# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=atk
VER=1.22.0
REV=2
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

DEPS=`latest --arch=${ARCH} glib`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`

for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have." Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libintl now. (The proxy-libintl libintl
# wrapper.) (Although Pango as such doesn't use any functions from
# libintl, the glib pc file insists on specifying -lintl on its Libs
# line, so libtool needs to find libintl.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

patch -p0 <<\EOF &&
--- ../1.22.0/atk/atkobject.c	2007-12-17 18:36:19.000000000 +0200
+++ atk/atkobject.c	2008-09-13 22:36:58.624625000 +0300
@@ -235,11 +235,22 @@
 
 #ifdef G_OS_WIN32
 
-#undef ATK_LOCALEDIR
+static HMODULE atk_dll;
 
-#define ATK_LOCALEDIR get_atk_locale_dir()
+BOOL WINAPI
+DllMain (HINSTANCE hinstDLL,
+	 DWORD     fdwReason,
+	 LPVOID    lpvReserved)
+{
+  switch (fdwReason)
+    {
+    case DLL_PROCESS_ATTACH:
+      atk_dll = (HMODULE) hinstDLL;
+      break;
+    }
 
-G_WIN32_DLLMAIN_FOR_DLL_NAME(static, dll_name)
+  return TRUE;
+}
 
 static const char *
 get_atk_locale_dir (void)
@@ -248,16 +259,35 @@
 
   if (!atk_localedir)
     {
-      gchar *temp;
-
-      temp = g_win32_get_package_installation_subdirectory
-        (GETTEXT_PACKAGE, dll_name, "lib\\locale");
+      const gchar *p;
+      gchar *root, *temp;
+      
+      /* ATK_LOCALEDIR might end in either /lib/locale or
+       * /share/locale. Scan for that slash.
+       */
+      p = ATK_LOCALEDIR + strlen (ATK_LOCALEDIR);
+      while (*--p != '/')
+	;
+      while (*--p != '/')
+	;
+
+      root = g_win32_get_package_installation_directory_of_module (atk_dll);
+      temp = g_build_filename (root, p, NULL);
+      g_free (root);
+
+      /* atk_localedir is passed to bindtextdomain() which isn't
+       * UTF-8-aware.
+       */
       atk_localedir = g_win32_locale_filename_from_utf8 (temp);
       g_free (temp);
     }
   return atk_localedir;
 }
 
+#undef ATK_LOCALEDIR
+
+#define ATK_LOCALEDIR get_atk_locale_dir()
+
 #endif
 
 static void
--- atk-zip.sh.in	(revision 1277)
+++ atk-zip.sh.in	(working copy)
@@ -15,7 +15,7 @@
 $DLLDIR/libatk-@ATK_API_VERSION@-@LT_CURRENT_MINUS_AGE@.dll
 EOF
 
-zip $ZIP lib/locale/*/LC_MESSAGES/atk10.mo
+zip $ZIP share/locale/*/LC_MESSAGES/atk10.mo
 
 rm $DEVZIP
 zip -r $DEVZIP -@ <<EOF
EOF

CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include" LDFLAGS="-L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base" CFLAGS=-O2 ./configure --disable-gtk-doc --disable-static --prefix=c:/devel/target/$HEX

libtoolcacheize
(cd atk; make atkmarshal.h atkmarshal.c) &&
PATH=/devel/target/$HEX/bin:.libs:$PATH make install &&

./atk-zip.sh &&

mv /tmp/atk-$VER.zip /tmp/$RUNZIP &&
mv /tmp/atk-dev-$VER.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
