/* rygel-transcoder.c generated by valac 0.20.1.2-ca5c2, the Vala compiler
 * generated from rygel-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	RygelDataSource* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, RygelDataSource* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelTranscoderPrivate {
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _extension;
};


static gpointer rygel_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_MIME_TYPE,
	RYGEL_TRANSCODER_DLNA_PROFILE,
	RYGEL_TRANSCODER_EXTENSION
};
RygelDataSource* rygel_transcoder_create_source (RygelTranscoder* self, RygelMediaItem* item, RygelDataSource* src, GError** error);
static RygelDataSource* rygel_transcoder_real_create_source (RygelTranscoder* self, RygelMediaItem* item, RygelDataSource* src, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static GUPnPDIDLLiteResource* rygel_transcoder_real_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
gboolean rygel_transcoder_mime_type_is_a (RygelTranscoder* self, const gchar* mime_type1, const gchar* mime_type2);
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);
const gchar* rygel_media_item_get_dlna_profile (RygelMediaItem* self);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
glong rygel_audio_item_get_duration (RygelAudioItem* self);
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
static guint rygel_transcoder_real_get_distance (RygelTranscoder* self, RygelMediaItem* item);
RygelTranscoder* rygel_transcoder_construct (GType object_type);
static void rygel_transcoder_set_mime_type (RygelTranscoder* self, const gchar* value);
static void rygel_transcoder_set_dlna_profile (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Creates a transcoding source.
     *
     * The provided original #RygelDataSource will have been implemented by the
     * same media engine that provided the #RygelTranscoder,
     * allowing the #RygelTranscoder to access specific resources of the
     * underlying multimedia backend used by the media engine.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
static RygelDataSource* rygel_transcoder_real_create_source (RygelTranscoder* self, RygelMediaItem* item, RygelDataSource* src, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `rygel_transcoder_create_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelDataSource* rygel_transcoder_create_source (RygelTranscoder* self, RygelMediaItem* item, RygelDataSource* src, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODER_GET_CLASS (self)->create_source (self, item, src, error);
}


/**
     * Derived classes should implement this function to fill a GUPnPDIDLLiteResource,
     * representing the transcoded content, with parameters specific to the transcoder,
     * such as bitrate or resolution. The GUPnPDIDLLiteResource should be instantiated
     * by calling this base class implementation, passing the provided didl_item, item
     * and manager parameters.
     *
     * @param didl_item The DIDLLite item for which to create the resource, by calling the base class implementation.
     * @param item The media item for which to create the DIDLiteResource, by calling the base class implementation.
     * @param manager The transcoder manager to pass to the base class implemenetation.
     * @return The new resource.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GUPnPDIDLLiteResource* rygel_transcoder_real_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelMediaItem* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_;
	RygelTranscodeManager* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* protocol;
	RygelTranscodeManager* _tmp13_;
	RygelMediaItem* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* uri;
	RygelMediaItem* _tmp17_;
	GUPnPDIDLLiteItem* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GUPnPDIDLLiteResource* _tmp21_ = NULL;
	GUPnPDIDLLiteResource* res;
	GUPnPDIDLLiteResource* _tmp22_;
	GUPnPDIDLLiteResource* _tmp23_;
	GUPnPProtocolInfo* _tmp24_;
	GUPnPProtocolInfo* _tmp25_;
	GUPnPProtocolInfo* _tmp26_;
	GUPnPProtocolInfo* protocol_info;
	GUPnPProtocolInfo* _tmp27_;
	const gchar* _tmp28_;
	GUPnPProtocolInfo* _tmp29_;
	const gchar* _tmp30_;
	GUPnPProtocolInfo* _tmp31_;
	GUPnPProtocolInfo* _tmp32_;
	gboolean _tmp33_ = FALSE;
	RygelMediaItem* _tmp34_;
	gboolean _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_tmp1_ = item;
	_tmp2_ = rygel_media_item_get_mime_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_mime_type;
	_tmp5_ = rygel_transcoder_mime_type_is_a (self, _tmp3_, _tmp4_);
	if (_tmp5_) {
		const gchar* _tmp6_;
		RygelMediaItem* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->priv->_dlna_profile;
		_tmp7_ = item;
		_tmp8_ = rygel_media_item_get_dlna_profile (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp9_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		result = NULL;
		return result;
	}
	_tmp11_ = manager;
	_tmp12_ = rygel_transcode_manager_get_protocol (_tmp11_);
	protocol = _tmp12_;
	_tmp13_ = manager;
	_tmp14_ = item;
	_tmp15_ = self->priv->_dlna_profile;
	_tmp16_ = rygel_transcode_manager_create_uri_for_item (_tmp13_, _tmp14_, -1, -1, _tmp15_, NULL);
	uri = _tmp16_;
	_tmp17_ = item;
	_tmp18_ = didl_item;
	_tmp19_ = uri;
	_tmp20_ = protocol;
	_tmp21_ = rygel_media_object_add_resource ((RygelMediaObject*) _tmp17_, (GUPnPDIDLLiteObject*) _tmp18_, _tmp19_, _tmp20_, NULL, &_inner_error_);
	res = _tmp21_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (uri);
		_g_free0 (protocol);
		return NULL;
	}
	_tmp22_ = res;
	gupnp_didl_lite_resource_set_size (_tmp22_, (glong) (-1));
	_tmp23_ = res;
	_tmp24_ = gupnp_didl_lite_resource_get_protocol_info (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	protocol_info = _tmp26_;
	_tmp27_ = protocol_info;
	_tmp28_ = self->priv->_mime_type;
	gupnp_protocol_info_set_mime_type (_tmp27_, _tmp28_);
	_tmp29_ = protocol_info;
	_tmp30_ = self->priv->_dlna_profile;
	gupnp_protocol_info_set_dlna_profile (_tmp29_, _tmp30_);
	_tmp31_ = protocol_info;
	gupnp_protocol_info_set_dlna_conversion (_tmp31_, GUPNP_DLNA_CONVERSION_TRANSCODED);
	_tmp32_ = protocol_info;
	gupnp_protocol_info_set_dlna_flags (_tmp32_, ((GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_DLNA_V15);
	_tmp34_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaItem* _tmp35_;
		glong _tmp36_;
		glong _tmp37_;
		_tmp35_ = item;
		_tmp36_ = rygel_audio_item_get_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp35_) : NULL);
		_tmp37_ = _tmp36_;
		_tmp33_ = _tmp37_ > ((glong) 0);
	} else {
		_tmp33_ = FALSE;
	}
	_tmp38_ = _tmp33_;
	if (_tmp38_) {
		GUPnPProtocolInfo* _tmp39_;
		_tmp39_ = protocol_info;
		gupnp_protocol_info_set_dlna_operation (_tmp39_, GUPNP_DLNA_OPERATION_TIMESEEK);
	} else {
		GUPnPProtocolInfo* _tmp40_;
		_tmp40_ = protocol_info;
		gupnp_protocol_info_set_dlna_operation (_tmp40_, GUPNP_DLNA_OPERATION_NONE);
	}
	result = res;
	_g_object_unref0 (protocol_info);
	_g_free0 (uri);
	_g_free0 (protocol);
	return result;
}


GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODER_GET_CLASS (self)->add_resource (self, didl_item, item, manager, error);
}


/**
     * Returns whether this trancoder can handle the specified DLNA profile.
     * This is determined by the #RygelTranscodeManager, which checks
     * the suitability of each #RygelTranscoder by calling
     * rygel_transcoder_get_distance() with each #RygelMediaItem,
     * choosing one DLNA profile for each transcoder to handle.
     *
     * @param target A DLNA profile name as obtained from rygel_media_item_get_dlna_profile().
     *
     * @return True if the transcoder can handle the specified DLNA profile.
     */
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	_tmp0_ = target;
	_tmp1_ = self->priv->_dlna_profile;
	result = g_strcmp0 (_tmp0_, _tmp1_) == 0;
	return result;
}


/**
     * Gets a numeric value that gives an gives an estimate of how hard
     * it would be for this transcoder to trancode @item to the target profile of this transcoder.
     *
     * @param item the media item to calculate the distance for
     *
     * @return      the distance from the @item, uint.MIN if providing such a
     *              value is impossible or uint.MAX if it doesn't make any
     *              sense to use this transcoder for @item
     */
static guint rygel_transcoder_real_get_distance (RygelTranscoder* self, RygelMediaItem* item) {
	g_critical ("Type `%s' does not implement abstract method `rygel_transcoder_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}


guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item) {
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_TRANSCODER_GET_CLASS (self)->get_distance (self, item);
}


gboolean rygel_transcoder_mime_type_is_a (RygelTranscoder* self, const gchar* mime_type1, const gchar* mime_type2) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* content_type1;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* content_type2;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type1 != NULL, FALSE);
	g_return_val_if_fail (mime_type2 != NULL, FALSE);
	_tmp0_ = mime_type1;
	_tmp1_ = g_content_type_get_mime_type (_tmp0_);
	content_type1 = _tmp1_;
	_tmp2_ = mime_type2;
	_tmp3_ = g_content_type_get_mime_type (_tmp2_);
	content_type2 = _tmp3_;
	_tmp4_ = g_content_type_is_a (content_type1, content_type2);
	result = _tmp4_;
	_g_free0 (content_type2);
	_g_free0 (content_type1);
	return result;
}


RygelTranscoder* rygel_transcoder_construct (GType object_type) {
	RygelTranscoder * self = NULL;
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
	return self;
}


const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}


static void rygel_transcoder_set_mime_type (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}


static void rygel_transcoder_set_dlna_profile (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dlna_profile);
	self->priv->_dlna_profile = _tmp1_;
	g_object_notify ((GObject *) self, "dlna-profile");
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}


static void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp1_;
	g_object_notify ((GObject *) self, "extension");
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_transcoder_real_create_source;
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_transcoder_real_get_distance;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_g_free0 (self->priv->_extension);
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
}


/**
 * The base Transcoder class. Each implementation derives from it and must
 * implement create_source() and get_distance().
 *
 * Transcoders are obtained from rygel_media_engine_get_transcoders() and
 * are only expected to support the derived #RygelDataSource types provided
 * by the same media engine.
 */
GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	switch (property_id) {
		case RYGEL_TRANSCODER_MIME_TYPE:
		g_value_set_string (value, rygel_transcoder_get_mime_type (self));
		break;
		case RYGEL_TRANSCODER_DLNA_PROFILE:
		g_value_set_string (value, rygel_transcoder_get_dlna_profile (self));
		break;
		case RYGEL_TRANSCODER_EXTENSION:
		g_value_set_string (value, rygel_transcoder_get_extension (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	switch (property_id) {
		case RYGEL_TRANSCODER_MIME_TYPE:
		rygel_transcoder_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_TRANSCODER_DLNA_PROFILE:
		rygel_transcoder_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_TRANSCODER_EXTENSION:
		rygel_transcoder_set_extension (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



