/* rygel-media-export-item-factory.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <gst/gst.h>
#include <gst/tag/gsttagdemux.h>
#include <gst/tag/gsttagmux.h>
#include <gst/tag/tag.h>
#include <gst/tag/xmpwriter.h>


#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define __vala_GstSample_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstSample_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define __vala_GstStructure_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstStructure_free (var), NULL)))

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
static void _vala_GstSample_free (GstSample* self);
static GstStructure* _vala_GstStructure_copy (GstStructure* self);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);
static void _vala_GstStructure_free (GstStructure* self);
static GDate* _g_date_dup (GDate* self);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaItem* result = NULL;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* title;
	RygelMediaItem* item = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* mime;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	RygelMediaItem* _tmp39_;
	const gchar* _tmp40_;
	RygelMediaItem* _tmp41_;
	GFileInfo* _tmp42_;
	gint64 _tmp43_ = 0LL;
	RygelMediaItem* _tmp44_;
	GFileInfo* _tmp45_;
	guint64 _tmp46_ = 0ULL;
	RygelMediaItem* _tmp47_;
	GFile* _tmp48_;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
	mime = _tmp5_;
	_tmp6_ = mime;
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
	if (_tmp7_) {
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		RygelMediaContainer* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaExportVideoItem* _tmp13_;
		_tmp8_ = file;
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = parent;
		_tmp12_ = title;
		_tmp13_ = rygel_media_export_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp13_;
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = mime;
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
		if (_tmp15_) {
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			RygelMediaContainer* _tmp19_;
			const gchar* _tmp20_;
			RygelMediaExportPhotoItem* _tmp21_;
			_tmp16_ = file;
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = parent;
			_tmp20_ = title;
			_tmp21_ = rygel_media_export_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp21_;
			_g_free0 (_tmp18_);
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp26_;
			_tmp23_ = mime;
			_tmp24_ = g_str_has_prefix (_tmp23_, "audio/");
			if (_tmp24_) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp25_;
				_tmp25_ = mime;
				_tmp22_ = g_strcmp0 (_tmp25_, "application/ogg") == 0;
			}
			_tmp26_ = _tmp22_;
			if (_tmp26_) {
				GFile* _tmp27_;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				RygelMediaContainer* _tmp30_;
				const gchar* _tmp31_;
				RygelMediaExportMusicItem* _tmp32_;
				_tmp27_ = file;
				_tmp28_ = rygel_media_export_media_cache_get_id (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = parent;
				_tmp31_ = title;
				_tmp32_ = rygel_media_export_music_item_new (_tmp29_, _tmp30_, _tmp31_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp32_;
				_g_free0 (_tmp29_);
			} else {
				GFile* _tmp33_;
				RygelMediaContainer* _tmp34_;
				const gchar* _tmp35_;
				RygelMediaItem* _tmp36_ = NULL;
				RygelMediaItem* _tmp37_;
				gchar* _tmp38_;
				_tmp33_ = file;
				_tmp34_ = parent;
				_tmp35_ = title;
				_tmp36_ = rygel_media_export_item_factory_create_playlist_item (_tmp33_, _tmp34_, _tmp35_);
				_g_object_unref0 (item);
				item = _tmp36_;
				_tmp37_ = item;
				if (_tmp37_ == NULL) {
					result = NULL;
					_g_free0 (mime);
					_g_object_unref0 (item);
					_g_free0 (title);
					return result;
				}
				_tmp38_ = g_strdup ("text/xml");
				_g_free0 (mime);
				mime = _tmp38_;
			}
		}
	}
	_tmp39_ = item;
	_tmp40_ = mime;
	rygel_media_item_set_mime_type (_tmp39_, _tmp40_);
	_tmp41_ = item;
	_tmp42_ = info;
	_tmp43_ = g_file_info_get_size (_tmp42_);
	rygel_media_item_set_size (_tmp41_, (gint64) _tmp43_);
	_tmp44_ = item;
	_tmp45_ = info;
	_tmp46_ = g_file_info_get_attribute_uint64 (_tmp45_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp44_, _tmp46_);
	_tmp47_ = item;
	_tmp48_ = file;
	_tmp49_ = g_file_get_uri (_tmp48_);
	_tmp50_ = _tmp49_;
	rygel_media_item_add_uri (_tmp47_, _tmp50_);
	_g_free0 (_tmp50_);
	result = item;
	_g_free0 (mime);
	_g_free0 (title);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaItem* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (fallback_title != NULL, NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		GFile* _tmp0_;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gint i;
		guint8* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		guint8 _tmp16_;
		guint8* _tmp17_;
		gint _tmp17__length1;
		GUPnPMediaCollection* _tmp18_;
		GUPnPMediaCollection* didl_s;
		GUPnPMediaCollection* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* author;
		GUPnPMediaCollection* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* title;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		gboolean _tmp31_;
		gboolean _tmp35_;
		const gchar* _tmp36_;
		GFile* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		RygelMediaContainer* _tmp42_;
		const gchar* _tmp43_;
		RygelMediaExportPlaylistItem* _tmp44_;
		RygelMediaExportPlaylistItem* _tmp45_;
		RygelMediaExportPlaylistItem* item;
		const gchar* _tmp46_;
		RygelMediaExportPlaylistItem* _tmp49_;
		_tmp0_ = file;
		_tmp3_ = g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp1_;
		contents_length1 = _tmp2_;
		_contents_size_ = contents_length1;
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			contents = (g_free (contents), NULL);
			goto __catch65_g_error;
		}
		if (!_tmp4_) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		i = 0;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_;
			gint _tmp6__length1;
			gint _tmp7_;
			guint8 _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp12_;
			gint _tmp13_;
			_tmp6_ = contents;
			_tmp6__length1 = contents_length1;
			_tmp7_ = i;
			_tmp8_ = _tmp6_[_tmp7_];
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
			if (_tmp9_) {
				gint _tmp10_;
				guint8* _tmp11_;
				gint _tmp11__length1;
				_tmp10_ = i;
				_tmp11_ = contents;
				_tmp11__length1 = contents_length1;
				_tmp5_ = _tmp10_ < _tmp11__length1;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp12_ = _tmp5_;
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
		}
		_tmp14_ = contents;
		_tmp14__length1 = contents_length1;
		_tmp15_ = i;
		_tmp16_ = _tmp14_[_tmp15_];
		if (_tmp16_ != ((guint8) '<')) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp17_ = contents;
		_tmp17__length1 = contents_length1;
		_tmp18_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp17_);
		didl_s = _tmp18_;
		_tmp19_ = didl_s;
		_tmp20_ = gupnp_media_collection_get_author (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup (_tmp21_);
		author = _tmp22_;
		_tmp23_ = didl_s;
		_tmp24_ = gupnp_media_collection_get_title (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup (_tmp25_);
		title = _tmp26_;
		_tmp29_ = author;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			_tmp30_ = title;
			_tmp28_ = _tmp30_ == NULL;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp31_ = _tmp28_;
		if (_tmp31_) {
			GUPnPMediaCollection* _tmp32_;
			GList* _tmp33_ = NULL;
			GList* _tmp34_;
			_tmp32_ = didl_s;
			_tmp33_ = gupnp_media_collection_get_items (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp27_ = _tmp34_ == NULL;
			__g_list_free__g_object_unref0_0 (_tmp34_);
		} else {
			_tmp27_ = FALSE;
		}
		_tmp35_ = _tmp27_;
		if (_tmp35_) {
			result = NULL;
			_g_free0 (title);
			_g_free0 (author);
			_g_object_unref0 (didl_s);
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp36_ = title;
		if (_tmp36_ == NULL) {
			const gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = fallback_title;
			_tmp38_ = g_strdup (_tmp37_);
			_g_free0 (title);
			title = _tmp38_;
		}
		_tmp39_ = file;
		_tmp40_ = rygel_media_export_media_cache_get_id (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = parent;
		_tmp43_ = title;
		_tmp44_ = rygel_media_export_playlist_item_new (_tmp41_, _tmp42_, _tmp43_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp41_);
		item = _tmp45_;
		_tmp46_ = author;
		if (_tmp46_ != NULL) {
			RygelMediaExportPlaylistItem* _tmp47_;
			const gchar* _tmp48_;
			_tmp47_ = item;
			_tmp48_ = author;
			rygel_playlist_item_set_creator ((RygelPlaylistItem*) _tmp47_, _tmp48_);
		}
		_tmp49_ = item;
		rygel_media_item_set_dlna_profile ((RygelMediaItem*) _tmp49_, "DIDL_S");
		result = (RygelMediaItem*) item;
		_g_free0 (title);
		_g_free0 (author);
		_g_object_unref0 (didl_s);
		contents = (g_free (contents), NULL);
		return result;
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally65:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GstDiscovererInfo* _tmp2_;
	GList* _tmp3_ = NULL;
	GstDiscovererInfo* _tmp4_;
	GList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GList* _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp13_ = FALSE;
	GList* _tmp14_;
	gboolean _tmp18_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = gst_discoverer_info_get_audio_streams (_tmp2_);
	__g_list_free__g_object_unref0_0 (audio_streams);
	audio_streams = (GList*) _tmp3_;
	_tmp4_ = info;
	_tmp5_ = gst_discoverer_info_get_video_streams (_tmp4_);
	__g_list_free__g_object_unref0_0 (video_streams);
	video_streams = (GList*) _tmp5_;
	_tmp7_ = audio_streams;
	if (_tmp7_ == NULL) {
		GList* _tmp8_;
		_tmp8_ = video_streams;
		_tmp6_ = _tmp8_ == NULL;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		GFile* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp10_ = file;
		_tmp11_ = g_file_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp12_);
		_g_free0 (_tmp12_);
		result = NULL;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	}
	_tmp14_ = audio_streams;
	if (_tmp14_ == NULL) {
		GList* _tmp15_;
		gconstpointer _tmp16_;
		gboolean _tmp17_ = FALSE;
		_tmp15_ = video_streams;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp16_);
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp18_ = _tmp13_;
	if (_tmp18_) {
		const gchar* _tmp19_;
		RygelMediaContainer* _tmp20_;
		RygelMediaExportPhotoItem* _tmp21_;
		RygelMediaItem* _tmp22_;
		GFile* _tmp23_;
		GstDiscovererInfo* _tmp24_;
		GUPnPDLNAProfile* _tmp25_;
		GList* _tmp26_;
		gconstpointer _tmp27_;
		GFileInfo* _tmp28_;
		RygelMediaItem* _tmp29_ = NULL;
		_tmp19_ = id;
		_tmp20_ = parent;
		_tmp21_ = rygel_media_export_photo_item_new (_tmp19_, _tmp20_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp21_;
		_tmp22_ = item;
		_tmp23_ = file;
		_tmp24_ = info;
		_tmp25_ = profile;
		_tmp26_ = video_streams;
		_tmp27_ = _tmp26_->data;
		_tmp28_ = file_info;
		_tmp29_ = rygel_media_export_item_factory_fill_photo_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM) ? ((RygelMediaExportPhotoItem*) _tmp22_) : NULL, _tmp23_, _tmp24_, _tmp25_, (GstDiscovererVideoInfo*) _tmp27_, _tmp28_);
		result = _tmp29_;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		GList* _tmp30_;
		_tmp30_ = video_streams;
		if (_tmp30_ != NULL) {
			const gchar* _tmp31_;
			RygelMediaContainer* _tmp32_;
			RygelMediaExportVideoItem* _tmp33_;
			GstDiscovererAudioInfo* _tmp34_;
			GstDiscovererAudioInfo* audio_info;
			GList* _tmp35_;
			RygelMediaItem* _tmp39_;
			GFile* _tmp40_;
			GstDiscovererInfo* _tmp41_;
			GUPnPDLNAProfile* _tmp42_;
			GList* _tmp43_;
			gconstpointer _tmp44_;
			GstDiscovererAudioInfo* _tmp45_;
			GFileInfo* _tmp46_;
			RygelMediaItem* _tmp47_ = NULL;
			_tmp31_ = id;
			_tmp32_ = parent;
			_tmp33_ = rygel_media_export_video_item_new (_tmp31_, _tmp32_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp33_;
			_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (NULL, gst_discoverer_audio_info_get_type ()) ? ((GstDiscovererAudioInfo*) NULL) : NULL);
			audio_info = _tmp34_;
			_tmp35_ = audio_streams;
			if (_tmp35_ != NULL) {
				GList* _tmp36_;
				gconstpointer _tmp37_;
				GstDiscovererAudioInfo* _tmp38_;
				_tmp36_ = audio_streams;
				_tmp37_ = _tmp36_->data;
				_tmp38_ = _g_object_ref0 ((GstDiscovererAudioInfo*) _tmp37_);
				_g_object_unref0 (audio_info);
				audio_info = _tmp38_;
			}
			_tmp39_ = item;
			_tmp40_ = file;
			_tmp41_ = info;
			_tmp42_ = profile;
			_tmp43_ = video_streams;
			_tmp44_ = _tmp43_->data;
			_tmp45_ = audio_info;
			_tmp46_ = file_info;
			_tmp47_ = rygel_media_export_item_factory_fill_video_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp39_) : NULL, _tmp40_, _tmp41_, _tmp42_, (GstDiscovererVideoInfo*) _tmp44_, _tmp45_, _tmp46_);
			result = _tmp47_;
			_g_object_unref0 (audio_info);
			__g_list_free__g_object_unref0_0 (video_streams);
			__g_list_free__g_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			GList* _tmp48_;
			_tmp48_ = audio_streams;
			if (_tmp48_ != NULL) {
				const gchar* _tmp49_;
				RygelMediaContainer* _tmp50_;
				RygelMediaExportMusicItem* _tmp51_;
				RygelMediaItem* _tmp52_;
				GFile* _tmp53_;
				GstDiscovererInfo* _tmp54_;
				GUPnPDLNAProfile* _tmp55_;
				GList* _tmp56_;
				gconstpointer _tmp57_;
				GFileInfo* _tmp58_;
				RygelMediaItem* _tmp59_ = NULL;
				_tmp49_ = id;
				_tmp50_ = parent;
				_tmp51_ = rygel_media_export_music_item_new (_tmp49_, _tmp50_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp51_;
				_tmp52_ = item;
				_tmp53_ = file;
				_tmp54_ = info;
				_tmp55_ = profile;
				_tmp56_ = audio_streams;
				_tmp57_ = _tmp56_->data;
				_tmp58_ = file_info;
				_tmp59_ = rygel_media_export_item_factory_fill_music_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp52_) : NULL, _tmp53_, _tmp54_, _tmp55_, (GstDiscovererAudioInfo*) _tmp57_, _tmp58_);
				result = _tmp59_;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__g_object_unref0_0 (video_streams);
	__g_list_free__g_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info) {
	GstDiscovererInfo* _tmp0_;
	GstClockTime _tmp1_ = 0ULL;
	GstDiscovererAudioInfo* _tmp6_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
	if (_tmp1_ > ((GstClockTime) 0)) {
		RygelAudioItem* _tmp2_;
		GstDiscovererInfo* _tmp3_;
		GstClockTime _tmp4_ = 0ULL;
		_tmp2_ = item;
		_tmp3_ = info;
		_tmp4_ = gst_discoverer_info_get_duration (_tmp3_);
		rygel_audio_item_set_duration (_tmp2_, (glong) (_tmp4_ / GST_SECOND));
	} else {
		RygelAudioItem* _tmp5_;
		_tmp5_ = item;
		rygel_audio_item_set_duration (_tmp5_, (glong) (-1));
	}
	_tmp6_ = audio_info;
	if (_tmp6_ != NULL) {
		GstDiscovererAudioInfo* _tmp7_;
		GstTagList* _tmp8_ = NULL;
		RygelAudioItem* _tmp14_;
		GstDiscovererAudioInfo* _tmp15_;
		guint _tmp16_ = 0U;
		RygelAudioItem* _tmp17_;
		GstDiscovererAudioInfo* _tmp18_;
		guint _tmp19_ = 0U;
		_tmp7_ = audio_info;
		_tmp8_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp7_);
		if (_tmp8_ != NULL) {
			guint tmp = 0U;
			GstDiscovererAudioInfo* _tmp9_;
			GstTagList* _tmp10_ = NULL;
			guint _tmp11_ = 0U;
			RygelAudioItem* _tmp12_;
			guint _tmp13_;
			_tmp9_ = audio_info;
			_tmp10_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp9_);
			gst_tag_list_get_uint (_tmp10_, GST_TAG_BITRATE, &_tmp11_);
			tmp = _tmp11_;
			_tmp12_ = item;
			_tmp13_ = tmp;
			rygel_audio_item_set_bitrate (_tmp12_, ((gint) _tmp13_) / 8);
		}
		_tmp14_ = item;
		_tmp15_ = audio_info;
		_tmp16_ = gst_discoverer_audio_info_get_channels (_tmp15_);
		rygel_audio_item_set_channels (_tmp14_, (gint) _tmp16_);
		_tmp17_ = item;
		_tmp18_ = audio_info;
		_tmp19_ = gst_discoverer_audio_info_get_sample_rate (_tmp18_);
		rygel_audio_item_set_sample_freq (_tmp17_, (gint) _tmp19_);
	}
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportVideoItem* _tmp0_;
	GstDiscovererInfo* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMediaExportVideoItem* _tmp3_;
	GFile* _tmp4_;
	GstDiscovererInfo* _tmp5_;
	GUPnPDLNAProfile* _tmp6_;
	GFileInfo* _tmp7_;
	RygelMediaExportVideoItem* _tmp8_;
	GstDiscovererVideoInfo* _tmp9_;
	guint _tmp10_ = 0U;
	RygelMediaExportVideoItem* _tmp11_;
	GstDiscovererVideoInfo* _tmp12_;
	guint _tmp13_ = 0U;
	GstDiscovererVideoInfo* _tmp14_;
	guint _tmp15_ = 0U;
	gint color_depth;
	gint _tmp16_ = 0;
	gint _tmp17_;
	RygelMediaExportVideoItem* _tmp19_;
	gint _tmp20_;
	RygelMediaExportVideoItem* _tmp21_;
	RygelMediaItem* _tmp22_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_width (_tmp9_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = item;
	_tmp12_ = video_info;
	_tmp13_ = gst_discoverer_video_info_get_height (_tmp12_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp11_, (gint) _tmp13_);
	_tmp14_ = video_info;
	_tmp15_ = gst_discoverer_video_info_get_depth (_tmp14_);
	color_depth = (gint) _tmp15_;
	_tmp17_ = color_depth;
	if (_tmp17_ == 0) {
		_tmp16_ = -1;
	} else {
		gint _tmp18_;
		_tmp18_ = color_depth;
		_tmp16_ = _tmp18_;
	}
	_tmp19_ = item;
	_tmp20_ = _tmp16_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp19_, _tmp20_);
	_tmp21_ = item;
	_tmp22_ = _g_object_ref0 ((RygelMediaItem*) _tmp21_);
	result = _tmp22_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportPhotoItem* _tmp0_;
	GFile* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GUPnPDLNAProfile* _tmp3_;
	GFileInfo* _tmp4_;
	RygelMediaExportPhotoItem* _tmp5_;
	GstDiscovererVideoInfo* _tmp6_;
	guint _tmp7_ = 0U;
	RygelMediaExportPhotoItem* _tmp8_;
	GstDiscovererVideoInfo* _tmp9_;
	guint _tmp10_ = 0U;
	GstDiscovererVideoInfo* _tmp11_;
	guint _tmp12_ = 0U;
	gint color_depth;
	gint _tmp13_ = 0;
	gint _tmp14_;
	RygelMediaExportPhotoItem* _tmp16_;
	gint _tmp17_;
	RygelMediaExportPhotoItem* _tmp18_;
	RygelMediaItem* _tmp19_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = file;
	_tmp2_ = info;
	_tmp3_ = profile;
	_tmp4_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = item;
	_tmp6_ = video_info;
	_tmp7_ = gst_discoverer_video_info_get_width (_tmp6_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp5_, (gint) _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_height (_tmp9_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = video_info;
	_tmp12_ = gst_discoverer_video_info_get_depth (_tmp11_);
	color_depth = (gint) _tmp12_;
	_tmp14_ = color_depth;
	if (_tmp14_ == 0) {
		_tmp13_ = -1;
	} else {
		gint _tmp15_;
		_tmp15_ = color_depth;
		_tmp13_ = _tmp15_;
	}
	_tmp16_ = item;
	_tmp17_ = _tmp13_;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp16_, _tmp17_);
	_tmp18_ = item;
	_tmp19_ = _g_object_ref0 ((RygelMediaItem*) _tmp18_);
	result = _tmp19_;
	return result;
}


static void _vala_GstSample_free (GstSample* self) {
	g_boxed_free (gst_sample_get_type (), self);
}


static GstStructure* _vala_GstStructure_copy (GstStructure* self) {
	return g_boxed_copy (gst_structure_get_type (), self);
}


static gpointer __vala_GstStructure_copy0 (gpointer self) {
	return self ? _vala_GstStructure_copy (self) : NULL;
}


static void _vala_GstStructure_free (GstStructure* self) {
	g_boxed_free (gst_structure_get_type (), self);
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportMusicItem* _tmp0_;
	GstDiscovererInfo* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMediaExportMusicItem* _tmp3_;
	GFile* _tmp4_;
	GstDiscovererInfo* _tmp5_;
	GUPnPDLNAProfile* _tmp6_;
	GFileInfo* _tmp7_;
	GstDiscovererAudioInfo* _tmp8_;
	gchar* artist = NULL;
	GstDiscovererInfo* _tmp11_;
	GstTagList* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	RygelMediaExportMusicItem* _tmp14_;
	const gchar* _tmp15_;
	gchar* album = NULL;
	GstDiscovererInfo* _tmp16_;
	GstTagList* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	RygelMediaExportMusicItem* _tmp19_;
	const gchar* _tmp20_;
	gchar* genre = NULL;
	GstDiscovererInfo* _tmp21_;
	GstTagList* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	RygelMediaExportMusicItem* _tmp24_;
	const gchar* _tmp25_;
	guint tmp = 0U;
	GstDiscovererInfo* _tmp26_;
	GstTagList* _tmp27_ = NULL;
	guint _tmp28_ = 0U;
	RygelMediaExportMusicItem* _tmp29_;
	guint _tmp30_;
	GstDiscovererInfo* _tmp31_;
	GstTagList* _tmp32_ = NULL;
	guint _tmp33_ = 0U;
	RygelMediaExportMusicItem* _tmp34_;
	guint _tmp35_;
	GstDiscovererAudioInfo* _tmp36_;
	GstTagList* _tmp37_ = NULL;
	GstSample* sample = NULL;
	GstDiscovererAudioInfo* _tmp40_;
	GstTagList* _tmp41_ = NULL;
	GstSample* _tmp42_ = NULL;
	GstSample* _tmp43_;
	GstSample* _tmp46_;
	GstCaps* _tmp47_ = NULL;
	GstStructure* _tmp48_ = NULL;
	GstStructure* _tmp49_;
	GstStructure* structure;
	gint image_type = 0;
	GstStructure* _tmp50_;
	gint _tmp51_ = 0;
	gint _tmp52_;
	RygelMediaExportMusicItem* _tmp62_;
	RygelMediaItem* _tmp63_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = audio_info;
	if (_tmp8_ == NULL) {
		RygelMediaExportMusicItem* _tmp9_;
		RygelMediaItem* _tmp10_;
		_tmp9_ = item;
		_tmp10_ = _g_object_ref0 ((RygelMediaItem*) _tmp9_);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = info;
	_tmp12_ = gst_discoverer_info_get_tags (_tmp11_);
	gst_tag_list_get_string (_tmp12_, GST_TAG_ARTIST, &_tmp13_);
	_g_free0 (artist);
	artist = _tmp13_;
	_tmp14_ = item;
	_tmp15_ = artist;
	rygel_music_item_set_artist ((RygelMusicItem*) _tmp14_, _tmp15_);
	_tmp16_ = info;
	_tmp17_ = gst_discoverer_info_get_tags (_tmp16_);
	gst_tag_list_get_string (_tmp17_, GST_TAG_ALBUM, &_tmp18_);
	_g_free0 (album);
	album = _tmp18_;
	_tmp19_ = item;
	_tmp20_ = album;
	rygel_music_item_set_album ((RygelMusicItem*) _tmp19_, _tmp20_);
	_tmp21_ = info;
	_tmp22_ = gst_discoverer_info_get_tags (_tmp21_);
	gst_tag_list_get_string (_tmp22_, GST_TAG_GENRE, &_tmp23_);
	_g_free0 (genre);
	genre = _tmp23_;
	_tmp24_ = item;
	_tmp25_ = genre;
	rygel_music_item_set_genre ((RygelMusicItem*) _tmp24_, _tmp25_);
	_tmp26_ = info;
	_tmp27_ = gst_discoverer_info_get_tags (_tmp26_);
	gst_tag_list_get_uint (_tmp27_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp28_);
	tmp = _tmp28_;
	_tmp29_ = item;
	_tmp30_ = tmp;
	_tmp29_->disc = (gint) _tmp30_;
	_tmp31_ = info;
	_tmp32_ = gst_discoverer_info_get_tags (_tmp31_);
	gst_tag_list_get_uint (_tmp32_, GST_TAG_TRACK_NUMBER, &_tmp33_);
	tmp = _tmp33_;
	_tmp34_ = item;
	_tmp35_ = tmp;
	rygel_music_item_set_track_number ((RygelMusicItem*) _tmp34_, (gint) _tmp35_);
	_tmp36_ = audio_info;
	_tmp37_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp36_);
	if (_tmp37_ == NULL) {
		RygelMediaExportMusicItem* _tmp38_;
		RygelMediaItem* _tmp39_;
		_tmp38_ = item;
		_tmp39_ = _g_object_ref0 ((RygelMediaItem*) _tmp38_);
		result = _tmp39_;
		_g_free0 (genre);
		_g_free0 (album);
		_g_free0 (artist);
		return result;
	}
	_tmp40_ = audio_info;
	_tmp41_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp40_);
	gst_tag_list_get_sample (_tmp41_, GST_TAG_IMAGE, &_tmp42_);
	__vala_GstSample_free0 (sample);
	sample = _tmp42_;
	_tmp43_ = sample;
	if (_tmp43_ == NULL) {
		RygelMediaExportMusicItem* _tmp44_;
		RygelMediaItem* _tmp45_;
		_tmp44_ = item;
		_tmp45_ = _g_object_ref0 ((RygelMediaItem*) _tmp44_);
		result = _tmp45_;
		__vala_GstSample_free0 (sample);
		_g_free0 (genre);
		_g_free0 (album);
		_g_free0 (artist);
		return result;
	}
	_tmp46_ = sample;
	_tmp47_ = gst_sample_get_caps (_tmp46_);
	_tmp48_ = gst_caps_get_structure (_tmp47_, (guint) 0);
	_tmp49_ = __vala_GstStructure_copy0 (_tmp48_);
	structure = _tmp49_;
	_tmp50_ = structure;
	gst_structure_get_enum (_tmp50_, "image-type", gst_tag_image_type_get_type (), &_tmp51_);
	image_type = _tmp51_;
	_tmp52_ = image_type;
	switch (_tmp52_) {
		case GST_TAG_IMAGE_TYPE_UNDEFINED:
		case GST_TAG_IMAGE_TYPE_FRONT_COVER:
		{
			RygelMediaArtStore* _tmp53_ = NULL;
			RygelMediaArtStore* store;
			RygelMediaArtStore* _tmp54_;
			RygelMediaExportMusicItem* _tmp55_;
			GFile* _tmp56_ = NULL;
			GFile* thumb;
			_tmp53_ = rygel_media_art_store_get_default ();
			store = _tmp53_;
			_tmp54_ = store;
			_tmp55_ = item;
			_tmp56_ = rygel_media_art_store_get_media_art_file (_tmp54_, "album", (RygelMusicItem*) _tmp55_, TRUE);
			thumb = _tmp56_;
			{
				RygelMediaExportJPEGWriter* _tmp57_;
				RygelMediaExportJPEGWriter* writer;
				RygelMediaExportJPEGWriter* _tmp58_;
				GstSample* _tmp59_;
				GstBuffer* _tmp60_ = NULL;
				GFile* _tmp61_;
				_tmp57_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
				writer = _tmp57_;
				if (_inner_error_ != NULL) {
					goto __catch66_g_error;
				}
				_tmp58_ = writer;
				_tmp59_ = sample;
				_tmp60_ = gst_sample_get_buffer (_tmp59_);
				_tmp61_ = thumb;
				rygel_media_export_jpeg_writer_write (_tmp58_, _tmp60_, _tmp61_);
				_g_object_unref0 (writer);
			}
			goto __finally66;
			__catch66_g_error:
			{
				GError* _error_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (_error_);
			}
			__finally66:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (thumb);
				_g_object_unref0 (store);
				__vala_GstStructure_free0 (structure);
				__vala_GstSample_free0 (sample);
				_g_free0 (genre);
				_g_free0 (album);
				_g_free0 (artist);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (thumb);
			_g_object_unref0 (store);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp62_ = item;
	_tmp63_ = _g_object_ref0 ((RygelMediaItem*) _tmp62_);
	result = _tmp63_;
	__vala_GstStructure_free0 (structure);
	__vala_GstSample_free0 (sample);
	_g_free0 (genre);
	_g_free0 (album);
	_g_free0 (artist);
	return result;
}


static GDate* _g_date_dup (GDate* self) {
	GDate* dup;
	dup = g_new0 (GDate, 1);
	memcpy (dup, self, sizeof (GDate));
	return dup;
}


static gpointer __g_date_dup0 (gpointer self) {
	return self ? _g_date_dup (self) : NULL;
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	gchar* title;
	gboolean _tmp0_ = FALSE;
	GstDiscovererInfo* _tmp1_;
	GstTagList* _tmp2_ = NULL;
	gboolean _tmp7_;
	RygelMediaItem* _tmp11_;
	const gchar* _tmp12_;
	GstDiscovererInfo* _tmp13_;
	GstTagList* _tmp14_ = NULL;
	GFileInfo* _tmp30_;
	guint64 _tmp31_ = 0ULL;
	guint64 mtime;
	RygelMediaItem* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	RygelMediaItem* _tmp40_;
	GFileInfo* _tmp41_;
	gint64 _tmp42_ = 0LL;
	RygelMediaItem* _tmp43_;
	guint64 _tmp44_;
	gboolean _tmp45_ = FALSE;
	GUPnPDLNAProfile* _tmp46_;
	gboolean _tmp50_;
	RygelMediaItem* _tmp64_;
	GFile* _tmp65_;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (file_info != NULL);
	title = NULL;
	_tmp1_ = info;
	_tmp2_ = gst_discoverer_info_get_tags (_tmp1_);
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GstDiscovererInfo* _tmp3_;
		GstTagList* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = info;
		_tmp4_ = gst_discoverer_info_get_tags (_tmp3_);
		_tmp6_ = gst_tag_list_get_string (_tmp4_, GST_TAG_TITLE, &_tmp5_);
		_g_free0 (title);
		title = _tmp5_;
		_tmp0_ = !_tmp6_;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		GFileInfo* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp8_ = file_info;
		_tmp9_ = g_file_info_get_display_name (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (title);
		title = _tmp10_;
	}
	_tmp11_ = item;
	_tmp12_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp11_, _tmp12_);
	_tmp13_ = info;
	_tmp14_ = gst_discoverer_info_get_tags (_tmp13_);
	if (_tmp14_ != NULL) {
		GDate* date = NULL;
		gboolean _tmp15_ = FALSE;
		GstDiscovererInfo* _tmp16_;
		GstTagList* _tmp17_ = NULL;
		GDate _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
		GDate _tmp20_;
		GDate* _tmp21_;
		gboolean _tmp24_;
		_tmp16_ = info;
		_tmp17_ = gst_discoverer_info_get_tags (_tmp16_);
		_tmp19_ = gst_tag_list_get_date (_tmp17_, GST_TAG_DATE, &_tmp18_);
		_g_free0 (date);
		_tmp20_ = _tmp18_;
		_tmp21_ = __g_date_dup0 (&_tmp20_);
		date = _tmp21_;
		if (_tmp19_) {
			GDate* _tmp22_;
			gboolean _tmp23_ = FALSE;
			_tmp22_ = date;
			_tmp23_ = g_date_valid (_tmp22_);
			_tmp15_ = _tmp23_;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp24_ = _tmp15_;
		if (_tmp24_) {
			gchar* _tmp25_ = NULL;
			gchar* datestr;
			gint datestr_length1;
			gint _datestr_size_;
			GDate* _tmp26_;
			gchar* _tmp27_;
			gint _tmp27__length1;
			RygelMediaItem* _tmp28_;
			gchar* _tmp29_;
			gint _tmp29__length1;
			_tmp25_ = g_new0 (gchar, 30);
			datestr = _tmp25_;
			datestr_length1 = 30;
			_datestr_size_ = datestr_length1;
			_tmp26_ = date;
			_tmp27_ = datestr;
			_tmp27__length1 = datestr_length1;
			g_date_strftime (_tmp27_, _tmp27__length1, "%F", _tmp26_);
			_tmp28_ = item;
			_tmp29_ = datestr;
			_tmp29__length1 = datestr_length1;
			rygel_media_item_set_date (_tmp28_, (const gchar*) _tmp29_);
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
	_tmp30_ = file_info;
	_tmp31_ = g_file_info_get_attribute_uint64 (_tmp30_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mtime = _tmp31_;
	_tmp32_ = item;
	_tmp33_ = rygel_media_item_get_date (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == NULL) {
		guint64 _tmp35_;
		GTimeVal _tmp36_ = {0};
		GTimeVal tv;
		RygelMediaItem* _tmp37_;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		_tmp35_ = mtime;
		_tmp36_.tv_sec = (glong) _tmp35_;
		_tmp36_.tv_usec = (glong) 0;
		tv = _tmp36_;
		_tmp37_ = item;
		_tmp38_ = g_time_val_to_iso8601 (&tv);
		_tmp39_ = _tmp38_;
		rygel_media_item_set_date (_tmp37_, _tmp39_);
		_g_free0 (_tmp39_);
	}
	_tmp40_ = item;
	_tmp41_ = file_info;
	_tmp42_ = g_file_info_get_size (_tmp41_);
	rygel_media_item_set_size (_tmp40_, (gint64) _tmp42_);
	_tmp43_ = item;
	_tmp44_ = mtime;
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp43_, (guint64) ((gint64) _tmp44_));
	_tmp46_ = profile;
	if (_tmp46_ != NULL) {
		GUPnPDLNAProfile* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		_tmp47_ = profile;
		_tmp48_ = gupnp_dlna_profile_get_name (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp45_ = _tmp49_ != NULL;
	} else {
		_tmp45_ = FALSE;
	}
	_tmp50_ = _tmp45_;
	if (_tmp50_) {
		RygelMediaItem* _tmp51_;
		GUPnPDLNAProfile* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		RygelMediaItem* _tmp55_;
		GUPnPDLNAProfile* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		_tmp51_ = item;
		_tmp52_ = profile;
		_tmp53_ = gupnp_dlna_profile_get_name (_tmp52_);
		_tmp54_ = _tmp53_;
		rygel_media_item_set_dlna_profile (_tmp51_, _tmp54_);
		_tmp55_ = item;
		_tmp56_ = profile;
		_tmp57_ = gupnp_dlna_profile_get_mime (_tmp56_);
		_tmp58_ = _tmp57_;
		rygel_media_item_set_mime_type (_tmp55_, _tmp58_);
	} else {
		RygelMediaItem* _tmp59_;
		GFileInfo* _tmp60_;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_;
		_tmp59_ = item;
		_tmp60_ = file_info;
		_tmp61_ = g_file_info_get_content_type (_tmp60_);
		_tmp62_ = g_content_type_get_mime_type (_tmp61_);
		_tmp63_ = _tmp62_;
		rygel_media_item_set_mime_type (_tmp59_, _tmp63_);
		_g_free0 (_tmp63_);
	}
	_tmp64_ = item;
	_tmp65_ = file;
	_tmp66_ = g_file_get_uri (_tmp65_);
	_tmp67_ = _tmp66_;
	rygel_media_item_add_uri (_tmp64_, _tmp67_);
	_g_free0 (_tmp67_);
	_g_free0 (title);
}



