/* rygel-tracker-item-factory.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-tracker-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gee.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_ITEM_FACTORY_TYPE_METADATA (rygel_tracker_item_factory_metadata_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTrackerParamSpecItemFactory RygelTrackerParamSpecItemFactory;

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
};

struct _RygelTrackerItemFactoryPrivate {
	GUPnPDLNADiscoverer* discoverer;
};

typedef enum  {
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TRACKER_ID,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY
} RygelTrackerItemFactoryMetadata;

struct _RygelTrackerParamSpecItemFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_tracker_item_factory_parent_class = NULL;

gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_ITEM_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryPrivate))
enum  {
	RYGEL_TRACKER_ITEM_FACTORY_DUMMY_PROPERTY
};
GType rygel_tracker_item_factory_metadata_get_type (void) G_GNUC_CONST;
RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* category_iri, const gchar* upnp_class, const gchar* upload_dir);
RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
static RygelMediaItem* rygel_tracker_item_factory_real_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* prefix);
void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
static void rygel_tracker_item_factory_real_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
static void rygel_tracker_item_factory_finalize (RygelTrackerItemFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType rygel_tracker_item_factory_metadata_get_type (void) {
	static volatile gsize rygel_tracker_item_factory_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_item_factory_metadata_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_ITEM_FACTORY_METADATA_TRACKER_ID, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_TRACKER_ID", "tracker-id"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL", "url"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER", "place-holder"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME", "file-name"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE", "title"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE", "dlna-profile"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME", "mime"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE", "size"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE", "date"}, {RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY, "RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		GType rygel_tracker_item_factory_metadata_type_id;
		rygel_tracker_item_factory_metadata_type_id = g_enum_register_static ("RygelTrackerItemFactoryMetadata", values);
		g_once_init_leave (&rygel_tracker_item_factory_metadata_type_id__volatile, rygel_tracker_item_factory_metadata_type_id);
	}
	return rygel_tracker_item_factory_metadata_type_id__volatile;
}


RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* category_iri, const gchar* upnp_class, const gchar* upload_dir) {
	RygelTrackerItemFactory* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GUPnPDLNADiscoverer* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
#line 59 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_val_if_fail (category != NULL, NULL);
#line 59 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_val_if_fail (category_iri != NULL, NULL);
#line 59 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 59 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self = (RygelTrackerItemFactory*) g_type_create_instance (object_type);
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp0_ = category;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->category);
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->category = _tmp1_;
#line 64 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp2_ = category_iri;
#line 64 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 64 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->category_iri);
#line 64 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->category_iri = _tmp3_;
#line 65 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp4_ = upnp_class;
#line 65 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 65 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->upnp_class);
#line 65 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->upnp_class = _tmp5_;
#line 66 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp6_ = upload_dir;
#line 66 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 66 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->upload_dir);
#line 66 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->upload_dir = _tmp7_;
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp9_ = upload_dir;
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp9_ == NULL) {
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp8_ = "none";
#line 219 "rygel-tracker-item-factory.c"
	} else {
		const gchar* _tmp10_;
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp10_ = upload_dir;
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp8_ = _tmp10_;
#line 226 "rygel-tracker-item-factory.c"
	}
#line 68 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp11_ = _tmp8_;
#line 68 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp12_ = upnp_class;
#line 68 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_message ("rygel-tracker-item-factory.vala:68: Using %s as upload directory for %" \
"s", _tmp11_, _tmp12_);
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp13_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, TRUE);
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_object_unref0 (self->priv->discoverer);
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->priv->discoverer = _tmp13_;
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_object_unref0 (self->properties);
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->properties = _tmp14_;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp15_ = self->properties;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "res");
#line 80 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp16_ = self->properties;
#line 80 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "place_holder");
#line 81 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp17_ = self->properties;
#line 81 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, "fileName");
#line 82 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp18_ = self->properties;
#line 82 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "dc:title");
#line 83 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp19_ = self->properties;
#line 83 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, "dlnaProfile");
#line 84 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp20_ = self->properties;
#line 84 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "mimeType");
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp21_ = self->properties;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, "res@size");
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp22_ = self->properties;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "date");
#line 59 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return self;
#line 280 "rygel-tracker-item-factory.c"
}


static RygelMediaItem* rygel_tracker_item_factory_real_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error) {
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_tracker_item_factory_create'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return NULL;
#line 289 "rygel-tracker-item-factory.c"
}


RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error) {
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS (self)->create (self, id, uri, parent, metadata, error);
#line 298 "rygel-tracker-item-factory.c"
}


void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* prefix) {
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	RygelMediaItem* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** split_id;
	gint split_id_length1;
	gint _split_id_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	RygelMediaItem* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
#line 95 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (item != NULL);
#line 95 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (prefix != NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp0_ = item;
#line 96 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 96 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp2_ = prefix;
#line 96 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp3_ = g_str_has_prefix (_tmp1_, _tmp2_);
#line 96 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp3_) {
#line 97 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		return;
#line 342 "rygel-tracker-item-factory.c"
	}
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp4_ = item;
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp5_ = ((RygelMediaObject*) _tmp4_)->id;
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	split_id = _tmp7_;
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	split_id_length1 = _vala_array_length (_tmp6_);
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_split_id_size_ = split_id_length1;
#line 101 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp8_ = split_id;
#line 101 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp8__length1 = split_id_length1;
#line 101 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp8__length1 != 2) {
#line 102 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		split_id = (_vala_array_free (split_id, split_id_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		return;
#line 366 "rygel-tracker-item-factory.c"
	}
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp9_ = item;
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp10_ = prefix;
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp11_ = g_strconcat (_tmp10_, ",", NULL);
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp12_ = _tmp11_;
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp13_ = split_id;
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp13__length1 = split_id_length1;
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp14_ = _tmp13_[1];
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (((RygelMediaObject*) _tmp9_)->ref_id);
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	((RygelMediaObject*) _tmp9_)->ref_id = _tmp15_;
#line 105 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (_tmp12_);
#line 95 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	split_id = (_vala_array_free (split_id, split_id_length1, (GDestroyNotify) g_free), NULL);
#line 392 "rygel-tracker-item-factory.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 134 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return self ? g_object_ref (self) : NULL;
#line 399 "rygel-tracker-item-factory.c"
}


static void rygel_tracker_item_factory_real_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error) {
	TrackerSparqlCursor* _tmp0_;
	gboolean _tmp1_ = FALSE;
	TrackerSparqlCursor* _tmp8_;
	gboolean _tmp9_ = FALSE;
	RygelMediaItem* _tmp14_;
	TrackerSparqlCursor* _tmp15_;
	gboolean _tmp16_ = FALSE;
	TrackerSparqlCursor* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GUPnPDLNAProfile* _tmp23_;
	GUPnPDLNAProfile* profile;
	TrackerSparqlCursor* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GUPnPDLNAProfile* _tmp34_;
	RygelMediaItem* _tmp44_;
	const gchar* _tmp45_;
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (item != NULL);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (uri != NULL);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (metadata != NULL);
#line 112 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp0_ = metadata;
#line 112 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp1_ = tracker_sparql_cursor_is_bound (_tmp0_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE);
#line 112 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp1_) {
#line 432 "rygel-tracker-item-factory.c"
		RygelMediaItem* _tmp2_;
		TrackerSparqlCursor* _tmp3_;
		const gchar* _tmp4_ = NULL;
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp2_ = item;
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp3_ = metadata;
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp4_ = tracker_sparql_cursor_get_string (_tmp3_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE, NULL);
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_media_object_set_title ((RygelMediaObject*) _tmp2_, _tmp4_);
#line 444 "rygel-tracker-item-factory.c"
	} else {
		RygelMediaItem* _tmp5_;
		TrackerSparqlCursor* _tmp6_;
		const gchar* _tmp7_ = NULL;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp5_ = item;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp6_ = metadata;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp7_ = tracker_sparql_cursor_get_string (_tmp6_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME, NULL);
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_media_object_set_title ((RygelMediaObject*) _tmp5_, _tmp7_);
#line 457 "rygel-tracker-item-factory.c"
	}
#line 119 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp8_ = metadata;
#line 119 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp9_ = tracker_sparql_cursor_is_bound (_tmp8_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE);
#line 119 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp9_) {
#line 465 "rygel-tracker-item-factory.c"
		RygelMediaItem* _tmp10_;
		TrackerSparqlCursor* _tmp11_;
		gint64 _tmp12_ = 0LL;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp10_ = item;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp11_ = metadata;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp12_ = tracker_sparql_cursor_get_integer (_tmp11_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_media_item_set_size (_tmp10_, _tmp12_);
#line 477 "rygel-tracker-item-factory.c"
	} else {
		RygelMediaItem* _tmp13_;
#line 125 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp13_ = item;
#line 125 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_media_item_set_size (_tmp13_, (gint64) 0);
#line 484 "rygel-tracker-item-factory.c"
	}
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp14_ = item;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp15_ = metadata;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp16_ = tracker_sparql_cursor_get_boolean (_tmp15_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER);
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	rygel_media_item_set_place_holder (_tmp14_, _tmp16_);
#line 130 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp17_ = metadata;
#line 130 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp18_ = tracker_sparql_cursor_is_bound (_tmp17_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE);
#line 130 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp18_) {
#line 500 "rygel-tracker-item-factory.c"
		RygelMediaItem* _tmp19_;
		TrackerSparqlCursor* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
#line 131 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp19_ = item;
#line 131 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp20_ = metadata;
#line 131 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp21_ = tracker_sparql_cursor_get_string (_tmp20_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE, NULL);
#line 131 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 131 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_g_free0 (_tmp19_->date);
#line 131 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp19_->date = _tmp22_;
#line 517 "rygel-tracker-item-factory.c"
	}
#line 134 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (NULL, GUPNP_TYPE_DLNA_PROFILE) ? ((GUPnPDLNAProfile*) NULL) : NULL);
#line 134 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	profile = _tmp23_;
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp24_ = metadata;
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp25_ = tracker_sparql_cursor_is_bound (_tmp24_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE);
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp25_) {
#line 529 "rygel-tracker-item-factory.c"
		RygelMediaItem* _tmp26_;
		TrackerSparqlCursor* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		GUPnPDLNADiscoverer* _tmp30_;
		RygelMediaItem* _tmp31_;
		const gchar* _tmp32_;
		GUPnPDLNAProfile* _tmp33_ = NULL;
#line 136 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp26_ = item;
#line 136 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp27_ = metadata;
#line 136 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp28_ = tracker_sparql_cursor_get_string (_tmp27_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE, NULL);
#line 136 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp29_ = g_strdup (_tmp28_);
#line 136 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_g_free0 (_tmp26_->dlna_profile);
#line 136 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp26_->dlna_profile = _tmp29_;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp30_ = self->priv->discoverer;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp31_ = item;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp32_ = _tmp31_->dlna_profile;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp33_ = gupnp_dlna_discoverer_get_profile (_tmp30_, _tmp32_);
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_g_object_unref0 (profile);
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		profile = _tmp33_;
#line 562 "rygel-tracker-item-factory.c"
	}
#line 140 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp34_ = profile;
#line 140 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (_tmp34_ != NULL) {
#line 568 "rygel-tracker-item-factory.c"
		RygelMediaItem* _tmp35_;
		GUPnPDLNAProfile* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
#line 141 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp35_ = item;
#line 141 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp36_ = profile;
#line 141 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp37_ = gupnp_dlna_profile_get_mime (_tmp36_);
#line 141 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp38_ = _tmp37_;
#line 141 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp39_ = g_strdup (_tmp38_);
#line 141 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_g_free0 (_tmp35_->mime_type);
#line 141 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp35_->mime_type = _tmp39_;
#line 588 "rygel-tracker-item-factory.c"
	} else {
		RygelMediaItem* _tmp40_;
		TrackerSparqlCursor* _tmp41_;
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp40_ = item;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp41_ = metadata;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp42_ = tracker_sparql_cursor_get_string (_tmp41_, (gint) RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME, NULL);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp43_ = g_strdup (_tmp42_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_g_free0 (_tmp40_->mime_type);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		_tmp40_->mime_type = _tmp43_;
#line 606 "rygel-tracker-item-factory.c"
	}
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp44_ = item;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_tmp45_ = uri;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	rygel_media_item_add_uri (_tmp44_, _tmp45_);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_object_unref0 (profile);
#line 616 "rygel-tracker-item-factory.c"
}


void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error) {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS (self)->set_metadata (self, item, uri, metadata, error);
#line 625 "rygel-tracker-item-factory.c"
}


static void rygel_tracker_value_item_factory_init (GValue* value) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	value->data[0].v_pointer = NULL;
#line 632 "rygel-tracker-item-factory.c"
}


static void rygel_tracker_value_item_factory_free_value (GValue* value) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (value->data[0].v_pointer) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_tracker_item_factory_unref (value->data[0].v_pointer);
#line 641 "rygel-tracker-item-factory.c"
	}
}


static void rygel_tracker_value_item_factory_copy_value (const GValue* src_value, GValue* dest_value) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (src_value->data[0].v_pointer) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		dest_value->data[0].v_pointer = rygel_tracker_item_factory_ref (src_value->data[0].v_pointer);
#line 651 "rygel-tracker-item-factory.c"
	} else {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		dest_value->data[0].v_pointer = NULL;
#line 655 "rygel-tracker-item-factory.c"
	}
}


static gpointer rygel_tracker_value_item_factory_peek_pointer (const GValue* value) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return value->data[0].v_pointer;
#line 663 "rygel-tracker-item-factory.c"
}


static gchar* rygel_tracker_value_item_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (collect_values[0].v_pointer) {
#line 670 "rygel-tracker-item-factory.c"
		RygelTrackerItemFactory* object;
		object = collect_values[0].v_pointer;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		if (object->parent_instance.g_class == NULL) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 677 "rygel-tracker-item-factory.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 681 "rygel-tracker-item-factory.c"
		}
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		value->data[0].v_pointer = rygel_tracker_item_factory_ref (object);
#line 685 "rygel-tracker-item-factory.c"
	} else {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		value->data[0].v_pointer = NULL;
#line 689 "rygel-tracker-item-factory.c"
	}
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return NULL;
#line 693 "rygel-tracker-item-factory.c"
}


static gchar* rygel_tracker_value_item_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTrackerItemFactory** object_p;
	object_p = collect_values[0].v_pointer;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (!object_p) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 704 "rygel-tracker-item-factory.c"
	}
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (!value->data[0].v_pointer) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		*object_p = NULL;
#line 710 "rygel-tracker-item-factory.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		*object_p = value->data[0].v_pointer;
#line 714 "rygel-tracker-item-factory.c"
	} else {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		*object_p = rygel_tracker_item_factory_ref (value->data[0].v_pointer);
#line 718 "rygel-tracker-item-factory.c"
	}
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return NULL;
#line 722 "rygel-tracker-item-factory.c"
}


GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelTrackerParamSpecItemFactory* spec;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TRACKER_TYPE_ITEM_FACTORY), NULL);
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return G_PARAM_SPEC (spec);
#line 736 "rygel-tracker-item-factory.c"
}


gpointer rygel_tracker_value_get_item_factory (const GValue* value) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TRACKER_TYPE_ITEM_FACTORY), NULL);
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return value->data[0].v_pointer;
#line 745 "rygel-tracker-item-factory.c"
}


void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object) {
	RygelTrackerItemFactory* old;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	old = value->data[0].v_pointer;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (v_object) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		value->data[0].v_pointer = v_object;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_tracker_item_factory_ref (value->data[0].v_pointer);
#line 765 "rygel-tracker-item-factory.c"
	} else {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		value->data[0].v_pointer = NULL;
#line 769 "rygel-tracker-item-factory.c"
	}
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (old) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_tracker_item_factory_unref (old);
#line 775 "rygel-tracker-item-factory.c"
	}
}


void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object) {
	RygelTrackerItemFactory* old;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	old = value->data[0].v_pointer;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (v_object) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TRACKER_TYPE_ITEM_FACTORY));
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		value->data[0].v_pointer = v_object;
#line 794 "rygel-tracker-item-factory.c"
	} else {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		value->data[0].v_pointer = NULL;
#line 798 "rygel-tracker-item-factory.c"
	}
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (old) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		rygel_tracker_item_factory_unref (old);
#line 804 "rygel-tracker-item-factory.c"
	}
}


static void rygel_tracker_item_factory_class_init (RygelTrackerItemFactoryClass * klass) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	rygel_tracker_item_factory_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->finalize = rygel_tracker_item_factory_finalize;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_type_class_add_private (klass, sizeof (RygelTrackerItemFactoryPrivate));
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->create = rygel_tracker_item_factory_real_create;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->set_metadata = rygel_tracker_item_factory_real_set_metadata;
#line 820 "rygel-tracker-item-factory.c"
}


static void rygel_tracker_item_factory_instance_init (RygelTrackerItemFactory * self) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->priv = RYGEL_TRACKER_ITEM_FACTORY_GET_PRIVATE (self);
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self->ref_count = 1;
#line 829 "rygel-tracker-item-factory.c"
}


static void rygel_tracker_item_factory_finalize (RygelTrackerItemFactory* obj) {
	RygelTrackerItemFactory * self;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory);
#line 50 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->category);
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->category_iri);
#line 52 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->upnp_class);
#line 53 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_free0 (self->upload_dir);
#line 55 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_object_unref0 (self->properties);
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	_g_object_unref0 (self->priv->discoverer);
#line 849 "rygel-tracker-item-factory.c"
}


/**
 * Abstract Tracker item factory.
 */
GType rygel_tracker_item_factory_get_type (void) {
	static volatile gsize rygel_tracker_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_item_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_tracker_value_item_factory_init, rygel_tracker_value_item_factory_free_value, rygel_tracker_value_item_factory_copy_value, rygel_tracker_value_item_factory_peek_pointer, "p", rygel_tracker_value_item_factory_collect_value, "p", rygel_tracker_value_item_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerItemFactory), 0, (GInstanceInitFunc) rygel_tracker_item_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_tracker_item_factory_type_id;
		rygel_tracker_item_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTrackerItemFactory", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_tracker_item_factory_type_id__volatile, rygel_tracker_item_factory_type_id);
	}
	return rygel_tracker_item_factory_type_id__volatile;
}


gpointer rygel_tracker_item_factory_ref (gpointer instance) {
	RygelTrackerItemFactory* self;
	self = instance;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	g_atomic_int_inc (&self->ref_count);
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	return instance;
#line 877 "rygel-tracker-item-factory.c"
}


void rygel_tracker_item_factory_unref (gpointer instance) {
	RygelTrackerItemFactory* self;
	self = instance;
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS (self)->finalize (self);
#line 35 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-item-factory.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 890 "rygel-tracker-item-factory.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



