/* rygel-xbox-hacks.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/gst.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelXboxHacksSearchData RygelXboxHacksSearchData;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaItem* item);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelXBoxHacks {
	RygelClientHacks parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelXboxHacksSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelXBoxHacks* self;
	RygelSearchableContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gboolean set_total_matches;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* modified_expression;
	RygelSearchExpression* _tmp2_;
	RygelSearchExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	RygelRelationalExpression* rel_expression;
	gboolean _tmp5_;
	RygelRelationalExpression* _tmp6_;
	gconstpointer _tmp7_;
	gboolean _tmp8_;
	RygelRelationalExpression* _tmp9_;
	gconstpointer _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	RygelRelationalExpression* _tmp15_;
	gconstpointer _tmp16_;
	RygelRelationalExpression* _tmp17_;
	gconstpointer _tmp18_;
	gboolean _tmp19_;
	RygelRelationalExpression* _tmp20_;
	gconstpointer _tmp21_;
	gboolean _tmp22_;
	RygelSearchableContainer* _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_;
	RygelSearchExpression* _tmp26_;
	RygelSearchExpression* _tmp27_;
	RygelSearchableContainer* _tmp28_;
	RygelSearchExpression* _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	const gchar* _tmp32_;
	GCancellable* _tmp33_;
	guint _tmp34_;
	RygelMediaObjects* _tmp35_;
	RygelMediaObjects* results;
	gboolean _tmp36_;
	guint _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;


static gpointer rygel_xbox_hacks_parent_class = NULL;

GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_XBOX_HACKS_DUMMY_PROPERTY
};
#define RYGEL_XBOX_HACKS_AGENT ".*Xbox.*"
#define RYGEL_XBOX_HACKS_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_XBOX_HACKS_DMS_V1 RYGEL_XBOX_HACKS_DMS ":1"
#define RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX ":"
#define RYGEL_XBOX_HACKS_MODEL_NAME "Windows Media Player Sharing"
#define RYGEL_XBOX_HACKS_MODEL_VERSION "11"
#define RYGEL_XBOX_HACKS_CONTAINER_ID "ContainerID"
GQuark rygel_client_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error);
RygelClientHacks* rygel_client_hacks_construct (GType object_type, const gchar* agent, SoupMessage* message, GError** error);
void rygel_client_hacks_set_object_id (RygelClientHacks* self, const gchar* value);
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE "urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1"
static void rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base, RygelMediaQueryAction* action, gchar** container_id);
GType rygel_search_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_real_apply (RygelClientHacks* base, RygelMediaItem* item);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_real_filter_sort_criteria (RygelClientHacks* base, gchar** sort_criteria);
static void rygel_xbox_hacks_real_search_data_free (gpointer _data);
static void rygel_xbox_hacks_real_search (RygelClientHacks* base, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
static RygelSearchExpression* rygel_xbox_hacks_rewrite_search_expression (RygelXBoxHacks* self, RygelSearchExpression* expression);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
#line 44 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 45 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 45 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (g_strcmp0 (_tmp0_, "true") == 0) {
#line 46 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = TRUE;
#line 46 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 434 "rygel-xbox-hacks.c"
	} else {
#line 48 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = FALSE;
#line 48 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 440 "rygel-xbox-hacks.c"
	}
}


RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error) {
	RygelXBoxHacks * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupURI* _tmp3_ = NULL;
	SoupURI* uri;
	SoupURI* _tmp4_;
	const gchar* _tmp5_;
	const gchar* query;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GHashTable* _tmp8_ = NULL;
	GHashTable* params;
	GHashTable* _tmp9_;
	gconstpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* album_art;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp16_;
	SoupURI* _tmp17_;
	SoupURI* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp0_ = message;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) rygel_client_hacks_construct (object_type, RYGEL_XBOX_HACKS_AGENT, _tmp0_, &_inner_error_);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			g_propagate_error (error, _inner_error_);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_g_object_unref0 (self);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			return NULL;
#line 486 "rygel-xbox-hacks.c"
		} else {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			g_clear_error (&_inner_error_);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			return NULL;
#line 494 "rygel-xbox-hacks.c"
		}
	}
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	rygel_client_hacks_set_object_id ((RygelClientHacks*) self, RYGEL_XBOX_HACKS_CONTAINER_ID);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp1_ = message;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp1_ == NULL) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return self;
#line 505 "rygel-xbox-hacks.c"
	}
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp2_ = message;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp3_ = soup_message_get_uri (_tmp2_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	uri = _tmp3_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp4_ = uri;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp5_ = _tmp4_->query;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	query = _tmp5_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp6_ = query;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp6_ == NULL) {
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return self;
#line 525 "rygel-xbox-hacks.c"
	}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp7_ = query;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp8_ = soup_form_decode (_tmp7_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	params = _tmp8_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp9_ = params;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp10_ = g_hash_table_lookup (_tmp9_, "albumArt");
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp11_ = g_strdup ((const gchar*) _tmp10_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	album_art = _tmp11_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp13_ = album_art;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp13_ == NULL) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp12_ = TRUE;
#line 547 "rygel-xbox-hacks.c"
	} else {
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp14_ = album_art;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp15_ = bool_parse (_tmp14_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp12_ = !_tmp15_;
#line 557 "rygel-xbox-hacks.c"
	}
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp16_ = _tmp12_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp16_) {
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_free0 (album_art);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_hash_table_unref0 (params);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return self;
#line 569 "rygel-xbox-hacks.c"
	}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp17_ = uri;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp18_ = uri;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp19_ = soup_uri_get_path (_tmp18_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp20_ = g_strconcat (_tmp19_, "/th/0", NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp21_ = _tmp20_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	soup_uri_set_path (_tmp17_, _tmp21_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (_tmp21_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (album_art);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_hash_table_unref0 (params);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return self;
#line 591 "rygel-xbox-hacks.c"
}


RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS, message, error);
#line 598 "rygel-xbox-hacks.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 611 "rygel-xbox-hacks.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 641 "rygel-xbox-hacks.c"
				goto __catch53_g_regex_error;
			}
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 650 "rygel-xbox-hacks.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 666 "rygel-xbox-hacks.c"
				goto __catch53_g_regex_error;
			}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 677 "rygel-xbox-hacks.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 685 "rygel-xbox-hacks.c"
	}
	goto __finally53;
	__catch53_g_regex_error:
	{
		GError* e = NULL;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1233 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 699 "rygel-xbox-hacks.c"
	}
	__finally53:
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return NULL;
#line 710 "rygel-xbox-hacks.c"
	}
}


void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error) {
	RygelRootDevice* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	DescriptionFile* _tmp5_;
	DescriptionFile* description_file;
	DescriptionFile* _tmp6_;
	DescriptionFile* _tmp7_;
	DescriptionFile* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* friendly_name;
	DescriptionFile* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	DescriptionFile* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* desc_path;
	DescriptionFile* _tmp17_;
	const gchar* _tmp18_;
	RygelRootDevice* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* server_path;
	RygelRootDevice* _tmp22_;
	GUPnPContext* _tmp23_;
	GUPnPContext* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GRegex* _tmp27_;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_if_fail (device != NULL);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp0_ = device;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp1_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _tmp0_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp2_ = g_str_has_prefix (_tmp1_, RYGEL_XBOX_HACKS_DMS);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (!_tmp2_) {
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return;
#line 763 "rygel-xbox-hacks.c"
	}
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp3_ = template_path;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp3_ == NULL) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return;
#line 771 "rygel-xbox-hacks.c"
	}
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp4_ = template_path;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp5_ = description_file_new (_tmp4_, &_inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	description_file = _tmp5_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_propagate_error (error, _inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return;
#line 785 "rygel-xbox-hacks.c"
	}
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp6_ = description_file;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	description_file_set_model_name (_tmp6_, RYGEL_XBOX_HACKS_MODEL_NAME);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp7_ = description_file;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	description_file_set_model_number (_tmp7_, RYGEL_XBOX_HACKS_MODEL_VERSION);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp8_ = description_file;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp9_ = description_file_get_friendly_name (_tmp8_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	friendly_name = _tmp9_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp10_ = description_file;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp11_ = friendly_name;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp12_ = g_strconcat (_tmp11_, RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX, NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp13_ = _tmp12_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	description_file_set_friendly_name (_tmp10_, _tmp13_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (_tmp13_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp14_ = description_file;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	description_file_modify_service_type (_tmp14_, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp15_ = template_path;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp16_ = string_replace (_tmp15_, "v1.xml", "xbox.xml");
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	desc_path = _tmp16_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp17_ = description_file;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp18_ = desc_path;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	description_file_save (_tmp17_, _tmp18_, &_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_propagate_error (error, _inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_free0 (desc_path);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_free0 (friendly_name);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_object_unref0 (description_file);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return;
#line 841 "rygel-xbox-hacks.c"
	}
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp19_ = device;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp20_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) _tmp19_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp21_ = g_strconcat ("/", _tmp20_, NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	server_path = _tmp21_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp22_ = device;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp23_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp22_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp24_ = _tmp23_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp25_ = desc_path;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp26_ = server_path;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp27_ = ((RygelClientHacks*) self)->agent_regex;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	gupnp_context_host_path_for_agent (_tmp24_, _tmp25_, _tmp26_, _tmp27_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (server_path);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (desc_path);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (friendly_name);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_object_unref0 (description_file);
#line 873 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base, RygelMediaQueryAction* action, gchar** container_id) {
	RygelXBoxHacks * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelMediaQueryAction* _tmp2_;
	gboolean _tmp19_;
	gboolean _tmp30_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) base;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_if_fail (action != NULL);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_if_fail (*container_id != NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp2_ = action;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_SEARCH)) {
#line 894 "rygel-xbox-hacks.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gboolean _tmp10_;
		gboolean _tmp12_;
		gboolean _tmp14_;
		gboolean _tmp16_;
		gboolean _tmp18_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp8_ = *container_id;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (g_strcmp0 (_tmp8_, "1") == 0) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp7_ = TRUE;
#line 912 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp9_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp9_ = *container_id;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, "4") == 0;
#line 919 "rygel-xbox-hacks.c"
		}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp10_ = _tmp7_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_tmp10_) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp6_ = TRUE;
#line 927 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp11_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp11_ = *container_id;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp6_ = g_strcmp0 (_tmp11_, "5") == 0;
#line 934 "rygel-xbox-hacks.c"
		}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp12_ = _tmp6_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_tmp12_) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp5_ = TRUE;
#line 942 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp13_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp13_ = *container_id;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp5_ = g_strcmp0 (_tmp13_, "6") == 0;
#line 949 "rygel-xbox-hacks.c"
		}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp14_ = _tmp5_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_tmp14_) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp4_ = TRUE;
#line 957 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp15_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp15_ = *container_id;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp4_ = g_strcmp0 (_tmp15_, "7") == 0;
#line 964 "rygel-xbox-hacks.c"
		}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp16_ = _tmp4_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_tmp16_) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp3_ = TRUE;
#line 972 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp17_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp17_ = *container_id;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp3_ = g_strcmp0 (_tmp17_, "F") == 0;
#line 979 "rygel-xbox-hacks.c"
		}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp18_ = _tmp3_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp1_ = _tmp18_;
#line 985 "rygel-xbox-hacks.c"
	} else {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp1_ = FALSE;
#line 989 "rygel-xbox-hacks.c"
	}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp19_ = _tmp1_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp19_) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp0_ = TRUE;
#line 997 "rygel-xbox-hacks.c"
	} else {
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		RygelMediaQueryAction* _tmp23_;
		gboolean _tmp25_;
		gboolean _tmp27_;
		gboolean _tmp29_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp23_ = action;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, RYGEL_TYPE_BROWSE)) {
#line 1010 "rygel-xbox-hacks.c"
			const gchar* _tmp24_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp24_ = *container_id;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp22_ = g_strcmp0 (_tmp24_, "15") == 0;
#line 1016 "rygel-xbox-hacks.c"
		} else {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp22_ = FALSE;
#line 1020 "rygel-xbox-hacks.c"
		}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp25_ = _tmp22_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_tmp25_) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp21_ = TRUE;
#line 1028 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp26_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp26_ = *container_id;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp21_ = g_strcmp0 (_tmp26_, "14") == 0;
#line 1035 "rygel-xbox-hacks.c"
		}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp27_ = _tmp21_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_tmp27_) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp20_ = TRUE;
#line 1043 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp28_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp28_ = *container_id;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp20_ = g_strcmp0 (_tmp28_, "16") == 0;
#line 1050 "rygel-xbox-hacks.c"
		}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp29_ = _tmp20_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp0_ = _tmp29_;
#line 1056 "rygel-xbox-hacks.c"
	}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp30_ = _tmp0_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp30_) {
#line 1062 "rygel-xbox-hacks.c"
		gchar* _tmp31_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp31_ = g_strdup ("0");
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_free0 (*container_id);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		*container_id = _tmp31_;
#line 1070 "rygel-xbox-hacks.c"
	}
}


static void rygel_xbox_hacks_real_apply (RygelClientHacks* base, RygelMediaItem* item) {
	RygelXBoxHacks * self;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) base;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_if_fail (item != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp0_ = item;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp1_ = _tmp0_->mime_type;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (g_strcmp0 (_tmp1_, "video/x-msvideo") == 0) {
#line 1089 "rygel-xbox-hacks.c"
		RygelMediaItem* _tmp2_;
		gchar* _tmp3_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp2_ = item;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp3_ = g_strdup ("video/avi");
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_free0 (_tmp2_->mime_type);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp2_->mime_type = _tmp3_;
#line 1100 "rygel-xbox-hacks.c"
	} else {
		RygelMediaItem* _tmp4_;
		const gchar* _tmp5_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp4_ = item;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp5_ = _tmp4_->mime_type;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (g_strcmp0 (_tmp5_, "video/mpeg") == 0) {
#line 1110 "rygel-xbox-hacks.c"
			RygelMediaItem* _tmp6_;
			gchar* _tmp7_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp6_ = item;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp7_ = g_strdup ("invalid/content");
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_g_free0 (_tmp6_->mime_type);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_tmp6_->mime_type = _tmp7_;
#line 1121 "rygel-xbox-hacks.c"
		}
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1176 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1177 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1177 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1178 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1178 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1158 "rygel-xbox-hacks.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1179 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1179 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1179 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1167 "rygel-xbox-hacks.c"
	}
#line 1181 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1181 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1173 "rygel-xbox-hacks.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1182 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1182 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1182 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1182 "rygel-xbox-hacks.c"
	}
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1188 "rygel-xbox-hacks.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1197 "rygel-xbox-hacks.c"
	} else {
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1201 "rygel-xbox-hacks.c"
	}
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1184 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1211 "rygel-xbox-hacks.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1220 "rygel-xbox-hacks.c"
	} else {
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1224 "rygel-xbox-hacks.c"
	}
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1185 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1186 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1186 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1186 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1248 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_real_filter_sort_criteria (RygelClientHacks* base, gchar** sort_criteria) {
	RygelXBoxHacks * self;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) base;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_if_fail (*sort_criteria != NULL);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp0_ = *sort_criteria;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp1_ = string_replace (_tmp0_, "+microsoft:sourceURL", "");
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (*sort_criteria);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	*sort_criteria = _tmp1_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp2_ = *sort_criteria;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp3_ = string_replace (_tmp2_, ",,", ",");
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (*sort_criteria);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	*sort_criteria = _tmp3_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp4_ = *sort_criteria;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp5_ = g_str_has_prefix (_tmp4_, ",");
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_tmp5_) {
#line 1286 "rygel-xbox-hacks.c"
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp6_ = *sort_criteria;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp7_ = *sort_criteria;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp8_ = strlen (_tmp7_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp9_ = _tmp8_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_tmp10_ = string_slice (_tmp6_, (glong) 1, (glong) _tmp9_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_g_free0 (*sort_criteria);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		*sort_criteria = _tmp10_;
#line 1306 "rygel-xbox-hacks.c"
	}
}


static void rygel_xbox_hacks_real_search_data_free (gpointer _data) {
	RygelXboxHacksSearchData* _data_;
	_data_ = _data;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->container);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (_data_->sort_criteria);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->cancellable);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->result);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->self);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_slice_free (RygelXboxHacksSearchData, _data_);
#line 1328 "rygel-xbox-hacks.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return self ? g_object_ref (self) : NULL;
#line 1335 "rygel-xbox-hacks.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1342 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_real_search (RygelClientHacks* base, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelXBoxHacks * self;
	RygelXboxHacksSearchData* _data_;
	RygelXBoxHacks* _tmp0_;
	RygelSearchableContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchExpression* _tmp3_;
	RygelSearchExpression* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) base;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_ = g_slice_new0 (RygelXboxHacksSearchData);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_xbox_hacks_real_search);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_xbox_hacks_real_search_data_free);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->self = _tmp0_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp1_ = container;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->container = _tmp2_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp3_ = expression;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp4_ = _rygel_search_expression_ref0 (_tmp3_);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->expression = _tmp4_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp5_ = offset;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->offset = _tmp5_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp6_ = max_count;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->max_count = _tmp6_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp7_ = sort_criteria;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->sort_criteria = _tmp8_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp9_ = cancellable;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->cancellable = _tmp10_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_real_search_co (_data_);
#line 1406 "rygel-xbox-hacks.c"
}


static RygelMediaObjects* rygel_xbox_hacks_real_search_finish (RygelClientHacks* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelXboxHacksSearchData* _data_;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return NULL;
#line 1417 "rygel-xbox-hacks.c"
	}
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (total_matches) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		*total_matches = _data_->total_matches;
#line 1425 "rygel-xbox-hacks.c"
	}
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	result = _data_->result;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->result = NULL;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return result;
#line 1433 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelXboxHacksSearchData* _data_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_ = _user_data_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_source_object_ = source_object;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_res_ = _res_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_real_search_co (_data_);
#line 1447 "rygel-xbox-hacks.c"
}


static gboolean rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_) {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	switch (_data_->_state_) {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		case 0:
#line 1456 "rygel-xbox-hacks.c"
		goto _state_0;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		case 1:
#line 1460 "rygel-xbox-hacks.c"
		goto _state_1;
		default:
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_assert_not_reached ();
#line 1465 "rygel-xbox-hacks.c"
	}
	_state_0:
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->set_total_matches = FALSE;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp0_ = _data_->expression;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp1_ = _rygel_search_expression_ref0 (_data_->_tmp0_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->modified_expression = _data_->_tmp1_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp2_ = _data_->expression;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp3_ = _data_->expression;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp4_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->_tmp3_) : NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->rel_expression = _data_->_tmp4_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp6_ = _data_->rel_expression;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp7_ = ((RygelSearchExpression*) _data_->_tmp6_)->operand1;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp8_ = FALSE;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp8_ = G_LIKELY (((const gchar*) _data_->_tmp7_) != NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_data_->_tmp8_) {
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp9_ = _data_->rel_expression;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp10_ = ((RygelSearchExpression*) _data_->_tmp9_)->operand1;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp5_ = g_strcmp0 ((const gchar*) _data_->_tmp10_, "upnp:class") == 0;
#line 1502 "rygel-xbox-hacks.c"
		} else {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp5_ = FALSE;
#line 1506 "rygel-xbox-hacks.c"
		}
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp11_ = _data_->_tmp5_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_data_->_tmp11_) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->set_total_matches = TRUE;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp15_ = _data_->rel_expression;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp16_ = ((RygelSearchExpression*) _data_->_tmp15_)->op;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			if (((GUPnPSearchCriteriaOp) ((gintptr) _data_->_tmp16_)) == GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM) {
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp17_ = _data_->rel_expression;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp18_ = ((RygelSearchExpression*) _data_->_tmp17_)->operand2;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp14_ = ((const gchar*) _data_->_tmp18_) != NULL;
#line 1526 "rygel-xbox-hacks.c"
			} else {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp14_ = FALSE;
#line 1530 "rygel-xbox-hacks.c"
			}
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp19_ = _data_->_tmp14_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			if (_data_->_tmp19_) {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp20_ = _data_->rel_expression;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp21_ = ((RygelSearchExpression*) _data_->_tmp20_)->operand2;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp13_ = g_strcmp0 ((const gchar*) _data_->_tmp21_, RYGEL_AUDIO_ITEM_UPNP_CLASS) == 0;
#line 1542 "rygel-xbox-hacks.c"
			} else {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp13_ = FALSE;
#line 1546 "rygel-xbox-hacks.c"
			}
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp22_ = _data_->_tmp13_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			if (_data_->_tmp22_) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp23_ = _data_->container;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp24_ = ((RygelMediaObject*) _data_->_tmp23_)->id;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp12_ = g_strcmp0 (_data_->_tmp24_, "0") == 0;
#line 1558 "rygel-xbox-hacks.c"
			} else {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp12_ = FALSE;
#line 1562 "rygel-xbox-hacks.c"
			}
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			_data_->_tmp25_ = _data_->_tmp12_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			if (_data_->_tmp25_) {
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp26_ = _data_->expression;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp27_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->_tmp27_ = rygel_xbox_hacks_rewrite_search_expression (_data_->self, _data_->_tmp26_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_rygel_search_expression_unref0 (_data_->modified_expression);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
				_data_->modified_expression = _data_->_tmp27_;
#line 1578 "rygel-xbox-hacks.c"
			}
		}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_rygel_search_expression_unref0 (_data_->rel_expression);
#line 1583 "rygel-xbox-hacks.c"
	}
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp28_ = _data_->container;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp29_ = _data_->modified_expression;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp30_ = _data_->offset;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp31_ = _data_->max_count;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp32_ = _data_->sort_criteria;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp33_ = _data_->cancellable;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp34_ = 0U;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_state_ = 1;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	rygel_searchable_container_search (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, rygel_xbox_hacks_search_ready, _data_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return FALSE;
#line 1605 "rygel-xbox-hacks.c"
	_state_1:
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp35_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp35_ = rygel_searchable_container_search_finish (_data_->_tmp28_, _data_->_res_, &_data_->_tmp34_, &_data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->total_matches = _data_->_tmp34_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->results = _data_->_tmp35_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_data_->_inner_error_ != NULL) {
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_error_free (_data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_rygel_search_expression_unref0 (_data_->modified_expression);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		if (_data_->_state_ == 0) {
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1627 "rygel-xbox-hacks.c"
		} else {
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1631 "rygel-xbox-hacks.c"
		}
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_object_unref (_data_->_async_result);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		return FALSE;
#line 1637 "rygel-xbox-hacks.c"
	}
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp37_ = _data_->total_matches;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_data_->_tmp37_ == ((guint) 0)) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp38_ = _data_->set_total_matches;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp36_ = _data_->_tmp38_;
#line 1647 "rygel-xbox-hacks.c"
	} else {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp36_ = FALSE;
#line 1651 "rygel-xbox-hacks.c"
	}
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->_tmp39_ = _data_->_tmp36_;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_data_->_tmp39_) {
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		_data_->total_matches = (guint) _data_->_tmp41_;
#line 1663 "rygel-xbox-hacks.c"
	}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_data_->result = _data_->results;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_rygel_search_expression_unref0 (_data_->modified_expression);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_data_->_state_ == 0) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1673 "rygel-xbox-hacks.c"
	} else {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1677 "rygel-xbox-hacks.c"
	}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_object_unref (_data_->_async_result);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return FALSE;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->results);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_rygel_search_expression_unref0 (_data_->modified_expression);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	if (_data_->_state_ == 0) {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1691 "rygel-xbox-hacks.c"
	} else {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1695 "rygel-xbox-hacks.c"
	}
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_object_unref (_data_->_async_result);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return FALSE;
#line 1701 "rygel-xbox-hacks.c"
}


static RygelSearchExpression* rygel_xbox_hacks_rewrite_search_expression (RygelXBoxHacks* self, RygelSearchExpression* expression) {
	RygelSearchExpression* result = NULL;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* ref_id_expression;
	gchar* _tmp1_;
	gchar* _tmp2_;
	RygelLogicalExpression* _tmp3_;
	RygelLogicalExpression* new_expression;
	RygelSearchExpression* _tmp4_;
	RygelSearchExpression* _tmp5_;
	RygelSearchExpression* _tmp6_;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp0_ = rygel_relational_expression_new ();
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	ref_id_expression = _tmp0_;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp1_ = g_strdup ("@refID");
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (((RygelSearchExpression*) ref_id_expression)->operand1);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	((RygelSearchExpression*) ref_id_expression)->operand1 = _tmp1_;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	((RygelSearchExpression*) ref_id_expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EXISTS);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp2_ = g_strdup ("false");
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_g_free0 (((RygelSearchExpression*) ref_id_expression)->operand2);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	((RygelSearchExpression*) ref_id_expression)->operand2 = _tmp2_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp3_ = rygel_logical_expression_new ();
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	new_expression = _tmp3_;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp4_ = expression;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp5_ = _rygel_search_expression_ref0 (_tmp4_);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_rygel_search_expression_unref0 (((RygelSearchExpression*) new_expression)->operand1);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	((RygelSearchExpression*) new_expression)->operand1 = _tmp5_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	((RygelSearchExpression*) new_expression)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_tmp6_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) ref_id_expression);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_rygel_search_expression_unref0 (((RygelSearchExpression*) new_expression)->operand2);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	((RygelSearchExpression*) new_expression)->operand2 = _tmp6_;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	result = (RygelSearchExpression*) new_expression;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	_rygel_search_expression_unref0 (ref_id_expression);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	return result;
#line 1764 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->translate_container_id = rygel_xbox_hacks_real_translate_container_id;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->apply = rygel_xbox_hacks_real_apply;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->filter_sort_criteria = rygel_xbox_hacks_real_filter_sort_criteria;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->search = rygel_xbox_hacks_real_search;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-xbox-hacks.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->search_finish = rygel_xbox_hacks_real_search_finish;
#line 1781 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_instance_init (RygelXBoxHacks * self) {
}


GType rygel_xbox_hacks_get_type (void) {
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}



