/* rygel-music-item.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-music-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	gchar* artist;
	gchar* album;
	gchar* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_music_item_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
void rygel_music_item_lookup_album_art (RygelMusicItem* self);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
RygelMediaArtStore* rygel_media_art_store_get_default (void);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
static void rygel_music_item_finalize (GObject* obj);


RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMusicItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = id;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = parent;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = title;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = upnp_class;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self;
#line 297 "rygel-music-item.c"
}


RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title, upnp_class);
#line 304 "rygel-music-item.c"
}


void rygel_music_item_lookup_album_art (RygelMusicItem* self) {
	RygelThumbnail* _tmp0_;
	RygelMediaArtStore* _tmp1_ = NULL;
	RygelMediaArtStore* media_art_store;
	RygelMediaArtStore* _tmp2_;
	GError * _inner_error_ = NULL;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->album_art;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_vala_assert (_tmp0_ == NULL, "this.album_art == null");
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = rygel_media_art_store_get_default ();
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	media_art_store = _tmp1_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = media_art_store;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp2_ == NULL) {
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (media_art_store);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 332 "rygel-music-item.c"
	}
	{
		RygelMediaArtStore* _tmp3_;
		RygelThumbnail* _tmp4_ = NULL;
		RygelThumbnail* _tmp5_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = media_art_store;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp4_ = rygel_media_art_store_find_media_art_any (_tmp3_, self, &_inner_error_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = _tmp4_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_inner_error_ != NULL) {
#line 346 "rygel-music-item.c"
			goto __catch3_g_error;
		}
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_rygel_icon_info_unref0 (self->album_art);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		self->album_art = _tmp5_;
#line 353 "rygel-music-item.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		err = _inner_error_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_inner_error_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_error_free0 (err);
#line 365 "rygel-music-item.c"
	}
	__finally3:
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (media_art_store);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_clear_error (&_inner_error_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 378 "rygel-music-item.c"
	}
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_object_unref0 (media_art_store);
#line 382 "rygel-music-item.c"
}


static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteItem* _tmp0_;
	gboolean _tmp1_;
	RygelThumbnail* _tmp2_;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = didl_item;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = allow_internal;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_propagate_error (error, _inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 408 "rygel-music-item.c"
	}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = self->album_art;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp2_ != NULL) {
#line 414 "rygel-music-item.c"
		RygelThumbnail* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* protocol;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gboolean _tmp9_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = self->album_art;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->uri;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, _tmp4_, &_inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		protocol = _tmp5_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_inner_error_ != NULL) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			g_propagate_error (error, _inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			return;
#line 436 "rygel-music-item.c"
		}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp7_ = allow_internal;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_tmp7_) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp6_ = TRUE;
#line 444 "rygel-music-item.c"
		} else {
			const gchar* _tmp8_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp8_ = protocol;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp6_ = g_strcmp0 (_tmp8_, "internal") != 0;
#line 451 "rygel-music-item.c"
		}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp9_ = _tmp6_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_tmp9_) {
#line 457 "rygel-music-item.c"
			GUPnPDIDLLiteItem* _tmp10_;
			RygelThumbnail* _tmp11_;
			const gchar* _tmp12_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp10_ = didl_item;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp11_ = self->album_art;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp12_ = ((RygelIconInfo*) _tmp11_)->uri;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp10_, _tmp12_);
#line 469 "rygel-music-item.c"
		}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_free0 (protocol);
#line 473 "rygel-music-item.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 481 "rygel-music-item.c"
}


static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMusicItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMusicItem* _tmp2_;
	RygelMusicItem* item;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	static GQuark _tmp5_label1 = 0;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	static GQuark _tmp5_label2 = 0;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = media_object;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		result = 1;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return result;
#line 515 "rygel-music-item.c"
	}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = media_object;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp1_) : NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	item = _tmp2_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = property;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = _tmp3_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("dc:artist")))) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 533 "rygel-music-item.c"
			default:
			{
				const gchar* _tmp7_;
				RygelMusicItem* _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp7_ = self->artist;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp8_ = item;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp9_ = _tmp8_->artist;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp10_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 554 "rygel-music-item.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("upnp:album")))) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 560 "rygel-music-item.c"
			default:
			{
				const gchar* _tmp11_;
				RygelMusicItem* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_ = 0;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp11_ = self->album;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp12_ = item;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp13_ = _tmp12_->album;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp14_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp11_, _tmp13_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp14_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 581 "rygel-music-item.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 587 "rygel-music-item.c"
			default:
			{
				gint _tmp15_;
				RygelMusicItem* _tmp16_;
				gint _tmp17_;
				gint _tmp18_ = 0;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp15_ = self->track_number;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp16_ = item;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp17_ = _tmp16_->track_number;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp18_ = rygel_media_object_compare_int_props ((RygelMediaObject*) self, _tmp15_, _tmp17_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp18_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 608 "rygel-music-item.c"
			}
		}
	} else {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 614 "rygel-music-item.c"
			default:
			{
				RygelMusicItem* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp19_ = item;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp20_ = property;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp21_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp19_, _tmp20_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp21_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 632 "rygel-music-item.c"
			}
		}
	}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_object_unref0 (item);
#line 638 "rygel-music-item.c"
}


static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* didl_item;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gint _tmp11_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp17_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean _tmp23_;
	GUPnPDIDLLiteObject* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GError * _inner_error_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (writer != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = writer;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = http_server;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	didl_item = _tmp2_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_propagate_error (error, _inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return NULL;
#line 683 "rygel-music-item.c"
	}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = self->artist;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp4_ != NULL) {
#line 689 "rygel-music-item.c"
		const gchar* _tmp5_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = self->artist;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 695 "rygel-music-item.c"
	} else {
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = FALSE;
#line 699 "rygel-music-item.c"
	}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp6_ = _tmp3_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp6_) {
#line 705 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp7_;
		GUPnPDIDLLiteContributor* _tmp8_ = NULL;
		GUPnPDIDLLiteContributor* contributor;
		GUPnPDIDLLiteContributor* _tmp9_;
		const gchar* _tmp10_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp7_ = didl_item;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp8_ = gupnp_didl_lite_object_add_artist (_tmp7_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		contributor = _tmp8_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp9_ = contributor;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp10_ = self->artist;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_contributor_set_name (_tmp9_, _tmp10_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (contributor);
#line 725 "rygel-music-item.c"
	}
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp11_ = self->track_number;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp11_ >= 0) {
#line 731 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp12_;
		gint _tmp13_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp12_ = didl_item;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp13_ = self->track_number;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_track_number (_tmp12_, _tmp13_);
#line 740 "rygel-music-item.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp15_ = self->album;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp15_ != NULL) {
#line 746 "rygel-music-item.c"
		const gchar* _tmp16_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp16_ = self->album;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
#line 752 "rygel-music-item.c"
	} else {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp14_ = FALSE;
#line 756 "rygel-music-item.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp17_ = _tmp14_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp17_) {
#line 762 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp18_;
		const gchar* _tmp19_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp18_ = didl_item;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp19_ = self->album;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_album (_tmp18_, _tmp19_);
#line 771 "rygel-music-item.c"
	}
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp21_ = self->genre;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp21_ != NULL) {
#line 777 "rygel-music-item.c"
		const gchar* _tmp22_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp22_ = self->genre;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp20_ = g_strcmp0 (_tmp22_, "") != 0;
#line 783 "rygel-music-item.c"
	} else {
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp20_ = FALSE;
#line 787 "rygel-music-item.c"
	}
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp23_ = _tmp20_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp23_) {
#line 793 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp24_;
		const gchar* _tmp25_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp24_ = didl_item;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp25_ = self->genre;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_genre (_tmp24_, _tmp25_);
#line 802 "rygel-music-item.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp26_ = didl_item;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp27_ = gupnp_didl_lite_object_get_album_art (_tmp26_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp28_ = _tmp27_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp28_ != NULL) {
#line 812 "rygel-music-item.c"
		GRegex* _tmp29_;
		GUPnPDIDLLiteObject* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		RygelHTTPServer* _tmp33_;
		GUPnPContext* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		GUPnPDIDLLiteObject* _tmp39_;
		gchar* _tmp40_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp29_ = ((RygelMediaItem*) self)->address_regex;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp30_ = didl_item;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp31_ = gupnp_didl_lite_object_get_album_art (_tmp30_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp32_ = _tmp31_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp33_ = http_server;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp34_ = _tmp33_->context;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp35_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp34_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp36_ = _tmp35_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp37_ = g_regex_replace_literal (_tmp29_, _tmp32_, (gssize) (-1), 0, _tmp36_, 0, &_inner_error_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp38_ = _tmp37_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_inner_error_ != NULL) {
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			g_propagate_error (error, _inner_error_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_g_object_unref0 (didl_item);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			return NULL;
#line 853 "rygel-music-item.c"
		}
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp39_ = didl_item;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp40_ = _tmp38_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_album_art (_tmp39_, _tmp40_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_free0 (_tmp40_);
#line 863 "rygel-music-item.c"
	}
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = didl_item;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 869 "rygel-music-item.c"
}


static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelMusicItem * self;
	RygelHTTPServer* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (server != NULL);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = server;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = didl_item;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_proxy_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_propagate_error (error, _inner_error_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 902 "rygel-music-item.c"
	}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp5_ = _tmp4_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (!_tmp5_) {
#line 910 "rygel-music-item.c"
		RygelThumbnail* _tmp6_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp6_ = self->album_art;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 916 "rygel-music-item.c"
	} else {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = FALSE;
#line 920 "rygel-music-item.c"
	}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp7_ = _tmp3_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp7_) {
#line 926 "rygel-music-item.c"
		RygelHTTPServer* _tmp8_;
		RygelThumbnail* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp8_ = server;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp9_ = self->album_art;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp10_ = ((RygelIconInfo*) _tmp9_)->uri;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp11_ = rygel_http_server_need_proxy (_tmp8_, _tmp10_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp2_ = _tmp11_;
#line 941 "rygel-music-item.c"
	} else {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp2_ = FALSE;
#line 945 "rygel-music-item.c"
	}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp12_ = _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp12_) {
#line 951 "rygel-music-item.c"
		GUPnPDIDLLiteItem* _tmp13_;
		RygelHTTPServer* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp13_ = didl_item;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp14_ = server;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp15_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) _tmp14_, (RygelMediaItem*) self, 0, -1, NULL);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp16_ = _tmp15_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp13_, _tmp16_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_free0 (_tmp16_);
#line 968 "rygel-music-item.c"
	}
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_music_item_real_add_resources;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_music_item_real_compare_by_property;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_music_item_real_serialize;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_music_item_real_add_proxy_resources;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 986 "rygel-music-item.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->track_number = -1;
#line 993 "rygel-music-item.c"
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->artist);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->album);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->genre);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_rygel_icon_info_unref0 (self->album_art);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 1011 "rygel-music-item.c"
}


/**
 * Represents a music item.
 */
GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}



