/* rygel-description-file.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-description-file.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_DESCRIPTION_FILE (description_file_get_type ())
#define DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESCRIPTION_FILE, DescriptionFile))
#define DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESCRIPTION_FILE, DescriptionFileClass))
#define IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESCRIPTION_FILE))
#define IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESCRIPTION_FILE))
#define DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESCRIPTION_FILE, DescriptionFileClass))

typedef struct _DescriptionFile DescriptionFile;
typedef struct _DescriptionFileClass DescriptionFileClass;
typedef struct _DescriptionFilePrivate DescriptionFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DescriptionFile {
	GObject parent_instance;
	DescriptionFilePrivate * priv;
};

struct _DescriptionFileClass {
	GObjectClass parent_class;
};

struct _DescriptionFilePrivate {
	GUPnPXMLDoc* doc;
};


static gpointer description_file_parent_class = NULL;

GType description_file_get_type (void) G_GNUC_CONST;
#define DESCRIPTION_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DESCRIPTION_FILE, DescriptionFilePrivate))
enum  {
	DESCRIPTION_FILE_DUMMY_PROPERTY
};
#define DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE "//*[.='%s']"
DescriptionFile* description_file_new (const gchar* template, GError** error);
DescriptionFile* description_file_construct (GType object_type, const gchar* template, GError** error);
DescriptionFile* description_file_new_from_xml_document (GUPnPXMLDoc* doc);
DescriptionFile* description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
void description_file_set_device_type (DescriptionFile* self, const gchar* device_type);
static void description_file_set_device_element (DescriptionFile* self, const gchar* element, const gchar* new_value);
void description_file_set_model_name (DescriptionFile* self, const gchar* model_name);
void description_file_set_model_number (DescriptionFile* self, const gchar* model_number);
void description_file_set_friendly_name (DescriptionFile* self, const gchar* friendly_name);
gchar* description_file_get_friendly_name (DescriptionFile* self);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
void description_file_modify_service_type (DescriptionFile* self, const gchar* old_type, const gchar* new_type);
void description_file_save (DescriptionFile* self, const gchar* path, GError** error);
static void description_file_finalize (GObject* obj);


/**
     * Constructor to load a description file from disk
     *
     * @param template the path to the description file.
     * @throws GUPnP.XMLError.PARSE if there was an error reading or parsing
     * the file.
     */
DescriptionFile* description_file_construct (GType object_type, const gchar* template, GError** error) {
	DescriptionFile * self = NULL;
	const gchar* _tmp0_;
	GUPnPXMLDoc* _tmp1_;
	GUPnPXMLDoc* _tmp2_;
	GError * _inner_error_ = NULL;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (template != NULL, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = (DescriptionFile*) g_object_new (object_type, NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = template;
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = gupnp_xml_doc_new_from_path (_tmp0_, &_inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = _tmp1_;
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_inner_error_ != NULL) {
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_object_unref0 (self);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return NULL;
#line 127 "rygel-description-file.c"
	}
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->doc = _tmp2_;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self;
#line 135 "rygel-description-file.c"
}


DescriptionFile* description_file_new (const gchar* template, GError** error) {
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return description_file_construct (TYPE_DESCRIPTION_FILE, template, error);
#line 142 "rygel-description-file.c"
}


/**
     * Constructor which wraps an existing GUPnP.XMLDoc as a description file.
     *
     * @param doc is the GUPnP.XMLDoc to wrap.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self ? g_object_ref (self) : NULL;
#line 154 "rygel-description-file.c"
}


DescriptionFile* description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc) {
	DescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_;
	GUPnPXMLDoc* _tmp1_;
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = (DescriptionFile*) g_object_new (object_type, NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = doc;
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->doc = _tmp1_;
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self;
#line 176 "rygel-description-file.c"
}


DescriptionFile* description_file_new_from_xml_document (GUPnPXMLDoc* doc) {
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return description_file_construct_from_xml_document (TYPE_DESCRIPTION_FILE, doc);
#line 183 "rygel-description-file.c"
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the device version, e.g. default device type is
     * "MediaServer:2" and device_type = "MediaServer:1".
     *
     * @param device_type is the current content of serviceType.
     */
void description_file_set_device_type (DescriptionFile* self, const gchar* device_type) {
	const gchar* _tmp0_;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (device_type != NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = device_type;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	description_file_set_device_element (self, "deviceType", _tmp0_);
#line 205 "rygel-description-file.c"
}


/**
     * Modify the model name.
     *
     * Usually the name of the software implementing this device.
     *
     * @param model_name is the new model name.
     */
void description_file_set_model_name (DescriptionFile* self, const gchar* model_name) {
	const gchar* _tmp0_;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_name != NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_name;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	description_file_set_device_element (self, "modelName", _tmp0_);
#line 226 "rygel-description-file.c"
}


/**
     * Modify the model number.
     *
     * Usually the version of the software implementing this device.
     *
     * @param model_number is the new model number.
     */
void description_file_set_model_number (DescriptionFile* self, const gchar* model_number) {
	const gchar* _tmp0_;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_number != NULL);
#line 92 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_number;
#line 92 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	description_file_set_device_element (self, "modelNumber", _tmp0_);
#line 247 "rygel-description-file.c"
}


/**
     * Set the friendly name of the device.
     *
     * The friendly name is the one usually presented to the user in control
     * points or DMPs
     *
     * @param friendly_name is the new friendly name of the device.
     */
void description_file_set_friendly_name (DescriptionFile* self, const gchar* friendly_name) {
	const gchar* _tmp0_;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (friendly_name != NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = friendly_name;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	description_file_set_device_element (self, "friendlyName", _tmp0_);
#line 269 "rygel-description-file.c"
}


/**
     * Get the current friendly name of the device.
     *
     * @return The currenly set friendly name.
     */
gchar* description_file_get_friendly_name (DescriptionFile* self) {
	gchar* result = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* element;
	gchar* _tmp3_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "friendlyName", NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	element = _tmp2_;
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (element != NULL, "element != null");
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = xmlNodeGetContent (element);
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp3_;
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 303 "rygel-description-file.c"
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the service version, e.g. old_type =
     * "ContentDirectory:2" and new_type = "ContentDirectory:1".
     *
     * @param old_type is the current content of serviceType.
     * @param new_type is the content serviceType will be set to.
     */
void description_file_modify_service_type (DescriptionFile* self, const gchar* old_type, const gchar* new_type) {
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlXPathContext* _tmp2_;
	xmlXPathContext* context;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* xpath;
	xmlXPathObject* _tmp5_ = NULL;
	xmlXPathObject* xpath_object;
	xmlXPathObjectType _tmp6_;
	xmlNodeSet* _tmp7_;
	gboolean _tmp8_ = FALSE;
	xmlNodeSet* _tmp9_;
	xmlNode* _tmp10_ = NULL;
	const gchar* _tmp11_;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (old_type != NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (new_type != NULL);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = xmlXPathNewContext (_tmp1_);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	context = _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = old_type;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = g_strdup_printf (DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE, _tmp3_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xpath = _tmp4_;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = xmlXPathEvalExpression (xpath, context);
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xpath_object = _tmp5_;
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (xpath_object != NULL, "xpath_object != null");
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = xpath_object->type;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (_tmp6_ == XPATH_NODESET, "xpath_object->type == XPath.ObjectType.NODESET");
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = xpath_object->nodesetval;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = xmlXPathNodeSetIsEmpty (_tmp7_);
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (!_tmp8_, "!xpath_object->nodesetval->is_empty ()");
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = xpath_object->nodesetval;
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = xmlXPathNodeSetItem (_tmp9_, 0);
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = new_type;
#line 141 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNodeSetContent (_tmp10_, _tmp11_);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (xpath);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_xmlXPathFreeContext0 (context);
#line 380 "rygel-description-file.c"
}


/**
     * Writes the current document to a file.
     *
     * It makes sure that the resulting file has the correct UTF-8 encoding
     * and does not have any kind of newlines. This is necessary as some
     * devices with broken XML parsers can't cope with UNIX newlines.
     * If a file with the same name exists it will be overwritten.
     *
     * @param path is a path to a file.
     * @throws GLib.Error if anything fails while creating the XML dump.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 404 "rygel-description-file.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 434 "rygel-description-file.c"
				goto __catch1_g_regex_error;
			}
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 443 "rygel-description-file.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 459 "rygel-description-file.c"
				goto __catch1_g_regex_error;
			}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 470 "rygel-description-file.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 478 "rygel-description-file.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1233 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 492 "rygel-description-file.c"
	}
	__finally1:
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return NULL;
#line 503 "rygel-description-file.c"
	}
}


void description_file_save (DescriptionFile* self, const gchar* path, GError** error) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* file;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* message;
	FILE* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gchar* mem;
	gint len;
	GUPnPXMLDoc* _tmp9_;
	xmlDoc* _tmp10_;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	FILE* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (path != NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = path;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = fopen (_tmp0_, "w+");
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	file = _tmp1_;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = _ ("Failed to write modified description to %s");
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	message = _tmp3_;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = file;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = G_UNLIKELY (_tmp4_ == NULL);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp5_) {
#line 552 "rygel-description-file.c"
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = message;
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = path;
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp6_, _tmp7_);
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_inner_error_ = _tmp8_;
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (message);
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_fclose0 (file);
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 572 "rygel-description-file.c"
	}
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	mem = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	len = -1;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = self->priv->doc;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = _tmp9_->doc;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlDocDumpMemoryEnc (_tmp10_, &_tmp11_, &_tmp12_, "UTF-8");
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (mem);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	mem = _tmp11_;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	len = _tmp12_;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = len;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = G_UNLIKELY (_tmp13_ <= 0);
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp14_) {
#line 596 "rygel-description-file.c"
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp15_ = message;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp16_ = path;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp17_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp15_, _tmp16_);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_inner_error_ = _tmp17_;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (mem);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (message);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_fclose0 (file);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 618 "rygel-description-file.c"
	}
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = file;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp19_ = mem;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp20_ = string_replace (_tmp19_, "\n", "");
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp21_ = _tmp20_;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	fputs (_tmp21_, _tmp18_);
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp21_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (mem);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (message);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_fclose0 (file);
#line 638 "rygel-description-file.c"
}


/**
     * Internal helper function to set an element to a new value.
     *
     * @param element below /root/device to be set.
     * @param new_vale is the new content of that element.
     */
static void description_file_set_device_element (DescriptionFile* self, const gchar* element, const gchar* new_value) {
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	const gchar* _tmp2_;
	xmlNode* _tmp3_ = NULL;
	xmlNode* xml_element;
	const gchar* _tmp4_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (element != NULL);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (new_value != NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = element;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_element = _tmp3_;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (xml_element != NULL, "xml_element != null");
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = new_value;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNodeSetContent (xml_element, _tmp4_);
#line 677 "rygel-description-file.c"
}


static void description_file_class_init (DescriptionFileClass * klass) {
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	description_file_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_type_class_add_private (klass, sizeof (DescriptionFilePrivate));
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	G_OBJECT_CLASS (klass)->finalize = description_file_finalize;
#line 688 "rygel-description-file.c"
}


static void description_file_instance_init (DescriptionFile * self) {
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv = DESCRIPTION_FILE_GET_PRIVATE (self);
#line 695 "rygel-description-file.c"
}


static void description_file_finalize (GObject* obj) {
	DescriptionFile * self;
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESCRIPTION_FILE, DescriptionFile);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	G_OBJECT_CLASS (description_file_parent_class)->finalize (obj);
#line 707 "rygel-description-file.c"
}


/**
 * Represents a device description document and offers methods for easy
 * manipulation of those.
 */
GType description_file_get_type (void) {
	static volatile gsize description_file_type_id__volatile = 0;
	if (g_once_init_enter (&description_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DescriptionFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) description_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DescriptionFile), 0, (GInstanceInitFunc) description_file_instance_init, NULL };
		GType description_file_type_id;
		description_file_type_id = g_type_register_static (G_TYPE_OBJECT, "DescriptionFile", &g_define_type_info, 0);
		g_once_init_leave (&description_file_type_id__volatile, description_file_type_id);
	}
	return description_file_type_id__volatile;
}



