/* rygel-http-response.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-http-response.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gst/base/gstbasesink.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;

#define RYGEL_TYPE_HTTP_GST_SINK (rygel_http_gst_sink_get_type ())
#define RYGEL_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSink))
#define RYGEL_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))
#define RYGEL_IS_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_IS_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_HTTP_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))

typedef struct _RygelHTTPGstSink RygelHTTPGstSink;
typedef struct _RygelHTTPGstSinkClass RygelHTTPGstSinkClass;
typedef struct _RygelHTTPGstSinkPrivate RygelHTTPGstSinkPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelHTTPResponsePrivate {
	SoupServer* _server;
	GCancellable* _cancellable;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gint _priority;
	GstPipeline* pipeline;
	guint bus_watch_id;
	gboolean unref_soup_server;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	gboolean _tmp0_;
	RygelHTTPSeek* _tmp1_;
	RygelHTTPSeek* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gboolean _tmp5_;
	GstPipeline* _tmp6_;
	GstPipeline* _tmp7_;
};

struct _RygelHTTPGstSink {
	GstBaseSink parent_instance;
	RygelHTTPGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;

GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_SERVER,
	RYGEL_HTTP_RESPONSE_CANCELLABLE,
	RYGEL_HTTP_RESPONSE_PRIORITY
};
SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self);
static void rygel_http_response_on_server_weak_ref (RygelHTTPResponse* self, GObject* object);
static void _rygel_http_response_on_server_weak_ref_gweak_notify (gpointer self, GObject* object);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
static void rygel_http_response_set_server (RygelHTTPResponse* self, SoupServer* value);
GCancellable* rygel_http_get_handler_get_cancellable (RygelHTTPGetHandler* self);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
static void rygel_http_response_on_cancelled (RygelHTTPResponse* self, GCancellable* cancellable);
static void _rygel_http_response_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_http_response_prepare_pipeline (RygelHTTPResponse* self, const gchar* name, GstElement* src, GError** error);
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void rygel_http_response_real_end (RygelHTTPResponse* self, gboolean aborted, guint status);
#define RYGEL_HTTP_GST_SINK_NAME "http-gst-sink"
GType rygel_http_gst_sink_get_type (void) G_GNUC_CONST;
RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response);
RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response);
static void rygel_http_response_src_pad_added (RygelHTTPResponse* self, GstElement* src, GstPad* src_pad);
static void _rygel_http_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
GQuark rygel_gst_error_quark (void);
static gboolean rygel_http_response_bus_handler (RygelHTTPResponse* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_http_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static inline void _dynamic_set_streamable2 (GstElement* obj, gboolean value);
static inline void _dynamic_set_fragment_duration3 (GstElement* obj, gint value);
static gboolean rygel_http_response_perform_seek (RygelHTTPResponse* self);
gint rygel_http_response_get_priority (RygelHTTPResponse* self);
static gboolean ___lambda11_ (RygelHTTPResponse* self);
static gboolean ____lambda11__gsource_func (gpointer self);
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_http_response_on_server_weak_ref_gweak_notify (gpointer self, GObject* object) {
	rygel_http_response_on_server_weak_ref (self, object);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_http_response_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	rygel_http_response_on_cancelled (self, _sender);
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPGet* _tmp0_;
	SoupServer* _tmp1_;
	RygelHTTPGet* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	RygelHTTPGetHandler* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelHTTPGet* _tmp8_;
	RygelHTTPSeek* _tmp9_;
	RygelHTTPSeek* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	SoupMessage* _tmp15_;
	SoupMessageBody* _tmp16_;
	GstElement* _tmp17_;
	SoupServer* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (request_handler != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->server;
	rygel_http_response_set_server (self, _tmp1_);
	_tmp2_ = request;
	_tmp3_ = ((RygelHTTPRequest*) _tmp2_)->msg;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->msg);
	self->msg = _tmp4_;
	_tmp5_ = request_handler;
	_tmp6_ = rygel_http_get_handler_get_cancellable (_tmp5_);
	_tmp7_ = _tmp6_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp7_);
	_tmp8_ = request;
	_tmp9_ = _tmp8_->seek;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->seek);
	self->seek = _tmp10_;
	_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		GCancellable* _tmp13_;
		GCancellable* _tmp14_;
		_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp14_ = _tmp13_;
		g_signal_connect_object (_tmp14_, "cancelled", (GCallback) _rygel_http_response_on_cancelled_g_cancellable_cancelled, self, 0);
	}
	_tmp15_ = self->msg;
	_tmp16_ = _tmp15_->response_body;
	soup_message_body_set_accumulate (_tmp16_, FALSE);
	_tmp17_ = src;
	rygel_http_response_prepare_pipeline (self, "RygelHTTPGstResponse", _tmp17_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp18_ = self->priv->_server;
	g_object_weak_ref ((GObject*) _tmp18_, _rygel_http_response_on_server_weak_ref_gweak_notify, self);
	self->priv->unref_soup_server = TRUE;
	return self;
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error) {
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, request, request_handler, src, error);
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpResponseRunData, _data_);
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_;
	self = (RygelHTTPResponse*) base;
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_response_real_run_co (_data_);
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
	return result;
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->seek;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->seek;
		_data_->_tmp3_ = rygel_http_seek_get_start (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = _data_->_tmp4_ > ((gint64) 0);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp0_;
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = _data_->self->priv->pipeline;
		gst_element_set_state ((GstElement*) _data_->_tmp6_, GST_STATE_PAUSED);
	} else {
		_data_->_tmp7_ = _data_->self->priv->pipeline;
		gst_element_set_state ((GstElement*) _data_->_tmp7_, GST_STATE_PLAYING);
	}
	(_data_->self->priv->run_continue_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->run_continue_target_destroy_notify (_data_->self->priv->run_continue_target), NULL);
	_data_->self->priv->run_continue = NULL;
	_data_->self->priv->run_continue_target = NULL;
	_data_->self->priv->run_continue_target_destroy_notify = NULL;
	_data_->self->priv->run_continue = _rygel_http_response_real_run_co_gsource_func;
	_data_->self->priv->run_continue_target = _data_;
	_data_->self->priv->run_continue_target_destroy_notify = NULL;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1) {
	SoupMessage* _tmp0_;
	SoupMessageBody* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	SoupServer* _tmp3_;
	SoupMessage* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->msg;
	_tmp1_ = _tmp0_->response_body;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	soup_message_body_append (_tmp1_, SOUP_MEMORY_COPY, _tmp2_, (gsize) _tmp2__length1);
	_tmp3_ = self->priv->_server;
	_tmp4_ = self->msg;
	soup_server_unpause_message (_tmp3_, _tmp4_);
}


static void rygel_http_response_real_end (RygelHTTPResponse* self, gboolean aborted, guint status) {
	GstPipeline* _tmp0_;
	GstElement* _tmp1_ = NULL;
	RygelHTTPGstSink* sink;
	RygelHTTPGstSink* _tmp2_;
	GCancellable* _tmp3_;
	GstPipeline* _tmp4_;
	guint _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessageHeaders* _tmp7_;
	SoupEncoding _tmp8_ = 0;
	SoupEncoding encoding;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp12_;
	GSourceFunc _tmp17_;
	void* _tmp17__target;
	guint _tmp19_;
	_tmp0_ = self->priv->pipeline;
	_tmp1_ = gst_bin_get_by_name ((GstBin*) _tmp0_, RYGEL_HTTP_GST_SINK_NAME);
	sink = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_GST_SINK) ? ((RygelHTTPGstSink*) _tmp1_) : NULL;
	_tmp2_ = sink;
	_tmp3_ = _tmp2_->cancellable;
	g_cancellable_cancel (_tmp3_);
	_tmp4_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_NULL);
	_tmp5_ = self->priv->bus_watch_id;
	g_source_remove (_tmp5_);
	_tmp6_ = self->msg;
	_tmp7_ = _tmp6_->response_headers;
	_tmp8_ = soup_message_headers_get_encoding (_tmp7_);
	encoding = _tmp8_;
	_tmp10_ = aborted;
	if (!_tmp10_) {
		SoupEncoding _tmp11_;
		_tmp11_ = encoding;
		_tmp9_ = _tmp11_ != SOUP_ENCODING_CONTENT_LENGTH;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp12_ = _tmp9_;
	if (_tmp12_) {
		SoupMessage* _tmp13_;
		SoupMessageBody* _tmp14_;
		SoupServer* _tmp15_;
		SoupMessage* _tmp16_;
		_tmp13_ = self->msg;
		_tmp14_ = _tmp13_->response_body;
		soup_message_body_complete (_tmp14_);
		_tmp15_ = self->priv->_server;
		_tmp16_ = self->msg;
		soup_server_unpause_message (_tmp15_, _tmp16_);
	}
	_tmp17_ = self->priv->run_continue;
	_tmp17__target = self->priv->run_continue_target;
	if (_tmp17_ != NULL) {
		GSourceFunc _tmp18_;
		void* _tmp18__target;
		_tmp18_ = self->priv->run_continue;
		_tmp18__target = self->priv->run_continue_target;
		_tmp18_ (_tmp18__target);
	}
	_tmp19_ = status;
	if (_tmp19_ != ((guint) SOUP_STATUS_NONE)) {
		SoupMessage* _tmp20_;
		guint _tmp21_;
		_tmp20_ = self->msg;
		_tmp21_ = status;
		soup_message_set_status (_tmp20_, _tmp21_);
	}
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_gst_object_unref0 (sink);
}


void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status) {
	g_return_if_fail (self != NULL);
	RYGEL_HTTP_RESPONSE_GET_CLASS (self)->end (self, aborted, status);
}


static void rygel_http_response_on_cancelled (RygelHTTPResponse* self, GCancellable* cancellable) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	rygel_http_response_end (self, TRUE, (guint) SOUP_STATUS_CANCELLED);
}


static void rygel_http_response_on_server_weak_ref (RygelHTTPResponse* self, GObject* object) {
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	self->priv->unref_soup_server = FALSE;
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	g_cancellable_cancel (_tmp1_);
}


static void _rygel_http_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	rygel_http_response_src_pad_added (self, _sender, pad);
}


static gboolean _rygel_http_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_http_response_bus_handler (self, bus, message);
	return result;
}


static void rygel_http_response_prepare_pipeline (RygelHTTPResponse* self, const gchar* name, GstElement* src, GError** error) {
	RygelHTTPGstSink* _tmp0_;
	RygelHTTPGstSink* sink;
	const gchar* _tmp1_;
	GstPipeline* _tmp2_;
	GstPipeline* _tmp3_;
	GstPipeline* _tmp4_;
	GstElement* _tmp5_;
	RygelHTTPGstSink* _tmp6_;
	GstElement* _tmp7_;
	guint16 _tmp8_;
	GstPipeline* _tmp24_;
	GstBus* _tmp25_ = NULL;
	GstBus* bus;
	GstBus* _tmp26_;
	guint _tmp27_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = rygel_http_gst_sink_new (self);
	gst_object_ref_sink (_tmp0_);
	sink = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = (GstPipeline*) gst_pipeline_new (_tmp1_);
	gst_object_ref_sink (_tmp2_);
	_gst_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	_tmp3_ = self->priv->pipeline;
	_vala_assert (_tmp3_ != NULL, "this.pipeline != null");
	_tmp4_ = self->priv->pipeline;
	_tmp5_ = src;
	_tmp6_ = sink;
	gst_bin_add_many ((GstBin*) _tmp4_, _tmp5_, (GstElement*) _tmp6_, NULL);
	_tmp7_ = src;
	_tmp8_ = _tmp7_->numsrcpads;
	if (((gint) _tmp8_) == 0) {
		GstElement* _tmp9_;
		_tmp9_ = src;
		g_signal_connect_object (_tmp9_, "pad-added", (GCallback) _rygel_http_response_src_pad_added_gst_element_pad_added, self, 0);
	} else {
		GstElement* _tmp10_;
		RygelHTTPGstSink* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp10_ = src;
		_tmp11_ = sink;
		_tmp12_ = gst_element_link (_tmp10_, (GstElement*) _tmp11_);
		if (!_tmp12_) {
			const gchar* _tmp13_ = NULL;
			GstElement* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			RygelHTTPGstSink* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			GError* _tmp22_;
			GError* _tmp23_;
			_tmp13_ = _ ("Failed to link %s to %s");
			_tmp14_ = src;
			_tmp15_ = gst_object_get_name ((GstObject*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			_tmp18_ = sink;
			_tmp19_ = gst_object_get_name ((GstObject*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_;
			_tmp22_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _tmp13_, _tmp17_, _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_inner_error_ = _tmp23_;
			g_propagate_error (error, _inner_error_);
			_gst_object_unref0 (sink);
			return;
		}
	}
	_tmp24_ = self->priv->pipeline;
	_tmp25_ = gst_pipeline_get_bus (_tmp24_);
	bus = _tmp25_;
	_tmp26_ = bus;
	_tmp27_ = gst_bus_add_watch_full (_tmp26_, G_PRIORITY_DEFAULT, _rygel_http_response_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	self->priv->bus_watch_id = _tmp27_;
	_gst_object_unref0 (bus);
	_gst_object_unref0 (sink);
}


static void rygel_http_response_src_pad_added (RygelHTTPResponse* self, GstElement* src, GstPad* src_pad) {
	GstPad* _tmp0_;
	GstCaps* _tmp1_ = NULL;
	GstCaps* caps;
	GstPipeline* _tmp2_;
	GstElement* _tmp3_ = NULL;
	GstElement* sink;
	GstPad* sink_pad = NULL;
	GstCaps* _tmp4_;
	GstElement* _tmp5_ = NULL;
	GstElement* depay;
	GstElement* _tmp6_;
	GstPad* _tmp29_;
	GstPad* _tmp30_;
	GstPadLinkReturn _tmp31_ = 0;
	GstElement* _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (src_pad != NULL);
	_tmp0_ = src_pad;
	_tmp1_ = gst_pad_get_caps_reffed (_tmp0_);
	caps = _tmp1_;
	_tmp2_ = self->priv->pipeline;
	_tmp3_ = gst_bin_get_by_name ((GstBin*) _tmp2_, RYGEL_HTTP_GST_SINK_NAME);
	sink = _tmp3_;
	_tmp4_ = caps;
	_tmp5_ = rygel_gst_utils_get_rtp_depayloader (_tmp4_);
	depay = _tmp5_;
	_tmp6_ = depay;
	if (_tmp6_ != NULL) {
		GstPipeline* _tmp7_;
		GstElement* _tmp8_;
		GstElement* _tmp9_;
		GstElement* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GstElement* _tmp21_;
		GstPad* _tmp22_;
		GstCaps* _tmp23_;
		GstPad* _tmp24_ = NULL;
		_tmp7_ = self->priv->pipeline;
		_tmp8_ = depay;
		gst_bin_add ((GstBin*) _tmp7_, _tmp8_);
		_tmp9_ = depay;
		_tmp10_ = sink;
		_tmp11_ = gst_element_link (_tmp9_, _tmp10_);
		if (!_tmp11_) {
			const gchar* _tmp12_ = NULL;
			GstElement* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GstElement* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp12_ = _ ("Failed to link %s to %s");
			_tmp13_ = depay;
			_tmp14_ = gst_object_get_name ((GstObject*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = sink;
			_tmp18_ = gst_object_get_name ((GstObject*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			g_critical (_tmp12_, _tmp16_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp16_);
			rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
			_gst_object_unref0 (depay);
			_gst_object_unref0 (sink_pad);
			_gst_object_unref0 (sink);
			_gst_caps_unref0 (caps);
			return;
		}
		_tmp21_ = depay;
		_tmp22_ = src_pad;
		_tmp23_ = caps;
		_tmp24_ = gst_element_get_compatible_pad (_tmp21_, _tmp22_, _tmp23_);
		_gst_object_unref0 (sink_pad);
		sink_pad = _tmp24_;
	} else {
		GstElement* _tmp25_;
		GstPad* _tmp26_;
		GstCaps* _tmp27_;
		GstPad* _tmp28_ = NULL;
		_tmp25_ = sink;
		_tmp26_ = src_pad;
		_tmp27_ = caps;
		_tmp28_ = gst_element_get_compatible_pad (_tmp25_, _tmp26_, _tmp27_);
		_gst_object_unref0 (sink_pad);
		sink_pad = _tmp28_;
	}
	_tmp29_ = src_pad;
	_tmp30_ = sink_pad;
	_tmp31_ = gst_pad_link (_tmp29_, _tmp30_);
	if (_tmp31_ != GST_PAD_LINK_OK) {
		const gchar* _tmp32_ = NULL;
		GstPad* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GstPad* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp32_ = _ ("Failed to link pad %s to %s");
		_tmp33_ = src_pad;
		_tmp34_ = gst_object_get_name ((GstObject*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _tmp35_;
		_tmp37_ = sink_pad;
		_tmp38_ = gst_object_get_name ((GstObject*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp39_;
		g_critical (_tmp32_, _tmp36_, _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp36_);
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
		_gst_object_unref0 (depay);
		_gst_object_unref0 (sink_pad);
		_gst_object_unref0 (sink);
		_gst_caps_unref0 (caps);
		return;
	}
	_tmp41_ = depay;
	if (_tmp41_ != NULL) {
		GstElement* _tmp42_;
		_tmp42_ = depay;
		gst_element_sync_state_with_parent (_tmp42_);
	}
	_gst_object_unref0 (depay);
	_gst_object_unref0 (sink_pad);
	_gst_object_unref0 (sink);
	_gst_caps_unref0 (caps);
}


static inline void _dynamic_set_streamable2 (GstElement* obj, gboolean value) {
	g_object_set (obj, "streamable", value, NULL);
}


static inline void _dynamic_set_fragment_duration3 (GstElement* obj, gint value) {
	g_object_set (obj, "fragment-duration", value, NULL);
}


static gboolean ___lambda11_ (RygelHTTPResponse* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
	if (!_tmp2_) {
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
	}
	result = FALSE;
	return result;
}


static gboolean ____lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda11_ (self);
	return result;
}


static gboolean rygel_http_response_bus_handler (RygelHTTPResponse* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean ret;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	gboolean _tmp58_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	ret = TRUE;
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == GST_MESSAGE_EOS) {
		ret = FALSE;
	} else {
		GstMessage* _tmp2_;
		GstMessageType _tmp3_;
		_tmp2_ = message;
		_tmp3_ = _tmp2_->type;
		if (_tmp3_ == GST_MESSAGE_STATE_CHANGED) {
			GstMessage* _tmp4_;
			GstObject* _tmp5_;
			GstPipeline* _tmp6_;
			GstState old_state = 0;
			GstState new_state = 0;
			GstMessage* _tmp7_;
			GstState _tmp8_ = 0;
			GstState _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			GstState _tmp11_;
			gboolean _tmp13_;
			gboolean _tmp24_ = FALSE;
			RygelHTTPSeek* _tmp25_;
			gboolean _tmp29_;
			_tmp4_ = message;
			_tmp5_ = _tmp4_->src;
			_tmp6_ = self->priv->pipeline;
			if (_tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GST_TYPE_OBJECT, GstObject)) {
				result = TRUE;
				return result;
			}
			_tmp7_ = message;
			gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, NULL);
			old_state = _tmp8_;
			new_state = _tmp9_;
			_tmp11_ = old_state;
			if (_tmp11_ == GST_STATE_NULL) {
				GstState _tmp12_;
				_tmp12_ = new_state;
				_tmp10_ = _tmp12_ == GST_STATE_READY;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp13_ = _tmp10_;
			if (_tmp13_) {
				GstPipeline* _tmp14_;
				GstElement* _tmp15_ = NULL;
				GstElement* element;
				GstElement* _tmp16_;
				_tmp14_ = self->priv->pipeline;
				_tmp15_ = gst_bin_get_by_name ((GstBin*) _tmp14_, "muxer");
				element = _tmp15_;
				_tmp16_ = element;
				if (_tmp16_ != NULL) {
					GstElement* _tmp17_;
					GstElementFactory* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gchar* name;
					const gchar* _tmp21_;
					_tmp17_ = element;
					_tmp18_ = gst_element_get_factory (_tmp17_);
					_tmp19_ = gst_plugin_feature_get_name ((GstPluginFeature*) _tmp18_);
					_tmp20_ = g_strdup (_tmp19_);
					name = _tmp20_;
					_tmp21_ = name;
					if (g_strcmp0 (_tmp21_, "mp4mux") == 0) {
						GstElement* _tmp22_;
						GstElement* _tmp23_;
						_tmp22_ = element;
						_dynamic_set_streamable2 (_tmp22_, TRUE);
						_tmp23_ = element;
						_dynamic_set_fragment_duration3 (_tmp23_, 1000);
					}
					_g_free0 (name);
				}
				_gst_object_unref0 (element);
			}
			_tmp25_ = self->seek;
			if (_tmp25_ != NULL) {
				RygelHTTPSeek* _tmp26_;
				gint64 _tmp27_;
				gint64 _tmp28_;
				_tmp26_ = self->seek;
				_tmp27_ = rygel_http_seek_get_start (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp24_ = _tmp28_ > ((gint64) 0);
			} else {
				_tmp24_ = FALSE;
			}
			_tmp29_ = _tmp24_;
			if (_tmp29_) {
				gboolean _tmp30_ = FALSE;
				GstState _tmp31_;
				gboolean _tmp33_;
				_tmp31_ = old_state;
				if (_tmp31_ == GST_STATE_READY) {
					GstState _tmp32_;
					_tmp32_ = new_state;
					_tmp30_ = _tmp32_ == GST_STATE_PAUSED;
				} else {
					_tmp30_ = FALSE;
				}
				_tmp33_ = _tmp30_;
				if (_tmp33_) {
					gboolean _tmp34_ = FALSE;
					_tmp34_ = rygel_http_response_perform_seek (self);
					if (_tmp34_) {
						GstPipeline* _tmp35_;
						_tmp35_ = self->priv->pipeline;
						gst_element_set_state ((GstElement*) _tmp35_, GST_STATE_PLAYING);
					}
				}
			}
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			GstMessage* _tmp36_;
			GstMessageType _tmp37_;
			_tmp36_ = message;
			_tmp37_ = _tmp36_->type;
			if (_tmp37_ == GST_MESSAGE_ERROR) {
				GstMessage* _tmp38_;
				GError* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				GstPipeline* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp38_ = message;
				gst_message_parse_error (_tmp38_, &_tmp39_, &_tmp40_);
				_g_error_free0 (err);
				err = _tmp39_;
				_g_free0 (err_msg);
				err_msg = _tmp40_;
				_tmp41_ = _ ("Error from pipeline %s: %s");
				_tmp42_ = self->priv->pipeline;
				_tmp43_ = gst_object_get_name ((GstObject*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = _tmp44_;
				_tmp46_ = err_msg;
				g_critical (_tmp41_, _tmp45_, _tmp46_);
				_g_free0 (_tmp45_);
				ret = FALSE;
			} else {
				GstMessage* _tmp47_;
				GstMessageType _tmp48_;
				_tmp47_ = message;
				_tmp48_ = _tmp47_->type;
				if (_tmp48_ == GST_MESSAGE_WARNING) {
					GstMessage* _tmp49_;
					GError* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					const gchar* _tmp52_ = NULL;
					GstPipeline* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					const gchar* _tmp57_;
					_tmp49_ = message;
					gst_message_parse_warning (_tmp49_, &_tmp50_, &_tmp51_);
					_g_error_free0 (err);
					err = _tmp50_;
					_g_free0 (err_msg);
					err_msg = _tmp51_;
					_tmp52_ = _ ("Warning from pipeline %s: %s");
					_tmp53_ = self->priv->pipeline;
					_tmp54_ = gst_object_get_name ((GstObject*) _tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = _tmp55_;
					_tmp57_ = err_msg;
					g_warning (_tmp52_, _tmp56_, _tmp57_);
					_g_free0 (_tmp56_);
				}
			}
			_g_free0 (err_msg);
			_g_error_free0 (err);
		}
	}
	_tmp58_ = ret;
	if (!_tmp58_) {
		gint _tmp59_;
		gint _tmp60_;
		_tmp59_ = rygel_http_response_get_priority (self);
		_tmp60_ = _tmp59_;
		g_idle_add_full (_tmp60_, ____lambda11__gsource_func, g_object_ref (self), g_object_unref);
	}
	result = ret;
	return result;
}


static gboolean rygel_http_response_perform_seek (RygelHTTPResponse* self) {
	gboolean result = FALSE;
	GstSeekType stop_type;
	GstFormat format = 0;
	RygelHTTPSeek* _tmp0_;
	RygelHTTPSeek* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	GstPipeline* _tmp4_;
	GstFormat _tmp5_;
	RygelHTTPSeek* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	GstSeekType _tmp9_;
	RygelHTTPSeek* _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	stop_type = GST_SEEK_TYPE_NONE;
	_tmp0_ = self->seek;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_HTTP_TIME_SEEK)) {
		format = GST_FORMAT_TIME;
	} else {
		format = GST_FORMAT_BYTES;
	}
	_tmp1_ = self->seek;
	_tmp2_ = rygel_http_seek_get_stop (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > ((gint64) 0)) {
		stop_type = GST_SEEK_TYPE_SET;
	}
	_tmp4_ = self->priv->pipeline;
	_tmp5_ = format;
	_tmp6_ = self->seek;
	_tmp7_ = rygel_http_seek_get_start (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = stop_type;
	_tmp10_ = self->seek;
	_tmp11_ = rygel_http_seek_get_stop (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gst_element_seek ((GstElement*) _tmp4_, 1.0, _tmp5_, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, _tmp8_, _tmp9_, _tmp12_ + 1);
	if (!_tmp13_) {
		const gchar* _tmp14_ = NULL;
		RygelHTTPSeek* _tmp15_;
		gint64 _tmp16_;
		gint64 _tmp17_;
		_tmp14_ = _ ("Failed to seek to offset %lld");
		_tmp15_ = self->seek;
		_tmp16_ = rygel_http_seek_get_start (_tmp15_);
		_tmp17_ = _tmp16_;
		g_warning (_tmp14_, _tmp17_);
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self) {
	SoupServer* result;
	SoupServer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_server;
	result = _tmp0_;
	return result;
}


static void rygel_http_response_set_server (RygelHTTPResponse* self, SoupServer* value) {
	SoupServer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_server = _tmp0_;
	g_object_notify ((GObject *) self, "server");
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPResponse*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelHTTPResponse*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


gint rygel_http_response_get_priority (RygelHTTPResponse* self) {
	gint result;
	gint _tmp0_;
	SoupMessage* _tmp2_;
	SoupMessageHeaders* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* mode;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp9_;
	gint _tmp12_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_priority;
	if (_tmp0_ != (-1)) {
		gint _tmp1_;
		_tmp1_ = self->priv->_priority;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->msg;
	_tmp3_ = _tmp2_->request_headers;
	_tmp4_ = soup_message_headers_get_one (_tmp3_, "transferMode.dlna.org");
	_tmp5_ = g_strdup (_tmp4_);
	mode = _tmp5_;
	_tmp7_ = mode;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = mode;
		_tmp6_ = g_strcmp0 (_tmp8_, "Interactive") == 0;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		self->priv->_priority = G_PRIORITY_DEFAULT;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = mode;
		if (g_strcmp0 (_tmp10_, "Streaming") == 0) {
			self->priv->_priority = G_PRIORITY_HIGH;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = mode;
			if (g_strcmp0 (_tmp11_, "Background") == 0) {
				self->priv->_priority = G_PRIORITY_LOW;
			} else {
				self->priv->_priority = G_PRIORITY_DEFAULT;
			}
		}
	}
	_tmp12_ = self->priv->_priority;
	result = _tmp12_;
	_g_free0 (mode);
	return result;
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
	RYGEL_HTTP_RESPONSE_CLASS (klass)->end = rygel_http_response_real_end;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_SERVER, g_param_spec_object ("server", "server", "server", soup_server_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_PRIORITY, g_param_spec_int ("priority", "priority", "priority", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
	iface->run_finish = rygel_http_response_real_run_finish;
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
	self->priv->_priority = -1;
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	gboolean _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
	_tmp0_ = self->priv->unref_soup_server;
	if (_tmp0_) {
		SoupServer* _tmp1_;
		_tmp1_ = self->priv->_server;
		g_object_weak_unref ((GObject*) _tmp1_, _rygel_http_response_on_server_weak_ref_gweak_notify, self);
	}
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->seek);
	(self->priv->run_continue_target_destroy_notify == NULL) ? NULL : (self->priv->run_continue_target_destroy_notify (self->priv->run_continue_target), NULL);
	self->priv->run_continue = NULL;
	self->priv->run_continue_target = NULL;
	self->priv->run_continue_target_destroy_notify = NULL;
	_gst_object_unref0 (self->priv->pipeline);
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_SERVER:
		g_value_set_object (value, rygel_http_response_get_server (self));
		break;
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		case RYGEL_HTTP_RESPONSE_PRIORITY:
		g_value_set_int (value, rygel_http_response_get_priority (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_SERVER:
		rygel_http_response_set_server (self, g_value_get_object (value));
		break;
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



