/**
 * SECTION:rygel-playbin-renderer
 * @short_description: Convert a GStreamer Playbin2 element into an UPnP renderer.
 * 
 * <para>Using Playbin2 as a model it reflects any changes done externally, such as changing the currently played URI, volume, pause/play etc. to UPnP.</para><para>Likewise the playbin can be modified externally using UPnP.</para>
 */
/**
 * RYGEL_PLAYBIN_TYPE_RENDERER
 * 
 * The type for <link linkend="RygelPlaybinRenderer"><type>RygelPlaybinRenderer</type></link>.
 */
/**
 * rygel_playbin_renderer_new
 * @title: (in): Friendly name of the new UPnP renderer on the network. 
 * 
 * Create a new instance of Renderer.
 * 
 * <para>Renderer will instanciate its own instance of playbin. The Playbin can be accessed by using Player.get_default().playbin</para>
 */
/**
 * rygel_playbin_renderer_new_wrap
 * @pipeline: (in): Instance of Gst.PlayBin2 to wrap. 
 * @title: (in): Friendly name of the new UPnP renderer on the network. 
 * 
 * Create a new instance of Renderer, wrapping an existing playbin instance.
 */
/**
 * RygelPlaybinRenderer
 * 
 * Convert a GStreamer Playbin2 element into an UPnP renderer.
 * 
 * <para>Using Playbin2 as a model it reflects any changes done externally, such as changing the currently played URI, volume, pause/play etc. to UPnP.</para><para>Likewise the playbin can be modified externally using UPnP.</para>
 */
