/* rygel-http-response-test.c generated by valac 0.17.0.12-8e4ca, the Vala compiler
 * generated from rygel-http-response-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_HTTP_RESPONSE_TEST (rygel_http_response_test_get_type ())
#define RYGEL_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTest))
#define RYGEL_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))
#define RYGEL_IS_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_IS_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_HTTP_RESPONSE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))

typedef struct _RygelHTTPResponseTest RygelHTTPResponseTest;
typedef struct _RygelHTTPResponseTestClass RygelHTTPResponseTestClass;
typedef struct _RygelHTTPResponseTestPrivate RygelHTTPResponseTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_media_item_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_item_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;
typedef struct _RygelHTTPByteSeekPrivate RygelHTTPByteSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelParamSpecMediaItem RygelParamSpecMediaItem;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPResponseTest {
	GObject parent_instance;
	RygelHTTPResponseTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
	GCancellable* cancellable;
};

struct _RygelHTTPResponseTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponseTest* self, GError** error);
};

struct _RygelHTTPResponseTestPrivate {
	gboolean server_done;
	gboolean client_done;
	RygelMediaItem* item;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
	gsize total_bytes;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gsize bytes_received;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	SoupMessage* _tmp0_;
	GUPnPContext* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
};

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
};

struct _RygelHTTPSeekPrivate {
	gint64 _start;
	gint64 _stop;
	gint64 _length;
	gint64 _total_length;
};

struct _RygelHTTPByteSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPByteSeekPrivate * priv;
};

struct _RygelHTTPByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupServer* server;
	SoupMessage* msg;
	GCancellable* cancellable;
	RygelMediaItem* item;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaItem *self);
};

struct _RygelMediaItemPrivate {
	GstElement* src;
};

struct _RygelParamSpecMediaItem {
	GParamSpec parent_instance;
};


static gpointer rygel_http_response_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_http_seek_parent_class = NULL;
static gpointer rygel_http_byte_seek_parent_class = NULL;
static gpointer rygel_http_time_seek_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
gpointer rygel_media_item_ref (gpointer instance);
void rygel_media_item_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_item (GValue* value, gpointer v_object);
void rygel_value_take_media_item (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_item (const GValue* value);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestPrivate))
enum  {
	RYGEL_HTTP_RESPONSE_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES ((glong) 102400)
gint rygel_http_response_test_main (gchar** args, int args_length1);
RygelHTTPResponseTest* rygel_http_response_test_new_complete (GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error);
void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_new_abort (GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_new (GCancellable* cancellable, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active);
RygelMediaItem* rygel_media_item_new_fixed_size (void);
RygelMediaItem* rygel_media_item_construct_fixed_size (GType object_type);
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error);
static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self);
static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client);
static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
static RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
RygelHTTPByteSeek* rygel_http_byte_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
RygelHTTPGet* rygel_http_get_new (SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable);
RygelHTTPGet* rygel_http_get_construct (GType object_type, SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
RygelHTTPGetHandler* rygel_http_get_handler_new (GCancellable* cancellable);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response);
static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_response_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable);
static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda2_ (Block1Data* _data1_, SoupMessage* msg, SoupBuffer* chunk);
static void ___lambda2__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void __lambda3_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda3__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_SEEK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekPrivate))
enum  {
	RYGEL_HTTP_SEEK_DUMMY_PROPERTY,
	RYGEL_HTTP_SEEK_START,
	RYGEL_HTTP_SEEK_STOP,
	RYGEL_HTTP_SEEK_LENGTH,
	RYGEL_HTTP_SEEK_TOTAL_LENGTH
};
RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
static void rygel_http_seek_finalize (GObject* obj);
static void _vala_rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_HTTP_BYTE_SEEK_DUMMY_PROPERTY
};
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
RygelHTTPTimeSeek* rygel_http_time_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
static void rygel_http_get_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
static void rygel_http_get_handler_finalize (GObject* obj);
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ITEM_BLOCK_SIZE ((RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES / 16) + 1)
#define RYGEL_MEDIA_ITEM_MAX_BUFFERS ((glong) 25)
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
static inline void _dynamic_set_sizetype0 (GstElement* obj, gint value);
static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value);
static inline void _dynamic_set_num_buffers2 (GstElement* obj, glong value);
static inline void _dynamic_set_sizemax3 (GstElement* obj, glong value);
static inline GstElement* _dynamic_get_num_buffers4 (GstElement* obj);
static void rygel_media_item_finalize (RygelMediaItem* obj);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


gint rygel_http_response_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	gst_init (&args_length1, &args);
#line 511 "rygel-http-response-test.c"
	{
		RygelHTTPResponseTest* _tmp0_;
		RygelHTTPResponseTest* test;
		RygelHTTPResponseTest* _tmp1_;
		RygelHTTPResponseTest* _tmp2_;
		RygelHTTPResponseTest* _tmp3_;
		RygelHTTPResponseTest* _tmp4_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = rygel_http_response_test_new_complete (&_inner_error_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		test = _tmp0_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 527 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = test;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_response_test_run (_tmp1_, &_inner_error_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (test);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 542 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = rygel_http_response_test_new_abort (&_inner_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = _tmp2_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (test);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 557 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (test);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		test = _tmp3_;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = test;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_response_test_run (_tmp4_, &_inner_error_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (test);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 576 "rygel-http-response-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (test);
#line 583 "rygel-http-response-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		gint _tmp6_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = _error_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp6_ = _tmp5_->code;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		result = _tmp6_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return result;
#line 605 "rygel-http-response-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = _error_;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = _tmp7_->message;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("rygel-http-response-test.vala:64: %s", _tmp8_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		result = -1;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return result;
#line 629 "rygel-http-response-test.c"
	}
	__finally0:
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_clear_error (&_inner_error_);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return 0;
#line 640 "rygel-http-response-test.c"
	}
#line 69 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = 0;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 646 "rygel-http-response-test.c"
}


int main (int argc, char ** argv) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_thread_init (NULL);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_init ();
#line 52 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_main (argv, argc);
#line 657 "rygel-http-response-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 664 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPServer* _tmp3_;
	RygelHTTPServer* _tmp4_;
	GUPnPContext* _tmp5_;
	RygelHTTPServer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GCancellable* _tmp10_;
	RygelHTTPClient* _tmp11_;
	GMainLoop* _tmp12_;
	GError * _inner_error_ = NULL;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPResponseTest*) g_object_new (object_type, NULL);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = cancellable;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->cancellable = _tmp1_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = rygel_http_server_new (&_inner_error_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = _tmp2_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 706 "rygel-http-response-test.c"
	}
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->server = _tmp3_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = self->server;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = _tmp4_->context;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = self->server;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = rygel_http_server_get_uri (_tmp6_);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = _tmp7_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _tmp8_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = cancellable;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = rygel_http_client_new (_tmp5_, _tmp9_, (gsize) RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES, _tmp10_ != NULL);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->client);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->client = _tmp11_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp9_);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = g_main_loop_new (NULL, FALSE);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->main_loop = _tmp12_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 742 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_new (GCancellable* cancellable, GError** error) {
#line 72 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_construct (RYGEL_TYPE_HTTP_RESPONSE_TEST, cancellable, error);
#line 749 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	RygelMediaItem* _tmp0_;
	GError * _inner_error_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, NULL, &_inner_error_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 767 "rygel-http-response-test.c"
	}
#line 86 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = rygel_media_item_new_fixed_size ();
#line 86 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->priv->item);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->item = _tmp0_;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 777 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_new_complete (GError** error) {
#line 83 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_construct_complete (RYGEL_TYPE_HTTP_RESPONSE_TEST, error);
#line 784 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	RygelMediaItem* _tmp2_;
	GError * _inner_error_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = g_cancellable_new ();
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, _tmp1_, &_inner_error_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (_tmp1_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 810 "rygel-http-response-test.c"
	}
#line 92 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = rygel_media_item_new ();
#line 92 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->priv->item);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->item = _tmp2_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 820 "rygel-http-response-test.c"
}


RygelHTTPResponseTest* rygel_http_response_test_new_abort (GError** error) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_response_test_construct_abort (RYGEL_TYPE_HTTP_RESPONSE_TEST, error);
#line 827 "rygel-http-response-test.c"
}


static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_test_on_timeout (self);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 836 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 97 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_message_received (self, _sender, message);
#line 843 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 98 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_message_aborted (self, _sender, message);
#line 850 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_client_completed (self, _sender);
#line 857 "rygel-http-response-test.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 110 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self ? g_error_copy (self) : NULL;
#line 864 "rygel-http-response-test.c"
}


static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error) {
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GCancellable* _tmp2_;
	RygelHTTPClient* _tmp4_;
	GMainLoop* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_response_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->server;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_object (_tmp0_, "message-received", (GCallback) _rygel_http_response_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = self->server;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_object (_tmp1_, "message-aborted", (GCallback) _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted, self, 0);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = self->cancellable;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp2_ == NULL) {
#line 890 "rygel-http-response-test.c"
		RygelHTTPClient* _tmp3_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = self->client;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_signal_connect_object ((RygelStateMachine*) _tmp3_, "completed", (GCallback) _rygel_http_response_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 896 "rygel-http-response-test.c"
	} else {
#line 102 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self->priv->client_done = TRUE;
#line 900 "rygel-http-response-test.c"
	}
#line 105 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = self->client;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp4_, NULL, NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = self->priv->main_loop;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_main_loop_run (_tmp5_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = self->priv->error;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp6_ != NULL) {
#line 914 "rygel-http-response-test.c"
		GError* _tmp7_;
		GError* _tmp8_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = self->priv->error;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = _tmp8_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 927 "rygel-http-response-test.c"
	}
}


void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error) {
#line 95 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	RYGEL_HTTP_RESPONSE_TEST_GET_CLASS (self)->run (self, error);
#line 937 "rygel-http-response-test.c"
}


static RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPSeek* _tmp0_;
	RygelHTTPSeek* seek;
	RygelMediaItem* _tmp1_;
	gboolean _tmp2_ = FALSE;
	RygelHTTPServer* _tmp12_;
	GUPnPContext* _tmp13_;
	SoupServer* _tmp14_;
	SoupServer* _tmp15_;
	SoupMessage* _tmp16_;
	RygelMediaItem* _tmp17_;
	RygelHTTPSeek* _tmp18_;
	GCancellable* _tmp19_;
	RygelHTTPGet* _tmp20_;
	RygelHTTPGet* request;
	GCancellable* _tmp21_;
	RygelHTTPGetHandler* _tmp22_;
	RygelHTTPGetHandler* handler;
	RygelMediaItem* _tmp23_;
	GstElement* _tmp24_ = NULL;
	GstElement* src;
	RygelHTTPResponse* _tmp25_;
	RygelHTTPResponse* _tmp26_;
	GError * _inner_error_ = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = _g_object_ref0 (RYGEL_IS_HTTP_SEEK (NULL) ? ((RygelHTTPSeek*) NULL) : NULL);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	seek = _tmp0_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = self->priv->item;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = rygel_media_item_is_live_stream (_tmp1_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (!_tmp2_) {
#line 980 "rygel-http-response-test.c"
		RygelMediaItem* _tmp3_;
		gint64 _tmp4_;
		gint64 _tmp5_;
		RygelHTTPByteSeek* _tmp6_;
		SoupMessage* _tmp7_;
		SoupMessageHeaders* _tmp8_;
		RygelHTTPSeek* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = self->priv->item;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = rygel_media_item_get_size (_tmp3_);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = _tmp4_;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp6_ = rygel_http_byte_seek_new ((gint64) 0, (gint64) (RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES - 1), _tmp5_);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (seek);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		seek = (RygelHTTPSeek*) _tmp6_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = msg;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = _tmp7_->response_headers;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp9_ = seek;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp10_ = rygel_http_seek_get_length (_tmp9_);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp11_ = _tmp10_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		soup_message_headers_set_content_length (_tmp8_, _tmp11_);
#line 1014 "rygel-http-response-test.c"
	}
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = self->server;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp13_ = _tmp12_->context;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp14_ = gupnp_context_get_server (_tmp13_);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp15_ = _tmp14_;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp16_ = msg;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp17_ = self->priv->item;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp18_ = seek;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp19_ = self->cancellable;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp20_ = rygel_http_get_new (_tmp15_, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	request = _tmp20_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp21_ = self->cancellable;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp22_ = rygel_http_get_handler_new (_tmp21_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	handler = _tmp22_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp23_ = self->priv->item;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp24_ = rygel_media_item_create_stream_source (_tmp23_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	src = _tmp24_;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp25_ = rygel_http_response_new (request, handler, src, &_inner_error_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp26_ = _tmp25_;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_propagate_error (error, _inner_error_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_gst_object_unref0 (src);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (handler);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (request);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (seek);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 1066 "rygel-http-response-test.c"
	}
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp26_;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_gst_object_unref0 (src);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (handler);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (request);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (seek);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1080 "rygel-http-response-test.c"
}


static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client) {
	gboolean _tmp0_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (client != NULL);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->server_done;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp0_) {
#line 1094 "rygel-http-response-test.c"
		GMainLoop* _tmp1_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = self->priv->main_loop;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_main_loop_quit (_tmp1_);
#line 1100 "rygel-http-response-test.c"
	}
#line 138 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->client_done = TRUE;
#line 1104 "rygel-http-response-test.c"
}


static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response) {
	gboolean _tmp0_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (response != NULL);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->client_done;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp0_) {
#line 1118 "rygel-http-response-test.c"
		GMainLoop* _tmp1_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = self->priv->main_loop;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_main_loop_quit (_tmp1_);
#line 1124 "rygel-http-response-test.c"
	}
#line 146 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->server_done = TRUE;
#line 1128 "rygel-http-response-test.c"
}


static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 156 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_on_response_completed (self, _sender);
#line 1135 "rygel-http-response-test.c"
}


static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	GError * _inner_error_ = NULL;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 1147 "rygel-http-response-test.c"
	{
		SoupMessage* _tmp0_;
		RygelHTTPResponse* _tmp1_ = NULL;
		RygelHTTPResponse* response;
		RygelHTTPResponse* _tmp2_;
		RygelHTTPResponse* _tmp3_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = msg;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = rygel_http_response_test_create_response (self, _tmp0_, &_inner_error_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		response = _tmp1_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 1162 "rygel-http-response-test.c"
			goto __catch1_g_error;
		}
#line 154 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = response;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _tmp2_, NULL, NULL);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = response;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_signal_connect_object ((RygelStateMachine*) _tmp3_, "completed", (GCallback) _rygel_http_response_test_on_response_completed_rygel_state_machine_completed, self, 0);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (response);
#line 1175 "rygel-http-response-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		GMainLoop* _tmp6_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = _error_;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (self->priv->error);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self->priv->error = _tmp5_;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp6_ = self->priv->main_loop;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_main_loop_quit (_tmp6_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 1204 "rygel-http-response-test.c"
	}
	__finally1:
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_clear_error (&_inner_error_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return;
#line 1215 "rygel-http-response-test.c"
	}
}


static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	GCancellable* _tmp0_;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->cancellable;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_cancellable_cancel (_tmp0_);
#line 1232 "rygel-http-response-test.c"
}


static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_;
	GMainLoop* _tmp1_;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
#line 171 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_error_free0 (self->priv->error);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->error = _tmp0_;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = self->priv->main_loop;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_main_loop_quit (_tmp1_);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = FALSE;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1256 "rygel-http-response-test.c"
}


static void rygel_http_response_test_class_init (RygelHTTPResponseTestClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_response_test_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponseTestPrivate));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	RYGEL_HTTP_RESPONSE_TEST_CLASS (klass)->run = rygel_http_response_test_real_run;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_test_finalize;
#line 1269 "rygel-http-response-test.c"
}


static void rygel_http_response_test_instance_init (RygelHTTPResponseTest * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE (self);
#line 1276 "rygel-http-response-test.c"
}


static void rygel_http_response_test_finalize (GObject* obj) {
	RygelHTTPResponseTest * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = RYGEL_HTTP_RESPONSE_TEST (obj);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->client);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->priv->item);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_error_free0 (self->priv->error);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_response_test_parent_class)->finalize (obj);
#line 1298 "rygel-http-response-test.c"
}


GType rygel_http_response_test_get_type (void) {
	static volatile gsize rygel_http_response_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponseTest), 0, (GInstanceInitFunc) rygel_http_response_test_instance_init, NULL };
		GType rygel_http_response_test_type_id;
		rygel_http_response_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponseTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_response_test_type_id__volatile, rygel_http_response_test_type_id);
	}
	return rygel_http_response_test_type_id__volatile;
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 205 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
#line 1317 "rygel-http-response-test.c"
}


static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
#line 1324 "rygel-http-response-test.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GUPnPContext* _tmp10_;
	SoupServer* _tmp11_;
	SoupServer* _tmp12_;
	GUPnPContext* _tmp13_;
	SoupServer* _tmp14_;
	SoupServer* _tmp15_;
	GError * _inner_error_ = NULL;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 1346 "rygel-http-response-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp1_ = _tmp0_;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_ != NULL) {
#line 1356 "rygel-http-response-test.c"
			goto __catch2_g_error;
		}
#line 196 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self->context);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self->context = _tmp1_;
#line 1363 "rygel-http-response-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_error_ = _inner_error_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = NULL;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 198 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_inner_error_ = _tmp2_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_error_free0 (_error_);
#line 1380 "rygel-http-response-test.c"
		goto __finally2;
	}
	__finally2:
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			g_propagate_error (error, _inner_error_);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			_g_object_unref0 (self);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return NULL;
#line 1394 "rygel-http-response-test.c"
		} else {
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			g_clear_error (&_inner_error_);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return NULL;
#line 1402 "rygel-http-response-test.c"
		}
	}
#line 201 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = self->context;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_assert (_tmp3_ != NULL);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = self->context;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = _tmp5_;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_assert (_tmp6_ != NULL);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = self->context;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _tmp8_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_assert (_tmp9_ > ((guint) 0));
#line 205 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = self->context;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = gupnp_context_get_server (_tmp10_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = _tmp11_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_server_add_handler (_tmp12_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp13_ = self->context;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp14_ = gupnp_context_get_server (_tmp13_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp15_ = _tmp14_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_object (_tmp15_, "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, self, 0);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 1443 "rygel-http-response-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 1450 "rygel-http-response-test.c"
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	GUPnPContext* _tmp0_;
	SoupServer* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (path != NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (client != NULL);
#line 214 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->context;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = gupnp_context_get_server (_tmp0_);
#line 214 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = msg;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_server_pause_message (_tmp2_, _tmp3_);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = msg;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name (self, "message-received", _tmp4_);
#line 1484 "rygel-http-response-test.c"
}


static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
	SoupMessage* _tmp0_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (message != NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (client != NULL);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = message;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name (self, "message-aborted", _tmp0_);
#line 1502 "rygel-http-response-test.c"
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->context;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp0_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = g_strconcat ("http://", _tmp2_, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = _tmp3_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = g_strconcat (_tmp4_, ":", NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = _tmp5_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = self->context;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _tmp8_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = g_strdup_printf ("%u", _tmp9_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = _tmp10_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp13_ = _tmp12_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp14_ = g_strconcat (_tmp13_, RYGEL_HTTP_SERVER_SERVER_PATH, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp15_ = _tmp14_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp13_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp11_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp6_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_free0 (_tmp4_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp15_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1570 "rygel-http-response-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_new ("message_aborted", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 1587 "rygel-http-response-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = RYGEL_HTTP_SERVER (obj);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->context);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 1603 "rygel-http-response-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SERVER_URI:
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_take_string (value, rygel_http_server_get_uri (self));
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 1630 "rygel-http-response-test.c"
		default:
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 1636 "rygel-http-response-test.c"
	}
}


static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 245 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_on_cancelled (self, _sender);
#line 1644 "rygel-http-response-test.c"
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	gsize _tmp2_;
	const gchar* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessageBody* _tmp7_;
	gboolean _tmp8_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = context;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->context);
#line 236 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->context = _tmp1_;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_bytes;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->total_bytes = _tmp2_;
#line 239 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = uri;
#line 239 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = soup_message_new ("HTTP", _tmp3_);
#line 239 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 239 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->msg = _tmp4_;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = self->msg;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_assert (_tmp5_ != NULL);
#line 241 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = self->msg;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = _tmp6_->response_body;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_message_body_set_accumulate (_tmp7_, FALSE);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = active;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp8_) {
#line 1699 "rygel-http-response-test.c"
		GCancellable* _tmp9_;
		GCancellable* _tmp10_;
		GCancellable* _tmp11_;
		GCancellable* _tmp12_;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp9_ = g_cancellable_new ();
#line 244 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp10_ = _tmp9_;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp10_);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (_tmp10_);
#line 245 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 245 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp12_ = _tmp11_;
#line 245 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_signal_connect_object (_tmp12_, "cancelled", (GCallback) _rygel_http_client_on_cancelled_g_cancellable_cancelled, self, 0);
#line 1718 "rygel-http-response-test.c"
	}
#line 232 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 1722 "rygel-http-response-test.c"
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active) {
#line 232 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri, total_bytes, active);
#line 1729 "rygel-http-response-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (_data_->self);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_slice_free (RygelHttpClientRunData, _data_);
#line 1740 "rygel-http-response-test.c"
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) base;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_ = g_slice_new0 (RygelHttpClientRunData);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->self = _tmp0_;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_real_run_co (_data_);
#line 1762 "rygel-http-response-test.c"
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1770 "rygel-http-response-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return _data1_;
#line 1779 "rygel-http-response-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1788 "rygel-http-response-test.c"
		RygelHTTPClient * self;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		self = _data1_->self;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_data1_->run_continue = NULL;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_data1_->run_continue_target = NULL;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_data1_->run_continue_target_destroy_notify = NULL;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_g_object_unref0 (self);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 1804 "rygel-http-response-test.c"
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 1814 "rygel-http-response-test.c"
}


static void __lambda2_ (Block1Data* _data1_, SoupMessage* msg, SoupBuffer* chunk) {
	RygelHTTPClient * self;
	SoupBuffer* _tmp0_;
	gsize _tmp1_;
	gboolean _tmp2_ = FALSE;
	gsize _tmp3_;
	gboolean _tmp6_;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = _data1_->self;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (chunk != NULL);
#line 254 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = chunk;
#line 254 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _tmp0_->length;
#line 254 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data1_->bytes_received = _data1_->bytes_received + _tmp1_;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = self->total_bytes;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_data1_->bytes_received >= _tmp3_) {
#line 1841 "rygel-http-response-test.c"
		GCancellable* _tmp4_;
		GCancellable* _tmp5_;
#line 257 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 257 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp5_ = _tmp4_;
#line 257 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = _tmp5_ != NULL;
#line 1850 "rygel-http-response-test.c"
	} else {
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp2_ = FALSE;
#line 1854 "rygel-http-response-test.c"
	}
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = _tmp2_;
#line 256 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp6_) {
#line 1860 "rygel-http-response-test.c"
		GCancellable* _tmp7_;
		GCancellable* _tmp8_;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp8_ = _tmp7_;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_cancellable_cancel (_tmp8_);
#line 1869 "rygel-http-response-test.c"
	}
}


static void ___lambda2__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	__lambda2_ (self, _sender, chunk);
#line 1877 "rygel-http-response-test.c"
}


static void __lambda3_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient * self;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	gboolean _tmp4_;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = _data1_->self;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (session != NULL);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_tmp2_ != NULL) {
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = TRUE;
#line 1901 "rygel-http-response-test.c"
	} else {
		gsize _tmp3_;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp3_ = self->total_bytes;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		_tmp0_ = _data1_->bytes_received == _tmp3_;
#line 1908 "rygel-http-response-test.c"
	}
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = _tmp0_;
#line 264 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_assert (_tmp4_);
#line 266 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 1916 "rygel-http-response-test.c"
}


static void ___lambda3__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	__lambda3_ (self, session, msg);
#line 1923 "rygel-http-response-test.c"
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (_data_->_state_) {
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case 0:
#line 1932 "rygel-http-response-test.c"
		goto _state_0;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case 1:
#line 1936 "rygel-http-response-test.c"
		goto _state_1;
		default:
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_assert_not_reached ();
#line 1941 "rygel-http-response-test.c"
	}
	_state_0:
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->run_continue_target = _data_;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_->bytes_received = (gsize) 0;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp0_ = _data_->self->msg;
#line 253 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_connect_data (_data_->_tmp0_, "got-chunk", (GCallback) ___lambda2__soup_message_got_chunk, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp1_ = _data_->self->context;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp2_ = gupnp_context_get_session (_data_->_tmp1_);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp4_ = _data_->self->msg;
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp5_, ___lambda3__soup_session_callback, _data_->_data1_);
#line 269 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_state_ = 1;
#line 269 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return FALSE;
#line 1980 "rygel-http-response-test.c"
	_state_1:
	;
#line 271 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	block1_data_unref (_data_->_data1_);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_data_->_data1_ = NULL;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_data_->_state_ == 0) {
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1993 "rygel-http-response-test.c"
	} else {
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1997 "rygel-http-response-test.c"
	}
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_unref (_data_->_async_result);
#line 249 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return FALSE;
#line 2003 "rygel-http-response-test.c"
}


static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable) {
	GUPnPContext* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
#line 274 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 274 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (cancellable != NULL);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->context;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = gupnp_context_get_session (_tmp0_);
#line 275 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = self->msg;
#line 275 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_session_cancel_message (_tmp2_, _tmp3_, (guint) SOUP_STATUS_CANCELLED);
#line 277 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 2028 "rygel-http-response-test.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) base;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2044 "rygel-http-response-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPClient*) base;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 2064 "rygel-http-response-test.c"
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2081 "rygel-http-response-test.c"
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->run_finish = rygel_http_client_real_run_finish;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
#line 2096 "rygel-http-response-test.c"
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
#line 2103 "rygel-http-response-test.c"
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = RYGEL_HTTP_CLIENT (obj);
#line 226 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->context);
#line 227 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 230 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
#line 2119 "rygel-http-response-test.c"
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2148 "rygel-http-response-test.c"
		default:
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2154 "rygel-http-response-test.c"
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2170 "rygel-http-response-test.c"
		default:
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2176 "rygel-http-response-test.c"
	}
}


RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPSeek * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
#line 287 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPSeek*) g_object_new (object_type, NULL);
#line 288 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = start;
#line 288 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_start (self, _tmp0_);
#line 289 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = stop;
#line 289 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_stop (self, _tmp1_);
#line 290 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_length;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_total_length (self, _tmp2_);
#line 292 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = stop;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = start;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_set_length (self, (_tmp3_ - _tmp4_) + 1);
#line 287 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2210 "rygel-http-response-test.c"
}


RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop, gint64 total_length) {
#line 287 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_seek_construct (RYGEL_TYPE_HTTP_SEEK, start, stop, total_length);
#line 2217 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_start (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_start;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2232 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_start = _tmp0_;
#line 282 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "start");
#line 2246 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_stop;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2261 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_stop = _tmp0_;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "stop");
#line 2275 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_length (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_length;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2290 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_length = _tmp0_;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "length");
#line 2304 "rygel-http-response-test.c"
}


gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self) {
	gint64 result;
	gint64 _tmp0_;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->_total_length;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp0_;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2319 "rygel-http-response-test.c"
}


static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value) {
	gint64 _tmp0_;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = value;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->_total_length = _tmp0_;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_notify ((GObject *) self, "total-length");
#line 2333 "rygel-http-response-test.c"
}


static void rygel_http_seek_class_init (RygelHTTPSeekClass * klass) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_seek_parent_class = g_type_class_peek_parent (klass);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPSeekPrivate));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_seek_get_property;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_seek_set_property;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_seek_finalize;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_START, g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_STOP, g_param_spec_int64 ("stop", "stop", "stop", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_LENGTH, g_param_spec_int64 ("length", "length", "length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_TOTAL_LENGTH, g_param_spec_int64 ("total-length", "total-length", "total-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2356 "rygel-http-response-test.c"
}


static void rygel_http_seek_instance_init (RygelHTTPSeek * self) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_HTTP_SEEK_GET_PRIVATE (self);
#line 2363 "rygel-http-response-test.c"
}


static void rygel_http_seek_finalize (GObject* obj) {
	RygelHTTPSeek * self;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = RYGEL_HTTP_SEEK (obj);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_seek_parent_class)->finalize (obj);
#line 2373 "rygel-http-response-test.c"
}


GType rygel_http_seek_get_type (void) {
	static volatile gsize rygel_http_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSeek), 0, (GInstanceInitFunc) rygel_http_seek_instance_init, NULL };
		GType rygel_http_seek_type_id;
		rygel_http_seek_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_seek_type_id__volatile, rygel_http_seek_type_id);
	}
	return rygel_http_seek_type_id__volatile;
}


static void _vala_rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_START:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_start (self));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_STOP:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_stop (self));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_LENGTH:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_length (self));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_value_set_int64 (value, rygel_http_seek_get_total_length (self));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2418 "rygel-http-response-test.c"
		default:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2424 "rygel-http-response-test.c"
	}
}


static void _vala_rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	switch (property_id) {
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_START:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_start (self, g_value_get_int64 (value));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_STOP:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_stop (self, g_value_get_int64 (value));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_LENGTH:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_length (self, g_value_get_int64 (value));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_http_seek_set_total_length (self, g_value_get_int64 (value));
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2458 "rygel-http-response-test.c"
		default:
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 281 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		break;
#line 2464 "rygel-http-response-test.c"
	}
}


RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPByteSeek * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = start;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = stop;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_length;
#line 298 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPByteSeek*) rygel_http_seek_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 297 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2484 "rygel-http-response-test.c"
}


RygelHTTPByteSeek* rygel_http_byte_seek_new (gint64 start, gint64 stop, gint64 total_length) {
#line 297 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_byte_seek_construct (RYGEL_TYPE_HTTP_BYTE_SEEK, start, stop, total_length);
#line 2491 "rygel-http-response-test.c"
}


static void rygel_http_byte_seek_class_init (RygelHTTPByteSeekClass * klass) {
#line 296 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_byte_seek_parent_class = g_type_class_peek_parent (klass);
#line 2498 "rygel-http-response-test.c"
}


static void rygel_http_byte_seek_instance_init (RygelHTTPByteSeek * self) {
}


GType rygel_http_byte_seek_get_type (void) {
	static volatile gsize rygel_http_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeek), 0, (GInstanceInitFunc) rygel_http_byte_seek_instance_init, NULL };
		GType rygel_http_byte_seek_type_id;
		rygel_http_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_type_id__volatile, rygel_http_byte_seek_type_id);
	}
	return rygel_http_byte_seek_type_id__volatile;
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPTimeSeek * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = start;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = stop;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = total_length;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 303 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2533 "rygel-http-response-test.c"
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (gint64 start, gint64 stop, gint64 total_length) {
#line 303 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, start, stop, total_length);
#line 2540 "rygel-http-response-test.c"
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
#line 302 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
#line 2547 "rygel-http-response-test.c"
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static gpointer _rygel_media_item_ref0 (gpointer self) {
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self ? rygel_media_item_ref (self) : NULL;
#line 2570 "rygel-http-response-test.c"
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable) {
	RygelHTTPGet * self = NULL;
	SoupServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	RygelMediaItem* _tmp4_;
	RygelMediaItem* _tmp5_;
	RygelHTTPSeek* _tmp6_;
	RygelHTTPSeek* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	SoupMessage* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	SoupMessage* _tmp12_;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = server;
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 323 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->server = _tmp1_;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = msg;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 324 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->msg = _tmp3_;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp4_ = item;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp5_ = _rygel_media_item_ref0 (_tmp4_);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->item);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->item = _tmp5_;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp6_ = seek;
#line 326 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->seek);
#line 326 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->seek = _tmp7_;
#line 327 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp8_ = cancellable;
#line 327 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 327 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 327 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->cancellable = _tmp9_;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp10_ = self->msg;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp11_ = _tmp10_->response_headers;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_message_headers_set_encoding (_tmp11_, SOUP_ENCODING_EOF);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp12_ = self->msg;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	soup_message_set_status (_tmp12_, (guint) SOUP_STATUS_OK);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2649 "rygel-http-response-test.c"
}


RygelHTTPGet* rygel_http_get_new (SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, server, msg, item, seek, cancellable);
#line 2656 "rygel-http-response-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 308 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 308 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 2665 "rygel-http-response-test.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 308 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = RYGEL_HTTP_GET (obj);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->server);
#line 310 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->msg);
#line 312 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 314 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_rygel_media_item_unref0 (self->item);
#line 316 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->seek);
#line 308 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 2689 "rygel-http-response-test.c"
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPGetHandler * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 336 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelHTTPGetHandler*) g_object_new (object_type, NULL);
#line 337 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = cancellable;
#line 337 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 337 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 337 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->cancellable = _tmp1_;
#line 336 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2721 "rygel-http-response-test.c"
}


RygelHTTPGetHandler* rygel_http_get_handler_new (GCancellable* cancellable) {
#line 336 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_http_get_handler_construct (RYGEL_TYPE_HTTP_GET_HANDLER, cancellable);
#line 2728 "rygel-http-response-test.c"
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
#line 333 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
#line 2737 "rygel-http-response-test.c"
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
}


static void rygel_http_get_handler_finalize (GObject* obj) {
	RygelHTTPGetHandler * self;
#line 333 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = RYGEL_HTTP_GET_HANDLER (obj);
#line 334 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_g_object_unref0 (self->cancellable);
#line 333 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_OBJECT_CLASS (rygel_http_get_handler_parent_class)->finalize (obj);
#line 2753 "rygel-http-response-test.c"
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, NULL };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


static inline void _dynamic_set_sizetype0 (GstElement* obj, gint value) {
#line 355 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_set (obj, "sizetype", value, NULL);
#line 2772 "rygel-http-response-test.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GError * _inner_error_ = NULL;
#line 353 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelMediaItem*) g_type_create_instance (object_type);
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = rygel_gst_utils_create_element ("fakesrc", NULL, &_inner_error_);
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _tmp0_;
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (_inner_error_ != NULL) {
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_clear_error (&_inner_error_);
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return NULL;
#line 2796 "rygel-http-response-test.c"
	}
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_gst_object_unref0 (self->priv->src);
#line 354 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv->src = _tmp1_;
#line 355 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = self->priv->src;
#line 355 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_dynamic_set_sizetype0 (_tmp2_, 2);
#line 353 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2808 "rygel-http-response-test.c"
}


RygelMediaItem* rygel_media_item_new (void) {
#line 353 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 2815 "rygel-http-response-test.c"
}


static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value) {
#line 361 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_set (obj, "blocksize", value, NULL);
#line 2822 "rygel-http-response-test.c"
}


static inline void _dynamic_set_num_buffers2 (GstElement* obj, glong value) {
#line 362 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_set (obj, "num-buffers", value, NULL);
#line 2829 "rygel-http-response-test.c"
}


static inline void _dynamic_set_sizemax3 (GstElement* obj, glong value) {
#line 363 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_set (obj, "sizemax", value, NULL);
#line 2836 "rygel-http-response-test.c"
}


RygelMediaItem* rygel_media_item_construct_fixed_size (GType object_type) {
	RygelMediaItem* self = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelMediaItem*) g_type_create_instance (object_type);
#line 359 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = (RygelMediaItem*) rygel_media_item_construct (object_type);
#line 361 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->src;
#line 361 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_dynamic_set_blocksize1 (_tmp0_, RYGEL_MEDIA_ITEM_BLOCK_SIZE);
#line 362 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = self->priv->src;
#line 362 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_dynamic_set_num_buffers2 (_tmp1_, RYGEL_MEDIA_ITEM_MAX_BUFFERS);
#line 363 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = self->priv->src;
#line 363 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_dynamic_set_sizemax3 (_tmp2_, RYGEL_MEDIA_ITEM_MAX_BUFFERS * RYGEL_MEDIA_ITEM_BLOCK_SIZE);
#line 358 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self;
#line 2863 "rygel-http-response-test.c"
}


RygelMediaItem* rygel_media_item_new_fixed_size (void) {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return rygel_media_item_construct_fixed_size (RYGEL_TYPE_MEDIA_ITEM);
#line 2870 "rygel-http-response-test.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 367 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return self ? gst_object_ref (self) : NULL;
#line 2877 "rygel-http-response-test.c"
}


GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 367 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->src;
#line 367 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _gst_object_ref0 (_tmp0_);
#line 367 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = _tmp1_;
#line 367 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2895 "rygel-http-response-test.c"
}


static inline GstElement* _dynamic_get_num_buffers4 (GstElement* obj) {
	GstElement* result;
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_object_get (obj, "num-buffers", &result, NULL);
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2905 "rygel-http-response-test.c"
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
#line 370 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp0_ = self->priv->src;
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp1_ = _dynamic_get_num_buffers4 (_tmp0_);
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_tmp2_ = _tmp1_;
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = ((gint) _tmp2_) < 0;
#line 371 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2926 "rygel-http-response-test.c"
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	result = (gint64) (RYGEL_MEDIA_ITEM_MAX_BUFFERS * RYGEL_MEDIA_ITEM_BLOCK_SIZE);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return result;
#line 2938 "rygel-http-response-test.c"
}


static void rygel_value_media_item_init (GValue* value) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	value->data[0].v_pointer = NULL;
#line 2945 "rygel-http-response-test.c"
}


static void rygel_value_media_item_free_value (GValue* value) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (value->data[0].v_pointer) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_unref (value->data[0].v_pointer);
#line 2954 "rygel-http-response-test.c"
	}
}


static void rygel_value_media_item_copy_value (const GValue* src_value, GValue* dest_value) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (src_value->data[0].v_pointer) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		dest_value->data[0].v_pointer = rygel_media_item_ref (src_value->data[0].v_pointer);
#line 2964 "rygel-http-response-test.c"
	} else {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2968 "rygel-http-response-test.c"
	}
}


static gpointer rygel_value_media_item_peek_pointer (const GValue* value) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return value->data[0].v_pointer;
#line 2976 "rygel-http-response-test.c"
}


static gchar* rygel_value_media_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (collect_values[0].v_pointer) {
#line 2983 "rygel-http-response-test.c"
		RygelMediaItem* object;
		object = collect_values[0].v_pointer;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2990 "rygel-http-response-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2994 "rygel-http-response-test.c"
		}
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = rygel_media_item_ref (object);
#line 2998 "rygel-http-response-test.c"
	} else {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = NULL;
#line 3002 "rygel-http-response-test.c"
	}
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return NULL;
#line 3006 "rygel-http-response-test.c"
}


static gchar* rygel_value_media_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaItem** object_p;
	object_p = collect_values[0].v_pointer;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (!object_p) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3017 "rygel-http-response-test.c"
	}
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (!value->data[0].v_pointer) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		*object_p = NULL;
#line 3023 "rygel-http-response-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		*object_p = value->data[0].v_pointer;
#line 3027 "rygel-http-response-test.c"
	} else {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		*object_p = rygel_media_item_ref (value->data[0].v_pointer);
#line 3031 "rygel-http-response-test.c"
	}
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return NULL;
#line 3035 "rygel-http-response-test.c"
}


GParamSpec* rygel_param_spec_media_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaItem* spec;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_ITEM), NULL);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return G_PARAM_SPEC (spec);
#line 3049 "rygel-http-response-test.c"
}


gpointer rygel_value_get_media_item (const GValue* value) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM), NULL);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return value->data[0].v_pointer;
#line 3058 "rygel-http-response-test.c"
}


void rygel_value_set_media_item (GValue* value, gpointer v_object) {
	RygelMediaItem* old;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM));
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	old = value->data[0].v_pointer;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (v_object) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_ITEM));
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = v_object;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_ref (value->data[0].v_pointer);
#line 3078 "rygel-http-response-test.c"
	} else {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = NULL;
#line 3082 "rygel-http-response-test.c"
	}
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (old) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_unref (old);
#line 3088 "rygel-http-response-test.c"
	}
}


void rygel_value_take_media_item (GValue* value, gpointer v_object) {
	RygelMediaItem* old;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM));
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	old = value->data[0].v_pointer;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (v_object) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_ITEM));
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = v_object;
#line 3107 "rygel-http-response-test.c"
	} else {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		value->data[0].v_pointer = NULL;
#line 3111 "rygel-http-response-test.c"
	}
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (old) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		rygel_media_item_unref (old);
#line 3117 "rygel-http-response-test.c"
	}
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
#line 3129 "rygel-http-response-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self->ref_count = 1;
#line 3138 "rygel-http-response-test.c"
}


static void rygel_media_item_finalize (RygelMediaItem* obj) {
	RygelMediaItem * self;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 351 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	_gst_object_unref0 (self->priv->src);
#line 3148 "rygel-http-response-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_item_init, rygel_value_media_item_free_value, rygel_value_media_item_copy_value, rygel_value_media_item_peek_pointer, "p", rygel_value_media_item_collect_value, "p", rygel_value_media_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


gpointer rygel_media_item_ref (gpointer instance) {
	RygelMediaItem* self;
	self = instance;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	return instance;
#line 3173 "rygel-http-response-test.c"
}


void rygel_media_item_unref (gpointer instance) {
	RygelMediaItem* self;
	self = instance;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		RYGEL_MEDIA_ITEM_GET_CLASS (self)->finalize (self);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-response-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3186 "rygel-http-response-test.c"
	}
}



