/* rygel-item-creator.c generated by valac 0.15.2, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <stdio.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SERVICE_ACTION (rygel_service_action_get_type ())
#define RYGEL_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceAction))
#define RYGEL_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))
#define RYGEL_IS_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_IS_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_SERVICE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))

typedef struct _RygelServiceAction RygelServiceAction;
typedef struct _RygelServiceActionClass RygelServiceActionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_IS_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerClass RygelWritableContainerClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_IS_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerClass RygelSearchableContainerClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelItemCreatorFindAnyContainerData RygelItemCreatorFindAnyContainerData;
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelItemCreatorCreateItemFromDidlData RygelItemCreatorCreateItemFromDidlData;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _RygelItemCreatorCreateUriData RygelItemCreatorCreateUriData;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _RygelItemCreatorWaitForItemData RygelItemCreatorWaitForItemData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
	RygelContentDirectory* content_dir;
	RygelServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GRegex* title_regex;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GObject parent_instance;
	RygelContentDirectoryPrivate * priv;
	GCancellable* cancellable;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
};

struct _RygelContentDirectoryClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	RygelMediaContainer* parent;
	gchar* upnp_class;
	gchar* title;
	GUPnPOCMFlags ocm_flags;
	GeeArrayList* uris;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT,
	RYGEL_CONTENT_DIRECTORY_ERROR_ERROR
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* dlna_profile;
	gchar* mime_type;
	glong size;
	gboolean place_holder;
	gchar* date;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelItemCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* container;
	gboolean _tmp1_;
	RygelWritableContainer* _tmp2_;
	GUPnPDIDLLiteItem* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GUPnPDIDLLiteItem* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	RygelWritableContainer* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	RygelWritableContainer* _tmp15_;
	RygelWritableContainer* _tmp16_;
	RygelMediaItem* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	RygelWritableContainer* _tmp20_;
	RygelMediaItem* _tmp21_;
	GUPnPDIDLLiteWriter* _tmp22_;
	RygelContentDirectory* _tmp23_;
	RygelHTTPServer* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	RygelMediaItem* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	RygelItemRemovalQueue* _tmp30_;
	RygelItemRemovalQueue* queue;
	RygelItemRemovalQueue* _tmp31_;
	RygelMediaItem* _tmp32_;
	GCancellable* _tmp33_;
	GCancellable* _tmp34_;
	GError* err;
	GError* _tmp35_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelItemCreatorFindAnyContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelMediaObject* result;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchableContainer* root_container;
	RygelSearchableContainer* _tmp3_;
	GUPnPDIDLLiteItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* upnp_class;
	RygelRelationalExpression* _tmp8_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelRelationalExpression* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	guint total_matches;
	RygelSearchableContainer* _tmp16_;
	RygelRelationalExpression* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	gint _tmp20_;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GUPnPDIDLLiteItem* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObjects* _tmp27_;
	gpointer _tmp28_;
	const gchar* _tmp29_;
	GUPnPDIDLLiteItem* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GError* _tmp33_;
	GError * _inner_error_;
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelContentDirectory* _tmp3_;
	RygelMediaContainer* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObject* _tmp8_;
	gboolean _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	gboolean _tmp15_;
	RygelMediaObject* _tmp16_;
	GUPnPOCMFlags _tmp17_;
	RygelMediaObject* _tmp18_;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	RygelMediaObject* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	RygelMediaObject* _tmp24_;
	RygelWritableContainer* _tmp25_;
	GError * _inner_error_;
};

struct _RygelItemCreatorCreateItemFromDidlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	GUPnPDIDLLiteItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelWritableContainer* _tmp3_;
	GUPnPDIDLLiteItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPDIDLLiteItem* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	RygelMediaItem* _tmp10_;
	RygelMediaItem* _tmp11_;
	GUPnPDIDLLiteItem* _tmp12_;
	GList* _tmp13_;
	GList* resources;
	gboolean _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	guint _tmp17_;
	gboolean _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	gconstpointer _tmp21_;
	GUPnPDIDLLiteResource* _tmp22_;
	GUPnPDIDLLiteResource* resource;
	GUPnPDIDLLiteResource* _tmp23_;
	GUPnPProtocolInfo* _tmp24_;
	GUPnPProtocolInfo* _tmp25_;
	GUPnPProtocolInfo* _tmp26_;
	GUPnPProtocolInfo* info;
	GUPnPProtocolInfo* _tmp27_;
	GUPnPProtocolInfo* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GUPnPProtocolInfo* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gboolean _tmp34_;
	GUPnPProtocolInfo* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	RygelMediaItem* _tmp39_;
	GUPnPProtocolInfo* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GUPnPProtocolInfo* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	RygelMediaItem* _tmp47_;
	GUPnPProtocolInfo* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* sanitized_uri;
	GUPnPDIDLLiteResource* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	gboolean _tmp56_;
	RygelMediaItem* _tmp57_;
	const gchar* _tmp58_;
	GUPnPDIDLLiteResource* _tmp59_;
	glong _tmp60_;
	glong _tmp61_;
	RygelMediaItem* _tmp62_;
	GUPnPDIDLLiteResource* _tmp63_;
	glong _tmp64_;
	glong _tmp65_;
	RygelMediaItem* _tmp66_;
	const gchar* _tmp67_;
	RygelMediaItem* _tmp68_;
	gchar* _tmp69_;
	RygelMediaItem* _tmp70_;
	glong _tmp71_;
	RygelMediaItem* _tmp72_;
	RygelMediaItem* _tmp73_;
	GeeArrayList* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	RygelWritableContainer* _tmp77_;
	RygelMediaItem* _tmp78_;
	const gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* uri;
	RygelMediaItem* _tmp81_;
	GeeArrayList* _tmp82_;
	const gchar* _tmp83_;
	RygelMediaItem* _tmp84_;
	RygelMediaItem* _tmp85_;
	GeeArrayList* _tmp86_;
	gpointer _tmp87_;
	gchar* _tmp88_;
	GFile* _tmp89_;
	GFile* _tmp90_;
	GFile* file;
	RygelMediaItem* _tmp91_;
	GFile* _tmp92_;
	gboolean _tmp93_;
	RygelMediaItem* _tmp94_;
	RygelMediaItem* _tmp95_;
	GeeArrayList* _tmp96_;
	gpointer _tmp97_;
	GError * _inner_error_;
};

struct _RygelItemCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* dir;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* file;
	guchar* _tmp16_;
	guchar* udn;
	gint udn_length1;
	gint _udn_size_;
	guchar* _tmp17_;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp18_;
	gint _tmp18__length1;
	guchar* _tmp19_;
	gint _tmp19__length1;
	guchar* _tmp20_;
	gint _tmp20__length1;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	guchar* _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	RygelItemCreator * self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	guint timeout;
};

struct _RygelItemCreatorWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	Block4Data* _data4_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaItem* item;
	RygelMediaItem* _tmp4_;
	RygelWritableContainer* _tmp5_;
	RygelMediaItem* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	GError* _error_;
	RygelWritableContainer* _tmp11_;
	const gchar* _tmp12_;
	RygelMediaItem* _tmp13_;
	const gchar* _tmp14_;
	RygelMediaItem* _tmp15_;
	Block5Data* _data5_;
	RygelWritableContainer* _tmp16_;
	gulong _tmp17_;
	gulong id;
	guint _tmp18_;
	RygelWritableContainer* _tmp19_;
	gulong _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	RygelWritableContainer* _tmp23_;
	const gchar* _tmp24_;
	GError * _inner_error_;
};


static gpointer rygel_item_creator_parent_class = NULL;
static GPatternSpec* rygel_item_creator_comment_pattern;
static GPatternSpec* rygel_item_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_service_action_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
#define RYGEL_ITEM_CREATOR_INVALID_CHARS "/?<>\\:*|\""
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, RygelServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, RygelServiceAction* action);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GError** error);
static void rygel_item_creator_parse_didl (RygelItemCreator* self, GError** error);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_creator_create_item_from_didl (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_create_item_from_didl_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_);
void rygel_media_item_serialize (RygelMediaItem* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* server);
static void rygel_item_creator_conclude (RygelItemCreator* self);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
void rygel_service_action_get (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, gchar** arg1_val, const gchar* arg2_name, GType arg2_type, gchar** arg2_val);
static void __lambda4_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item);
static void ___lambda4__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class);
static void rygel_item_creator_find_any_container_data_free (gpointer _data);
static void rygel_item_creator_find_any_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_item_creator_find_any_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_item_creator_find_any_container_co (RygelItemCreatorFindAnyContainerData* _data_);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, gint offset, gint count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, gint* total_matches);
static void rygel_item_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_);
void rygel_service_action_set (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, const gchar* arg1_val, const gchar* arg2_name, GType arg2_type, const gchar* arg2_val);
void rygel_service_action_return (RygelServiceAction* self);
void rygel_service_action_return_error (RygelServiceAction* self, gint code, const gchar* message);
static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_item_creator_create_item_from_didl_data_free (gpointer _data);
static gboolean rygel_item_creator_create_item_from_didl_co (RygelItemCreatorCreateItemFromDidlData* _data_);
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri, gchar** sanitized_uri);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_create_item_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_parse_and_verify_didl_date (RygelItemCreator* self, GError** error);
static void _vala_SoupDate_free (SoupDate* self);
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static void _vala_SoupURI_free (SoupURI* self);
static gchar* rygel_item_creator_mangle_title (RygelItemCreator* self, const gchar* title, GError** error);
static void rygel_item_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_);
void rygel_writable_container_get_writable (RygelWritableContainer* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_writable_container_get_writable_finish (RygelWritableContainer* self, GAsyncResult* _res_);
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid, guchar* output);
static void rygel_item_creator_wait_for_item_data_free (gpointer _data);
static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ____lambda5_ (Block5Data* _data5_, RygelMediaContainer* container);
static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean ____lambda6_ (Block5Data* _data5_);
static gboolean _____lambda6__gsource_func (gpointer self);
static void rygel_item_creator_finalize (GObject* obj);
static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 51 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return self ? g_object_ref (self) : NULL;
#line 839 "rygel-item-creator.c"
}


RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, RygelServiceAction* action) {
	RygelItemCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	RygelContentDirectory* _tmp2_;
	GCancellable* _tmp3_;
	RygelServiceAction* _tmp4_;
	GUPnPDIDLLiteWriter* _tmp5_;
	GUPnPDIDLLiteParser* _tmp6_;
	GError * _inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
#line 51 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = content_dir;
#line 51 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 51 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 51 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->content_dir = _tmp1_;
#line 52 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = content_dir;
#line 52 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 52 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 53 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp4_ = action;
#line 53 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	action = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->action);
#line 53 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->action = _tmp4_;
#line 54 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp5_ = gupnp_didl_lite_writer_new (NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_writer);
#line 54 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->didl_writer = _tmp5_;
#line 55 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp6_ = gupnp_didl_lite_parser_new ();
#line 55 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 55 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->didl_parser = _tmp6_;
#line 893 "rygel-item-creator.c"
	{
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* pattern;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp7_ = g_regex_escape_string (RYGEL_ITEM_CREATOR_INVALID_CHARS, -1);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp8_ = _tmp7_;
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp9_ = g_strconcat ("[", _tmp8_, NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp10_ = _tmp9_;
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp11_ = g_strconcat (_tmp10_, "]", NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp12_ = _tmp11_;
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_tmp10_);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_tmp8_);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		pattern = _tmp12_;
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp13_ = g_regex_new (pattern, G_REGEX_OPTIMIZE, G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp14_ = _tmp13_;
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_inner_error_ != NULL) {
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_free0 (pattern);
#line 930 "rygel-item-creator.c"
			goto __catch0_g_error;
		}
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_regex_unref0 (self->priv->title_regex);
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		self->priv->title_regex = _tmp14_;
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (pattern);
#line 939 "rygel-item-creator.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_error_ = _inner_error_;
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_error_free0 (_error_);
#line 953 "rygel-item-creator.c"
	}
	__finally0:
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_inner_error_ != NULL) {
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (action);
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_clear_error (&_inner_error_);
#line 56 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return NULL;
#line 966 "rygel-item-creator.c"
	}
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (action);
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return self;
#line 972 "rygel-item-creator.c"
}


RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, RygelServiceAction* action) {
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
#line 979 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorRunData, _data_);
#line 990 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	RygelItemCreator* _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_real_run_co (_data_);
#line 1012 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1020 "rygel-item-creator.c"
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* _data_;
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_real_run_co (_data_);
#line 1034 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_) {
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 0:
#line 1043 "rygel-item-creator.c"
		goto _state_0;
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 1:
#line 1047 "rygel-item-creator.c"
		goto _state_1;
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 2:
#line 1051 "rygel-item-creator.c"
		goto _state_2;
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 3:
#line 1055 "rygel-item-creator.c"
		goto _state_3;
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 4:
#line 1059 "rygel-item-creator.c"
		goto _state_4;
		default:
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 1064 "rygel-item-creator.c"
	}
	_state_0:
	{
#line 66 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_parse_args (_data_->self, &_data_->_inner_error_);
#line 66 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1072 "rygel-item-creator.c"
			goto __catch1_g_error;
		}
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_parse_didl (_data_->self, &_data_->_inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1079 "rygel-item-creator.c"
			goto __catch1_g_error;
		}
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 1;
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_fetch_container (_data_->self, rygel_item_creator_run_ready, _data_);
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 1088 "rygel-item-creator.c"
		_state_1:
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp0_ = NULL;
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp0_ = rygel_item_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->container = _data_->_tmp0_;
#line 69 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1098 "rygel-item-creator.c"
			goto __catch1_g_error;
		}
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp2_ = _data_->container;
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp3_ = _data_->self->priv->didl_item;
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp4_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp3_);
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp6_ = FALSE;
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp6_ = rygel_writable_container_can_create (_data_->_tmp2_, _data_->_tmp5_);
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (!_data_->_tmp6_) {
#line 79 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp7_ = _data_->self->priv->container_id;
#line 79 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp1_ = g_strcmp0 (_data_->_tmp7_, "DLNA_ORG.AnyContainer") != 0;
#line 1119 "rygel-item-creator.c"
		} else {
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp1_ = FALSE;
#line 1123 "rygel-item-creator.c"
		}
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp8_ = _data_->_tmp1_;
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp8_) {
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp9_ = _data_->self->priv->didl_item;
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp10_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp9_);
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp11_ = _data_->_tmp10_;
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp12_ = _data_->container;
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp13_ = ((RygelMediaObject*) _data_->_tmp12_)->id;
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp14_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp11_, _data_->_tmp13_);
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp14_;
#line 80 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1145 "rygel-item-creator.c"
			goto __catch1_g_error;
		}
#line 87 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp15_ = _data_->container;
#line 87 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 2;
#line 87 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_create_item_from_didl (_data_->self, _data_->_tmp15_, rygel_item_creator_run_ready, _data_);
#line 87 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 1156 "rygel-item-creator.c"
		_state_2:
#line 87 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_create_item_from_didl_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 87 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1164 "rygel-item-creator.c"
			goto __catch1_g_error;
		}
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp16_ = _data_->container;
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp17_ = _data_->self->priv->item;
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp19_ = _data_->_tmp18_;
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 3;
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_writable_container_add_item (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp19_, rygel_item_creator_run_ready, _data_);
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 1181 "rygel-item-creator.c"
		_state_3:
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_writable_container_add_item_finish (_data_->_tmp16_, _data_->_res_);
#line 90 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp20_ = _data_->container;
#line 90 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 4;
#line 90 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_wait_for_item (_data_->self, _data_->_tmp20_, rygel_item_creator_run_ready, _data_);
#line 90 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 1193 "rygel-item-creator.c"
		_state_4:
#line 90 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_wait_for_item_finish (_data_->self, _data_->_res_);
#line 92 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp21_ = _data_->self->priv->item;
#line 92 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp22_ = _data_->self->priv->didl_writer;
#line 92 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp23_ = _data_->self->priv->content_dir;
#line 92 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp24_ = _data_->_tmp23_->http_server;
#line 92 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_media_item_serialize (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp24_);
#line 95 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_conclude (_data_->self);
#line 97 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp26_ = _data_->self->priv->container_id;
#line 97 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (g_strcmp0 (_data_->_tmp26_, "DLNA.ORG_AnyContainer") == 0) {
#line 98 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp27_ = _data_->self->priv->item;
#line 98 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp28_ = _data_->_tmp27_->place_holder;
#line 98 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp25_ = _data_->_tmp28_;
#line 1219 "rygel-item-creator.c"
		} else {
#line 97 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp25_ = FALSE;
#line 1223 "rygel-item-creator.c"
		}
#line 97 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp29_ = _data_->_tmp25_;
#line 97 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp29_) {
#line 99 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp30_ = NULL;
#line 99 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp30_ = rygel_item_removal_queue_get_default ();
#line 99 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->queue = _data_->_tmp30_;
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp31_ = _data_->queue;
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp32_ = _data_->self->priv->item;
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp33_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp34_ = _data_->_tmp33_;
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			rygel_item_removal_queue_queue (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp34_);
#line 97 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->queue);
#line 1247 "rygel-item-creator.c"
		}
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->container);
#line 1251 "rygel-item-creator.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->err = _data_->_inner_error_;
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_inner_error_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp35_ = _data_->err;
#line 104 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_handle_error (_data_->self, _data_->_tmp35_);
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_error_free0 (_data_->err);
#line 1266 "rygel-item-creator.c"
	}
	__finally1:
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_clear_error (&_data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 1277 "rygel-item-creator.c"
	}
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1283 "rygel-item-creator.c"
	} else {
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1287 "rygel-item-creator.c"
	}
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 1293 "rygel-item-creator.c"
}


/**
     * Check the supplied input parameters.
     */
static void rygel_item_creator_parse_args (RygelItemCreator* self, GError** error) {
	RygelServiceAction* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp11_;
	GError * _inner_error_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = self->priv->action;
#line 113 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &_tmp1_, "Elements", G_TYPE_STRING, &_tmp2_);
#line 113 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (self->priv->container_id);
#line 113 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->container_id = _tmp1_;
#line 113 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (self->priv->elements);
#line 113 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->elements = _tmp2_;
#line 116 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = self->priv->elements;
#line 116 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp3_ == NULL) {
#line 1325 "rygel-item-creator.c"
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_;
#line 117 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp4_ = _ ("'Elements' argument missing.");
#line 117 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp5_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp4_);
#line 117 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp5_;
#line 117 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1338 "rygel-item-creator.c"
	} else {
		GPatternSpec* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
#line 119 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp6_ = rygel_item_creator_comment_pattern;
#line 119 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp7_ = self->priv->elements;
#line 119 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp8_ = g_pattern_match_string (_tmp6_, _tmp7_);
#line 119 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_tmp8_) {
#line 1351 "rygel-item-creator.c"
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_;
#line 120 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_tmp9_ = _ ("Comments not allowed in XML");
#line 120 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_tmp10_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp9_);
#line 120 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_inner_error_ = _tmp10_;
#line 120 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_propagate_error (error, _inner_error_);
#line 120 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return;
#line 1364 "rygel-item-creator.c"
		}
	}
#line 124 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp11_ = self->priv->container_id;
#line 124 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp11_ == NULL) {
#line 1371 "rygel-item-creator.c"
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_;
#line 126 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp12_ = _ ("No such object");
#line 126 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _tmp12_);
#line 126 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp13_;
#line 126 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 126 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1384 "rygel-item-creator.c"
	}
}


/**
     * Parse the given DIDL-Lite snippet.
     *
     * Parses the DIDL-Lite and performs checking of the passed meta-data
     * according to UPnP and DLNA guidelines.
     */
static void __lambda4_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item) {
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
#line 138 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (didl_item != NULL);
#line 139 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = didl_item;
#line 139 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 139 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_item);
#line 139 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->didl_item = _tmp1_;
#line 1408 "rygel-item-creator.c"
}


static void ___lambda4__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
#line 138 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	__lambda4_ (self, item);
#line 1415 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_didl (RygelItemCreator* self, GError** error) {
	GUPnPDIDLLiteParser* _tmp0_;
	GUPnPDIDLLiteItem* _tmp4_;
	gboolean _tmp10_ = FALSE;
	GUPnPDIDLLiteItem* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp17_;
	GUPnPDIDLLiteItem* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GUPnPDIDLLiteItem* _tmp23_;
	GUPnPOCMFlags _tmp24_;
	GUPnPOCMFlags _tmp25_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	GUPnPDIDLLiteItem* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean _tmp35_;
	gboolean _tmp40_;
	GUPnPDIDLLiteItem* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	GError * _inner_error_ = NULL;
#line 137 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = self->priv->didl_parser;
#line 138 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_signal_connect_object (_tmp0_, "item-available", (GCallback) ___lambda4__gupnp_didl_lite_parser_item_available, self, 0);
#line 1450 "rygel-item-creator.c"
	{
		GUPnPDIDLLiteParser* _tmp1_;
		const gchar* _tmp2_;
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp1_ = self->priv->didl_parser;
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp2_ = self->priv->elements;
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		gupnp_didl_lite_parser_parse_didl (_tmp1_, _tmp2_, &_inner_error_);
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_inner_error_ != NULL) {
#line 1462 "rygel-item-creator.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* parse_err = NULL;
		GError* _tmp3_;
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		parse_err = _inner_error_;
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = NULL;
#line 145 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
#line 145 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp3_;
#line 145 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_error_free0 (parse_err);
#line 1481 "rygel-item-creator.c"
		goto __finally2;
	}
	__finally2:
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_inner_error_ != NULL) {
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1491 "rygel-item-creator.c"
	}
#line 148 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp4_ = self->priv->didl_item;
#line 148 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp4_ == NULL) {
#line 1497 "rygel-item-creator.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* message;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
#line 149 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp5_ = _ ("No items in DIDL-Lite from client: '%s'");
#line 149 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 149 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		message = _tmp6_;
#line 151 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp7_ = message;
#line 151 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp8_ = self->priv->elements;
#line 151 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp7_, _tmp8_);
#line 151 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp9_;
#line 151 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 151 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (message);
#line 151 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1524 "rygel-item-creator.c"
	}
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp11_ = self->priv->didl_item;
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp12_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _tmp11_);
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp13_ = _tmp12_;
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp13_ == NULL) {
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp10_ = TRUE;
#line 1536 "rygel-item-creator.c"
	} else {
		GUPnPDIDLLiteItem* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp14_ = self->priv->didl_item;
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp15_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _tmp14_);
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp16_ = _tmp15_;
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp10_ = g_strcmp0 (_tmp16_, "") != 0;
#line 1549 "rygel-item-creator.c"
	}
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp17_ = _tmp10_;
#line 155 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp17_) {
#line 1555 "rygel-item-creator.c"
		GError* _tmp18_;
#line 156 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp18_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "@id must be set to \"\" in " "CreateItem");
#line 156 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp18_;
#line 156 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1565 "rygel-item-creator.c"
	}
#line 161 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp19_ = self->priv->didl_item;
#line 161 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp20_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _tmp19_);
#line 161 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp21_ = _tmp20_;
#line 161 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp21_ == NULL) {
#line 1575 "rygel-item-creator.c"
		GError* _tmp22_;
#line 162 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp22_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "dc:title must be set in " "CreateItem");
#line 162 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp22_;
#line 162 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 162 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1585 "rygel-item-creator.c"
	}
#line 168 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp23_ = self->priv->didl_item;
#line 168 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp24_ = gupnp_didl_lite_object_get_dlna_managed ((GUPnPDIDLLiteObject*) _tmp23_);
#line 168 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp25_ = _tmp24_;
#line 168 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if ((_tmp25_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0) {
#line 1595 "rygel-item-creator.c"
		GError* _tmp26_;
#line 172 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp26_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Flags that must not be set " "were found in 'dlnaManaged'");
#line 172 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp26_;
#line 172 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 172 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1605 "rygel-item-creator.c"
	}
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp29_ = self->priv->didl_item;
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp30_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp29_);
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp31_ = _tmp30_;
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp31_ == NULL) {
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp28_ = TRUE;
#line 1617 "rygel-item-creator.c"
	} else {
		GUPnPDIDLLiteItem* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp32_ = self->priv->didl_item;
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp33_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp32_);
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp34_ = _tmp33_;
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp28_ = g_strcmp0 (_tmp34_, "") == 0;
#line 1630 "rygel-item-creator.c"
	}
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp35_ = _tmp28_;
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp35_) {
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp27_ = TRUE;
#line 1638 "rygel-item-creator.c"
	} else {
		GUPnPDIDLLiteItem* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gboolean _tmp39_ = FALSE;
#line 179 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp36_ = self->priv->didl_item;
#line 179 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp37_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp36_);
#line 179 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp38_ = _tmp37_;
#line 179 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp39_ = g_str_has_prefix (_tmp38_, "object.item");
#line 179 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp27_ = !_tmp39_;
#line 1654 "rygel-item-creator.c"
	}
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp40_ = _tmp27_;
#line 177 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp40_) {
#line 1660 "rygel-item-creator.c"
		GError* _tmp41_;
#line 180 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp41_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid upnp:class given ");
#line 180 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp41_;
#line 180 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 180 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1670 "rygel-item-creator.c"
	}
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp42_ = self->priv->didl_item;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp43_ = gupnp_didl_lite_object_get_restricted ((GUPnPDIDLLiteObject*) _tmp42_);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp44_ = _tmp43_;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp44_) {
#line 1680 "rygel-item-creator.c"
		GError* _tmp45_;
#line 185 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp45_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Cannot create restricted item");
#line 185 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp45_;
#line 185 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 185 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 1690 "rygel-item-creator.c"
	}
}


/**
     * Modify the give UPnP class to be a more general one.
     *
     * Used to simplify the search for a valid container in the
     * DLNA.ORG_AnyContainer use-case.
     * Example: object.item.videoItem.videoBroadcast → object.item.videoItem
     *
     * @param upnp_class the current UPnP class which will be modified in-place.
     */
static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* needle;
	gchar* _tmp2_;
#line 199 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 199 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (*upnp_class != NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = *upnp_class;
#line 200 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) (-1), ".");
#line 200 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	needle = _tmp1_;
#line 201 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = needle;
#line 201 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp2_ != NULL) {
#line 1723 "rygel-item-creator.c"
		gchar* _tmp3_;
		gchar _tmp4_;
#line 202 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp3_ = needle;
#line 202 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		*_tmp3_ = '\0';
#line 202 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp4_ = *_tmp3_;
#line 1732 "rygel-item-creator.c"
	}
}


static void rygel_item_creator_find_any_container_data_free (gpointer _data) {
	RygelItemCreatorFindAnyContainerData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorFindAnyContainerData, _data_);
#line 1746 "rygel-item-creator.c"
}


static void rygel_item_creator_find_any_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFindAnyContainerData* _data_;
	RygelItemCreator* _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorFindAnyContainerData);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_find_any_container);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_find_any_container_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_find_any_container_co (_data_);
#line 1765 "rygel-item-creator.c"
}


static RygelMediaObject* rygel_item_creator_find_any_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelItemCreatorFindAnyContainerData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return NULL;
#line 1776 "rygel-item-creator.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 1786 "rygel-item-creator.c"
}


/**
     * Find a container that can create items matching the UPnP class of the
     * requested item.
     *
     * If the item's UPnP class cannot be found, generalize the UPnP class until
     * we reach object.item according to DLNA guideline 7.3.120.4.
     *
     * @returns a container able to create the item or null if no such container
     *          can be found.
     */
static void rygel_item_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFindAnyContainerData* _data_;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_find_any_container_co (_data_);
#line 1810 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_find_any_container_co (RygelItemCreatorFindAnyContainerData* _data_) {
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 0:
#line 1819 "rygel-item-creator.c"
		goto _state_0;
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 1:
#line 1823 "rygel-item-creator.c"
		goto _state_1;
		default:
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 1828 "rygel-item-creator.c"
	}
	_state_0:
#line 217 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->content_dir;
#line 217 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
#line 217 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp2_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp1_) ? ((RygelSearchableContainer*) _data_->_tmp1_) : NULL);
#line 217 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->root_container = _data_->_tmp2_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp3_ = _data_->root_container;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp3_ == NULL) {
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->result = NULL;
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1851 "rygel-item-creator.c"
		} else {
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1855 "rygel-item-creator.c"
		}
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 1861 "rygel-item-creator.c"
	}
#line 224 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp4_ = _data_->self->priv->didl_item;
#line 224 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp5_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp4_);
#line 224 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 224 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
#line 224 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->upnp_class = _data_->_tmp7_;
#line 226 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp8_ = rygel_relational_expression_new ();
#line 226 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->expression = _data_->_tmp8_;
#line 227 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp9_ = _data_->expression;
#line 227 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	((RygelSearchExpression*) _data_->_tmp9_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
#line 228 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp10_ = _data_->expression;
#line 228 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp11_ = g_strdup ("upnp:createClass");
#line 228 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand1);
#line 228 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	((RygelSearchExpression*) _data_->_tmp10_)->operand1 = _data_->_tmp11_;
#line 230 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	while (TRUE) {
#line 230 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp12_ = _data_->upnp_class;
#line 230 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (!(g_strcmp0 (_data_->_tmp12_, "object.item") != 0)) {
#line 230 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			break;
#line 1897 "rygel-item-creator.c"
		}
#line 231 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp13_ = _data_->expression;
#line 231 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp14_ = _data_->upnp_class;
#line 231 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
#line 231 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (((RygelSearchExpression*) _data_->_tmp13_)->operand2);
#line 231 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		((RygelSearchExpression*) _data_->_tmp13_)->operand2 = _data_->_tmp15_;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp16_ = _data_->root_container;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp17_ = _data_->expression;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp19_ = _data_->_tmp18_;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp20_ = 0;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 1;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_searchable_container_search (_data_->_tmp16_, (RygelSearchExpression*) _data_->_tmp17_, 0, 1, _data_->_tmp19_, rygel_item_creator_find_any_container_ready, _data_);
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 1925 "rygel-item-creator.c"
		_state_1:
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp21_ = NULL;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp16_, _data_->_res_, &_data_->_tmp20_);
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->total_matches = (guint) _data_->_tmp20_;
#line 234 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_result_ = _data_->_tmp21_;
#line 239 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp22_ = _data_->_result_;
#line 239 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp22_);
#line 239 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp24_ = _data_->_tmp23_;
#line 239 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp24_ > 0) {
#line 240 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp25_ = _data_->self->priv->didl_item;
#line 240 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp26_ = _data_->upnp_class;
#line 240 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp25_, _data_->_tmp26_);
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp27_ = _data_->_result_;
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp28_ = NULL;
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp27_, 0);
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->result = (RygelMediaObject*) _data_->_tmp28_;
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->_result_);
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_free0 (_data_->upnp_class);
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1969 "rygel-item-creator.c"
			} else {
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1973 "rygel-item-creator.c"
			}
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 242 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return FALSE;
#line 1979 "rygel-item-creator.c"
		} else {
#line 244 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			rygel_item_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
#line 1983 "rygel-item-creator.c"
		}
#line 230 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->_result_);
#line 1987 "rygel-item-creator.c"
	}
#line 248 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp29_ = _data_->upnp_class;
#line 248 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_strcmp0 (_data_->_tmp29_, "object.item") == 0) {
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp30_ = _data_->self->priv->didl_item;
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp31_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp30_);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp32_ = _data_->_tmp31_;
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp33_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' UPnP class unsupported", _data_->_tmp32_);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp33_;
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_data_->upnp_class);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2017 "rygel-item-creator.c"
		} else {
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2021 "rygel-item-creator.c"
		}
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 2027 "rygel-item-creator.c"
	}
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->result = NULL;
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_data_->upnp_class);
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2041 "rygel-item-creator.c"
	} else {
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2045 "rygel-item-creator.c"
	}
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 254 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_data_->upnp_class);
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2061 "rygel-item-creator.c"
	} else {
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2065 "rygel-item-creator.c"
	}
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 216 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 2071 "rygel-item-creator.c"
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorFetchContainerData, _data_);
#line 2084 "rygel-item-creator.c"
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	RygelItemCreator* _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_fetch_container_co (_data_);
#line 2103 "rygel-item-creator.c"
}


static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return NULL;
#line 2114 "rygel-item-creator.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 2124 "rygel-item-creator.c"
}


/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return a instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_fetch_container_co (_data_);
#line 2148 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_) {
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 0:
#line 2157 "rygel-item-creator.c"
		goto _state_0;
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 1:
#line 2161 "rygel-item-creator.c"
		goto _state_1;
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 2:
#line 2165 "rygel-item-creator.c"
		goto _state_2;
		default:
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 2170 "rygel-item-creator.c"
	}
	_state_0:
#line 268 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->media_object = NULL;
#line 270 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->container_id;
#line 270 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_strcmp0 (_data_->_tmp0_, "DLNA.ORG_AnyContainer") == 0) {
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 1;
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_find_any_container (_data_->self, rygel_item_creator_fetch_container_ready, _data_);
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 2185 "rygel-item-creator.c"
		_state_1:
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp1_ = NULL;
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp1_ = rygel_item_creator_find_any_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2205 "rygel-item-creator.c"
			} else {
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2209 "rygel-item-creator.c"
			}
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return FALSE;
#line 2215 "rygel-item-creator.c"
		}
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 271 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->media_object = _data_->_tmp2_;
#line 2221 "rygel-item-creator.c"
	} else {
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp3_ = _data_->self->priv->content_dir;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp4_ = _data_->_tmp3_->root_container;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp5_ = _data_->self->priv->container_id;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 2;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_media_container_find_object (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_, rygel_item_creator_fetch_container_ready, _data_);
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 2239 "rygel-item-creator.c"
		_state_2:
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp8_ = NULL;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp8_ = rygel_media_container_find_object_finish (_data_->_tmp4_, _data_->_res_);
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->media_object = _data_->_tmp8_;
#line 2249 "rygel-item-creator.c"
	}
#line 277 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp10_ = _data_->media_object;
#line 277 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp10_ == NULL) {
#line 277 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp9_ = TRUE;
#line 2257 "rygel-item-creator.c"
	} else {
#line 277 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp11_ = _data_->media_object;
#line 277 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp9_ = !RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp11_);
#line 2263 "rygel-item-creator.c"
	}
#line 277 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp12_ = _data_->_tmp9_;
#line 277 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp12_) {
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp13_ = NULL;
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp13_ = _ ("No such object");
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp14_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp13_);
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp14_;
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2287 "rygel-item-creator.c"
		} else {
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2291 "rygel-item-creator.c"
		}
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 2297 "rygel-item-creator.c"
	} else {
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp16_ = _data_->media_object;
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp17_ = _data_->_tmp16_->ocm_flags;
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (!((_data_->_tmp17_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD)) {
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp15_ = TRUE;
#line 2307 "rygel-item-creator.c"
		} else {
#line 281 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp18_ = _data_->media_object;
#line 281 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp15_ = !RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp18_);
#line 2313 "rygel-item-creator.c"
		}
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp19_ = _data_->_tmp15_;
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp19_) {
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp20_ = NULL;
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp20_ = _ ("Object creation in %s not allowed");
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp21_ = _data_->media_object;
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp22_ = _data_->_tmp21_->id;
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp23_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp20_, _data_->_tmp22_);
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp23_;
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2341 "rygel-item-creator.c"
			} else {
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2345 "rygel-item-creator.c"
			}
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 282 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return FALSE;
#line 2351 "rygel-item-creator.c"
		}
	}
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp24_ = _data_->media_object;
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp25_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp24_) ? ((RygelWritableContainer*) _data_->_tmp24_) : NULL);
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->result = _data_->_tmp25_;
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2366 "rygel-item-creator.c"
	} else {
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2370 "rygel-item-creator.c"
	}
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 289 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2382 "rygel-item-creator.c"
	} else {
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2386 "rygel-item-creator.c"
	}
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 267 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 2392 "rygel-item-creator.c"
}


static void rygel_item_creator_conclude (RygelItemCreator* self) {
	GUPnPDIDLLiteWriter* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* didl;
	RygelServiceAction* _tmp2_;
	RygelMediaItem* _tmp3_;
	const gchar* _tmp4_;
	RygelServiceAction* _tmp5_;
#line 292 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 294 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = self->priv->didl_writer;
#line 294 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = gupnp_didl_lite_writer_get_string (_tmp0_);
#line 294 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	didl = _tmp1_;
#line 297 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = self->priv->action;
#line 297 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = self->priv->item;
#line 297 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp4_ = ((RygelMediaObject*) _tmp3_)->id;
#line 297 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp4_, "Result", G_TYPE_STRING, didl);
#line 300 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp5_ = self->priv->action;
#line 300 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_service_action_return (_tmp5_);
#line 301 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 292 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (didl);
#line 2428 "rygel-item-creator.c"
}


static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
#line 304 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 305 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _error_;
#line 305 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 2444 "rygel-item-creator.c"
		RygelServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 306 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp1_ = self->priv->action;
#line 306 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp2_ = _error_;
#line 306 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp3_ = _tmp2_->code;
#line 306 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp4_ = _error_;
#line 306 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp5_ = _tmp4_->message;
#line 306 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_service_action_return_error (_tmp1_, _tmp3_, _tmp5_);
#line 2462 "rygel-item-creator.c"
	} else {
		RygelServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 308 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp6_ = self->priv->action;
#line 308 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp7_ = _error_;
#line 308 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp8_ = _tmp7_->message;
#line 308 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_service_action_return_error (_tmp6_, 701, _tmp8_);
#line 2475 "rygel-item-creator.c"
	}
#line 311 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp9_ = _ ("Failed to create item under '%s': %s");
#line 311 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp10_ = self->priv->container_id;
#line 311 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp11_ = _error_;
#line 311 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp12_ = _tmp11_->message;
#line 311 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_warning (_tmp9_, _tmp10_, _tmp12_);
#line 315 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 2489 "rygel-item-creator.c"
}


static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
	gchar* result = NULL;
	RygelMediaItem* _tmp0_;
#line 318 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 319 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = self->priv->item;
#line 319 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (RYGEL_IS_IMAGE_ITEM (_tmp0_)) {
#line 2502 "rygel-item-creator.c"
		gchar* _tmp1_;
#line 320 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp1_ = g_strdup ("image");
#line 320 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		result = _tmp1_;
#line 320 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return result;
#line 2510 "rygel-item-creator.c"
	} else {
		RygelMediaItem* _tmp2_;
#line 321 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp2_ = self->priv->item;
#line 321 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (RYGEL_IS_VIDEO_ITEM (_tmp2_)) {
#line 2517 "rygel-item-creator.c"
			gchar* _tmp3_;
#line 322 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_tmp3_ = g_strdup ("video");
#line 322 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			result = _tmp3_;
#line 322 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return result;
#line 2525 "rygel-item-creator.c"
		} else {
			gchar* _tmp4_;
#line 324 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_tmp4_ = g_strdup ("audio");
#line 324 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			result = _tmp4_;
#line 324 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return result;
#line 2534 "rygel-item-creator.c"
		}
	}
}


static void rygel_item_creator_create_item_from_didl_data_free (gpointer _data) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->container);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorCreateItemFromDidlData, _data_);
#line 2549 "rygel-item-creator.c"
}


static void rygel_item_creator_create_item_from_didl (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorCreateItemFromDidlData);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_item_from_didl);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_item_from_didl_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = container;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->container = _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_create_item_from_didl_co (_data_);
#line 2576 "rygel-item-creator.c"
}


static void rygel_item_creator_create_item_from_didl_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 2586 "rygel-item-creator.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2590 "rygel-item-creator.c"
}


/**
     * Transfer information passed by caller to a MediaItem.
     *
     * WritableContainer works on MediaItem so we transfer the supplied data to
     * one. Additionally some checks are performed (e.g. whether the DLNA
     * profile is supported or not) or sanitize the supplied title for use as
     * part of the on-disk filename.
     *
     * This function fills ItemCreator.item.
     */
static void _g_object_unref0_ (gpointer var) {
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2607 "rygel-item-creator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_list_free (self);
#line 2616 "rygel-item-creator.c"
}


static void rygel_item_creator_create_item_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateItemFromDidlData* _data_;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_create_item_from_didl_co (_data_);
#line 2630 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_create_item_from_didl_co (RygelItemCreatorCreateItemFromDidlData* _data_) {
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 0:
#line 2639 "rygel-item-creator.c"
		goto _state_0;
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 1:
#line 2643 "rygel-item-creator.c"
		goto _state_1;
		default:
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 2648 "rygel-item-creator.c"
	}
	_state_0:
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->didl_item;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp1_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp0_);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp3_ = _data_->container;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp4_ = _data_->self->priv->didl_item;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp5_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _data_->_tmp4_);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp7_ = _data_->self->priv->didl_item;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp8_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp7_);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp10_ = NULL;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp10_ = rygel_item_creator_create_item (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp6_, _data_->_tmp9_, &_data_->_inner_error_);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2687 "rygel-item-creator.c"
		} else {
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2691 "rygel-item-creator.c"
		}
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 2697 "rygel-item-creator.c"
	}
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self->priv->item);
#line 340 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->self->priv->item = _data_->_tmp11_;
#line 345 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp12_ = _data_->self->priv->didl_item;
#line 345 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp13_ = NULL;
#line 345 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp13_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _data_->_tmp12_);
#line 345 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->resources = _data_->_tmp13_;
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp15_ = _data_->resources;
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp15_ != NULL) {
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp16_ = _data_->resources;
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp17_ = 0U;
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp17_ = g_list_length (_data_->_tmp16_);
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp14_ = _data_->_tmp17_ > ((guint) 0);
#line 2723 "rygel-item-creator.c"
	} else {
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp14_ = FALSE;
#line 2727 "rygel-item-creator.c"
	}
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp18_ = _data_->_tmp14_;
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp18_) {
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp19_ = _data_->resources;
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp20_ = NULL;
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp20_ = g_list_nth (_data_->_tmp19_, (guint) 0);
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp21_ = _data_->_tmp20_->data;
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp22_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) _data_->_tmp21_);
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->resource = _data_->_tmp22_;
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp23_ = _data_->resource;
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp24_ = gupnp_didl_lite_resource_get_protocol_info (_data_->_tmp23_);
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp26_ = _g_object_ref0 (_data_->_tmp25_);
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->info = _data_->_tmp26_;
#line 350 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp27_ = _data_->info;
#line 350 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp27_ != NULL) {
#line 351 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp28_ = _data_->info;
#line 351 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp29_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp28_);
#line 351 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp30_ = _data_->_tmp29_;
#line 351 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			if (_data_->_tmp30_ != NULL) {
#line 352 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp31_ = _data_->info;
#line 352 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp32_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp31_);
#line 352 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp33_ = _data_->_tmp32_;
#line 352 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp34_ = FALSE;
#line 352 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp34_ = rygel_item_creator_is_profile_valid (_data_->self, _data_->_tmp33_);
#line 352 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				if (!_data_->_tmp34_) {
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					_data_->_tmp35_ = _data_->info;
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					_data_->_tmp36_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp35_);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					_data_->_tmp37_ = _data_->_tmp36_;
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					_data_->_tmp38_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' DLNA profile unsupported", _data_->_tmp37_);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					_data_->_inner_error_ = _data_->_tmp38_;
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					g_error_free (_data_->_inner_error_);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					_g_object_unref0 (_data_->info);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					_g_object_unref0 (_data_->resource);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					__g_list_free__g_object_unref0_0 (_data_->resources);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					if (_data_->_state_ == 0) {
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2803 "rygel-item-creator.c"
					} else {
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 2807 "rygel-item-creator.c"
					}
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					g_object_unref (_data_->_async_result);
#line 353 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					return FALSE;
#line 2813 "rygel-item-creator.c"
				}
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp39_ = _data_->self->priv->item;
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp40_ = _data_->info;
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp41_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp40_);
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp42_ = _data_->_tmp41_;
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp43_ = g_strdup (_data_->_tmp42_);
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_g_free0 (_data_->_tmp39_->dlna_profile);
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp39_->dlna_profile = _data_->_tmp43_;
#line 2829 "rygel-item-creator.c"
			}
#line 361 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp44_ = _data_->info;
#line 361 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp45_ = gupnp_protocol_info_get_mime_type (_data_->_tmp44_);
#line 361 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp46_ = _data_->_tmp45_;
#line 361 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			if (_data_->_tmp46_ != NULL) {
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp47_ = _data_->self->priv->item;
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp48_ = _data_->info;
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp49_ = gupnp_protocol_info_get_mime_type (_data_->_tmp48_);
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp50_ = _data_->_tmp49_;
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp51_ = g_strdup (_data_->_tmp50_);
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_g_free0 (_data_->_tmp47_->mime_type);
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp47_->mime_type = _data_->_tmp51_;
#line 2853 "rygel-item-creator.c"
			}
		}
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp52_ = _data_->resource;
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp53_ = gupnp_didl_lite_resource_get_uri (_data_->_tmp52_);
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp54_ = _data_->_tmp53_;
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp55_ = NULL;
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp56_ = FALSE;
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp56_ = rygel_item_creator_is_valid_uri (_data_->self, _data_->_tmp54_, &_data_->_tmp55_);
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_data_->sanitized_uri);
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->sanitized_uri = _data_->_tmp55_;
#line 367 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp56_) {
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp57_ = _data_->self->priv->item;
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp58_ = _data_->sanitized_uri;
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			rygel_media_object_add_uri ((RygelMediaObject*) _data_->_tmp57_, _data_->_tmp58_);
#line 2880 "rygel-item-creator.c"
		}
#line 371 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp59_ = _data_->resource;
#line 371 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp60_ = gupnp_didl_lite_resource_get_size (_data_->_tmp59_);
#line 371 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp61_ = _data_->_tmp60_;
#line 371 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp61_ >= ((glong) 0)) {
#line 372 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp62_ = _data_->self->priv->item;
#line 372 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp63_ = _data_->resource;
#line 372 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp64_ = gupnp_didl_lite_resource_get_size (_data_->_tmp63_);
#line 372 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp65_ = _data_->_tmp64_;
#line 372 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp62_->size = _data_->_tmp65_;
#line 2900 "rygel-item-creator.c"
		}
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_data_->sanitized_uri);
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->info);
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->resource);
#line 2908 "rygel-item-creator.c"
	}
#line 376 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp66_ = _data_->self->priv->item;
#line 376 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp67_ = _data_->_tmp66_->mime_type;
#line 376 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp67_ == NULL) {
#line 377 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp68_ = _data_->self->priv->item;
#line 377 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp69_ = NULL;
#line 377 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp69_ = rygel_item_creator_get_generic_mime_type (_data_->self);
#line 377 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_data_->_tmp68_->mime_type);
#line 377 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp68_->mime_type = _data_->_tmp69_;
#line 2926 "rygel-item-creator.c"
	}
#line 380 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp70_ = _data_->self->priv->item;
#line 380 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp71_ = _data_->_tmp70_->size;
#line 380 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp71_ < ((glong) 0)) {
#line 381 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp72_ = _data_->self->priv->item;
#line 381 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp72_->size = (glong) 0;
#line 2938 "rygel-item-creator.c"
	}
#line 384 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp73_ = _data_->self->priv->item;
#line 384 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp74_ = ((RygelMediaObject*) _data_->_tmp73_)->uris;
#line 384 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp75_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp74_);
#line 384 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp76_ = _data_->_tmp75_;
#line 384 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp76_ == 0) {
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp77_ = _data_->container;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp78_ = _data_->self->priv->item;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp79_ = ((RygelMediaObject*) _data_->_tmp78_)->title;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_state_ = 1;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_item_creator_create_uri (_data_->self, _data_->_tmp77_, _data_->_tmp79_, rygel_item_creator_create_item_from_didl_ready, _data_);
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 2962 "rygel-item-creator.c"
		_state_1:
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp80_ = NULL;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp80_ = rygel_item_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->uri = _data_->_tmp80_;
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			__g_list_free__g_object_unref0_0 (_data_->resources);
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2982 "rygel-item-creator.c"
			} else {
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2986 "rygel-item-creator.c"
			}
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 385 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return FALSE;
#line 2992 "rygel-item-creator.c"
		}
#line 386 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp81_ = _data_->self->priv->item;
#line 386 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp82_ = ((RygelMediaObject*) _data_->_tmp81_)->uris;
#line 386 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp83_ = _data_->uri;
#line 386 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp82_, _data_->_tmp83_);
#line 387 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp84_ = _data_->self->priv->item;
#line 387 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp84_->place_holder = TRUE;
#line 384 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_data_->uri);
#line 3008 "rygel-item-creator.c"
	} else {
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp85_ = _data_->self->priv->item;
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp86_ = ((RygelMediaObject*) _data_->_tmp85_)->uris;
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp87_ = NULL;
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp87_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp86_, 0);
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp88_ = (gchar*) _data_->_tmp87_;
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp89_ = NULL;
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp89_ = g_file_new_for_uri (_data_->_tmp88_);
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp90_ = _data_->_tmp89_;
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_data_->_tmp88_);
#line 389 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->file = _data_->_tmp90_;
#line 390 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp91_ = _data_->self->priv->item;
#line 390 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp92_ = _data_->file;
#line 390 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp93_ = FALSE;
#line 390 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp93_ = g_file_is_native (_data_->_tmp92_);
#line 390 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp91_->place_holder = !_data_->_tmp93_;
#line 384 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->file);
#line 3042 "rygel-item-creator.c"
	}
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp94_ = _data_->self->priv->item;
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp95_ = _data_->self->priv->item;
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp96_ = ((RygelMediaObject*) _data_->_tmp95_)->uris;
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp97_ = NULL;
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp97_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp96_, 0);
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (((RygelMediaObject*) _data_->_tmp94_)->id);
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	((RygelMediaObject*) _data_->_tmp94_)->id = (gchar*) _data_->_tmp97_;
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_parse_and_verify_didl_date (_data_->self, &_data_->_inner_error_);
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		__g_list_free__g_object_unref0_0 (_data_->resources);
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3072 "rygel-item-creator.c"
		} else {
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3076 "rygel-item-creator.c"
		}
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 395 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 3082 "rygel-item-creator.c"
	}
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	__g_list_free__g_object_unref0_0 (_data_->resources);
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3090 "rygel-item-creator.c"
	} else {
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3094 "rygel-item-creator.c"
	}
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 3100 "rygel-item-creator.c"
}


static void _vala_SoupDate_free (SoupDate* self) {
#line 407 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_boxed_free (soup_date_get_type (), self);
#line 3107 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_and_verify_didl_date (RygelItemCreator* self, GError** error) {
	GUPnPDIDLLiteItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPDIDLLiteItem* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SoupDate* _tmp6_;
	SoupDate* parsed_date;
	SoupDate* _tmp7_;
	gint year;
	gint month;
	gint day;
	GUPnPDIDLLiteItem* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_ = 0;
	GDate date = {0};
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gboolean _tmp22_ = FALSE;
	RygelMediaItem* _tmp27_;
	GUPnPDIDLLiteItem* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	GError * _inner_error_ = NULL;
#line 398 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 399 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = self->priv->didl_item;
#line 399 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp0_);
#line 399 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = _tmp1_;
#line 399 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp2_ == NULL) {
#line 400 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 3151 "rygel-item-creator.c"
	}
#line 403 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = self->priv->didl_item;
#line 403 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp4_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp3_);
#line 403 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp5_ = _tmp4_;
#line 403 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp6_ = soup_date_new_from_string (_tmp5_);
#line 403 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	parsed_date = _tmp6_;
#line 404 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp7_ = parsed_date;
#line 404 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp7_ != NULL) {
#line 3167 "rygel-item-creator.c"
		RygelMediaItem* _tmp8_;
		SoupDate* _tmp9_;
		gchar* _tmp10_ = NULL;
#line 405 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp8_ = self->priv->item;
#line 405 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp9_ = parsed_date;
#line 405 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp10_ = soup_date_to_string (_tmp9_, SOUP_DATE_ISO8601);
#line 405 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_tmp8_->date);
#line 405 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp8_->date = _tmp10_;
#line 407 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 407 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 3185 "rygel-item-creator.c"
	}
#line 410 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	year = 0;
#line 410 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	month = 0;
#line 410 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	day = 0;
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp11_ = self->priv->didl_item;
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp12_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp11_);
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp13_ = _tmp12_;
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp14_ = sscanf (_tmp13_, "%4d-%02d-%02d", &year, &month, &day);
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp14_ != 3) {
#line 3203 "rygel-item-creator.c"
		GUPnPDIDLLiteItem* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp15_ = self->priv->didl_item;
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp16_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp15_);
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp17_ = _tmp16_;
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp18_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid date format: %s", _tmp17_);
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp18_;
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 3224 "rygel-item-creator.c"
	}
#line 421 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	memset (&date, 0, sizeof (GDate));
#line 422 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp19_ = day;
#line 422 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp20_ = month;
#line 422 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp21_ = year;
#line 422 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_date_set_dmy (&date, (GDateDay) _tmp19_, (gint) ((GDateMonth) _tmp20_), (GDateYear) _tmp21_);
#line 424 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp22_ = g_date_valid (&date);
#line 424 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (!_tmp22_) {
#line 3240 "rygel-item-creator.c"
		GUPnPDIDLLiteItem* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GError* _tmp26_;
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp23_ = self->priv->didl_item;
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp24_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp23_);
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp25_ = _tmp24_;
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp26_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid date: %s", _tmp25_);
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_inner_error_ = _tmp26_;
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 425 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return;
#line 3261 "rygel-item-creator.c"
	}
#line 430 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp27_ = self->priv->item;
#line 430 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp28_ = self->priv->didl_item;
#line 430 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp29_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp28_);
#line 430 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp30_ = _tmp29_;
#line 430 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp31_ = g_strconcat (_tmp30_, "T00:00:00", NULL);
#line 430 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_tmp27_->date);
#line 430 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp27_->date = _tmp31_;
#line 398 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	__vala_SoupDate_free0 (parsed_date);
#line 3279 "rygel-item-creator.c"
}


static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
#line 433 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 433 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 433 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 433 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 433 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = upnp_class;
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = _tmp0_;
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		switch (0) {
#line 3309 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp4_;
				RygelWritableContainer* _tmp5_;
				const gchar* _tmp6_;
				RygelImageItem* _tmp7_;
#line 439 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp4_ = id;
#line 439 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp5_ = parent;
#line 439 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp6_ = title;
#line 439 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_);
#line 439 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp7_;
#line 439 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				return result;
#line 3328 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		switch (0) {
#line 3334 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp8_;
				RygelWritableContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelPhotoItem* _tmp11_;
#line 441 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp8_ = id;
#line 441 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp9_ = parent;
#line 441 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp10_ = title;
#line 441 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_);
#line 441 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp11_;
#line 441 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				return result;
#line 3353 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		switch (0) {
#line 3359 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp12_;
				RygelWritableContainer* _tmp13_;
				const gchar* _tmp14_;
				RygelVideoItem* _tmp15_;
#line 443 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp12_ = id;
#line 443 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp13_ = parent;
#line 443 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp14_ = title;
#line 443 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_);
#line 443 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp15_;
#line 443 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				return result;
#line 3378 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		switch (0) {
#line 3384 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp16_;
				RygelWritableContainer* _tmp17_;
				const gchar* _tmp18_;
				RygelAudioItem* _tmp19_;
#line 445 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp16_ = id;
#line 445 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp17_ = parent;
#line 445 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp18_ = title;
#line 445 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_);
#line 445 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp19_;
#line 445 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				return result;
#line 3403 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		switch (0) {
#line 3409 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp20_;
				RygelWritableContainer* _tmp21_;
				const gchar* _tmp22_;
				RygelMusicItem* _tmp23_;
#line 447 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp20_ = id;
#line 447 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp21_ = parent;
#line 447 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp22_ = title;
#line 447 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_);
#line 447 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp23_;
#line 447 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				return result;
#line 3428 "rygel-item-creator.c"
			}
		}
	} else {
#line 437 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		switch (0) {
#line 3434 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp24_;
				GError* _tmp25_;
#line 449 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp24_ = upnp_class;
#line 449 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp25_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", _tmp24_);
#line 449 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_inner_error_ = _tmp25_;
#line 449 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_propagate_error (error, _inner_error_);
#line 449 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				return NULL;
#line 3449 "rygel-item-creator.c"
			}
		}
	}
}


/**
     * Simple check for the validity of an URI.
     *
     * Check is done by parsing the URI with soup. Additionaly a cleaned-up
     * version of the URI is returned in sanitized_uri.
     *
     * @param uri the input URI
     * @param sanitized_uri containes a sanitized version of the URI on return
     * @returns true if the URI is valid, false otherwise.
     */
static void _vala_SoupURI_free (SoupURI* self) {
#line 475 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 3469 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri, gchar** sanitized_uri) {
	gchar* _vala_sanitized_uri = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	SoupURI* _tmp5_;
	SoupURI* soup_uri;
	gboolean _tmp6_ = FALSE;
	SoupURI* _tmp7_;
	gboolean _tmp10_;
	SoupURI* _tmp11_;
	gchar* _tmp12_ = NULL;
#line 466 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 467 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_vala_sanitized_uri);
#line 467 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_vala_sanitized_uri = NULL;
#line 468 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = uri;
#line 468 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp1_ == NULL) {
#line 468 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp0_ = TRUE;
#line 3499 "rygel-item-creator.c"
	} else {
		const gchar* _tmp2_;
#line 468 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp2_ = uri;
#line 468 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 3506 "rygel-item-creator.c"
	}
#line 468 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = _tmp0_;
#line 468 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp3_) {
#line 469 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		result = FALSE;
#line 469 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (sanitized_uri) {
#line 469 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			*sanitized_uri = _vala_sanitized_uri;
#line 3518 "rygel-item-creator.c"
		} else {
#line 469 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_free0 (_vala_sanitized_uri);
#line 3522 "rygel-item-creator.c"
		}
#line 469 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return result;
#line 3526 "rygel-item-creator.c"
	}
#line 472 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp4_ = uri;
#line 472 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp5_ = soup_uri_new (_tmp4_);
#line 472 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	soup_uri = _tmp5_;
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp7_ = soup_uri;
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp7_ == NULL) {
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp6_ = TRUE;
#line 3540 "rygel-item-creator.c"
	} else {
		SoupURI* _tmp8_;
		const gchar* _tmp9_;
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp8_ = soup_uri;
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp9_ = _tmp8_->scheme;
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_tmp6_ = _tmp9_ == NULL;
#line 3550 "rygel-item-creator.c"
	}
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp10_ = _tmp6_;
#line 474 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_tmp10_) {
#line 475 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		result = FALSE;
#line 475 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		__vala_SoupURI_free0 (soup_uri);
#line 475 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (sanitized_uri) {
#line 475 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			*sanitized_uri = _vala_sanitized_uri;
#line 3564 "rygel-item-creator.c"
		} else {
#line 475 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_free0 (_vala_sanitized_uri);
#line 3568 "rygel-item-creator.c"
		}
#line 475 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return result;
#line 3572 "rygel-item-creator.c"
	}
#line 478 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp11_ = soup_uri;
#line 478 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp12_ = soup_uri_to_string (_tmp11_, FALSE);
#line 478 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_vala_sanitized_uri);
#line 478 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_vala_sanitized_uri = _tmp12_;
#line 480 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = TRUE;
#line 480 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	__vala_SoupURI_free0 (soup_uri);
#line 480 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (sanitized_uri) {
#line 480 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		*sanitized_uri = _vala_sanitized_uri;
#line 3590 "rygel-item-creator.c"
	} else {
#line 480 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (_vala_sanitized_uri);
#line 3594 "rygel-item-creator.c"
	}
#line 480 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 3598 "rygel-item-creator.c"
}


/**
     * Transform the title to be usable on legacy file-systems such as FAT32.
     *
     * The function trims down the title to 205 chars (leaving room for an UUID)
     * and replaces all special characters.
     *
     * @param title of the the media item
     * @return the cleaned and shortened title
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1304 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1304 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1304 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1304 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1305 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1305 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 3630 "rygel-item-creator.c"
		glong _tmp4_;
#line 1306 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1306 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1306 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		return result;
#line 3638 "rygel-item-creator.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1308 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1308 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1308 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1308 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		return result;
#line 3650 "rygel-item-creator.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1315 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1317 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1317 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 3675 "rygel-item-creator.c"
		glong _tmp2_;
#line 1317 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1317 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 3681 "rygel-item-creator.c"
	} else {
#line 1317 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3685 "rygel-item-creator.c"
	}
#line 1317 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1317 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 3691 "rygel-item-creator.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1319 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1319 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1319 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1319 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 3703 "rygel-item-creator.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1321 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1321 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1321 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 3713 "rygel-item-creator.c"
	}
#line 1324 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1324 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 3719 "rygel-item-creator.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1325 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1325 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1325 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1326 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1326 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 3733 "rygel-item-creator.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1328 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1328 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1328 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 3743 "rygel-item-creator.c"
	}
#line 1330 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1330 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 3749 "rygel-item-creator.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1331 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1331 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1331 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 3758 "rygel-item-creator.c"
	}
#line 1333 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1333 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1333 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1333 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1334 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1334 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1334 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1334 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1334 "/opt/gnome2/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 3778 "rygel-item-creator.c"
}


static gchar* rygel_item_creator_mangle_title (RygelItemCreator* self, const gchar* title, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* mangled;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
#line 492 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 492 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 493 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = title;
#line 493 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = title;
#line 493 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = strlen (_tmp1_);
#line 493 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = _tmp2_;
#line 493 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp4_ = MIN (_tmp3_, 205);
#line 493 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp5_ = string_substring (_tmp0_, (glong) 0, (glong) _tmp4_);
#line 493 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	mangled = _tmp5_;
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp6_ = self->priv->title_regex;
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp7_ = mangled;
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp8_ = g_regex_replace_literal (_tmp6_, _tmp7_, (gssize) (-1), 0, "_", G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp9_ = _tmp8_;
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_inner_error_ != NULL) {
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_free0 (mangled);
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return NULL;
#line 3830 "rygel-item-creator.c"
	}
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (mangled);
#line 494 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	mangled = _tmp9_;
#line 500 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = mangled;
#line 500 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 3840 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri_data_free (gpointer _data) {
	RygelItemCreatorCreateUriData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->container);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_data_->title);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_data_->result);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorCreateUriData, _data_);
#line 3857 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorCreateUriData);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_uri);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_uri_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = container;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->container = _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp3_ = title;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->title = _tmp4_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_create_uri_co (_data_);
#line 3892 "rygel-item-creator.c"
}


static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelItemCreatorCreateUriData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return NULL;
#line 3903 "rygel-item-creator.c"
	}
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 3913 "rygel-item-creator.c"
}


/**
     * Create an URI from the item's title.
     *
     * Create an unique URI from the supplied title by cleaning it from
     * unwanted characters, shortening it and adding an UUID.
     *
     * @param container to create the item in
     * @param title of the item to base the name on
     * @returns an URI for the newly created item
     */
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_create_uri_co (_data_);
#line 3937 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_) {
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 0:
#line 3946 "rygel-item-creator.c"
		goto _state_0;
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 1:
#line 3950 "rygel-item-creator.c"
		goto _state_1;
		default:
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 3955 "rygel-item-creator.c"
	}
	_state_0:
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_state_ = 1;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_writable_container_get_writable (_data_->_tmp0_, _data_->_tmp2_, rygel_item_creator_create_uri_ready, _data_);
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 3970 "rygel-item-creator.c"
	_state_1:
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp3_ = NULL;
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp3_ = rygel_writable_container_get_writable_finish (_data_->_tmp0_, _data_->_res_);
#line 515 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->dir = _data_->_tmp3_;
#line 516 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp4_ = _data_->dir;
#line 516 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_tmp4_ == NULL) {
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp5_ = NULL;
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp5_ = _ ("Object creation in %s not allowed");
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp6_ = _data_->container;
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->id;
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp8_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp5_, _data_->_tmp7_);
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4004 "rygel-item-creator.c"
		} else {
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4008 "rygel-item-creator.c"
		}
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 517 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 4014 "rygel-item-creator.c"
	}
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp9_ = _data_->title;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp10_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp10_ = rygel_item_creator_mangle_title (_data_->self, _data_->_tmp9_, &_data_->_inner_error_);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4036 "rygel-item-creator.c"
		} else {
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4040 "rygel-item-creator.c"
		}
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 4046 "rygel-item-creator.c"
	}
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp12_ = _data_->dir;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp13_ = _data_->_tmp11_;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp14_ = NULL;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp14_ = g_file_get_child_for_display_name (_data_->_tmp12_, _data_->_tmp13_, &_data_->_inner_error_);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_data_->_tmp13_);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->file = _data_->_tmp15_;
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4074 "rygel-item-creator.c"
		} else {
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4078 "rygel-item-creator.c"
		}
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 522 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		return FALSE;
#line 4084 "rygel-item-creator.c"
	}
#line 524 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp16_ = NULL;
#line 524 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp16_ = g_new0 (guchar, 50);
#line 524 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->udn = _data_->_tmp16_;
#line 524 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->udn_length1 = 50;
#line 524 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_udn_size_ = _data_->udn_length1;
#line 525 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp17_ = NULL;
#line 525 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp17_ = g_new0 (guchar, 16);
#line 525 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->id = _data_->_tmp17_;
#line 525 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->id_length1 = 16;
#line 525 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_id_size_ = _data_->id_length1;
#line 527 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp18_ = _data_->id;
#line 527 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp18__length1 = _data_->id_length1;
#line 527 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	uuid_generate (_data_->_tmp18_);
#line 528 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp19_ = _data_->id;
#line 528 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp19__length1 = _data_->id_length1;
#line 528 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp20_ = _data_->udn;
#line 528 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp20__length1 = _data_->udn_length1;
#line 528 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	uuid_unparse (_data_->_tmp19_, _data_->_tmp20_);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp21_ = _data_->file;
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp22_ = NULL;
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp22_ = g_file_get_uri (_data_->_tmp21_);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp24_ = _data_->udn;
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp24__length1 = _data_->udn_length1;
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp25_ = g_strconcat (_data_->_tmp23_, (const gchar*) _data_->_tmp24_, NULL);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp26_ = _data_->_tmp25_;
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (_data_->_tmp23_);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->result = _data_->_tmp26_;
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->id = (g_free (_data_->id), NULL);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->udn = (g_free (_data_->udn), NULL);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->file);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4154 "rygel-item-creator.c"
	} else {
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4158 "rygel-item-creator.c"
	}
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 530 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->id = (g_free (_data_->id), NULL);
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->udn = (g_free (_data_->udn), NULL);
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->file);
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4176 "rygel-item-creator.c"
	} else {
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4180 "rygel-item-creator.c"
	}
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 513 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 4186 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_data_free (gpointer _data) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->container);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorWaitForItemData, _data_);
#line 4199 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorWaitForItemData);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_wait_for_item);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_wait_for_item_data_free);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = container;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->container = _tmp2_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data_);
#line 4226 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_) {
	RygelItemCreatorWaitForItemData* _data_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 4234 "rygel-item-creator.c"
}


/**
     * Wait for the new item
     *
     * When creating an item in the back-end via WritableContainer.add_item
     * there might be a delay between the creation and the back-end having the
     * newly created item available. This function waits for the item to become
     * available by hooking into the container_updated signal. The maximum time
     * to wait is 5 seconds.
     *
     * @param container to watch
     */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return _data4_;
#line 4254 "rygel-item-creator.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 4263 "rygel-item-creator.c"
		RygelItemCreator * self;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		self = _data4_->self;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (_data4_->container);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_g_object_unref0 (self);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_slice_free (Block4Data, _data4_);
#line 4273 "rygel-item-creator.c"
	}
}


static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data_);
#line 4288 "rygel-item-creator.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return _data5_;
#line 4297 "rygel-item-creator.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 4306 "rygel-item-creator.c"
		RygelItemCreator * self;
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		self = _data5_->_data4_->self;
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		block4_data_unref (_data5_->_data4_);
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data5_->_data4_ = NULL;
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_slice_free (Block5Data, _data5_);
#line 4316 "rygel-item-creator.c"
	}
}


static void ____lambda5_ (Block5Data* _data5_, RygelMediaContainer* container) {
	Block4Data* _data4_;
	RygelItemCreator * self;
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data4_ = _data5_->_data4_;
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self = _data4_->self;
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_if_fail (container != NULL);
#line 564 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data4_->_async_data_);
#line 4332 "rygel-item-creator.c"
}


static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	____lambda5_ (self, container);
#line 4339 "rygel-item-creator.c"
}


static gboolean ____lambda6_ (Block5Data* _data5_) {
	Block4Data* _data4_;
	RygelItemCreator * self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_;
	const gchar* _tmp1_;
#line 568 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data4_ = _data5_->_data4_;
#line 568 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self = _data4_->self;
#line 569 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = _data4_->container;
#line 569 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 569 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:569: Timeout on waiting for 'updated' signal o" \
"n '%s'.", _tmp1_);
#line 571 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data5_->timeout = (guint) 0;
#line 572 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data4_->_async_data_);
#line 574 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = FALSE;
#line 574 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 4367 "rygel-item-creator.c"
}


static gboolean _____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda6_ (self);
#line 568 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 4376 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_) {
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 0:
#line 4385 "rygel-item-creator.c"
		goto _state_0;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 1:
#line 4389 "rygel-item-creator.c"
		goto _state_1;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case 2:
#line 4393 "rygel-item-creator.c"
		goto _state_2;
		default:
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 4398 "rygel-item-creator.c"
	}
	_state_0:
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_data4_ = g_slice_new0 (Block4Data);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_data4_->_ref_count_ = 1;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_data4_->self = g_object_ref (_data_->self);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_data4_->container = _data_->_tmp1_;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_data4_->_async_data_ = _data_;
#line 545 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp2_ = _data_->_data4_->container;
#line 545 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp3_ = ((RygelMediaObject*) _data_->_tmp2_)->id;
#line 545 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:545: Waiting for new item to appear under cont" \
"ainer '%s'..", _data_->_tmp3_);
#line 548 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->item = NULL;
#line 550 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	while (TRUE) {
#line 550 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp4_ = _data_->item;
#line 550 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (!(_data_->_tmp4_ == NULL)) {
#line 550 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			break;
#line 4431 "rygel-item-creator.c"
		}
		{
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp5_ = _data_->_data4_->container;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp6_ = _data_->self->priv->item;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->id;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_state_ = 1;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp5_, _data_->_tmp7_, _data_->_tmp9_, rygel_item_creator_wait_for_item_ready, _data_);
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return FALSE;
#line 4450 "rygel-item-creator.c"
			_state_1:
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp10_ = NULL;
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp10_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp5_, _data_->_res_);
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->item);
#line 552 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->item = RYGEL_IS_MEDIA_ITEM (_data_->_tmp10_) ? ((RygelMediaItem*) _data_->_tmp10_) : NULL;
#line 4460 "rygel-item-creator.c"
		}
		goto __finally3;
		__catch3_g_error:
		{
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_error_ = _data_->_inner_error_;
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_inner_error_ = NULL;
#line 556 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp11_ = _data_->_data4_->container;
#line 556 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp12_ = ((RygelMediaObject*) _data_->_tmp11_)->id;
#line 556 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp13_ = _data_->self->priv->item;
#line 556 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp14_ = ((RygelMediaObject*) _data_->_tmp13_)->id;
#line 556 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_warning ("Error from container '%s' on trying to find newly " "added child item '%s' in it", _data_->_tmp12_, _data_->_tmp14_);
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_error_free0 (_data_->_error_);
#line 4481 "rygel-item-creator.c"
		}
		__finally3:
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_g_object_unref0 (_data_->item);
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			block4_data_unref (_data_->_data4_);
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_data4_ = NULL;
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 551 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return FALSE;
#line 4498 "rygel-item-creator.c"
		}
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		_data_->_tmp15_ = _data_->item;
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		if (_data_->_tmp15_ == NULL) {
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_data5_ = g_slice_new0 (Block5Data);
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_data5_->_ref_count_ = 1;
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp16_ = _data_->_data4_->container;
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp17_ = 0UL;
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp17_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp16_, "container-updated", (GCallback) _____lambda5__rygel_media_container_container_updated, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
#line 563 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->id = _data_->_tmp17_;
#line 567 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_data5_->timeout = (guint) 0;
#line 568 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp18_ = 0U;
#line 568 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp18_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda6__gsource_func, block5_data_ref (_data_->_data5_), block5_data_unref);
#line 568 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_data5_->timeout = _data_->_tmp18_;
#line 577 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_state_ = 2;
#line 577 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			return FALSE;
#line 4530 "rygel-item-creator.c"
			_state_2:
			;
#line 579 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp19_ = _data_->_data4_->container;
#line 579 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp20_ = _data_->id;
#line 579 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			g_signal_handler_disconnect ((GObject*) _data_->_tmp19_, _data_->_tmp20_);
#line 581 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_tmp21_ = _data_->_data5_->timeout;
#line 581 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			if (_data_->_tmp21_ != ((guint) 0)) {
#line 582 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_tmp22_ = _data_->_data5_->timeout;
#line 582 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				g_source_remove (_data_->_tmp22_);
#line 4547 "rygel-item-creator.c"
			} else {
#line 584 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				block5_data_unref (_data_->_data5_);
#line 584 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_data_->_data5_ = NULL;
#line 584 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				break;
#line 4555 "rygel-item-creator.c"
			}
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			block5_data_unref (_data_->_data5_);
#line 562 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			_data_->_data5_ = NULL;
#line 4561 "rygel-item-creator.c"
		}
	}
#line 588 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp23_ = _data_->_data4_->container;
#line 588 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_tmp24_ = ((RygelMediaObject*) _data_->_tmp23_)->id;
#line 588 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:588: Finished waiting for new item to appear u" \
"nder container '%s'", _data_->_tmp24_);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (_data_->item);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	block4_data_unref (_data_->_data4_);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_data_->_data4_ = NULL;
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4580 "rygel-item-creator.c"
	} else {
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4584 "rygel-item-creator.c"
	}
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 544 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return FALSE;
#line 4590 "rygel-item-creator.c"
}


/**
     * Check if the profile is supported.
     *
     * The check is performed against GUPnP-DLNA's database explicitly excluding
     * the transcoders.
     *
     * @param profile to check
     * @returns true if the profile is supported, false otherwise.
     */
static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GUPnPDLNADiscoverer* _tmp0_;
	GUPnPDLNADiscoverer* discoverer;
	gboolean valid;
	GUPnPDLNADiscoverer* _tmp1_;
	GList* _tmp2_ = NULL;
#line 601 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 601 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_return_val_if_fail (profile != NULL, FALSE);
#line 602 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, FALSE);
#line 602 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	discoverer = _tmp0_;
#line 606 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	valid = FALSE;
#line 607 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = discoverer;
#line 607 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp2_ = gupnp_dlna_discoverer_list_profiles (_tmp1_);
#line 4624 "rygel-item-creator.c"
	{
		GList* known_profile_collection = NULL;
		GList* known_profile_it = NULL;
#line 607 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		known_profile_collection = _tmp2_;
#line 607 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		for (known_profile_it = known_profile_collection; known_profile_it != NULL; known_profile_it = known_profile_it->next) {
#line 4632 "rygel-item-creator.c"
			GUPnPDLNAProfile* known_profile = NULL;
#line 607 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
			known_profile = (GUPnPDLNAProfile*) known_profile_it->data;
#line 4636 "rygel-item-creator.c"
			{
				GUPnPDLNAProfile* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
#line 608 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp3_ = known_profile;
#line 608 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp4_ = gupnp_dlna_profile_get_name (_tmp3_);
#line 608 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp5_ = _tmp4_;
#line 608 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				_tmp6_ = profile;
#line 608 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
				if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
#line 609 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					valid = TRUE;
#line 611 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
					break;
#line 4656 "rygel-item-creator.c"
				}
			}
		}
	}
#line 615 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = valid;
#line 615 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (discoverer);
#line 615 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 4667 "rygel-item-creator.c"
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	GCancellable* _tmp0_;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = self->priv->_cancellable;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	return result;
#line 4683 "rygel-item-creator.c"
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv->_cancellable = _tmp1_;
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 4703 "rygel-item-creator.c"
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	GPatternSpec* _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_creator_get_property;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_creator_set_property;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", G_TYPE_CANCELLABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 30 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
#line 30 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_comment_pattern = _tmp0_;
#line 4725 "rygel-item-creator.c"
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_creator_real_run;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	iface->run_finish = rygel_item_creator_real_run_finish;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
#line 4740 "rygel-item-creator.c"
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
#line 4747 "rygel-item-creator.c"
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	self = RYGEL_ITEM_CREATOR (obj);
#line 35 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (self->priv->container_id);
#line 36 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_free0 (self->priv->elements);
#line 38 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_item);
#line 39 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->item);
#line 41 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 42 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->action);
#line 43 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_writer);
#line 44 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 45 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_regex_unref0 (self->priv->title_regex);
#line 47 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
#line 4777 "rygel-item-creator.c"
}


/**
 * CreateObject action implementation.
 */
GType rygel_item_creator_get_type (void) {
	static volatile gsize rygel_item_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_creator_type_id;
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_creator_type_id__volatile, rygel_item_creator_type_id);
	}
	return rygel_item_creator_type_id__volatile;
}


static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		break;
#line 4809 "rygel-item-creator.c"
		default:
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		break;
#line 4815 "rygel-item-creator.c"
	}
}


static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		break;
#line 4831 "rygel-item-creator.c"
		default:
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/tests/rygel-item-creator.vala"
		break;
#line 4837 "rygel-item-creator.c"
	}
}



