/* rygel-mpris-player.c generated by valac 0.15.1.36-84b2b, the Vala compiler
 * generated from rygel-mpris-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gst/gst.h>


#define RYGEL_MPRIS_TYPE_PLAYER (rygel_mpris_player_get_type ())
#define RYGEL_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer))
#define RYGEL_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))
#define RYGEL_MPRIS_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))

typedef struct _RygelMPRISPlayer RygelMPRISPlayer;
typedef struct _RygelMPRISPlayerClass RygelMPRISPlayerClass;
typedef struct _RygelMPRISPlayerPrivate RygelMPRISPlayerPrivate;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY (rygel_mpris_media_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxy))
#define RYGEL_MPRIS_IS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerProxy RygelMPRISMediaPlayerProxy;
typedef struct _RygelMPRISMediaPlayerProxyIface RygelMPRISMediaPlayerProxyIface;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY_PROXY (rygel_mpris_media_player_proxy_proxy_get_type ())

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY (rygel_mpris_media_player_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxy))
#define RYGEL_MPRIS_MEDIA_PLAYER_IS_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerPlayerProxy RygelMPRISMediaPlayerPlayerProxy;
typedef struct _RygelMPRISMediaPlayerPlayerProxyIface RygelMPRISMediaPlayerPlayerProxyIface;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY_PROXY (rygel_mpris_media_player_player_proxy_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MPRIS_TYPE_PLUGIN (rygel_mpris_plugin_get_type ())
#define RYGEL_MPRIS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin))
#define RYGEL_MPRIS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))
#define RYGEL_MPRIS_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))

typedef struct _RygelMPRISPlugin RygelMPRISPlugin;
typedef struct _RygelMPRISPluginClass RygelMPRISPluginClass;
typedef struct _RygelMPRISPluginPrivate RygelMPRISPluginPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _RygelMPRISPlayer {
	GObject parent_instance;
	RygelMPRISPlayerPrivate * priv;
};

struct _RygelMPRISPlayerClass {
	GObjectClass parent_class;
};

struct _RygelMPRISMediaPlayerProxyIface {
	GTypeInterface parent_iface;
	gchar* (*get_identity) (RygelMPRISMediaPlayerProxy* self);
	gchar** (*get_supported_uri_schemes) (RygelMPRISMediaPlayerProxy* self, int* result_length1);
	gchar** (*get_supported_mime_types) (RygelMPRISMediaPlayerProxy* self, int* result_length1);
};

struct _RygelMPRISMediaPlayerPlayerProxyIface {
	GTypeInterface parent_iface;
	void (*pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play_pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*stop) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*seek) (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
	void (*open_uri) (RygelMPRISMediaPlayerPlayerProxy* self, const gchar* uri, GError** error);
	gchar* (*get_playback_status) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_volume) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_volume) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gint64 (*get_position) (RygelMPRISMediaPlayerPlayerProxy* self);
	GHashTable* (*get_metadata) (RygelMPRISMediaPlayerPlayerProxy* self);
};

struct _RygelMPRISPlayerPrivate {
	gchar** protocols;
	gint protocols_length1;
	gint _protocols_size_;
	gchar** mime_types;
	gint mime_types_length1;
	gint _mime_types_size_;
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
};

struct _RygelMPRISPlugin {
	RygelMediaRendererPlugin parent_instance;
	RygelMPRISPluginPrivate * priv;
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
	gchar** mime_types;
	gint mime_types_length1;
	gchar** protocols;
	gint protocols_length1;
};

struct _RygelMPRISPluginClass {
	RygelMediaRendererPluginClass parent_class;
};


static gpointer rygel_mpris_player_parent_class = NULL;
static RygelMediaPlayerIface* rygel_mpris_player_rygel_media_player_parent_iface = NULL;

GType rygel_mpris_player_get_type (void) G_GNUC_CONST;
GType rygel_mpris_media_player_proxy_get_type (void) G_GNUC_CONST;
GType rygel_mpris_media_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_mpris_media_player_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_player_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_mpris_media_player_player_proxy_get_type (void) G_GNUC_CONST;
#define RYGEL_MPRIS_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerPrivate))
enum  {
	RYGEL_MPRIS_PLAYER_DUMMY_PROPERTY,
	RYGEL_MPRIS_PLAYER_PLAYBACK_STATE,
	RYGEL_MPRIS_PLAYER_URI,
	RYGEL_MPRIS_PLAYER_VOLUME,
	RYGEL_MPRIS_PLAYER_DURATION,
	RYGEL_MPRIS_PLAYER_POSITION
};
GType rygel_mpris_plugin_get_type (void) G_GNUC_CONST;
RygelMPRISPlayer* rygel_mpris_player_new (RygelMPRISPlugin* plugin);
RygelMPRISPlayer* rygel_mpris_player_construct (GType object_type, RygelMPRISPlugin* plugin);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void rygel_mpris_player_on_properties_changed (RygelMPRISPlayer* self, GDBusProxy* actual_player, GVariant* changed, gchar** invalidated, int invalidated_length1);
static void _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static gboolean rygel_mpris_player_real_seek (RygelMediaPlayer* base, GstClockTime time);
void rygel_mpris_media_player_player_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
static gchar** rygel_mpris_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** rygel_mpris_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar* rygel_mpris_player_mpris_to_upnp_state (RygelMPRISPlayer* self, const gchar* state);
static gchar* _variant_get1 (GVariant* value);
gchar* rygel_mpris_media_player_player_proxy_get_playback_status (RygelMPRISMediaPlayerPlayerProxy* self);
void rygel_mpris_media_player_player_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
GHashTable* rygel_mpris_media_player_player_proxy_get_metadata (RygelMPRISMediaPlayerPlayerProxy* self);
static const gchar* _variant_get2 (GVariant* value);
void rygel_mpris_media_player_player_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, const gchar* uri, GError** error);
gdouble rygel_mpris_media_player_player_proxy_get_volume (RygelMPRISMediaPlayerPlayerProxy* self);
void rygel_mpris_media_player_player_proxy_set_volume (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
static gint64 _variant_get3 (GVariant* value);
gint64 rygel_mpris_media_player_player_proxy_get_position (RygelMPRISMediaPlayerPlayerProxy* self);
static void rygel_mpris_player_finalize (GObject* obj);
static void _vala_rygel_mpris_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_mpris_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	rygel_mpris_player_on_properties_changed (self, _sender, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


RygelMPRISPlayer* rygel_mpris_player_construct (GType object_type, RygelMPRISPlugin* plugin) {
	RygelMPRISPlayer * self = NULL;
	RygelMPRISPlugin* _tmp0_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp1_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp2_;
	RygelMPRISPlugin* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	RygelMPRISPlugin* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	RygelMPRISMediaPlayerPlayerProxy* _tmp9_;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (RygelMPRISPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = plugin;
	_tmp1_ = _tmp0_->actual_player;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->actual_player);
	self->priv->actual_player = _tmp2_;
	_tmp3_ = plugin;
	_tmp4_ = _tmp3_->mime_types;
	_tmp4__length1 = _tmp3_->mime_types_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types = _tmp5_;
	self->priv->mime_types_length1 = _tmp5__length1;
	self->priv->_mime_types_size_ = self->priv->mime_types_length1;
	_tmp6_ = plugin;
	_tmp7_ = _tmp6_->protocols;
	_tmp7__length1 = _tmp6_->protocols_length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup2 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->priv->protocols = _tmp8_;
	self->priv->protocols_length1 = _tmp8__length1;
	self->priv->_protocols_size_ = self->priv->protocols_length1;
	_tmp9_ = self->priv->actual_player;
	g_signal_connect_object ((GDBusProxy*) _tmp9_, "g-properties-changed", (GCallback) _rygel_mpris_player_on_properties_changed_g_dbus_proxy_g_properties_changed, self, 0);
	return self;
}


RygelMPRISPlayer* rygel_mpris_player_new (RygelMPRISPlugin* plugin) {
	return rygel_mpris_player_construct (RYGEL_MPRIS_TYPE_PLAYER, plugin);
}


static gboolean rygel_mpris_player_real_seek (RygelMediaPlayer* base, GstClockTime time) {
	RygelMPRISPlayer * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (RygelMPRISPlayer*) base;
	ret = FALSE;
	{
		RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
		GstClockTime _tmp1_;
		_tmp0_ = self->priv->actual_player;
		_tmp1_ = time;
		rygel_mpris_media_player_player_proxy_seek (_tmp0_, (gint64) (_tmp1_ / 1000), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		ret = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = ret;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_mpris_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelMPRISPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->protocols;
	_tmp0__length1 = self->priv->protocols_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_mpris_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelMPRISPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->mime_types;
	_tmp0__length1 = self->priv->mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar* rygel_mpris_player_mpris_to_upnp_state (RygelMPRISPlayer* self, const gchar* state) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = state;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Stopped")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("STOPPED");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Paused")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("PAUSED_PLAYBACK");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("Playing")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("PLAYING");
				result = _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static void rygel_mpris_player_on_properties_changed (RygelMPRISPlayer* self, GDBusProxy* actual_player, GVariant* changed, gchar** invalidated, int invalidated_length1) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (actual_player != NULL);
	g_return_if_fail (changed != NULL);
	{
		GVariant* _tmp0_;
		GVariantIter* _tmp1_ = NULL;
		GVariantIter* _changed_prop_it;
		GVariant* changed_prop = NULL;
		_tmp0_ = changed;
		_tmp1_ = g_variant_iter_new (_tmp0_);
		_changed_prop_it = _tmp1_;
		while (TRUE) {
			GVariantIter* _tmp2_;
			GVariant* _tmp3_ = NULL;
			GVariant* _tmp4_;
			GVariant* _tmp5_;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* key;
			GVariant* _tmp10_;
			GVariant* _tmp11_ = NULL;
			GVariant* _tmp12_;
			GVariant* _tmp13_ = NULL;
			GVariant* _tmp14_;
			GVariant* value;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			GQuark _tmp18_ = 0U;
			static GQuark _tmp17_label0 = 0;
			static GQuark _tmp17_label1 = 0;
			static GQuark _tmp17_label2 = 0;
			static GQuark _tmp17_label3 = 0;
			static GQuark _tmp17_label4 = 0;
			_tmp2_ = _changed_prop_it;
			_tmp3_ = g_variant_iter_next_value (_tmp2_);
			_g_variant_unref0 (changed_prop);
			changed_prop = _tmp3_;
			_tmp4_ = changed_prop;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = changed_prop;
			_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 0);
			_tmp7_ = _tmp6_;
			_tmp8_ = _variant_get1 (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_variant_unref0 (_tmp7_);
			key = _tmp9_;
			_tmp10_ = changed_prop;
			_tmp11_ = g_variant_get_child_value (_tmp10_, (gsize) 1);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_variant_get_child_value (_tmp12_, (gsize) 0);
			_tmp14_ = _tmp13_;
			_g_variant_unref0 (_tmp12_);
			value = _tmp14_;
			_tmp15_ = key;
			_tmp16_ = _tmp15_;
			_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
			if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("PlaybackStatus")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "playback-state");
						break;
					}
				}
			} else if (_tmp18_ == ((0 != _tmp17_label1) ? _tmp17_label1 : (_tmp17_label1 = g_quark_from_static_string ("Volume")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "volume");
						break;
					}
				}
			} else if (_tmp18_ == ((0 != _tmp17_label2) ? _tmp17_label2 : (_tmp17_label2 = g_quark_from_static_string ("Metadata")))) {
				switch (0) {
					default:
					{
						GDBusProxy* _tmp19_;
						GVariant* _tmp20_;
						gchar** _tmp21_ = NULL;
						gchar** _tmp22_;
						gint _tmp22__length1;
						_tmp19_ = actual_player;
						_tmp20_ = value;
						_tmp21_ = g_new0 (gchar*, 0 + 1);
						_tmp22_ = _tmp21_;
						_tmp22__length1 = 0;
						rygel_mpris_player_on_properties_changed (self, _tmp19_, _tmp20_, _tmp22_, 0);
						_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
						break;
					}
				}
			} else if (_tmp18_ == ((0 != _tmp17_label3) ? _tmp17_label3 : (_tmp17_label3 = g_quark_from_static_string ("xesam:url")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "uri");
						break;
					}
				}
			} else if (_tmp18_ == ((0 != _tmp17_label4) ? _tmp17_label4 : (_tmp17_label4 = g_quark_from_static_string ("mpris:length")))) {
				switch (0) {
					default:
					{
						g_object_notify ((GObject*) self, "duration");
						break;
					}
				}
			}
			_g_variant_unref0 (value);
			_g_free0 (key);
		}
		_g_variant_unref0 (changed_prop);
		_g_variant_iter_free0 (_changed_prop_it);
	}
}


static gchar* rygel_mpris_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_playback_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_mpris_player_mpris_to_upnp_state (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static void rygel_mpris_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	GError * _inner_error_ = NULL;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = value;
	g_debug ("rygel-mpris-player.vala:40: Changing playback state to %s..", _tmp0_);
	_tmp1_ = value;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp5_;
					_tmp5_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_stop (_tmp5_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp6_;
					_tmp6_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_pause (_tmp6_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally2:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				{
					RygelMPRISMediaPlayerPlayerProxy* _tmp7_;
					_tmp7_ = self->priv->actual_player;
					rygel_mpris_media_player_player_proxy_play (_tmp7_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch3_g_error;
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally3:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static const gchar* _variant_get2 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar* rygel_mpris_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* val;
	GVariant* _tmp7_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp3_, "xesam:url");
	_tmp5_ = _g_variant_ref0 ((GVariant*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_hash_table_unref0 (_tmp3_);
	val = _tmp6_;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = val;
		_tmp9_ = _variant_get2 (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_variant_unref0 (val);
		return result;
	} else {
		result = NULL;
		_g_variant_unref0 (val);
		return result;
	}
	_g_variant_unref0 (val);
}


static void rygel_mpris_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelMPRISPlayer* self;
	GError * _inner_error_ = NULL;
	self = (RygelMPRISPlayer*) base;
	{
		RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->actual_player;
		_tmp1_ = value;
		rygel_mpris_media_player_player_proxy_open_uri (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject *) self, "uri");
}


static gdouble rygel_mpris_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_volume (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void rygel_mpris_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gdouble _tmp1_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = value;
	rygel_mpris_media_player_player_proxy_set_volume (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "volume");
}


static gint64 _variant_get3 (GVariant* value) {
	return g_variant_get_int64 (value);
}


static gint64 rygel_mpris_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* val;
	gint64 dur;
	GVariant* _tmp7_;
	gint64 _tmp10_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_lookup (_tmp3_, "mpris:length");
	_tmp5_ = _g_variant_ref0 ((GVariant*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_hash_table_unref0 (_tmp3_);
	val = _tmp6_;
	dur = (gint64) 0;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_;
		gint64 _tmp9_;
		_tmp8_ = val;
		_tmp9_ = _variant_get3 (_tmp8_);
		dur = _tmp9_ * 1000;
	}
	_tmp10_ = dur;
	result = _tmp10_;
	_g_variant_unref0 (val);
	return result;
}


static gint64 rygel_mpris_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelMPRISPlayer* self;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	self = (RygelMPRISPlayer*) base;
	_tmp0_ = self->priv->actual_player;
	_tmp1_ = rygel_mpris_media_player_player_proxy_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ * 1000;
	return result;
}


static void rygel_mpris_player_class_init (RygelMPRISPlayerClass * klass) {
	rygel_mpris_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMPRISPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_mpris_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_mpris_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_mpris_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_mpris_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_mpris_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*)(RygelMediaPlayer*, GstClockTime)) rygel_mpris_player_real_seek;
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_mpris_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_mpris_player_real_get_mime_types;
	iface->get_playback_state = rygel_mpris_player_real_get_playback_state;
	iface->set_playback_state = rygel_mpris_player_real_set_playback_state;
	iface->get_uri = rygel_mpris_player_real_get_uri;
	iface->set_uri = rygel_mpris_player_real_set_uri;
	iface->get_volume = rygel_mpris_player_real_get_volume;
	iface->set_volume = rygel_mpris_player_real_set_volume;
	iface->get_duration = rygel_mpris_player_real_get_duration;
	iface->get_position = rygel_mpris_player_real_get_position;
}


static void rygel_mpris_player_instance_init (RygelMPRISPlayer * self) {
	self->priv = RYGEL_MPRIS_PLAYER_GET_PRIVATE (self);
}


static void rygel_mpris_player_finalize (GObject* obj) {
	RygelMPRISPlayer * self;
	self = RYGEL_MPRIS_PLAYER (obj);
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->actual_player);
	G_OBJECT_CLASS (rygel_mpris_player_parent_class)->finalize (obj);
}


GType rygel_mpris_player_get_type (void) {
	static volatile gsize rygel_mpris_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPlayer), 0, (GInstanceInitFunc) rygel_mpris_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_mpris_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_mpris_player_type_id;
		rygel_mpris_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMPRISPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_mpris_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_mpris_player_type_id__volatile, rygel_mpris_player_type_id);
	}
	return rygel_mpris_player_type_id__volatile;
}


static void _vala_rygel_mpris_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMPRISPlayer * self;
	self = RYGEL_MPRIS_PLAYER (object);
	switch (property_id) {
		case RYGEL_MPRIS_PLAYER_PLAYBACK_STATE:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_URI:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_DURATION:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_MPRIS_PLAYER_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_mpris_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMPRISPlayer * self;
	self = RYGEL_MPRIS_PLAYER (object);
	switch (property_id) {
		case RYGEL_MPRIS_PLAYER_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_MPRIS_PLAYER_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



