/* plugin.c generated by valac 0.14.0, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libanjuta/libanjuta.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <gio/gio.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <valacodegen.h>


#define TYPE_VALA_PLUGIN (vala_plugin_get_type ())
#define VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PLUGIN, ValaPlugin))
#define VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PLUGIN, ValaPluginClass))
#define IS_VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PLUGIN))
#define IS_VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PLUGIN))
#define VALA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PLUGIN, ValaPluginClass))

typedef struct _ValaPlugin ValaPlugin;
typedef struct _ValaPluginClass ValaPluginClass;
typedef struct _ValaPluginPrivate ValaPluginPrivate;

#define TYPE_BLOCK_LOCATOR (block_locator_get_type ())
#define BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_LOCATOR, BlockLocator))
#define BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_LOCATOR, BlockLocatorClass))
#define IS_BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_LOCATOR))
#define IS_BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_LOCATOR))
#define BLOCK_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_LOCATOR, BlockLocatorClass))

typedef struct _BlockLocator BlockLocator;
typedef struct _BlockLocatorClass BlockLocatorClass;

#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;

#define TYPE_VALA_PROVIDER (vala_provider_get_type ())
#define VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PROVIDER, ValaProvider))
#define VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PROVIDER, ValaProviderClass))
#define IS_VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PROVIDER))
#define IS_VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PROVIDER))
#define VALA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PROVIDER, ValaProviderClass))

typedef struct _ValaProvider ValaProvider;
typedef struct _ValaProviderClass ValaProviderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaPlugin {
	AnjutaPlugin parent_instance;
	ValaPluginPrivate * priv;
	IAnjutaEditor* current_editor;
	GSettings* settings;
};

struct _ValaPluginClass {
	AnjutaPluginClass parent_class;
};

struct _ValaPluginPrivate {
	guint editor_watch_id;
	gulong project_loaded_id;
	ValaCodeContext* context;
	GStaticRecMutex __lock_context;
	GCancellable* cancel;
	BlockLocator* locator;
	AnjutaReport* report;
	ValaProvider* provider;
	ValaParser* parser;
	ValaGenieParser* genie_parser;
	ValaSet* current_sources;
};


static gpointer vala_plugin_parent_class = NULL;
static GType vala_plugin_type_id = 0;

GType vala_plugin_get_type (void) G_GNUC_CONST;
GType vala_plugin_register_type (GTypeModule * module);
GType block_locator_get_type (void) G_GNUC_CONST;
GType block_locator_register_type (GTypeModule * module);
GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
GType vala_provider_get_type (void) G_GNUC_CONST;
GType vala_provider_register_type (GTypeModule * module);
#define VALA_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_PLUGIN, ValaPluginPrivate))
enum  {
	VALA_PLUGIN_DUMMY_PROPERTY
};
BlockLocator* block_locator_new (void);
BlockLocator* block_locator_construct (GType object_type);
#define VALA_PLUGIN_DECL_MARK "/* ANJUTA: Widgets declaration for %s - DO NOT REMOVE */\n"
#define VALA_PLUGIN_INIT_MARK "/* ANJUTA: Widgets initialization for %s - DO NOT REMOVE */\n"
static ValaPlugin* vala_plugin_new (void);
static ValaPlugin* vala_plugin_construct (GType object_type);
static gboolean vala_plugin_real_activate (AnjutaPlugin* base);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void vala_plugin_init_context (ValaPlugin* self);
ValaProvider* vala_provider_new (ValaPlugin* plugin);
ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin);
void vala_plugin_editor_value_added (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name, GValue* value);
static void _vala_plugin_editor_value_added_anjuta_plugin_value_added (AnjutaPlugin* plugin, const gchar* name, GValue* value, gpointer self);
void vala_plugin_editor_value_removed (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name);
static void _vala_plugin_editor_value_removed_anjuta_plugin_value_removed (AnjutaPlugin* plugin, const gchar* name, gpointer self);
static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base);
void anjuta_report_clear_error_indicators (AnjutaReport* self, ValaSourceFile* file);
static void vala_plugin_parse (ValaPlugin* self);
static void ___lambda0_ (ValaPlugin* self);
static gpointer ____lambda0__gthread_func (gpointer self);
static void vala_plugin_add_project_files (ValaPlugin* self);
static void __lambda1_ (ValaPlugin* self, AnjutaProjectNode* node);
static void ___lambda1__anjuta_project_node_foreach_func (AnjutaProjectNode* node, gpointer self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup1 (gchar** self, int length);
void vala_plugin_on_project_loaded (ValaPlugin* self, IAnjutaProjectManager* pm, GError* e);
static void _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded (IAnjutaProjectManager* _sender, GError* _error_, gpointer self);
void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position, gchar ch);
static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditor* _sender, IAnjutaIterable* position, gchar ch, gpointer self);
void vala_plugin_on_file_saved (ValaPlugin* self, IAnjutaFileSavable* savable, GFile* file);
static void _vala_plugin_on_file_saved_ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GFile* file, gpointer self);
gboolean vala_plugin_on_drop_possible (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position);
static gboolean _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, gpointer self);
void vala_plugin_on_drop (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position, const gchar* signal_data);
static void _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, const gchar* signal_data, gpointer self);
static void vala_plugin_insert_member_decl_and_init (ValaPlugin* self, IAnjutaEditor* editor, const gchar* widget_ctype, const gchar* widget_name, const gchar* filename);
static void _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add (IAnjutaEditor* _sender, const gchar* widget_typename, const gchar* widget_name, const gchar* filename, gpointer self);
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file);
#define VALA_PROVIDER_PREF_CALLTIP_ENABLE "cpp-calltip-enable"
void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor);
static ValaSymbol* vala_plugin_get_scope (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position);
ValaSymbol* vala_plugin_get_current_context (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position);
static ValaSymbol* vala_plugin_lookup_symbol_by_cname (ValaPlugin* self, const gchar* cname, ValaSymbol* parent);
static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static gboolean vala_plugin_insert_after_mark (ValaPlugin* self, IAnjutaEditor* editor, const gchar* mark, const gchar* code_to_add);
ValaSymbol* block_locator_locate (BlockLocator* self, ValaSourceFile* file, gint line, gint column);
GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block);
static void vala_plugin_finalize (GObject* obj);
GType anjuta_glue_register_components (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static ValaPlugin* vala_plugin_construct (GType object_type) {
	ValaPlugin * self = NULL;
	self = (ValaPlugin*) g_object_new (object_type, NULL);
	return self;
}


static ValaPlugin* vala_plugin_new (void) {
	return vala_plugin_construct (TYPE_VALA_PLUGIN);
}


static void _vala_plugin_editor_value_added_anjuta_plugin_value_added (AnjutaPlugin* plugin, const gchar* name, GValue* value, gpointer self) {
	vala_plugin_editor_value_added (self, plugin, name, value);
}


static void _vala_plugin_editor_value_removed_anjuta_plugin_value_removed (AnjutaPlugin* plugin, const gchar* name, gpointer self) {
	vala_plugin_editor_value_removed (self, plugin, name);
}


static gboolean vala_plugin_real_activate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	AnjutaReport* _tmp0_;
	AnjutaShell* _tmp1_ = NULL;
	AnjutaShell* _tmp2_;
	AnjutaShell* _tmp3_;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	AnjutaReport* _tmp7_;
	ValaParser* _tmp8_;
	ValaGenieParser* _tmp9_;
	ValaProvider* _tmp10_;
	guint _tmp11_ = 0U;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	g_debug ("plugin.vala:42: Activating ValaPlugin");
	_tmp0_ = anjuta_report_new ();
	_g_object_unref0 (self->priv->report);
	self->priv->report = _tmp0_;
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = anjuta_shell_get_object (_tmp3_, "IAnjutaDocumentManager", &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = self->priv->report;
	anjuta_report_set_docman (_tmp7_, IANJUTA_DOCUMENT_MANAGER (_tmp6_));
	_tmp8_ = vala_parser_new ();
	_vala_code_visitor_unref0 (self->priv->parser);
	self->priv->parser = _tmp8_;
	_tmp9_ = vala_genie_parser_new ();
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	self->priv->genie_parser = _tmp9_;
	vala_plugin_init_context (self);
	_tmp10_ = vala_provider_new (self);
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = _tmp10_;
	_tmp11_ = anjuta_plugin_add_watch ((AnjutaPlugin*) self, "document_manager_current_document", _vala_plugin_editor_value_added_anjuta_plugin_value_added, _vala_plugin_editor_value_removed_anjuta_plugin_value_removed, self);
	self->priv->editor_watch_id = _tmp11_;
	result = TRUE;
	return result;
}


static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	guint _tmp0_;
	GCancellable* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	g_debug ("plugin.vala:59: Deactivating ValaPlugin");
	_tmp0_ = self->priv->editor_watch_id;
	anjuta_plugin_remove_watch ((AnjutaPlugin*) self, _tmp0_, TRUE);
	_tmp1_ = self->priv->cancel;
	g_cancellable_cancel (_tmp1_);
	{
		ValaCodeContext* _tmp2_;
		_tmp2_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			_vala_code_context_unref0 (self->priv->context);
			self->priv->context = NULL;
		}
		__finally0:
		{
			ValaCodeContext* _tmp3_;
			_tmp3_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static void vala_plugin_init_context (ValaPlugin* self) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	AnjutaReport* _tmp3_;
	AnjutaReport* _tmp4_;
	GCancellable* _tmp5_;
	ValaParser* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaGenieParser* _tmp8_;
	ValaCodeContext* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashSet* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	_tmp3_ = self->priv->report;
	vala_code_context_set_report (_tmp2_, (ValaReport*) _tmp3_);
	_tmp4_ = self->priv->report;
	anjuta_report_clear_error_indicators (_tmp4_, NULL);
	_tmp5_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancel);
	self->priv->cancel = _tmp5_;
	_tmp6_ = self->priv->parser;
	_tmp7_ = self->priv->context;
	vala_parser_parse (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->genie_parser;
	_tmp9_ = self->priv->context;
	vala_genie_parser_parse (_tmp8_, _tmp9_);
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp10_, _tmp11_);
	_vala_iterable_unref0 (self->priv->current_sources);
	self->priv->current_sources = (ValaSet*) _tmp12_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ___lambda0_ (ValaPlugin* self) {
	GError * _inner_error_ = NULL;
	{
		ValaCodeContext* _tmp0_;
		_tmp0_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaCodeContext* _tmp1_;
			ValaCodeContext* _tmp2_;
			ValaReport* _tmp3_;
			ValaReport* _tmp4_;
			AnjutaReport* _tmp5_;
			AnjutaReport* report;
			gboolean _tmp33_ = FALSE;
			AnjutaReport* _tmp34_;
			gint _tmp35_ = 0;
			gboolean _tmp38_;
			ValaCodeContext* _tmp40_;
			_tmp1_ = self->priv->context;
			vala_code_context_push (_tmp1_);
			_tmp2_ = self->priv->context;
			_tmp3_ = vala_code_context_get_report (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _g_object_ref0 (IS_ANJUTA_REPORT (_tmp4_) ? ((AnjutaReport*) _tmp4_) : NULL);
			report = _tmp5_;
			{
				ValaCodeContext* _tmp6_;
				ValaList* _tmp7_ = NULL;
				ValaList* _src_list;
				ValaList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _src_size;
				gint _src_index;
				_tmp6_ = self->priv->context;
				_tmp7_ = vala_code_context_get_source_files (_tmp6_);
				_src_list = _tmp7_;
				_tmp8_ = _src_list;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				_src_size = _tmp10_;
				_src_index = -1;
				while (TRUE) {
					gint _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					ValaList* _tmp14_;
					gint _tmp15_;
					gpointer _tmp16_ = NULL;
					ValaSourceFile* src;
					ValaSourceFile* _tmp17_;
					ValaList* _tmp18_ = NULL;
					ValaList* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					gboolean _tmp22_;
					GCancellable* _tmp30_;
					gboolean _tmp31_ = FALSE;
					_tmp11_ = _src_index;
					_src_index = _tmp11_ + 1;
					_tmp12_ = _src_index;
					_tmp13_ = _src_size;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					_tmp14_ = _src_list;
					_tmp15_ = _src_index;
					_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
					src = (ValaSourceFile*) _tmp16_;
					_tmp17_ = src;
					_tmp18_ = vala_source_file_get_nodes (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = _tmp21_ == 0;
					_vala_iterable_unref0 (_tmp19_);
					if (_tmp22_) {
						ValaSourceFile* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						ValaGenieParser* _tmp26_;
						ValaSourceFile* _tmp27_;
						ValaParser* _tmp28_;
						ValaSourceFile* _tmp29_;
						_tmp23_ = src;
						_tmp24_ = vala_source_file_get_filename (_tmp23_);
						_tmp25_ = _tmp24_;
						g_debug ("plugin.vala:96: parsing file %s", _tmp25_);
						_tmp26_ = self->priv->genie_parser;
						_tmp27_ = src;
						vala_code_visitor_visit_source_file ((ValaCodeVisitor*) _tmp26_, _tmp27_);
						_tmp28_ = self->priv->parser;
						_tmp29_ = src;
						vala_code_visitor_visit_source_file ((ValaCodeVisitor*) _tmp28_, _tmp29_);
					}
					_tmp30_ = self->priv->cancel;
					_tmp31_ = g_cancellable_is_cancelled (_tmp30_);
					if (_tmp31_) {
						vala_code_context_pop ();
						_vala_source_file_unref0 (src);
						_vala_iterable_unref0 (_src_list);
						_g_object_unref0 (report);
						{
							ValaCodeContext* _tmp32_;
							_tmp32_ = self->priv->context;
							g_static_rec_mutex_unlock (&self->priv->__lock_context);
						}
						return;
					}
					_vala_source_file_unref0 (src);
				}
				_vala_iterable_unref0 (_src_list);
			}
			_tmp34_ = report;
			_tmp35_ = vala_report_get_errors ((ValaReport*) _tmp34_);
			if (_tmp35_ > 0) {
				_tmp33_ = TRUE;
			} else {
				GCancellable* _tmp36_;
				gboolean _tmp37_ = FALSE;
				_tmp36_ = self->priv->cancel;
				_tmp37_ = g_cancellable_is_cancelled (_tmp36_);
				_tmp33_ = _tmp37_;
			}
			_tmp38_ = _tmp33_;
			if (_tmp38_) {
				vala_code_context_pop ();
				_g_object_unref0 (report);
				{
					ValaCodeContext* _tmp39_;
					_tmp39_ = self->priv->context;
					g_static_rec_mutex_unlock (&self->priv->__lock_context);
				}
				return;
			}
			_tmp40_ = self->priv->context;
			vala_code_context_check (_tmp40_);
			vala_code_context_pop ();
			_g_object_unref0 (report);
		}
		__finally2:
		{
			ValaCodeContext* _tmp41_;
			_tmp41_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer ____lambda0__gthread_func (gpointer self) {
	___lambda0_ (self);
}


static void vala_plugin_parse (ValaPlugin* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_thread_create (____lambda0__gthread_func, self, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch1_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _tmp0_->message;
		g_warning ("plugin.vala:117: cannot create thread : %s", _tmp1_);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda1_ (ValaPlugin* self, AnjutaProjectNode* node) {
	AnjutaProjectNode* _tmp0_;
	AnjutaProjectNodeType _tmp1_ = 0;
	AnjutaProjectNode* _tmp2_;
	GFile* _tmp3_ = NULL;
	AnjutaProjectNode* _tmp4_;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* path;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp17_;
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = anjuta_project_node_get_node_type (_tmp0_);
	if (!((_tmp1_ & ANJUTA_PROJECT_SOURCE) == ANJUTA_PROJECT_SOURCE)) {
		return;
	}
	_tmp2_ = node;
	_tmp3_ = anjuta_project_node_get_file (_tmp2_);
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = node;
	_tmp5_ = anjuta_project_node_get_file (_tmp4_);
	_tmp6_ = g_file_get_path (_tmp5_);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		_g_free0 (path);
		return;
	}
	_tmp10_ = path;
	_tmp11_ = g_str_has_suffix (_tmp10_, ".vala");
	if (_tmp11_) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = path;
		_tmp13_ = g_str_has_suffix (_tmp12_, ".vapi");
		_tmp9_ = _tmp13_;
	}
	_tmp14_ = _tmp9_;
	if (_tmp14_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp15_ = path;
		_tmp16_ = g_str_has_suffix (_tmp15_, ".gs");
		_tmp8_ = _tmp16_;
	}
	_tmp17_ = _tmp8_;
	if (_tmp17_) {
		ValaSet* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp20_ = FALSE;
		_tmp18_ = self->priv->current_sources;
		_tmp19_ = path;
		_tmp20_ = vala_collection_contains ((ValaCollection*) _tmp18_, _tmp19_);
		if (_tmp20_) {
			const gchar* _tmp21_;
			_tmp21_ = path;
			g_debug ("plugin.vala:151: file %s already added", _tmp21_);
		} else {
			ValaCodeContext* _tmp22_;
			const gchar* _tmp23_;
			ValaSet* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp22_ = self->priv->context;
			_tmp23_ = path;
			vala_code_context_add_source_filename (_tmp22_, _tmp23_, FALSE);
			_tmp24_ = self->priv->current_sources;
			_tmp25_ = path;
			vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
			_tmp26_ = path;
			g_debug ("plugin.vala:155: file %s added", _tmp26_);
		}
	} else {
		const gchar* _tmp27_;
		_tmp27_ = path;
		g_debug ("plugin.vala:158: file %s skipped", _tmp27_);
	}
	_g_free0 (path);
}


static void ___lambda1__anjuta_project_node_foreach_func (AnjutaProjectNode* node, gpointer self) {
	__lambda1_ (self, node);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void vala_plugin_add_project_files (ValaPlugin* self) {
	AnjutaShell* _tmp0_ = NULL;
	AnjutaShell* _tmp1_;
	AnjutaShell* _tmp2_;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	IAnjutaProjectManager* _tmp6_;
	IAnjutaProjectManager* pm;
	IAnjutaProjectManager* _tmp7_;
	IAnjutaProject* _tmp8_ = NULL;
	IAnjutaProject* _tmp9_;
	IAnjutaProject* project;
	IAnjutaEditor* _tmp10_;
	GFile* _tmp11_ = NULL;
	GFile* current_file;
	IAnjutaProject* _tmp12_;
	ValaCodeContext* _tmp13_;
	IAnjutaProject* _tmp14_;
	AnjutaProjectNode* _tmp15_ = NULL;
	AnjutaProjectNode* _tmp16_;
	GFile* _tmp17_;
	AnjutaProjectNode* _tmp18_ = NULL;
	AnjutaProjectNode* _tmp19_;
	AnjutaProjectNode* current_src;
	AnjutaProjectNode* _tmp20_;
	AnjutaProjectNode* _tmp21_;
	AnjutaProjectNode* _tmp22_ = NULL;
	AnjutaProjectNode* _tmp23_;
	AnjutaProjectNode* current_target;
	AnjutaProjectNode* _tmp24_;
	AnjutaProjectNode* _tmp25_;
	ValaCodeContext* _tmp26_;
	gboolean _tmp27_ = FALSE;
	gchar** _tmp30_ = NULL;
	gchar** flags;
	gint flags_length1;
	gint _flags_size_;
	AnjutaProjectNode* _tmp31_;
	AnjutaProjectProperty* _tmp32_ = NULL;
	AnjutaProjectProperty* prop;
	gboolean _tmp33_ = FALSE;
	AnjutaProjectProperty* _tmp34_;
	gboolean _tmp39_;
	gchar** _tmp60_ = NULL;
	gchar** packages;
	gint packages_length1;
	gint _packages_size_;
	gchar** _tmp61_ = NULL;
	gchar** vapidirs;
	gint vapidirs_length1;
	gint _vapidirs_size_;
	AnjutaProjectNode* _tmp110_;
	AnjutaProjectNode* _tmp111_ = NULL;
	GFile* _tmp112_ = NULL;
	gchar* _tmp113_ = NULL;
	gchar* srcdir;
	IAnjutaProject* _tmp114_;
	AnjutaProjectNode* _tmp115_ = NULL;
	AnjutaProjectNode* _tmp116_;
	GFile* _tmp117_ = NULL;
	gchar* _tmp118_ = NULL;
	gchar* top_srcdir;
	ValaCodeContext* _tmp135_;
	gchar** _tmp136_;
	gint _tmp136__length1;
	gchar** _tmp137_;
	gint _tmp137__length1;
	gchar** _tmp138_;
	gint _tmp138__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = anjuta_shell_get_object (_tmp2_, "IAnjutaProjectManager", &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _g_object_ref0 (IANJUTA_PROJECT_MANAGER (_tmp5_));
	pm = _tmp6_;
	_tmp7_ = pm;
	_tmp8_ = ianjuta_project_manager_get_current_project (_tmp7_, &_inner_error_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	project = _tmp9_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = self->current_editor;
	_tmp11_ = ianjuta_file_get_file (IANJUTA_IS_FILE (_tmp10_) ? ((IAnjutaFile*) _tmp10_) : NULL, &_inner_error_);
	current_file = _tmp11_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = project;
	if (_tmp12_ == NULL) {
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		return;
	}
	_tmp13_ = self->priv->context;
	vala_code_context_push (_tmp13_);
	_tmp14_ = project;
	_tmp15_ = ianjuta_project_get_root (_tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = current_file;
	_tmp18_ = anjuta_project_node_get_source_from_file (_tmp16_, _tmp17_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	current_src = _tmp19_;
	_tmp20_ = current_src;
	if (_tmp20_ == NULL) {
		_g_object_unref0 (current_src);
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		return;
	}
	_tmp21_ = current_src;
	_tmp22_ = anjuta_project_node_parent_type (_tmp21_, ANJUTA_PROJECT_TARGET);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	current_target = _tmp23_;
	_tmp24_ = current_target;
	if (_tmp24_ == NULL) {
		_g_object_unref0 (current_target);
		_g_object_unref0 (current_src);
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		return;
	}
	_tmp25_ = current_target;
	anjuta_project_node_foreach (_tmp25_, G_PRE_ORDER, ___lambda1__anjuta_project_node_foreach_func, self);
	_tmp26_ = self->priv->context;
	_tmp27_ = vala_code_context_has_package (_tmp26_, "gobject-2.0");
	if (!_tmp27_) {
		ValaCodeContext* _tmp28_;
		ValaCodeContext* _tmp29_;
		_tmp28_ = self->priv->context;
		vala_code_context_add_external_package (_tmp28_, "glib-2.0");
		_tmp29_ = self->priv->context;
		vala_code_context_add_external_package (_tmp29_, "gobject-2.0");
		g_debug ("plugin.vala:165: standard packages added");
	} else {
		g_debug ("plugin.vala:167: standard packages already added");
	}
	_tmp30_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp30_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp31_ = current_target;
	_tmp32_ = anjuta_project_node_get_property (_tmp31_, "VALAFLAGS");
	prop = _tmp32_;
	_tmp34_ = prop;
	if (_tmp34_ != NULL) {
		AnjutaProjectProperty* _tmp35_;
		AnjutaProjectProperty* _tmp36_;
		AnjutaProjectPropertyInfo* _tmp37_;
		AnjutaProjectProperty* _tmp38_;
		_tmp35_ = prop;
		_tmp36_ = prop;
		_tmp37_ = _tmp36_->info;
		_tmp38_ = _tmp37_->default_value;
		_tmp33_ = _tmp35_ != _tmp38_;
	} else {
		_tmp33_ = FALSE;
	}
	_tmp39_ = _tmp33_;
	if (_tmp39_) {
		AnjutaProjectProperty* _tmp40_;
		const gchar* _tmp41_;
		gchar** _tmp42_ = NULL;
		gint _tmp43_ = 0;
		_tmp40_ = prop;
		_tmp41_ = _tmp40_->value;
		g_shell_parse_argv (_tmp41_, &_tmp43_, &_tmp42_, &_inner_error_);
		flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
		flags = _tmp42_;
		flags_length1 = _tmp43_;
		_flags_size_ = flags_length1;
		if (_inner_error_ != NULL) {
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (current_target);
			_g_object_unref0 (current_src);
			_g_object_unref0 (current_file);
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		AnjutaProjectNode* _tmp44_;
		AnjutaProjectNode* _tmp45_ = NULL;
		AnjutaProjectNode* _tmp46_;
		AnjutaProjectNode* current_group;
		AnjutaProjectNode* _tmp47_;
		AnjutaProjectProperty* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		AnjutaProjectProperty* _tmp50_;
		gboolean _tmp55_;
		_tmp44_ = current_target;
		_tmp45_ = anjuta_project_node_parent_type (_tmp44_, ANJUTA_PROJECT_GROUP);
		_tmp46_ = _g_object_ref0 (_tmp45_);
		current_group = _tmp46_;
		_tmp47_ = current_group;
		_tmp48_ = anjuta_project_node_get_property (_tmp47_, "VALAFLAGS");
		prop = _tmp48_;
		_tmp50_ = prop;
		if (_tmp50_ != NULL) {
			AnjutaProjectProperty* _tmp51_;
			AnjutaProjectProperty* _tmp52_;
			AnjutaProjectPropertyInfo* _tmp53_;
			AnjutaProjectProperty* _tmp54_;
			_tmp51_ = prop;
			_tmp52_ = prop;
			_tmp53_ = _tmp52_->info;
			_tmp54_ = _tmp53_->default_value;
			_tmp49_ = _tmp51_ != _tmp54_;
		} else {
			_tmp49_ = FALSE;
		}
		_tmp55_ = _tmp49_;
		if (_tmp55_) {
			AnjutaProjectProperty* _tmp56_;
			const gchar* _tmp57_;
			gchar** _tmp58_ = NULL;
			gint _tmp59_ = 0;
			_tmp56_ = prop;
			_tmp57_ = _tmp56_->value;
			g_shell_parse_argv (_tmp57_, &_tmp59_, &_tmp58_, &_inner_error_);
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
			flags = _tmp58_;
			flags_length1 = _tmp59_;
			_flags_size_ = flags_length1;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (current_group);
				flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (current_target);
				_g_object_unref0 (current_src);
				_g_object_unref0 (current_file);
				_g_object_unref0 (project);
				_g_object_unref0 (pm);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (current_group);
	}
	_tmp60_ = g_new0 (gchar*, 0 + 1);
	packages = _tmp60_;
	packages_length1 = 0;
	_packages_size_ = packages_length1;
	_tmp61_ = g_new0 (gchar*, 0 + 1);
	vapidirs = _tmp61_;
	vapidirs_length1 = 0;
	_vapidirs_size_ = vapidirs_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp62_;
			_tmp62_ = TRUE;
			while (TRUE) {
				gboolean _tmp63_;
				gint _tmp65_;
				gchar** _tmp66_;
				gint _tmp66__length1;
				gchar** _tmp67_;
				gint _tmp67__length1;
				gint _tmp68_;
				const gchar* _tmp69_;
				_tmp63_ = _tmp62_;
				if (!_tmp63_) {
					gint _tmp64_;
					_tmp64_ = i;
					i = _tmp64_ + 1;
				}
				_tmp62_ = FALSE;
				_tmp65_ = i;
				_tmp66_ = flags;
				_tmp66__length1 = flags_length1;
				if (!(_tmp65_ < _tmp66__length1)) {
					break;
				}
				_tmp67_ = flags;
				_tmp67__length1 = flags_length1;
				_tmp68_ = i;
				_tmp69_ = _tmp67_[_tmp68_];
				if (g_strcmp0 (_tmp69_, "--vapidir") == 0) {
					gchar** _tmp70_;
					gint _tmp70__length1;
					gchar** _tmp71_;
					gint _tmp71__length1;
					gint _tmp72_;
					gint _tmp73_;
					const gchar* _tmp74_;
					gchar* _tmp75_;
					_tmp70_ = vapidirs;
					_tmp70__length1 = vapidirs_length1;
					_tmp71_ = flags;
					_tmp71__length1 = flags_length1;
					_tmp72_ = i;
					i = _tmp72_ + 1;
					_tmp73_ = i;
					_tmp74_ = _tmp71_[_tmp73_];
					_tmp75_ = g_strdup (_tmp74_);
					_vala_array_add1 (&vapidirs, &vapidirs_length1, &_vapidirs_size_, _tmp75_);
				} else {
					gchar** _tmp76_;
					gint _tmp76__length1;
					gint _tmp77_;
					const gchar* _tmp78_;
					gboolean _tmp79_ = FALSE;
					_tmp76_ = flags;
					_tmp76__length1 = flags_length1;
					_tmp77_ = i;
					_tmp78_ = _tmp76_[_tmp77_];
					_tmp79_ = g_str_has_prefix (_tmp78_, "--vapidir=");
					if (_tmp79_) {
						gchar** _tmp80_;
						gint _tmp80__length1;
						gchar** _tmp81_;
						gint _tmp81__length1;
						gint _tmp82_;
						const gchar* _tmp83_;
						gint _tmp84_;
						gint _tmp85_;
						gchar* _tmp86_ = NULL;
						_tmp80_ = vapidirs;
						_tmp80__length1 = vapidirs_length1;
						_tmp81_ = flags;
						_tmp81__length1 = flags_length1;
						_tmp82_ = i;
						_tmp83_ = _tmp81_[_tmp82_];
						_tmp84_ = strlen ("--vapidir=");
						_tmp85_ = _tmp84_;
						_tmp86_ = string_substring (_tmp83_, (glong) _tmp85_, (glong) (-1));
						_vala_array_add2 (&vapidirs, &vapidirs_length1, &_vapidirs_size_, _tmp86_);
					} else {
						gchar** _tmp87_;
						gint _tmp87__length1;
						gint _tmp88_;
						const gchar* _tmp89_;
						_tmp87_ = flags;
						_tmp87__length1 = flags_length1;
						_tmp88_ = i;
						_tmp89_ = _tmp87_[_tmp88_];
						if (g_strcmp0 (_tmp89_, "--pkg") == 0) {
							gchar** _tmp90_;
							gint _tmp90__length1;
							gchar** _tmp91_;
							gint _tmp91__length1;
							gint _tmp92_;
							gint _tmp93_;
							const gchar* _tmp94_;
							gchar* _tmp95_;
							_tmp90_ = packages;
							_tmp90__length1 = packages_length1;
							_tmp91_ = flags;
							_tmp91__length1 = flags_length1;
							_tmp92_ = i;
							i = _tmp92_ + 1;
							_tmp93_ = i;
							_tmp94_ = _tmp91_[_tmp93_];
							_tmp95_ = g_strdup (_tmp94_);
							_vala_array_add3 (&packages, &packages_length1, &_packages_size_, _tmp95_);
						} else {
							gchar** _tmp96_;
							gint _tmp96__length1;
							gint _tmp97_;
							const gchar* _tmp98_;
							gboolean _tmp99_ = FALSE;
							_tmp96_ = flags;
							_tmp96__length1 = flags_length1;
							_tmp97_ = i;
							_tmp98_ = _tmp96_[_tmp97_];
							_tmp99_ = g_str_has_prefix (_tmp98_, "--pkg=");
							if (_tmp99_) {
								gchar** _tmp100_;
								gint _tmp100__length1;
								gchar** _tmp101_;
								gint _tmp101__length1;
								gint _tmp102_;
								const gchar* _tmp103_;
								gint _tmp104_;
								gint _tmp105_;
								gchar* _tmp106_ = NULL;
								_tmp100_ = packages;
								_tmp100__length1 = packages_length1;
								_tmp101_ = flags;
								_tmp101__length1 = flags_length1;
								_tmp102_ = i;
								_tmp103_ = _tmp101_[_tmp102_];
								_tmp104_ = strlen ("--pkg=");
								_tmp105_ = _tmp104_;
								_tmp106_ = string_substring (_tmp103_, (glong) _tmp105_, (glong) (-1));
								_vala_array_add4 (&packages, &packages_length1, &_packages_size_, _tmp106_);
							} else {
								gchar** _tmp107_;
								gint _tmp107__length1;
								gint _tmp108_;
								const gchar* _tmp109_;
								_tmp107_ = flags;
								_tmp107__length1 = flags_length1;
								_tmp108_ = i;
								_tmp109_ = _tmp107_[_tmp108_];
								g_debug ("plugin.vala:195: Unknown valac flag %s", _tmp109_);
							}
						}
					}
				}
			}
		}
	}
	_tmp110_ = current_target;
	_tmp111_ = anjuta_project_node_parent_type (_tmp110_, ANJUTA_PROJECT_GROUP);
	_tmp112_ = anjuta_project_node_get_file (_tmp111_);
	_tmp113_ = g_file_get_path (_tmp112_);
	srcdir = _tmp113_;
	_tmp114_ = project;
	_tmp115_ = ianjuta_project_get_root (_tmp114_, &_inner_error_);
	_tmp116_ = _tmp115_;
	if (_inner_error_ != NULL) {
		_g_free0 (srcdir);
		vapidirs = (_vala_array_free (vapidirs, vapidirs_length1, (GDestroyNotify) g_free), NULL);
		packages = (_vala_array_free (packages, packages_length1, (GDestroyNotify) g_free), NULL);
		flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (current_target);
		_g_object_unref0 (current_src);
		_g_object_unref0 (current_file);
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp117_ = anjuta_project_node_get_file (_tmp116_);
	_tmp118_ = g_file_get_path (_tmp117_);
	top_srcdir = _tmp118_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp119_;
			_tmp119_ = TRUE;
			while (TRUE) {
				gboolean _tmp120_;
				gint _tmp122_;
				gchar** _tmp123_;
				gint _tmp123__length1;
				gchar** _tmp124_;
				gint _tmp124__length1;
				gint _tmp125_;
				gchar** _tmp126_;
				gint _tmp126__length1;
				gint _tmp127_;
				const gchar* _tmp128_;
				const gchar* _tmp129_;
				gchar* _tmp130_ = NULL;
				gchar* _tmp131_;
				const gchar* _tmp132_;
				gchar* _tmp133_ = NULL;
				gchar* _tmp134_;
				_tmp120_ = _tmp119_;
				if (!_tmp120_) {
					gint _tmp121_;
					_tmp121_ = i;
					i = _tmp121_ + 1;
				}
				_tmp119_ = FALSE;
				_tmp122_ = i;
				_tmp123_ = vapidirs;
				_tmp123__length1 = vapidirs_length1;
				if (!(_tmp122_ < _tmp123__length1)) {
					break;
				}
				_tmp124_ = vapidirs;
				_tmp124__length1 = vapidirs_length1;
				_tmp125_ = i;
				_tmp126_ = vapidirs;
				_tmp126__length1 = vapidirs_length1;
				_tmp127_ = i;
				_tmp128_ = _tmp126_[_tmp127_];
				_tmp129_ = srcdir;
				_tmp130_ = string_replace (_tmp128_, "$(srcdir)", _tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = top_srcdir;
				_tmp133_ = string_replace (_tmp131_, "$(top_srcdir)", _tmp132_);
				_g_free0 (_tmp124_[_tmp125_]);
				_tmp124_[_tmp125_] = _tmp133_;
				_tmp134_ = _tmp124_[_tmp125_];
				_g_free0 (_tmp131_);
			}
		}
	}
	_tmp135_ = self->priv->context;
	_tmp136_ = vapidirs;
	_tmp136__length1 = vapidirs_length1;
	_tmp137_ = (_tmp136_ != NULL) ? _vala_array_dup1 (_tmp136_, _tmp136__length1) : ((gpointer) _tmp136_);
	_tmp137__length1 = _tmp136__length1;
	_tmp135_->vapi_directories = (_vala_array_free (_tmp135_->vapi_directories, _tmp135_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp135_->vapi_directories = _tmp137_;
	_tmp135_->vapi_directories_length1 = _tmp137__length1;
	_tmp138_ = packages;
	_tmp138__length1 = packages_length1;
	{
		gchar** pkg_collection = NULL;
		gint pkg_collection_length1 = 0;
		gint _pkg_collection_size_ = 0;
		gint pkg_it = 0;
		pkg_collection = _tmp138_;
		pkg_collection_length1 = _tmp138__length1;
		for (pkg_it = 0; pkg_it < _tmp138__length1; pkg_it = pkg_it + 1) {
			gchar* _tmp139_;
			gchar* pkg = NULL;
			_tmp139_ = g_strdup (pkg_collection[pkg_it]);
			pkg = _tmp139_;
			{
				ValaCodeContext* _tmp140_;
				const gchar* _tmp141_;
				gboolean _tmp142_ = FALSE;
				_tmp140_ = self->priv->context;
				_tmp141_ = pkg;
				_tmp142_ = vala_code_context_has_package (_tmp140_, _tmp141_);
				if (_tmp142_) {
					const gchar* _tmp143_;
					_tmp143_ = pkg;
					g_debug ("plugin.vala:208: package %s skipped", _tmp143_);
				} else {
					ValaCodeContext* _tmp144_;
					const gchar* _tmp145_;
					gboolean _tmp146_ = FALSE;
					_tmp144_ = self->priv->context;
					_tmp145_ = pkg;
					_tmp146_ = vala_code_context_add_external_package (_tmp144_, _tmp145_);
					if (_tmp146_) {
						const gchar* _tmp147_;
						_tmp147_ = pkg;
						g_debug ("plugin.vala:210: package %s added", _tmp147_);
					} else {
						const gchar* _tmp148_;
						_tmp148_ = pkg;
						g_debug ("plugin.vala:212: package %s not found", _tmp148_);
					}
				}
				_g_free0 (pkg);
			}
		}
	}
	vala_code_context_pop ();
	_g_free0 (top_srcdir);
	_g_free0 (srcdir);
	vapidirs = (_vala_array_free (vapidirs, vapidirs_length1, (GDestroyNotify) g_free), NULL);
	packages = (_vala_array_free (packages, packages_length1, (GDestroyNotify) g_free), NULL);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (current_target);
	_g_object_unref0 (current_src);
	_g_object_unref0 (current_file);
	_g_object_unref0 (project);
	_g_object_unref0 (pm);
}


void vala_plugin_on_project_loaded (ValaPlugin* self, IAnjutaProjectManager* pm, GError* e) {
	ValaCodeContext* _tmp0_;
	IAnjutaProjectManager* _tmp1_;
	gulong _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pm != NULL);
	_tmp0_ = self->priv->context;
	if (_tmp0_ == NULL) {
		return;
	}
	vala_plugin_add_project_files (self);
	vala_plugin_parse (self);
	_tmp1_ = pm;
	_tmp2_ = self->priv->project_loaded_id;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
	self->priv->project_loaded_id = (gulong) 0;
}


static void _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded (IAnjutaProjectManager* _sender, GError* _error_, gpointer self) {
	vala_plugin_on_project_loaded (self, _sender, _error_);
}


static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditor* _sender, IAnjutaIterable* position, gchar ch, gpointer self) {
	vala_plugin_on_char_added (self, _sender, position, ch);
}


static void _vala_plugin_on_file_saved_ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GFile* file, gpointer self) {
	vala_plugin_on_file_saved (self, _sender, file);
}


static gboolean _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, gpointer self) {
	gboolean result;
	result = vala_plugin_on_drop_possible (self, _sender, iterator);
	return result;
}


static void _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, const gchar* signal_data, gpointer self) {
	vala_plugin_on_drop (self, _sender, iterator, signal_data);
}


static void _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add (IAnjutaEditor* _sender, const gchar* widget_typename, const gchar* widget_name, const gchar* filename, gpointer self) {
	vala_plugin_insert_member_decl_and_init (self, _sender, widget_typename, widget_name, filename);
}


void vala_plugin_editor_value_added (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name, GValue* value) {
	IAnjutaEditor* _tmp0_;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	IAnjutaFile* _tmp4_;
	IAnjutaFile* current_file;
	AnjutaShell* _tmp5_ = NULL;
	AnjutaShell* _tmp6_;
	AnjutaShell* _tmp7_;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GObject* _tmp10_;
	IAnjutaProjectManager* _tmp11_;
	IAnjutaProjectManager* pm;
	IAnjutaProjectManager* _tmp12_;
	IAnjutaProject* _tmp13_ = NULL;
	IAnjutaProject* _tmp14_;
	IAnjutaProject* project;
	IAnjutaProject* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	IAnjutaEditor* _tmp33_;
	AnjutaReport* _tmp49_;
	IAnjutaEditor* _tmp50_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("plugin.vala:229: editor value added");
	_tmp0_ = self->current_editor;
	g_assert (_tmp0_ == NULL);
	_tmp1_ = g_value_get_object (value);
	if (!IANJUTA_IS_EDITOR (_tmp1_)) {
		return;
	}
	_tmp2_ = g_value_get_object (value);
	self->current_editor = IANJUTA_IS_EDITOR (_tmp2_) ? ((IAnjutaEditor*) _tmp2_) : NULL;
	_tmp3_ = g_value_get_object (value);
	_tmp4_ = _g_object_ref0 (IANJUTA_IS_FILE (_tmp3_) ? ((IAnjutaFile*) _tmp3_) : NULL);
	current_file = _tmp4_;
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = anjuta_shell_get_object (_tmp7_, "IAnjutaProjectManager", &_inner_error_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = _g_object_ref0 (IANJUTA_PROJECT_MANAGER (_tmp10_));
	pm = _tmp11_;
	_tmp12_ = pm;
	_tmp13_ = ianjuta_project_manager_get_current_project (_tmp12_, &_inner_error_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	project = _tmp14_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pm);
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = project;
	_tmp16_ = ianjuta_project_is_loaded (_tmp15_, &_inner_error_);
	_tmp17_ = _tmp16_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (!_tmp17_) {
		gulong _tmp18_;
		_tmp18_ = self->priv->project_loaded_id;
		if (_tmp18_ == ((gulong) 0)) {
			IAnjutaProjectManager* _tmp19_;
			gulong _tmp20_ = 0UL;
			_tmp19_ = pm;
			_tmp20_ = g_signal_connect_object (_tmp19_, "project-loaded", (GCallback) _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded, self, 0);
			self->priv->project_loaded_id = _tmp20_;
		}
	} else {
		IAnjutaFile* _tmp21_;
		GFile* _tmp22_ = NULL;
		GFile* cur_gfile;
		GFile* _tmp23_;
		ValaSet* _tmp24_;
		GFile* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		_tmp21_ = current_file;
		_tmp22_ = ianjuta_file_get_file (_tmp21_, &_inner_error_);
		cur_gfile = _tmp22_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			_g_object_unref0 (current_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = cur_gfile;
		if (_tmp23_ == NULL) {
			_g_object_unref0 (cur_gfile);
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			_g_object_unref0 (current_file);
			return;
		}
		_tmp24_ = self->priv->current_sources;
		_tmp25_ = cur_gfile;
		_tmp26_ = g_file_get_path (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_contains ((ValaCollection*) _tmp24_, _tmp27_);
		_tmp29_ = !_tmp28_;
		_g_free0 (_tmp27_);
		if (_tmp29_) {
			GCancellable* _tmp30_;
			_tmp30_ = self->priv->cancel;
			g_cancellable_cancel (_tmp30_);
			{
				ValaCodeContext* _tmp31_;
				_tmp31_ = self->priv->context;
				g_static_rec_mutex_lock (&self->priv->__lock_context);
				{
					vala_plugin_init_context (self);
					vala_plugin_add_project_files (self);
				}
				__finally4:
				{
					ValaCodeContext* _tmp32_;
					_tmp32_ = self->priv->context;
					g_static_rec_mutex_unlock (&self->priv->__lock_context);
				}
				if (_inner_error_ != NULL) {
					_g_object_unref0 (cur_gfile);
					_g_object_unref0 (project);
					_g_object_unref0 (pm);
					_g_object_unref0 (current_file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_plugin_parse (self);
		}
		_g_object_unref0 (cur_gfile);
	}
	_tmp33_ = self->current_editor;
	if (_tmp33_ != NULL) {
		IAnjutaEditor* _tmp34_;
		IAnjutaEditor* _tmp37_;
		IAnjutaEditor* _tmp39_;
		IAnjutaEditor* _tmp43_;
		IAnjutaEditor* _tmp48_;
		_tmp34_ = self->current_editor;
		if (IANJUTA_IS_EDITOR_ASSIST (_tmp34_)) {
			IAnjutaEditor* _tmp35_;
			ValaProvider* _tmp36_;
			_tmp35_ = self->current_editor;
			_tmp36_ = self->priv->provider;
			ianjuta_editor_assist_add (IANJUTA_IS_EDITOR_ASSIST (_tmp35_) ? ((IAnjutaEditorAssist*) _tmp35_) : NULL, (IAnjutaProvider*) _tmp36_, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (project);
				_g_object_unref0 (pm);
				_g_object_unref0 (current_file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp37_ = self->current_editor;
		if (IANJUTA_IS_EDITOR_TIP (_tmp37_)) {
			IAnjutaEditor* _tmp38_;
			_tmp38_ = self->current_editor;
			g_signal_connect_object (_tmp38_, "char-added", (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self, 0);
		}
		_tmp39_ = self->current_editor;
		if (IANJUTA_IS_FILE_SAVABLE (_tmp39_)) {
			IAnjutaEditor* _tmp40_;
			IAnjutaFileSavable* _tmp41_;
			IAnjutaFileSavable* file_savable;
			IAnjutaFileSavable* _tmp42_;
			_tmp40_ = self->current_editor;
			_tmp41_ = _g_object_ref0 (IANJUTA_FILE_SAVABLE (_tmp40_));
			file_savable = _tmp41_;
			_tmp42_ = file_savable;
			g_signal_connect_object (_tmp42_, "saved", (GCallback) _vala_plugin_on_file_saved_ianjuta_file_savable_saved, self, 0);
			_g_object_unref0 (file_savable);
		}
		_tmp43_ = self->current_editor;
		if (IANJUTA_IS_EDITOR_GLADE_SIGNAL (_tmp43_)) {
			IAnjutaEditor* _tmp44_;
			IAnjutaEditorGladeSignal* _tmp45_;
			IAnjutaEditorGladeSignal* gladesig;
			IAnjutaEditorGladeSignal* _tmp46_;
			IAnjutaEditorGladeSignal* _tmp47_;
			_tmp44_ = self->current_editor;
			_tmp45_ = _g_object_ref0 (IANJUTA_IS_EDITOR_GLADE_SIGNAL (_tmp44_) ? ((IAnjutaEditorGladeSignal*) _tmp44_) : NULL);
			gladesig = _tmp45_;
			_tmp46_ = gladesig;
			g_signal_connect_object (_tmp46_, "drop-possible", (GCallback) _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible, self, 0);
			_tmp47_ = gladesig;
			g_signal_connect_object (_tmp47_, "drop", (GCallback) _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop, self, 0);
			_g_object_unref0 (gladesig);
		}
		_tmp48_ = self->current_editor;
		g_signal_connect_object (_tmp48_, "glade-member-add", (GCallback) _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add, self, 0);
	}
	_tmp49_ = self->priv->report;
	_tmp50_ = self->current_editor;
	anjuta_report_update_errors (_tmp49_, _tmp50_);
	_g_object_unref0 (project);
	_g_object_unref0 (pm);
	_g_object_unref0 (current_file);
}


void vala_plugin_editor_value_removed (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name) {
	IAnjutaEditor* _tmp0_;
	IAnjutaEditor* _tmp3_;
	IAnjutaEditor* _tmp6_;
	IAnjutaEditor* _tmp11_;
	IAnjutaEditor* _tmp18_;
	guint _tmp19_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (name != NULL);
	g_debug ("plugin.vala:281: editor value removed");
	_tmp0_ = self->current_editor;
	if (IANJUTA_IS_EDITOR_ASSIST (_tmp0_)) {
		IAnjutaEditor* _tmp1_;
		ValaProvider* _tmp2_;
		_tmp1_ = self->current_editor;
		_tmp2_ = self->priv->provider;
		ianjuta_editor_assist_remove (IANJUTA_IS_EDITOR_ASSIST (_tmp1_) ? ((IAnjutaEditorAssist*) _tmp1_) : NULL, (IAnjutaProvider*) _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->current_editor;
	if (IANJUTA_IS_EDITOR_TIP (_tmp3_)) {
		IAnjutaEditor* _tmp4_;
		guint _tmp5_ = 0U;
		_tmp4_ = self->current_editor;
		g_signal_parse_name ("char-added", ianjuta_editor_get_type (), &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self);
	}
	_tmp6_ = self->current_editor;
	if (IANJUTA_IS_FILE_SAVABLE (_tmp6_)) {
		IAnjutaEditor* _tmp7_;
		IAnjutaFileSavable* _tmp8_;
		IAnjutaFileSavable* file_savable;
		IAnjutaFileSavable* _tmp9_;
		guint _tmp10_ = 0U;
		_tmp7_ = self->current_editor;
		_tmp8_ = _g_object_ref0 (IANJUTA_FILE_SAVABLE (_tmp7_));
		file_savable = _tmp8_;
		_tmp9_ = file_savable;
		g_signal_parse_name ("saved", ianjuta_file_savable_get_type (), &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _vala_plugin_on_file_saved_ianjuta_file_savable_saved, self);
		_g_object_unref0 (file_savable);
	}
	_tmp11_ = self->current_editor;
	if (IANJUTA_IS_EDITOR_GLADE_SIGNAL (_tmp11_)) {
		IAnjutaEditor* _tmp12_;
		IAnjutaEditorGladeSignal* _tmp13_;
		IAnjutaEditorGladeSignal* gladesig;
		IAnjutaEditorGladeSignal* _tmp14_;
		guint _tmp15_ = 0U;
		IAnjutaEditorGladeSignal* _tmp16_;
		guint _tmp17_ = 0U;
		_tmp12_ = self->current_editor;
		_tmp13_ = _g_object_ref0 (IANJUTA_IS_EDITOR_GLADE_SIGNAL (_tmp12_) ? ((IAnjutaEditorGladeSignal*) _tmp12_) : NULL);
		gladesig = _tmp13_;
		_tmp14_ = gladesig;
		g_signal_parse_name ("drop-possible", ianjuta_editor_glade_signal_get_type (), &_tmp15_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible, self);
		_tmp16_ = gladesig;
		g_signal_parse_name ("drop", ianjuta_editor_glade_signal_get_type (), &_tmp17_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop, self);
		_g_object_unref0 (gladesig);
	}
	_tmp18_ = self->current_editor;
	g_signal_parse_name ("glade-member-add", ianjuta_editor_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _vala_plugin_insert_member_decl_and_init_ianjuta_editor_glade_member_add, self);
	self->current_editor = NULL;
}


void vala_plugin_on_file_saved (ValaPlugin* self, IAnjutaFileSavable* savable, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (savable != NULL);
	g_return_if_fail (file != NULL);
	{
		ValaCodeContext* _tmp0_;
		ValaList* _tmp1_ = NULL;
		ValaList* _source_file_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _source_file_size;
		gint _source_file_index;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_source_file_list = _tmp1_;
		_tmp2_ = _source_file_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_source_file_size = _tmp4_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaSourceFile* source_file;
			ValaSourceFile* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			GFile* _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gboolean _tmp17_;
			guint8* contents = NULL;
			gint contents_length1 = 0;
			gint _contents_size_ = 0;
			_tmp5_ = _source_file_index;
			_source_file_index = _tmp5_ + 1;
			_tmp6_ = _source_file_index;
			_tmp7_ = _source_file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _source_file_list;
			_tmp9_ = _source_file_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			source_file = (ValaSourceFile*) _tmp10_;
			_tmp11_ = source_file;
			_tmp12_ = vala_source_file_get_filename (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = file;
			_tmp15_ = g_file_get_path (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				_vala_source_file_unref0 (source_file);
				continue;
			}
			{
				GFile* _tmp18_;
				guint8* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				ValaSourceFile* _tmp21_;
				ValaSourceFile* _tmp22_;
				_tmp18_ = file;
				g_file_load_contents (_tmp18_, NULL, &_tmp19_, &_tmp20_, NULL, &_inner_error_);
				contents = (g_free (contents), NULL);
				contents = _tmp19_;
				contents_length1 = _tmp20_;
				_contents_size_ = contents_length1;
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
				_tmp21_ = source_file;
				vala_source_file_set_content (_tmp21_, (const gchar*) contents);
				_tmp22_ = source_file;
				vala_plugin_update_file (self, _tmp22_);
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally5:
			if (_inner_error_ != NULL) {
				contents = (g_free (contents), NULL);
				_vala_source_file_unref0 (source_file);
				_vala_iterable_unref0 (_source_file_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			contents = (g_free (contents), NULL);
			_vala_source_file_unref0 (source_file);
			_vala_iterable_unref0 (_source_file_list);
			return;
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}


void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position, gchar ch) {
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	IAnjutaEditor* _tmp2_;
	IAnjutaEditorTip* _tmp3_;
	IAnjutaEditorTip* editortip;
	gchar _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	_tmp0_ = self->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, VALA_PROVIDER_PREF_CALLTIP_ENABLE);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = editor;
	_tmp3_ = _g_object_ref0 (IANJUTA_IS_EDITOR_TIP (_tmp2_) ? ((IAnjutaEditorTip*) _tmp2_) : NULL);
	editortip = _tmp3_;
	_tmp4_ = ch;
	if (_tmp4_ == '(') {
		ValaProvider* _tmp5_;
		IAnjutaEditorTip* _tmp6_;
		_tmp5_ = self->priv->provider;
		_tmp6_ = editortip;
		vala_provider_show_call_tip (_tmp5_, _tmp6_);
	} else {
		gchar _tmp7_;
		_tmp7_ = ch;
		if (_tmp7_ == ')') {
			IAnjutaEditorTip* _tmp8_;
			_tmp8_ = editortip;
			ianjuta_editor_tip_cancel (_tmp8_, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (editortip);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (editortip);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static ValaSymbol* vala_plugin_get_scope (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position) {
	ValaSymbol* result = NULL;
	gint depth;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	g_return_val_if_fail (position != NULL, NULL);
	depth = 0;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			IAnjutaIterable* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* current_char;
			const gchar* _tmp7_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				IAnjutaIterable* _tmp2_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_;
				_tmp2_ = position;
				_tmp3_ = ianjuta_iterable_previous (_tmp2_, &_inner_error_);
				_tmp4_ = _tmp3_;
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				if (!_tmp4_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp5_ = position;
			_tmp6_ = ianjuta_editor_cell_get_character (IANJUTA_IS_EDITOR_CELL (_tmp5_) ? ((IAnjutaEditorCell*) _tmp5_) : NULL, &_inner_error_);
			current_char = _tmp6_;
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp7_ = current_char;
			if (g_strcmp0 (_tmp7_, "}") == 0) {
				gint _tmp8_;
				_tmp8_ = depth;
				depth = _tmp8_ + 1;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = current_char;
				if (g_strcmp0 (_tmp9_, "{") == 0) {
					gint _tmp10_;
					_tmp10_ = depth;
					if (_tmp10_ > 0) {
						gint _tmp11_;
						_tmp11_ = depth;
						depth = _tmp11_ - 1;
					} else {
						IAnjutaEditor* _tmp21_;
						IAnjutaIterable* _tmp22_;
						ValaSymbol* _tmp23_ = NULL;
						{
							gboolean _tmp12_;
							_tmp12_ = TRUE;
							while (TRUE) {
								gboolean _tmp13_;
								IAnjutaIterable* _tmp17_;
								IAnjutaIterable* _tmp18_;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_;
								_tmp13_ = _tmp12_;
								if (!_tmp13_) {
									const gchar* _tmp14_;
									gunichar _tmp15_ = 0U;
									gboolean _tmp16_ = FALSE;
									_tmp14_ = current_char;
									_tmp15_ = string_get_char (_tmp14_, (glong) 0);
									_tmp16_ = g_unichar_isalnum (_tmp15_);
									if (!(!_tmp16_)) {
										break;
									}
								}
								_tmp12_ = FALSE;
								_tmp17_ = position;
								ianjuta_iterable_previous (_tmp17_, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_free0 (current_char);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp18_ = position;
								_tmp19_ = ianjuta_editor_cell_get_character (IANJUTA_IS_EDITOR_CELL (_tmp18_) ? ((IAnjutaEditorCell*) _tmp18_) : NULL, &_inner_error_);
								_tmp20_ = _tmp19_;
								if (_inner_error_ != NULL) {
									_g_free0 (current_char);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_g_free0 (current_char);
								current_char = _tmp20_;
							}
						}
						_tmp21_ = editor;
						_tmp22_ = position;
						_tmp23_ = vala_plugin_get_current_context (self, _tmp21_, _tmp22_);
						result = _tmp23_;
						_g_free0 (current_char);
						return result;
					}
				}
			}
			_g_free0 (current_char);
		}
	}
	result = NULL;
	return result;
}


gboolean vala_plugin_on_drop_possible (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position) {
	gboolean result = FALSE;
	IAnjutaEditorGladeSignal* _tmp0_;
	IAnjutaIterable* _tmp1_;
	gint _tmp2_ = 0;
	gint line;
	IAnjutaEditorGladeSignal* _tmp3_;
	gint _tmp4_;
	IAnjutaIterable* _tmp5_ = NULL;
	IAnjutaIterable* _tmp6_;
	IAnjutaIterable* _tmp7_;
	IAnjutaIterable* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_;
	gint column;
	gint _tmp11_;
	gint _tmp12_;
	IAnjutaIterable* _tmp13_;
	IAnjutaIterable* _tmp14_ = NULL;
	IAnjutaIterable* _tmp15_;
	IAnjutaEditorGladeSignal* _tmp16_;
	IAnjutaIterable* _tmp17_;
	ValaSymbol* _tmp18_ = NULL;
	ValaSymbol* _tmp19_;
	ValaSymbol* scope;
	ValaSymbol* _tmp20_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	ValaSymbol* _tmp26_;
	gboolean _tmp28_;
	gboolean _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (editor != NULL, FALSE);
	g_return_val_if_fail (position != NULL, FALSE);
	_tmp0_ = editor;
	_tmp1_ = position;
	_tmp2_ = ianjuta_editor_get_line_from_position ((IAnjutaEditor*) _tmp0_, _tmp1_, &_inner_error_);
	line = _tmp2_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = editor;
	_tmp4_ = line;
	_tmp5_ = ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) _tmp3_, _tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = _tmp6_;
	_tmp8_ = position;
	_tmp9_ = ianjuta_iterable_diff (_tmp7_, _tmp8_, &_inner_error_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp7_);
	column = _tmp10_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp11_ = line;
	_tmp12_ = column;
	g_debug ("plugin.vala:356: line %d, column %d", _tmp11_, _tmp12_);
	_tmp13_ = position;
	_tmp14_ = ianjuta_iterable_clone (_tmp13_, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp16_ = editor;
	_tmp17_ = _tmp15_;
	_tmp18_ = vala_plugin_get_scope (self, (IAnjutaEditor*) _tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp17_);
	scope = _tmp19_;
	_tmp20_ = scope;
	if (_tmp20_ != NULL) {
		ValaSymbol* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		_tmp21_ = scope;
		_tmp22_ = vala_symbol_get_full_name (_tmp21_);
		_tmp23_ = _tmp22_;
		g_debug ("plugin.vala:360: drag is inside %s", _tmp23_);
		_g_free0 (_tmp23_);
	}
	_tmp26_ = scope;
	if (_tmp26_ == NULL) {
		_tmp25_ = TRUE;
	} else {
		ValaSymbol* _tmp27_;
		_tmp27_ = scope;
		_tmp25_ = VALA_IS_NAMESPACE (_tmp27_);
	}
	_tmp28_ = _tmp25_;
	if (_tmp28_) {
		_tmp24_ = TRUE;
	} else {
		ValaSymbol* _tmp29_;
		_tmp29_ = scope;
		_tmp24_ = VALA_IS_CLASS (_tmp29_);
	}
	_tmp30_ = _tmp24_;
	if (_tmp30_) {
		result = TRUE;
		_vala_code_node_unref0 (scope);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (scope);
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_plugin_on_drop (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position, const gchar* signal_data) {
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** data;
	gint data_length1;
	gint _data_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* widget_name;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* signal_name;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* handler_name;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gboolean swapped;
	IAnjutaIterable* _tmp14_;
	IAnjutaIterable* _tmp15_ = NULL;
	IAnjutaIterable* _tmp16_;
	IAnjutaEditorGladeSignal* _tmp17_;
	IAnjutaIterable* _tmp18_;
	ValaSymbol* _tmp19_ = NULL;
	ValaSymbol* _tmp20_;
	ValaSymbol* scope;
	GString* _tmp21_;
	GString* builder;
	gchar* _tmp22_;
	gchar* scope_prefix;
	ValaSymbol* _tmp23_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* handler_cname;
	gboolean _tmp37_ = FALSE;
	gchar** _tmp38_;
	gint _tmp38__length1;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gboolean _tmp42_;
	const gchar* _tmp54_;
	ValaCodeContext* _tmp55_;
	ValaNamespace* _tmp56_;
	ValaNamespace* _tmp57_;
	ValaSymbol* _tmp58_ = NULL;
	ValaSymbol* widget;
	ValaSymbol* _tmp59_;
	const gchar* _tmp60_;
	GList* _tmp61_ = NULL;
	GList* sigs;
	gboolean _tmp62_ = FALSE;
	GList* _tmp63_;
	gboolean _tmp66_;
	GList* _tmp67_;
	gconstpointer _tmp68_;
	ValaSignal* _tmp69_;
	ValaSignal* sig;
	GString* _tmp70_;
	const gchar* _tmp71_;
	gboolean _tmp72_;
	GString* _tmp125_;
	IAnjutaEditorGladeSignal* _tmp126_;
	IAnjutaIterable* _tmp127_;
	GString* _tmp128_;
	const gchar* _tmp129_;
	AnjutaShell* _tmp130_ = NULL;
	AnjutaShell* _tmp131_;
	AnjutaShell* _tmp132_;
	GObject* _tmp133_ = NULL;
	GObject* _tmp134_;
	GObject* _tmp135_;
	IAnjutaIndenter* _tmp136_;
	IAnjutaIndenter* indenter;
	IAnjutaIndenter* _tmp137_;
	IAnjutaEditorGladeSignal* _tmp150_;
	IAnjutaIterable* _tmp151_;
	gint _tmp152_ = 0;
	gint _tmp153_;
	IAnjutaEditorGladeSignal* _tmp154_;
	IAnjutaIterable* _tmp155_ = NULL;
	IAnjutaIterable* inside;
	IAnjutaEditorGladeSignal* _tmp156_;
	IAnjutaIterable* _tmp157_;
	IAnjutaIndenter* _tmp158_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	g_return_if_fail (signal_data != NULL);
	_tmp0_ = signal_data;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 0);
	data = _tmp2_;
	data_length1 = _vala_array_length (_tmp1_);
	_data_size_ = data_length1;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strdup (_tmp4_);
	widget_name = _tmp5_;
	_tmp6_ = data;
	_tmp6__length1 = data_length1;
	_tmp7_ = _tmp6_[1];
	_tmp8_ = string_replace (_tmp7_, "-", "_");
	signal_name = _tmp8_;
	_tmp9_ = data;
	_tmp9__length1 = data_length1;
	_tmp10_ = _tmp9_[2];
	_tmp11_ = g_strdup (_tmp10_);
	handler_name = _tmp11_;
	_tmp12_ = data;
	_tmp12__length1 = data_length1;
	_tmp13_ = _tmp12_[4];
	swapped = g_strcmp0 (_tmp13_, "1") == 0;
	_tmp14_ = position;
	_tmp15_ = ianjuta_iterable_clone (_tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = editor;
	_tmp18_ = _tmp16_;
	_tmp19_ = vala_plugin_get_scope (self, (IAnjutaEditor*) _tmp17_, _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp18_);
	scope = _tmp20_;
	_tmp21_ = g_string_new ("");
	builder = _tmp21_;
	_tmp22_ = g_strdup ("");
	scope_prefix = _tmp22_;
	_tmp23_ = scope;
	if (_tmp23_ != NULL) {
		ValaSymbol* _tmp24_;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp24_ = scope;
		_tmp25_ = vala_ccode_base_module_get_ccode_lower_case_prefix (_tmp24_);
		_g_free0 (scope_prefix);
		scope_prefix = _tmp25_;
		_tmp26_ = handler_name;
		_tmp27_ = scope_prefix;
		_tmp28_ = g_str_has_prefix (_tmp26_, _tmp27_);
		if (_tmp28_) {
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gchar* _tmp33_ = NULL;
			_tmp29_ = handler_name;
			_tmp30_ = scope_prefix;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = string_substring (_tmp29_, (glong) _tmp32_, (glong) (-1));
			_g_free0 (handler_name);
			handler_name = _tmp33_;
		}
	}
	_tmp34_ = scope_prefix;
	_tmp35_ = handler_name;
	_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
	handler_cname = _tmp36_;
	_tmp38_ = data;
	_tmp38__length1 = data_length1;
	_tmp39_ = _tmp38_[2];
	_tmp40_ = handler_cname;
	if (g_strcmp0 (_tmp39_, _tmp40_) != 0) {
		gboolean _tmp41_;
		_tmp41_ = swapped;
		_tmp37_ = !_tmp41_;
	} else {
		_tmp37_ = FALSE;
	}
	_tmp42_ = _tmp37_;
	if (_tmp42_) {
		GString* _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		const gchar* _tmp45_;
		_tmp43_ = builder;
		_tmp44_ = data;
		_tmp44__length1 = data_length1;
		_tmp45_ = _tmp44_[2];
		g_string_append_printf (_tmp43_, "[CCode (cname=\"%s\", instance_pos=-1)]\n", _tmp45_);
	} else {
		gchar** _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		_tmp46_ = data;
		_tmp46__length1 = data_length1;
		_tmp47_ = _tmp46_[2];
		_tmp48_ = handler_cname;
		if (g_strcmp0 (_tmp47_, _tmp48_) != 0) {
			GString* _tmp49_;
			gchar** _tmp50_;
			gint _tmp50__length1;
			const gchar* _tmp51_;
			_tmp49_ = builder;
			_tmp50_ = data;
			_tmp50__length1 = data_length1;
			_tmp51_ = _tmp50_[2];
			g_string_append_printf (_tmp49_, "[CCode (cname=\"%s\")]\n", _tmp51_);
		} else {
			gboolean _tmp52_;
			_tmp52_ = swapped;
			if (!_tmp52_) {
				GString* _tmp53_;
				_tmp53_ = builder;
				g_string_append (_tmp53_, "[CCode (instance_pos=-1)]\n");
			}
		}
	}
	_tmp54_ = widget_name;
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_code_context_get_root (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_plugin_lookup_symbol_by_cname (self, _tmp54_, (ValaSymbol*) _tmp57_);
	widget = _tmp58_;
	_tmp59_ = widget;
	_tmp60_ = signal_name;
	_tmp61_ = vala_plugin_symbol_lookup_inherited (self, _tmp59_, _tmp60_, FALSE, FALSE);
	sigs = _tmp61_;
	_tmp63_ = sigs;
	if (_tmp63_ == NULL) {
		_tmp62_ = TRUE;
	} else {
		GList* _tmp64_;
		gconstpointer _tmp65_;
		_tmp64_ = sigs;
		_tmp65_ = _tmp64_->data;
		_tmp62_ = !VALA_IS_SIGNAL ((ValaSymbol*) _tmp65_);
	}
	_tmp66_ = _tmp62_;
	if (_tmp66_) {
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp67_ = sigs;
	_tmp68_ = _tmp67_->data;
	_tmp69_ = _vala_code_node_ref0 (VALA_SIGNAL ((ValaSymbol*) _tmp68_));
	sig = _tmp69_;
	_tmp70_ = builder;
	_tmp71_ = handler_name;
	g_string_append_printf (_tmp70_, "public void %s (", _tmp71_);
	_tmp72_ = swapped;
	if (_tmp72_) {
		GString* _tmp73_;
		ValaSymbol* _tmp74_;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_;
		_tmp73_ = builder;
		_tmp74_ = widget;
		_tmp75_ = vala_symbol_get_full_name (_tmp74_);
		_tmp76_ = _tmp75_;
		g_string_append_printf (_tmp73_, "%s sender", _tmp76_);
		_g_free0 (_tmp76_);
		{
			ValaSignal* _tmp77_;
			ValaList* _tmp78_ = NULL;
			ValaList* _param_list;
			ValaList* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			gint _param_size;
			gint _param_index;
			_tmp77_ = sig;
			_tmp78_ = vala_signal_get_parameters (_tmp77_);
			_param_list = _tmp78_;
			_tmp79_ = _param_list;
			_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
			_tmp81_ = _tmp80_;
			_param_size = _tmp81_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp82_;
				gint _tmp83_;
				gint _tmp84_;
				ValaList* _tmp85_;
				gint _tmp86_;
				gpointer _tmp87_ = NULL;
				ValaParameter* param;
				GString* _tmp88_;
				ValaParameter* _tmp89_;
				ValaDataType* _tmp90_;
				ValaDataType* _tmp91_;
				ValaTypeSymbol* _tmp92_;
				ValaTypeSymbol* _tmp93_;
				gchar* _tmp94_ = NULL;
				gchar* _tmp95_;
				ValaParameter* _tmp96_;
				const gchar* _tmp97_;
				const gchar* _tmp98_;
				_tmp82_ = _param_index;
				_param_index = _tmp82_ + 1;
				_tmp83_ = _param_index;
				_tmp84_ = _param_size;
				if (!(_tmp83_ < _tmp84_)) {
					break;
				}
				_tmp85_ = _param_list;
				_tmp86_ = _param_index;
				_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
				param = (ValaParameter*) _tmp87_;
				_tmp88_ = builder;
				_tmp89_ = param;
				_tmp90_ = vala_variable_get_variable_type ((ValaVariable*) _tmp89_);
				_tmp91_ = _tmp90_;
				_tmp92_ = vala_data_type_get_data_type (_tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = param;
				_tmp97_ = vala_symbol_get_name ((ValaSymbol*) _tmp96_);
				_tmp98_ = _tmp97_;
				g_string_append_printf (_tmp88_, ", %s %s", _tmp95_, _tmp98_);
				_g_free0 (_tmp95_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	} else {
		GString* _tmp121_;
		ValaSymbol* _tmp122_;
		gchar* _tmp123_ = NULL;
		gchar* _tmp124_;
		{
			ValaSignal* _tmp99_;
			ValaList* _tmp100_ = NULL;
			ValaList* _param_list;
			ValaList* _tmp101_;
			gint _tmp102_;
			gint _tmp103_;
			gint _param_size;
			gint _param_index;
			_tmp99_ = sig;
			_tmp100_ = vala_signal_get_parameters (_tmp99_);
			_param_list = _tmp100_;
			_tmp101_ = _param_list;
			_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
			_tmp103_ = _tmp102_;
			_param_size = _tmp103_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp104_;
				gint _tmp105_;
				gint _tmp106_;
				ValaList* _tmp107_;
				gint _tmp108_;
				gpointer _tmp109_ = NULL;
				ValaParameter* param;
				GString* _tmp110_;
				ValaParameter* _tmp111_;
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				ValaTypeSymbol* _tmp114_;
				ValaTypeSymbol* _tmp115_;
				gchar* _tmp116_ = NULL;
				gchar* _tmp117_;
				ValaParameter* _tmp118_;
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				_tmp104_ = _param_index;
				_param_index = _tmp104_ + 1;
				_tmp105_ = _param_index;
				_tmp106_ = _param_size;
				if (!(_tmp105_ < _tmp106_)) {
					break;
				}
				_tmp107_ = _param_list;
				_tmp108_ = _param_index;
				_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
				param = (ValaParameter*) _tmp109_;
				_tmp110_ = builder;
				_tmp111_ = param;
				_tmp112_ = vala_variable_get_variable_type ((ValaVariable*) _tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = vala_data_type_get_data_type (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = param;
				_tmp119_ = vala_symbol_get_name ((ValaSymbol*) _tmp118_);
				_tmp120_ = _tmp119_;
				g_string_append_printf (_tmp110_, "%s %s, ", _tmp117_, _tmp120_);
				_g_free0 (_tmp117_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp121_ = builder;
		_tmp122_ = widget;
		_tmp123_ = vala_symbol_get_full_name (_tmp122_);
		_tmp124_ = _tmp123_;
		g_string_append_printf (_tmp121_, "%s sender", _tmp124_);
		_g_free0 (_tmp124_);
	}
	_tmp125_ = builder;
	g_string_append_printf (_tmp125_, ") {\n\n}\n");
	_tmp126_ = editor;
	_tmp127_ = position;
	_tmp128_ = builder;
	_tmp129_ = _tmp128_->str;
	ianjuta_editor_insert ((IAnjutaEditor*) _tmp126_, _tmp127_, _tmp129_, -1, &_inner_error_);
	if (_inner_error_ != NULL) {
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp130_, NULL);
	_tmp131_ = _tmp130_;
	_tmp132_ = _tmp131_;
	_tmp133_ = anjuta_shell_get_object (_tmp132_, "IAnjutaIndenter", &_inner_error_);
	_tmp134_ = _tmp133_;
	_g_object_unref0 (_tmp132_);
	_tmp135_ = _tmp134_;
	if (_inner_error_ != NULL) {
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp136_ = _g_object_ref0 (IANJUTA_IS_INDENTER (_tmp135_) ? ((IAnjutaIndenter*) _tmp135_) : NULL);
	indenter = _tmp136_;
	_tmp137_ = indenter;
	if (_tmp137_ != NULL) {
		IAnjutaIterable* _tmp138_;
		IAnjutaIterable* _tmp139_ = NULL;
		IAnjutaIterable* end;
		IAnjutaIterable* _tmp140_;
		gint _tmp141_ = 0;
		gint _tmp142_;
		IAnjutaIterable* _tmp143_;
		GString* _tmp144_;
		const gchar* _tmp145_;
		gint _tmp146_ = 0;
		IAnjutaIndenter* _tmp147_;
		IAnjutaIterable* _tmp148_;
		IAnjutaIterable* _tmp149_;
		_tmp138_ = position;
		_tmp139_ = ianjuta_iterable_clone (_tmp138_, &_inner_error_);
		end = _tmp139_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp140_ = end;
		_tmp141_ = ianjuta_iterable_get_position (_tmp140_, &_inner_error_);
		_tmp142_ = _tmp141_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp143_ = end;
		_tmp144_ = builder;
		_tmp145_ = _tmp144_->str;
		_tmp146_ = g_utf8_strlen (_tmp145_, (gssize) (-1));
		ianjuta_iterable_set_position (_tmp143_, (_tmp142_ + _tmp146_) - 1, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp147_ = indenter;
		_tmp148_ = position;
		_tmp149_ = end;
		ianjuta_indenter_indent (_tmp147_, _tmp148_, _tmp149_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (end);
	}
	_tmp150_ = editor;
	_tmp151_ = position;
	_tmp152_ = ianjuta_editor_get_line_from_position ((IAnjutaEditor*) _tmp150_, _tmp151_, &_inner_error_);
	_tmp153_ = _tmp152_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp154_ = editor;
	_tmp155_ = ianjuta_editor_get_line_end_position ((IAnjutaEditor*) _tmp154_, _tmp153_ + 2, &_inner_error_);
	inside = _tmp155_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp156_ = editor;
	_tmp157_ = inside;
	ianjuta_editor_goto_position ((IAnjutaEditor*) _tmp156_, _tmp157_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (inside);
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp158_ = indenter;
	if (_tmp158_ != NULL) {
		IAnjutaIndenter* _tmp159_;
		IAnjutaIterable* _tmp160_;
		IAnjutaIterable* _tmp161_;
		_tmp159_ = indenter;
		_tmp160_ = inside;
		_tmp161_ = inside;
		ianjuta_indenter_indent (_tmp159_, _tmp160_, _tmp161_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (inside);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (inside);
	_g_object_unref0 (indenter);
	_vala_code_node_unref0 (sig);
	__g_list_free__vala_code_node_unref0_0 (sigs);
	_vala_code_node_unref0 (widget);
	_g_free0 (handler_cname);
	_g_free0 (scope_prefix);
	_g_string_free0 (builder);
	_vala_code_node_unref0 (scope);
	_g_free0 (handler_name);
	_g_free0 (signal_name);
	_g_free0 (widget_name);
	data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
}


static void vala_plugin_insert_member_decl_and_init (ValaPlugin* self, IAnjutaEditor* editor, const gchar* widget_ctype, const gchar* widget_name, const gchar* filename) {
	const gchar* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* widget_type;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* basename;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* member_decl;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* member_init;
	gboolean _tmp17_ = FALSE;
	IAnjutaEditor* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_;
	gboolean _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (widget_ctype != NULL);
	g_return_if_fail (widget_name != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = widget_ctype;
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_root (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_plugin_lookup_symbol_by_cname (self, _tmp0_, (ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_full_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_code_node_unref0 (_tmp5_);
	widget_type = _tmp7_;
	_tmp8_ = filename;
	_tmp9_ = g_path_get_basename (_tmp8_);
	basename = _tmp9_;
	_tmp10_ = widget_type;
	_tmp11_ = widget_name;
	_tmp12_ = g_strdup_printf ("%s %s;\n", _tmp10_, _tmp11_);
	member_decl = _tmp12_;
	_tmp13_ = widget_name;
	_tmp14_ = widget_name;
	_tmp15_ = widget_type;
	_tmp16_ = g_strdup_printf ("%s = builder.get_object(\"%s\") as %s;\n", _tmp13_, _tmp14_, _tmp15_);
	member_init = _tmp16_;
	_tmp18_ = editor;
	_tmp19_ = basename;
	_tmp20_ = g_strdup_printf (VALA_PLUGIN_DECL_MARK, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = member_decl;
	_tmp23_ = vala_plugin_insert_after_mark (self, _tmp18_, _tmp21_, _tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp21_);
	if (_tmp24_) {
		IAnjutaEditor* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp25_ = editor;
		_tmp26_ = basename;
		_tmp27_ = g_strdup_printf (VALA_PLUGIN_INIT_MARK, _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = member_init;
		_tmp30_ = vala_plugin_insert_after_mark (self, _tmp25_, _tmp28_, _tmp29_);
		_tmp17_ = _tmp30_;
		_g_free0 (_tmp28_);
	} else {
		_tmp17_ = FALSE;
	}
	_tmp31_ = _tmp17_;
	_g_free0 (member_init);
	_g_free0 (member_decl);
	_g_free0 (basename);
	_g_free0 (widget_type);
}


static gboolean vala_plugin_insert_after_mark (ValaPlugin* self, IAnjutaEditor* editor, const gchar* mark, const gchar* code_to_add) {
	gboolean result = FALSE;
	IAnjutaEditor* _tmp0_;
	IAnjutaIterable* _tmp1_ = NULL;
	IAnjutaIterable* _tmp2_;
	IAnjutaEditorCell* _tmp3_;
	IAnjutaEditorCell* search_start;
	IAnjutaEditor* _tmp4_;
	IAnjutaIterable* _tmp5_ = NULL;
	IAnjutaIterable* _tmp6_;
	IAnjutaEditorCell* _tmp7_;
	IAnjutaEditorCell* search_end;
	IAnjutaEditorCell* result_end = NULL;
	IAnjutaEditor* _tmp8_;
	const gchar* _tmp9_;
	IAnjutaEditorCell* _tmp10_;
	IAnjutaEditorCell* _tmp11_;
	IAnjutaEditorCell* _tmp12_ = NULL;
	IAnjutaEditorCell* _tmp13_;
	IAnjutaIterable* _tmp14_;
	IAnjutaIterable* mark_position;
	IAnjutaIterable* _tmp15_;
	IAnjutaEditor* _tmp16_;
	IAnjutaIterable* _tmp17_;
	const gchar* _tmp18_;
	AnjutaShell* _tmp19_ = NULL;
	AnjutaShell* _tmp20_;
	AnjutaShell* _tmp21_;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GObject* _tmp24_;
	IAnjutaIndenter* _tmp25_;
	IAnjutaIndenter* indenter;
	IAnjutaIndenter* _tmp26_;
	IAnjutaEditor* _tmp38_;
	IAnjutaIterable* _tmp39_;
	const gchar* _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (editor != NULL, FALSE);
	g_return_val_if_fail (mark != NULL, FALSE);
	g_return_val_if_fail (code_to_add != NULL, FALSE);
	_tmp0_ = editor;
	_tmp1_ = ianjuta_editor_get_start_position (_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = _g_object_ref0 (IANJUTA_IS_EDITOR_CELL (_tmp2_) ? ((IAnjutaEditorCell*) _tmp2_) : NULL);
	search_start = _tmp3_;
	_tmp4_ = editor;
	_tmp5_ = ianjuta_editor_get_end_position (_tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = _g_object_ref0 (IANJUTA_IS_EDITOR_CELL (_tmp6_) ? ((IAnjutaEditorCell*) _tmp6_) : NULL);
	search_end = _tmp7_;
	_tmp8_ = editor;
	_tmp9_ = mark;
	_tmp10_ = search_start;
	_tmp11_ = search_end;
	ianjuta_editor_search_forward (IANJUTA_IS_EDITOR_SEARCH (_tmp8_) ? ((IAnjutaEditorSearch*) _tmp8_) : NULL, _tmp9_, FALSE, _tmp10_, _tmp11_, NULL, &_tmp12_, &_inner_error_);
	_g_object_unref0 (result_end);
	result_end = _tmp12_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp13_ = result_end;
	_tmp14_ = _g_object_ref0 (IANJUTA_IS_ITERABLE (_tmp13_) ? ((IAnjutaIterable*) _tmp13_) : NULL);
	mark_position = _tmp14_;
	_tmp15_ = mark_position;
	if (_tmp15_ == NULL) {
		result = FALSE;
		_g_object_unref0 (mark_position);
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		return result;
	}
	_tmp16_ = editor;
	_tmp17_ = mark_position;
	_tmp18_ = code_to_add;
	ianjuta_editor_insert (_tmp16_, _tmp17_, _tmp18_, -1, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (mark_position);
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = anjuta_shell_get_object (_tmp21_, "IAnjutaIndenter", &_inner_error_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp21_);
	_tmp24_ = _tmp23_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (mark_position);
		_g_object_unref0 (result_end);
		_g_object_unref0 (search_end);
		_g_object_unref0 (search_start);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp25_ = _g_object_ref0 (IANJUTA_IS_INDENTER (_tmp24_) ? ((IAnjutaIndenter*) _tmp24_) : NULL);
	indenter = _tmp25_;
	_tmp26_ = indenter;
	if (_tmp26_ != NULL) {
		IAnjutaIterable* _tmp27_;
		IAnjutaIterable* _tmp28_ = NULL;
		IAnjutaIterable* end;
		IAnjutaIterable* _tmp29_;
		gint _tmp30_ = 0;
		gint _tmp31_;
		IAnjutaIterable* _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_ = 0;
		IAnjutaIndenter* _tmp35_;
		IAnjutaIterable* _tmp36_;
		IAnjutaIterable* _tmp37_;
		_tmp27_ = mark_position;
		_tmp28_ = ianjuta_iterable_clone (_tmp27_, &_inner_error_);
		end = _tmp28_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp29_ = end;
		_tmp30_ = ianjuta_iterable_get_position (_tmp29_, &_inner_error_);
		_tmp31_ = _tmp30_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp32_ = end;
		_tmp33_ = code_to_add;
		_tmp34_ = g_utf8_strlen (_tmp33_, (gssize) (-1));
		ianjuta_iterable_set_position (_tmp32_, (_tmp31_ + _tmp34_) - 1, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp35_ = indenter;
		_tmp36_ = mark_position;
		_tmp37_ = end;
		ianjuta_indenter_indent (_tmp35_, _tmp36_, _tmp37_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_g_object_unref0 (mark_position);
			_g_object_unref0 (result_end);
			_g_object_unref0 (search_end);
			_g_object_unref0 (search_start);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (end);
	}
	_tmp38_ = editor;
	_tmp39_ = mark_position;
	_tmp40_ = code_to_add;
	g_signal_emit_by_name (_tmp38_, "code-added", _tmp39_, _tmp40_);
	result = TRUE;
	_g_object_unref0 (indenter);
	_g_object_unref0 (mark_position);
	_g_object_unref0 (result_end);
	_g_object_unref0 (search_end);
	_g_object_unref0 (search_start);
	return result;
}


static ValaSymbol* vala_plugin_lookup_symbol_by_cname (ValaPlugin* self, const gchar* cname, ValaSymbol* parent) {
	ValaSymbol* result = NULL;
	ValaSymbol* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* sym;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaMap* _tmp9_ = NULL;
	ValaMap* symtab;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cname != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	_tmp1_ = vala_symbol_get_scope (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = cname;
	_tmp4_ = vala_scope_lookup (_tmp2_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (_tmp5_ != NULL) {
		result = sym;
		return result;
	}
	_tmp6_ = parent;
	_tmp7_ = vala_symbol_get_scope (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_get_symbol_table (_tmp8_);
	symtab = _tmp9_;
	{
		ValaMap* _tmp10_;
		ValaSet* _tmp11_ = NULL;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_ = NULL;
		ValaIterator* _tmp14_;
		ValaIterator* _name_it;
		_tmp10_ = symtab;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_name_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			gboolean _tmp16_ = FALSE;
			ValaIterator* _tmp17_;
			gpointer _tmp18_ = NULL;
			gchar* name;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp15_ = _name_it;
			_tmp16_ = vala_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _name_it;
			_tmp18_ = vala_iterator_get (_tmp17_);
			name = (gchar*) _tmp18_;
			_tmp19_ = cname;
			_tmp20_ = name;
			_tmp21_ = g_str_has_prefix (_tmp19_, _tmp20_);
			if (_tmp21_) {
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaScope* _tmp29_;
				ValaScope* _tmp30_;
				const gchar* _tmp31_;
				ValaSymbol* _tmp32_ = NULL;
				ValaSymbol* _tmp33_;
				ValaSymbol* _tmp34_ = NULL;
				ValaSymbol* _tmp35_;
				_tmp22_ = cname;
				_tmp23_ = name;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_substring (_tmp22_, (glong) _tmp25_, (glong) (-1));
				_tmp27_ = _tmp26_;
				_tmp28_ = parent;
				_tmp29_ = vala_symbol_get_scope (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = name;
				_tmp32_ = vala_scope_lookup (_tmp30_, _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_plugin_lookup_symbol_by_cname (self, _tmp27_, _tmp33_);
				_tmp35_ = _tmp34_;
				_vala_code_node_unref0 (_tmp33_);
				_g_free0 (_tmp27_);
				result = _tmp35_;
				_g_free0 (name);
				_vala_iterator_unref0 (_name_it);
				_vala_map_unref0 (symtab);
				_vala_code_node_unref0 (sym);
				return result;
			}
			_g_free0 (name);
		}
		_vala_iterator_unref0 (_name_it);
	}
	result = NULL;
	_vala_map_unref0 (symtab);
	_vala_code_node_unref0 (sym);
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


ValaSymbol* vala_plugin_get_current_context (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position) {
	ValaSymbol* result = NULL;
	IAnjutaEditor* _tmp0_;
	IAnjutaEditor* _tmp1_;
	IAnjutaFile* _tmp2_;
	IAnjutaFile* file;
	IAnjutaFile* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	_tmp0_ = editor;
	g_return_val_if_fail (IANJUTA_IS_FILE (_tmp0_), NULL);
	_tmp1_ = editor;
	_tmp2_ = _g_object_ref0 (IANJUTA_IS_FILE (_tmp1_) ? ((IAnjutaFile*) _tmp1_) : NULL);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = ianjuta_file_get_file (_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	path = _tmp8_;
	{
		ValaCodeContext* _tmp9_;
		_tmp9_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaSourceFile* source;
			ValaSourceFile* _tmp27_;
			gint line = 0;
			gint column = 0;
			IAnjutaIterable* _tmp38_;
			BlockLocator* _tmp58_;
			ValaSourceFile* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			ValaSymbol* _tmp62_ = NULL;
			source = NULL;
			{
				ValaCodeContext* _tmp10_;
				ValaList* _tmp11_ = NULL;
				ValaList* _src_list;
				ValaList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _src_size;
				gint _src_index;
				_tmp10_ = self->priv->context;
				_tmp11_ = vala_code_context_get_source_files (_tmp10_);
				_src_list = _tmp11_;
				_tmp12_ = _src_list;
				_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_src_size = _tmp14_;
				_src_index = -1;
				while (TRUE) {
					gint _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					ValaList* _tmp18_;
					gint _tmp19_;
					gpointer _tmp20_ = NULL;
					ValaSourceFile* src;
					ValaSourceFile* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp15_ = _src_index;
					_src_index = _tmp15_ + 1;
					_tmp16_ = _src_index;
					_tmp17_ = _src_size;
					if (!(_tmp16_ < _tmp17_)) {
						break;
					}
					_tmp18_ = _src_list;
					_tmp19_ = _src_index;
					_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
					src = (ValaSourceFile*) _tmp20_;
					_tmp21_ = src;
					_tmp22_ = vala_source_file_get_filename (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = path;
					if (g_strcmp0 (_tmp23_, _tmp24_) == 0) {
						ValaSourceFile* _tmp25_;
						ValaSourceFile* _tmp26_;
						_tmp25_ = src;
						_tmp26_ = _vala_source_file_ref0 (_tmp25_);
						_vala_source_file_unref0 (source);
						source = _tmp26_;
						_vala_source_file_unref0 (src);
						break;
					}
					_vala_source_file_unref0 (src);
				}
				_vala_iterable_unref0 (_src_list);
			}
			_tmp27_ = source;
			if (_tmp27_ == NULL) {
				ValaSourceFileType _tmp28_ = 0;
				const gchar* _tmp29_;
				gboolean _tmp30_ = FALSE;
				ValaCodeContext* _tmp31_;
				ValaSourceFileType _tmp32_;
				const gchar* _tmp33_;
				ValaSourceFile* _tmp34_;
				ValaCodeContext* _tmp35_;
				ValaSourceFile* _tmp36_;
				ValaSourceFile* _tmp37_;
				_tmp29_ = path;
				_tmp30_ = g_str_has_suffix (_tmp29_, "vapi");
				if (_tmp30_) {
					_tmp28_ = VALA_SOURCE_FILE_TYPE_PACKAGE;
				} else {
					_tmp28_ = VALA_SOURCE_FILE_TYPE_SOURCE;
				}
				_tmp31_ = self->priv->context;
				_tmp32_ = _tmp28_;
				_tmp33_ = path;
				_tmp34_ = vala_source_file_new (_tmp31_, _tmp32_, _tmp33_, NULL);
				_vala_source_file_unref0 (source);
				source = _tmp34_;
				_tmp35_ = self->priv->context;
				_tmp36_ = source;
				vala_code_context_add_source_file (_tmp35_, _tmp36_);
				_tmp37_ = source;
				vala_plugin_update_file (self, _tmp37_);
			}
			_tmp38_ = position;
			if (_tmp38_ == NULL) {
				IAnjutaEditor* _tmp39_;
				gint _tmp40_ = 0;
				gint _tmp41_;
				IAnjutaEditor* _tmp42_;
				gint _tmp43_ = 0;
				gint _tmp44_;
				_tmp39_ = editor;
				_tmp40_ = ianjuta_editor_get_lineno (_tmp39_, &_inner_error_);
				_tmp41_ = _tmp40_;
				if (_inner_error_ != NULL) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				line = _tmp41_;
				_tmp42_ = editor;
				_tmp43_ = ianjuta_editor_get_column (_tmp42_, &_inner_error_);
				_tmp44_ = _tmp43_;
				if (_inner_error_ != NULL) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				column = _tmp44_;
			} else {
				IAnjutaEditor* _tmp45_;
				IAnjutaIterable* _tmp46_;
				gint _tmp47_ = 0;
				gint _tmp48_;
				IAnjutaEditor* _tmp49_;
				gint _tmp50_;
				IAnjutaIterable* _tmp51_ = NULL;
				IAnjutaIterable* _tmp52_;
				IAnjutaIterable* _tmp53_;
				IAnjutaIterable* _tmp54_;
				gint _tmp55_ = 0;
				gint _tmp56_;
				gint _tmp57_;
				_tmp45_ = editor;
				_tmp46_ = position;
				_tmp47_ = ianjuta_editor_get_line_from_position (_tmp45_, _tmp46_, &_inner_error_);
				_tmp48_ = _tmp47_;
				if (_inner_error_ != NULL) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				line = _tmp48_;
				_tmp49_ = editor;
				_tmp50_ = line;
				_tmp51_ = ianjuta_editor_get_line_begin_position (_tmp49_, _tmp50_, &_inner_error_);
				_tmp52_ = _tmp51_;
				if (_inner_error_ != NULL) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				_tmp53_ = _tmp52_;
				_tmp54_ = position;
				_tmp55_ = ianjuta_iterable_diff (_tmp53_, _tmp54_, &_inner_error_);
				_tmp56_ = _tmp55_;
				_g_object_unref0 (_tmp53_);
				_tmp57_ = _tmp56_;
				if (_inner_error_ != NULL) {
					_vala_source_file_unref0 (source);
					goto __finally6;
				}
				column = _tmp57_;
			}
			_tmp58_ = self->priv->locator;
			_tmp59_ = source;
			_tmp60_ = line;
			_tmp61_ = column;
			_tmp62_ = block_locator_locate (_tmp58_, _tmp59_, _tmp60_, _tmp61_);
			result = _tmp62_;
			_vala_source_file_unref0 (source);
			{
				ValaCodeContext* _tmp63_;
				_tmp63_ = self->priv->context;
				g_static_rec_mutex_unlock (&self->priv->__lock_context);
			}
			_g_free0 (path);
			_g_object_unref0 (file);
			return result;
		}
		__finally6:
		{
			ValaCodeContext* _tmp64_;
			_tmp64_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		_g_free0 (path);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	_g_object_unref0 (file);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block) {
	GList* result = NULL;
	GList* matching_symbols;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (block != NULL, NULL);
	matching_symbols = NULL;
	{
		ValaCodeContext* _tmp0_;
		_tmp0_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			ValaExpression* _tmp1_;
			_tmp1_ = inner;
			if (_tmp1_ == NULL) {
				{
					ValaBlock* _tmp2_;
					ValaSymbol* _tmp3_;
					ValaSymbol* sym;
					_tmp2_ = block;
					_tmp3_ = _vala_code_node_ref0 (VALA_SYMBOL (_tmp2_));
					sym = _tmp3_;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							ValaSymbol* _tmp10_;
							ValaSymbol* _tmp11_;
							const gchar* _tmp12_;
							gboolean _tmp13_;
							GList* _tmp14_ = NULL;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								ValaSymbol* _tmp6_;
								ValaSymbol* _tmp7_;
								ValaSymbol* _tmp8_;
								ValaSymbol* _tmp9_;
								_tmp6_ = sym;
								_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
								_tmp8_ = _tmp7_;
								_tmp9_ = _vala_code_node_ref0 (_tmp8_);
								_vala_code_node_unref0 (sym);
								sym = _tmp9_;
							}
							_tmp4_ = FALSE;
							_tmp10_ = sym;
							if (!(_tmp10_ != NULL)) {
								break;
							}
							_tmp11_ = sym;
							_tmp12_ = name;
							_tmp13_ = prefix_match;
							_tmp14_ = vala_plugin_symbol_lookup_inherited (self, _tmp11_, _tmp12_, _tmp13_, FALSE);
							matching_symbols = g_list_concat (matching_symbols, _tmp14_);
						}
					}
					_vala_code_node_unref0 (sym);
				}
				{
					ValaBlock* _tmp15_;
					ValaSourceReference* _tmp16_;
					ValaSourceReference* _tmp17_;
					ValaSourceFile* _tmp18_;
					ValaSourceFile* _tmp19_;
					ValaList* _tmp20_;
					ValaList* _tmp21_;
					ValaList* _tmp22_;
					ValaList* _ns_list;
					ValaList* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gint _ns_size;
					gint _ns_index;
					_tmp15_ = block;
					_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = vala_source_reference_get_file (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = vala_source_file_get_current_using_directives (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = _vala_iterable_ref0 (_tmp21_);
					_ns_list = _tmp22_;
					_tmp23_ = _ns_list;
					_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
					_tmp25_ = _tmp24_;
					_ns_size = _tmp25_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp26_;
						gint _tmp27_;
						gint _tmp28_;
						ValaList* _tmp29_;
						gint _tmp30_;
						gpointer _tmp31_ = NULL;
						ValaUsingDirective* ns;
						ValaUsingDirective* _tmp32_;
						ValaSymbol* _tmp33_;
						ValaSymbol* _tmp34_;
						const gchar* _tmp35_;
						gboolean _tmp36_;
						GList* _tmp37_ = NULL;
						_tmp26_ = _ns_index;
						_ns_index = _tmp26_ + 1;
						_tmp27_ = _ns_index;
						_tmp28_ = _ns_size;
						if (!(_tmp27_ < _tmp28_)) {
							break;
						}
						_tmp29_ = _ns_list;
						_tmp30_ = _ns_index;
						_tmp31_ = vala_list_get (_tmp29_, _tmp30_);
						ns = (ValaUsingDirective*) _tmp31_;
						_tmp32_ = ns;
						_tmp33_ = vala_using_directive_get_namespace_symbol (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = name;
						_tmp36_ = prefix_match;
						_tmp37_ = vala_plugin_symbol_lookup_inherited (self, _tmp34_, _tmp35_, _tmp36_, FALSE);
						matching_symbols = g_list_concat (matching_symbols, _tmp37_);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			} else {
				ValaExpression* _tmp38_;
				ValaSymbol* _tmp39_;
				ValaSymbol* _tmp40_;
				_tmp38_ = inner;
				_tmp39_ = vala_expression_get_symbol_reference (_tmp38_);
				_tmp40_ = _tmp39_;
				if (_tmp40_ != NULL) {
					ValaExpression* _tmp41_;
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					const gchar* _tmp44_;
					gboolean _tmp45_;
					GList* _tmp46_ = NULL;
					_tmp41_ = inner;
					_tmp42_ = vala_expression_get_symbol_reference (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = name;
					_tmp45_ = prefix_match;
					_tmp46_ = vala_plugin_symbol_lookup_inherited (self, _tmp43_, _tmp44_, _tmp45_, FALSE);
					matching_symbols = g_list_concat (matching_symbols, _tmp46_);
				} else {
					ValaExpression* _tmp47_;
					_tmp47_ = inner;
					if (VALA_IS_MEMBER_ACCESS (_tmp47_)) {
						ValaExpression* _tmp48_;
						ValaMemberAccess* _tmp49_;
						ValaMemberAccess* inner_ma;
						ValaMemberAccess* _tmp50_;
						ValaExpression* _tmp51_;
						ValaExpression* _tmp52_;
						ValaMemberAccess* _tmp53_;
						const gchar* _tmp54_;
						const gchar* _tmp55_;
						ValaBlock* _tmp56_;
						GList* _tmp57_ = NULL;
						GList* matching;
						GList* _tmp58_;
						_tmp48_ = inner;
						_tmp49_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (_tmp48_));
						inner_ma = _tmp49_;
						_tmp50_ = inner_ma;
						_tmp51_ = vala_member_access_get_inner (_tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = inner_ma;
						_tmp54_ = vala_member_access_get_member_name (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = block;
						_tmp57_ = vala_plugin_lookup_symbol (self, _tmp52_, _tmp55_, FALSE, _tmp56_);
						matching = _tmp57_;
						_tmp58_ = matching;
						if (_tmp58_ != NULL) {
							GList* _tmp59_;
							gconstpointer _tmp60_;
							const gchar* _tmp61_;
							gboolean _tmp62_;
							GList* _tmp63_ = NULL;
							_tmp59_ = matching;
							_tmp60_ = _tmp59_->data;
							_tmp61_ = name;
							_tmp62_ = prefix_match;
							_tmp63_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp60_, _tmp61_, _tmp62_, FALSE);
							matching_symbols = g_list_concat (matching_symbols, _tmp63_);
						}
						__g_list_free__vala_code_node_unref0_0 (matching);
						_vala_code_node_unref0 (inner_ma);
					} else {
						ValaExpression* _tmp64_;
						_tmp64_ = inner;
						if (VALA_IS_METHOD_CALL (_tmp64_)) {
							ValaExpression* _tmp65_;
							ValaMethodCall* _tmp66_;
							ValaMethodCall* inner_inv;
							ValaMethodCall* _tmp67_;
							ValaExpression* _tmp68_;
							ValaExpression* _tmp69_;
							ValaMemberAccess* _tmp70_;
							ValaMemberAccess* inner_ma;
							ValaMemberAccess* _tmp71_;
							_tmp65_ = inner;
							_tmp66_ = _vala_code_node_ref0 (VALA_METHOD_CALL (_tmp65_));
							inner_inv = _tmp66_;
							_tmp67_ = inner_inv;
							_tmp68_ = vala_method_call_get_call (_tmp67_);
							_tmp69_ = _tmp68_;
							_tmp70_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp69_) ? ((ValaMemberAccess*) _tmp69_) : NULL);
							inner_ma = _tmp70_;
							_tmp71_ = inner_ma;
							if (_tmp71_ != NULL) {
								ValaMemberAccess* _tmp72_;
								ValaExpression* _tmp73_;
								ValaExpression* _tmp74_;
								ValaMemberAccess* _tmp75_;
								const gchar* _tmp76_;
								const gchar* _tmp77_;
								ValaBlock* _tmp78_;
								GList* _tmp79_ = NULL;
								GList* matching;
								GList* _tmp80_;
								_tmp72_ = inner_ma;
								_tmp73_ = vala_member_access_get_inner (_tmp72_);
								_tmp74_ = _tmp73_;
								_tmp75_ = inner_ma;
								_tmp76_ = vala_member_access_get_member_name (_tmp75_);
								_tmp77_ = _tmp76_;
								_tmp78_ = block;
								_tmp79_ = vala_plugin_lookup_symbol (self, _tmp74_, _tmp77_, FALSE, _tmp78_);
								matching = _tmp79_;
								_tmp80_ = matching;
								if (_tmp80_ != NULL) {
									GList* _tmp81_;
									gconstpointer _tmp82_;
									const gchar* _tmp83_;
									gboolean _tmp84_;
									GList* _tmp85_ = NULL;
									_tmp81_ = matching;
									_tmp82_ = _tmp81_->data;
									_tmp83_ = name;
									_tmp84_ = prefix_match;
									_tmp85_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp82_, _tmp83_, _tmp84_, TRUE);
									matching_symbols = g_list_concat (matching_symbols, _tmp85_);
								}
								__g_list_free__vala_code_node_unref0_0 (matching);
							}
							_vala_code_node_unref0 (inner_ma);
							_vala_code_node_unref0 (inner_inv);
						}
					}
				}
			}
		}
		__finally7:
		{
			ValaCodeContext* _tmp86_;
			_tmp86_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (_inner_error_ != NULL) {
			__g_list_free__vala_code_node_unref0_0 (matching_symbols);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = matching_symbols;
	return result;
}


static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation) {
	GList* result = NULL;
	GList* _result_;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaMap* _tmp4_ = NULL;
	ValaMap* symbol_table;
	ValaMap* _tmp5_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_;
	gboolean _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = sym;
	if (_tmp0_ == NULL) {
		result = _result_;
		return result;
	}
	_tmp1_ = sym;
	_tmp2_ = vala_symbol_get_scope (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_get_symbol_table (_tmp3_);
	symbol_table = _tmp4_;
	_tmp5_ = symbol_table;
	if (_tmp5_ != NULL) {
		{
			ValaMap* _tmp6_;
			ValaSet* _tmp7_ = NULL;
			ValaSet* _tmp8_;
			ValaIterator* _tmp9_ = NULL;
			ValaIterator* _tmp10_;
			ValaIterator* _key_it;
			_tmp6_ = symbol_table;
			_tmp7_ = vala_map_get_keys (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_iterable_iterator ((ValaIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_vala_iterable_unref0 (_tmp8_);
			_key_it = _tmp10_;
			while (TRUE) {
				ValaIterator* _tmp11_;
				gboolean _tmp12_ = FALSE;
				ValaIterator* _tmp13_;
				gpointer _tmp14_ = NULL;
				gchar* key;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_;
				gboolean _tmp21_;
				gboolean _tmp24_;
				_tmp11_ = _key_it;
				_tmp12_ = vala_iterator_next (_tmp11_);
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = _key_it;
				_tmp14_ = vala_iterator_get (_tmp13_);
				key = (gchar*) _tmp14_;
				_tmp17_ = prefix_match;
				if (_tmp17_) {
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gboolean _tmp20_ = FALSE;
					_tmp18_ = key;
					_tmp19_ = name;
					_tmp20_ = g_str_has_prefix (_tmp18_, _tmp19_);
					_tmp16_ = _tmp20_;
				} else {
					_tmp16_ = FALSE;
				}
				_tmp21_ = _tmp16_;
				if (_tmp21_) {
					_tmp15_ = TRUE;
				} else {
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					_tmp22_ = key;
					_tmp23_ = name;
					_tmp15_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
				}
				_tmp24_ = _tmp15_;
				if (_tmp24_) {
					ValaMap* _tmp25_;
					const gchar* _tmp26_;
					gpointer _tmp27_ = NULL;
					_tmp25_ = symbol_table;
					_tmp26_ = key;
					_tmp27_ = vala_map_get (_tmp25_, _tmp26_);
					_result_ = g_list_append (_result_, (ValaSymbol*) _tmp27_);
				}
				_g_free0 (key);
			}
			_vala_iterator_unref0 (_key_it);
		}
	}
	_tmp29_ = invocation;
	if (_tmp29_) {
		ValaSymbol* _tmp30_;
		_tmp30_ = sym;
		_tmp28_ = VALA_IS_METHOD (_tmp30_);
	} else {
		_tmp28_ = FALSE;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		ValaSymbol* _tmp32_;
		ValaMethod* _tmp33_;
		ValaMethod* func;
		ValaMethod* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		ValaTypeSymbol* _tmp37_;
		ValaTypeSymbol* _tmp38_;
		const gchar* _tmp39_;
		gboolean _tmp40_;
		GList* _tmp41_ = NULL;
		_tmp32_ = sym;
		_tmp33_ = _vala_code_node_ref0 (VALA_METHOD (_tmp32_));
		func = _tmp33_;
		_tmp34_ = func;
		_tmp35_ = vala_method_get_return_type (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_data_type_get_data_type (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = name;
		_tmp40_ = prefix_match;
		_tmp41_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp38_, _tmp39_, _tmp40_, FALSE);
		_result_ = g_list_concat (_result_, _tmp41_);
		_vala_code_node_unref0 (func);
	} else {
		ValaSymbol* _tmp42_;
		_tmp42_ = sym;
		if (VALA_IS_CLASS (_tmp42_)) {
			ValaSymbol* _tmp43_;
			ValaClass* _tmp44_;
			ValaClass* cl;
			_tmp43_ = sym;
			_tmp44_ = _vala_code_node_ref0 (VALA_CLASS (_tmp43_));
			cl = _tmp44_;
			{
				ValaClass* _tmp45_;
				ValaList* _tmp46_ = NULL;
				ValaList* _base_type_list;
				ValaList* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gint _base_type_size;
				gint _base_type_index;
				_tmp45_ = cl;
				_tmp46_ = vala_class_get_base_types (_tmp45_);
				_base_type_list = _tmp46_;
				_tmp47_ = _base_type_list;
				_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
				_tmp49_ = _tmp48_;
				_base_type_size = _tmp49_;
				_base_type_index = -1;
				while (TRUE) {
					gint _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					ValaList* _tmp53_;
					gint _tmp54_;
					gpointer _tmp55_ = NULL;
					ValaDataType* base_type;
					ValaDataType* _tmp56_;
					ValaTypeSymbol* _tmp57_;
					ValaTypeSymbol* _tmp58_;
					const gchar* _tmp59_;
					gboolean _tmp60_;
					GList* _tmp61_ = NULL;
					_tmp50_ = _base_type_index;
					_base_type_index = _tmp50_ + 1;
					_tmp51_ = _base_type_index;
					_tmp52_ = _base_type_size;
					if (!(_tmp51_ < _tmp52_)) {
						break;
					}
					_tmp53_ = _base_type_list;
					_tmp54_ = _base_type_index;
					_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
					base_type = (ValaDataType*) _tmp55_;
					_tmp56_ = base_type;
					_tmp57_ = vala_data_type_get_data_type (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = name;
					_tmp60_ = prefix_match;
					_tmp61_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp58_, _tmp59_, _tmp60_, FALSE);
					_result_ = g_list_concat (_result_, _tmp61_);
					_vala_code_node_unref0 (base_type);
				}
				_vala_iterable_unref0 (_base_type_list);
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp62_;
			_tmp62_ = sym;
			if (VALA_IS_STRUCT (_tmp62_)) {
				ValaSymbol* _tmp63_;
				ValaStruct* _tmp64_;
				ValaStruct* st;
				ValaStruct* _tmp65_;
				ValaDataType* _tmp66_;
				ValaDataType* _tmp67_;
				ValaTypeSymbol* _tmp68_;
				ValaTypeSymbol* _tmp69_;
				const gchar* _tmp70_;
				gboolean _tmp71_;
				GList* _tmp72_ = NULL;
				_tmp63_ = sym;
				_tmp64_ = _vala_code_node_ref0 (VALA_STRUCT (_tmp63_));
				st = _tmp64_;
				_tmp65_ = st;
				_tmp66_ = vala_struct_get_base_type (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = vala_data_type_get_data_type (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = name;
				_tmp71_ = prefix_match;
				_tmp72_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp69_, _tmp70_, _tmp71_, FALSE);
				_result_ = g_list_concat (_result_, _tmp72_);
				_vala_code_node_unref0 (st);
			} else {
				ValaSymbol* _tmp73_;
				_tmp73_ = sym;
				if (VALA_IS_INTERFACE (_tmp73_)) {
					ValaSymbol* _tmp74_;
					ValaInterface* _tmp75_;
					ValaInterface* iface;
					_tmp74_ = sym;
					_tmp75_ = _vala_code_node_ref0 (VALA_INTERFACE (_tmp74_));
					iface = _tmp75_;
					{
						ValaInterface* _tmp76_;
						ValaList* _tmp77_ = NULL;
						ValaList* _prerequisite_list;
						ValaList* _tmp78_;
						gint _tmp79_;
						gint _tmp80_;
						gint _prerequisite_size;
						gint _prerequisite_index;
						_tmp76_ = iface;
						_tmp77_ = vala_interface_get_prerequisites (_tmp76_);
						_prerequisite_list = _tmp77_;
						_tmp78_ = _prerequisite_list;
						_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
						_tmp80_ = _tmp79_;
						_prerequisite_size = _tmp80_;
						_prerequisite_index = -1;
						while (TRUE) {
							gint _tmp81_;
							gint _tmp82_;
							gint _tmp83_;
							ValaList* _tmp84_;
							gint _tmp85_;
							gpointer _tmp86_ = NULL;
							ValaDataType* prerequisite;
							ValaDataType* _tmp87_;
							ValaTypeSymbol* _tmp88_;
							ValaTypeSymbol* _tmp89_;
							const gchar* _tmp90_;
							gboolean _tmp91_;
							GList* _tmp92_ = NULL;
							_tmp81_ = _prerequisite_index;
							_prerequisite_index = _tmp81_ + 1;
							_tmp82_ = _prerequisite_index;
							_tmp83_ = _prerequisite_size;
							if (!(_tmp82_ < _tmp83_)) {
								break;
							}
							_tmp84_ = _prerequisite_list;
							_tmp85_ = _prerequisite_index;
							_tmp86_ = vala_list_get (_tmp84_, _tmp85_);
							prerequisite = (ValaDataType*) _tmp86_;
							_tmp87_ = prerequisite;
							_tmp88_ = vala_data_type_get_data_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = name;
							_tmp91_ = prefix_match;
							_tmp92_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp89_, _tmp90_, _tmp91_, FALSE);
							_result_ = g_list_concat (_result_, _tmp92_);
							_vala_code_node_unref0 (prerequisite);
						}
						_vala_iterable_unref0 (_prerequisite_list);
					}
					_vala_code_node_unref0 (iface);
				} else {
					ValaSymbol* _tmp93_;
					_tmp93_ = sym;
					if (VALA_IS_LOCAL_VARIABLE (_tmp93_)) {
						ValaSymbol* _tmp94_;
						ValaLocalVariable* _tmp95_;
						ValaLocalVariable* variable;
						ValaLocalVariable* _tmp96_;
						ValaDataType* _tmp97_;
						ValaDataType* _tmp98_;
						ValaTypeSymbol* _tmp99_;
						ValaTypeSymbol* _tmp100_;
						const gchar* _tmp101_;
						gboolean _tmp102_;
						GList* _tmp103_ = NULL;
						_tmp94_ = sym;
						_tmp95_ = _vala_code_node_ref0 (VALA_LOCAL_VARIABLE (_tmp94_));
						variable = _tmp95_;
						_tmp96_ = variable;
						_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = vala_data_type_get_data_type (_tmp98_);
						_tmp100_ = _tmp99_;
						_tmp101_ = name;
						_tmp102_ = prefix_match;
						_tmp103_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp100_, _tmp101_, _tmp102_, FALSE);
						_result_ = g_list_concat (_result_, _tmp103_);
						_vala_code_node_unref0 (variable);
					} else {
						ValaSymbol* _tmp104_;
						_tmp104_ = sym;
						if (VALA_IS_FIELD (_tmp104_)) {
							ValaSymbol* _tmp105_;
							ValaField* _tmp106_;
							ValaField* field;
							ValaField* _tmp107_;
							ValaDataType* _tmp108_;
							ValaDataType* _tmp109_;
							ValaTypeSymbol* _tmp110_;
							ValaTypeSymbol* _tmp111_;
							const gchar* _tmp112_;
							gboolean _tmp113_;
							GList* _tmp114_ = NULL;
							_tmp105_ = sym;
							_tmp106_ = _vala_code_node_ref0 (VALA_FIELD (_tmp105_));
							field = _tmp106_;
							_tmp107_ = field;
							_tmp108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp107_);
							_tmp109_ = _tmp108_;
							_tmp110_ = vala_data_type_get_data_type (_tmp109_);
							_tmp111_ = _tmp110_;
							_tmp112_ = name;
							_tmp113_ = prefix_match;
							_tmp114_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp111_, _tmp112_, _tmp113_, FALSE);
							_result_ = g_list_concat (_result_, _tmp114_);
							_vala_code_node_unref0 (field);
						} else {
							ValaSymbol* _tmp115_;
							_tmp115_ = sym;
							if (VALA_IS_PROPERTY (_tmp115_)) {
								ValaSymbol* _tmp116_;
								ValaProperty* _tmp117_;
								ValaProperty* prop;
								ValaProperty* _tmp118_;
								ValaDataType* _tmp119_;
								ValaDataType* _tmp120_;
								ValaTypeSymbol* _tmp121_;
								ValaTypeSymbol* _tmp122_;
								const gchar* _tmp123_;
								gboolean _tmp124_;
								GList* _tmp125_ = NULL;
								_tmp116_ = sym;
								_tmp117_ = _vala_code_node_ref0 (VALA_PROPERTY (_tmp116_));
								prop = _tmp117_;
								_tmp118_ = prop;
								_tmp119_ = vala_property_get_property_type (_tmp118_);
								_tmp120_ = _tmp119_;
								_tmp121_ = vala_data_type_get_data_type (_tmp120_);
								_tmp122_ = _tmp121_;
								_tmp123_ = name;
								_tmp124_ = prefix_match;
								_tmp125_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp122_, _tmp123_, _tmp124_, FALSE);
								_result_ = g_list_concat (_result_, _tmp125_);
								_vala_code_node_unref0 (prop);
							} else {
								ValaSymbol* _tmp126_;
								_tmp126_ = sym;
								if (VALA_IS_PARAMETER (_tmp126_)) {
									ValaSymbol* _tmp127_;
									ValaParameter* _tmp128_;
									ValaParameter* fp;
									ValaParameter* _tmp129_;
									ValaDataType* _tmp130_;
									ValaDataType* _tmp131_;
									ValaTypeSymbol* _tmp132_;
									ValaTypeSymbol* _tmp133_;
									const gchar* _tmp134_;
									gboolean _tmp135_;
									GList* _tmp136_ = NULL;
									_tmp127_ = sym;
									_tmp128_ = _vala_code_node_ref0 (VALA_PARAMETER (_tmp127_));
									fp = _tmp128_;
									_tmp129_ = fp;
									_tmp130_ = vala_variable_get_variable_type ((ValaVariable*) _tmp129_);
									_tmp131_ = _tmp130_;
									_tmp132_ = vala_data_type_get_data_type (_tmp131_);
									_tmp133_ = _tmp132_;
									_tmp134_ = name;
									_tmp135_ = prefix_match;
									_tmp136_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp133_, _tmp134_, _tmp135_, FALSE);
									_result_ = g_list_concat (_result_, _tmp136_);
									_vala_code_node_unref0 (fp);
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	_vala_map_unref0 (symbol_table);
	return result;
}


static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		ValaCodeContext* _tmp0_;
		_tmp0_ = self->priv->context;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		{
			GEqualFunc _tmp1_;
			ValaArrayList* _tmp2_;
			ValaArrayList* nodes;
			ValaSourceFile* _tmp46_;
			GEqualFunc _tmp47_;
			ValaArrayList* _tmp48_;
			ValaArrayList* _tmp49_;
			ValaUnresolvedSymbol* _tmp50_;
			ValaUnresolvedSymbol* _tmp51_;
			ValaUsingDirective* _tmp52_;
			ValaUsingDirective* _tmp53_;
			ValaUsingDirective* ns_ref;
			ValaSourceFile* _tmp54_;
			ValaCodeContext* _tmp55_;
			ValaNamespace* _tmp56_;
			ValaNamespace* _tmp57_;
			AnjutaReport* _tmp58_;
			ValaSourceFile* _tmp59_;
			AnjutaReport* _tmp60_;
			IAnjutaEditor* _tmp61_;
			_tmp1_ = g_direct_equal;
			_tmp2_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp1_);
			nodes = _tmp2_;
			{
				ValaSourceFile* _tmp3_;
				ValaList* _tmp4_ = NULL;
				ValaList* _node_list;
				ValaList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _node_size;
				gint _node_index;
				_tmp3_ = file;
				_tmp4_ = vala_source_file_get_nodes (_tmp3_);
				_node_list = _tmp4_;
				_tmp5_ = _node_list;
				_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				_node_size = _tmp7_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					ValaList* _tmp11_;
					gint _tmp12_;
					gpointer _tmp13_ = NULL;
					ValaCodeNode* node;
					ValaArrayList* _tmp14_;
					ValaCodeNode* _tmp15_;
					_tmp8_ = _node_index;
					_node_index = _tmp8_ + 1;
					_tmp9_ = _node_index;
					_tmp10_ = _node_size;
					if (!(_tmp9_ < _tmp10_)) {
						break;
					}
					_tmp11_ = _node_list;
					_tmp12_ = _node_index;
					_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
					node = (ValaCodeNode*) _tmp13_;
					_tmp14_ = nodes;
					_tmp15_ = node;
					vala_collection_add ((ValaCollection*) _tmp14_, _tmp15_);
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			{
				ValaArrayList* _tmp16_;
				ValaArrayList* _tmp17_;
				ValaArrayList* _node_list;
				ValaArrayList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _node_size;
				gint _node_index;
				_tmp16_ = nodes;
				_tmp17_ = _vala_iterable_ref0 (_tmp16_);
				_node_list = _tmp17_;
				_tmp18_ = _node_list;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_node_size = _tmp20_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					ValaArrayList* _tmp24_;
					gint _tmp25_;
					gpointer _tmp26_ = NULL;
					ValaCodeNode* node;
					ValaSourceFile* _tmp27_;
					ValaCodeNode* _tmp28_;
					ValaCodeNode* _tmp29_;
					_tmp21_ = _node_index;
					_node_index = _tmp21_ + 1;
					_tmp22_ = _node_index;
					_tmp23_ = _node_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _node_list;
					_tmp25_ = _node_index;
					_tmp26_ = vala_list_get ((ValaList*) _tmp24_, _tmp25_);
					node = (ValaCodeNode*) _tmp26_;
					_tmp27_ = file;
					_tmp28_ = node;
					vala_source_file_remove_node (_tmp27_, _tmp28_);
					_tmp29_ = node;
					if (VALA_IS_SYMBOL (_tmp29_)) {
						ValaCodeNode* _tmp30_;
						ValaSymbol* _tmp31_;
						ValaSymbol* sym;
						ValaSymbol* _tmp32_;
						ValaScope* _tmp33_;
						ValaScope* _tmp34_;
						ValaCodeContext* _tmp41_;
						ValaMethod* _tmp42_;
						ValaMethod* _tmp43_;
						ValaSymbol* _tmp44_;
						_tmp30_ = node;
						_tmp31_ = _vala_code_node_ref0 (VALA_SYMBOL (_tmp30_));
						sym = _tmp31_;
						_tmp32_ = sym;
						_tmp33_ = vala_symbol_get_owner (_tmp32_);
						_tmp34_ = _tmp33_;
						if (_tmp34_ != NULL) {
							ValaSymbol* _tmp35_;
							ValaScope* _tmp36_;
							ValaScope* _tmp37_;
							ValaSymbol* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							_tmp35_ = sym;
							_tmp36_ = vala_symbol_get_owner (_tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = sym;
							_tmp39_ = vala_symbol_get_name (_tmp38_);
							_tmp40_ = _tmp39_;
							vala_scope_remove (_tmp37_, _tmp40_);
						}
						_tmp41_ = self->priv->context;
						_tmp42_ = vala_code_context_get_entry_point (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = sym;
						if (VALA_SYMBOL (_tmp43_) == _tmp44_) {
							ValaCodeContext* _tmp45_;
							_tmp45_ = self->priv->context;
							vala_code_context_set_entry_point (_tmp45_, NULL);
						}
						_vala_code_node_unref0 (sym);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_tmp46_ = file;
			_tmp47_ = g_direct_equal;
			_tmp48_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp47_);
			_tmp49_ = _tmp48_;
			vala_source_file_set_current_using_directives (_tmp46_, (ValaList*) _tmp49_);
			_vala_iterable_unref0 (_tmp49_);
			_tmp50_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_using_directive_new ((ValaSymbol*) _tmp51_, NULL);
			_tmp53_ = _tmp52_;
			_vala_code_node_unref0 (_tmp51_);
			ns_ref = _tmp53_;
			_tmp54_ = file;
			vala_source_file_add_using_directive (_tmp54_, ns_ref);
			_tmp55_ = self->priv->context;
			_tmp56_ = vala_code_context_get_root (_tmp55_);
			_tmp57_ = _tmp56_;
			vala_namespace_add_using_directive (_tmp57_, ns_ref);
			_tmp58_ = self->priv->report;
			_tmp59_ = file;
			anjuta_report_clear_error_indicators (_tmp58_, _tmp59_);
			vala_plugin_parse (self);
			_tmp60_ = self->priv->report;
			_tmp61_ = self->current_editor;
			anjuta_report_update_errors (_tmp60_, _tmp61_);
			_vala_code_node_unref0 (ns_ref);
			_vala_iterable_unref0 (nodes);
		}
		__finally8:
		{
			ValaCodeContext* _tmp62_;
			_tmp62_ = self->priv->context;
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void vala_plugin_class_init (ValaPluginClass * klass) {
	vala_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPluginPrivate));
	ANJUTA_PLUGIN_CLASS (klass)->activate = vala_plugin_real_activate;
	ANJUTA_PLUGIN_CLASS (klass)->deactivate = vala_plugin_real_deactivate;
	G_OBJECT_CLASS (klass)->finalize = vala_plugin_finalize;
}


static void vala_plugin_instance_init (ValaPlugin * self) {
	GSettings* _tmp0_;
	BlockLocator* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	self->priv = VALA_PLUGIN_GET_PRIVATE (self);
	_tmp0_ = g_settings_new ("org.gnome.anjuta.cpp");
	self->settings = _tmp0_;
	g_static_rec_mutex_init (&self->priv->__lock_context);
	_tmp1_ = block_locator_new ();
	self->priv->locator = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp2_, _tmp3_);
	self->priv->current_sources = (ValaSet*) _tmp4_;
}


static void vala_plugin_finalize (GObject* obj) {
	ValaPlugin * self;
	self = VALA_PLUGIN (obj);
	_g_object_unref0 (self->settings);
	g_static_rec_mutex_free (&self->priv->__lock_context);
	_vala_code_context_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->cancel);
	_vala_code_visitor_unref0 (self->priv->locator);
	_g_object_unref0 (self->priv->report);
	_g_object_unref0 (self->priv->provider);
	_vala_code_visitor_unref0 (self->priv->parser);
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	_vala_iterable_unref0 (self->priv->current_sources);
	G_OBJECT_CLASS (vala_plugin_parent_class)->finalize (obj);
}


GType vala_plugin_get_type (void) {
	return vala_plugin_type_id;
}


GType vala_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ValaPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPlugin), 0, (GInstanceInitFunc) vala_plugin_instance_init, NULL };
	vala_plugin_type_id = g_type_module_register_type (module, anjuta_plugin_get_type (), "ValaPlugin", &g_define_type_info, 0);
	return vala_plugin_type_id;
}


GType anjuta_glue_register_components (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	block_locator_register_type (module);
	vala_plugin_register_type (module);
	vala_provider_register_type (module);
	anjuta_report_register_type (module);
	result = TYPE_VALA_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



