/* clutter-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Clutter", gir_namespace = "Clutter", gir_version = "1.0", lower_case_cprefix = "clutter_")]
namespace Clutter {
	namespace FrameSource {
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static uint add (uint fps, GLib.SourceFunc func);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static uint add_full (int priority, uint fps, owned GLib.SourceFunc func);
	}
	namespace Threads {
		namespace FrameSource {
			[CCode (cheader_filename = "clutter/clutter.h", cname = "clutter_threads_add_frame_source")]
			public static uint add (uint fps, GLib.SourceFunc func);
			[CCode (cheader_filename = "clutter/clutter.h", cname = "clutter_threads_add_frame_source_full")]
			public static uint add_full (int priority, uint fps, owned GLib.SourceFunc func);
		}
		namespace Idle {
			[CCode (cheader_filename = "clutter/clutter.h", cname = "clutter_threads_add_idle")]
			public static uint add (GLib.SourceFunc func);
			[CCode (cheader_filename = "clutter/clutter.h", cname = "clutter_threads_add_idle_full")]
			public static uint add_full (int priority, owned GLib.SourceFunc func);
		}
		namespace Timeout {
			[CCode (cheader_filename = "clutter/clutter.h", cname = "clutter_threads_add_timeout")]
			public static uint add (uint interval, GLib.SourceFunc func);
			[CCode (cheader_filename = "clutter/clutter.h", cname = "clutter_threads_add_timeout_full")]
			public static uint add_full (int priority, uint interval, owned GLib.SourceFunc func);
		}
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static uint add_repaint_func (owned GLib.SourceFunc func);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void enter ();
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void init ();
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void leave ();
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void remove_repaint_func (uint handle_id);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_lock_functions (GLib.Callback enter_fn, GLib.Callback leave_fn);
	}
	namespace Util {
		[CCode (cheader_filename = "clutter/clutter.h", cname = "clutter_util_next_p2")]
		public static int next_power_of_2 (int a);
	}
	namespace Value {
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static unowned Clutter.Color? get_color (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static unowned Cogl.Fixed? get_fixed (GLib.Value value);
		[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "clutter/clutter.h")]
		public static unowned float[] get_shader_float (GLib.Value value);
		[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "clutter/clutter.h")]
		public static unowned int[] get_shader_int (GLib.Value value);
		[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "clutter/clutter.h")]
		public static unowned float[] get_shader_matrix (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static Clutter.Units get_units (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_color (GLib.Value value, Clutter.Color color);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_fixed (GLib.Value value, Cogl.Fixed fixed_);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_shader_float (GLib.Value value, [CCode (array_length_cname = "size", array_length_pos = 1.5, type = "gfloat*")] float[] floats);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_shader_int (GLib.Value value, [CCode (array_length_cname = "size", array_length_pos = 1.5, type = "gint*")] int[] ints);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_shader_matrix (GLib.Value value, [CCode (array_length_cname = "size", array_length_pos = 1.5, type = "gfloat*")] float[] matrix);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_units (GLib.Value value, Clutter.Units units);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_action_get_type ()")]
	public abstract class Action : Clutter.ActorMeta {
		[CCode (has_construct_function = false)]
		protected Action ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_actor_get_type ()")]
	public abstract class Actor : GLib.InitiallyUnowned, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		public uint32 flags;
		[CCode (has_construct_function = false)]
		protected Actor ();
		public void add_action (Clutter.Action action);
		public void add_action_with_name (string name, Clutter.Action action);
		public void add_constraint (Clutter.Constraint constraint);
		public void add_constraint_with_name (string name, Clutter.Constraint constraint);
		public void add_effect (Clutter.Effect effect);
		public void add_effect_with_name (string name, Clutter.Effect effect);
		public virtual void allocate (Clutter.ActorBox box, Clutter.AllocationFlags flags);
		public void allocate_align_fill (Clutter.ActorBox box, double x_align, double y_align, bool x_fill, bool y_fill, Clutter.AllocationFlags flags);
		public void allocate_available_size (float x, float y, float available_width, float available_height, Clutter.AllocationFlags flags);
		public void allocate_preferred_size (Clutter.AllocationFlags flags);
		public unowned Clutter.Animation animate (ulong mode, uint duration, ...);
		public unowned Clutter.Animation animate_with_alpha (Clutter.Alpha alpha, ...);
		public unowned Clutter.Animation animate_with_alphav (Clutter.Alpha alpha, [CCode (array_length_cname = "n_properties", array_length_pos = 1.5)] string[] properties, [CCode (array_length_cname = "n_properties", array_length_pos = 1.5)] GLib.Value[] values);
		public unowned Clutter.Animation animate_with_timeline (ulong mode, Clutter.Timeline timeline, ...);
		public unowned Clutter.Animation animate_with_timelinev (ulong mode, Clutter.Timeline timeline, [CCode (array_length_cname = "n_properties", array_length_pos = 2.5)] string[] properties, [CCode (array_length_cname = "n_properties", array_length_pos = 2.5)] GLib.Value[] values);
		public unowned Clutter.Animation animatev (ulong mode, uint duration, [CCode (array_length_cname = "n_properties", array_length_pos = 2.5)] string[] properties, [CCode (array_length_cname = "n_properties", array_length_pos = 2.5)] GLib.Value[] values);
		public Clutter.Vertex apply_relative_transform_to_point (Clutter.Actor? ancestor, Clutter.Vertex point);
		[NoWrapper]
		public virtual void apply_transform (ref Cogl.Matrix matrix);
		public Clutter.Vertex apply_transform_to_point (Clutter.Vertex point);
		public void clear_actions ();
		public void clear_constraints ();
		public void clear_effects ();
		public bool contains (Clutter.Actor descendant);
		public void continue_paint ();
		public Pango.Context create_pango_context ();
		public Pango.Layout create_pango_layout (string text);
		public void detach_animation ();
		public void get_abs_allocation_vertices ([CCode (array_length = false)] out Clutter.Vertex[] verts);
		public virtual unowned Atk.Object get_accessible ();
		public unowned Clutter.Action get_action (string name);
		public GLib.List<weak Clutter.Action> get_actions ();
		public Clutter.ActorBox get_allocation_box ();
		public Clutter.Geometry get_allocation_geometry ();
		public void get_allocation_vertices (Clutter.Actor? ancestor, [CCode (array_length = false)] out Clutter.Vertex[] verts);
		public void get_anchor_point (out float anchor_x, out float anchor_y);
		public Clutter.Gravity get_anchor_point_gravity ();
		public unowned Clutter.Animation get_animation ();
		[CCode (cname = "clutter_get_actor_by_gid")]
		[Deprecated (since = "1.8")]
		public static unowned Clutter.Actor get_by_gid (uint32 id_);
		public void get_clip (out float xoff, out float yoff, out float width, out float height);
		public bool get_clip_to_allocation ();
		public unowned Clutter.Constraint get_constraint (string name);
		public GLib.List<weak Clutter.Constraint> get_constraints ();
		public float get_depth ();
		public unowned Clutter.Effect get_effect (string name);
		public GLib.List<weak Clutter.Effect> get_effects ();
		public bool get_fixed_position_set ();
		public Clutter.ActorFlags get_flags ();
		public Clutter.Geometry get_geometry ();
		[Deprecated (since = "1.8")]
		public uint32 get_gid ();
		[CCode (cname = "clutter_actor_has_pointer")]
		public bool get_has_pointer ();
		public float get_height ();
		public unowned string get_name ();
		public Clutter.OffscreenRedirect get_offscreen_redirect ();
		public uint8 get_opacity ();
		public bool get_paint_box (out Clutter.ActorBox box);
		public uint8 get_paint_opacity ();
		public bool get_paint_visibility ();
		[NoWrapper]
		public virtual bool get_paint_volume (Clutter.PaintVolume volume);
		public unowned Pango.Context get_pango_context ();
		public unowned Clutter.Actor? get_parent ();
		public void get_position (out float x, out float y);
		public virtual void get_preferred_height (float for_width, out float min_height_p, out float natural_height_p);
		public void get_preferred_size (out float min_width_p, out float min_height_p, out float natural_width_p, out float natural_height_p);
		public virtual void get_preferred_width (float for_height, out float min_width_p, out float natural_width_p);
		public bool get_reactive ();
		public Clutter.RequestMode get_request_mode ();
		public double get_rotation (Clutter.RotateAxis axis, out float x, out float y, out float z);
		public void get_scale (out double scale_x, out double scale_y);
		public void get_scale_center (out float center_x, out float center_y);
		public Clutter.Gravity get_scale_gravity ();
		[Deprecated (since = "1.8")]
		public unowned Clutter.Shader get_shader ();
		public void get_size (out float width, out float height);
		public unowned Clutter.Stage get_stage ();
		public Clutter.TextDirection get_text_direction ();
		public Cogl.Matrix get_transformation_matrix ();
		public unowned Clutter.PaintVolume get_transformed_paint_volume (Clutter.Actor relative_to_ancestor);
		public void get_transformed_position (out float x, out float y);
		public void get_transformed_size (out float width, out float height);
		public float get_width ();
		public float get_x ();
		public float get_y ();
		public Clutter.Gravity get_z_rotation_gravity ();
		public void grab_key_focus ();
		public bool has_allocation ();
		public bool has_key_focus ();
		public virtual bool has_overlaps ();
		public virtual void hide_all ();
		public bool is_in_clone_paint ();
		public bool is_rotated ();
		public bool is_scaled ();
		public void lower (Clutter.Actor? above);
		public void lower_bottom ();
		public virtual void map ();
		public void move_anchor_point (float anchor_x, float anchor_y);
		public void move_anchor_point_from_gravity (Clutter.Gravity gravity);
		public void move_by (float dx, float dy);
		public void pop_internal ();
		public void push_internal ();
		public void queue_redraw ();
		public void raise (Clutter.Actor? below);
		public void raise_top ();
		public void remove_action (Clutter.Action action);
		public void remove_action_by_name (string name);
		public void remove_clip ();
		public void remove_constraint (Clutter.Constraint constraint);
		public void remove_constraint_by_name (string name);
		public void remove_effect (Clutter.Effect effect);
		public void remove_effect_by_name (string name);
		public void reparent (Clutter.Actor new_parent);
		public void set_anchor_point (float anchor_x, float anchor_y);
		public void set_anchor_point_from_gravity (Clutter.Gravity gravity);
		public void set_clip (float xoff, float yoff, float width, float height);
		public void set_clip_to_allocation (bool clip_set);
		public void set_depth (float depth);
		public void set_fixed_position_set (bool is_set);
		public void set_flags (Clutter.ActorFlags flags);
		public void set_geometry (Clutter.Geometry geometry);
		public void set_height (float height);
		public void set_name (string name);
		public void set_offscreen_redirect (Clutter.OffscreenRedirect redirect);
		public void set_opacity (uint8 opacity);
		public void set_parent (Clutter.Actor parent);
		public void set_position (float x, float y);
		public void set_reactive (bool reactive);
		public void set_request_mode (Clutter.RequestMode mode);
		public void set_rotation (Clutter.RotateAxis axis, double angle, float x, float y, float z);
		public void set_scale (double scale_x, double scale_y);
		public void set_scale_full (double scale_x, double scale_y, float center_x, float center_y);
		public void set_scale_with_gravity (double scale_x, double scale_y, Clutter.Gravity gravity);
		[Deprecated (since = "1.8")]
		public bool set_shader (Clutter.Shader? shader);
		[Deprecated (since = "1.8")]
		public void set_shader_param (string param, GLib.Value value);
		[Deprecated (since = "1.8")]
		public void set_shader_param_float (string param, float value);
		[Deprecated (since = "1.8")]
		public void set_shader_param_int (string param, int value);
		public void set_size (float width, float height);
		public void set_text_direction (Clutter.TextDirection text_dir);
		public void set_width (float width);
		public void set_x (float x);
		public void set_y (float y);
		public void set_z_rotation_from_gravity (double angle, Clutter.Gravity gravity);
		public bool should_pick_paint ();
		public virtual void show_all ();
		public bool transform_stage_point (float x, float y, out float x_out, out float y_out);
		public virtual void unmap ();
		public void unparent ();
		public void unset_flags (Clutter.ActorFlags flags);
		[NoAccessorMethod]
		public Clutter.Action actions { set; }
		[NoAccessorMethod]
		public Clutter.ActorBox allocation { get; }
		[NoAccessorMethod]
		public Clutter.Gravity anchor_gravity { get; set; }
		[NoAccessorMethod]
		public float anchor_x { get; set; }
		[NoAccessorMethod]
		public float anchor_y { get; set; }
		[NoAccessorMethod]
		public Clutter.Geometry clip { get; set; }
		public bool clip_to_allocation { get; set; }
		[NoAccessorMethod]
		public Clutter.Constraint constraints { set; }
		public float depth { get; set; }
		[NoAccessorMethod]
		public Clutter.Effect effect { set; }
		public bool fixed_position_set { get; set; }
		[NoAccessorMethod]
		public float fixed_x { get; set; }
		[NoAccessorMethod]
		public float fixed_y { get; set; }
		[NoAccessorMethod]
		public bool has_clip { get; }
		[NoAccessorMethod]
		public bool has_pointer { get; }
		public float height { get; set; }
		[NoAccessorMethod]
		public bool mapped { get; }
		[NoAccessorMethod]
		public float min_height { get; set; }
		[NoAccessorMethod]
		public bool min_height_set { get; set; }
		[NoAccessorMethod]
		public float min_width { get; set; }
		[NoAccessorMethod]
		public bool min_width_set { get; set; }
		public string name { get; set; }
		[NoAccessorMethod]
		public float natural_height { get; set; }
		[NoAccessorMethod]
		public bool natural_height_set { get; set; }
		[NoAccessorMethod]
		public float natural_width { get; set; }
		[NoAccessorMethod]
		public bool natural_width_set { get; set; }
		public Clutter.OffscreenRedirect offscreen_redirect { get; set; }
		public uint opacity { get; set; }
		public bool reactive { get; set; }
		[NoAccessorMethod]
		public bool realized { get; }
		public Clutter.RequestMode request_mode { get; set; }
		[NoAccessorMethod]
		public double rotation_angle_x { get; set; }
		[NoAccessorMethod]
		public double rotation_angle_y { get; set; }
		[NoAccessorMethod]
		public double rotation_angle_z { get; set; }
		[NoAccessorMethod]
		public Clutter.Vertex rotation_center_x { get; set; }
		[NoAccessorMethod]
		public Clutter.Vertex rotation_center_y { get; set; }
		[NoAccessorMethod]
		public Clutter.Vertex rotation_center_z { get; set; }
		[NoAccessorMethod]
		public Clutter.Gravity rotation_center_z_gravity { get; set; }
		[NoAccessorMethod]
		public float scale_center_x { get; set; }
		[NoAccessorMethod]
		public float scale_center_y { get; set; }
		[NoAccessorMethod]
		public Clutter.Gravity scale_gravity { get; set; }
		[NoAccessorMethod]
		public double scale_x { get; set; }
		[NoAccessorMethod]
		public double scale_y { get; set; }
		[NoAccessorMethod]
		public bool show_on_set_parent { get; set; }
		public Clutter.TextDirection text_direction { get; set; }
		[NoAccessorMethod]
		public bool visible { get; set; }
		public float width { get; set; }
		public float x { get; set; }
		public float y { get; set; }
		public signal void allocation_changed (Clutter.ActorBox box, Clutter.AllocationFlags flags);
		public virtual signal bool button_press_event (Clutter.ButtonEvent event);
		public virtual signal bool button_release_event (Clutter.ButtonEvent event);
		public virtual signal bool captured_event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void destroy ();
		public virtual signal bool enter_event (Clutter.CrossingEvent event);
		[HasEmitter]
		public virtual signal bool event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void hide ();
		public virtual signal void key_focus_in ();
		public virtual signal void key_focus_out ();
		public virtual signal bool key_press_event (Clutter.KeyEvent event);
		public virtual signal bool key_release_event (Clutter.KeyEvent event);
		public virtual signal bool leave_event (Clutter.CrossingEvent event);
		public virtual signal bool motion_event (Clutter.MotionEvent event);
		[HasEmitter]
		public virtual signal void paint ();
		public virtual signal void parent_set (Clutter.Actor? old_parent);
		public virtual signal void pick (Clutter.Color color);
		[HasEmitter]
		public virtual signal void queue_relayout ();
		[HasEmitter]
		public virtual signal void realize ();
		public virtual signal bool scroll_event (Clutter.ScrollEvent event);
		[HasEmitter]
		public virtual signal void show ();
		[HasEmitter]
		public virtual signal void unrealize ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_actor_meta_get_type ()")]
	public abstract class ActorMeta : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		protected ActorMeta ();
		public unowned Clutter.Actor get_actor ();
		public bool get_enabled ();
		public unowned string get_name ();
		[NoWrapper]
		public virtual void set_actor (Clutter.Actor actor);
		public void set_enabled (bool is_enabled);
		public void set_name (string name);
		public Clutter.Actor actor { get; }
		public bool enabled { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_align_constraint_get_type ()")]
	public class AlignConstraint : Clutter.Constraint {
		[CCode (has_construct_function = false, type = "ClutterConstraint*")]
		public AlignConstraint (Clutter.Actor? source, Clutter.AlignAxis axis, float factor);
		public Clutter.AlignAxis get_align_axis ();
		public float get_factor ();
		public unowned Clutter.Actor get_source ();
		public void set_align_axis (Clutter.AlignAxis axis);
		public void set_factor (float factor);
		public void set_source (Clutter.Actor? source);
		public Clutter.AlignAxis align_axis { get; set construct; }
		public float factor { get; set construct; }
		public Clutter.Actor source { get; set construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_alpha_get_type ()")]
	public class Alpha : GLib.InitiallyUnowned, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		public Alpha ();
		[CCode (has_construct_function = false)]
		public Alpha.full (Clutter.Timeline timeline, ulong mode);
		public double get_alpha ();
		public ulong get_mode ();
		public unowned Clutter.Timeline get_timeline ();
		public static ulong register_closure (GLib.Closure closure);
		public static ulong register_func (Clutter.AlphaFunc func);
		public void set_closure (GLib.Closure closure);
		public void set_func (owned Clutter.AlphaFunc func);
		public void set_mode (ulong mode);
		public void set_timeline (Clutter.Timeline timeline);
		[CCode (has_construct_function = false)]
		public Alpha.with_func (Clutter.Timeline timeline, owned Clutter.AlphaFunc func);
		public double alpha { get; }
		public ulong mode { get; set construct; }
		public Clutter.Timeline timeline { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_animation_get_type ()")]
	public class Animation : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		public Animation ();
		public unowned Clutter.Animation bind (string property_name, GLib.Value final);
		public unowned Clutter.Animation bind_interval (string property_name, owned Clutter.Interval interval);
		public unowned Clutter.Alpha get_alpha ();
		public uint get_duration ();
		public unowned Clutter.Interval get_interval (string property_name);
		public bool get_loop ();
		public ulong get_mode ();
		public unowned GLib.Object get_object ();
		public unowned Clutter.Timeline get_timeline ();
		public bool has_property (string property_name);
		public void set_alpha (Clutter.Alpha alpha);
		public void set_duration (uint msecs);
		public void set_loop (bool loop);
		public void set_mode (ulong mode);
		public void set_object (GLib.Object object);
		public void set_timeline (Clutter.Timeline timeline);
		public void unbind_property (string property_name);
		public unowned Clutter.Animation update (string property_name, GLib.Value final);
		public void update_interval (string property_name, Clutter.Interval interval);
		public Clutter.Alpha alpha { get; set; }
		public uint duration { get; set; }
		public bool loop { get; set; }
		public ulong mode { get; set; }
		public GLib.Object object { get; set; }
		public Clutter.Timeline timeline { get; set; }
		[HasEmitter]
		public virtual signal void completed ();
		public virtual signal void started ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_animator_get_type ()")]
	public class Animator : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		public Animator ();
		public bool compute_value (GLib.Object object, string property_name, double progress, GLib.Value value);
		public uint get_duration ();
		public GLib.List<weak Clutter.AnimatorKey> get_keys (GLib.Object? object, string? property_name, double progress);
		public unowned Clutter.Timeline get_timeline ();
		public bool property_get_ease_in (GLib.Object object, string property_name);
		public Clutter.Interpolation property_get_interpolation (GLib.Object object, string property_name);
		public void property_set_ease_in (GLib.Object object, string property_name, bool ease_in);
		public void property_set_interpolation (GLib.Object object, string property_name, Clutter.Interpolation interpolation);
		public void remove_key (GLib.Object? object, string? property_name, double progress);
		public void @set (void* first_object, string first_property_name, uint first_mode, ...);
		public void set_duration (uint duration);
		public unowned Clutter.Animator set_key (GLib.Object object, string property_name, uint mode, double progress, GLib.Value value);
		public void set_timeline (Clutter.Timeline timeline);
		public unowned Clutter.Timeline start ();
		public uint duration { get; set; }
		public Clutter.Timeline timeline { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "clutter_animator_key_get_type ()")]
	[Compact]
	public class AnimatorKey {
		public ulong get_mode ();
		public unowned GLib.Object get_object ();
		public double get_progress ();
		public unowned string get_property_name ();
		public GLib.Type get_property_type ();
		public bool get_value (GLib.Value value);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Backend : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Backend ();
		[NoWrapper]
		public virtual void add_options (GLib.OptionGroup group);
		[NoWrapper]
		public virtual bool create_context () throws GLib.Error;
		[NoWrapper]
		public virtual unowned Clutter.StageWindow create_stage (Clutter.Stage wrapper) throws GLib.Error;
		[NoWrapper]
		public virtual void ensure_context (Clutter.Stage stage);
		[NoWrapper]
		public virtual unowned Clutter.DeviceManager get_device_manager ();
		[Deprecated (since = "1.4")]
		public uint get_double_click_distance ();
		[Deprecated (since = "1.4")]
		public uint get_double_click_time ();
		[NoWrapper]
		public virtual Clutter.FeatureFlags get_features ();
		[Deprecated (since = "1.4")]
		public unowned string get_font_name ();
		public unowned Cairo.FontOptions get_font_options ();
		public double get_resolution ();
		[NoWrapper]
		public virtual void init_events ();
		[NoWrapper]
		public virtual void init_features ();
		[NoWrapper]
		public virtual bool post_parse () throws GLib.Error;
		[NoWrapper]
		public virtual bool pre_parse () throws GLib.Error;
		[NoWrapper]
		public virtual void redraw (Clutter.Stage stage);
		[Deprecated (since = "1.4")]
		public void set_double_click_distance (uint distance);
		[Deprecated (since = "1.4")]
		public void set_double_click_time (uint msec);
		[Deprecated (since = "1.4")]
		public void set_font_name (string font_name);
		public void set_font_options (Cairo.FontOptions options);
		public void set_resolution (double dpi);
		public signal void font_changed ();
		public signal void resolution_changed ();
		public signal void settings_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_behaviour_get_type ()")]
	public abstract class Behaviour : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		protected Behaviour ();
		public void actors_foreach (Clutter.BehaviourForeachFunc func);
		[NoWrapper]
		public virtual void alpha_notify (double alpha_value);
		public void apply (Clutter.Actor actor);
		public GLib.SList<weak Clutter.Actor> get_actors ();
		public unowned Clutter.Alpha get_alpha ();
		public int get_n_actors ();
		public unowned Clutter.Actor get_nth_actor (int index_);
		public bool is_applied (Clutter.Actor actor);
		public void remove (Clutter.Actor actor);
		public void remove_all ();
		public void set_alpha (Clutter.Alpha alpha);
		public Clutter.Alpha alpha { get; set; }
		public virtual signal void applied (Clutter.Actor actor);
		public virtual signal void removed (Clutter.Actor actor);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_behaviour_depth_get_type ()")]
	[Deprecated (since = "1.6")]
	public class BehaviourDepth : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourDepth (Clutter.Alpha? alpha, int depth_start, int depth_end);
		public void get_bounds (out int depth_start, out int depth_end);
		public void set_bounds (int depth_start, int depth_end);
		[NoAccessorMethod]
		public int depth_end { get; set; }
		[NoAccessorMethod]
		public int depth_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_behaviour_ellipse_get_type ()")]
	public class BehaviourEllipse : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourEllipse (Clutter.Alpha? alpha, int x, int y, int width, int height, Clutter.RotateDirection direction, double start, double end);
		public double get_angle_end ();
		public double get_angle_start ();
		public double get_angle_tilt (Clutter.RotateAxis axis);
		public void get_center (out int x, out int y);
		public Clutter.RotateDirection get_direction ();
		public int get_height ();
		public void get_tilt (out double angle_tilt_x, out double angle_tilt_y, out double angle_tilt_z);
		public int get_width ();
		public void set_angle_end (double angle_end);
		public void set_angle_start (double angle_start);
		public void set_angle_tilt (Clutter.RotateAxis axis, double angle_tilt);
		public void set_center (int x, int y);
		public void set_direction (Clutter.RotateDirection direction);
		public void set_height (int height);
		public void set_tilt (double angle_tilt_x, double angle_tilt_y, double angle_tilt_z);
		public void set_width (int width);
		public double angle_end { get; set; }
		public double angle_start { get; set; }
		[NoAccessorMethod]
		public double angle_tilt_x { get; set; }
		[NoAccessorMethod]
		public double angle_tilt_y { get; set; }
		[NoAccessorMethod]
		public double angle_tilt_z { get; set; }
		[NoAccessorMethod]
		public Clutter.Knot center { get; set; }
		public Clutter.RotateDirection direction { get; set; }
		public int height { get; set; }
		public int width { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_behaviour_opacity_get_type ()")]
	[Deprecated (since = "1.6")]
	public class BehaviourOpacity : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourOpacity (Clutter.Alpha? alpha, uint8 opacity_start, uint8 opacity_end);
		public void get_bounds (out uint8 opacity_start, out uint8 opacity_end);
		public void set_bounds (uint8 opacity_start, uint8 opacity_end);
		[NoAccessorMethod]
		public uint opacity_end { get; set; }
		[NoAccessorMethod]
		public uint opacity_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_behaviour_path_get_type ()")]
	[Deprecated (since = "1.6")]
	public class BehaviourPath : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourPath (Clutter.Alpha? alpha, Clutter.Path path);
		public unowned Clutter.Path get_path ();
		public void set_path (Clutter.Path path);
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourPath.with_description (Clutter.Alpha? alpha, string desc);
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourPath.with_knots (Clutter.Alpha? alpha, [CCode (array_length_cname = "n_knots", array_length_pos = 2.1, array_length_type = "guint")] Clutter.Knot[] knots);
		public Clutter.Path path { get; set; }
		public virtual signal void knot_reached (uint knot_num);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_behaviour_rotate_get_type ()")]
	[Deprecated (since = "1.6")]
	public class BehaviourRotate : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourRotate (Clutter.Alpha? alpha, Clutter.RotateAxis axis, Clutter.RotateDirection direction, double angle_start, double angle_end);
		public Clutter.RotateAxis get_axis ();
		public void get_bounds (out double angle_start, out double angle_end);
		public void get_center (out int x, out int y, out int z);
		public Clutter.RotateDirection get_direction ();
		public void set_axis (Clutter.RotateAxis axis);
		public void set_bounds (double angle_start, double angle_end);
		public void set_center (int x, int y, int z);
		public void set_direction (Clutter.RotateDirection direction);
		[NoAccessorMethod]
		public double angle_end { get; set; }
		[NoAccessorMethod]
		public double angle_start { get; set; }
		public Clutter.RotateAxis axis { get; set; }
		[NoAccessorMethod]
		public int center_x { get; set; }
		[NoAccessorMethod]
		public int center_y { get; set; }
		[NoAccessorMethod]
		public int center_z { get; set; }
		public Clutter.RotateDirection direction { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_behaviour_scale_get_type ()")]
	[Deprecated (since = "1.6")]
	public class BehaviourScale : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterBehaviour*")]
		public BehaviourScale (Clutter.Alpha? alpha, double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end);
		public void get_bounds (out double x_scale_start, out double y_scale_start, out double x_scale_end, out double y_scale_end);
		public void set_bounds (double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end);
		[NoAccessorMethod]
		public double x_scale_end { get; set; }
		[NoAccessorMethod]
		public double x_scale_start { get; set; }
		[NoAccessorMethod]
		public double y_scale_end { get; set; }
		[NoAccessorMethod]
		public double y_scale_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_bin_layout_get_type ()")]
	public class BinLayout : Clutter.LayoutManager {
		[CCode (has_construct_function = false, type = "ClutterLayoutManager*")]
		public BinLayout (Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		public void add (Clutter.Actor child, Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		public void get_alignment (Clutter.Actor? child, out Clutter.BinAlignment x_align, out Clutter.BinAlignment y_align);
		public void set_alignment (Clutter.Actor? child, Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		[NoAccessorMethod]
		public Clutter.BinAlignment x_align { get; set; }
		[NoAccessorMethod]
		public Clutter.BinAlignment y_align { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_bind_constraint_get_type ()")]
	public class BindConstraint : Clutter.Constraint {
		[CCode (has_construct_function = false, type = "ClutterConstraint*")]
		public BindConstraint (Clutter.Actor? source, Clutter.BindCoordinate coordinate, float offset);
		public Clutter.BindCoordinate get_coordinate ();
		public float get_offset ();
		public unowned Clutter.Actor get_source ();
		public void set_coordinate (Clutter.BindCoordinate coordinate);
		public void set_offset (float offset);
		public void set_source (Clutter.Actor? source);
		public Clutter.BindCoordinate coordinate { get; set construct; }
		public float offset { get; set construct; }
		public Clutter.Actor source { get; set construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_binding_pool_get_type ()")]
	public class BindingPool : GLib.Object {
		[CCode (has_construct_function = false)]
		public BindingPool (string name);
		public bool activate (uint key_val, Clutter.ModifierType modifiers, GLib.Object gobject);
		public void block_action (string action_name);
		public static unowned Clutter.BindingPool find (string name);
		public unowned string find_action (uint key_val, Clutter.ModifierType modifiers);
		public static unowned Clutter.BindingPool get_for_class (void* klass);
		public void install_action (string action_name, uint key_val, Clutter.ModifierType modifiers, [CCode (type = "GCallback")] owned Clutter.BindingActionFunc callback);
		public void install_closure (string action_name, uint key_val, Clutter.ModifierType modifiers, [CCode (type = "GClosure*")] owned Clutter.BindingActionFunc closure);
		public void override_action (uint key_val, Clutter.ModifierType modifiers, owned GLib.Callback callback);
		public void override_closure (uint key_val, Clutter.ModifierType modifiers, GLib.Closure closure);
		public void remove_action (uint key_val, Clutter.ModifierType modifiers);
		public void unblock_action (string action_name);
		[NoAccessorMethod]
		public string name { owned get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_blur_effect_get_type ()")]
	public class BlurEffect : Clutter.OffscreenEffect {
		[CCode (has_construct_function = false, type = "ClutterEffect*")]
		public BlurEffect ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_box_get_type ()")]
	public class Box : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Box (Clutter.LayoutManager manager);
		public Clutter.Color get_color ();
		public unowned Clutter.LayoutManager get_layout_manager ();
		public void pack (Clutter.Actor actor, ...);
		public void pack_after (Clutter.Actor actor, Clutter.Actor? sibling, ...);
		public void pack_at (Clutter.Actor actor, int position, ...);
		public void pack_before (Clutter.Actor actor, Clutter.Actor? sibling, ...);
		public void packv (Clutter.Actor actor, [CCode (array_length_cname = "n_properties", array_length_pos = 1.5, array_length_type = "guint")] string[] properties, [CCode (array_length_cname = "n_properties", array_length_pos = 1.5, array_length_type = "guint")] GLib.Value[] values);
		public void set_color (Clutter.Color? color);
		public void set_layout_manager (Clutter.LayoutManager manager);
		public Clutter.Color color { get; set; }
		[NoAccessorMethod]
		public bool color_set { get; set; }
		public Clutter.LayoutManager layout_manager { get; set construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_box_layout_get_type ()")]
	public class BoxLayout : Clutter.LayoutManager {
		[CCode (has_construct_function = false, type = "ClutterLayoutManager*")]
		public BoxLayout ();
		public void get_alignment (Clutter.Actor actor, out Clutter.BoxAlignment x_align, out Clutter.BoxAlignment y_align);
		public uint get_easing_duration ();
		public ulong get_easing_mode ();
		public bool get_expand (Clutter.Actor actor);
		public void get_fill (Clutter.Actor actor, out bool x_fill, out bool y_fill);
		public bool get_homogeneous ();
		public bool get_pack_start ();
		public uint get_spacing ();
		public bool get_use_animations ();
		public bool get_vertical ();
		public void pack (Clutter.Actor actor, bool expand, bool x_fill, bool y_fill, Clutter.BoxAlignment x_align, Clutter.BoxAlignment y_align);
		public void set_alignment (Clutter.Actor actor, Clutter.BoxAlignment x_align, Clutter.BoxAlignment y_align);
		public void set_easing_duration (uint msecs);
		public void set_easing_mode (ulong mode);
		public void set_expand (Clutter.Actor actor, bool expand);
		public void set_fill (Clutter.Actor actor, bool x_fill, bool y_fill);
		public void set_homogeneous (bool homogeneous);
		public void set_pack_start (bool pack_start);
		public void set_spacing (uint spacing);
		public void set_use_animations (bool animate);
		public void set_vertical (bool vertical);
		public uint easing_duration { get; set; }
		public ulong easing_mode { get; set; }
		public bool homogeneous { get; set; }
		public bool pack_start { get; set; }
		public uint spacing { get; set; }
		public bool use_animations { get; set; }
		public bool vertical { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_cairo_texture_get_type ()")]
	public class CairoTexture : Clutter.Texture, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public CairoTexture (uint width, uint height);
		public void clear ();
		[Deprecated (since = "1.8")]
		public Cairo.Context create ();
		[Deprecated (since = "1.8")]
		public Cairo.Context create_region (int x_offset, int y_offset, int width, int height);
		public bool get_auto_resize ();
		public void get_surface_size (out uint width, out uint height);
		public void invalidate ();
		public void invalidate_rectangle (Cairo.RectangleInt? rect);
		public void set_auto_resize (bool value);
		public void set_surface_size (uint width, uint height);
		public bool auto_resize { get; set; }
		[NoAccessorMethod]
		public uint surface_height { get; set; }
		[NoAccessorMethod]
		public uint surface_width { get; set; }
		public virtual signal Cairo.Surface create_surface (uint width, uint height);
		public virtual signal bool draw (Cairo.Context cr);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_child_meta_get_type ()")]
	public abstract class ChildMeta : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ChildMeta ();
		public unowned Clutter.Actor get_actor ();
		public unowned Clutter.Container get_container ();
		public Clutter.Actor actor { get; construct; }
		public Clutter.Container container { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_click_action_get_type ()")]
	public class ClickAction : Clutter.Action {
		[CCode (has_construct_function = false, type = "ClutterAction*")]
		public ClickAction ();
		public uint get_button ();
		public void get_coords (out float press_x, out float press_y);
		public Clutter.ModifierType get_state ();
		public void release ();
		[NoAccessorMethod]
		public bool held { get; }
		[NoAccessorMethod]
		public int long_press_duration { get; set; }
		[NoAccessorMethod]
		public int long_press_threshold { get; set; }
		[NoAccessorMethod]
		public bool pressed { get; }
		public virtual signal void clicked (Clutter.Actor actor);
		public virtual signal bool long_press (Clutter.Actor actor, Clutter.LongPressState state);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_clone_get_type ()")]
	public class Clone : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Clone (Clutter.Actor source);
		public unowned Clutter.Actor get_source ();
		public void set_source (Clutter.Actor source);
		public Clutter.Actor source { get; set construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_colorize_effect_get_type ()")]
	public class ColorizeEffect : Clutter.OffscreenEffect {
		[CCode (has_construct_function = false, type = "ClutterEffect*")]
		public ColorizeEffect (Clutter.Color tint);
		public Clutter.Color get_tint ();
		public void set_tint (Clutter.Color tint);
		public Clutter.Color tint { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_constraint_get_type ()")]
	public abstract class Constraint : Clutter.ActorMeta {
		[CCode (has_construct_function = false)]
		protected Constraint ();
		[NoWrapper]
		public virtual void update_allocation (Clutter.Actor actor, Clutter.ActorBox allocation);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_deform_effect_get_type ()")]
	public abstract class DeformEffect : Clutter.OffscreenEffect {
		[CCode (has_construct_function = false)]
		protected DeformEffect ();
		[NoWrapper]
		public virtual void deform_vertex (float width, float height, Cogl.TextureVertex vertex);
		public unowned Cogl.Handle get_back_material ();
		public void get_n_tiles (out uint x_tiles, out uint y_tiles);
		public void invalidate ();
		public void set_back_material (Cogl.Handle? material);
		public void set_n_tiles (uint x_tiles, uint y_tiles);
		[NoAccessorMethod]
		public uint x_tiles { get; set; }
		[NoAccessorMethod]
		public uint y_tiles { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_desaturate_effect_get_type ()")]
	public class DesaturateEffect : Clutter.OffscreenEffect {
		[CCode (has_construct_function = false, type = "ClutterEffect*")]
		public DesaturateEffect (double factor);
		public double get_factor ();
		public void set_factor (double factor);
		public double factor { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_device_manager_get_type ()")]
	public abstract class DeviceManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		[NoWrapper]
		public virtual void add_device (Clutter.InputDevice device);
		public virtual unowned Clutter.InputDevice get_core_device (Clutter.InputDeviceType device_type);
		public static unowned Clutter.DeviceManager get_default ();
		public virtual unowned Clutter.InputDevice get_device (int device_id);
		[NoWrapper]
		public virtual unowned GLib.SList<Clutter.InputDevice> get_devices ();
		public GLib.SList<weak Clutter.InputDevice> list_devices ();
		public unowned GLib.SList<Clutter.InputDevice> peek_devices ();
		[NoWrapper]
		public virtual void remove_device (Clutter.InputDevice device);
		[NoAccessorMethod]
		public Clutter.Backend backend { owned get; construct; }
		public signal void device_added (Clutter.InputDevice device);
		public signal void device_removed (Clutter.InputDevice device);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_drag_action_get_type ()")]
	public class DragAction : Clutter.Action {
		[CCode (has_construct_function = false, type = "ClutterAction*")]
		public DragAction ();
		public Clutter.DragAxis get_drag_axis ();
		public unowned Clutter.Actor get_drag_handle ();
		public void get_drag_threshold (out uint x_threshold, out uint y_threshold);
		public void get_motion_coords (out float motion_x, out float motion_y);
		public void get_press_coords (out float press_x, out float press_y);
		public void set_drag_axis (Clutter.DragAxis axis);
		public void set_drag_handle (Clutter.Actor? handle);
		public void set_drag_threshold (int x_threshold, int y_threshold);
		public Clutter.DragAxis drag_axis { get; set; }
		public Clutter.Actor drag_handle { get; set; }
		[NoAccessorMethod]
		public int x_drag_threshold { get; set; }
		[NoAccessorMethod]
		public int y_drag_threshold { get; set; }
		public virtual signal void drag_begin (Clutter.Actor actor, float event_x, float event_y, Clutter.ModifierType modifiers);
		public virtual signal void drag_end (Clutter.Actor actor, float event_x, float event_y, Clutter.ModifierType modifiers);
		public virtual signal void drag_motion (Clutter.Actor actor, float delta_x, float delta_y);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_drop_action_get_type ()")]
	public class DropAction : Clutter.Action {
		[CCode (has_construct_function = false, type = "ClutterAction*")]
		public DropAction ();
		public virtual signal bool can_drop (Clutter.Actor actor, float event_x, float event_y);
		public virtual signal void drop (Clutter.Actor actor, float event_x, float event_y);
		public virtual signal void over_in (Clutter.Actor actor);
		public virtual signal void over_out (Clutter.Actor actor);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_effect_get_type ()")]
	public abstract class Effect : Clutter.ActorMeta {
		[CCode (has_construct_function = false)]
		protected Effect ();
		[NoWrapper]
		public virtual bool get_paint_volume (Clutter.PaintVolume volume);
		[NoWrapper]
		public virtual void paint (Clutter.EffectPaintFlags flags);
		[NoWrapper]
		public virtual void pick (Clutter.EffectPaintFlags flags);
		[NoWrapper]
		public virtual void post_paint ();
		[NoWrapper]
		public virtual bool pre_paint ();
		public void queue_repaint ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "clutter_event_get_type ()")]
	[Compact]
	public class Event {
		public Clutter.AnyEvent any;
		public Clutter.ButtonEvent button;
		public Clutter.CrossingEvent crossing;
		public Clutter.KeyEvent key;
		public Clutter.MotionEvent motion;
		public Clutter.ScrollEvent scroll;
		public Clutter.StageStateEvent stage_state;
		public Clutter.EventType type;
		[CCode (has_construct_function = false)]
		public Event (Clutter.EventType type);
		public Clutter.Event copy ();
		public void free ();
		public static Clutter.Event @get ();
		public double get_axes (out uint n_axes);
		public uint32 get_button ();
		public uint get_click_count ();
		public void get_coords (out float x, out float y);
		public unowned Clutter.InputDevice get_device ();
		public int get_device_id ();
		public Clutter.InputDeviceType get_device_type ();
		public Clutter.EventFlags get_flags ();
		public uint16 get_key_code ();
		public uint get_key_symbol ();
		public uint32 get_key_unicode ();
		public unowned Clutter.Actor get_related ();
		public Clutter.ScrollDirection get_scroll_direction ();
		public unowned Clutter.Actor get_source ();
		public unowned Clutter.InputDevice get_source_device ();
		public unowned Clutter.Stage get_stage ();
		public Clutter.ModifierType get_state ();
		public uint32 get_time ();
		[CCode (cname = "clutter_event_type")]
		public Clutter.EventType get_type ();
		public static unowned Clutter.Event peek ();
		public void put ();
		public void set_button (uint32 button);
		public void set_coords (float x, float y);
		public void set_device (Clutter.InputDevice? device);
		public void set_flags (Clutter.EventFlags flags);
		public void set_key_code (uint16 key_code);
		public void set_key_symbol (uint key_sym);
		public void set_key_unicode (uint32 key_unicode);
		public void set_related (Clutter.Actor? actor);
		public void set_scroll_direction (Clutter.ScrollDirection direction);
		public void set_source (Clutter.Actor? actor);
		public void set_source_device (Clutter.InputDevice? device);
		public void set_stage (Clutter.Stage? stage);
		public void set_state (Clutter.ModifierType state);
		public void set_time (uint32 time_);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_fixed_layout_get_type ()")]
	public class FixedLayout : Clutter.LayoutManager {
		[CCode (has_construct_function = false, type = "ClutterLayoutManager*")]
		public FixedLayout ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_flow_layout_get_type ()")]
	public class FlowLayout : Clutter.LayoutManager {
		[CCode (has_construct_function = false, type = "ClutterLayoutManager*")]
		public FlowLayout (Clutter.FlowOrientation orientation);
		public float get_column_spacing ();
		public void get_column_width (out float min_width, out float max_width);
		public bool get_homogeneous ();
		public Clutter.FlowOrientation get_orientation ();
		public void get_row_height (out float min_height, out float max_height);
		public float get_row_spacing ();
		public void set_column_spacing (float spacing);
		public void set_column_width (float min_width, float max_width);
		public void set_homogeneous (bool homogeneous);
		public void set_orientation (Clutter.FlowOrientation orientation);
		public void set_row_height (float min_height, float max_height);
		public void set_row_spacing (float spacing);
		public float column_spacing { get; set; }
		public bool homogeneous { get; set; }
		[NoAccessorMethod]
		public float max_column_width { get; set; }
		[NoAccessorMethod]
		public float max_row_height { get; set; }
		[NoAccessorMethod]
		public float min_column_width { get; set; }
		[NoAccessorMethod]
		public float min_row_height { get; set; }
		public Clutter.FlowOrientation orientation { get; set construct; }
		public float row_spacing { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_gesture_action_get_type ()")]
	public class GestureAction : Clutter.Action {
		[CCode (has_construct_function = false, type = "ClutterAction*")]
		public GestureAction ();
		public void get_motion_coords (uint device, out float motion_x, out float motion_y);
		public void get_press_coords (uint device, out float press_x, out float press_y);
		public void get_release_coords (uint device, out float release_x, out float release_y);
		public virtual signal bool gesture_begin (Clutter.Actor actor);
		public virtual signal void gesture_cancel (Clutter.Actor actor);
		public virtual signal void gesture_end (Clutter.Actor actor);
		public virtual signal bool gesture_progress (Clutter.Actor actor);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_group_get_type ()")]
	public class Group : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Group ();
		public int get_n_children ();
		public unowned Clutter.Actor get_nth_child (int index_);
		public void remove_all ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_input_device_get_type ()")]
	public class InputDevice : GLib.Object {
		[CCode (has_construct_function = false)]
		protected InputDevice ();
		public unowned Clutter.InputDevice get_associated_device ();
		public Clutter.InputAxis get_axis (uint index_);
		public bool get_axis_value ([CCode (array_length = false, array_null_terminated = true)] double[] axes, Clutter.InputAxis axis, out double value);
		public void get_device_coords (out int x, out int y);
		public int get_device_id ();
		public Clutter.InputMode get_device_mode ();
		public unowned string get_device_name ();
		public Clutter.InputDeviceType get_device_type ();
		public bool get_enabled ();
		[CCode (cname = "clutter_get_input_device_for_id")]
		public static unowned Clutter.InputDevice get_for_id (int id_);
		public bool get_has_cursor ();
		public bool get_key (uint index_, out uint keyval, out Clutter.ModifierType modifiers);
		public uint get_n_axes ();
		public uint get_n_keys ();
		public unowned Clutter.Actor get_pointer_actor ();
		public unowned Clutter.Stage get_pointer_stage ();
		public GLib.List<weak Clutter.InputDevice> get_slave_devices ();
		public void set_enabled (bool enabled);
		public void set_key (uint index_, uint keyval, Clutter.ModifierType modifiers);
		public void update_from_event (Clutter.Event event, bool update_stage);
		[NoAccessorMethod]
		public Clutter.Backend backend { owned get; construct; }
		[NoAccessorMethod]
		public Clutter.DeviceManager device_manager { owned get; construct; }
		public Clutter.InputMode device_mode { get; construct; }
		public Clutter.InputDeviceType device_type { get; construct; }
		public bool enabled { get; set; }
		public bool has_cursor { get; construct; }
		[NoAccessorMethod]
		public int id { get; construct; }
		public uint n_axes { get; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_interval_get_type ()")]
	public class Interval : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public Interval (GLib.Type gtype, ...);
		public Clutter.Interval clone ();
		public GLib.Value compute (double factor);
		public virtual bool compute_value (double factor, out GLib.Value value);
		public GLib.Value get_final_value ();
		public GLib.Value get_initial_value ();
		public void get_interval (...);
		public GLib.Type get_value_type ();
		public GLib.Value peek_final_value ();
		public GLib.Value peek_initial_value ();
		public static void register_progress_func (GLib.Type value_type, Clutter.ProgressFunc func);
		public void set_final_value (GLib.Value value);
		public void set_initial_value (GLib.Value value);
		public void set_interval (...);
		public virtual bool validate (GLib.ParamSpec pspec);
		[CCode (has_construct_function = false)]
		public Interval.with_values (GLib.Type gtype, GLib.Value initial, GLib.Value final);
		public GLib.Type value_type { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_layout_manager_get_type ()")]
	public abstract class LayoutManager : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		protected LayoutManager ();
		public virtual void allocate (Clutter.Container container, Clutter.ActorBox allocation, Clutter.AllocationFlags flags);
		public virtual unowned Clutter.Alpha begin_animation (uint duration, ulong mode);
		public void child_get (Clutter.Container container, Clutter.Actor actor, ...);
		public void child_get_property (Clutter.Container container, Clutter.Actor actor, string property_name, GLib.Value value);
		public void child_set (Clutter.Container container, Clutter.Actor actor, ...);
		public void child_set_property (Clutter.Container container, Clutter.Actor actor, string property_name, GLib.Value value);
		[NoWrapper]
		public virtual unowned Clutter.LayoutMeta create_child_meta (Clutter.Container container, Clutter.Actor actor);
		public virtual void end_animation ();
		public unowned GLib.ParamSpec find_child_property (string name);
		public virtual double get_animation_progress ();
		public unowned Clutter.LayoutMeta get_child_meta (Clutter.Container container, Clutter.Actor actor);
		[NoWrapper]
		public virtual GLib.Type get_child_meta_type ();
		public virtual void get_preferred_height (Clutter.Container container, float for_width, out float min_height_p, out float nat_height_p);
		public virtual void get_preferred_width (Clutter.Container container, float for_height, out float min_width_p, out float nat_width_p);
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public GLib.ParamSpec[] list_child_properties ();
		public virtual void set_container (Clutter.Container? container);
		[HasEmitter]
		public virtual signal void layout_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_layout_meta_get_type ()")]
	public abstract class LayoutMeta : Clutter.ChildMeta {
		[CCode (has_construct_function = false)]
		protected LayoutMeta ();
		public unowned Clutter.LayoutManager get_manager ();
		public Clutter.LayoutManager manager { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_list_model_get_type ()")]
	public class ListModel : Clutter.Model, Clutter.Scriptable, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterModel*")]
		public ListModel (uint n_columns, ...);
		[CCode (cname = "clutter_list_model_newv", has_construct_function = false, type = "ClutterModel*")]
		public ListModel.newv ([CCode (array_length_pos = 0.9)] GLib.Type[] types, [CCode (array_length_pos = 0.9)] string[] names);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_model_get_type ()")]
	public abstract class Model : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		protected Model ();
		public void append (...);
		public void appendv ([CCode (array_length_cname = "n_columns", array_length_pos = 0.5, array_length_type = "guint")] uint[] columns, [CCode (array_length_cname = "n_columns", array_length_pos = 0.5, array_length_type = "guint")] GLib.Value[] values);
		public bool filter_iter (Clutter.ModelIter iter);
		public bool filter_row (uint row);
		public void @foreach (Clutter.ModelForeachFunc func);
		public virtual unowned string get_column_name (uint column);
		public virtual GLib.Type get_column_type (uint column);
		public bool get_filter_set ();
		public Clutter.ModelIter get_first_iter ();
		public virtual Clutter.ModelIter get_iter_at_row (uint row);
		public Clutter.ModelIter get_last_iter ();
		public virtual uint get_n_columns ();
		public virtual uint get_n_rows ();
		public int get_sorting_column ();
		public void insert (uint row, ...);
		[NoWrapper]
		public virtual unowned Clutter.ModelIter insert_row (int index_);
		public void insert_value (uint row, uint column, GLib.Value value);
		public void insertv (uint row, [CCode (array_length_cname = "n_columns", array_length_pos = 1.5, array_length_type = "guint")] uint[] columns, [CCode (array_length_cname = "n_columns", array_length_pos = 1.5, array_length_type = "guint")] GLib.Value[] values);
		public void prepend (...);
		public void prependv ([CCode (array_length_cname = "n_columns", array_length_pos = 0.5, array_length_type = "guint")] uint[] columns, [CCode (array_length_cname = "n_columns", array_length_pos = 0.5, array_length_type = "guint")] GLib.Value[] values);
		public void remove (uint row);
		[NoWrapper]
		public virtual void remove_row (uint row);
		public void resort ();
		public void set_filter (owned Clutter.ModelFilterFunc? func);
		public void set_names ([CCode (array_length_cname = "n_columns", array_length_pos = 0.5, array_length_type = "guint")] string[] names);
		public void set_sort (int column, owned Clutter.ModelSortFunc? func);
		public void set_sorting_column (int column);
		public void set_types ([CCode (array_length_cname = "n_columns", array_length_pos = 0.5, array_length_type = "guint")] GLib.Type[] types);
		public bool filter_set { get; }
		public virtual signal void filter_changed ();
		public virtual signal void row_added (Clutter.ModelIter iter);
		public virtual signal void row_changed (Clutter.ModelIter iter);
		public virtual signal void row_removed (Clutter.ModelIter iter);
		public virtual signal void sort_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_model_iter_get_type ()")]
	public abstract class ModelIter : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ModelIter ();
		public virtual Clutter.ModelIter copy ();
		public void @get (...);
		public virtual unowned Clutter.Model get_model ();
		public virtual uint get_row ();
		public virtual GLib.Value get_value (uint column);
		public virtual bool is_first ();
		public virtual bool is_last ();
		public virtual unowned Clutter.ModelIter next ();
		public virtual unowned Clutter.ModelIter prev ();
		public void @set (...);
		public virtual void set_value (uint column, GLib.Value value);
		[NoAccessorMethod]
		public Clutter.Model model { owned get; set; }
		[NoAccessorMethod]
		public uint row { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_offscreen_effect_get_type ()")]
	public abstract class OffscreenEffect : Clutter.Effect {
		[CCode (has_construct_function = false)]
		protected OffscreenEffect ();
		public virtual Cogl.Handle create_texture (float width, float height);
		public unowned Cogl.Material get_target ();
		public bool get_target_size (out float width, out float height);
		public virtual void paint_target ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_page_turn_effect_get_type ()")]
	public class PageTurnEffect : Clutter.DeformEffect {
		[CCode (has_construct_function = false, type = "ClutterEffect*")]
		public PageTurnEffect (double period, double angle, float radius);
		public double get_angle ();
		public double get_period ();
		public float get_radius ();
		public void set_angle (double angle);
		public void set_period (double period);
		public void set_radius (float radius);
		public double angle { get; set; }
		public double period { get; set; }
		public float radius { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "clutter_paint_volume_get_type ()")]
	[Compact]
	public class PaintVolume {
		public Clutter.PaintVolume copy ();
		public void free ();
		public float get_depth ();
		public float get_height ();
		public Clutter.Vertex get_origin ();
		public float get_width ();
		public void set_depth (float depth);
		public bool set_from_allocation (Clutter.Actor actor);
		public void set_height (float height);
		public void set_origin (Clutter.Vertex origin);
		public void set_width (float width);
		public void union (Clutter.PaintVolume another_pv);
	}
	[CCode (cheader_filename = "clutter/clutter.h", lower_case_csuffix = "param_units", type_id = "clutter_param_units_get_type ()")]
	public class ParamSpecUnit {
		[CCode (has_construct_function = false)]
		protected ParamSpecUnit ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_path_get_type ()")]
	public class Path : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public Path ();
		public void add_cairo_path (Cairo.Path cpath);
		public void add_close ();
		public void add_curve_to (int x_1, int y_1, int x_2, int y_2, int x_3, int y_3);
		public void add_line_to (int x, int y);
		public void add_move_to (int x, int y);
		public void add_node (Clutter.PathNode node);
		public void add_rel_curve_to (int x_1, int y_1, int x_2, int y_2, int x_3, int y_3);
		public void add_rel_line_to (int x, int y);
		public void add_rel_move_to (int x, int y);
		public bool add_string (string str);
		public void clear ();
		public void @foreach (Clutter.PathCallback callback);
		public string get_description ();
		public uint get_length ();
		public uint get_n_nodes ();
		public void get_node (uint index_, Clutter.PathNode node);
		public GLib.SList<weak Clutter.PathNode> get_nodes ();
		public uint get_position (double progress, Clutter.Knot position);
		public void insert_node (int index_, Clutter.PathNode node);
		public void remove_node (uint index_);
		public void replace_node (uint index_, Clutter.PathNode node);
		public bool set_description (string str);
		public void to_cairo_path (Cairo.Context cr);
		[CCode (has_construct_function = false)]
		public Path.with_description (string desc);
		[NoAccessorMethod]
		public string description { owned get; set; }
		public uint length { get; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_path_constraint_get_type ()")]
	public class PathConstraint : Clutter.Constraint {
		[CCode (has_construct_function = false, type = "ClutterConstraint*")]
		public PathConstraint (Clutter.Path? path, float offset);
		public float get_offset ();
		public unowned Clutter.Path get_path ();
		public void set_offset (float offset);
		public void set_path (Clutter.Path? path);
		public float offset { get; set; }
		public Clutter.Path path { get; set; }
		public signal void node_reached (Clutter.Actor actor, uint index);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_rectangle_get_type ()")]
	public class Rectangle : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Rectangle ();
		public Clutter.Color get_border_color ();
		public uint get_border_width ();
		public Clutter.Color get_color ();
		public void set_border_color (Clutter.Color color);
		public void set_border_width (uint width);
		public void set_color (Clutter.Color color);
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Rectangle.with_color (Clutter.Color color);
		public Clutter.Color border_color { get; set; }
		public uint border_width { get; set; }
		public Clutter.Color color { get; set; }
		[NoAccessorMethod]
		public bool has_border { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_score_get_type ()")]
	public class Score : GLib.Object {
		[CCode (has_construct_function = false)]
		public Score ();
		public ulong append (Clutter.Timeline? parent, Clutter.Timeline timeline);
		public ulong append_at_marker (Clutter.Timeline parent, string marker_name, Clutter.Timeline timeline);
		public bool get_loop ();
		public unowned Clutter.Timeline get_timeline (ulong id_);
		public bool is_playing ();
		public GLib.SList<weak Clutter.Timeline> list_timelines ();
		public void pause ();
		public void remove (ulong id_);
		public void remove_all ();
		public void rewind ();
		public void set_loop (bool loop);
		public void start ();
		public void stop ();
		public bool loop { get; set; }
		public virtual signal void completed ();
		public virtual signal void paused ();
		public virtual signal void started ();
		public virtual signal void timeline_completed (Clutter.Timeline timeline);
		public virtual signal void timeline_started (Clutter.Timeline timeline);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_script_get_type ()")]
	public class Script : GLib.Object {
		[CCode (has_construct_function = false)]
		public Script ();
		public void add_search_paths ([CCode (array_length_cname = "n_paths", array_length_pos = 1.1, array_length_type = "gsize")] string[] paths);
		public void add_states (string? name, Clutter.State state);
		public void connect_signals (void* user_data);
		public void connect_signals_full (Clutter.ScriptConnectFunc func);
		public void ensure_objects ();
		public unowned GLib.Object get_object (string name);
		public int get_objects (...);
		public unowned Clutter.State get_states (string? name);
		public virtual GLib.Type get_type_from_name (string type_name);
		public GLib.List<weak GLib.Object> list_objects ();
		public uint load_from_data (string data, ssize_t length) throws GLib.Error;
		public uint load_from_file (string filename) throws GLib.Error;
		public string lookup_filename (string filename);
		public void unmerge_objects (uint merge_id);
		[NoAccessorMethod]
		public string filename { owned get; }
		[NoAccessorMethod]
		public bool filename_set { get; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_settings_get_type ()")]
	public class Settings : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Settings ();
		public static unowned Clutter.Settings get_default ();
		public Clutter.Backend backend { construct; }
		[NoAccessorMethod]
		public int dnd_drag_threshold { get; set; }
		[NoAccessorMethod]
		public int double_click_distance { get; set; }
		[NoAccessorMethod]
		public int double_click_time { get; set; }
		[NoAccessorMethod]
		public int font_antialias { get; set; }
		[NoAccessorMethod]
		public int font_dpi { get; set; }
		[NoAccessorMethod]
		public string font_hint_style { owned get; set; }
		[NoAccessorMethod]
		public int font_hinting { get; set; }
		[NoAccessorMethod]
		public string font_name { owned get; set; }
		[NoAccessorMethod]
		public string font_subpixel_order { owned get; set; }
		[NoAccessorMethod]
		public int long_press_duration { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_shader_get_type ()")]
	[Deprecated (since = "1.8")]
	public class Shader : GLib.Object {
		[CCode (has_construct_function = false)]
		[Deprecated (since = "1.8")]
		public Shader ();
		[Deprecated (since = "1.8")]
		public bool compile () throws GLib.Error;
		[Deprecated (since = "1.8")]
		public unowned Cogl.Handle get_cogl_fragment_shader ();
		[Deprecated (since = "1.8")]
		public unowned Cogl.Handle get_cogl_program ();
		[Deprecated (since = "1.8")]
		public unowned Cogl.Handle get_cogl_vertex_shader ();
		[Deprecated (since = "1.8")]
		public unowned string get_fragment_source ();
		[Deprecated (since = "1.8")]
		public bool get_is_enabled ();
		[Deprecated (since = "1.8")]
		public unowned string get_vertex_source ();
		[Deprecated (since = "1.8")]
		public bool is_compiled ();
		[Deprecated (since = "1.8")]
		public void release ();
		[Deprecated (since = "1.8")]
		public void set_fragment_source (string data, ssize_t length);
		[Deprecated (since = "1.8")]
		public void set_is_enabled (bool enabled);
		[Deprecated (since = "1.8")]
		public void set_uniform (string name, GLib.Value value);
		[Deprecated (since = "1.8")]
		public void set_vertex_source (string data, ssize_t length);
		[Deprecated (since = "1.8")]
		[NoAccessorMethod]
		public bool compiled { get; }
		[Deprecated (since = "1.8")]
		[NoAccessorMethod]
		public bool enabled { get; set; }
		[Deprecated (since = "1.8")]
		[NoAccessorMethod]
		public string fragment_source { owned get; set; }
		[Deprecated (since = "1.8")]
		[NoAccessorMethod]
		public string vertex_source { owned get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_shader_effect_get_type ()")]
	public class ShaderEffect : Clutter.OffscreenEffect {
		[CCode (has_construct_function = false, type = "ClutterEffect*")]
		public ShaderEffect (Clutter.ShaderType shader_type);
		public unowned Cogl.Handle get_program ();
		public unowned Cogl.Handle get_shader ();
		public bool set_shader_source (string source);
		public void set_uniform_value (string name, GLib.Value value);
		public Clutter.ShaderType shader_type { construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Compact]
	public class ShaderFloat {
		public static GLib.Type get_type ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Compact]
	public class ShaderInt {
		public static GLib.Type get_type ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Compact]
	public class ShaderMatrix {
		public static GLib.Type get_type ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_snap_constraint_get_type ()")]
	public class SnapConstraint : Clutter.Constraint {
		[CCode (has_construct_function = false, type = "ClutterConstraint*")]
		public SnapConstraint (Clutter.Actor? source, Clutter.SnapEdge from_edge, Clutter.SnapEdge to_edge, float offset);
		public void get_edges (out Clutter.SnapEdge from_edge, out Clutter.SnapEdge to_edge);
		public float get_offset ();
		public unowned Clutter.Actor get_source ();
		public void set_edges (Clutter.SnapEdge from_edge, Clutter.SnapEdge to_edge);
		public void set_offset (float offset);
		public void set_source (Clutter.Actor? source);
		[NoAccessorMethod]
		public Clutter.SnapEdge from_edge { get; set construct; }
		public float offset { get; set construct; }
		public Clutter.Actor source { get; set construct; }
		[NoAccessorMethod]
		public Clutter.SnapEdge to_edge { get; set construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_stage_get_type ()")]
	public class Stage : Clutter.Group, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Stage ();
		[CCode (cname = "clutter_stage_event")]
		public bool emit_event (Clutter.Event event);
		public void ensure_current ();
		public void ensure_redraw ();
		public void ensure_viewport ();
		public bool get_accept_focus ();
		public unowned Clutter.Actor get_actor_at_pos (Clutter.PickMode pick_mode, int x, int y);
		public Clutter.Color get_color ();
		public static unowned Clutter.Stage get_default ();
		public Clutter.Fog get_fog ();
		public bool get_fullscreen ();
		public unowned Clutter.Actor get_key_focus ();
		public void get_minimum_size (out uint width, out uint height);
		public bool get_motion_events_enabled ();
		public bool get_no_clear_hint ();
		public Clutter.Perspective get_perspective ();
		public Cairo.RectangleInt get_redraw_clip_bounds ();
		public bool get_throttle_motion_events ();
		public unowned string get_title ();
		public bool get_use_alpha ();
		public bool get_use_fog ();
		public bool get_user_resizable ();
		public void hide_cursor ();
		public bool is_default ();
		public void queue_redraw ();
		[CCode (array_length = false, array_null_terminated = true)]
		public uint8[] read_pixels (int x, int y, int width = -1, int height = -1);
		[CCode (cname = "clutter_redraw")]
		public void redraw ();
		public void set_accept_focus (bool accept_focus);
		public void set_color (Clutter.Color color);
		public void set_fog (Clutter.Fog fog);
		public void set_fullscreen (bool fullscreen);
		public void set_key_focus (Clutter.Actor? actor);
		public void set_minimum_size (uint width, uint height);
		public void set_motion_events_enabled (bool enabled);
		public void set_no_clear_hint (bool no_clear);
		public void set_perspective (Clutter.Perspective perspective);
		public void set_throttle_motion_events (bool throttle);
		public void set_title (string title);
		public void set_use_alpha (bool use_alpha);
		public void set_use_fog (bool fog);
		public void set_user_resizable (bool resizable);
		public void show_cursor ();
		public bool accept_focus { get; set; }
		public Clutter.Color color { get; set; }
		[NoAccessorMethod]
		public bool cursor_visible { get; set; }
		public Clutter.Fog fog { get; set; }
		[NoAccessorMethod]
		public bool fullscreen_set { get; }
		public Clutter.Actor key_focus { get; set; }
		public bool no_clear_hint { get; set; }
		[NoAccessorMethod]
		public bool offscreen { get; set; }
		public Clutter.Perspective perspective { get; set; }
		public string title { get; set; }
		public bool use_alpha { get; set; }
		public bool use_fog { get; set; }
		public bool user_resizable { get; set; }
		public virtual signal void activate ();
		public virtual signal void deactivate ();
		public virtual signal bool delete_event (Clutter.Event event);
		public virtual signal void fullscreen ();
		public virtual signal void unfullscreen ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_stage_manager_get_type ()")]
	public class StageManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StageManager ();
		public static unowned Clutter.StageManager get_default ();
		public unowned Clutter.Stage get_default_stage ();
		public GLib.SList<weak Clutter.Stage> list_stages ();
		public unowned GLib.SList<Clutter.Stage> peek_stages ();
		[Deprecated (since = "1.2")]
		public void set_default_stage (Clutter.Stage stage);
		public Clutter.Stage default_stage { get; }
		public virtual signal void stage_added (Clutter.Stage stage);
		public virtual signal void stage_removed (Clutter.Stage stage);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_state_get_type ()")]
	public class State : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		public State ();
		public unowned Clutter.Animator get_animator (string source_state_name, string target_state_name);
		public uint get_duration (string? source_state_name, string? target_state_name);
		public GLib.List<weak Clutter.StateKey> get_keys (string? source_state_name, string? target_state_name, GLib.Object? object, string? property_name);
		public unowned string get_state ();
		public GLib.List<weak string> get_states ();
		public unowned Clutter.Timeline get_timeline ();
		public void remove_key (string? source_state_name, string? target_state_name, GLib.Object? object, string? property_name);
		public void set_animator (string source_state_name, string target_state_name, Clutter.Animator? animator);
		public void set_duration (string? source_state_name, string? target_state_name, uint duration);
		public unowned Clutter.State set_key (string? source_state_name, string target_state_name, GLib.Object object, string property_name, uint mode, GLib.Value value, double pre_delay, double post_delay);
		public unowned Clutter.Timeline set_state (string target_state_name);
		public unowned Clutter.Timeline warp_to_state (string target_state_name);
		[NoAccessorMethod]
		public uint duration { get; set; }
		[NoAccessorMethod]
		public string state { owned get; set; }
		public virtual signal void completed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "clutter_state_key_get_type ()")]
	[Compact]
	public class StateKey {
		public ulong get_mode ();
		public unowned GLib.Object get_object ();
		public double get_post_delay ();
		public double get_pre_delay ();
		public unowned string get_property_name ();
		public GLib.Type get_property_type ();
		public unowned string get_source_state_name ();
		public unowned string get_target_state_name ();
		public bool get_value (GLib.Value value);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_swipe_action_get_type ()")]
	public class SwipeAction : Clutter.GestureAction {
		[CCode (has_construct_function = false, type = "ClutterAction*")]
		public SwipeAction ();
		public virtual signal void swept (Clutter.Actor actor, Clutter.SwipeDirection direction);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_table_layout_get_type ()")]
	public class TableLayout : Clutter.LayoutManager {
		[CCode (has_construct_function = false, type = "ClutterLayoutManager*")]
		public TableLayout ();
		public void get_alignment (Clutter.Actor actor, out Clutter.TableAlignment x_align, out Clutter.TableAlignment y_align);
		public int get_column_count ();
		public uint get_column_spacing ();
		public uint get_easing_duration ();
		public ulong get_easing_mode ();
		public void get_expand (Clutter.Actor actor, out bool x_expand, out bool y_expand);
		public void get_fill (Clutter.Actor actor, out bool x_fill, out bool y_fill);
		public int get_row_count ();
		public uint get_row_spacing ();
		public void get_span (Clutter.Actor actor, out int column_span, out int row_span);
		public bool get_use_animations ();
		public void pack (Clutter.Actor actor, int column, int row);
		public void set_alignment (Clutter.Actor actor, Clutter.TableAlignment x_align, Clutter.TableAlignment y_align);
		public void set_column_spacing (uint spacing);
		public void set_easing_duration (uint msecs);
		public void set_easing_mode (ulong mode);
		public void set_expand (Clutter.Actor actor, bool x_expand, bool y_expand);
		public void set_fill (Clutter.Actor actor, bool x_fill, bool y_fill);
		public void set_row_spacing (uint spacing);
		public void set_span (Clutter.Actor actor, int column_span, int row_span);
		public void set_use_animations (bool animate);
		public uint column_spacing { get; set; }
		public uint easing_duration { get; set; }
		public ulong easing_mode { get; set; }
		public uint row_spacing { get; set; }
		public bool use_animations { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_text_get_type ()")]
	public class Text : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Text ();
		public void delete_chars (uint n_chars);
		public bool delete_selection ();
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Text.full (string font_name, string text, Clutter.Color color);
		public bool get_activatable ();
		public unowned Pango.AttrList get_attributes ();
		public string get_chars (ssize_t start_pos, ssize_t end_pos);
		public Clutter.Color get_color ();
		public Clutter.Color get_cursor_color ();
		public int get_cursor_position ();
		public uint get_cursor_size ();
		public bool get_cursor_visible ();
		public bool get_editable ();
		public Pango.EllipsizeMode get_ellipsize ();
		public Pango.FontDescription get_font_description ();
		public unowned string get_font_name ();
		public bool get_justify ();
		public unowned Pango.Layout get_layout ();
		public void get_layout_offsets (out int x, out int y);
		public Pango.Alignment get_line_alignment ();
		public bool get_line_wrap ();
		public Pango.WrapMode get_line_wrap_mode ();
		public int get_max_length ();
		public unichar get_password_char ();
		public bool get_selectable ();
		public Clutter.Color get_selected_text_color ();
		public string get_selection ();
		public int get_selection_bound ();
		public Clutter.Color get_selection_color ();
		public bool get_single_line_mode ();
		public unowned string get_text ();
		public bool get_use_markup ();
		public void insert_text (string text, ssize_t position);
		public void insert_unichar (unichar wc);
		public bool position_to_coords (int position, out float x, out float y, out float line_height = null);
		public void set_activatable (bool activatable);
		public void set_attributes (Pango.AttrList attrs);
		public void set_color (Clutter.Color color);
		public void set_cursor_color (Clutter.Color color);
		public void set_cursor_position (int position);
		public void set_cursor_size (int size);
		public void set_cursor_visible (bool cursor_visible);
		public void set_editable (bool editable);
		public void set_ellipsize (Pango.EllipsizeMode mode);
		public void set_font_description (Pango.FontDescription font_desc);
		public void set_font_name (string? font_name);
		public void set_justify (bool justify);
		public void set_line_alignment (Pango.Alignment alignment);
		public void set_line_wrap (bool line_wrap);
		public void set_line_wrap_mode (Pango.WrapMode wrap_mode);
		public void set_markup (string markup);
		public void set_max_length (int max);
		public void set_password_char (unichar wc);
		public void set_preedit_string (string? preedit_str, Pango.AttrList? preedit_attrs, uint cursor_pos);
		public void set_selectable (bool selectable);
		public void set_selected_text_color (Clutter.Color color);
		public void set_selection (ssize_t start_pos, ssize_t end_pos);
		public void set_selection_bound (int selection_bound);
		public void set_selection_color (Clutter.Color color);
		public void set_single_line_mode (bool single_line);
		public void set_text (string text);
		public void set_use_markup (bool setting);
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Text.with_text (string? font_name, string text);
		public bool activatable { get; set; }
		public Pango.AttrList attributes { get; set; }
		public Clutter.Color color { get; set; }
		public Clutter.Color cursor_color { get; set; }
		[NoAccessorMethod]
		public bool cursor_color_set { get; }
		public int cursor_size { get; set; }
		public bool cursor_visible { get; set; }
		public bool editable { get; set; }
		public Pango.EllipsizeMode ellipsize { get; set; }
		public Pango.FontDescription font_description { owned get; set; }
		public string font_name { get; set; }
		public bool justify { get; set; }
		public Pango.Alignment line_alignment { get; set; }
		public bool line_wrap { get; set; }
		public Pango.WrapMode line_wrap_mode { get; set; }
		public int max_length { get; set; }
		public uint password_char { get; set; }
		[NoAccessorMethod]
		public int position { get; set; }
		public bool selectable { get; set; }
		public Clutter.Color selected_text_color { get; set; }
		[NoAccessorMethod]
		public bool selected_text_color_set { get; }
		public int selection_bound { get; set; }
		public Clutter.Color selection_color { get; set; }
		[NoAccessorMethod]
		public bool selection_color_set { get; }
		public bool single_line_mode { get; set; }
		public string text { get; set; }
		public bool use_markup { get; set; }
		[HasEmitter]
		public virtual signal void activate ();
		public virtual signal void cursor_event (Clutter.Geometry geometry);
		[HasEmitter]
		public signal void delete_text (int start_pos, int end_pos);
		public virtual signal void text_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_texture_get_type ()")]
	public class Texture : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable, Atk.Implementor, Clutter.Animatable, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Texture ();
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		[Deprecated (since = "1.8")]
		public Texture.from_actor (Clutter.Actor actor);
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Texture.from_file (string filename) throws Clutter.TextureError;
		public void get_base_size (out int width, out int height);
		public unowned Cogl.Handle get_cogl_material ();
		public unowned Cogl.Handle get_cogl_texture ();
		public Clutter.TextureQuality get_filter_quality ();
		public bool get_keep_aspect_ratio ();
		public bool get_load_async ();
		public bool get_load_data_async ();
		public int get_max_tile_waste ();
		public bool get_pick_with_alpha ();
		public Cogl.PixelFormat get_pixel_format ();
		public void get_repeat (out bool repeat_x, out bool repeat_y);
		public bool get_sync_size ();
		public bool set_area_from_rgb_data ([CCode (array_length = false, array_null_terminated = true)] uint8[] data, bool has_alpha, int x, int y, int width, int height, int rowstride, int bpp, Clutter.TextureFlags flags) throws GLib.Error;
		public void set_cogl_material (Cogl.Handle cogl_material);
		public void set_cogl_texture (Cogl.Handle cogl_tex);
		public void set_filter_quality (Clutter.TextureQuality filter_quality);
		public bool set_from_file (string filename) throws GLib.Error;
		public bool set_from_rgb_data ([CCode (array_length = false, array_null_terminated = true)] uint8[] data, bool has_alpha, int width, int height, int rowstride, int bpp, Clutter.TextureFlags flags) throws GLib.Error;
		public bool set_from_yuv_data ([CCode (array_length = false, array_null_terminated = true)] uint8[] data, int width, int height, Clutter.TextureFlags flags) throws GLib.Error;
		public void set_keep_aspect_ratio (bool keep_aspect);
		public void set_load_async (bool load_async);
		public void set_load_data_async (bool load_async);
		public void set_pick_with_alpha (bool pick_with_alpha);
		public void set_repeat (bool repeat_x, bool repeat_y);
		public void set_sync_size (bool sync_size);
		public Cogl.Material cogl_material { get; set; }
		public Cogl.Texture cogl_texture { get; set; }
		[NoAccessorMethod]
		public bool disable_slicing { get; construct; }
		[NoAccessorMethod]
		public string filename { owned get; set; }
		public Clutter.TextureQuality filter_quality { get; set construct; }
		public bool keep_aspect_ratio { get; set; }
		public bool load_async { set; }
		public bool load_data_async { set; }
		public bool pick_with_alpha { get; set; }
		public Cogl.PixelFormat pixel_format { get; }
		[NoAccessorMethod]
		public bool repeat_x { get; set; }
		[NoAccessorMethod]
		public bool repeat_y { get; set; }
		public bool sync_size { get; set; }
		[NoAccessorMethod]
		public int tile_waste { get; }
		public virtual signal void load_finished (GLib.Error error);
		public virtual signal void pixbuf_change ();
		public virtual signal void size_change (int width, int height);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_timeline_get_type ()")]
	public class Timeline : GLib.Object {
		[CCode (has_construct_function = false)]
		public Timeline (uint msecs);
		public void add_marker_at_time (string marker_name, uint msecs);
		public void advance (uint msecs);
		public void advance_to_marker (string marker_name);
		public Clutter.Timeline clone ();
		public bool get_auto_reverse ();
		public uint get_delay ();
		public uint get_delta ();
		public Clutter.TimelineDirection get_direction ();
		public uint get_duration ();
		public uint get_elapsed_time ();
		public bool get_loop ();
		public double get_progress ();
		public bool has_marker (string marker_name);
		public bool is_playing ();
		[CCode (array_length_pos = 1.1, array_length_type = "gsize")]
		public string[] list_markers (int msecs);
		public void pause ();
		public void remove_marker (string marker_name);
		public void rewind ();
		public void set_auto_reverse (bool reverse);
		public void set_delay (uint msecs);
		public void set_direction (Clutter.TimelineDirection direction);
		public void set_duration (uint msecs);
		public void set_loop (bool loop);
		public void skip (uint msecs);
		public void start ();
		public void stop ();
		public bool auto_reverse { get; set; }
		public uint delay { get; set; }
		public Clutter.TimelineDirection direction { get; set; }
		public uint duration { get; set; }
		public bool loop { get; set; }
		public virtual signal void completed ();
		public virtual signal void marker_reached (string marker_name, int frame_num);
		public virtual signal void new_frame (int msecs);
		public virtual signal void paused ();
		public virtual signal void started ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Compact]
	public class TimeoutPool {
		[CCode (has_construct_function = false)]
		public TimeoutPool (int priority);
		public uint add (uint fps, owned GLib.SourceFunc func);
		public void remove (uint id_);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_animatable_get_type ()")]
	public interface Animatable : GLib.Object {
		[Deprecated (since = "1.8")]
		public abstract bool animate_property (Clutter.Animation animation, string property_name, GLib.Value initial_value, GLib.Value final_value, double progress, GLib.Value value);
		public abstract unowned GLib.ParamSpec find_property (string property_name);
		public abstract void get_initial_state (string property_name, GLib.Value value);
		public abstract bool interpolate_value (string property_name, Clutter.Interval interval, double progress, out GLib.Value value);
		public abstract void set_final_state (string property_name, GLib.Value value);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_container_get_type ()")]
	public interface Container : GLib.Object {
		public void add (params Clutter.Actor[] actors);
		[CCode (vfunc_name = "add")]
		public abstract void add_actor (Clutter.Actor actor);
		public void add_valist (Clutter.Actor first_actor, void* var_args);
		public void child_get (Clutter.Actor actor, ...);
		public void child_get_property (Clutter.Actor child, string property, GLib.Value value);
		public void child_set (Clutter.Actor actor, ...);
		public void child_set_property (Clutter.Actor child, string property, GLib.Value value);
		public virtual void create_child_meta (Clutter.Actor actor);
		public virtual void destroy_child_meta (Clutter.Actor actor);
		public unowned Clutter.Actor find_child_by_name (string child_name);
		[CCode (cname = "clutter_container_class_find_child_property")]
		public class unowned GLib.ParamSpec find_child_property (string property_name);
		public abstract void @foreach (Clutter.Callback callback);
		public virtual void foreach_with_internals (Clutter.Callback callback);
		public virtual unowned Clutter.ChildMeta get_child_meta (Clutter.Actor actor);
		public GLib.List<weak Clutter.Actor> get_children ();
		[CCode (cname = "clutter_container_class_list_child_properties")]
		public class unowned GLib.ParamSpec[] list_child_properties ();
		[CCode (vfunc_name = "lower")]
		public virtual void lower_child (Clutter.Actor actor, Clutter.Actor? sibling = null);
		[CCode (vfunc_name = "raise")]
		public virtual void raise_child (Clutter.Actor actor, Clutter.Actor? sibling = null);
		public void remove (...);
		[CCode (vfunc_name = "remove")]
		public abstract void remove_actor (Clutter.Actor actor);
		public void remove_valist (Clutter.Actor first_actor, va_list var_args);
		public abstract void sort_depth_order ();
		public virtual signal void actor_added (Clutter.Actor actor);
		public virtual signal void actor_removed (Clutter.Actor actor);
		[HasEmitter]
		public virtual signal void child_notify (Clutter.Actor child, GLib.ParamSpec pspec);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_media_get_type ()")]
	public interface Media : GLib.Object {
		public double get_audio_volume ();
		public double get_buffer_fill ();
		public bool get_can_seek ();
		public double get_duration ();
		public bool get_playing ();
		public double get_progress ();
		public string get_subtitle_font_name ();
		public string get_subtitle_uri ();
		public string get_uri ();
		public void set_audio_volume (double volume);
		public void set_filename (string filename);
		public void set_playing (bool playing);
		public void set_progress (double progress);
		public void set_subtitle_font_name (string font_name);
		public void set_subtitle_uri (string uri);
		public void set_uri (string uri);
		[NoAccessorMethod]
		public abstract double audio_volume { get; set; }
		[NoAccessorMethod]
		public abstract double buffer_fill { get; }
		[NoAccessorMethod]
		public abstract bool can_seek { get; }
		[NoAccessorMethod]
		public abstract double duration { get; }
		[NoAccessorMethod]
		public abstract bool playing { get; set; }
		[NoAccessorMethod]
		public abstract double progress { get; set; }
		[NoAccessorMethod]
		public abstract string subtitle_font_name { owned get; set; }
		[NoAccessorMethod]
		public abstract string subtitle_uri { owned get; set; }
		[NoAccessorMethod]
		public abstract string uri { owned get; set; }
		public virtual signal void eos ();
		public virtual signal void error (GLib.Error error);
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "clutter_scriptable_get_type ()")]
	public interface Scriptable : GLib.Object {
		public abstract unowned string get_id ();
		public abstract bool parse_custom_node (Clutter.Script script, GLib.Value value, string name, Json.Node node);
		public abstract void set_custom_property (Clutter.Script script, string name, GLib.Value value);
		public abstract void set_id (string id_);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface StageWindow : GLib.Object {
		[NoWrapper]
		public abstract void add_redraw_clip (Clutter.Geometry stage_rectangle);
		[NoWrapper]
		public abstract void get_geometry (Clutter.Geometry geometry);
		[NoWrapper]
		public abstract int get_pending_swaps ();
		[NoWrapper]
		public abstract unowned Clutter.Actor get_wrapper ();
		[NoWrapper]
		public abstract bool has_redraw_clips ();
		[NoWrapper]
		public abstract void hide ();
		[NoWrapper]
		public abstract bool ignoring_redraw_clips ();
		[NoWrapper]
		public abstract bool realize ();
		[NoWrapper]
		public abstract void resize (int width, int height);
		[NoWrapper]
		public abstract void set_cursor_visible (bool cursor_visible);
		[NoWrapper]
		public abstract void set_fullscreen (bool is_fullscreen);
		[NoWrapper]
		public abstract void set_title (string title);
		[NoWrapper]
		public abstract void set_user_resizable (bool is_resizable);
		[NoWrapper]
		public abstract void show (bool do_raise);
		[NoWrapper]
		public abstract void unrealize ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "CLUTTER_TYPE_ACTOR_BOX")]
	public struct ActorBox {
		public float x1;
		public float y1;
		public float x2;
		public float y2;
		public void clamp_to_pixel ();
		public bool contains (float x, float y);
		public Clutter.ActorBox copy ();
		public bool equal (Clutter.ActorBox box_b);
		public void free ();
		[CCode (cname = "clutter_actor_box_from_vertices")]
		public ActorBox.from_vertices (Clutter.Vertex[] verts);
		public float get_area ();
		public float get_height ();
		public void get_origin (out float x, out float y);
		public void get_size (out float width, out float height);
		public float get_width ();
		public float get_x ();
		public float get_y ();
		public Clutter.ActorBox interpolate (Clutter.ActorBox final, double progress);
		public void set_origin (float x, float y);
		public void set_size (float width, float height);
		public Clutter.ActorBox union (Clutter.ActorBox b);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct AnyEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct ButtonEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ModifierType modifier_state;
		public uint32 button;
		public uint click_count;
		public double axes;
		public weak Clutter.InputDevice device;
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "CLUTTER_TYPE_COLOR")]
	public struct Color {
		public static GLib.HashFunc hash;
		public static GLib.EqualFunc equal;
		public uint8 red;
		public uint8 green;
		public uint8 blue;
		public uint8 alpha;
		public Clutter.Color add (Clutter.Color b);
		public Clutter.Color copy ();
		public Clutter.Color darken ();
		public void free ();
		[CCode (cname = "clutter_color_from_hls")]
		public Color.from_hls (float hue, float luminance, float saturation);
		[CCode (cname = "clutter_color_from_pixel")]
		public Color.from_pixel (uint32 pixel);
		[CCode (cname = "clutter_color_from_string")]
		public Color.from_string (string str);
		public static Clutter.Color get_static (Clutter.StaticColor color);
		public Clutter.Color interpolate (Clutter.Color final, double progress);
		public Clutter.Color lighten ();
		[CCode (cname = "clutter_color_from_string")]
		public bool parse_string (string str);
		public Clutter.Color shade (double factor);
		public Clutter.Color subtract (Clutter.Color b);
		public void to_hls (out float hue, out float luminance, out float saturation);
		public uint32 to_pixel ();
		public string to_string ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct CrossingEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public weak Clutter.InputDevice device;
		public weak Clutter.Actor related;
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct Fog {
		public float z_near;
		public float z_far;
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct Geometry {
		public int x;
		public int y;
		public uint width;
		public uint height;
		public bool intersects (Clutter.Geometry geometry1);
		public Clutter.Geometry union (Clutter.Geometry geometry_b);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct KeyEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public Clutter.ModifierType modifier_state;
		public uint keyval;
		public uint16 hardware_keycode;
		public unichar unicode_value;
		public weak Clutter.InputDevice device;
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct Knot {
		public int x;
		public int y;
		public Clutter.Knot copy ();
		public bool equal (Clutter.Knot knot_b);
		public void free ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct MotionEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ModifierType modifier_state;
		public double axes;
		public weak Clutter.InputDevice device;
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct PathNode {
		public Clutter.PathNodeType type;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Clutter.Knot[] points;
		public Clutter.PathNode copy ();
		public bool equal (Clutter.PathNode node_b);
		public void free ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct Perspective {
		public float fovy;
		public float aspect;
		public float z_near;
		public float z_far;
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct ScrollEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ScrollDirection direction;
		public Clutter.ModifierType modifier_state;
		public double axes;
		public weak Clutter.InputDevice device;
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct StageStateEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public Clutter.StageState changed_mask;
		public Clutter.StageState new_state;
	}
	[CCode (cheader_filename = "clutter/clutter.h", type_id = "CLUTTER_TYPE_UNITS")]
	public struct Units {
		public Clutter.Units copy ();
		public void free ();
		[CCode (cname = "clutter_units_from_em")]
		public Units.from_em (float em);
		[CCode (cname = "clutter_units_from_em_for_font")]
		public Units.from_em_for_font (string font_name, float em);
		[CCode (cname = "clutter_units_from_mm")]
		public Units.from_mm (float mm);
		[CCode (cname = "clutter_units_from_pixels")]
		public Units.from_pixels (int px);
		[CCode (cname = "clutter_units_from_pt")]
		public Units.from_pt (float pt);
		[CCode (cname = "clutter_units_from_string")]
		public Units.from_string (string str);
		public Clutter.UnitType get_unit_type ();
		public float get_unit_value ();
		public float to_pixels ();
		public string to_string ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public struct Vertex {
		public float x;
		public float y;
		public float z;
		public Clutter.Vertex copy ();
		public bool equal (Clutter.Vertex vertex_b);
		public void free ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_ACTOR_")]
	[Flags]
	public enum ActorFlags {
		MAPPED,
		REALIZED,
		REACTIVE,
		VISIBLE,
		NO_LAYOUT
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_ALIGN_")]
	public enum AlignAxis {
		X_AXIS,
		Y_AXIS
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_")]
	[Flags]
	public enum AllocationFlags {
		ALLOCATION_NONE,
		ABSOLUTE_ORIGIN_CHANGED
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_")]
	public enum AnimationMode {
		CUSTOM_MODE,
		LINEAR,
		EASE_IN_QUAD,
		EASE_OUT_QUAD,
		EASE_IN_OUT_QUAD,
		EASE_IN_CUBIC,
		EASE_OUT_CUBIC,
		EASE_IN_OUT_CUBIC,
		EASE_IN_QUART,
		EASE_OUT_QUART,
		EASE_IN_OUT_QUART,
		EASE_IN_QUINT,
		EASE_OUT_QUINT,
		EASE_IN_OUT_QUINT,
		EASE_IN_SINE,
		EASE_OUT_SINE,
		EASE_IN_OUT_SINE,
		EASE_IN_EXPO,
		EASE_OUT_EXPO,
		EASE_IN_OUT_EXPO,
		EASE_IN_CIRC,
		EASE_OUT_CIRC,
		EASE_IN_OUT_CIRC,
		EASE_IN_ELASTIC,
		EASE_OUT_ELASTIC,
		EASE_IN_OUT_ELASTIC,
		EASE_IN_BACK,
		EASE_OUT_BACK,
		EASE_IN_OUT_BACK,
		EASE_IN_BOUNCE,
		EASE_OUT_BOUNCE,
		EASE_IN_OUT_BOUNCE,
		ANIMATION_LAST
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_BIN_ALIGNMENT_")]
	public enum BinAlignment {
		FIXED,
		FILL,
		START,
		END,
		CENTER
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_BIND_")]
	public enum BindCoordinate {
		X,
		Y,
		WIDTH,
		HEIGHT,
		POSITION,
		SIZE
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_BOX_ALIGNMENT_")]
	public enum BoxAlignment {
		START,
		END,
		CENTER
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_DRAG_")]
	public enum DragAxis {
		AXIS_NONE,
		X_AXIS,
		Y_AXIS
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_EFFECT_PAINT_ACTOR_")]
	[Flags]
	public enum EffectPaintFlags {
		[CCode (cname = "CLUTTER_EFFECT_PAINT_ACTOR_DIRTY")]
		ACTOR_DIRTY
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_EVENT_")]
	[Flags]
	public enum EventFlags {
		NONE,
		FLAG_SYNTHETIC
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_")]
	public enum EventType {
		NOTHING,
		KEY_PRESS,
		KEY_RELEASE,
		MOTION,
		ENTER,
		LEAVE,
		BUTTON_PRESS,
		BUTTON_RELEASE,
		SCROLL,
		STAGE_STATE,
		DESTROY_NOTIFY,
		CLIENT_MESSAGE,
		DELETE
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_FEATURE_")]
	[Flags]
	public enum FeatureFlags {
		TEXTURE_NPOT,
		SYNC_TO_VBLANK,
		TEXTURE_YUV,
		TEXTURE_READ_PIXELS,
		STAGE_STATIC,
		STAGE_USER_RESIZE,
		STAGE_CURSOR,
		SHADERS_GLSL,
		OFFSCREEN,
		STAGE_MULTIPLE,
		SWAP_EVENTS;
		[CCode (cname = "clutter_feature_available")]
		public bool is_available ();
		[CCode (cname = "clutter_feature_get_all")]
		public static Clutter.FeatureFlags @get ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_FLOW_")]
	public enum FlowOrientation {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_FONT_")]
	[Flags]
	public enum FontFlags {
		MIPMAPPING,
		HINTING
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_GRAVITY_")]
	public enum Gravity {
		NONE,
		NORTH,
		NORTH_EAST,
		EAST,
		SOUTH_EAST,
		SOUTH,
		SOUTH_WEST,
		WEST,
		NORTH_WEST,
		CENTER
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_INIT_")]
	public enum InitError {
		SUCCESS,
		ERROR_UNKNOWN,
		ERROR_THREADS,
		ERROR_BACKEND,
		ERROR_INTERNAL;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_INPUT_AXIS_")]
	public enum InputAxis {
		IGNORE,
		X,
		Y,
		PRESSURE,
		XTILT,
		YTILT,
		WHEEL
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_")]
	public enum InputDeviceType {
		POINTER_DEVICE,
		KEYBOARD_DEVICE,
		EXTENSION_DEVICE,
		JOYSTICK_DEVICE,
		TABLET_DEVICE,
		TOUCHPAD_DEVICE,
		TOUCHSCREEN_DEVICE,
		PEN_DEVICE,
		ERASER_DEVICE,
		CURSOR_DEVICE,
		N_DEVICE_TYPES
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_INPUT_MODE_")]
	public enum InputMode {
		MASTER,
		SLAVE,
		FLOATING
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_INTERPOLATION_")]
	public enum Interpolation {
		LINEAR,
		CUBIC
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_LONG_PRESS_")]
	public enum LongPressState {
		QUERY,
		ACTIVATE,
		CANCEL
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_")]
	[Flags]
	public enum ModifierType {
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		BUTTON1_MASK,
		BUTTON2_MASK,
		BUTTON3_MASK,
		BUTTON4_MASK,
		BUTTON5_MASK,
		MODIFIER_RESERVED_13_MASK,
		MODIFIER_RESERVED_14_MASK,
		MODIFIER_RESERVED_15_MASK,
		MODIFIER_RESERVED_16_MASK,
		MODIFIER_RESERVED_17_MASK,
		MODIFIER_RESERVED_18_MASK,
		MODIFIER_RESERVED_19_MASK,
		MODIFIER_RESERVED_20_MASK,
		MODIFIER_RESERVED_21_MASK,
		MODIFIER_RESERVED_22_MASK,
		MODIFIER_RESERVED_23_MASK,
		MODIFIER_RESERVED_24_MASK,
		MODIFIER_RESERVED_25_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		MODIFIER_RESERVED_29_MASK,
		RELEASE_MASK,
		MODIFIER_MASK
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_OFFSCREEN_REDIRECT_")]
	public enum OffscreenRedirect {
		AUTOMATIC_FOR_OPACITY,
		ALWAYS_FOR_OPACITY,
		ALWAYS
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_PATH_")]
	public enum PathNodeType {
		MOVE_TO,
		LINE_TO,
		CURVE_TO,
		CLOSE,
		REL_MOVE_TO,
		REL_LINE_TO,
		REL_CURVE_TO
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_PICK_")]
	public enum PickMode {
		NONE,
		REACTIVE,
		ALL
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_REQUEST_")]
	public enum RequestMode {
		HEIGHT_FOR_WIDTH,
		WIDTH_FOR_HEIGHT
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_")]
	public enum RotateAxis {
		X_AXIS,
		Y_AXIS,
		Z_AXIS
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_ROTATE_")]
	public enum RotateDirection {
		CW,
		CCW
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_SCROLL_")]
	public enum ScrollDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_")]
	public enum ShaderType {
		VERTEX_SHADER,
		FRAGMENT_SHADER
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_SNAP_EDGE_")]
	public enum SnapEdge {
		TOP,
		RIGHT,
		BOTTOM,
		LEFT
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_STAGE_STATE_")]
	[Flags]
	public enum StageState {
		FULLSCREEN,
		OFFSCREEN,
		ACTIVATED
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_COLOR_")]
	public enum StaticColor {
		WHITE,
		BLACK,
		RED,
		DARK_RED,
		GREEN,
		DARK_GREEN,
		BLUE,
		DARK_BLUE,
		CYAN,
		DARK_CYAN,
		MAGENTA,
		DARK_MAGENTA,
		YELLOW,
		DARK_YELLOW,
		GRAY,
		DARK_GRAY,
		LIGHT_GRAY,
		BUTTER,
		BUTTER_LIGHT,
		BUTTER_DARK,
		ORANGE,
		ORANGE_LIGHT,
		ORANGE_DARK,
		CHOCOLATE,
		CHOCOLATE_LIGHT,
		CHOCOLATE_DARK,
		CHAMELEON,
		CHAMELEON_LIGHT,
		CHAMELEON_DARK,
		SKY_BLUE,
		SKY_BLUE_LIGHT,
		SKY_BLUE_DARK,
		PLUM,
		PLUM_LIGHT,
		PLUM_DARK,
		SCARLET_RED,
		SCARLET_RED_LIGHT,
		SCARLET_RED_DARK,
		ALUMINIUM_1,
		ALUMINIUM_2,
		ALUMINIUM_3,
		ALUMINIUM_4,
		ALUMINIUM_5,
		ALUMINIUM_6,
		TRANSPARENT
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_SWIPE_DIRECTION_")]
	[Flags]
	public enum SwipeDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_TABLE_ALIGNMENT_")]
	public enum TableAlignment {
		START,
		CENTER,
		END
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_TEXT_DIRECTION_")]
	public enum TextDirection {
		DEFAULT,
		LTR,
		RTL
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_TEXTURE_")]
	[Flags]
	public enum TextureFlags {
		NONE,
		RGB_FLAG_BGR,
		RGB_FLAG_PREMULT,
		YUV_FLAG_YUV2
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_TEXTURE_QUALITY_")]
	public enum TextureQuality {
		LOW,
		MEDIUM,
		HIGH
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_TIMELINE_")]
	public enum TimelineDirection {
		FORWARD,
		BACKWARD
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_UNIT_")]
	public enum UnitType {
		PIXEL,
		EM,
		MM,
		POINT,
		CM
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_X11_FILTER_")]
	public enum X11FilterReturn {
		CONTINUE,
		TRANSLATE,
		REMOVE
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_X11_XINPUT_")]
	public enum X11XInputEventTypes {
		KEY_PRESS_EVENT,
		KEY_RELEASE_EVENT,
		BUTTON_PRESS_EVENT,
		BUTTON_RELEASE_EVENT,
		MOTION_NOTIFY_EVENT,
		LAST_EVENT
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_SCRIPT_ERROR_INVALID_")]
	public errordomain ScriptError {
		TYPE_FUNCTION,
		PROPERTY,
		VALUE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_SHADER_ERROR_")]
	public errordomain ShaderError {
		NO_ASM,
		NO_GLSL,
		COMPILE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", cprefix = "CLUTTER_TEXTURE_ERROR_")]
	public errordomain TextureError {
		OUT_OF_MEMORY,
		NO_YUV,
		BAD_FORMAT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 1.9)]
	public delegate double AlphaFunc (Clutter.Alpha alpha);
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 2.9)]
	public delegate void BehaviourForeachFunc (Clutter.Behaviour behaviour, Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate bool BindingActionFunc (GLib.Object gobject, string action_name, uint key_val, Clutter.ModifierType modifiers);
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 1.9)]
	public delegate void Callback (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 2.9)]
	public delegate bool ModelFilterFunc (Clutter.Model model, Clutter.ModelIter iter);
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 2.9)]
	public delegate bool ModelForeachFunc (Clutter.Model model, Clutter.ModelIter iter);
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 3.9)]
	public delegate int ModelSortFunc (Clutter.Model model, GLib.Value a, GLib.Value b);
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 1.9)]
	public delegate void PathCallback (Clutter.PathNode node);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate bool ProgressFunc (GLib.Value a, GLib.Value b, double progress, GLib.Value retval);
	[CCode (cheader_filename = "clutter/clutter.h", instance_pos = 6.9)]
	public delegate void ScriptConnectFunc (Clutter.Script script, GLib.Object object, string signal_name, string handler_name, GLib.Object connect_object, GLib.ConnectFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string COGL;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int CURRENT_TIME;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string FLAVOUR;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PATH_RELATIVE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PRIORITY_REDRAW;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const double VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int VERSION_HEX;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string VERSION_S;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void base_init ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void cairo_set_source_color (Cairo.Context cr, Clutter.Color color);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool check_version (uint major, uint minor, uint micro);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void clear_glyph_cache ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void do_event (Clutter.Event event);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool events_pending ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_accessibility_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Event get_current_event ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint32 get_current_event_time ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_debug_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Backend get_default_backend ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint get_default_frame_rate ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.TextDirection get_default_text_direction ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.FontFlags get_font_flags ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Pango.FontMap get_font_map ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Actor get_keyboard_grab ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Deprecated (since = "1.8")]
	public static bool get_motion_events_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.OptionGroup get_option_group ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.OptionGroup get_option_group_without_init ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Actor get_pointer_grab ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned string get_script_id (GLib.Object gobject);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_show_fps ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static ulong get_timestamp ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_keyboard (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_pointer (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_pointer_for_device (Clutter.Actor actor, int id_);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.InitError init ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.InitError init_with_args ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv, string? parameter_string, [CCode (array_length = false, type = "GOptionEntry*")] GLib.OptionEntry?[] entries, string? translation_domain) throws GLib.Error;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint32 keysym_to_unicode (uint keyval);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void main ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static int main_level ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void main_quit ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_default_frame_rate (uint frames_per_sec);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_font_flags (Clutter.FontFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Deprecated (since = "1.8")]
	public static void set_motion_events_enabled (bool enable);
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Deprecated (replacement = "Threads.add_repaint_func", since = "vala-0.14")]
	public static uint threads_add_repaint_func (GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "clutter/clutter.h")]
	[Deprecated (replacement = "Threads.remove_repaint_func", since = "vala-0.14")]
	public static void threads_remove_repaint_func (uint handle_id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_keyboard ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_pointer ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_pointer_for_device (int id_);
}
