/* libvirt-machine.c generated by valac 0.15.0.11-e8f32, the Vala compiler
 * generated from libvirt-machine.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libvirt-gobject/libvirt-gobject.h>
#include <float.h>
#include <math.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <glib/gi18n-lib.h>


#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UI, BoxesUIClass))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_IS_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UI))
#define BOXES_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UI, BoxesUIClass))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIClass BoxesUIClass;
typedef struct _BoxesUIPrivate BoxesUIPrivate;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;
typedef struct _BoxesCollectionItemPrivate BoxesCollectionItemPrivate;

#define BOXES_TYPE_IPROPERTIES (boxes_iproperties_get_type ())
#define BOXES_IPROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_IPROPERTIES, BoxesIProperties))
#define BOXES_IS_IPROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_IPROPERTIES))
#define BOXES_IPROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_IPROPERTIES, BoxesIPropertiesIface))

typedef struct _BoxesIProperties BoxesIProperties;
typedef struct _BoxesIPropertiesIface BoxesIPropertiesIface;

#define BOXES_TYPE_PROPERTIES_PAGE (boxes_properties_page_get_type ())

#define BOXES_TYPE_PAIR (boxes_pair_get_type ())
#define BOXES_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PAIR, BoxesPair))
#define BOXES_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PAIR, BoxesPairClass))
#define BOXES_IS_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PAIR))
#define BOXES_IS_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PAIR))
#define BOXES_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PAIR, BoxesPairClass))

typedef struct _BoxesPair BoxesPair;
typedef struct _BoxesPairClass BoxesPairClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;
typedef struct _BoxesMachinePrivate BoxesMachinePrivate;

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;

#define BOXES_TYPE_MACHINE_ACTOR (boxes_machine_actor_get_type ())
#define BOXES_MACHINE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE_ACTOR, BoxesMachineActor))
#define BOXES_MACHINE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE_ACTOR, BoxesMachineActorClass))
#define BOXES_IS_MACHINE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE_ACTOR))
#define BOXES_IS_MACHINE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE_ACTOR))
#define BOXES_MACHINE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE_ACTOR, BoxesMachineActorClass))

typedef struct _BoxesMachineActor BoxesMachineActor;
typedef struct _BoxesMachineActorClass BoxesMachineActorClass;

#define BOXES_TYPE_COLLECTION_SOURCE (boxes_collection_source_get_type ())
#define BOXES_COLLECTION_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_SOURCE, BoxesCollectionSource))
#define BOXES_COLLECTION_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_SOURCE, BoxesCollectionSourceClass))
#define BOXES_IS_COLLECTION_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_SOURCE))
#define BOXES_IS_COLLECTION_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_SOURCE))
#define BOXES_COLLECTION_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_SOURCE, BoxesCollectionSourceClass))

typedef struct _BoxesCollectionSource BoxesCollectionSource;
typedef struct _BoxesCollectionSourceClass BoxesCollectionSourceClass;

#define BOXES_TYPE_DISPLAY_CONFIG (boxes_display_config_get_type ())
#define BOXES_DISPLAY_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY_CONFIG, BoxesDisplayConfig))
#define BOXES_DISPLAY_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY_CONFIG, BoxesDisplayConfigClass))
#define BOXES_IS_DISPLAY_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY_CONFIG))
#define BOXES_IS_DISPLAY_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY_CONFIG))
#define BOXES_DISPLAY_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY_CONFIG, BoxesDisplayConfigClass))

typedef struct _BoxesDisplayConfig BoxesDisplayConfig;
typedef struct _BoxesDisplayConfigClass BoxesDisplayConfigClass;

#define BOXES_TYPE_LIBVIRT_MACHINE (boxes_libvirt_machine_get_type ())
#define BOXES_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachine))
#define BOXES_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))
#define BOXES_IS_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_IS_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_LIBVIRT_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))

typedef struct _BoxesLibvirtMachine BoxesLibvirtMachine;
typedef struct _BoxesLibvirtMachineClass BoxesLibvirtMachineClass;
typedef struct _BoxesLibvirtMachinePrivate BoxesLibvirtMachinePrivate;

#define BOXES_LIBVIRT_MACHINE_TYPE_MACHINE_STAT (boxes_libvirt_machine_machine_stat_get_type ())
typedef struct _BoxesLibvirtMachineMachineStat BoxesLibvirtMachineMachineStat;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesAppPrivate BoxesAppPrivate;

#define BOXES_TYPE_TOPBAR (boxes_topbar_get_type ())
#define BOXES_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOPBAR, BoxesTopbar))
#define BOXES_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOPBAR, BoxesTopbarClass))
#define BOXES_IS_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOPBAR))
#define BOXES_IS_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOPBAR))
#define BOXES_TOPBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOPBAR, BoxesTopbarClass))

typedef struct _BoxesTopbar BoxesTopbar;
typedef struct _BoxesTopbarClass BoxesTopbarClass;

#define BOXES_TYPE_NOTIFICATIONBAR (boxes_notificationbar_get_type ())
#define BOXES_NOTIFICATIONBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_NOTIFICATIONBAR, BoxesNotificationbar))
#define BOXES_NOTIFICATIONBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_NOTIFICATIONBAR, BoxesNotificationbarClass))
#define BOXES_IS_NOTIFICATIONBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_NOTIFICATIONBAR))
#define BOXES_IS_NOTIFICATIONBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_NOTIFICATIONBAR))
#define BOXES_NOTIFICATIONBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_NOTIFICATIONBAR, BoxesNotificationbarClass))

typedef struct _BoxesNotificationbar BoxesNotificationbar;
typedef struct _BoxesNotificationbarClass BoxesNotificationbarClass;

#define BOXES_TYPE_SIDEBAR (boxes_sidebar_get_type ())
#define BOXES_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SIDEBAR, BoxesSidebar))
#define BOXES_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SIDEBAR, BoxesSidebarClass))
#define BOXES_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SIDEBAR))
#define BOXES_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SIDEBAR))
#define BOXES_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SIDEBAR, BoxesSidebarClass))

typedef struct _BoxesSidebar BoxesSidebar;
typedef struct _BoxesSidebarClass BoxesSidebarClass;

#define BOXES_TYPE_SELECTIONBAR (boxes_selectionbar_get_type ())
#define BOXES_SELECTIONBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SELECTIONBAR, BoxesSelectionbar))
#define BOXES_SELECTIONBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SELECTIONBAR, BoxesSelectionbarClass))
#define BOXES_IS_SELECTIONBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SELECTIONBAR))
#define BOXES_IS_SELECTIONBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SELECTIONBAR))
#define BOXES_SELECTIONBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SELECTIONBAR, BoxesSelectionbarClass))

typedef struct _BoxesSelectionbar BoxesSelectionbar;
typedef struct _BoxesSelectionbarClass BoxesSelectionbarClass;

#define BOXES_TYPE_WIZARD (boxes_wizard_get_type ())
#define BOXES_WIZARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WIZARD, BoxesWizard))
#define BOXES_WIZARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WIZARD, BoxesWizardClass))
#define BOXES_IS_WIZARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WIZARD))
#define BOXES_IS_WIZARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WIZARD))
#define BOXES_WIZARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WIZARD, BoxesWizardClass))

typedef struct _BoxesWizard BoxesWizard;
typedef struct _BoxesWizardClass BoxesWizardClass;

#define BOXES_TYPE_PROPERTIES (boxes_properties_get_type ())
#define BOXES_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PROPERTIES, BoxesProperties))
#define BOXES_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PROPERTIES, BoxesPropertiesClass))
#define BOXES_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PROPERTIES))
#define BOXES_IS_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PROPERTIES))
#define BOXES_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PROPERTIES, BoxesPropertiesClass))

typedef struct _BoxesProperties BoxesProperties;
typedef struct _BoxesPropertiesClass BoxesPropertiesClass;

#define BOXES_TYPE_DISPLAY_PAGE (boxes_display_page_get_type ())
#define BOXES_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPage))
#define BOXES_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))
#define BOXES_IS_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_IS_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_DISPLAY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))

typedef struct _BoxesDisplayPage BoxesDisplayPage;
typedef struct _BoxesDisplayPageClass BoxesDisplayPageClass;

#define BOXES_TYPE_COLLECTION (boxes_collection_get_type ())
#define BOXES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION, BoxesCollection))
#define BOXES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION, BoxesCollectionClass))
#define BOXES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION))
#define BOXES_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION))
#define BOXES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION, BoxesCollectionClass))

typedef struct _BoxesCollection BoxesCollection;
typedef struct _BoxesCollectionClass BoxesCollectionClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GVirDomainDiskStats_free0(var) ((var == NULL) ? NULL : (var = (_vala_GVirDomainDiskStats_free (var), NULL)))
#define __vala_GVirDomainInterfaceStats_free0(var) ((var == NULL) ? NULL : (var = (_vala_GVirDomainInterfaceStats_free (var), NULL)))
#define __vala_GVirDomainInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GVirDomainInfo_free (var), NULL)))
#define __g_list_free__boxes_pair_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__boxes_pair_unref0_ (var), NULL)))

#define BOXES_TYPE_SPICE_DISPLAY (boxes_spice_display_get_type ())
#define BOXES_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay))
#define BOXES_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))
#define BOXES_IS_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_IS_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_SPICE_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))

typedef struct _BoxesSpiceDisplay BoxesSpiceDisplay;
typedef struct _BoxesSpiceDisplayClass BoxesSpiceDisplayClass;

#define BOXES_TYPE_VNC_DISPLAY (boxes_vnc_display_get_type ())
#define BOXES_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplay))
#define BOXES_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))
#define BOXES_IS_VNC_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_IS_VNC_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VNC_DISPLAY))
#define BOXES_VNC_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VNC_DISPLAY, BoxesVncDisplayClass))

typedef struct _BoxesVncDisplay BoxesVncDisplay;
typedef struct _BoxesVncDisplayClass BoxesVncDisplayClass;
typedef struct _BoxesLibvirtMachineTakeScreenshotData BoxesLibvirtMachineTakeScreenshotData;

typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_SETTINGS,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES
} BoxesUIState;

struct _BoxesUI {
	GObject parent_instance;
	BoxesUIPrivate * priv;
	BoxesUIState previous_ui_state;
};

struct _BoxesUIClass {
	GObjectClass parent_class;
	void (*ui_state_changed) (BoxesUI* self);
	ClutterActor* (*get_actor) (BoxesUI* self);
};

struct _BoxesCollectionItem {
	BoxesUI parent_instance;
	BoxesCollectionItemPrivate * priv;
};

struct _BoxesCollectionItemClass {
	BoxesUIClass parent_class;
};

typedef enum  {
	BOXES_PROPERTIES_PAGE_LOGIN,
	BOXES_PROPERTIES_PAGE_DISPLAY,
	BOXES_PROPERTIES_PAGE_DEVICES,
	BOXES_PROPERTIES_PAGE_LAST
} BoxesPropertiesPage;

struct _BoxesIPropertiesIface {
	GTypeInterface parent_iface;
	GList* (*get_properties) (BoxesIProperties* self, BoxesPropertiesPage page);
};

struct _BoxesMachine {
	BoxesCollectionItem parent_instance;
	BoxesMachinePrivate * priv;
	BoxesApp* app;
	BoxesMachineActor* machine_actor;
	BoxesCollectionSource* source;
	BoxesDisplayConfig* config;
	gboolean _connect_display;
};

struct _BoxesMachineClass {
	BoxesCollectionItemClass parent_class;
	gchar* (*get_screenshot_filename) (BoxesMachine* self, const gchar* ext);
	void (*take_screenshot) (BoxesMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*take_screenshot_finish) (BoxesMachine* self, GAsyncResult* _res_, GError** error);
	GList* (*get_properties) (BoxesMachine* self, BoxesPropertiesPage page);
	gboolean (*is_running) (BoxesMachine* self);
	gchar* (*get_screenshot_prefix) (BoxesMachine* self);
	void (*connect_display) (BoxesMachine* self);
	void (*disconnect_display) (BoxesMachine* self);
	void (*delete) (BoxesMachine* self, gboolean by_user);
};

struct _BoxesLibvirtMachine {
	BoxesMachine parent_instance;
	BoxesLibvirtMachinePrivate * priv;
	GVirDomain* domain;
	GVirConnection* connection;
	gdouble* cpu_stats;
	gint cpu_stats_length1;
	gint _cpu_stats_size_;
	gdouble* io_stats;
	gint io_stats_length1;
	gint _io_stats_size_;
	gdouble* net_stats;
	gint net_stats_length1;
	gint _net_stats_size_;
};

struct _BoxesLibvirtMachineClass {
	BoxesMachineClass parent_class;
};

struct _BoxesLibvirtMachineMachineStat {
	gint64 timestamp;
	gdouble cpu_time;
	gdouble cpu_time_abs;
	gdouble cpu_guest_percent;
	gdouble memory_percent;
	GVirDomainDiskStats* disk;
	gdouble disk_read;
	gdouble disk_write;
	GVirDomainInterfaceStats* net;
	gdouble net_read;
	gdouble net_write;
};

struct _BoxesLibvirtMachinePrivate {
	gulong started_id;
	BoxesLibvirtMachineMachineStat* stats;
	gint stats_length1;
	gint _stats_size_;
	guint stats_id;
};

struct _BoxesApp {
	BoxesUI parent_instance;
	BoxesAppPrivate * priv;
	GtkWindow* window;
	GtkNotebook* notebook;
	GtkClutterEmbed* embed;
	ClutterStage* stage;
	ClutterState* state;
	ClutterBox* box;
	BoxesCollectionItem* current_item;
	BoxesTopbar* topbar;
	BoxesNotificationbar* notificationbar;
	BoxesSidebar* sidebar;
	BoxesSelectionbar* selectionbar;
	guint duration;
	GSettings* settings;
	BoxesWizard* wizard;
	BoxesProperties* properties;
	BoxesDisplayPage* display_page;
	BoxesCollection* collection;
};

struct _BoxesAppClass {
	BoxesUIClass parent_class;
};

typedef enum  {
	BOXES_ERROR_INVALID
} BoxesError;
#define BOXES_ERROR boxes_error_quark ()
typedef void (*PropertyStringChanged) (const gchar* value, void* user_data, GError** error);
struct _BoxesLibvirtMachineTakeScreenshotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesLibvirtMachine* self;
	gboolean result;
	gboolean _tmp0_;
	GVirDomainState _tmp1_;
	GVirDomainState _tmp2_;
	GVirDomainState _tmp3_;
	GVirDomainState _tmp4_;
	gboolean _tmp5_;
	GVirConnection* _tmp6_;
	GVirStream* _tmp7_;
	GVirStream* stream;
	gchar* _tmp8_;
	gchar* file_name;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* file;
	GFile* _tmp11_;
	GFileOutputStream* _tmp12_;
	GFileOutputStream* output_stream;
	GVirStream* _tmp13_;
	GInputStream* _tmp14_;
	GInputStream* _tmp15_;
	GInputStream* input_stream;
	GVirDomain* _tmp16_;
	GVirStream* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	guint8* _tmp20_;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gssize length;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gssize _tmp23_;
	GInputStream* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gssize _tmp26_;
	gssize _tmp27_;
	GFileOutputStream* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gssize _tmp30_;
	GError * _inner_error_;
};


static gpointer boxes_libvirt_machine_parent_class = NULL;

GType boxes_ui_get_type (void) G_GNUC_CONST;
GType boxes_ui_state_get_type (void) G_GNUC_CONST;
GType boxes_collection_item_get_type (void) G_GNUC_CONST;
GType boxes_properties_page_get_type (void) G_GNUC_CONST;
gpointer boxes_pair_ref (gpointer instance);
void boxes_pair_unref (gpointer instance);
GParamSpec* boxes_param_spec_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_pair (GValue* value, gpointer v_object);
void boxes_value_take_pair (GValue* value, gpointer v_object);
gpointer boxes_value_get_pair (const GValue* value);
GType boxes_pair_get_type (void) G_GNUC_CONST;
GType boxes_iproperties_get_type (void) G_GNUC_CONST;
GType boxes_machine_get_type (void) G_GNUC_CONST;
GType boxes_app_get_type (void) G_GNUC_CONST;
GType boxes_machine_actor_get_type (void) G_GNUC_CONST;
GType boxes_collection_source_get_type (void) G_GNUC_CONST;
GType boxes_display_config_get_type (void) G_GNUC_CONST;
GType boxes_libvirt_machine_get_type (void) G_GNUC_CONST;
static GType boxes_libvirt_machine_machine_stat_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BoxesLibvirtMachineMachineStat* boxes_libvirt_machine_machine_stat_dup (const BoxesLibvirtMachineMachineStat* self);
static void boxes_libvirt_machine_machine_stat_free (BoxesLibvirtMachineMachineStat* self);
static void boxes_libvirt_machine_machine_stat_copy (const BoxesLibvirtMachineMachineStat* self, BoxesLibvirtMachineMachineStat* dest);
static void boxes_libvirt_machine_machine_stat_destroy (BoxesLibvirtMachineMachineStat* self);
#define BOXES_LIBVIRT_MACHINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachinePrivate))
enum  {
	BOXES_LIBVIRT_MACHINE_DUMMY_PROPERTY,
	BOXES_LIBVIRT_MACHINE_STATE
};
static void _vala_BoxesLibvirtMachineMachineStat_array_free (BoxesLibvirtMachineMachineStat* array, gint array_length);
#define BOXES_LIBVIRT_MACHINE_STATS_SIZE 20
static void boxes_libvirt_machine_real_disconnect_display (BoxesMachine* base);
GType boxes_topbar_get_type (void) G_GNUC_CONST;
GType boxes_notificationbar_get_type (void) G_GNUC_CONST;
GType boxes_sidebar_get_type (void) G_GNUC_CONST;
GType boxes_selectionbar_get_type (void) G_GNUC_CONST;
GType boxes_wizard_get_type (void) G_GNUC_CONST;
GType boxes_properties_get_type (void) G_GNUC_CONST;
GType boxes_display_page_get_type (void) G_GNUC_CONST;
GType boxes_collection_get_type (void) G_GNUC_CONST;
GtkWidget* boxes_display_page_remove_display (BoxesDisplayPage* self);
GType boxes_display_get_type (void) G_GNUC_CONST;
void boxes_machine_set_display (BoxesMachine* self, BoxesDisplay* value);
static void boxes_libvirt_machine_real_connect_display (BoxesMachine* base);
static void boxes_libvirt_machine_update_display (BoxesLibvirtMachine* self);
GVirDomainState boxes_libvirt_machine_get_state (BoxesLibvirtMachine* self);
static void ____lambda64_ (BoxesLibvirtMachine* self);
void boxes_machine_connect_display (BoxesMachine* self);
static void _____lambda64__gvir_domain_resumed (GVirDomain* _sender, gpointer self);
static void ____lambda65_ (BoxesLibvirtMachine* self);
static void _____lambda65__gvir_domain_started (GVirDomain* _sender, gpointer self);
BoxesLibvirtMachine* boxes_libvirt_machine_new (BoxesCollectionSource* source, BoxesApp* app, GVirConnection* connection, GVirDomain* domain);
BoxesLibvirtMachine* boxes_libvirt_machine_construct (GType object_type, BoxesCollectionSource* source, BoxesApp* app, GVirConnection* connection, GVirDomain* domain);
BoxesMachine* boxes_machine_construct (GType object_type, BoxesCollectionSource* source, BoxesApp* app, const gchar* name);
BoxesDisplayConfig* boxes_display_config_new (BoxesCollectionSource* source, const gchar* subgroup);
BoxesDisplayConfig* boxes_display_config_construct (GType object_type, BoxesCollectionSource* source, const gchar* subgroup);
void boxes_machine_set_screenshot_enable (BoxesMachine* self, gboolean enable);
static void boxes_libvirt_machine_set_stats_enable (BoxesLibvirtMachine* self, gboolean enable);
static void boxes_libvirt_machine_update_cpu_stat (BoxesLibvirtMachine* self, GVirDomainInfo* info, BoxesLibvirtMachineMachineStat* stat);
static void boxes_libvirt_machine_update_mem_stat (BoxesLibvirtMachine* self, GVirDomainInfo* info, BoxesLibvirtMachineMachineStat* stat);
gboolean boxes_machine_is_running (BoxesMachine* self);
static void boxes_libvirt_machine_update_io_stat (BoxesLibvirtMachine* self, BoxesLibvirtMachineMachineStat* stat);
GQuark boxes_error_quark (void);
gchar* boxes_extract_xpath (const gchar* xmldoc, const gchar* xpath, gboolean required, GError** error);
static void _vala_GVirDomainDiskStats_free (GVirDomainDiskStats* self);
static void boxes_libvirt_machine_update_net_stat (BoxesLibvirtMachine* self, BoxesLibvirtMachineMachineStat* stat);
static void _vala_GVirDomainInterfaceStats_free (GVirDomainInterfaceStats* self);
static void boxes_libvirt_machine_update_stats (BoxesLibvirtMachine* self);
static BoxesLibvirtMachineMachineStat* _vala_array_dup2 (BoxesLibvirtMachineMachineStat* self, int length);
static void _vala_array_add2 (BoxesLibvirtMachineMachineStat** array, int* length, int* size, const BoxesLibvirtMachineMachineStat* value);
static void _vala_GVirDomainInfo_free (GVirDomainInfo* self);
static void _vala_array_add3 (gdouble** array, int* length, int* size, gdouble value);
static void _vala_array_add4 (gdouble** array, int* length, int* size, gdouble value);
static void _vala_array_add5 (gdouble** array, int* length, int* size, gdouble value);
static gboolean ___lambda66_ (BoxesLibvirtMachine* self);
static gboolean ____lambda66__gsource_func (gpointer self);
static GList* boxes_libvirt_machine_real_get_properties (BoxesMachine* base, BoxesPropertiesPage page);
void boxes_iproperties_add_string_property (BoxesIProperties* self, GList** list, const gchar* name, const gchar* value, PropertyStringChanged changed, void* changed_target);
gchar* boxes_collection_source_get_uri (BoxesCollectionSource* self);
BoxesDisplay* boxes_machine_get_display (BoxesMachine* self);
gchar* boxes_display_get_uri (BoxesDisplay* self);
const gchar* boxes_display_get_protocol (BoxesDisplay* self);
GList* boxes_display_get_properties (BoxesDisplay* self, BoxesPropertiesPage page);
static void _boxes_pair_unref0_ (gpointer var);
static void _g_list_free__boxes_pair_unref0_ (GList* self);
void boxes_display_disconnect_it (BoxesDisplay* self);
BoxesSpiceDisplay* boxes_spice_display_new (BoxesDisplayConfig* config, const gchar* host, gint port);
BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type, BoxesDisplayConfig* config, const gchar* host, gint port);
GType boxes_spice_display_get_type (void) G_GNUC_CONST;
BoxesVncDisplay* boxes_vnc_display_new (BoxesDisplayConfig* config, const gchar* host, gint port);
BoxesVncDisplay* boxes_vnc_display_construct (GType object_type, BoxesDisplayConfig* config, const gchar* host, gint port);
GType boxes_vnc_display_get_type (void) G_GNUC_CONST;
static gchar* boxes_libvirt_machine_real_get_screenshot_prefix (BoxesMachine* base);
static gboolean boxes_libvirt_machine_real_is_running (BoxesMachine* base);
static void boxes_libvirt_machine_real_take_screenshot_data_free (gpointer _data);
static void boxes_libvirt_machine_real_take_screenshot (BoxesMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean boxes_libvirt_machine_real_take_screenshot_co (BoxesLibvirtMachineTakeScreenshotData* _data_);
gchar* boxes_machine_get_screenshot_filename (BoxesMachine* self, const gchar* ext);
static void boxes_libvirt_machine_take_screenshot_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void boxes_output_stream_write (GOutputStream* stream, guint8* buffer, int buffer_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void boxes_output_stream_write_finish (GAsyncResult* _res_, GError** error);
static void boxes_libvirt_machine_real_delete (BoxesMachine* base, gboolean by_user);
static GObject * boxes_libvirt_machine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static GVirDomainDiskStats* _vala_GVirDomainDiskStats_copy (GVirDomainDiskStats* self);
static GVirDomainInterfaceStats* _vala_GVirDomainInterfaceStats_copy (GVirDomainInterfaceStats* self);
static void boxes_libvirt_machine_finalize (GObject* obj);
static void _vala_boxes_libvirt_machine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _vala_BoxesLibvirtMachineMachineStat_array_free (BoxesLibvirtMachineMachineStat* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			boxes_libvirt_machine_machine_stat_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void boxes_libvirt_machine_real_disconnect_display (BoxesMachine* base) {
	BoxesLibvirtMachine * self;
	gboolean _tmp0_;
	BoxesApp* _tmp1_;
	BoxesDisplayPage* _tmp2_;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_;
	self = (BoxesLibvirtMachine*) base;
	_tmp0_ = ((BoxesMachine*) self)->_connect_display;
	if (_tmp0_ == FALSE) {
		return;
	}
	((BoxesMachine*) self)->_connect_display = FALSE;
	_tmp1_ = ((BoxesMachine*) self)->app;
	_tmp2_ = _tmp1_->display_page;
	_tmp3_ = boxes_display_page_remove_display (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	boxes_machine_set_display ((BoxesMachine*) self, NULL);
}


static void ____lambda64_ (BoxesLibvirtMachine* self) {
	GVirDomain* _tmp0_;
	gulong _tmp1_;
	_tmp0_ = self->domain;
	_tmp1_ = self->priv->started_id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	self->priv->started_id = (gulong) 0;
	boxes_machine_connect_display ((BoxesMachine*) self);
}


static void _____lambda64__gvir_domain_resumed (GVirDomain* _sender, gpointer self) {
	____lambda64_ (self);
}


static void ____lambda65_ (BoxesLibvirtMachine* self) {
	GVirDomain* _tmp0_;
	gulong _tmp1_;
	_tmp0_ = self->domain;
	_tmp1_ = self->priv->started_id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	self->priv->started_id = (gulong) 0;
	boxes_machine_connect_display ((BoxesMachine*) self);
}


static void _____lambda65__gvir_domain_started (GVirDomain* _sender, gpointer self) {
	____lambda65_ (self);
}


static void boxes_libvirt_machine_real_connect_display (BoxesMachine* base) {
	BoxesLibvirtMachine * self;
	gboolean _tmp0_;
	GVirDomainState _tmp1_;
	GVirDomainState _tmp2_;
	GError * _inner_error_ = NULL;
	self = (BoxesLibvirtMachine*) base;
	_tmp0_ = ((BoxesMachine*) self)->_connect_display;
	if (_tmp0_) {
		boxes_libvirt_machine_update_display (self);
		return;
	}
	_tmp1_ = boxes_libvirt_machine_get_state (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GVIR_DOMAIN_STATE_RUNNING) {
		gulong _tmp3_;
		GVirDomainState _tmp4_;
		GVirDomainState _tmp5_;
		_tmp3_ = self->priv->started_id;
		if (_tmp3_ != ((gulong) 0)) {
			return;
		}
		_tmp4_ = boxes_libvirt_machine_get_state (self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == GVIR_DOMAIN_STATE_PAUSED) {
			GVirDomain* _tmp6_;
			gulong _tmp7_ = 0UL;
			_tmp6_ = self->domain;
			_tmp7_ = g_signal_connect_object (_tmp6_, "resumed", (GCallback) _____lambda64__gvir_domain_resumed, self, 0);
			self->priv->started_id = _tmp7_;
			{
				GVirDomain* _tmp8_;
				_tmp8_ = self->domain;
				gvir_domain_resume (_tmp8_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
			}
			goto __finally9;
			__catch9_g_error:
			{
				GError* _error_ = NULL;
				GError* _tmp9_;
				const gchar* _tmp10_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp9_ = _error_;
				_tmp10_ = _tmp9_->message;
				g_warning ("libvirt-machine.vala:47: %s", _tmp10_);
				_g_error_free0 (_error_);
			}
			__finally9:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			GVirDomain* _tmp11_;
			gulong _tmp12_ = 0UL;
			_tmp11_ = self->domain;
			_tmp12_ = g_signal_connect_object (_tmp11_, "started", (GCallback) _____lambda65__gvir_domain_started, self, 0);
			self->priv->started_id = _tmp12_;
			{
				GVirDomain* _tmp13_;
				_tmp13_ = self->domain;
				gvir_domain_start (_tmp13_, (guint) 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch10_g_error;
				}
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError* _error_ = NULL;
				GError* _tmp14_;
				const gchar* _tmp15_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp14_ = _error_;
				_tmp15_ = _tmp14_->message;
				g_warning ("libvirt-machine.vala:58: %s", _tmp15_);
				_g_error_free0 (_error_);
			}
			__finally10:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	((BoxesMachine*) self)->_connect_display = TRUE;
	boxes_libvirt_machine_update_display (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BoxesLibvirtMachine* boxes_libvirt_machine_construct (GType object_type, BoxesCollectionSource* source, BoxesApp* app, GVirConnection* connection, GVirDomain* domain) {
	BoxesLibvirtMachine * self = NULL;
	BoxesCollectionSource* _tmp0_;
	BoxesApp* _tmp1_;
	GVirDomain* _tmp2_;
	const gchar* _tmp3_ = NULL;
	BoxesCollectionSource* _tmp4_;
	GVirDomain* _tmp5_;
	const gchar* _tmp6_ = NULL;
	BoxesDisplayConfig* _tmp7_;
	GVirConnection* _tmp8_;
	GVirConnection* _tmp9_;
	GVirDomain* _tmp10_;
	GVirDomain* _tmp11_;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = source;
	_tmp1_ = app;
	_tmp2_ = domain;
	_tmp3_ = gvir_domain_get_name (_tmp2_);
	self = (BoxesLibvirtMachine*) boxes_machine_construct (object_type, _tmp0_, _tmp1_, _tmp3_);
	_tmp4_ = source;
	_tmp5_ = domain;
	_tmp6_ = gvir_domain_get_uuid (_tmp5_);
	_tmp7_ = boxes_display_config_new (_tmp4_, _tmp6_);
	_g_object_unref0 (((BoxesMachine*) self)->config);
	((BoxesMachine*) self)->config = _tmp7_;
	_tmp8_ = connection;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->connection);
	self->connection = _tmp9_;
	_tmp10_ = domain;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->domain);
	self->domain = _tmp11_;
	boxes_machine_set_screenshot_enable ((BoxesMachine*) self, TRUE);
	boxes_libvirt_machine_set_stats_enable (self, TRUE);
	return self;
}


BoxesLibvirtMachine* boxes_libvirt_machine_new (BoxesCollectionSource* source, BoxesApp* app, GVirConnection* connection, GVirDomain* domain) {
	return boxes_libvirt_machine_construct (BOXES_TYPE_LIBVIRT_MACHINE, source, app, connection, domain);
}


static void boxes_libvirt_machine_update_cpu_stat (BoxesLibvirtMachine* self, GVirDomainInfo* info, BoxesLibvirtMachineMachineStat* stat) {
	BoxesLibvirtMachineMachineStat* _tmp0_;
	gint _tmp0__length1;
	BoxesLibvirtMachineMachineStat _tmp1_;
	BoxesLibvirtMachineMachineStat _tmp2_ = {0};
	BoxesLibvirtMachineMachineStat prev;
	gboolean _tmp3_ = FALSE;
	GVirDomainInfo* _tmp4_;
	GVirDomainState _tmp5_;
	gboolean _tmp8_;
	GVirDomainInfo* _tmp9_;
	guint64 _tmp10_;
	BoxesLibvirtMachineMachineStat _tmp11_;
	gdouble _tmp12_;
	GVirDomainInfo* _tmp13_;
	guint64 _tmp14_;
	BoxesLibvirtMachineMachineStat _tmp15_;
	gint64 _tmp16_;
	BoxesLibvirtMachineMachineStat _tmp17_;
	gint64 _tmp18_;
	gint64 dt;
	BoxesLibvirtMachineMachineStat _tmp19_;
	gdouble _tmp20_;
	gint64 _tmp21_;
	gdouble percent;
	gdouble _tmp22_;
	GVirDomainInfo* _tmp23_;
	guint16 _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (stat != NULL);
	_tmp0_ = self->priv->stats;
	_tmp0__length1 = self->priv->stats_length1;
	_tmp1_ = _tmp0_[BOXES_LIBVIRT_MACHINE_STATS_SIZE - 1];
	boxes_libvirt_machine_machine_stat_copy (&_tmp1_, &_tmp2_);
	prev = _tmp2_;
	_tmp4_ = info;
	_tmp5_ = _tmp4_->state;
	if (_tmp5_ == GVIR_DOMAIN_STATE_CRASHED) {
		_tmp3_ = TRUE;
	} else {
		GVirDomainInfo* _tmp6_;
		GVirDomainState _tmp7_;
		_tmp6_ = info;
		_tmp7_ = _tmp6_->state;
		_tmp3_ = _tmp7_ == GVIR_DOMAIN_STATE_SHUTOFF;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		boxes_libvirt_machine_machine_stat_destroy (&prev);
		return;
	}
	_tmp9_ = info;
	_tmp10_ = _tmp9_->cpuTime;
	_tmp11_ = prev;
	_tmp12_ = _tmp11_.cpu_time_abs;
	(*stat).cpu_time = _tmp10_ - _tmp12_;
	_tmp13_ = info;
	_tmp14_ = _tmp13_->cpuTime;
	(*stat).cpu_time_abs = (gdouble) _tmp14_;
	_tmp15_ = *stat;
	_tmp16_ = _tmp15_.timestamp;
	_tmp17_ = prev;
	_tmp18_ = _tmp17_.timestamp;
	dt = (_tmp16_ - _tmp18_) * 10;
	_tmp19_ = *stat;
	_tmp20_ = _tmp19_.cpu_time;
	_tmp21_ = dt;
	percent = _tmp20_ / _tmp21_;
	_tmp22_ = percent;
	_tmp23_ = info;
	_tmp24_ = _tmp23_->nrVirtCpu;
	percent = _tmp22_ / _tmp24_;
	_tmp25_ = percent;
	_tmp26_ = CLAMP (_tmp25_, (gdouble) 0, (gdouble) 100);
	(*stat).cpu_guest_percent = _tmp26_;
	boxes_libvirt_machine_machine_stat_destroy (&prev);
}


static void boxes_libvirt_machine_update_mem_stat (BoxesLibvirtMachine* self, GVirDomainInfo* info, BoxesLibvirtMachineMachineStat* stat) {
	gboolean _tmp0_ = FALSE;
	GVirDomainInfo* _tmp1_;
	guint64 _tmp2_;
	GVirDomainInfo* _tmp3_;
	guint64 _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (stat != NULL);
	_tmp0_ = boxes_machine_is_running ((BoxesMachine*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = info;
	_tmp2_ = _tmp1_->memory;
	_tmp3_ = info;
	_tmp4_ = _tmp3_->maxMem;
	(*stat).memory_percent = (_tmp2_ * 100.0) / _tmp4_;
}


static void _vala_GVirDomainDiskStats_free (GVirDomainDiskStats* self) {
	g_boxed_free (gvir_domain_disk_stats_get_type (), self);
}


static void boxes_libvirt_machine_update_io_stat (BoxesLibvirtMachine* self, BoxesLibvirtMachineMachineStat* stat) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stat != NULL);
	_tmp0_ = boxes_machine_is_running ((BoxesMachine*) self);
	if (!_tmp0_) {
		return;
	}
	{
		GVirDomain* _tmp1_;
		GVirConfigDomain* _tmp2_ = NULL;
		GVirConfigDomain* _tmp3_;
		GVirConfigDomain* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* xmldoc;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* target_dev;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GVirDomain* _tmp11_;
		GObject* _tmp12_ = NULL;
		GObject* _tmp13_;
		GVirDomainDisk* disk;
		GVirDomainDisk* _tmp14_;
		GVirDomainDiskStats* _tmp15_ = NULL;
		GVirDomainDiskStats* _tmp16_;
		BoxesLibvirtMachineMachineStat* _tmp17_;
		gint _tmp17__length1;
		BoxesLibvirtMachineMachineStat _tmp18_;
		BoxesLibvirtMachineMachineStat _tmp19_ = {0};
		BoxesLibvirtMachineMachineStat prev;
		BoxesLibvirtMachineMachineStat _tmp20_;
		GVirDomainDiskStats* _tmp21_;
		_tmp1_ = self->domain;
		_tmp2_ = gvir_domain_get_config (_tmp1_, (guint) 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp4_ = _tmp3_;
		_tmp5_ = gvir_config_object_to_xml ((GVirConfigObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		xmldoc = _tmp6_;
		_tmp7_ = xmldoc;
		_tmp8_ = boxes_extract_xpath (_tmp7_, "string(/domain/devices/disk[@type='file']/target/@dev)", TRUE, &_inner_error_);
		target_dev = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_free0 (xmldoc);
			goto __catch11_g_error;
		}
		_tmp9_ = target_dev;
		if (g_strcmp0 (_tmp9_, "") == 0) {
			_g_free0 (target_dev);
			_g_free0 (xmldoc);
			return;
		}
		_tmp10_ = target_dev;
		_tmp11_ = self->domain;
		_tmp12_ = g_object_new (gvir_domain_disk_get_type (), "path", _tmp10_, "domain", _tmp11_, NULL);
		_tmp13_ = G_IS_INITIALLY_UNOWNED (_tmp12_) ? g_object_ref_sink (_tmp12_) : _tmp12_;
		disk = GVIR_IS_DOMAIN_DISK (_tmp13_) ? ((GVirDomainDisk*) _tmp13_) : NULL;
		_tmp14_ = disk;
		_tmp15_ = gvir_domain_disk_get_stats (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (disk);
			_g_free0 (target_dev);
			_g_free0 (xmldoc);
			goto __catch11_g_error;
		}
		__vala_GVirDomainDiskStats_free0 ((*stat).disk);
		(*stat).disk = _tmp16_;
		_tmp17_ = self->priv->stats;
		_tmp17__length1 = self->priv->stats_length1;
		_tmp18_ = _tmp17_[BOXES_LIBVIRT_MACHINE_STATS_SIZE - 1];
		boxes_libvirt_machine_machine_stat_copy (&_tmp18_, &_tmp19_);
		prev = _tmp19_;
		_tmp20_ = prev;
		_tmp21_ = _tmp20_.disk;
		if (_tmp21_ != NULL) {
			BoxesLibvirtMachineMachineStat _tmp22_;
			GVirDomainDiskStats* _tmp23_;
			gint64 _tmp24_;
			BoxesLibvirtMachineMachineStat _tmp25_;
			GVirDomainDiskStats* _tmp26_;
			gint64 _tmp27_;
			BoxesLibvirtMachineMachineStat _tmp28_;
			GVirDomainDiskStats* _tmp29_;
			gint64 _tmp30_;
			BoxesLibvirtMachineMachineStat _tmp31_;
			GVirDomainDiskStats* _tmp32_;
			gint64 _tmp33_;
			_tmp22_ = *stat;
			_tmp23_ = _tmp22_.disk;
			_tmp24_ = _tmp23_->rd_bytes;
			_tmp25_ = prev;
			_tmp26_ = _tmp25_.disk;
			_tmp27_ = _tmp26_->rd_bytes;
			(*stat).disk_read = (gdouble) (_tmp24_ - _tmp27_);
			_tmp28_ = *stat;
			_tmp29_ = _tmp28_.disk;
			_tmp30_ = _tmp29_->wr_bytes;
			_tmp31_ = prev;
			_tmp32_ = _tmp31_.disk;
			_tmp33_ = _tmp32_->wr_bytes;
			(*stat).disk_write = (gdouble) (_tmp30_ - _tmp33_);
		}
		boxes_libvirt_machine_machine_stat_destroy (&prev);
		_g_object_unref0 (disk);
		_g_free0 (target_dev);
		_g_free0 (xmldoc);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_GVirDomainInterfaceStats_free (GVirDomainInterfaceStats* self) {
	g_boxed_free (gvir_domain_interface_stats_get_type (), self);
}


static void boxes_libvirt_machine_update_net_stat (BoxesLibvirtMachine* self, BoxesLibvirtMachineMachineStat* stat) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stat != NULL);
	_tmp0_ = boxes_machine_is_running ((BoxesMachine*) self);
	if (!_tmp0_) {
		return;
	}
	{
		GVirDomain* _tmp1_;
		GVirConfigDomain* _tmp2_ = NULL;
		GVirConfigDomain* _tmp3_;
		GVirConfigDomain* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* xmldoc;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* target_dev;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GVirDomain* _tmp11_;
		GObject* _tmp12_ = NULL;
		GObject* _tmp13_;
		GVirDomainInterface* net;
		GVirDomainInterface* _tmp14_;
		GVirDomainInterfaceStats* _tmp15_ = NULL;
		GVirDomainInterfaceStats* _tmp16_;
		BoxesLibvirtMachineMachineStat* _tmp17_;
		gint _tmp17__length1;
		BoxesLibvirtMachineMachineStat _tmp18_;
		BoxesLibvirtMachineMachineStat _tmp19_ = {0};
		BoxesLibvirtMachineMachineStat prev;
		BoxesLibvirtMachineMachineStat _tmp20_;
		GVirDomainInterfaceStats* _tmp21_;
		_tmp1_ = self->domain;
		_tmp2_ = gvir_domain_get_config (_tmp1_, (guint) 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		_tmp4_ = _tmp3_;
		_tmp5_ = gvir_config_object_to_xml ((GVirConfigObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		xmldoc = _tmp6_;
		_tmp7_ = xmldoc;
		_tmp8_ = boxes_extract_xpath (_tmp7_, "string(/domain/devices/interface[@type='network']/target/@dev)", TRUE, &_inner_error_);
		target_dev = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_free0 (xmldoc);
			goto __catch12_g_error;
		}
		_tmp9_ = target_dev;
		if (g_strcmp0 (_tmp9_, "") == 0) {
			_g_free0 (target_dev);
			_g_free0 (xmldoc);
			return;
		}
		_tmp10_ = target_dev;
		_tmp11_ = self->domain;
		_tmp12_ = g_object_new (gvir_domain_interface_get_type (), "path", _tmp10_, "domain", _tmp11_, NULL);
		_tmp13_ = G_IS_INITIALLY_UNOWNED (_tmp12_) ? g_object_ref_sink (_tmp12_) : _tmp12_;
		net = GVIR_IS_DOMAIN_INTERFACE (_tmp13_) ? ((GVirDomainInterface*) _tmp13_) : NULL;
		_tmp14_ = net;
		_tmp15_ = gvir_domain_interface_get_stats (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (net);
			_g_free0 (target_dev);
			_g_free0 (xmldoc);
			goto __catch12_g_error;
		}
		__vala_GVirDomainInterfaceStats_free0 ((*stat).net);
		(*stat).net = _tmp16_;
		_tmp17_ = self->priv->stats;
		_tmp17__length1 = self->priv->stats_length1;
		_tmp18_ = _tmp17_[BOXES_LIBVIRT_MACHINE_STATS_SIZE - 1];
		boxes_libvirt_machine_machine_stat_copy (&_tmp18_, &_tmp19_);
		prev = _tmp19_;
		_tmp20_ = prev;
		_tmp21_ = _tmp20_.net;
		if (_tmp21_ != NULL) {
			BoxesLibvirtMachineMachineStat _tmp22_;
			GVirDomainInterfaceStats* _tmp23_;
			gint64 _tmp24_;
			BoxesLibvirtMachineMachineStat _tmp25_;
			GVirDomainInterfaceStats* _tmp26_;
			gint64 _tmp27_;
			BoxesLibvirtMachineMachineStat _tmp28_;
			GVirDomainInterfaceStats* _tmp29_;
			gint64 _tmp30_;
			BoxesLibvirtMachineMachineStat _tmp31_;
			GVirDomainInterfaceStats* _tmp32_;
			gint64 _tmp33_;
			_tmp22_ = *stat;
			_tmp23_ = _tmp22_.net;
			_tmp24_ = _tmp23_->rx_bytes;
			_tmp25_ = prev;
			_tmp26_ = _tmp25_.net;
			_tmp27_ = _tmp26_->rx_bytes;
			(*stat).net_read = (gdouble) (_tmp24_ - _tmp27_);
			_tmp28_ = *stat;
			_tmp29_ = _tmp28_.net;
			_tmp30_ = _tmp29_->tx_bytes;
			_tmp31_ = prev;
			_tmp32_ = _tmp31_.net;
			_tmp33_ = _tmp32_->tx_bytes;
			(*stat).net_write = (gdouble) (_tmp30_ - _tmp33_);
		}
		boxes_libvirt_machine_machine_stat_destroy (&prev);
		_g_object_unref0 (net);
		_g_free0 (target_dev);
		_g_free0 (xmldoc);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static BoxesLibvirtMachineMachineStat* _vala_array_dup2 (BoxesLibvirtMachineMachineStat* self, int length) {
	BoxesLibvirtMachineMachineStat* result;
	int i;
	result = g_new0 (BoxesLibvirtMachineMachineStat, length);
	for (i = 0; i < length; i++) {
		BoxesLibvirtMachineMachineStat _tmp0_ = {0};
		boxes_libvirt_machine_machine_stat_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add2 (BoxesLibvirtMachineMachineStat** array, int* length, int* size, const BoxesLibvirtMachineMachineStat* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BoxesLibvirtMachineMachineStat, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_GVirDomainInfo_free (GVirDomainInfo* self) {
	g_boxed_free (gvir_domain_info_get_type (), self);
}


static void _vala_array_add3 (gdouble** array, int* length, int* size, gdouble value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gdouble, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (gdouble** array, int* length, int* size, gdouble value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gdouble, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add5 (gdouble** array, int* length, int* size, gdouble value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gdouble, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void boxes_libvirt_machine_update_stats (BoxesLibvirtMachine* self) {
	gdouble* _tmp11_ = NULL;
	gdouble* _tmp12_ = NULL;
	gdouble* _tmp13_ = NULL;
	BoxesLibvirtMachineMachineStat* _tmp14_;
	gint _tmp14__length1;
	BoxesLibvirtMachineMachineStat* _tmp19_;
	gint _tmp19__length1;
	BoxesLibvirtMachineMachineStat* _tmp26_;
	gint _tmp26__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint64 _tmp0_ = 0LL;
		gint64 now;
		BoxesLibvirtMachineMachineStat _tmp1_ = {0};
		BoxesLibvirtMachineMachineStat stat;
		GVirDomain* _tmp2_;
		GVirDomainInfo* _tmp3_ = NULL;
		GVirDomainInfo* info;
		BoxesLibvirtMachineMachineStat* _tmp4_;
		gint _tmp4__length1;
		BoxesLibvirtMachineMachineStat* _tmp5_;
		gint _tmp5__length1;
		BoxesLibvirtMachineMachineStat* _tmp6_;
		gint _tmp6__length1;
		BoxesLibvirtMachineMachineStat _tmp7_;
		BoxesLibvirtMachineMachineStat _tmp8_ = {0};
		_tmp0_ = g_get_monotonic_time ();
		now = _tmp0_;
		memset (&_tmp1_, 0, sizeof (BoxesLibvirtMachineMachineStat));
		_tmp1_.timestamp = now;
		stat = _tmp1_;
		_tmp2_ = self->domain;
		_tmp3_ = gvir_domain_get_info (_tmp2_, &_inner_error_);
		info = _tmp3_;
		if (_inner_error_ != NULL) {
			boxes_libvirt_machine_machine_stat_destroy (&stat);
			goto __catch13_g_error;
		}
		boxes_libvirt_machine_update_cpu_stat (self, info, &stat);
		boxes_libvirt_machine_update_mem_stat (self, info, &stat);
		boxes_libvirt_machine_update_io_stat (self, &stat);
		boxes_libvirt_machine_update_net_stat (self, &stat);
		_tmp4_ = self->priv->stats;
		_tmp4__length1 = self->priv->stats_length1;
		_tmp5_ = ((_tmp4_ + 1) != NULL) ? _vala_array_dup2 (_tmp4_ + 1, BOXES_LIBVIRT_MACHINE_STATS_SIZE - 1) : ((gpointer) (_tmp4_ + 1));
		_tmp5__length1 = BOXES_LIBVIRT_MACHINE_STATS_SIZE - 1;
		self->priv->stats = (_vala_BoxesLibvirtMachineMachineStat_array_free (self->priv->stats, self->priv->stats_length1), NULL);
		self->priv->stats = _tmp5_;
		self->priv->stats_length1 = _tmp5__length1;
		self->priv->_stats_size_ = self->priv->stats_length1;
		_tmp6_ = self->priv->stats;
		_tmp6__length1 = self->priv->stats_length1;
		_tmp7_ = stat;
		boxes_libvirt_machine_machine_stat_copy (&_tmp7_, &_tmp8_);
		_vala_array_add2 (&self->priv->stats, &self->priv->stats_length1, &self->priv->_stats_size_, &_tmp8_);
		__vala_GVirDomainInfo_free0 (info);
		boxes_libvirt_machine_machine_stat_destroy (&stat);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("libvirt-machine.vala:193: %s", _tmp10_);
		_g_error_free0 (err);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = g_new0 (gdouble, 0);
	self->cpu_stats = (g_free (self->cpu_stats), NULL);
	self->cpu_stats = _tmp11_;
	self->cpu_stats_length1 = 0;
	self->_cpu_stats_size_ = self->cpu_stats_length1;
	_tmp12_ = g_new0 (gdouble, 0);
	self->io_stats = (g_free (self->io_stats), NULL);
	self->io_stats = _tmp12_;
	self->io_stats_length1 = 0;
	self->_io_stats_size_ = self->io_stats_length1;
	_tmp13_ = g_new0 (gdouble, 0);
	self->net_stats = (g_free (self->net_stats), NULL);
	self->net_stats = _tmp13_;
	self->net_stats_length1 = 0;
	self->_net_stats_size_ = self->net_stats_length1;
	_tmp14_ = self->priv->stats;
	_tmp14__length1 = self->priv->stats_length1;
	{
		BoxesLibvirtMachineMachineStat* s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp14_;
		s_collection_length1 = _tmp14__length1;
		for (s_it = 0; s_it < _tmp14__length1; s_it = s_it + 1) {
			BoxesLibvirtMachineMachineStat _tmp15_ = {0};
			BoxesLibvirtMachineMachineStat s = {0};
			boxes_libvirt_machine_machine_stat_copy (&s_collection[s_it], &_tmp15_);
			s = _tmp15_;
			{
				gdouble* _tmp16_;
				gint _tmp16__length1;
				BoxesLibvirtMachineMachineStat _tmp17_;
				gdouble _tmp18_;
				_tmp16_ = self->cpu_stats;
				_tmp16__length1 = self->cpu_stats_length1;
				_tmp17_ = s;
				_tmp18_ = _tmp17_.cpu_guest_percent;
				_vala_array_add3 (&self->cpu_stats, &self->cpu_stats_length1, &self->_cpu_stats_size_, _tmp18_);
				boxes_libvirt_machine_machine_stat_destroy (&s);
			}
		}
	}
	_tmp19_ = self->priv->stats;
	_tmp19__length1 = self->priv->stats_length1;
	{
		BoxesLibvirtMachineMachineStat* s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp19_;
		s_collection_length1 = _tmp19__length1;
		for (s_it = 0; s_it < _tmp19__length1; s_it = s_it + 1) {
			BoxesLibvirtMachineMachineStat _tmp20_ = {0};
			BoxesLibvirtMachineMachineStat s = {0};
			boxes_libvirt_machine_machine_stat_copy (&s_collection[s_it], &_tmp20_);
			s = _tmp20_;
			{
				gdouble* _tmp21_;
				gint _tmp21__length1;
				BoxesLibvirtMachineMachineStat _tmp22_;
				gdouble _tmp23_;
				BoxesLibvirtMachineMachineStat _tmp24_;
				gdouble _tmp25_;
				_tmp21_ = self->net_stats;
				_tmp21__length1 = self->net_stats_length1;
				_tmp22_ = s;
				_tmp23_ = _tmp22_.net_read;
				_tmp24_ = s;
				_tmp25_ = _tmp24_.net_write;
				_vala_array_add4 (&self->net_stats, &self->net_stats_length1, &self->_net_stats_size_, _tmp23_ + _tmp25_);
				boxes_libvirt_machine_machine_stat_destroy (&s);
			}
		}
	}
	_tmp26_ = self->priv->stats;
	_tmp26__length1 = self->priv->stats_length1;
	{
		BoxesLibvirtMachineMachineStat* s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp26_;
		s_collection_length1 = _tmp26__length1;
		for (s_it = 0; s_it < _tmp26__length1; s_it = s_it + 1) {
			BoxesLibvirtMachineMachineStat _tmp27_ = {0};
			BoxesLibvirtMachineMachineStat s = {0};
			boxes_libvirt_machine_machine_stat_copy (&s_collection[s_it], &_tmp27_);
			s = _tmp27_;
			{
				gdouble* _tmp28_;
				gint _tmp28__length1;
				BoxesLibvirtMachineMachineStat _tmp29_;
				gdouble _tmp30_;
				BoxesLibvirtMachineMachineStat _tmp31_;
				gdouble _tmp32_;
				_tmp28_ = self->io_stats;
				_tmp28__length1 = self->io_stats_length1;
				_tmp29_ = s;
				_tmp30_ = _tmp29_.disk_read;
				_tmp31_ = s;
				_tmp32_ = _tmp31_.disk_write;
				_vala_array_add5 (&self->io_stats, &self->io_stats_length1, &self->_io_stats_size_, _tmp30_ + _tmp32_);
				boxes_libvirt_machine_machine_stat_destroy (&s);
			}
		}
	}
	g_signal_emit_by_name (self, "stats-updated");
}


static gboolean ___lambda66_ (BoxesLibvirtMachine* self) {
	gboolean result = FALSE;
	boxes_libvirt_machine_update_stats (self);
	result = TRUE;
	return result;
}


static gboolean ____lambda66__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda66_ (self);
	return result;
}


static void boxes_libvirt_machine_set_stats_enable (BoxesLibvirtMachine* self, gboolean enable) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = enable;
	if (_tmp0_) {
		guint _tmp1_;
		guint _tmp2_ = 0U;
		_tmp1_ = self->priv->stats_id;
		if (_tmp1_ != ((guint) 0)) {
			return;
		}
		_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda66__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->stats_id = _tmp2_;
	} else {
		guint _tmp3_;
		_tmp3_ = self->priv->stats_id;
		if (_tmp3_ != ((guint) 0)) {
			guint _tmp4_;
			_tmp4_ = self->priv->stats_id;
			g_source_remove (_tmp4_);
		}
		self->priv->stats_id = (guint) 0;
	}
}


static void _boxes_pair_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (boxes_pair_unref (var), NULL));
}


static void _g_list_free__boxes_pair_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _boxes_pair_unref0_, NULL);
	g_list_free (self);
}


static GList* boxes_libvirt_machine_real_get_properties (BoxesMachine* base, BoxesPropertiesPage page) {
	BoxesLibvirtMachine * self;
	GList* result = NULL;
	GList* list;
	BoxesPropertiesPage _tmp0_;
	BoxesDisplay* _tmp17_;
	BoxesDisplay* _tmp18_;
	BoxesPropertiesPage _tmp19_;
	GList* _tmp20_ = NULL;
	self = (BoxesLibvirtMachine*) base;
	list = NULL;
	_tmp0_ = page;
	switch (_tmp0_) {
		case BOXES_PROPERTIES_PAGE_LOGIN:
		{
			const gchar* _tmp1_ = NULL;
			BoxesCollectionSource* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_ = NULL;
			BoxesDisplay* _tmp7_;
			BoxesDisplay* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp1_ = _ ("Virtualizer");
			_tmp2_ = ((BoxesMachine*) self)->source;
			_tmp3_ = boxes_collection_source_get_uri (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			boxes_iproperties_add_string_property ((BoxesIProperties*) self, &list, _tmp1_, _tmp5_, NULL, NULL);
			_g_free0 (_tmp5_);
			_tmp6_ = _ ("URI");
			_tmp7_ = boxes_machine_get_display ((BoxesMachine*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = boxes_display_get_uri (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_;
			boxes_iproperties_add_string_property ((BoxesIProperties*) self, &list, _tmp6_, _tmp11_, NULL, NULL);
			_g_free0 (_tmp11_);
			break;
		}
		case BOXES_PROPERTIES_PAGE_DISPLAY:
		{
			const gchar* _tmp12_ = NULL;
			BoxesDisplay* _tmp13_;
			BoxesDisplay* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp12_ = _ ("Protocol");
			_tmp13_ = boxes_machine_get_display ((BoxesMachine*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = boxes_display_get_protocol (_tmp14_);
			_tmp16_ = _tmp15_;
			boxes_iproperties_add_string_property ((BoxesIProperties*) self, &list, _tmp12_, _tmp16_, NULL, NULL);
			break;
		}
		default:
		break;
	}
	_tmp17_ = boxes_machine_get_display ((BoxesMachine*) self);
	_tmp18_ = _tmp17_;
	_tmp19_ = page;
	_tmp20_ = boxes_display_get_properties (_tmp18_, _tmp19_);
	list = g_list_concat (list, _tmp20_);
	result = list;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void boxes_libvirt_machine_update_display (BoxesLibvirtMachine* self) {
	gchar* type = NULL;
	gchar* port = NULL;
	gchar* socket = NULL;
	gchar* host = NULL;
	gboolean _tmp0_;
	BoxesDisplay* _tmp36_;
	BoxesDisplay* _tmp37_;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_;
	gboolean _tmp43_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GQuark _tmp48_ = 0U;
	static GQuark _tmp47_label0 = 0;
	static GQuark _tmp47_label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((BoxesMachine*) self)->_connect_display;
	g_return_if_fail (_tmp0_ == TRUE);
	{
		GVirDomain* _tmp1_;
		GVirConfigDomain* _tmp2_ = NULL;
		GVirConfigDomain* _tmp3_;
		GVirConfigDomain* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* xmldoc;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp1_ = self->domain;
		_tmp2_ = gvir_domain_get_config (_tmp1_, (guint) 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_tmp4_ = _tmp3_;
		_tmp5_ = gvir_config_object_to_xml ((GVirConfigObject*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		xmldoc = _tmp6_;
		_tmp7_ = xmldoc;
		_tmp8_ = boxes_extract_xpath (_tmp7_, "string(/domain/devices/graphics/@type)", TRUE, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_free0 (xmldoc);
			goto __catch14_g_error;
		}
		_g_free0 (type);
		type = _tmp9_;
		_tmp10_ = xmldoc;
		_tmp11_ = type;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("string(/domain/devices/graphics[@type='", _tmp12_, "']/@port)", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = boxes_extract_xpath (_tmp10_, _tmp14_, FALSE, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			_g_free0 (xmldoc);
			goto __catch14_g_error;
		}
		_g_free0 (port);
		port = _tmp17_;
		_tmp18_ = xmldoc;
		_tmp19_ = type;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat ("string(/domain/devices/graphics[@type='", _tmp20_, "']/@socket)", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = boxes_extract_xpath (_tmp18_, _tmp22_, FALSE, &_inner_error_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_tmp25_ = _tmp24_;
		if (_inner_error_ != NULL) {
			_g_free0 (xmldoc);
			goto __catch14_g_error;
		}
		_g_free0 (socket);
		socket = _tmp25_;
		_tmp26_ = xmldoc;
		_tmp27_ = type;
		_tmp28_ = string_to_string (_tmp27_);
		_tmp29_ = g_strconcat ("string(/domain/devices/graphics[@type='", _tmp28_, "']/@listen)", NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = boxes_extract_xpath (_tmp26_, _tmp30_, FALSE, &_inner_error_);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		_tmp33_ = _tmp32_;
		if (_inner_error_ != NULL) {
			_g_free0 (xmldoc);
			goto __catch14_g_error;
		}
		_g_free0 (host);
		host = _tmp33_;
		_g_free0 (xmldoc);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp34_ = _error_;
		_tmp35_ = _tmp34_->message;
		g_warning ("libvirt-machine.vala:261: %s", _tmp35_);
		_g_error_free0 (_error_);
		_g_free0 (host);
		_g_free0 (socket);
		_g_free0 (port);
		_g_free0 (type);
		return;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_free0 (host);
		_g_free0 (socket);
		_g_free0 (port);
		_g_free0 (type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp36_ = boxes_machine_get_display ((BoxesMachine*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		BoxesDisplay* _tmp38_;
		BoxesDisplay* _tmp39_;
		_tmp38_ = boxes_machine_get_display ((BoxesMachine*) self);
		_tmp39_ = _tmp38_;
		boxes_display_disconnect_it (_tmp39_);
	}
	_tmp41_ = host;
	if (_tmp41_ == NULL) {
		_tmp40_ = TRUE;
	} else {
		const gchar* _tmp42_;
		_tmp42_ = host;
		_tmp40_ = g_strcmp0 (_tmp42_, "") == 0;
	}
	_tmp43_ = _tmp40_;
	if (_tmp43_) {
		gchar* _tmp44_;
		_tmp44_ = g_strdup ("localhost");
		_g_free0 (host);
		host = _tmp44_;
	}
	_tmp45_ = type;
	_tmp46_ = _tmp45_;
	_tmp48_ = (NULL == _tmp46_) ? 0 : g_quark_from_string (_tmp46_);
	if (_tmp48_ == ((0 != _tmp47_label0) ? _tmp47_label0 : (_tmp47_label0 = g_quark_from_static_string ("spice")))) {
		switch (0) {
			default:
			{
				BoxesDisplayConfig* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				gint _tmp52_ = 0;
				BoxesSpiceDisplay* _tmp53_;
				BoxesSpiceDisplay* _tmp54_;
				_tmp49_ = ((BoxesMachine*) self)->config;
				_tmp50_ = host;
				_tmp51_ = port;
				_tmp52_ = atoi (_tmp51_);
				_tmp53_ = boxes_spice_display_new (_tmp49_, _tmp50_, _tmp52_);
				_tmp54_ = _tmp53_;
				boxes_machine_set_display ((BoxesMachine*) self, (BoxesDisplay*) _tmp54_);
				_g_object_unref0 (_tmp54_);
				break;
			}
		}
	} else if (_tmp48_ == ((0 != _tmp47_label1) ? _tmp47_label1 : (_tmp47_label1 = g_quark_from_static_string ("vnc")))) {
		switch (0) {
			default:
			{
				BoxesDisplayConfig* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				gint _tmp58_ = 0;
				BoxesVncDisplay* _tmp59_;
				BoxesVncDisplay* _tmp60_;
				_tmp55_ = ((BoxesMachine*) self)->config;
				_tmp56_ = host;
				_tmp57_ = port;
				_tmp58_ = atoi (_tmp57_);
				_tmp59_ = boxes_vnc_display_new (_tmp55_, _tmp56_, _tmp58_);
				_tmp60_ = _tmp59_;
				boxes_machine_set_display ((BoxesMachine*) self, (BoxesDisplay*) _tmp60_);
				_g_object_unref0 (_tmp60_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp61_ = type;
				_tmp62_ = g_strconcat ("unsupported display of type ", _tmp61_, NULL);
				_tmp63_ = _tmp62_;
				g_warning ("libvirt-machine.vala:281: %s", _tmp63_);
				_g_free0 (_tmp63_);
				break;
			}
		}
	}
	_g_free0 (host);
	_g_free0 (socket);
	_g_free0 (port);
	_g_free0 (type);
}


static gchar* boxes_libvirt_machine_real_get_screenshot_prefix (BoxesMachine* base) {
	BoxesLibvirtMachine * self;
	gchar* result = NULL;
	GVirDomain* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self = (BoxesLibvirtMachine*) base;
	_tmp0_ = self->domain;
	_tmp1_ = gvir_domain_get_uuid (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean boxes_libvirt_machine_real_is_running (BoxesMachine* base) {
	BoxesLibvirtMachine * self;
	gboolean result = FALSE;
	GVirDomainState _tmp0_;
	GVirDomainState _tmp1_;
	self = (BoxesLibvirtMachine*) base;
	_tmp0_ = boxes_libvirt_machine_get_state (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GVIR_DOMAIN_STATE_RUNNING;
	return result;
}


static void boxes_libvirt_machine_real_take_screenshot_data_free (gpointer _data) {
	BoxesLibvirtMachineTakeScreenshotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesLibvirtMachineTakeScreenshotData, _data_);
}


static void boxes_libvirt_machine_real_take_screenshot (BoxesMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesLibvirtMachine * self;
	BoxesLibvirtMachineTakeScreenshotData* _data_;
	BoxesLibvirtMachine* _tmp0_;
	self = (BoxesLibvirtMachine*) base;
	_data_ = g_slice_new0 (BoxesLibvirtMachineTakeScreenshotData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_libvirt_machine_real_take_screenshot);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_libvirt_machine_real_take_screenshot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_libvirt_machine_real_take_screenshot_co (_data_);
}


static gboolean boxes_libvirt_machine_real_take_screenshot_finish (BoxesMachine* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	BoxesLibvirtMachineTakeScreenshotData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void boxes_libvirt_machine_take_screenshot_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesLibvirtMachineTakeScreenshotData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_libvirt_machine_real_take_screenshot_co (_data_);
}


static gboolean boxes_libvirt_machine_real_take_screenshot_co (BoxesLibvirtMachineTakeScreenshotData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = boxes_libvirt_machine_get_state (_data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ != GVIR_DOMAIN_STATE_RUNNING) {
		_data_->_tmp3_ = boxes_libvirt_machine_get_state (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = _data_->_tmp4_ != GVIR_DOMAIN_STATE_PAUSED;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp0_;
	if (_data_->_tmp5_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->connection;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = gvir_connection_get_stream (_data_->_tmp6_, (guint) 0);
	_data_->stream = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = boxes_machine_get_screenshot_filename ((BoxesMachine*) _data_->self, "ppm");
	_data_->file_name = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->file_name;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
	_data_->file = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->file;
	_data_->_state_ = 1;
	g_file_replace_async (_data_->_tmp11_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, boxes_libvirt_machine_take_screenshot_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_file_replace_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
	_data_->output_stream = _data_->_tmp12_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->file_name);
		_g_object_unref0 (_data_->stream);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->stream;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_io_stream_get_input_stream ((GIOStream*) _data_->_tmp13_);
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
	_data_->input_stream = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->self->domain;
	_data_->_tmp17_ = _data_->stream;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = gvir_domain_screenshot (_data_->_tmp16_, _data_->_tmp17_, (guint) 0, (guint) 0, &_data_->_inner_error_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_g_free0 (_data_->_tmp19_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->input_stream);
		_g_object_unref0 (_data_->output_stream);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->file_name);
		_g_object_unref0 (_data_->stream);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_new0 (guint8, 65535);
	_data_->buffer = _data_->_tmp20_;
	_data_->buffer_length1 = 65535;
	_data_->_buffer_size_ = _data_->buffer_length1;
	_data_->length = (gssize) 0;
	{
		_data_->_tmp21_ = TRUE;
		while (TRUE) {
			_data_->_tmp22_ = _data_->_tmp21_;
			if (!_data_->_tmp22_) {
				_data_->_tmp23_ = _data_->length;
				if (!(_data_->_tmp23_ > ((gssize) 0))) {
					break;
				}
			}
			_data_->_tmp21_ = FALSE;
			_data_->_tmp24_ = _data_->input_stream;
			_data_->_tmp25_ = _data_->buffer;
			_data_->_tmp25__length1 = _data_->buffer_length1;
			_data_->_state_ = 2;
			g_input_stream_read_async (_data_->_tmp24_, _data_->_tmp25_, (gsize) _data_->_tmp25__length1, G_PRIORITY_DEFAULT, NULL, boxes_libvirt_machine_take_screenshot_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp26_ = 0L;
			_data_->_tmp26_ = g_input_stream_read_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp27_ = _data_->_tmp26_;
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_data_->buffer = (g_free (_data_->buffer), NULL);
				_g_object_unref0 (_data_->input_stream);
				_g_object_unref0 (_data_->output_stream);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->file_name);
				_g_object_unref0 (_data_->stream);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->length = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->output_stream;
			_data_->_tmp29_ = _data_->buffer;
			_data_->_tmp29__length1 = _data_->buffer_length1;
			_data_->_tmp30_ = _data_->length;
			_data_->_state_ = 3;
			boxes_output_stream_write ((GOutputStream*) _data_->_tmp28_, _data_->_tmp29_ + 0, _data_->_tmp30_ - 0, boxes_libvirt_machine_take_screenshot_ready, _data_);
			return FALSE;
			_state_3:
			boxes_output_stream_write_finish (_data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_data_->buffer = (g_free (_data_->buffer), NULL);
				_g_object_unref0 (_data_->input_stream);
				_g_object_unref0 (_data_->output_stream);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->file_name);
				_g_object_unref0 (_data_->stream);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = TRUE;
	_data_->buffer = (g_free (_data_->buffer), NULL);
	_g_object_unref0 (_data_->input_stream);
	_g_object_unref0 (_data_->output_stream);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->file_name);
	_g_object_unref0 (_data_->stream);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->buffer = (g_free (_data_->buffer), NULL);
	_g_object_unref0 (_data_->input_stream);
	_g_object_unref0 (_data_->output_stream);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->file_name);
	_g_object_unref0 (_data_->stream);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_libvirt_machine_real_delete (BoxesMachine* base, gboolean by_user) {
	BoxesLibvirtMachine * self;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	self = (BoxesLibvirtMachine*) base;
	_tmp0_ = by_user;
	if (_tmp0_) {
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = boxes_machine_is_running ((BoxesMachine*) self);
			if (_tmp1_) {
				GVirDomain* _tmp2_;
				_tmp2_ = self->domain;
				gvir_domain_stop (_tmp2_, (guint) 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch15_g_error;
				}
			}
		}
		goto __finally15;
		__catch15_g_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			GVirDomain* _tmp3_;
			_tmp3_ = self->domain;
			gvir_domain_delete (_tmp3_, (guint) 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch16_g_error;
			}
		}
		goto __finally16;
		__catch16_g_error:
		{
			GError* err = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = err;
			_tmp5_ = _tmp4_->message;
			g_warning ("libvirt-machine.vala:328: %s", _tmp5_);
			_g_error_free0 (err);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	boxes_libvirt_machine_set_stats_enable (self, FALSE);
}


GVirDomainState boxes_libvirt_machine_get_state (BoxesLibvirtMachine* self) {
	GVirDomainState result;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GVirDomain* _tmp0_;
		GVirDomainInfo* _tmp1_ = NULL;
		GVirDomainInfo* _tmp2_;
		GVirDomainInfo* _tmp3_;
		GVirDomainState _tmp4_;
		GVirDomainState _tmp5_;
		_tmp0_ = self->domain;
		_tmp1_ = gvir_domain_get_info (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->state;
		_tmp5_ = _tmp4_;
		__vala_GVirDomainInfo_free0 (_tmp3_);
		result = _tmp5_;
		return result;
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		result = GVIR_DOMAIN_STATE_NONE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally17:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static GObject * boxes_libvirt_machine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BoxesLibvirtMachine * self;
	BoxesLibvirtMachineMachineStat* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (boxes_libvirt_machine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = BOXES_LIBVIRT_MACHINE (obj);
	_tmp0_ = g_new0 (BoxesLibvirtMachineMachineStat, BOXES_LIBVIRT_MACHINE_STATS_SIZE);
	self->priv->stats = (_vala_BoxesLibvirtMachineMachineStat_array_free (self->priv->stats, self->priv->stats_length1), NULL);
	self->priv->stats = _tmp0_;
	self->priv->stats_length1 = BOXES_LIBVIRT_MACHINE_STATS_SIZE;
	self->priv->_stats_size_ = self->priv->stats_length1;
	return obj;
}


static GVirDomainDiskStats* _vala_GVirDomainDiskStats_copy (GVirDomainDiskStats* self) {
	return g_boxed_copy (gvir_domain_disk_stats_get_type (), self);
}


static gpointer __vala_GVirDomainDiskStats_copy0 (gpointer self) {
	return self ? _vala_GVirDomainDiskStats_copy (self) : NULL;
}


static GVirDomainInterfaceStats* _vala_GVirDomainInterfaceStats_copy (GVirDomainInterfaceStats* self) {
	return g_boxed_copy (gvir_domain_interface_stats_get_type (), self);
}


static gpointer __vala_GVirDomainInterfaceStats_copy0 (gpointer self) {
	return self ? _vala_GVirDomainInterfaceStats_copy (self) : NULL;
}


static void boxes_libvirt_machine_machine_stat_copy (const BoxesLibvirtMachineMachineStat* self, BoxesLibvirtMachineMachineStat* dest) {
	gint64 _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	GVirDomainDiskStats* _tmp5_;
	GVirDomainDiskStats* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GVirDomainInterfaceStats* _tmp9_;
	GVirDomainInterfaceStats* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	_tmp0_ = (*self).timestamp;
	(*dest).timestamp = _tmp0_;
	_tmp1_ = (*self).cpu_time;
	(*dest).cpu_time = _tmp1_;
	_tmp2_ = (*self).cpu_time_abs;
	(*dest).cpu_time_abs = _tmp2_;
	_tmp3_ = (*self).cpu_guest_percent;
	(*dest).cpu_guest_percent = _tmp3_;
	_tmp4_ = (*self).memory_percent;
	(*dest).memory_percent = _tmp4_;
	_tmp5_ = (*self).disk;
	_tmp6_ = __vala_GVirDomainDiskStats_copy0 (_tmp5_);
	__vala_GVirDomainDiskStats_free0 ((*dest).disk);
	(*dest).disk = _tmp6_;
	_tmp7_ = (*self).disk_read;
	(*dest).disk_read = _tmp7_;
	_tmp8_ = (*self).disk_write;
	(*dest).disk_write = _tmp8_;
	_tmp9_ = (*self).net;
	_tmp10_ = __vala_GVirDomainInterfaceStats_copy0 (_tmp9_);
	__vala_GVirDomainInterfaceStats_free0 ((*dest).net);
	(*dest).net = _tmp10_;
	_tmp11_ = (*self).net_read;
	(*dest).net_read = _tmp11_;
	_tmp12_ = (*self).net_write;
	(*dest).net_write = _tmp12_;
}


static void boxes_libvirt_machine_machine_stat_destroy (BoxesLibvirtMachineMachineStat* self) {
	__vala_GVirDomainDiskStats_free0 ((*self).disk);
	__vala_GVirDomainInterfaceStats_free0 ((*self).net);
}


static BoxesLibvirtMachineMachineStat* boxes_libvirt_machine_machine_stat_dup (const BoxesLibvirtMachineMachineStat* self) {
	BoxesLibvirtMachineMachineStat* dup;
	dup = g_new0 (BoxesLibvirtMachineMachineStat, 1);
	boxes_libvirt_machine_machine_stat_copy (self, dup);
	return dup;
}


static void boxes_libvirt_machine_machine_stat_free (BoxesLibvirtMachineMachineStat* self) {
	boxes_libvirt_machine_machine_stat_destroy (self);
	g_free (self);
}


static GType boxes_libvirt_machine_machine_stat_get_type (void) {
	static volatile gsize boxes_libvirt_machine_machine_stat_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_libvirt_machine_machine_stat_type_id__volatile)) {
		GType boxes_libvirt_machine_machine_stat_type_id;
		boxes_libvirt_machine_machine_stat_type_id = g_boxed_type_register_static ("BoxesLibvirtMachineMachineStat", (GBoxedCopyFunc) boxes_libvirt_machine_machine_stat_dup, (GBoxedFreeFunc) boxes_libvirt_machine_machine_stat_free);
		g_once_init_leave (&boxes_libvirt_machine_machine_stat_type_id__volatile, boxes_libvirt_machine_machine_stat_type_id);
	}
	return boxes_libvirt_machine_machine_stat_type_id__volatile;
}


static void boxes_libvirt_machine_class_init (BoxesLibvirtMachineClass * klass) {
	boxes_libvirt_machine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesLibvirtMachinePrivate));
	BOXES_MACHINE_CLASS (klass)->disconnect_display = boxes_libvirt_machine_real_disconnect_display;
	BOXES_MACHINE_CLASS (klass)->connect_display = boxes_libvirt_machine_real_connect_display;
	BOXES_MACHINE_CLASS (klass)->get_properties = boxes_libvirt_machine_real_get_properties;
	BOXES_MACHINE_CLASS (klass)->get_screenshot_prefix = boxes_libvirt_machine_real_get_screenshot_prefix;
	BOXES_MACHINE_CLASS (klass)->is_running = boxes_libvirt_machine_real_is_running;
	BOXES_MACHINE_CLASS (klass)->take_screenshot = boxes_libvirt_machine_real_take_screenshot;
	BOXES_MACHINE_CLASS (klass)->take_screenshot_finish = boxes_libvirt_machine_real_take_screenshot_finish;
	BOXES_MACHINE_CLASS (klass)->delete = boxes_libvirt_machine_real_delete;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_libvirt_machine_get_property;
	G_OBJECT_CLASS (klass)->constructor = boxes_libvirt_machine_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_libvirt_machine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_LIBVIRT_MACHINE_STATE, g_param_spec_enum ("state", "state", "state", GVIR_TYPE_DOMAIN_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("stats_updated", BOXES_TYPE_LIBVIRT_MACHINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void boxes_libvirt_machine_instance_init (BoxesLibvirtMachine * self) {
	self->priv = BOXES_LIBVIRT_MACHINE_GET_PRIVATE (self);
}


static void boxes_libvirt_machine_finalize (GObject* obj) {
	BoxesLibvirtMachine * self;
	self = BOXES_LIBVIRT_MACHINE (obj);
	_g_object_unref0 (self->domain);
	_g_object_unref0 (self->connection);
	self->priv->stats = (_vala_BoxesLibvirtMachineMachineStat_array_free (self->priv->stats, self->priv->stats_length1), NULL);
	self->cpu_stats = (g_free (self->cpu_stats), NULL);
	self->io_stats = (g_free (self->io_stats), NULL);
	self->net_stats = (g_free (self->net_stats), NULL);
	G_OBJECT_CLASS (boxes_libvirt_machine_parent_class)->finalize (obj);
}


GType boxes_libvirt_machine_get_type (void) {
	static volatile gsize boxes_libvirt_machine_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_libvirt_machine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesLibvirtMachineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_libvirt_machine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesLibvirtMachine), 0, (GInstanceInitFunc) boxes_libvirt_machine_instance_init, NULL };
		GType boxes_libvirt_machine_type_id;
		boxes_libvirt_machine_type_id = g_type_register_static (BOXES_TYPE_MACHINE, "BoxesLibvirtMachine", &g_define_type_info, 0);
		g_once_init_leave (&boxes_libvirt_machine_type_id__volatile, boxes_libvirt_machine_type_id);
	}
	return boxes_libvirt_machine_type_id__volatile;
}


static void _vala_boxes_libvirt_machine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesLibvirtMachine * self;
	self = BOXES_LIBVIRT_MACHINE (object);
	switch (property_id) {
		case BOXES_LIBVIRT_MACHINE_STATE:
		g_value_set_enum (value, boxes_libvirt_machine_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



