/* rygel-media-export-extract.c generated by valac 0.34.7, the Vala compiler
 * generated from rygel-media-export-extract.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <unistd.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _RunData RunData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	METADATA_EXTRACTOR_ERROR_GENERAL
} MetadataExtractorError;
#define METADATA_EXTRACTOR_ERROR metadata_extractor_error_quark ()
typedef enum  {
	DVD_PARSER_ERROR_GENERAL,
	DVD_PARSER_ERROR_NOT_AVAILABLE
} DVDParserError;
#define DVD_PARSER_ERROR dvd_parser_error_quark ()
struct _RunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* line;
	GDataInputStream* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* data;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** parts;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GFile* file;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	RygelMediaExportExtractor* extractor;
	GFile* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	gboolean _tmp22_;
	RygelMediaExportExtractor* _tmp23_;
	RygelMediaExportExtractor* _tmp24_;
	GFile* _tmp25_;
	RygelMediaExportExtractor* _tmp26_;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
	GError* _error_;
	GError* _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	const gchar* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	const gchar* _tmp36_;
	GError* _tmp37_;
	const gchar* _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	const gchar* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	GError* _tmp43_;
	const gchar* _tmp44_;
	gboolean _tmp45_;
	gchar* command;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gboolean _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp54_;
	const gchar* _tmp55_;
	gboolean _tmp56_;
	GError* _vala1__error_;
	const gchar* _tmp57_;
	GError* _tmp58_;
	const gchar* _tmp59_;
	GMainLoop* _tmp60_;
	GError * _inner_error_;
};


extern gint in_fd;
gint in_fd = 0;
extern gint out_fd;
gint out_fd = 1;
extern gboolean metadata;
gboolean metadata = FALSE;
extern GMainLoop* loop;
GMainLoop* loop = NULL;
extern GDataInputStream* input_stream;
GDataInputStream* input_stream = NULL;
extern GOutputStream* output_stream;
GOutputStream* output_stream = NULL;

#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_PLAYLIST "object.item.playlistItem"
#define UPNP_CLASS_PLAYLIST_CONTAINER_DVD "object.container.playlistContainer.DVD"
#define UPNP_CLASS_DVD_TRACK UPNP_CLASS_VIDEO ".dvdTrack"
#define STATUS_LINE_TEMPLATE "RESULT|%s|%" G_GSIZE_FORMAT "|%s\n"
#define ERROR_LINE_TEMPLATE "ERROR|%s|%d|%s\n"
#define SKIPPED_LINE_TEMPLATE "SKIP|%s|-1|0\n"
GQuark metadata_extractor_error_quark (void);
static void run_data_free (gpointer _data);
void run (GAsyncReadyCallback _callback_, gpointer _user_data_);
void run_finish (GAsyncResult* _res_);
static gboolean run_co (RunData* _data_);
static void run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST;
RygelMediaExportExtractor* rygel_media_export_extractor_create_for_file (GFile* file, const gchar* content_type, gboolean extract_metadata);
void rygel_media_export_extractor_run (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
void send_extraction_done (GFile* file, GVariant* v, GError** error);
GVariant* rygel_media_export_extractor_get (RygelMediaExportExtractor* self);
GQuark dvd_parser_error_quark (void);
void send_skip (GFile* file);
void send_error (GFile* file, GError* err);
gboolean vaapi_filter (GstPluginFeature* feature);
gint _vala_main (gchar** args, int args_length1);
static gboolean _vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[4] = {{"input-fd", 'i', 0, G_OPTION_ARG_INT, &in_fd, "File descriptor used for input", NULL}, {"output-fd", 'o', 0, G_OPTION_ARG_INT, &out_fd, "File descriptor used for output", NULL}, {"extract-metadata", 'm', 0, G_OPTION_ARG_NONE, &metadata, "Whether to extract all metadata from the files or just basic informati" \
"on", NULL}, {NULL}};

GQuark metadata_extractor_error_quark (void) {
	return g_quark_from_static_string ("metadata_extractor_error-quark");
}


static void run_data_free (gpointer _data) {
	RunData* _data_;
	_data_ = _data;
	g_slice_free (RunData, _data_);
}


void run (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RunData* _data_;
	_data_ = g_slice_new0 (RunData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, run_data_free);
	run_co (_data_);
}


void run_finish (GAsyncResult* _res_) {
	RunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	run_co (_data_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean run_co (RunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		{
			_data_->_tmp0_ = NULL;
			_data_->_tmp0_ = input_stream;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, NULL, run_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = NULL;
			_data_->_tmp1_ = g_data_input_stream_read_line_finish (_data_->_tmp0_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->line = _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = NULL;
			_data_->_tmp2_ = _data_->line;
			if (_data_->_tmp2_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = _data_->line;
			_data_->_tmp4_ = FALSE;
			_data_->_tmp4_ = g_str_has_prefix (_data_->_tmp3_, "EXTRACT ");
			if (_data_->_tmp4_) {
				_data_->_tmp5_ = NULL;
				_data_->_tmp5_ = _data_->line;
				g_debug ("rygel-media-export-extract.vala:69: Got command to extract file: %s", _data_->_tmp5_);
				_data_->_tmp6_ = NULL;
				_data_->_tmp6_ = _data_->line;
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = string_replace (_data_->_tmp6_, "EXTRACT ", "");
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = string_strip (_data_->_tmp8_);
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->_tmp9_;
				_g_free0 (_data_->_tmp8_);
				_data_->data = _data_->_tmp10_;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->data;
				_data_->_tmp12_ = NULL;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->_tmp12_ = g_strsplit (_data_->_tmp11_, "|", 0);
				_data_->parts_length1 = 0;
				_data_->_parts_size_ = 0;
				_data_->parts = _data_->_tmp13_;
				_data_->parts_length1 = _vala_array_length (_data_->_tmp12_);
				_data_->_parts_size_ = _data_->parts_length1;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14__length1 = 0;
				_data_->_tmp14_ = _data_->parts;
				_data_->_tmp14__length1 = _data_->parts_length1;
				if (_data_->_tmp14__length1 != 2) {
					_data_->_tmp15_ = NULL;
					_data_->_tmp15_ = _ ("Invalid command received, ignoring");
					g_warning ("rygel-media-export-extract.vala:73: %s", _data_->_tmp15_);
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					continue;
				}
				{
					_data_->_tmp16_ = NULL;
					_data_->_tmp16__length1 = 0;
					_data_->_tmp16_ = _data_->parts;
					_data_->_tmp16__length1 = _data_->parts_length1;
					_data_->_tmp17_ = NULL;
					_data_->_tmp17_ = _data_->_tmp16_[0];
					_data_->_tmp18_ = NULL;
					_data_->_tmp18_ = g_file_new_for_uri (_data_->_tmp17_);
					_data_->file = _data_->_tmp18_;
					_data_->_tmp19_ = NULL;
					_data_->_tmp19_ = _data_->file;
					_data_->_tmp20_ = NULL;
					_data_->_tmp20__length1 = 0;
					_data_->_tmp20_ = _data_->parts;
					_data_->_tmp20__length1 = _data_->parts_length1;
					_data_->_tmp21_ = NULL;
					_data_->_tmp21_ = _data_->_tmp20_[1];
					_data_->_tmp22_ = FALSE;
					_data_->_tmp22_ = metadata;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = rygel_media_export_extractor_create_for_file (_data_->_tmp19_, _data_->_tmp21_, _data_->_tmp22_);
					_data_->extractor = _data_->_tmp23_;
					_data_->_tmp24_ = NULL;
					_data_->_tmp24_ = _data_->extractor;
					_data_->_state_ = 2;
					rygel_media_export_extractor_run (_data_->_tmp24_, run_ready, _data_);
					return FALSE;
					_state_2:
					rygel_media_export_extractor_run_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch2_g_error;
					}
					_data_->_tmp25_ = NULL;
					_data_->_tmp25_ = _data_->file;
					_data_->_tmp26_ = NULL;
					_data_->_tmp26_ = _data_->extractor;
					_data_->_tmp27_ = NULL;
					_data_->_tmp27_ = rygel_media_export_extractor_get (_data_->_tmp26_);
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = _data_->_tmp27_;
					send_extraction_done (_data_->_tmp25_, _data_->_tmp28_, &_data_->_inner_error_);
					_g_variant_unref0 (_data_->_tmp28_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->extractor);
						_g_object_unref0 (_data_->file);
						goto __catch2_g_error;
					}
					_g_object_unref0 (_data_->extractor);
					_g_object_unref0 (_data_->file);
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp29_ = NULL;
					_data_->_tmp29_ = _data_->_error_;
					if (g_error_matches (_data_->_tmp29_, DVD_PARSER_ERROR, DVD_PARSER_ERROR_NOT_AVAILABLE)) {
						_data_->_tmp30_ = NULL;
						_data_->_tmp30__length1 = 0;
						_data_->_tmp30_ = _data_->parts;
						_data_->_tmp30__length1 = _data_->parts_length1;
						_data_->_tmp31_ = NULL;
						_data_->_tmp31_ = _data_->_tmp30_[0];
						_data_->_tmp32_ = NULL;
						_data_->_tmp32_ = g_file_new_for_uri (_data_->_tmp31_);
						_data_->_tmp33_ = NULL;
						_data_->_tmp33_ = _data_->_tmp32_;
						send_skip (_data_->_tmp33_);
						_g_object_unref0 (_data_->_tmp33_);
					} else {
						_data_->_tmp34_ = NULL;
						_data_->_tmp34_ = _ ("Failed to discover URI %s: %s");
						_data_->_tmp35_ = NULL;
						_data_->_tmp35__length1 = 0;
						_data_->_tmp35_ = _data_->parts;
						_data_->_tmp35__length1 = _data_->parts_length1;
						_data_->_tmp36_ = NULL;
						_data_->_tmp36_ = _data_->_tmp35_[0];
						_data_->_tmp37_ = NULL;
						_data_->_tmp37_ = _data_->_error_;
						_data_->_tmp38_ = NULL;
						_data_->_tmp38_ = _data_->_tmp37_->message;
						g_warning (_data_->_tmp34_, _data_->_tmp36_, _data_->_tmp38_);
						_data_->_tmp39_ = NULL;
						_data_->_tmp39__length1 = 0;
						_data_->_tmp39_ = _data_->parts;
						_data_->_tmp39__length1 = _data_->parts_length1;
						_data_->_tmp40_ = NULL;
						_data_->_tmp40_ = _data_->_tmp39_[0];
						_data_->_tmp41_ = NULL;
						_data_->_tmp41_ = g_file_new_for_uri (_data_->_tmp40_);
						_data_->_tmp42_ = NULL;
						_data_->_tmp42_ = _data_->_tmp41_;
						_data_->_tmp43_ = NULL;
						_data_->_tmp43_ = _data_->_error_;
						send_error (_data_->_tmp42_, _data_->_tmp43_);
						_g_object_unref0 (_data_->_tmp42_);
					}
					_g_error_free0 (_data_->_error_);
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->data);
					_g_free0 (_data_->line);
					goto __catch0_g_error;
				}
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->data);
			} else {
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = _data_->line;
				_data_->_tmp45_ = FALSE;
				_data_->_tmp45_ = g_str_has_prefix (_data_->_tmp44_, "METADATA ");
				if (_data_->_tmp45_) {
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = _data_->line;
					_data_->_tmp47_ = NULL;
					_data_->_tmp47_ = string_replace (_data_->_tmp46_, "METADATA ", "");
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = _data_->_tmp47_;
					_data_->_tmp49_ = NULL;
					_data_->_tmp49_ = string_strip (_data_->_tmp48_);
					_data_->_tmp50_ = NULL;
					_data_->_tmp50_ = _data_->_tmp49_;
					_g_free0 (_data_->_tmp48_);
					_data_->command = _data_->_tmp50_;
					_data_->_tmp51_ = NULL;
					_data_->_tmp51_ = _data_->command;
					_data_->_tmp52_ = FALSE;
					_data_->_tmp52_ = bool_parse (_data_->_tmp51_);
					metadata = _data_->_tmp52_;
					_data_->_tmp54_ = FALSE;
					_data_->_tmp54_ = metadata;
					if (_data_->_tmp54_) {
						_data_->_tmp53_ = "enabled";
					} else {
						_data_->_tmp53_ = "disabled";
					}
					g_debug ("rygel-media-export-extract.vala:99: Meta-data extraction was %s", _data_->_tmp53_);
					_g_free0 (_data_->command);
				} else {
					_data_->_tmp55_ = NULL;
					_data_->_tmp55_ = _data_->line;
					_data_->_tmp56_ = FALSE;
					_data_->_tmp56_ = g_str_has_prefix (_data_->_tmp55_, "QUIT");
					if (_data_->_tmp56_) {
						_g_free0 (_data_->line);
						break;
					}
				}
			}
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp57_ = NULL;
			_data_->_tmp57_ = _ ("Failed to read from pipe: %s");
			_data_->_tmp58_ = NULL;
			_data_->_tmp58_ = _data_->_vala1__error_;
			_data_->_tmp59_ = NULL;
			_data_->_tmp59_ = _data_->_tmp58_->message;
			g_warning (_data_->_tmp57_, _data_->_tmp59_);
			_g_error_free0 (_data_->_vala1__error_);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp60_ = NULL;
	_data_->_tmp60_ = loop;
	g_main_loop_quit (_data_->_tmp60_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void send_extraction_done (GFile* file, GVariant* v, GError** error) {
	GBytes* data = NULL;
	GVariant* _tmp0_ = NULL;
	GBytes* _tmp1_ = NULL;
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GBytes* _tmp5_ = NULL;
	gsize _tmp6_ = 0UL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GOutputStream* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	guint8* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gsize _tmp16_ = 0UL;
	GOutputStream* _tmp17_ = NULL;
	GBytes* _tmp18_ = NULL;
	gsize _tmp19_;
	guint8* _tmp20_ = NULL;
	gsize _tmp21_ = 0UL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_get_data_as_bytes (_tmp0_);
	data = _tmp1_;
	bytes_written = (gsize) 0;
	_tmp2_ = file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = data;
	_tmp6_ = g_bytes_get_size (_tmp5_);
	_tmp7_ = file;
	_tmp8_ = g_file_get_uri (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (STATUS_LINE_TEMPLATE, _tmp4_, _tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp4_);
	status = _tmp11_;
	_tmp12_ = output_stream;
	_tmp13_ = status;
	_tmp14_ = string_get_data (_tmp13_, &_tmp14__length1);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	g_output_stream_write_all (_tmp12_, _tmp15_, (gsize) _tmp15__length1, &_tmp16_, NULL, &_inner_error_);
	bytes_written = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_tmp17_ = output_stream;
	_tmp18_ = data;
	_tmp20_ = g_bytes_get_data (_tmp18_, &_tmp19_);
	g_output_stream_write_all (_tmp17_, _tmp20_, (gsize) _tmp19_, &_tmp21_, NULL, &_inner_error_);
	bytes_written = _tmp21_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (status);
		_g_bytes_unref0 (data);
		return;
	}
	_g_free0 (status);
	_g_bytes_unref0 (data);
}


void send_skip (GFile* file) {
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (SKIPPED_LINE_TEMPLATE, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	status = _tmp4_;
	{
		GOutputStream* _tmp5_ = NULL;
		guint8* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		guint8* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gsize _tmp8_ = 0UL;
		_tmp5_ = output_stream;
		_tmp6_ = string_get_data (status, &_tmp6__length1);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp6__length1;
		g_output_stream_write_all (_tmp5_, _tmp7_, (gsize) _tmp7__length1, &_tmp8_, NULL, &_inner_error_);
		bytes_written = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = _ ("Failed to send error to parent: %s");
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning (_tmp9_, _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status);
}


void send_error (GFile* file, GError* err) {
	gsize bytes_written = 0UL;
	gchar* status = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GError* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	bytes_written = (gsize) 0;
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = err;
	_tmp4_ = _tmp3_->code;
	_tmp5_ = err;
	_tmp6_ = _tmp5_->message;
	_tmp7_ = g_strdup_printf (ERROR_LINE_TEMPLATE, _tmp2_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp2_);
	status = _tmp8_;
	{
		GOutputStream* _tmp9_ = NULL;
		guint8* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		guint8* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gsize _tmp12_ = 0UL;
		_tmp9_ = output_stream;
		_tmp10_ = string_get_data (status, &_tmp10__length1);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp10__length1;
		g_output_stream_write_all (_tmp9_, _tmp11_, (gsize) _tmp11__length1, &_tmp12_, NULL, &_inner_error_);
		bytes_written = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = _ ("Failed to send error to parent: %s");
		_tmp14_ = _error_;
		_tmp15_ = _tmp14_->message;
		g_warning (_tmp13_, _tmp15_);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status);
}


gboolean vaapi_filter (GstPluginFeature* feature) {
	gboolean result = FALSE;
	GstPluginFeature* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (feature != NULL, FALSE);
	_tmp0_ = feature;
	_tmp1_ = gst_object_get_name ((GstObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_prefix (_tmp2_, "vaapi");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vaapi_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self) {
	gboolean result;
	result = vaapi_filter (feature);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* ctx = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gint _tmp10_ = 0;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp11_ = NULL;
	GstRegistry* _tmp12_ = NULL;
	GList* features = NULL;
	GstRegistry* _tmp13_ = NULL;
	GList* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GUnixInputStream* _tmp25_ = NULL;
	GUnixInputStream* _tmp26_ = NULL;
	GDataInputStream* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	GUnixOutputStream* _tmp29_ = NULL;
	GMainLoop* _tmp30_ = NULL;
	GMainLoop* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = _ ("— helper binary for Rygel to extract metadata");
	_tmp1_ = g_option_context_new (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	_tmp3_ = ctx;
	_tmp4_ = gst_init_get_option_group ();
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = ctx;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _ ("Failed to parse commandline args: %s");
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning (_tmp6_, _tmp8_);
		result = EXIT_FAILURE;
		_g_error_free0 (_error_);
		_g_option_context_free0 (ctx);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp9_ = 0;
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp9_;
	}
	_tmp10_ = nice (19);
	if (_tmp10_ < 0) {
		g_debug ("rygel-media-export-extract.vala:170: Failed to reduce nice level of th" \
"umbnailer, continuing anyway");
	}
	_tmp11_ = gst_registry_get ();
	_tmp12_ = _g_object_ref0 (_tmp11_);
	registry = _tmp12_;
	_tmp13_ = registry;
	_tmp14_ = gst_registry_feature_filter (_tmp13_, _vaapi_filter_gst_plugin_feature_filter, FALSE, NULL);
	features = _tmp14_;
	_tmp15_ = features;
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp15_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp16_ = NULL;
			GstPluginFeature* feature = NULL;
			_tmp16_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
			feature = _tmp16_;
			{
				GstPluginFeature* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				GstRegistry* _tmp20_ = NULL;
				GstPluginFeature* _tmp21_ = NULL;
				_tmp17_ = feature;
				_tmp18_ = gst_object_get_name ((GstObject*) _tmp17_);
				_tmp19_ = _tmp18_;
				g_debug ("rygel-media-export-extract.vala:176: Removing registry feature %s", _tmp19_);
				_g_free0 (_tmp19_);
				_tmp20_ = registry;
				_tmp21_ = feature;
				gst_registry_remove_feature (_tmp20_, _tmp21_);
				_g_object_unref0 (feature);
			}
		}
	}
	_tmp22_ = in_fd;
	_tmp23_ = out_fd;
	g_message ("rygel-media-export-extract.vala:180: Started with descriptors %d (in) " \
"%d (out)", _tmp22_, _tmp23_);
	_tmp24_ = in_fd;
	_tmp25_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp24_, TRUE);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_data_input_stream_new ((GInputStream*) _tmp26_);
	_g_object_unref0 (input_stream);
	input_stream = _tmp27_;
	_g_object_unref0 (_tmp26_);
	_tmp28_ = out_fd;
	_tmp29_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp28_, TRUE);
	_g_object_unref0 (output_stream);
	output_stream = (GOutputStream*) _tmp29_;
	_tmp30_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp30_;
	run (NULL, NULL);
	_tmp31_ = loop;
	g_main_loop_run (_tmp31_);
	result = 0;
	__g_list_free__g_object_unref0_0 (features);
	_g_object_unref0 (registry);
	_g_option_context_free0 (ctx);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



