/* sudoku-printer.c generated by valac 0.37.1.6-1eaec, the Vala compiler
 * generated from sudoku-printer.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "libsudoku.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
typedef struct _SudokuPrinterPrivate SudokuPrinterPrivate;
enum  {
	SUDOKU_PRINTER_DUMMY_PROPERTY,
	SUDOKU_PRINTER_LAST_PROPERTY
};
static GParamSpec* sudoku_printer_properties[SUDOKU_PRINTER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _SudokuPrinter {
	GObject parent_instance;
	SudokuPrinterPrivate * priv;
};

struct _SudokuPrinterClass {
	GObjectClass parent_class;
};

struct _SudokuPrinterPrivate {
	GeeList* boards;
	GtkWindow* window;
	gint margin;
	gint n_sudokus;
	GtkPrintOperation* print_op;
};


static gpointer sudoku_printer_parent_class = NULL;

GType sudoku_printer_get_type (void) G_GNUC_CONST;
#define SUDOKU_PRINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_PRINTER, SudokuPrinterPrivate))
#define SUDOKU_PRINTER_SUDOKUS_PER_PAGE 2
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context);
static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self);
static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr);
static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin);
static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y);
static void sudoku_printer_finalize (GObject * obj);


GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self) {
	GtkPrintOperationResult result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GtkPrintOperationResult _result_ = 0;
		GtkPrintOperation* _tmp0_;
		GtkWindow* _tmp1_;
		GtkPrintOperationResult _tmp2_;
		_tmp0_ = self->priv->print_op;
		_tmp1_ = self->priv->window;
		_tmp2_ = gtk_print_operation_run (_tmp0_, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp1_, &_inner_error_);
		_result_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		result = _result_;
		return result;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GtkWindow* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkMessageDialog* _tmp8_;
		GtkMessageDialog* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = self->priv->window;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strdup_printf ("%s\n%s", _ ("Error printing file:"), _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp7_);
		g_object_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		gtk_dialog_run ((GtkDialog*) _tmp9_);
		_g_object_unref0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = GTK_PRINT_OPERATION_RESULT_ERROR;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self) {
	sudoku_printer_begin_print_cb ((SudokuPrinter*) self, _sender, context);
}


static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
	sudoku_printer_draw_page_cb ((SudokuPrinter*) self, _sender, context, page_nr);
}


SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window) {
	SudokuPrinter * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkPrintOperation* _tmp7_;
	GtkPrintOperation* _tmp8_;
	GtkPrintOperation* _tmp9_;
	g_return_val_if_fail (boards != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (SudokuPrinter*) g_object_new (object_type, NULL);
	_tmp0_ = boards;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->boards);
	self->priv->boards = _tmp1_;
	_tmp2_ = window;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp3_;
	self->priv->margin = 25;
	_tmp4_ = boards;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->n_sudokus = _tmp6_;
	_tmp7_ = gtk_print_operation_new ();
	_g_object_unref0 (self->priv->print_op);
	self->priv->print_op = _tmp7_;
	_tmp8_ = self->priv->print_op;
	g_signal_connect_object (_tmp8_, "begin-print", (GCallback) _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print, self, 0);
	_tmp9_ = self->priv->print_op;
	g_signal_connect_object (_tmp9_, "draw-page", (GCallback) _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page, self, 0);
	return self;
}


SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window) {
	return sudoku_printer_construct (TYPE_SUDOKU_PRINTER, boards, window);
}


static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context) {
	gint pages = 0;
	gint _tmp0_;
	GtkPrintOperation* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->n_sudokus;
	pages = _tmp0_ / SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	while (TRUE) {
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = pages;
		_tmp2_ = self->priv->n_sudokus;
		if (!((_tmp1_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE) < _tmp2_)) {
			break;
		}
		_tmp3_ = pages;
		pages = _tmp3_ + 1;
	}
	_tmp4_ = operation;
	_tmp5_ = pages;
	gtk_print_operation_set_n_pages (_tmp4_, _tmp5_);
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr) {
	cairo_t* cr = NULL;
	GtkPrintContext* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	gdouble width = 0.0;
	GtkPrintContext* _tmp3_;
	gdouble _tmp4_;
	gdouble height = 0.0;
	GtkPrintContext* _tmp5_;
	gdouble _tmp6_;
	gdouble best_square_size = 0.0;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gint start = 0;
	gint _tmp11_;
	gint end = 0;
	gint _tmp12_;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeList* sudokus_on_page = NULL;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeList* _tmp20_;
	gdouble left = 0.0;
	gdouble _tmp21_;
	gdouble _tmp22_;
	gdouble top = 0.0;
	gint _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
	_tmp2_ = _cairo_reference0 (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = gtk_print_context_get_width (_tmp3_);
	width = _tmp4_;
	_tmp5_ = context;
	_tmp6_ = gtk_print_context_get_height (_tmp5_);
	height = _tmp6_;
	_tmp7_ = width;
	_tmp8_ = height;
	_tmp9_ = self->priv->margin;
	_tmp10_ = sudoku_printer_fit_squares_in_rectangle (self, _tmp7_, _tmp8_, _tmp9_);
	best_square_size = _tmp10_;
	_tmp11_ = page_nr;
	start = _tmp11_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	_tmp12_ = start;
	_tmp13_ = self->priv->boards;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = MIN (_tmp12_ + SUDOKU_PRINTER_SUDOKUS_PER_PAGE, _tmp15_);
	end = _tmp16_;
	_tmp17_ = self->priv->boards;
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = gee_list_slice (_tmp17_, _tmp18_, _tmp19_);
	sudokus_on_page = _tmp20_;
	_tmp21_ = width;
	_tmp22_ = best_square_size;
	left = (_tmp21_ - _tmp22_) / 2;
	_tmp23_ = self->priv->margin;
	top = (gdouble) _tmp23_;
	{
		GeeList* _sudoku_list = NULL;
		GeeList* _tmp24_;
		GeeList* _tmp25_;
		gint _sudoku_size = 0;
		GeeList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _sudoku_index = 0;
		_tmp24_ = sudokus_on_page;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_sudoku_list = _tmp25_;
		_tmp26_ = _sudoku_list;
		_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_sudoku_size = _tmp28_;
		_sudoku_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			SudokuBoard* sudoku = NULL;
			GeeList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			gchar* label = NULL;
			SudokuBoard* _tmp35_;
			DifficultyCategory _tmp36_;
			DifficultyCategory _tmp37_;
			gchar* _tmp38_;
			cairo_t* _tmp39_;
			cairo_t* _tmp40_;
			cairo_t* _tmp41_;
			cairo_text_extents_t extents = {0};
			cairo_t* _tmp42_;
			const gchar* _tmp43_;
			cairo_text_extents_t _tmp44_ = {0};
			cairo_t* _tmp45_;
			gdouble _tmp46_;
			cairo_text_extents_t _tmp47_;
			gdouble _tmp48_;
			gdouble _tmp49_;
			cairo_text_extents_t _tmp50_;
			gdouble _tmp51_;
			cairo_t* _tmp52_;
			const gchar* _tmp53_;
			cairo_t* _tmp54_;
			SudokuBoard* _tmp55_;
			gdouble _tmp56_;
			gdouble _tmp57_;
			gdouble _tmp58_;
			gdouble _tmp59_;
			gdouble _tmp60_;
			gint _tmp61_;
			_tmp29_ = _sudoku_index;
			_sudoku_index = _tmp29_ + 1;
			_tmp30_ = _sudoku_index;
			_tmp31_ = _sudoku_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _sudoku_list;
			_tmp33_ = _sudoku_index;
			_tmp34_ = gee_list_get (_tmp32_, _tmp33_);
			sudoku = (SudokuBoard*) _tmp34_;
			_tmp35_ = sudoku;
			_tmp36_ = sudoku_board_get_difficulty_category (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = difficulty_category_to_string (_tmp37_);
			label = _tmp38_;
			_tmp39_ = cr;
			cairo_set_font_size (_tmp39_, (gdouble) 12);
			_tmp40_ = cr;
			cairo_select_font_face (_tmp40_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
			_tmp41_ = cr;
			cairo_set_source_rgb (_tmp41_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp42_ = cr;
			_tmp43_ = label;
			cairo_text_extents (_tmp42_, _tmp43_, &_tmp44_);
			extents = _tmp44_;
			_tmp45_ = cr;
			_tmp46_ = width;
			_tmp47_ = extents;
			_tmp48_ = _tmp47_.width;
			_tmp49_ = top;
			_tmp50_ = extents;
			_tmp51_ = _tmp50_.height;
			cairo_move_to (_tmp45_, (_tmp46_ - _tmp48_) / 2, _tmp49_ - (_tmp51_ / 2));
			_tmp52_ = cr;
			_tmp53_ = label;
			cairo_show_text (_tmp52_, _tmp53_);
			_tmp54_ = cr;
			_tmp55_ = sudoku;
			_tmp56_ = best_square_size;
			_tmp57_ = left;
			_tmp58_ = top;
			sudoku_printer_draw_sudoku (self, _tmp54_, _tmp55_, _tmp56_, _tmp57_, _tmp58_);
			_tmp59_ = top;
			_tmp60_ = best_square_size;
			_tmp61_ = self->priv->margin;
			top = _tmp59_ + (_tmp60_ + (2 * _tmp61_));
			_g_free0 (label);
			_g_object_unref0 (sudoku);
		}
		_g_object_unref0 (_sudoku_list);
	}
	_g_object_unref0 (sudokus_on_page);
	_cairo_destroy0 (cr);
}


static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin) {
	gdouble result = 0.0;
	gint n = 0;
	gdouble best_square_size = 0.0;
	gdouble square_size = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	n = SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
	best_square_size = 0.0;
	square_size = 0.0;
	{
		gint n_across = 0;
		n_across = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gdouble n_down = 0.0;
				gint _tmp4_;
				gint _tmp5_;
				gdouble across_size = 0.0;
				gdouble _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gdouble _tmp9_;
				gint _tmp10_;
				gdouble down_size = 0.0;
				gdouble _tmp11_;
				gdouble _tmp12_;
				gint _tmp13_;
				gdouble _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp17_;
				gdouble _tmp18_;
				gdouble _tmp19_;
				gdouble _tmp20_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = n_across;
					n_across = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = n_across;
				_tmp3_ = n;
				if (!(_tmp2_ <= _tmp3_)) {
					break;
				}
				_tmp4_ = n;
				_tmp5_ = n_across;
				n_down = (gdouble) (_tmp4_ / _tmp5_);
				_tmp6_ = width;
				_tmp7_ = n_across;
				_tmp8_ = margin;
				across_size = _tmp6_ - ((_tmp7_ + 1) * _tmp8_);
				_tmp9_ = across_size;
				_tmp10_ = n_across;
				across_size = _tmp9_ / _tmp10_;
				_tmp11_ = height;
				_tmp12_ = n_down;
				_tmp13_ = margin;
				down_size = _tmp11_ - ((_tmp12_ + 1) * _tmp13_);
				_tmp14_ = down_size;
				_tmp15_ = n_down;
				down_size = _tmp14_ / _tmp15_;
				_tmp16_ = across_size;
				_tmp17_ = down_size;
				_tmp18_ = MIN (_tmp16_, _tmp17_);
				square_size = _tmp18_;
				_tmp19_ = square_size;
				_tmp20_ = best_square_size;
				if (_tmp19_ > _tmp20_) {
					gdouble _tmp21_;
					_tmp21_ = square_size;
					best_square_size = _tmp21_;
				}
			}
		}
	}
	result = best_square_size;
	return result;
}


static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y) {
	static const gint SUDOKU_SIZE = 9;
	static const gint N_BOXES = 3;
	static const gdouble PENCIL_GREY[] = {0.3, 0.3, 0.3};
	static const gdouble BACKGROUND_COLOR[] = {1.0, 1.0, 1.0};
	static const gdouble BORDER_COLOR[] = {1.0, 1.0, 1.0};
	static const gdouble LINE_COLOR[] = {0.0, 0.0, 0.0};
	gdouble THIN = 0.0;
	gdouble _tmp0_;
	gdouble THICK = 0.0;
	gdouble _tmp1_;
	gdouble BORDER = 0.0;
	gdouble _tmp2_;
	gdouble WHITE_SPACE = 0.0;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble SQUARE_SIZE = 0.0;
	gdouble _tmp8_;
	gint FONT_SIZE = 0;
	gdouble _tmp9_;
	static const cairo_font_weight_t FONT_WEIGHT = CAIRO_FONT_WEIGHT_NORMAL;
	gdouble* outer = NULL;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble* _tmp16_;
	gint outer_length1;
	gint _outer_size_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	gdouble* _tmp19_;
	gint _tmp19__length1;
	gdouble _tmp20_;
	gdouble* _tmp21_;
	gint _tmp21__length1;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	gdouble _tmp28_;
	cairo_t* _tmp29_;
	gdouble* _tmp30_;
	gint _tmp30__length1;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble* _tmp33_;
	gint _tmp33__length1;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	cairo_t* _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	cairo_t* _tmp49_;
	cairo_t* _tmp50_;
	cairo_t* _tmp51_;
	gdouble _tmp52_;
	cairo_t* _tmp53_;
	gdouble* _tmp54_;
	gint _tmp54__length1;
	gdouble _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gdouble* _tmp58_;
	gint _tmp58__length1;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gdouble _tmp61_;
	gdouble _tmp62_;
	gdouble _tmp63_;
	gdouble _tmp64_;
	gdouble _tmp65_;
	gdouble _tmp66_;
	gdouble _tmp67_;
	cairo_t* _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	gdouble _tmp71_;
	cairo_t* _tmp72_;
	gdouble* pos = NULL;
	gdouble* _tmp73_;
	gint pos_length1;
	gint _pos_size_;
	gdouble position = 0.0;
	gdouble _tmp74_;
	gdouble _tmp75_;
	gdouble* _tmp76_;
	gint _tmp76__length1;
	gdouble _tmp77_;
	gdouble _tmp78_;
	gdouble _tmp79_;
	gdouble last_line = 0.0;
	cairo_t* _tmp131_;
	gint _tmp132_;
	gchar* letter = NULL;
	gchar* _tmp133_;
	cairo_text_extents_t extents = {0};
	gint* sudoku = NULL;
	SudokuBoard* _tmp134_;
	gint _tmp135_;
	gint _tmp136_;
	gint* _tmp137_;
	gint sudoku_length1;
	gint sudoku_length2;
	gboolean invert = FALSE;
	GtkTextDirection _tmp138_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (sudoku_board != NULL);
	_tmp0_ = size;
	THIN = _tmp0_ / 500.0;
	_tmp1_ = THIN;
	THICK = _tmp1_ * 5;
	_tmp2_ = THICK;
	BORDER = _tmp2_;
	_tmp3_ = size;
	_tmp4_ = BORDER;
	_tmp5_ = THICK;
	_tmp6_ = THICK;
	_tmp7_ = THIN;
	WHITE_SPACE = (((_tmp3_ - (2 * _tmp4_)) - (2 * _tmp5_)) - ((N_BOXES - 1) * _tmp6_)) - ((N_BOXES * 2) * _tmp7_);
	_tmp8_ = WHITE_SPACE;
	SQUARE_SIZE = _tmp8_ / SUDOKU_SIZE;
	_tmp9_ = SQUARE_SIZE;
	FONT_SIZE = ((gint) _tmp9_) / 2;
	_tmp10_ = offset_x;
	_tmp11_ = offset_x;
	_tmp12_ = size;
	_tmp13_ = offset_y;
	_tmp14_ = offset_y;
	_tmp15_ = size;
	_tmp16_ = g_new0 (gdouble, 4);
	_tmp16_[0] = _tmp10_;
	_tmp16_[1] = _tmp11_ + _tmp12_;
	_tmp16_[2] = _tmp13_;
	_tmp16_[3] = _tmp14_ + _tmp15_;
	outer = _tmp16_;
	outer_length1 = 4;
	_outer_size_ = outer_length1;
	_tmp17_ = cr;
	cairo_set_source_rgb (_tmp17_, 1.0, 1.0, 1.0);
	_tmp18_ = cr;
	_tmp19_ = outer;
	_tmp19__length1 = outer_length1;
	_tmp20_ = _tmp19_[0];
	_tmp21_ = outer;
	_tmp21__length1 = outer_length1;
	_tmp22_ = _tmp21_[2];
	_tmp23_ = size;
	_tmp24_ = size;
	cairo_rectangle (_tmp18_, _tmp20_, _tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = cr;
	cairo_fill (_tmp25_);
	_tmp26_ = cr;
	cairo_set_line_join (_tmp26_, CAIRO_LINE_JOIN_ROUND);
	_tmp27_ = cr;
	_tmp28_ = BORDER;
	cairo_set_line_width (_tmp27_, _tmp28_);
	_tmp29_ = cr;
	_tmp30_ = outer;
	_tmp30__length1 = outer_length1;
	_tmp31_ = _tmp30_[0];
	_tmp32_ = BORDER;
	_tmp33_ = outer;
	_tmp33__length1 = outer_length1;
	_tmp34_ = _tmp33_[2];
	_tmp35_ = BORDER;
	_tmp36_ = size;
	_tmp37_ = BORDER;
	_tmp38_ = size;
	_tmp39_ = BORDER;
	cairo_rectangle (_tmp29_, _tmp31_ + (_tmp32_ / 2.0), _tmp34_ + (_tmp35_ / 2.0), _tmp36_ - _tmp37_, _tmp38_ - _tmp39_);
	_tmp40_ = cr;
	_tmp41_ = BACKGROUND_COLOR[0];
	_tmp42_ = BACKGROUND_COLOR[1];
	_tmp43_ = BACKGROUND_COLOR[2];
	cairo_set_source_rgb (_tmp40_, _tmp41_, _tmp42_, _tmp43_);
	_tmp44_ = cr;
	cairo_fill_preserve (_tmp44_);
	_tmp45_ = cr;
	_tmp46_ = BORDER_COLOR[0];
	_tmp47_ = BORDER_COLOR[1];
	_tmp48_ = BORDER_COLOR[2];
	cairo_set_source_rgb (_tmp45_, _tmp46_, _tmp47_, _tmp48_);
	_tmp49_ = cr;
	cairo_stroke (_tmp49_);
	_tmp50_ = cr;
	cairo_set_line_join (_tmp50_, CAIRO_LINE_JOIN_MITER);
	_tmp51_ = cr;
	_tmp52_ = THICK;
	cairo_set_line_width (_tmp51_, _tmp52_);
	_tmp53_ = cr;
	_tmp54_ = outer;
	_tmp54__length1 = outer_length1;
	_tmp55_ = _tmp54_[0];
	_tmp56_ = BORDER;
	_tmp57_ = THICK;
	_tmp58_ = outer;
	_tmp58__length1 = outer_length1;
	_tmp59_ = _tmp58_[2];
	_tmp60_ = BORDER;
	_tmp61_ = THICK;
	_tmp62_ = size;
	_tmp63_ = BORDER;
	_tmp64_ = THICK;
	_tmp65_ = size;
	_tmp66_ = BORDER;
	_tmp67_ = THICK;
	cairo_rectangle (_tmp53_, (_tmp55_ + _tmp56_) + (_tmp57_ / 2.0), (_tmp59_ + _tmp60_) + (_tmp61_ / 2.0), (_tmp62_ - (_tmp63_ * 2)) - _tmp64_, (_tmp65_ - (_tmp66_ * 2)) - _tmp67_);
	_tmp68_ = cr;
	_tmp69_ = LINE_COLOR[0];
	_tmp70_ = LINE_COLOR[1];
	_tmp71_ = LINE_COLOR[2];
	cairo_set_source_rgb (_tmp68_, _tmp69_, _tmp70_, _tmp71_);
	_tmp72_ = cr;
	cairo_stroke (_tmp72_);
	_tmp73_ = g_new0 (gdouble, SUDOKU_SIZE + 1);
	pos = _tmp73_;
	pos_length1 = SUDOKU_SIZE + 1;
	_pos_size_ = pos_length1;
	_tmp74_ = BORDER;
	_tmp75_ = THICK;
	position = _tmp74_ + _tmp75_;
	_tmp76_ = pos;
	_tmp76__length1 = pos_length1;
	_tmp77_ = position;
	_tmp78_ = SQUARE_SIZE;
	_tmp76_[0] = _tmp77_ + (_tmp78_ / 2.0);
	_tmp79_ = _tmp76_[0];
	last_line = 0.0;
	{
		gint n = 0;
		n = 1;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				gint _tmp82_;
				gint _tmp83_;
				gdouble* _tmp98_;
				gint _tmp98__length1;
				gint _tmp99_;
				gdouble _tmp100_;
				gdouble _tmp101_;
				gdouble _tmp102_;
				gdouble _tmp103_;
				cairo_t* _tmp104_;
				gdouble _tmp105_;
				gdouble _tmp106_;
				gdouble _tmp107_;
				gdouble _tmp108_;
				gdouble _tmp109_;
				cairo_t* _tmp110_;
				gdouble _tmp111_;
				gdouble _tmp112_;
				gdouble _tmp113_;
				gdouble _tmp114_;
				gdouble _tmp115_;
				gdouble _tmp116_;
				cairo_t* _tmp117_;
				gdouble _tmp118_;
				gdouble _tmp119_;
				gdouble _tmp120_;
				gdouble _tmp121_;
				gdouble _tmp122_;
				cairo_t* _tmp123_;
				gdouble _tmp124_;
				gdouble _tmp125_;
				gdouble _tmp126_;
				gdouble _tmp127_;
				gdouble _tmp128_;
				gdouble _tmp129_;
				cairo_t* _tmp130_;
				if (!_tmp80_) {
					gint _tmp81_;
					_tmp81_ = n;
					n = _tmp81_ + 1;
				}
				_tmp80_ = FALSE;
				_tmp82_ = n;
				if (!(_tmp82_ <= SUDOKU_SIZE)) {
					break;
				}
				_tmp83_ = n;
				if ((_tmp83_ % N_BOXES) == 0) {
					cairo_t* _tmp84_;
					gdouble _tmp85_;
					gdouble _tmp86_;
					gdouble _tmp87_;
					gdouble _tmp88_;
					gdouble _tmp89_;
					gdouble _tmp90_;
					_tmp84_ = cr;
					_tmp85_ = THICK;
					cairo_set_line_width (_tmp84_, _tmp85_);
					_tmp86_ = position;
					_tmp87_ = SQUARE_SIZE;
					_tmp88_ = last_line;
					_tmp89_ = THICK;
					position = _tmp86_ + ((_tmp87_ + (_tmp88_ / 2.0)) + (_tmp89_ / 2.0));
					_tmp90_ = THICK;
					last_line = _tmp90_;
				} else {
					cairo_t* _tmp91_;
					gdouble _tmp92_;
					gdouble _tmp93_;
					gdouble _tmp94_;
					gdouble _tmp95_;
					gdouble _tmp96_;
					gdouble _tmp97_;
					_tmp91_ = cr;
					_tmp92_ = THIN;
					cairo_set_line_width (_tmp91_, _tmp92_);
					_tmp93_ = position;
					_tmp94_ = SQUARE_SIZE;
					_tmp95_ = last_line;
					_tmp96_ = THIN;
					position = _tmp93_ + ((_tmp94_ + (_tmp95_ / 2.0)) + (_tmp96_ / 2.0));
					_tmp97_ = THIN;
					last_line = _tmp97_;
				}
				_tmp98_ = pos;
				_tmp98__length1 = pos_length1;
				_tmp99_ = n;
				_tmp100_ = position;
				_tmp101_ = last_line;
				_tmp102_ = SQUARE_SIZE;
				_tmp98_[_tmp99_] = (_tmp100_ + (_tmp101_ / 2.0)) + (_tmp102_ / 2.0);
				_tmp103_ = _tmp98_[_tmp99_];
				_tmp104_ = cr;
				_tmp105_ = BORDER;
				_tmp106_ = THICK;
				_tmp107_ = offset_x;
				_tmp108_ = position;
				_tmp109_ = offset_y;
				cairo_move_to (_tmp104_, (_tmp105_ + (_tmp106_ / 2.0)) + _tmp107_, _tmp108_ + _tmp109_);
				_tmp110_ = cr;
				_tmp111_ = size;
				_tmp112_ = BORDER;
				_tmp113_ = THICK;
				_tmp114_ = offset_x;
				_tmp115_ = position;
				_tmp116_ = offset_y;
				cairo_line_to (_tmp110_, ((_tmp111_ - _tmp112_) - (_tmp113_ / 2.0)) + _tmp114_, _tmp115_ + _tmp116_);
				_tmp117_ = cr;
				_tmp118_ = position;
				_tmp119_ = offset_x;
				_tmp120_ = BORDER;
				_tmp121_ = THICK;
				_tmp122_ = offset_y;
				cairo_move_to (_tmp117_, _tmp118_ + _tmp119_, (_tmp120_ + (_tmp121_ / 2.0)) + _tmp122_);
				_tmp123_ = cr;
				_tmp124_ = position;
				_tmp125_ = offset_x;
				_tmp126_ = size;
				_tmp127_ = BORDER;
				_tmp128_ = THICK;
				_tmp129_ = offset_y;
				cairo_line_to (_tmp123_, _tmp124_ + _tmp125_, ((_tmp126_ - _tmp127_) - (_tmp128_ / 2.0)) + _tmp129_);
				_tmp130_ = cr;
				cairo_stroke (_tmp130_);
			}
		}
	}
	_tmp131_ = cr;
	_tmp132_ = FONT_SIZE;
	cairo_set_font_size (_tmp131_, (gdouble) _tmp132_);
	_tmp133_ = g_strdup ("");
	letter = _tmp133_;
	_tmp134_ = sudoku_board;
	_tmp137_ = sudoku_board_get_cells (_tmp134_, &_tmp135_, &_tmp136_);
	sudoku = _tmp137_;
	sudoku_length1 = _tmp135_;
	sudoku_length2 = _tmp136_;
	_tmp138_ = gtk_widget_get_default_direction ();
	invert = _tmp138_ == GTK_TEXT_DIR_RTL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp139_ = FALSE;
			_tmp139_ = TRUE;
			while (TRUE) {
				gint _tmp141_;
				gint _tmp142_ = 0;
				gboolean _tmp143_;
				gint real_x = 0;
				if (!_tmp139_) {
					gint _tmp140_;
					_tmp140_ = x;
					x = _tmp140_ + 1;
				}
				_tmp139_ = FALSE;
				_tmp141_ = x;
				if (!(_tmp141_ < SUDOKU_SIZE)) {
					break;
				}
				_tmp143_ = invert;
				if (_tmp143_) {
					gint _tmp144_;
					_tmp144_ = x;
					_tmp142_ = (SUDOKU_SIZE - _tmp144_) - 1;
				} else {
					gint _tmp145_;
					_tmp145_ = x;
					_tmp142_ = _tmp145_;
				}
				real_x = _tmp142_;
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp146_ = FALSE;
						_tmp146_ = TRUE;
						while (TRUE) {
							gint _tmp148_;
							cairo_t* _tmp149_;
							gdouble* _tmp150_;
							gint _tmp150__length1;
							gint _tmp151_;
							gdouble _tmp152_;
							gdouble _tmp153_;
							gdouble* _tmp154_;
							gint _tmp154__length1;
							gint _tmp155_;
							gdouble _tmp156_;
							gdouble _tmp157_;
							gchar* _tmp158_;
							gint* _tmp159_;
							gint _tmp159__length1;
							gint _tmp159__length2;
							gint _tmp160_;
							gint _tmp161_;
							gint _tmp162_;
							if (!_tmp146_) {
								gint _tmp147_;
								_tmp147_ = y;
								y = _tmp147_ + 1;
							}
							_tmp146_ = FALSE;
							_tmp148_ = y;
							if (!(_tmp148_ < SUDOKU_SIZE)) {
								break;
							}
							_tmp149_ = cr;
							_tmp150_ = pos;
							_tmp150__length1 = pos_length1;
							_tmp151_ = x;
							_tmp152_ = _tmp150_[_tmp151_];
							_tmp153_ = offset_x;
							_tmp154_ = pos;
							_tmp154__length1 = pos_length1;
							_tmp155_ = y;
							_tmp156_ = _tmp154_[_tmp155_];
							_tmp157_ = offset_y;
							cairo_move_to (_tmp149_, _tmp152_ + _tmp153_, _tmp156_ + _tmp157_);
							_tmp158_ = g_strdup ("");
							_g_free0 (letter);
							letter = _tmp158_;
							_tmp159_ = sudoku;
							_tmp159__length1 = sudoku_length1;
							_tmp159__length2 = sudoku_length2;
							_tmp160_ = y;
							_tmp161_ = real_x;
							_tmp162_ = _tmp159_[(_tmp160_ * _tmp159__length2) + _tmp161_];
							if (_tmp162_ != 0) {
								gint* _tmp163_;
								gint _tmp163__length1;
								gint _tmp163__length2;
								gint _tmp164_;
								gint _tmp165_;
								gint _tmp166_;
								gchar* _tmp167_;
								SudokuBoard* _tmp168_;
								gboolean* _tmp169_;
								gint _tmp169__length1;
								gint _tmp169__length2;
								gint _tmp170_;
								gint _tmp171_;
								gboolean _tmp172_;
								cairo_t* _tmp180_;
								const gchar* _tmp181_;
								cairo_text_extents_t _tmp182_ = {0};
								cairo_t* _tmp183_;
								gdouble* _tmp184_;
								gint _tmp184__length1;
								gint _tmp185_;
								gdouble _tmp186_;
								gdouble _tmp187_;
								cairo_text_extents_t _tmp188_;
								gdouble _tmp189_;
								gdouble* _tmp190_;
								gint _tmp190__length1;
								gint _tmp191_;
								gdouble _tmp192_;
								gdouble _tmp193_;
								cairo_text_extents_t _tmp194_;
								gdouble _tmp195_;
								cairo_t* _tmp196_;
								const gchar* _tmp197_;
								_tmp163_ = sudoku;
								_tmp163__length1 = sudoku_length1;
								_tmp163__length2 = sudoku_length2;
								_tmp164_ = y;
								_tmp165_ = real_x;
								_tmp166_ = _tmp163_[(_tmp164_ * _tmp163__length2) + _tmp165_];
								_tmp167_ = g_strdup_printf ("%i", _tmp166_);
								_g_free0 (letter);
								letter = _tmp167_;
								_tmp168_ = sudoku_board;
								_tmp169_ = _tmp168_->is_fixed;
								_tmp169__length1 = _tmp168_->is_fixed_length1;
								_tmp169__length2 = _tmp168_->is_fixed_length2;
								_tmp170_ = y;
								_tmp171_ = real_x;
								_tmp172_ = _tmp169_[(_tmp170_ * _tmp169__length2) + _tmp171_];
								if (_tmp172_) {
									cairo_t* _tmp173_;
									cairo_t* _tmp174_;
									_tmp173_ = cr;
									cairo_select_font_face (_tmp173_, "Sans", CAIRO_FONT_SLANT_NORMAL, FONT_WEIGHT);
									_tmp174_ = cr;
									cairo_set_source_rgb (_tmp174_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
								} else {
									cairo_t* _tmp175_;
									cairo_t* _tmp176_;
									gdouble _tmp177_;
									gdouble _tmp178_;
									gdouble _tmp179_;
									_tmp175_ = cr;
									cairo_select_font_face (_tmp175_, "Sans", CAIRO_FONT_SLANT_ITALIC, FONT_WEIGHT);
									_tmp176_ = cr;
									_tmp177_ = PENCIL_GREY[0];
									_tmp178_ = PENCIL_GREY[1];
									_tmp179_ = PENCIL_GREY[2];
									cairo_set_source_rgb (_tmp176_, _tmp177_, _tmp178_, _tmp179_);
								}
								_tmp180_ = cr;
								_tmp181_ = letter;
								cairo_text_extents (_tmp180_, _tmp181_, &_tmp182_);
								extents = _tmp182_;
								_tmp183_ = cr;
								_tmp184_ = pos;
								_tmp184__length1 = pos_length1;
								_tmp185_ = x;
								_tmp186_ = _tmp184_[_tmp185_];
								_tmp187_ = offset_x;
								_tmp188_ = extents;
								_tmp189_ = _tmp188_.x_advance;
								_tmp190_ = pos;
								_tmp190__length1 = pos_length1;
								_tmp191_ = y;
								_tmp192_ = _tmp190_[_tmp191_];
								_tmp193_ = offset_y;
								_tmp194_ = extents;
								_tmp195_ = _tmp194_.height;
								cairo_move_to (_tmp183_, (_tmp186_ + _tmp187_) - (_tmp189_ / 2.0), (_tmp192_ + _tmp193_) + (_tmp195_ / 2.0));
								_tmp196_ = cr;
								_tmp197_ = letter;
								cairo_show_text (_tmp196_, _tmp197_);
							}
						}
					}
				}
			}
		}
	}
	sudoku = (g_free (sudoku), NULL);
	_g_free0 (letter);
	pos = (g_free (pos), NULL);
	outer = (g_free (outer), NULL);
}


static void sudoku_printer_class_init (SudokuPrinterClass * klass) {
	sudoku_printer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuPrinterPrivate));
	G_OBJECT_CLASS (klass)->finalize = sudoku_printer_finalize;
}


static void sudoku_printer_instance_init (SudokuPrinter * self) {
	self->priv = SUDOKU_PRINTER_GET_PRIVATE (self);
}


static void sudoku_printer_finalize (GObject * obj) {
	SudokuPrinter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_PRINTER, SudokuPrinter);
	_g_object_unref0 (self->priv->boards);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->print_op);
	G_OBJECT_CLASS (sudoku_printer_parent_class)->finalize (obj);
}


GType sudoku_printer_get_type (void) {
	static volatile gsize sudoku_printer_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_printer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuPrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuPrinter), 0, (GInstanceInitFunc) sudoku_printer_instance_init, NULL };
		GType sudoku_printer_type_id;
		sudoku_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuPrinter", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_printer_type_id__volatile, sudoku_printer_type_id);
	}
	return sudoku_printer_type_id__volatile;
}



