/* sudoku-board.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include "qqwing-wrapper.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _SudokuBoardPrivate {
	gboolean* possible_in_row;
	gint possible_in_row_length1;
	gint possible_in_row_length2;
	gboolean* possible_in_col;
	gint possible_in_col_length1;
	gint possible_in_col_length2;
	gboolean* possible_in_block;
	gint possible_in_block_length1;
	gint possible_in_block_length2;
	gint possible_in_block_length3;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gint n_earmarks;
	gdouble _previous_played_time;
	DifficultyCategory _difficulty_category;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gint _fixed;
};

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};


static gpointer sudoku_board_parent_class = NULL;

GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
#define SUDOKU_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_BOARD, SudokuBoardPrivate))
enum  {
	SUDOKU_BOARD_DUMMY_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME,
	SUDOKU_BOARD_DIFFICULTY_CATEGORY,
	SUDOKU_BOARD_BLOCK_ROWS,
	SUDOKU_BOARD_BLOCK_COLS,
	SUDOKU_BOARD_ROWS,
	SUDOKU_BOARD_COLS,
	SUDOKU_BOARD_MAX_VAL,
	SUDOKU_BOARD_BROKEN,
	SUDOKU_BOARD_FILLED,
	SUDOKU_BOARD_FIXED,
	SUDOKU_BOARD_SIZE,
	SUDOKU_BOARD_COMPLETE
};
gboolean sudoku_board_is_empty (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_fixed (SudokuBoard* self);
gboolean sudoku_board_is_fully_filled (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static void sudoku_board_set_cols (SudokuBoard* self, gint value);
static void sudoku_board_set_rows (SudokuBoard* self, gint value);
static void sudoku_board_set_block_rows (SudokuBoard* self, gint value);
static void sudoku_board_set_block_cols (SudokuBoard* self, gint value);
gint sudoku_board_get_max_val (SudokuBoard* self);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a, Coord* b);
void coord_init (Coord *self, gint row, gint col);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
static gint* _vala_array_dup1 (gint* self, int length);
static gboolean* _vala_array_dup2 (gboolean* self, int length);
static gboolean* _vala_array_dup3 (gboolean* self, int length);
static gboolean* _vala_array_dup4 (gboolean* self, int length);
static gboolean* _vala_array_dup5 (gboolean* self, int length);
static void sudoku_board_set_filled (SudokuBoard* self, gint value);
static void sudoku_board_set_fixed (SudokuBoard* self, gint value);
static gboolean* _vala_array_dup6 (gboolean* self, int length);
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_disable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_disable_all_earmarks (SudokuBoard* self, gint row, gint column);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
static gint* _vala_array_dup7 (gint* self, int length);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_get_complete (SudokuBoard* self);
void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val);
gint sudoku_board_count_solutions_limited (SudokuBoard* self);
gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self, gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
static gint* _vala_array_dup8 (gint* self, int length);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
const gchar* sudoku_saver_get_finishgame_dir (void);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_get_size (SudokuBoard* self);
static void sudoku_board_finalize (GObject* obj);
static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType house_get_type (void) G_GNUC_CONST;
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self, Coord* coord, gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
gchar* difficulty_category_to_string (DifficultyCategory self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
DifficultyCategory difficulty_category_from_string (const gchar* input);


gboolean sudoku_board_is_empty (SudokuBoard* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_fixed;
	if (_tmp1_ == _tmp2_) {
		gint _tmp3_ = 0;
		_tmp3_ = self->priv->n_earmarks;
		_tmp0_ = _tmp3_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean sudoku_board_is_fully_filled (SudokuBoard* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filled;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = self->priv->_rows;
	result = _tmp0_ == (_tmp1_ * _tmp2_);
	return result;
}


SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols) {
	SudokuBoard * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gboolean* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gboolean* _tmp25_ = NULL;
	GeeHashSet* _tmp68_ = NULL;
	GeeArrayList* _tmp69_ = NULL;
	GeeList* _tmp97_ = NULL;
	GeeList* _tmp98_ = NULL;
	GeeList* _tmp99_ = NULL;
	GeeArrayList* _tmp100_ = NULL;
	GeeList* _tmp128_ = NULL;
	GeeList* _tmp129_ = NULL;
	GeeList* _tmp130_ = NULL;
	GeeHashMap* _tmp131_ = NULL;
	GeeMap* _tmp186_ = NULL;
	GeeMap* _tmp187_ = NULL;
	GeeMap* _tmp188_ = NULL;
	self = (SudokuBoard*) g_object_new (object_type, NULL);
	_tmp0_ = block_rows;
	_tmp1_ = block_cols;
	sudoku_board_set_cols (self, _tmp0_ * _tmp1_);
	sudoku_board_set_rows (self, _tmp0_ * _tmp1_);
	_tmp2_ = block_rows;
	sudoku_board_set_block_rows (self, _tmp2_);
	_tmp3_ = block_cols;
	sudoku_board_set_block_cols (self, _tmp3_);
	_tmp4_ = self->priv->_rows;
	_tmp5_ = self->priv->_cols;
	_tmp6_ = g_new0 (gint, _tmp4_ * _tmp5_);
	self->cells = (g_free (self->cells), NULL);
	self->cells = _tmp6_;
	self->cells_length1 = _tmp4_;
	self->cells_length2 = _tmp5_;
	_tmp7_ = self->priv->_rows;
	_tmp8_ = self->priv->_cols;
	_tmp9_ = g_new0 (gboolean, _tmp7_ * _tmp8_);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->is_fixed = _tmp9_;
	self->is_fixed_length1 = _tmp7_;
	self->is_fixed_length2 = _tmp8_;
	_tmp10_ = self->priv->_rows;
	_tmp11_ = self->priv->_cols;
	_tmp12_ = g_new0 (gboolean, _tmp10_ * _tmp11_);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_row = _tmp12_;
	self->priv->possible_in_row_length1 = _tmp10_;
	self->priv->possible_in_row_length2 = _tmp11_;
	_tmp13_ = self->priv->_cols;
	_tmp14_ = self->priv->_rows;
	_tmp15_ = g_new0 (gboolean, _tmp13_ * _tmp14_);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_col = _tmp15_;
	self->priv->possible_in_col_length1 = _tmp13_;
	self->priv->possible_in_col_length2 = _tmp14_;
	_tmp16_ = block_rows;
	_tmp17_ = block_cols;
	_tmp18_ = block_rows;
	_tmp19_ = block_cols;
	_tmp20_ = g_new0 (gboolean, (_tmp16_ * _tmp17_) * (_tmp18_ * _tmp19_));
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->priv->possible_in_block = _tmp20_;
	self->priv->possible_in_block_length1 = _tmp16_;
	self->priv->possible_in_block_length2 = _tmp17_;
	self->priv->possible_in_block_length3 = _tmp18_ * _tmp19_;
	_tmp21_ = self->priv->_rows;
	_tmp22_ = self->priv->_cols;
	_tmp23_ = sudoku_board_get_max_val (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_new0 (gboolean, (_tmp21_ * _tmp22_) * _tmp24_);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	self->priv->earmarks = _tmp25_;
	self->priv->earmarks_length1 = _tmp21_;
	self->priv->earmarks_length2 = _tmp22_;
	self->priv->earmarks_length3 = _tmp24_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				if (!_tmp26_) {
					gint _tmp27_ = 0;
					_tmp27_ = l1;
					l1 = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = l1;
				_tmp29_ = self->priv->_rows;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint* _tmp34_ = NULL;
							gint _tmp34__length1 = 0;
							gint _tmp34__length2 = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gboolean* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gboolean _tmp41_ = FALSE;
							gboolean* _tmp42_ = NULL;
							gint _tmp42__length1 = 0;
							gint _tmp42__length2 = 0;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gboolean _tmp45_ = FALSE;
							gboolean* _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gboolean _tmp49_ = FALSE;
							if (!_tmp30_) {
								gint _tmp31_ = 0;
								_tmp31_ = l2;
								l2 = _tmp31_ + 1;
							}
							_tmp30_ = FALSE;
							_tmp32_ = l2;
							_tmp33_ = self->priv->_cols;
							if (!(_tmp32_ < _tmp33_)) {
								break;
							}
							_tmp34_ = self->cells;
							_tmp34__length1 = self->cells_length1;
							_tmp34__length2 = self->cells_length2;
							_tmp35_ = l1;
							_tmp36_ = l2;
							_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = 0;
							_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
							_tmp38_ = self->is_fixed;
							_tmp38__length1 = self->is_fixed_length1;
							_tmp38__length2 = self->is_fixed_length2;
							_tmp39_ = l1;
							_tmp40_ = l2;
							_tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_] = FALSE;
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
							_tmp42_ = self->priv->possible_in_row;
							_tmp42__length1 = self->priv->possible_in_row_length1;
							_tmp42__length2 = self->priv->possible_in_row_length2;
							_tmp43_ = l1;
							_tmp44_ = l2;
							_tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_] = TRUE;
							_tmp45_ = _tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_];
							_tmp46_ = self->priv->possible_in_col;
							_tmp46__length1 = self->priv->possible_in_col_length1;
							_tmp46__length2 = self->priv->possible_in_col_length2;
							_tmp47_ = l2;
							_tmp48_ = l1;
							_tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_] = TRUE;
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				if (!_tmp50_) {
					gint _tmp51_ = 0;
					_tmp51_ = l1;
					l1 = _tmp51_ + 1;
				}
				_tmp50_ = FALSE;
				_tmp52_ = l1;
				_tmp53_ = block_rows;
				if (!(_tmp52_ < _tmp53_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp54_ = FALSE;
						_tmp54_ = TRUE;
						while (TRUE) {
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
							if (!_tmp54_) {
								gint _tmp55_ = 0;
								_tmp55_ = l2;
								l2 = _tmp55_ + 1;
							}
							_tmp54_ = FALSE;
							_tmp56_ = l2;
							_tmp57_ = block_cols;
							if (!(_tmp56_ < _tmp57_)) {
								break;
							}
							{
								gint l3 = 0;
								l3 = 0;
								{
									gboolean _tmp58_ = FALSE;
									_tmp58_ = TRUE;
									while (TRUE) {
										gint _tmp60_ = 0;
										gint _tmp61_ = 0;
										gint _tmp62_ = 0;
										gboolean* _tmp63_ = NULL;
										gint _tmp63__length1 = 0;
										gint _tmp63__length2 = 0;
										gint _tmp63__length3 = 0;
										gint _tmp64_ = 0;
										gint _tmp65_ = 0;
										gint _tmp66_ = 0;
										gboolean _tmp67_ = FALSE;
										if (!_tmp58_) {
											gint _tmp59_ = 0;
											_tmp59_ = l3;
											l3 = _tmp59_ + 1;
										}
										_tmp58_ = FALSE;
										_tmp60_ = l3;
										_tmp61_ = sudoku_board_get_max_val (self);
										_tmp62_ = _tmp61_;
										if (!(_tmp60_ < _tmp62_)) {
											break;
										}
										_tmp63_ = self->priv->possible_in_block;
										_tmp63__length1 = self->priv->possible_in_block_length1;
										_tmp63__length2 = self->priv->possible_in_block_length2;
										_tmp63__length3 = self->priv->possible_in_block_length3;
										_tmp64_ = l1;
										_tmp65_ = l2;
										_tmp66_ = l3;
										_tmp63_[(((_tmp64_ * _tmp63__length2) + _tmp65_) * _tmp63__length3) + _tmp66_] = TRUE;
										_tmp67_ = _tmp63_[(((_tmp64_ * _tmp63__length2) + _tmp65_) * _tmp63__length3) + _tmp66_];
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp68_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	_g_object_unref0 (self->broken_coords);
	self->broken_coords = (GeeSet*) _tmp68_;
	_tmp69_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = (GeeList*) _tmp69_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp70_ = FALSE;
			_tmp70_ = TRUE;
			while (TRUE) {
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				GeeList* _tmp74_ = NULL;
				GeeArrayList* _tmp75_ = NULL;
				GeeArrayList* _tmp76_ = NULL;
				GeeList* _tmp88_ = NULL;
				gint _tmp89_ = 0;
				GeeList* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				gpointer _tmp92_ = NULL;
				GeeList* _tmp93_ = NULL;
				GeeList* _tmp94_ = NULL;
				GeeList* _tmp95_ = NULL;
				GeeList* _tmp96_ = NULL;
				if (!_tmp70_) {
					gint _tmp71_ = 0;
					_tmp71_ = col;
					col = _tmp71_ + 1;
				}
				_tmp70_ = FALSE;
				_tmp72_ = col;
				_tmp73_ = self->priv->_cols;
				if (!(_tmp72_ < _tmp73_)) {
					break;
				}
				_tmp74_ = self->coords_for_col;
				_tmp75_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp76_ = _tmp75_;
				gee_collection_add ((GeeCollection*) _tmp74_, (GeeList*) _tmp76_);
				_g_object_unref0 (_tmp76_);
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp77_ = FALSE;
						_tmp77_ = TRUE;
						while (TRUE) {
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							GeeList* _tmp81_ = NULL;
							gint _tmp82_ = 0;
							gpointer _tmp83_ = NULL;
							GeeList* _tmp84_ = NULL;
							gint _tmp85_ = 0;
							gint _tmp86_ = 0;
							Coord _tmp87_ = {0};
							if (!_tmp77_) {
								gint _tmp78_ = 0;
								_tmp78_ = row;
								row = _tmp78_ + 1;
							}
							_tmp77_ = FALSE;
							_tmp79_ = row;
							_tmp80_ = self->priv->_rows;
							if (!(_tmp79_ < _tmp80_)) {
								break;
							}
							_tmp81_ = self->coords_for_col;
							_tmp82_ = col;
							_tmp83_ = gee_list_get (_tmp81_, _tmp82_);
							_tmp84_ = (GeeList*) _tmp83_;
							_tmp85_ = row;
							_tmp86_ = col;
							coord_init (&_tmp87_, _tmp85_, _tmp86_);
							gee_collection_add ((GeeCollection*) _tmp84_, &_tmp87_);
							_g_object_unref0 (_tmp84_);
						}
					}
				}
				_tmp88_ = self->coords_for_col;
				_tmp89_ = col;
				_tmp90_ = self->coords_for_col;
				_tmp91_ = col;
				_tmp92_ = gee_list_get (_tmp90_, _tmp91_);
				_tmp93_ = (GeeList*) _tmp92_;
				_tmp94_ = gee_list_get_read_only_view (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = _tmp95_;
				gee_list_set (_tmp88_, _tmp89_, _tmp96_);
				_g_object_unref0 (_tmp96_);
				_g_object_unref0 (_tmp93_);
			}
		}
	}
	_tmp97_ = self->coords_for_col;
	_tmp98_ = gee_list_get_read_only_view (_tmp97_);
	_tmp99_ = _tmp98_;
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = _tmp99_;
	_tmp100_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = (GeeList*) _tmp100_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp101_ = FALSE;
			_tmp101_ = TRUE;
			while (TRUE) {
				gint _tmp103_ = 0;
				gint _tmp104_ = 0;
				GeeList* _tmp105_ = NULL;
				GeeArrayList* _tmp106_ = NULL;
				GeeArrayList* _tmp107_ = NULL;
				GeeList* _tmp119_ = NULL;
				gint _tmp120_ = 0;
				GeeList* _tmp121_ = NULL;
				gint _tmp122_ = 0;
				gpointer _tmp123_ = NULL;
				GeeList* _tmp124_ = NULL;
				GeeList* _tmp125_ = NULL;
				GeeList* _tmp126_ = NULL;
				GeeList* _tmp127_ = NULL;
				if (!_tmp101_) {
					gint _tmp102_ = 0;
					_tmp102_ = row;
					row = _tmp102_ + 1;
				}
				_tmp101_ = FALSE;
				_tmp103_ = row;
				_tmp104_ = self->priv->_rows;
				if (!(_tmp103_ < _tmp104_)) {
					break;
				}
				_tmp105_ = self->coords_for_row;
				_tmp106_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp107_ = _tmp106_;
				gee_collection_add ((GeeCollection*) _tmp105_, (GeeList*) _tmp107_);
				_g_object_unref0 (_tmp107_);
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp108_ = FALSE;
						_tmp108_ = TRUE;
						while (TRUE) {
							gint _tmp110_ = 0;
							gint _tmp111_ = 0;
							GeeList* _tmp112_ = NULL;
							gint _tmp113_ = 0;
							gpointer _tmp114_ = NULL;
							GeeList* _tmp115_ = NULL;
							gint _tmp116_ = 0;
							gint _tmp117_ = 0;
							Coord _tmp118_ = {0};
							if (!_tmp108_) {
								gint _tmp109_ = 0;
								_tmp109_ = col;
								col = _tmp109_ + 1;
							}
							_tmp108_ = FALSE;
							_tmp110_ = col;
							_tmp111_ = self->priv->_cols;
							if (!(_tmp110_ < _tmp111_)) {
								break;
							}
							_tmp112_ = self->coords_for_row;
							_tmp113_ = row;
							_tmp114_ = gee_list_get (_tmp112_, _tmp113_);
							_tmp115_ = (GeeList*) _tmp114_;
							_tmp116_ = row;
							_tmp117_ = col;
							coord_init (&_tmp118_, _tmp116_, _tmp117_);
							gee_collection_add ((GeeCollection*) _tmp115_, &_tmp118_);
							_g_object_unref0 (_tmp115_);
						}
					}
				}
				_tmp119_ = self->coords_for_row;
				_tmp120_ = row;
				_tmp121_ = self->coords_for_row;
				_tmp122_ = row;
				_tmp123_ = gee_list_get (_tmp121_, _tmp122_);
				_tmp124_ = (GeeList*) _tmp123_;
				_tmp125_ = gee_list_get_read_only_view (_tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = _tmp126_;
				gee_list_set (_tmp119_, _tmp120_, _tmp127_);
				_g_object_unref0 (_tmp127_);
				_g_object_unref0 (_tmp124_);
			}
		}
	}
	_tmp128_ = self->coords_for_row;
	_tmp129_ = gee_list_get_read_only_view (_tmp128_);
	_tmp130_ = _tmp129_;
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = _tmp130_;
	_tmp131_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = (GeeMap*) _tmp131_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp132_ = FALSE;
			_tmp132_ = TRUE;
			while (TRUE) {
				gint _tmp134_ = 0;
				gint _tmp135_ = 0;
				if (!_tmp132_) {
					gint _tmp133_ = 0;
					_tmp133_ = col;
					col = _tmp133_ + 1;
				}
				_tmp132_ = FALSE;
				_tmp134_ = col;
				_tmp135_ = block_cols;
				if (!(_tmp134_ < _tmp135_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp136_ = FALSE;
						_tmp136_ = TRUE;
						while (TRUE) {
							gint _tmp138_ = 0;
							gint _tmp139_ = 0;
							GeeMap* _tmp140_ = NULL;
							gint _tmp141_ = 0;
							gint _tmp142_ = 0;
							Coord _tmp143_ = {0};
							GeeArrayList* _tmp144_ = NULL;
							GeeArrayList* _tmp145_ = NULL;
							if (!_tmp136_) {
								gint _tmp137_ = 0;
								_tmp137_ = row;
								row = _tmp137_ + 1;
							}
							_tmp136_ = FALSE;
							_tmp138_ = row;
							_tmp139_ = block_rows;
							if (!(_tmp138_ < _tmp139_)) {
								break;
							}
							_tmp140_ = self->coords_for_block;
							_tmp141_ = row;
							_tmp142_ = col;
							coord_init (&_tmp143_, _tmp141_, _tmp142_);
							_tmp144_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
							_tmp145_ = _tmp144_;
							gee_map_set (_tmp140_, &_tmp143_, (GeeList*) _tmp145_);
							_g_object_unref0 (_tmp145_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp146_ = FALSE;
			_tmp146_ = TRUE;
			while (TRUE) {
				gint _tmp148_ = 0;
				gint _tmp149_ = 0;
				if (!_tmp146_) {
					gint _tmp147_ = 0;
					_tmp147_ = col;
					col = _tmp147_ + 1;
				}
				_tmp146_ = FALSE;
				_tmp148_ = col;
				_tmp149_ = self->priv->_cols;
				if (!(_tmp148_ < _tmp149_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp150_ = FALSE;
						_tmp150_ = TRUE;
						while (TRUE) {
							gint _tmp152_ = 0;
							gint _tmp153_ = 0;
							GeeMap* _tmp154_ = NULL;
							gint _tmp155_ = 0;
							gint _tmp156_ = 0;
							gint _tmp157_ = 0;
							gint _tmp158_ = 0;
							Coord _tmp159_ = {0};
							gpointer _tmp160_ = NULL;
							GeeList* _tmp161_ = NULL;
							gint _tmp162_ = 0;
							gint _tmp163_ = 0;
							Coord _tmp164_ = {0};
							if (!_tmp150_) {
								gint _tmp151_ = 0;
								_tmp151_ = row;
								row = _tmp151_ + 1;
							}
							_tmp150_ = FALSE;
							_tmp152_ = row;
							_tmp153_ = self->priv->_rows;
							if (!(_tmp152_ < _tmp153_)) {
								break;
							}
							_tmp154_ = self->coords_for_block;
							_tmp155_ = row;
							_tmp156_ = block_rows;
							_tmp157_ = col;
							_tmp158_ = block_cols;
							coord_init (&_tmp159_, _tmp155_ / _tmp156_, _tmp157_ / _tmp158_);
							_tmp160_ = gee_map_get (_tmp154_, &_tmp159_);
							_tmp161_ = (GeeList*) _tmp160_;
							_tmp162_ = row;
							_tmp163_ = col;
							coord_init (&_tmp164_, _tmp162_, _tmp163_);
							gee_collection_add ((GeeCollection*) _tmp161_, &_tmp164_);
							_g_object_unref0 (_tmp161_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp165_ = FALSE;
			_tmp165_ = TRUE;
			while (TRUE) {
				gint _tmp167_ = 0;
				gint _tmp168_ = 0;
				if (!_tmp165_) {
					gint _tmp166_ = 0;
					_tmp166_ = col;
					col = _tmp166_ + 1;
				}
				_tmp165_ = FALSE;
				_tmp167_ = col;
				_tmp168_ = block_cols;
				if (!(_tmp167_ < _tmp168_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp169_ = FALSE;
						_tmp169_ = TRUE;
						while (TRUE) {
							gint _tmp171_ = 0;
							gint _tmp172_ = 0;
							GeeMap* _tmp173_ = NULL;
							gint _tmp174_ = 0;
							gint _tmp175_ = 0;
							Coord _tmp176_ = {0};
							GeeMap* _tmp177_ = NULL;
							gint _tmp178_ = 0;
							gint _tmp179_ = 0;
							Coord _tmp180_ = {0};
							gpointer _tmp181_ = NULL;
							GeeList* _tmp182_ = NULL;
							GeeList* _tmp183_ = NULL;
							GeeList* _tmp184_ = NULL;
							GeeList* _tmp185_ = NULL;
							if (!_tmp169_) {
								gint _tmp170_ = 0;
								_tmp170_ = row;
								row = _tmp170_ + 1;
							}
							_tmp169_ = FALSE;
							_tmp171_ = row;
							_tmp172_ = block_rows;
							if (!(_tmp171_ < _tmp172_)) {
								break;
							}
							_tmp173_ = self->coords_for_block;
							_tmp174_ = row;
							_tmp175_ = col;
							coord_init (&_tmp176_, _tmp174_, _tmp175_);
							_tmp177_ = self->coords_for_block;
							_tmp178_ = row;
							_tmp179_ = col;
							coord_init (&_tmp180_, _tmp178_, _tmp179_);
							_tmp181_ = gee_map_get (_tmp177_, &_tmp180_);
							_tmp182_ = (GeeList*) _tmp181_;
							_tmp183_ = gee_list_get_read_only_view (_tmp182_);
							_tmp184_ = _tmp183_;
							_tmp185_ = _tmp184_;
							gee_map_set (_tmp173_, &_tmp176_, _tmp185_);
							_g_object_unref0 (_tmp185_);
							_g_object_unref0 (_tmp182_);
						}
					}
				}
			}
		}
	}
	_tmp186_ = self->coords_for_block;
	_tmp187_ = gee_map_get_read_only_view (_tmp186_);
	_tmp188_ = _tmp187_;
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = _tmp188_;
	return self;
}


SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols) {
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gboolean* _vala_array_dup2 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean* _vala_array_dup3 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean* _vala_array_dup4 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean* _vala_array_dup5 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean* _vala_array_dup6 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


SudokuBoard* sudoku_board_clone (SudokuBoard* self) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuBoard* _tmp2_ = NULL;
	gint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gboolean* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gboolean* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gboolean* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	gboolean* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gboolean* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gboolean* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	gint _tmp11__length3 = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp12__length2 = 0;
	gint _tmp12__length3 = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GeeSet* _tmp16_ = NULL;
	GeeSet* _tmp17_ = NULL;
	gboolean* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp18__length2 = 0;
	gint _tmp18__length3 = 0;
	gboolean* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint _tmp19__length2 = 0;
	gint _tmp19__length3 = 0;
	DifficultyCategory _tmp20_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
	board = _tmp2_;
	_tmp3_ = self->cells;
	_tmp3__length1 = self->cells_length1;
	_tmp3__length2 = self->cells_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	board->cells = (g_free (board->cells), NULL);
	board->cells = _tmp4_;
	board->cells_length1 = _tmp4__length1;
	board->cells_length2 = _tmp4__length2;
	_tmp5_ = self->is_fixed;
	_tmp5__length1 = self->is_fixed_length1;
	_tmp5__length2 = self->is_fixed_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	board->is_fixed = (g_free (board->is_fixed), NULL);
	board->is_fixed = _tmp6_;
	board->is_fixed_length1 = _tmp6__length1;
	board->is_fixed_length2 = _tmp6__length2;
	_tmp7_ = self->priv->possible_in_row;
	_tmp7__length1 = self->priv->possible_in_row_length1;
	_tmp7__length2 = self->priv->possible_in_row_length2;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	_tmp8__length2 = _tmp7__length2;
	board->priv->possible_in_row = (g_free (board->priv->possible_in_row), NULL);
	board->priv->possible_in_row = _tmp8_;
	board->priv->possible_in_row_length1 = _tmp8__length1;
	board->priv->possible_in_row_length2 = _tmp8__length2;
	_tmp9_ = self->priv->possible_in_col;
	_tmp9__length1 = self->priv->possible_in_col_length1;
	_tmp9__length2 = self->priv->possible_in_col_length2;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	_tmp10__length2 = _tmp9__length2;
	board->priv->possible_in_col = (g_free (board->priv->possible_in_col), NULL);
	board->priv->possible_in_col = _tmp10_;
	board->priv->possible_in_col_length1 = _tmp10__length1;
	board->priv->possible_in_col_length2 = _tmp10__length2;
	_tmp11_ = self->priv->possible_in_block;
	_tmp11__length1 = self->priv->possible_in_block_length1;
	_tmp11__length2 = self->priv->possible_in_block_length2;
	_tmp11__length3 = self->priv->possible_in_block_length3;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, (_tmp11__length1 * _tmp11__length2) * _tmp11__length3) : ((gpointer) _tmp11_);
	_tmp12__length1 = _tmp11__length1;
	_tmp12__length2 = _tmp11__length2;
	_tmp12__length3 = _tmp11__length3;
	board->priv->possible_in_block = (g_free (board->priv->possible_in_block), NULL);
	board->priv->possible_in_block = _tmp12_;
	board->priv->possible_in_block_length1 = _tmp12__length1;
	board->priv->possible_in_block_length2 = _tmp12__length2;
	board->priv->possible_in_block_length3 = _tmp12__length3;
	_tmp13_ = self->priv->_filled;
	sudoku_board_set_filled (board, _tmp13_);
	_tmp14_ = self->priv->_fixed;
	sudoku_board_set_fixed (board, _tmp14_);
	_tmp15_ = self->priv->n_earmarks;
	board->priv->n_earmarks = _tmp15_;
	_tmp16_ = board->broken_coords;
	_tmp17_ = self->broken_coords;
	gee_collection_add_all ((GeeCollection*) _tmp16_, (GeeCollection*) _tmp17_);
	_tmp18_ = self->priv->earmarks;
	_tmp18__length1 = self->priv->earmarks_length1;
	_tmp18__length2 = self->priv->earmarks_length2;
	_tmp18__length3 = self->priv->earmarks_length3;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup6 (_tmp18_, (_tmp18__length1 * _tmp18__length2) * _tmp18__length3) : ((gpointer) _tmp18_);
	_tmp19__length1 = _tmp18__length1;
	_tmp19__length2 = _tmp18__length2;
	_tmp19__length3 = _tmp18__length3;
	board->priv->earmarks = (g_free (board->priv->earmarks), NULL);
	board->priv->earmarks = _tmp19_;
	board->priv->earmarks_length1 = _tmp19__length1;
	board->priv->earmarks_length2 = _tmp19__length2;
	board->priv->earmarks_length3 = _tmp19__length3;
	_tmp20_ = self->priv->_difficulty_category;
	sudoku_board_set_difficulty_category (board, _tmp20_);
	result = board;
	return result;
}


void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = row;
	_tmp2_ = column;
	_tmp3_ = digit;
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
	if (!_tmp4_) {
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp5__length3 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
		_tmp5_ = self->priv->earmarks;
		_tmp5__length1 = self->priv->earmarks_length1;
		_tmp5__length2 = self->priv->earmarks_length2;
		_tmp5__length3 = self->priv->earmarks_length3;
		_tmp6_ = row;
		_tmp7_ = column;
		_tmp8_ = digit;
		_tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)] = TRUE;
		_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
		_tmp10_ = self->priv->n_earmarks;
		self->priv->n_earmarks = _tmp10_ + 1;
	}
	_tmp11_ = self->priv->n_earmarks;
	_vala_warn_if_fail (_tmp11_ > 0, "n_earmarks > 0");
}


void sudoku_board_disable_earmark (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = row;
	_tmp2_ = column;
	_tmp3_ = digit;
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
	if (_tmp4_) {
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp5__length3 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
		_tmp5_ = self->priv->earmarks;
		_tmp5__length1 = self->priv->earmarks_length1;
		_tmp5__length2 = self->priv->earmarks_length2;
		_tmp5__length3 = self->priv->earmarks_length3;
		_tmp6_ = row;
		_tmp7_ = column;
		_tmp8_ = digit;
		_tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)] = FALSE;
		_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
		_tmp10_ = self->priv->n_earmarks;
		self->priv->n_earmarks = _tmp10_ - 1;
	}
	_tmp11_ = self->priv->n_earmarks;
	_vala_warn_if_fail (_tmp11_ >= 0, "n_earmarks >= 0");
}


void sudoku_board_disable_all_earmarks (SudokuBoard* self, gint row, gint column) {
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gboolean* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				gint _tmp5__length3 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = sudoku_board_get_max_val (self);
				_tmp4_ = _tmp3_;
				if (!(_tmp2_ <= _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->earmarks;
				_tmp5__length1 = self->priv->earmarks_length1;
				_tmp5__length2 = self->priv->earmarks_length2;
				_tmp5__length3 = self->priv->earmarks_length3;
				_tmp6_ = row;
				_tmp7_ = column;
				_tmp8_ = i;
				_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
				if (_tmp9_) {
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp10_ = row;
					_tmp11_ = column;
					_tmp12_ = i;
					sudoku_board_disable_earmark (self, _tmp10_, _tmp11_, _tmp12_);
				}
			}
		}
	}
	_tmp13_ = self->priv->n_earmarks;
	_vala_warn_if_fail (_tmp13_ >= 0, "n_earmarks >= 0");
}


gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean result = FALSE;
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = row;
	_tmp2_ = column;
	_tmp3_ = digit;
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
	result = _tmp4_;
	return result;
}


gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = val;
	val = _tmp0_ - 1;
	_tmp3_ = self->priv->possible_in_row;
	_tmp3__length1 = self->priv->possible_in_row_length1;
	_tmp3__length2 = self->priv->possible_in_row_length2;
	_tmp4_ = row;
	_tmp5_ = val;
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
	if (_tmp6_) {
		gboolean* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = self->priv->possible_in_col;
		_tmp7__length1 = self->priv->possible_in_col_length1;
		_tmp7__length2 = self->priv->possible_in_col_length2;
		_tmp8_ = col;
		_tmp9_ = val;
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
		_tmp2_ = _tmp10_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp11__length3 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
		_tmp11_ = self->priv->possible_in_block;
		_tmp11__length1 = self->priv->possible_in_block_length1;
		_tmp11__length2 = self->priv->possible_in_block_length2;
		_tmp11__length3 = self->priv->possible_in_block_length3;
		_tmp12_ = row;
		_tmp13_ = self->priv->_block_cols;
		_tmp14_ = col;
		_tmp15_ = self->priv->_block_rows;
		_tmp16_ = val;
		_tmp17_ = _tmp11_[((((_tmp12_ / _tmp13_) * _tmp11__length2) + (_tmp14_ / _tmp15_)) * _tmp11__length3) + _tmp16_];
		_tmp1_ = _tmp17_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}


gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = row;
	_tmp1_ = col;
	_tmp3_ = sudoku_board_get_possibilities (self, _tmp0_, _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = _tmp2_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	result = _tmp5_;
	return result;
}


static gint* _vala_array_dup7 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint* possibilities = NULL;
	gint* _tmp6_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gint count = 0;
	gint* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	if (_tmp3_ != 0) {
		gint* _tmp4_ = NULL;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp4_ = g_new0 (gint, 0);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_new0 (gint, 9);
	possibilities = _tmp6_;
	possibilities_length1 = 9;
	_possibilities_size_ = possibilities_length1;
	count = 0;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = l;
					l = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = l;
				_tmp10_ = sudoku_board_get_max_val (self);
				_tmp11_ = _tmp10_;
				if (!(_tmp9_ <= _tmp11_)) {
					break;
				}
				_tmp12_ = row;
				_tmp13_ = col;
				_tmp14_ = l;
				_tmp15_ = sudoku_board_is_possible (self, _tmp12_, _tmp13_, _tmp14_);
				if (_tmp15_) {
					gint* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					_tmp16_ = possibilities;
					_tmp16__length1 = possibilities_length1;
					_tmp17_ = count;
					_tmp18_ = l;
					_tmp16_[_tmp17_] = _tmp18_;
					_tmp19_ = _tmp16_[_tmp17_];
					_tmp20_ = count;
					count = _tmp20_ + 1;
				}
			}
		}
	}
	_tmp21_ = possibilities;
	_tmp21__length1 = possibilities_length1;
	_tmp22_ = count;
	_tmp23_ = ((_tmp21_ + 0) != NULL) ? _vala_array_dup7 (_tmp21_ + 0, _tmp22_ - 0) : ((gpointer) (_tmp21_ + 0));
	_tmp23__length1 = _tmp22_ - 0;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = _tmp23__length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	possibilities = (g_free (possibilities), NULL);
	return result;
}


gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gboolean* result = NULL;
	gboolean* possibilities = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean* _tmp2_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	possibilities = _tmp2_;
	possibilities_length1 = _tmp1_;
	_possibilities_size_ = possibilities_length1;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gboolean* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = l;
					l = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = l;
				_tmp6_ = sudoku_board_get_max_val (self);
				_tmp7_ = _tmp6_;
				if (!(_tmp5_ <= _tmp7_)) {
					break;
				}
				_tmp8_ = possibilities;
				_tmp8__length1 = possibilities_length1;
				_tmp9_ = l;
				_tmp10_ = row;
				_tmp11_ = col;
				_tmp12_ = l;
				_tmp13_ = sudoku_board_is_possible (self, _tmp10_, _tmp11_, _tmp12_);
				_tmp8_[_tmp9_ - 1] = _tmp13_;
				_tmp14_ = _tmp8_[_tmp9_ - 1];
			}
		}
	}
	_tmp15_ = possibilities;
	_tmp15__length1 = possibilities_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}


void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Coord _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = row;
	_tmp1_ = self->priv->_block_rows;
	_tmp2_ = col;
	_tmp3_ = self->priv->_block_cols;
	coord_init (&_tmp4_, _tmp0_ / _tmp1_, _tmp2_ / _tmp3_);
	*result = _tmp4_;
	return;
}


void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gboolean _tmp27_ = FALSE;
	gboolean* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gint _tmp29__length2 = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gboolean _tmp32_ = FALSE;
	gboolean* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp38__length2 = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gboolean _tmp41_ = FALSE;
	gboolean* _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
	gint _tmp47__length2 = 0;
	gint _tmp47__length3 = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	gboolean _tmp53_ = FALSE;
	gint _tmp63_ = 0;
	gboolean* _tmp64_ = NULL;
	gint _tmp64__length1 = 0;
	gint _tmp64__length2 = 0;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gboolean _tmp67_ = FALSE;
	gboolean* _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	gint _tmp68__length2 = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	gboolean _tmp71_ = FALSE;
	gboolean* _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	gint _tmp72__length2 = 0;
	gint _tmp72__length3 = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = val;
	_vala_assert (_tmp0_ > 0, "val > 0");
	_tmp1_ = val;
	_tmp2_ = sudoku_board_get_max_val (self);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp1_ <= _tmp3_, "val <= max_val");
	_tmp4_ = is_fixed;
	if (!_tmp4_) {
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->is_fixed;
		_tmp5__length1 = self->is_fixed_length1;
		_tmp5__length2 = self->is_fixed_length2;
		_tmp6_ = row;
		_tmp7_ = col;
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
	}
	_tmp9_ = self->cells;
	_tmp9__length1 = self->cells_length1;
	_tmp9__length2 = self->cells_length2;
	_tmp10_ = row;
	_tmp11_ = col;
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
	if (_tmp12_ != 0) {
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = row;
		_tmp14_ = col;
		_tmp15_ = is_fixed;
		sudoku_board_remove (self, _tmp13_, _tmp14_, _tmp15_);
	}
	_tmp16_ = self->cells;
	_tmp16__length1 = self->cells_length1;
	_tmp16__length2 = self->cells_length2;
	_tmp17_ = row;
	_tmp18_ = col;
	_tmp19_ = val;
	_tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_] = _tmp19_;
	_tmp20_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
	_tmp21_ = self->is_fixed;
	_tmp21__length1 = self->is_fixed_length1;
	_tmp21__length2 = self->is_fixed_length2;
	_tmp22_ = row;
	_tmp23_ = col;
	_tmp24_ = is_fixed;
	_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_;
	_tmp25_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
	_tmp26_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp26_ + 1);
	_tmp27_ = is_fixed;
	if (_tmp27_) {
		gint _tmp28_ = 0;
		_tmp28_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp28_ + 1);
	}
	_tmp29_ = self->priv->possible_in_row;
	_tmp29__length1 = self->priv->possible_in_row_length1;
	_tmp29__length2 = self->priv->possible_in_row_length2;
	_tmp30_ = row;
	_tmp31_ = val;
	_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + (_tmp31_ - 1)];
	if (!_tmp32_) {
		GeeList* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gpointer _tmp35_ = NULL;
		GeeList* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		_tmp33_ = self->coords_for_row;
		_tmp34_ = row;
		_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
		_tmp36_ = (GeeList*) _tmp35_;
		_tmp37_ = val;
		sudoku_board_mark_breakages_for (self, _tmp36_, _tmp37_);
		_g_object_unref0 (_tmp36_);
	}
	_tmp38_ = self->priv->possible_in_col;
	_tmp38__length1 = self->priv->possible_in_col_length1;
	_tmp38__length2 = self->priv->possible_in_col_length2;
	_tmp39_ = col;
	_tmp40_ = val;
	_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + (_tmp40_ - 1)];
	if (!_tmp41_) {
		GeeList* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gpointer _tmp44_ = NULL;
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		_tmp42_ = self->coords_for_col;
		_tmp43_ = col;
		_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
		_tmp45_ = (GeeList*) _tmp44_;
		_tmp46_ = val;
		sudoku_board_mark_breakages_for (self, _tmp45_, _tmp46_);
		_g_object_unref0 (_tmp45_);
	}
	_tmp47_ = self->priv->possible_in_block;
	_tmp47__length1 = self->priv->possible_in_block_length1;
	_tmp47__length2 = self->priv->possible_in_block_length2;
	_tmp47__length3 = self->priv->possible_in_block_length3;
	_tmp48_ = row;
	_tmp49_ = self->priv->_block_cols;
	_tmp50_ = col;
	_tmp51_ = self->priv->_block_rows;
	_tmp52_ = val;
	_tmp53_ = _tmp47_[((((_tmp48_ / _tmp49_) * _tmp47__length2) + (_tmp50_ / _tmp51_)) * _tmp47__length3) + (_tmp52_ - 1)];
	if (!_tmp53_) {
		GeeMap* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		Coord _tmp59_ = {0};
		gpointer _tmp60_ = NULL;
		GeeList* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		_tmp54_ = self->coords_for_block;
		_tmp55_ = row;
		_tmp56_ = self->priv->_block_cols;
		_tmp57_ = col;
		_tmp58_ = self->priv->_block_rows;
		coord_init (&_tmp59_, _tmp55_ / _tmp56_, _tmp57_ / _tmp58_);
		_tmp60_ = gee_map_get (_tmp54_, &_tmp59_);
		_tmp61_ = (GeeList*) _tmp60_;
		_tmp62_ = val;
		sudoku_board_mark_breakages_for (self, _tmp61_, _tmp62_);
		_g_object_unref0 (_tmp61_);
	}
	_tmp63_ = val;
	val = _tmp63_ - 1;
	_tmp64_ = self->priv->possible_in_row;
	_tmp64__length1 = self->priv->possible_in_row_length1;
	_tmp64__length2 = self->priv->possible_in_row_length2;
	_tmp65_ = row;
	_tmp66_ = val;
	_tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_] = FALSE;
	_tmp67_ = _tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_];
	_tmp68_ = self->priv->possible_in_col;
	_tmp68__length1 = self->priv->possible_in_col_length1;
	_tmp68__length2 = self->priv->possible_in_col_length2;
	_tmp69_ = col;
	_tmp70_ = val;
	_tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_] = FALSE;
	_tmp71_ = _tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_];
	_tmp72_ = self->priv->possible_in_block;
	_tmp72__length1 = self->priv->possible_in_block_length1;
	_tmp72__length2 = self->priv->possible_in_block_length2;
	_tmp72__length3 = self->priv->possible_in_block_length3;
	_tmp73_ = row;
	_tmp74_ = self->priv->_block_cols;
	_tmp75_ = col;
	_tmp76_ = self->priv->_block_rows;
	_tmp77_ = val;
	_tmp72_[((((_tmp73_ / _tmp74_) * _tmp72__length2) + (_tmp75_ / _tmp76_)) * _tmp72__length3) + _tmp77_] = FALSE;
	_tmp78_ = _tmp72_[((((_tmp73_ / _tmp74_) * _tmp72__length2) + (_tmp75_ / _tmp76_)) * _tmp72__length3) + _tmp77_];
	_tmp79_ = sudoku_board_get_complete (self);
	_tmp80_ = _tmp79_;
	if (_tmp80_) {
		g_signal_emit_by_name (self, "completed");
	}
}


void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = val;
	if (_tmp0_ == 0) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = row;
		_tmp2_ = col;
		sudoku_board_remove (self, _tmp1_, _tmp2_, FALSE);
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		_tmp4_ = val;
		if (_tmp4_ > 0) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp5_ = val;
			_tmp6_ = sudoku_board_get_max_val (self);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp5_ <= _tmp7_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			_tmp8_ = row;
			_tmp9_ = col;
			_tmp10_ = val;
			sudoku_board_insert (self, _tmp8_, _tmp9_, _tmp10_, FALSE);
		} else {
			g_assert_not_reached ();
		}
	}
}


gint sudoku_board_get (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	result = _tmp3_;
	return result;
}


void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint previous_val = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GeeSet* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Coord _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	gint _tmp126_ = 0;
	gboolean _tmp127_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	if (_tmp3_ == 0) {
		return;
	}
	_tmp4_ = is_fixed;
	if (!_tmp4_) {
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->is_fixed;
		_tmp5__length1 = self->is_fixed_length1;
		_tmp5__length2 = self->is_fixed_length2;
		_tmp6_ = row;
		_tmp7_ = col;
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
	}
	_tmp9_ = self->cells;
	_tmp9__length1 = self->cells_length1;
	_tmp9__length2 = self->cells_length2;
	_tmp10_ = row;
	_tmp11_ = col;
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
	previous_val = _tmp12_;
	_tmp13_ = self->cells;
	_tmp13__length1 = self->cells_length1;
	_tmp13__length2 = self->cells_length2;
	_tmp14_ = row;
	_tmp15_ = col;
	_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = 0;
	_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
	_tmp17_ = self->broken_coords;
	_tmp18_ = row;
	_tmp19_ = col;
	coord_init (&_tmp20_, _tmp18_, _tmp19_);
	_tmp21_ = gee_collection_contains ((GeeCollection*) _tmp17_, &_tmp20_);
	if (_tmp21_) {
		GeeList* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gpointer _tmp24_ = NULL;
		GeeList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gpointer _tmp29_ = NULL;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		GeeMap* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Coord _tmp37_ = {0};
		gpointer _tmp38_ = NULL;
		GeeList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		GeeSet* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Coord _tmp44_ = {0};
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gpointer _tmp47_ = NULL;
		GeeList* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		GeeList* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gpointer _tmp52_ = NULL;
		GeeList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		GeeMap* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		Coord _tmp60_ = {0};
		gpointer _tmp61_ = NULL;
		GeeList* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gboolean* _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		gint _tmp64__length2 = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GeeList* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gpointer _tmp69_ = NULL;
		GeeList* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		GeeSet* _tmp72_ = NULL;
		GeeSet* _tmp73_ = NULL;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gboolean _tmp76_ = FALSE;
		gboolean* _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		gint _tmp77__length2 = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		GeeList* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		gpointer _tmp82_ = NULL;
		GeeList* _tmp83_ = NULL;
		gint _tmp84_ = 0;
		GeeSet* _tmp85_ = NULL;
		GeeSet* _tmp86_ = NULL;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		gboolean _tmp89_ = FALSE;
		gboolean* _tmp90_ = NULL;
		gint _tmp90__length1 = 0;
		gint _tmp90__length2 = 0;
		gint _tmp90__length3 = 0;
		gint _tmp91_ = 0;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		gint _tmp95_ = 0;
		GeeMap* _tmp96_ = NULL;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		gint _tmp100_ = 0;
		Coord _tmp101_ = {0};
		gpointer _tmp102_ = NULL;
		GeeList* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		GeeSet* _tmp105_ = NULL;
		GeeSet* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		gboolean _tmp109_ = FALSE;
		_tmp22_ = self->coords_for_row;
		_tmp23_ = row;
		_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
		_tmp25_ = (GeeList*) _tmp24_;
		_tmp26_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp25_, _tmp26_);
		_g_object_unref0 (_tmp25_);
		_tmp27_ = self->coords_for_col;
		_tmp28_ = col;
		_tmp29_ = gee_list_get (_tmp27_, _tmp28_);
		_tmp30_ = (GeeList*) _tmp29_;
		_tmp31_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp30_, _tmp31_);
		_g_object_unref0 (_tmp30_);
		_tmp32_ = self->coords_for_block;
		_tmp33_ = row;
		_tmp34_ = self->priv->_block_rows;
		_tmp35_ = col;
		_tmp36_ = self->priv->_block_cols;
		coord_init (&_tmp37_, _tmp33_ / _tmp34_, _tmp35_ / _tmp36_);
		_tmp38_ = gee_map_get (_tmp32_, &_tmp37_);
		_tmp39_ = (GeeList*) _tmp38_;
		_tmp40_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp39_, _tmp40_);
		_g_object_unref0 (_tmp39_);
		_tmp41_ = self->broken_coords;
		_tmp42_ = row;
		_tmp43_ = col;
		coord_init (&_tmp44_, _tmp42_, _tmp43_);
		gee_collection_remove ((GeeCollection*) _tmp41_, &_tmp44_);
		_tmp45_ = self->coords_for_row;
		_tmp46_ = row;
		_tmp47_ = gee_list_get (_tmp45_, _tmp46_);
		_tmp48_ = (GeeList*) _tmp47_;
		_tmp49_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp48_, _tmp49_);
		_g_object_unref0 (_tmp48_);
		_tmp50_ = self->coords_for_col;
		_tmp51_ = col;
		_tmp52_ = gee_list_get (_tmp50_, _tmp51_);
		_tmp53_ = (GeeList*) _tmp52_;
		_tmp54_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp53_, _tmp54_);
		_g_object_unref0 (_tmp53_);
		_tmp55_ = self->coords_for_block;
		_tmp56_ = row;
		_tmp57_ = self->priv->_block_rows;
		_tmp58_ = col;
		_tmp59_ = self->priv->_block_cols;
		coord_init (&_tmp60_, _tmp56_ / _tmp57_, _tmp58_ / _tmp59_);
		_tmp61_ = gee_map_get (_tmp55_, &_tmp60_);
		_tmp62_ = (GeeList*) _tmp61_;
		_tmp63_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp62_, _tmp63_);
		_g_object_unref0 (_tmp62_);
		_tmp64_ = self->priv->possible_in_row;
		_tmp64__length1 = self->priv->possible_in_row_length1;
		_tmp64__length2 = self->priv->possible_in_row_length2;
		_tmp65_ = row;
		_tmp66_ = previous_val;
		_tmp67_ = self->coords_for_row;
		_tmp68_ = row;
		_tmp69_ = gee_list_get (_tmp67_, _tmp68_);
		_tmp70_ = (GeeList*) _tmp69_;
		_tmp71_ = previous_val;
		_tmp72_ = sudoku_board_get_occurances (self, _tmp70_, _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = gee_collection_get_size ((GeeCollection*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)] = _tmp75_ == 0;
		_tmp76_ = _tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)];
		_g_object_unref0 (_tmp73_);
		_g_object_unref0 (_tmp70_);
		_tmp77_ = self->priv->possible_in_col;
		_tmp77__length1 = self->priv->possible_in_col_length1;
		_tmp77__length2 = self->priv->possible_in_col_length2;
		_tmp78_ = col;
		_tmp79_ = previous_val;
		_tmp80_ = self->coords_for_col;
		_tmp81_ = col;
		_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
		_tmp83_ = (GeeList*) _tmp82_;
		_tmp84_ = previous_val;
		_tmp85_ = sudoku_board_get_occurances (self, _tmp83_, _tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = gee_collection_get_size ((GeeCollection*) _tmp86_);
		_tmp88_ = _tmp87_;
		_tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)] = _tmp88_ == 0;
		_tmp89_ = _tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)];
		_g_object_unref0 (_tmp86_);
		_g_object_unref0 (_tmp83_);
		_tmp90_ = self->priv->possible_in_block;
		_tmp90__length1 = self->priv->possible_in_block_length1;
		_tmp90__length2 = self->priv->possible_in_block_length2;
		_tmp90__length3 = self->priv->possible_in_block_length3;
		_tmp91_ = row;
		_tmp92_ = self->priv->_block_cols;
		_tmp93_ = col;
		_tmp94_ = self->priv->_block_rows;
		_tmp95_ = previous_val;
		_tmp96_ = self->coords_for_block;
		_tmp97_ = row;
		_tmp98_ = self->priv->_block_rows;
		_tmp99_ = col;
		_tmp100_ = self->priv->_block_cols;
		coord_init (&_tmp101_, _tmp97_ / _tmp98_, _tmp99_ / _tmp100_);
		_tmp102_ = gee_map_get (_tmp96_, &_tmp101_);
		_tmp103_ = (GeeList*) _tmp102_;
		_tmp104_ = previous_val;
		_tmp105_ = sudoku_board_get_occurances (self, _tmp103_, _tmp104_);
		_tmp106_ = _tmp105_;
		_tmp107_ = gee_collection_get_size ((GeeCollection*) _tmp106_);
		_tmp108_ = _tmp107_;
		_tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)] = _tmp108_ == 0;
		_tmp109_ = _tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)];
		_g_object_unref0 (_tmp106_);
		_g_object_unref0 (_tmp103_);
	} else {
		gint _tmp110_ = 0;
		gboolean* _tmp111_ = NULL;
		gint _tmp111__length1 = 0;
		gint _tmp111__length2 = 0;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean* _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		gint _tmp115__length2 = 0;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		gboolean _tmp118_ = FALSE;
		gboolean* _tmp119_ = NULL;
		gint _tmp119__length1 = 0;
		gint _tmp119__length2 = 0;
		gint _tmp119__length3 = 0;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		gboolean _tmp125_ = FALSE;
		_tmp110_ = previous_val;
		previous_val = _tmp110_ - 1;
		_tmp111_ = self->priv->possible_in_row;
		_tmp111__length1 = self->priv->possible_in_row_length1;
		_tmp111__length2 = self->priv->possible_in_row_length2;
		_tmp112_ = row;
		_tmp113_ = previous_val;
		_tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_] = TRUE;
		_tmp114_ = _tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_];
		_tmp115_ = self->priv->possible_in_col;
		_tmp115__length1 = self->priv->possible_in_col_length1;
		_tmp115__length2 = self->priv->possible_in_col_length2;
		_tmp116_ = col;
		_tmp117_ = previous_val;
		_tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_] = TRUE;
		_tmp118_ = _tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_];
		_tmp119_ = self->priv->possible_in_block;
		_tmp119__length1 = self->priv->possible_in_block_length1;
		_tmp119__length2 = self->priv->possible_in_block_length2;
		_tmp119__length3 = self->priv->possible_in_block_length3;
		_tmp120_ = row;
		_tmp121_ = self->priv->_block_cols;
		_tmp122_ = col;
		_tmp123_ = self->priv->_block_rows;
		_tmp124_ = previous_val;
		_tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_] = TRUE;
		_tmp125_ = _tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_];
	}
	_tmp126_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp126_ - 1);
	_tmp127_ = is_fixed;
	if (_tmp127_) {
		gint _tmp128_ = 0;
		_tmp128_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp128_ - 1);
	}
}


gint sudoku_board_count_solutions_limited (SudokuBoard* self) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = qqwing_count_solutions_limited ((gint*) _tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* result = NULL;
	GeeSet* occurances = NULL;
	GeeHashSet* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (coords != NULL, NULL);
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	occurances = (GeeSet*) _tmp0_;
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp1_ = NULL;
		GeeList* _tmp2_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _coord_index = 0;
		_tmp1_ = coords;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_coord_list = _tmp2_;
		_tmp3_ = _coord_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_coord_size = _tmp5_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Coord coord = {0};
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Coord* _tmp12_ = NULL;
			Coord _tmp13_ = {0};
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp6_ = _coord_index;
			_coord_index = _tmp6_ + 1;
			_tmp7_ = _coord_index;
			_tmp8_ = _coord_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _coord_list;
			_tmp10_ = _coord_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			_tmp12_ = (Coord*) _tmp11_;
			_tmp13_ = *_tmp12_;
			_coord_free0 (_tmp12_);
			coord = _tmp13_;
			_tmp14_ = self->cells;
			_tmp14__length1 = self->cells_length1;
			_tmp14__length2 = self->cells_length2;
			_tmp15_ = coord;
			_tmp16_ = _tmp15_.row;
			_tmp17_ = coord;
			_tmp18_ = _tmp17_.col;
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
			_tmp20_ = val;
			if (_tmp19_ == _tmp20_) {
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				_tmp21_ = occurances;
				_tmp22_ = coord;
				gee_collection_add ((GeeCollection*) _tmp21_, &_tmp22_);
			}
		}
		_g_object_unref0 (_coord_list);
	}
	result = occurances;
	return result;
}


gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_row;
	_tmp1_ = row;
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = val;
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != 0;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}


gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_col;
	_tmp1_ = col;
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = val;
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != 0;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}


gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val) {
	gboolean result = FALSE;
	GeeMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (block != NULL, FALSE);
	_tmp0_ = self->coords_for_block;
	_tmp1_ = *block;
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = val;
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != 0;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _coord_index = 0;
		_tmp0_ = coords;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_coord_list = _tmp1_;
		_tmp2_ = _coord_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_coord_size = _tmp4_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Coord coord = {0};
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			gboolean _tmp13_ = FALSE;
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp5_ = _coord_index;
			_coord_index = _tmp5_ + 1;
			_tmp6_ = _coord_index;
			_tmp7_ = _coord_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _coord_list;
			_tmp9_ = _coord_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			_tmp11_ = (Coord*) _tmp10_;
			_tmp12_ = *_tmp11_;
			_coord_free0 (_tmp11_);
			coord = _tmp12_;
			_tmp14_ = self->cells;
			_tmp14__length1 = self->cells_length1;
			_tmp14__length2 = self->cells_length2;
			_tmp15_ = coord;
			_tmp16_ = _tmp15_.row;
			_tmp17_ = coord;
			_tmp18_ = _tmp17_.col;
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
			_tmp20_ = val;
			if (_tmp19_ == _tmp20_) {
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
				_tmp21_ = self->broken_coords;
				_tmp22_ = coord;
				_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp21_, &_tmp22_);
				_tmp13_ = _tmp23_;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GeeSet* _tmp24_ = NULL;
				Coord _tmp25_ = {0};
				_tmp24_ = self->broken_coords;
				_tmp25_ = coord;
				gee_collection_remove ((GeeCollection*) _tmp24_, &_tmp25_);
			}
		}
		_g_object_unref0 (_coord_list);
	}
}


static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* occurances = NULL;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	_tmp0_ = coords;
	_tmp1_ = val;
	_tmp2_ = sudoku_board_get_occurances (self, _tmp0_, _tmp1_);
	occurances = _tmp2_;
	_tmp3_ = occurances;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != 1) {
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		_tmp6_ = self->broken_coords;
		_tmp7_ = occurances;
		gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp7_);
	}
	_g_object_unref0 (occurances);
}


void sudoku_board_to_initial_state (SudokuBoard* self) {
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = l1;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gboolean* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gboolean _tmp11_ = FALSE;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = l2;
								l2 = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = l2;
							_tmp7_ = self->priv->_cols;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = self->is_fixed;
							_tmp8__length1 = self->is_fixed_length1;
							_tmp8__length2 = self->is_fixed_length2;
							_tmp9_ = l1;
							_tmp10_ = l2;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							if (!_tmp11_) {
								gint _tmp12_ = 0;
								gint _tmp13_ = 0;
								_tmp12_ = l1;
								_tmp13_ = l2;
								sudoku_board_remove (self, _tmp12_, _tmp13_, FALSE);
							}
						}
					}
				}
			}
		}
	}
}


void sudoku_board_print (SudokuBoard* self, gint indent) {
	FILE* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				FILE* _tmp21_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = l1;
				if (!(_tmp2_ < 9)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							FILE* _tmp7_ = NULL;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = i;
							_tmp6_ = indent;
							if (!(_tmp5_ < _tmp6_)) {
								break;
							}
							_tmp7_ = stdout;
							fprintf (_tmp7_, " ");
						}
					}
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_ = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = l2;
								l2 = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = l2;
							if (!(_tmp10_ < 9)) {
								break;
							}
							_tmp11_ = self->cells;
							_tmp11__length1 = self->cells_length1;
							_tmp11__length2 = self->cells_length2;
							_tmp12_ = l1;
							_tmp13_ = l2;
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
							if (_tmp14_ != 0) {
								FILE* _tmp15_ = NULL;
								gint* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								gint _tmp16__length2 = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								_tmp15_ = stdout;
								_tmp16_ = self->cells;
								_tmp16__length1 = self->cells_length1;
								_tmp16__length2 = self->cells_length2;
								_tmp17_ = l1;
								_tmp18_ = l2;
								_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
								fprintf (_tmp15_, "%d ", _tmp19_);
							} else {
								FILE* _tmp20_ = NULL;
								_tmp20_ = stdout;
								fprintf (_tmp20_, "  ");
							}
						}
					}
				}
				_tmp21_ = stdout;
				fprintf (_tmp21_, "\n");
			}
		}
	}
	_tmp22_ = stdout;
	fflush (_tmp22_);
}


void sudoku_board_get_string (SudokuBoard* self) {
	FILE* _tmp0_ = NULL;
	FILE* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "[ ");
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				FILE* _tmp4_ = NULL;
				FILE* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = l1;
				if (!(_tmp3_ < 9)) {
					break;
				}
				_tmp4_ = stdout;
				fprintf (_tmp4_, "[ ");
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							FILE* _tmp8_ = NULL;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = l2;
							if (!(_tmp7_ < 9)) {
								break;
							}
							_tmp8_ = stdout;
							_tmp9_ = self->cells;
							_tmp9__length1 = self->cells_length1;
							_tmp9__length2 = self->cells_length2;
							_tmp10_ = l1;
							_tmp11_ = l2;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							fprintf (_tmp8_, "%d", _tmp12_);
							_tmp13_ = l2;
							if (_tmp13_ != 8) {
								FILE* _tmp14_ = NULL;
								_tmp14_ = stdout;
								fprintf (_tmp14_, ",");
							}
						}
					}
				}
				_tmp15_ = stdout;
				fprintf (_tmp15_, " ]");
				_tmp16_ = l1;
				if (_tmp16_ != 8) {
					FILE* _tmp17_ = NULL;
					_tmp17_ = stdout;
					fprintf (_tmp17_, ",");
				}
			}
		}
	}
	_tmp18_ = stdout;
	fprintf (_tmp18_, " ]");
}


gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state) {
	gchar* result = NULL;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	board_string = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gboolean* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = j;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = self->is_fixed;
							_tmp9__length1 = self->is_fixed_length1;
							_tmp9__length2 = self->is_fixed_length2;
							_tmp10_ = i;
							_tmp11_ = j;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							if (_tmp12_) {
								const gchar* _tmp13_ = NULL;
								gint* _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								gint _tmp14__length2 = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
								_tmp13_ = board_string;
								_tmp14_ = self->cells;
								_tmp14__length1 = self->cells_length1;
								_tmp14__length2 = self->cells_length2;
								_tmp15_ = i;
								_tmp16_ = j;
								_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
								_tmp18_ = g_strdup_printf ("%i", _tmp17_);
								_tmp19_ = _tmp18_;
								_tmp20_ = g_strconcat (_tmp13_, _tmp19_, NULL);
								_g_free0 (board_string);
								board_string = _tmp20_;
								_g_free0 (_tmp19_);
							} else {
								gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp29_ = NULL;
								gchar* _tmp30_ = NULL;
								_tmp22_ = get_original_state;
								if (_tmp22_) {
									gchar* _tmp23_ = NULL;
									_tmp23_ = g_strdup ("0");
									_g_free0 (_tmp21_);
									_tmp21_ = _tmp23_;
								} else {
									gint* _tmp24_ = NULL;
									gint _tmp24__length1 = 0;
									gint _tmp24__length2 = 0;
									gint _tmp25_ = 0;
									gint _tmp26_ = 0;
									gint _tmp27_ = 0;
									gchar* _tmp28_ = NULL;
									_tmp24_ = self->cells;
									_tmp24__length1 = self->cells_length1;
									_tmp24__length2 = self->cells_length2;
									_tmp25_ = i;
									_tmp26_ = j;
									_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
									_tmp28_ = g_strdup_printf ("%i", _tmp27_);
									_g_free0 (_tmp21_);
									_tmp21_ = _tmp28_;
								}
								_tmp29_ = board_string;
								_tmp30_ = g_strconcat (_tmp29_, _tmp21_, NULL);
								_g_free0 (board_string);
								board_string = _tmp30_;
								_g_free0 (_tmp21_);
							}
						}
					}
				}
			}
		}
	}
	result = board_string;
	return result;
}


static gint* _vala_array_dup8 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp2__length2;
	}
	result = _tmp2_;
	return result;
}


GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self) {
	GeeHashMap* result = NULL;
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	possibilities = _tmp0_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = l1;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = l2;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = self->cells;
							_tmp9__length1 = self->cells_length1;
							_tmp9__length2 = self->cells_length2;
							_tmp10_ = l1;
							_tmp11_ = l2;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							if (_tmp12_ == 0) {
								GeeList* possArrayList = NULL;
								GeeArrayList* _tmp13_ = NULL;
								gint* possArray = NULL;
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint* _tmp17_ = NULL;
								gint possArray_length1 = 0;
								gint _possArray_size_ = 0;
								gint* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								GeeHashMap* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								Coord _tmp24_ = {0};
								GeeList* _tmp25_ = NULL;
								_tmp13_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
								possArrayList = (GeeList*) _tmp13_;
								_tmp14_ = l1;
								_tmp15_ = l2;
								_tmp17_ = sudoku_board_get_possibilities (self, _tmp14_, _tmp15_, &_tmp16_);
								possArray = _tmp17_;
								possArray_length1 = _tmp16_;
								_possArray_size_ = possArray_length1;
								_tmp18_ = possArray;
								_tmp18__length1 = possArray_length1;
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
									i_collection = _tmp18_;
									i_collection_length1 = _tmp18__length1;
									for (i_it = 0; i_it < _tmp18__length1; i_it = i_it + 1) {
										gint i = 0;
										i = i_collection[i_it];
										{
											GeeList* _tmp19_ = NULL;
											gint _tmp20_ = 0;
											_tmp19_ = possArrayList;
											_tmp20_ = i;
											gee_collection_add ((GeeCollection*) _tmp19_, (gpointer) ((gintptr) _tmp20_));
										}
									}
								}
								_tmp21_ = possibilities;
								_tmp22_ = l1;
								_tmp23_ = l2;
								coord_init (&_tmp24_, _tmp22_, _tmp23_);
								_tmp25_ = possArrayList;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, &_tmp24_, _tmp25_);
								possArray = (g_free (possArray), NULL);
								_g_object_unref0 (possArrayList);
							}
						}
					}
				}
			}
		}
	}
	result = possibilities;
	return result;
}


gboolean sudoku_board_is_finished (SudokuBoard* self) {
	gboolean result = FALSE;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	GFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sudoku_board_to_string (self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	board_string = _tmp3_;
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
	finishgame_file = _tmp6_;
	_tmp7_ = g_file_new_for_path (finishgame_file);
	file = _tmp7_;
	_tmp8_ = g_file_query_exists (file, NULL);
	result = _tmp8_;
	_g_object_unref0 (file);
	_g_free0 (finishgame_file);
	_g_free0 (board_string);
	return result;
}


gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint _tmp6__length3 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = sudoku_board_get_max_val (self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ <= _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->earmarks;
				_tmp6__length1 = self->priv->earmarks_length1;
				_tmp6__length2 = self->priv->earmarks_length2;
				_tmp6__length3 = self->priv->earmarks_length3;
				_tmp7_ = row;
				_tmp8_ = col;
				_tmp9_ = i;
				_tmp10_ = _tmp6_[(((_tmp7_ * _tmp6__length2) + _tmp8_) * _tmp6__length3) + (_tmp9_ - 1)];
				if (_tmp10_) {
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					_tmp11_ = s;
					_tmp12_ = i;
					_tmp13_ = g_strdup_printf ("%i", _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
					_g_free0 (s);
					s = _tmp15_;
					_g_free0 (_tmp14_);
				}
			}
		}
	}
	result = s;
	return result;
}


gdouble sudoku_board_get_previous_played_time (SudokuBoard* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_previous_played_time;
	result = _tmp0_;
	return result;
}


void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_previous_played_time = _tmp0_;
	g_object_notify ((GObject *) self, "previous-played-time");
}


DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self) {
	DifficultyCategory result;
	DifficultyCategory _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_difficulty_category;
	result = _tmp0_;
	return result;
}


void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value) {
	DifficultyCategory _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_difficulty_category = _tmp0_;
	g_object_notify ((GObject *) self, "difficulty-category");
}


gint sudoku_board_get_block_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	result = _tmp0_;
	return result;
}


static void sudoku_board_set_block_rows (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_block_rows = _tmp0_;
	g_object_notify ((GObject *) self, "block-rows");
}


gint sudoku_board_get_block_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_cols;
	result = _tmp0_;
	return result;
}


static void sudoku_board_set_block_cols (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_block_cols = _tmp0_;
	g_object_notify ((GObject *) self, "block-cols");
}


gint sudoku_board_get_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	result = _tmp0_;
	return result;
}


static void sudoku_board_set_rows (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rows = _tmp0_;
	g_object_notify ((GObject *) self, "rows");
}


gint sudoku_board_get_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cols;
	result = _tmp0_;
	return result;
}


static void sudoku_board_set_cols (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_cols = _tmp0_;
	g_object_notify ((GObject *) self, "cols");
}


gint sudoku_board_get_max_val (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}


gboolean sudoku_board_get_broken (SudokuBoard* self) {
	gboolean result;
	GeeSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->broken_coords;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != 0;
	return result;
}


gint sudoku_board_get_filled (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_filled;
	result = _tmp0_;
	return result;
}


static void sudoku_board_set_filled (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_filled = _tmp0_;
	g_object_notify ((GObject *) self, "filled");
}


gint sudoku_board_get_fixed (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_fixed;
	result = _tmp0_;
	return result;
}


static void sudoku_board_set_fixed (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_fixed = _tmp0_;
	g_object_notify ((GObject *) self, "fixed");
}


gint sudoku_board_get_size (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}


gboolean sudoku_board_get_complete (SudokuBoard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_cols;
	_tmp3_ = self->priv->_rows;
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = sudoku_board_get_broken (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void sudoku_board_class_init (SudokuBoardClass * klass) {
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuBoardPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME, g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_DIFFICULTY_CATEGORY, g_param_spec_enum ("difficulty-category", "difficulty-category", "difficulty-category", TYPE_DIFFICULTY_CATEGORY, DIFFICULTY_CATEGORY_UNKNOWN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS, g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS, g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS, g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL, g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN, g_param_spec_boolean ("broken", "broken", "broken", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED, g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FIXED, g_param_spec_int ("fixed", "fixed", "fixed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE, g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sudoku_board_instance_init (SudokuBoard * self) {
	self->priv = SUDOKU_BOARD_GET_PRIVATE (self);
	self->priv->_previous_played_time = (gdouble) 0;
	self->priv->_difficulty_category = DIFFICULTY_CATEGORY_UNKNOWN;
}


static void sudoku_board_finalize (GObject* obj) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
	self->cells = (g_free (self->cells), NULL);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	_g_object_unref0 (self->broken_coords);
	_g_object_unref0 (self->coords_for_col);
	_g_object_unref0 (self->coords_for_row);
	_g_object_unref0 (self->coords_for_block);
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
}


GType sudoku_board_get_type (void) {
	static volatile gsize sudoku_board_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_board_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
		GType sudoku_board_type_id;
		sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_board_type_id__volatile, sudoku_board_type_id);
	}
	return sudoku_board_type_id__volatile;
}


static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY:
		g_value_set_enum (value, sudoku_board_get_difficulty_category (self));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS:
		g_value_set_int (value, sudoku_board_get_block_rows (self));
		break;
		case SUDOKU_BOARD_BLOCK_COLS:
		g_value_set_int (value, sudoku_board_get_block_cols (self));
		break;
		case SUDOKU_BOARD_ROWS:
		g_value_set_int (value, sudoku_board_get_rows (self));
		break;
		case SUDOKU_BOARD_COLS:
		g_value_set_int (value, sudoku_board_get_cols (self));
		break;
		case SUDOKU_BOARD_MAX_VAL:
		g_value_set_int (value, sudoku_board_get_max_val (self));
		break;
		case SUDOKU_BOARD_BROKEN:
		g_value_set_boolean (value, sudoku_board_get_broken (self));
		break;
		case SUDOKU_BOARD_FILLED:
		g_value_set_int (value, sudoku_board_get_filled (self));
		break;
		case SUDOKU_BOARD_FIXED:
		g_value_set_int (value, sudoku_board_get_fixed (self));
		break;
		case SUDOKU_BOARD_SIZE:
		g_value_set_int (value, sudoku_board_get_size (self));
		break;
		case SUDOKU_BOARD_COMPLETE:
		g_value_set_boolean (value, sudoku_board_get_complete (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY:
		sudoku_board_set_difficulty_category (self, g_value_get_enum (value));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS:
		sudoku_board_set_block_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_BLOCK_COLS:
		sudoku_board_set_block_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_ROWS:
		sudoku_board_set_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_COLS:
		sudoku_board_set_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FILLED:
		sudoku_board_set_filled (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FIXED:
		sudoku_board_set_fixed (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType house_get_type (void) {
	static volatile gsize house_type_id__volatile = 0;
	if (g_once_init_enter (&house_type_id__volatile)) {
		static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
		GType house_type_id;
		house_type_id = g_enum_register_static ("House", values);
		g_once_init_leave (&house_type_id__volatile, house_type_id);
	}
	return house_type_id__volatile;
}


void coord_init (Coord *self, gint row, gint col) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	memset (self, 0, sizeof (Coord));
	_tmp0_ = row;
	(*self).row = _tmp0_;
	_tmp1_ = col;
	(*self).col = _tmp1_;
}


gint coord_hash (Coord* coord) {
	gint result = 0;
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
	Coord _tmp2_ = {0};
	gint _tmp3_ = 0;
	g_return_val_if_fail (coord != NULL, 0);
	_tmp0_ = *coord;
	_tmp1_ = _tmp0_.row;
	_tmp2_ = *coord;
	_tmp3_ = _tmp2_.col;
	result = (_tmp1_ * 33) ^ _tmp3_;
	return result;
}


gboolean coord_equal (Coord* a, Coord* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Coord _tmp3_ = {0};
	gint _tmp4_ = 0;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.row;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.row;
	if (_tmp2_ == _tmp4_) {
		Coord _tmp5_ = {0};
		gint _tmp6_ = 0;
		Coord _tmp7_ = {0};
		gint _tmp8_ = 0;
		_tmp5_ = *a;
		_tmp6_ = _tmp5_.col;
		_tmp7_ = *b;
		_tmp8_ = _tmp7_.col;
		_tmp0_ = _tmp6_ == _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


Coord* coord_dup (const Coord* self) {
	Coord* dup;
	dup = g_new0 (Coord, 1);
	memcpy (dup, self, sizeof (Coord));
	return dup;
}


void coord_free (Coord* self) {
	g_free (self);
}


GType coord_get_type (void) {
	static volatile gsize coord_type_id__volatile = 0;
	if (g_once_init_enter (&coord_type_id__volatile)) {
		GType coord_type_id;
		coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
		g_once_init_leave (&coord_type_id__volatile, coord_type_id);
	}
	return coord_type_id__volatile;
}


void cell_init (Cell *self, Coord* coord, gint val) {
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
	g_return_if_fail (coord != NULL);
	memset (self, 0, sizeof (Cell));
	_tmp0_ = *coord;
	(*self).coord = _tmp0_;
	_tmp1_ = val;
	(*self).val = _tmp1_;
}


gint cell_hash (Cell* cell) {
	gint result = 0;
	Cell _tmp0_ = {0};
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Cell _tmp3_ = {0};
	gint _tmp4_ = 0;
	g_return_val_if_fail (cell != NULL, 0);
	_tmp0_ = *cell;
	_tmp1_ = _tmp0_.coord;
	_tmp2_ = coord_hash (&_tmp1_);
	_tmp3_ = *cell;
	_tmp4_ = _tmp3_.val;
	result = (_tmp2_ * 33) ^ _tmp4_;
	return result;
}


gboolean cell_equal (Cell* a, Cell* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_ = {0};
	Coord _tmp2_ = {0};
	Cell _tmp3_ = {0};
	Coord _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.coord;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.coord;
	_tmp5_ = coord_equal (&_tmp2_, &_tmp4_);
	if (_tmp5_) {
		Cell _tmp6_ = {0};
		gint _tmp7_ = 0;
		Cell _tmp8_ = {0};
		gint _tmp9_ = 0;
		_tmp6_ = *a;
		_tmp7_ = _tmp6_.val;
		_tmp8_ = *b;
		_tmp9_ = _tmp8_.val;
		_tmp0_ = _tmp7_ == _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


Cell* cell_dup (const Cell* self) {
	Cell* dup;
	dup = g_new0 (Cell, 1);
	memcpy (dup, self, sizeof (Cell));
	return dup;
}


void cell_free (Cell* self) {
	g_free (self);
}


GType cell_get_type (void) {
	static volatile gsize cell_type_id__volatile = 0;
	if (g_once_init_enter (&cell_type_id__volatile)) {
		GType cell_type_id;
		cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
		g_once_init_leave (&cell_type_id__volatile, cell_type_id);
	}
	return cell_type_id__volatile;
}


gchar* difficulty_category_to_string (DifficultyCategory self) {
	gchar* result = NULL;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
			_tmp0_ = _ ("Unknown Difficulty");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp2_ = _ ("Easy Difficulty");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp4_ = _ ("Medium Difficulty");
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp6_ = _ ("Hard Difficulty");
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp8_ = _ ("Very Hard Difficulty");
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp10_ = _ ("Custom Puzzle");
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


gchar* difficulty_category_to_untranslated_string (DifficultyCategory self) {
	gchar* result = NULL;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("Unknown Difficulty");
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("Easy Difficulty");
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("Medium Difficulty");
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("Hard Difficulty");
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("Very Hard Difficulty");
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("Custom Puzzle");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


DifficultyCategory difficulty_category_from_string (const gchar* input) {
	DifficultyCategory result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	g_return_val_if_fail (input != NULL, 0);
	_tmp0_ = input;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Unknown Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_UNKNOWN;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Easy Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("Medium Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_MEDIUM;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_HARD;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("Very Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_VERY_HARD;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("Custom Puzzle")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_CUSTOM;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("sudoku-board.vala:637: Could not parse difficulty level. Falling back " \
"to Easy difficulty");
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	}
}


GType difficulty_category_get_type (void) {
	static volatile gsize difficulty_category_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_category_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_UNKNOWN, "DIFFICULTY_CATEGORY_UNKNOWN", "unknown"}, {DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {DIFFICULTY_CATEGORY_CUSTOM, "DIFFICULTY_CATEGORY_CUSTOM", "custom"}, {0, NULL, NULL}};
		GType difficulty_category_type_id;
		difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
		g_once_init_leave (&difficulty_category_type_id__volatile, difficulty_category_type_id);
	}
	return difficulty_category_type_id__volatile;
}



