/* chess-clock.c generated by valac 0.32.0.32-d07e8, the Vala compiler
 * generated from chess-clock.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CLOCK_TYPE (clock_type_get_type ())

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

typedef enum  {
	CLOCK_TYPE_SIMPLE,
	CLOCK_TYPE_FISCHER,
	CLOCK_TYPE_BRONSTEIN,
	CLOCK_TYPE_INVALID
} ClockType;

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessClockPrivate {
	gint _white_initial_seconds;
	gint _black_initial_seconds;
	gint _white_seconds_used;
	gint _black_seconds_used;
	ClockType _clock_type;
	gint _white_prev_move_seconds;
	gint _black_prev_move_seconds;
	gint _white_extra_seconds;
	gint _black_extra_seconds;
	Color _active_color;
	gint _extra_seconds;
	GTimer* timer;
	guint tick_timeout_id;
	gboolean is_active;
};


static gpointer chess_clock_parent_class = NULL;

GType clock_type_get_type (void) G_GNUC_CONST;
gchar* clock_type_to_string (ClockType self);
ClockType clock_type_string_to_enum (const gchar* s);
GType chess_clock_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
#define CHESS_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_CLOCK, ChessClockPrivate))
enum  {
	CHESS_CLOCK_DUMMY_PROPERTY,
	CHESS_CLOCK_WHITE_INITIAL_SECONDS,
	CHESS_CLOCK_BLACK_INITIAL_SECONDS,
	CHESS_CLOCK_WHITE_SECONDS_USED,
	CHESS_CLOCK_BLACK_SECONDS_USED,
	CHESS_CLOCK_CLOCK_TYPE,
	CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS,
	CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS,
	CHESS_CLOCK_WHITE_EXTRA_SECONDS,
	CHESS_CLOCK_BLACK_EXTRA_SECONDS,
	CHESS_CLOCK_EXTRA_SECONDS,
	CHESS_CLOCK_ACTIVE_COLOR
};
void chess_clock_update_prev_move_time (ChessClock* self);
Color chess_clock_get_active_color (ChessClock* self);
gint chess_clock_get_black_seconds_used (ChessClock* self);
static void chess_clock_set_black_prev_move_seconds (ChessClock* self, gint value);
gint chess_clock_get_white_seconds_used (ChessClock* self);
static void chess_clock_set_white_prev_move_seconds (ChessClock* self, gint value);
void chess_clock_update_extra_seconds (ChessClock* self);
ClockType chess_clock_get_clock_type (ChessClock* self);
gint chess_clock_get_white_extra_seconds (ChessClock* self);
gint chess_clock_get_extra_seconds (ChessClock* self);
static void chess_clock_set_white_extra_seconds (ChessClock* self, gint value);
gint chess_clock_get_black_extra_seconds (ChessClock* self);
static void chess_clock_set_black_extra_seconds (ChessClock* self, gint value);
gint chess_clock_get_white_prev_move_seconds (ChessClock* self);
gint chess_clock_get_black_prev_move_seconds (ChessClock* self);
ChessClock* chess_clock_new (gint white_initial_seconds, gint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, gint white_initial_seconds, gint black_initial_seconds);
static void chess_clock_set_white_initial_seconds (ChessClock* self, gint value);
static void chess_clock_set_black_initial_seconds (ChessClock* self, gint value);
void chess_clock_start (ChessClock* self);
static void chess_clock_watch_timer (ChessClock* self);
static gboolean chess_clock_tick_cb (ChessClock* self);
static void chess_clock_set_white_seconds_used (ChessClock* self, gint value);
static void chess_clock_set_black_seconds_used (ChessClock* self, gint value);
gint chess_clock_get_white_initial_seconds (ChessClock* self);
gint chess_clock_get_black_initial_seconds (ChessClock* self);
void chess_clock_stop (ChessClock* self);
static void chess_clock_stop_watching_timer (ChessClock* self);
void chess_clock_pause (ChessClock* self);
void chess_clock_unpause (ChessClock* self);
static gboolean _chess_clock_tick_cb_gsource_func (gpointer self);
void chess_clock_set_clock_type (ChessClock* self, ClockType value);
void chess_clock_set_extra_seconds (ChessClock* self, gint value);
void chess_clock_set_active_color (ChessClock* self, Color value);
static void chess_clock_finalize (GObject* obj);
static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gchar* clock_type_to_string (ClockType self) {
	gchar* result = NULL;
	switch (self) {
		case CLOCK_TYPE_SIMPLE:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("simple");
			result = _tmp0_;
			return result;
		}
		case CLOCK_TYPE_FISCHER:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("fischer");
			result = _tmp1_;
			return result;
		}
		case CLOCK_TYPE_BRONSTEIN:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("bronstein");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


ClockType clock_type_string_to_enum (const gchar* s) {
	ClockType result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = s;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("simple")))) {
		switch (0) {
			default:
			{
				result = CLOCK_TYPE_SIMPLE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("fischer")))) {
		switch (0) {
			default:
			{
				result = CLOCK_TYPE_FISCHER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("bronstein")))) {
		switch (0) {
			default:
			{
				result = CLOCK_TYPE_BRONSTEIN;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = CLOCK_TYPE_INVALID;
				return result;
			}
		}
	}
}


GType clock_type_get_type (void) {
	static volatile gsize clock_type_type_id__volatile = 0;
	if (g_once_init_enter (&clock_type_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCK_TYPE_SIMPLE, "CLOCK_TYPE_SIMPLE", "simple"}, {CLOCK_TYPE_FISCHER, "CLOCK_TYPE_FISCHER", "fischer"}, {CLOCK_TYPE_BRONSTEIN, "CLOCK_TYPE_BRONSTEIN", "bronstein"}, {CLOCK_TYPE_INVALID, "CLOCK_TYPE_INVALID", "invalid"}, {0, NULL, NULL}};
		GType clock_type_type_id;
		clock_type_type_id = g_enum_register_static ("ClockType", values);
		g_once_init_leave (&clock_type_type_id__volatile, clock_type_type_id);
	}
	return clock_type_type_id__volatile;
}


void chess_clock_update_prev_move_time (ChessClock* self) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_clock_get_active_color (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == COLOR_WHITE) {
		gint _tmp2_ = 0;
		_tmp2_ = self->priv->_black_seconds_used;
		chess_clock_set_black_prev_move_seconds (self, _tmp2_);
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = self->priv->_white_seconds_used;
		chess_clock_set_white_prev_move_seconds (self, _tmp3_);
	}
}


void chess_clock_update_extra_seconds (ChessClock* self) {
	gint white_move_used = 0;
	gint black_move_used = 0;
	ClockType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	white_move_used = 0;
	black_move_used = 0;
	_tmp0_ = self->priv->_clock_type;
	switch (_tmp0_) {
		case CLOCK_TYPE_SIMPLE:
		{
			break;
		}
		case CLOCK_TYPE_FISCHER:
		{
			Color _tmp1_ = 0;
			Color _tmp2_ = 0;
			_tmp1_ = chess_clock_get_active_color (self);
			_tmp2_ = _tmp1_;
			if (_tmp2_ == COLOR_WHITE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				_tmp3_ = self->priv->_white_extra_seconds;
				_tmp4_ = self->priv->_extra_seconds;
				chess_clock_set_white_extra_seconds (self, _tmp3_ + _tmp4_);
			} else {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				_tmp5_ = self->priv->_black_extra_seconds;
				_tmp6_ = self->priv->_extra_seconds;
				chess_clock_set_black_extra_seconds (self, _tmp5_ + _tmp6_);
			}
			break;
		}
		case CLOCK_TYPE_BRONSTEIN:
		{
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			Color _tmp11_ = 0;
			Color _tmp12_ = 0;
			_tmp7_ = self->priv->_white_seconds_used;
			_tmp8_ = self->priv->_white_prev_move_seconds;
			white_move_used = _tmp7_ - _tmp8_;
			_tmp9_ = self->priv->_black_seconds_used;
			_tmp10_ = self->priv->_black_prev_move_seconds;
			black_move_used = _tmp9_ - _tmp10_;
			_tmp11_ = chess_clock_get_active_color (self);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != COLOR_WHITE) {
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				_tmp13_ = self->priv->_white_extra_seconds;
				_tmp14_ = self->priv->_extra_seconds;
				_tmp15_ = white_move_used;
				_tmp16_ = MIN (_tmp14_, _tmp15_);
				chess_clock_set_white_extra_seconds (self, _tmp13_ + _tmp16_);
			} else {
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				_tmp17_ = self->priv->_black_extra_seconds;
				_tmp18_ = self->priv->_extra_seconds;
				_tmp19_ = black_move_used;
				_tmp20_ = MIN (_tmp18_, _tmp19_);
				chess_clock_set_black_extra_seconds (self, _tmp17_ + _tmp20_);
			}
			break;
		}
		default:
		break;
	}
}


ChessClock* chess_clock_construct (GType object_type, gint white_initial_seconds, gint black_initial_seconds) {
	ChessClock * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (ChessClock*) g_object_new (object_type, NULL);
	_tmp0_ = white_initial_seconds;
	chess_clock_set_white_initial_seconds (self, _tmp0_);
	_tmp1_ = black_initial_seconds;
	chess_clock_set_black_initial_seconds (self, _tmp1_);
	return self;
}


ChessClock* chess_clock_new (gint white_initial_seconds, gint black_initial_seconds) {
	return chess_clock_construct (TYPE_CHESS_CLOCK, white_initial_seconds, black_initial_seconds);
}


void chess_clock_start (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_active;
	if (_tmp0_) {
		return;
	}
	self->priv->is_active = TRUE;
	_tmp1_ = self->priv->timer;
	if (_tmp1_ == NULL) {
		GTimer* _tmp2_ = NULL;
		_tmp2_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->timer);
		self->priv->timer = _tmp2_;
	} else {
		GTimer* _tmp3_ = NULL;
		_tmp3_ = self->priv->timer;
		g_timer_start (_tmp3_);
	}
	chess_clock_watch_timer (self);
}


static gboolean chess_clock_tick_cb (ChessClock* self) {
	gboolean result = FALSE;
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = chess_clock_get_active_color (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == COLOR_WHITE) {
		gint _tmp2_ = 0;
		_tmp2_ = self->priv->_white_seconds_used;
		chess_clock_set_white_seconds_used (self, _tmp2_ + 1);
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = self->priv->_black_seconds_used;
		chess_clock_set_black_seconds_used (self, _tmp3_ + 1);
	}
	g_signal_emit_by_name (self, "tick");
	_tmp5_ = self->priv->_white_seconds_used;
	_tmp6_ = self->priv->_white_initial_seconds;
	if (_tmp5_ >= _tmp6_) {
		_tmp4_ = TRUE;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = self->priv->_black_seconds_used;
		_tmp8_ = self->priv->_black_initial_seconds;
		_tmp4_ = _tmp7_ >= _tmp8_;
	}
	if (_tmp4_) {
		chess_clock_stop (self);
		g_signal_emit_by_name (self, "expired");
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


void chess_clock_stop (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->timer;
	g_timer_stop (_tmp1_);
	chess_clock_stop_watching_timer (self);
	self->priv->is_active = FALSE;
}


void chess_clock_pause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->timer;
	g_timer_stop (_tmp1_);
	chess_clock_stop_watching_timer (self);
	self->priv->is_active = FALSE;
}


void chess_clock_unpause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	GTimer* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timer;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_active;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->timer;
	g_timer_continue (_tmp3_);
	chess_clock_watch_timer (self);
	self->priv->is_active = TRUE;
}


static gboolean _chess_clock_tick_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_tick_cb ((ChessClock*) self);
	return result;
}


static void chess_clock_watch_timer (ChessClock* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _chess_clock_tick_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->tick_timeout_id = _tmp0_;
}


static void chess_clock_stop_watching_timer (ChessClock* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tick_timeout_id;
	g_source_remove (_tmp0_);
	self->priv->tick_timeout_id = (guint) 0;
}


gint chess_clock_get_white_initial_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_white_initial_seconds;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_white_initial_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_white_initial_seconds = _tmp0_;
	g_object_notify ((GObject *) self, "white-initial-seconds");
}


gint chess_clock_get_black_initial_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_black_initial_seconds;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_black_initial_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_black_initial_seconds = _tmp0_;
	g_object_notify ((GObject *) self, "black-initial-seconds");
}


gint chess_clock_get_white_seconds_used (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_white_seconds_used;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_white_seconds_used (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_white_seconds_used = _tmp0_;
	g_object_notify ((GObject *) self, "white-seconds-used");
}


gint chess_clock_get_black_seconds_used (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_black_seconds_used;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_black_seconds_used (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_black_seconds_used = _tmp0_;
	g_object_notify ((GObject *) self, "black-seconds-used");
}


ClockType chess_clock_get_clock_type (ChessClock* self) {
	ClockType result;
	ClockType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_clock_type;
	result = _tmp0_;
	return result;
}


void chess_clock_set_clock_type (ChessClock* self, ClockType value) {
	ClockType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_clock_type = _tmp0_;
	g_object_notify ((GObject *) self, "clock-type");
}


gint chess_clock_get_white_prev_move_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_white_prev_move_seconds;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_white_prev_move_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_white_prev_move_seconds = _tmp0_;
	g_object_notify ((GObject *) self, "white-prev-move-seconds");
}


gint chess_clock_get_black_prev_move_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_black_prev_move_seconds;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_black_prev_move_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_black_prev_move_seconds = _tmp0_;
	g_object_notify ((GObject *) self, "black-prev-move-seconds");
}


gint chess_clock_get_white_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_white_extra_seconds;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_white_extra_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_white_extra_seconds = _tmp0_;
	g_object_notify ((GObject *) self, "white-extra-seconds");
}


gint chess_clock_get_black_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_black_extra_seconds;
	result = _tmp0_;
	return result;
}


static void chess_clock_set_black_extra_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_black_extra_seconds = _tmp0_;
	g_object_notify ((GObject *) self, "black-extra-seconds");
}


gint chess_clock_get_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_extra_seconds;
	result = _tmp0_;
	return result;
}


void chess_clock_set_extra_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_extra_seconds = _tmp0_;
	g_object_notify ((GObject *) self, "extra-seconds");
}


Color chess_clock_get_active_color (ChessClock* self) {
	Color result;
	Color _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_active_color;
	result = _tmp0_;
	return result;
}


void chess_clock_set_active_color (ChessClock* self, Color value) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	Color _tmp2_ = 0;
	Color _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = chess_clock_get_active_color (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		return;
	}
	chess_clock_stop (self);
	_tmp3_ = value;
	self->priv->_active_color = _tmp3_;
	chess_clock_update_extra_seconds (self);
	chess_clock_update_prev_move_time (self);
	chess_clock_start (self);
	g_object_notify ((GObject *) self, "active-color");
}


static void chess_clock_class_init (ChessClockClass * klass) {
	chess_clock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessClockPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_clock_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_clock_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_clock_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_INITIAL_SECONDS, g_param_spec_int ("white-initial-seconds", "white-initial-seconds", "white-initial-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_INITIAL_SECONDS, g_param_spec_int ("black-initial-seconds", "black-initial-seconds", "black-initial-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_SECONDS_USED, g_param_spec_int ("white-seconds-used", "white-seconds-used", "white-seconds-used", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_SECONDS_USED, g_param_spec_int ("black-seconds-used", "black-seconds-used", "black-seconds-used", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_CLOCK_TYPE, g_param_spec_enum ("clock-type", "clock-type", "clock-type", TYPE_CLOCK_TYPE, CLOCK_TYPE_SIMPLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS, g_param_spec_int ("white-prev-move-seconds", "white-prev-move-seconds", "white-prev-move-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS, g_param_spec_int ("black-prev-move-seconds", "black-prev-move-seconds", "black-prev-move-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_EXTRA_SECONDS, g_param_spec_int ("white-extra-seconds", "white-extra-seconds", "white-extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_EXTRA_SECONDS, g_param_spec_int ("black-extra-seconds", "black-extra-seconds", "black-extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_EXTRA_SECONDS, g_param_spec_int ("extra-seconds", "extra-seconds", "extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_ACTIVE_COLOR, g_param_spec_enum ("active-color", "active-color", "active-color", TYPE_COLOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("tick", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("expired", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_clock_instance_init (ChessClock * self) {
	self->priv = CHESS_CLOCK_GET_PRIVATE (self);
	self->priv->_white_seconds_used = 0;
	self->priv->_black_seconds_used = 0;
	self->priv->_clock_type = CLOCK_TYPE_SIMPLE;
	self->priv->_white_prev_move_seconds = 0;
	self->priv->_black_prev_move_seconds = 0;
	self->priv->_white_extra_seconds = 0;
	self->priv->_black_extra_seconds = 0;
	self->priv->_active_color = COLOR_WHITE;
	self->priv->_extra_seconds = 0;
	self->priv->tick_timeout_id = (guint) 0;
	self->priv->is_active = FALSE;
}


static void chess_clock_finalize (GObject* obj) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_CLOCK, ChessClock);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (chess_clock_parent_class)->finalize (obj);
}


GType chess_clock_get_type (void) {
	static volatile gsize chess_clock_type_id__volatile = 0;
	if (g_once_init_enter (&chess_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessClock), 0, (GInstanceInitFunc) chess_clock_instance_init, NULL };
		GType chess_clock_type_id;
		chess_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessClock", &g_define_type_info, 0);
		g_once_init_leave (&chess_clock_type_id__volatile, chess_clock_type_id);
	}
	return chess_clock_type_id__volatile;
}


static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
	switch (property_id) {
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
		g_value_set_int (value, chess_clock_get_white_initial_seconds (self));
		break;
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
		g_value_set_int (value, chess_clock_get_black_initial_seconds (self));
		break;
		case CHESS_CLOCK_WHITE_SECONDS_USED:
		g_value_set_int (value, chess_clock_get_white_seconds_used (self));
		break;
		case CHESS_CLOCK_BLACK_SECONDS_USED:
		g_value_set_int (value, chess_clock_get_black_seconds_used (self));
		break;
		case CHESS_CLOCK_CLOCK_TYPE:
		g_value_set_enum (value, chess_clock_get_clock_type (self));
		break;
		case CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS:
		g_value_set_int (value, chess_clock_get_white_prev_move_seconds (self));
		break;
		case CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS:
		g_value_set_int (value, chess_clock_get_black_prev_move_seconds (self));
		break;
		case CHESS_CLOCK_WHITE_EXTRA_SECONDS:
		g_value_set_int (value, chess_clock_get_white_extra_seconds (self));
		break;
		case CHESS_CLOCK_BLACK_EXTRA_SECONDS:
		g_value_set_int (value, chess_clock_get_black_extra_seconds (self));
		break;
		case CHESS_CLOCK_EXTRA_SECONDS:
		g_value_set_int (value, chess_clock_get_extra_seconds (self));
		break;
		case CHESS_CLOCK_ACTIVE_COLOR:
		g_value_set_enum (value, chess_clock_get_active_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
	switch (property_id) {
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
		chess_clock_set_white_initial_seconds (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
		chess_clock_set_black_initial_seconds (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_WHITE_SECONDS_USED:
		chess_clock_set_white_seconds_used (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_BLACK_SECONDS_USED:
		chess_clock_set_black_seconds_used (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_CLOCK_TYPE:
		chess_clock_set_clock_type (self, g_value_get_enum (value));
		break;
		case CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS:
		chess_clock_set_white_prev_move_seconds (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS:
		chess_clock_set_black_prev_move_seconds (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_WHITE_EXTRA_SECONDS:
		chess_clock_set_white_extra_seconds (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_BLACK_EXTRA_SECONDS:
		chess_clock_set_black_extra_seconds (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_EXTRA_SECONDS:
		chess_clock_set_extra_seconds (self, g_value_get_int (value));
		break;
		case CHESS_CLOCK_ACTIVE_COLOR:
		chess_clock_set_active_color (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



