/* spice-display.c generated by valac 0.32.0.6-ea53, the Vala compiler
 * generated from spice-display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libcommon.h>
#include <stdlib.h>
#include <string.h>
#include <spice-client.h>
#include <spice-widget.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>
#include <libusb.h>
#include <libxml/uri.h>


#define BOXES_TYPE_IPROPERTIES_PROVIDER (boxes_iproperties_provider_get_type ())
#define BOXES_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProvider))
#define BOXES_IS_IPROPERTIES_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER))
#define BOXES_IPROPERTIES_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_IPROPERTIES_PROVIDER, BoxesIPropertiesProviderIface))

typedef struct _BoxesIPropertiesProvider BoxesIPropertiesProvider;
typedef struct _BoxesIPropertiesProviderIface BoxesIPropertiesProviderIface;

#define BOXES_TYPE_PROPERTIES_PAGE (boxes_properties_page_get_type ())

#define TYPE_PROPERTY_CREATION_FLAG (property_creation_flag_get_type ())

#define BOXES_TYPE_PROPERTY (boxes_property_get_type ())
#define BOXES_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_PROPERTY, BoxesProperty))
#define BOXES_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_PROPERTY, BoxesPropertyClass))
#define BOXES_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_PROPERTY))
#define BOXES_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_PROPERTY))
#define BOXES_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_PROPERTY, BoxesPropertyClass))

typedef struct _BoxesProperty BoxesProperty;
typedef struct _BoxesPropertyClass BoxesPropertyClass;

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;

#define BOXES_TYPE_SPICE_DISPLAY (boxes_spice_display_get_type ())
#define BOXES_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay))
#define BOXES_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))
#define BOXES_IS_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_IS_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_SPICE_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))

typedef struct _BoxesSpiceDisplay BoxesSpiceDisplay;
typedef struct _BoxesSpiceDisplayClass BoxesSpiceDisplayClass;
typedef struct _BoxesSpiceDisplayPrivate BoxesSpiceDisplayPrivate;

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;

#define BOXES_TYPE_SPICE_CHANNEL_HANDLER (boxes_spice_channel_handler_get_type ())
#define BOXES_SPICE_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandler))
#define BOXES_SPICE_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerClass))
#define BOXES_IS_SPICE_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER))
#define BOXES_IS_SPICE_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_CHANNEL_HANDLER))
#define BOXES_SPICE_CHANNEL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerClass))

typedef struct _BoxesSpiceChannelHandler BoxesSpiceChannelHandler;
typedef struct _BoxesSpiceChannelHandlerClass BoxesSpiceChannelHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SpiceUsbDevice_free0(var) ((var == NULL) ? NULL : (var = (_vala_SpiceUsbDevice_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block79Data Block79Data;
typedef struct _Block80Data Block80Data;
typedef struct _Block81Data Block81Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _libusb_unref_device0(var) ((var == NULL) ? NULL : (var = (libusb_unref_device (var), NULL)))
#define _libusb_free_config_descriptor0(var) ((var == NULL) ? NULL : (var = (libusb_free_config_descriptor (var), NULL)))
typedef struct _BoxesSpiceChannelHandlerPrivate BoxesSpiceChannelHandlerPrivate;
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BOXES_PROPERTIES_PAGE_GENERAL,
	BOXES_PROPERTIES_PAGE_SYSTEM,
	BOXES_PROPERTIES_PAGE_DEVICES,
	BOXES_PROPERTIES_PAGE_SNAPSHOTS,
	BOXES_PROPERTIES_PAGE_LAST
} BoxesPropertiesPage;

typedef enum  {
	PROPERTY_CREATION_FLAG_NONE = 1 << 0,
	PROPERTY_CREATION_FLAG_NO_USB = 1 << 1
} PropertyCreationFlag;

struct _BoxesIPropertiesProviderIface {
	GTypeInterface parent_iface;
	GList* (*get_properties) (BoxesIPropertiesProvider* self, BoxesPropertiesPage page, PropertyCreationFlag* flags);
};

typedef gint (*BoxesDisplayOpenFDFunc) (void* user_data);
struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	void (*send_keys) (BoxesDisplay* self, guint* keyvals, int keyvals_length1);
	GList* (*get_properties) (BoxesDisplay* self, BoxesPropertiesPage page, PropertyCreationFlag* flags);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
};

struct _BoxesSpiceDisplay {
	BoxesDisplay parent_instance;
	BoxesSpiceDisplayPrivate * priv;
};

struct _BoxesSpiceDisplayClass {
	BoxesDisplayClass parent_class;
};

struct _BoxesSpiceDisplayPrivate {
	BoxesMachine* machine;
	SpiceSession* session;
	SpiceGtkSession* gtk_session;
	SpiceAudio* audio;
	gulong channel_new_id;
	gulong channel_destroy_id;
	BoxesBoxConfigSavedProperty* display_saved_properties;
	gint display_saved_properties_length1;
	gint _display_saved_properties_size_;
	BoxesBoxConfigSavedProperty* gtk_session_saved_properties;
	gint gtk_session_saved_properties_length1;
	gint _gtk_session_saved_properties_size_;
	gboolean closed;
	GHashTable* channel_handlers;
	BoxesDisplayOpenFDFunc open_fd;
	gpointer open_fd_target;
	GDestroyNotify open_fd_target_destroy_notify;
	SpiceMainChannel* _main_channel;
	gulong main_event_id;
	gulong main_mouse_mode_id;
};

typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES
} BoxesUIState;

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _Block79Data {
	int _ref_count_;
	BoxesSpiceDisplay* self;
	SpiceUsbDeviceManager* manager;
	BoxesProperty* usb_property;
};

struct _Block80Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _Block81Data {
	int _ref_count_;
	Block79Data * _data79_;
	SpiceUsbDevice* dev;
	GtkSwitch* dev_toggle;
};

struct _BoxesSpiceChannelHandler {
	GObject parent_instance;
	BoxesSpiceChannelHandlerPrivate * priv;
};

struct _BoxesSpiceChannelHandlerClass {
	GObjectClass parent_class;
};

struct _BoxesSpiceChannelHandlerPrivate {
	BoxesSpiceDisplay* display;
	SpiceChannel* channel;
	BoxesDisplayOpenFDFunc open_fd;
	gpointer open_fd_target;
	GDestroyNotify open_fd_target_destroy_notify;
};


static gpointer boxes_spice_display_parent_class = NULL;
static gpointer boxes_spice_channel_handler_parent_class = NULL;

GType boxes_properties_page_get_type (void) G_GNUC_CONST;
GType property_creation_flag_get_type (void) G_GNUC_CONST;
GType boxes_property_get_type (void) G_GNUC_CONST;
GType boxes_iproperties_provider_get_type (void) G_GNUC_CONST;
GType boxes_display_get_type (void) G_GNUC_CONST;
GType boxes_spice_display_get_type (void) G_GNUC_CONST;
GType boxes_collection_item_get_type (void) G_GNUC_CONST;
GType boxes_machine_get_type (void) G_GNUC_CONST;
GType boxes_spice_channel_handler_get_type (void) G_GNUC_CONST;
#define BOXES_SPICE_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayPrivate))
enum  {
	BOXES_SPICE_DISPLAY_DUMMY_PROPERTY,
	BOXES_SPICE_DISPLAY_PROTOCOL,
	BOXES_SPICE_DISPLAY_URI,
	BOXES_SPICE_DISPLAY_CA_CERT,
	BOXES_SPICE_DISPLAY_MAIN_CHANNEL
};
static void boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self);
static void _vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty* array, gint array_length);
static void boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self);
GType boxes_ui_state_get_type (void) G_GNUC_CONST;
GType boxes_ui_get_type (void) G_GNUC_CONST;
BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
GtkWidget* boxes_display_get_display (BoxesDisplay* self, gint n);
static gchar* boxes_spice_display_get_box_name (BoxesSpiceDisplay* self);
BoxesBoxConfig* boxes_display_get_config (BoxesDisplay* self);
SpiceMainChannel* boxes_spice_display_get_main_channel (BoxesSpiceDisplay* self);
void boxes_spice_display_set_main_channel (BoxesSpiceDisplay* self, SpiceMainChannel* value);
BoxesSpiceDisplay* boxes_spice_display_new (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject);
BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject);
BoxesDisplay* boxes_display_construct (GType object_type);
static void _boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void boxes_display_set_config (BoxesDisplay* self, BoxesBoxConfig* value);
BoxesSpiceDisplay* boxes_spice_display_new_with_uri (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri);
BoxesSpiceDisplay* boxes_spice_display_construct_with_uri (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri);
BoxesSpiceDisplay* boxes_spice_display_new_priv (BoxesMachine* machine, BoxesBoxConfig* config);
BoxesSpiceDisplay* boxes_spice_display_construct_priv (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config);
static GtkWidget* boxes_spice_display_real_get_display (BoxesDisplay* base, gint n);
static void ___lambda47_ (BoxesSpiceDisplay* self, gint status);
void boxes_display_set_mouse_grabbed (BoxesDisplay* self, gboolean value);
static void ____lambda47__spice_display_mouse_grab (SpiceDisplay* _sender, gint grabbed, gpointer self);
static void ___lambda48_ (BoxesSpiceDisplay* self, gint status);
void boxes_display_set_keyboard_grabbed (BoxesDisplay* self, gboolean value);
static void ____lambda48__spice_display_keyboard_grab (SpiceDisplay* _sender, gint grabbed, gpointer self);
static gboolean boxes_spice_display_has_usb_device_connected (BoxesSpiceDisplay* self);
static SpiceUsbDevice* _vala_SpiceUsbDevice_copy (SpiceUsbDevice* self);
static void _vala_SpiceUsbDevice_free (SpiceUsbDevice* self);
static gboolean boxes_spice_display_real_should_keep_alive (BoxesDisplay* base);
static void boxes_spice_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable);
static GdkPixbuf* boxes_spice_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error);
static void boxes_spice_display_real_collect_logs (BoxesDisplay* base, GString* builder);
gchar* boxes_display_get_uri (BoxesDisplay* self);
static void boxes_spice_display_real_connect_it (BoxesDisplay* base, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
static void _g_object_unref0_ (gpointer var);
static void boxes_spice_display_on_channel_new (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel);
static void _boxes_spice_display_on_channel_new_spice_session_channel_new (SpiceSession* _sender, SpiceChannel* channel, gpointer self);
static void boxes_spice_display_on_channel_destroy (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel);
static void _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy (SpiceSession* _sender, SpiceChannel* channel, gpointer self);
const gchar* boxes_display_get_password (BoxesDisplay* self);
static void boxes_spice_display_real_disconnect_it (BoxesDisplay* base);
BoxesSpiceChannelHandler* boxes_spice_channel_handler_new (BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify);
BoxesSpiceChannelHandler* boxes_spice_channel_handler_construct (GType object_type, BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify);
void boxes_display_access_start (BoxesDisplay* self);
void boxes_display_access_finish (BoxesDisplay* self);
static void boxes_spice_display_main_event (BoxesSpiceDisplay* self, SpiceChannelEvent event);
void boxes_display_set_need_password (BoxesDisplay* self, gboolean value);
static GList* boxes_spice_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page, PropertyCreationFlag* flags);
BoxesProperty* boxes_iproperties_provider_add_property (BoxesIPropertiesProvider* self, GList** list, const gchar* name, GtkWidget* widget, GtkWidget* extra_widget);
static Block79Data* block79_data_ref (Block79Data* _data79_);
static void block79_data_unref (void * _userdata_);
static GPtrArray* boxes_spice_display_get_usb_devices (BoxesSpiceDisplay* self, SpiceUsbDeviceManager* manager);
static Block80Data* block80_data_ref (Block80Data* _data80_);
static void block80_data_unref (void * _userdata_);
static gint ___lambda1__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint ____lambda50_ (SpiceUsbDevice* a, SpiceUsbDevice* b);
static gint _____lambda50__gcompare_func (gconstpointer a, gconstpointer b);
static Block81Data* block81_data_ref (Block81Data* _data81_);
static void block81_data_unref (void * _userdata_);
static void _______lambda51_ (Block81Data* _data81_);
static void ___lambda52_ (Block81Data* _data81_, GObject* obj, GAsyncResult* res);
static void ____lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ________lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ____lambda53_ (Block79Data* _data79_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev);
static void _____lambda53__spice_usb_device_manager_device_added (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self);
static void ____lambda54_ (Block79Data* _data79_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev);
static void _____lambda54__spice_usb_device_manager_device_removed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self);
static void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_spice_display_real_send_keys (BoxesDisplay* base, guint* keyvals, int keyvals_length1);
static void __vala_SpiceUsbDevice_free0_ (gpointer var);
static gboolean boxes_spice_display_is_usb_kbd_or_mouse (BoxesSpiceDisplay* self, guint8 class, guint8 subclass, guint8 protocol);
GByteArray* boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self);
void boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self, GByteArray* value);
static void _boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender, SpiceChannelEvent event, gpointer self);
static void _boxes_spice_display_main_channel___lambda49_ (BoxesSpiceDisplay* self);
void boxes_display_set_can_grab_mouse (BoxesDisplay* self, gboolean value);
static void __boxes_spice_display_main_channel___lambda49__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GObject * boxes_spice_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _boxes_spice_display____lambda55_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err);
static void __boxes_spice_display____lambda55__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self);
static void boxes_spice_display_finalize (GObject* obj);
const gchar* boxes_display_get_protocol (BoxesDisplay* self);
static void _vala_boxes_spice_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_boxes_spice_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define BOXES_SPICE_CHANNEL_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerPrivate))
enum  {
	BOXES_SPICE_CHANNEL_HANDLER_DUMMY_PROPERTY
};
static void boxes_spice_channel_handler_on_open_fd (BoxesSpiceChannelHandler* self, SpiceChannel* channel, gint with_tls);
static void _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd (SpiceChannel* _sender, gint with_tls, gpointer self);
static void boxes_spice_channel_handler_on_display_ready (BoxesSpiceChannelHandler* self, GObject* object, GParamSpec* param_spec);
static void _boxes_spice_channel_handler_on_display_ready_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void boxes_spice_channel_handler_finalize (GObject* obj);
void spice_validate_uri (const gchar* uri_as_text, gint** port, gint** tls_port, GError** error);
static gint* _int_dup (gint* self);


static void _vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty* array, gint array_length) {
#line 25 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (array != NULL) {
#line 375 "spice-display.c"
		int i;
#line 25 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 25 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			boxes_box_config_saved_property_destroy (&array[i]);
#line 381 "spice-display.c"
		}
	}
#line 25 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_free (array);
#line 386 "spice-display.c"
}


static void boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self) {
	BoxesMachine* _tmp0_ = NULL;
	BoxesUIState _tmp1_ = 0;
	BoxesUIState _tmp2_ = 0;
#line 32 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 34 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->machine;
#line 34 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp0_);
#line 34 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 34 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == BOXES_UI_STATE_DISPLAY) {
#line 404 "spice-display.c"
		SpiceDisplay* display = NULL;
		GtkWidget* _tmp3_ = NULL;
		SpiceDisplay* _tmp4_ = NULL;
		SpiceDisplay* _tmp5_ = NULL;
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = boxes_display_get_display ((BoxesDisplay*) self, 0);
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL;
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp4_ == NULL) {
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp3_);
#line 417 "spice-display.c"
		}
#line 36 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		display = _tmp4_;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = display;
#line 37 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp5_, "resize-guest", TRUE, NULL);
#line 34 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 427 "spice-display.c"
	}
}


static gchar* boxes_spice_display_get_box_name (BoxesSpiceDisplay* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	BoxesBoxConfig* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp7_ = NULL;
#line 41 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = boxes_box_config_get_last_seen_name (_tmp2_);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _tmp4_;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ == NULL) {
#line 454 "spice-display.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _ ("Unknown");
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp0_);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _tmp6_;
#line 465 "spice-display.c"
	}
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp0_;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = NULL;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp7_;
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp0_);
#line 43 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 477 "spice-display.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self ? g_object_ref (self) : NULL;
#line 484 "spice-display.c"
}


static void boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self) {
	SpiceMainChannel* _tmp0_ = NULL;
	SpiceMainChannel* _tmp1_ = NULL;
	GObject* o = NULL;
	SpiceMainChannel* _tmp2_ = NULL;
	SpiceMainChannel* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	GObject* _tmp7_ = NULL;
	gulong _tmp8_ = 0UL;
#line 90 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = boxes_spice_display_get_main_channel (self);
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _tmp0_;
#line 91 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp1_ == NULL) {
#line 92 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 509 "spice-display.c"
	}
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_display_get_main_channel (self);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, G_TYPE_OBJECT) ? ((GObject*) _tmp3_) : NULL);
#line 94 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	o = _tmp4_;
#line 95 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = o;
#line 95 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = self->priv->main_event_id;
#line 95 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_handler_disconnect (_tmp5_, _tmp6_);
#line 96 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->main_event_id = (gulong) 0;
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = o;
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = self->priv->main_mouse_mode_id;
#line 97 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_handler_disconnect (_tmp7_, _tmp8_);
#line 98 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->main_mouse_mode_id = (gulong) 0;
#line 99 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_set_main_channel (self, NULL);
#line 90 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (o);
#line 539 "spice-display.c"
}


static void _boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_ui_state_changed ((BoxesSpiceDisplay*) self);
#line 546 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject) {
	BoxesSpiceDisplay * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	BoxesMachine* _tmp2_ = NULL;
	BoxesMachine* _tmp3_ = NULL;
	BoxesBoxConfig* _tmp4_ = NULL;
	SpiceSession* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp12_ = 0;
	const gchar* _tmp17_ = NULL;
	BoxesBoxConfig* _tmp22_ = NULL;
	SpiceGtkSession* _tmp23_ = NULL;
	BoxesBoxConfigSavedProperty* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = port;
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = tls_port;
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_vala_return_val_if_fail ((_tmp0_ != 0) || (_tmp1_ != 0), "port != 0 || tls_port != 0", NULL);
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = machine;
#line 108 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp2_;
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = machine;
#line 109 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 111 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = config;
#line 111 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp4_);
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->session;
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = host;
#line 113 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp5_, "host", _tmp6_, NULL);
#line 114 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = port;
#line 114 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp7_ != 0) {
#line 602 "spice-display.c"
		SpiceSession* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = self->priv->session;
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = port;
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _tmp10_;
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp8_, "port", _tmp11_, NULL);
#line 115 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp11_);
#line 619 "spice-display.c"
	}
#line 117 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = tls_port;
#line 117 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp12_ != 0) {
#line 625 "spice-display.c"
		SpiceSession* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = self->priv->session;
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = tls_port;
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_;
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp13_, "tls-port", _tmp16_, NULL);
#line 118 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp16_);
#line 642 "spice-display.c"
	}
#line 124 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp17_ = host_subject;
#line 124 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp17_ != NULL) {
#line 648 "spice-display.c"
		SpiceSession* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = self->priv->session;
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = host_subject;
#line 125 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp18_, "cert-subject", _tmp19_, NULL);
#line 657 "spice-display.c"
	} else {
		SpiceSession* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp20_ = self->priv->session;
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp21_ = g_getenv ("BOXES_SPICE_HOST_SUBJECT");
#line 127 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp20_, "cert-subject", _tmp21_, NULL);
#line 667 "spice-display.c"
	}
#line 129 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp22_ = config;
#line 129 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp23_ = self->priv->gtk_session;
#line 129 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp24_ = self->priv->gtk_session_saved_properties;
#line 129 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp24__length1 = self->priv->gtk_session_saved_properties_length1;
#line 129 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_box_config_save_properties (_tmp22_, (GObject*) _tmp23_, _tmp24_, _tmp24__length1);
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self;
#line 681 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* host, gint port, gint tls_port, const gchar* host_subject) {
#line 106 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct (BOXES_TYPE_SPICE_DISPLAY, machine, config, host, port, tls_port, host_subject);
#line 688 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct_with_uri (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri) {
	BoxesSpiceDisplay * self = NULL;
	BoxesMachine* _tmp0_ = NULL;
	BoxesMachine* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	SpiceSession* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	BoxesBoxConfig* _tmp5_ = NULL;
	SpiceGtkSession* _tmp6_ = NULL;
	BoxesBoxConfigSavedProperty* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 132 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 132 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 132 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 132 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 133 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = machine;
#line 133 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp0_;
#line 134 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = machine;
#line 134 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 136 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = config;
#line 136 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp2_);
#line 138 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->session;
#line 138 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = uri;
#line 138 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp3_, "uri", _tmp4_, NULL);
#line 140 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = config;
#line 140 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = self->priv->gtk_session;
#line 140 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = self->priv->gtk_session_saved_properties;
#line 140 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7__length1 = self->priv->gtk_session_saved_properties_length1;
#line 140 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_box_config_save_properties (_tmp5_, (GObject*) _tmp6_, _tmp7_, _tmp7__length1);
#line 132 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self;
#line 741 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new_with_uri (BoxesMachine* machine, BoxesBoxConfig* config, const gchar* uri) {
#line 132 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct_with_uri (BOXES_TYPE_SPICE_DISPLAY, machine, config, uri);
#line 748 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_construct_priv (GType object_type, BoxesMachine* machine, BoxesBoxConfig* config) {
	BoxesSpiceDisplay * self = NULL;
	BoxesMachine* _tmp0_ = NULL;
	BoxesMachine* _tmp1_ = NULL;
	BoxesBoxConfig* _tmp2_ = NULL;
	BoxesBoxConfig* _tmp3_ = NULL;
	SpiceGtkSession* _tmp4_ = NULL;
	BoxesBoxConfigSavedProperty* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 143 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (machine != NULL, NULL);
#line 143 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (config != NULL, NULL);
#line 143 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
#line 144 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = machine;
#line 144 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->machine = _tmp0_;
#line 145 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = machine;
#line 145 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
#line 147 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = config;
#line 147 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_config ((BoxesDisplay*) self, _tmp2_);
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = config;
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = self->priv->gtk_session;
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->gtk_session_saved_properties;
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5__length1 = self->priv->gtk_session_saved_properties_length1;
#line 149 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_box_config_save_properties (_tmp3_, (GObject*) _tmp4_, _tmp5_, _tmp5__length1);
#line 143 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self;
#line 791 "spice-display.c"
}


BoxesSpiceDisplay* boxes_spice_display_new_priv (BoxesMachine* machine, BoxesBoxConfig* config) {
#line 143 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return boxes_spice_display_construct_priv (BOXES_TYPE_SPICE_DISPLAY, machine, config);
#line 798 "spice-display.c"
}


static void ___lambda47_ (BoxesSpiceDisplay* self, gint status) {
	gint _tmp0_ = 0;
#line 159 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = status;
#line 159 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_mouse_grabbed ((BoxesDisplay*) self, _tmp0_ != 0);
#line 808 "spice-display.c"
}


static void ____lambda47__spice_display_mouse_grab (SpiceDisplay* _sender, gint grabbed, gpointer self) {
#line 158 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda47_ ((BoxesSpiceDisplay*) self, grabbed);
#line 815 "spice-display.c"
}


static void ___lambda48_ (BoxesSpiceDisplay* self, gint status) {
	gint _tmp0_ = 0;
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = status;
#line 162 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_keyboard_grabbed ((BoxesDisplay*) self, _tmp0_ != 0);
#line 825 "spice-display.c"
}


static void ____lambda48__spice_display_keyboard_grab (SpiceDisplay* _sender, gint grabbed, gpointer self) {
#line 161 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda48_ ((BoxesSpiceDisplay*) self, grabbed);
#line 832 "spice-display.c"
}


static GtkWidget* boxes_spice_display_real_get_display (BoxesDisplay* base, gint n) {
	BoxesSpiceDisplay * self;
	GtkWidget* result = NULL;
	SpiceDisplay* display = NULL;
	GHashTable* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	SpiceDisplay* _tmp4_ = NULL;
	SpiceDisplay* _tmp5_ = NULL;
#line 152 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->displays;
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = n;
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) _tmp1_));
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = (GtkWidget*) _tmp2_;
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL);
#line 153 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	display = _tmp4_;
#line 155 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = display;
#line 155 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp5_ == NULL) {
#line 864 "spice-display.c"
		SpiceSession* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		SpiceDisplay* _tmp8_ = NULL;
		SpiceDisplay* _tmp9_ = NULL;
		SpiceDisplay* _tmp10_ = NULL;
		BoxesBoxConfig* _tmp11_ = NULL;
		BoxesBoxConfig* _tmp12_ = NULL;
		BoxesBoxConfigSavedProperty* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		SpiceDisplay* _tmp14_ = NULL;
		GHashTable* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		SpiceDisplay* _tmp17_ = NULL;
		GtkWidget* _tmp18_ = NULL;
#line 156 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->session;
#line 156 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp7_ = n;
#line 156 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = spice_display_new (_tmp6_, _tmp7_);
#line 156 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_ref_sink (_tmp8_);
#line 156 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 156 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		display = _tmp8_;
#line 158 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = display;
#line 158 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp9_, "mouse-grab", (GCallback) ____lambda47__spice_display_mouse_grab, self, 0);
#line 161 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = display;
#line 161 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp10_, "keyboard-grab", (GCallback) ____lambda48__spice_display_keyboard_grab, self, 0);
#line 164 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = boxes_display_get_config ((BoxesDisplay*) self);
#line 164 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 164 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = self->priv->display_saved_properties;
#line 164 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13__length1 = self->priv->display_saved_properties_length1;
#line 164 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_box_config_save_properties (_tmp12_, (GObject*) self, _tmp13_, _tmp13__length1);
#line 165 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = display;
#line 165 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_set (_tmp14_, "scaling", TRUE, NULL);
#line 167 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = ((BoxesDisplay*) self)->displays;
#line 167 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = n;
#line 167 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp17_ = display;
#line 167 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = _g_object_ref0 ((GtkWidget*) _tmp17_);
#line 167 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_hash_table_replace (_tmp15_, (gpointer) ((gintptr) _tmp16_), _tmp18_);
#line 923 "spice-display.c"
	}
#line 170 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = (GtkWidget*) display;
#line 170 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 929 "spice-display.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
#line 4803 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4803 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4803 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4803 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 944 "spice-display.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
#line 4804 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4804 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4804 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 956 "spice-display.c"
}


static SpiceUsbDevice* _vala_SpiceUsbDevice_copy (SpiceUsbDevice* self) {
#line 178 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return g_boxed_copy (spice_usb_device_get_type (), self);
#line 963 "spice-display.c"
}


static gpointer __vala_SpiceUsbDevice_copy0 (gpointer self) {
#line 178 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self ? _vala_SpiceUsbDevice_copy (self) : NULL;
#line 970 "spice-display.c"
}


static void _vala_SpiceUsbDevice_free (SpiceUsbDevice* self) {
#line 180 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_boxed_free (spice_usb_device_get_type (), self);
#line 977 "spice-display.c"
}


static gboolean boxes_spice_display_has_usb_device_connected (BoxesSpiceDisplay* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 173 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 986 "spice-display.c"
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp0_ = NULL;
		SpiceUsbDeviceManager* _tmp1_ = NULL;
		SpiceUsbDeviceManager* _tmp2_ = NULL;
		GPtrArray* devs = NULL;
		SpiceUsbDeviceManager* _tmp3_ = NULL;
		GPtrArray* _tmp4_ = NULL;
#line 175 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = self->priv->session;
#line 175 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp1_ = spice_usb_device_manager_get (_tmp0_, &_inner_error_);
#line 175 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 175 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		manager = _tmp2_;
#line 175 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1005 "spice-display.c"
			goto __catch76_g_error;
		}
#line 176 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = manager;
#line 176 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = spice_usb_device_manager_get_devices (_tmp3_);
#line 176 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		devs = _tmp4_;
#line 1014 "spice-display.c"
		{
			gint i = 0;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			i = 0;
#line 1019 "spice-display.c"
			{
				gboolean _tmp5_ = FALSE;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp5_ = TRUE;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				while (TRUE) {
#line 1026 "spice-display.c"
					gint _tmp7_ = 0;
					GPtrArray* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					SpiceUsbDevice* dev = NULL;
					GPtrArray* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gconstpointer _tmp13_ = NULL;
					SpiceUsbDevice* _tmp14_ = NULL;
					SpiceUsbDeviceManager* _tmp15_ = NULL;
					SpiceUsbDevice* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!_tmp5_) {
#line 1041 "spice-display.c"
						gint _tmp6_ = 0;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp6_ = i;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						i = _tmp6_ + 1;
#line 1047 "spice-display.c"
					}
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp5_ = FALSE;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp7_ = i;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp8_ = devs;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp9_ = g_ptr_array_get_length (_tmp8_);
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp10_ = _tmp9_;
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!(_tmp7_ < _tmp10_)) {
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						break;
#line 1063 "spice-display.c"
					}
#line 178 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp11_ = devs;
#line 178 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp12_ = i;
#line 178 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
#line 178 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp14_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp13_);
#line 178 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					dev = _tmp14_;
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp15_ = manager;
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp16_ = dev;
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp17_ = spice_usb_device_manager_is_device_connected (_tmp15_, _tmp16_);
#line 179 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (_tmp17_) {
#line 180 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						result = TRUE;
#line 180 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						__vala_SpiceUsbDevice_free0 (dev);
#line 180 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_ptr_array_unref0 (devs);
#line 180 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_object_unref0 (manager);
#line 180 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						return result;
#line 1093 "spice-display.c"
					}
#line 177 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 1097 "spice-display.c"
				}
			}
		}
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_ptr_array_unref0 (devs);
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 1105 "spice-display.c"
	}
	goto __finally76;
	__catch76_g_error:
	{
		GError* _error_ = NULL;
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 1117 "spice-display.c"
	}
	__finally76:
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 174 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return FALSE;
#line 1128 "spice-display.c"
	}
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = FALSE;
#line 184 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 1134 "spice-display.c"
}


static gboolean boxes_spice_display_real_should_keep_alive (BoxesDisplay* base) {
	BoxesSpiceDisplay * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 187 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 188 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->closed;
#line 188 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (!_tmp1_) {
#line 1149 "spice-display.c"
		gboolean _tmp2_ = FALSE;
#line 188 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = boxes_spice_display_has_usb_device_connected (self);
#line 188 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _tmp2_;
#line 1155 "spice-display.c"
	} else {
#line 188 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = FALSE;
#line 1159 "spice-display.c"
	}
#line 188 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp0_;
#line 188 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 1165 "spice-display.c"
}


static void boxes_spice_display_real_set_enable_audio (BoxesDisplay* base, gboolean enable) {
	BoxesSpiceDisplay * self;
	SpiceSession* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 191 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = enable;
#line 192 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp0_, "enable-audio", _tmp1_, NULL);
#line 1181 "spice-display.c"
}


static GdkPixbuf* boxes_spice_display_real_get_pixbuf (BoxesDisplay* base, gint n, GError** error) {
	BoxesSpiceDisplay * self;
	GdkPixbuf* result = NULL;
	SpiceDisplay* display = NULL;
	gint _tmp0_ = 0;
	GtkWidget* _tmp1_ = NULL;
	SpiceDisplay* _tmp2_ = NULL;
	SpiceDisplay* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	SpiceDisplay* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
#line 195 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = n;
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_display ((BoxesDisplay*) self, _tmp0_);
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp1_) : NULL;
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_tmp1_);
#line 1209 "spice-display.c"
	}
#line 196 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	display = _tmp2_;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = display;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp3_, "ready", &_tmp4_, NULL);
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_;
#line 198 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (!_tmp5_) {
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		result = NULL;
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (display);
#line 199 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return result;
#line 1227 "spice-display.c"
	}
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = display;
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = spice_display_get_pixbuf (_tmp6_);
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp7_;
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (display);
#line 201 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 1239 "spice-display.c"
}


static void boxes_spice_display_real_collect_logs (BoxesDisplay* base, GString* builder) {
	BoxesSpiceDisplay * self;
	GString* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SpiceGtkSession* _tmp4_ = NULL;
	SpiceMainChannel* _tmp10_ = NULL;
	SpiceMainChannel* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 204 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 204 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (builder != NULL);
#line 205 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = builder;
#line 205 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = boxes_display_get_uri ((BoxesDisplay*) self);
#line 205 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 205 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 205 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_string_append_printf (_tmp0_, "URI: %s\n", _tmp3_);
#line 205 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp3_);
#line 206 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = self->priv->gtk_session;
#line 206 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp4_ != NULL) {
#line 1273 "spice-display.c"
		const gchar* _tmp5_ = NULL;
		SpiceGtkSession* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GString* _tmp9_ = NULL;
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->gtk_session;
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp6_, "auto-clipboard", &_tmp7_, NULL);
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = _tmp7_;
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp8_) {
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp5_ = "yes";
#line 1289 "spice-display.c"
		} else {
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp5_ = "no";
#line 1293 "spice-display.c"
		}
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = builder;
#line 207 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp9_, "Auto clipboard sync: %s\n", _tmp5_);
#line 1299 "spice-display.c"
	}
#line 209 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = boxes_spice_display_get_main_channel (self);
#line 209 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = _tmp10_;
#line 209 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp11_ != NULL) {
#line 1307 "spice-display.c"
		GString* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		SpiceMainChannel* _tmp15_ = NULL;
		SpiceMainChannel* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		SpiceMainChannel* _tmp21_ = NULL;
		SpiceMainChannel* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		GString* _tmp25_ = NULL;
#line 210 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = builder;
#line 210 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = spice_util_get_version_string ();
#line 210 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp12_, "Spice-gtk version %s\n", _tmp13_);
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = boxes_spice_display_get_main_channel (self);
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_;
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp16_, "mouse-mode", &_tmp17_, NULL);
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = _tmp17_;
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp18_ == 1) {
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp14_ = "server";
#line 1340 "spice-display.c"
		} else {
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp14_ = "client";
#line 1344 "spice-display.c"
		}
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = builder;
#line 211 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp19_, "Mouse mode: %s\n", _tmp14_);
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp21_ = boxes_spice_display_get_main_channel (self);
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp22_ = _tmp21_;
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp22_, "agent-connected", &_tmp23_, NULL);
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp24_ = _tmp23_;
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp24_) {
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp20_ = "connected";
#line 1362 "spice-display.c"
		} else {
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp20_ = "disconnected";
#line 1366 "spice-display.c"
		}
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp25_ = builder;
#line 212 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_string_append_printf (_tmp25_, "Agent: %s\n", _tmp20_);
#line 1372 "spice-display.c"
	}
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp26_ = NULL;
		SpiceUsbDeviceManager* _tmp27_ = NULL;
		SpiceUsbDeviceManager* _tmp28_ = NULL;
		GPtrArray* devs = NULL;
		SpiceUsbDeviceManager* _tmp29_ = NULL;
		GPtrArray* _tmp30_ = NULL;
#line 216 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp26_ = self->priv->session;
#line 216 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp27_ = spice_usb_device_manager_get (_tmp26_, &_inner_error_);
#line 216 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 216 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		manager = _tmp28_;
#line 216 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1392 "spice-display.c"
			goto __catch77_g_error;
		}
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp29_ = manager;
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp30_ = spice_usb_device_manager_get_devices (_tmp29_);
#line 217 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		devs = _tmp30_;
#line 1401 "spice-display.c"
		{
			gint i = 0;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			i = 0;
#line 1406 "spice-display.c"
			{
				gboolean _tmp31_ = FALSE;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp31_ = TRUE;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				while (TRUE) {
#line 1413 "spice-display.c"
					gint _tmp33_ = 0;
					GPtrArray* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					gint _tmp36_ = 0;
					SpiceUsbDevice* dev = NULL;
					GPtrArray* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					gconstpointer _tmp39_ = NULL;
					SpiceUsbDevice* _tmp40_ = NULL;
					SpiceUsbDeviceManager* _tmp41_ = NULL;
					SpiceUsbDevice* _tmp42_ = NULL;
					gboolean _tmp43_ = FALSE;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!_tmp31_) {
#line 1428 "spice-display.c"
						gint _tmp32_ = 0;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp32_ = i;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						i = _tmp32_ + 1;
#line 1434 "spice-display.c"
					}
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp31_ = FALSE;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp33_ = i;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp34_ = devs;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp35_ = g_ptr_array_get_length (_tmp34_);
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp36_ = _tmp35_;
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (!(_tmp33_ < _tmp36_)) {
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						break;
#line 1450 "spice-display.c"
					}
#line 219 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp37_ = devs;
#line 219 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp38_ = i;
#line 219 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp39_ = g_ptr_array_index (_tmp37_, (guint) _tmp38_);
#line 219 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp40_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp39_);
#line 219 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					dev = _tmp40_;
#line 220 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp41_ = manager;
#line 220 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp42_ = dev;
#line 220 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp43_ = spice_usb_device_manager_is_device_connected (_tmp41_, _tmp42_);
#line 220 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (_tmp43_) {
#line 1470 "spice-display.c"
						GString* _tmp44_ = NULL;
						SpiceUsbDevice* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp44_ = builder;
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp45_ = dev;
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp46_ = spice_usb_device_get_description (_tmp45_, "%s %s %s at %d-%d");
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp47_ = _tmp46_;
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						g_string_append_printf (_tmp44_, "USB device redirected: %s\n", _tmp47_);
#line 221 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_g_free0 (_tmp47_);
#line 1487 "spice-display.c"
					}
#line 218 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 1491 "spice-display.c"
				}
			}
		}
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_ptr_array_unref0 (devs);
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 1499 "spice-display.c"
	}
	goto __finally77;
	__catch77_g_error:
	{
		GError* _error_ = NULL;
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 1511 "spice-display.c"
	}
	__finally77:
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 215 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 1522 "spice-display.c"
	}
}


static void _g_object_unref0_ (gpointer var) {
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1530 "spice-display.c"
}


static void _boxes_spice_display_on_channel_new_spice_session_channel_new (SpiceSession* _sender, SpiceChannel* channel, gpointer self) {
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_on_channel_new ((BoxesSpiceDisplay*) self, _sender, channel);
#line 1537 "spice-display.c"
}


static void _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy (SpiceSession* _sender, SpiceChannel* channel, gpointer self) {
#line 241 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_on_channel_destroy ((BoxesSpiceDisplay*) self, _sender, channel);
#line 1544 "spice-display.c"
}


static void boxes_spice_display_real_connect_it (BoxesDisplay* base, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error) {
	BoxesSpiceDisplay * self;
	gboolean _tmp0_ = FALSE;
	BoxesDisplayOpenFDFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	gulong _tmp8_ = 0UL;
	SpiceSession* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	BoxesDisplayOpenFDFunc _tmp14_ = NULL;
	void* _tmp14__target = NULL;
#line 227 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = ((BoxesDisplay*) self)->connected;
#line 229 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_) {
#line 230 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 230 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		open_fd = NULL;
#line 230 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		open_fd_target = NULL;
#line 230 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		open_fd_target_destroy_notify = NULL;
#line 230 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 1580 "spice-display.c"
	}
#line 231 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplay*) self)->connected = TRUE;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = open_fd;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1__target = open_fd_target;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1__target_destroy_notify = open_fd_target_destroy_notify;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = _tmp1_;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = _tmp1__target;
#line 232 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = _tmp1__target_destroy_notify;
#line 234 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = g_direct_hash;
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = g_direct_equal;
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, _g_object_unref0_);
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_hash_table_unref0 (self->priv->channel_handlers);
#line 235 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->channel_handlers = _tmp4_;
#line 238 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->channel_new_id;
#line 238 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp5_ == ((gulong) 0)) {
#line 1622 "spice-display.c"
		SpiceSession* _tmp6_ = NULL;
		gulong _tmp7_ = 0UL;
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->session;
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp7_ = g_signal_connect_object (_tmp6_, "channel-new", (GCallback) _boxes_spice_display_on_channel_new_spice_session_channel_new, self, 0);
#line 239 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->channel_new_id = _tmp7_;
#line 1631 "spice-display.c"
	}
#line 240 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = self->priv->channel_destroy_id;
#line 240 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp8_ == ((gulong) 0)) {
#line 1637 "spice-display.c"
		SpiceSession* _tmp9_ = NULL;
		gulong _tmp10_ = 0UL;
#line 241 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = self->priv->session;
#line 241 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = g_signal_connect_object (_tmp9_, "channel-destroy", (GCallback) _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy, self, 0);
#line 241 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->channel_destroy_id = _tmp10_;
#line 1646 "spice-display.c"
	}
#line 243 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = self->priv->session;
#line 243 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = boxes_display_get_password ((BoxesDisplay*) self);
#line 243 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp13_ = _tmp12_;
#line 243 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp11_, "password", _tmp13_, NULL);
#line 244 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp14_ = open_fd;
#line 244 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp14__target = open_fd_target;
#line 244 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp14_ != NULL) {
#line 1662 "spice-display.c"
		SpiceSession* _tmp15_ = NULL;
#line 245 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = self->priv->session;
#line 245 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_session_open_fd (_tmp15_, -1);
#line 1668 "spice-display.c"
	} else {
		SpiceSession* _tmp16_ = NULL;
#line 247 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = self->priv->session;
#line 247 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_session_connect (_tmp16_);
#line 1675 "spice-display.c"
	}
#line 227 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 227 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd = NULL;
#line 227 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd_target = NULL;
#line 227 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 1685 "spice-display.c"
}


static void boxes_spice_display_real_disconnect_it (BoxesDisplay* base) {
	BoxesSpiceDisplay * self;
	gulong _tmp0_ = 0UL;
	gulong _tmp3_ = 0UL;
	SpiceSession* _tmp6_ = NULL;
	GHashTable* _tmp7_ = NULL;
#line 250 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 251 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->channel_new_id;
#line 251 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ > ((gulong) 0)) {
#line 1701 "spice-display.c"
		SpiceSession* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
#line 252 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp1_ = self->priv->session;
#line 252 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = self->priv->channel_new_id;
#line 252 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, G_TYPE_OBJECT) ? ((GObject*) _tmp1_) : NULL, _tmp2_);
#line 253 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->channel_new_id = (gulong) 0;
#line 1712 "spice-display.c"
	}
#line 255 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->channel_destroy_id;
#line 255 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp3_ > ((gulong) 0)) {
#line 1718 "spice-display.c"
		SpiceSession* _tmp4_ = NULL;
		gulong _tmp5_ = 0UL;
#line 256 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = self->priv->session;
#line 256 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = self->priv->channel_destroy_id;
#line 256 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, G_TYPE_OBJECT) ? ((GObject*) _tmp4_) : NULL, _tmp5_);
#line 257 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self->priv->channel_destroy_id = (gulong) 0;
#line 1729 "spice-display.c"
	}
#line 259 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = self->priv->session;
#line 259 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	spice_session_disconnect (_tmp6_);
#line 260 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 261 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_hash_table_unref0 (self->priv->channel_handlers);
#line 261 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->channel_handlers = NULL;
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 262 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 263 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = ((BoxesDisplay*) self)->displays;
#line 263 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_hash_table_remove_all (_tmp7_);
#line 1759 "spice-display.c"
}


static void boxes_spice_display_on_channel_new (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel) {
	BoxesSpiceChannelHandler* handler = NULL;
	SpiceChannel* _tmp0_ = NULL;
	BoxesDisplayOpenFDFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	BoxesSpiceChannelHandler* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	SpiceChannel* _tmp4_ = NULL;
	SpiceChannel* _tmp5_ = NULL;
	BoxesSpiceChannelHandler* _tmp6_ = NULL;
	BoxesSpiceChannelHandler* _tmp7_ = NULL;
	SpiceChannel* _tmp8_ = NULL;
#line 266 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 266 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (session != NULL);
#line 266 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 267 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = channel;
#line 267 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->open_fd;
#line 267 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1__target = self->priv->open_fd_target;
#line 267 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1__target_destroy_notify = self->priv->open_fd_target_destroy_notify;
#line 267 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 267 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_channel_handler_new (self, _tmp0_, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
#line 267 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	handler = _tmp2_;
#line 268 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = self->priv->channel_handlers;
#line 268 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = channel;
#line 268 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 268 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = handler;
#line 268 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 268 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_hash_table_insert (_tmp3_, _tmp5_, _tmp7_);
#line 270 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = channel;
#line 270 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, spice_display_channel_get_type ())) {
#line 1812 "spice-display.c"
		SpiceChannel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 271 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = channel;
#line 271 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp9_, "channel-id", &_tmp10_, NULL);
#line 271 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _tmp10_;
#line 271 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp11_ != 0) {
#line 272 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (handler);
#line 272 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 1828 "spice-display.c"
		}
#line 274 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_display_access_start ((BoxesDisplay*) self);
#line 1832 "spice-display.c"
	}
#line 266 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (handler);
#line 1836 "spice-display.c"
}


static void boxes_spice_display_on_channel_destroy (BoxesSpiceDisplay* self, SpiceSession* session, SpiceChannel* channel) {
	SpiceChannel* _tmp0_ = NULL;
	SpiceDisplayChannel* display = NULL;
	SpiceChannel* _tmp1_ = NULL;
	SpiceDisplayChannel* _tmp2_ = NULL;
	SpiceDisplayChannel* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 278 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 278 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (session != NULL);
#line 278 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 279 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = channel;
#line 279 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_channel_get_type ())) {
#line 280 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 1860 "spice-display.c"
	}
#line 282 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = channel;
#line 282 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, spice_display_channel_get_type ()) ? ((SpiceDisplayChannel*) _tmp1_) : NULL);
#line 282 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	display = _tmp2_;
#line 283 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = display;
#line 283 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get ((SpiceChannel*) _tmp3_, "channel-id", &_tmp4_, NULL);
#line 283 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_;
#line 283 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "hide", _tmp5_);
#line 284 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_access_finish ((BoxesDisplay*) self);
#line 278 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (display);
#line 1880 "spice-display.c"
}


static void boxes_spice_display_main_event (BoxesSpiceDisplay* self, SpiceChannelEvent event) {
	SpiceChannelEvent _tmp0_ = 0;
#line 287 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = event;
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (_tmp0_) {
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_CLOSED:
#line 1894 "spice-display.c"
		{
#line 290 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			self->priv->closed = TRUE;
#line 291 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", FALSE);
#line 292 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1902 "spice-display.c"
		}
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_AUTH:
#line 1906 "spice-display.c"
		{
#line 295 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			boxes_display_set_need_password ((BoxesDisplay*) self, TRUE);
#line 296 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1912 "spice-display.c"
		}
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_CONNECT:
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_TLS:
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_LINK:
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_ERROR_IO:
#line 1922 "spice-display.c"
		{
			SpiceChannelEvent _tmp1_ = 0;
#line 302 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp1_ = event;
#line 302 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_debug ("spice-display.vala:302: main SPICE channel error: %d", (gint) _tmp1_);
#line 303 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			self->priv->closed = TRUE;
#line 304 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", TRUE);
#line 305 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1935 "spice-display.c"
		}
#line 288 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case SPICE_CHANNEL_OPENED:
#line 1939 "spice-display.c"
		{
#line 308 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1943 "spice-display.c"
		}
		default:
		{
			SpiceChannelEvent _tmp2_ = 0;
#line 311 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp2_ = event;
#line 311 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_debug ("spice-display.vala:311: unhandled main SPICE channel event: %d", (gint) _tmp2_);
#line 312 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 1954 "spice-display.c"
		}
	}
}


static Block79Data* block79_data_ref (Block79Data* _data79_) {
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data79_->_ref_count_);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return _data79_;
#line 1965 "spice-display.c"
}


static void block79_data_unref (void * _userdata_) {
	Block79Data* _data79_;
	_data79_ = (Block79Data*) _userdata_;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data79_->_ref_count_)) {
#line 1974 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self = _data79_->self;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data79_->usb_property);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data79_->manager);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (self);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block79Data, _data79_);
#line 1986 "spice-display.c"
	}
}


static Block80Data* block80_data_ref (Block80Data* _data80_) {
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	g_atomic_int_inc (&_data80_->_ref_count_);
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	return _data80_;
#line 1996 "spice-display.c"
}


static void block80_data_unref (void * _userdata_) {
	Block80Data* _data80_;
	_data80_ = (Block80Data*) _userdata_;
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	if (g_atomic_int_dec_and_test (&_data80_->_ref_count_)) {
#line 2005 "spice-display.c"
		GPtrArray* self;
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
		self = _data80_->self;
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_ptr_array_unref0 (self);
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
		g_slice_free (Block80Data, _data80_);
#line 2013 "spice-display.c"
	}
}


static gint __lambda1_ (Block80Data* _data80_, gconstpointer** a, gconstpointer** b) {
	GPtrArray* self;
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	gconstpointer** _tmp1_ = NULL;
	gconstpointer** _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 4788 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	self = _data80_->self;
#line 4789 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = _data80_->compare_func;
#line 4789 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = a;
#line 4789 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = b;
#line 4789 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_ ((gconstpointer**) (*_tmp1_), (gconstpointer**) (*_tmp2_));
#line 4789 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp3_;
#line 4789 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 2039 "spice-display.c"
}


static gint ___lambda1__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda1_ (self, a, b);
#line 4788 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 2048 "spice-display.c"
}


static void vala_g_ptr_array_sort (GPtrArray* self, GCompareFunc compare_func) {
	Block80Data* _data80_;
	GCompareFunc _tmp0_ = NULL;
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_data80_ = g_slice_new0 (Block80Data);
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_data80_->_ref_count_ = 1;
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_data80_->self = g_ptr_array_ref (self);
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = compare_func;
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_data80_->compare_func = _tmp0_;
#line 4788 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	g_ptr_array_sort_with_data (self, ___lambda1__gcompare_data_func, _data80_);
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	block80_data_unref (_data80_);
#line 4787 "/home/zeenix/jhbuild/share/vala-0.32/vapi/glib-2.0.vapi"
	_data80_ = NULL;
#line 2073 "spice-display.c"
}


static gint ____lambda50_ (SpiceUsbDevice* a, SpiceUsbDevice* b) {
	gint result = 0;
	gchar* str_a = NULL;
	SpiceUsbDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* str_b = NULL;
	SpiceUsbDevice* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 340 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = a;
#line 340 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = spice_usb_device_get_description (_tmp0_, "    %1$s %2$s");
#line 340 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	str_a = _tmp1_;
#line 341 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = b;
#line 341 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = spice_usb_device_get_description (_tmp2_, "    %1$s %2$s");
#line 341 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	str_b = _tmp3_;
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = g_strcmp0;
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_ (str_a, str_b);
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp5_;
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (str_b);
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (str_a);
#line 343 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2115 "spice-display.c"
}


static gint _____lambda50__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ____lambda50_ ((SpiceUsbDevice*) a, (SpiceUsbDevice*) b);
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2124 "spice-display.c"
}


static Block81Data* block81_data_ref (Block81Data* _data81_) {
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_atomic_int_inc (&_data81_->_ref_count_);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return _data81_;
#line 2133 "spice-display.c"
}


static void block81_data_unref (void * _userdata_) {
	Block81Data* _data81_;
	_data81_ = (Block81Data*) _userdata_;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (g_atomic_int_dec_and_test (&_data81_->_ref_count_)) {
#line 2142 "spice-display.c"
		BoxesSpiceDisplay* self;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		self = _data81_->_data79_->self;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_data81_->dev_toggle);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		__vala_SpiceUsbDevice_free0 (_data81_->dev);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		block79_data_unref (_data81_->_data79_);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_data81_->_data79_ = NULL;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_slice_free (Block81Data, _data81_);
#line 2156 "spice-display.c"
	}
}


static void ___lambda52_ (Block81Data* _data81_, GObject* obj, GAsyncResult* res) {
	Block79Data* _data79_;
	BoxesSpiceDisplay* self;
	GError * _inner_error_ = NULL;
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data79_ = _data81_->_data79_;
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data79_->self;
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (res != NULL);
#line 2171 "spice-display.c"
	{
		SpiceUsbDeviceManager* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 373 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _data79_->manager;
#line 373 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp1_ = res;
#line 373 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_connect_device_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 373 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2183 "spice-display.c"
			goto __catch79_g_error;
		}
	}
	goto __finally79;
	__catch79_g_error:
	{
		GError* err = NULL;
		GtkSwitch* _tmp2_ = NULL;
		gchar* device_desc = NULL;
		SpiceUsbDevice* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* box_name = NULL;
		gchar* _tmp5_ = NULL;
		gchar* msg = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		err = _inner_error_;
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 375 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp2_ = _data81_->dev_toggle;
#line 375 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		gtk_switch_set_active (_tmp2_, FALSE);
#line 376 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _data81_->dev;
#line 376 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = spice_usb_device_get_description (_tmp3_, "%1$s %2$s");
#line 376 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		device_desc = _tmp4_;
#line 377 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = boxes_spice_display_get_box_name (self);
#line 377 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		box_name = _tmp5_;
#line 378 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = _ ("Redirection of USB device '%s' for '%s' failed");
#line 378 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 378 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		msg = _tmp7_;
#line 379 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = msg;
#line 379 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = device_desc;
#line 379 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = box_name;
#line 379 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = g_strdup_printf (_tmp8_, _tmp9_, _tmp10_);
#line 379 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 379 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp12_);
#line 379 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp12_);
#line 380 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = device_desc;
#line 380 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = box_name;
#line 380 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = err;
#line 380 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = _tmp15_->message;
#line 380 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_debug ("spice-display.vala:380: Error connecting %s to %s: %s", _tmp13_, _tmp14_, _tmp16_);
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (msg);
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (box_name);
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (device_desc);
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (err);
#line 2265 "spice-display.c"
	}
	__finally79:
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 372 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 2276 "spice-display.c"
	}
}


static void ____lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	___lambda52_ (self, source_object, res);
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	block81_data_unref (self);
#line 2286 "spice-display.c"
}


static void _______lambda51_ (Block81Data* _data81_) {
	Block79Data* _data79_;
	BoxesSpiceDisplay* self;
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 369 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_data79_ = _data81_->_data79_;
#line 369 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data79_->self;
#line 370 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data81_->dev_toggle;
#line 370 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 370 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 370 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_) {
#line 2308 "spice-display.c"
		SpiceUsbDeviceManager* _tmp3_ = NULL;
		SpiceUsbDevice* _tmp4_ = NULL;
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _data79_->manager;
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = _data81_->dev;
#line 371 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_connect_device_async (_tmp3_, _tmp4_, NULL, ____lambda52__gasync_ready_callback, block81_data_ref (_data81_));
#line 2317 "spice-display.c"
	} else {
		SpiceUsbDeviceManager* _tmp5_ = NULL;
		SpiceUsbDevice* _tmp6_ = NULL;
#line 386 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = _data79_->manager;
#line 386 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = _data81_->dev;
#line 386 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_usb_device_manager_disconnect_device (_tmp5_, _tmp6_);
#line 2327 "spice-display.c"
	}
}


static void ________lambda51__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 369 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_______lambda51_ (self);
#line 2335 "spice-display.c"
}


static void ____lambda53_ (Block79Data* _data79_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev) {
	BoxesSpiceDisplay* self;
	BoxesProperty* _tmp0_ = NULL;
#line 393 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data79_->self;
#line 393 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (manager != NULL);
#line 393 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 394 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data79_->usb_property;
#line 394 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name (_tmp0_, "refresh-properties");
#line 2352 "spice-display.c"
}


static void _____lambda53__spice_usb_device_manager_device_added (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self) {
#line 393 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	____lambda53_ (self, _sender, device);
#line 2359 "spice-display.c"
}


static void ____lambda54_ (Block79Data* _data79_, SpiceUsbDeviceManager* manager, SpiceUsbDevice* dev) {
	BoxesSpiceDisplay* self;
	BoxesProperty* _tmp0_ = NULL;
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = _data79_->self;
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (manager != NULL);
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 397 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = _data79_->usb_property;
#line 397 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name (_tmp0_, "refresh-properties");
#line 2376 "spice-display.c"
}


static void _____lambda54__spice_usb_device_manager_device_removed (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, gpointer self) {
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	____lambda54_ (self, _sender, device);
#line 2383 "spice-display.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_list_free (self);
#line 2392 "spice-display.c"
}


static GList* boxes_spice_display_real_get_properties (BoxesDisplay* base, BoxesPropertiesPage page, PropertyCreationFlag* flags) {
	BoxesSpiceDisplay * self;
	GList* result = NULL;
	GList* list = NULL;
	BoxesPropertiesPage _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 316 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 317 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	list = NULL;
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = page;
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (_tmp0_) {
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_PROPERTIES_PAGE_GENERAL:
#line 2412 "spice-display.c"
		{
			GtkSwitch* toggle = NULL;
			GtkSwitch* _tmp1_ = NULL;
			SpiceGtkSession* _tmp2_ = NULL;
			GtkSwitch* _tmp3_ = NULL;
			GtkSwitch* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GtkSwitch* _tmp6_ = NULL;
			BoxesProperty* _tmp7_ = NULL;
			BoxesProperty* _tmp8_ = NULL;
#line 321 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp1_ = (GtkSwitch*) gtk_switch_new ();
#line 321 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_object_ref_sink (_tmp1_);
#line 321 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			toggle = _tmp1_;
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp2_ = self->priv->gtk_session;
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp3_ = toggle;
#line 322 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_object_bind_property_with_closures ((GObject*) _tmp2_, "auto-clipboard", (GObject*) _tmp3_, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp4_ = toggle;
#line 324 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp5_ = _ ("Share Clipboard");
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp6_ = toggle;
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp7_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp5_, (GtkWidget*) _tmp6_, NULL);
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp8_ = _tmp7_;
#line 325 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp8_);
#line 326 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (toggle);
#line 326 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 2453 "spice-display.c"
		}
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_PROPERTIES_PAGE_DEVICES:
#line 2457 "spice-display.c"
		{
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			PropertyCreationFlag _tmp11_ = 0;
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp11_ = *flags;
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if ((_tmp11_ & PROPERTY_CREATION_FLAG_NO_USB) == PROPERTY_CREATION_FLAG_NO_USB) {
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp10_ = TRUE;
#line 2468 "spice-display.c"
			} else {
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp10_ = !HAVE_USBREDIR;
#line 2472 "spice-display.c"
			}
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if (_tmp10_) {
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp9_ = TRUE;
#line 2478 "spice-display.c"
			} else {
				gboolean _tmp12_ = FALSE;
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp12_ = ((BoxesDisplay*) self)->connected;
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp9_ = !_tmp12_;
#line 2485 "spice-display.c"
			}
#line 329 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if (_tmp9_) {
#line 330 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				break;
#line 2491 "spice-display.c"
			}
			{
				Block79Data* _data79_;
				SpiceSession* _tmp13_ = NULL;
				SpiceUsbDeviceManager* _tmp14_ = NULL;
				SpiceUsbDeviceManager* _tmp15_ = NULL;
				GPtrArray* devs = NULL;
				SpiceUsbDeviceManager* _tmp16_ = NULL;
				GPtrArray* _tmp17_ = NULL;
				GPtrArray* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				GPtrArray* _tmp21_ = NULL;
				GtkFrame* frame = NULL;
				GtkFrame* _tmp22_ = NULL;
				GtkListBox* listbox = NULL;
				GtkListBox* _tmp23_ = NULL;
				GtkListBox* _tmp24_ = NULL;
				GtkFrame* _tmp25_ = NULL;
				GtkListBox* _tmp26_ = NULL;
				const gchar* _tmp61_ = NULL;
				GtkLabel* _tmp62_ = NULL;
				GtkLabel* _tmp63_ = NULL;
				GtkFrame* _tmp64_ = NULL;
				BoxesProperty* _tmp65_ = NULL;
				BoxesProperty* _tmp66_ = NULL;
				SpiceUsbDeviceManager* _tmp67_ = NULL;
				SpiceUsbDeviceManager* _tmp68_ = NULL;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data79_ = g_slice_new0 (Block79Data);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data79_->_ref_count_ = 1;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data79_->self = g_object_ref (self);
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp13_ = self->priv->session;
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp14_ = spice_usb_device_manager_get (_tmp13_, &_inner_error_);
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp15_ = _g_object_ref0 (_tmp14_);
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data79_->manager = _tmp15_;
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					block79_data_unref (_data79_);
#line 333 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_data79_ = NULL;
#line 2540 "spice-display.c"
					goto __catch78_g_error;
				}
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp16_ = _data79_->manager;
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp17_ = boxes_spice_display_get_usb_devices (self, _tmp16_);
#line 334 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				devs = _tmp17_;
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp18_ = devs;
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp19_ = g_ptr_array_get_length (_tmp18_);
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp20_ = _tmp19_;
#line 336 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (_tmp20_ <= 0) {
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					result = list;
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_ptr_array_unref0 (devs);
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					block79_data_unref (_data79_);
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_data79_ = NULL;
#line 337 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					return result;
#line 2567 "spice-display.c"
				}
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp21_ = devs;
#line 339 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				vala_g_ptr_array_sort (_tmp21_, _____lambda50__gcompare_func);
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp22_ = (GtkFrame*) gtk_frame_new (NULL);
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_object_ref_sink (_tmp22_);
#line 346 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				frame = _tmp22_;
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp23_ = (GtkListBox*) gtk_list_box_new ();
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_object_ref_sink (_tmp23_);
#line 347 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				listbox = _tmp23_;
#line 348 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp24_ = listbox;
#line 348 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
#line 349 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp25_ = frame;
#line 349 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp26_ = listbox;
#line 349 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
#line 2595 "spice-display.c"
				{
					gint i = 0;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					i = 0;
#line 2600 "spice-display.c"
					{
						gboolean _tmp27_ = FALSE;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_tmp27_ = TRUE;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						while (TRUE) {
#line 2607 "spice-display.c"
							Block81Data* _data81_;
							gint _tmp29_ = 0;
							GPtrArray* _tmp30_ = NULL;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							GPtrArray* _tmp33_ = NULL;
							gint _tmp34_ = 0;
							gconstpointer _tmp35_ = NULL;
							SpiceUsbDevice* _tmp36_ = NULL;
							GtkBox* hbox = NULL;
							GtkBox* _tmp37_ = NULL;
							GtkBox* _tmp38_ = NULL;
							GtkBox* _tmp39_ = NULL;
							GtkBox* _tmp40_ = NULL;
							GtkBox* _tmp41_ = NULL;
							GtkLabel* label = NULL;
							SpiceUsbDevice* _tmp42_ = NULL;
							gchar* _tmp43_ = NULL;
							gchar* _tmp44_ = NULL;
							GtkLabel* _tmp45_ = NULL;
							GtkLabel* _tmp46_ = NULL;
							GtkLabel* _tmp47_ = NULL;
							GtkBox* _tmp48_ = NULL;
							GtkLabel* _tmp49_ = NULL;
							GtkSwitch* _tmp50_ = NULL;
							GtkSwitch* _tmp51_ = NULL;
							GtkBox* _tmp52_ = NULL;
							GtkSwitch* _tmp53_ = NULL;
							GtkListBox* _tmp54_ = NULL;
							GtkBox* _tmp55_ = NULL;
							GtkSwitch* _tmp56_ = NULL;
							SpiceUsbDeviceManager* _tmp57_ = NULL;
							SpiceUsbDevice* _tmp58_ = NULL;
							gboolean _tmp59_ = FALSE;
							GtkSwitch* _tmp60_ = NULL;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_data81_ = g_slice_new0 (Block81Data);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_data81_->_ref_count_ = 1;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_data81_->_data79_ = block79_data_ref (_data79_);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							if (!_tmp27_) {
#line 2651 "spice-display.c"
								gint _tmp28_ = 0;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_tmp28_ = i;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								i = _tmp28_ + 1;
#line 2657 "spice-display.c"
							}
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp27_ = FALSE;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp29_ = i;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp30_ = devs;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp31_ = g_ptr_array_get_length (_tmp30_);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp32_ = _tmp31_;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							if (!(_tmp29_ < _tmp32_)) {
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								block81_data_unref (_data81_);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_data81_ = NULL;
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								break;
#line 2677 "spice-display.c"
							}
#line 352 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp33_ = devs;
#line 352 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp34_ = i;
#line 352 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp35_ = g_ptr_array_index (_tmp33_, (guint) _tmp34_);
#line 352 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp36_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp35_);
#line 352 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_data81_->dev = _tmp36_;
#line 354 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp37_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 354 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							g_object_ref_sink (_tmp37_);
#line 354 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							hbox = _tmp37_;
#line 355 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp38_ = hbox;
#line 355 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_start ((GtkWidget*) _tmp38_, 12);
#line 356 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp39_ = hbox;
#line 356 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_end ((GtkWidget*) _tmp39_, 12);
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp40_ = hbox;
#line 357 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_top ((GtkWidget*) _tmp40_, 6);
#line 358 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp41_ = hbox;
#line 358 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_margin_bottom ((GtkWidget*) _tmp41_, 6);
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp42_ = _data81_->dev;
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp43_ = spice_usb_device_get_description (_tmp42_, "%1$s %2$s");
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp44_ = _tmp43_;
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp45_ = (GtkLabel*) gtk_label_new (_tmp44_);
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							g_object_ref_sink (_tmp45_);
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp46_ = _tmp45_;
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_g_free0 (_tmp44_);
#line 359 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							label = _tmp46_;
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp47_ = label;
#line 360 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_halign ((GtkWidget*) _tmp47_, GTK_ALIGN_START);
#line 361 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp48_ = hbox;
#line 361 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp49_ = label;
#line 361 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, TRUE, TRUE, (guint) 0);
#line 362 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp50_ = (GtkSwitch*) gtk_switch_new ();
#line 362 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							g_object_ref_sink (_tmp50_);
#line 362 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_data81_->dev_toggle = _tmp50_;
#line 363 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp51_ = _data81_->dev_toggle;
#line 363 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_widget_set_halign ((GtkWidget*) _tmp51_, GTK_ALIGN_END);
#line 364 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp52_ = hbox;
#line 364 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp53_ = _data81_->dev_toggle;
#line 364 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, TRUE, TRUE, (guint) 0);
#line 365 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp54_ = listbox;
#line 365 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp55_ = hbox;
#line 365 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_list_box_prepend (_tmp54_, (GtkWidget*) _tmp55_);
#line 367 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp56_ = _data81_->dev_toggle;
#line 367 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp57_ = _data79_->manager;
#line 367 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp58_ = _data81_->dev;
#line 367 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp59_ = spice_usb_device_manager_is_device_connected (_tmp57_, _tmp58_);
#line 367 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							gtk_switch_set_active (_tmp56_, _tmp59_);
#line 369 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp60_ = _data81_->dev_toggle;
#line 369 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							g_signal_connect_data ((GObject*) _tmp60_, "notify::active", (GCallback) ________lambda51__g_object_notify, block81_data_ref (_data81_), (GClosureNotify) block81_data_unref, 0);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_g_object_unref0 (label);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_g_object_unref0 (hbox);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							block81_data_unref (_data81_);
#line 351 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_data81_ = NULL;
#line 2781 "spice-display.c"
						}
					}
				}
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp61_ = _ ("USB devices");
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp62_ = (GtkLabel*) gtk_label_new ("");
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_object_ref_sink (_tmp62_);
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp63_ = _tmp62_;
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp64_ = frame;
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp65_ = boxes_iproperties_provider_add_property ((BoxesIPropertiesProvider*) self, &list, _tmp61_, (GtkWidget*) _tmp63_, (GtkWidget*) _tmp64_);
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp66_ = _tmp65_;
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (_tmp63_);
#line 391 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data79_->usb_property = _tmp66_;
#line 393 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp67_ = _data79_->manager;
#line 393 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_signal_connect_data (_tmp67_, "device-added", (GCallback) _____lambda53__spice_usb_device_manager_device_added, block79_data_ref (_data79_), (GClosureNotify) block79_data_unref, 0);
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp68_ = _data79_->manager;
#line 396 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_signal_connect_data (_tmp68_, "device-removed", (GCallback) _____lambda54__spice_usb_device_manager_device_removed, block79_data_ref (_data79_), (GClosureNotify) block79_data_unref, 0);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (listbox);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_g_object_unref0 (frame);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_g_ptr_array_unref0 (devs);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				block79_data_unref (_data79_);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_data79_ = NULL;
#line 2821 "spice-display.c"
			}
			goto __finally78;
			__catch78_g_error:
			{
				GError* _error_ = NULL;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_error_ = _inner_error_;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_inner_error_ = NULL;
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_g_error_free0 (_error_);
#line 2833 "spice-display.c"
			}
			__finally78:
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				__g_list_free__g_object_unref0_0 (list);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_clear_error (&_inner_error_);
#line 332 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				return NULL;
#line 2846 "spice-display.c"
			}
#line 401 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			break;
#line 2850 "spice-display.c"
		}
		default:
#line 319 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 2855 "spice-display.c"
	}
#line 404 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = list;
#line 404 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 2861 "spice-display.c"
}


static void boxes_spice_display_real_send_keys (BoxesDisplay* base, guint* keyvals, int keyvals_length1) {
	BoxesSpiceDisplay * self;
	SpiceDisplay* display = NULL;
	GtkWidget* _tmp0_ = NULL;
	SpiceDisplay* _tmp1_ = NULL;
	guint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 409 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = boxes_display_get_display ((BoxesDisplay*) self, 0);
#line 409 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp0_) : NULL;
#line 409 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp1_ == NULL) {
#line 409 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (_tmp0_);
#line 2882 "spice-display.c"
	}
#line 409 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	display = _tmp1_;
#line 411 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = keyvals;
#line 411 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2__length1 = keyvals_length1;
#line 411 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	spice_display_send_keys (display, _tmp2_, _tmp2__length1, SPICE_DISPLAY_KEY_EVENT_CLICK);
#line 407 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (display);
#line 2894 "spice-display.c"
}


static void __vala_SpiceUsbDevice_free0_ (gpointer var) {
#line 415 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(var == NULL) ? NULL : (var = (_vala_SpiceUsbDevice_free (var), NULL));
#line 2901 "spice-display.c"
}


static gpointer _libusb_ref_device0 (gpointer self) {
#line 420 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self ? libusb_ref_device (self) : NULL;
#line 2908 "spice-display.c"
}


static GPtrArray* boxes_spice_display_get_usb_devices (BoxesSpiceDisplay* self, SpiceUsbDeviceManager* manager) {
	GPtrArray* result = NULL;
	GPtrArray* ret = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* devs = NULL;
	SpiceUsbDeviceManager* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
#line 414 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 414 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 415 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = g_ptr_array_new_full ((guint) 0, __vala_SpiceUsbDevice_free0_);
#line 415 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	ret = _tmp0_;
#line 416 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = manager;
#line 416 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = spice_usb_device_manager_get_devices (_tmp1_);
#line 416 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	devs = _tmp2_;
#line 2933 "spice-display.c"
	{
		gint i = 0;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		i = 0;
#line 2938 "spice-display.c"
		{
			gboolean _tmp3_ = FALSE;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp3_ = TRUE;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			while (TRUE) {
#line 2945 "spice-display.c"
				gint _tmp5_ = 0;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				SpiceUsbDevice* dev = NULL;
				GPtrArray* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gconstpointer _tmp11_ = NULL;
				SpiceUsbDevice* _tmp12_ = NULL;
				libusb_device* libusb_dev = NULL;
				SpiceUsbDevice* _tmp13_ = NULL;
				void* _tmp14_ = NULL;
				libusb_device* _tmp15_ = NULL;
				struct libusb_device_descriptor desc = {0};
				libusb_device* _tmp16_ = NULL;
				struct libusb_device_descriptor _tmp17_ = {0};
				gint _tmp18_ = 0;
				struct libusb_device_descriptor _tmp19_ = {0};
				guint8 _tmp20_ = 0U;
				struct libusb_device_descriptor _tmp21_ = {0};
				guint8 _tmp22_ = 0U;
				struct libusb_device_descriptor _tmp23_ = {0};
				guint8 _tmp24_ = 0U;
				gboolean _tmp25_ = FALSE;
				struct libusb_device_descriptor _tmp26_ = {0};
				guint8 _tmp27_ = 0U;
				GPtrArray* _tmp77_ = NULL;
				SpiceUsbDevice* _tmp78_ = NULL;
				SpiceUsbDevice* _tmp79_ = NULL;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (!_tmp3_) {
#line 2977 "spice-display.c"
					gint _tmp4_ = 0;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp4_ = i;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					i = _tmp4_ + 1;
#line 2983 "spice-display.c"
				}
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp3_ = FALSE;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp5_ = i;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp6_ = devs;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp8_ = _tmp7_;
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					break;
#line 2999 "spice-display.c"
				}
#line 419 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp9_ = devs;
#line 419 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp10_ = i;
#line 419 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
#line 419 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp12_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp11_);
#line 419 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				dev = _tmp12_;
#line 420 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp13_ = dev;
#line 420 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp14_ = spice_usb_device_get_libusb_device (_tmp13_);
#line 420 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp15_ = _libusb_ref_device0 ((libusb_device*) _tmp14_);
#line 420 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				libusb_dev = _tmp15_;
#line 424 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp16_ = libusb_dev;
#line 424 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp18_ = libusb_get_device_descriptor (_tmp16_, &_tmp17_);
#line 424 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				desc = _tmp17_;
#line 424 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (_tmp18_ != 0) {
#line 425 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_libusb_unref_device0 (libusb_dev);
#line 425 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 425 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					continue;
#line 3033 "spice-display.c"
				}
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp19_ = desc;
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp20_ = _tmp19_.bDeviceClass;
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp21_ = desc;
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp22_ = _tmp21_.bDeviceSubClass;
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp23_ = desc;
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp24_ = _tmp23_.bDeviceProtocol;
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp25_ = boxes_spice_display_is_usb_kbd_or_mouse (self, _tmp20_, _tmp22_, _tmp24_);
#line 427 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (_tmp25_) {
#line 428 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_libusb_unref_device0 (libusb_dev);
#line 428 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					__vala_SpiceUsbDevice_free0 (dev);
#line 428 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					continue;
#line 3057 "spice-display.c"
				}
#line 431 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp26_ = desc;
#line 431 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp27_ = _tmp26_.bDeviceClass;
#line 431 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (_tmp27_ == LIBUSB_CLASS_PER_INTERFACE) {
#line 3065 "spice-display.c"
					struct libusb_config_descriptor* config = NULL;
					libusb_device* _tmp28_ = NULL;
					struct libusb_config_descriptor* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					gboolean kbd_or_mouse = FALSE;
					gboolean _tmp76_ = FALSE;
#line 433 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp28_ = libusb_dev;
#line 433 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp30_ = libusb_get_active_config_descriptor (_tmp28_, &_tmp29_);
#line 433 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_libusb_free_config_descriptor0 (config);
#line 433 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					config = _tmp29_;
#line 433 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (_tmp30_ != 0) {
#line 434 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_libusb_free_config_descriptor0 (config);
#line 434 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_libusb_unref_device0 (libusb_dev);
#line 434 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						__vala_SpiceUsbDevice_free0 (dev);
#line 434 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						continue;
#line 3090 "spice-display.c"
					}
#line 436 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					kbd_or_mouse = FALSE;
#line 3094 "spice-display.c"
					{
						gint j = 0;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						j = 0;
#line 3099 "spice-display.c"
						{
							gboolean _tmp31_ = FALSE;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							_tmp31_ = TRUE;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
							while (TRUE) {
#line 3106 "spice-display.c"
								gboolean _tmp33_ = FALSE;
								gint _tmp34_ = 0;
								struct libusb_config_descriptor* _tmp35_ = NULL;
								struct libusb_interface* _tmp36_ = NULL;
								gint _tmp36__length1 = 0;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								if (!_tmp31_) {
#line 3114 "spice-display.c"
									gint _tmp32_ = 0;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp32_ = j;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									j = _tmp32_ + 1;
#line 3120 "spice-display.c"
								}
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_tmp31_ = FALSE;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_tmp34_ = j;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_tmp35_ = config;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_tmp36_ = _tmp35_->interface;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								_tmp36__length1 = _tmp35_->bNumInterfaces;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								if (_tmp34_ < _tmp36__length1) {
#line 3134 "spice-display.c"
									gboolean _tmp37_ = FALSE;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp37_ = kbd_or_mouse;
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp33_ = !_tmp37_;
#line 3140 "spice-display.c"
								} else {
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									_tmp33_ = FALSE;
#line 3144 "spice-display.c"
								}
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
								if (!_tmp33_) {
#line 437 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									break;
#line 3150 "spice-display.c"
								}
								{
									gint k = 0;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
									k = 0;
#line 3156 "spice-display.c"
									{
										gboolean _tmp38_ = FALSE;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										_tmp38_ = TRUE;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
										while (TRUE) {
#line 3163 "spice-display.c"
											gboolean _tmp40_ = FALSE;
											gint _tmp41_ = 0;
											struct libusb_config_descriptor* _tmp42_ = NULL;
											struct libusb_interface* _tmp43_ = NULL;
											gint _tmp43__length1 = 0;
											gint _tmp44_ = 0;
											struct libusb_interface _tmp45_ = {0};
											struct libusb_interface_descriptor* _tmp46_ = NULL;
											gint _tmp46__length1 = 0;
											guint8 class = 0U;
											struct libusb_config_descriptor* _tmp48_ = NULL;
											struct libusb_interface* _tmp49_ = NULL;
											gint _tmp49__length1 = 0;
											gint _tmp50_ = 0;
											struct libusb_interface _tmp51_ = {0};
											struct libusb_interface_descriptor* _tmp52_ = NULL;
											gint _tmp52__length1 = 0;
											gint _tmp53_ = 0;
											struct libusb_interface_descriptor _tmp54_ = {0};
											guint8 _tmp55_ = 0U;
											guint8 subclass = 0U;
											struct libusb_config_descriptor* _tmp56_ = NULL;
											struct libusb_interface* _tmp57_ = NULL;
											gint _tmp57__length1 = 0;
											gint _tmp58_ = 0;
											struct libusb_interface _tmp59_ = {0};
											struct libusb_interface_descriptor* _tmp60_ = NULL;
											gint _tmp60__length1 = 0;
											gint _tmp61_ = 0;
											struct libusb_interface_descriptor _tmp62_ = {0};
											guint8 _tmp63_ = 0U;
											guint8 protocol = 0U;
											struct libusb_config_descriptor* _tmp64_ = NULL;
											struct libusb_interface* _tmp65_ = NULL;
											gint _tmp65__length1 = 0;
											gint _tmp66_ = 0;
											struct libusb_interface _tmp67_ = {0};
											struct libusb_interface_descriptor* _tmp68_ = NULL;
											gint _tmp68__length1 = 0;
											gint _tmp69_ = 0;
											struct libusb_interface_descriptor _tmp70_ = {0};
											guint8 _tmp71_ = 0U;
											guint8 _tmp72_ = 0U;
											guint8 _tmp73_ = 0U;
											guint8 _tmp74_ = 0U;
											gboolean _tmp75_ = FALSE;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											if (!_tmp38_) {
#line 3212 "spice-display.c"
												gint _tmp39_ = 0;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
												_tmp39_ = k;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
												k = _tmp39_ + 1;
#line 3218 "spice-display.c"
											}
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp38_ = FALSE;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp41_ = k;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp42_ = config;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp43_ = _tmp42_->interface;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp43__length1 = _tmp42_->bNumInterfaces;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp44_ = j;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp45_ = _tmp43_[_tmp44_];
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp46_ = _tmp45_.altsetting;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp46__length1 = _tmp45_.num_altsetting;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											if (_tmp41_ < _tmp46__length1) {
#line 3240 "spice-display.c"
												gboolean _tmp47_ = FALSE;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
												_tmp47_ = kbd_or_mouse;
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
												_tmp40_ = !_tmp47_;
#line 3246 "spice-display.c"
											} else {
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
												_tmp40_ = FALSE;
#line 3250 "spice-display.c"
											}
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											if (!_tmp40_) {
#line 438 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
												break;
#line 3256 "spice-display.c"
											}
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp48_ = config;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp49_ = _tmp48_->interface;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp49__length1 = _tmp48_->bNumInterfaces;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp50_ = j;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp51_ = _tmp49_[_tmp50_];
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp52_ = _tmp51_.altsetting;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp52__length1 = _tmp51_.num_altsetting;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp53_ = k;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp54_ = _tmp52_[_tmp53_];
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp55_ = _tmp54_.bInterfaceClass;
#line 439 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											class = _tmp55_;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp56_ = config;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp57_ = _tmp56_->interface;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp57__length1 = _tmp56_->bNumInterfaces;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp58_ = j;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp59_ = _tmp57_[_tmp58_];
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp60_ = _tmp59_.altsetting;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp60__length1 = _tmp59_.num_altsetting;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp61_ = k;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp62_ = _tmp60_[_tmp61_];
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp63_ = _tmp62_.bInterfaceSubClass;
#line 440 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											subclass = _tmp63_;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp64_ = config;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp65_ = _tmp64_->interface;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp65__length1 = _tmp64_->bNumInterfaces;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp66_ = j;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp67_ = _tmp65_[_tmp66_];
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp68_ = _tmp67_.altsetting;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp68__length1 = _tmp67_.num_altsetting;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp69_ = k;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp70_ = _tmp68_[_tmp69_];
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp71_ = _tmp70_.bInterfaceProtocol;
#line 441 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											protocol = _tmp71_;
#line 443 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp72_ = class;
#line 443 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp73_ = subclass;
#line 443 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp74_ = protocol;
#line 443 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											_tmp75_ = boxes_spice_display_is_usb_kbd_or_mouse (self, _tmp72_, _tmp73_, _tmp74_);
#line 443 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
											kbd_or_mouse = _tmp75_;
#line 3334 "spice-display.c"
										}
									}
								}
							}
						}
					}
#line 447 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_tmp76_ = kbd_or_mouse;
#line 447 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					if (_tmp76_) {
#line 448 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_libusb_free_config_descriptor0 (config);
#line 448 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						_libusb_unref_device0 (libusb_dev);
#line 448 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						__vala_SpiceUsbDevice_free0 (dev);
#line 448 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						continue;
#line 3353 "spice-display.c"
					}
#line 431 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_libusb_free_config_descriptor0 (config);
#line 3357 "spice-display.c"
				}
#line 451 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp77_ = ret;
#line 451 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp78_ = dev;
#line 451 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp79_ = __vala_SpiceUsbDevice_copy0 (_tmp78_);
#line 451 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				g_ptr_array_add (_tmp77_, _tmp79_);
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_libusb_unref_device0 (libusb_dev);
#line 418 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				__vala_SpiceUsbDevice_free0 (dev);
#line 3371 "spice-display.c"
			}
		}
	}
#line 454 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = ret;
#line 454 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_ptr_array_unref0 (devs);
#line 454 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 3381 "spice-display.c"
}


static gboolean boxes_spice_display_is_usb_kbd_or_mouse (BoxesSpiceDisplay* self, guint8 class, guint8 subclass, guint8 protocol) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	guint8 _tmp0_ = 0U;
#line 457 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 458 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	ret = FALSE;
#line 460 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = class;
#line 460 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_ == LIBUSB_CLASS_HID) {
#line 3397 "spice-display.c"
		guint8 _tmp1_ = 0U;
#line 461 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp1_ = subclass;
#line 461 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		switch (_tmp1_) {
#line 461 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			case 0x00:
#line 3405 "spice-display.c"
			{
#line 463 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				break;
#line 3409 "spice-display.c"
			}
#line 461 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			case 0x01:
#line 3413 "spice-display.c"
			{
				guint8 _tmp2_ = 0U;
#line 465 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp2_ = protocol;
#line 465 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				switch (_tmp2_) {
#line 465 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					case 0x00:
#line 3422 "spice-display.c"
					{
#line 467 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						break;
#line 3426 "spice-display.c"
					}
#line 465 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					case 0x01:
#line 465 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					case 0x02:
#line 3432 "spice-display.c"
					{
#line 470 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						ret = TRUE;
#line 471 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						break;
#line 3438 "spice-display.c"
					}
					default:
					{
#line 473 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
						break;
#line 3444 "spice-display.c"
					}
				}
#line 475 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				break;
#line 3449 "spice-display.c"
			}
			default:
			{
#line 477 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				break;
#line 3455 "spice-display.c"
			}
		}
	}
#line 481 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = ret;
#line 481 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 3463 "spice-display.c"
}


static const gchar* boxes_spice_display_real_get_protocol (BoxesDisplay* base) {
	const gchar* result;
	BoxesSpiceDisplay* self;
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = "SPICE";
#line 7 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 3476 "spice-display.c"
}


static gchar* boxes_spice_display_real_get_uri (BoxesDisplay* base) {
	gchar* result;
	BoxesSpiceDisplay* self;
	gboolean _tmp0_ = FALSE;
	SpiceSession* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SpiceSession* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
#line 9 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceDisplay*) base;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = self->priv->session;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp1_, "port", &_tmp2_, NULL);
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = _tmp4_ == NULL;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp4_);
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp5_) {
#line 3508 "spice-display.c"
		SpiceSession* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = self->priv->session;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp6_, "tls-port", &_tmp7_, NULL);
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = _tmp7_;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = _tmp8_;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = _tmp9_ == NULL;
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp9_);
#line 3525 "spice-display.c"
	} else {
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp0_ = FALSE;
#line 3529 "spice-display.c"
	}
#line 10 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp0_) {
#line 11 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		result = NULL;
#line 11 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return result;
#line 3537 "spice-display.c"
	}
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = self->priv->session;
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp10_, "uri", &_tmp11_, NULL);
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = _tmp11_;
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp12_;
#line 13 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 3549 "spice-display.c"
}


GByteArray* boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self) {
	GByteArray* result;
	SpiceSession* _tmp0_ = NULL;
	GByteArray* _tmp1_ = NULL;
	GByteArray* _tmp2_ = NULL;
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp0_, "ca", &_tmp1_, NULL);
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _tmp1_;
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp2_;
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 3570 "spice-display.c"
}


void boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self, GByteArray* value) {
	SpiceSession* _tmp0_ = NULL;
	GByteArray* _tmp1_ = NULL;
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->session;
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = value;
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_set (_tmp0_, "ca", _tmp1_, NULL);
#line 16 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_notify ((GObject *) self, "ca-cert");
#line 3587 "spice-display.c"
}


SpiceMainChannel* boxes_spice_display_get_main_channel (BoxesSpiceDisplay* self) {
	SpiceMainChannel* result;
	SpiceMainChannel* _tmp0_ = NULL;
#line 70 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->_main_channel;
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	result = _tmp0_;
#line 71 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return result;
#line 3602 "spice-display.c"
}


static void _boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender, SpiceChannelEvent event, gpointer self) {
#line 79 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_event ((BoxesSpiceDisplay*) self, event);
#line 3609 "spice-display.c"
}


static void _boxes_spice_display_main_channel___lambda49_ (BoxesSpiceDisplay* self) {
	SpiceMainChannel* _tmp0_ = NULL;
	SpiceMainChannel* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = boxes_spice_display_get_main_channel (self);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _tmp0_;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp1_, "mouse-mode", &_tmp2_, NULL);
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _tmp2_;
#line 81 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp3_ != 2);
#line 3628 "spice-display.c"
}


static void __boxes_spice_display_main_channel___lambda49__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_boxes_spice_display_main_channel___lambda49_ ((BoxesSpiceDisplay*) self);
#line 3635 "spice-display.c"
}


void boxes_spice_display_set_main_channel (BoxesSpiceDisplay* self, SpiceMainChannel* value) {
	SpiceMainChannel* _tmp0_ = NULL;
	SpiceMainChannel* _tmp1_ = NULL;
	SpiceMainChannel* _tmp2_ = NULL;
	SpiceMainChannel* _tmp3_ = NULL;
	SpiceMainChannel* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	SpiceMainChannel* _tmp6_ = NULL;
	SpiceMainChannel* _tmp7_ = NULL;
	gulong _tmp8_ = 0UL;
	SpiceMainChannel* _tmp9_ = NULL;
	SpiceMainChannel* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = value;
#line 75 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 75 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->_main_channel);
#line 75 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->_main_channel = _tmp1_;
#line 76 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = self->priv->_main_channel;
#line 76 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 77 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		return;
#line 3669 "spice-display.c"
	}
#line 79 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = boxes_spice_display_get_main_channel (self);
#line 79 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 79 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = g_signal_connect_object ((SpiceChannel*) _tmp4_, "channel-event", (GCallback) _boxes_spice_display_main_event_spice_channel_channel_event, self, 0);
#line 79 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->main_event_id = _tmp5_;
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = boxes_spice_display_get_main_channel (self);
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp6_;
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = g_signal_connect_object ((GObject*) _tmp7_, "notify::mouse-mode", (GCallback) __boxes_spice_display_main_channel___lambda49__g_object_notify, self, 0);
#line 80 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->main_mouse_mode_id = _tmp8_;
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = boxes_spice_display_get_main_channel (self);
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = _tmp9_;
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp10_, "mouse-mode", &_tmp11_, NULL);
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = _tmp11_;
#line 84 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp12_ != 2);
#line 74 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_notify ((GObject *) self, "main-channel");
#line 3699 "spice-display.c"
}


static void _boxes_spice_display____lambda55_ (BoxesSpiceDisplay* self, SpiceUsbDevice* dev, GError* err) {
	gchar* device_description = NULL;
	SpiceUsbDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* box_name = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GError* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (dev != NULL);
#line 59 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = dev;
#line 59 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = spice_usb_device_get_description (_tmp0_, "%1$s %2$s");
#line 59 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	device_description = _tmp1_;
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = boxes_spice_display_get_box_name (self);
#line 60 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	box_name = _tmp2_;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = _ ("Redirection of USB device '%s' for '%s' failed");
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = device_description;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = box_name;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = g_strdup_printf (_tmp3_, _tmp4_, _tmp5_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = _tmp6_;
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp7_);
#line 61 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp7_);
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = device_description;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = box_name;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = err;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = _tmp10_->message;
#line 62 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_debug ("spice-display.vala:62: Error connecting %s to %s: %s", _tmp8_, _tmp9_, _tmp11_);
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (box_name);
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (device_description);
#line 3758 "spice-display.c"
}


static void __boxes_spice_display____lambda55__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender, SpiceUsbDevice* device, GError* _error_, gpointer self) {
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_boxes_spice_display____lambda55_ ((BoxesSpiceDisplay*) self, device, _error_);
#line 3765 "spice-display.c"
}


static GObject * boxes_spice_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BoxesSpiceDisplay * self;
	gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	BoxesBoxConfigSavedProperty _tmp2_ = {0};
	BoxesBoxConfigSavedProperty* _tmp3_ = NULL;
	SpiceSession* _tmp4_ = NULL;
	SpiceSession* _tmp5_ = NULL;
	SpiceAudio* _tmp6_ = NULL;
	SpiceSession* _tmp7_ = NULL;
	SpiceGtkSession* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 46 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	parent_class = G_OBJECT_CLASS (boxes_spice_display_parent_class);
#line 46 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 46 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = g_strdup ("auto-clipboard");
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_init (&_tmp1_, G_TYPE_BOOLEAN);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_value_set_boolean (&_tmp1_, TRUE);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	memset (&_tmp2_, 0, sizeof (BoxesBoxConfigSavedProperty));
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_tmp2_.name);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_.name = _tmp0_;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_IS_VALUE (&_tmp2_.default_value) ? (g_value_unset (&_tmp2_.default_value), NULL) : NULL;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_.default_value = _tmp1_;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = g_new0 (BoxesBoxConfigSavedProperty, 1);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_[0] = _tmp2_;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->gtk_session_saved_properties, self->priv->gtk_session_saved_properties_length1), NULL);
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties = _tmp3_;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties_length1 = 1;
#line 47 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->_gtk_session_saved_properties_size_ = self->priv->gtk_session_saved_properties_length1;
#line 51 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_display_set_need_password ((BoxesDisplay*) self, FALSE);
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = spice_session_new ();
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->session);
#line 52 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->session = _tmp4_;
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = self->priv->session;
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = spice_audio_get (_tmp5_, NULL);
#line 53 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->audio = _tmp6_;
#line 54 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = self->priv->session;
#line 54 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = spice_gtk_session_get (_tmp7_);
#line 54 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session = _tmp8_;
#line 3837 "spice-display.c"
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp9_ = NULL;
		SpiceUsbDeviceManager* _tmp10_ = NULL;
		SpiceUsbDeviceManager* _tmp11_ = NULL;
		SpiceUsbDeviceManager* _tmp12_ = NULL;
#line 56 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = self->priv->session;
#line 56 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = spice_usb_device_manager_get (_tmp9_, &_inner_error_);
#line 56 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 56 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		manager = _tmp11_;
#line 56 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3854 "spice-display.c"
			goto __catch80_g_error;
		}
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = manager;
#line 58 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp12_, "device-error", (GCallback) __boxes_spice_display____lambda55__spice_usb_device_manager_device_error, self, 0);
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (manager);
#line 3863 "spice-display.c"
	}
	goto __finally80;
	__catch80_g_error:
	{
		GError* _error_ = NULL;
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_error_ = _inner_error_;
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = NULL;
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_error_free0 (_error_);
#line 3875 "spice-display.c"
	}
	__finally80:
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 55 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_clear_error (&_inner_error_);
#line 3884 "spice-display.c"
	}
#line 46 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return obj;
#line 3888 "spice-display.c"
}


static void boxes_spice_display_class_init (BoxesSpiceDisplayClass * klass) {
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_parent_class = g_type_class_peek_parent (klass);
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesSpiceDisplayPrivate));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_display = boxes_spice_display_real_get_display;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->should_keep_alive = boxes_spice_display_real_should_keep_alive;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->set_enable_audio = boxes_spice_display_real_set_enable_audio;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_pixbuf = boxes_spice_display_real_get_pixbuf;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->collect_logs = boxes_spice_display_real_collect_logs;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->connect_it = boxes_spice_display_real_connect_it;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->disconnect_it = boxes_spice_display_real_disconnect_it;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->get_properties = boxes_spice_display_real_get_properties;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	((BoxesDisplayClass *) klass)->send_keys = boxes_spice_display_real_send_keys;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_protocol = boxes_spice_display_real_get_protocol;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	BOXES_DISPLAY_CLASS (klass)->get_uri = boxes_spice_display_real_get_uri;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_spice_display_get_property;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_spice_display_set_property;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->constructor = boxes_spice_display_constructor;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_spice_display_finalize;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_PROTOCOL, g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_CA_CERT, g_param_spec_boxed ("ca-cert", "ca-cert", "ca-cert", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_MAIN_CHANNEL, g_param_spec_object ("main-channel", "main-channel", "main-channel", spice_main_channel_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3935 "spice-display.c"
}


static void boxes_spice_display_instance_init (BoxesSpiceDisplay * self) {
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv = BOXES_SPICE_DISPLAY_GET_PRIVATE (self);
#line 3942 "spice-display.c"
}


static void boxes_spice_display_finalize (GObject* obj) {
	BoxesSpiceDisplay * self;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 103 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_display_main_cleanup (self);
#line 20 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->session);
#line 25 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->display_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->display_saved_properties, self->priv->display_saved_properties_length1), NULL);
#line 26 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->gtk_session_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->gtk_session_saved_properties, self->priv->gtk_session_saved_properties_length1), NULL);
#line 29 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_hash_table_unref0 (self->priv->channel_handlers);
#line 30 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 30 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 30 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 30 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 68 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->_main_channel);
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (boxes_spice_display_parent_class)->finalize (obj);
#line 3972 "spice-display.c"
}


GType boxes_spice_display_get_type (void) {
	static volatile gsize boxes_spice_display_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_spice_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesSpiceDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_spice_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSpiceDisplay), 0, (GInstanceInitFunc) boxes_spice_display_instance_init, NULL };
		GType boxes_spice_display_type_id;
		boxes_spice_display_type_id = g_type_register_static (BOXES_TYPE_DISPLAY, "BoxesSpiceDisplay", &g_define_type_info, 0);
		g_once_init_leave (&boxes_spice_display_type_id__volatile, boxes_spice_display_type_id);
	}
	return boxes_spice_display_type_id__volatile;
}


static void _vala_boxes_spice_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (property_id) {
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_PROTOCOL:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_set_string (value, boxes_display_get_protocol ((BoxesDisplay*) self));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_URI:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_take_string (value, boxes_display_get_uri ((BoxesDisplay*) self));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_CA_CERT:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_take_boxed (value, boxes_spice_display_get_ca_cert (self));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_MAIN_CHANNEL:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_value_set_object (value, boxes_spice_display_get_main_channel (self));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 4017 "spice-display.c"
		default:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 4023 "spice-display.c"
	}
}


static void _vala_boxes_spice_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	switch (property_id) {
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_CA_CERT:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_ca_cert (self, g_value_get_boxed (value));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		case BOXES_SPICE_DISPLAY_MAIN_CHANNEL:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_main_channel (self, g_value_get_object (value));
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 4045 "spice-display.c"
		default:
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 6 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		break;
#line 4051 "spice-display.c"
	}
}


static void _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd (SpiceChannel* _sender, gint with_tls, gpointer self) {
#line 497 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_channel_handler_on_open_fd ((BoxesSpiceChannelHandler*) self, _sender, with_tls);
#line 4059 "spice-display.c"
}


static void _boxes_spice_channel_handler_on_display_ready_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 507 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_channel_handler_on_display_ready ((BoxesSpiceChannelHandler*) self, _sender, pspec);
#line 4066 "spice-display.c"
}


BoxesSpiceChannelHandler* boxes_spice_channel_handler_construct (GType object_type, BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify) {
	BoxesSpiceChannelHandler * self = NULL;
	BoxesSpiceDisplay* _tmp0_ = NULL;
	SpiceChannel* _tmp1_ = NULL;
	SpiceChannel* _tmp2_ = NULL;
	BoxesDisplayOpenFDFunc _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	GDestroyNotify _tmp3__target_destroy_notify = NULL;
	gint id = 0;
	SpiceChannel* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	BoxesDisplayOpenFDFunc _tmp7_ = NULL;
	void* _tmp7__target = NULL;
	SpiceChannel* _tmp9_ = NULL;
	SpiceChannel* _tmp12_ = NULL;
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (display != NULL, NULL);
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_val_if_fail (channel != NULL, NULL);
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = (BoxesSpiceChannelHandler*) g_object_new (object_type, NULL);
#line 491 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = display;
#line 491 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->display = _tmp0_;
#line 492 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = channel;
#line 492 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 492 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->channel);
#line 492 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->channel = _tmp2_;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3_ = open_fd;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3__target = open_fd_target;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp3__target_destroy_notify = open_fd_target_destroy_notify;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = _tmp3_;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = _tmp3__target;
#line 493 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = _tmp3__target_destroy_notify;
#line 494 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = channel;
#line 494 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp4_, "channel-id", &_tmp5_, NULL);
#line 494 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = _tmp5_;
#line 494 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	id = _tmp6_;
#line 496 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = open_fd;
#line 496 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7__target = open_fd_target;
#line 496 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp7_ != NULL) {
#line 4140 "spice-display.c"
		SpiceChannel* _tmp8_ = NULL;
#line 497 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = channel;
#line 497 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object (_tmp8_, "open-fd", (GCallback) _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd, self, 0);
#line 4146 "spice-display.c"
	}
#line 499 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = channel;
#line 499 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, spice_main_channel_get_type ())) {
#line 4152 "spice-display.c"
		BoxesSpiceDisplay* _tmp10_ = NULL;
		SpiceChannel* _tmp11_ = NULL;
#line 500 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = display;
#line 500 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp11_ = channel;
#line 500 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		boxes_spice_display_set_main_channel (_tmp10_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, spice_main_channel_get_type ()) ? ((SpiceMainChannel*) _tmp11_) : NULL);
#line 4161 "spice-display.c"
	}
#line 502 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = channel;
#line 502 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, spice_display_channel_get_type ())) {
#line 4167 "spice-display.c"
		gint _tmp13_ = 0;
		SpiceDisplay* spice_display = NULL;
		BoxesSpiceDisplay* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		GtkWidget* _tmp16_ = NULL;
		SpiceDisplay* _tmp17_ = NULL;
		SpiceDisplay* _tmp18_ = NULL;
#line 503 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = id;
#line 503 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp13_ != 0) {
#line 504 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 504 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			open_fd = NULL;
#line 504 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			open_fd_target = NULL;
#line 504 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			open_fd_target_destroy_notify = NULL;
#line 504 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return self;
#line 4189 "spice-display.c"
		}
#line 506 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = display;
#line 506 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp15_ = id;
#line 506 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp16_ = boxes_display_get_display ((BoxesDisplay*) _tmp14_, _tmp15_);
#line 506 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp16_) : NULL;
#line 506 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp17_ == NULL) {
#line 506 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_object_unref0 (_tmp16_);
#line 4203 "spice-display.c"
		}
#line 506 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		spice_display = _tmp17_;
#line 507 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = spice_display;
#line 507 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_connect_object ((GObject*) _tmp18_, "notify::ready", (GCallback) _boxes_spice_channel_handler_on_display_ready_g_object_notify, self, 0);
#line 502 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (spice_display);
#line 4213 "spice-display.c"
	}
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd = NULL;
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd_target = NULL;
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	open_fd_target_destroy_notify = NULL;
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self;
#line 4225 "spice-display.c"
}


BoxesSpiceChannelHandler* boxes_spice_channel_handler_new (BoxesSpiceDisplay* display, SpiceChannel* channel, BoxesDisplayOpenFDFunc open_fd, void* open_fd_target, GDestroyNotify open_fd_target_destroy_notify) {
#line 490 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return boxes_spice_channel_handler_construct (BOXES_TYPE_SPICE_CHANNEL_HANDLER, display, channel, open_fd, open_fd_target, open_fd_target_destroy_notify);
#line 4232 "spice-display.c"
}


static void boxes_spice_channel_handler_on_display_ready (BoxesSpiceChannelHandler* self, GObject* object, GParamSpec* param_spec) {
	SpiceDisplay* spice_display = NULL;
	GObject* _tmp0_ = NULL;
	SpiceDisplay* _tmp1_ = NULL;
	SpiceDisplay* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 511 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 511 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (object != NULL);
#line 511 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (param_spec != NULL);
#line 512 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = object;
#line 512 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp0_) : NULL);
#line 512 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	spice_display = _tmp1_;
#line 513 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = spice_display;
#line 513 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_object_get (_tmp2_, "ready", &_tmp3_, NULL);
#line 513 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp4_ = _tmp3_;
#line 513 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp4_) {
#line 4263 "spice-display.c"
		BoxesSpiceDisplay* _tmp5_ = NULL;
		SpiceDisplay* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 514 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp5_ = self->priv->display;
#line 514 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp6_ = spice_display;
#line 514 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp6_, "channel-id", &_tmp7_, NULL);
#line 514 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp8_ = _tmp7_;
#line 514 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) _tmp5_, "show", _tmp8_);
#line 4278 "spice-display.c"
	} else {
		BoxesSpiceDisplay* _tmp9_ = NULL;
		SpiceDisplay* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 516 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp9_ = self->priv->display;
#line 516 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = spice_display;
#line 516 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_object_get (_tmp10_, "channel-id", &_tmp11_, NULL);
#line 516 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp12_ = _tmp11_;
#line 516 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		g_signal_emit_by_name ((BoxesDisplay*) _tmp9_, "hide", _tmp12_);
#line 4294 "spice-display.c"
	}
#line 511 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (spice_display);
#line 4298 "spice-display.c"
}


static void boxes_spice_channel_handler_on_open_fd (BoxesSpiceChannelHandler* self, SpiceChannel* channel, gint with_tls) {
	gint fd = 0;
	BoxesDisplayOpenFDFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gint _tmp1_ = 0;
	SpiceChannel* _tmp2_ = NULL;
#line 519 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (self != NULL);
#line 519 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (channel != NULL);
#line 522 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = self->priv->open_fd;
#line 522 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0__target = self->priv->open_fd_target;
#line 522 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = _tmp0_ (_tmp0__target);
#line 522 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	fd = _tmp1_;
#line 523 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = channel;
#line 523 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	spice_channel_open_fd (_tmp2_, fd);
#line 4324 "spice-display.c"
}


static void boxes_spice_channel_handler_class_init (BoxesSpiceChannelHandlerClass * klass) {
#line 485 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	boxes_spice_channel_handler_parent_class = g_type_class_peek_parent (klass);
#line 485 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_type_class_add_private (klass, sizeof (BoxesSpiceChannelHandlerPrivate));
#line 485 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_spice_channel_handler_finalize;
#line 4335 "spice-display.c"
}


static void boxes_spice_channel_handler_instance_init (BoxesSpiceChannelHandler * self) {
#line 485 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv = BOXES_SPICE_CHANNEL_HANDLER_GET_PRIVATE (self);
#line 4342 "spice-display.c"
}


static void boxes_spice_channel_handler_finalize (GObject* obj) {
	BoxesSpiceChannelHandler * self;
#line 485 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandler);
#line 487 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_object_unref0 (self->priv->channel);
#line 488 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
#line 488 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd = NULL;
#line 488 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target = NULL;
#line 488 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	self->priv->open_fd_target_destroy_notify = NULL;
#line 485 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	G_OBJECT_CLASS (boxes_spice_channel_handler_parent_class)->finalize (obj);
#line 4362 "spice-display.c"
}


GType boxes_spice_channel_handler_get_type (void) {
	static volatile gsize boxes_spice_channel_handler_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_spice_channel_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesSpiceChannelHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_spice_channel_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSpiceChannelHandler), 0, (GInstanceInitFunc) boxes_spice_channel_handler_instance_init, NULL };
		GType boxes_spice_channel_handler_type_id;
		boxes_spice_channel_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesSpiceChannelHandler", &g_define_type_info, 0);
		g_once_init_leave (&boxes_spice_channel_handler_type_id__volatile, boxes_spice_channel_handler_type_id);
	}
	return boxes_spice_channel_handler_type_id__volatile;
}


static gint* _int_dup (gint* self) {
	gint* dup;
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	dup = g_new0 (gint, 1);
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	memcpy (dup, self, sizeof (gint));
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return dup;
#line 4386 "spice-display.c"
}


static gpointer __int_dup0 (gpointer self) {
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	return self ? _int_dup (self) : NULL;
#line 4393 "spice-display.c"
}


void spice_validate_uri (const gchar* uri_as_text, gint** port, gint** tls_port, GError** error) {
	gint* _vala_port = NULL;
	gint* _vala_tls_port = NULL;
	xmlURI* uri = NULL;
	const gchar* _tmp0_ = NULL;
	xmlURI* _tmp1_ = NULL;
	xmlURI* _tmp2_ = NULL;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	xmlURI* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	xmlURI* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* query_str = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp40_ = FALSE;
	gint* _tmp41_ = NULL;
	GError * _inner_error_ = NULL;
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	g_return_if_fail (uri_as_text != NULL);
#line 531 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp0_ = uri_as_text;
#line 531 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp1_ = xmlParseURI (_tmp0_);
#line 531 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	uri = _tmp1_;
#line 533 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp2_ = uri;
#line 533 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp2_ == NULL) {
#line 4430 "spice-display.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp3_ = _ ("Invalid URI");
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp4_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp3_);
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = _tmp4_;
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_propagate_error (error, _inner_error_);
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 4447 "spice-display.c"
		} else {
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_clear_error (&_inner_error_);
#line 534 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 4457 "spice-display.c"
		}
	}
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp5_ = 0;
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp6_ = __int_dup0 (&_tmp5_);
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_vala_tls_port);
#line 536 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_vala_tls_port = _tmp6_;
#line 537 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp7_ = uri;
#line 537 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp8_ = _tmp7_->port;
#line 537 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp9_ = __int_dup0 (&_tmp8_);
#line 537 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (_vala_port);
#line 537 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_vala_port = _tmp9_;
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp11_ = uri;
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp12_ = _tmp11_->query_raw;
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp10_ = _tmp12_;
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp10_ == NULL) {
#line 4486 "spice-display.c"
		xmlURI* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp13_ = uri;
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp14_ = _tmp13_->query;
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp10_ = _tmp14_;
#line 4495 "spice-display.c"
	}
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp15_ = g_strdup (_tmp10_);
#line 538 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	query_str = _tmp15_;
#line 540 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp16_ = query_str;
#line 540 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp16_ != NULL) {
#line 4505 "spice-display.c"
		BoxesQuery* query = NULL;
		const gchar* _tmp17_ = NULL;
		BoxesQuery* _tmp18_ = NULL;
		BoxesQuery* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		BoxesQuery* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
#line 541 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp17_ = query_str;
#line 541 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp18_ = boxes_query_new (_tmp17_);
#line 541 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		query = _tmp18_;
#line 542 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp19_ = query;
#line 542 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp20_ = boxes_query_get (_tmp19_, "port");
#line 542 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp21_ = _tmp20_;
#line 542 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp22_ = _tmp21_ != NULL;
#line 542 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp21_);
#line 542 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp22_) {
#line 4535 "spice-display.c"
			gint* _tmp23_ = NULL;
			BoxesQuery* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint* _tmp30_ = NULL;
#line 543 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp23_ = _vala_port;
#line 543 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			if ((*_tmp23_) > 0) {
#line 4546 "spice-display.c"
				const gchar* _tmp24_ = NULL;
				GError* _tmp25_ = NULL;
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp24_ = _ ("The port must be specified once");
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_tmp25_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp24_);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				_inner_error_ = _tmp25_;
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
				if (_inner_error_->domain == BOXES_ERROR) {
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					g_propagate_error (error, _inner_error_);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_object_unref0 (query);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					return;
#line 4567 "spice-display.c"
				} else {
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_object_unref0 (query);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_g_free0 (query_str);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					_xmlFreeURI0 (uri);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					g_clear_error (&_inner_error_);
#line 544 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
					return;
#line 4581 "spice-display.c"
				}
			}
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp26_ = query;
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp27_ = boxes_query_get (_tmp26_, "port");
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp28_ = _tmp27_;
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp29_ = atoi (_tmp28_);
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp30_ = __int_dup0 (&_tmp29_);
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_vala_port);
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_vala_port = _tmp30_;
#line 545 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_tmp28_);
#line 4600 "spice-display.c"
		}
#line 548 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp31_ = query;
#line 548 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp32_ = boxes_query_get (_tmp31_, "tls-port");
#line 548 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp33_ = _tmp32_;
#line 548 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp34_ = _tmp33_ != NULL;
#line 548 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_tmp33_);
#line 548 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_tmp34_) {
#line 4614 "spice-display.c"
			BoxesQuery* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gint* _tmp39_ = NULL;
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp35_ = query;
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp36_ = boxes_query_get (_tmp35_, "tls-port");
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp37_ = _tmp36_;
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp38_ = atoi (_tmp37_);
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_tmp39_ = __int_dup0 (&_tmp38_);
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_vala_tls_port);
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_vala_tls_port = _tmp39_;
#line 549 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (_tmp37_);
#line 4636 "spice-display.c"
		}
#line 540 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_object_unref0 (query);
#line 4640 "spice-display.c"
	}
#line 552 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_tmp41_ = _vala_port;
#line 552 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if ((*_tmp41_) <= 0) {
#line 4646 "spice-display.c"
		gint* _tmp42_ = NULL;
#line 552 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp42_ = _vala_tls_port;
#line 552 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp40_ = (*_tmp42_) <= 0;
#line 4652 "spice-display.c"
	} else {
#line 552 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp40_ = FALSE;
#line 4656 "spice-display.c"
	}
#line 552 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (_tmp40_) {
#line 4660 "spice-display.c"
		const gchar* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp43_ = _ ("Missing port in Spice URI");
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_tmp44_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, _tmp43_);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_inner_error_ = _tmp44_;
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		if (_inner_error_->domain == BOXES_ERROR) {
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_propagate_error (error, _inner_error_);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (query_str);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 4679 "spice-display.c"
		} else {
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_g_free0 (query_str);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			_xmlFreeURI0 (uri);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			g_clear_error (&_inner_error_);
#line 553 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
			return;
#line 4691 "spice-display.c"
		}
	}
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_g_free0 (query_str);
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	_xmlFreeURI0 (uri);
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (port) {
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		*port = _vala_port;
#line 4702 "spice-display.c"
	} else {
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_vala_port);
#line 4706 "spice-display.c"
	}
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
	if (tls_port) {
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		*tls_port = _vala_tls_port;
#line 4712 "spice-display.c"
	} else {
#line 528 "/home/zeenix/checkout/gnome/gnome-boxes/src/spice-display.vala"
		_g_free0 (_vala_tls_port);
#line 4716 "spice-display.c"
	}
}



