/* rygel-http-item-uri.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY
};
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPItemURI * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	RygelHTTPServer* _tmp6_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = item_id;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->item_id);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->item_id = _tmp1_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = thumbnail_index;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->thumbnail_index = _tmp2_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = subtitle_index;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->subtitle_index = _tmp3_;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = transcode_target;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->transcode_target);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->transcode_target = _tmp5_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = http_server;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->http_server = _tmp6_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self;
#line 164 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item_id, http_server, thumbnail_index, subtitle_index, transcode_target);
#line 171 "rygel-http-item-uri.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1386 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1386 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1386 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 184 "rygel-http-item-uri.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 214 "rygel-http-item-uri.c"
				goto __catch2_g_regex_error;
			}
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1388 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 223 "rygel-http-item-uri.c"
		}
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 239 "rygel-http-item-uri.c"
				goto __catch2_g_regex_error;
			}
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 250 "rygel-http-item-uri.c"
		}
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1389 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 258 "rygel-http-item-uri.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1391 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 272 "rygel-http-item-uri.c"
	}
	__finally2:
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return NULL;
#line 283 "rygel-http-item-uri.c"
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* request_uri;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp12_;
	const gchar* _tmp53_;
	GError * _inner_error_ = NULL;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->thumbnail_index = -1;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->subtitle_index = -1;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->transcode_target);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->transcode_target = NULL;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = http_server;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->http_server = _tmp0_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = uri;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = http_server;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = _tmp3_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	request_uri = _tmp5_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = request_uri;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts = _tmp8_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts_length1 = _vala_array_length (_tmp7_);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_parts_size_ = parts_length1;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = parts;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10__length1 = parts_length1;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp10__length1 < 2) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp9_ = TRUE;
#line 357 "rygel-http-item-uri.c"
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11_ = parts;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11__length1 = parts_length1;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp9_ = (_tmp11__length1 % 2) == 0;
#line 367 "rygel-http-item-uri.c"
	}
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp12_ = _tmp9_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp12_) {
#line 373 "rygel-http-item-uri.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = _ ("Invalid URI '%s'");
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = request_uri;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp13_, _tmp14_);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_inner_error_ = _tmp15_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 397 "rygel-http-item-uri.c"
		} else {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 409 "rygel-http-item-uri.c"
		}
	}
	{
		gint i;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		i = 1;
#line 416 "rygel-http-item-uri.c"
		{
			gboolean _tmp16_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp16_ = TRUE;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			while (TRUE) {
#line 423 "rygel-http-item-uri.c"
				gboolean _tmp17_;
				gint _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				GQuark _tmp26_ = 0U;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp25_label0 = 0;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp25_label1 = 0;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp25_label2 = 0;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp25_label3 = 0;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp17_ = _tmp16_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!_tmp17_) {
#line 446 "rygel-http-item-uri.c"
					gint _tmp18_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp18_ = i;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					i = _tmp18_ + 2;
#line 452 "rygel-http-item-uri.c"
				}
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp16_ = FALSE;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp19_ = i;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp20_ = parts;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp20__length1 = parts_length1;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!(_tmp19_ < (_tmp20__length1 - 1))) {
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					break;
#line 466 "rygel-http-item-uri.c"
				}
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp21_ = parts;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp21__length1 = parts_length1;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp22_ = i;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp24_ = _tmp23_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("i")))) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 484 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp27_;
							gint _tmp27__length1;
							gint _tmp28_;
							const gchar* _tmp29_;
							gchar* _tmp30_ = NULL;
							gchar* _tmp31_;
							size_t _tmp32_;
							guchar* _tmp33_ = NULL;
							guchar* _tmp34_;
							gint _tmp34__length1;
							guchar* data;
							gint data_length1;
							gint _data_size_;
							GString* _tmp35_;
							GString* builder;
							GString* _tmp36_;
							guchar* _tmp37_;
							gint _tmp37__length1;
							GString* _tmp38_;
							const gchar* _tmp39_;
							gchar* _tmp40_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp27_ = parts;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp27__length1 = parts_length1;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp28_ = i;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp29_ = _tmp27_[_tmp28_ + 1];
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp30_ = soup_uri_decode (_tmp29_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp31_ = _tmp30_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp33_ = g_base64_decode (_tmp31_, &_tmp32_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp34_ = _tmp33_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp34__length1 = _tmp32_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (_tmp31_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data = _tmp34_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data_length1 = _tmp34__length1;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_data_size_ = data_length1;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp35_ = g_string_new ("");
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							builder = _tmp35_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp36_ = builder;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp37_ = data;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp37__length1 = data_length1;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							g_string_append (_tmp36_, (const gchar*) _tmp37_);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp38_ = builder;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp39_ = _tmp38_->str;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp40_ = g_strdup (_tmp39_);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (self->item_id);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->item_id = _tmp40_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_string_free0 (builder);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data = (g_free (data), NULL);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 562 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("tr")))) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 568 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp41_;
							gint _tmp41__length1;
							gint _tmp42_;
							const gchar* _tmp43_;
							gchar* _tmp44_ = NULL;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp41_ = parts;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp41__length1 = parts_length1;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp42_ = i;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp43_ = _tmp41_[_tmp42_ + 1];
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp44_ = soup_uri_decode (_tmp43_);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (self->transcode_target);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->transcode_target = _tmp44_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 592 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label2) ? _tmp25_label2 : (_tmp25_label2 = g_quark_from_static_string ("th")))) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 598 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp45_;
							gint _tmp45__length1;
							gint _tmp46_;
							const gchar* _tmp47_;
							gint _tmp48_ = 0;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp45_ = parts;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp45__length1 = parts_length1;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp46_ = i;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp47_ = _tmp45_[_tmp46_ + 1];
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp48_ = atoi (_tmp47_);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->thumbnail_index = _tmp48_;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 620 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label3) ? _tmp25_label3 : (_tmp25_label3 = g_quark_from_static_string ("sub")))) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 626 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp49_;
							gint _tmp49__length1;
							gint _tmp50_;
							const gchar* _tmp51_;
							gint _tmp52_ = 0;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp49_ = parts;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp49__length1 = parts_length1;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp50_ = i;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp51_ = _tmp49_[_tmp50_ + 1];
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp52_ = atoi (_tmp51_);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->subtitle_index = _tmp52_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 648 "rygel-http-item-uri.c"
						}
					}
				} else {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 654 "rygel-http-item-uri.c"
						default:
						{
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 659 "rygel-http-item-uri.c"
						}
					}
				}
			}
		}
	}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp53_ = self->item_id;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp53_ == NULL) {
#line 670 "rygel-http-item-uri.c"
		const gchar* _tmp54_ = NULL;
		GError* _tmp55_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp54_ = _ ("Not Found");
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp55_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp54_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_inner_error_ = _tmp55_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 691 "rygel-http-item-uri.c"
		} else {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 703 "rygel-http-item-uri.c"
		}
	}
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (request_uri);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self;
#line 712 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
#line 719 "rygel-http-item-uri.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1411 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1412 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1412 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1412 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1412 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1412 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1412 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1413 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1413 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1414 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1414 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1414 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1414 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1414 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1415 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1415 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1415 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1415 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 774 "rygel-http-item-uri.c"
	}
#line 1415 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1415 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 780 "rygel-http-item-uri.c"
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* escaped;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* path;
	const gchar* _tmp10_;
	const gchar* _tmp34_;
	gchar* _tmp35_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->item_id;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data = _tmp2_;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data_length1 = _tmp1_;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_data_size_ = data_length1;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = data;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3__length1 = data_length1;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = g_base64_encode ((guchar*) _tmp3_, _tmp3__length1);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = g_uri_escape_string (_tmp5_, "", TRUE);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (_tmp5_);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	escaped = _tmp7_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = escaped;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp9_ = g_strconcat ("/i/", _tmp8_, NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	path = _tmp9_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = self->transcode_target;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp10_ != NULL) {
#line 843 "rygel-http-item-uri.c"
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11_ = self->transcode_target;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp12_ = g_uri_escape_string (_tmp11_, "", TRUE);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (escaped);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		escaped = _tmp12_;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = path;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = escaped;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = g_strconcat ("/tr/", _tmp14_, NULL);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp16_ = _tmp15_;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (path);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		path = _tmp17_;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (_tmp16_);
#line 875 "rygel-http-item-uri.c"
	} else {
		gint _tmp18_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_ = self->thumbnail_index;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_tmp18_ >= 0) {
#line 882 "rygel-http-item-uri.c"
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp19_ = path;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp20_ = self->thumbnail_index;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp21_ = g_strdup_printf ("%i", _tmp20_);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp22_ = _tmp21_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp23_ = g_strconcat ("/th/", _tmp22_, NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp24_ = _tmp23_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (path);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			path = _tmp25_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp24_);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp22_);
#line 912 "rygel-http-item-uri.c"
		} else {
			gint _tmp26_;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp26_ = self->subtitle_index;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (_tmp26_ >= 0) {
#line 919 "rygel-http-item-uri.c"
				const gchar* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp27_ = path;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp28_ = self->subtitle_index;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp30_ = _tmp29_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp31_ = g_strconcat ("/sub/", _tmp30_, NULL);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp32_ = _tmp31_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (path);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				path = _tmp33_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (_tmp32_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (_tmp30_);
#line 949 "rygel-http-item-uri.c"
			}
		}
	}
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp34_ = path;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp35_ = rygel_http_item_uri_create_uri_for_path (self, _tmp34_);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp35_;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (path);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (escaped);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data = (g_free (data), NULL);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 967 "rygel-http-item-uri.c"
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	GUPnPContext* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	RygelHTTPServer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->http_server;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = _tmp0_->context;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = _tmp2_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = self->http_server;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_->context;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = gupnp_context_get_port (_tmp5_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = self->http_server;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = _tmp9_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp11_ = path;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp12_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 1020 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
#line 26 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
#line 1029 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
#line 26 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = RYGEL_HTTP_ITEM_URI (obj);
#line 27 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->item_id);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->transcode_target);
#line 26 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
#line 1047 "rygel-http-item-uri.c"
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



