/* klotski-window.c generated by valac 0.31.1.6-4f062, the Vala compiler
 * generated from klotski-window.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgames-support.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>


#define TYPE_LEVEL_INFO (level_info_get_type ())
typedef struct _LevelInfo LevelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KLOTSKI_WINDOW (klotski_window_get_type ())
#define KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindow))
#define KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))
#define IS_KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KLOTSKI_WINDOW))
#define IS_KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KLOTSKI_WINDOW))
#define KLOTSKI_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))

typedef struct _KlotskiWindow KlotskiWindow;
typedef struct _KlotskiWindowClass KlotskiWindowClass;
typedef struct _KlotskiWindowPrivate KlotskiWindowPrivate;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _LevelInfo {
	gchar* name;
	gint group;
	gint width;
	gint height;
	gchar* data;
};

struct _KlotskiWindow {
	GtkApplicationWindow parent_instance;
	KlotskiWindowPrivate * priv;
};

struct _KlotskiWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _KlotskiWindowPrivate {
	GSettings* settings;
	gboolean is_tiled;
	gboolean window_is_maximized;
	gint window_width;
	gint window_height;
	GtkHeaderBar* headerbar;
	GtkStack* stack_packs;
	GtkStack* stack_puzzles;
	GtkPopover* puzzles_popover;
	PuzzleView* view;
	GtkTreeView* treeview_huarong;
	GtkTreeView* treeview_challenge;
	GtkTreeView* treeview_skill;
	GSimpleAction* prev_pack;
	GSimpleAction* next_pack;
	GSimpleAction* prev_puzzle;
	GSimpleAction* next_puzzle;
	GSimpleAction* start_game;
	Puzzle* puzzle;
	gint current_pack;
	gint current_level;
	GamesScoresContext* scores_context;
	GtkListStore* liststore_huarong;
	GtkListStore* liststore_challenge;
	GtkListStore* liststore_skill;
	GtkTreeIter* puzzles_items;
	gint puzzles_items_length1;
	gint _puzzles_items_size_;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer klotski_window_parent_class = NULL;
static GeeList* klotski_window_score_categories;
static GeeList* klotski_window_score_categories = NULL;

GType level_info_get_type (void) G_GNUC_CONST;
LevelInfo* level_info_dup (const LevelInfo* self);
void level_info_free (LevelInfo* self);
void level_info_copy (const LevelInfo* self, LevelInfo* dest);
void level_info_destroy (LevelInfo* self);
GType klotski_window_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define KLOTSKI_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KLOTSKI_WINDOW, KlotskiWindowPrivate))
enum  {
	KLOTSKI_WINDOW_DUMMY_PROPERTY
};
#define KLOTSKI_WINDOW_KEY_LEVEL "level"
static void klotski_window_prev_pack_cb (KlotskiWindow* self);
static void _klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_next_pack_cb (KlotskiWindow* self);
static void _klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_prev_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_next_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_window_start_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static gchar* klotski_window_normalize_map_name (const gchar* name);
static GamesScoresCategory* klotski_window_category_request (KlotskiWindow* self, const gchar* key);
static void klotski_window_parse_old_score (KlotskiWindow* self, const gchar* line, GamesScoresScore** score, GamesScoresCategory** category);
KlotskiWindow* klotski_window_new (void);
KlotskiWindow* klotski_window_construct (GType object_type);
static GamesScoresCategory* _klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
static void _klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line, GamesScoresScore** score, GamesScoresCategory** category, gpointer self);
static void klotski_window_level_huarong_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void klotski_window_level_challenge_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void klotski_window_level_skill_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void _klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void klotski_window_load_solved_state (KlotskiWindow* self);
static void __lambda5_ (KlotskiWindow* self);
static void klotski_window_update_popover (KlotskiWindow* self, gboolean make_current);
static void ___lambda5__gtk_widget_show (GtkWidget* _sender, gpointer self);
static void klotski_window_start_puzzle (KlotskiWindow* self);
static void klotski_window_on_size_allocate (KlotskiWindow* self, GtkAllocation* allocation);
static void _klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean klotski_window_on_window_state_event (KlotskiWindow* self, GdkEventWindowState* event);
static gboolean _klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void klotski_window_on_destroy (KlotskiWindow* self);
static void _klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void klotski_window_start_puzzle_from_iter (KlotskiWindow* self, GtkListStore* model, GtkTreeIter* iter);
static void klotski_window_update_buttons_state (KlotskiWindow* self);
static void klotski_window_level_cb (KlotskiWindow* self, GtkListStore* liststore, GtkTreePath* path, GtkTreeViewColumn* column);
Puzzle* puzzle_new (gint width, gint height, const gchar* data);
Puzzle* puzzle_construct (GType object_type, gint width, gint height, const gchar* data);
static void klotski_window_puzzle_moved_cb (KlotskiWindow* self);
static void _klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void klotski_window_update_moves_label (KlotskiWindow* self);
gboolean puzzle_game_over (Puzzle* self);
static void klotski_window_game_score (KlotskiWindow* self);
static gchar* klotski_window_get_level_key (KlotskiWindow* self, gint level_number);
static void klotski_window_puzzle_solved (KlotskiWindow* self, GtkTreeIter* iter, gboolean solved);
static void __lambda4_ (KlotskiWindow* self, GObject* object, GAsyncResult* _result_);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void klotski_window_show_scores (KlotskiWindow* self);
static void klotski_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const LevelInfo KLOTSKI_WINDOW_levels[28] = {{"Only 18 Steps", 0, 6, 9, "######" "#a**b#" "#m**n#" "#cdef#" "#ghij#" "#k  l#" "##--##" "    .." "    .."}, {"Daisy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#zghi#" "#j  k#" "##--##" "    .." "    .."}, {"Violet", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghi#" "#j  k#" "##--##" "    .." "    .."}, {"Poppy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#fghi#" "#j  k#" "##--##" "    .." "    .."}, {"Pansy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghf#" "#i  j#" "##--##" "    .." "    .."}, {"Snowdrop", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfgh#" "#i  j#" "##--##" "    .." "    .."}, {"Red Donkey", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfge#" "#h  i#" "##--##" "    .." "    .."}, {"Trail", 0, 6, 9, "######" "#a**c#" "#a**c#" "#eddg#" "#hffj#" "# ii #" "##--##" "    .." "    .."}, {"Ambush", 0, 6, 9, "######" "#a**c#" "#d**e#" "#dffe#" "#ghhi#" "# jj #" "##--##" "    .." "    .."}, {"Agatka", 1, 7, 7, "..     " ".      " "#####--" "#**aab-" "#*ccde#" "#fgh  #" "#######"}, {"Success", 1, 9, 6, "#######  " "#**bbc#  " "#defgh#  " "#ijkgh-  " "#llk  #  " "#######.."}, {"Bone", 1, 6, 9, "######" "#abc*#" "# dd*#" "# ee*#" "# fgh#" "##-###" "     ." "     ." "     ."}, {"Fortune", 1, 7, 10, "     .." "     . " "####-. " "#ab  - " "#ccd # " "#ccd # " "#**ee# " "#*fgh# " "#*iih# " "###### "}, {"Fool", 1, 10, 6, "  ########" "  -aabc  #" "  #aabdef#" "  #ijggef#" "  #klhh**#" "..########"}, {"Solomon", 1, 7, 9, " .     " "..     " "#--####" "#  aab#" "# cdfb#" "#hcefg#" "#hijk*#" "#hll**#" "#######"}, {"Cleopatra", 1, 6, 8, "######" "#abcd#" "#**ee#" "#f*g #" "#fh i-" "####--" "    .." "     ."}, {"Shark", 1, 11, 8, "########   " "#nrr s #   " "#n*op q#   " "#***jml#   " "#hhijkl#   " "#ffcddg-   " "#abcdde- . " "########..."}, {"Rome", 1, 8, 8, "########" "#abcc**#" "#ddeef*#" "#ddghfi#" "#   jki#" "#--#####" " ..     " "  .     "}, {"Pennant Puzzle", 1, 6, 9, "######" "#**aa#" "#**bb#" "#de  #" "#fghh#" "#fgii#" "#--###" "    .." "    .."}, {"Ithaca", 2, 19, 19, ".aaaaaaaaaaaaaaaaab" "..  cddeffffffffffb" " .. cddeffffffffffb" "  . cddeffffffffffb" "ggg-############hhb" "ggg-  ABCDEFFGH#hhb" "ggg-       FFIJ#hhb" "ggg#       KLMJ#hhb" "ggg#NNNNOOOPQMJ#hhb" "ggg#NNNNOOOP*RS#hhb" "ggg#TTTTTUVW**X#hhb" "ggg#YZ12222W3**#hhb" "ggg#YZ12222W34*#iib" "jjj#YZ155555367#klb" "jjj#############mmb" "jjjnooooooooooppppb" "jjjqooooooooooppppb" "       rrrssssppppb" "ttttttuvvvvvvvwwwwx"}, {"Pelopones", 2, 9, 8, "#########" "#abbb***#" "#abbb*c*#" "#adeefgg#" "#  eefhh#" "#... ihh#" "#. . ihh#" "#########"}, {"Transeuropa", 2, 15, 8, "    ###########" "    -AAAAABBCC#" "    -   DEFGHI#" "    #   DEFGJI#" "    #   KEFGLI#" "    #   KEFG*I#" "  . #   MM****#" "....###########"}, {"Lodzianka", 2, 9, 7, "#########" "#**abbcc#" "#**abbdd#" "#eefgh  #" "#iiijk..#" "#iiijk..#" "#########"}, {"Polonaise", 2, 7, 7, "#######" "#aab**#" "#aabc*#" "#defgg#" "#..fhh#" "# .ihh#" "#######"}, {"Baltic Sea", 2, 6, 8, "######" "#.abc#" "#.dec#" "#fggc#" "#fhhi#" "#fjk*#" "#flk*#" "######"}, {"American Pie", 2, 10, 12, "##########" "#a*bcdefg#" "#**bhhhhg#" "#*iijjkkg#" "#liimnoop#" "#qiirrr  #" "#qstuvv  #" "#qwwxvv  #" "######--##" "         ." "        .." "        . "}, {"Traffic Jam", 2, 10, 7, "########  " "#** ffi#  " "#** fgh#  " "#aacehh#  " "#bbdjlm-  " "#bddklm-.." "########.."}, {"Sunshine", 2, 17, 22, "       ...       " "      .. ..      " "      .   .      " "      .. ..      " "       ...       " "######-----######" "#hh0iilltmmpp;qq#" "#hh,iill mmpp:qq#" "#2y{45v s w89x/z#" "#jj6kkaa nnoo<rr#" "#jj7kkaaunnoo>rr#" "#33333TTJWW11111#" "#33333TTJWW11111#" "#33333GG HH11111#" "#33333YYIgg11111#" "#33333YYIgg11111#" "#ddFeeA***BffOZZ#" "#ddFee** **ffOZZ#" "#MMKQQ*   *PPS^^#" "#VVLXX** **bbRcc#" "#VVLXXD***EbbRcc#" "#################"}};
static const GActionEntry KLOTSKI_WINDOW_win_actions[5] = {{"prev-pack", _klotski_window_prev_pack_cb_gsimple_action_activate_callback}, {"next-pack", _klotski_window_next_pack_cb_gsimple_action_activate_callback}, {"prev-puzzle", _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback}, {"next-puzzle", _klotski_window_next_puzzle_cb_gsimple_action_activate_callback}, {"start-game", _klotski_window_start_puzzle_cb_gsimple_action_activate_callback}};

void level_info_copy (const LevelInfo* self, LevelInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = (*self).name;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*dest).name);
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	(*dest).name = _tmp1_;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = (*self).group;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	(*dest).group = _tmp2_;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = (*self).width;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	(*dest).width = _tmp3_;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = (*self).height;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	(*dest).height = _tmp4_;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = (*self).data;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*dest).data);
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	(*dest).data = _tmp6_;
#line 253 "klotski-window.c"
}


void level_info_destroy (LevelInfo* self) {
#line 16 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*self).name);
#line 20 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 ((*self).data);
#line 262 "klotski-window.c"
}


LevelInfo* level_info_dup (const LevelInfo* self) {
	LevelInfo* dup;
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	dup = g_new0 (LevelInfo, 1);
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	level_info_copy (self, dup);
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return dup;
#line 274 "klotski-window.c"
}


void level_info_free (LevelInfo* self) {
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	level_info_destroy (self);
#line 14 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_free (self);
#line 283 "klotski-window.c"
}


GType level_info_get_type (void) {
	static volatile gsize level_info_type_id__volatile = 0;
	if (g_once_init_enter (&level_info_type_id__volatile)) {
		GType level_info_type_id;
		level_info_type_id = g_boxed_type_register_static ("LevelInfo", (GBoxedCopyFunc) level_info_dup, (GBoxedFreeFunc) level_info_free);
		g_once_init_leave (&level_info_type_id__volatile, level_info_type_id);
	}
	return level_info_type_id__volatile;
}


static void _klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_prev_pack_cb ((KlotskiWindow*) self);
#line 301 "klotski-window.c"
}


static void _klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_next_pack_cb ((KlotskiWindow*) self);
#line 308 "klotski-window.c"
}


static void _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_prev_puzzle_cb ((KlotskiWindow*) self);
#line 315 "klotski-window.c"
}


static void _klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_next_puzzle_cb ((KlotskiWindow*) self);
#line 322 "klotski-window.c"
}


static void _klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle_cb ((KlotskiWindow*) self);
#line 329 "klotski-window.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1376 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1376 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1376 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 342 "klotski-window.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 373 "klotski-window.c"
				goto __catch1_g_regex_error;
			}
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1378 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			return NULL;
#line 382 "klotski-window.c"
		}
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 398 "klotski-window.c"
				goto __catch1_g_regex_error;
			}
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
			return NULL;
#line 409 "klotski-window.c"
		}
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1379 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 423 "klotski-window.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
#line 1377 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1377 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1377 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 437 "klotski-window.c"
	}
	__finally1:
#line 1377 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1377 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1377 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1377 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
		return NULL;
#line 448 "klotski-window.c"
	}
}


static gchar* klotski_window_normalize_map_name (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = name;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = string_replace (_tmp2_, " ", "-");
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = _tmp3_;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 (_tmp2_);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	result = _tmp4_;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return result;
#line 478 "klotski-window.c"
}


static GamesScoresCategory* klotski_window_category_request (KlotskiWindow* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 488 "klotski-window.c"
	{
		gint i = 0;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 493 "klotski-window.c"
		{
			gboolean _tmp0_ = FALSE;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp0_ = TRUE;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 500 "klotski-window.c"
				gint _tmp2_ = 0;
				const gchar* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				LevelInfo _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!_tmp0_) {
#line 511 "klotski-window.c"
					gint _tmp1_ = 0;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp1_ = i;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					i = _tmp1_ + 1;
#line 517 "klotski-window.c"
				}
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp0_ = FALSE;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp2_ = i;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp2_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					break;
#line 527 "klotski-window.c"
				}
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp3_ = key;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp4_ = i;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp5_ = KLOTSKI_WINDOW_levels[_tmp4_];
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = _tmp5_.name;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = klotski_window_normalize_map_name (_tmp6_);
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp8_ = _tmp7_;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp9_ = g_strcmp0 (_tmp3_, _tmp8_) == 0;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_g_free0 (_tmp8_);
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (_tmp9_) {
#line 547 "klotski-window.c"
					GeeList* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gpointer _tmp12_ = NULL;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp10_ = klotski_window_score_categories;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp11_ = i;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					result = (GamesScoresCategory*) _tmp12_;
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					return result;
#line 561 "klotski-window.c"
				}
			}
		}
	}
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	result = NULL;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return result;
#line 570 "klotski-window.c"
}


static void klotski_window_parse_old_score (KlotskiWindow* self, const gchar* line, GamesScoresScore** score, GamesScoresCategory** category) {
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64 date = 0LL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint level = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gint moves = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint64 _tmp26_ = 0LL;
	GamesScoresScore* _tmp27_ = NULL;
	GeeList* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gpointer _tmp30_ = NULL;
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (line != NULL);
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_score);
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_vala_score = NULL;
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_category);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_vala_category = NULL;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = line;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	tokens = _tmp2_;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	tokens_length1 = _vala_array_length (_tmp1_);
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tokens_size_ = tokens_length1;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = tokens;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3__length1 = tokens_length1;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp3__length1 != 3) {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 646 "klotski-window.c"
		} else {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 650 "klotski-window.c"
		}
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 656 "klotski-window.c"
		} else {
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 660 "klotski-window.c"
		}
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 664 "klotski-window.c"
	}
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = tokens;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4__length1 = tokens_length1;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = _tmp4_[0];
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = games_scores_history_file_importer_parse_date (_tmp5_);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	date = _tmp6_;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = date;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp7_ == ((gint64) 0)) {
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 686 "klotski-window.c"
		} else {
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 690 "klotski-window.c"
		}
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 696 "klotski-window.c"
		} else {
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 700 "klotski-window.c"
		}
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 704 "klotski-window.c"
	}
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = tokens;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp8__length1 = tokens_length1;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = _tmp8_[1];
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = atoi (_tmp9_);
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	level = _tmp10_;
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = level;
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp12_ == 0) {
#line 720 "klotski-window.c"
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		const gchar* _tmp14_ = NULL;
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp13_ = tokens;
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp13__length1 = tokens_length1;
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp14_ = _tmp13_[1];
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp11_ = g_strcmp0 (_tmp14_, "0") != 0;
#line 732 "klotski-window.c"
	} else {
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp11_ = FALSE;
#line 736 "klotski-window.c"
	}
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp11_) {
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 746 "klotski-window.c"
		} else {
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 750 "klotski-window.c"
		}
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 756 "klotski-window.c"
		} else {
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 760 "klotski-window.c"
		}
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 764 "klotski-window.c"
	}
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = level;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp16_ < 0) {
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp15_ = TRUE;
#line 772 "klotski-window.c"
	} else {
		gint _tmp17_ = 0;
		GeeList* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp17_ = level;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp18_ = klotski_window_score_categories;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp20_ = _tmp19_;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp15_ = _tmp17_ > _tmp20_;
#line 788 "klotski-window.c"
	}
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp15_) {
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 798 "klotski-window.c"
		} else {
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 802 "klotski-window.c"
		}
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 808 "klotski-window.c"
		} else {
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 812 "klotski-window.c"
		}
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 816 "klotski-window.c"
	}
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = tokens;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp21__length1 = tokens_length1;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp22_ = _tmp21_[2];
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp23_ = atoi (_tmp22_);
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	moves = _tmp23_;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp24_ = moves;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp24_ <= 0) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (score) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*score = _vala_score;
#line 838 "klotski-window.c"
		} else {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_score);
#line 842 "klotski-window.c"
		}
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (category) {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			*category = _vala_category;
#line 848 "klotski-window.c"
		} else {
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_g_object_unref0 (_vala_category);
#line 852 "klotski-window.c"
		}
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 856 "klotski-window.c"
	}
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp25_ = moves;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp26_ = date;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp27_ = games_scores_score_new ((glong) _tmp25_, _tmp26_, NULL);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_score);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_vala_score = _tmp27_;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp28_ = klotski_window_score_categories;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp29_ = level;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_vala_category);
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_vala_category = (GamesScoresCategory*) _tmp30_;
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (score) {
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		*score = _vala_score;
#line 884 "klotski-window.c"
	} else {
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_object_unref0 (_vala_score);
#line 888 "klotski-window.c"
	}
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (category) {
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		*category = _vala_category;
#line 894 "klotski-window.c"
	} else {
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_object_unref0 (_vala_category);
#line 898 "klotski-window.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return self ? g_object_ref (self) : NULL;
#line 906 "klotski-window.c"
}


static GamesScoresCategory* _klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = klotski_window_category_request ((KlotskiWindow*) self, category_key);
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return result;
#line 915 "klotski-window.c"
}


static void _klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line, GamesScoresScore** score, GamesScoresCategory** category, gpointer self) {
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_parse_old_score ((KlotskiWindow*) self, line, score, category);
#line 922 "klotski-window.c"
}


static void _klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_huarong_cb ((KlotskiWindow*) self, path, column);
#line 929 "klotski-window.c"
}


static void _klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_challenge_cb ((KlotskiWindow*) self, path, column);
#line 936 "klotski-window.c"
}


static void _klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_skill_cb ((KlotskiWindow*) self, path, column);
#line 943 "klotski-window.c"
}


static void __lambda5_ (KlotskiWindow* self) {
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 950 "klotski-window.c"
}


static void ___lambda5__gtk_widget_show (GtkWidget* _sender, gpointer self) {
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	__lambda5_ ((KlotskiWindow*) self);
#line 957 "klotski-window.c"
}


KlotskiWindow* klotski_window_construct (GType object_type) {
	KlotskiWindow * self = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GtkCssProvider* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GtkCssProvider* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GSettings* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GAction* _tmp11_ = NULL;
	GSimpleAction* _tmp12_ = NULL;
	GAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GAction* _tmp15_ = NULL;
	GSimpleAction* _tmp16_ = NULL;
	GAction* _tmp17_ = NULL;
	GSimpleAction* _tmp18_ = NULL;
	GAction* _tmp19_ = NULL;
	GSimpleAction* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GamesScoresHistoryFileImporter* _tmp22_ = NULL;
	GamesScoresHistoryFileImporter* _tmp23_ = NULL;
	GamesScoresContext* _tmp24_ = NULL;
	GtkListStore* _tmp25_ = NULL;
	GtkListStore* _tmp26_ = NULL;
	GtkListStore* _tmp27_ = NULL;
	GtkTreeIter* _tmp28_ = NULL;
	GtkTreeView* _tmp74_ = NULL;
	GtkListStore* _tmp75_ = NULL;
	GtkTreeView* _tmp76_ = NULL;
	GtkListStore* _tmp77_ = NULL;
	GtkTreeView* _tmp78_ = NULL;
	GtkListStore* _tmp79_ = NULL;
	GtkTreeView* _tmp80_ = NULL;
	GtkTreeView* _tmp81_ = NULL;
	GtkTreeView* _tmp82_ = NULL;
	PuzzleView* _tmp83_ = NULL;
	PuzzleView* _tmp84_ = NULL;
	PuzzleView* _tmp85_ = NULL;
	PuzzleView* _tmp86_ = NULL;
	PuzzleView* _tmp87_ = NULL;
	GSettings* _tmp88_ = NULL;
	gint _tmp89_ = 0;
	gint _tmp90_ = 0;
	GtkPopover* _tmp91_ = NULL;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self = (KlotskiWindow*) g_object_new (object_type, NULL);
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = gtk_css_provider_new ();
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	css_provider = _tmp0_;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = css_provider;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/klotski/ui/klotski.css");
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = gdk_screen_get_default ();
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = css_provider;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = g_settings_new ("org.gnome.klotski");
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->settings);
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->settings = _tmp4_;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = self->priv->settings;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = g_settings_get_int (_tmp5_, "window-width");
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->settings;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = g_settings_get_int (_tmp7_, "window-height");
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, _tmp6_, _tmp8_);
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = self->priv->settings;
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = g_settings_get_boolean (_tmp9_, "window-is-maximized");
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp10_) {
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 1051 "klotski-window.c"
	}
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_action_map_add_action_entries ((GActionMap*) self, KLOTSKI_WINDOW_win_actions, G_N_ELEMENTS (KLOTSKI_WINDOW_win_actions), self);
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) self, "prev-pack");
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp11_) : NULL);
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_pack);
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->prev_pack = _tmp12_;
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = g_action_map_lookup_action ((GActionMap*) self, "next-pack");
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp13_) : NULL);
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_pack);
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->next_pack = _tmp14_;
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) self, "prev-puzzle");
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp15_) : NULL);
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_puzzle);
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->prev_puzzle = _tmp16_;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "next-puzzle");
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp17_) : NULL);
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_puzzle);
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->next_puzzle = _tmp18_;
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp19_ = g_action_map_lookup_action ((GActionMap*) self, "start-game");
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp19_) : NULL);
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->start_game);
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->start_game = _tmp20_;
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = _ ("Puzzle");
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp22_ = games_scores_history_file_importer_new (_klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func, self);
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp23_ = _tmp22_;
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp24_ = games_scores_context_new_with_importer ("gnome-klotski", _tmp21_, (GtkWindow*) self, _klotski_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, (GamesScoresImporter*) _tmp23_);
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->scores_context = _tmp24_;
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_tmp23_);
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp25_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_huarong);
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->liststore_huarong = _tmp25_;
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp26_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_challenge);
#line 535 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->liststore_challenge = _tmp26_;
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp27_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_skill);
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->liststore_skill = _tmp27_;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp28_ = g_new0 (GtkTreeIter, G_N_ELEMENTS (KLOTSKI_WINDOW_levels));
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items = _tmp28_;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items_length1 = G_N_ELEMENTS (KLOTSKI_WINDOW_levels);
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->_puzzles_items_size_ = self->priv->puzzles_items_length1;
#line 1137 "klotski-window.c"
	{
		gint i = 0;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 1142 "klotski-window.c"
		{
			gboolean _tmp29_ = FALSE;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp29_ = TRUE;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 1149 "klotski-window.c"
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				LevelInfo _tmp33_ = {0};
				gint _tmp34_ = 0;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!_tmp29_) {
#line 1156 "klotski-window.c"
					gint _tmp30_ = 0;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp30_ = i;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					i = _tmp30_ + 1;
#line 1162 "klotski-window.c"
				}
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp29_ = FALSE;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp31_ = i;
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp31_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 539 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					break;
#line 1172 "klotski-window.c"
				}
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp32_ = i;
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp33_ = KLOTSKI_WINDOW_levels[_tmp32_];
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp34_ = _tmp33_.group;
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				switch (_tmp34_) {
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					case 0:
#line 1184 "klotski-window.c"
					{
						GtkListStore* _tmp35_ = NULL;
						GtkTreeIter* _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gint _tmp37_ = 0;
						GtkTreeIter _tmp38_ = {0};
						GtkListStore* _tmp39_ = NULL;
						GtkTreeIter* _tmp40_ = NULL;
						gint _tmp40__length1 = 0;
						gint _tmp41_ = 0;
						GtkTreeIter _tmp42_ = {0};
						gint _tmp43_ = 0;
						LevelInfo _tmp44_ = {0};
						const gchar* _tmp45_ = NULL;
						const gchar* _tmp46_ = NULL;
						gint _tmp47_ = 0;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp35_ = self->priv->liststore_huarong;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp36_ = self->priv->puzzles_items;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp36__length1 = self->priv->puzzles_items_length1;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp37_ = i;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_append (_tmp35_, &_tmp38_);
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp36_[_tmp37_] = _tmp38_;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp39_ = self->priv->liststore_huarong;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp40_ = self->priv->puzzles_items;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp40__length1 = self->priv->puzzles_items_length1;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp41_ = i;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp42_ = _tmp40_[_tmp41_];
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp43_ = i;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp44_ = KLOTSKI_WINDOW_levels[_tmp43_];
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp45_ = _tmp44_.name;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp46_ = _ (_tmp45_);
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp47_ = i;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_set (_tmp39_, &_tmp42_, 0, _tmp46_, 1, FALSE, 2, _tmp47_, 3, FALSE, -1);
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						break;
#line 1237 "klotski-window.c"
					}
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					case 1:
#line 1241 "klotski-window.c"
					{
						GtkListStore* _tmp48_ = NULL;
						GtkTreeIter* _tmp49_ = NULL;
						gint _tmp49__length1 = 0;
						gint _tmp50_ = 0;
						GtkTreeIter _tmp51_ = {0};
						GtkListStore* _tmp52_ = NULL;
						GtkTreeIter* _tmp53_ = NULL;
						gint _tmp53__length1 = 0;
						gint _tmp54_ = 0;
						GtkTreeIter _tmp55_ = {0};
						gint _tmp56_ = 0;
						LevelInfo _tmp57_ = {0};
						const gchar* _tmp58_ = NULL;
						const gchar* _tmp59_ = NULL;
						gint _tmp60_ = 0;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp48_ = self->priv->liststore_challenge;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp49_ = self->priv->puzzles_items;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp49__length1 = self->priv->puzzles_items_length1;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp50_ = i;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_append (_tmp48_, &_tmp51_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp49_[_tmp50_] = _tmp51_;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp52_ = self->priv->liststore_challenge;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp53_ = self->priv->puzzles_items;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp53__length1 = self->priv->puzzles_items_length1;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp54_ = i;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp55_ = _tmp53_[_tmp54_];
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp56_ = i;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp57_ = KLOTSKI_WINDOW_levels[_tmp56_];
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp58_ = _tmp57_.name;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp59_ = _ (_tmp58_);
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp60_ = i;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_set (_tmp52_, &_tmp55_, 0, _tmp59_, 1, FALSE, 2, _tmp60_, 3, FALSE, -1);
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						break;
#line 1294 "klotski-window.c"
					}
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					case 2:
#line 1298 "klotski-window.c"
					{
						GtkListStore* _tmp61_ = NULL;
						GtkTreeIter* _tmp62_ = NULL;
						gint _tmp62__length1 = 0;
						gint _tmp63_ = 0;
						GtkTreeIter _tmp64_ = {0};
						GtkListStore* _tmp65_ = NULL;
						GtkTreeIter* _tmp66_ = NULL;
						gint _tmp66__length1 = 0;
						gint _tmp67_ = 0;
						GtkTreeIter _tmp68_ = {0};
						gint _tmp69_ = 0;
						LevelInfo _tmp70_ = {0};
						const gchar* _tmp71_ = NULL;
						const gchar* _tmp72_ = NULL;
						gint _tmp73_ = 0;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp61_ = self->priv->liststore_skill;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp62_ = self->priv->puzzles_items;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp62__length1 = self->priv->puzzles_items_length1;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp63_ = i;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_append (_tmp61_, &_tmp64_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp62_[_tmp63_] = _tmp64_;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp65_ = self->priv->liststore_skill;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp66_ = self->priv->puzzles_items;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp66__length1 = self->priv->puzzles_items_length1;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp67_ = i;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp68_ = _tmp66_[_tmp67_];
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp69_ = i;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp70_ = KLOTSKI_WINDOW_levels[_tmp69_];
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp71_ = _tmp70_.name;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp72_ = _ (_tmp71_);
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp73_ = i;
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						gtk_list_store_set (_tmp65_, &_tmp68_, 0, _tmp72_, 1, FALSE, 2, _tmp73_, 3, FALSE, -1);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						break;
#line 1351 "klotski-window.c"
					}
					default:
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					break;
#line 1356 "klotski-window.c"
				}
			}
		}
	}
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp74_ = self->priv->treeview_huarong;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp75_ = self->priv->liststore_huarong;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_tree_view_set_model (_tmp74_, (GtkTreeModel*) _tmp75_);
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp76_ = self->priv->treeview_challenge;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp77_ = self->priv->liststore_challenge;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_tree_view_set_model (_tmp76_, (GtkTreeModel*) _tmp77_);
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp78_ = self->priv->treeview_skill;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp79_ = self->priv->liststore_skill;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_tree_view_set_model (_tmp78_, (GtkTreeModel*) _tmp79_);
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp80_ = self->priv->treeview_huarong;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp80_, "row-activated", (GCallback) _klotski_window_level_huarong_cb_gtk_tree_view_row_activated, self, 0);
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp81_ = self->priv->treeview_challenge;
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp81_, "row-activated", (GCallback) _klotski_window_level_challenge_cb_gtk_tree_view_row_activated, self, 0);
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp82_ = self->priv->treeview_skill;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp82_, "row-activated", (GCallback) _klotski_window_level_skill_cb_gtk_tree_view_row_activated, self, 0);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp83_ = puzzle_view_new ();
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_object_ref_sink (_tmp83_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->view);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->view = _tmp83_;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp84_ = self->priv->view;
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp84_, GTK_ALIGN_FILL);
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp85_ = self->priv->view;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_object_set ((GtkWidget*) _tmp85_, "can-focus", TRUE, NULL);
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp86_ = self->priv->view;
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_show ((GtkWidget*) _tmp86_);
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp87_ = self->priv->view;
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp87_);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_load_solved_state (self);
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp88_ = self->priv->settings;
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp89_ = g_settings_get_int (_tmp88_, KLOTSKI_WINDOW_KEY_LEVEL);
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp90_ = CLAMP (_tmp89_, 0, G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1);
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp90_;
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp91_ = self->priv->puzzles_popover;
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object ((GtkWidget*) _tmp91_, "show", (GCallback) ___lambda5__gtk_widget_show, self, 0);
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 590 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (css_provider);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return self;
#line 1437 "klotski-window.c"
}


KlotskiWindow* klotski_window_new (void) {
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return klotski_window_construct (TYPE_KLOTSKI_WINDOW);
#line 1444 "klotski-window.c"
}


static void klotski_window_on_size_allocate (KlotskiWindow* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (allocation != NULL);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->window_is_maximized;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp1_) {
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp0_ = TRUE;
#line 1463 "klotski-window.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp2_ = self->priv->is_tiled;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp0_ = _tmp2_;
#line 1470 "klotski-window.c"
	}
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp0_) {
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 1476 "klotski-window.c"
	}
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->window_width = _tmp3_;
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->window_height = _tmp4_;
#line 1484 "klotski-window.c"
}


static void _klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_on_size_allocate ((KlotskiWindow*) self, allocation);
#line 1491 "klotski-window.c"
}


static gboolean klotski_window_on_window_state_event (KlotskiWindow* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 606 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 606 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = event;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1511 "klotski-window.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp2_ = event;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1520 "klotski-window.c"
	}
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = event;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1528 "klotski-window.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = event;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1537 "klotski-window.c"
	}
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	result = FALSE;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return result;
#line 1543 "klotski-window.c"
}


static gboolean _klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = klotski_window_on_window_state_event ((KlotskiWindow*) self, event);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return result;
#line 1552 "klotski-window.c"
}


static void klotski_window_on_destroy (KlotskiWindow* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 617 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->settings;
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_level;
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_settings_set_int (_tmp0_, KLOTSKI_WINDOW_KEY_LEVEL, _tmp1_);
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = self->priv->settings;
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->window_width;
#line 623 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_settings_set_int (_tmp2_, "window-width", _tmp3_);
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = self->priv->settings;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = self->priv->window_height;
#line 624 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_settings_set_int (_tmp4_, "window-height", _tmp5_);
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = self->priv->settings;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->window_is_maximized;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_settings_set_boolean (_tmp6_, "window-is-maximized", _tmp7_);
#line 1591 "klotski-window.c"
}


static void _klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_on_destroy ((KlotskiWindow*) self);
#line 1598 "klotski-window.c"
}


static void klotski_window_prev_pack_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 635 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 1619 "klotski-window.c"
	}
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_pack = _tmp3_ - 1;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, FALSE);
#line 1627 "klotski-window.c"
}


static void klotski_window_next_pack_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 643 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 1648 "klotski-window.c"
	}
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_pack = _tmp3_ + 1;
#line 645 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, FALSE);
#line 1656 "klotski-window.c"
}


static void klotski_window_prev_puzzle_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 648 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 651 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 1677 "klotski-window.c"
	}
#line 652 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_level;
#line 652 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp3_ - 1;
#line 653 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 654 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 1687 "klotski-window.c"
}


static void klotski_window_next_puzzle_cb (KlotskiWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 657 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_popover;
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (!_tmp2_) {
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 1708 "klotski-window.c"
	}
#line 661 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_level;
#line 661 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp3_ + 1;
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_popover (self, TRUE);
#line 663 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 1718 "klotski-window.c"
}


static void klotski_window_start_puzzle_cb (KlotskiWindow* self) {
	GtkTreeView* tree = NULL;
	GtkStack* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gconstpointer _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkTreeView* _tmp6_ = NULL;
	GtkTreeView* _tmp7_ = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp8_ = NULL;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp11_ = NULL;
	GtkTreeSelection* _tmp12_ = NULL;
	GtkTreeModel* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	GtkTreeModel* _tmp16_ = NULL;
	GtkPopover* _tmp19_ = NULL;
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->stack_puzzles;
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_;
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = g_list_nth_data (_tmp2_, (guint) _tmp3_);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp4_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_tree_view_get_type (), GtkTreeView));
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = _tmp6_;
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp2_);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	tree = _tmp7_;
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = tree;
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = gtk_tree_view_get_model (_tmp8_);
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	model = _tmp10_;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = tree;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = gtk_tree_selection_get_selected (_tmp12_, &_tmp13_, &_tmp14_);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (model);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = _g_object_ref0 (_tmp13_);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	model = _tmp16_;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	iter = _tmp14_;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp15_) {
#line 1790 "klotski-window.c"
		GtkTreeModel* _tmp17_ = NULL;
		GtkTreeIter _tmp18_ = {0};
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp17_ = model;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp18_ = iter;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		klotski_window_start_puzzle_from_iter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_list_store_get_type (), GtkListStore), &_tmp18_);
#line 1799 "klotski-window.c"
	} else {
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		klotski_window_start_puzzle (self);
#line 1803 "klotski-window.c"
	}
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp19_ = self->priv->puzzles_popover;
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp19_);
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (model);
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (tree);
#line 1813 "klotski-window.c"
}


static void klotski_window_update_popover (KlotskiWindow* self, gboolean make_current) {
	gint current_level_pack = 0;
	GtkTreeIter iter = {0};
	GtkTreeIter* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkTreeSelection* selection = NULL;
	GtkStack* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gconstpointer _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	GtkTreeSelection* _tmp17_ = NULL;
	GtkTreeSelection* _tmp18_ = NULL;
	GtkTreeSelection* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	GtkStack* _tmp25_ = NULL;
	GtkStack* _tmp26_ = NULL;
	GList* _tmp27_ = NULL;
	GList* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gconstpointer _tmp30_ = NULL;
	GtkStack* _tmp31_ = NULL;
	GtkStack* _tmp32_ = NULL;
	GList* _tmp33_ = NULL;
	GList* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gconstpointer _tmp36_ = NULL;
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->puzzles_items;
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0__length1 = self->priv->puzzles_items_length1;
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_level;
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	iter = _tmp2_;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->liststore_huarong;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = iter;
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = gtk_list_store_iter_is_valid (_tmp3_, &_tmp4_);
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp5_) {
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		current_level_pack = 0;
#line 1874 "klotski-window.c"
	} else {
		GtkListStore* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = self->priv->liststore_challenge;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp7_ = iter;
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp8_ = gtk_list_store_iter_is_valid (_tmp6_, &_tmp7_);
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (_tmp8_) {
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			current_level_pack = 1;
#line 1889 "klotski-window.c"
		} else {
#line 692 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			current_level_pack = 2;
#line 1893 "klotski-window.c"
		}
	}
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = make_current;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp9_) {
#line 1900 "klotski-window.c"
		gint _tmp10_ = 0;
#line 695 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp10_ = current_level_pack;
#line 695 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		self->priv->current_pack = _tmp10_;
#line 1906 "klotski-window.c"
	}
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = self->priv->stack_puzzles;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = gtk_container_get_children ((GtkContainer*) _tmp11_);
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = _tmp12_;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = self->priv->current_pack;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = g_list_nth_data (_tmp13_, (guint) _tmp14_);
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp15_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp17_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_tree_view_get_type (), GtkTreeView));
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp18_ = _g_object_ref0 (_tmp17_);
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp19_ = _tmp18_;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp13_);
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	selection = _tmp19_;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp20_ = self->priv->current_pack;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = current_level_pack;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp20_ == _tmp21_) {
#line 1936 "klotski-window.c"
		GtkTreeSelection* _tmp22_ = NULL;
		GtkTreeIter _tmp23_ = {0};
#line 700 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp22_ = selection;
#line 700 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp23_ = iter;
#line 700 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		gtk_tree_selection_select_iter (_tmp22_, &_tmp23_);
#line 1945 "klotski-window.c"
	} else {
		GtkTreeSelection* _tmp24_ = NULL;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp24_ = selection;
#line 702 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		gtk_tree_selection_unselect_all (_tmp24_);
#line 1952 "klotski-window.c"
	}
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_buttons_state (self);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp25_ = self->priv->stack_packs;
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp26_ = self->priv->stack_packs;
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp27_ = gtk_container_get_children ((GtkContainer*) _tmp26_);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp28_ = _tmp27_;
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp29_ = self->priv->current_pack;
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp30_ = g_list_nth_data (_tmp28_, (guint) _tmp29_);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_stack_set_visible_child (_tmp25_, (GtkWidget*) _tmp30_);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp28_);
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp31_ = self->priv->stack_puzzles;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp32_ = self->priv->stack_puzzles;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp33_ = gtk_container_get_children ((GtkContainer*) _tmp32_);
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp34_ = _tmp33_;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp35_ = self->priv->current_pack;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp36_ = g_list_nth_data (_tmp34_, (guint) _tmp35_);
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_stack_set_visible_child (_tmp31_, (GtkWidget*) _tmp36_);
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_list_free0 (_tmp34_);
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (selection);
#line 1990 "klotski-window.c"
}


static void klotski_window_update_buttons_state (KlotskiWindow* self) {
	GSimpleAction* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSimpleAction* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSimpleAction* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GSimpleAction* _tmp6_ = NULL;
	gint _tmp7_ = 0;
#line 711 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->prev_pack;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_pack;
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp0_, _tmp1_ > 0);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = self->priv->next_pack;
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->current_pack;
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp2_, _tmp3_ < 2);
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = self->priv->prev_puzzle;
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = self->priv->current_level;
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp4_, _tmp5_ > 0);
#line 717 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = self->priv->next_puzzle;
#line 717 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->current_level;
#line 717 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp6_, _tmp7_ < (G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1));
#line 2029 "klotski-window.c"
}


static void klotski_window_level_huarong_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkListStore* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
#line 724 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 724 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 724 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_huarong;
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = column;
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_cb (self, _tmp0_, _tmp1_, _tmp2_);
#line 2051 "klotski-window.c"
}


static void klotski_window_level_challenge_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkListStore* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_challenge;
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = column;
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_cb (self, _tmp0_, _tmp1_, _tmp2_);
#line 2073 "klotski-window.c"
}


static void klotski_window_level_skill_cb (KlotskiWindow* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkListStore* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_skill;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = column;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_level_cb (self, _tmp0_, _tmp1_, _tmp2_);
#line 2095 "klotski-window.c"
}


static void klotski_window_level_cb (KlotskiWindow* self, GtkListStore* liststore, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
#line 736 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 736 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (liststore != NULL);
#line 736 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (path != NULL);
#line 736 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (column != NULL);
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = liststore;
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = path;
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	iter = _tmp2_;
#line 741 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = liststore;
#line 741 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = iter;
#line 741 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle_from_iter (self, _tmp3_, &_tmp4_);
#line 2128 "klotski-window.c"
}


static void klotski_window_start_puzzle_from_iter (KlotskiWindow* self, GtkListStore* model, GtkTreeIter* iter) {
	GValue val = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GValue _tmp2_ = {0};
	gint requested_level = 0;
	GValue _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (model != NULL);
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (iter != NULL);
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = model;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = *iter;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 2, &_tmp2_);
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	val = _tmp2_;
#line 753 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = val;
#line 753 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	requested_level = g_value_get_int (&_tmp3_);
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = requested_level;
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp4_ < 0) {
#line 755 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 755 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 2169 "klotski-window.c"
	}
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = requested_level;
#line 757 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = _tmp5_;
#line 758 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_buttons_state (self);
#line 759 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_start_puzzle (self);
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 2181 "klotski-window.c"
}


static void _klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self) {
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_puzzle_moved_cb ((KlotskiWindow*) self);
#line 2188 "klotski-window.c"
}


static void klotski_window_start_puzzle (KlotskiWindow* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	LevelInfo _tmp2_ = {0};
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	LevelInfo _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	LevelInfo _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	LevelInfo _tmp12_ = {0};
	const gchar* _tmp13_ = NULL;
	Puzzle* _tmp14_ = NULL;
	Puzzle* _tmp15_ = NULL;
	PuzzleView* _tmp16_ = NULL;
	Puzzle* _tmp17_ = NULL;
	GSimpleAction* _tmp18_ = NULL;
#line 762 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->headerbar;
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->current_level;
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = KLOTSKI_WINDOW_levels[_tmp1_];
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = _tmp2_.name;
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = _ (_tmp3_);
#line 764 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_header_bar_set_title (_tmp0_, _tmp4_);
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = self->priv->current_level;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = KLOTSKI_WINDOW_levels[_tmp5_];
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = _tmp6_.width;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = self->priv->current_level;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = KLOTSKI_WINDOW_levels[_tmp8_];
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = _tmp9_.height;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = self->priv->current_level;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = KLOTSKI_WINDOW_levels[_tmp11_];
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = _tmp12_.data;
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = puzzle_new (_tmp7_, _tmp10_, _tmp13_);
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->puzzle);
#line 765 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzle = _tmp14_;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = self->priv->puzzle;
#line 766 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_signal_connect_object (_tmp15_, "moved", (GCallback) _klotski_window_puzzle_moved_cb_puzzle_moved, self, 0);
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = self->priv->view;
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp17_ = self->priv->puzzle;
#line 767 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	puzzle_view_set_puzzle (_tmp16_, _tmp17_);
#line 769 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_moves_label (self);
#line 770 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp18_ = self->priv->start_game;
#line 770 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp18_, FALSE);
#line 2266 "klotski-window.c"
}


static void klotski_window_puzzle_moved_cb (KlotskiWindow* self) {
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_update_moves_label (self);
#line 2275 "klotski-window.c"
}


static void klotski_window_update_moves_label (KlotskiWindow* self) {
	GSimpleAction* _tmp0_ = NULL;
	GtkHeaderBar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Puzzle* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Puzzle* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->start_game;
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_simple_action_set_enabled (_tmp0_, TRUE);
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = self->priv->headerbar;
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _ ("Moves: %d");
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = self->priv->puzzle;
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = _tmp3_->moves;
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp5_ = g_strdup_printf (_tmp2_, _tmp4_);
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp6_ = _tmp5_;
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_header_bar_set_subtitle (_tmp1_, _tmp6_);
#line 781 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 (_tmp6_);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->puzzle;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = puzzle_game_over (_tmp7_);
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp8_) {
#line 2317 "klotski-window.c"
		GtkHeaderBar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp9_ = self->priv->headerbar;
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp10_ = _ ("Level completed.");
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		gtk_header_bar_set_title (_tmp9_, _tmp10_);
#line 785 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		klotski_window_game_score (self);
#line 2328 "klotski-window.c"
	}
}


static void __lambda4_ (KlotskiWindow* self, GObject* object, GAsyncResult* _result_) {
	GError * _inner_error_ = NULL;
#line 823 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (_result_ != NULL);
#line 2337 "klotski-window.c"
	{
		GamesScoresContext* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp0_ = self->priv->scores_context;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp1_ = _result_;
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 826 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2349 "klotski-window.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 830 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp2_ = e;
#line 830 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp3_ = _tmp2_->message;
#line 830 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_warning ("klotski-window.vala:830: Failed to add score: %s", _tmp3_);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2371 "klotski-window.c"
	}
	__finally4:
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 2382 "klotski-window.c"
	}
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	__lambda4_ ((KlotskiWindow*) self, source_object, res);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_object_unref (self);
#line 2392 "klotski-window.c"
}


static void klotski_window_game_score (KlotskiWindow* self) {
	gchar* key = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp2_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkTreeIter* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp8_ = 0;
	GtkTreeIter _tmp9_ = {0};
	GamesScoresContext* _tmp10_ = NULL;
	Puzzle* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GeeList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gpointer _tmp15_ = NULL;
	GamesScoresCategory* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 793 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->current_level;
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = klotski_window_get_level_key (self, _tmp0_);
#line 796 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	key = _tmp1_;
#line 797 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = g_key_file_new ();
#line 797 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	keyfile = _tmp2_;
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = g_get_user_data_dir ();
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp4_ = g_build_filename (_tmp3_, "gnome-klotski", "levels", NULL);
#line 798 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	filename = _tmp4_;
#line 2435 "klotski-window.c"
	{
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2441 "klotski-window.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2455 "klotski-window.c"
	}
	__finally2:
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_free0 (filename);
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_key_file_unref0 (keyfile);
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_free0 (key);
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 800 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 2472 "klotski-window.c"
	}
#line 808 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_key_file_set_boolean (keyfile, key, "solved", TRUE);
#line 2476 "klotski-window.c"
	{
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 812 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp5_ = g_key_file_to_data (keyfile, NULL, NULL);
#line 812 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = _tmp5_;
#line 812 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_file_set_contents (filename, _tmp6_, (gssize) -1, &_inner_error_);
#line 812 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_free0 (_tmp6_);
#line 812 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2490 "klotski-window.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2504 "klotski-window.c"
	}
	__finally3:
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_free0 (filename);
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_key_file_unref0 (keyfile);
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_free0 (key);
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 810 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 2521 "klotski-window.c"
	}
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7_ = self->priv->puzzles_items;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp7__length1 = self->priv->puzzles_items_length1;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp8_ = self->priv->current_level;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp9_ = _tmp7_[_tmp8_];
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_puzzle_solved (self, &_tmp9_, TRUE);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp10_ = self->priv->scores_context;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp11_ = self->priv->puzzle;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp12_ = _tmp11_->moves;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp13_ = klotski_window_score_categories;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp14_ = self->priv->current_level;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp15_ = gee_list_get (_tmp13_, _tmp14_);
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp16_ = (GamesScoresCategory*) _tmp15_;
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	games_scores_context_add_score (_tmp10_, (glong) _tmp12_, _tmp16_, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self));
#line 820 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (_tmp16_);
#line 793 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 (filename);
#line 793 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_key_file_unref0 (keyfile);
#line 793 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 (key);
#line 2557 "klotski-window.c"
}


void klotski_window_show_scores (KlotskiWindow* self) {
	GamesScoresContext* _tmp0_ = NULL;
#line 835 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 837 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->scores_context;
#line 837 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	games_scores_context_run_dialog (_tmp0_);
#line 2569 "klotski-window.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1082 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1083 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1083 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1083 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1083 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 2587 "klotski-window.c"
}


static gchar* klotski_window_get_level_key (KlotskiWindow* self, gint level_number) {
	gchar* result = NULL;
	guint32 _result_ = 0U;
	gchar* data = NULL;
	gint _tmp0_ = 0;
	LevelInfo _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint32 _tmp21_ = 0U;
	gchar* _tmp22_ = NULL;
#line 840 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 843 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_result_ = (guint32) 0xFFFFFFFFU;
#line 844 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = level_number;
#line 844 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = KLOTSKI_WINDOW_levels[_tmp0_];
#line 844 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = _tmp1_.data;
#line 844 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 844 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	data = _tmp3_;
#line 2615 "klotski-window.c"
	{
		gint i = 0;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 2620 "klotski-window.c"
		{
			gboolean _tmp4_ = FALSE;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp4_ = TRUE;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 2627 "klotski-window.c"
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gchar _tmp8_ = '\0';
				gchar octet = '\0';
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gchar _tmp11_ = '\0';
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!_tmp4_) {
#line 2637 "klotski-window.c"
					gint _tmp5_ = 0;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp5_ = i;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					i = _tmp5_ + 1;
#line 2643 "klotski-window.c"
				}
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp4_ = FALSE;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = data;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = i;
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp8_ = string_get (_tmp6_, (glong) _tmp7_);
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp8_ != '\0')) {
#line 845 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					break;
#line 2657 "klotski-window.c"
				}
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp9_ = data;
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp10_ = i;
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp11_ = string_get (_tmp9_, (glong) _tmp10_);
#line 847 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				octet = _tmp11_;
#line 2667 "klotski-window.c"
				{
					gint j = 0;
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					j = 0;
#line 2672 "klotski-window.c"
					{
						gboolean _tmp12_ = FALSE;
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						_tmp12_ = TRUE;
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
						while (TRUE) {
#line 2679 "klotski-window.c"
							gint _tmp14_ = 0;
							gchar _tmp15_ = '\0';
							guint32 _tmp16_ = 0U;
							guint32 _tmp19_ = 0U;
							gchar _tmp20_ = '\0';
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							if (!_tmp12_) {
#line 2687 "klotski-window.c"
								gint _tmp13_ = 0;
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
								_tmp13_ = j;
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
								j = _tmp13_ + 1;
#line 2693 "klotski-window.c"
							}
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							_tmp12_ = FALSE;
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							_tmp14_ = j;
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							if (!(_tmp14_ < 8)) {
#line 848 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
								break;
#line 2703 "klotski-window.c"
							}
#line 850 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							_tmp15_ = octet;
#line 850 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							_tmp16_ = _result_;
#line 850 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							if (((_tmp15_ >> 7) ^ (_tmp16_ >> 31)) != 0) {
#line 2711 "klotski-window.c"
								guint32 _tmp17_ = 0U;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
								_tmp17_ = _result_;
#line 851 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
								_result_ = (_tmp17_ << 1) ^ 0x04c11db7;
#line 2717 "klotski-window.c"
							} else {
								guint32 _tmp18_ = 0U;
#line 853 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
								_tmp18_ = _result_;
#line 853 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
								_result_ = _tmp18_ << 1;
#line 2724 "klotski-window.c"
							}
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							_tmp19_ = _result_;
#line 854 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							_result_ = _tmp19_ & 0xFFFFFFFFLL;
#line 855 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							_tmp20_ = octet;
#line 855 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
							octet = (gchar) (_tmp20_ << 1);
#line 2734 "klotski-window.c"
						}
					}
				}
			}
		}
	}
#line 859 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp21_ = _result_;
#line 859 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp22_ = g_strdup_printf ("%08X", (guint) (~_tmp21_));
#line 859 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	result = _tmp22_;
#line 859 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 (data);
#line 859 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	return result;
#line 2751 "klotski-window.c"
}


static void klotski_window_load_solved_state (KlotskiWindow* self) {
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 862 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 864 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = g_key_file_new ();
#line 864 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	keyfile = _tmp0_;
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = g_get_user_data_dir ();
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = g_build_filename (_tmp1_, "gnome-klotski", "levels", NULL);
#line 865 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	filename = _tmp2_;
#line 2774 "klotski-window.c"
	{
#line 868 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
#line 868 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2780 "klotski-window.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		e = _inner_error_;
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_inner_error_ = NULL;
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_error_free0 (e);
#line 2794 "klotski-window.c"
	}
	__finally5:
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_free0 (filename);
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_g_key_file_unref0 (keyfile);
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		g_clear_error (&_inner_error_);
#line 866 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		return;
#line 2809 "klotski-window.c"
	}
	{
		gint i = 0;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 2815 "klotski-window.c"
		{
			gboolean _tmp3_ = FALSE;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp3_ = TRUE;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 2822 "klotski-window.c"
				gint _tmp5_ = 0;
				gchar* key = NULL;
				gint _tmp6_ = 0;
				gchar* _tmp7_ = NULL;
				gboolean value = FALSE;
				GtkTreeIter* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				GtkTreeIter _tmp13_ = {0};
				gboolean _tmp14_ = FALSE;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!_tmp3_) {
#line 2835 "klotski-window.c"
					gint _tmp4_ = 0;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp4_ = i;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					i = _tmp4_ + 1;
#line 2841 "klotski-window.c"
				}
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp3_ = FALSE;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp5_ = i;
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp5_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					break;
#line 2851 "klotski-window.c"
				}
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = i;
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = klotski_window_get_level_key (self, _tmp6_);
#line 876 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				key = _tmp7_;
#line 877 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				value = FALSE;
#line 2861 "klotski-window.c"
				{
					gboolean _tmp8_ = FALSE;
					const gchar* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
#line 880 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp9_ = key;
#line 880 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp10_ = g_key_file_get_boolean (keyfile, _tmp9_, "solved", &_inner_error_);
#line 880 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp8_ = _tmp10_;
#line 880 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2874 "klotski-window.c"
						goto __catch6_g_error;
					}
#line 880 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					value = _tmp8_;
#line 2879 "klotski-window.c"
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					e = _inner_error_;
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_inner_error_ = NULL;
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_g_error_free0 (e);
#line 2891 "klotski-window.c"
				}
				__finally6:
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_g_free0 (key);
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_g_free0 (filename);
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_g_key_file_unref0 (keyfile);
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					g_clear_error (&_inner_error_);
#line 878 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					return;
#line 2908 "klotski-window.c"
				}
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp11_ = self->priv->puzzles_items;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp11__length1 = self->priv->puzzles_items_length1;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp12_ = i;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp14_ = value;
#line 886 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				klotski_window_puzzle_solved (self, &_tmp13_, _tmp14_);
#line 874 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_g_free0 (key);
#line 2924 "klotski-window.c"
			}
		}
	}
#line 862 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_free0 (filename);
#line 862 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_key_file_unref0 (keyfile);
#line 2932 "klotski-window.c"
}


static void klotski_window_puzzle_solved (KlotskiWindow* self, GtkTreeIter* iter, gboolean solved) {
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (self != NULL);
#line 890 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_return_if_fail (iter != NULL);
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = self->priv->liststore_huarong;
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp1_ = *iter;
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp2_ = gtk_list_store_iter_is_valid (_tmp0_, &_tmp1_);
#line 892 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	if (_tmp2_) {
#line 2952 "klotski-window.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp3_ = self->priv->liststore_huarong;
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp4_ = *iter;
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp5_ = solved;
#line 893 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		gtk_list_store_set (_tmp3_, &_tmp4_, 1, _tmp5_, -1);
#line 2964 "klotski-window.c"
	} else {
		GtkListStore* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp6_ = self->priv->liststore_challenge;
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp7_ = *iter;
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		_tmp8_ = gtk_list_store_iter_is_valid (_tmp6_, &_tmp7_);
#line 894 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		if (_tmp8_) {
#line 2977 "klotski-window.c"
			GtkListStore* _tmp9_ = NULL;
			GtkTreeIter _tmp10_ = {0};
			gboolean _tmp11_ = FALSE;
#line 895 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp9_ = self->priv->liststore_challenge;
#line 895 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp10_ = *iter;
#line 895 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp11_ = solved;
#line 895 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			gtk_list_store_set (_tmp9_, &_tmp10_, 1, _tmp11_, -1);
#line 2989 "klotski-window.c"
		} else {
			GtkListStore* _tmp12_ = NULL;
			GtkTreeIter _tmp13_ = {0};
			gboolean _tmp14_ = FALSE;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp12_ = self->priv->liststore_skill;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp13_ = *iter;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp14_ = solved;
#line 897 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			gtk_list_store_set (_tmp12_, &_tmp13_, 1, _tmp14_, -1);
#line 3002 "klotski-window.c"
		}
	}
}


static void klotski_window_base_init (KlotskiWindowClass * klass) {
	GeeArrayList* _tmp0_ = NULL;
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_tmp0_ = gee_array_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (klotski_window_score_categories);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_score_categories = (GeeList*) _tmp0_;
#line 3016 "klotski-window.c"
	{
		gint i = 0;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
		i = 0;
#line 3021 "klotski-window.c"
		{
			gboolean _tmp1_ = FALSE;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			_tmp1_ = TRUE;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
			while (TRUE) {
#line 3028 "klotski-window.c"
				gint _tmp3_ = 0;
				GeeList* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				LevelInfo _tmp6_ = {0};
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				LevelInfo _tmp11_ = {0};
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				GamesScoresCategory* _tmp14_ = NULL;
				GamesScoresCategory* _tmp15_ = NULL;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!_tmp1_) {
#line 3044 "klotski-window.c"
					gint _tmp2_ = 0;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					_tmp2_ = i;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					i = _tmp2_ + 1;
#line 3050 "klotski-window.c"
				}
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp1_ = FALSE;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp3_ = i;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				if (!(_tmp3_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
					break;
#line 3060 "klotski-window.c"
				}
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp4_ = klotski_window_score_categories;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp5_ = i;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp6_ = KLOTSKI_WINDOW_levels[_tmp5_];
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp7_ = _tmp6_.name;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp8_ = klotski_window_normalize_map_name (_tmp7_);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp9_ = _tmp8_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp10_ = i;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp11_ = KLOTSKI_WINDOW_levels[_tmp10_];
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp12_ = _tmp11_.name;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp13_ = _ (_tmp12_);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp14_ = games_scores_category_new (_tmp9_, _tmp13_);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_tmp15_ = _tmp14_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				gee_collection_add ((GeeCollection*) _tmp4_, _tmp15_);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_g_object_unref0 (_tmp15_);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
				_g_free0 (_tmp9_);
#line 3092 "klotski-window.c"
			}
		}
	}
}


static void klotski_window_class_init (KlotskiWindowClass * klass) {
	gint KlotskiWindow_private_offset;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	klotski_window_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	g_type_class_add_private (klass, sizeof (KlotskiWindowPrivate));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	G_OBJECT_CLASS (klass)->finalize = klotski_window_finalize;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	KlotskiWindow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/klotski/ui/klotski.ui");
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, headerbar));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_packs", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_packs));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_puzzles", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_puzzles));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "puzzles_popover", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, puzzles_popover));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_huarong", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_huarong));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_challenge", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_challenge));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_skill", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_skill));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_klotski_window_on_size_allocate_gtk_widget_size_allocate));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_klotski_window_on_window_state_event_gtk_widget_window_state_event));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_klotski_window_on_destroy_gtk_widget_destroy));
#line 3131 "klotski-window.c"
}


static void klotski_window_instance_init (KlotskiWindow * self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv = KLOTSKI_WINDOW_GET_PRIVATE (self);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_pack = -1;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->current_level = -1;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3144 "klotski-window.c"
}


static void klotski_window_finalize (GObject* obj) {
	KlotskiWindow * self;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI_WINDOW, KlotskiWindow);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->settings);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->stack_packs);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->stack_puzzles);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->puzzles_popover);
#line 40 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->view);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->treeview_huarong);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->treeview_challenge);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->treeview_skill);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_pack);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_pack);
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->prev_puzzle);
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->next_puzzle);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->start_game);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->puzzle);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_huarong);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_challenge);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	_g_object_unref0 (self->priv->liststore_skill);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-klotski/src/klotski-window.vala"
	G_OBJECT_CLASS (klotski_window_parent_class)->finalize (obj);
#line 3194 "klotski-window.c"
}


GType klotski_window_get_type (void) {
	static volatile gsize klotski_window_type_id__volatile = 0;
	if (g_once_init_enter (&klotski_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KlotskiWindowClass), (GBaseInitFunc) klotski_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) klotski_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KlotskiWindow), 0, (GInstanceInitFunc) klotski_window_instance_init, NULL };
		GType klotski_window_type_id;
		klotski_window_type_id = g_type_register_static (gtk_application_window_get_type (), "KlotskiWindow", &g_define_type_info, 0);
		g_once_init_leave (&klotski_window_type_id__volatile, klotski_window_type_id);
	}
	return klotski_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



