/* taquin-main.c generated by valac 0.30.0, the Vala compiler
 * generated from taquin-main.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2015 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_TAQUIN (taquin_get_type ())
#define TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN, Taquin))
#define TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN, TaquinClass))
#define IS_TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN))
#define IS_TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN))
#define TAQUIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN, TaquinClass))

typedef struct _Taquin Taquin;
typedef struct _TaquinClass TaquinClass;
typedef struct _TaquinPrivate TaquinPrivate;

#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _Taquin {
	GtkApplication parent_instance;
	TaquinPrivate * priv;
};

struct _TaquinClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

struct _TaquinPrivate {
	GSettings* settings;
	GameType* tmp_type;
	gboolean size_changed;
	gboolean theme_changed;
	GameWindow* window;
	GtkMenuButton* size_button;
	GtkMenuButton* theme_button;
	TaquinView* view;
	Game* game;
	GList* theme_dirlist;
};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer taquin_parent_class = NULL;
static gint taquin_tmp_size;
static gint taquin_tmp_size = 0;
static gboolean* taquin_sound;
static gboolean* taquin_sound = NULL;

GType taquin_get_type (void) G_GNUC_CONST;
GType game_type_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType taquin_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define TAQUIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAQUIN, TaquinPrivate))
enum  {
	TAQUIN_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void taquin_change_size_cb (Taquin* self, GSimpleAction* action, GVariant* variant);
static void _taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_change_theme_cb (Taquin* self, GSimpleAction* action, GVariant* variant);
static void _taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_help_cb (Taquin* self);
static void _taquin_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_about_cb (Taquin* self);
static void _taquin_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint taquin_main (gchar** args, int args_length1);
static Taquin* taquin_new (void);
static Taquin* taquin_construct (GType object_type);
static gint taquin_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static GameType* _game_type_dup (GameType* self);
static void taquin_real_startup (GApplication* base);
gchar* game_type_to_string (GameType self);
TaquinView* taquin_view_new (void);
TaquinView* taquin_view_construct (GType object_type);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
static void taquin_start_game (Taquin* self);
static void _taquin_start_game_game_window_play (GameWindow* _sender, gpointer self);
static void taquin_undo_cb (Taquin* self);
static void _taquin_undo_cb_game_window_undo (GameWindow* _sender, gpointer self);
static void __lambda5_ (Taquin* self);
static void taquin_update_size_button_label (Taquin* self, gint size);
static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda6_ (Taquin* self);
static void taquin_update_theme (Taquin* self, const gchar* theme);
static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void taquin_real_activate (GApplication* base);
static void taquin_real_shutdown (GApplication* base);
void game_window_shutdown (GameWindow* self, GSettings* settings);
Game* game_new (GameType game_type, gint size);
Game* game_construct (GType object_type, GameType game_type, gint size);
void taquin_view_set_game (TaquinView* self, Game* value);
void taquin_view_set_theme (TaquinView* self, const gchar* value);
static void taquin_game_complete_cb (Taquin* self);
static void _taquin_game_complete_cb_game_complete (Game* _sender, gpointer self);
static void taquin_cannot_move_cb (Taquin* self);
static void _taquin_cannot_move_cb_game_cannot_move (Game* _sender, gint x, gint y, gpointer self);
void game_window_cannot_undo_more (GameWindow* self);
static void _game_window_cannot_undo_more_game_cannot_undo_more (Game* _sender, gpointer self);
static void taquin_move_cb (Taquin* self);
static void _taquin_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self);
void game_undo (Game* self);
static void taquin_play_sound (Taquin* self, const gchar* name);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
void game_window_finish_game (GameWindow* self);
static void taquin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry TAQUIN_option_entries[7] = {{"fifteen", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play the classical 1880s’ 15-puzzle", NULL}, {"sixteen", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Try this fun alternative 16-puzzle", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &taquin_tmp_size, "Sets the puzzle edges’ size (3-5, 2-9 for debug)", NULL}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry TAQUIN_app_actions[5] = {{"change-size", _taquin_change_size_cb_gsimple_action_activate_callback, "s"}, {"change-theme", _taquin_change_theme_cb_gsimple_action_activate_callback, "s"}, {"help", _taquin_help_cb_gsimple_action_activate_callback}, {"about", _taquin_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static void _g_free0_ (gpointer var) {
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	var = (g_free (var), NULL);
#line 214 "taquin-main.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_list_free (self);
#line 223 "taquin-main.c"
}


static void _taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_change_size_cb ((Taquin*) self, action, parameter);
#line 230 "taquin-main.c"
}


static void _taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_change_theme_cb ((Taquin*) self, action, parameter);
#line 237 "taquin-main.c"
}


static void _taquin_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_help_cb ((Taquin*) self);
#line 244 "taquin-main.c"
}


static void _taquin_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_about_cb ((Taquin*) self);
#line 251 "taquin-main.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_application_quit ((GApplication*) self);
#line 258 "taquin-main.c"
}


gint taquin_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Taquin* _tmp1_ = NULL;
	Taquin* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	setlocale (LC_ALL, "");
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = _ ("Taquin");
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_set_application_name (_tmp0_);
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_window_set_default_icon_name ("gnome-taquin");
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = taquin_new ();
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = _tmp1_;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = args;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3__length1 = args_length1;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = _tmp4_;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (_tmp2_);
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	result = _tmp5_;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return result;
#line 303 "taquin-main.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 69 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return taquin_main (argv, argc);
#line 313 "taquin-main.c"
}


static Taquin* taquin_construct (GType object_type) {
	Taquin * self = NULL;
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) g_object_new (object_type, "application-id", "org.gnome.taquin", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_application_add_main_option_entries ((GApplication*) self, TAQUIN_option_entries);
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self;
#line 325 "taquin-main.c"
}


static Taquin* taquin_new (void) {
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return taquin_construct (TYPE_TAQUIN);
#line 332 "taquin-main.c"
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	dup = g_new0 (gboolean, 1);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return dup;
#line 344 "taquin-main.c"
}


static gpointer __bool_dup0 (gpointer self) {
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self ? _bool_dup (self) : NULL;
#line 351 "taquin-main.c"
}


static GameType* _game_type_dup (GameType* self) {
	GameType* dup;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	dup = g_new0 (GameType, 1);
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	memcpy (dup, self, sizeof (GameType));
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return dup;
#line 363 "taquin-main.c"
}


static gpointer __game_type_dup0 (gpointer self) {
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self ? _game_type_dup (self) : NULL;
#line 370 "taquin-main.c"
}


static gint taquin_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Taquin * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = options;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp1_) {
#line 395 "taquin-main.c"
		FILE* _tmp2_ = NULL;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = stdout;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-taquin", VERSION);
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		result = EXIT_SUCCESS;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return result;
#line 405 "taquin-main.c"
	}
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = taquin_tmp_size;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp4_ != 0) {
#line 411 "taquin-main.c"
		gint _tmp5_ = 0;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp5_ = taquin_tmp_size;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = _tmp5_ < 2;
#line 417 "taquin-main.c"
	} else {
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = FALSE;
#line 421 "taquin-main.c"
	}
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp3_) {
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_tmp_size = 2;
#line 427 "taquin-main.c"
	}
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = options;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = g_variant_dict_contains (_tmp6_, "mute");
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp7_) {
#line 435 "taquin-main.c"
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = FALSE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp9_ = __bool_dup0 (&_tmp8_);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (taquin_sound);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_sound = _tmp9_;
#line 446 "taquin-main.c"
	} else {
		GVariantDict* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp10_ = options;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp11_ = g_variant_dict_contains (_tmp10_, "unmute");
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (_tmp11_) {
#line 456 "taquin-main.c"
			gboolean _tmp12_ = FALSE;
			gboolean* _tmp13_ = NULL;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp12_ = TRUE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp13_ = __bool_dup0 (&_tmp12_);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (taquin_sound);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			taquin_sound = _tmp13_;
#line 467 "taquin-main.c"
		}
	}
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp14_ = options;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp15_ = g_variant_dict_contains (_tmp14_, "fifteen");
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp15_) {
#line 476 "taquin-main.c"
		GameType _tmp16_ = 0;
		GameType* _tmp17_ = NULL;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp16_ = GAME_TYPE_FIFTEEN;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp17_ = __game_type_dup0 (&_tmp16_);
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (self->priv->tmp_type);
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		self->priv->tmp_type = _tmp17_;
#line 487 "taquin-main.c"
	} else {
		GVariantDict* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp18_ = options;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp19_ = g_variant_dict_contains (_tmp18_, "sixteen");
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (_tmp19_) {
#line 497 "taquin-main.c"
			GameType _tmp20_ = 0;
			GameType* _tmp21_ = NULL;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp20_ = GAME_TYPE_SIXTEEN;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp21_ = __game_type_dup0 (&_tmp20_);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (self->priv->tmp_type);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			self->priv->tmp_type = _tmp21_;
#line 508 "taquin-main.c"
		}
	}
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	result = -1;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return result;
#line 515 "taquin-main.c"
}


static void _taquin_start_game_game_window_play (GameWindow* _sender, gpointer self) {
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_start_game ((Taquin*) self);
#line 522 "taquin-main.c"
}


static void _taquin_undo_cb_game_window_undo (GameWindow* _sender, gpointer self) {
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_undo_cb ((Taquin*) self);
#line 529 "taquin-main.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self ? g_object_ref (self) : NULL;
#line 536 "taquin-main.c"
}


static void __lambda5_ (Taquin* self) {
	gboolean _tmp0_ = FALSE;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->size_changed;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (!_tmp0_) {
#line 546 "taquin-main.c"
		GSettings* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = self->priv->settings;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = g_settings_get_int (_tmp1_, "size");
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_update_size_button_label (self, _tmp2_);
#line 555 "taquin-main.c"
	}
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_changed = FALSE;
#line 559 "taquin-main.c"
}


static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__lambda5_ ((Taquin*) self);
#line 566 "taquin-main.c"
}


static void __lambda6_ (Taquin* self) {
	gboolean _tmp0_ = FALSE;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->theme_changed;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (!_tmp0_) {
#line 576 "taquin-main.c"
		GSettings* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = self->priv->settings;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = g_settings_get_string (_tmp1_, "theme");
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = _tmp2_;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_update_theme (self, _tmp3_);
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (_tmp3_);
#line 590 "taquin-main.c"
	}
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_changed = FALSE;
#line 594 "taquin-main.c"
}


static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__lambda6_ ((Taquin*) self);
#line 601 "taquin-main.c"
}


static void taquin_real_startup (GApplication* base) {
	Taquin * self;
	GSettings* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	GameType* _tmp7_ = NULL;
	TaquinView* _tmp12_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GSettings* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GObject* _tmp21_ = NULL;
	TaquinView* _tmp22_ = NULL;
	GameWindow* _tmp23_ = NULL;
	GameWindow* _tmp24_ = NULL;
	GameWindow* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gchar* _tmp35_ = NULL;
	gchar** _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	gchar* _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	GObject* _tmp41_ = NULL;
	GtkMenuButton* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	GObject* _tmp46_ = NULL;
	GtkMenuButton* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	GSettings* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	GSettings* _tmp52_ = NULL;
	GAction* _tmp53_ = NULL;
	GAction* _tmp54_ = NULL;
	GSettings* _tmp55_ = NULL;
	GAction* _tmp56_ = NULL;
	GAction* _tmp57_ = NULL;
	GameWindow* _tmp58_ = NULL;
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_APPLICATION_CLASS (taquin_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = g_settings_new ("org.gnome.taquin");
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->settings);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->settings = _tmp0_;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = taquin_sound;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp1_ != NULL) {
#line 678 "taquin-main.c"
		GSettings* _tmp2_ = NULL;
		gboolean* _tmp3_ = NULL;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = self->priv->settings;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = taquin_sound;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_settings_set_boolean (_tmp2_, "sound", *_tmp3_);
#line 687 "taquin-main.c"
	}
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = taquin_tmp_size;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp4_ > 1) {
#line 693 "taquin-main.c"
		GSettings* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp5_ = self->priv->settings;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp6_ = taquin_tmp_size;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_settings_set_int (_tmp5_, "size", _tmp6_);
#line 702 "taquin-main.c"
	}
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = self->priv->tmp_type;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp7_ != NULL) {
#line 708 "taquin-main.c"
		GSettings* _tmp8_ = NULL;
		GameType* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = self->priv->settings;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp9_ = self->priv->tmp_type;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp10_ = game_type_to_string (*_tmp9_);
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp11_ = _tmp10_;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_settings_set_string (_tmp8_, "type", _tmp11_);
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (_tmp11_);
#line 725 "taquin-main.c"
	}
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp12_ = taquin_view_new ();
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_object_ref_sink (_tmp12_);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->view);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->view = _tmp12_;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp13_ = gtk_builder_new_from_resource ("/org/gnome/taquin/ui/taquin-screens.ui");
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	builder = _tmp13_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp14_ = _ ("Taquin");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp15_ = self->priv->settings;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp16_ = g_settings_get_int (_tmp15_, "window-width");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp17_ = self->priv->settings;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp18_ = g_settings_get_int (_tmp17_, "window-height");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp19_ = self->priv->settings;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp20_ = g_settings_get_boolean (_tmp19_, "window-is-maximized");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp21_ = gtk_builder_get_object (builder, "new-game-screen");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp22_ = self->priv->view;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp23_ = game_window_new ("/org/gnome/taquin/ui/taquin.css", _tmp14_, _tmp16_, _tmp18_, _tmp20_, TRUE, GAME_WINDOW_FLAGS_SHOW_UNDO | GAME_WINDOW_FLAGS_SHOW_START_BUTTON, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp22_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_object_ref_sink (_tmp23_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->window);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->window = _tmp23_;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp24_ = self->priv->window;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp24_, "play", (GCallback) _taquin_start_game_game_window_play, self, 0);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp25_ = self->priv->window;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp25_, "undo", (GCallback) _taquin_undo_cb_game_window_undo, self, 0);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp26_ = g_strdup ("<Primary>n");
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp27_ = g_new0 (gchar*, 1 + 1);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp27_[0] = _tmp26_;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp28_ = _tmp27_;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp28__length1 = 1;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp28_);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp29_ = g_strdup ("<Primary><Shift>n");
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp30_ = g_new0 (gchar*, 1 + 1);
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp30_[0] = _tmp29_;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp31_ = _tmp30_;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp31__length1 = 1;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp31_);
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp32_ = g_strdup ("<Primary>z");
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp33_ = g_new0 (gchar*, 1 + 1);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp33_[0] = _tmp32_;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp34_ = _tmp33_;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp34__length1 = 1;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp34_);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp35_ = g_strdup ("<Primary><Shift>z");
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp36_ = g_new0 (gchar*, 1 + 1);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp36_[0] = _tmp35_;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp37_ = _tmp36_;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp37__length1 = 1;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp37_);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp38_ = g_strdup ("Escape");
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp39_ = g_new0 (gchar*, 1 + 1);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp39_[0] = _tmp38_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp40_ = _tmp39_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp40__length1 = 1;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp40_);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp41_ = gtk_builder_get_object (builder, "size-button");
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_menu_button_get_type (), GtkMenuButton));
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->size_button);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_button = _tmp42_;
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp43_ = self->priv->settings;
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp43_, "changed::size", (GCallback) ___lambda5__g_settings_changed, self, 0);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp44_ = self->priv->settings;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp45_ = g_settings_get_int (_tmp44_, "size");
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_size_button_label (self, _tmp45_);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp46_ = gtk_builder_get_object (builder, "theme-button");
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_menu_button_get_type (), GtkMenuButton));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->theme_button);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_button = _tmp47_;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp48_ = self->priv->settings;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp48_, "changed::theme", (GCallback) ___lambda6__g_settings_changed, self, 0);
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp49_ = self->priv->settings;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp50_ = g_settings_get_string (_tmp49_, "theme");
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp51_ = _tmp50_;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_theme (self, _tmp51_);
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp51_);
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_action_map_add_action_entries ((GActionMap*) self, TAQUIN_app_actions, G_N_ELEMENTS (TAQUIN_app_actions), self);
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp52_ = self->priv->settings;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp53_ = g_settings_create_action (_tmp52_, "sound");
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp54_ = _tmp53_;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp54_);
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (_tmp54_);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp55_ = self->priv->settings;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp56_ = g_settings_create_action (_tmp55_, "type");
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp57_ = _tmp56_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp57_);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (_tmp57_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp58_ = self->priv->window;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp58_);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_start_game (self);
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (builder);
#line 913 "taquin-main.c"
}


static void taquin_real_activate (GApplication* base) {
	Taquin * self;
	GameWindow* _tmp0_ = NULL;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 926 "taquin-main.c"
}


static void taquin_real_shutdown (GApplication* base) {
	Taquin * self;
	GameWindow* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = self->priv->settings;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_shutdown (_tmp0_, _tmp1_);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_APPLICATION_CLASS (taquin_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 944 "taquin-main.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 962 "taquin-main.c"
}


static void _taquin_game_complete_cb_game_complete (Game* _sender, gpointer self) {
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_game_complete_cb ((Taquin*) self);
#line 969 "taquin-main.c"
}


static void _taquin_cannot_move_cb_game_cannot_move (Game* _sender, gint x, gint y, gpointer self) {
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_cannot_move_cb ((Taquin*) self);
#line 976 "taquin-main.c"
}


static void _game_window_cannot_undo_more_game_cannot_undo_more (Game* _sender, gpointer self) {
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_cannot_undo_more ((GameWindow*) self);
#line 983 "taquin-main.c"
}


static void _taquin_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self) {
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_move_cb ((Taquin*) self);
#line 990 "taquin-main.c"
}


static void taquin_start_game (Taquin* self) {
	Game* _tmp0_ = NULL;
	GameType type = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint size = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GameType _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	TaquinView* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	gchar* filename = NULL;
	gchar* _tmp11_ = NULL;
	GList* dirlist = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	TaquinView* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	TaquinView* _tmp49_ = NULL;
	Game* _tmp50_ = NULL;
	Game* _tmp51_ = NULL;
	Game* _tmp52_ = NULL;
	GameWindow* _tmp53_ = NULL;
	Game* _tmp54_ = NULL;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->game;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp0_ != NULL) {
#line 1031 "taquin-main.c"
		Game* _tmp1_ = NULL;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = self->priv->game;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1037 "taquin-main.c"
	}
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = self->priv->settings;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = g_settings_get_enum (_tmp2_, "type");
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	type = (GameType) _tmp3_;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = self->priv->settings;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = g_settings_get_int (_tmp4_, "size");
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	size = _tmp5_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = type;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = size;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp8_ = game_new (_tmp6_, _tmp7_);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->game);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->game = _tmp8_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_ = self->priv->view;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp10_ = self->priv->game;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_view_set_game (_tmp9_, _tmp10_);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_ = g_strdup ("");
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	filename = _tmp11_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp12_ = self->priv->theme_dirlist;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp13_ = g_list_copy (_tmp12_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	dirlist = _tmp13_;
#line 1077 "taquin-main.c"
	{
		gboolean _tmp14_ = FALSE;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp14_ = TRUE;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		while (TRUE) {
#line 1084 "taquin-main.c"
			gint random = 0;
			GList* _tmp30_ = NULL;
			guint _tmp31_ = 0U;
			gint32 _tmp32_ = 0;
			GList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gconstpointer _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GList* entry = NULL;
			GList* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			GCompareFunc _tmp39_ = NULL;
			GList* _tmp40_ = NULL;
			GList* _tmp41_ = NULL;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			if (!_tmp14_) {
#line 1101 "taquin-main.c"
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp16_ = NULL;
				gchar _tmp17_ = '\0';
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp16_ = filename;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp17_ = string_get (_tmp16_, (glong) 0);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				if (_tmp17_ == '0') {
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp15_ = TRUE;
#line 1113 "taquin-main.c"
				} else {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					const gchar* _tmp20_ = NULL;
					gchar _tmp21_ = '\0';
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp20_ = filename;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp21_ = string_get (_tmp20_, (glong) 0);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					if (_tmp21_ != '1') {
#line 1125 "taquin-main.c"
						const gchar* _tmp22_ = NULL;
						gchar _tmp23_ = '\0';
						gint _tmp24_ = 0;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar _tmp27_ = '\0';
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp22_ = filename;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp23_ = string_get (_tmp22_, (glong) 0);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp24_ = size;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp25_ = g_strdup_printf ("%i", _tmp24_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp26_ = _tmp25_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp27_ = string_get (_tmp26_, (glong) 0);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp19_ = _tmp23_ != _tmp27_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_g_free0 (_tmp26_);
#line 1148 "taquin-main.c"
					} else {
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp19_ = FALSE;
#line 1152 "taquin-main.c"
					}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					if (_tmp19_) {
#line 1156 "taquin-main.c"
						GList* _tmp28_ = NULL;
						guint _tmp29_ = 0U;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp28_ = dirlist;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp29_ = g_list_length (_tmp28_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp18_ = _tmp29_ != ((guint) 0);
#line 1165 "taquin-main.c"
					} else {
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp18_ = FALSE;
#line 1169 "taquin-main.c"
					}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp15_ = _tmp18_;
#line 1173 "taquin-main.c"
				}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				if (!_tmp15_) {
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					break;
#line 1179 "taquin-main.c"
				}
			}
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp14_ = FALSE;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp30_ = dirlist;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp31_ = g_list_length (_tmp30_);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp32_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp31_));
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			random = (gint) _tmp32_;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp33_ = dirlist;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp34_ = random;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp35_ = g_list_nth_data (_tmp33_, (guint) _tmp34_);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp36_ = g_strdup ((const gchar*) _tmp35_);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (filename);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			filename = _tmp36_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp37_ = dirlist;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp38_ = filename;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp39_ = g_strcmp0;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp40_ = g_list_find_custom (_tmp37_, _tmp38_, _tmp39_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			entry = _tmp40_;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp41_ = entry;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			dirlist = g_list_remove_link (dirlist, _tmp41_);
#line 1218 "taquin-main.c"
		}
	}
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp42_ = self->priv->view;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp43_ = self->priv->settings;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp44_ = g_settings_get_string (_tmp43_, "theme");
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp45_ = _tmp44_;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp46_ = filename;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp47_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp45_, _tmp46_, NULL);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp48_ = _tmp47_;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_view_set_theme (_tmp42_, _tmp48_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp48_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp45_);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp49_ = self->priv->view;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_widget_realize ((GtkWidget*) _tmp49_);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp50_ = self->priv->game;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp50_, "complete", (GCallback) _taquin_game_complete_cb_game_complete, self, 0);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp51_ = self->priv->game;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp51_, "cannot-move", (GCallback) _taquin_cannot_move_cb_game_cannot_move, self, 0);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp52_ = self->priv->game;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp53_ = self->priv->window;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp52_, "cannot-undo-more", (GCallback) _game_window_cannot_undo_more_game_cannot_undo_more, _tmp53_, 0);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp54_ = self->priv->game;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp54_, "move", (GCallback) _taquin_move_cb_game_move, self, 0);
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_list_free0 (dirlist);
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (filename);
#line 1267 "taquin-main.c"
}


static void taquin_about_cb (Taquin* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GameWindow* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = g_strdup ("Arnaud Bonatti");
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_new0 (gchar*, 2 + 1);
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_[0] = _tmp0_;
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_[1] = NULL;
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	authors = _tmp1_;
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	authors_length1 = 2;
#line 227 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_authors_size_ = authors_length1;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = g_strdup ("Ola Einang (Flickr)");
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = g_strdup ("Ruskis (Wikimedia)");
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = g_strdup ("Alvesgaspar (Wikimedia)");
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = g_strdup ("Mark J. Sebastian (Flickr)");
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = g_strdup ("Mueller-rech.muenchen (Wikimedia)");
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = _ ("(see COPYING.themes for informations)");
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_ = g_new0 (gchar*, 7 + 1);
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[0] = _tmp2_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[1] = _tmp3_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[2] = _tmp4_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[3] = _tmp5_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[4] = _tmp6_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[5] = _tmp8_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[6] = NULL;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	artists = _tmp9_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	artists_length1 = 7;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_artists_size_ = artists_length1;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp10_ = g_strdup ("Arnaud Bonatti");
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_ = g_new0 (gchar*, 2 + 1);
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_[0] = _tmp10_;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_[1] = NULL;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	documenters = _tmp11_;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	documenters_length1 = 2;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_documenters_size_ = documenters_length1;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp12_ = self->priv->window;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp13_ = _ ("Taquin");
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp14_ = _ ("A classic 15-puzzle game");
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp15_ = _ ("translator-credits");
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp12_, "name", _tmp13_, "version", VERSION, "copyright", "Copyright © 2014-2015 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp14_, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp15_, "logo-icon-name", "gnome-taquin", "website", "https://wiki.gnome.org/Apps/Taquin", NULL, NULL);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1379 "taquin-main.c"
}


static void taquin_help_cb (Taquin* self) {
	GError * _inner_error_ = NULL;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 1387 "taquin-main.c"
	{
		GameWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp0_ = self->priv->window;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		gtk_show_uri (_tmp1_, "help:gnome-taquin", _tmp2_, &_inner_error_);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1402 "taquin-main.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		e = _inner_error_;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_inner_error_ = NULL;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = e;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp4_ = _tmp3_->message;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_warning ("taquin-main.vala:259: Failed to show help: %s", _tmp4_);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_error_free0 (e);
#line 1424 "taquin-main.c"
	}
	__finally0:
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_clear_error (&_inner_error_);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return;
#line 1435 "taquin-main.c"
	}
}


static void taquin_undo_cb (Taquin* self) {
	Game* _tmp0_ = NULL;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->game;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_undo (_tmp0_);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_play_sound (self, "sliding-1");
#line 1450 "taquin-main.c"
}


static void taquin_move_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	GameWindow* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_set_subtitle (_tmp0_, NULL);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = self->priv->window;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = _tmp1_->undo_action;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_simple_action_set_enabled (_tmp2_, TRUE);
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_play_sound (self, "sliding-1");
#line 1472 "taquin-main.c"
}


static void taquin_cannot_move_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = _ ("You can’t move this tile!");
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_set_subtitle (_tmp0_, _tmp1_);
#line 1487 "taquin-main.c"
}


static void taquin_game_complete_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	GameWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GameWindow* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_finish_game (_tmp0_);
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = self->priv->window;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = _ ("Bravo! You finished the game!");
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_set_subtitle (_tmp1_, _tmp2_);
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = self->priv->window;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = _tmp3_->undo_action;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_simple_action_set_enabled (_tmp4_, FALSE);
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_play_sound (self, "gameover");
#line 1517 "taquin-main.c"
}


static void taquin_change_size_cb (Taquin* self, GSimpleAction* action, GVariant* variant) {
	gint size = 0;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (action != NULL);
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_changed = TRUE;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = variant;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = atoi (_tmp1_);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	size = _tmp2_;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_size_button_label (self, size);
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = self->priv->settings;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_settings_set_int (_tmp3_, "size", size);
#line 1547 "taquin-main.c"
}


static void taquin_update_size_button_label (Taquin* self, gint size) {
	GtkMenuButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->size_button;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = _ ("Size: %d × %d ▾");
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = size;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = size;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp2_, _tmp3_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = _tmp4_;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_button_set_label ((GtkButton*) _tmp0_, _tmp5_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp5_);
#line 1576 "taquin-main.c"
}


static void taquin_change_theme_cb (Taquin* self, GSimpleAction* action, GVariant* variant) {
	gchar* name = NULL;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (action != NULL);
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_changed = TRUE;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = variant;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	name = _tmp2_;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_theme (self, name);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = self->priv->settings;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_settings_set_string (_tmp3_, "theme", name);
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (name);
#line 1608 "taquin-main.c"
}


static void taquin_update_theme (Taquin* self, const gchar* theme) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	static GQuark _tmp2_label0 = 0;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	static GQuark _tmp2_label1 = 0;
#line 1620 "taquin-main.c"
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (theme != NULL);
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = theme;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = _tmp0_;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("cats")))) {
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		switch (0) {
#line 1637 "taquin-main.c"
			default:
			{
				GtkMenuButton* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp4_ = self->priv->theme_button;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp5_ = _ ("Theme: Cats ▾");
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				gtk_button_set_label ((GtkButton*) _tmp4_, _tmp5_);
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1650 "taquin-main.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("numbers")))) {
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		switch (0) {
#line 1656 "taquin-main.c"
			default:
			{
				GtkMenuButton* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp6_ = self->priv->theme_button;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp7_ = _ ("Theme: Numbers ▾");
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				gtk_button_set_label ((GtkButton*) _tmp6_, _tmp7_);
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1669 "taquin-main.c"
			}
		}
	} else {
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		switch (0) {
#line 1675 "taquin-main.c"
			default:
			{
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				g_warn_if_reached ();
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1682 "taquin-main.c"
			}
		}
	}
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__g_list_free__g_free0_0 (self->priv->theme_dirlist);
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_dirlist = NULL;
#line 1690 "taquin-main.c"
	{
		GDir* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GDir* _tmp12_ = NULL;
		GDir* _tmp13_ = NULL;
		GDir* _tmp14_ = NULL;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp9_ = theme;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp10_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp9_, NULL);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp11_ = _tmp10_;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp12_ = g_dir_open (_tmp11_, (guint) 0, &_inner_error_);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp13_ = _tmp12_;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (_tmp11_);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = _tmp13_;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 1717 "taquin-main.c"
				goto __catch1_g_file_error;
			}
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_dir_close0 (dir);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			g_clear_error (&_inner_error_);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			return;
#line 1728 "taquin-main.c"
		}
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp14_ = _tmp8_;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = NULL;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_dir_close0 (dir);
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		dir = _tmp14_;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		while (TRUE) {
#line 1740 "taquin-main.c"
			gchar* filename = NULL;
			GDir* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp15_ = dir;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp16_ = g_dir_read_name (_tmp15_);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp17_ = g_strdup (_tmp16_);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			filename = _tmp17_;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp18_ = filename;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			if (_tmp18_ == NULL) {
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_g_free0 (filename);
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1764 "taquin-main.c"
			}
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp19_ = filename;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp20_ = g_strdup (_tmp19_);
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			self->priv->theme_dirlist = g_list_append (self->priv->theme_dirlist, _tmp20_);
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (filename);
#line 1774 "taquin-main.c"
		}
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_dir_close0 (_tmp8_);
#line 1778 "taquin-main.c"
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		e = _inner_error_;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_inner_error_ = NULL;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp21_ = e;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp22_ = _tmp21_->message;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_warning ("taquin-main.vala:344: Failed to load images: %s", _tmp22_);
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_error_free0 (e);
#line 1798 "taquin-main.c"
	}
	__finally1:
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_dir_close0 (dir);
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_clear_error (&_inner_error_);
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return;
#line 1811 "taquin-main.c"
	}
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_dir_close0 (dir);
#line 1815 "taquin-main.c"
}


static void taquin_play_sound (Taquin* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	TaquinView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (name != NULL);
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->settings;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (!_tmp1_) {
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return;
#line 1841 "taquin-main.c"
	}
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = self->priv->view;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = name;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = name;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = _tmp5_;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp8_ = _tmp7_;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp8_);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp6_);
#line 1863 "taquin-main.c"
}


static void taquin_class_init (TaquinClass * klass) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_parent_class = g_type_class_peek_parent (klass);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_type_class_add_private (klass, sizeof (TaquinPrivate));
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->handle_local_options = taquin_real_handle_local_options;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->startup = taquin_real_startup;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->activate = taquin_real_activate;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->shutdown = taquin_real_shutdown;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_OBJECT_CLASS (klass)->finalize = taquin_finalize;
#line 1882 "taquin-main.c"
}


static void taquin_instance_init (Taquin * self) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv = TAQUIN_GET_PRIVATE (self);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->tmp_type = NULL;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_changed = FALSE;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_changed = FALSE;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->game = NULL;
#line 1897 "taquin-main.c"
}


static void taquin_finalize (GObject* obj) {
	Taquin * self;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN, Taquin);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->settings);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (self->priv->tmp_type);
#line 34 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->window);
#line 35 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->size_button);
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->theme_button);
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->view);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->game);
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__g_list_free__g_free0_0 (self->priv->theme_dirlist);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_OBJECT_CLASS (taquin_parent_class)->finalize (obj);
#line 1923 "taquin-main.c"
}


GType taquin_get_type (void) {
	static volatile gsize taquin_type_id__volatile = 0;
	if (g_once_init_enter (&taquin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaquinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Taquin), 0, (GInstanceInitFunc) taquin_instance_init, NULL };
		GType taquin_type_id;
		taquin_type_id = g_type_register_static (gtk_application_get_type (), "Taquin", &g_define_type_info, 0);
		g_once_init_leave (&taquin_type_id__volatile, taquin_type_id);
	}
	return taquin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



