/* rygel-media-export-root-container.c generated by valac 0.28.0, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009-2013 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <rygel-db.h>


#define RYGEL_MEDIA_EXPORT_TYPE_FOLDER_DEFINITION (rygel_media_export_folder_definition_get_type ())
typedef struct _RygelMediaExportFolderDefinition RygelMediaExportFolderDefinition;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;
typedef struct _RygelMediaExportTrackableDbContainerPrivate RygelMediaExportTrackableDbContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportRootContainerFindObjectData RygelMediaExportRootContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportRootContainerSearchData RygelMediaExportRootContainerSearchData;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER (rygel_media_export_playlist_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainer))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))

typedef struct _RygelMediaExportPlaylistRootContainer RygelMediaExportPlaylistRootContainer;
typedef struct _RygelMediaExportPlaylistRootContainerClass RygelMediaExportPlaylistRootContainerClass;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

struct _RygelMediaExportFolderDefinition {
	gchar* title;
	gchar* definition;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	gint (*count_children) (RygelMediaExportDBContainer* self);
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportTrackableDbContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportTrackableDbContainerPrivate * priv;
};

struct _RygelMediaExportTrackableDbContainerClass {
	RygelMediaExportDBContainerClass parent_class;
	void (*remove_child) (RygelMediaExportTrackableDbContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelMediaExportTrackableDbContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelMediaExportTrackableDbContainer* self);
	void (*set_service_reset_token) (RygelMediaExportTrackableDbContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelMediaExportTrackableDbContainer* self);
};

struct _RygelMediaExportRootContainer {
	RygelMediaExportTrackableDbContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaExportTrackableDbContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMediaExportHarvester* harvester;
	GCancellable* cancellable;
	RygelMediaExportDBContainer* filesystem_container;
	gulong harvester_signal_id;
	gulong filesystem_signal_id;
	gboolean initialized;
};

struct _RygelMediaExportRootContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* object;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	RygelMediaExportQueryContainerFactory* factory;
	RygelMediaExportQueryContainerFactory* _tmp6_;
	RygelMediaExportQueryContainer* container;
	RygelMediaExportQueryContainerFactory* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaExportQueryContainer* _tmp9_;
	RygelMediaExportQueryContainer* _tmp10_;
	RygelMediaExportQueryContainer* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	gchar* tmp_id;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** parts;
	const gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	RygelMediaObject* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	GCancellable* _tmp23_;
	RygelMediaObject* _tmp24_;
	RygelMediaObject* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelMediaObject* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	RygelMediaObject* _tmp31_;
	const gchar* _tmp32_;
	RygelMediaExportQueryContainerFactory* _vala1_factory;
	RygelMediaExportQueryContainerFactory* _tmp33_;
	gchar* container_id;
	gchar** _tmp34_;
	gint _tmp34__length1;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	RygelMediaExportQueryContainer* _vala1_container;
	RygelMediaExportQueryContainerFactory* _tmp37_;
	const gchar* _tmp38_;
	RygelMediaExportQueryContainer* _tmp39_;
	RygelMediaExportQueryContainer* _tmp40_;
	RygelMediaObject* _tmp41_;
	RygelMediaExportQueryContainer* _tmp42_;
	GError * _inner_error_;
};

struct _RygelMediaExportRootContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelSearchExpression* _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* _tmp9_;
	RygelMediaObjects* list;
	RygelMediaContainer* query_container;
	gchar* upnp_class;
	RygelSearchExpression* _tmp10_;
	RygelRelationalExpression* relational_expression;
	RygelSearchExpression* _tmp11_;
	RygelRelationalExpression* _tmp12_;
	RygelRelationalExpression* _tmp13_;
	RygelMediaContainer* _tmp14_;
	RygelRelationalExpression* _tmp15_;
	gconstpointer _tmp16_;
	gchar* _tmp17_;
	RygelSearchExpression* _tmp18_;
	RygelMediaContainer* _tmp19_;
	gboolean _tmp20_;
	RygelMediaContainer* _tmp21_;
	RygelMediaObjects* _tmp22_;
	RygelMediaContainer* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	const gchar* _tmp26_;
	GCancellable* _tmp27_;
	RygelMediaObjects* _tmp28_;
	RygelMediaObjects* _tmp29_;
	RygelMediaContainer* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	const gchar* _tmp33_;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp34_;
	RygelMediaObjects* _tmp35_;
	gint _object_size;
	RygelMediaObjects* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _object_index;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	RygelMediaObject* object;
	RygelMediaObjects* _tmp42_;
	gint _tmp43_;
	gpointer _tmp44_;
	RygelMediaObject* _tmp45_;
	const gchar* _tmp46_;
	RygelMediaObjects* _tmp47_;
	RygelSearchExpression* _tmp48_;
	guint _tmp49_;
	guint _tmp50_;
	const gchar* _tmp51_;
	GCancellable* _tmp52_;
	guint _tmp53_;
	RygelMediaObjects* _tmp54_;
	RygelMediaObjects* _tmp55_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_root_container_parent_class = NULL;
static RygelMediaExportRootContainer* rygel_media_export_root_container_instance;
static RygelMediaExportRootContainer* rygel_media_export_root_container_instance = NULL;

GType rygel_media_export_folder_definition_get_type (void) G_GNUC_CONST;
RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest);
void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_SEARCH_CONTAINER_PREFIX RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "upnp:class," RYGEL_MUSIC_ITEM_UPNP_CLASS ","
void rygel_media_export_root_container_ensure_exists (GError** error);
void rygel_media_export_media_cache_ensure_exists (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (void);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type);
RygelMediaExportRootContainer* rygel_media_export_root_container_get_instance (void);
RygelMediaExportDBContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self);
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_);
static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self, const gchar* id, const gchar* name);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_ITEM_PREFIX "virtual-id:"
static void rygel_media_export_root_container_real_search_data_free (gpointer _data);
static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelMediaContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression);
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container);
static GeeArrayList* rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self);
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_new (void);
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_construct (GType object_type);
GType rygel_media_export_playlist_root_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self, const gchar* definition_id, const gchar* name);
gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash);
static guint32 rygel_media_export_root_container_real_get_system_update_id (RygelMediaExportTrackableDbContainer* base);
guint32 rygel_media_export_trackable_db_container_get_system_update_id (RygelMediaExportTrackableDbContainer* self);
static gboolean __lambda8_ (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_init (RygelMediaExportRootContainer* self, GError** error);
static gboolean ___lambda8__gsource_func (gpointer self);
void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
RygelMediaExportTrackableDbContainer* rygel_media_export_trackable_db_container_new (const gchar* id, const gchar* title);
RygelMediaExportTrackableDbContainer* rygel_media_export_trackable_db_container_construct (GType object_type, const gchar* id, const gchar* title);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self);
static void _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender, gpointer self);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error);
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent);
static void rygel_media_export_root_container_root_updated (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_on_setting_changed (RygelMediaExportRootContainer* self, const gchar* section, const gchar* key);
static void _rygel_media_export_root_container_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self);
#define RYGEL_MEDIA_EXPORT_PLUGIN_NAME "MediaExport"
static void rygel_media_export_root_container_handle_uri_config_change (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_handle_virtual_folder_change (RygelMediaExportRootContainer* self);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent);
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
static void __lambda9_ (RygelMediaExportRootContainer* self);
static void ___lambda9__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error);
static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelNullContainer* rygel_null_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_root_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const RygelMediaExportFolderDefinition VIRTUAL_FOLDERS_DEFAULT[2] = {{"Year", "dc:date,?"}, {"All", ""}};
const RygelMediaExportFolderDefinition VIRTUAL_FOLDERS_MUSIC[3] = {{"Artist", "upnp:artist,?,upnp:album,?"}, {"Album", "upnp:album,?"}, {"Genre", "dc:genre,?"}};

void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = (*self).title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp1_;
	_tmp2_ = (*self).definition;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).definition);
	(*dest).definition = _tmp3_;
}


void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self) {
	_g_free0 ((*self).title);
	_g_free0 ((*self).definition);
}


RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self) {
	RygelMediaExportFolderDefinition* dup;
	dup = g_new0 (RygelMediaExportFolderDefinition, 1);
	rygel_media_export_folder_definition_copy (self, dup);
	return dup;
}


void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self) {
	rygel_media_export_folder_definition_destroy (self);
	g_free (self);
}


GType rygel_media_export_folder_definition_get_type (void) {
	static volatile gsize rygel_media_export_folder_definition_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_folder_definition_type_id__volatile)) {
		GType rygel_media_export_folder_definition_type_id;
		rygel_media_export_folder_definition_type_id = g_boxed_type_register_static ("RygelMediaExportFolderDefinition", (GBoxedCopyFunc) rygel_media_export_folder_definition_dup, (GBoxedFreeFunc) rygel_media_export_folder_definition_free);
		g_once_init_leave (&rygel_media_export_folder_definition_type_id__volatile, rygel_media_export_folder_definition_type_id);
	}
	return rygel_media_export_folder_definition_type_id__volatile;
}


void rygel_media_export_root_container_ensure_exists (GError** error) {
	RygelMediaExportRootContainer* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_export_root_container_instance;
	if (_tmp0_ == NULL) {
		RygelMediaExportRootContainer* _tmp1_ = NULL;
		rygel_media_export_media_cache_ensure_exists (&_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp1_ = rygel_media_export_root_container_new ();
		_g_object_unref0 (rygel_media_export_root_container_instance);
		rygel_media_export_root_container_instance = _tmp1_;
	}
}


/**
     * Get the single instance of the root container.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaExportRootContainer* rygel_media_export_root_container_get_instance (void) {
	RygelMediaExportRootContainer* result = NULL;
	RygelMediaExportRootContainer* _tmp0_ = NULL;
	RygelMediaExportRootContainer* _tmp1_ = NULL;
	_tmp0_ = rygel_media_export_root_container_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


RygelMediaExportDBContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self) {
	RygelMediaExportDBContainer* result = NULL;
	RygelMediaExportDBContainer* _tmp0_ = NULL;
	RygelMediaExportDBContainer* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filesystem_container;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self) {
	GCancellable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
}


static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportRootContainerFindObjectData, _data_);
}


static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerFindObjectData* _data_;
	RygelMediaExportRootContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_media_export_root_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_export_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportRootContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_root_container_real_find_object_co (_data_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally34;
	__catch34_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 1;
	RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_tmp0_, _data_->_tmp1_, rygel_media_export_root_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_inner_error_);
	_data_->object = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->object;
	if (_data_->_tmp3_ != NULL) {
		_data_->result = _data_->object;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->id;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = g_str_has_prefix (_data_->_tmp4_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = rygel_media_export_query_container_factory_get_default ();
		_data_->factory = _data_->_tmp6_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->factory;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->id;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = rygel_media_export_query_container_factory_create_from_hashed_id (_data_->_tmp7_, _data_->_tmp8_, "");
		_data_->container = _data_->_tmp9_;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->container;
		if (_data_->_tmp10_ != NULL) {
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->container;
			rygel_media_object_set_parent ((RygelMediaObject*) _data_->_tmp11_, (RygelMediaContainer*) _data_->self);
		}
		_data_->result = (RygelMediaObject*) _data_->container;
		_g_object_unref0 (_data_->factory);
		_g_object_unref0 (_data_->object);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->id;
		_data_->_tmp13_ = FALSE;
		_data_->_tmp13_ = g_str_has_prefix (_data_->_tmp12_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_ITEM_PREFIX);
		if (_data_->_tmp13_) {
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->id;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = string_replace (_data_->_tmp14_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_ITEM_PREFIX, "");
			_data_->tmp_id = _data_->_tmp15_;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->tmp_id;
			_data_->_tmp17_ = NULL;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_ = g_strsplit (_data_->_tmp16_, ":", 0);
			_data_->parts_length1 = 0;
			_data_->_parts_size_ = 0;
			_data_->parts = _data_->_tmp18_;
			_data_->parts_length1 = _vala_array_length (_data_->_tmp17_);
			_data_->_parts_size_ = _data_->parts_length1;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19__length1 = 0;
			_data_->_tmp19_ = _data_->parts;
			_data_->_tmp19__length1 = _data_->parts_length1;
			if (_data_->_tmp19__length1 != 2) {
				_data_->result = NULL;
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->tmp_id);
				_g_object_unref0 (_data_->object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp21_ = NULL;
			_data_->_tmp21__length1 = 0;
			_data_->_tmp21_ = _data_->parts;
			_data_->_tmp21__length1 = _data_->parts_length1;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->_tmp21_[1];
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->cancellable;
			_data_->_state_ = 2;
			RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_tmp22_, _data_->_tmp23_, rygel_media_export_root_container_find_object_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp20_ = _data_->_tmp24_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->tmp_id);
				_g_object_unref0 (_data_->object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->_tmp20_;
			_data_->_tmp20_ = NULL;
			_g_object_unref0 (_data_->object);
			_data_->object = _data_->_tmp25_;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->object;
			if (_data_->_tmp26_ == NULL) {
				_data_->result = NULL;
				_g_object_unref0 (_data_->_tmp20_);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->tmp_id);
				_g_object_unref0 (_data_->object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->object;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->object;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = rygel_media_object_get_id (_data_->_tmp28_);
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->_tmp29_;
			rygel_media_object_set_ref_id (_data_->_tmp27_, _data_->_tmp30_);
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->object;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _data_->id;
			rygel_media_object_set_id (_data_->_tmp31_, _data_->_tmp32_);
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = rygel_media_export_query_container_factory_get_default ();
			_data_->_vala1_factory = _data_->_tmp33_;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34__length1 = 0;
			_data_->_tmp34_ = _data_->parts;
			_data_->_tmp34__length1 = _data_->parts_length1;
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = _data_->_tmp34_[0];
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _data_->_tmp35_, NULL);
			_data_->container_id = _data_->_tmp36_;
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = _data_->_vala1_factory;
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = _data_->container_id;
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = rygel_media_export_query_container_factory_create_from_hashed_id (_data_->_tmp37_, _data_->_tmp38_, "");
			_data_->_vala1_container = _data_->_tmp39_;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = _data_->_vala1_container;
			if (_data_->_tmp40_ == NULL) {
				_data_->result = NULL;
				_g_object_unref0 (_data_->_vala1_container);
				_g_free0 (_data_->container_id);
				_g_object_unref0 (_data_->_vala1_factory);
				_g_object_unref0 (_data_->_tmp20_);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->tmp_id);
				_g_object_unref0 (_data_->object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = _data_->object;
			_data_->_tmp42_ = NULL;
			_data_->_tmp42_ = _data_->_vala1_container;
			rygel_media_object_set_parent_ref (_data_->_tmp41_, (RygelMediaContainer*) _data_->_tmp42_);
			_g_object_unref0 (_data_->_vala1_container);
			_g_free0 (_data_->container_id);
			_g_object_unref0 (_data_->_vala1_factory);
			_g_object_unref0 (_data_->_tmp20_);
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->tmp_id);
		}
	}
	_data_->result = _data_->object;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_root_container_real_search_data_free (gpointer _data) {
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportRootContainerSearchData, _data_);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerSearchData* _data_;
	RygelMediaExportRootContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = sort_criteria;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	rygel_media_export_root_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_export_root_container_real_search_finish (RygelMediaExportDBContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportRootContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_root_container_real_search_co (_data_);
}


static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->expression;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->expression;
		_data_->_tmp3_ = 0U;
		_data_->_tmp3_ = _data_->offset;
		_data_->_tmp4_ = 0U;
		_data_->_tmp4_ = _data_->max_count;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->sort_criteria;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->cancellable;
		_data_->_tmp7_ = 0U;
		_data_->_state_ = 1;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp7_;
		_data_->_tmp1_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_data_->result = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp1_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->query_container = NULL;
	_data_->upnp_class = NULL;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->expression;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp10_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->expression;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp11_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->_tmp11_) : NULL);
		_data_->relational_expression = _data_->_tmp12_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->relational_expression;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = rygel_media_export_root_container_search_to_virtual_container (_data_->self, _data_->_tmp13_);
		_g_object_unref0 (_data_->query_container);
		_data_->query_container = _data_->_tmp14_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->relational_expression;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = ((RygelSearchExpression*) _data_->_tmp15_)->operand2;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup ((const gchar*) _data_->_tmp16_);
		_g_free0 (_data_->upnp_class);
		_data_->upnp_class = _data_->_tmp17_;
		_rygel_search_expression_unref0 (_data_->relational_expression);
	} else {
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->expression;
		_data_->_tmp19_ = NULL;
		_data_->_tmp20_ = FALSE;
		_data_->_tmp20_ = rygel_media_export_root_container_is_search_in_virtual_container (_data_->self, _data_->_tmp18_, &_data_->_tmp19_);
		_g_object_unref0 (_data_->query_container);
		_data_->query_container = _data_->_tmp19_;
		if (_data_->_tmp20_) {
		}
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->query_container;
	if (_data_->_tmp21_ != NULL) {
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->query_container;
		_data_->_tmp24_ = 0U;
		_data_->_tmp24_ = _data_->offset;
		_data_->_tmp25_ = 0U;
		_data_->_tmp25_ = _data_->max_count;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->sort_criteria;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->cancellable;
		_data_->_state_ = 2;
		rygel_media_container_get_children (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->_tmp26_, _data_->_tmp27_, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = rygel_media_container_get_children_finish (_data_->_tmp23_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp22_ = _data_->_tmp28_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->query_container);
			_g_object_unref0 (_data_->list);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->_tmp22_;
		_data_->_tmp22_ = NULL;
		_g_object_unref0 (_data_->list);
		_data_->list = _data_->_tmp29_;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->query_container;
		_data_->_tmp31_ = 0;
		_data_->_tmp31_ = rygel_media_container_get_child_count (_data_->_tmp30_);
		_data_->_tmp32_ = 0;
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->total_matches = (guint) _data_->_tmp32_;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->upnp_class;
		if (_data_->_tmp33_ != NULL) {
			{
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->list;
				_data_->_tmp35_ = NULL;
				_data_->_tmp35_ = _g_object_ref0 (_data_->_tmp34_);
				_data_->_object_list = _data_->_tmp35_;
				_data_->_tmp36_ = NULL;
				_data_->_tmp36_ = _data_->_object_list;
				_data_->_tmp37_ = 0;
				_data_->_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp36_);
				_data_->_tmp38_ = 0;
				_data_->_tmp38_ = _data_->_tmp37_;
				_data_->_object_size = _data_->_tmp38_;
				_data_->_object_index = -1;
				while (TRUE) {
					_data_->_tmp39_ = 0;
					_data_->_tmp39_ = _data_->_object_index;
					_data_->_object_index = _data_->_tmp39_ + 1;
					_data_->_tmp40_ = 0;
					_data_->_tmp40_ = _data_->_object_index;
					_data_->_tmp41_ = 0;
					_data_->_tmp41_ = _data_->_object_size;
					if (!(_data_->_tmp40_ < _data_->_tmp41_)) {
						break;
					}
					_data_->_tmp42_ = NULL;
					_data_->_tmp42_ = _data_->_object_list;
					_data_->_tmp43_ = 0;
					_data_->_tmp43_ = _data_->_object_index;
					_data_->_tmp44_ = NULL;
					_data_->_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp42_, _data_->_tmp43_);
					_data_->object = (RygelMediaObject*) _data_->_tmp44_;
					_data_->_tmp45_ = NULL;
					_data_->_tmp45_ = _data_->object;
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = _data_->upnp_class;
					rygel_media_object_set_upnp_class (_data_->_tmp45_, _data_->_tmp46_);
					_g_object_unref0 (_data_->object);
				}
				_g_object_unref0 (_data_->_object_list);
			}
		}
		_data_->result = _data_->list;
		_g_object_unref0 (_data_->_tmp22_);
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->query_container);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp48_ = NULL;
		_data_->_tmp48_ = _data_->expression;
		_data_->_tmp49_ = 0U;
		_data_->_tmp49_ = _data_->offset;
		_data_->_tmp50_ = 0U;
		_data_->_tmp50_ = _data_->max_count;
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = _data_->sort_criteria;
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = _data_->cancellable;
		_data_->_tmp53_ = 0U;
		_data_->_state_ = 3;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish ((RygelMediaExportDBContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer), _data_->_res_, &_data_->_tmp53_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp53_;
		_data_->_tmp47_ = _data_->_tmp54_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->query_container);
			_g_object_unref0 (_data_->list);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _data_->_tmp47_;
		_data_->_tmp47_ = NULL;
		_data_->result = _data_->_tmp55_;
		_g_object_unref0 (_data_->_tmp47_);
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->query_container);
		_g_object_unref0 (_data_->list);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->query_container);
	_g_object_unref0 (_data_->list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GeeArrayList* rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* uris = NULL;
	GeeArrayList* actual_uris = NULL;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GFile* home_dir = NULL;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	const gchar* pictures_dir = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* videos_dir = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* music_dir = NULL;
	const gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		GeeArrayList* _tmp1_ = NULL;
		RygelMetaConfig* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		_tmp2_ = config;
		_tmp3_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp2_, "MediaExport", "uris", &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch35_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (uris);
		uris = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* _error_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (uris);
		uris = _tmp5_;
		_g_error_free0 (_error_);
	}
	__finally35:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		_g_object_unref0 (actual_uris);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	_g_object_unref0 (actual_uris);
	actual_uris = _tmp6_;
	_tmp7_ = g_get_home_dir ();
	_tmp8_ = g_file_new_for_path (_tmp7_);
	home_dir = _tmp8_;
	_tmp9_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	pictures_dir = _tmp9_;
	_tmp10_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	videos_dir = _tmp10_;
	_tmp11_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	music_dir = _tmp11_;
	{
		GeeArrayList* _uri_list = NULL;
		GeeArrayList* _tmp12_ = NULL;
		GeeArrayList* _tmp13_ = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _uri_index = 0;
		_tmp12_ = uris;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_uri_list = _tmp13_;
		_tmp14_ = _uri_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_uri_size = _tmp16_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gchar* uri = NULL;
			GeeArrayList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			GFile* file = NULL;
			const gchar* _tmp23_ = NULL;
			GFile* _tmp24_ = NULL;
			GFile* _tmp25_ = NULL;
			GFile* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			GeeArrayList* _tmp51_ = NULL;
			GFile* _tmp52_ = NULL;
			_tmp17_ = _uri_index;
			_uri_index = _tmp17_ + 1;
			_tmp18_ = _uri_index;
			_tmp19_ = _uri_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _uri_list;
			_tmp21_ = _uri_index;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
			uri = (gchar*) _tmp22_;
			_tmp23_ = uri;
			_tmp24_ = g_file_new_for_commandline_arg (_tmp23_);
			file = _tmp24_;
			_tmp25_ = file;
			_tmp26_ = home_dir;
			_tmp27_ = g_file_equal (_tmp25_, _tmp26_);
			_tmp28_ = G_LIKELY (!_tmp27_);
			if (_tmp28_) {
				gchar* actual_uri = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				const gchar* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
				const gchar* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				const gchar* _tmp46_ = NULL;
				GFile* _tmp47_ = NULL;
				GFile* _tmp48_ = NULL;
				GFile* _tmp49_ = NULL;
				gboolean _tmp50_ = FALSE;
				_tmp29_ = uri;
				_tmp30_ = g_strdup (_tmp29_);
				actual_uri = _tmp30_;
				_tmp31_ = pictures_dir;
				_tmp32_ = G_LIKELY (_tmp31_ != NULL);
				if (_tmp32_) {
					const gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					_tmp33_ = actual_uri;
					_tmp34_ = pictures_dir;
					_tmp35_ = string_replace (_tmp33_, "@PICTURES@", _tmp34_);
					_g_free0 (actual_uri);
					actual_uri = _tmp35_;
				}
				_tmp36_ = videos_dir;
				_tmp37_ = G_LIKELY (_tmp36_ != NULL);
				if (_tmp37_) {
					const gchar* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					_tmp38_ = actual_uri;
					_tmp39_ = videos_dir;
					_tmp40_ = string_replace (_tmp38_, "@VIDEOS@", _tmp39_);
					_g_free0 (actual_uri);
					actual_uri = _tmp40_;
				}
				_tmp41_ = music_dir;
				_tmp42_ = G_LIKELY (_tmp41_ != NULL);
				if (_tmp42_) {
					const gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					_tmp43_ = actual_uri;
					_tmp44_ = music_dir;
					_tmp45_ = string_replace (_tmp43_, "@MUSIC@", _tmp44_);
					_g_free0 (actual_uri);
					actual_uri = _tmp45_;
				}
				_tmp46_ = actual_uri;
				_tmp47_ = g_file_new_for_commandline_arg (_tmp46_);
				_g_object_unref0 (file);
				file = _tmp47_;
				_tmp48_ = file;
				_tmp49_ = home_dir;
				_tmp50_ = g_file_equal (_tmp48_, _tmp49_);
				if (_tmp50_) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_g_free0 (actual_uri);
			}
			_tmp51_ = actual_uris;
			_tmp52_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp52_);
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	result = actual_uris;
	_g_object_unref0 (home_dir);
	_g_object_unref0 (config);
	_g_object_unref0 (uris);
	return result;
}


static RygelMediaContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression) {
	RygelMediaContainer* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelRelationalExpression* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp1_ = expression;
	_tmp2_ = ((RygelSearchExpression*) _tmp1_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp2_, "upnp:class") == 0) {
		RygelRelationalExpression* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		_tmp3_ = expression;
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->op;
		_tmp0_ = ((GUPnPSearchCriteriaOp) ((gintptr) _tmp4_)) == GUPNP_SEARCH_CRITERIA_OP_EQ;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* id = NULL;
		gchar* _tmp5_ = NULL;
		RygelRelationalExpression* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GQuark _tmp10_ = 0U;
		RygelMediaExportQueryContainerFactory* factory = NULL;
		RygelMediaExportQueryContainerFactory* _tmp18_ = NULL;
		RygelMediaExportQueryContainerFactory* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		RygelMediaExportQueryContainer* _tmp21_ = NULL;
		_tmp5_ = g_strdup (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_SEARCH_CONTAINER_PREFIX);
		id = _tmp5_;
		_tmp6_ = expression;
		_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
		_tmp8_ = (const gchar*) _tmp7_;
		_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
		if (_tmp10_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM)) {
			switch (0) {
				default:
				{
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					_tmp11_ = id;
					_tmp12_ = g_strconcat (_tmp11_, "upnp:album,?", NULL);
					_g_free0 (id);
					id = _tmp12_;
					break;
				}
			}
		} else if (_tmp10_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST)) {
			switch (0) {
				default:
				{
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp13_ = id;
					_tmp14_ = g_strconcat (_tmp13_, "dc:creator,?,upnp:album,?", NULL);
					_g_free0 (id);
					id = _tmp14_;
					break;
				}
			}
		} else if (_tmp10_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_MUSIC_GENRE)) {
			switch (0) {
				default:
				{
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					_tmp15_ = id;
					_tmp16_ = g_strconcat (_tmp15_, "dc:genre,?", NULL);
					_g_free0 (id);
					id = _tmp16_;
					break;
				}
			}
		} else if (_tmp10_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_PLAYLIST)) {
			switch (0) {
				default:
				{
					RygelMediaExportPlaylistRootContainer* _tmp17_ = NULL;
					_tmp17_ = rygel_media_export_playlist_root_container_new ();
					result = (RygelMediaContainer*) _tmp17_;
					_g_free0 (id);
					return result;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = NULL;
					_g_free0 (id);
					return result;
				}
			}
		}
		_tmp18_ = rygel_media_export_query_container_factory_get_default ();
		factory = _tmp18_;
		_tmp19_ = factory;
		_tmp20_ = id;
		_tmp21_ = rygel_media_export_query_container_factory_create_from_description_id (_tmp19_, _tmp20_, "");
		result = (RygelMediaContainer*) _tmp21_;
		_g_object_unref0 (factory);
		_g_free0 (id);
		return result;
	}
	result = NULL;
	return result;
}


/**
     * Check if a passed search expression is a simple search in a virtual
     * container.
     *
     * @param expression the expression to check
     * @param new_id contains the id of the virtual container constructed from
     *               the search
     * @param upnp_class contains the class of the container the search was
     *                   looking in
     * @return true if it was a search in virtual container, false otherwise.
     * @note This works single level only. Enough to satisfy Xbox music
     *       browsing, but may need refinement
     */
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container) {
	RygelMediaContainer* _vala_container = NULL;
	gboolean result = FALSE;
	RygelRelationalExpression* virtual_expression = NULL;
	RygelMediaContainer* query_container = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	RygelLogicalExpression* logical_expression = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelLogicalExpression* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelLogicalExpression* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	RygelRelationalExpression* left_expression = NULL;
	RygelLogicalExpression* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	RygelSearchExpression* _tmp13_ = NULL;
	RygelRelationalExpression* _tmp14_ = NULL;
	RygelRelationalExpression* right_expression = NULL;
	RygelLogicalExpression* _tmp15_ = NULL;
	gconstpointer _tmp16_ = NULL;
	RygelSearchExpression* _tmp17_ = NULL;
	RygelRelationalExpression* _tmp18_ = NULL;
	RygelRelationalExpression* _tmp19_ = NULL;
	RygelMediaContainer* _tmp20_ = NULL;
	RygelMediaContainer* _tmp21_ = NULL;
	RygelMediaExportQueryContainerFactory* factory = NULL;
	RygelMediaExportQueryContainerFactory* _tmp29_ = NULL;
	gchar* plaintext_id = NULL;
	RygelMediaExportQueryContainerFactory* _tmp30_ = NULL;
	RygelMediaContainer* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* last_argument = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* escaped_detail = NULL;
	RygelRelationalExpression* _tmp37_ = NULL;
	gconstpointer _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* new_id = NULL;
	RygelRelationalExpression* _tmp40_ = NULL;
	gconstpointer _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	RygelMediaExportQueryContainerFactory* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	RygelMediaExportQueryContainer* _tmp47_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expression != NULL, FALSE);
	virtual_expression = NULL;
	_g_object_unref0 (_vala_container);
	_vala_container = NULL;
	_tmp0_ = expression;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		result = FALSE;
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _vala_container;
		} else {
			_g_object_unref0 (_vala_container);
		}
		return result;
	}
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp1_) : NULL);
	logical_expression = _tmp2_;
	_tmp5_ = logical_expression;
	_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand1;
	if (G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp6_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		RygelLogicalExpression* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		_tmp7_ = logical_expression;
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->operand2;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp8_, RYGEL_TYPE_RELATIONAL_EXPRESSION);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		RygelLogicalExpression* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		_tmp9_ = logical_expression;
		_tmp10_ = ((RygelSearchExpression*) _tmp9_)->op;
		_tmp3_ = ((RygelLogicalOperator) ((gintptr) _tmp10_)) == RYGEL_LOGICAL_OPERATOR_AND;
	} else {
		_tmp3_ = FALSE;
	}
	if (!_tmp3_) {
		result = FALSE;
		_rygel_search_expression_unref0 (logical_expression);
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _vala_container;
		} else {
			_g_object_unref0 (_vala_container);
		}
		return result;
	}
	_tmp11_ = logical_expression;
	_tmp12_ = ((RygelSearchExpression*) _tmp11_)->operand1;
	_tmp13_ = (RygelSearchExpression*) _tmp12_;
	_tmp14_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp13_) : NULL);
	left_expression = _tmp14_;
	_tmp15_ = logical_expression;
	_tmp16_ = ((RygelSearchExpression*) _tmp15_)->operand2;
	_tmp17_ = (RygelSearchExpression*) _tmp16_;
	_tmp18_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp17_) : NULL);
	right_expression = _tmp18_;
	_tmp19_ = left_expression;
	_tmp20_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp19_);
	_g_object_unref0 (query_container);
	query_container = _tmp20_;
	_tmp21_ = query_container;
	if (_tmp21_ == NULL) {
		RygelRelationalExpression* _tmp22_ = NULL;
		RygelMediaContainer* _tmp23_ = NULL;
		RygelMediaContainer* _tmp24_ = NULL;
		_tmp22_ = right_expression;
		_tmp23_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp22_);
		_g_object_unref0 (query_container);
		query_container = _tmp23_;
		_tmp24_ = query_container;
		if (_tmp24_ != NULL) {
			RygelRelationalExpression* _tmp25_ = NULL;
			RygelRelationalExpression* _tmp26_ = NULL;
			_tmp25_ = left_expression;
			_tmp26_ = _rygel_search_expression_ref0 (_tmp25_);
			_rygel_search_expression_unref0 (virtual_expression);
			virtual_expression = _tmp26_;
		} else {
			result = FALSE;
			_rygel_search_expression_unref0 (right_expression);
			_rygel_search_expression_unref0 (left_expression);
			_rygel_search_expression_unref0 (logical_expression);
			_g_object_unref0 (query_container);
			_rygel_search_expression_unref0 (virtual_expression);
			if (container) {
				*container = _vala_container;
			} else {
				_g_object_unref0 (_vala_container);
			}
			return result;
		}
	} else {
		RygelRelationalExpression* _tmp27_ = NULL;
		RygelRelationalExpression* _tmp28_ = NULL;
		_tmp27_ = right_expression;
		_tmp28_ = _rygel_search_expression_ref0 (_tmp27_);
		_rygel_search_expression_unref0 (virtual_expression);
		virtual_expression = _tmp28_;
	}
	_tmp29_ = rygel_media_export_query_container_factory_get_default ();
	factory = _tmp29_;
	_tmp30_ = factory;
	_tmp31_ = query_container;
	_tmp32_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = rygel_media_export_query_container_factory_get_virtual_container_definition (_tmp30_, _tmp33_);
	plaintext_id = _tmp34_;
	_tmp35_ = plaintext_id;
	_tmp36_ = string_replace (_tmp35_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	last_argument = _tmp36_;
	_tmp37_ = virtual_expression;
	_tmp38_ = ((RygelSearchExpression*) _tmp37_)->operand2;
	_tmp39_ = g_uri_escape_string ((const gchar*) _tmp38_, "", TRUE);
	escaped_detail = _tmp39_;
	_tmp40_ = virtual_expression;
	_tmp41_ = ((RygelSearchExpression*) _tmp40_)->operand1;
	_tmp42_ = escaped_detail;
	_tmp43_ = last_argument;
	_tmp44_ = g_strdup_printf ("%s%s,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, (const gchar*) _tmp41_, _tmp42_, _tmp43_);
	new_id = _tmp44_;
	_tmp45_ = factory;
	_tmp46_ = new_id;
	_tmp47_ = rygel_media_export_query_container_factory_create_from_description_id (_tmp45_, _tmp46_, "");
	_g_object_unref0 (_vala_container);
	_vala_container = (RygelMediaContainer*) _tmp47_;
	result = TRUE;
	_g_free0 (new_id);
	_g_free0 (escaped_detail);
	_g_free0 (last_argument);
	_g_free0 (plaintext_id);
	_g_object_unref0 (factory);
	_rygel_search_expression_unref0 (right_expression);
	_rygel_search_expression_unref0 (left_expression);
	_rygel_search_expression_unref0 (logical_expression);
	_g_object_unref0 (query_container);
	_rygel_search_expression_unref0 (virtual_expression);
	if (container) {
		*container = _vala_container;
	} else {
		_g_object_unref0 (_vala_container);
	}
	return result;
}


/**
     * Create a new root container.
     */
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type) {
	RygelMediaExportRootContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = _ ("@REALNAME@'s media");
	self = (RygelMediaExportRootContainer*) g_object_new (object_type, "id", "0", "title", _tmp0_, "parent", NULL, "child-count", 0, NULL);
	return self;
}


static RygelMediaExportRootContainer* rygel_media_export_root_container_new (void) {
	return rygel_media_export_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER);
}


static gboolean __lambda8_ (RygelMediaExportRootContainer* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		rygel_media_export_root_container_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ ((RygelMediaExportRootContainer*) self);
	return result;
}


static guint32 rygel_media_export_root_container_real_get_system_update_id (RygelMediaExportTrackableDbContainer* base) {
	RygelMediaExportRootContainer * self;
	guint32 result = 0U;
	guint32 id = 0U;
	guint32 _tmp0_ = 0U;
	self = (RygelMediaExportRootContainer*) base;
	_tmp0_ = RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->get_system_update_id (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer));
	id = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	result = id;
	return result;
}


static void _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender, gpointer self) {
	rygel_media_export_root_container_on_initial_harvesting_done ((RygelMediaExportRootContainer*) self);
}


static void _rygel_media_export_root_container_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self) {
	rygel_media_export_root_container_on_setting_changed ((RygelMediaExportRootContainer*) self, section, key);
}


static void rygel_media_export_root_container_init (RygelMediaExportRootContainer* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	RygelMediaExportMediaCache* _tmp2_ = NULL;
	GeeArrayList* ids = NULL;
	GCancellable* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	RygelMediaExportHarvester* _tmp17_ = NULL;
	RygelMediaExportHarvester* _tmp18_ = NULL;
	gulong _tmp19_ = 0UL;
	RygelMediaExportMediaCache* _tmp54_ = NULL;
	RygelMediaExportHarvester* _tmp55_ = NULL;
	RygelMediaExportDBContainer* _tmp56_ = NULL;
	GeeArrayList* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	RygelMetaConfig* _tmp60_ = NULL;
	RygelMetaConfig* _tmp61_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->initialized;
	if (_tmp0_) {
		return;
	}
	self->priv->initialized = TRUE;
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	_tmp2_ = ((RygelMediaExportDBContainer*) self)->media_db;
	rygel_media_export_media_cache_drop_virtual_folders (_tmp2_);
	{
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		_tmp3_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_save_container (_tmp3_, (RygelMediaContainer*) self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		const gchar* _tmp4_ = NULL;
		RygelMediaExportTrackableDbContainer* _tmp5_ = NULL;
		RygelMediaExportDBContainer* _tmp6_ = NULL;
		RygelMediaExportMediaCache* _tmp7_ = NULL;
		RygelMediaExportDBContainer* _tmp8_ = NULL;
		_tmp4_ = _ (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME);
		_tmp5_ = rygel_media_export_trackable_db_container_new (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, _tmp4_);
		_g_object_unref0 (self->priv->filesystem_container);
		self->priv->filesystem_container = (RygelMediaExportDBContainer*) _tmp5_;
		_tmp6_ = self->priv->filesystem_container;
		rygel_media_object_set_parent ((RygelMediaObject*) _tmp6_, (RygelMediaContainer*) self);
		_tmp7_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp8_ = self->priv->filesystem_container;
		rygel_media_export_media_cache_save_container (_tmp7_, (RygelMediaContainer*) _tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch38_g_error;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		GeeArrayList* _tmp9_ = NULL;
		RygelMediaExportMediaCache* _tmp10_ = NULL;
		GeeArrayList* _tmp11_ = NULL;
		GeeArrayList* _tmp12_ = NULL;
		_tmp10_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp11_ = rygel_media_export_media_cache_get_child_ids (_tmp10_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch39_rygel_database_database_error;
			}
			_g_object_unref0 (ids);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (ids);
		ids = _tmp12_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally39;
	__catch39_rygel_database_database_error:
	{
		GError* e = NULL;
		GeeArrayList* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (ids);
		ids = _tmp13_;
		_g_error_free0 (e);
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ids);
		return;
	}
	_tmp14_ = self->priv->cancellable;
	_tmp15_ = rygel_media_export_root_container_get_shared_uris (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = rygel_media_export_harvester_new (_tmp14_, _tmp16_);
	_g_object_unref0 (self->priv->harvester);
	self->priv->harvester = _tmp17_;
	_g_object_unref0 (_tmp16_);
	_tmp18_ = self->priv->harvester;
	_tmp19_ = g_signal_connect_object (_tmp18_, "done", (GCallback) _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done, self, 0);
	self->priv->harvester_signal_id = _tmp19_;
	{
		GeeArrayList* _file_list = NULL;
		RygelMediaExportHarvester* _tmp20_ = NULL;
		GeeArrayList* _tmp21_ = NULL;
		GeeArrayList* _tmp22_ = NULL;
		GeeArrayList* _tmp23_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _file_index = 0;
		_tmp20_ = self->priv->harvester;
		_tmp21_ = rygel_media_export_harvester_get_locations (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		_file_list = _tmp23_;
		_tmp24_ = _file_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_file_size = _tmp26_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			GeeArrayList* _tmp33_ = NULL;
			GFile* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			_tmp27_ = _file_index;
			_file_index = _tmp27_ + 1;
			_tmp28_ = _file_index;
			_tmp29_ = _file_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _file_list;
			_tmp31_ = _file_index;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
			file = (GFile*) _tmp32_;
			_tmp33_ = ids;
			_tmp34_ = file;
			_tmp35_ = rygel_media_export_media_cache_get_id (_tmp34_);
			_tmp36_ = _tmp35_;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp33_, _tmp36_);
			_g_free0 (_tmp36_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	{
		GeeArrayList* _id_list = NULL;
		GeeArrayList* _tmp37_ = NULL;
		GeeArrayList* _tmp38_ = NULL;
		gint _id_size = 0;
		GeeArrayList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _id_index = 0;
		_tmp37_ = ids;
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_id_list = _tmp38_;
		_tmp39_ = _id_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_id_size = _tmp41_;
		_id_index = -1;
		while (TRUE) {
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gchar* id = NULL;
			GeeArrayList* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			gpointer _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			_tmp42_ = _id_index;
			_id_index = _tmp42_ + 1;
			_tmp43_ = _id_index;
			_tmp44_ = _id_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _id_list;
			_tmp46_ = _id_index;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _tmp46_);
			id = (gchar*) _tmp47_;
			_tmp48_ = id;
			g_debug ("rygel-media-export-root-container.vala:435: ID %s is no longer in the " \
"configuration. Deleting...", _tmp48_);
			{
				RygelMediaExportMediaCache* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				_tmp49_ = ((RygelMediaExportDBContainer*) self)->media_db;
				_tmp50_ = id;
				rygel_media_export_media_cache_remove_by_id (_tmp49_, _tmp50_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch40_rygel_database_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (_id_list);
					_g_object_unref0 (ids);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally40;
			__catch40_rygel_database_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp51_ = NULL;
				GError* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp51_ = _ ("Failed to remove entry: %s");
				_tmp52_ = _error_;
				_tmp53_ = _tmp52_->message;
				g_warning (_tmp51_, _tmp53_);
				_g_error_free0 (_error_);
			}
			__finally40:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				_g_object_unref0 (_id_list);
				_g_object_unref0 (ids);
				return;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_list);
	}
	_tmp54_ = ((RygelMediaExportDBContainer*) self)->media_db;
	rygel_media_export_media_cache_rebuild_exists_cache (_tmp54_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ids);
		return;
	}
	_tmp55_ = self->priv->harvester;
	_tmp56_ = self->priv->filesystem_container;
	rygel_media_export_harvester_schedule_locations (_tmp55_, (RygelMediaContainer*) _tmp56_);
	_tmp57_ = ids;
	_tmp58_ = gee_collection_get_is_empty ((GeeCollection*) _tmp57_);
	_tmp59_ = _tmp58_;
	if (!_tmp59_) {
		rygel_media_export_root_container_root_updated (self);
	}
	_tmp60_ = rygel_meta_config_get_default ();
	_tmp61_ = _tmp60_;
	g_signal_connect_object ((RygelConfiguration*) _tmp61_, "setting-changed", (GCallback) _rygel_media_export_root_container_on_setting_changed_rygel_configuration_setting_changed, self, 0);
	_g_object_unref0 (_tmp61_);
	_g_object_unref0 (ids);
}


static void rygel_media_export_root_container_root_updated (RygelMediaExportRootContainer* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	{
		RygelMediaExportMediaCache* _tmp0_ = NULL;
		_tmp0_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_save_container (_tmp0_, (RygelMediaContainer*) self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch41_g_error;
		}
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally41:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_root_container_on_setting_changed (RygelMediaExportRootContainer* self, const gchar* section, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = section;
	if (g_strcmp0 (_tmp0_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME) != 0) {
		return;
	}
	_tmp1_ = key;
	if (g_strcmp0 (_tmp1_, "uris") == 0) {
		rygel_media_export_root_container_handle_uri_config_change (self);
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = key;
		if (g_strcmp0 (_tmp2_, "virtual-folders") == 0) {
			rygel_media_export_root_container_handle_virtual_folder_change (self);
		}
	}
}


static void rygel_media_export_root_container_handle_uri_config_change (RygelMediaExportRootContainer* self) {
	GeeArrayList* uris = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* new_uris = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	RygelMediaExportHarvester* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* old_uris = NULL;
	GeeArrayList* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	RygelMediaExportHarvester* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	RygelMediaExportHarvester* _tmp35_ = NULL;
	GeeArrayList* _tmp36_ = NULL;
	GeeArrayList* _tmp37_ = NULL;
	GeeArrayList* _tmp38_ = NULL;
	GeeArrayList* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_media_export_root_container_get_shared_uris (self);
	uris = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	new_uris = _tmp1_;
	_tmp2_ = new_uris;
	_tmp3_ = uris;
	gee_array_list_add_all (_tmp2_, (GeeCollection*) _tmp3_);
	_tmp4_ = new_uris;
	_tmp5_ = self->priv->harvester;
	_tmp6_ = rygel_media_export_harvester_get_locations (_tmp5_);
	_tmp7_ = _tmp6_;
	gee_collection_remove_all ((GeeCollection*) _tmp4_, (GeeCollection*) _tmp7_);
	_tmp8_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	old_uris = _tmp8_;
	_tmp9_ = old_uris;
	_tmp10_ = self->priv->harvester;
	_tmp11_ = rygel_media_export_harvester_get_locations (_tmp10_);
	_tmp12_ = _tmp11_;
	gee_array_list_add_all (_tmp9_, (GeeCollection*) _tmp12_);
	_tmp13_ = old_uris;
	_tmp14_ = uris;
	gee_collection_remove_all ((GeeCollection*) _tmp13_, (GeeCollection*) _tmp14_);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _file_index = 0;
		_tmp15_ = old_uris;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_file_list = _tmp16_;
		_tmp17_ = _file_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_file_size = _tmp19_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gpointer _tmp25_ = NULL;
			RygelMediaExportHarvester* _tmp26_ = NULL;
			GFile* _tmp27_ = NULL;
			_tmp20_ = _file_index;
			_file_index = _tmp20_ + 1;
			_tmp21_ = _file_index;
			_tmp22_ = _file_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _file_list;
			_tmp24_ = _file_index;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
			file = (GFile*) _tmp25_;
			_tmp26_ = self->priv->harvester;
			_tmp27_ = file;
			rygel_media_export_harvester_cancel (_tmp26_, _tmp27_);
			{
				RygelMediaExportMediaCache* _tmp28_ = NULL;
				GFile* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				_tmp28_ = ((RygelMediaExportDBContainer*) self)->media_db;
				_tmp29_ = file;
				_tmp30_ = rygel_media_export_media_cache_get_id (_tmp29_);
				_tmp31_ = _tmp30_;
				rygel_media_export_media_cache_remove_by_id (_tmp28_, _tmp31_, &_inner_error_);
				_g_free0 (_tmp31_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch42_rygel_database_database_error;
					}
					_g_object_unref0 (file);
					_g_object_unref0 (_file_list);
					_g_object_unref0 (old_uris);
					_g_object_unref0 (new_uris);
					_g_object_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally42;
			__catch42_rygel_database_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp32_ = NULL;
				GError* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp32_ = _ ("Failed to remove entry: %s");
				_tmp33_ = _error_;
				_tmp34_ = _tmp33_->message;
				g_warning (_tmp32_, _tmp34_);
				_g_error_free0 (_error_);
			}
			__finally42:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (_file_list);
				_g_object_unref0 (old_uris);
				_g_object_unref0 (new_uris);
				_g_object_unref0 (uris);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp35_ = self->priv->harvester;
	_tmp36_ = rygel_media_export_harvester_get_locations (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = old_uris;
	gee_collection_remove_all ((GeeCollection*) _tmp37_, (GeeCollection*) _tmp38_);
	_tmp39_ = new_uris;
	_tmp40_ = gee_collection_get_is_empty ((GeeCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	if (!_tmp41_) {
		RygelMediaExportDBContainer* _tmp42_ = NULL;
		gulong _tmp43_ = 0UL;
		RygelMediaExportHarvester* _tmp44_ = NULL;
		gulong _tmp45_ = 0UL;
		_tmp42_ = self->priv->filesystem_container;
		_tmp43_ = self->priv->filesystem_signal_id;
		g_signal_handler_disconnect ((GObject*) _tmp42_, _tmp43_);
		self->priv->filesystem_signal_id = (gulong) 0;
		_tmp44_ = self->priv->harvester;
		_tmp45_ = g_signal_connect_object (_tmp44_, "done", (GCallback) _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done, self, 0);
		self->priv->harvester_signal_id = _tmp45_;
	}
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp46_ = NULL;
		GeeArrayList* _tmp47_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		gint _file_index = 0;
		_tmp46_ = new_uris;
		_tmp47_ = _g_object_ref0 (_tmp46_);
		_file_list = _tmp47_;
		_tmp48_ = _file_list;
		_tmp49_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_file_size = _tmp50_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			gint _tmp53_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp54_ = NULL;
			gint _tmp55_ = 0;
			gpointer _tmp56_ = NULL;
			GFile* _tmp57_ = NULL;
			gboolean _tmp58_ = FALSE;
			_tmp51_ = _file_index;
			_file_index = _tmp51_ + 1;
			_tmp52_ = _file_index;
			_tmp53_ = _file_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _file_list;
			_tmp55_ = _file_index;
			_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, _tmp55_);
			file = (GFile*) _tmp56_;
			_tmp57_ = file;
			_tmp58_ = g_file_query_exists (_tmp57_, NULL);
			if (_tmp58_) {
				RygelMediaExportHarvester* _tmp59_ = NULL;
				GeeArrayList* _tmp60_ = NULL;
				GeeArrayList* _tmp61_ = NULL;
				GFile* _tmp62_ = NULL;
				RygelMediaExportHarvester* _tmp63_ = NULL;
				GFile* _tmp64_ = NULL;
				RygelMediaExportDBContainer* _tmp65_ = NULL;
				_tmp59_ = self->priv->harvester;
				_tmp60_ = rygel_media_export_harvester_get_locations (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
				_tmp63_ = self->priv->harvester;
				_tmp64_ = file;
				_tmp65_ = self->priv->filesystem_container;
				rygel_media_export_harvester_schedule (_tmp63_, _tmp64_, (RygelMediaContainer*) _tmp65_);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_g_object_unref0 (old_uris);
	_g_object_unref0 (new_uris);
	_g_object_unref0 (uris);
}


static void rygel_media_export_root_container_handle_virtual_folder_change (RygelMediaExportRootContainer* self) {
	gboolean virtual_folders = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	virtual_folders = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "virtual-folders", &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch43_g_error;
		}
		virtual_folders = _tmp1_;
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally43:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = virtual_folders;
	if (_tmp3_) {
		rygel_media_export_root_container_add_default_virtual_folders (self);
		_g_object_unref0 (config);
		return;
	} else {
		RygelMediaExportMediaCache* _tmp4_ = NULL;
		_tmp4_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_drop_virtual_folders (_tmp4_);
	}
	rygel_media_export_root_container_root_updated (self);
	_g_object_unref0 (config);
}


static void __lambda9_ (RygelMediaExportRootContainer* self) {
	rygel_media_export_root_container_add_default_virtual_folders (self);
	rygel_media_export_root_container_root_updated (self);
}


static void ___lambda9__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	__lambda9_ ((RygelMediaExportRootContainer*) self);
}


static void rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self) {
	RygelMediaExportHarvester* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	RygelMediaExportMediaCache* _tmp2_ = NULL;
	RygelMediaExportDBContainer* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->harvester;
	_tmp1_ = self->priv->harvester_signal_id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	self->priv->harvester_signal_id = (gulong) 0;
	_tmp2_ = ((RygelMediaExportDBContainer*) self)->media_db;
	rygel_media_export_media_cache_debug_statistics (_tmp2_);
	rygel_media_export_root_container_add_default_virtual_folders (self);
	rygel_media_export_root_container_root_updated (self);
	_tmp3_ = self->priv->filesystem_container;
	_tmp4_ = g_signal_connect_object ((RygelMediaContainer*) _tmp3_, "container-updated", (GCallback) ___lambda9__rygel_media_container_container_updated, self, 0);
	self->priv->filesystem_signal_id = _tmp4_;
}


/** Add the default virtual folders,
     * for Music, Pictures, etc,
     * saving them in the cache.
     */
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self) {
	gboolean virtual_folders = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	virtual_folders = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		RygelMetaConfig* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = config;
		_tmp3_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp2_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "virtual-folders", &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch44_g_error;
		}
		virtual_folders = _tmp1_;
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally44:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = virtual_folders;
	if (!_tmp4_) {
		_g_object_unref0 (config);
		return;
	}
	{
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp5_ = _ ("Music");
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp5_, RYGEL_MUSIC_ITEM_UPNP_CLASS, VIRTUAL_FOLDERS_MUSIC, G_N_ELEMENTS (VIRTUAL_FOLDERS_MUSIC), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch45_g_error;
		}
		_tmp6_ = _ ("Pictures");
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp6_, RYGEL_PHOTO_ITEM_UPNP_CLASS, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch45_g_error;
		}
		_tmp7_ = _ ("Videos");
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp7_, RYGEL_VIDEO_ITEM_UPNP_CLASS, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch45_g_error;
		}
		_tmp8_ = _ ("Playlists");
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp8_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS, NULL, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch45_g_error;
		}
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally45:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (config);
}


/**
     * Add a QueryContainer to the provided container,
     * for the specified UPnP class,
     * with the specified definition,
     * saving it in the cache.
     */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error) {
	gchar* id = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaExportFolderDefinition _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	RygelMediaExportQueryContainerFactory* factory = NULL;
	RygelMediaExportQueryContainerFactory* _tmp8_ = NULL;
	RygelMediaExportQueryContainer* query_container = NULL;
	RygelMediaExportQueryContainerFactory* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	RygelMediaExportFolderDefinition _tmp11_ = {0};
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	RygelMediaExportQueryContainer* _tmp14_ = NULL;
	RygelMediaExportQueryContainer* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (item_class != NULL);
	g_return_if_fail (definition != NULL);
	_tmp0_ = item_class;
	_tmp1_ = *definition;
	_tmp2_ = _tmp1_.definition;
	_tmp3_ = g_strdup_printf ("%supnp:class,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp0_, _tmp2_);
	id = _tmp3_;
	_tmp4_ = id;
	_tmp5_ = g_str_has_suffix (_tmp4_, ",");
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = id;
		_tmp7_ = string_slice (_tmp6_, (glong) 0, (glong) (-1));
		_g_free0 (id);
		id = _tmp7_;
	}
	_tmp8_ = rygel_media_export_query_container_factory_get_default ();
	factory = _tmp8_;
	_tmp9_ = factory;
	_tmp10_ = id;
	_tmp11_ = *definition;
	_tmp12_ = _tmp11_.title;
	_tmp13_ = _ (_tmp12_);
	_tmp14_ = rygel_media_export_query_container_factory_create_from_description_id (_tmp9_, _tmp10_, _tmp13_);
	query_container = _tmp14_;
	_tmp15_ = query_container;
	_tmp16_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		RygelMediaExportQueryContainer* _tmp18_ = NULL;
		RygelMediaContainer* _tmp19_ = NULL;
		RygelMediaExportMediaCache* _tmp20_ = NULL;
		RygelMediaExportQueryContainer* _tmp21_ = NULL;
		_tmp18_ = query_container;
		_tmp19_ = container;
		rygel_media_object_set_parent ((RygelMediaObject*) _tmp18_, _tmp19_);
		_tmp20_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp21_ = query_container;
		rygel_media_export_media_cache_save_container (_tmp20_, (RygelMediaContainer*) _tmp21_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query_container);
			_g_object_unref0 (factory);
			_g_free0 (id);
			return;
		}
	} else {
		RygelMediaExportMediaCache* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		_tmp22_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp23_ = id;
		rygel_media_export_media_cache_remove_by_id (_tmp22_, _tmp23_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query_container);
			_g_object_unref0 (factory);
			_g_free0 (id);
			return;
		}
	}
	_g_object_unref0 (query_container);
	_g_object_unref0 (factory);
	_g_free0 (id);
}


/**
     * Add a parent container with child containers for the definitions,
     * saving them in the cache.
     */
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error) {
	RygelNullContainer* container = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelNullContainer* _tmp4_ = NULL;
	RygelNullContainer* _tmp5_ = NULL;
	RygelMediaExportMediaCache* _tmp6_ = NULL;
	RygelNullContainer* _tmp7_ = NULL;
	RygelMediaExportFolderDefinition* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_ = 0;
	RygelMediaExportMediaCache* _tmp19_ = NULL;
	RygelNullContainer* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (item_class != NULL);
	_tmp0_ = item_class;
	_tmp1_ = g_strconcat ("virtual-parent:", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = parent;
	_tmp4_ = rygel_null_container_new (_tmp2_, (RygelMediaContainer*) self, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	container = _tmp5_;
	_tmp6_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp7_ = container;
	rygel_media_export_media_cache_save_container (_tmp6_, (RygelMediaContainer*) _tmp7_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (container);
		return;
	}
	{
		RygelMediaExportFolderDefinition* definition_collection = NULL;
		gint definition_collection_length1 = 0;
		gint _definition_collection_size_ = 0;
		gint definition_it = 0;
		definition_collection = VIRTUAL_FOLDERS_DEFAULT;
		definition_collection_length1 = G_N_ELEMENTS (VIRTUAL_FOLDERS_DEFAULT);
		for (definition_it = 0; definition_it < G_N_ELEMENTS (VIRTUAL_FOLDERS_DEFAULT); definition_it = definition_it + 1) {
			RygelMediaExportFolderDefinition definition = {0};
			definition = definition_collection[definition_it];
			{
				RygelNullContainer* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				RygelMediaExportFolderDefinition _tmp10_ = {0};
				_tmp8_ = container;
				_tmp9_ = item_class;
				_tmp10_ = definition;
				rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp8_, _tmp9_, &_tmp10_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (container);
					return;
				}
			}
		}
	}
	_tmp11_ = definitions;
	_tmp11__length1 = definitions_length1;
	if (_tmp11_ != NULL) {
		RygelMediaExportFolderDefinition* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		_tmp12_ = definitions;
		_tmp12__length1 = definitions_length1;
		{
			RygelMediaExportFolderDefinition* definition_collection = NULL;
			gint definition_collection_length1 = 0;
			gint _definition_collection_size_ = 0;
			gint definition_it = 0;
			definition_collection = _tmp12_;
			definition_collection_length1 = _tmp12__length1;
			for (definition_it = 0; definition_it < _tmp12__length1; definition_it = definition_it + 1) {
				RygelMediaExportFolderDefinition _tmp13_ = {0};
				RygelMediaExportFolderDefinition definition = {0};
				rygel_media_export_folder_definition_copy (&definition_collection[definition_it], &_tmp13_);
				definition = _tmp13_;
				{
					RygelNullContainer* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					RygelMediaExportFolderDefinition _tmp16_ = {0};
					_tmp14_ = container;
					_tmp15_ = item_class;
					_tmp16_ = definition;
					rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp14_, _tmp15_, &_tmp16_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						rygel_media_export_folder_definition_destroy (&definition);
						_g_object_unref0 (container);
						return;
					}
					rygel_media_export_folder_definition_destroy (&definition);
				}
			}
		}
	}
	_tmp19_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp20_ = container;
	_tmp21_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = rygel_media_export_media_cache_get_child_count (_tmp19_, _tmp22_, &_inner_error_);
	_tmp18_ = _tmp23_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (container);
		return;
	}
	if (_tmp18_ == 0) {
		RygelNullContainer* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		_tmp24_ = container;
		_tmp25_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_str_has_prefix (_tmp26_, "virtual-parent:" RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp17_ = !_tmp27_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		RygelMediaExportMediaCache* _tmp28_ = NULL;
		RygelNullContainer* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		_tmp28_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp29_ = container;
		_tmp30_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp29_);
		_tmp31_ = _tmp30_;
		rygel_media_export_media_cache_remove_by_id (_tmp28_, _tmp31_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (container);
			return;
		}
	} else {
		RygelNullContainer* _tmp32_ = NULL;
		_tmp32_ = container;
		rygel_media_container_updated ((RygelMediaContainer*) _tmp32_, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	}
	_g_object_unref0 (container);
}


static void rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass) {
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportRootContainerPrivate));
	((RygelMediaContainerClass *) klass)->find_object = rygel_media_export_root_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = rygel_media_export_root_container_real_find_object_finish;
	((RygelMediaExportDBContainerClass *) klass)->search = rygel_media_export_root_container_real_search;
	((RygelMediaExportDBContainerClass *) klass)->search_finish = rygel_media_export_root_container_real_search_finish;
	((RygelMediaExportTrackableDbContainerClass *) klass)->get_system_update_id = rygel_media_export_root_container_real_get_system_update_id;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
}


static void rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE (self);
	self->priv->initialized = FALSE;
}


static void rygel_media_export_root_container_finalize (GObject* obj) {
	RygelMediaExportRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer);
	_g_object_unref0 (self->priv->harvester);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->filesystem_container);
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
}


/**
 * Represents the root container.
 */
GType rygel_media_export_root_container_get_type (void) {
	static volatile gsize rygel_media_export_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		GType rygel_media_export_root_container_type_id;
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_root_container_type_id__volatile, rygel_media_export_root_container_type_id);
	}
	return rygel_media_export_root_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



