/* rygel-media-export-info-serializer.c generated by valac 0.29.2, the Vala compiler
 * generated from rygel-media-export-info-serializer.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_INFO_SERIALIZER (rygel_info_serializer_get_type ())
#define RYGEL_INFO_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializer))
#define RYGEL_INFO_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializerClass))
#define RYGEL_IS_INFO_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_INFO_SERIALIZER))
#define RYGEL_IS_INFO_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_INFO_SERIALIZER))
#define RYGEL_INFO_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializerClass))

typedef struct _RygelInfoSerializer RygelInfoSerializer;
typedef struct _RygelInfoSerializerClass RygelInfoSerializerClass;
typedef struct _RygelInfoSerializerPrivate RygelInfoSerializerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
typedef struct _RygelParamSpecInfoSerializer RygelParamSpecInfoSerializer;

typedef enum  {
	INFO_SERIALIZER_ERROR_INVALID_STREAM,
	INFO_SERIALIZER_ERROR_BAD_MIME
} InfoSerializerError;
#define INFO_SERIALIZER_ERROR info_serializer_error_quark ()
struct _RygelInfoSerializer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelInfoSerializerPrivate * priv;
};

struct _RygelInfoSerializerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelInfoSerializer *self);
};

struct _RygelParamSpecInfoSerializer {
	GParamSpec parent_instance;
};


static gpointer rygel_info_serializer_parent_class = NULL;

GQuark info_serializer_error_quark (void);
gpointer rygel_info_serializer_ref (gpointer instance);
void rygel_info_serializer_unref (gpointer instance);
GParamSpec* rygel_param_spec_info_serializer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_info_serializer (GValue* value, gpointer v_object);
void rygel_value_take_info_serializer (GValue* value, gpointer v_object);
gpointer rygel_value_get_info_serializer (const GValue* value);
GType rygel_info_serializer_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_INFO_SERIALIZER_DUMMY_PROPERTY
};
GVariant* rygel_info_serializer_serialize (RygelInfoSerializer* self, GFile* file, GFileInfo* file_info, GstDiscovererInfo* info, GUPnPDLNAProfile* dlna_profile, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
static GVariant* rygel_info_serializer_serialize_file_info (RygelInfoSerializer* self, GFileInfo* info);
static GVariant* rygel_info_serializer_serialize_dlna_profile (RygelInfoSerializer* self, GUPnPDLNAProfile* profile);
static GVariant* rygel_info_serializer_serialize_info (RygelInfoSerializer* self, GstDiscovererInfo* info);
static GVariant* rygel_info_serializer_serialize_audio_info (RygelInfoSerializer* self, GstDiscovererAudioInfo* info);
static GVariant* rygel_info_serializer_serialize_video_info (RygelInfoSerializer* self, GstDiscovererVideoInfo* info);
static GVariant* rygel_info_serializer_serialize_meta_data (RygelInfoSerializer* self, GstDiscovererAudioInfo* info);
#define UPNP_CLASS_PLAYLIST "object.item.playlistItem"
RygelInfoSerializer* rygel_info_serializer_new (void);
RygelInfoSerializer* rygel_info_serializer_construct (GType object_type);
static void rygel_info_serializer_finalize (RygelInfoSerializer* obj);


GQuark info_serializer_error_quark (void) {
	return g_quark_from_static_string ("info_serializer_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GVariant* rygel_info_serializer_serialize (RygelInfoSerializer* self, GFile* file, GFileInfo* file_info, GstDiscovererInfo* info, GUPnPDLNAProfile* dlna_profile, GError** error) {
	GVariant* result = NULL;
	GstDiscovererInfo* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ != NULL) {
		gchar* upnp_class = NULL;
		GList* audio_streams = NULL;
		GstDiscovererInfo* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		GList* video_streams = NULL;
		GstDiscovererInfo* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		GList* _tmp6_ = NULL;
		gboolean _tmp12_ = FALSE;
		GList* _tmp13_ = NULL;
		GstDiscovererAudioInfo* _tmp22_ = NULL;
		GList* _tmp23_ = NULL;
		GstDiscovererVideoInfo* _tmp26_ = NULL;
		GList* _tmp27_ = NULL;
		GstDiscovererAudioInfo* _tmp30_ = NULL;
		GList* _tmp31_ = NULL;
		const gchar* _tmp34_ = NULL;
		GFileInfo* _tmp35_ = NULL;
		GVariant* _tmp36_ = NULL;
		GVariant* _tmp37_ = NULL;
		GUPnPDLNAProfile* _tmp38_ = NULL;
		GVariant* _tmp39_ = NULL;
		GVariant* _tmp40_ = NULL;
		GstDiscovererInfo* _tmp41_ = NULL;
		GVariant* _tmp42_ = NULL;
		GVariant* _tmp43_ = NULL;
		GVariant* _tmp44_ = NULL;
		GVariant* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		GVariant* _tmp47_ = NULL;
		GVariant* _tmp48_ = NULL;
		GVariant* _tmp49_ = NULL;
		GVariant* _tmp50_ = NULL;
		GVariant* _tmp51_ = NULL;
		upnp_class = NULL;
		_tmp1_ = info;
		_tmp2_ = gst_discoverer_info_get_audio_streams (_tmp1_);
		audio_streams = (GList*) _tmp2_;
		_tmp3_ = info;
		_tmp4_ = gst_discoverer_info_get_video_streams (_tmp3_);
		video_streams = (GList*) _tmp4_;
		_tmp6_ = audio_streams;
		if (_tmp6_ == NULL) {
			GList* _tmp7_ = NULL;
			_tmp7_ = video_streams;
			_tmp5_ = _tmp7_ == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			_tmp8_ = file;
			_tmp9_ = g_file_get_uri (_tmp8_);
			_tmp10_ = _tmp9_;
			g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = g_error_new_literal (INFO_SERIALIZER_ERROR, INFO_SERIALIZER_ERROR_INVALID_STREAM, "No stream information");
			_inner_error_ = _tmp11_;
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (video_streams);
			__g_list_free__g_object_unref0_0 (audio_streams);
			_g_free0 (upnp_class);
			return NULL;
		}
		_tmp13_ = audio_streams;
		if (_tmp13_ == NULL) {
			GList* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = video_streams;
			_tmp15_ = _tmp14_->data;
			_tmp16_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp15_);
			_tmp12_ = _tmp16_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* _tmp17_ = NULL;
			_tmp17_ = g_strdup (UPNP_CLASS_PHOTO);
			_g_free0 (upnp_class);
			upnp_class = _tmp17_;
		} else {
			GList* _tmp18_ = NULL;
			_tmp18_ = video_streams;
			if (_tmp18_ != NULL) {
				gchar* _tmp19_ = NULL;
				_tmp19_ = g_strdup (UPNP_CLASS_VIDEO);
				_g_free0 (upnp_class);
				upnp_class = _tmp19_;
			} else {
				GList* _tmp20_ = NULL;
				_tmp20_ = audio_streams;
				if (_tmp20_ != NULL) {
					gchar* _tmp21_ = NULL;
					_tmp21_ = g_strdup (UPNP_CLASS_MUSIC);
					_g_free0 (upnp_class);
					upnp_class = _tmp21_;
				} else {
				}
			}
		}
		_tmp23_ = audio_streams;
		if (_tmp23_ != NULL) {
			GList* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			_tmp24_ = audio_streams;
			_tmp25_ = _tmp24_->data;
			_tmp22_ = (GstDiscovererAudioInfo*) _tmp25_;
		} else {
			_tmp22_ = NULL;
		}
		_tmp27_ = video_streams;
		if (_tmp27_ != NULL) {
			GList* _tmp28_ = NULL;
			gconstpointer _tmp29_ = NULL;
			_tmp28_ = video_streams;
			_tmp29_ = _tmp28_->data;
			_tmp26_ = (GstDiscovererVideoInfo*) _tmp29_;
		} else {
			_tmp26_ = NULL;
		}
		_tmp31_ = audio_streams;
		if (_tmp31_ != NULL) {
			GList* _tmp32_ = NULL;
			gconstpointer _tmp33_ = NULL;
			_tmp32_ = audio_streams;
			_tmp33_ = _tmp32_->data;
			_tmp30_ = (GstDiscovererAudioInfo*) _tmp33_;
		} else {
			_tmp30_ = NULL;
		}
		_tmp34_ = upnp_class;
		_tmp35_ = file_info;
		_tmp36_ = rygel_info_serializer_serialize_file_info (self, _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = dlna_profile;
		_tmp39_ = rygel_info_serializer_serialize_dlna_profile (self, _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = info;
		_tmp42_ = rygel_info_serializer_serialize_info (self, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = rygel_info_serializer_serialize_audio_info (self, _tmp22_);
		_tmp45_ = _tmp44_;
		_tmp46_ = rygel_info_serializer_serialize_video_info (self, _tmp26_);
		_tmp47_ = _tmp46_;
		_tmp48_ = rygel_info_serializer_serialize_meta_data (self, _tmp30_);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_variant_new ("(smvmvmvmvmvmv)", _tmp34_, _tmp37_, _tmp40_, _tmp43_, _tmp45_, _tmp47_, _tmp49_, NULL);
		g_variant_ref_sink (_tmp50_);
		_tmp51_ = _tmp50_;
		_g_variant_unref0 (_tmp49_);
		_g_variant_unref0 (_tmp47_);
		_g_variant_unref0 (_tmp45_);
		_g_variant_unref0 (_tmp43_);
		_g_variant_unref0 (_tmp40_);
		_g_variant_unref0 (_tmp37_);
		result = _tmp51_;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (upnp_class);
		return result;
	} else {
		gchar* upnp_class = NULL;
		gchar* mime = NULL;
		GFileInfo* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		gboolean _tmp56_ = FALSE;
		GFile* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		GFileInfo* _tmp79_ = NULL;
		GVariant* _tmp80_ = NULL;
		GVariant* _tmp81_ = NULL;
		GVariant* _tmp82_ = NULL;
		GVariant* _tmp83_ = NULL;
		upnp_class = NULL;
		_tmp52_ = file_info;
		_tmp53_ = g_file_info_get_content_type (_tmp52_);
		_tmp54_ = g_content_type_get_mime_type (_tmp53_);
		mime = _tmp54_;
		_tmp55_ = mime;
		_tmp56_ = g_str_has_prefix (_tmp55_, "video/");
		if (_tmp56_) {
			gchar* _tmp57_ = NULL;
			_tmp57_ = g_strdup (UPNP_CLASS_VIDEO);
			_g_free0 (upnp_class);
			upnp_class = _tmp57_;
		} else {
			const gchar* _tmp58_ = NULL;
			gboolean _tmp59_ = FALSE;
			_tmp58_ = mime;
			_tmp59_ = g_str_has_prefix (_tmp58_, "image/");
			if (_tmp59_) {
				gchar* _tmp60_ = NULL;
				_tmp60_ = g_strdup (UPNP_CLASS_PHOTO);
				_g_free0 (upnp_class);
				upnp_class = _tmp60_;
			} else {
				gboolean _tmp61_ = FALSE;
				const gchar* _tmp62_ = NULL;
				gboolean _tmp63_ = FALSE;
				_tmp62_ = mime;
				_tmp63_ = g_str_has_prefix (_tmp62_, "audio/");
				if (_tmp63_) {
					_tmp61_ = TRUE;
				} else {
					const gchar* _tmp64_ = NULL;
					_tmp64_ = mime;
					_tmp61_ = g_strcmp0 (_tmp64_, "application/ogg") == 0;
				}
				if (_tmp61_) {
					gchar* _tmp65_ = NULL;
					_tmp65_ = g_strdup (UPNP_CLASS_MUSIC);
					_g_free0 (upnp_class);
					upnp_class = _tmp65_;
				} else {
					const gchar* _tmp66_ = NULL;
					gboolean _tmp67_ = FALSE;
					_tmp66_ = mime;
					_tmp67_ = g_str_has_suffix (_tmp66_, "/xml");
					if (_tmp67_) {
						gchar* _tmp68_ = NULL;
						_tmp68_ = g_strdup (UPNP_CLASS_PLAYLIST);
						_g_free0 (upnp_class);
						upnp_class = _tmp68_;
					} else {
						const gchar* _tmp69_ = NULL;
						GFile* _tmp70_ = NULL;
						gchar* _tmp71_ = NULL;
						gchar* _tmp72_ = NULL;
						const gchar* _tmp73_ = NULL;
						GError* _tmp74_ = NULL;
						_tmp69_ = mime;
						_tmp70_ = file;
						_tmp71_ = g_file_get_uri (_tmp70_);
						_tmp72_ = _tmp71_;
						g_debug ("rygel-media-export-info-serializer.vala:85: Unsupported content-type %" \
"s, skipping %s…", _tmp69_, _tmp72_);
						_g_free0 (_tmp72_);
						_tmp73_ = mime;
						_tmp74_ = g_error_new (INFO_SERIALIZER_ERROR, INFO_SERIALIZER_ERROR_BAD_MIME, "Not supported: %s", _tmp73_);
						_inner_error_ = _tmp74_;
						g_propagate_error (error, _inner_error_);
						_g_free0 (mime);
						_g_free0 (upnp_class);
						return NULL;
					}
				}
			}
		}
		_tmp75_ = file;
		_tmp76_ = g_file_get_uri (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = upnp_class;
		_tmp79_ = file_info;
		_tmp80_ = rygel_info_serializer_serialize_file_info (self, _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_variant_new ("(ssmvmvmvmvmvmv)", _tmp77_, _tmp78_, _tmp81_, NULL, NULL, NULL, NULL, NULL, NULL);
		g_variant_ref_sink (_tmp82_);
		_tmp83_ = _tmp82_;
		_g_variant_unref0 (_tmp81_);
		_g_free0 (_tmp77_);
		result = _tmp83_;
		_g_free0 (mime);
		_g_free0 (upnp_class);
		return result;
	}
}


static GVariant* rygel_info_serializer_serialize_file_info (RygelInfoSerializer* self, GFileInfo* info) {
	GVariant* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
	guint64 _tmp7_ = 0ULL;
	GFileInfo* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = info;
	_tmp3_ = g_file_info_get_content_type (_tmp2_);
	_tmp4_ = g_content_type_get_mime_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = info;
	_tmp7_ = g_file_info_get_attribute_uint64 (_tmp6_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_tmp8_ = info;
	_tmp9_ = g_file_info_get_size (_tmp8_);
	_tmp10_ = g_variant_new ("(sstt)", _tmp1_, _tmp5_, _tmp7_, _tmp9_, NULL);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp5_);
	result = _tmp11_;
	return result;
}


static GVariant* rygel_info_serializer_serialize_dlna_profile (RygelInfoSerializer* self, GUPnPDLNAProfile* profile) {
	GVariant* result = NULL;
	GUPnPDLNAProfile* _tmp0_ = NULL;
	GUPnPDLNAProfile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPDLNAProfile* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = profile;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = profile;
	_tmp2_ = gupnp_dlna_profile_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = profile;
	_tmp5_ = gupnp_dlna_profile_get_mime (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_new ("(ss)", _tmp3_, _tmp6_, NULL);
	g_variant_ref_sink (_tmp7_);
	result = _tmp7_;
	return result;
}


static gpointer _gst_tag_list_ref0 (gpointer self) {
	return self ? gst_tag_list_ref (self) : NULL;
}


static GVariant* rygel_info_serializer_serialize_info (RygelInfoSerializer* self, GstDiscovererInfo* info) {
	GVariant* result = NULL;
	glong duration = 0L;
	GstDiscovererInfo* _tmp0_ = NULL;
	GstClockTime _tmp1_ = 0ULL;
	GstTagList* tags = NULL;
	GstDiscovererInfo* _tmp4_ = NULL;
	GstTagList* _tmp5_ = NULL;
	GstTagList* _tmp6_ = NULL;
	gchar* title = NULL;
	GstTagList* _tmp7_ = NULL;
	gchar* date = NULL;
	GstDateTime* dt = NULL;
	gboolean _tmp10_ = FALSE;
	GstTagList* _tmp11_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	glong _tmp37_ = 0L;
	GVariant* _tmp38_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	duration = (glong) -1;
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
	if (_tmp1_ > ((GstClockTime) 0)) {
		GstDiscovererInfo* _tmp2_ = NULL;
		GstClockTime _tmp3_ = 0ULL;
		_tmp2_ = info;
		_tmp3_ = gst_discoverer_info_get_duration (_tmp2_);
		duration = (glong) (_tmp3_ / GST_SECOND);
	}
	_tmp4_ = info;
	_tmp5_ = gst_discoverer_info_get_tags (_tmp4_);
	_tmp6_ = _gst_tag_list_ref0 (_tmp5_);
	tags = _tmp6_;
	title = NULL;
	_tmp7_ = tags;
	if (_tmp7_ != NULL) {
		GstTagList* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = tags;
		gst_tag_list_get_string (_tmp8_, GST_TAG_TITLE, &_tmp9_);
		_g_free0 (title);
		title = _tmp9_;
	}
	date = NULL;
	dt = NULL;
	_tmp11_ = tags;
	if (_tmp11_ != NULL) {
		GstTagList* _tmp12_ = NULL;
		GstDateTime* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp12_ = tags;
		_tmp14_ = gst_tag_list_get_date_time (_tmp12_, GST_TAG_DATE_TIME, &_tmp13_);
		_gst_date_time_unref0 (dt);
		dt = _tmp13_;
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gboolean _tmp15_ = FALSE;
		GstDateTime* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = dt;
		_tmp17_ = gst_date_time_has_day (_tmp16_);
		if (!_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			GstDateTime* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			_tmp18_ = dt;
			_tmp19_ = gst_date_time_has_month (_tmp18_);
			_tmp15_ = !_tmp19_;
		}
		if (_tmp15_) {
			gint _tmp20_ = 0;
			GstDateTime* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			gint _tmp25_ = 0;
			GstDateTime* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			GstDateTime* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gchar* _tmp32_ = NULL;
			_tmp21_ = dt;
			_tmp22_ = gst_date_time_has_month (_tmp21_);
			if (_tmp22_) {
				GstDateTime* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				_tmp23_ = dt;
				_tmp24_ = gst_date_time_get_month (_tmp23_);
				_tmp20_ = _tmp24_;
			} else {
				_tmp20_ = 1;
			}
			_tmp26_ = dt;
			_tmp27_ = gst_date_time_has_day (_tmp26_);
			if (_tmp27_) {
				GstDateTime* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				_tmp28_ = dt;
				_tmp29_ = gst_date_time_get_day (_tmp28_);
				_tmp25_ = _tmp29_;
			} else {
				_tmp25_ = 1;
			}
			_tmp30_ = dt;
			_tmp31_ = gst_date_time_get_year (_tmp30_);
			_tmp32_ = g_strdup_printf ("%d-%02d-%02d", _tmp31_, _tmp20_, _tmp25_);
			_g_free0 (date);
			date = _tmp32_;
		} else {
			GstDateTime* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			_tmp33_ = dt;
			_tmp34_ = gst_date_time_to_iso8601_string (_tmp33_);
			_g_free0 (date);
			date = _tmp34_;
		}
	}
	_tmp35_ = title;
	_tmp36_ = date;
	_tmp37_ = duration;
	_tmp38_ = g_variant_new ("(msmsi)", _tmp35_, _tmp36_, _tmp37_, NULL);
	g_variant_ref_sink (_tmp38_);
	result = _tmp38_;
	_gst_date_time_unref0 (dt);
	_g_free0 (date);
	_g_free0 (title);
	_gst_tag_list_unref0 (tags);
	return result;
}


static GVariant* rygel_info_serializer_serialize_video_info (RygelInfoSerializer* self, GstDiscovererVideoInfo* info) {
	GVariant* result = NULL;
	GstDiscovererVideoInfo* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GstDiscovererVideoInfo* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GstDiscovererVideoInfo* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GstDiscovererVideoInfo* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	GVariant* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = info;
	_tmp3_ = gst_discoverer_video_info_get_depth (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GstDiscovererVideoInfo* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		_tmp4_ = info;
		_tmp5_ = gst_discoverer_video_info_get_depth (_tmp4_);
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = (guint) -1;
	}
	_tmp6_ = info;
	_tmp7_ = gst_discoverer_video_info_get_width (_tmp6_);
	_tmp8_ = info;
	_tmp9_ = gst_discoverer_video_info_get_height (_tmp8_);
	_tmp10_ = g_variant_new ("(iii)", (gint) _tmp7_, (gint) _tmp9_, _tmp1_, NULL);
	g_variant_ref_sink (_tmp10_);
	result = _tmp10_;
	return result;
}


static GVariant* rygel_info_serializer_serialize_audio_info (RygelInfoSerializer* self, GstDiscovererAudioInfo* info) {
	GVariant* result = NULL;
	GstDiscovererAudioInfo* _tmp0_ = NULL;
	GstDiscovererAudioInfo* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GstDiscovererAudioInfo* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GVariant* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = info;
	_tmp2_ = gst_discoverer_audio_info_get_channels (_tmp1_);
	_tmp3_ = info;
	_tmp4_ = gst_discoverer_audio_info_get_sample_rate (_tmp3_);
	_tmp5_ = g_variant_new ("(ii)", (gint) _tmp2_, (gint) _tmp4_, NULL);
	g_variant_ref_sink (_tmp5_);
	result = _tmp5_;
	return result;
}


static GVariant* rygel_info_serializer_serialize_meta_data (RygelInfoSerializer* self, GstDiscovererAudioInfo* info) {
	GVariant* result = NULL;
	GstDiscovererAudioInfo* _tmp0_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp1_ = NULL;
	GstTagList* _tmp2_ = NULL;
	GstTagList* _tmp3_ = NULL;
	GstTagList* _tmp4_ = NULL;
	gchar* artist = NULL;
	GstTagList* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* album = NULL;
	GstTagList* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* genre = NULL;
	GstTagList* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	guint volume = 0U;
	GstTagList* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint track = 0U;
	GstTagList* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint bitrate = 0U;
	GstTagList* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	guint _tmp22_ = 0U;
	GVariant* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = info;
	_tmp2_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp1_);
	_tmp3_ = _gst_tag_list_ref0 (_tmp2_);
	tags = _tmp3_;
	_tmp4_ = tags;
	if (_tmp4_ == NULL) {
		result = NULL;
		_gst_tag_list_unref0 (tags);
		return result;
	}
	artist = NULL;
	_tmp5_ = tags;
	gst_tag_list_get_string (_tmp5_, GST_TAG_ARTIST, &_tmp6_);
	_g_free0 (artist);
	artist = _tmp6_;
	album = NULL;
	_tmp7_ = tags;
	gst_tag_list_get_string (_tmp7_, GST_TAG_ALBUM, &_tmp8_);
	_g_free0 (album);
	album = _tmp8_;
	genre = NULL;
	_tmp9_ = tags;
	gst_tag_list_get_string (_tmp9_, GST_TAG_GENRE, &_tmp10_);
	_g_free0 (genre);
	genre = _tmp10_;
	volume = G_MAXUINT;
	_tmp11_ = tags;
	gst_tag_list_get_uint (_tmp11_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp12_);
	volume = _tmp12_;
	track = G_MAXUINT;
	_tmp13_ = tags;
	gst_tag_list_get_uint (_tmp13_, GST_TAG_TRACK_NUMBER, &_tmp14_);
	track = _tmp14_;
	bitrate = G_MAXUINT;
	_tmp15_ = tags;
	gst_tag_list_get_uint (_tmp15_, GST_TAG_BITRATE, &_tmp16_);
	bitrate = _tmp16_;
	_tmp17_ = artist;
	_tmp18_ = album;
	_tmp19_ = genre;
	_tmp20_ = volume;
	_tmp21_ = track;
	_tmp22_ = bitrate;
	_tmp23_ = g_variant_new ("(msmsmsiii)", _tmp17_, _tmp18_, _tmp19_, _tmp20_, _tmp21_, ((gint) _tmp22_) / 8, NULL);
	g_variant_ref_sink (_tmp23_);
	result = _tmp23_;
	_g_free0 (genre);
	_g_free0 (album);
	_g_free0 (artist);
	_gst_tag_list_unref0 (tags);
	return result;
}


RygelInfoSerializer* rygel_info_serializer_construct (GType object_type) {
	RygelInfoSerializer* self = NULL;
	self = (RygelInfoSerializer*) g_type_create_instance (object_type);
	return self;
}


RygelInfoSerializer* rygel_info_serializer_new (void) {
	return rygel_info_serializer_construct (RYGEL_TYPE_INFO_SERIALIZER);
}


static void rygel_value_info_serializer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_info_serializer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_info_serializer_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_info_serializer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_info_serializer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_info_serializer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_info_serializer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelInfoSerializer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_info_serializer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_info_serializer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelInfoSerializer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_info_serializer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_info_serializer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecInfoSerializer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_INFO_SERIALIZER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_info_serializer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_INFO_SERIALIZER), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_info_serializer (GValue* value, gpointer v_object) {
	RygelInfoSerializer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_INFO_SERIALIZER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_INFO_SERIALIZER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_info_serializer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_info_serializer_unref (old);
	}
}


void rygel_value_take_info_serializer (GValue* value, gpointer v_object) {
	RygelInfoSerializer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_INFO_SERIALIZER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_INFO_SERIALIZER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_info_serializer_unref (old);
	}
}


static void rygel_info_serializer_class_init (RygelInfoSerializerClass * klass) {
	rygel_info_serializer_parent_class = g_type_class_peek_parent (klass);
	((RygelInfoSerializerClass *) klass)->finalize = rygel_info_serializer_finalize;
}


static void rygel_info_serializer_instance_init (RygelInfoSerializer * self) {
	self->ref_count = 1;
}


static void rygel_info_serializer_finalize (RygelInfoSerializer* obj) {
	RygelInfoSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializer);
	g_signal_handlers_destroy (self);
}


GType rygel_info_serializer_get_type (void) {
	static volatile gsize rygel_info_serializer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_info_serializer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_info_serializer_init, rygel_value_info_serializer_free_value, rygel_value_info_serializer_copy_value, rygel_value_info_serializer_peek_pointer, "p", rygel_value_info_serializer_collect_value, "p", rygel_value_info_serializer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelInfoSerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_info_serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelInfoSerializer), 0, (GInstanceInitFunc) rygel_info_serializer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_info_serializer_type_id;
		rygel_info_serializer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelInfoSerializer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_info_serializer_type_id__volatile, rygel_info_serializer_type_id);
	}
	return rygel_info_serializer_type_id__volatile;
}


gpointer rygel_info_serializer_ref (gpointer instance) {
	RygelInfoSerializer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_info_serializer_unref (gpointer instance) {
	RygelInfoSerializer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_INFO_SERIALIZER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



