/* widgets.c generated by valac 0.28.0.2-3502, the Vala compiler
 * generated from widgets.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;
typedef struct _ClocksHeaderBarPrivate ClocksHeaderBarPrivate;

#define CLOCKS_HEADER_BAR_TYPE_MODE (clocks_header_bar_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define CLOCKS_TYPE_TITLE_RENDERER (clocks_title_renderer_get_type ())
#define CLOCKS_TITLE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRenderer))
#define CLOCKS_TITLE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRendererClass))
#define CLOCKS_IS_TITLE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_TITLE_RENDERER))
#define CLOCKS_IS_TITLE_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_TITLE_RENDERER))
#define CLOCKS_TITLE_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRendererClass))

typedef struct _ClocksTitleRenderer ClocksTitleRenderer;
typedef struct _ClocksTitleRendererClass ClocksTitleRendererClass;
typedef struct _ClocksTitleRendererPrivate ClocksTitleRendererPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER (clocks_digital_clock_renderer_get_type ())
#define CLOCKS_DIGITAL_CLOCK_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRenderer))
#define CLOCKS_DIGITAL_CLOCK_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRendererClass))
#define CLOCKS_IS_DIGITAL_CLOCK_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER))
#define CLOCKS_IS_DIGITAL_CLOCK_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER))
#define CLOCKS_DIGITAL_CLOCK_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRendererClass))

typedef struct _ClocksDigitalClockRenderer ClocksDigitalClockRenderer;
typedef struct _ClocksDigitalClockRendererClass ClocksDigitalClockRendererClass;
typedef struct _ClocksDigitalClockRendererPrivate ClocksDigitalClockRendererPrivate;
#define _pango_layout_line_unref0(var) ((var == NULL) ? NULL : (var = (pango_layout_line_unref (var), NULL)))

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_TYPE_ICON_VIEW (clocks_icon_view_get_type ())
#define CLOCKS_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_ICON_VIEW, ClocksIconView))
#define CLOCKS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_ICON_VIEW, ClocksIconViewClass))
#define CLOCKS_IS_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_ICON_VIEW))
#define CLOCKS_IS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_ICON_VIEW))
#define CLOCKS_ICON_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_ICON_VIEW, ClocksIconViewClass))

typedef struct _ClocksIconView ClocksIconView;
typedef struct _ClocksIconViewClass ClocksIconViewClass;
typedef struct _ClocksIconViewPrivate ClocksIconViewPrivate;

#define CLOCKS_ICON_VIEW_TYPE_MODE (clocks_icon_view_mode_get_type ())

#define CLOCKS_ICON_VIEW_TYPE_COLUMN (clocks_icon_view_column_get_type ())
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

#define CLOCKS_TYPE_CONTENT_VIEW (clocks_content_view_get_type ())
#define CLOCKS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView))
#define CLOCKS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))
#define CLOCKS_IS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_IS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_CONTENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))

typedef struct _ClocksContentView ClocksContentView;
typedef struct _ClocksContentViewClass ClocksContentViewClass;
typedef struct _ClocksContentViewPrivate ClocksContentViewPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON (clocks_am_pm_toggle_button_get_type ())
#define CLOCKS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButton))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))

typedef struct _ClocksAmPmToggleButton ClocksAmPmToggleButton;
typedef struct _ClocksAmPmToggleButtonClass ClocksAmPmToggleButtonClass;
typedef struct _ClocksAmPmToggleButtonPrivate ClocksAmPmToggleButtonPrivate;

#define CLOCKS_AM_PM_TOGGLE_BUTTON_TYPE_AM_PM (clocks_am_pm_toggle_button_am_pm_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define CLOCKS_TYPE_ANALOG_FRAME (clocks_analog_frame_get_type ())
#define CLOCKS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrame))
#define CLOCKS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))
#define CLOCKS_IS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_IS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_ANALOG_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))

typedef struct _ClocksAnalogFrame ClocksAnalogFrame;
typedef struct _ClocksAnalogFrameClass ClocksAnalogFrameClass;
typedef struct _ClocksAnalogFramePrivate ClocksAnalogFramePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ClocksHeaderBar {
	GtkHeaderBar parent_instance;
	ClocksHeaderBarPrivate * priv;
};

struct _ClocksHeaderBarClass {
	GtkHeaderBarClass parent_class;
};

typedef enum  {
	CLOCKS_HEADER_BAR_MODE_NORMAL,
	CLOCKS_HEADER_BAR_MODE_SELECTION,
	CLOCKS_HEADER_BAR_MODE_STANDALONE
} ClocksHeaderBarMode;

struct _ClocksHeaderBarPrivate {
	ClocksHeaderBarMode _mode;
};

struct _ClocksTitleRenderer {
	GtkCellRendererText parent_instance;
	ClocksTitleRendererPrivate * priv;
};

struct _ClocksTitleRendererClass {
	GtkCellRendererTextClass parent_class;
};

struct _ClocksTitleRendererPrivate {
	gint ICON_XOFF;
	gint ICON_YOFF;
	gint ICON_SIZE;
	gchar* _title_icon;
	gchar* _title;
};

struct _ClocksDigitalClockRenderer {
	GtkCellRendererPixbuf parent_instance;
	ClocksDigitalClockRendererPrivate * priv;
};

struct _ClocksDigitalClockRendererClass {
	GtkCellRendererPixbufClass parent_class;
};

struct _ClocksDigitalClockRendererPrivate {
	gchar* _text;
	gchar* _subtext;
	gchar* _css_class;
	gboolean _checked;
	gboolean _toggle_visible;
	gboolean _selectable;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*get_thumb_properties) (ClocksContentItem* self, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
	const gchar* (*get_title_icon) (ClocksContentItem* self);
	void (*set_title_icon) (ClocksContentItem* self, const gchar* value);
	gboolean (*get_selectable) (ClocksContentItem* self);
	void (*set_selectable) (ClocksContentItem* self, gboolean value);
};

struct _ClocksIconView {
	GtkIconView parent_instance;
	ClocksIconViewPrivate * priv;
};

struct _ClocksIconViewClass {
	GtkIconViewClass parent_class;
};

typedef enum  {
	CLOCKS_ICON_VIEW_MODE_NORMAL,
	CLOCKS_ICON_VIEW_MODE_SELECTION
} ClocksIconViewMode;

struct _ClocksIconViewPrivate {
	ClocksIconViewMode _mode;
	ClocksDigitalClockRenderer* thumb_renderer;
};

typedef enum  {
	CLOCKS_ICON_VIEW_COLUMN_SELECTED,
	CLOCKS_ICON_VIEW_COLUMN_ITEM,
	CLOCKS_ICON_VIEW_COLUMN_COLUMNS
} ClocksIconViewColumn;

struct _Block4Data {
	int _ref_count_;
	ClocksIconView* self;
	GList* items;
};

struct _ClocksContentView {
	GtkBin parent_instance;
	ClocksContentViewPrivate * priv;
};

struct _ClocksContentViewClass {
	GtkBinClass parent_class;
	void (*delete_selected) (ClocksContentView* self);
};

struct _ClocksContentViewPrivate {
	gboolean _empty;
	gboolean _can_select;
	ClocksIconView* icon_view;
	GtkButton* select_button;
	GtkButton* cancel_button;
	GMenuModel* selection_menu;
	GtkMenuButton* selection_menubutton;
	GtkLabel* selection_menubutton_label;
	GtkGrid* grid;
	GtkButton* delete_button;
	ClocksHeaderBar* header_bar;
};

typedef gint (*ClocksContentViewSortFunc) (ClocksContentItem* item1, ClocksContentItem* item2, void* user_data);
struct _Block5Data {
	int _ref_count_;
	ClocksContentView* self;
	ClocksContentViewSortFunc sort_func;
	gpointer sort_func_target;
};

struct _Block6Data {
	int _ref_count_;
	ClocksContentView* self;
	GtkActionBar* action_bar;
};

struct _ClocksAmPmToggleButton {
	GtkButton parent_instance;
	ClocksAmPmToggleButtonPrivate * priv;
};

struct _ClocksAmPmToggleButtonClass {
	GtkButtonClass parent_class;
};

typedef enum  {
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM,
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM
} ClocksAmPmToggleButtonAmPm;

struct _ClocksAmPmToggleButtonPrivate {
	ClocksAmPmToggleButtonAmPm _choice;
	GtkStack* stack;
	GtkLabel* am_label;
	GtkLabel* pm_label;
};

struct _ClocksAnalogFrame {
	GtkFrame parent_instance;
	ClocksAnalogFramePrivate * priv;
};

struct _ClocksAnalogFrameClass {
	GtkFrameClass parent_class;
	void (*draw_progress) (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius);
};


static gpointer clocks_header_bar_parent_class = NULL;
static gpointer clocks_title_renderer_parent_class = NULL;
static gpointer clocks_digital_clock_renderer_parent_class = NULL;
static gpointer clocks_icon_view_parent_class = NULL;
static gpointer clocks_content_view_parent_class = NULL;
static gpointer clocks_am_pm_toggle_button_parent_class = NULL;
static gpointer clocks_analog_frame_parent_class = NULL;

GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_header_bar_mode_get_type (void) G_GNUC_CONST;
#define CLOCKS_HEADER_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarPrivate))
enum  {
	CLOCKS_HEADER_BAR_DUMMY_PROPERTY,
	CLOCKS_HEADER_BAR_MODE
};
void clocks_header_bar_clear (ClocksHeaderBar* self);
ClocksHeaderBar* clocks_header_bar_new (void);
ClocksHeaderBar* clocks_header_bar_construct (GType object_type);
ClocksHeaderBarMode clocks_header_bar_get_mode (ClocksHeaderBar* self);
void clocks_header_bar_set_mode (ClocksHeaderBar* self, ClocksHeaderBarMode value);
static void clocks_header_bar_finalize (GObject* obj);
static void _vala_clocks_header_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_header_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_title_renderer_get_type (void) G_GNUC_CONST;
#define CLOCKS_TITLE_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRendererPrivate))
enum  {
	CLOCKS_TITLE_RENDERER_DUMMY_PROPERTY,
	CLOCKS_TITLE_RENDERER_TITLE,
	CLOCKS_TITLE_RENDERER_TITLE_ICON
};
ClocksTitleRenderer* clocks_title_renderer_new (void);
ClocksTitleRenderer* clocks_title_renderer_construct (GType object_type);
static void clocks_title_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
const gchar* clocks_title_renderer_get_title_icon (ClocksTitleRenderer* self);
const gchar* clocks_title_renderer_get_title (ClocksTitleRenderer* self);
void clocks_title_renderer_set_title (ClocksTitleRenderer* self, const gchar* value);
void clocks_title_renderer_set_title_icon (ClocksTitleRenderer* self, const gchar* value);
static void clocks_title_renderer_finalize (GObject* obj);
static void _vala_clocks_title_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_title_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_digital_clock_renderer_get_type (void) G_GNUC_CONST;
#define CLOCKS_DIGITAL_CLOCK_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRendererPrivate))
enum  {
	CLOCKS_DIGITAL_CLOCK_RENDERER_DUMMY_PROPERTY,
	CLOCKS_DIGITAL_CLOCK_RENDERER_TEXT,
	CLOCKS_DIGITAL_CLOCK_RENDERER_SUBTEXT,
	CLOCKS_DIGITAL_CLOCK_RENDERER_CSS_CLASS,
	CLOCKS_DIGITAL_CLOCK_RENDERER_CHECKED,
	CLOCKS_DIGITAL_CLOCK_RENDERER_TOGGLE_VISIBLE,
	CLOCKS_DIGITAL_CLOCK_RENDERER_SELECTABLE
};
#define CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE 256
#define CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE 40
#define CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_MARGIN (CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE / 4)
#define CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_MARGIN_BOTTOM (CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE / 8)
ClocksDigitalClockRenderer* clocks_digital_clock_renderer_new (void);
ClocksDigitalClockRenderer* clocks_digital_clock_renderer_construct (GType object_type);
static void clocks_digital_clock_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
const gchar* clocks_digital_clock_renderer_get_css_class (ClocksDigitalClockRenderer* self);
const gchar* clocks_digital_clock_renderer_get_text (ClocksDigitalClockRenderer* self);
const gchar* clocks_digital_clock_renderer_get_subtext (ClocksDigitalClockRenderer* self);
gboolean clocks_digital_clock_renderer_get_selectable (ClocksDigitalClockRenderer* self);
gboolean clocks_digital_clock_renderer_get_toggle_visible (ClocksDigitalClockRenderer* self);
gboolean clocks_digital_clock_renderer_get_checked (ClocksDigitalClockRenderer* self);
void clocks_digital_clock_renderer_set_text (ClocksDigitalClockRenderer* self, const gchar* value);
void clocks_digital_clock_renderer_set_subtext (ClocksDigitalClockRenderer* self, const gchar* value);
void clocks_digital_clock_renderer_set_css_class (ClocksDigitalClockRenderer* self, const gchar* value);
void clocks_digital_clock_renderer_set_checked (ClocksDigitalClockRenderer* self, gboolean value);
void clocks_digital_clock_renderer_set_toggle_visible (ClocksDigitalClockRenderer* self, gboolean value);
void clocks_digital_clock_renderer_set_selectable (ClocksDigitalClockRenderer* self, gboolean value);
static void clocks_digital_clock_renderer_finalize (GObject* obj);
static void _vala_clocks_digital_clock_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_digital_clock_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_content_item_get_type (void) G_GNUC_CONST;
void clocks_content_item_get_thumb_properties (ClocksContentItem* self, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
const gchar* clocks_content_item_get_name (ClocksContentItem* self);
void clocks_content_item_set_name (ClocksContentItem* self, const gchar* value);
const gchar* clocks_content_item_get_title_icon (ClocksContentItem* self);
void clocks_content_item_set_title_icon (ClocksContentItem* self, const gchar* value);
gboolean clocks_content_item_get_selectable (ClocksContentItem* self);
void clocks_content_item_set_selectable (ClocksContentItem* self, gboolean value);
GType clocks_icon_view_get_type (void) G_GNUC_CONST;
GType clocks_icon_view_mode_get_type (void) G_GNUC_CONST;
#define CLOCKS_ICON_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_ICON_VIEW, ClocksIconViewPrivate))
enum  {
	CLOCKS_ICON_VIEW_DUMMY_PROPERTY,
	CLOCKS_ICON_VIEW_MODE
};
GType clocks_icon_view_column_get_type (void) G_GNUC_CONST;
ClocksIconView* clocks_icon_view_new (void);
ClocksIconView* clocks_icon_view_construct (GType object_type);
static void __lambda10_ (ClocksIconView* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter);
static void ___lambda10__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void __lambda11_ (ClocksIconView* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter);
static void ___lambda11__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static gboolean clocks_icon_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void clocks_icon_view_set_mode (ClocksIconView* self, ClocksIconViewMode value);
ClocksIconViewMode clocks_icon_view_get_mode (ClocksIconView* self);
void clocks_icon_view_add_item (ClocksIconView* self, GObject* item);
void clocks_icon_view_prepend (ClocksIconView* self, GObject* item);
GList* clocks_icon_view_get_selected_items (ClocksIconView* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda13_ (Block4Data* _data4_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static gboolean ___lambda13__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
void clocks_icon_view_select_all (ClocksIconView* self);
static gboolean __lambda14_ (ClocksIconView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static gboolean ___lambda14__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
void clocks_icon_view_unselect_all (ClocksIconView* self);
static gboolean __lambda12_ (ClocksIconView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static gboolean ___lambda12__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
void clocks_icon_view_remove_selected (ClocksIconView* self);
static void clocks_icon_view_finalize (GObject* obj);
static void _vala_clocks_icon_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_icon_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_content_view_get_type (void) G_GNUC_CONST;
#define CLOCKS_CONTENT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewPrivate))
enum  {
	CLOCKS_CONTENT_VIEW_DUMMY_PROPERTY,
	CLOCKS_CONTENT_VIEW_EMPTY
};
void clocks_content_view_add_item (ClocksContentView* self, ClocksContentItem* item);
static void clocks_content_view_update_props_on_insert (ClocksContentView* self, ClocksContentItem* item);
void clocks_content_view_prepend (ClocksContentView* self, ClocksContentItem* item);
static void clocks_content_view_update_props_on_remove (ClocksContentView* self);
gboolean clocks_content_view_get_empty (ClocksContentView* self);
static void clocks_content_view_set_empty (ClocksContentView* self, gboolean value);
static gboolean clocks_content_view_get_can_select (ClocksContentView* self);
static void clocks_content_view_set_can_select (ClocksContentView* self, gboolean value);
GList* clocks_content_view_get_selected_items (ClocksContentView* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void clocks_content_view_select_all (ClocksContentView* self);
void clocks_content_view_unselect_all (ClocksContentView* self);
gboolean clocks_content_view_escape_pressed (ClocksContentView* self);
void clocks_content_view_set_header_bar (ClocksContentView* self, ClocksHeaderBar* bar);
static void __lambda15_ (ClocksContentView* self);
static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda16_ (ClocksContentView* self);
static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda17_ (ClocksContentView* self);
static void ___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void clocks_content_view_update_header_bar (ClocksContentView* self);
void clocks_content_view_set_sorting (ClocksContentView* self, GtkSortType sort_type, ClocksContentViewSortFunc sort_func, void* sort_func_target);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gint __lambda18_ (Block5Data* _data5_, GtkTreeModel* model, GtkTreeIter* iter1, GtkTreeIter* iter2);
static gint ___lambda18__gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
ClocksContentView* clocks_content_view_new (void);
ClocksContentView* clocks_content_view_construct (GType object_type);
static void clocks_content_view_real_delete_selected (ClocksContentView* self);
static GObject * clocks_content_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _clocks_content_view___lambda19_ (ClocksContentView* self);
static void __clocks_content_view___lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _clocks_content_view___lambda20_ (Block6Data* _data6_);
static void __clocks_content_view___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _clocks_content_view___lambda21_ (ClocksContentView* self);
static void __clocks_content_view___lambda21__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void _clocks_content_view___lambda22_ (ClocksContentView* self, GtkTreePath* path);
static void __clocks_content_view___lambda22__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void clocks_content_view_finalize (GObject* obj);
static void _vala_clocks_content_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_content_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_am_pm_toggle_button_get_type (void) G_GNUC_CONST;
GType clocks_am_pm_toggle_button_am_pm_get_type (void) G_GNUC_CONST;
#define CLOCKS_AM_PM_TOGGLE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonPrivate))
enum  {
	CLOCKS_AM_PM_TOGGLE_BUTTON_DUMMY_PROPERTY,
	CLOCKS_AM_PM_TOGGLE_BUTTON_CHOICE
};
ClocksAmPmToggleButton* clocks_am_pm_toggle_button_new (void);
ClocksAmPmToggleButton* clocks_am_pm_toggle_button_construct (GType object_type);
static void __lambda35_ (ClocksAmPmToggleButton* self);
ClocksAmPmToggleButtonAmPm clocks_am_pm_toggle_button_get_choice (ClocksAmPmToggleButton* self);
void clocks_am_pm_toggle_button_set_choice (ClocksAmPmToggleButton* self, ClocksAmPmToggleButtonAmPm value);
static void ___lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_am_pm_toggle_button_finalize (GObject* obj);
static void _vala_clocks_am_pm_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_am_pm_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_analog_frame_get_type (void) G_GNUC_CONST;
enum  {
	CLOCKS_ANALOG_FRAME_DUMMY_PROPERTY
};
#define CLOCKS_ANALOG_FRAME_LINE_WIDTH 6
#define CLOCKS_ANALOG_FRAME_RADIUS_PAD 48
static gint clocks_analog_frame_calculate_diameter (ClocksAnalogFrame* self);
static void clocks_analog_frame_real_get_preferred_width (GtkWidget* base, gint* min_w, gint* natural_w);
static void clocks_analog_frame_real_get_preferred_height (GtkWidget* base, gint* min_h, gint* natural_h);
static void clocks_analog_frame_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static gboolean clocks_analog_frame_real_draw (GtkWidget* base, cairo_t* cr);
void clocks_analog_frame_draw_progress (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius);
static void clocks_analog_frame_real_draw_progress (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius);
ClocksAnalogFrame* clocks_analog_frame_new (void);
ClocksAnalogFrame* clocks_analog_frame_construct (GType object_type);


GType clocks_header_bar_mode_get_type (void) {
	static volatile gsize clocks_header_bar_mode_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_header_bar_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_HEADER_BAR_MODE_NORMAL, "CLOCKS_HEADER_BAR_MODE_NORMAL", "normal"}, {CLOCKS_HEADER_BAR_MODE_SELECTION, "CLOCKS_HEADER_BAR_MODE_SELECTION", "selection"}, {CLOCKS_HEADER_BAR_MODE_STANDALONE, "CLOCKS_HEADER_BAR_MODE_STANDALONE", "standalone"}, {0, NULL, NULL}};
		GType clocks_header_bar_mode_type_id;
		clocks_header_bar_mode_type_id = g_enum_register_static ("ClocksHeaderBarMode", values);
		g_once_init_leave (&clocks_header_bar_mode_type_id__volatile, clocks_header_bar_mode_type_id);
	}
	return clocks_header_bar_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void clocks_header_bar_clear (ClocksHeaderBar* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_header_bar_set_custom_title ((GtkHeaderBar*) self, NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp1_ = NULL;
			GtkWidget* w = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp1_;
			{
				GtkWidget* _tmp2_ = NULL;
				_tmp2_ = w;
				gtk_widget_hide (_tmp2_);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
}


ClocksHeaderBar* clocks_header_bar_construct (GType object_type) {
	ClocksHeaderBar * self = NULL;
	self = (ClocksHeaderBar*) g_object_new (object_type, NULL);
	return self;
}


ClocksHeaderBar* clocks_header_bar_new (void) {
	return clocks_header_bar_construct (CLOCKS_TYPE_HEADER_BAR);
}


ClocksHeaderBarMode clocks_header_bar_get_mode (ClocksHeaderBar* self) {
	ClocksHeaderBarMode result;
	ClocksHeaderBarMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void clocks_header_bar_set_mode (ClocksHeaderBar* self, ClocksHeaderBarMode value) {
	ClocksHeaderBarMode _tmp0_ = 0;
	ClocksHeaderBarMode _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	_tmp1_ = value;
	if (_tmp0_ != _tmp1_) {
		ClocksHeaderBarMode _tmp2_ = 0;
		ClocksHeaderBarMode _tmp3_ = 0;
		_tmp2_ = value;
		self->priv->_mode = _tmp2_;
		_tmp3_ = self->priv->_mode;
		if (_tmp3_ == CLOCKS_HEADER_BAR_MODE_SELECTION) {
			GtkStyleContext* _tmp4_ = NULL;
			_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
			gtk_style_context_add_class (_tmp4_, "selection-mode");
		} else {
			GtkStyleContext* _tmp5_ = NULL;
			_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
			gtk_style_context_remove_class (_tmp5_, "selection-mode");
		}
		g_object_notify ((GObject*) self, "mode");
	}
}


static void clocks_header_bar_class_init (ClocksHeaderBarClass * klass) {
	clocks_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksHeaderBarPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_header_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_header_bar_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_header_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_HEADER_BAR_MODE, g_param_spec_enum ("mode", "mode", "mode", CLOCKS_HEADER_BAR_TYPE_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_header_bar_instance_init (ClocksHeaderBar * self) {
	self->priv = CLOCKS_HEADER_BAR_GET_PRIVATE (self);
}


static void clocks_header_bar_finalize (GObject* obj) {
	ClocksHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar);
	G_OBJECT_CLASS (clocks_header_bar_parent_class)->finalize (obj);
}


GType clocks_header_bar_get_type (void) {
	static volatile gsize clocks_header_bar_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_header_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksHeaderBar), 0, (GInstanceInitFunc) clocks_header_bar_instance_init, NULL };
		GType clocks_header_bar_type_id;
		clocks_header_bar_type_id = g_type_register_static (gtk_header_bar_get_type (), "ClocksHeaderBar", &g_define_type_info, 0);
		g_once_init_leave (&clocks_header_bar_type_id__volatile, clocks_header_bar_type_id);
	}
	return clocks_header_bar_type_id__volatile;
}


static void _vala_clocks_header_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar);
	switch (property_id) {
		case CLOCKS_HEADER_BAR_MODE:
		g_value_set_enum (value, clocks_header_bar_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_header_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar);
	switch (property_id) {
		case CLOCKS_HEADER_BAR_MODE:
		clocks_header_bar_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ClocksTitleRenderer* clocks_title_renderer_construct (GType object_type) {
	ClocksTitleRenderer * self = NULL;
	self = (ClocksTitleRenderer*) g_object_new (object_type, NULL);
	self->priv->ICON_YOFF = 5;
	self->priv->ICON_XOFF = 25;
	self->priv->ICON_SIZE = 18;
	return self;
}


ClocksTitleRenderer* clocks_title_renderer_new (void) {
	return clocks_title_renderer_construct (CLOCKS_TYPE_TITLE_RENDERER);
}


static void clocks_title_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	ClocksTitleRenderer * self;
	cairo_t* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_ = {0};
	GtkCellRendererState _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ClocksTitleRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = cr;
	_tmp1_ = widget;
	_tmp2_ = *cell_area;
	_tmp3_ = *cell_area;
	_tmp4_ = flags;
	GTK_CELL_RENDERER_CLASS (clocks_title_renderer_parent_class)->render ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), _tmp0_, _tmp1_, &_tmp2_, &_tmp3_, _tmp4_);
	_tmp5_ = self->priv->_title_icon;
	if (_tmp5_ != NULL) {
		GtkStyleContext* context = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkStyleContext* _tmp7_ = NULL;
		GtkStyleContext* _tmp8_ = NULL;
		GtkStyleContext* _tmp9_ = NULL;
		cairo_t* _tmp10_ = NULL;
		cairo_t* _tmp11_ = NULL;
		GdkRectangle _tmp12_ = {0};
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		GdkRectangle _tmp15_ = {0};
		gint _tmp16_ = 0;
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
		PangoLayout* layout = NULL;
		GtkWidget* _tmp19_ = NULL;
		PangoLayout* _tmp20_ = NULL;
		PangoLayout* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		PangoLayout* _tmp24_ = NULL;
		gint text_w = 0;
		gint text_h = 0;
		PangoLayout* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint x = 0;
		GdkRectangle _tmp28_ = {0};
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint y = 0;
		gint _tmp32_ = 0;
		GtkWidget* _tmp33_ = NULL;
		GtkTextDirection _tmp34_ = 0;
		GtkIconTheme* icon_theme = NULL;
		GdkScreen* _tmp40_ = NULL;
		GtkIconTheme* _tmp41_ = NULL;
		GtkIconTheme* _tmp42_ = NULL;
		GtkStyleContext* _tmp57_ = NULL;
		cairo_t* _tmp58_ = NULL;
		_tmp6_ = widget;
		_tmp7_ = gtk_widget_get_style_context (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		context = _tmp8_;
		_tmp9_ = context;
		gtk_style_context_save (_tmp9_);
		_tmp10_ = cr;
		cairo_save (_tmp10_);
		_tmp11_ = cr;
		_tmp12_ = *cell_area;
		gdk_cairo_rectangle (_tmp11_, &_tmp12_);
		_tmp13_ = cr;
		cairo_clip (_tmp13_);
		_tmp14_ = cr;
		_tmp15_ = *cell_area;
		_tmp16_ = _tmp15_.x;
		_tmp17_ = *cell_area;
		_tmp18_ = _tmp17_.y;
		cairo_translate (_tmp14_, (gdouble) _tmp16_, (gdouble) _tmp18_);
		_tmp19_ = widget;
		_tmp20_ = gtk_widget_create_pango_layout (_tmp19_, "");
		layout = _tmp20_;
		_tmp21_ = layout;
		_tmp22_ = clocks_title_renderer_get_title (self);
		_tmp23_ = _tmp22_;
		pango_layout_set_markup (_tmp21_, _tmp23_, -1);
		_tmp24_ = layout;
		pango_layout_set_alignment (_tmp24_, PANGO_ALIGN_CENTER);
		_tmp25_ = layout;
		pango_layout_get_pixel_size (_tmp25_, &_tmp26_, &_tmp27_);
		text_w = _tmp26_;
		text_h = _tmp27_;
		_tmp28_ = *cell_area;
		_tmp29_ = _tmp28_.width;
		_tmp30_ = text_w;
		_tmp31_ = self->priv->ICON_XOFF;
		x = ((_tmp29_ - _tmp30_) / 2) - _tmp31_;
		_tmp32_ = self->priv->ICON_YOFF;
		y = _tmp32_;
		_tmp33_ = widget;
		_tmp34_ = gtk_widget_get_direction (_tmp33_);
		if (_tmp34_ == GTK_TEXT_DIR_RTL) {
			GdkRectangle _tmp35_ = {0};
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			_tmp35_ = *cell_area;
			_tmp36_ = _tmp35_.width;
			_tmp37_ = text_w;
			_tmp38_ = self->priv->ICON_XOFF;
			_tmp39_ = self->priv->ICON_SIZE;
			x = (((_tmp36_ + _tmp37_) / 2) + _tmp38_) - _tmp39_;
		}
		_tmp40_ = gdk_screen_get_default ();
		_tmp41_ = gtk_icon_theme_get_for_screen (_tmp40_);
		_tmp42_ = _g_object_ref0 (_tmp41_);
		icon_theme = _tmp42_;
		{
			GtkIconInfo* icon_info = NULL;
			GtkIconTheme* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gint _tmp45_ = 0;
			GtkIconInfo* _tmp46_ = NULL;
			GtkIconInfo* _tmp47_ = NULL;
			GdkPixbuf* pixbuf = NULL;
			GtkIconInfo* _tmp48_ = NULL;
			GdkPixbuf* _tmp49_ = NULL;
			GtkStyleContext* _tmp50_ = NULL;
			cairo_t* _tmp51_ = NULL;
			GdkPixbuf* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			gint _tmp54_ = 0;
			_tmp43_ = icon_theme;
			_tmp44_ = self->priv->_title_icon;
			_tmp45_ = self->priv->ICON_SIZE;
			_tmp46_ = gtk_icon_theme_lookup_icon (_tmp43_, _tmp44_, _tmp45_, 0);
			icon_info = _tmp46_;
			_tmp47_ = icon_info;
			_vala_assert (_tmp47_ != NULL, "icon_info != null");
			_tmp48_ = icon_info;
			_tmp49_ = gtk_icon_info_load_icon (_tmp48_, &_inner_error_);
			pixbuf = _tmp49_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_gtk_icon_info_free0 (icon_info);
				goto __catch7_g_error;
			}
			_tmp50_ = context;
			_tmp51_ = cr;
			_tmp52_ = pixbuf;
			_tmp53_ = x;
			_tmp54_ = y;
			gtk_render_icon (_tmp50_, _tmp51_, _tmp52_, (gdouble) _tmp53_, (gdouble) _tmp54_);
			_g_object_unref0 (pixbuf);
			_gtk_icon_info_free0 (icon_info);
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			GError* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp55_ = e;
			_tmp56_ = _tmp55_->message;
			g_warning ("widgets.vala:117: %s", _tmp56_);
			_g_error_free0 (e);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (icon_theme);
			_g_object_unref0 (layout);
			_g_object_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp57_ = context;
		gtk_style_context_restore (_tmp57_);
		_tmp58_ = cr;
		cairo_restore (_tmp58_);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (layout);
		_g_object_unref0 (context);
	}
}


const gchar* clocks_title_renderer_get_title (ClocksTitleRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void clocks_title_renderer_set_title (ClocksTitleRenderer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	_tmp2_ = self->priv->_title;
	g_object_set ((GtkCellRendererText*) self, "markup", _tmp2_, NULL);
	g_object_notify ((GObject *) self, "title");
}


const gchar* clocks_title_renderer_get_title_icon (ClocksTitleRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title_icon;
	result = _tmp0_;
	return result;
}


void clocks_title_renderer_set_title_icon (ClocksTitleRenderer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title_icon);
	self->priv->_title_icon = _tmp1_;
	g_object_notify ((GObject *) self, "title-icon");
}


static void clocks_title_renderer_class_init (ClocksTitleRendererClass * klass) {
	clocks_title_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksTitleRendererPrivate));
	((GtkCellRendererClass *) klass)->render = clocks_title_renderer_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_title_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_title_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_title_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TITLE_RENDERER_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TITLE_RENDERER_TITLE_ICON, g_param_spec_string ("title-icon", "title-icon", "title-icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_title_renderer_instance_init (ClocksTitleRenderer * self) {
	self->priv = CLOCKS_TITLE_RENDERER_GET_PRIVATE (self);
	self->priv->_title_icon = NULL;
}


static void clocks_title_renderer_finalize (GObject* obj) {
	ClocksTitleRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRenderer);
	_g_free0 (self->priv->_title_icon);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (clocks_title_renderer_parent_class)->finalize (obj);
}


GType clocks_title_renderer_get_type (void) {
	static volatile gsize clocks_title_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_title_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksTitleRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_title_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTitleRenderer), 0, (GInstanceInitFunc) clocks_title_renderer_instance_init, NULL };
		GType clocks_title_renderer_type_id;
		clocks_title_renderer_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "ClocksTitleRenderer", &g_define_type_info, 0);
		g_once_init_leave (&clocks_title_renderer_type_id__volatile, clocks_title_renderer_type_id);
	}
	return clocks_title_renderer_type_id__volatile;
}


static void _vala_clocks_title_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksTitleRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRenderer);
	switch (property_id) {
		case CLOCKS_TITLE_RENDERER_TITLE:
		g_value_set_string (value, clocks_title_renderer_get_title (self));
		break;
		case CLOCKS_TITLE_RENDERER_TITLE_ICON:
		g_value_set_string (value, clocks_title_renderer_get_title_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_title_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksTitleRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRenderer);
	switch (property_id) {
		case CLOCKS_TITLE_RENDERER_TITLE:
		clocks_title_renderer_set_title (self, g_value_get_string (value));
		break;
		case CLOCKS_TITLE_RENDERER_TITLE_ICON:
		clocks_title_renderer_set_title_icon (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ClocksDigitalClockRenderer* clocks_digital_clock_renderer_construct (GType object_type) {
	ClocksDigitalClockRenderer * self = NULL;
	self = (ClocksDigitalClockRenderer*) g_object_new (object_type, NULL);
	return self;
}


ClocksDigitalClockRenderer* clocks_digital_clock_renderer_new (void) {
	return clocks_digital_clock_renderer_construct (CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER);
}


static gpointer _pango_layout_line_ref0 (gpointer self) {
	return self ? pango_layout_line_ref (self) : NULL;
}


static void clocks_digital_clock_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	ClocksDigitalClockRenderer * self;
	GtkStyleContext* context = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	GdkRectangle _tmp9_ = {0};
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	GdkRectangle _tmp12_ = {0};
	gint _tmp13_ = 0;
	GdkRectangle _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint margin = 0;
	GdkRectangle _tmp16_ = {0};
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	GdkPixbuf* _tmp19_ = NULL;
	GdkPixbuf* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gint w = 0;
	GdkRectangle _tmp39_ = {0};
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	PangoLayout* layout = NULL;
	GtkWidget* _tmp42_ = NULL;
	PangoLayout* _tmp43_ = NULL;
	PangoLayout* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	PangoLayout* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	PangoLayout* _tmp50_ = NULL;
	gint text_w = 0;
	gint text_h = 0;
	PangoLayout* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	PangoLayout* layout_subtext = NULL;
	gint subtext_w = 0;
	gint subtext_h = 0;
	gint subtext_pad = 0;
	const gchar* _tmp54_ = NULL;
	gint stripe_h = 0;
	gint x = 0;
	gint _tmp75_ = 0;
	gint y = 0;
	GdkRectangle _tmp76_ = {0};
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	GtkStyleContext* _tmp79_ = NULL;
	GtkStyleContext* _tmp80_ = NULL;
	cairo_t* _tmp81_ = NULL;
	gint _tmp82_ = 0;
	gint _tmp83_ = 0;
	gint _tmp84_ = 0;
	gint _tmp85_ = 0;
	GtkStyleContext* _tmp86_ = NULL;
	cairo_t* _tmp87_ = NULL;
	gint _tmp88_ = 0;
	gint _tmp89_ = 0;
	gint _tmp90_ = 0;
	gint _tmp91_ = 0;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
	gint _tmp94_ = 0;
	gint _tmp95_ = 0;
	gint _tmp96_ = 0;
	GtkStyleContext* _tmp97_ = NULL;
	cairo_t* _tmp98_ = NULL;
	gint _tmp99_ = 0;
	gint _tmp100_ = 0;
	PangoLayout* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkStyleContext* _tmp111_ = NULL;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_ = FALSE;
	cairo_t* _tmp144_ = NULL;
	self = (ClocksDigitalClockRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	gtk_style_context_save (_tmp3_);
	_tmp4_ = context;
	gtk_style_context_add_class (_tmp4_, "clocks-digital-renderer");
	_tmp5_ = context;
	_tmp6_ = self->priv->_css_class;
	gtk_style_context_add_class (_tmp5_, _tmp6_);
	_tmp7_ = cr;
	cairo_save (_tmp7_);
	_tmp8_ = cr;
	_tmp9_ = *cell_area;
	gdk_cairo_rectangle (_tmp8_, &_tmp9_);
	_tmp10_ = cr;
	cairo_clip (_tmp10_);
	_tmp11_ = cr;
	_tmp12_ = *cell_area;
	_tmp13_ = _tmp12_.x;
	_tmp14_ = *cell_area;
	_tmp15_ = _tmp14_.y;
	cairo_translate (_tmp11_, (gdouble) _tmp13_, (gdouble) _tmp15_);
	_tmp16_ = *cell_area;
	_tmp17_ = _tmp16_.width;
	_tmp18_ = MAX (CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_MARGIN, (gint) ((_tmp17_ - CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE) / 2));
	margin = _tmp18_;
	g_object_get ((GtkCellRendererPixbuf*) self, "pixbuf", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_ != NULL;
	_g_object_unref0 (_tmp21_);
	if (_tmp22_) {
		GdkRectangle area = {0};
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GdkRectangle _tmp25_ = {0};
		cairo_t* _tmp26_ = NULL;
		GtkWidget* _tmp27_ = NULL;
		GdkRectangle _tmp28_ = {0};
		GdkRectangle _tmp29_ = {0};
		GtkCellRendererState _tmp30_ = 0;
		_tmp23_ = margin;
		_tmp24_ = margin;
		_tmp25_.x = _tmp23_;
		_tmp25_.y = _tmp24_;
		_tmp25_.width = CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE;
		_tmp25_.height = CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE;
		area = _tmp25_;
		_tmp26_ = cr;
		_tmp27_ = widget;
		_tmp28_ = area;
		_tmp29_ = area;
		_tmp30_ = flags;
		GTK_CELL_RENDERER_CLASS (clocks_digital_clock_renderer_parent_class)->render ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_pixbuf_get_type (), GtkCellRendererPixbuf), _tmp26_, _tmp27_, &_tmp28_, &_tmp29_, _tmp30_);
	} else {
		GtkStyleContext* _tmp31_ = NULL;
		cairo_t* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		GtkStyleContext* _tmp35_ = NULL;
		cairo_t* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		_tmp31_ = context;
		_tmp32_ = cr;
		_tmp33_ = margin;
		_tmp34_ = margin;
		gtk_render_frame (_tmp31_, _tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE);
		_tmp35_ = context;
		_tmp36_ = cr;
		_tmp37_ = margin;
		_tmp38_ = margin;
		gtk_render_background (_tmp35_, _tmp36_, (gdouble) _tmp37_, (gdouble) _tmp38_, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE);
	}
	_tmp39_ = *cell_area;
	_tmp40_ = _tmp39_.width;
	_tmp41_ = margin;
	w = _tmp40_ - (2 * _tmp41_);
	_tmp42_ = widget;
	_tmp43_ = gtk_widget_create_pango_layout (_tmp42_, "");
	layout = _tmp43_;
	_tmp44_ = layout;
	_tmp45_ = self->priv->_text;
	_tmp46_ = g_strdup_printf ("<span font_desc=\"32.0\">%s</span>", _tmp45_);
	_tmp47_ = _tmp46_;
	pango_layout_set_markup (_tmp44_, _tmp47_, -1);
	_g_free0 (_tmp47_);
	_tmp48_ = layout;
	_tmp49_ = w;
	pango_layout_set_width (_tmp48_, _tmp49_ * PANGO_SCALE);
	_tmp50_ = layout;
	pango_layout_set_alignment (_tmp50_, PANGO_ALIGN_CENTER);
	_tmp51_ = layout;
	pango_layout_get_pixel_size (_tmp51_, &_tmp52_, &_tmp53_);
	text_w = _tmp52_;
	text_h = _tmp53_;
	layout_subtext = NULL;
	subtext_w = 0;
	subtext_h = 0;
	subtext_pad = 0;
	_tmp54_ = self->priv->_subtext;
	if (_tmp54_ != NULL) {
		GtkWidget* _tmp55_ = NULL;
		PangoLayout* _tmp56_ = NULL;
		PangoLayout* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		PangoLayout* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		PangoLayout* _tmp63_ = NULL;
		PangoLayout* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		PangoLayoutLine* line = NULL;
		PangoLayout* _tmp67_ = NULL;
		PangoLayoutLine* _tmp68_ = NULL;
		PangoLayoutLine* _tmp69_ = NULL;
		PangoRectangle ink_rect = {0};
		PangoRectangle log_rect = {0};
		PangoLayoutLine* _tmp70_ = NULL;
		PangoRectangle _tmp71_ = {0};
		PangoRectangle _tmp72_ = {0};
		PangoRectangle _tmp73_ = {0};
		gint _tmp74_ = 0;
		_tmp55_ = widget;
		_tmp56_ = gtk_widget_create_pango_layout (_tmp55_, "");
		_g_object_unref0 (layout_subtext);
		layout_subtext = _tmp56_;
		_tmp57_ = layout_subtext;
		_tmp58_ = self->priv->_subtext;
		_tmp59_ = g_strdup_printf ("<span font_desc=\"14.0\">%s</span>", _tmp58_);
		_tmp60_ = _tmp59_;
		pango_layout_set_markup (_tmp57_, _tmp60_, -1);
		_g_free0 (_tmp60_);
		_tmp61_ = layout_subtext;
		_tmp62_ = w;
		pango_layout_set_width (_tmp61_, _tmp62_ * PANGO_SCALE);
		_tmp63_ = layout_subtext;
		pango_layout_set_alignment (_tmp63_, PANGO_ALIGN_CENTER);
		_tmp64_ = layout_subtext;
		pango_layout_get_pixel_size (_tmp64_, &_tmp65_, &_tmp66_);
		subtext_w = _tmp65_;
		subtext_h = _tmp66_;
		subtext_pad = 4;
		_tmp67_ = layout_subtext;
		_tmp68_ = pango_layout_get_line (_tmp67_, 0);
		_tmp69_ = _pango_layout_line_ref0 (_tmp68_);
		line = _tmp69_;
		_tmp70_ = line;
		pango_layout_line_get_pixel_extents (_tmp70_, &_tmp71_, &_tmp72_);
		ink_rect = _tmp71_;
		log_rect = _tmp72_;
		_tmp73_ = log_rect;
		_tmp74_ = _tmp73_.width;
		subtext_w = _tmp74_;
		_pango_layout_line_unref0 (line);
	}
	stripe_h = 128;
	_tmp75_ = margin;
	x = _tmp75_;
	_tmp76_ = *cell_area;
	_tmp77_ = _tmp76_.height;
	_tmp78_ = stripe_h;
	y = (_tmp77_ - _tmp78_) / 2;
	_tmp79_ = context;
	gtk_style_context_add_class (_tmp79_, "stripe");
	_tmp80_ = context;
	_tmp81_ = cr;
	_tmp82_ = x;
	_tmp83_ = y;
	_tmp84_ = w;
	_tmp85_ = stripe_h;
	gtk_render_frame (_tmp80_, _tmp81_, (gdouble) _tmp82_, (gdouble) _tmp83_, (gdouble) _tmp84_, (gdouble) _tmp85_);
	_tmp86_ = context;
	_tmp87_ = cr;
	_tmp88_ = x;
	_tmp89_ = y;
	_tmp90_ = w;
	_tmp91_ = stripe_h;
	gtk_render_background (_tmp86_, _tmp87_, (gdouble) _tmp88_, (gdouble) _tmp89_, (gdouble) _tmp90_, (gdouble) _tmp91_);
	_tmp92_ = y;
	_tmp93_ = stripe_h;
	_tmp94_ = text_h;
	_tmp95_ = subtext_h;
	_tmp96_ = subtext_pad;
	y = _tmp92_ + ((((_tmp93_ - _tmp94_) - _tmp95_) - _tmp96_) / 2);
	_tmp97_ = context;
	_tmp98_ = cr;
	_tmp99_ = x;
	_tmp100_ = y;
	_tmp101_ = layout;
	gtk_render_layout (_tmp97_, _tmp98_, (gdouble) _tmp99_, (gdouble) _tmp100_, _tmp101_);
	_tmp102_ = self->priv->_subtext;
	if (_tmp102_ != NULL) {
		gint _tmp103_ = 0;
		gint _tmp104_ = 0;
		gint _tmp105_ = 0;
		GtkStyleContext* _tmp106_ = NULL;
		cairo_t* _tmp107_ = NULL;
		gint _tmp108_ = 0;
		gint _tmp109_ = 0;
		PangoLayout* _tmp110_ = NULL;
		_tmp103_ = y;
		_tmp104_ = text_h;
		_tmp105_ = subtext_pad;
		y = _tmp103_ + (_tmp104_ + _tmp105_);
		_tmp106_ = context;
		_tmp107_ = cr;
		_tmp108_ = x;
		_tmp109_ = y;
		_tmp110_ = layout_subtext;
		gtk_render_layout (_tmp106_, _tmp107_, (gdouble) _tmp108_, (gdouble) _tmp109_, _tmp110_);
	}
	_tmp111_ = context;
	gtk_style_context_restore (_tmp111_);
	_tmp113_ = self->priv->_selectable;
	if (_tmp113_) {
		gboolean _tmp114_ = FALSE;
		_tmp114_ = self->priv->_toggle_visible;
		_tmp112_ = _tmp114_;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		gint xpad = 0;
		gint ypad = 0;
		gint x_offset = 0;
		gint _tmp115_ = 0;
		gint _tmp116_ = 0;
		GtkWidget* _tmp117_ = NULL;
		GtkTextDirection _tmp118_ = 0;
		gint check_x = 0;
		gint _tmp123_ = 0;
		gint check_y = 0;
		GdkRectangle _tmp124_ = {0};
		gint _tmp125_ = 0;
		gint _tmp126_ = 0;
		GtkStyleContext* _tmp127_ = NULL;
		GtkStyleContext* _tmp128_ = NULL;
		gboolean _tmp129_ = FALSE;
		GtkStyleContext* _tmp131_ = NULL;
		cairo_t* _tmp132_ = NULL;
		gint _tmp133_ = 0;
		gint _tmp134_ = 0;
		GtkStyleContext* _tmp135_ = NULL;
		cairo_t* _tmp136_ = NULL;
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		GtkStyleContext* _tmp139_ = NULL;
		cairo_t* _tmp140_ = NULL;
		gint _tmp141_ = 0;
		gint _tmp142_ = 0;
		GtkStyleContext* _tmp143_ = NULL;
		gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp115_, &_tmp116_);
		xpad = _tmp115_;
		ypad = _tmp116_;
		_tmp117_ = widget;
		_tmp118_ = gtk_widget_get_direction (_tmp117_);
		if (_tmp118_ == GTK_TEXT_DIR_RTL) {
			gint _tmp119_ = 0;
			_tmp119_ = xpad;
			x_offset = _tmp119_;
		} else {
			GdkRectangle _tmp120_ = {0};
			gint _tmp121_ = 0;
			gint _tmp122_ = 0;
			_tmp120_ = *cell_area;
			_tmp121_ = _tmp120_.width;
			_tmp122_ = xpad;
			x_offset = (_tmp121_ - CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE) - _tmp122_;
		}
		_tmp123_ = x_offset;
		check_x = _tmp123_;
		_tmp124_ = *cell_area;
		_tmp125_ = _tmp124_.height;
		_tmp126_ = ypad;
		check_y = (_tmp125_ - CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE) - _tmp126_;
		_tmp127_ = context;
		gtk_style_context_save (_tmp127_);
		_tmp128_ = context;
		gtk_style_context_add_class (_tmp128_, GTK_STYLE_CLASS_CHECK);
		_tmp129_ = self->priv->_checked;
		if (_tmp129_) {
			GtkStyleContext* _tmp130_ = NULL;
			_tmp130_ = context;
			gtk_style_context_set_state (_tmp130_, GTK_STATE_FLAG_CHECKED);
		}
		_tmp131_ = context;
		_tmp132_ = cr;
		_tmp133_ = check_x;
		_tmp134_ = check_y;
		gtk_render_background (_tmp131_, _tmp132_, (gdouble) _tmp133_, (gdouble) _tmp134_, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE);
		_tmp135_ = context;
		_tmp136_ = cr;
		_tmp137_ = check_x;
		_tmp138_ = check_y;
		gtk_render_frame (_tmp135_, _tmp136_, (gdouble) _tmp137_, (gdouble) _tmp138_, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE);
		_tmp139_ = context;
		_tmp140_ = cr;
		_tmp141_ = check_x;
		_tmp142_ = check_y;
		gtk_render_check (_tmp139_, _tmp140_, (gdouble) _tmp141_, (gdouble) _tmp142_, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE, (gdouble) CLOCKS_DIGITAL_CLOCK_RENDERER_CHECK_ICON_SIZE);
		_tmp143_ = context;
		gtk_style_context_restore (_tmp143_);
	}
	_tmp144_ = cr;
	cairo_restore (_tmp144_);
	_g_object_unref0 (layout_subtext);
	_g_object_unref0 (layout);
	_g_object_unref0 (context);
}


const gchar* clocks_digital_clock_renderer_get_text (ClocksDigitalClockRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}


void clocks_digital_clock_renderer_set_text (ClocksDigitalClockRenderer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	g_object_notify ((GObject *) self, "text");
}


const gchar* clocks_digital_clock_renderer_get_subtext (ClocksDigitalClockRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subtext;
	result = _tmp0_;
	return result;
}


void clocks_digital_clock_renderer_set_subtext (ClocksDigitalClockRenderer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_subtext);
	self->priv->_subtext = _tmp1_;
	g_object_notify ((GObject *) self, "subtext");
}


const gchar* clocks_digital_clock_renderer_get_css_class (ClocksDigitalClockRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_css_class;
	result = _tmp0_;
	return result;
}


void clocks_digital_clock_renderer_set_css_class (ClocksDigitalClockRenderer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_css_class);
	self->priv->_css_class = _tmp1_;
	g_object_notify ((GObject *) self, "css-class");
}


gboolean clocks_digital_clock_renderer_get_checked (ClocksDigitalClockRenderer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_checked;
	result = _tmp0_;
	return result;
}


void clocks_digital_clock_renderer_set_checked (ClocksDigitalClockRenderer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_checked = _tmp0_;
	g_object_notify ((GObject *) self, "checked");
}


gboolean clocks_digital_clock_renderer_get_toggle_visible (ClocksDigitalClockRenderer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_toggle_visible;
	result = _tmp0_;
	return result;
}


void clocks_digital_clock_renderer_set_toggle_visible (ClocksDigitalClockRenderer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_toggle_visible = _tmp0_;
	g_object_notify ((GObject *) self, "toggle-visible");
}


gboolean clocks_digital_clock_renderer_get_selectable (ClocksDigitalClockRenderer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_selectable;
	result = _tmp0_;
	return result;
}


void clocks_digital_clock_renderer_set_selectable (ClocksDigitalClockRenderer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_selectable = _tmp0_;
	g_object_notify ((GObject *) self, "selectable");
}


static void clocks_digital_clock_renderer_class_init (ClocksDigitalClockRendererClass * klass) {
	clocks_digital_clock_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksDigitalClockRendererPrivate));
	((GtkCellRendererClass *) klass)->render = clocks_digital_clock_renderer_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_digital_clock_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_digital_clock_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_digital_clock_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_DIGITAL_CLOCK_RENDERER_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_DIGITAL_CLOCK_RENDERER_SUBTEXT, g_param_spec_string ("subtext", "subtext", "subtext", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_DIGITAL_CLOCK_RENDERER_CSS_CLASS, g_param_spec_string ("css-class", "css-class", "css-class", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_DIGITAL_CLOCK_RENDERER_CHECKED, g_param_spec_boolean ("checked", "checked", "checked", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_DIGITAL_CLOCK_RENDERER_TOGGLE_VISIBLE, g_param_spec_boolean ("toggle-visible", "toggle-visible", "toggle-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_DIGITAL_CLOCK_RENDERER_SELECTABLE, g_param_spec_boolean ("selectable", "selectable", "selectable", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_digital_clock_renderer_instance_init (ClocksDigitalClockRenderer * self) {
	self->priv = CLOCKS_DIGITAL_CLOCK_RENDERER_GET_PRIVATE (self);
	self->priv->_checked = FALSE;
	self->priv->_toggle_visible = FALSE;
	self->priv->_selectable = TRUE;
}


static void clocks_digital_clock_renderer_finalize (GObject* obj) {
	ClocksDigitalClockRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRenderer);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_subtext);
	_g_free0 (self->priv->_css_class);
	G_OBJECT_CLASS (clocks_digital_clock_renderer_parent_class)->finalize (obj);
}


GType clocks_digital_clock_renderer_get_type (void) {
	static volatile gsize clocks_digital_clock_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_digital_clock_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksDigitalClockRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_digital_clock_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksDigitalClockRenderer), 0, (GInstanceInitFunc) clocks_digital_clock_renderer_instance_init, NULL };
		GType clocks_digital_clock_renderer_type_id;
		clocks_digital_clock_renderer_type_id = g_type_register_static (gtk_cell_renderer_pixbuf_get_type (), "ClocksDigitalClockRenderer", &g_define_type_info, 0);
		g_once_init_leave (&clocks_digital_clock_renderer_type_id__volatile, clocks_digital_clock_renderer_type_id);
	}
	return clocks_digital_clock_renderer_type_id__volatile;
}


static void _vala_clocks_digital_clock_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksDigitalClockRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRenderer);
	switch (property_id) {
		case CLOCKS_DIGITAL_CLOCK_RENDERER_TEXT:
		g_value_set_string (value, clocks_digital_clock_renderer_get_text (self));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_SUBTEXT:
		g_value_set_string (value, clocks_digital_clock_renderer_get_subtext (self));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_CSS_CLASS:
		g_value_set_string (value, clocks_digital_clock_renderer_get_css_class (self));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_CHECKED:
		g_value_set_boolean (value, clocks_digital_clock_renderer_get_checked (self));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_TOGGLE_VISIBLE:
		g_value_set_boolean (value, clocks_digital_clock_renderer_get_toggle_visible (self));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_SELECTABLE:
		g_value_set_boolean (value, clocks_digital_clock_renderer_get_selectable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_digital_clock_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksDigitalClockRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRenderer);
	switch (property_id) {
		case CLOCKS_DIGITAL_CLOCK_RENDERER_TEXT:
		clocks_digital_clock_renderer_set_text (self, g_value_get_string (value));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_SUBTEXT:
		clocks_digital_clock_renderer_set_subtext (self, g_value_get_string (value));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_CSS_CLASS:
		clocks_digital_clock_renderer_set_css_class (self, g_value_get_string (value));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_CHECKED:
		clocks_digital_clock_renderer_set_checked (self, g_value_get_boolean (value));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_TOGGLE_VISIBLE:
		clocks_digital_clock_renderer_set_toggle_visible (self, g_value_get_boolean (value));
		break;
		case CLOCKS_DIGITAL_CLOCK_RENDERER_SELECTABLE:
		clocks_digital_clock_renderer_set_selectable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void clocks_content_item_get_thumb_properties (ClocksContentItem* self, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class) {
	g_return_if_fail (self != NULL);
	CLOCKS_CONTENT_ITEM_GET_INTERFACE (self)->get_thumb_properties (self, text, subtext, pixbuf, css_class);
}


const gchar* clocks_content_item_get_name (ClocksContentItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return CLOCKS_CONTENT_ITEM_GET_INTERFACE (self)->get_name (self);
}


void clocks_content_item_set_name (ClocksContentItem* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	CLOCKS_CONTENT_ITEM_GET_INTERFACE (self)->set_name (self, value);
}


const gchar* clocks_content_item_get_title_icon (ClocksContentItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return CLOCKS_CONTENT_ITEM_GET_INTERFACE (self)->get_title_icon (self);
}


void clocks_content_item_set_title_icon (ClocksContentItem* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	CLOCKS_CONTENT_ITEM_GET_INTERFACE (self)->set_title_icon (self, value);
}


gboolean clocks_content_item_get_selectable (ClocksContentItem* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return CLOCKS_CONTENT_ITEM_GET_INTERFACE (self)->get_selectable (self);
}


void clocks_content_item_set_selectable (ClocksContentItem* self, gboolean value) {
	g_return_if_fail (self != NULL);
	CLOCKS_CONTENT_ITEM_GET_INTERFACE (self)->set_selectable (self, value);
}


static void clocks_content_item_base_init (ClocksContentItemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("title-icon", "title-icon", "title-icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("selectable", "selectable", "selectable", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType clocks_content_item_get_type (void) {
	static volatile gsize clocks_content_item_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_content_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksContentItemIface), (GBaseInitFunc) clocks_content_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType clocks_content_item_type_id;
		clocks_content_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "ClocksContentItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (clocks_content_item_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&clocks_content_item_type_id__volatile, clocks_content_item_type_id);
	}
	return clocks_content_item_type_id__volatile;
}


GType clocks_icon_view_mode_get_type (void) {
	static volatile gsize clocks_icon_view_mode_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_icon_view_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_ICON_VIEW_MODE_NORMAL, "CLOCKS_ICON_VIEW_MODE_NORMAL", "normal"}, {CLOCKS_ICON_VIEW_MODE_SELECTION, "CLOCKS_ICON_VIEW_MODE_SELECTION", "selection"}, {0, NULL, NULL}};
		GType clocks_icon_view_mode_type_id;
		clocks_icon_view_mode_type_id = g_enum_register_static ("ClocksIconViewMode", values);
		g_once_init_leave (&clocks_icon_view_mode_type_id__volatile, clocks_icon_view_mode_type_id);
	}
	return clocks_icon_view_mode_type_id__volatile;
}


GType clocks_icon_view_column_get_type (void) {
	static volatile gsize clocks_icon_view_column_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_icon_view_column_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_ICON_VIEW_COLUMN_SELECTED, "CLOCKS_ICON_VIEW_COLUMN_SELECTED", "selected"}, {CLOCKS_ICON_VIEW_COLUMN_ITEM, "CLOCKS_ICON_VIEW_COLUMN_ITEM", "item"}, {CLOCKS_ICON_VIEW_COLUMN_COLUMNS, "CLOCKS_ICON_VIEW_COLUMN_COLUMNS", "columns"}, {0, NULL, NULL}};
		GType clocks_icon_view_column_type_id;
		clocks_icon_view_column_type_id = g_enum_register_static ("ClocksIconViewColumn", values);
		g_once_init_leave (&clocks_icon_view_column_type_id__volatile, clocks_icon_view_column_type_id);
	}
	return clocks_icon_view_column_type_id__volatile;
}


static void __lambda10_ (ClocksIconView* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter) {
	ClocksContentItem* item = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	ClocksContentItem* _tmp2_ = NULL;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item, -1);
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		ClocksDigitalClockRenderer* renderer = NULL;
		GtkCellRenderer* _tmp3_ = NULL;
		ClocksDigitalClockRenderer* _tmp4_ = NULL;
		gchar* text = NULL;
		gchar* subtext = NULL;
		GdkPixbuf* pixbuf = NULL;
		gchar* css_class = NULL;
		ClocksContentItem* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		ClocksDigitalClockRenderer* _tmp10_ = NULL;
		ClocksContentItem* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		ClocksDigitalClockRenderer* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		ClocksDigitalClockRenderer* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		ClocksDigitalClockRenderer* _tmp18_ = NULL;
		GdkPixbuf* _tmp19_ = NULL;
		ClocksDigitalClockRenderer* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp3_ = cell;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRenderer));
		renderer = _tmp4_;
		_tmp5_ = item;
		clocks_content_item_get_thumb_properties (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
		_g_free0 (text);
		text = _tmp6_;
		_g_free0 (subtext);
		subtext = _tmp7_;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp8_;
		_g_free0 (css_class);
		css_class = _tmp9_;
		_tmp10_ = renderer;
		_tmp11_ = item;
		_tmp12_ = clocks_content_item_get_selectable (_tmp11_);
		_tmp13_ = _tmp12_;
		clocks_digital_clock_renderer_set_selectable (_tmp10_, _tmp13_);
		_tmp14_ = renderer;
		_tmp15_ = text;
		clocks_digital_clock_renderer_set_text (_tmp14_, _tmp15_);
		_tmp16_ = renderer;
		_tmp17_ = subtext;
		clocks_digital_clock_renderer_set_subtext (_tmp16_, _tmp17_);
		_tmp18_ = renderer;
		_tmp19_ = pixbuf;
		g_object_set ((GtkCellRendererPixbuf*) _tmp18_, "pixbuf", _tmp19_, NULL);
		_tmp20_ = renderer;
		_tmp21_ = css_class;
		clocks_digital_clock_renderer_set_css_class (_tmp20_, _tmp21_);
		_g_free0 (css_class);
		_g_object_unref0 (pixbuf);
		_g_free0 (subtext);
		_g_free0 (text);
		_g_object_unref0 (renderer);
	}
	_g_object_unref0 (item);
}


static void ___lambda10__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	__lambda10_ ((ClocksIconView*) self, cell_layout, cell, tree_model, iter);
}


static void __lambda11_ (ClocksIconView* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter) {
	ClocksContentItem* item = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	ClocksContentItem* _tmp2_ = NULL;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item, -1);
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		ClocksTitleRenderer* renderer = NULL;
		GtkCellRenderer* _tmp3_ = NULL;
		ClocksTitleRenderer* _tmp4_ = NULL;
		ClocksTitleRenderer* _tmp5_ = NULL;
		ClocksContentItem* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		ClocksTitleRenderer* _tmp11_ = NULL;
		ClocksContentItem* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp3_ = cell;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_TYPE_TITLE_RENDERER, ClocksTitleRenderer));
		renderer = _tmp4_;
		_tmp5_ = renderer;
		_tmp6_ = item;
		_tmp7_ = clocks_content_item_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
		_tmp10_ = _tmp9_;
		clocks_title_renderer_set_title (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = renderer;
		_tmp12_ = item;
		_tmp13_ = clocks_content_item_get_title_icon (_tmp12_);
		_tmp14_ = _tmp13_;
		clocks_title_renderer_set_title_icon (_tmp11_, _tmp14_);
		_g_object_unref0 (renderer);
	}
	_g_object_unref0 (item);
}


static void ___lambda11__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	__lambda11_ ((ClocksIconView*) self, cell_layout, cell, tree_model, iter);
}


ClocksIconView* clocks_icon_view_construct (GType object_type) {
	ClocksIconView * self = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	gint tile_width = 0;
	gint tile_height = 0;
	ClocksDigitalClockRenderer* _tmp4_ = NULL;
	ClocksDigitalClockRenderer* _tmp5_ = NULL;
	ClocksDigitalClockRenderer* _tmp6_ = NULL;
	ClocksDigitalClockRenderer* _tmp7_ = NULL;
	ClocksDigitalClockRenderer* _tmp8_ = NULL;
	ClocksDigitalClockRenderer* _tmp9_ = NULL;
	ClocksTitleRenderer* title_renderer = NULL;
	ClocksTitleRenderer* _tmp10_ = NULL;
	self = (ClocksIconView*) g_object_new (object_type, "selection-mode", GTK_SELECTION_NONE, "mode", CLOCKS_ICON_VIEW_MODE_NORMAL, NULL);
	_tmp0_ = gtk_list_store_new ((gint) CLOCKS_ICON_VIEW_COLUMN_COLUMNS, G_TYPE_BOOLEAN, CLOCKS_TYPE_CONTENT_ITEM, -1);
	_tmp1_ = _tmp0_;
	gtk_icon_view_set_model ((GtkIconView*) self, (GtkTreeModel*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "clocks-tiles-view");
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp3_, "content-view");
	gtk_icon_view_set_item_padding ((GtkIconView*) self, 0);
	gtk_icon_view_set_margin ((GtkIconView*) self, 12);
	tile_width = CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE + (2 * CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_MARGIN);
	tile_height = (CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_SIZE + CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_MARGIN) + CLOCKS_DIGITAL_CLOCK_RENDERER_TILE_MARGIN_BOTTOM;
	_tmp4_ = clocks_digital_clock_renderer_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->thumb_renderer);
	self->priv->thumb_renderer = _tmp4_;
	_tmp5_ = self->priv->thumb_renderer;
	gtk_cell_renderer_set_alignment ((GtkCellRenderer*) _tmp5_, 0.5f, 0.5f);
	_tmp6_ = self->priv->thumb_renderer;
	gtk_cell_renderer_set_fixed_size ((GtkCellRenderer*) _tmp6_, tile_width, tile_height);
	_tmp7_ = self->priv->thumb_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) self, (GtkCellRenderer*) _tmp7_, FALSE);
	_tmp8_ = self->priv->thumb_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self, (GtkCellRenderer*) _tmp8_, "checked", (gint) CLOCKS_ICON_VIEW_COLUMN_SELECTED);
	_tmp9_ = self->priv->thumb_renderer;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) self, (GtkCellRenderer*) _tmp9_, ___lambda10__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp10_ = clocks_title_renderer_new ();
	g_object_ref_sink (_tmp10_);
	title_renderer = _tmp10_;
	gtk_cell_renderer_set_alignment ((GtkCellRenderer*) title_renderer, 0.5f, 0.5f);
	gtk_cell_renderer_set_fixed_size ((GtkCellRenderer*) title_renderer, tile_width, -1);
	g_object_set ((GtkCellRendererText*) title_renderer, "alignment", PANGO_ALIGN_CENTER, NULL);
	g_object_set ((GtkCellRendererText*) title_renderer, "wrap-width", 220, NULL);
	g_object_set ((GtkCellRendererText*) title_renderer, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self, (GtkCellRenderer*) title_renderer, TRUE);
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) self, (GtkCellRenderer*) title_renderer, ___lambda11__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (title_renderer);
	return self;
}


ClocksIconView* clocks_icon_view_new (void) {
	return clocks_icon_view_construct (CLOCKS_TYPE_ICON_VIEW);
}


static gboolean clocks_icon_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ClocksIconView * self;
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GdkEventButton* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	self = (ClocksIconView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->x;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->y;
	_tmp4_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) self, (gint) _tmp1_, (gint) _tmp3_);
	path = _tmp4_;
	_tmp5_ = path;
	if (_tmp5_ != NULL) {
		GdkEventButton* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		ClocksIconViewMode _tmp8_ = 0;
		ClocksIconViewMode _tmp9_ = 0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->button;
		if (_tmp7_ == ((guint) GDK_BUTTON_SECONDARY)) {
			clocks_icon_view_set_mode (self, CLOCKS_ICON_VIEW_MODE_SELECTION);
		}
		_tmp8_ = clocks_icon_view_get_mode (self);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == CLOCKS_ICON_VIEW_MODE_SELECTION) {
			GtkListStore* store = NULL;
			GtkTreeModel* _tmp10_ = NULL;
			GtkTreeModel* _tmp11_ = NULL;
			GtkListStore* _tmp12_ = NULL;
			GtkTreeIter i = {0};
			GtkListStore* _tmp13_ = NULL;
			GtkTreePath* _tmp14_ = NULL;
			GtkTreeIter _tmp15_ = {0};
			gboolean _tmp16_ = FALSE;
			_tmp10_ = gtk_icon_view_get_model ((GtkIconView*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_list_store_get_type (), GtkListStore));
			store = _tmp12_;
			_tmp13_ = store;
			_tmp14_ = path;
			_tmp16_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp13_, &_tmp15_, _tmp14_);
			i = _tmp15_;
			if (_tmp16_) {
				gboolean selected = FALSE;
				ClocksContentItem* item = NULL;
				GtkListStore* _tmp17_ = NULL;
				GtkTreeIter _tmp18_ = {0};
				ClocksContentItem* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				_tmp17_ = store;
				_tmp18_ = i;
				gtk_tree_model_get ((GtkTreeModel*) _tmp17_, &_tmp18_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, &selected, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item, -1);
				_tmp19_ = item;
				_tmp20_ = clocks_content_item_get_selectable (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_) {
					GtkListStore* _tmp22_ = NULL;
					GtkTreeIter _tmp23_ = {0};
					gboolean _tmp24_ = FALSE;
					_tmp22_ = store;
					_tmp23_ = i;
					_tmp24_ = selected;
					gtk_list_store_set (_tmp22_, &_tmp23_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, !_tmp24_, -1);
					g_signal_emit_by_name ((GtkIconView*) self, "selection-changed");
				}
				_g_object_unref0 (item);
			}
			_g_object_unref0 (store);
		} else {
			GtkTreePath* _tmp25_ = NULL;
			_tmp25_ = path;
			gtk_icon_view_item_activated ((GtkIconView*) self, _tmp25_);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


void clocks_icon_view_add_item (ClocksIconView* self, GObject* item) {
	GtkListStore* store = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter i = {0};
	GtkTreeIter _tmp3_ = {0};
	GtkTreeIter _tmp4_ = {0};
	GObject* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = gtk_icon_view_get_model ((GtkIconView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp2_;
	gtk_list_store_append (store, &_tmp3_);
	i = _tmp3_;
	_tmp4_ = i;
	_tmp5_ = item;
	gtk_list_store_set (store, &_tmp4_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, FALSE, CLOCKS_ICON_VIEW_COLUMN_ITEM, _tmp5_, -1);
	_g_object_unref0 (store);
}


void clocks_icon_view_prepend (ClocksIconView* self, GObject* item) {
	GtkListStore* store = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter i = {0};
	GtkTreeIter _tmp3_ = {0};
	GtkTreeIter _tmp4_ = {0};
	GObject* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = gtk_icon_view_get_model ((GtkIconView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp2_;
	gtk_list_store_insert (store, &_tmp3_, 0);
	i = _tmp3_;
	_tmp4_ = i;
	_tmp5_ = item;
	gtk_list_store_set (store, &_tmp4_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, FALSE, CLOCKS_ICON_VIEW_COLUMN_ITEM, _tmp5_, -1);
	_g_object_unref0 (store);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ClocksIconView* self;
		self = _data4_->self;
		__g_list_free__gtk_tree_path_free0_0 (_data4_->items);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static gboolean __lambda13_ (Block4Data* _data4_, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	ClocksIconView* self;
	gboolean result = FALSE;
	gboolean selected = FALSE;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	self = _data4_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_list_store_get_type (), GtkListStore), &_tmp1_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, &selected, -1);
	_tmp2_ = selected;
	if (_tmp2_) {
		GtkTreePath* _tmp3_ = NULL;
		GtkTreePath* _tmp4_ = NULL;
		_tmp3_ = path;
		_tmp4_ = _gtk_tree_path_copy0 (_tmp3_);
		_data4_->items = g_list_prepend (_data4_->items, _tmp4_);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda13__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda13_ (self, model, path, iter);
	return result;
}


GList* clocks_icon_view_get_selected_items (ClocksIconView* self) {
	GList* result = NULL;
	Block4Data* _data4_;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->items = NULL;
	_tmp0_ = gtk_icon_view_get_model ((GtkIconView*) self);
	_tmp1_ = _tmp0_;
	gtk_tree_model_foreach (_tmp1_, ___lambda13__gtk_tree_model_foreach_func, _data4_);
	_data4_->items = g_list_reverse (_data4_->items);
	_tmp2_ = _data4_->items;
	_data4_->items = NULL;
	result = _tmp2_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


static gboolean __lambda14_ (ClocksIconView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	gboolean result = FALSE;
	ClocksContentItem* item = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	ClocksContentItem* _tmp3_ = NULL;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_list_store_get_type (), GtkListStore), &_tmp1_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item, -1);
	_tmp3_ = item;
	if (_tmp3_ != NULL) {
		ClocksContentItem* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = item;
		_tmp5_ = clocks_content_item_get_selectable (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkTreeModel* _tmp7_ = NULL;
		GtkTreeIter _tmp8_ = {0};
		_tmp7_ = model;
		_tmp8_ = *iter;
		gtk_list_store_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_store_get_type (), GtkListStore), &_tmp8_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, TRUE, -1);
	}
	result = FALSE;
	_g_object_unref0 (item);
	return result;
}


static gboolean ___lambda14__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda14_ ((ClocksIconView*) self, model, path, iter);
	return result;
}


void clocks_icon_view_select_all (ClocksIconView* self) {
	GtkListStore* model = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_view_get_model ((GtkIconView*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_list_store_get_type ()) ? ((GtkListStore*) _tmp0_) : NULL);
	model = _tmp1_;
	gtk_tree_model_foreach ((GtkTreeModel*) model, ___lambda14__gtk_tree_model_foreach_func, self);
	g_signal_emit_by_name ((GtkIconView*) self, "selection-changed");
	_g_object_unref0 (model);
}


static gboolean __lambda12_ (ClocksIconView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_list_store_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_list_store_get_type (), GtkListStore), &_tmp1_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, FALSE, -1);
	result = FALSE;
	return result;
}


static gboolean ___lambda12__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda12_ ((ClocksIconView*) self, model, path, iter);
	return result;
}


void clocks_icon_view_unselect_all (ClocksIconView* self) {
	GtkListStore* model = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_view_get_model ((GtkIconView*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_list_store_get_type ()) ? ((GtkListStore*) _tmp0_) : NULL);
	model = _tmp1_;
	gtk_tree_model_foreach ((GtkTreeModel*) model, ___lambda12__gtk_tree_model_foreach_func, self);
	g_signal_emit_by_name ((GtkIconView*) self, "selection-changed");
	_g_object_unref0 (model);
}


void clocks_icon_view_remove_selected (ClocksIconView* self) {
	GList* paths = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_icon_view_get_selected_items (self);
	paths = _tmp0_;
	paths = g_list_reverse (paths);
	_tmp1_ = paths;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp1_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp2_ = NULL;
			GtkTreePath* path = NULL;
			_tmp2_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp2_;
			{
				GtkTreeIter i = {0};
				GtkTreeModel* _tmp3_ = NULL;
				GtkTreeModel* _tmp4_ = NULL;
				GtkTreePath* _tmp5_ = NULL;
				GtkTreeIter _tmp6_ = {0};
				gboolean _tmp7_ = FALSE;
				_tmp3_ = gtk_icon_view_get_model ((GtkIconView*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = path;
				_tmp7_ = gtk_tree_model_get_iter ((GtkTreeModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_store_get_type (), GtkListStore), &_tmp6_, _tmp5_);
				i = _tmp6_;
				if (_tmp7_) {
					GtkTreeModel* _tmp8_ = NULL;
					GtkTreeModel* _tmp9_ = NULL;
					GtkTreeIter _tmp10_ = {0};
					_tmp8_ = gtk_icon_view_get_model ((GtkIconView*) self);
					_tmp9_ = _tmp8_;
					_tmp10_ = i;
					gtk_list_store_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_list_store_get_type (), GtkListStore), &_tmp10_);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	g_signal_emit_by_name ((GtkIconView*) self, "selection-changed");
	__g_list_free__gtk_tree_path_free0_0 (paths);
}


ClocksIconViewMode clocks_icon_view_get_mode (ClocksIconView* self) {
	ClocksIconViewMode result;
	ClocksIconViewMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void clocks_icon_view_set_mode (ClocksIconView* self, ClocksIconViewMode value) {
	ClocksIconViewMode _tmp0_ = 0;
	ClocksIconViewMode _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	_tmp1_ = value;
	if (_tmp0_ != _tmp1_) {
		ClocksIconViewMode _tmp2_ = 0;
		ClocksIconViewMode _tmp3_ = 0;
		ClocksDigitalClockRenderer* _tmp4_ = NULL;
		ClocksIconViewMode _tmp5_ = 0;
		_tmp2_ = value;
		self->priv->_mode = _tmp2_;
		_tmp3_ = self->priv->_mode;
		if (_tmp3_ != CLOCKS_ICON_VIEW_MODE_SELECTION) {
			clocks_icon_view_unselect_all (self);
		}
		_tmp4_ = self->priv->thumb_renderer;
		_tmp5_ = self->priv->_mode;
		clocks_digital_clock_renderer_set_toggle_visible (_tmp4_, _tmp5_ == CLOCKS_ICON_VIEW_MODE_SELECTION);
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify ((GObject *) self, "mode");
}


static void clocks_icon_view_class_init (ClocksIconViewClass * klass) {
	clocks_icon_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksIconViewPrivate));
	((GtkWidgetClass *) klass)->button_press_event = clocks_icon_view_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_icon_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_icon_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_icon_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ICON_VIEW_MODE, g_param_spec_enum ("mode", "mode", "mode", CLOCKS_ICON_VIEW_TYPE_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_icon_view_instance_init (ClocksIconView * self) {
	self->priv = CLOCKS_ICON_VIEW_GET_PRIVATE (self);
}


static void clocks_icon_view_finalize (GObject* obj) {
	ClocksIconView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_ICON_VIEW, ClocksIconView);
	_g_object_unref0 (self->priv->thumb_renderer);
	G_OBJECT_CLASS (clocks_icon_view_parent_class)->finalize (obj);
}


GType clocks_icon_view_get_type (void) {
	static volatile gsize clocks_icon_view_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_icon_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksIconViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_icon_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksIconView), 0, (GInstanceInitFunc) clocks_icon_view_instance_init, NULL };
		GType clocks_icon_view_type_id;
		clocks_icon_view_type_id = g_type_register_static (gtk_icon_view_get_type (), "ClocksIconView", &g_define_type_info, 0);
		g_once_init_leave (&clocks_icon_view_type_id__volatile, clocks_icon_view_type_id);
	}
	return clocks_icon_view_type_id__volatile;
}


static void _vala_clocks_icon_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksIconView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_ICON_VIEW, ClocksIconView);
	switch (property_id) {
		case CLOCKS_ICON_VIEW_MODE:
		g_value_set_enum (value, clocks_icon_view_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_icon_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksIconView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_ICON_VIEW, ClocksIconView);
	switch (property_id) {
		case CLOCKS_ICON_VIEW_MODE:
		clocks_icon_view_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void clocks_content_view_add_item (ClocksContentView* self, ClocksContentItem* item) {
	ClocksIconView* _tmp0_ = NULL;
	ClocksContentItem* _tmp1_ = NULL;
	ClocksContentItem* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = item;
	clocks_icon_view_add_item (_tmp0_, (GObject*) _tmp1_);
	_tmp2_ = item;
	clocks_content_view_update_props_on_insert (self, _tmp2_);
}


void clocks_content_view_prepend (ClocksContentView* self, ClocksContentItem* item) {
	ClocksIconView* _tmp0_ = NULL;
	ClocksContentItem* _tmp1_ = NULL;
	ClocksContentItem* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = item;
	clocks_icon_view_prepend (_tmp0_, (GObject*) _tmp1_);
	_tmp2_ = item;
	clocks_content_view_update_props_on_insert (self, _tmp2_);
}


static void clocks_content_view_update_props_on_remove (ClocksContentView* self) {
	GtkTreeIter iter = {0};
	gboolean local_empty = FALSE;
	gboolean local_can_select = FALSE;
	ClocksIconView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	local_empty = TRUE;
	local_can_select = FALSE;
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = gtk_icon_view_get_model ((GtkIconView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = gtk_tree_model_get_iter_first (_tmp2_, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		local_empty = FALSE;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ClocksContentItem* item = NULL;
				ClocksIconView* _tmp10_ = NULL;
				GtkTreeModel* _tmp11_ = NULL;
				GtkTreeModel* _tmp12_ = NULL;
				GtkTreeIter _tmp13_ = {0};
				ClocksContentItem* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				if (!_tmp5_) {
					ClocksIconView* _tmp6_ = NULL;
					GtkTreeModel* _tmp7_ = NULL;
					GtkTreeModel* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
					_tmp6_ = self->priv->icon_view;
					_tmp7_ = gtk_icon_view_get_model ((GtkIconView*) _tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp5_ = FALSE;
				_tmp10_ = self->priv->icon_view;
				_tmp11_ = gtk_icon_view_get_model ((GtkIconView*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = iter;
				gtk_tree_model_get (_tmp12_, &_tmp13_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item, -1);
				_tmp14_ = item;
				_tmp15_ = clocks_content_item_get_selectable (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					local_can_select = TRUE;
					_g_object_unref0 (item);
					break;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp17_ = local_empty;
	_tmp18_ = self->priv->_empty;
	if (_tmp17_ != _tmp18_) {
		gboolean _tmp19_ = FALSE;
		_tmp19_ = local_empty;
		clocks_content_view_set_empty (self, _tmp19_);
	}
	_tmp20_ = local_can_select;
	_tmp21_ = clocks_content_view_get_can_select (self);
	_tmp22_ = _tmp21_;
	if (_tmp20_ != _tmp22_) {
		gboolean _tmp23_ = FALSE;
		_tmp23_ = local_can_select;
		clocks_content_view_set_can_select (self, _tmp23_);
	}
}


static void clocks_content_view_update_props_on_insert (ClocksContentView* self, ClocksContentItem* item) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->_empty;
	if (_tmp0_) {
		clocks_content_view_set_empty (self, FALSE);
	}
	_tmp2_ = clocks_content_view_get_can_select (self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		ClocksContentItem* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = item;
		_tmp5_ = clocks_content_item_get_selectable (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		clocks_content_view_set_can_select (self, TRUE);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* clocks_content_view_get_selected_items (ClocksContentView* self) {
	GList* result = NULL;
	GList* items = NULL;
	GtkListStore* store = NULL;
	ClocksIconView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	ClocksIconView* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	items = NULL;
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = gtk_icon_view_get_model ((GtkIconView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp3_;
	_tmp4_ = self->priv->icon_view;
	_tmp5_ = clocks_icon_view_get_selected_items (_tmp4_);
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp5_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp6_ = NULL;
			GtkTreePath* path = NULL;
			_tmp6_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp6_;
			{
				GtkTreeIter i = {0};
				GtkListStore* _tmp7_ = NULL;
				GtkTreePath* _tmp8_ = NULL;
				GtkTreeIter _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				_tmp7_ = store;
				_tmp8_ = path;
				_tmp10_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp7_, &_tmp9_, _tmp8_);
				i = _tmp9_;
				if (_tmp10_) {
					GObject* item = NULL;
					GtkListStore* _tmp11_ = NULL;
					GtkTreeIter _tmp12_ = {0};
					GObject* _tmp13_ = NULL;
					GObject* _tmp14_ = NULL;
					_tmp11_ = store;
					_tmp12_ = i;
					gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item, -1);
					_tmp13_ = item;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					items = g_list_prepend (items, _tmp14_);
					_g_object_unref0 (item);
				}
				_gtk_tree_path_free0 (path);
			}
		}
		__g_list_free__gtk_tree_path_free0_0 (path_collection);
	}
	items = g_list_reverse (items);
	_tmp15_ = items;
	items = NULL;
	result = _tmp15_;
	_g_object_unref0 (store);
	__g_list_free__g_object_unref0_0 (items);
	return result;
}


void clocks_content_view_select_all (ClocksContentView* self) {
	ClocksIconView* _tmp0_ = NULL;
	ClocksIconView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_set_mode (_tmp0_, CLOCKS_ICON_VIEW_MODE_SELECTION);
	_tmp1_ = self->priv->icon_view;
	clocks_icon_view_select_all (_tmp1_);
}


void clocks_content_view_unselect_all (ClocksContentView* self) {
	ClocksIconView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_unselect_all (_tmp0_);
}


gboolean clocks_content_view_escape_pressed (ClocksContentView* self) {
	gboolean result = FALSE;
	ClocksIconView* _tmp0_ = NULL;
	ClocksIconViewMode _tmp1_ = 0;
	ClocksIconViewMode _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = clocks_icon_view_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == CLOCKS_ICON_VIEW_MODE_SELECTION) {
		ClocksIconView* _tmp3_ = NULL;
		_tmp3_ = self->priv->icon_view;
		clocks_icon_view_set_mode (_tmp3_, CLOCKS_ICON_VIEW_MODE_NORMAL);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void __lambda15_ (ClocksContentView* self) {
	ClocksIconView* _tmp0_ = NULL;
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_set_mode (_tmp0_, CLOCKS_ICON_VIEW_MODE_SELECTION);
}


static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda15_ ((ClocksContentView*) self);
}


static void __lambda16_ (ClocksContentView* self) {
	ClocksIconView* _tmp0_ = NULL;
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_set_mode (_tmp0_, CLOCKS_ICON_VIEW_MODE_NORMAL);
}


static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda16_ ((ClocksContentView*) self);
}


static void __lambda17_ (ClocksContentView* self) {
	ClocksIconView* _tmp0_ = NULL;
	ClocksIconViewMode _tmp1_ = 0;
	ClocksIconViewMode _tmp2_ = 0;
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = clocks_icon_view_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == CLOCKS_ICON_VIEW_MODE_SELECTION) {
		ClocksHeaderBar* _tmp3_ = NULL;
		_tmp3_ = self->priv->header_bar;
		clocks_header_bar_set_mode (_tmp3_, CLOCKS_HEADER_BAR_MODE_SELECTION);
	} else {
		ClocksIconView* _tmp4_ = NULL;
		ClocksIconViewMode _tmp5_ = 0;
		ClocksIconViewMode _tmp6_ = 0;
		_tmp4_ = self->priv->icon_view;
		_tmp5_ = clocks_icon_view_get_mode (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == CLOCKS_ICON_VIEW_MODE_NORMAL) {
			ClocksHeaderBar* _tmp7_ = NULL;
			_tmp7_ = self->priv->header_bar;
			clocks_header_bar_set_mode (_tmp7_, CLOCKS_HEADER_BAR_MODE_NORMAL);
		}
	}
}


static void ___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda17_ ((ClocksContentView*) self);
}


void clocks_content_view_set_header_bar (ClocksContentView* self, ClocksHeaderBar* bar) {
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkImage* select_button_image = NULL;
	GtkImage* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	ClocksHeaderBar* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	ClocksHeaderBar* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkApplication* app = NULL;
	GApplication* _tmp17_ = NULL;
	GtkApplication* _tmp18_ = NULL;
	GMenu* _tmp19_ = NULL;
	GMenuModel* _tmp20_ = NULL;
	GtkMenuButton* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkImage* selection_menubutton_arrow = NULL;
	GtkImage* _tmp24_ = NULL;
	GtkGrid* selection_menubutton_grid = NULL;
	GtkGrid* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkMenuButton* _tmp27_ = NULL;
	GtkMenuButton* _tmp28_ = NULL;
	GtkMenuButton* _tmp29_ = NULL;
	GtkMenuButton* _tmp30_ = NULL;
	GMenuModel* _tmp31_ = NULL;
	GtkMenuButton* _tmp32_ = NULL;
	GtkStyleContext* _tmp33_ = NULL;
	ClocksIconView* _tmp34_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bar != NULL);
	_tmp0_ = bar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->header_bar);
	self->priv->header_bar = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->select_button);
	self->priv->select_button = _tmp2_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("object-select-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp3_);
	select_button_image = _tmp3_;
	_tmp4_ = self->priv->select_button;
	gtk_button_set_image (_tmp4_, (GtkWidget*) select_button_image);
	_tmp5_ = self->priv->select_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->select_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->select_button;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) ___lambda15__gtk_button_clicked, self, 0);
	_tmp8_ = self->priv->header_bar;
	_tmp9_ = self->priv->select_button;
	gtk_header_bar_pack_end ((GtkHeaderBar*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = _ ("Cancel");
	_tmp11_ = (GtkButton*) gtk_button_new_with_label (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->cancel_button);
	self->priv->cancel_button = _tmp11_;
	_tmp12_ = self->priv->cancel_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = self->priv->cancel_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	_tmp14_ = self->priv->cancel_button;
	g_signal_connect_object (_tmp14_, "clicked", (GCallback) ___lambda16__gtk_button_clicked, self, 0);
	_tmp15_ = self->priv->header_bar;
	_tmp16_ = self->priv->cancel_button;
	gtk_header_bar_pack_end ((GtkHeaderBar*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = g_application_get_default ();
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_application_get_type (), GtkApplication));
	app = _tmp18_;
	_tmp19_ = gtk_application_get_menu_by_id (app, "selection-menu");
	_tmp20_ = _g_object_ref0 ((GMenuModel*) _tmp19_);
	_g_object_unref0 (self->priv->selection_menu);
	self->priv->selection_menu = _tmp20_;
	_tmp21_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->selection_menubutton);
	self->priv->selection_menubutton = _tmp21_;
	_tmp22_ = _ ("Click on items to select them");
	_tmp23_ = (GtkLabel*) gtk_label_new (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->selection_menubutton_label);
	self->priv->selection_menubutton_label = _tmp23_;
	_tmp24_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp24_);
	selection_menubutton_arrow = _tmp24_;
	_tmp25_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp25_);
	selection_menubutton_grid = _tmp25_;
	gtk_grid_set_column_spacing (selection_menubutton_grid, (guint) 6);
	_tmp26_ = self->priv->selection_menubutton_label;
	gtk_grid_attach (selection_menubutton_grid, (GtkWidget*) _tmp26_, 0, 0, 1, 1);
	gtk_grid_attach (selection_menubutton_grid, (GtkWidget*) selection_menubutton_arrow, 1, 0, 1, 1);
	_tmp27_ = self->priv->selection_menubutton;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) selection_menubutton_grid);
	_tmp28_ = self->priv->selection_menubutton;
	gtk_widget_show_all ((GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->selection_menubutton;
	gtk_widget_set_valign ((GtkWidget*) _tmp29_, GTK_ALIGN_CENTER);
	_tmp30_ = self->priv->selection_menubutton;
	_tmp31_ = self->priv->selection_menu;
	gtk_menu_button_set_menu_model (_tmp30_, _tmp31_);
	_tmp32_ = self->priv->selection_menubutton;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	gtk_style_context_add_class (_tmp33_, "selection-menu");
	_tmp34_ = self->priv->icon_view;
	g_signal_connect_object ((GObject*) _tmp34_, "notify::mode", (GCallback) ___lambda17__g_object_notify, self, 0);
	_g_object_unref0 (selection_menubutton_grid);
	_g_object_unref0 (selection_menubutton_arrow);
	_g_object_unref0 (app);
	_g_object_unref0 (select_button_image);
}


void clocks_content_view_update_header_bar (ClocksContentView* self) {
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBarMode _tmp1_ = 0;
	ClocksHeaderBarMode _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->header_bar;
	_tmp1_ = clocks_header_bar_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case CLOCKS_HEADER_BAR_MODE_SELECTION:
		{
			ClocksHeaderBar* _tmp3_ = NULL;
			GtkMenuButton* _tmp4_ = NULL;
			GtkButton* _tmp5_ = NULL;
			_tmp3_ = self->priv->header_bar;
			_tmp4_ = self->priv->selection_menubutton;
			gtk_header_bar_set_custom_title ((GtkHeaderBar*) _tmp3_, (GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->cancel_button;
			gtk_widget_show ((GtkWidget*) _tmp5_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_NORMAL:
		{
			GtkButton* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			_tmp6_ = self->priv->select_button;
			_tmp7_ = clocks_content_view_get_can_select (self);
			_tmp8_ = _tmp7_;
			gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp8_);
			break;
		}
		default:
		break;
	}
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ClocksContentView* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gint __lambda18_ (Block5Data* _data5_, GtkTreeModel* model, GtkTreeIter* iter1, GtkTreeIter* iter2) {
	ClocksContentView* self;
	gint result = 0;
	ClocksContentItem* item1 = NULL;
	ClocksContentItem* item2 = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	ClocksContentViewSortFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	gint _tmp5_ = 0;
	self = _data5_->self;
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (iter1 != NULL, 0);
	g_return_val_if_fail (iter2 != NULL, 0);
	_tmp0_ = model;
	_tmp1_ = *iter1;
	gtk_tree_model_get (_tmp0_, &_tmp1_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item1, -1);
	_tmp2_ = model;
	_tmp3_ = *iter2;
	gtk_tree_model_get (_tmp2_, &_tmp3_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item2, -1);
	_tmp4_ = _data5_->sort_func;
	_tmp4__target = _data5_->sort_func_target;
	_tmp5_ = _tmp4_ (item1, item2, _tmp4__target);
	result = _tmp5_;
	_g_object_unref0 (item2);
	_g_object_unref0 (item1);
	return result;
}


static gint ___lambda18__gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = __lambda18_ (self, model, a, b);
	return result;
}


void clocks_content_view_set_sorting (ClocksContentView* self, GtkSortType sort_type, ClocksContentViewSortFunc sort_func, void* sort_func_target) {
	Block5Data* _data5_;
	ClocksContentViewSortFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GtkTreeSortable* sortable = NULL;
	ClocksIconView* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeSortable* _tmp3_ = NULL;
	GtkSortType _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = sort_func;
	_tmp0__target = sort_func_target;
	_data5_->sort_func = _tmp0_;
	_data5_->sort_func_target = _tmp0__target;
	_tmp1_ = self->priv->icon_view;
	_tmp2_ = gtk_icon_view_get_model ((GtkIconView*) _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_TREE_SORTABLE) ? ((GtkTreeSortable*) _tmp2_) : NULL);
	sortable = _tmp3_;
	_tmp4_ = sort_type;
	gtk_tree_sortable_set_sort_column_id (sortable, 1, _tmp4_);
	gtk_tree_sortable_set_sort_func (sortable, 1, ___lambda18__gtk_tree_iter_compare_func, block5_data_ref (_data5_), block5_data_unref);
	_g_object_unref0 (sortable);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


ClocksContentView* clocks_content_view_construct (GType object_type) {
	ClocksContentView * self = NULL;
	self = (ClocksContentView*) g_object_new (object_type, NULL);
	return self;
}


ClocksContentView* clocks_content_view_new (void) {
	return clocks_content_view_construct (CLOCKS_TYPE_CONTENT_VIEW);
}


gboolean clocks_content_view_get_empty (ClocksContentView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_empty;
	result = _tmp0_;
	return result;
}


static void clocks_content_view_set_empty (ClocksContentView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_empty = _tmp0_;
	g_object_notify ((GObject *) self, "empty");
}


static gboolean clocks_content_view_get_can_select (ClocksContentView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_can_select;
	result = _tmp0_;
	return result;
}


static void clocks_content_view_set_can_select (ClocksContentView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_can_select;
	_tmp1_ = value;
	if (_tmp0_ != _tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		GtkButton* _tmp6_ = NULL;
		_tmp2_ = value;
		self->priv->_can_select = _tmp2_;
		_tmp4_ = self->priv->_can_select;
		if (_tmp4_) {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = gtk_widget_get_mapped ((GtkWidget*) self);
			_tmp3_ = _tmp5_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp6_ = self->priv->select_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp3_);
	}
}


static void clocks_content_view_real_delete_selected (ClocksContentView* self) {
	ClocksIconView* _tmp0_ = NULL;
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_remove_selected (_tmp0_);
	clocks_content_view_update_props_on_remove (self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ClocksContentView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->action_bar);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _clocks_content_view___lambda19_ (ClocksContentView* self) {
	ClocksIconView* _tmp0_ = NULL;
	g_signal_emit_by_name (self, "delete-selected");
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_set_mode (_tmp0_, CLOCKS_ICON_VIEW_MODE_NORMAL);
}


static void __clocks_content_view___lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_clocks_content_view___lambda19_ ((ClocksContentView*) self);
}


static void _clocks_content_view___lambda20_ (Block6Data* _data6_) {
	ClocksContentView* self;
	ClocksIconView* _tmp0_ = NULL;
	ClocksIconViewMode _tmp1_ = 0;
	ClocksIconViewMode _tmp2_ = 0;
	self = _data6_->self;
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = clocks_icon_view_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == CLOCKS_ICON_VIEW_MODE_SELECTION) {
		GtkActionBar* _tmp3_ = NULL;
		_tmp3_ = _data6_->action_bar;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	} else {
		ClocksIconView* _tmp4_ = NULL;
		ClocksIconViewMode _tmp5_ = 0;
		ClocksIconViewMode _tmp6_ = 0;
		_tmp4_ = self->priv->icon_view;
		_tmp5_ = clocks_icon_view_get_mode (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == CLOCKS_ICON_VIEW_MODE_NORMAL) {
			GtkActionBar* _tmp7_ = NULL;
			_tmp7_ = _data6_->action_bar;
			gtk_widget_hide ((GtkWidget*) _tmp7_);
		}
	}
}


static void __clocks_content_view___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_clocks_content_view___lambda20_ (self);
}


static void _clocks_content_view___lambda21_ (ClocksContentView* self) {
	GList* items = NULL;
	ClocksIconView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint n_items = 0U;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* label = NULL;
	guint _tmp4_ = 0U;
	GtkLabel* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = clocks_icon_view_get_selected_items (_tmp0_);
	items = _tmp1_;
	_tmp2_ = items;
	_tmp3_ = g_list_length (_tmp2_);
	n_items = _tmp3_;
	_tmp4_ = n_items;
	if (_tmp4_ == ((guint) 0)) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = _ ("Click on items to select them");
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (label);
		label = _tmp6_;
	} else {
		guint _tmp7_ = 0U;
		const gchar* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		gchar* _tmp10_ = NULL;
		_tmp7_ = n_items;
		_tmp8_ = ngettext ("%d selected", "%d selected", (gulong) _tmp7_);
		_tmp9_ = n_items;
		_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_);
		_g_free0 (label);
		label = _tmp10_;
	}
	_tmp11_ = self->priv->selection_menubutton_label;
	_tmp12_ = label;
	gtk_label_set_label (_tmp11_, _tmp12_);
	_tmp13_ = n_items;
	if (_tmp13_ != ((guint) 0)) {
		GtkButton* _tmp14_ = NULL;
		_tmp14_ = self->priv->delete_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
	} else {
		GtkButton* _tmp15_ = NULL;
		_tmp15_ = self->priv->delete_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
	}
	_g_free0 (label);
	__g_list_free__gtk_tree_path_free0_0 (items);
}


static void __clocks_content_view___lambda21__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	_clocks_content_view___lambda21_ ((ClocksContentView*) self);
}


static void _clocks_content_view___lambda22_ (ClocksContentView* self, GtkTreePath* path) {
	GtkListStore* store = NULL;
	ClocksIconView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter i = {0};
	GtkListStore* _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = gtk_icon_view_get_model ((GtkIconView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp3_;
	_tmp4_ = store;
	_tmp5_ = path;
	_tmp7_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp4_, &_tmp6_, _tmp5_);
	i = _tmp6_;
	if (_tmp7_) {
		ClocksIconView* _tmp8_ = NULL;
		ClocksIconViewMode _tmp9_ = 0;
		ClocksIconViewMode _tmp10_ = 0;
		_tmp8_ = self->priv->icon_view;
		_tmp9_ = clocks_icon_view_get_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == CLOCKS_ICON_VIEW_MODE_SELECTION) {
			gboolean selected = FALSE;
			GtkListStore* _tmp11_ = NULL;
			GtkTreeIter _tmp12_ = {0};
			GtkListStore* _tmp13_ = NULL;
			GtkTreeIter _tmp14_ = {0};
			gboolean _tmp15_ = FALSE;
			ClocksIconView* _tmp16_ = NULL;
			_tmp11_ = store;
			_tmp12_ = i;
			gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, &selected, -1);
			_tmp13_ = store;
			_tmp14_ = i;
			_tmp15_ = selected;
			gtk_list_store_set (_tmp13_, &_tmp14_, CLOCKS_ICON_VIEW_COLUMN_SELECTED, !_tmp15_, -1);
			_tmp16_ = self->priv->icon_view;
			g_signal_emit_by_name ((GtkIconView*) _tmp16_, "selection-changed");
		} else {
			GObject* item = NULL;
			GtkListStore* _tmp17_ = NULL;
			GtkTreeIter _tmp18_ = {0};
			GObject* _tmp19_ = NULL;
			_tmp17_ = store;
			_tmp18_ = i;
			gtk_tree_model_get ((GtkTreeModel*) _tmp17_, &_tmp18_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &item, -1);
			_tmp19_ = item;
			g_signal_emit_by_name (self, "item-activated", G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem));
			_g_object_unref0 (item);
		}
	}
	_g_object_unref0 (store);
}


static void __clocks_content_view___lambda22__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	_clocks_content_view___lambda22_ ((ClocksContentView*) self, path);
}


static GObject * clocks_content_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ClocksContentView * self;
	Block6Data* _data6_;
	ClocksIconView* _tmp0_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp1_ = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	ClocksIconView* _tmp3_ = NULL;
	GtkScrolledWindow* _tmp4_ = NULL;
	GtkScrolledWindow* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_ = NULL;
	GtkScrolledWindow* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	GtkScrolledWindow* _tmp10_ = NULL;
	GtkActionBar* _tmp11_ = NULL;
	GtkActionBar* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkActionBar* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkButton* _tmp18_ = NULL;
	GtkButton* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkActionBar* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	ClocksIconView* _tmp25_ = NULL;
	ClocksIconView* _tmp26_ = NULL;
	ClocksIconView* _tmp27_ = NULL;
	GtkGrid* _tmp28_ = NULL;
	GtkGrid* _tmp29_ = NULL;
	parent_class = G_OBJECT_CLASS (clocks_content_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = clocks_icon_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->icon_view);
	self->priv->icon_view = _tmp0_;
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp1_);
	scrolled_window = _tmp1_;
	_tmp2_ = scrolled_window;
	_tmp3_ = self->priv->icon_view;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = scrolled_window;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = scrolled_window;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = scrolled_window;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_FILL);
	_tmp7_ = scrolled_window;
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_FILL);
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp8_;
	_tmp9_ = self->priv->grid;
	_tmp10_ = scrolled_window;
	gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp10_, 0, 0, 1, 1);
	_tmp11_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp11_);
	_data6_->action_bar = _tmp11_;
	_tmp12_ = _data6_->action_bar;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = self->priv->grid;
	_tmp14_ = _data6_->action_bar;
	gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, 0, 1, 1, 1);
	_tmp15_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->delete_button);
	self->priv->delete_button = _tmp15_;
	_tmp16_ = self->priv->delete_button;
	_tmp17_ = _ ("Delete");
	gtk_button_set_label (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->delete_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, TRUE);
	_tmp19_ = self->priv->delete_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	_tmp20_ = self->priv->delete_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_END);
	_tmp21_ = self->priv->delete_button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	_tmp22_ = self->priv->delete_button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) __clocks_content_view___lambda19__gtk_button_clicked, self, 0);
	_tmp23_ = _data6_->action_bar;
	_tmp24_ = self->priv->delete_button;
	gtk_action_bar_pack_end (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->icon_view;
	g_signal_connect_data ((GObject*) _tmp25_, "notify::mode", (GCallback) __clocks_content_view___lambda20__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp26_ = self->priv->icon_view;
	g_signal_connect_object ((GtkIconView*) _tmp26_, "selection-changed", (GCallback) __clocks_content_view___lambda21__gtk_icon_view_selection_changed, self, 0);
	_tmp27_ = self->priv->icon_view;
	g_signal_connect_object ((GtkIconView*) _tmp27_, "item-activated", (GCallback) __clocks_content_view___lambda22__gtk_icon_view_item_activated, self, 0);
	_tmp28_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->grid;
	gtk_widget_show_all ((GtkWidget*) _tmp29_);
	_g_object_unref0 (scrolled_window);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return obj;
}


static void clocks_content_view_class_init (ClocksContentViewClass * klass) {
	clocks_content_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksContentViewPrivate));
	((ClocksContentViewClass *) klass)->delete_selected = clocks_content_view_real_delete_selected;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_content_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_content_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = clocks_content_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_content_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_CONTENT_VIEW_EMPTY, g_param_spec_boolean ("empty", "empty", "empty", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("item_activated", CLOCKS_TYPE_CONTENT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CLOCKS_TYPE_CONTENT_ITEM);
	g_signal_new ("delete_selected", CLOCKS_TYPE_CONTENT_VIEW, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksContentViewClass, delete_selected), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_content_view_instance_init (ClocksContentView * self) {
	self->priv = CLOCKS_CONTENT_VIEW_GET_PRIVATE (self);
	self->priv->_empty = TRUE;
}


static void clocks_content_view_finalize (GObject* obj) {
	ClocksContentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView);
	_g_object_unref0 (self->priv->icon_view);
	_g_object_unref0 (self->priv->select_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->selection_menu);
	_g_object_unref0 (self->priv->selection_menubutton);
	_g_object_unref0 (self->priv->selection_menubutton_label);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->priv->header_bar);
	G_OBJECT_CLASS (clocks_content_view_parent_class)->finalize (obj);
}


GType clocks_content_view_get_type (void) {
	static volatile gsize clocks_content_view_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_content_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksContentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_content_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksContentView), 0, (GInstanceInitFunc) clocks_content_view_instance_init, NULL };
		GType clocks_content_view_type_id;
		clocks_content_view_type_id = g_type_register_static (gtk_bin_get_type (), "ClocksContentView", &g_define_type_info, 0);
		g_once_init_leave (&clocks_content_view_type_id__volatile, clocks_content_view_type_id);
	}
	return clocks_content_view_type_id__volatile;
}


static void _vala_clocks_content_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksContentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView);
	switch (property_id) {
		case CLOCKS_CONTENT_VIEW_EMPTY:
		g_value_set_boolean (value, clocks_content_view_get_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_content_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksContentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView);
	switch (property_id) {
		case CLOCKS_CONTENT_VIEW_EMPTY:
		clocks_content_view_set_empty (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType clocks_am_pm_toggle_button_am_pm_get_type (void) {
	static volatile gsize clocks_am_pm_toggle_button_am_pm_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_am_pm_toggle_button_am_pm_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM, "CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM", "am"}, {CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM, "CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM", "pm"}, {0, NULL, NULL}};
		GType clocks_am_pm_toggle_button_am_pm_type_id;
		clocks_am_pm_toggle_button_am_pm_type_id = g_enum_register_static ("ClocksAmPmToggleButtonAmPm", values);
		g_once_init_leave (&clocks_am_pm_toggle_button_am_pm_type_id__volatile, clocks_am_pm_toggle_button_am_pm_type_id);
	}
	return clocks_am_pm_toggle_button_am_pm_type_id__volatile;
}


static void __lambda35_ (ClocksAmPmToggleButton* self) {
	ClocksAmPmToggleButtonAmPm _tmp0_ = 0;
	ClocksAmPmToggleButtonAmPm _tmp1_ = 0;
	ClocksAmPmToggleButtonAmPm _tmp2_ = 0;
	_tmp1_ = clocks_am_pm_toggle_button_get_choice (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM) {
		_tmp0_ = CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM;
	} else {
		_tmp0_ = CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM;
	}
	clocks_am_pm_toggle_button_set_choice (self, _tmp0_);
}


static void ___lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda35_ ((ClocksAmPmToggleButton*) self);
}


ClocksAmPmToggleButton* clocks_am_pm_toggle_button_construct (GType object_type) {
	ClocksAmPmToggleButton * self = NULL;
	GtkStack* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	gchar* str = NULL;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GDateTime* _tmp8_ = NULL;
	GDateTime* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkStack* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkStack* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkStack* _tmp17_ = NULL;
	GtkStack* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	self = (ClocksAmPmToggleButton*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "clocks-ampm-toggle-button");
	_tmp2_ = g_date_time_new_utc (1, 1, 1, 0, 0, (gdouble) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_date_time_format (_tmp3_, "%p");
	_tmp5_ = _tmp4_;
	_g_date_time_unref0 (_tmp3_);
	str = _tmp5_;
	_tmp6_ = str;
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->am_label);
	self->priv->am_label = _tmp7_;
	_tmp8_ = g_date_time_new_utc (1, 1, 1, 12, 0, (gdouble) 0);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_date_time_format (_tmp9_, "%p");
	_g_free0 (str);
	str = _tmp10_;
	_g_date_time_unref0 (_tmp9_);
	_tmp11_ = str;
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->pm_label);
	self->priv->pm_label = _tmp12_;
	_tmp13_ = self->priv->stack;
	_tmp14_ = self->priv->am_label;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->stack;
	_tmp16_ = self->priv->pm_label;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp17_);
	g_signal_connect_object ((GtkButton*) self, "clicked", (GCallback) ___lambda35__gtk_button_clicked, self, 0);
	clocks_am_pm_toggle_button_set_choice (self, CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM);
	_tmp18_ = self->priv->stack;
	_tmp19_ = self->priv->am_label;
	gtk_stack_set_visible_child (_tmp18_, (GtkWidget*) _tmp19_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_free0 (str);
	return self;
}


ClocksAmPmToggleButton* clocks_am_pm_toggle_button_new (void) {
	return clocks_am_pm_toggle_button_construct (CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON);
}


ClocksAmPmToggleButtonAmPm clocks_am_pm_toggle_button_get_choice (ClocksAmPmToggleButton* self) {
	ClocksAmPmToggleButtonAmPm result;
	ClocksAmPmToggleButtonAmPm _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_choice;
	result = _tmp0_;
	return result;
}


void clocks_am_pm_toggle_button_set_choice (ClocksAmPmToggleButton* self, ClocksAmPmToggleButtonAmPm value) {
	ClocksAmPmToggleButtonAmPm _tmp0_ = 0;
	ClocksAmPmToggleButtonAmPm _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_choice;
	_tmp1_ = value;
	if (_tmp0_ != _tmp1_) {
		ClocksAmPmToggleButtonAmPm _tmp2_ = 0;
		GtkLabel* _tmp3_ = NULL;
		ClocksAmPmToggleButtonAmPm _tmp4_ = 0;
		GtkStack* _tmp7_ = NULL;
		_tmp2_ = value;
		self->priv->_choice = _tmp2_;
		_tmp4_ = self->priv->_choice;
		if (_tmp4_ == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM) {
			GtkLabel* _tmp5_ = NULL;
			_tmp5_ = self->priv->am_label;
			_tmp3_ = _tmp5_;
		} else {
			GtkLabel* _tmp6_ = NULL;
			_tmp6_ = self->priv->pm_label;
			_tmp3_ = _tmp6_;
		}
		_tmp7_ = self->priv->stack;
		gtk_stack_set_visible_child (_tmp7_, (GtkWidget*) _tmp3_);
	}
	g_object_notify ((GObject *) self, "choice");
}


static void clocks_am_pm_toggle_button_class_init (ClocksAmPmToggleButtonClass * klass) {
	clocks_am_pm_toggle_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAmPmToggleButtonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_am_pm_toggle_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_am_pm_toggle_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_am_pm_toggle_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_AM_PM_TOGGLE_BUTTON_CHOICE, g_param_spec_enum ("choice", "choice", "choice", CLOCKS_AM_PM_TOGGLE_BUTTON_TYPE_AM_PM, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_am_pm_toggle_button_instance_init (ClocksAmPmToggleButton * self) {
	self->priv = CLOCKS_AM_PM_TOGGLE_BUTTON_GET_PRIVATE (self);
}


static void clocks_am_pm_toggle_button_finalize (GObject* obj) {
	ClocksAmPmToggleButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButton);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->am_label);
	_g_object_unref0 (self->priv->pm_label);
	G_OBJECT_CLASS (clocks_am_pm_toggle_button_parent_class)->finalize (obj);
}


GType clocks_am_pm_toggle_button_get_type (void) {
	static volatile gsize clocks_am_pm_toggle_button_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_am_pm_toggle_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAmPmToggleButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_am_pm_toggle_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAmPmToggleButton), 0, (GInstanceInitFunc) clocks_am_pm_toggle_button_instance_init, NULL };
		GType clocks_am_pm_toggle_button_type_id;
		clocks_am_pm_toggle_button_type_id = g_type_register_static (gtk_button_get_type (), "ClocksAmPmToggleButton", &g_define_type_info, 0);
		g_once_init_leave (&clocks_am_pm_toggle_button_type_id__volatile, clocks_am_pm_toggle_button_type_id);
	}
	return clocks_am_pm_toggle_button_type_id__volatile;
}


static void _vala_clocks_am_pm_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksAmPmToggleButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButton);
	switch (property_id) {
		case CLOCKS_AM_PM_TOGGLE_BUTTON_CHOICE:
		g_value_set_enum (value, clocks_am_pm_toggle_button_get_choice (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_am_pm_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksAmPmToggleButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButton);
	switch (property_id) {
		case CLOCKS_AM_PM_TOGGLE_BUTTON_CHOICE:
		clocks_am_pm_toggle_button_set_choice (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint clocks_analog_frame_calculate_diameter (ClocksAnalogFrame* self) {
	gint result = 0;
	gint ret = 0;
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkWidget* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	ret = 2 * CLOCKS_ANALOG_FRAME_RADIUS_PAD;
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	child = _tmp1_;
	_tmp3_ = child;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = child;
		_tmp5_ = gtk_widget_get_visible (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint w = 0;
		gint h = 0;
		GtkWidget* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		GtkWidget* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gdouble _tmp16_ = 0.0;
		_tmp7_ = child;
		gtk_widget_get_preferred_width (_tmp7_, &_tmp8_, NULL);
		w = _tmp8_;
		_tmp9_ = child;
		gtk_widget_get_preferred_height (_tmp9_, &_tmp10_, NULL);
		h = _tmp10_;
		_tmp11_ = ret;
		_tmp12_ = w;
		_tmp13_ = w;
		_tmp14_ = h;
		_tmp15_ = h;
		_tmp16_ = sqrt ((gdouble) ((_tmp12_ * _tmp13_) + (_tmp14_ * _tmp15_)));
		ret = _tmp11_ + ((gint) _tmp16_);
	}
	result = ret;
	_g_object_unref0 (child);
	return result;
}


static void clocks_analog_frame_real_get_preferred_width (GtkWidget* base, gint* min_w, gint* natural_w) {
	ClocksAnalogFrame * self;
	gint _vala_min_w = 0;
	gint _vala_natural_w = 0;
	gint d = 0;
	gint _tmp0_ = 0;
	self = (ClocksAnalogFrame*) base;
	_tmp0_ = clocks_analog_frame_calculate_diameter (self);
	d = _tmp0_;
	_vala_min_w = d;
	_vala_natural_w = d;
	if (min_w) {
		*min_w = _vala_min_w;
	}
	if (natural_w) {
		*natural_w = _vala_natural_w;
	}
}


static void clocks_analog_frame_real_get_preferred_height (GtkWidget* base, gint* min_h, gint* natural_h) {
	ClocksAnalogFrame * self;
	gint _vala_min_h = 0;
	gint _vala_natural_h = 0;
	gint d = 0;
	gint _tmp0_ = 0;
	self = (ClocksAnalogFrame*) base;
	_tmp0_ = clocks_analog_frame_calculate_diameter (self);
	d = _tmp0_;
	_vala_min_h = d;
	_vala_natural_h = d;
	if (min_h) {
		*min_h = _vala_min_h;
	}
	if (natural_h) {
		*natural_h = _vala_natural_h;
	}
}


static void clocks_analog_frame_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	ClocksAnalogFrame * self;
	GtkAllocation _tmp0_ = {0};
	GtkWidget* child = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkWidget* _tmp4_ = NULL;
	self = (ClocksAnalogFrame*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp0_);
	_tmp1_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	child = _tmp2_;
	_tmp4_ = child;
	if (_tmp4_ != NULL) {
		GtkWidget* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = child;
		_tmp6_ = gtk_widget_get_visible (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint w = 0;
		gint h = 0;
		GtkWidget* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		GtkWidget* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		GtkAllocation child_allocation = {0};
		GtkAllocation _tmp12_ = {0};
		GtkAllocation _tmp13_ = {0};
		gint _tmp14_ = 0;
		GtkAllocation _tmp15_ = {0};
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		GtkAllocation _tmp18_ = {0};
		gint _tmp19_ = 0;
		GtkAllocation _tmp20_ = {0};
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GtkWidget* _tmp25_ = NULL;
		GtkAllocation _tmp26_ = {0};
		_tmp8_ = child;
		gtk_widget_get_preferred_width (_tmp8_, &_tmp9_, NULL);
		w = _tmp9_;
		_tmp10_ = child;
		gtk_widget_get_preferred_height (_tmp10_, &_tmp11_, NULL);
		h = _tmp11_;
		child_allocation = _tmp12_;
		_tmp13_ = *allocation;
		_tmp14_ = _tmp13_.x;
		_tmp15_ = *allocation;
		_tmp16_ = _tmp15_.width;
		_tmp17_ = w;
		child_allocation.x = _tmp14_ + ((_tmp16_ - _tmp17_) / 2);
		_tmp18_ = *allocation;
		_tmp19_ = _tmp18_.y;
		_tmp20_ = *allocation;
		_tmp21_ = _tmp20_.height;
		_tmp22_ = h;
		child_allocation.y = _tmp19_ + ((_tmp21_ - _tmp22_) / 2);
		_tmp23_ = w;
		child_allocation.width = _tmp23_;
		_tmp24_ = h;
		child_allocation.height = _tmp24_;
		_tmp25_ = child;
		_tmp26_ = child_allocation;
		gtk_widget_size_allocate (_tmp25_, &_tmp26_);
	}
	_g_object_unref0 (child);
}


static gboolean clocks_analog_frame_real_draw (GtkWidget* base, cairo_t* cr) {
	ClocksAnalogFrame * self;
	gboolean result = FALSE;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	gint center_x = 0;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint center_y = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint radius = 0;
	gint _tmp7_ = 0;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	GdkRGBA color = {0};
	GdkRGBA _tmp10_ = {0};
	cairo_t* _tmp11_ = NULL;
	cairo_t* _tmp12_ = NULL;
	GdkRGBA _tmp13_ = {0};
	cairo_t* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	self = (ClocksAnalogFrame*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = allocation;
	_tmp4_ = _tmp3_.width;
	center_x = _tmp4_ / 2;
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.height;
	center_y = _tmp6_ / 2;
	_tmp7_ = clocks_analog_frame_calculate_diameter (self);
	radius = _tmp7_ / 2;
	_tmp8_ = cr;
	cairo_save (_tmp8_);
	_tmp9_ = cr;
	cairo_move_to (_tmp9_, (gdouble) (center_x + radius), (gdouble) center_y);
	gtk_style_context_save (context);
	gtk_style_context_add_class (context, "clocks-analog-frame");
	gtk_style_context_save (context);
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_TROUGH);
	gtk_style_context_get_color (context, GTK_STATE_FLAG_NORMAL, &_tmp10_);
	color = _tmp10_;
	_tmp11_ = cr;
	cairo_set_line_width (_tmp11_, (gdouble) CLOCKS_ANALOG_FRAME_LINE_WIDTH);
	_tmp12_ = cr;
	_tmp13_ = color;
	gdk_cairo_set_source_rgba (_tmp12_, &_tmp13_);
	_tmp14_ = cr;
	cairo_arc (_tmp14_, (gdouble) center_x, (gdouble) center_y, (gdouble) (radius - (CLOCKS_ANALOG_FRAME_LINE_WIDTH / 2)), (gdouble) 0, 2 * G_PI);
	_tmp15_ = cr;
	cairo_stroke (_tmp15_);
	gtk_style_context_restore (context);
	_tmp16_ = cr;
	clocks_analog_frame_draw_progress (self, _tmp16_, center_x, center_y, radius);
	gtk_style_context_restore (context);
	_tmp17_ = cr;
	cairo_restore (_tmp17_);
	_tmp18_ = cr;
	_tmp19_ = GTK_WIDGET_CLASS (clocks_analog_frame_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_frame_get_type (), GtkFrame), _tmp18_);
	result = _tmp19_;
	_g_object_unref0 (context);
	return result;
}


static void clocks_analog_frame_real_draw_progress (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius) {
	g_return_if_fail (cr != NULL);
}


void clocks_analog_frame_draw_progress (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius) {
	g_return_if_fail (self != NULL);
	CLOCKS_ANALOG_FRAME_GET_CLASS (self)->draw_progress (self, cr, center_x, center_y, radius);
}


ClocksAnalogFrame* clocks_analog_frame_construct (GType object_type) {
	ClocksAnalogFrame * self = NULL;
	self = (ClocksAnalogFrame*) g_object_new (object_type, NULL);
	return self;
}


ClocksAnalogFrame* clocks_analog_frame_new (void) {
	return clocks_analog_frame_construct (CLOCKS_TYPE_ANALOG_FRAME);
}


static void clocks_analog_frame_class_init (ClocksAnalogFrameClass * klass) {
	clocks_analog_frame_parent_class = g_type_class_peek_parent (klass);
	((GtkWidgetClass *) klass)->get_preferred_width = clocks_analog_frame_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = clocks_analog_frame_real_get_preferred_height;
	((GtkWidgetClass *) klass)->size_allocate = clocks_analog_frame_real_size_allocate;
	((GtkWidgetClass *) klass)->draw = clocks_analog_frame_real_draw;
	((ClocksAnalogFrameClass *) klass)->draw_progress = clocks_analog_frame_real_draw_progress;
}


static void clocks_analog_frame_instance_init (ClocksAnalogFrame * self) {
}


GType clocks_analog_frame_get_type (void) {
	static volatile gsize clocks_analog_frame_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_analog_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAnalogFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_analog_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAnalogFrame), 0, (GInstanceInitFunc) clocks_analog_frame_instance_init, NULL };
		GType clocks_analog_frame_type_id;
		clocks_analog_frame_type_id = g_type_register_static (gtk_frame_get_type (), "ClocksAnalogFrame", &g_define_type_info, 0);
		g_once_init_leave (&clocks_analog_frame_type_id__volatile, clocks_analog_frame_type_id);
	}
	return clocks_analog_frame_type_id__volatile;
}



