/* taquin-main.c generated by valac 0.27.1.26-9b1a5, the Vala compiler
 * generated from taquin-main.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2015 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_TAQUIN (taquin_get_type ())
#define TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN, Taquin))
#define TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN, TaquinClass))
#define IS_TAQUIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN))
#define IS_TAQUIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN))
#define TAQUIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN, TaquinClass))

typedef struct _Taquin Taquin;
typedef struct _TaquinClass TaquinClass;
typedef struct _TaquinPrivate TaquinPrivate;

#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _Taquin {
	GtkApplication parent_instance;
	TaquinPrivate * priv;
};

struct _TaquinClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

struct _TaquinPrivate {
	GSettings* settings;
	GameType* tmp_type;
	gboolean type_changed;
	gboolean size_changed;
	gboolean theme_changed;
	GameWindow* window;
	GtkMenuButton* size_button;
	GtkMenuButton* theme_button;
	TaquinView* view;
	Game* game;
	GList* theme_dirlist;
};

struct _Block1Data {
	int _ref_count_;
	Taquin* self;
	GtkBuilder* builder;
};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer taquin_parent_class = NULL;
static gint taquin_tmp_size;
static gint taquin_tmp_size = 0;
static gboolean* taquin_sound;
static gboolean* taquin_sound = NULL;

GType taquin_get_type (void) G_GNUC_CONST;
GType game_type_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType taquin_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define TAQUIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAQUIN, TaquinPrivate))
enum  {
	TAQUIN_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void taquin_change_type_cb (Taquin* self, GSimpleAction* action, GVariant* variant);
static void _taquin_change_type_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_change_size_cb (Taquin* self, GSimpleAction* action, GVariant* variant);
static void _taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_change_theme_cb (Taquin* self, GSimpleAction* action, GVariant* variant);
static void _taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_help_cb (Taquin* self);
static void _taquin_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void taquin_about_cb (Taquin* self);
static void _taquin_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint taquin_main (gchar** args, int args_length1);
static Taquin* taquin_new (void);
static Taquin* taquin_construct (GType object_type);
static gint taquin_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static GameType* _game_type_dup (GameType* self);
static void taquin_real_startup (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gchar* game_type_to_string (GameType self);
TaquinView* taquin_view_new (void);
TaquinView* taquin_view_construct (GType object_type);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
static void taquin_start_game (Taquin* self);
static void _taquin_start_game_game_window_play (GameWindow* _sender, gpointer self);
static void taquin_undo_cb (Taquin* self);
static void _taquin_undo_cb_game_window_undo (GameWindow* _sender, gpointer self);
static void __lambda5_ (Taquin* self);
static void taquin_update_size_button_label (Taquin* self, gint size);
static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda6_ (Taquin* self);
static void taquin_update_theme (Taquin* self, const gchar* theme);
static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda7_ (Block1Data* _data1_);
static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void taquin_real_activate (GApplication* base);
static void taquin_real_shutdown (GApplication* base);
void game_window_shutdown (GameWindow* self, GSettings* settings);
Game* game_new (GameType game_type, gint size);
Game* game_construct (GType object_type, GameType game_type, gint size);
void taquin_view_set_game (TaquinView* self, Game* value);
void taquin_view_set_theme (TaquinView* self, const gchar* value);
static void taquin_game_complete_cb (Taquin* self);
static void _taquin_game_complete_cb_game_complete (Game* _sender, gpointer self);
static void taquin_cannot_move_cb (Taquin* self);
static void _taquin_cannot_move_cb_game_cannot_move (Game* _sender, gint x, gint y, gpointer self);
void game_window_cannot_undo_more (GameWindow* self);
static void _game_window_cannot_undo_more_game_cannot_undo_more (Game* _sender, gpointer self);
static void taquin_move_cb (Taquin* self);
static void _taquin_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self);
void game_undo (Game* self);
static void taquin_play_sound (Taquin* self, const gchar* name);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
void game_window_finish_game (GameWindow* self);
static void taquin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry TAQUIN_option_entries[7] = {{"fifteen", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play the classical 1880s’ 15-puzzle", NULL}, {"sixteen", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Try this fun alternative 16-puzzle", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &taquin_tmp_size, "Sets the puzzle edges’ size (3-5, 2-9 for debug)", NULL}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry TAQUIN_app_actions[6] = {{"change-type", _taquin_change_type_cb_gsimple_action_activate_callback, "s"}, {"change-size", _taquin_change_size_cb_gsimple_action_activate_callback, "s"}, {"change-theme", _taquin_change_theme_cb_gsimple_action_activate_callback, "s"}, {"help", _taquin_help_cb_gsimple_action_activate_callback}, {"about", _taquin_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static void _g_free0_ (gpointer var) {
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	var = (g_free (var), NULL);
#line 227 "taquin-main.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_list_free (self);
#line 236 "taquin-main.c"
}


static void _taquin_change_type_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_change_type_cb ((Taquin*) self, action, parameter);
#line 243 "taquin-main.c"
}


static void _taquin_change_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_change_size_cb ((Taquin*) self, action, parameter);
#line 250 "taquin-main.c"
}


static void _taquin_change_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_change_theme_cb ((Taquin*) self, action, parameter);
#line 257 "taquin-main.c"
}


static void _taquin_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_help_cb ((Taquin*) self);
#line 264 "taquin-main.c"
}


static void _taquin_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_about_cb ((Taquin*) self);
#line 271 "taquin-main.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_application_quit ((GApplication*) self);
#line 278 "taquin-main.c"
}


gint taquin_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Taquin* _tmp1_ = NULL;
	Taquin* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	setlocale (LC_ALL, "");
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = _ ("Taquin");
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_set_application_name (_tmp0_);
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_window_set_default_icon_name ("gnome-taquin");
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = taquin_new ();
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = _tmp1_;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = args;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3__length1 = args_length1;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = _tmp4_;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (_tmp2_);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	result = _tmp5_;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return result;
#line 323 "taquin-main.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return taquin_main (argv, argc);
#line 333 "taquin-main.c"
}


static Taquin* taquin_construct (GType object_type) {
	Taquin * self = NULL;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) g_object_new (object_type, "application-id", "org.gnome.taquin", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_application_add_main_option_entries ((GApplication*) self, TAQUIN_option_entries);
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self;
#line 345 "taquin-main.c"
}


static Taquin* taquin_new (void) {
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return taquin_construct (TYPE_TAQUIN);
#line 352 "taquin-main.c"
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	dup = g_new0 (gboolean, 1);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return dup;
#line 364 "taquin-main.c"
}


static gpointer __bool_dup0 (gpointer self) {
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self ? _bool_dup (self) : NULL;
#line 371 "taquin-main.c"
}


static GameType* _game_type_dup (GameType* self) {
	GameType* dup;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	dup = g_new0 (GameType, 1);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	memcpy (dup, self, sizeof (GameType));
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return dup;
#line 383 "taquin-main.c"
}


static gpointer __game_type_dup0 (gpointer self) {
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self ? _game_type_dup (self) : NULL;
#line 390 "taquin-main.c"
}


static gint taquin_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Taquin * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = options;
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp1_) {
#line 415 "taquin-main.c"
		FILE* _tmp2_ = NULL;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = stderr;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-taquin", VERSION);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		result = EXIT_SUCCESS;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return result;
#line 425 "taquin-main.c"
	}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = taquin_tmp_size;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp4_ != 0) {
#line 431 "taquin-main.c"
		gint _tmp5_ = 0;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp5_ = taquin_tmp_size;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = _tmp5_ < 2;
#line 437 "taquin-main.c"
	} else {
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = FALSE;
#line 441 "taquin-main.c"
	}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp3_) {
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_tmp_size = 2;
#line 447 "taquin-main.c"
	}
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = options;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = g_variant_dict_contains (_tmp6_, "mute");
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp7_) {
#line 455 "taquin-main.c"
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = FALSE;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp9_ = __bool_dup0 (&_tmp8_);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (taquin_sound);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_sound = _tmp9_;
#line 466 "taquin-main.c"
	} else {
		GVariantDict* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp10_ = options;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp11_ = g_variant_dict_contains (_tmp10_, "unmute");
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (_tmp11_) {
#line 476 "taquin-main.c"
			gboolean _tmp12_ = FALSE;
			gboolean* _tmp13_ = NULL;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp12_ = TRUE;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp13_ = __bool_dup0 (&_tmp12_);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (taquin_sound);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			taquin_sound = _tmp13_;
#line 487 "taquin-main.c"
		}
	}
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp14_ = options;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp15_ = g_variant_dict_contains (_tmp14_, "fifteen");
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp15_) {
#line 496 "taquin-main.c"
		GameType _tmp16_ = 0;
		GameType* _tmp17_ = NULL;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp16_ = GAME_TYPE_FIFTEEN;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp17_ = __game_type_dup0 (&_tmp16_);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (self->priv->tmp_type);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		self->priv->tmp_type = _tmp17_;
#line 507 "taquin-main.c"
	} else {
		GVariantDict* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp18_ = options;
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp19_ = g_variant_dict_contains (_tmp18_, "sixteen");
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (_tmp19_) {
#line 517 "taquin-main.c"
			GameType _tmp20_ = 0;
			GameType* _tmp21_ = NULL;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp20_ = GAME_TYPE_SIXTEEN;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp21_ = __game_type_dup0 (&_tmp20_);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (self->priv->tmp_type);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			self->priv->tmp_type = _tmp21_;
#line 528 "taquin-main.c"
		}
	}
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	result = -1;
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return result;
#line 535 "taquin-main.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return _data1_;
#line 544 "taquin-main.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 553 "taquin-main.c"
		Taquin* self;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		self = _data1_->self;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_object_unref0 (_data1_->builder);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_object_unref0 (self);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_slice_free (Block1Data, _data1_);
#line 563 "taquin-main.c"
	}
}


static void _taquin_start_game_game_window_play (GameWindow* _sender, gpointer self) {
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_start_game ((Taquin*) self);
#line 571 "taquin-main.c"
}


static void _taquin_undo_cb_game_window_undo (GameWindow* _sender, gpointer self) {
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_undo_cb ((Taquin*) self);
#line 578 "taquin-main.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	return self ? g_object_ref (self) : NULL;
#line 585 "taquin-main.c"
}


static void __lambda5_ (Taquin* self) {
	gboolean _tmp0_ = FALSE;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->size_changed;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (!_tmp0_) {
#line 595 "taquin-main.c"
		GSettings* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = self->priv->settings;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = g_settings_get_int (_tmp1_, "size");
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_update_size_button_label (self, _tmp2_);
#line 604 "taquin-main.c"
	}
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_changed = FALSE;
#line 608 "taquin-main.c"
}


static void ___lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__lambda5_ ((Taquin*) self);
#line 615 "taquin-main.c"
}


static void __lambda6_ (Taquin* self) {
	gboolean _tmp0_ = FALSE;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->theme_changed;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (!_tmp0_) {
#line 625 "taquin-main.c"
		GSettings* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = self->priv->settings;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = g_settings_get_string (_tmp1_, "theme");
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = _tmp2_;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		taquin_update_theme (self, _tmp3_);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (_tmp3_);
#line 639 "taquin-main.c"
	}
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_changed = FALSE;
#line 643 "taquin-main.c"
}


static void ___lambda6__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__lambda6_ ((Taquin*) self);
#line 650 "taquin-main.c"
}


static void __lambda7_ (Block1Data* _data1_) {
	Taquin* self;
	gboolean _tmp0_ = FALSE;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = _data1_->self;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->type_changed;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (!_tmp0_) {
#line 663 "taquin-main.c"
		gchar* button_name = NULL;
		GSettings* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GObject* _tmp7_ = NULL;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = self->priv->settings;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = g_settings_get_string (_tmp1_, "type");
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = _tmp2_;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp4_ = g_strconcat ("radio-", _tmp3_, NULL);
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp5_ = _tmp4_;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (_tmp3_);
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		button_name = _tmp5_;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp6_ = button_name;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp7_ = gtk_builder_get_object (_data1_->builder, _tmp6_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_radio_button_get_type (), GtkRadioButton), TRUE);
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (button_name);
#line 694 "taquin-main.c"
	}
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->type_changed = FALSE;
#line 698 "taquin-main.c"
}


static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__lambda7_ (self);
#line 705 "taquin-main.c"
}


static void taquin_real_startup (GApplication* base) {
	Taquin * self;
	Block1Data* _data1_;
	GSettings* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	gint _tmp4_ = 0;
	GameType* _tmp7_ = NULL;
	TaquinView* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GSettings* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GObject* _tmp21_ = NULL;
	TaquinView* _tmp22_ = NULL;
	GameWindow* _tmp23_ = NULL;
	GameWindow* _tmp24_ = NULL;
	GameWindow* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gchar* _tmp35_ = NULL;
	gchar** _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	gchar* _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	GObject* _tmp41_ = NULL;
	GtkMenuButton* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	GObject* _tmp46_ = NULL;
	GtkMenuButton* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	GSettings* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	GSettings* _tmp52_ = NULL;
	gchar* button_name = NULL;
	GSettings* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GSettings* _tmp59_ = NULL;
	GAction* _tmp60_ = NULL;
	GAction* _tmp61_ = NULL;
	GameWindow* _tmp62_ = NULL;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_data1_->_ref_count_ = 1;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_data1_->self = g_object_ref (self);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_APPLICATION_CLASS (taquin_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = g_settings_new ("org.gnome.taquin");
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->settings);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->settings = _tmp0_;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = taquin_sound;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp1_ != NULL) {
#line 793 "taquin-main.c"
		GSettings* _tmp2_ = NULL;
		gboolean* _tmp3_ = NULL;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = self->priv->settings;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = taquin_sound;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_settings_set_boolean (_tmp2_, "sound", *_tmp3_);
#line 802 "taquin-main.c"
	}
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = taquin_tmp_size;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp4_ > 1) {
#line 808 "taquin-main.c"
		GSettings* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp5_ = self->priv->settings;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp6_ = taquin_tmp_size;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_settings_set_int (_tmp5_, "size", _tmp6_);
#line 817 "taquin-main.c"
	}
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = self->priv->tmp_type;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp7_ != NULL) {
#line 823 "taquin-main.c"
		GSettings* _tmp8_ = NULL;
		GameType* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = self->priv->settings;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp9_ = self->priv->tmp_type;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp10_ = game_type_to_string (*_tmp9_);
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp11_ = _tmp10_;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_settings_set_string (_tmp8_, "type", _tmp11_);
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (_tmp11_);
#line 840 "taquin-main.c"
	}
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp12_ = taquin_view_new ();
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_object_ref_sink (_tmp12_);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->view);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->view = _tmp12_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp13_ = gtk_builder_new_from_resource ("/org/gnome/taquin/ui/taquin-screens.ui");
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_data1_->builder = _tmp13_;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp14_ = _ ("Taquin");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp15_ = self->priv->settings;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp16_ = g_settings_get_int (_tmp15_, "window-width");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp17_ = self->priv->settings;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp18_ = g_settings_get_int (_tmp17_, "window-height");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp19_ = self->priv->settings;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp20_ = g_settings_get_boolean (_tmp19_, "window-is-maximized");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp21_ = gtk_builder_get_object (_data1_->builder, "new-game-screen");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp22_ = self->priv->view;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp23_ = game_window_new ("/org/gnome/taquin/ui/taquin.css", _tmp14_, _tmp16_, _tmp18_, _tmp20_, TRUE, GAME_WINDOW_FLAGS_SHOW_UNDO, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp22_);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_object_ref_sink (_tmp23_);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->window);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->window = _tmp23_;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp24_ = self->priv->window;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp24_, "play", (GCallback) _taquin_start_game_game_window_play, self, 0);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp25_ = self->priv->window;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp25_, "undo", (GCallback) _taquin_undo_cb_game_window_undo, self, 0);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp26_ = g_strdup ("<Primary>n");
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp27_ = g_new0 (gchar*, 1 + 1);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp27_[0] = _tmp26_;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp28_ = _tmp27_;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp28__length1 = 1;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp28_);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp29_ = g_strdup ("<Primary><Shift>n");
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp30_ = g_new0 (gchar*, 1 + 1);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp30_[0] = _tmp29_;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp31_ = _tmp30_;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp31__length1 = 1;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp31_);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp32_ = g_strdup ("<Primary>z");
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp33_ = g_new0 (gchar*, 1 + 1);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp33_[0] = _tmp32_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp34_ = _tmp33_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp34__length1 = 1;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp34_);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp35_ = g_strdup ("<Primary><Shift>z");
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp36_ = g_new0 (gchar*, 1 + 1);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp36_[0] = _tmp35_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp37_ = _tmp36_;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp37__length1 = 1;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp37_);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp38_ = g_strdup ("Escape");
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp39_ = g_new0 (gchar*, 1 + 1);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp39_[0] = _tmp38_;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp40_ = _tmp39_;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp40__length1 = 1;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp40_);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp41_ = gtk_builder_get_object (_data1_->builder, "size-button");
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_menu_button_get_type (), GtkMenuButton));
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->size_button);
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_button = _tmp42_;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp43_ = self->priv->settings;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp43_, "changed::size", (GCallback) ___lambda5__g_settings_changed, self, 0);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp44_ = self->priv->settings;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp45_ = g_settings_get_int (_tmp44_, "size");
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_size_button_label (self, _tmp45_);
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp46_ = gtk_builder_get_object (_data1_->builder, "theme-button");
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_menu_button_get_type (), GtkMenuButton));
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->theme_button);
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_button = _tmp47_;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp48_ = self->priv->settings;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp48_, "changed::theme", (GCallback) ___lambda6__g_settings_changed, self, 0);
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp49_ = self->priv->settings;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp50_ = g_settings_get_string (_tmp49_, "theme");
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp51_ = _tmp50_;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_theme (self, _tmp51_);
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp51_);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp52_ = self->priv->settings;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_data (_tmp52_, "changed::type", (GCallback) ___lambda7__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp53_ = self->priv->settings;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp54_ = g_settings_get_string (_tmp53_, "type");
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp55_ = _tmp54_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp56_ = g_strconcat ("radio-", _tmp55_, NULL);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp57_ = _tmp56_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp55_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	button_name = _tmp57_;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp58_ = gtk_builder_get_object (_data1_->builder, button_name);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_radio_button_get_type (), GtkRadioButton), TRUE);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_action_map_add_action_entries ((GActionMap*) self, TAQUIN_app_actions, G_N_ELEMENTS (TAQUIN_app_actions), self);
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp59_ = self->priv->settings;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp60_ = g_settings_create_action (_tmp59_, "sound");
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp61_ = _tmp60_;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp61_);
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (_tmp61_);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp62_ = self->priv->window;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp62_);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_start_game (self);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (button_name);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	block1_data_unref (_data1_);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_data1_ = NULL;
#line 1044 "taquin-main.c"
}


static void taquin_real_activate (GApplication* base) {
	Taquin * self;
	GameWindow* _tmp0_ = NULL;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1057 "taquin-main.c"
}


static void taquin_real_shutdown (GApplication* base) {
	Taquin * self;
	GameWindow* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = (Taquin*) base;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = self->priv->settings;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_shutdown (_tmp0_, _tmp1_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_APPLICATION_CLASS (taquin_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1075 "taquin-main.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1093 "taquin-main.c"
}


static void _taquin_game_complete_cb_game_complete (Game* _sender, gpointer self) {
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_game_complete_cb ((Taquin*) self);
#line 1100 "taquin-main.c"
}


static void _taquin_cannot_move_cb_game_cannot_move (Game* _sender, gint x, gint y, gpointer self) {
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_cannot_move_cb ((Taquin*) self);
#line 1107 "taquin-main.c"
}


static void _game_window_cannot_undo_more_game_cannot_undo_more (Game* _sender, gpointer self) {
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_cannot_undo_more ((GameWindow*) self);
#line 1114 "taquin-main.c"
}


static void _taquin_move_cb_game_move (Game* _sender, gboolean x_axis, gint number, gint x_gap, gint y_gap, gpointer self) {
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_move_cb ((Taquin*) self);
#line 1121 "taquin-main.c"
}


static void taquin_start_game (Taquin* self) {
	Game* _tmp0_ = NULL;
	GameType type = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint size = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GameType _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	TaquinView* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	gchar* filename = NULL;
	gchar* _tmp11_ = NULL;
	GList* dirlist = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	TaquinView* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	TaquinView* _tmp49_ = NULL;
	Game* _tmp50_ = NULL;
	Game* _tmp51_ = NULL;
	Game* _tmp52_ = NULL;
	GameWindow* _tmp53_ = NULL;
	Game* _tmp54_ = NULL;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->game;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp0_ != NULL) {
#line 1162 "taquin-main.c"
		Game* _tmp1_ = NULL;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = self->priv->game;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1168 "taquin-main.c"
	}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = self->priv->settings;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = g_settings_get_enum (_tmp2_, "type");
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	type = (GameType) _tmp3_;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = self->priv->settings;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = g_settings_get_int (_tmp4_, "size");
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	size = _tmp5_;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = type;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = size;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp8_ = game_new (_tmp6_, _tmp7_);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->game);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->game = _tmp8_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_ = self->priv->view;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp10_ = self->priv->game;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_view_set_game (_tmp9_, _tmp10_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_ = g_strdup ("");
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	filename = _tmp11_;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp12_ = self->priv->theme_dirlist;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp13_ = g_list_copy (_tmp12_);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	dirlist = _tmp13_;
#line 1208 "taquin-main.c"
	{
		gboolean _tmp14_ = FALSE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp14_ = TRUE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		while (TRUE) {
#line 1215 "taquin-main.c"
			gint random = 0;
			GList* _tmp30_ = NULL;
			guint _tmp31_ = 0U;
			gint32 _tmp32_ = 0;
			GList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gconstpointer _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GList* entry = NULL;
			GList* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			GCompareFunc _tmp39_ = NULL;
			GList* _tmp40_ = NULL;
			GList* _tmp41_ = NULL;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			if (!_tmp14_) {
#line 1232 "taquin-main.c"
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp16_ = NULL;
				gchar _tmp17_ = '\0';
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp16_ = filename;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp17_ = string_get (_tmp16_, (glong) 0);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				if (_tmp17_ == '0') {
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp15_ = TRUE;
#line 1244 "taquin-main.c"
				} else {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					const gchar* _tmp20_ = NULL;
					gchar _tmp21_ = '\0';
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp20_ = filename;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp21_ = string_get (_tmp20_, (glong) 0);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					if (_tmp21_ != '1') {
#line 1256 "taquin-main.c"
						const gchar* _tmp22_ = NULL;
						gchar _tmp23_ = '\0';
						gint _tmp24_ = 0;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar _tmp27_ = '\0';
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp22_ = filename;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp23_ = string_get (_tmp22_, (glong) 0);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp24_ = size;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp25_ = g_strdup_printf ("%i", _tmp24_);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp26_ = _tmp25_;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp27_ = string_get (_tmp26_, (glong) 0);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp19_ = _tmp23_ != _tmp27_;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_g_free0 (_tmp26_);
#line 1279 "taquin-main.c"
					} else {
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp19_ = FALSE;
#line 1283 "taquin-main.c"
					}
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					if (_tmp19_) {
#line 1287 "taquin-main.c"
						GList* _tmp28_ = NULL;
						guint _tmp29_ = 0U;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp28_ = dirlist;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp29_ = g_list_length (_tmp28_);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp18_ = _tmp29_ != ((guint) 0);
#line 1296 "taquin-main.c"
					} else {
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
						_tmp18_ = FALSE;
#line 1300 "taquin-main.c"
					}
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					_tmp15_ = _tmp18_;
#line 1304 "taquin-main.c"
				}
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				if (!_tmp15_) {
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
					break;
#line 1310 "taquin-main.c"
				}
			}
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp14_ = FALSE;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp30_ = dirlist;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp31_ = g_list_length (_tmp30_);
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp32_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp31_));
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			random = (gint) _tmp32_;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp33_ = dirlist;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp34_ = random;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp35_ = g_list_nth_data (_tmp33_, (guint) _tmp34_);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp36_ = g_strdup ((const gchar*) _tmp35_);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (filename);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			filename = _tmp36_;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp37_ = dirlist;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp38_ = filename;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp39_ = g_strcmp0;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp40_ = g_list_find_custom (_tmp37_, _tmp38_, _tmp39_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			entry = _tmp40_;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp41_ = entry;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			dirlist = g_list_remove_link (dirlist, _tmp41_);
#line 1349 "taquin-main.c"
		}
	}
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp42_ = self->priv->view;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp43_ = self->priv->settings;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp44_ = g_settings_get_string (_tmp43_, "theme");
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp45_ = _tmp44_;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp46_ = filename;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp47_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp45_, _tmp46_, NULL);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp48_ = _tmp47_;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_view_set_theme (_tmp42_, _tmp48_);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp48_);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp45_);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp49_ = self->priv->view;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_widget_realize ((GtkWidget*) _tmp49_);
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp50_ = self->priv->game;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp50_, "complete", (GCallback) _taquin_game_complete_cb_game_complete, self, 0);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp51_ = self->priv->game;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp51_, "cannot-move", (GCallback) _taquin_cannot_move_cb_game_cannot_move, self, 0);
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp52_ = self->priv->game;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp53_ = self->priv->window;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp52_, "cannot-undo-more", (GCallback) _game_window_cannot_undo_more_game_cannot_undo_more, _tmp53_, 0);
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp54_ = self->priv->game;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_signal_connect_object (_tmp54_, "move", (GCallback) _taquin_move_cb_game_move, self, 0);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_list_free0 (dirlist);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (filename);
#line 1398 "taquin-main.c"
}


static void taquin_about_cb (Taquin* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GameWindow* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = g_strdup ("Arnaud Bonatti");
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_new0 (gchar*, 2 + 1);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_[0] = _tmp0_;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_[1] = NULL;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	authors = _tmp1_;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	authors_length1 = 2;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_authors_size_ = authors_length1;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = g_strdup ("Ola Einang (Flickr)");
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = g_strdup ("Ruskis (Wikimedia)");
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = g_strdup ("Alvesgaspar (Wikimedia)");
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = g_strdup ("Mark J. Sebastian (Flickr)");
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = g_strdup ("Mueller-rech.muenchen (Wikimedia)");
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = _ ("(see COPYING.themes for informations)");
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_ = g_new0 (gchar*, 7 + 1);
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[0] = _tmp2_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[1] = _tmp3_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[2] = _tmp4_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[3] = _tmp5_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[4] = _tmp6_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[5] = _tmp8_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp9_[6] = NULL;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	artists = _tmp9_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	artists_length1 = 7;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_artists_size_ = artists_length1;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp10_ = g_strdup ("Arnaud Bonatti");
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_ = g_new0 (gchar*, 2 + 1);
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_[0] = _tmp10_;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp11_[1] = NULL;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	documenters = _tmp11_;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	documenters_length1 = 2;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_documenters_size_ = documenters_length1;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp12_ = self->priv->window;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp13_ = _ ("Taquin");
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp14_ = _ ("A classic 15-puzzle game");
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp15_ = _ ("translator-credits");
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp12_, "name", _tmp13_, "version", VERSION, "copyright", "Copyright © 2014-2015 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp14_, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp15_, "logo-icon-name", "gnome-taquin", "website", "https://wiki.gnome.org/Apps/Taquin", NULL, NULL);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1510 "taquin-main.c"
}


static void taquin_help_cb (Taquin* self) {
	GError * _inner_error_ = NULL;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 1518 "taquin-main.c"
	{
		GameWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp0_ = self->priv->window;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		gtk_show_uri (_tmp1_, "help:gnome-taquin", _tmp2_, &_inner_error_);
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1533 "taquin-main.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		e = _inner_error_;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_inner_error_ = NULL;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp3_ = e;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp4_ = _tmp3_->message;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_warning ("taquin-main.vala:272: Failed to show help: %s", _tmp4_);
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_error_free0 (e);
#line 1555 "taquin-main.c"
	}
	__finally0:
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_clear_error (&_inner_error_);
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return;
#line 1566 "taquin-main.c"
	}
}


static void taquin_undo_cb (Taquin* self) {
	Game* _tmp0_ = NULL;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->game;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_undo (_tmp0_);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_play_sound (self, "sliding-1");
#line 1581 "taquin-main.c"
}


static void taquin_move_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	GameWindow* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_set_subtitle (_tmp0_, NULL);
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = self->priv->window;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = _tmp1_->undo_action;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_simple_action_set_enabled (_tmp2_, TRUE);
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_play_sound (self, "sliding-1");
#line 1603 "taquin-main.c"
}


static void taquin_cannot_move_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = _ ("You can’t move this tile!");
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_set_subtitle (_tmp0_, _tmp1_);
#line 1618 "taquin-main.c"
}


static void taquin_game_complete_cb (Taquin* self) {
	GameWindow* _tmp0_ = NULL;
	GameWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GameWindow* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->window;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_finish_game (_tmp0_);
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = self->priv->window;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = _ ("Bravo! You finished the game!");
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	game_window_set_subtitle (_tmp1_, _tmp2_);
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = self->priv->window;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = _tmp3_->undo_action;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_simple_action_set_enabled (_tmp4_, FALSE);
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_play_sound (self, "gameover");
#line 1648 "taquin-main.c"
}


static void taquin_change_type_cb (Taquin* self, GSimpleAction* action, GVariant* variant) {
	GSettings* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (action != NULL);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->type_changed = TRUE;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->settings;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = variant;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_settings_set_string (_tmp0_, "type", _tmp2_);
#line 1670 "taquin-main.c"
}


static void taquin_change_size_cb (Taquin* self, GSimpleAction* action, GVariant* variant) {
	gint size = 0;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (action != NULL);
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_changed = TRUE;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = variant;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = atoi (_tmp1_);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	size = _tmp2_;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_size_button_label (self, size);
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = self->priv->settings;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_settings_set_int (_tmp3_, "size", size);
#line 1700 "taquin-main.c"
}


static void taquin_update_size_button_label (Taquin* self, gint size) {
	GtkMenuButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->size_button;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = _ ("Size: %d × %d ▾");
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = size;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = size;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp2_, _tmp3_);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = _tmp4_;
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	gtk_button_set_label ((GtkButton*) _tmp0_, _tmp5_);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp5_);
#line 1729 "taquin-main.c"
}


static void taquin_change_theme_cb (Taquin* self, GSimpleAction* action, GVariant* variant) {
	gchar* name = NULL;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (action != NULL);
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_changed = TRUE;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = variant;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	name = _tmp2_;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_update_theme (self, name);
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = self->priv->settings;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_settings_set_string (_tmp3_, "theme", name);
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (name);
#line 1761 "taquin-main.c"
}


static void taquin_update_theme (Taquin* self, const gchar* theme) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	static GQuark _tmp2_label0 = 0;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	static GQuark _tmp2_label1 = 0;
#line 1773 "taquin-main.c"
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (theme != NULL);
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = theme;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = _tmp0_;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("cats")))) {
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		switch (0) {
#line 1790 "taquin-main.c"
			default:
			{
				GtkMenuButton* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp4_ = self->priv->theme_button;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp5_ = _ ("Theme: Cats ▾");
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				gtk_button_set_label ((GtkButton*) _tmp4_, _tmp5_);
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1803 "taquin-main.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("numbers")))) {
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		switch (0) {
#line 1809 "taquin-main.c"
			default:
			{
				GtkMenuButton* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp6_ = self->priv->theme_button;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_tmp7_ = _ ("Theme: Numbers ▾");
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				gtk_button_set_label ((GtkButton*) _tmp6_, _tmp7_);
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1822 "taquin-main.c"
			}
		}
	} else {
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		switch (0) {
#line 1828 "taquin-main.c"
			default:
			{
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				g_warn_if_reached ();
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1835 "taquin-main.c"
			}
		}
	}
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__g_list_free__g_free0_0 (self->priv->theme_dirlist);
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_dirlist = NULL;
#line 1843 "taquin-main.c"
	{
		GDir* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GDir* _tmp12_ = NULL;
		GDir* _tmp13_ = NULL;
		GDir* _tmp14_ = NULL;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp9_ = theme;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp10_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp9_, NULL);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp11_ = _tmp10_;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp12_ = g_dir_open (_tmp11_, (guint) 0, &_inner_error_);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp13_ = _tmp12_;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_free0 (_tmp11_);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = _tmp13_;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 1870 "taquin-main.c"
				goto __catch1_g_file_error;
			}
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_dir_close0 (dir);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			g_clear_error (&_inner_error_);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			return;
#line 1881 "taquin-main.c"
		}
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp14_ = _tmp8_;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp8_ = NULL;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_dir_close0 (dir);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		dir = _tmp14_;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		while (TRUE) {
#line 1893 "taquin-main.c"
			gchar* filename = NULL;
			GDir* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp15_ = dir;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp16_ = g_dir_read_name (_tmp15_);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp17_ = g_strdup (_tmp16_);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			filename = _tmp17_;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp18_ = filename;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			if (_tmp18_ == NULL) {
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				_g_free0 (filename);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
				break;
#line 1917 "taquin-main.c"
			}
#line 358 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp19_ = filename;
#line 358 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_tmp20_ = g_strdup (_tmp19_);
#line 358 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			self->priv->theme_dirlist = g_list_append (self->priv->theme_dirlist, _tmp20_);
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
			_g_free0 (filename);
#line 1927 "taquin-main.c"
		}
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_dir_close0 (_tmp8_);
#line 1931 "taquin-main.c"
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		e = _inner_error_;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_inner_error_ = NULL;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp21_ = e;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_tmp22_ = _tmp21_->message;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_warning ("taquin-main.vala:363: Failed to load images: %s", _tmp22_);
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_error_free0 (e);
#line 1951 "taquin-main.c"
	}
	__finally1:
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		_g_dir_close0 (dir);
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		g_clear_error (&_inner_error_);
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return;
#line 1964 "taquin-main.c"
	}
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_dir_close0 (dir);
#line 1968 "taquin-main.c"
}


static void taquin_play_sound (Taquin* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	TaquinView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (self != NULL);
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_return_if_fail (name != NULL);
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp0_ = self->priv->settings;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	if (!_tmp1_) {
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
		return;
#line 1994 "taquin-main.c"
	}
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp2_ = self->priv->view;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp3_ = name;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp4_ = name;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp6_ = _tmp5_;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_tmp8_ = _tmp7_;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp8_);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (_tmp6_);
#line 2016 "taquin-main.c"
}


static void taquin_class_init (TaquinClass * klass) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	taquin_parent_class = g_type_class_peek_parent (klass);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	g_type_class_add_private (klass, sizeof (TaquinPrivate));
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->handle_local_options = taquin_real_handle_local_options;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->startup = taquin_real_startup;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->activate = taquin_real_activate;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	((GApplicationClass *) klass)->shutdown = taquin_real_shutdown;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_OBJECT_CLASS (klass)->finalize = taquin_finalize;
#line 2035 "taquin-main.c"
}


static void taquin_instance_init (Taquin * self) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv = TAQUIN_GET_PRIVATE (self);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->tmp_type = NULL;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->type_changed = FALSE;
#line 30 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->size_changed = FALSE;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->theme_changed = FALSE;
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self->priv->game = NULL;
#line 2052 "taquin-main.c"
}


static void taquin_finalize (GObject* obj) {
	Taquin * self;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN, Taquin);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->settings);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_free0 (self->priv->tmp_type);
#line 35 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->window);
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->size_button);
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->theme_button);
#line 38 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->view);
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	_g_object_unref0 (self->priv->game);
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	__g_list_free__g_free0_0 (self->priv->theme_dirlist);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-main.vala"
	G_OBJECT_CLASS (taquin_parent_class)->finalize (obj);
#line 2078 "taquin-main.c"
}


GType taquin_get_type (void) {
	static volatile gsize taquin_type_id__volatile = 0;
	if (g_once_init_enter (&taquin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaquinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Taquin), 0, (GInstanceInitFunc) taquin_instance_init, NULL };
		GType taquin_type_id;
		taquin_type_id = g_type_register_static (gtk_application_get_type (), "Taquin", &g_define_type_info, 0);
		g_once_init_leave (&taquin_type_id__volatile, taquin_type_id);
	}
	return taquin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



