/* taquin-game.c generated by valac 0.27.1.26-9b1a5, the Vala compiler
 * generated from taquin-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define GAME_TYPE_UNDO_ITEM (game_undo_item_get_type ())
typedef struct _GameUndoItem GameUndoItem;
#define _game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (game_undo_item_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameUndoItem {
	gint x;
	gint y;
	GameUndoItem* next;
	GameUndoItem* previous;
};

struct _GamePrivate {
	gint* _tiles;
	gint _tiles_length1;
	gint _tiles_length2;
	gint _size;
	GameType _game_type;
	GameUndoItem* state;
	GameUndoItem* previous_state;
	gint x_gap;
	gint y_gap;
};


static gpointer game_parent_class = NULL;

GType game_type_get_type (void) G_GNUC_CONST;
gchar* game_type_to_string (GameType self);
GType game_get_type (void) G_GNUC_CONST;
static GType game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GameUndoItem* game_undo_item_dup (const GameUndoItem* self);
static void game_undo_item_free (GameUndoItem* self);
static void game_undo_item_copy (const GameUndoItem* self, GameUndoItem* dest);
static void game_undo_item_destroy (GameUndoItem* self);
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_SIZE,
	GAME_GAME_TYPE
};
Game* game_new (GameType game_type, gint size);
Game* game_construct (GType object_type, GameType game_type, gint size);
static void game_set_size (Game* self, gint value);
static void game_set_game_type (Game* self, GameType value);
static void game_set_tiles (Game* self, gint* value, int value_length1, int value_length2);
static gint* _int_dup (gint* self);
gint* game_get_tiles (Game* self, int* result_length1, int* result_length2);
gchar* game_to_string (Game* self);
gint game_get_size (Game* self);
void game_request_move (Game* self, gint x, gint y);
GameType game_get_game_type (Game* self);
static void game_fifteen_move (Game* self, gint x, gint y, gboolean undoing);
static void game_sixteen_move (Game* self, gint x, gint y, gboolean undoing);
static void game_add_move (Game* self, gint x_gap, gint y_gap);
static void game_check_complete (Game* self);
void game_undo (Game* self);
static gint* _vala_array_dup1 (gint* self, int length);
static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* game_type_to_string (GameType self) {
	gchar* result = NULL;
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	switch (self) {
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_TYPE_FIFTEEN:
#line 135 "taquin-game.c"
		{
			gchar* _tmp0_ = NULL;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp0_ = g_strdup ("fifteen");
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			result = _tmp0_;
#line 31 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			return result;
#line 144 "taquin-game.c"
		}
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_TYPE_SIXTEEN:
#line 148 "taquin-game.c"
		{
			gchar* _tmp1_ = NULL;
#line 33 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp1_ = g_strdup ("sixteen");
#line 33 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			result = _tmp1_;
#line 33 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			return result;
#line 157 "taquin-game.c"
		}
		default:
		{
#line 35 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			g_assert_not_reached ();
#line 163 "taquin-game.c"
		}
	}
}


GType game_type_get_type (void) {
	static volatile gsize game_type_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_TYPE_FIFTEEN, "GAME_TYPE_FIFTEEN", "fifteen"}, {GAME_TYPE_SIXTEEN, "GAME_TYPE_SIXTEEN", "sixteen"}, {0, NULL, NULL}};
		GType game_type_type_id;
		game_type_type_id = g_enum_register_static ("GameType", values);
		g_once_init_leave (&game_type_type_id__volatile, game_type_type_id);
	}
	return game_type_type_id__volatile;
}


static gint* _int_dup (gint* self) {
	gint* dup;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	dup = g_new0 (gint, 1);
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	memcpy (dup, self, sizeof (gint));
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return dup;
#line 189 "taquin-game.c"
}


static gpointer __int_dup0 (gpointer self) {
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return self ? _int_dup (self) : NULL;
#line 196 "taquin-game.c"
}


Game* game_construct (GType object_type, GameType game_type, gint size) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GameType _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gint ntiles = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint** line = NULL;
	gint _tmp9_ = 0;
	gint** _tmp10_ = NULL;
	gint line_length1 = 0;
	gint _line_size_ = 0;
	gint i = 0;
	GameType _tmp26_ = 0;
	gboolean parity_grid = FALSE;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean parity_game = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = size;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_vala_return_val_if_fail (_tmp0_ >= 2, "size >= 2", NULL);
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 69 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = size;
#line 69 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_set_size (self, _tmp1_);
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp2_ = game_type;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_set_game_type (self, _tmp2_);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = size;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp4_ = size;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp5_ = g_new0 (gint, _tmp3_ * _tmp4_);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6_ = _tmp5_;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6__length1 = _tmp3_;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6__length2 = _tmp4_;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_set_tiles (self, _tmp6_, _tmp3_, _tmp4_);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6_ = (g_free (_tmp6_), NULL);
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp7_ = size;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_ = size;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	ntiles = _tmp7_ * _tmp8_;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp9_ = ntiles;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = g_new0 (gint*, _tmp9_);
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	line = _tmp10_;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	line_length1 = _tmp9_;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_line_size_ = line_length1;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	i = 0;
#line 275 "taquin-game.c"
	{
		gint n = 0;
		gint _tmp11_ = 0;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp11_ = ntiles;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		n = _tmp11_ - 1;
#line 283 "taquin-game.c"
		{
			gboolean _tmp12_ = FALSE;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp12_ = TRUE;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 290 "taquin-game.c"
				gint _tmp14_ = 0;
				gint** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint* _tmp24_ = NULL;
				gint* _tmp25_ = NULL;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp12_) {
#line 300 "taquin-game.c"
					gint _tmp13_ = 0;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp13_ = n;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					n = _tmp13_ - 1;
#line 306 "taquin-game.c"
				}
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp12_ = FALSE;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp14_ = n;
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp14_ >= 0)) {
#line 76 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 316 "taquin-game.c"
				}
				{
					gboolean _tmp15_ = FALSE;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp15_ = TRUE;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 324 "taquin-game.c"
						gint _tmp19_ = 0;
						gint32 _tmp20_ = 0;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp15_) {
#line 329 "taquin-game.c"
							gint** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp17_ = 0;
							gint* _tmp18_ = NULL;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp16_ = line;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp16__length1 = line_length1;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp17_ = i;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp18_ = _tmp16_[_tmp17_];
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!(_tmp18_ != NULL)) {
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								break;
#line 346 "taquin-game.c"
							}
						}
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp15_ = FALSE;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp19_ = ntiles;
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp20_ = g_random_int_range ((gint32) 0, (gint32) _tmp19_);
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						i = (gint) _tmp20_;
#line 357 "taquin-game.c"
					}
				}
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21_ = line;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21__length1 = line_length1;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp22_ = i;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp23_ = n;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp24_ = __int_dup0 (&_tmp23_);
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_g_free0 (_tmp21_[_tmp22_]);
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21_[_tmp22_] = _tmp24_;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp25_ = _tmp21_[_tmp22_];
#line 376 "taquin-game.c"
			}
		}
	}
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp26_ = game_type;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp26_ == GAME_TYPE_FIFTEEN) {
#line 384 "taquin-game.c"
		gint** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gint _tmp28_ = 0;
		gint** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		gint* _tmp30_ = NULL;
		gint* _tmp31_ = NULL;
		gint* _tmp32_ = NULL;
		gint** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		gint _tmp34_ = 0;
		gint* _tmp35_ = NULL;
		gint* _tmp36_ = NULL;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27_ = line;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27__length1 = line_length1;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp28_ = i;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp29_ = line;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp29__length1 = line_length1;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp30_ = _tmp29_[0];
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp31_ = __int_dup0 (_tmp30_);
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp27_[_tmp28_]);
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27_[_tmp28_] = _tmp31_;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp32_ = _tmp27_[_tmp28_];
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33_ = line;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33__length1 = line_length1;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp34_ = -1;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp35_ = __int_dup0 (&_tmp34_);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp33_[0]);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33_[0] = _tmp35_;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp36_ = _tmp33_[0];
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		self->priv->x_gap = 0;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		self->priv->y_gap = 0;
#line 436 "taquin-game.c"
	}
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp37_ = size;
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp38_ = size;
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	parity_grid = ((gboolean) ((_tmp37_ % 2) ^ (_tmp38_ % 2))) & (1 == 0);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	parity_game = FALSE;
#line 446 "taquin-game.c"
	{
		gint j = 0;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		j = 0;
#line 451 "taquin-game.c"
		{
			gboolean _tmp39_ = FALSE;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp39_ = TRUE;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 458 "taquin-game.c"
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp39_) {
#line 463 "taquin-game.c"
					gint _tmp40_ = 0;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp40_ = j;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					j = _tmp40_ + 1;
#line 469 "taquin-game.c"
				}
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp39_ = FALSE;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp41_ = j;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp42_ = ntiles;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp41_ < (_tmp42_ - 1))) {
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 481 "taquin-game.c"
				}
				{
					gint k = 0;
					gint _tmp43_ = 0;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43_ = j;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					k = _tmp43_ + 1;
#line 490 "taquin-game.c"
					{
						gboolean _tmp44_ = FALSE;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp44_ = TRUE;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						while (TRUE) {
#line 497 "taquin-game.c"
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint** _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							gint _tmp49_ = 0;
							gint* _tmp50_ = NULL;
							gint** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp52_ = 0;
							gint* _tmp53_ = NULL;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!_tmp44_) {
#line 510 "taquin-game.c"
								gint _tmp45_ = 0;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								_tmp45_ = k;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								k = _tmp45_ + 1;
#line 516 "taquin-game.c"
							}
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp44_ = FALSE;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp46_ = k;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp47_ = ntiles;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!(_tmp46_ < _tmp47_)) {
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								break;
#line 528 "taquin-game.c"
							}
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp48_ = line;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp48__length1 = line_length1;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp49_ = j;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp50_ = _tmp48_[_tmp49_];
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp51_ = line;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp51__length1 = line_length1;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp52_ = k;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp53_ = _tmp51_[_tmp52_];
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if ((*_tmp50_) > (*_tmp53_)) {
#line 548 "taquin-game.c"
								gboolean _tmp54_ = FALSE;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								_tmp54_ = parity_game;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								parity_game = !_tmp54_;
#line 554 "taquin-game.c"
							}
						}
					}
				}
			}
		}
	}
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp55_ = parity_game;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp56_ = parity_grid;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp55_ != _tmp56_) {
#line 568 "taquin-game.c"
		gint* save = NULL;
		gint** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		gint* _tmp58_ = NULL;
		gint* _tmp59_ = NULL;
		gint** _tmp60_ = NULL;
		gint _tmp60__length1 = 0;
		gint** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		gint _tmp62_ = 0;
		gint* _tmp63_ = NULL;
		gint* _tmp64_ = NULL;
		gint* _tmp65_ = NULL;
		gint** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gint _tmp67_ = 0;
		gint* _tmp68_ = NULL;
		gint* _tmp69_ = NULL;
		gint* _tmp70_ = NULL;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp57_ = line;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp57__length1 = line_length1;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp58_ = _tmp57_[1];
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp59_ = __int_dup0 (_tmp58_);
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		save = _tmp59_;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp60_ = line;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp60__length1 = line_length1;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp61_ = line;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp61__length1 = line_length1;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp62_ = size;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp63_ = _tmp61_[_tmp62_ + 1];
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp64_ = __int_dup0 (_tmp63_);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp60_[1]);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp60_[1] = _tmp64_;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp65_ = _tmp60_[1];
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp66_ = line;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp66__length1 = line_length1;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp67_ = size;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp68_ = save;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp69_ = __int_dup0 (_tmp68_);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (_tmp66_[_tmp67_ + 1]);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp66_[_tmp67_ + 1] = _tmp69_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp70_ = _tmp66_[_tmp67_ + 1];
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_g_free0 (save);
#line 636 "taquin-game.c"
	}
	{
		gint j = 0;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		j = 0;
#line 642 "taquin-game.c"
		{
			gboolean _tmp71_ = FALSE;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp71_ = TRUE;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 649 "taquin-game.c"
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint* _tmp75_ = NULL;
				gint _tmp75__length1 = 0;
				gint _tmp75__length2 = 0;
				gint* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp76__length2 = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				gint** _tmp81_ = NULL;
				gint _tmp81__length1 = 0;
				gint _tmp82_ = 0;
				gint* _tmp83_ = NULL;
				gint _tmp84_ = 0;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp71_) {
#line 669 "taquin-game.c"
					gint _tmp72_ = 0;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp72_ = j;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					j = _tmp72_ + 1;
#line 675 "taquin-game.c"
				}
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp71_ = FALSE;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp73_ = j;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp74_ = ntiles;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp73_ < _tmp74_)) {
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 687 "taquin-game.c"
				}
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp75_ = game_get_tiles (self, &_tmp75__length1, &_tmp75__length2);
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76_ = _tmp75_;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76__length1 = _tmp75__length1;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76__length2 = _tmp75__length2;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp77_ = j;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp78_ = size;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp79_ = j;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp80_ = size;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp81_ = line;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp81__length1 = line_length1;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp82_ = j;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp83_ = _tmp81_[_tmp82_];
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp76_[((_tmp77_ % _tmp78_) * _tmp76__length2) + (_tmp79_ / _tmp80_)] = *_tmp83_;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp84_ = _tmp76_[((_tmp77_ % _tmp78_) * _tmp76__length2) + (_tmp79_ / _tmp80_)];
#line 717 "taquin-game.c"
			}
		}
	}
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return self;
#line 725 "taquin-game.c"
}


Game* game_new (GameType game_type, gint size) {
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return game_construct (TYPE_GAME, game_type, size);
#line 732 "taquin-game.c"
}


gchar* game_to_string (Game* self) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = g_strdup ("\n");
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	s = _tmp0_;
#line 746 "taquin-game.c"
	{
		gint x = 0;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		x = 0;
#line 751 "taquin-game.c"
		{
			gboolean _tmp1_ = FALSE;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp1_ = TRUE;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 758 "taquin-game.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp1_) {
#line 765 "taquin-game.c"
					gint _tmp2_ = 0;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp2_ = x;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					x = _tmp2_ + 1;
#line 771 "taquin-game.c"
				}
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp1_ = FALSE;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp3_ = x;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp4_ = self->priv->_size;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 783 "taquin-game.c"
				}
				{
					gint y = 0;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					y = 0;
#line 789 "taquin-game.c"
					{
						gboolean _tmp5_ = FALSE;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp5_ = TRUE;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						while (TRUE) {
#line 796 "taquin-game.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							const gchar* _tmp9_ = NULL;
							gint* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gchar* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!_tmp5_) {
#line 816 "taquin-game.c"
								gint _tmp6_ = 0;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								_tmp6_ = y;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								y = _tmp6_ + 1;
#line 822 "taquin-game.c"
							}
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp5_ = FALSE;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp7_ = y;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp8_ = self->priv->_size;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
								break;
#line 834 "taquin-game.c"
							}
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp9_ = s;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp10_ = game_get_tiles (self, &_tmp10__length1, &_tmp10__length2);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp11_ = _tmp10_;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp11__length1 = _tmp10__length1;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp11__length2 = _tmp10__length2;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp12_ = y;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp13_ = x;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp15_ = g_strdup_printf ("%i", _tmp14_ + 1);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp16_ = _tmp15_;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp17_ = g_strconcat (" ", _tmp16_, NULL);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp18_ = _tmp17_;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp19_ = g_strconcat (_tmp9_, _tmp18_, NULL);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_g_free0 (s);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							s = _tmp19_;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_g_free0 (_tmp18_);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_g_free0 (_tmp16_);
#line 870 "taquin-game.c"
						}
					}
				}
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp20_ = s;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_g_free0 (s);
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				s = _tmp21_;
#line 882 "taquin-game.c"
			}
		}
	}
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = s;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 890 "taquin-game.c"
}


void game_request_move (Game* self, gint x, gint y) {
	GameType _tmp0_ = 0;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_game_type;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_ == GAME_TYPE_FIFTEEN) {
#line 902 "taquin-game.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = x;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = y;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_fifteen_move (self, _tmp1_, _tmp2_, FALSE);
#line 911 "taquin-game.c"
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp3_ = x;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = y;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_sixteen_move (self, _tmp3_, _tmp4_, FALSE);
#line 921 "taquin-game.c"
	}
}


static void game_fifteen_move (Game* self, gint x, gint y, gboolean undoing) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gboolean move_x_axis = FALSE;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gint move_number = 0;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint* _tmp93_ = NULL;
	gint _tmp93__length1 = 0;
	gint _tmp93__length2 = 0;
	gint* _tmp94_ = NULL;
	gint _tmp94__length1 = 0;
	gint _tmp94__length2 = 0;
	gint _tmp95_ = 0;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	gboolean _tmp98_ = FALSE;
	gint _tmp99_ = 0;
	gint _tmp100_ = 0;
	gint _tmp101_ = 0;
#line 137 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = x;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp3_ < 0) {
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = TRUE;
#line 966 "taquin-game.c"
	} else {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = x;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp5_ = self->priv->_size;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = _tmp4_ >= _tmp5_;
#line 976 "taquin-game.c"
	}
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp2_) {
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = TRUE;
#line 982 "taquin-game.c"
	} else {
		gint _tmp6_ = 0;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp6_ = y;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = _tmp6_ < 0;
#line 989 "taquin-game.c"
	}
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_) {
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = TRUE;
#line 995 "taquin-game.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp7_ = y;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp8_ = self->priv->_size;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = _tmp7_ >= _tmp8_;
#line 1005 "taquin-game.c"
	}
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_) {
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 1011 "taquin-game.c"
	}
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = x;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp11_ = self->priv->x_gap;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp10_ == _tmp11_) {
#line 1019 "taquin-game.c"
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = y;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp13_ = self->priv->y_gap;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = _tmp12_ == _tmp13_;
#line 1028 "taquin-game.c"
	} else {
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = FALSE;
#line 1032 "taquin-game.c"
	}
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp9_) {
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_signal_emit_by_name (self, "empty-tile");
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 1040 "taquin-game.c"
	}
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp15_ = x;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp16_ = self->priv->x_gap;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp15_ != _tmp16_) {
#line 1048 "taquin-game.c"
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp17_ = y;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp18_ = self->priv->y_gap;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = _tmp17_ != _tmp18_;
#line 1057 "taquin-game.c"
	} else {
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = FALSE;
#line 1061 "taquin-game.c"
	}
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp14_) {
#line 1065 "taquin-game.c"
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp19_ = x;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp20_ = y;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_signal_emit_by_name (self, "cannot-move", _tmp19_, _tmp20_);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 1076 "taquin-game.c"
	}
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp21_ = x;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp22_ = self->priv->x_gap;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	move_x_axis = _tmp21_ != _tmp22_;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp24_ = move_x_axis;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp24_) {
#line 1088 "taquin-game.c"
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp25_ = self->priv->x_gap;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp26_ = x;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp23_ = _tmp25_ - _tmp26_;
#line 1097 "taquin-game.c"
	} else {
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp27_ = self->priv->y_gap;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp28_ = y;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp23_ = _tmp27_ - _tmp28_;
#line 1107 "taquin-game.c"
	}
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	move_number = _tmp23_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp29_ = undoing;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (!_tmp29_) {
#line 1115 "taquin-game.c"
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp30_ = self->priv->x_gap;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp31_ = self->priv->y_gap;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_add_move (self, _tmp30_, _tmp31_);
#line 1124 "taquin-game.c"
	}
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp32_ = move_x_axis;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp32_) {
#line 1130 "taquin-game.c"
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp33_ = x;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp34_ = self->priv->x_gap;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp33_ < _tmp34_) {
#line 1139 "taquin-game.c"
			{
				gboolean _tmp35_ = FALSE;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp35_ = TRUE;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1146 "taquin-game.c"
					gint* _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					gint _tmp38__length2 = 0;
					gint* _tmp39_ = NULL;
					gint _tmp39__length1 = 0;
					gint _tmp39__length2 = 0;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					gint* _tmp42_ = NULL;
					gint _tmp42__length1 = 0;
					gint _tmp42__length2 = 0;
					gint* _tmp43_ = NULL;
					gint _tmp43__length1 = 0;
					gint _tmp43__length2 = 0;
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp35_) {
#line 1168 "taquin-game.c"
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36_ = self->priv->x_gap;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp37_ = x;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp36_ != _tmp37_)) {
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1179 "taquin-game.c"
						}
					}
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp35_ = FALSE;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp38_ = game_get_tiles (self, &_tmp38__length1, &_tmp38__length2);
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39_ = _tmp38_;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39__length1 = _tmp38__length1;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39__length2 = _tmp38__length2;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp40_ = self->priv->x_gap;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp41_ = y;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp42_ = game_get_tiles (self, &_tmp42__length1, &_tmp42__length2);
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43_ = _tmp42_;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43__length1 = _tmp42__length1;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp43__length2 = _tmp42__length2;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp44_ = self->priv->x_gap;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp45_ = y;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp46_ = _tmp43_[((_tmp44_ - 1) * _tmp43__length2) + _tmp45_];
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_] = _tmp46_;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp47_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp48_ = self->priv->x_gap;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->x_gap = _tmp48_ - 1;
#line 1218 "taquin-game.c"
				}
			}
		} else {
			{
				gboolean _tmp49_ = FALSE;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp49_ = TRUE;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1228 "taquin-game.c"
					gint* _tmp52_ = NULL;
					gint _tmp52__length1 = 0;
					gint _tmp52__length2 = 0;
					gint* _tmp53_ = NULL;
					gint _tmp53__length1 = 0;
					gint _tmp53__length2 = 0;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					gint* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					gint _tmp56__length2 = 0;
					gint* _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp57__length2 = 0;
					gint _tmp58_ = 0;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp49_) {
#line 1250 "taquin-game.c"
						gint _tmp50_ = 0;
						gint _tmp51_ = 0;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp50_ = self->priv->x_gap;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp51_ = x;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp50_ != _tmp51_)) {
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1261 "taquin-game.c"
						}
					}
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp49_ = FALSE;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp52_ = game_get_tiles (self, &_tmp52__length1, &_tmp52__length2);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53_ = _tmp52_;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53__length1 = _tmp52__length1;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53__length2 = _tmp52__length2;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp54_ = self->priv->x_gap;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp55_ = y;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp56_ = game_get_tiles (self, &_tmp56__length1, &_tmp56__length2);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp57_ = _tmp56_;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp57__length1 = _tmp56__length1;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp57__length2 = _tmp56__length2;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp58_ = self->priv->x_gap;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp59_ = y;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp60_ = _tmp57_[((_tmp58_ + 1) * _tmp57__length2) + _tmp59_];
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp53_[(_tmp54_ * _tmp53__length2) + _tmp55_] = _tmp60_;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp61_ = _tmp53_[(_tmp54_ * _tmp53__length2) + _tmp55_];
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp62_ = self->priv->x_gap;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->x_gap = _tmp62_ + 1;
#line 1300 "taquin-game.c"
				}
			}
		}
	} else {
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp63_ = y;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp64_ = self->priv->y_gap;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp63_ < _tmp64_) {
#line 1313 "taquin-game.c"
			{
				gboolean _tmp65_ = FALSE;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp65_ = TRUE;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1320 "taquin-game.c"
					gint* _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					gint _tmp68__length2 = 0;
					gint* _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					gint _tmp69__length2 = 0;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					gint* _tmp72_ = NULL;
					gint _tmp72__length1 = 0;
					gint _tmp72__length2 = 0;
					gint* _tmp73_ = NULL;
					gint _tmp73__length1 = 0;
					gint _tmp73__length2 = 0;
					gint _tmp74_ = 0;
					gint _tmp75_ = 0;
					gint _tmp76_ = 0;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp65_) {
#line 1342 "taquin-game.c"
						gint _tmp66_ = 0;
						gint _tmp67_ = 0;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp66_ = self->priv->y_gap;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp67_ = y;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp66_ != _tmp67_)) {
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1353 "taquin-game.c"
						}
					}
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp65_ = FALSE;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp68_ = game_get_tiles (self, &_tmp68__length1, &_tmp68__length2);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69_ = _tmp68_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69__length1 = _tmp68__length1;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69__length2 = _tmp68__length2;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp70_ = x;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp71_ = self->priv->y_gap;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp72_ = game_get_tiles (self, &_tmp72__length1, &_tmp72__length2);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp73_ = _tmp72_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp73__length1 = _tmp72__length1;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp73__length2 = _tmp72__length2;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp74_ = x;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp75_ = self->priv->y_gap;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp76_ = _tmp73_[(_tmp74_ * _tmp73__length2) + (_tmp75_ - 1)];
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_] = _tmp76_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp77_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp78_ = self->priv->y_gap;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->y_gap = _tmp78_ - 1;
#line 1392 "taquin-game.c"
				}
			}
		} else {
			{
				gboolean _tmp79_ = FALSE;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp79_ = TRUE;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				while (TRUE) {
#line 1402 "taquin-game.c"
					gint* _tmp82_ = NULL;
					gint _tmp82__length1 = 0;
					gint _tmp82__length2 = 0;
					gint* _tmp83_ = NULL;
					gint _tmp83__length1 = 0;
					gint _tmp83__length2 = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					gint* _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					gint _tmp86__length2 = 0;
					gint* _tmp87_ = NULL;
					gint _tmp87__length1 = 0;
					gint _tmp87__length2 = 0;
					gint _tmp88_ = 0;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					if (!_tmp79_) {
#line 1424 "taquin-game.c"
						gint _tmp80_ = 0;
						gint _tmp81_ = 0;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp80_ = self->priv->y_gap;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp81_ = y;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp80_ != _tmp81_)) {
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1435 "taquin-game.c"
						}
					}
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp79_ = FALSE;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp82_ = game_get_tiles (self, &_tmp82__length1, &_tmp82__length2);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83_ = _tmp82_;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83__length1 = _tmp82__length1;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83__length2 = _tmp82__length2;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp84_ = x;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp85_ = self->priv->y_gap;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp86_ = game_get_tiles (self, &_tmp86__length1, &_tmp86__length2);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp87_ = _tmp86_;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp87__length1 = _tmp86__length1;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp87__length2 = _tmp86__length2;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp88_ = x;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp89_ = self->priv->y_gap;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp90_ = _tmp87_[(_tmp88_ * _tmp87__length2) + (_tmp89_ + 1)];
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_] = _tmp90_;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp91_ = _tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_];
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp92_ = self->priv->y_gap;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					self->priv->y_gap = _tmp92_ + 1;
#line 1474 "taquin-game.c"
				}
			}
		}
	}
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp93_ = game_get_tiles (self, &_tmp93__length1, &_tmp93__length2);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94_ = _tmp93_;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94__length1 = _tmp93__length1;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94__length2 = _tmp93__length2;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp95_ = self->priv->x_gap;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp96_ = self->priv->y_gap;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp94_[(_tmp95_ * _tmp94__length2) + _tmp96_] = -1;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp97_ = _tmp94_[(_tmp95_ * _tmp94__length2) + _tmp96_];
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp98_ = move_x_axis;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp99_ = move_number;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp100_ = self->priv->x_gap;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp101_ = self->priv->y_gap;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_emit_by_name (self, "move", _tmp98_, _tmp99_, _tmp100_, _tmp101_);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_check_complete (self);
#line 1507 "taquin-game.c"
}


static void game_sixteen_move (Game* self, gint x, gint y, gboolean undoing) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean move_x_axis = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint new_coord = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp122_ = FALSE;
	gint _tmp135_ = 0;
	gint _tmp136_ = 0;
	gint _tmp139_ = 0;
	gboolean _tmp140_ = FALSE;
	gint _tmp143_ = 0;
	gboolean _tmp144_ = FALSE;
	gboolean _tmp147_ = FALSE;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = x;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp3_ >= 0) {
#line 1535 "taquin-game.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = x;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp5_ = self->priv->_size;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = _tmp4_ < _tmp5_;
#line 1544 "taquin-game.c"
	} else {
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = FALSE;
#line 1548 "taquin-game.c"
	}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp2_) {
#line 1552 "taquin-game.c"
		gint _tmp6_ = 0;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp6_ = y;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = _tmp6_ >= 0;
#line 1558 "taquin-game.c"
	} else {
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp1_ = FALSE;
#line 1562 "taquin-game.c"
	}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_) {
#line 1566 "taquin-game.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp7_ = y;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp8_ = self->priv->_size;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = _tmp7_ < _tmp8_;
#line 1575 "taquin-game.c"
	} else {
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = FALSE;
#line 1579 "taquin-game.c"
	}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_) {
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 1585 "taquin-game.c"
	}
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	move_x_axis = FALSE;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = x;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp10_ < 0) {
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = TRUE;
#line 1595 "taquin-game.c"
	} else {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp11_ = x;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = self->priv->_size;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = _tmp11_ >= _tmp12_;
#line 1605 "taquin-game.c"
	}
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp9_) {
#line 1609 "taquin-game.c"
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = y;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp14_ < 0) {
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp13_ = TRUE;
#line 1618 "taquin-game.c"
		} else {
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp15_ = y;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp16_ = self->priv->_size;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp13_ = _tmp15_ >= _tmp16_;
#line 1628 "taquin-game.c"
		}
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp13_) {
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			return;
#line 1634 "taquin-game.c"
		} else {
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			move_x_axis = TRUE;
#line 1638 "taquin-game.c"
		}
	} else {
		gboolean _tmp17_ = FALSE;
		gint _tmp18_ = 0;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp18_ = y;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp18_ >= 0) {
#line 1647 "taquin-game.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp19_ = y;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp20_ = self->priv->_size;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp17_ = _tmp19_ < _tmp20_;
#line 1656 "taquin-game.c"
		} else {
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp17_ = FALSE;
#line 1660 "taquin-game.c"
		}
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp17_) {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			return;
#line 1666 "taquin-game.c"
		}
	}
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	new_coord = 0;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp21_ = move_x_axis;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp21_) {
#line 1675 "taquin-game.c"
		gint _tmp22_ = 0;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp22_ = x;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp22_ < 0) {
#line 1681 "taquin-game.c"
			gint tmp = 0;
			gint* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			gint _tmp23__length2 = 0;
			gint* _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			gint _tmp24__length2 = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint* _tmp41_ = NULL;
			gint _tmp41__length1 = 0;
			gint _tmp41__length2 = 0;
			gint* _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
			gint _tmp42__length2 = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp23_ = game_get_tiles (self, &_tmp23__length1, &_tmp23__length2);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp24_ = _tmp23_;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp24__length1 = _tmp23__length1;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp24__length2 = _tmp23__length2;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp25_ = y;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp26_ = _tmp24_[(0 * _tmp24__length2) + _tmp25_];
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp26_;
#line 1716 "taquin-game.c"
			{
				gint i = 0;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = 0;
#line 1721 "taquin-game.c"
				{
					gboolean _tmp27_ = FALSE;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp27_ = TRUE;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 1728 "taquin-game.c"
						gint _tmp29_ = 0;
						gint _tmp30_ = 0;
						gint* _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						gint _tmp31__length2 = 0;
						gint* _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						gint _tmp32__length2 = 0;
						gint _tmp33_ = 0;
						gint _tmp34_ = 0;
						gint* _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gint _tmp35__length2 = 0;
						gint* _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gint _tmp36__length2 = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp27_) {
#line 1751 "taquin-game.c"
							gint _tmp28_ = 0;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp28_ = i;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp28_ + 1;
#line 1757 "taquin-game.c"
						}
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp27_ = FALSE;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp29_ = i;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp30_ = self->priv->_size;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp29_ < (_tmp30_ - 1))) {
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1769 "taquin-game.c"
						}
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp31_ = game_get_tiles (self, &_tmp31__length1, &_tmp31__length2);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32_ = _tmp31_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32__length1 = _tmp31__length1;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32__length2 = _tmp31__length2;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp33_ = i;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp34_ = y;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp35_ = game_get_tiles (self, &_tmp35__length1, &_tmp35__length2);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36_ = _tmp35_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36__length1 = _tmp35__length1;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp36__length2 = _tmp35__length2;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp37_ = i;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp38_ = y;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp39_ = _tmp36_[((_tmp37_ + 1) * _tmp36__length2) + _tmp38_];
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_] = _tmp39_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp40_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
#line 1801 "taquin-game.c"
					}
				}
			}
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp41_ = game_get_tiles (self, &_tmp41__length1, &_tmp41__length2);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42_ = _tmp41_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42__length1 = _tmp41__length1;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42__length2 = _tmp41__length2;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp43_ = self->priv->_size;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp44_ = y;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp45_ = tmp;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp42_[((_tmp43_ - 1) * _tmp42__length2) + _tmp44_] = _tmp45_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp46_ = _tmp42_[((_tmp43_ - 1) * _tmp42__length2) + _tmp44_];
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp47_ = self->priv->_size;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = _tmp47_ - 1;
#line 1827 "taquin-game.c"
		} else {
			gint tmp = 0;
			gint* _tmp48_ = NULL;
			gint _tmp48__length1 = 0;
			gint _tmp48__length2 = 0;
			gint* _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			gint _tmp49__length2 = 0;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			gint* _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gint _tmp67__length2 = 0;
			gint* _tmp68_ = NULL;
			gint _tmp68__length1 = 0;
			gint _tmp68__length2 = 0;
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp48_ = game_get_tiles (self, &_tmp48__length1, &_tmp48__length2);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp49_ = _tmp48_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp49__length1 = _tmp48__length1;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp49__length2 = _tmp48__length2;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp50_ = self->priv->_size;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp51_ = y;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp52_ = _tmp49_[((_tmp50_ - 1) * _tmp49__length2) + _tmp51_];
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp52_;
#line 1864 "taquin-game.c"
			{
				gint i = 0;
				gint _tmp53_ = 0;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp53_ = self->priv->_size;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = _tmp53_ - 1;
#line 1872 "taquin-game.c"
				{
					gboolean _tmp54_ = FALSE;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp54_ = TRUE;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 1879 "taquin-game.c"
						gint _tmp56_ = 0;
						gint* _tmp57_ = NULL;
						gint _tmp57__length1 = 0;
						gint _tmp57__length2 = 0;
						gint* _tmp58_ = NULL;
						gint _tmp58__length1 = 0;
						gint _tmp58__length2 = 0;
						gint _tmp59_ = 0;
						gint _tmp60_ = 0;
						gint* _tmp61_ = NULL;
						gint _tmp61__length1 = 0;
						gint _tmp61__length2 = 0;
						gint* _tmp62_ = NULL;
						gint _tmp62__length1 = 0;
						gint _tmp62__length2 = 0;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp54_) {
#line 1901 "taquin-game.c"
							gint _tmp55_ = 0;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp55_ = i;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp55_ - 1;
#line 1907 "taquin-game.c"
						}
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp54_ = FALSE;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp56_ = i;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp56_ > 0)) {
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 1917 "taquin-game.c"
						}
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp57_ = game_get_tiles (self, &_tmp57__length1, &_tmp57__length2);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58_ = _tmp57_;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58__length1 = _tmp57__length1;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58__length2 = _tmp57__length2;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp59_ = i;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp60_ = y;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp61_ = game_get_tiles (self, &_tmp61__length1, &_tmp61__length2);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp62_ = _tmp61_;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp62__length1 = _tmp61__length1;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp62__length2 = _tmp61__length2;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp63_ = i;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp64_ = y;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp65_ = _tmp62_[((_tmp63_ - 1) * _tmp62__length2) + _tmp64_];
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_] = _tmp65_;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp66_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
#line 1949 "taquin-game.c"
					}
				}
			}
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp67_ = game_get_tiles (self, &_tmp67__length1, &_tmp67__length2);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68_ = _tmp67_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68__length1 = _tmp67__length1;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68__length2 = _tmp67__length2;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp69_ = y;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp70_ = tmp;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp68_[(0 * _tmp68__length2) + _tmp69_] = _tmp70_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp71_ = _tmp68_[(0 * _tmp68__length2) + _tmp69_];
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = 0;
#line 1971 "taquin-game.c"
		}
	} else {
		gint _tmp72_ = 0;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp72_ = y;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp72_ < 0) {
#line 1979 "taquin-game.c"
			gint tmp = 0;
			gint* _tmp73_ = NULL;
			gint _tmp73__length1 = 0;
			gint _tmp73__length2 = 0;
			gint* _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			gint _tmp74__length2 = 0;
			gint _tmp75_ = 0;
			gint _tmp76_ = 0;
			gint* _tmp91_ = NULL;
			gint _tmp91__length1 = 0;
			gint _tmp91__length2 = 0;
			gint* _tmp92_ = NULL;
			gint _tmp92__length1 = 0;
			gint _tmp92__length2 = 0;
			gint _tmp93_ = 0;
			gint _tmp94_ = 0;
			gint _tmp95_ = 0;
			gint _tmp96_ = 0;
			gint _tmp97_ = 0;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp73_ = game_get_tiles (self, &_tmp73__length1, &_tmp73__length2);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp74_ = _tmp73_;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp74__length1 = _tmp73__length1;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp74__length2 = _tmp73__length2;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp75_ = x;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp76_ = _tmp74_[(_tmp75_ * _tmp74__length2) + 0];
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp76_;
#line 2014 "taquin-game.c"
			{
				gint i = 0;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = 0;
#line 2019 "taquin-game.c"
				{
					gboolean _tmp77_ = FALSE;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp77_ = TRUE;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 2026 "taquin-game.c"
						gint _tmp79_ = 0;
						gint _tmp80_ = 0;
						gint* _tmp81_ = NULL;
						gint _tmp81__length1 = 0;
						gint _tmp81__length2 = 0;
						gint* _tmp82_ = NULL;
						gint _tmp82__length1 = 0;
						gint _tmp82__length2 = 0;
						gint _tmp83_ = 0;
						gint _tmp84_ = 0;
						gint* _tmp85_ = NULL;
						gint _tmp85__length1 = 0;
						gint _tmp85__length2 = 0;
						gint* _tmp86_ = NULL;
						gint _tmp86__length1 = 0;
						gint _tmp86__length2 = 0;
						gint _tmp87_ = 0;
						gint _tmp88_ = 0;
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp77_) {
#line 2049 "taquin-game.c"
							gint _tmp78_ = 0;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp78_ = i;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp78_ + 1;
#line 2055 "taquin-game.c"
						}
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp77_ = FALSE;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp79_ = i;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp80_ = self->priv->_size;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp79_ < (_tmp80_ - 1))) {
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 2067 "taquin-game.c"
						}
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp81_ = game_get_tiles (self, &_tmp81__length1, &_tmp81__length2);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82_ = _tmp81_;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82__length1 = _tmp81__length1;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82__length2 = _tmp81__length2;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp83_ = x;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp84_ = i;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp85_ = game_get_tiles (self, &_tmp85__length1, &_tmp85__length2);
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp86_ = _tmp85_;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp86__length1 = _tmp85__length1;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp86__length2 = _tmp85__length2;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp87_ = x;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp88_ = i;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp89_ = _tmp86_[(_tmp87_ * _tmp86__length2) + (_tmp88_ + 1)];
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp82_[(_tmp83_ * _tmp82__length2) + _tmp84_] = _tmp89_;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp90_ = _tmp82_[(_tmp83_ * _tmp82__length2) + _tmp84_];
#line 2099 "taquin-game.c"
					}
				}
			}
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp91_ = game_get_tiles (self, &_tmp91__length1, &_tmp91__length2);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92_ = _tmp91_;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92__length1 = _tmp91__length1;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92__length2 = _tmp91__length2;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp93_ = x;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp94_ = self->priv->_size;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp95_ = tmp;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp92_[(_tmp93_ * _tmp92__length2) + (_tmp94_ - 1)] = _tmp95_;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp96_ = _tmp92_[(_tmp93_ * _tmp92__length2) + (_tmp94_ - 1)];
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp97_ = self->priv->_size;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = _tmp97_ - 1;
#line 2125 "taquin-game.c"
		} else {
			gint tmp = 0;
			gint* _tmp98_ = NULL;
			gint _tmp98__length1 = 0;
			gint _tmp98__length2 = 0;
			gint* _tmp99_ = NULL;
			gint _tmp99__length1 = 0;
			gint _tmp99__length2 = 0;
			gint _tmp100_ = 0;
			gint _tmp101_ = 0;
			gint _tmp102_ = 0;
			gint* _tmp117_ = NULL;
			gint _tmp117__length1 = 0;
			gint _tmp117__length2 = 0;
			gint* _tmp118_ = NULL;
			gint _tmp118__length1 = 0;
			gint _tmp118__length2 = 0;
			gint _tmp119_ = 0;
			gint _tmp120_ = 0;
			gint _tmp121_ = 0;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp98_ = game_get_tiles (self, &_tmp98__length1, &_tmp98__length2);
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp99_ = _tmp98_;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp99__length1 = _tmp98__length1;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp99__length2 = _tmp98__length2;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp100_ = x;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp101_ = self->priv->_size;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp102_ = _tmp99_[(_tmp100_ * _tmp99__length2) + (_tmp101_ - 1)];
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			tmp = _tmp102_;
#line 2162 "taquin-game.c"
			{
				gint i = 0;
				gint _tmp103_ = 0;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp103_ = self->priv->_size;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				i = _tmp103_ - 1;
#line 2170 "taquin-game.c"
				{
					gboolean _tmp104_ = FALSE;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp104_ = TRUE;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					while (TRUE) {
#line 2177 "taquin-game.c"
						gint _tmp106_ = 0;
						gint* _tmp107_ = NULL;
						gint _tmp107__length1 = 0;
						gint _tmp107__length2 = 0;
						gint* _tmp108_ = NULL;
						gint _tmp108__length1 = 0;
						gint _tmp108__length2 = 0;
						gint _tmp109_ = 0;
						gint _tmp110_ = 0;
						gint* _tmp111_ = NULL;
						gint _tmp111__length1 = 0;
						gint _tmp111__length2 = 0;
						gint* _tmp112_ = NULL;
						gint _tmp112__length1 = 0;
						gint _tmp112__length2 = 0;
						gint _tmp113_ = 0;
						gint _tmp114_ = 0;
						gint _tmp115_ = 0;
						gint _tmp116_ = 0;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!_tmp104_) {
#line 2199 "taquin-game.c"
							gint _tmp105_ = 0;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							_tmp105_ = i;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							i = _tmp105_ - 1;
#line 2205 "taquin-game.c"
						}
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp104_ = FALSE;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp106_ = i;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						if (!(_tmp106_ > 0)) {
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
							break;
#line 2215 "taquin-game.c"
						}
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp107_ = game_get_tiles (self, &_tmp107__length1, &_tmp107__length2);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108_ = _tmp107_;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108__length1 = _tmp107__length1;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108__length2 = _tmp107__length2;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp109_ = x;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp110_ = i;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp111_ = game_get_tiles (self, &_tmp111__length1, &_tmp111__length2);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp112_ = _tmp111_;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp112__length1 = _tmp111__length1;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp112__length2 = _tmp111__length2;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp113_ = x;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp114_ = i;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp115_ = _tmp112_[(_tmp113_ * _tmp112__length2) + (_tmp114_ - 1)];
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_] = _tmp115_;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
						_tmp116_ = _tmp108_[(_tmp109_ * _tmp108__length2) + _tmp110_];
#line 2247 "taquin-game.c"
					}
				}
			}
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp117_ = game_get_tiles (self, &_tmp117__length1, &_tmp117__length2);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118_ = _tmp117_;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118__length1 = _tmp117__length1;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118__length2 = _tmp117__length2;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp119_ = x;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp120_ = tmp;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp118_[(_tmp119_ * _tmp118__length2) + 0] = _tmp120_;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp121_ = _tmp118_[(_tmp119_ * _tmp118__length2) + 0];
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			new_coord = 0;
#line 2269 "taquin-game.c"
		}
	}
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp122_ = undoing;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (!_tmp122_) {
#line 2276 "taquin-game.c"
		gint _tmp123_ = 0;
		gboolean _tmp124_ = FALSE;
		gint _tmp129_ = 0;
		gboolean _tmp130_ = FALSE;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp124_ = move_x_axis;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp124_) {
#line 2285 "taquin-game.c"
			gint _tmp125_ = 0;
			gint _tmp126_ = 0;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp126_ = new_coord;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			if (_tmp126_ == 0) {
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp125_ = -1;
#line 2294 "taquin-game.c"
			} else {
				gint _tmp127_ = 0;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp127_ = self->priv->_size;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp125_ = _tmp127_;
#line 2301 "taquin-game.c"
			}
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp123_ = _tmp125_;
#line 2305 "taquin-game.c"
		} else {
			gint _tmp128_ = 0;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp128_ = x;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp123_ = _tmp128_;
#line 2312 "taquin-game.c"
		}
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp130_ = move_x_axis;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		if (_tmp130_) {
#line 2318 "taquin-game.c"
			gint _tmp131_ = 0;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp131_ = y;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp129_ = _tmp131_;
#line 2324 "taquin-game.c"
		} else {
			gint _tmp132_ = 0;
			gint _tmp133_ = 0;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp133_ = new_coord;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			if (_tmp133_ == 0) {
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp132_ = -1;
#line 2334 "taquin-game.c"
			} else {
				gint _tmp134_ = 0;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp134_ = self->priv->_size;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp132_ = _tmp134_;
#line 2341 "taquin-game.c"
			}
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp129_ = _tmp132_;
#line 2345 "taquin-game.c"
		}
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_add_move (self, _tmp123_, _tmp129_);
#line 2349 "taquin-game.c"
	}
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp136_ = new_coord;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp136_ == 0) {
#line 2355 "taquin-game.c"
		gint _tmp137_ = 0;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp137_ = self->priv->_size;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp135_ = _tmp137_ - 1;
#line 2361 "taquin-game.c"
	} else {
		gint _tmp138_ = 0;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp138_ = self->priv->_size;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp135_ = 1 - _tmp138_;
#line 2368 "taquin-game.c"
	}
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp140_ = move_x_axis;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp140_) {
#line 2374 "taquin-game.c"
		gint _tmp141_ = 0;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp141_ = new_coord;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp139_ = _tmp141_;
#line 2380 "taquin-game.c"
	} else {
		gint _tmp142_ = 0;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp142_ = x;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp139_ = _tmp142_;
#line 2387 "taquin-game.c"
	}
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp144_ = move_x_axis;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp144_) {
#line 2393 "taquin-game.c"
		gint _tmp145_ = 0;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp145_ = y;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp143_ = _tmp145_;
#line 2399 "taquin-game.c"
	} else {
		gint _tmp146_ = 0;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp146_ = new_coord;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp143_ = _tmp146_;
#line 2406 "taquin-game.c"
	}
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp147_ = move_x_axis;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_emit_by_name (self, "move", _tmp147_, _tmp135_, _tmp139_, _tmp143_);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_check_complete (self);
#line 2414 "taquin-game.c"
}


static void game_check_complete (Game* self) {
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 2421 "taquin-game.c"
	{
		gint i = 0;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		i = 1;
#line 2426 "taquin-game.c"
		{
			gboolean _tmp0_ = FALSE;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			_tmp0_ = TRUE;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
			while (TRUE) {
#line 2433 "taquin-game.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp7__length2 = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!_tmp0_) {
#line 2451 "taquin-game.c"
					gint _tmp1_ = 0;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					_tmp1_ = i;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					i = _tmp1_ + 1;
#line 2457 "taquin-game.c"
				}
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp0_ = FALSE;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp2_ = i;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp3_ = self->priv->_size;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp4_ = self->priv->_size;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (!(_tmp2_ < (_tmp3_ * _tmp4_))) {
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					break;
#line 2471 "taquin-game.c"
				}
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp5_ = i;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp6_ = game_get_tiles (self, &_tmp6__length1, &_tmp6__length2);
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp7_ = _tmp6_;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp7__length1 = _tmp6__length1;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp7__length2 = _tmp6__length2;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp8_ = i;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp9_ = self->priv->_size;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp10_ = i;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp11_ = self->priv->_size;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				_tmp12_ = _tmp7_[((_tmp8_ % _tmp9_) * _tmp7__length2) + (_tmp10_ / _tmp11_)];
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
				if (_tmp5_ != _tmp12_) {
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
					return;
#line 2497 "taquin-game.c"
				}
			}
		}
	}
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_emit_by_name (self, "complete");
#line 2504 "taquin-game.c"
}


static gpointer _game_undo_item_dup0 (gpointer self) {
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return self ? game_undo_item_dup (self) : NULL;
#line 2511 "taquin-game.c"
}


void game_undo (Game* self) {
	GameUndoItem* _tmp0_ = NULL;
	GameType _tmp1_ = 0;
	GameUndoItem* _tmp10_ = NULL;
	GameUndoItem* _tmp11_ = NULL;
	GameUndoItem* _tmp12_ = NULL;
	GameUndoItem* _tmp13_ = NULL;
	GameUndoItem* _tmp16_ = NULL;
	GameUndoItem* _tmp17_ = NULL;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->state;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp0_ == NULL) {
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		return;
#line 2532 "taquin-game.c"
	}
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = self->priv->_game_type;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_ == GAME_TYPE_FIFTEEN) {
#line 2538 "taquin-game.c"
		GameUndoItem* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GameUndoItem* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = self->priv->state;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp3_ = (*_tmp2_).x;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp4_ = self->priv->state;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp5_ = (*_tmp4_).y;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_fifteen_move (self, _tmp3_, _tmp5_, TRUE);
#line 2553 "taquin-game.c"
	} else {
		GameUndoItem* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		GameUndoItem* _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp6_ = self->priv->state;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp7_ = (*_tmp6_).x;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp8_ = self->priv->state;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp9_ = (*_tmp8_).y;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_sixteen_move (self, _tmp7_, _tmp9_, TRUE);
#line 2569 "taquin-game.c"
	}
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = self->priv->previous_state;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp11_ = _game_undo_item_dup0 (_tmp10_);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->state);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->state = _tmp11_;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp13_ = self->priv->state;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp13_ == NULL) {
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = NULL;
#line 2585 "taquin-game.c"
	} else {
		GameUndoItem* _tmp14_ = NULL;
		GameUndoItem* _tmp15_ = NULL;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = self->priv->state;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp15_ = (*_tmp14_).previous;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = _tmp15_;
#line 2595 "taquin-game.c"
	}
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp16_ = _game_undo_item_dup0 (_tmp12_);
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->previous_state);
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->previous_state = _tmp16_;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp17_ = self->priv->state;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp17_ == NULL) {
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_signal_emit_by_name (self, "cannot-undo-more");
#line 2609 "taquin-game.c"
	}
}


static void game_add_move (Game* self, gint x_gap, gint y_gap) {
	GameUndoItem* _tmp0_ = NULL;
	GameUndoItem* _tmp1_ = NULL;
	GameUndoItem* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GameUndoItem* _tmp6_ = NULL;
	GameUndoItem* _tmp7_ = NULL;
	GameUndoItem _tmp8_ = {0};
	GameUndoItem _tmp9_ = {0};
	GameUndoItem* _tmp10_ = NULL;
	GameUndoItem* _tmp11_ = NULL;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = self->priv->state;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp1_ == NULL) {
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = NULL;
#line 2634 "taquin-game.c"
	} else {
		GameUndoItem* _tmp2_ = NULL;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp2_ = self->priv->state;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp0_ = _tmp2_;
#line 2641 "taquin-game.c"
	}
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = _game_undo_item_dup0 (_tmp0_);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->previous_state);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->previous_state = _tmp3_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp4_ = x_gap;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp5_ = y_gap;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp6_ = self->priv->previous_state;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp7_ = _game_undo_item_dup0 (_tmp6_);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	memset (&_tmp8_, 0, sizeof (GameUndoItem));
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.x = _tmp4_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.y = _tmp5_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (_tmp8_.next);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.next = NULL;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (_tmp8_.previous);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp8_.previous = _tmp7_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp9_ = _tmp8_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp10_ = _game_undo_item_dup0 (&_tmp9_);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->state);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->state = _tmp10_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_undo_item_destroy (&_tmp9_);
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp11_ = self->priv->previous_state;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (_tmp11_ != NULL) {
#line 2685 "taquin-game.c"
		GameUndoItem* _tmp12_ = NULL;
		GameUndoItem* _tmp13_ = NULL;
		GameUndoItem* _tmp14_ = NULL;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp12_ = self->priv->previous_state;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp13_ = self->priv->state;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_tmp14_ = _game_undo_item_dup0 (_tmp13_);
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		_game_undo_item_free0 ((*_tmp12_).next);
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		(*_tmp12_).next = _tmp14_;
#line 2699 "taquin-game.c"
	}
}


gint* game_get_tiles (Game* self, int* result_length1, int* result_length2) {
	gint* result;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_tiles;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length1 = self->priv->_tiles_length1;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length2 = self->priv->_tiles_length2;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = _tmp0_;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length1 = _tmp0__length1;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length2 = _tmp0__length2;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (result_length1) {
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		*result_length1 = _tmp1__length1;
#line 2730 "taquin-game.c"
	}
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (result_length2) {
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		*result_length2 = _tmp1__length2;
#line 2736 "taquin-game.c"
	}
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = _tmp1_;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 2742 "taquin-game.c"
}


static gint* _vala_array_dup1 (gint* self, int length) {
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return g_memdup (self, length * sizeof (gint));
#line 2749 "taquin-game.c"
}


static void game_set_tiles (Game* self, gint* value, int value_length1, int value_length2) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = value;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length1 = value_length1;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0__length2 = value_length2;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length1 = _tmp0__length1;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1__length2 = _tmp0__length2;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles = _tmp1_;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles_length1 = _tmp1__length1;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles_length2 = _tmp1__length2;
#line 2782 "taquin-game.c"
}


gint game_get_size (Game* self) {
	gint result;
	gint _tmp0_ = 0;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_size;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = _tmp0_;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 2797 "taquin-game.c"
}


static void game_set_size (Game* self, gint value) {
	gint _tmp0_ = 0;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = value;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_size = _tmp0_;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_notify ((GObject *) self, "size");
#line 2811 "taquin-game.c"
}


GameType game_get_game_type (Game* self) {
	GameType result;
	GameType _tmp0_ = 0;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = self->priv->_game_type;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	result = _tmp0_;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return result;
#line 2826 "taquin-game.c"
}


static void game_set_game_type (Game* self, GameType value) {
	GameType _tmp0_ = 0;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (self != NULL);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = value;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_game_type = _tmp0_;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_notify ((GObject *) self, "game-type");
#line 2840 "taquin-game.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (gpointer data1, gboolean arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (n_param_values == 5);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = closure->data;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 2859 "taquin-game.c"
	} else {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = closure->data;
#line 2865 "taquin-game.c"
	}
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
#line 2871 "taquin-game.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_return_if_fail (n_param_values == 3);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = closure->data;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 2890 "taquin-game.c"
	} else {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		data2 = closure->data;
#line 2896 "taquin-game.c"
	}
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 2902 "taquin-game.c"
}


static void game_undo_item_copy (const GameUndoItem* self, GameUndoItem* dest) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GameUndoItem* _tmp2_ = NULL;
	GameUndoItem* _tmp3_ = NULL;
	GameUndoItem* _tmp4_ = NULL;
	GameUndoItem* _tmp5_ = NULL;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp0_ = (*self).x;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).x = _tmp0_;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp1_ = (*self).y;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).y = _tmp1_;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp2_ = (*self).next;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp3_ = _game_undo_item_dup0 (_tmp2_);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*dest).next);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).next = _tmp3_;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp4_ = (*self).previous;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_tmp5_ = _game_undo_item_dup0 (_tmp4_);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*dest).previous);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	(*dest).previous = _tmp5_;
#line 2937 "taquin-game.c"
}


static void game_undo_item_destroy (GameUndoItem* self) {
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*self).next);
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 ((*self).previous);
#line 2946 "taquin-game.c"
}


static GameUndoItem* game_undo_item_dup (const GameUndoItem* self) {
	GameUndoItem* dup;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	dup = g_new0 (GameUndoItem, 1);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_undo_item_copy (self, dup);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	return dup;
#line 2958 "taquin-game.c"
}


static void game_undo_item_free (GameUndoItem* self) {
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_undo_item_destroy (self);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_free (self);
#line 2967 "taquin-game.c"
}


static GType game_undo_item_get_type (void) {
	static volatile gsize game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&game_undo_item_type_id__volatile)) {
		GType game_undo_item_type_id;
		game_undo_item_type_id = g_boxed_type_register_static ("GameUndoItem", (GBoxedCopyFunc) game_undo_item_dup, (GBoxedFreeFunc) game_undo_item_free);
		g_once_init_leave (&game_undo_item_type_id__volatile, game_undo_item_type_id);
	}
	return game_undo_item_type_id__volatile;
}


static void game_class_init (GameClass * klass) {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	game_parent_class = g_type_class_peek_parent (klass);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_type_class_add_private (klass, sizeof (GamePrivate));
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GAME_TYPE, g_param_spec_enum ("game-type", "game-type", "game-type", TYPE_GAME_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("empty_tile", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("cannot_move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	g_signal_new ("cannot_undo_more", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3007 "taquin-game.c"
}


static void game_instance_init (Game * self) {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv = GAME_GET_PRIVATE (self);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->state = NULL;
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->previous_state = NULL;
#line 52 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->x_gap = 0;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->y_gap = 0;
#line 3022 "taquin-game.c"
}


static void game_finalize (GObject* obj) {
	Game * self;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->state);
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	_game_undo_item_free0 (self->priv->previous_state);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
#line 3038 "taquin-game.c"
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	switch (property_id) {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_SIZE:
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_value_set_int (value, game_get_size (self));
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_GAME_TYPE:
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		g_value_set_enum (value, game_get_game_type (self));
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3071 "taquin-game.c"
		default:
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3077 "taquin-game.c"
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
	switch (property_id) {
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_SIZE:
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_set_size (self, g_value_get_int (value));
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		case GAME_GAME_TYPE:
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		game_set_game_type (self, g_value_get_enum (value));
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3099 "taquin-game.c"
		default:
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-taquin/src/taquin-game.vala"
		break;
#line 3105 "taquin-game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



