/* sudoku-view.c generated by valac 0.27.1.15-b1df0, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gee.h>
#include <pango/pangocairo.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean _show_possibilities;
	gboolean _show_warnings;
	gboolean _selected;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _Block5Data {
	int _ref_count_;
	SudokuCellView* self;
	gint row;
	gint col;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
	gboolean _highlighter;
};

struct _Block6Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
enum  {
	SUDOKU_CELL_VIEW_DUMMY_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE,
	SUDOKU_CELL_VIEW_IS_FIXED,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS,
	SUDOKU_CELL_VIEW_SELECTED,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR
};
SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game);
SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void sudoku_cell_view_set_value (SudokuCellView* self, gint value);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark);
static void __lambda7_ (Block5Data* _data5_, NumberPicker* o, gint number);
static void ___lambda7__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self);
static gboolean __lambda8_ (SudokuCellView* self);
static gboolean ___lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda9_ (Block5Data* _data5_, gint number, gboolean state);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda9__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
static gboolean __lambda10_ (SudokuCellView* self);
static gboolean ___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c);
void sudoku_cell_view_clear (SudokuCellView* self);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result);
void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value);
static void sudoku_cell_view_finalize (GObject* obj);
static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
enum  {
	SUDOKU_VIEW_DUMMY_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS,
	SUDOKU_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_VIEW_HIGHLIGHTER
};
static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ________lambda11_ (Block7Data* _data7_);
static gboolean _________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void ________lambda12_ (Block7Data* _data7_, GObject* s, GParamSpec* p);
static void _________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sudoku_view_clear (SudokuView* self);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
gboolean sudoku_view_get_highlighter (SudokuView* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void sudoku_view_finalize (GObject* obj);
static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GdkRGBA SUDOKU_VIEW_fixed_cell_color = {0.8, 0.8, 0.8, (gdouble) 0};
static const GdkRGBA SUDOKU_VIEW_free_cell_color = {1.0, 1.0, 1.0, 1.0};
static const GdkRGBA SUDOKU_VIEW_highlight_color = {0.93, 0.93, 0.93, (gdouble) 0};
static const GdkRGBA SUDOKU_VIEW_selected_bg_color = {0.7, 0.8, 0.9};

static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data5_;
#line 251 "sudoku-view.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 260 "sudoku-view.c"
		SudokuCellView* self;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data5_->self;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block5Data, _data5_);
#line 268 "sudoku-view.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 276 "sudoku-view.c"
}


static void __lambda7_ (Block5Data* _data5_, NumberPicker* o, gint number) {
	SudokuCellView* self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuGame* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkPopover* _tmp6_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (o != NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = number;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp0_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = number;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == 0) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 303 "sudoku-view.c"
	}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->game;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp2_->board;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _data5_->row;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _data5_->col;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_board_disable_all_earmarks (_tmp3_, _tmp4_, _tmp5_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->popover;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 319 "sudoku-view.c"
}


static void ___lambda7__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda7_ (self, _sender, number);
#line 326 "sudoku-view.c"
}


static gboolean __lambda8_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 341 "sudoku-view.c"
}


static gboolean ___lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda8_ ((SudokuCellView*) self);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 350 "sudoku-view.c"
}


static void __lambda9_ (Block5Data* _data5_, gint number, gboolean state) {
	SudokuCellView* self;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = state;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 370 "sudoku-view.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->game;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp1_->board;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _data5_->row;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _data5_->col;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = number;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_enable_earmark (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 388 "sudoku-view.c"
	} else {
		SudokuGame* _tmp6_ = NULL;
		SudokuBoard* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = self->priv->game;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->board;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _data5_->row;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = _data5_->col;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = number;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_disable_earmark (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 407 "sudoku-view.c"
	}
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->game;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _data5_->row;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _data5_->col;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_value (self);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = sudoku_cell_view_get_value (self);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_emit_by_name (_tmp11_, "cell-changed", _tmp12_, _tmp13_, _tmp15_, _tmp17_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 427 "sudoku-view.c"
}


static void ___lambda9__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self) {
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda9_ (self, number, active);
#line 434 "sudoku-view.c"
}


static gboolean __lambda10_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 449 "sudoku-view.c"
}


static gboolean ___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda10_ ((SudokuCellView*) self);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 458 "sudoku-view.c"
}


static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 467 "sudoku-view.c"
}


static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
#line 474 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game) {
	SudokuCellView * self = NULL;
	Block5Data* _data5_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuGame* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkStyle* _tmp6_ = NULL;
	GtkStyle* _tmp7_ = NULL;
	PangoFontDescription* _tmp8_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuBoard* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	SudokuGame* _tmp16_ = NULL;
	NumberPicker* _tmp17_ = NULL;
	NumberPicker* _tmp18_ = NULL;
	GtkPopover* _tmp19_ = NULL;
	GtkPopover* _tmp20_ = NULL;
	NumberPicker* _tmp21_ = NULL;
	GtkPopover* _tmp22_ = NULL;
	GtkPopover* _tmp23_ = NULL;
	GtkPopover* _tmp24_ = NULL;
	SudokuGame* _tmp25_ = NULL;
	NumberPicker* _tmp26_ = NULL;
	NumberPicker* _tmp27_ = NULL;
	NumberPicker* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GtkPopover* _tmp31_ = NULL;
	GtkPopover* _tmp32_ = NULL;
	NumberPicker* _tmp33_ = NULL;
	GtkPopover* _tmp34_ = NULL;
	GtkPopover* _tmp35_ = NULL;
	GtkPopover* _tmp36_ = NULL;
	SudokuGame* _tmp37_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (*game != NULL, NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->_ref_count_ = 1;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = row;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->row = _tmp0_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = col;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->col = _tmp1_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) g_object_new (object_type, NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->self = g_object_ref (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = *game;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->game = _tmp3_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _data5_->row;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->row = _tmp4_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _data5_->col;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->col = _tmp5_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = gtk_widget_get_style ((GtkWidget*) self);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = _tmp7_->font_desc;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_font_description_set_size (_tmp8_, PANGO_SCALE * 13);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = *game;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _tmp9_->board;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = _data5_->row;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _data5_->col;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = sudoku_board_get (_tmp10_, _tmp11_, _tmp12_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp13_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_KEY_PRESS_MASK);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_is_fixed (self);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp15_) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		block5_data_unref (_data5_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_data5_ = NULL;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return self;
#line 589 "sudoku-view.c"
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = *game;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = number_picker_new (&_tmp16_->board, FALSE);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp17_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->number_picker = _tmp17_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = self->priv->number_picker;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_data (_tmp18_, "number-picked", (GCallback) ___lambda7__number_picker_number_picked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp19_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->popover = _tmp19_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = self->priv->popover;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = self->priv->number_picker;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = self->priv->popover;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp22_, FALSE);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = self->priv->popover;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp23_, GTK_POS_BOTTOM);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = self->priv->popover;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp24_, "focus-out-event", (GCallback) ___lambda8__gtk_widget_focus_out_event, self, 0);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp25_ = *game;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp26_ = number_picker_new (&_tmp25_->board, TRUE);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp26_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_picker = _tmp26_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp27_ = self->priv->earmark_picker;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_data (_tmp27_, "earmark-state-changed", (GCallback) ___lambda9__number_picker_earmark_state_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp28_ = self->priv->earmark_picker;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp29_ = _data5_->row;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp30_ = _data5_->col;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_earmarks (_tmp28_, _tmp29_, _tmp30_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp31_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp31_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_popover = _tmp31_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp32_ = self->priv->earmark_popover;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp33_ = self->priv->earmark_picker;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = self->priv->earmark_popover;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp34_, FALSE);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = self->priv->earmark_popover;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp35_, GTK_POS_BOTTOM);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp36_ = self->priv->earmark_popover;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp36_, "focus-out-event", (GCallback) ___lambda10__gtk_widget_focus_out_event, self, 0);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp37_ = *game;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp37_, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	block5_data_unref (_data5_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 691 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
#line 698 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkPopover* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GdkEventButton* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = event;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->button;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ != ((guint) 1)) {
#line 728 "sudoku-view.c"
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = event;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _tmp3_->button;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp4_ != ((guint) 3);
#line 737 "sudoku-view.c"
	} else {
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 741 "sudoku-view.c"
	}
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 749 "sudoku-view.c"
	}
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp5_, NULL);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp6_) {
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) self);
#line 759 "sudoku-view.c"
	}
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = sudoku_cell_view_get_is_fixed (self);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = _tmp7_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp8_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 771 "sudoku-view.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->popover;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = gtk_widget_get_visible ((GtkWidget*) _tmp10_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _tmp11_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp12_) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = TRUE;
#line 783 "sudoku-view.c"
	} else {
		GtkPopover* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = self->priv->earmark_popover;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp14_ = gtk_widget_get_visible ((GtkWidget*) _tmp13_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = _tmp14_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = _tmp15_;
#line 796 "sudoku-view.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp9_) {
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 806 "sudoku-view.c"
	}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = event;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_->button;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp17_ == ((guint) 1)) {
#line 814 "sudoku-view.c"
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = self->priv->_show_possibilities;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp19_) {
#line 821 "sudoku-view.c"
			GdkEventButton* _tmp20_ = NULL;
			GdkModifierType _tmp21_ = 0;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp20_ = event;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = _tmp20_->state;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp18_ = (_tmp21_ & GDK_CONTROL_MASK) > 0;
#line 830 "sudoku-view.c"
		} else {
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp18_ = FALSE;
#line 834 "sudoku-view.c"
		}
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp18_) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 840 "sudoku-view.c"
		} else {
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_number_picker (self);
#line 844 "sudoku-view.c"
		}
	} else {
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = self->priv->_show_possibilities;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp23_) {
#line 853 "sudoku-view.c"
			GdkEventButton* _tmp24_ = NULL;
			guint _tmp25_ = 0U;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = event;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = _tmp24_->button;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = _tmp25_ == ((guint) 3);
#line 862 "sudoku-view.c"
		} else {
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = FALSE;
#line 866 "sudoku-view.c"
		}
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp22_) {
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 872 "sudoku-view.c"
		}
	}
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 879 "sudoku-view.c"
}


static void sudoku_cell_view_show_number_picker (SudokuCellView* self) {
	NumberPicker* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkPopover* _tmp3_ = NULL;
	GtkPopover* _tmp4_ = NULL;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->number_picker;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = sudoku_cell_view_get_value (self);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_clear_button_visibility (_tmp0_, _tmp2_ != 0);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->earmark_popover;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->popover;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 907 "sudoku-view.c"
}


static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->earmark_popover;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 924 "sudoku-view.c"
}


static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->earmark_popover;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 941 "sudoku-view.c"
}


static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_hide_both_popovers (self);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 959 "sudoku-view.c"
}


static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (key_name != NULL, 0);
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = key_name;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp1_, "KP_0") == 0) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 986 "sudoku-view.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = key_name;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "0") == 0;
#line 993 "sudoku-view.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 0;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1001 "sudoku-view.c"
	}
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = key_name;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp3_, "KP_1") == 0) {
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 1;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1011 "sudoku-view.c"
	}
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = key_name;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp4_, "KP_2") == 0) {
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 2;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1021 "sudoku-view.c"
	}
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = key_name;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp5_, "KP_3") == 0) {
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 3;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1031 "sudoku-view.c"
	}
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = key_name;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp6_, "KP_4") == 0) {
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 4;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1041 "sudoku-view.c"
	}
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = key_name;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp7_, "KP_5") == 0) {
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 5;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1051 "sudoku-view.c"
	}
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = key_name;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp8_, "KP_6") == 0) {
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 6;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1061 "sudoku-view.c"
	}
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = key_name;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp9_, "KP_7") == 0) {
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 7;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1071 "sudoku-view.c"
	}
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = key_name;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp10_, "KP_8") == 0) {
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 8;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1081 "sudoku-view.c"
	}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = key_name;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp11_, "KP_9") == 0) {
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 9;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1091 "sudoku-view.c"
	}
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = -1;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1097 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* k_name = NULL;
	GdkEventKey* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint k_no = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gint _tmp46_ = 0;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp54_ = NULL;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1138 "sudoku-view.c"
	}
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = event;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp2_->keyval;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = gdk_keyval_name (_tmp3_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_name = _tmp5_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = k_name;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = atoi (_tmp6_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_no = _tmp7_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = k_no;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp8_ == 0) {
#line 1160 "sudoku-view.c"
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = k_name;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = sudoku_cell_view_key_map_keypad (self, _tmp9_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		k_no = _tmp10_;
#line 1169 "sudoku-view.c"
	}
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = k_no;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp12_ >= 1) {
#line 1175 "sudoku-view.c"
		gint _tmp13_ = 0;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = k_no;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = _tmp13_ <= 9;
#line 1181 "sudoku-view.c"
	} else {
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = FALSE;
#line 1185 "sudoku-view.c"
	}
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp11_) {
#line 1189 "sudoku-view.c"
		GdkEventKey* _tmp14_ = NULL;
		GdkModifierType _tmp15_ = 0;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp14_ = event;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = _tmp14_->state;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if ((_tmp15_ & GDK_CONTROL_MASK) > 0) {
#line 1198 "sudoku-view.c"
			gboolean new_state = FALSE;
			SudokuGame* _tmp16_ = NULL;
			SudokuBoard* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gboolean _tmp21_ = FALSE;
			NumberPicker* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp16_ = self->priv->game;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp17_ = _tmp16_->board;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp18_ = self->priv->row;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp19_ = self->priv->col;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp20_ = k_no;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = sudoku_board_is_earmark_enabled (_tmp17_, _tmp18_, _tmp19_, _tmp20_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			new_state = !_tmp21_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = self->priv->earmark_picker;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp23_ = self->priv->row;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = self->priv->col;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = k_no;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = new_state;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = number_picker_set_earmark (_tmp22_, _tmp23_, _tmp24_, _tmp25_ - 1, _tmp26_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp27_) {
#line 1240 "sudoku-view.c"
				gboolean _tmp28_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp28_ = new_state;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp28_) {
#line 1246 "sudoku-view.c"
					SudokuGame* _tmp29_ = NULL;
					SudokuBoard* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp29_ = self->priv->game;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp30_ = _tmp29_->board;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp31_ = self->priv->row;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp32_ = self->priv->col;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp33_ = k_no;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_enable_earmark (_tmp30_, _tmp31_, _tmp32_, _tmp33_);
#line 1264 "sudoku-view.c"
				} else {
					SudokuGame* _tmp34_ = NULL;
					SudokuBoard* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp34_ = self->priv->game;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp35_ = _tmp34_->board;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp36_ = self->priv->row;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp37_ = self->priv->col;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp38_ = k_no;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_disable_earmark (_tmp35_, _tmp36_, _tmp37_, _tmp38_);
#line 1283 "sudoku-view.c"
				}
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				gtk_widget_queue_draw ((GtkWidget*) self);
#line 1287 "sudoku-view.c"
			}
		} else {
			gint _tmp39_ = 0;
			SudokuGame* _tmp40_ = NULL;
			SudokuBoard* _tmp41_ = NULL;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp39_ = k_no;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_set_value (self, _tmp39_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp40_ = self->priv->game;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp41_ = _tmp40_->board;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp42_ = self->priv->row;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp43_ = self->priv->col;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_board_disable_all_earmarks (_tmp41_, _tmp42_, _tmp43_);
#line 1309 "sudoku-view.c"
		}
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1317 "sudoku-view.c"
	}
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp46_ = k_no;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp46_ == 0) {
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = TRUE;
#line 1325 "sudoku-view.c"
	} else {
		const gchar* _tmp47_ = NULL;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp47_ = k_name;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = g_strcmp0 (_tmp47_, "BackSpace") == 0;
#line 1332 "sudoku-view.c"
	}
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp45_) {
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = TRUE;
#line 1338 "sudoku-view.c"
	} else {
		const gchar* _tmp48_ = NULL;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = k_name;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = g_strcmp0 (_tmp48_, "Delete") == 0;
#line 1345 "sudoku-view.c"
	}
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp44_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, 0);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1359 "sudoku-view.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp51_ = k_name;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp51_, "space") == 0) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = TRUE;
#line 1367 "sudoku-view.c"
	} else {
		const gchar* _tmp52_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = k_name;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = g_strcmp0 (_tmp52_, "Return") == 0;
#line 1374 "sudoku-view.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp50_) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = TRUE;
#line 1380 "sudoku-view.c"
	} else {
		const gchar* _tmp53_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = k_name;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = g_strcmp0 (_tmp53_, "KP_Enter") == 0;
#line 1387 "sudoku-view.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp49_) {
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_show_number_picker (self);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1399 "sudoku-view.c"
	}
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp54_ = k_name;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp54_, "Escape") == 0) {
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1413 "sudoku-view.c"
	}
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_free0 (k_name);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1421 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->layout;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_layout_get_pixel_size (_tmp0_, &_tmp1_, &_tmp2_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_width = _tmp1_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_height = _tmp2_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->_show_warnings;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp4_) {
#line 1458 "sudoku-view.c"
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Coord _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->game;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->broken_coords;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->row;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->col;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp10_, _tmp8_, _tmp9_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp10_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp11_;
#line 1482 "sudoku-view.c"
	} else {
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = FALSE;
#line 1486 "sudoku-view.c"
	}
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 1490 "sudoku-view.c"
		cairo_t* _tmp12_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = c;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp12_, 1.0, 0.0, 0.0);
#line 1496 "sudoku-view.c"
	} else {
		gboolean _tmp13_ = FALSE;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = self->priv->_selected;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp13_) {
#line 1503 "sudoku-view.c"
			cairo_t* _tmp14_ = NULL;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp14_ = c;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp14_, 0.2, 0.2, 0.2);
#line 1509 "sudoku-view.c"
		} else {
			cairo_t* _tmp15_ = NULL;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp15_ = c;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp15_, 0.0, 0.0, 0.0);
#line 1516 "sudoku-view.c"
		}
	}
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = sudoku_cell_view_get_value (self);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp17_ != 0) {
#line 1525 "sudoku-view.c"
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gdouble scale = 0.0;
		gint _tmp22_ = 0;
		gdouble _tmp23_ = 0.0;
		gint _tmp24_ = 0;
		cairo_t* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gdouble _tmp28_ = 0.0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gdouble _tmp31_ = 0.0;
		cairo_t* _tmp32_ = NULL;
		cairo_t* _tmp33_ = NULL;
		gdouble _tmp34_ = 0.0;
		gdouble _tmp35_ = 0.0;
		cairo_t* _tmp36_ = NULL;
		PangoLayout* _tmp37_ = NULL;
		cairo_t* _tmp38_ = NULL;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = self->priv->layout;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_get_size (_tmp18_, &_tmp19_, &_tmp20_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		width = _tmp19_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp20_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = height;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp21_ / PANGO_SCALE;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = self->priv->size_ratio;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = height;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		scale = (((gdouble) _tmp22_) / _tmp23_) / _tmp24_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = c;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = glyph_width;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp28_ = scale;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp29_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp30_ = glyph_height;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp31_ = scale;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp25_, (_tmp26_ - (_tmp27_ * _tmp28_)) / 2, (_tmp29_ - (_tmp30_ * _tmp31_)) / 2);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp32_ = c;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_save (_tmp32_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp33_ = c;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp34_ = scale;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp35_ = scale;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp33_, _tmp34_, _tmp35_);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = c;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = self->priv->layout;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_cairo_show_layout (_tmp36_, _tmp37_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = c;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_restore (_tmp38_);
#line 1608 "sudoku-view.c"
	}
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp39_ = sudoku_cell_view_get_is_fixed (self);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp40_ = _tmp39_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp40_) {
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1620 "sudoku-view.c"
	}
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp41_ = self->priv->_show_possibilities;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp41_) {
#line 1626 "sudoku-view.c"
		gdouble earmark_size = 0.0;
		gint _tmp42_ = 0;
		gdouble _tmp43_ = 0.0;
		cairo_t* _tmp44_ = NULL;
		gdouble _tmp45_ = 0.0;
		cairo_t* _tmp46_ = NULL;
		gdouble _tmp47_ = 0.0;
		cairo_t* _tmp48_ = NULL;
		cairo_t* _tmp49_ = NULL;
		SudokuGame* _tmp50_ = NULL;
		SudokuBoard* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = self->priv->size_ratio;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		earmark_size = _tmp42_ / (_tmp43_ * 2);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = c;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = earmark_size;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp44_, _tmp45_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = c;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp47_ = earmark_size;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp46_, (gdouble) 0, _tmp47_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = c;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp48_, 0.0, 0.0, 0.0);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = c;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = self->priv->game;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp51_ = _tmp50_->board;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = self->priv->row;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = self->priv->col;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp54_ = sudoku_board_get_earmarks_string (_tmp51_, _tmp52_, _tmp53_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = _tmp54_;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp49_, _tmp55_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (_tmp55_);
#line 1682 "sudoku-view.c"
	} else {
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = sudoku_cell_view_get_value (self);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp57_ = _tmp56_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp57_ == 0) {
#line 1692 "sudoku-view.c"
			gdouble possibility_size = 0.0;
			gint _tmp58_ = 0;
			gdouble _tmp59_ = 0.0;
			cairo_t* _tmp60_ = NULL;
			gdouble _tmp61_ = 0.0;
			cairo_t* _tmp62_ = NULL;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp63_ = NULL;
			SudokuBoard* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
			gint _tmp67_ = 0;
			gboolean* _tmp68_ = NULL;
			gint possibilities_length1 = 0;
			gint _possibilities_size_ = 0;
			gint height = 0;
			gint _tmp69_ = 0;
			SudokuGame* _tmp70_ = NULL;
			SudokuBoard* _tmp71_ = NULL;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gint width = 0;
			gint _tmp74_ = 0;
			SudokuGame* _tmp75_ = NULL;
			SudokuBoard* _tmp76_ = NULL;
			gint _tmp77_ = 0;
			gint _tmp78_ = 0;
			gint num = 0;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp58_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp59_ = self->priv->size_ratio;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibility_size = _tmp58_ / (_tmp59_ * 2);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp60_ = c;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp61_ = possibility_size;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_font_size (_tmp60_, _tmp61_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp62_ = c;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp62_, 0.0, 0.0, 0.0);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp63_ = self->priv->game;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp64_ = _tmp63_->board;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp65_ = self->priv->row;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp66_ = self->priv->col;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp68_ = sudoku_board_get_possibilities_as_bool_array (_tmp64_, _tmp65_, _tmp66_, &_tmp67_);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = _tmp68_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities_length1 = _tmp67_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_possibilities_size_ = possibilities_length1;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp70_ = self->priv->game;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp71_ = _tmp70_->board;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp72_ = sudoku_board_get_block_cols (_tmp71_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp73_ = _tmp72_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			height = _tmp69_ / _tmp73_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp74_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp75_ = self->priv->game;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp76_ = _tmp75_->board;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = sudoku_board_get_block_rows (_tmp76_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = _tmp77_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			width = _tmp74_ / _tmp78_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			num = 0;
#line 1779 "sudoku-view.c"
			{
				gint row_tmp = 0;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				row_tmp = 0;
#line 1784 "sudoku-view.c"
				{
					gboolean _tmp79_ = FALSE;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp79_ = TRUE;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					while (TRUE) {
#line 1791 "sudoku-view.c"
						gint _tmp81_ = 0;
						SudokuGame* _tmp82_ = NULL;
						SudokuBoard* _tmp83_ = NULL;
						gint _tmp84_ = 0;
						gint _tmp85_ = 0;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!_tmp79_) {
#line 1799 "sudoku-view.c"
							gint _tmp80_ = 0;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp80_ = row_tmp;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							row_tmp = _tmp80_ + 1;
#line 1805 "sudoku-view.c"
						}
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp79_ = FALSE;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp81_ = row_tmp;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp82_ = self->priv->game;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp83_ = _tmp82_->board;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp84_ = sudoku_board_get_block_rows (_tmp83_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp85_ = _tmp84_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!(_tmp81_ < _tmp85_)) {
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							break;
#line 1823 "sudoku-view.c"
						}
						{
							gint col_tmp = 0;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							col_tmp = 0;
#line 1829 "sudoku-view.c"
							{
								gboolean _tmp86_ = FALSE;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp86_ = TRUE;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								while (TRUE) {
#line 1836 "sudoku-view.c"
									gint _tmp88_ = 0;
									SudokuGame* _tmp89_ = NULL;
									SudokuBoard* _tmp90_ = NULL;
									gint _tmp91_ = 0;
									gint _tmp92_ = 0;
									gint _tmp93_ = 0;
									gboolean* _tmp94_ = NULL;
									gint _tmp94__length1 = 0;
									gint _tmp95_ = 0;
									gboolean _tmp96_ = FALSE;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!_tmp86_) {
#line 1849 "sudoku-view.c"
										gint _tmp87_ = 0;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp87_ = col_tmp;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										col_tmp = _tmp87_ + 1;
#line 1855 "sudoku-view.c"
									}
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp86_ = FALSE;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp88_ = col_tmp;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp89_ = self->priv->game;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp90_ = _tmp89_->board;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp91_ = sudoku_board_get_block_cols (_tmp90_);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp92_ = _tmp91_;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!(_tmp88_ < _tmp92_)) {
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										break;
#line 1873 "sudoku-view.c"
									}
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp93_ = num;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									num = _tmp93_ + 1;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp94_ = possibilities;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp94__length1 = possibilities_length1;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp95_ = num;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp96_ = _tmp94_[_tmp95_ - 1];
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (_tmp96_) {
#line 1889 "sudoku-view.c"
										cairo_t* _tmp97_ = NULL;
										gint _tmp98_ = 0;
										gint _tmp99_ = 0;
										gint _tmp100_ = 0;
										gint _tmp101_ = 0;
										gdouble _tmp102_ = 0.0;
										cairo_t* _tmp103_ = NULL;
										gint _tmp104_ = 0;
										gchar* _tmp105_ = NULL;
										gchar* _tmp106_ = NULL;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp97_ = c;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp98_ = col_tmp;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp99_ = width;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp100_ = row_tmp;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp101_ = height;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp102_ = possibility_size;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_move_to (_tmp97_, (gdouble) (_tmp98_ * _tmp99_), (_tmp100_ * _tmp101_) + _tmp102_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp103_ = c;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp104_ = num;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp105_ = g_strdup_printf ("%d", _tmp104_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp106_ = _tmp105_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_show_text (_tmp103_, _tmp106_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_g_free0 (_tmp106_);
#line 1926 "sudoku-view.c"
									}
								}
							}
						}
					}
				}
			}
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = (g_free (possibilities), NULL);
#line 1936 "sudoku-view.c"
		}
	}
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp108_ = self->priv->_show_warnings;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp108_) {
#line 1943 "sudoku-view.c"
		gboolean _tmp109_ = FALSE;
		gint _tmp110_ = 0;
		gint _tmp111_ = 0;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp110_ = sudoku_cell_view_get_value (self);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp111_ = _tmp110_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp111_ == 0) {
#line 1953 "sudoku-view.c"
			SudokuGame* _tmp112_ = NULL;
			SudokuBoard* _tmp113_ = NULL;
			gint _tmp114_ = 0;
			gint _tmp115_ = 0;
			gint _tmp116_ = 0;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp112_ = self->priv->game;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp113_ = _tmp112_->board;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp114_ = self->priv->row;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp115_ = self->priv->col;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp116_ = sudoku_board_count_possibilities (_tmp113_, _tmp114_, _tmp115_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp109_ = _tmp116_ == 0;
#line 1971 "sudoku-view.c"
		} else {
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp109_ = FALSE;
#line 1975 "sudoku-view.c"
		}
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp107_ = _tmp109_;
#line 1979 "sudoku-view.c"
	} else {
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp107_ = FALSE;
#line 1983 "sudoku-view.c"
	}
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp107_) {
#line 1987 "sudoku-view.c"
		gchar* warning = NULL;
		gchar* _tmp117_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp118_ = NULL;
		gint _tmp119_ = 0;
		cairo_t* _tmp120_ = NULL;
		const gchar* _tmp121_ = NULL;
		cairo_text_extents_t _tmp122_ = {0};
		cairo_t* _tmp123_ = NULL;
		gint _tmp124_ = 0;
		cairo_text_extents_t _tmp125_ = {0};
		gdouble _tmp126_ = 0.0;
		gint _tmp127_ = 0;
		cairo_text_extents_t _tmp128_ = {0};
		gdouble _tmp129_ = 0.0;
		cairo_t* _tmp130_ = NULL;
		cairo_t* _tmp131_ = NULL;
		const gchar* _tmp132_ = NULL;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp117_ = g_strdup ("X");
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		warning = _tmp117_;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp118_ = c;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp119_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp118_, (gdouble) (_tmp119_ / 2));
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp120_ = c;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp121_ = warning;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp120_, _tmp121_, &_tmp122_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp122_;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp123_ = c;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp124_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp125_ = extents;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp126_ = _tmp125_.width;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp127_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp128_ = extents;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp129_ = _tmp128_.height;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp123_, ((_tmp124_ - _tmp126_) / 2) - 1, ((_tmp127_ + _tmp129_) / 2) + 1);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp130_ = c;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp130_, 1.0, 0.0, 0.0);
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = c;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = warning;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp131_, _tmp132_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (warning);
#line 2052 "sudoku-view.c"
	}
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2058 "sudoku-view.c"
}


void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = row;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == _tmp2_) {
#line 2074 "sudoku-view.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = col;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->col;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 2083 "sudoku-view.c"
	} else {
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 2087 "sudoku-view.c"
	}
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 2091 "sudoku-view.c"
		gint _tmp5_ = 0;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = new_val;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, _tmp5_);
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 2099 "sudoku-view.c"
	}
}


void sudoku_cell_view_clear (SudokuCellView* self) {
	NumberPicker* _tmp0_ = NULL;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_picker;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 2112 "sudoku-view.c"
		{
			gint i = 0;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			i = 0;
#line 2117 "sudoku-view.c"
			{
				gboolean _tmp1_ = FALSE;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = TRUE;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				while (TRUE) {
#line 2124 "sudoku-view.c"
					gint _tmp3_ = 0;
					SudokuGame* _tmp4_ = NULL;
					SudokuBoard* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					NumberPicker* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (!_tmp1_) {
#line 2136 "sudoku-view.c"
						gint _tmp2_ = 0;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp2_ = i;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						i = _tmp2_ + 1;
#line 2142 "sudoku-view.c"
					}
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = FALSE;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp3_ = i;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp4_ = self->priv->game;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp5_ = _tmp4_->board;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp6_ = sudoku_board_get_max_val (_tmp5_);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp7_ = _tmp6_;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (!(_tmp3_ < _tmp7_)) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						break;
#line 2160 "sudoku-view.c"
					}
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp8_ = self->priv->earmark_picker;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = self->priv->row;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp10_ = self->priv->col;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp11_ = i;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					number_picker_set_earmark (_tmp8_, _tmp9_, _tmp10_, _tmp11_, FALSE);
#line 2172 "sudoku-view.c"
				}
			}
		}
	}
}


gint sudoku_cell_view_get_value (SudokuCellView* self) {
	gint result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->col;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp4_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2203 "sudoku-view.c"
}


void sudoku_cell_view_set_value (SudokuCellView* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp14_ = 0;
	gint _tmp30_ = 0;
	SudokuGame* _tmp31_ = NULL;
	SudokuBoard* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	SudokuGame* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 2229 "sudoku-view.c"
		gchar* text = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		PangoLayout* _tmp9_ = NULL;
		PangoLayout* _tmp10_ = NULL;
		GtkStyle* _tmp11_ = NULL;
		GtkStyle* _tmp12_ = NULL;
		PangoFontDescription* _tmp13_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = self->priv->game;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp2_->board;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->row;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->col;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = sudoku_board_get (_tmp3_, _tmp4_, _tmp5_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp7_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = text;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp8_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp9_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = self->priv->layout;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_->font_desc;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp10_, _tmp13_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2279 "sudoku-view.c"
	}
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = value;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp14_ == 0) {
#line 2285 "sudoku-view.c"
		gchar* text = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		PangoLayout* _tmp17_ = NULL;
		PangoLayout* _tmp18_ = NULL;
		GtkStyle* _tmp19_ = NULL;
		GtkStyle* _tmp20_ = NULL;
		PangoFontDescription* _tmp21_ = NULL;
		SudokuGame* _tmp22_ = NULL;
		SudokuBoard* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = g_strdup ("");
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp15_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = text;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp16_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp17_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = self->priv->layout;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = gtk_widget_get_style ((GtkWidget*) self);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp20_ = _tmp19_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = _tmp20_->font_desc;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp18_, _tmp21_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = self->priv->game;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = _tmp22_->board;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = self->priv->row;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = self->priv->col;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = sudoku_board_get (_tmp23_, _tmp24_, _tmp25_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp26_ != 0) {
#line 2333 "sudoku-view.c"
			SudokuGame* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = self->priv->game;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = self->priv->row;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = self->priv->col;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_game_remove (_tmp27_, _tmp28_, _tmp29_);
#line 2345 "sudoku-view.c"
		}
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2351 "sudoku-view.c"
	}
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp30_ = value;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp31_ = self->priv->game;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp32_ = _tmp31_->board;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp33_ = self->priv->row;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = self->priv->col;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = sudoku_board_get (_tmp32_, _tmp33_, _tmp34_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp30_ == _tmp35_) {
#line 2367 "sudoku-view.c"
		gchar* text = NULL;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		PangoLayout* _tmp39_ = NULL;
		PangoLayout* _tmp40_ = NULL;
		GtkStyle* _tmp41_ = NULL;
		GtkStyle* _tmp42_ = NULL;
		PangoFontDescription* _tmp43_ = NULL;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = value;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = g_strdup_printf ("%d", _tmp36_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp37_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = text;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp39_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp38_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp39_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = self->priv->layout;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = gtk_widget_get_style ((GtkWidget*) self);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = _tmp41_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = _tmp42_->font_desc;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp40_, _tmp43_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2405 "sudoku-view.c"
	}
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp44_ = self->priv->game;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp45_ = self->priv->row;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp46_ = self->priv->col;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp47_ = value;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_game_insert (_tmp44_, _tmp45_, _tmp46_, _tmp47_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "value");
#line 2419 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self) {
	gboolean result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->is_fixed;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length1 = _tmp1_->is_fixed_length1;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length2 = _tmp1_->is_fixed_length2;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->row;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->col;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp5_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2455 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2470 "sudoku-view.c"
}


void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 2486 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2501 "sudoku-view.c"
}


void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 2517 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_selected (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_selected;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2532 "sudoku-view.c"
}


void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_selected = _tmp0_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "selected");
#line 2546 "sudoku-view.c"
}


void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_background_color;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	*result = _tmp0_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return;
#line 2560 "sudoku-view.c"
}


void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value) {
	GdkRGBA _tmp0_ = {0};
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *value;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_background_color = _tmp0_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "background-color");
#line 2574 "sudoku-view.c"
}


static void sudoku_cell_view_class_init (SudokuCellViewClass * klass) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = sudoku_cell_view_real_button_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->key_press_event = sudoku_cell_view_real_key_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->draw = sudoku_cell_view_real_draw;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED, g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR, g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2607 "sudoku-view.c"
}


static void sudoku_cell_view_instance_init (SudokuCellView * self) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->size_ratio = (gdouble) 2;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = TRUE;
#line 2618 "sudoku-view.c"
}


static void sudoku_cell_view_finalize (GObject* obj) {
	SudokuCellView * self;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->layout);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
#line 2640 "sudoku-view.c"
}


GType sudoku_cell_view_get_type (void) {
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_int (value, sudoku_cell_view_get_value (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_IS_FIXED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 2693 "sudoku-view.c"
		{
			GdkRGBA boxed;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_get_background_color (self, &boxed);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			g_value_set_boxed (value, &boxed);
#line 2700 "sudoku-view.c"
		}
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2704 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2710 "sudoku-view.c"
	}
}


static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, g_value_get_int (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2750 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2756 "sudoku-view.c"
	}
}


static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	SudokuCellView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuCellView* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SudokuCellView** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	SudokuCellView* _tmp13_ = NULL;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->cells;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length1 = self->priv->cells_length1;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length2 = self->priv->cells_length2;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->selected_row;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->selected_col;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp3_, FALSE);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->cells;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length1 = self->priv->cells_length1;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length2 = self->priv->cells_length2;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->selected_row;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->selected_col;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = cell_row;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = _tmp8_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = cell_col;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = _tmp9_;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->cells;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length1 = self->priv->cells_length1;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length2 = self->priv->cells_length2;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->selected_row;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->selected_col;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp13_, TRUE);
#line 2834 "sudoku-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data6_;
#line 2843 "sudoku-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 2852 "sudoku-view.c"
		SudokuView* self;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data6_->self;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_data6_->game);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 2862 "sudoku-view.c"
	}
}


static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2872 "sudoku-view.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data7_;
#line 2881 "sudoku-view.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 2890 "sudoku-view.c"
		SudokuView* self;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data7_->_data6_->self;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		block6_data_unref (_data7_->_data6_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_data7_->_data6_ = NULL;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 2900 "sudoku-view.c"
	}
}


static gboolean ________lambda11_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	SudokuView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuCellView** _tmp110_ = NULL;
	gint _tmp110__length1 = 0;
	gint _tmp110__length2 = 0;
	gint _tmp111_ = 0;
	gint _tmp112_ = 0;
	SudokuCellView* _tmp113_ = NULL;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = _data7_->_data6_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data6_->self;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = _data7_->cell_row;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _data7_->cell_col;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_set_selected (self, _tmp0_, _tmp1_);
#line 2927 "sudoku-view.c"
	{
		gint col_tmp = 0;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 2932 "sudoku-view.c"
		{
			gboolean _tmp2_ = FALSE;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp2_ = TRUE;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 2939 "sudoku-view.c"
				gint _tmp4_ = 0;
				SudokuGame* _tmp5_ = NULL;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GdkRGBA _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				GdkRGBA color = {0};
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp2_) {
#line 2952 "sudoku-view.c"
					gint _tmp3_ = 0;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp3_ = col_tmp;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp3_ + 1;
#line 2958 "sudoku-view.c"
				}
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp2_ = FALSE;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = col_tmp;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _data6_->game;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = _tmp5_->board;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = sudoku_board_get_cols (_tmp6_);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp8_ = _tmp7_;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 2976 "sudoku-view.c"
				}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = col_tmp;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp12_ = _data7_->cell_col;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp11_ == _tmp12_) {
#line 2984 "sudoku-view.c"
					gboolean _tmp13_ = FALSE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp13_ = self->priv->_highlighter;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp10_ = _tmp13_;
#line 2990 "sudoku-view.c"
				} else {
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp10_ = FALSE;
#line 2994 "sudoku-view.c"
				}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp10_) {
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = SUDOKU_VIEW_highlight_color;
#line 3000 "sudoku-view.c"
				} else {
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = SUDOKU_VIEW_free_cell_color;
#line 3004 "sudoku-view.c"
				}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				color = _tmp9_;
#line 3008 "sudoku-view.c"
				{
					gint row_tmp = 0;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row_tmp = 0;
#line 3013 "sudoku-view.c"
					{
						gboolean _tmp14_ = FALSE;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp14_ = TRUE;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 3020 "sudoku-view.c"
							gint _tmp16_ = 0;
							SudokuGame* _tmp17_ = NULL;
							SudokuBoard* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							GdkRGBA _tmp21_ = {0};
							SudokuCellView** _tmp22_ = NULL;
							gint _tmp22__length1 = 0;
							gint _tmp22__length2 = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							SudokuCellView* _tmp25_ = NULL;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp27_ = FALSE;
							SudokuCellView** _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							SudokuCellView* _tmp32_ = NULL;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp14_) {
#line 3043 "sudoku-view.c"
								gint _tmp15_ = 0;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp15_ = row_tmp;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								row_tmp = _tmp15_ + 1;
#line 3049 "sudoku-view.c"
							}
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = FALSE;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = row_tmp;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = _data6_->game;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp17_->board;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = sudoku_board_get_rows (_tmp18_);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = _tmp19_;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp16_ < _tmp20_)) {
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3067 "sudoku-view.c"
							}
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = self->priv->cells;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22__length1 = self->priv->cells_length1;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22__length2 = self->priv->cells_length2;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = row_tmp;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = col_tmp;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = sudoku_cell_view_get_is_fixed (_tmp25_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = _tmp26_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp27_) {
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp21_ = SUDOKU_VIEW_fixed_cell_color;
#line 3089 "sudoku-view.c"
							} else {
								GdkRGBA _tmp28_ = {0};
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp28_ = color;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp21_ = _tmp28_;
#line 3096 "sudoku-view.c"
							}
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp29_ = self->priv->cells;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp29__length1 = self->priv->cells_length1;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp29__length2 = self->priv->cells_length2;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = row_tmp;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = col_tmp;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp32_, &_tmp21_);
#line 3112 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint col_tmp = 0;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 3123 "sudoku-view.c"
		{
			gboolean _tmp33_ = FALSE;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp33_ = TRUE;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3130 "sudoku-view.c"
				gint _tmp35_ = 0;
				SudokuGame* _tmp36_ = NULL;
				SudokuBoard* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				SudokuCellView** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gint _tmp40__length2 = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				SudokuCellView* _tmp43_ = NULL;
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp33_) {
#line 3146 "sudoku-view.c"
					gint _tmp34_ = 0;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp34_ = col_tmp;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp34_ + 1;
#line 3152 "sudoku-view.c"
				}
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp33_ = FALSE;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp35_ = col_tmp;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp36_ = _data6_->game;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp37_ = _tmp36_->board;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp38_ = sudoku_board_get_cols (_tmp37_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp39_ = _tmp38_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp35_ < _tmp39_)) {
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3170 "sudoku-view.c"
				}
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40_ = self->priv->cells;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40__length1 = self->priv->cells_length1;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40__length2 = self->priv->cells_length2;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp41_ = _data7_->cell_row;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp42_ = col_tmp;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp43_ = _tmp40_[(_tmp41_ * _tmp40__length2) + _tmp42_];
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp44_ = sudoku_cell_view_get_is_fixed (_tmp43_);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp45_ = _tmp44_;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp45_) {
#line 3190 "sudoku-view.c"
					SudokuCellView** _tmp46_ = NULL;
					gint _tmp46__length1 = 0;
					gint _tmp46__length2 = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					SudokuCellView* _tmp49_ = NULL;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp46_ = self->priv->cells;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp46__length1 = self->priv->cells_length1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp46__length2 = self->priv->cells_length2;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp47_ = _data7_->cell_row;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp48_ = col_tmp;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp49_, &SUDOKU_VIEW_fixed_cell_color);
#line 3211 "sudoku-view.c"
				} else {
					gboolean _tmp50_ = FALSE;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp50_ = self->priv->_highlighter;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (_tmp50_) {
#line 3218 "sudoku-view.c"
						SudokuCellView** _tmp51_ = NULL;
						gint _tmp51__length1 = 0;
						gint _tmp51__length2 = 0;
						gint _tmp52_ = 0;
						gint _tmp53_ = 0;
						SudokuCellView* _tmp54_ = NULL;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp51_ = self->priv->cells;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp51__length1 = self->priv->cells_length1;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp51__length2 = self->priv->cells_length2;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp52_ = _data7_->cell_row;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp53_ = col_tmp;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp54_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp54_, &SUDOKU_VIEW_highlight_color);
#line 3239 "sudoku-view.c"
					} else {
						SudokuCellView** _tmp55_ = NULL;
						gint _tmp55__length1 = 0;
						gint _tmp55__length2 = 0;
						gint _tmp56_ = 0;
						gint _tmp57_ = 0;
						SudokuCellView* _tmp58_ = NULL;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp55_ = self->priv->cells;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp55__length1 = self->priv->cells_length1;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp55__length2 = self->priv->cells_length2;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp56_ = _data7_->cell_row;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp57_ = col_tmp;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp58_ = _tmp55_[(_tmp56_ * _tmp55__length2) + _tmp57_];
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp58_, &SUDOKU_VIEW_free_cell_color);
#line 3261 "sudoku-view.c"
					}
				}
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		SudokuGame* _tmp59_ = NULL;
		SudokuBoard* _tmp60_ = NULL;
		GeeMap* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		SudokuGame* _tmp63_ = NULL;
		SudokuBoard* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		SudokuGame* _tmp68_ = NULL;
		SudokuBoard* _tmp69_ = NULL;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		Coord _tmp72_ = {0};
		gpointer _tmp73_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		gint _coord_index = 0;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = _data6_->game;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = _tmp59_->board;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = _tmp60_->coords_for_block;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp62_ = _data7_->cell_row;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = _data6_->game;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp64_ = _tmp63_->board;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp65_ = sudoku_board_get_block_rows (_tmp64_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp66_ = _tmp65_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp67_ = _data7_->cell_col;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp68_ = _data6_->game;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp69_ = _tmp68_->board;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp70_ = sudoku_board_get_block_cols (_tmp69_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp71_ = _tmp70_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp72_, _tmp62_ / _tmp66_, _tmp67_ / _tmp71_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp73_ = gee_map_get (_tmp61_, &_tmp72_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_list = (GeeList*) _tmp73_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp74_ = _coord_list;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp75_ = gee_collection_get_size ((GeeCollection*) _tmp74_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp76_ = _tmp75_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_size = _tmp76_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_index = -1;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		while (TRUE) {
#line 3333 "sudoku-view.c"
			gint _tmp77_ = 0;
			gint _tmp78_ = 0;
			gint _tmp79_ = 0;
			Coord* coord = NULL;
			GeeList* _tmp80_ = NULL;
			gint _tmp81_ = 0;
			gpointer _tmp82_ = NULL;
			SudokuCellView** _tmp83_ = NULL;
			gint _tmp83__length1 = 0;
			gint _tmp83__length2 = 0;
			Coord* _tmp84_ = NULL;
			gint _tmp85_ = 0;
			Coord* _tmp86_ = NULL;
			gint _tmp87_ = 0;
			SudokuCellView* _tmp88_ = NULL;
			gboolean _tmp89_ = FALSE;
			gboolean _tmp90_ = FALSE;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = _coord_index;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_coord_index = _tmp77_ + 1;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = _coord_index;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp79_ = _coord_size;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (!(_tmp78_ < _tmp79_)) {
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				break;
#line 3363 "sudoku-view.c"
			}
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = _coord_list;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = _coord_index;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			coord = (Coord*) _tmp82_;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83_ = self->priv->cells;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83__length1 = self->priv->cells_length1;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83__length2 = self->priv->cells_length2;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp84_ = coord;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp85_ = (*_tmp84_).row;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp86_ = coord;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp87_ = (*_tmp86_).col;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp88_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp89_ = sudoku_cell_view_get_is_fixed (_tmp88_);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = _tmp89_;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp90_) {
#line 3395 "sudoku-view.c"
				SudokuCellView** _tmp91_ = NULL;
				gint _tmp91__length1 = 0;
				gint _tmp91__length2 = 0;
				Coord* _tmp92_ = NULL;
				gint _tmp93_ = 0;
				Coord* _tmp94_ = NULL;
				gint _tmp95_ = 0;
				SudokuCellView* _tmp96_ = NULL;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp91_ = self->priv->cells;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp91__length1 = self->priv->cells_length1;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp91__length2 = self->priv->cells_length2;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp92_ = coord;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp93_ = (*_tmp92_).row;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp94_ = coord;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp95_ = (*_tmp94_).col;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = _tmp91_[(_tmp93_ * _tmp91__length2) + _tmp95_];
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (_tmp96_, &SUDOKU_VIEW_fixed_cell_color);
#line 3422 "sudoku-view.c"
			} else {
				gboolean _tmp97_ = FALSE;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = self->priv->_highlighter;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp97_) {
#line 3429 "sudoku-view.c"
					SudokuCellView** _tmp98_ = NULL;
					gint _tmp98__length1 = 0;
					gint _tmp98__length2 = 0;
					Coord* _tmp99_ = NULL;
					gint _tmp100_ = 0;
					Coord* _tmp101_ = NULL;
					gint _tmp102_ = 0;
					SudokuCellView* _tmp103_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp98_ = self->priv->cells;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp98__length1 = self->priv->cells_length1;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp98__length2 = self->priv->cells_length2;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp99_ = coord;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp100_ = (*_tmp99_).row;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp101_ = coord;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp102_ = (*_tmp101_).col;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp103_ = _tmp98_[(_tmp100_ * _tmp98__length2) + _tmp102_];
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp103_, &SUDOKU_VIEW_highlight_color);
#line 3456 "sudoku-view.c"
				} else {
					SudokuCellView** _tmp104_ = NULL;
					gint _tmp104__length1 = 0;
					gint _tmp104__length2 = 0;
					Coord* _tmp105_ = NULL;
					gint _tmp106_ = 0;
					Coord* _tmp107_ = NULL;
					gint _tmp108_ = 0;
					SudokuCellView* _tmp109_ = NULL;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp104_ = self->priv->cells;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp104__length1 = self->priv->cells_length1;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp104__length2 = self->priv->cells_length2;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp105_ = coord;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp106_ = (*_tmp105_).row;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp107_ = coord;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp108_ = (*_tmp107_).col;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = _tmp104_[(_tmp106_ * _tmp104__length2) + _tmp108_];
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp109_, &SUDOKU_VIEW_free_cell_color);
#line 3484 "sudoku-view.c"
				}
			}
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (coord);
#line 3489 "sudoku-view.c"
		}
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_coord_list);
#line 3493 "sudoku-view.c"
	}
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp110_ = self->priv->cells;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp110__length1 = self->priv->cells_length1;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp110__length2 = self->priv->cells_length2;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp111_ = _data7_->cell_row;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp112_ = _data7_->cell_col;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp113_ = _tmp110_[(_tmp111_ * _tmp110__length2) + _tmp112_];
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_background_color (_tmp113_, &SUDOKU_VIEW_selected_bg_color);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3515 "sudoku-view.c"
}


static gboolean _________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = ________lambda11_ (self);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3524 "sudoku-view.c"
}


static void ________lambda12_ (Block7Data* _data7_, GObject* s, GParamSpec* p) {
	Block6Data* _data6_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = _data7_->_data6_;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data6_->self;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (s != NULL);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (p != NULL);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->_show_possibilities;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = TRUE;
#line 3549 "sudoku-view.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->_show_warnings;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp4_;
#line 3556 "sudoku-view.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = TRUE;
#line 3562 "sudoku-view.c"
	} else {
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _data6_->game;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _tmp7_;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = _tmp8_;
#line 3578 "sudoku-view.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 3584 "sudoku-view.c"
	} else {
		gboolean _tmp9_ = FALSE;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->previous_board_broken_state;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp9_;
#line 3591 "sudoku-view.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 3595 "sudoku-view.c"
		SudokuGame* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = _data6_->game;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = _tmp10_->board;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = sudoku_board_get_broken (_tmp11_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->previous_board_broken_state = _tmp13_;
#line 3610 "sudoku-view.c"
	}
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 3614 "sudoku-view.c"
}


static void _________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	________lambda12_ (self, _sender, pspec);
#line 3621 "sudoku-view.c"
}


SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game) {
	SudokuView * self = NULL;
	Block6Data* _data6_;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	GtkOverlay* _tmp2_ = NULL;
	GtkOverlay* _tmp3_ = NULL;
	GtkDrawingArea* _tmp4_ = NULL;
	GtkDrawingArea* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuBoard* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	SudokuGame* _tmp20_ = NULL;
	SudokuBoard* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	SudokuCellView** _tmp24_ = NULL;
	GtkOverlay* _tmp61_ = NULL;
	GtkDrawingArea* _tmp62_ = NULL;
	GtkOverlay* _tmp63_ = NULL;
	GtkGrid* _tmp64_ = NULL;
	GtkDrawingArea* _tmp65_ = NULL;
	GtkGrid* _tmp66_ = NULL;
	GtkOverlay* _tmp67_ = NULL;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->_ref_count_ = 1;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = game;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (_data6_->game);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->game = _tmp1_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuView*) g_object_new (object_type, NULL);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->self = g_object_ref (self);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = (GtkOverlay*) gtk_overlay_new ();
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp2_);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->overlay = _tmp2_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->overlay;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp4_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->drawing = _tmp4_;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->drawing;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->grid;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp6_ != NULL) {
#line 3710 "sudoku-view.c"
		GtkOverlay* _tmp7_ = NULL;
		GtkGrid* _tmp8_ = NULL;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = self->priv->overlay;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->grid;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_container_remove ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 3719 "sudoku-view.c"
	}
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _data6_->game;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->game = _tmp10_;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp11_);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->grid = _tmp11_;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->grid;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_spacing (_tmp12_, 1);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->grid;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_spacing (_tmp13_, 1);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->grid;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_homogeneous (_tmp14_, TRUE);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = self->priv->grid;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_homogeneous (_tmp15_, TRUE);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = _data6_->game;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_->board;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = sudoku_board_get_rows (_tmp17_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = _tmp18_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _data6_->game;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = _tmp20_->board;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = sudoku_board_get_cols (_tmp21_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = _tmp22_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = g_new0 (SudokuCellView*, (_tmp19_ * _tmp23_) + 1);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = _tmp24_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length1 = _tmp19_;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length2 = _tmp23_;
#line 3779 "sudoku-view.c"
	{
		gint row = 0;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		row = 0;
#line 3784 "sudoku-view.c"
		{
			gboolean _tmp25_ = FALSE;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = TRUE;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3791 "sudoku-view.c"
				gint _tmp27_ = 0;
				SudokuGame* _tmp28_ = NULL;
				SudokuBoard* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp25_) {
#line 3799 "sudoku-view.c"
					gint _tmp26_ = 0;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp26_ = row;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row = _tmp26_ + 1;
#line 3805 "sudoku-view.c"
				}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp25_ = FALSE;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp27_ = row;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp28_ = _data6_->game;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp29_ = _tmp28_->board;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp30_ = sudoku_board_get_rows (_tmp29_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp31_ = _tmp30_;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp27_ < _tmp31_)) {
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3823 "sudoku-view.c"
				}
				{
					gint col = 0;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col = 0;
#line 3829 "sudoku-view.c"
					{
						gboolean _tmp32_ = FALSE;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp32_ = TRUE;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 3836 "sudoku-view.c"
							Block7Data* _data7_;
							gint _tmp34_ = 0;
							SudokuGame* _tmp35_ = NULL;
							SudokuBoard* _tmp36_ = NULL;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							SudokuCellView* cell = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							SudokuCellView* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							GdkRGBA _tmp44_ = {0};
							SudokuCellView* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							SudokuCellView* _tmp48_ = NULL;
							SudokuCellView* _tmp49_ = NULL;
							SudokuCellView* _tmp50_ = NULL;
							SudokuCellView** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp51__length2 = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							SudokuCellView* _tmp54_ = NULL;
							SudokuCellView* _tmp55_ = NULL;
							SudokuCellView* _tmp56_ = NULL;
							GtkGrid* _tmp57_ = NULL;
							SudokuCellView* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_ = g_slice_new0 (Block7Data);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->_ref_count_ = 1;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->_data6_ = block6_data_ref (_data6_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp32_) {
#line 3876 "sudoku-view.c"
								gint _tmp33_ = 0;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp33_ = col;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								col = _tmp33_ + 1;
#line 3882 "sudoku-view.c"
							}
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = FALSE;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = col;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _data6_->game;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = _tmp35_->board;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = sudoku_board_get_cols (_tmp36_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = _tmp37_;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp34_ < _tmp38_)) {
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								block7_data_unref (_data7_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_data7_ = NULL;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3904 "sudoku-view.c"
							}
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = row;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = col;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = sudoku_cell_view_new (_tmp39_, _tmp40_, &self->game);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_object_ref_sink (_tmp41_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cell = _tmp41_;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = row;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->cell_row = _tmp42_;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = col;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->cell_col = _tmp43_;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = cell;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = sudoku_cell_view_get_is_fixed (_tmp45_);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = _tmp46_;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp47_) {
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = SUDOKU_VIEW_fixed_cell_color;
#line 3934 "sudoku-view.c"
							} else {
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = SUDOKU_VIEW_free_cell_color;
#line 3938 "sudoku-view.c"
							}
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp48_ = cell;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp48_, &_tmp44_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp49_ = cell;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-in-event", (GCallback) _________lambda11__gtk_widget_focus_in_event, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp50_ = cell;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GObject*) _tmp50_, "notify::value", (GCallback) _________lambda12__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_ = self->priv->cells;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length1 = self->priv->cells_length1;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length2 = self->priv->cells_length2;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp52_ = row;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp53_ = col;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp54_ = cell;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp55_ = _g_object_ref0 (_tmp54_);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_]);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_] = _tmp55_;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp56_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp57_ = self->priv->grid;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp58_ = cell;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp59_ = col;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp60_ = row;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, _tmp59_, _tmp60_, 1, 1);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (cell);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							block7_data_unref (_data7_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_ = NULL;
#line 3988 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp61_ = self->priv->overlay;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp62_ = self->priv->drawing;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp63_ = self->priv->overlay;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp64_ = self->priv->grid;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp64_);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp65_ = self->priv->drawing;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp65_);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp66_ = self->priv->grid;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp67_ = self->priv->overlay;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp67_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	block6_data_unref (_data6_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = NULL;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 4025 "sudoku-view.c"
}


SudokuView* sudoku_view_new (SudokuGame* game) {
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
#line 4032 "sudoku-view.c"
}


static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c) {
	gboolean result = FALSE;
	gint board_length = 0;
	GtkGrid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble tile_length = 0.0;
	gint _tmp2_ = 0;
	SudokuGame* _tmp3_ = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTextDirection _tmp7_ = 0;
	cairo_t* _tmp48_ = NULL;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp88_ = NULL;
	cairo_t* _tmp89_ = NULL;
	cairo_t* _tmp126_ = NULL;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->grid;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	board_length = _tmp1_;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = board_length;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->game;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _tmp3_->board;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	tile_length = ((gdouble) (_tmp2_ - 1)) / _tmp6_;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = gtk_widget_get_default_direction ();
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_ == GTK_TEXT_DIR_RTL) {
#line 4079 "sudoku-view.c"
		cairo_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		cairo_t* _tmp10_ = NULL;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = c;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = board_length;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_translate (_tmp8_, (gdouble) _tmp9_, (gdouble) 0);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = c;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp10_, (gdouble) (-1), (gdouble) 1);
#line 4093 "sudoku-view.c"
	}
	{
		gint i = 0;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4099 "sudoku-view.c"
		{
			gboolean _tmp11_ = FALSE;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp11_ = TRUE;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4106 "sudoku-view.c"
				gint _tmp13_ = 0;
				SudokuGame* _tmp14_ = NULL;
				SudokuBoard* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp11_) {
#line 4114 "sudoku-view.c"
					gint _tmp12_ = 0;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = i;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp12_ + 1;
#line 4120 "sudoku-view.c"
				}
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = FALSE;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp13_ = i;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = self->game;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp15_ = _tmp14_->board;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp16_ = sudoku_board_get_cols (_tmp15_);
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp17_ = _tmp16_;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp13_ < _tmp17_)) {
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4138 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4144 "sudoku-view.c"
					{
						gboolean _tmp18_ = FALSE;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp18_ = TRUE;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4151 "sudoku-view.c"
							gint _tmp20_ = 0;
							SudokuGame* _tmp21_ = NULL;
							SudokuBoard* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							GdkRGBA background_color = {0};
							SudokuCellView** _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							SudokuCellView* _tmp28_ = NULL;
							GdkRGBA _tmp29_ = {0};
							GdkRGBA _tmp30_ = {0};
							cairo_t* _tmp31_ = NULL;
							GdkRGBA _tmp32_ = {0};
							gdouble _tmp33_ = 0.0;
							GdkRGBA _tmp34_ = {0};
							gdouble _tmp35_ = 0.0;
							GdkRGBA _tmp36_ = {0};
							gdouble _tmp37_ = 0.0;
							cairo_t* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gdouble _tmp40_ = 0.0;
							gint _tmp41_ = 0;
							gdouble _tmp42_ = 0.0;
							gint _tmp43_ = 0;
							gdouble _tmp44_ = 0.0;
							gint _tmp45_ = 0;
							gdouble _tmp46_ = 0.0;
							cairo_t* _tmp47_ = NULL;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp18_) {
#line 4185 "sudoku-view.c"
								gint _tmp19_ = 0;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp19_ = j;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp19_ + 1;
#line 4191 "sudoku-view.c"
							}
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = FALSE;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = j;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = self->game;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = _tmp21_->board;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = sudoku_board_get_cols (_tmp22_);
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = _tmp23_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp20_ < _tmp24_)) {
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4209 "sudoku-view.c"
							}
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = self->priv->cells;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length1 = self->priv->cells_length1;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length2 = self->priv->cells_length2;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = i;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = j;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_get_background_color (_tmp28_, &_tmp29_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = _tmp29_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							background_color = _tmp30_;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = c;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = background_color;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = _tmp32_.red;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = background_color;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _tmp34_.green;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = background_color;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = _tmp36_.blue;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_set_source_rgb (_tmp31_, _tmp33_, _tmp35_, _tmp37_);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = c;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = j;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = tile_length;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = i;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = tile_length;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = j;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp44_ = tile_length;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = i;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = tile_length;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_rectangle (_tmp38_, ((gint) (_tmp39_ * _tmp40_)) + 0.5, ((gint) (_tmp41_ * _tmp42_)) + 0.5, ((gint) ((_tmp43_ + 1) * _tmp44_)) + 0.5, ((gint) ((_tmp45_ + 1) * _tmp46_)) + 0.5);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = c;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_fill (_tmp47_);
#line 4269 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp48_ = c;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_line_width (_tmp48_, (gdouble) 1);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp49_ = c;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp49_, 0.6, 0.6, 0.6);
#line 4284 "sudoku-view.c"
	{
		gint i = 0;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4289 "sudoku-view.c"
		{
			gboolean _tmp50_ = FALSE;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp50_ = TRUE;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4296 "sudoku-view.c"
				gint _tmp52_ = 0;
				SudokuGame* _tmp53_ = NULL;
				SudokuBoard* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				SudokuGame* _tmp58_ = NULL;
				SudokuBoard* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				cairo_t* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gdouble _tmp64_ = 0.0;
				cairo_t* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gdouble _tmp67_ = 0.0;
				gint _tmp68_ = 0;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp50_) {
#line 4316 "sudoku-view.c"
					gint _tmp51_ = 0;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp51_ = i;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp51_ + 1;
#line 4322 "sudoku-view.c"
				}
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp50_ = FALSE;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp52_ = i;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp53_ = self->game;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp54_ = _tmp53_->board;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp55_ = sudoku_board_get_cols (_tmp54_);
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp56_ = _tmp55_;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp52_ < _tmp56_)) {
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4340 "sudoku-view.c"
				}
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp57_ = i;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp58_ = self->game;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp59_ = _tmp58_->board;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp60_ = sudoku_board_get_block_cols (_tmp59_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp61_ = _tmp60_;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp57_ % _tmp61_) == 0) {
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4356 "sudoku-view.c"
				}
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp62_ = c;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp63_ = i;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp64_ = tile_length;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp62_, ((gint) (_tmp63_ * _tmp64_)) + 0.5, (gdouble) 1);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp65_ = c;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp66_ = i;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp67_ = tile_length;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp68_ = board_length;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp65_, ((gint) (_tmp66_ * _tmp67_)) + 0.5, (gdouble) _tmp68_);
#line 4376 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4384 "sudoku-view.c"
		{
			gboolean _tmp69_ = FALSE;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = TRUE;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4391 "sudoku-view.c"
				gint _tmp71_ = 0;
				SudokuGame* _tmp72_ = NULL;
				SudokuBoard* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				SudokuGame* _tmp77_ = NULL;
				SudokuBoard* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				cairo_t* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gdouble _tmp83_ = 0.0;
				cairo_t* _tmp84_ = NULL;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gdouble _tmp87_ = 0.0;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp69_) {
#line 4411 "sudoku-view.c"
					gint _tmp70_ = 0;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp70_ = i;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp70_ + 1;
#line 4417 "sudoku-view.c"
				}
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp69_ = FALSE;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp71_ = i;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp72_ = self->game;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp73_ = _tmp72_->board;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp74_ = sudoku_board_get_cols (_tmp73_);
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp75_ = _tmp74_;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp71_ < _tmp75_)) {
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4435 "sudoku-view.c"
				}
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp76_ = i;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp77_ = self->game;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp78_ = _tmp77_->board;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp79_ = sudoku_board_get_block_rows (_tmp78_);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp80_ = _tmp79_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp76_ % _tmp80_) == 0) {
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4451 "sudoku-view.c"
				}
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp81_ = c;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp82_ = i;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp83_ = tile_length;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp81_, (gdouble) 1, ((gint) (_tmp82_ * _tmp83_)) + 0.5);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp84_ = c;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp85_ = board_length;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp86_ = i;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp87_ = tile_length;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp84_, (gdouble) _tmp85_, ((gint) (_tmp86_ * _tmp87_)) + 0.5);
#line 4471 "sudoku-view.c"
			}
		}
	}
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp88_ = c;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp88_);
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp89_ = c;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp89_, 0.0, 0.0, 0.0);
#line 4483 "sudoku-view.c"
	{
		gint i = 0;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4488 "sudoku-view.c"
		{
			gboolean _tmp90_ = FALSE;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = TRUE;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4495 "sudoku-view.c"
				gint _tmp96_ = 0;
				SudokuGame* _tmp97_ = NULL;
				SudokuBoard* _tmp98_ = NULL;
				gint _tmp99_ = 0;
				gint _tmp100_ = 0;
				cairo_t* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				gdouble _tmp103_ = 0.0;
				cairo_t* _tmp104_ = NULL;
				gint _tmp105_ = 0;
				gdouble _tmp106_ = 0.0;
				gint _tmp107_ = 0;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp90_) {
#line 4510 "sudoku-view.c"
					gint _tmp91_ = 0;
					SudokuGame* _tmp92_ = NULL;
					SudokuBoard* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp91_ = i;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp92_ = self->game;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp93_ = _tmp92_->board;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp94_ = sudoku_board_get_block_cols (_tmp93_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp95_ = _tmp94_;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp91_ + _tmp95_;
#line 4528 "sudoku-view.c"
				}
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp90_ = FALSE;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = i;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = self->game;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp98_ = _tmp97_->board;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp99_ = sudoku_board_get_cols (_tmp98_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp100_ = _tmp99_;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp96_ <= _tmp100_)) {
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4546 "sudoku-view.c"
				}
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp101_ = c;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp102_ = i;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp103_ = tile_length;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp101_, ((gint) (_tmp102_ * _tmp103_)) + 0.5, (gdouble) 0);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp104_ = c;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp105_ = i;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp106_ = tile_length;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp107_ = board_length;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp104_, ((gint) (_tmp105_ * _tmp106_)) + 0.5, (gdouble) _tmp107_);
#line 4566 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4574 "sudoku-view.c"
		{
			gboolean _tmp108_ = FALSE;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp108_ = TRUE;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4581 "sudoku-view.c"
				gint _tmp114_ = 0;
				SudokuGame* _tmp115_ = NULL;
				SudokuBoard* _tmp116_ = NULL;
				gint _tmp117_ = 0;
				gint _tmp118_ = 0;
				cairo_t* _tmp119_ = NULL;
				gint _tmp120_ = 0;
				gdouble _tmp121_ = 0.0;
				cairo_t* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gint _tmp124_ = 0;
				gdouble _tmp125_ = 0.0;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp108_) {
#line 4596 "sudoku-view.c"
					gint _tmp109_ = 0;
					SudokuGame* _tmp110_ = NULL;
					SudokuBoard* _tmp111_ = NULL;
					gint _tmp112_ = 0;
					gint _tmp113_ = 0;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = i;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp110_ = self->game;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp111_ = _tmp110_->board;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp112_ = sudoku_board_get_block_rows (_tmp111_);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp113_ = _tmp112_;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp109_ + _tmp113_;
#line 4614 "sudoku-view.c"
				}
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp108_ = FALSE;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp114_ = i;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp115_ = self->game;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp116_ = _tmp115_->board;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp117_ = sudoku_board_get_cols (_tmp116_);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp118_ = _tmp117_;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp114_ <= _tmp118_)) {
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4632 "sudoku-view.c"
				}
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp119_ = c;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp120_ = i;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp121_ = tile_length;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp119_, (gdouble) 0, ((gint) (_tmp120_ * _tmp121_)) + 0.5);
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp122_ = c;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp123_ = board_length;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp124_ = i;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp125_ = tile_length;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp122_, (gdouble) _tmp123_, ((gint) (_tmp124_ * _tmp125_)) + 0.5);
#line 4652 "sudoku-view.c"
			}
		}
	}
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp126_ = c;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp126_);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4664 "sudoku-view.c"
}


void sudoku_view_clear (SudokuView* self) {
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 4671 "sudoku-view.c"
	{
		gint i = 0;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4676 "sudoku-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp0_ = TRUE;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4683 "sudoku-view.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp0_) {
#line 4691 "sudoku-view.c"
					gint _tmp1_ = 0;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = i;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp1_ + 1;
#line 4697 "sudoku-view.c"
				}
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp0_ = FALSE;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp2_ = i;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = self->game;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = _tmp3_->board;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = _tmp5_;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4715 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4721 "sudoku-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp7_ = TRUE;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4728 "sudoku-view.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuCellView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							SudokuCellView* _tmp17_ = NULL;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp7_) {
#line 4742 "sudoku-view.c"
								gint _tmp8_ = 0;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp8_ = j;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp8_ + 1;
#line 4748 "sudoku-view.c"
							}
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp7_ = FALSE;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp9_ = j;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = self->game;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = _tmp10_->board;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = _tmp12_;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4766 "sudoku-view.c"
							}
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = self->priv->cells;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length1 = self->priv->cells_length1;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length2 = self->priv->cells_length2;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = i;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = j;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_clear (_tmp17_);
#line 4782 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
}


gboolean sudoku_view_get_show_warnings (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4803 "sudoku-view.c"
}


void sudoku_view_set_show_warnings (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 4815 "sudoku-view.c"
	{
		gint i = 0;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4820 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4827 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 4835 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 4841 "sudoku-view.c"
				}
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4859 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4865 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4872 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 4887 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 4893 "sudoku-view.c"
							}
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4911 "sudoku-view.c"
							}
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = self->priv->_show_warnings;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_warnings (_tmp18_, _tmp19_);
#line 4929 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 4938 "sudoku-view.c"
}


gboolean sudoku_view_get_show_possibilities (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4953 "sudoku-view.c"
}


void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 4965 "sudoku-view.c"
	{
		gint i = 0;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4970 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4977 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 4985 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 4991 "sudoku-view.c"
				}
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 5009 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 5015 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 5022 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 5037 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 5043 "sudoku-view.c"
							}
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5061 "sudoku-view.c"
							}
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = value;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_possibilities (_tmp18_, _tmp19_);
#line 5079 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 5088 "sudoku-view.c"
}


gboolean sudoku_view_get_highlighter (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_highlighter;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5103 "sudoku-view.c"
}


void sudoku_view_set_highlighter (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = _tmp0_;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "highlighter");
#line 5117 "sudoku-view.c"
}


static void sudoku_view_class_init (SudokuViewClass * klass) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER, g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5138 "sudoku-view.c"
}


static void sudoku_view_instance_init (SudokuView * self) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->previous_board_broken_state = FALSE;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = 0;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = 0;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = FALSE;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = FALSE;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = FALSE;
#line 5157 "sudoku-view.c"
}


static void sudoku_view_finalize (GObject* obj) {
	SudokuView * self;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
#line 5177 "sudoku-view.c"
}


GType sudoku_view_get_type (void) {
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5216 "sudoku-view.c"
		default:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5222 "sudoku-view.c"
	}
}


static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5250 "sudoku-view.c"
		default:
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5256 "sudoku-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



