/* sudoku-saver.c generated by valac 0.25.4.4-19ea, the Vala compiler
 * generated from sudoku-saver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_saver_parent_class = NULL;
static gchar* sudoku_saver__savegame_file;
static gchar* sudoku_saver__savegame_file = NULL;
static gchar* sudoku_saver__finishgame_dir;
static gchar* sudoku_saver__finishgame_dir = NULL;

GType sudoku_saver_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_SAVER_DUMMY_PROPERTY
};
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
const gchar* sudoku_saver_get_savegame_file (void);
static void sudoku_saver_set_savegame_file (const gchar* value);
const gchar* sudoku_saver_get_finishgame_dir (void);
static void sudoku_saver_set_finishgame_dir (const gchar* value);
GType sudoku_game_get_type (void) G_GNUC_CONST;
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path);
void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game);
static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name);
void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame);
GType sudoku_board_get_type (void) G_GNUC_CONST;
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit);
static void _vala_array_add1 (gint** array, int* length, int* size, gint value);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void _vala_JsonNode_free (JsonNode* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
DifficultyCategory difficulty_category_from_string (const gchar* input);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
static void sudoku_saver_finalize (GObject* obj);
static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


SudokuSaver* sudoku_saver_construct (GType object_type) {
	SudokuSaver * self = NULL;
	GError * _inner_error_ = NULL;
	self = (SudokuSaver*) g_object_new (object_type, NULL);
	{
		gchar* config_dir = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* sudoku_data_dir = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp0_ = g_get_user_data_dir ();
		_tmp1_ = g_strdup (_tmp0_);
		config_dir = _tmp1_;
		_tmp2_ = config_dir;
		_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "gnome-sudoku", NULL);
		sudoku_data_dir = _tmp3_;
		_tmp4_ = sudoku_saver_get_savegame_file ();
		_tmp5_ = _tmp4_;
		_tmp6_ = sudoku_data_dir;
		_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, "savefile", NULL);
		_tmp8_ = _tmp7_;
		sudoku_saver_set_savegame_file (_tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = sudoku_saver_get_finishgame_dir ();
		_tmp10_ = _tmp9_;
		_tmp11_ = sudoku_data_dir;
		_tmp12_ = g_build_path (G_DIR_SEPARATOR_S, _tmp11_, "finished", NULL);
		_tmp13_ = _tmp12_;
		sudoku_saver_set_finishgame_dir (_tmp13_);
		_g_free0 (_tmp13_);
		{
			GFile* file = NULL;
			const gchar* _tmp14_ = NULL;
			GFile* _tmp15_ = NULL;
			GFile* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GFile* _tmp21_ = NULL;
			GFile* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			_tmp14_ = sudoku_data_dir;
			_tmp15_ = g_file_new_for_path (_tmp14_);
			file = _tmp15_;
			_tmp16_ = file;
			_tmp17_ = g_file_query_exists (_tmp16_, NULL);
			if (!_tmp17_) {
				GFile* _tmp18_ = NULL;
				_tmp18_ = file;
				g_file_make_directory (_tmp18_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (sudoku_data_dir);
					_g_free0 (config_dir);
					goto __catch0_g_error;
				}
			}
			_tmp19_ = sudoku_saver_get_finishgame_dir ();
			_tmp20_ = _tmp19_;
			_tmp21_ = g_file_new_for_path (_tmp20_);
			_g_object_unref0 (file);
			file = _tmp21_;
			_tmp22_ = file;
			_tmp23_ = g_file_query_exists (_tmp22_, NULL);
			if (!_tmp23_) {
				GFile* _tmp24_ = NULL;
				_tmp24_ = file;
				g_file_make_directory (_tmp24_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (sudoku_data_dir);
					_g_free0 (config_dir);
					goto __catch0_g_error;
				}
			}
			_g_object_unref0 (file);
		}
		_g_free0 (sudoku_data_dir);
		_g_free0 (config_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("sudoku-saver.vala:28: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


SudokuSaver* sudoku_saver_new (void) {
	return sudoku_saver_construct (TYPE_SUDOKU_SAVER);
}


SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self) {
	SudokuGame* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	if (!_tmp4_) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	}
	_tmp5_ = sudoku_saver_get_savegame_file ();
	_tmp6_ = _tmp5_;
	_tmp7_ = sudoku_saver_parse_json_to_game (self, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (file);
	return result;
}


void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game) {
	SudokuGame* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game;
	_tmp1_ = sudoku_saver_get_savegame_file ();
	_tmp2_ = _tmp1_;
	sudoku_saver_create_file_for_game (self, _tmp0_, _tmp2_);
}


void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame) {
	gchar* file_name = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* file_path = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = sudoku_board_to_string (_tmp1_, TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".save", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file_name = _tmp5_;
	_tmp6_ = sudoku_saver_get_finishgame_dir ();
	_tmp7_ = _tmp6_;
	_tmp8_ = file_name;
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp7_, _tmp8_, NULL);
	file_path = _tmp9_;
	_tmp10_ = game;
	_tmp11_ = file_path;
	sudoku_saver_create_file_for_game (self, _tmp10_, _tmp11_);
	_tmp12_ = delete_savegame;
	if (_tmp12_) {
		GFile* file = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp13_ = sudoku_saver_get_savegame_file ();
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		file = _tmp15_;
		_tmp16_ = file;
		_tmp17_ = g_file_query_exists (_tmp16_, NULL);
		if (_tmp17_) {
			{
				GFile* _tmp18_ = NULL;
				_tmp18_ = file;
				g_file_delete (_tmp18_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GFile* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp19_ = file;
				_tmp20_ = g_file_get_uri (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("sudoku-saver.vala:64: Failed to delete %s: %s", _tmp21_, _tmp23_);
				_g_free0 (_tmp21_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (file_path);
				_g_free0 (file_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (file);
	}
	_g_free0 (file_path);
	_g_free0 (file_name);
}


static void sudoku_saver_create_file_for_game (SudokuSaver* self, SudokuGame* game, const gchar* file_name) {
	gchar* json_str = NULL;
	SudokuGame* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (file_name != NULL);
	_tmp0_ = game;
	_tmp1_ = sudoku_saver_serialize_game_to_json (self, _tmp0_);
	json_str = _tmp1_;
	{
		const gchar* _tmp2_ = NULL;
		_tmp2_ = file_name;
		g_file_set_contents (_tmp2_, json_str, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("sudoku-saver.vala:77: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (json_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (json_str);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self, SudokuGame* game) {
	gchar* result = NULL;
	SudokuBoard* board = NULL;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	SudokuBoard* _tmp2_ = NULL;
	gint* board_cells = NULL;
	SudokuBoard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint board_cells_length1 = 0;
	gint board_cells_length2 = 0;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp7_ = NULL;
	JsonBuilder* _tmp8_ = NULL;
	JsonBuilder* _tmp9_ = NULL;
	JsonBuilder* _tmp10_ = NULL;
	SudokuBoard* _tmp11_ = NULL;
	DifficultyCategory _tmp12_ = 0;
	DifficultyCategory _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	JsonBuilder* _tmp16_ = NULL;
	JsonBuilder* _tmp17_ = NULL;
	SudokuGame* _tmp18_ = NULL;
	gdouble _tmp19_ = 0.0;
	JsonBuilder* _tmp20_ = NULL;
	JsonBuilder* _tmp21_ = NULL;
	JsonBuilder* _tmp82_ = NULL;
	JsonBuilder* _tmp83_ = NULL;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp84_ = NULL;
	JsonNode* root = NULL;
	JsonBuilder* _tmp85_ = NULL;
	JsonNode* _tmp86_ = NULL;
	gchar* _tmp87_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	board = _tmp2_;
	_tmp3_ = board;
	_tmp6_ = sudoku_board_get_cells (_tmp3_, &_tmp4_, &_tmp5_);
	board_cells = _tmp6_;
	board_cells_length1 = _tmp4_;
	board_cells_length2 = _tmp5_;
	_tmp7_ = json_builder_new ();
	builder = _tmp7_;
	_tmp8_ = builder;
	json_builder_begin_object (_tmp8_);
	_tmp9_ = builder;
	json_builder_set_member_name (_tmp9_, "difficulty_category");
	_tmp10_ = builder;
	_tmp11_ = board;
	_tmp12_ = sudoku_board_get_difficulty_category (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = difficulty_category_to_untranslated_string (_tmp13_);
	_tmp15_ = _tmp14_;
	json_builder_add_string_value (_tmp10_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = builder;
	json_builder_set_member_name (_tmp16_, "time_elapsed");
	_tmp17_ = builder;
	_tmp18_ = game;
	_tmp19_ = sudoku_game_get_total_time_played (_tmp18_);
	json_builder_add_double_value (_tmp17_, _tmp19_);
	_tmp20_ = builder;
	json_builder_set_member_name (_tmp20_, "cells");
	_tmp21_ = builder;
	json_builder_begin_array (_tmp21_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				SudokuBoard* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = board;
				_tmp26_ = sudoku_board_get_rows (_tmp25_);
				_tmp27_ = _tmp26_;
				if (!(_tmp24_ < _tmp27_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							gint _tmp30_ = 0;
							SudokuBoard* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint* earmarks = NULL;
							gint* _tmp34_ = NULL;
							gint earmarks_length1 = 0;
							gint _earmarks_size_ = 0;
							gboolean _tmp48_ = FALSE;
							gint* _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							gint _tmp49__length2 = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							JsonBuilder* _tmp54_ = NULL;
							JsonBuilder* _tmp55_ = NULL;
							JsonBuilder* _tmp56_ = NULL;
							JsonBuilder* _tmp57_ = NULL;
							gint _tmp58_ = 0;
							JsonBuilder* _tmp59_ = NULL;
							gint _tmp60_ = 0;
							JsonBuilder* _tmp61_ = NULL;
							JsonBuilder* _tmp62_ = NULL;
							JsonBuilder* _tmp63_ = NULL;
							gint* _tmp64_ = NULL;
							gint _tmp64__length1 = 0;
							gint _tmp64__length2 = 0;
							gint _tmp65_ = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							JsonBuilder* _tmp68_ = NULL;
							JsonBuilder* _tmp69_ = NULL;
							SudokuBoard* _tmp70_ = NULL;
							gboolean* _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							gint _tmp71__length2 = 0;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							gboolean _tmp74_ = FALSE;
							JsonBuilder* _tmp75_ = NULL;
							JsonBuilder* _tmp76_ = NULL;
							gint* _tmp77_ = NULL;
							gint _tmp77__length1 = 0;
							JsonBuilder* _tmp80_ = NULL;
							JsonBuilder* _tmp81_ = NULL;
							if (!_tmp28_) {
								gint _tmp29_ = 0;
								_tmp29_ = j;
								j = _tmp29_ + 1;
							}
							_tmp28_ = FALSE;
							_tmp30_ = j;
							_tmp31_ = board;
							_tmp32_ = sudoku_board_get_cols (_tmp31_);
							_tmp33_ = _tmp32_;
							if (!(_tmp30_ < _tmp33_)) {
								break;
							}
							_tmp34_ = g_new0 (gint, 0);
							earmarks = _tmp34_;
							earmarks_length1 = 0;
							_earmarks_size_ = earmarks_length1;
							{
								gint k = 0;
								k = 1;
								{
									gboolean _tmp35_ = FALSE;
									_tmp35_ = TRUE;
									while (TRUE) {
										gint _tmp37_ = 0;
										SudokuBoard* _tmp38_ = NULL;
										gint _tmp39_ = 0;
										gint _tmp40_ = 0;
										SudokuBoard* _tmp41_ = NULL;
										gint _tmp42_ = 0;
										gint _tmp43_ = 0;
										gint _tmp44_ = 0;
										gboolean _tmp45_ = FALSE;
										if (!_tmp35_) {
											gint _tmp36_ = 0;
											_tmp36_ = k;
											k = _tmp36_ + 1;
										}
										_tmp35_ = FALSE;
										_tmp37_ = k;
										_tmp38_ = board;
										_tmp39_ = sudoku_board_get_max_val (_tmp38_);
										_tmp40_ = _tmp39_;
										if (!(_tmp37_ <= _tmp40_)) {
											break;
										}
										_tmp41_ = board;
										_tmp42_ = i;
										_tmp43_ = j;
										_tmp44_ = k;
										_tmp45_ = sudoku_board_is_earmark_enabled (_tmp41_, _tmp42_, _tmp43_, _tmp44_);
										if (_tmp45_) {
											gint* _tmp46_ = NULL;
											gint _tmp46__length1 = 0;
											gint _tmp47_ = 0;
											_tmp46_ = earmarks;
											_tmp46__length1 = earmarks_length1;
											_tmp47_ = k;
											_vala_array_add1 (&earmarks, &earmarks_length1, &_earmarks_size_, _tmp47_);
										}
									}
								}
							}
							_tmp49_ = board_cells;
							_tmp49__length1 = board_cells_length1;
							_tmp49__length2 = board_cells_length2;
							_tmp50_ = i;
							_tmp51_ = j;
							_tmp52_ = _tmp49_[(_tmp50_ * _tmp49__length2) + _tmp51_];
							if (_tmp52_ == 0) {
								gint* _tmp53_ = NULL;
								gint _tmp53__length1 = 0;
								_tmp53_ = earmarks;
								_tmp53__length1 = earmarks_length1;
								_tmp48_ = _tmp53__length1 == 0;
							} else {
								_tmp48_ = FALSE;
							}
							if (_tmp48_) {
								earmarks = (g_free (earmarks), NULL);
								continue;
							}
							_tmp54_ = builder;
							json_builder_begin_object (_tmp54_);
							_tmp55_ = builder;
							json_builder_set_member_name (_tmp55_, "position");
							_tmp56_ = builder;
							json_builder_begin_array (_tmp56_);
							_tmp57_ = builder;
							_tmp58_ = i;
							json_builder_add_int_value (_tmp57_, (gint64) _tmp58_);
							_tmp59_ = builder;
							_tmp60_ = j;
							json_builder_add_int_value (_tmp59_, (gint64) _tmp60_);
							_tmp61_ = builder;
							json_builder_end_array (_tmp61_);
							_tmp62_ = builder;
							json_builder_set_member_name (_tmp62_, "value");
							_tmp63_ = builder;
							_tmp64_ = board_cells;
							_tmp64__length1 = board_cells_length1;
							_tmp64__length2 = board_cells_length2;
							_tmp65_ = i;
							_tmp66_ = j;
							_tmp67_ = _tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_];
							json_builder_add_int_value (_tmp63_, (gint64) _tmp67_);
							_tmp68_ = builder;
							json_builder_set_member_name (_tmp68_, "fixed");
							_tmp69_ = builder;
							_tmp70_ = board;
							_tmp71_ = _tmp70_->is_fixed;
							_tmp71__length1 = _tmp70_->is_fixed_length1;
							_tmp71__length2 = _tmp70_->is_fixed_length2;
							_tmp72_ = i;
							_tmp73_ = j;
							_tmp74_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
							json_builder_add_boolean_value (_tmp69_, _tmp74_);
							_tmp75_ = builder;
							json_builder_set_member_name (_tmp75_, "earmarks");
							_tmp76_ = builder;
							json_builder_begin_array (_tmp76_);
							_tmp77_ = earmarks;
							_tmp77__length1 = earmarks_length1;
							{
								gint* k_collection = NULL;
								gint k_collection_length1 = 0;
								gint _k_collection_size_ = 0;
								gint k_it = 0;
								k_collection = _tmp77_;
								k_collection_length1 = _tmp77__length1;
								for (k_it = 0; k_it < _tmp77__length1; k_it = k_it + 1) {
									gint k = 0;
									k = k_collection[k_it];
									{
										JsonBuilder* _tmp78_ = NULL;
										gint _tmp79_ = 0;
										_tmp78_ = builder;
										_tmp79_ = k;
										json_builder_add_int_value (_tmp78_, (gint64) _tmp79_);
									}
								}
							}
							_tmp80_ = builder;
							json_builder_end_array (_tmp80_);
							_tmp81_ = builder;
							json_builder_end_object (_tmp81_);
							earmarks = (g_free (earmarks), NULL);
						}
					}
				}
			}
		}
	}
	_tmp82_ = builder;
	json_builder_end_array (_tmp82_);
	_tmp83_ = builder;
	json_builder_end_object (_tmp83_);
	_tmp84_ = json_generator_new ();
	generator = _tmp84_;
	json_generator_set_pretty (generator, TRUE);
	_tmp85_ = builder;
	_tmp86_ = json_builder_get_root (_tmp85_);
	root = _tmp86_;
	json_generator_set_root (generator, root);
	_tmp87_ = json_generator_to_data (generator, NULL);
	result = _tmp87_;
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_object_unref0 (builder);
	board_cells = (g_free (board_cells), NULL);
	_g_object_unref0 (board);
	return result;
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self, const gchar* file_path) {
	SudokuGame* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_ = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp3_ = NULL;
	JsonNode* node = NULL;
	JsonParser* _tmp4_ = NULL;
	JsonNode* _tmp5_ = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonReader* reader = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonReader* _tmp8_ = NULL;
	JsonReader* _tmp9_ = NULL;
	JsonReader* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonReader* _tmp75_ = NULL;
	JsonReader* _tmp76_ = NULL;
	JsonReader* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	SudokuBoard* _tmp79_ = NULL;
	JsonReader* _tmp80_ = NULL;
	gdouble _tmp81_ = 0.0;
	JsonReader* _tmp82_ = NULL;
	JsonReader* _tmp83_ = NULL;
	JsonReader* _tmp84_ = NULL;
	gboolean _tmp85_ = FALSE;
	SudokuBoard* _tmp86_ = NULL;
	JsonReader* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	DifficultyCategory _tmp89_ = 0;
	JsonReader* _tmp90_ = NULL;
	SudokuBoard* _tmp91_ = NULL;
	SudokuGame* _tmp92_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		JsonParser* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = parser;
		_tmp2_ = file_path;
		json_parser_load_from_file (_tmp1_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = sudoku_board_new (3, 3);
	board = _tmp3_;
	_tmp4_ = parser;
	_tmp5_ = json_parser_get_root (_tmp4_);
	_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
	node = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = json_reader_new (_tmp7_);
	reader = _tmp8_;
	_tmp9_ = reader;
	json_reader_read_member (_tmp9_, "cells");
	_tmp10_ = reader;
	_tmp11_ = json_reader_is_array (_tmp10_);
	g_return_val_if_fail (_tmp11_, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				JsonReader* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				JsonReader* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				JsonReader* _tmp19_ = NULL;
				JsonReader* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				JsonReader* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				JsonReader* _tmp24_ = NULL;
				JsonReader* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gint row = 0;
				JsonReader* _tmp27_ = NULL;
				gint64 _tmp28_ = 0LL;
				JsonReader* _tmp29_ = NULL;
				JsonReader* _tmp30_ = NULL;
				JsonReader* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				gint col = 0;
				JsonReader* _tmp33_ = NULL;
				gint64 _tmp34_ = 0LL;
				JsonReader* _tmp35_ = NULL;
				JsonReader* _tmp36_ = NULL;
				JsonReader* _tmp37_ = NULL;
				JsonReader* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				gint val = 0;
				JsonReader* _tmp40_ = NULL;
				gint64 _tmp41_ = 0LL;
				JsonReader* _tmp42_ = NULL;
				JsonReader* _tmp43_ = NULL;
				JsonReader* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				gboolean is_fixed = FALSE;
				JsonReader* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				JsonReader* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				JsonReader* _tmp55_ = NULL;
				JsonReader* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
				JsonReader* _tmp73_ = NULL;
				JsonReader* _tmp74_ = NULL;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = reader;
				_tmp16_ = json_reader_count_elements (_tmp15_);
				if (!(_tmp14_ < _tmp16_)) {
					break;
				}
				_tmp17_ = reader;
				_tmp18_ = i;
				json_reader_read_element (_tmp17_, (guint) _tmp18_);
				_tmp19_ = reader;
				json_reader_read_member (_tmp19_, "position");
				_tmp20_ = reader;
				_tmp21_ = json_reader_is_array (_tmp20_);
				g_return_val_if_fail (_tmp21_, NULL);
				_tmp22_ = reader;
				_tmp23_ = json_reader_count_elements (_tmp22_);
				g_return_val_if_fail (_tmp23_ == 2, NULL);
				_tmp24_ = reader;
				json_reader_read_element (_tmp24_, (guint) 0);
				_tmp25_ = reader;
				_tmp26_ = json_reader_is_value (_tmp25_);
				g_return_val_if_fail (_tmp26_, NULL);
				_tmp27_ = reader;
				_tmp28_ = json_reader_get_int_value (_tmp27_);
				row = (gint) _tmp28_;
				_tmp29_ = reader;
				json_reader_end_element (_tmp29_);
				_tmp30_ = reader;
				json_reader_read_element (_tmp30_, (guint) 1);
				_tmp31_ = reader;
				_tmp32_ = json_reader_is_value (_tmp31_);
				g_return_val_if_fail (_tmp32_, NULL);
				_tmp33_ = reader;
				_tmp34_ = json_reader_get_int_value (_tmp33_);
				col = (gint) _tmp34_;
				_tmp35_ = reader;
				json_reader_end_element (_tmp35_);
				_tmp36_ = reader;
				json_reader_end_member (_tmp36_);
				_tmp37_ = reader;
				json_reader_read_member (_tmp37_, "value");
				_tmp38_ = reader;
				_tmp39_ = json_reader_is_value (_tmp38_);
				g_return_val_if_fail (_tmp39_, NULL);
				_tmp40_ = reader;
				_tmp41_ = json_reader_get_int_value (_tmp40_);
				val = (gint) _tmp41_;
				_tmp42_ = reader;
				json_reader_end_member (_tmp42_);
				_tmp43_ = reader;
				json_reader_read_member (_tmp43_, "fixed");
				_tmp44_ = reader;
				_tmp45_ = json_reader_is_value (_tmp44_);
				g_return_val_if_fail (_tmp45_, NULL);
				_tmp46_ = reader;
				_tmp47_ = json_reader_get_boolean_value (_tmp46_);
				is_fixed = _tmp47_;
				_tmp48_ = reader;
				json_reader_end_member (_tmp48_);
				_tmp49_ = val;
				if (_tmp49_ != 0) {
					SudokuBoard* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
					gboolean _tmp54_ = FALSE;
					_tmp50_ = board;
					_tmp51_ = row;
					_tmp52_ = col;
					_tmp53_ = val;
					_tmp54_ = is_fixed;
					sudoku_board_insert (_tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_);
				}
				_tmp55_ = reader;
				json_reader_read_member (_tmp55_, "earmarks");
				_tmp56_ = reader;
				_tmp57_ = json_reader_is_array (_tmp56_);
				g_return_val_if_fail (_tmp57_, NULL);
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp58_ = FALSE;
						_tmp58_ = TRUE;
						while (TRUE) {
							gint _tmp60_ = 0;
							JsonReader* _tmp61_ = NULL;
							gint _tmp62_ = 0;
							JsonReader* _tmp63_ = NULL;
							gint _tmp64_ = 0;
							JsonReader* _tmp65_ = NULL;
							gboolean _tmp66_ = FALSE;
							SudokuBoard* _tmp67_ = NULL;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							JsonReader* _tmp70_ = NULL;
							gint64 _tmp71_ = 0LL;
							JsonReader* _tmp72_ = NULL;
							if (!_tmp58_) {
								gint _tmp59_ = 0;
								_tmp59_ = k;
								k = _tmp59_ + 1;
							}
							_tmp58_ = FALSE;
							_tmp60_ = k;
							_tmp61_ = reader;
							_tmp62_ = json_reader_count_elements (_tmp61_);
							if (!(_tmp60_ < _tmp62_)) {
								break;
							}
							_tmp63_ = reader;
							_tmp64_ = k;
							json_reader_read_element (_tmp63_, (guint) _tmp64_);
							_tmp65_ = reader;
							_tmp66_ = json_reader_is_value (_tmp65_);
							g_return_val_if_fail (_tmp66_, NULL);
							_tmp67_ = board;
							_tmp68_ = row;
							_tmp69_ = col;
							_tmp70_ = reader;
							_tmp71_ = json_reader_get_int_value (_tmp70_);
							sudoku_board_enable_earmark (_tmp67_, _tmp68_, _tmp69_, (gint) _tmp71_);
							_tmp72_ = reader;
							json_reader_end_element (_tmp72_);
						}
					}
				}
				_tmp73_ = reader;
				json_reader_end_member (_tmp73_);
				_tmp74_ = reader;
				json_reader_end_element (_tmp74_);
			}
		}
	}
	_tmp75_ = reader;
	json_reader_end_member (_tmp75_);
	_tmp76_ = reader;
	json_reader_read_member (_tmp76_, "time_elapsed");
	_tmp77_ = reader;
	_tmp78_ = json_reader_is_value (_tmp77_);
	g_return_val_if_fail (_tmp78_, NULL);
	_tmp79_ = board;
	_tmp80_ = reader;
	_tmp81_ = json_reader_get_double_value (_tmp80_);
	sudoku_board_set_previous_played_time (_tmp79_, _tmp81_);
	_tmp82_ = reader;
	json_reader_end_member (_tmp82_);
	_tmp83_ = reader;
	json_reader_read_member (_tmp83_, "difficulty_category");
	_tmp84_ = reader;
	_tmp85_ = json_reader_is_value (_tmp84_);
	g_return_val_if_fail (_tmp85_, NULL);
	_tmp86_ = board;
	_tmp87_ = reader;
	_tmp88_ = json_reader_get_string_value (_tmp87_);
	_tmp89_ = difficulty_category_from_string (_tmp88_);
	sudoku_board_set_difficulty_category (_tmp86_, _tmp89_);
	_tmp90_ = reader;
	json_reader_end_member (_tmp90_);
	_tmp91_ = board;
	_tmp92_ = sudoku_game_new (_tmp91_);
	result = _tmp92_;
	_g_object_unref0 (reader);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (board);
	_g_object_unref0 (parser);
	return result;
}


const gchar* sudoku_saver_get_savegame_file (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = sudoku_saver__savegame_file;
	result = _tmp0_;
	return result;
}


static void sudoku_saver_set_savegame_file (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (sudoku_saver__savegame_file);
	sudoku_saver__savegame_file = _tmp1_;
}


const gchar* sudoku_saver_get_finishgame_dir (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = sudoku_saver__finishgame_dir;
	result = _tmp0_;
	return result;
}


static void sudoku_saver_set_finishgame_dir (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (sudoku_saver__finishgame_dir);
	sudoku_saver__finishgame_dir = _tmp1_;
}


static void sudoku_saver_class_init (SudokuSaverClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	sudoku_saver_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_saver_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_saver_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_saver_finalize;
	_tmp0_ = g_strdup ("");
	sudoku_saver__savegame_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	sudoku_saver__finishgame_dir = _tmp1_;
}


static void sudoku_saver_instance_init (SudokuSaver * self) {
}


static void sudoku_saver_finalize (GObject* obj) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SAVER, SudokuSaver);
	G_OBJECT_CLASS (sudoku_saver_parent_class)->finalize (obj);
}


GType sudoku_saver_get_type (void) {
	static volatile gsize sudoku_saver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_saver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSaver), 0, (GInstanceInitFunc) sudoku_saver_instance_init, NULL };
		GType sudoku_saver_type_id;
		sudoku_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSaver", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_saver_type_id__volatile, sudoku_saver_type_id);
	}
	return sudoku_saver_type_id__volatile;
}


static void _vala_sudoku_saver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_saver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



