/* rygel-http-item-uri-test.c generated by valac 0.24.0.112-bbf5, the Vala compiler
 * generated from rygel-http-item-uri-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_IS_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemClass RygelVisualItemClass;
typedef struct _RygelVisualItemPrivate RygelVisualItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_ITEM_URI_TEST (rygel_http_item_uri_test_get_type ())
#define RYGEL_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITest))
#define RYGEL_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))
#define RYGEL_IS_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_IS_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_HTTP_ITEM_URI_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))

typedef struct _RygelHTTPItemURITest RygelHTTPItemURITest;
typedef struct _RygelHTTPItemURITestClass RygelHTTPItemURITestClass;
typedef struct _RygelHTTPItemURITestPrivate RygelHTTPItemURITestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
};

struct _RygelTranscoderPrivate {
	gchar* _extension;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	GeeArrayList* uris;
	gchar* mime_type;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelVisualItem {
	RygelMediaItem parent_instance;
	RygelVisualItemPrivate * priv;
	GeeArrayList* thumbnails;
};

struct _RygelVisualItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelVideoItem {
	RygelVisualItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelVisualItemClass parent_class;
};

struct _RygelMusicItem {
	RygelMediaItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelHTTPItemURITest {
	GObject parent_instance;
	RygelHTTPItemURITestPrivate * priv;
};

struct _RygelHTTPItemURITestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURITestPrivate {
	RygelVisualItem* item;
	RygelHTTPServer* server;
};


static gpointer rygel_transcoder_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_visual_item_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_http_item_uri_test_parent_class = NULL;

GQuark rygel_http_request_error_quark (void);
GQuark rygel_test_error_quark (void);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_EXTENSION
};
RygelTranscoder* rygel_transcoder_new (const gchar* extension);
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension);
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/Test"
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value);
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_object_finalize (GObject* obj);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
GeeArrayList* rygel_media_item_get_uris (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VISUAL_ITEM_DUMMY_PROPERTY
};
RygelVisualItem* rygel_visual_item_new (void);
RygelVisualItem* rygel_visual_item_construct (GType object_type);
static void rygel_visual_item_finalize (GObject* obj);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
static void rygel_video_item_finalize (GObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (GObject* obj);
GType rygel_http_item_uri_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET "MP3"
gint rygel_http_item_uri_test_main (gchar** args, int args_length1);
static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error);
static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error);
void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self);
static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error);
static void rygel_http_item_uri_test_test_error_construction (RygelHTTPItemURITest* self, const gchar* str, SoupStatus error_code);
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_item_uri_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (extension != NULL, NULL);
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
	_tmp0_ = extension;
	rygel_transcoder_set_extension (self, _tmp0_);
	return self;
}


RygelTranscoder* rygel_transcoder_new (const gchar* extension) {
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER, extension);
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp1_;
	g_object_notify ((GObject *) self, "extension");
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	_g_free0 (self->priv->_extension);
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	switch (property_id) {
		case RYGEL_TRANSCODER_EXTENSION:
		g_value_set_string (value, rygel_transcoder_get_extension (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	switch (property_id) {
		case RYGEL_TRANSCODER_EXTENSION:
		rygel_transcoder_set_extension (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp4_ = NULL;
	GUPnPContext* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GUPnPContext* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
	rygel_http_server_set_path_root (self, RYGEL_HTTP_SERVER_SERVER_PATH);
	{
		GUPnPContext* _tmp0_ = NULL;
		GUPnPContext* _tmp1_ = NULL;
		GUPnPContext* _tmp2_ = NULL;
		_tmp1_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->context);
		self->context = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
		_inner_error_ = _tmp3_;
		_g_error_free0 (_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = self->context;
	_vala_assert (_tmp4_ != NULL, "this.context != null");
	_tmp5_ = self->context;
	_tmp6_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_ != NULL, "this.context.host_ip != null");
	_tmp8_ = self->context;
	_tmp9_ = gupnp_context_get_port (_tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (_tmp10_ > ((guint) 0), "this.context.port > 0");
	return self;
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	_tmp0_ = target;
	if (g_strcmp0 (_tmp0_, "MP3") == 0) {
		RygelTranscoder* _tmp1_ = NULL;
		_tmp1_ = rygel_transcoder_new ("mp3");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = target;
	_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No transcoder available for target format '%s'", _tmp2_);
	_inner_error_ = _tmp3_;
	g_propagate_error (error, _inner_error_);
	return NULL;
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path_root;
	result = _tmp0_;
	return result;
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_path_root);
	self->priv->_path_root = _tmp1_;
	g_object_notify ((GObject *) self, "path-root");
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	_g_free0 (self->priv->_path_root);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		rygel_http_server_set_path_root (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}


RygelMediaObject* rygel_media_object_new (void) {
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	_g_free0 (self->id);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeArrayList* rygel_media_item_get_uris (RygelMediaItem* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->uris;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	return self;
}


RygelMediaItem* rygel_media_item_new (void) {
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_ = NULL;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	self->uris = _tmp0_;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	_g_object_unref0 (self->uris);
	_g_free0 (self->mime_type);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
	self = (RygelThumbnail*) g_type_create_instance (object_type);
	return self;
}


RygelThumbnail* rygel_thumbnail_new (void) {
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
}


static void rygel_value_thumbnail_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_thumbnail_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_thumbnail_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_thumbnail_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
	self->ref_count = 1;
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
	_g_free0 (self->file_extension);
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelVisualItem* rygel_visual_item_construct (GType object_type) {
	RygelVisualItem * self = NULL;
	self = (RygelVisualItem*) rygel_media_item_construct (object_type);
	return self;
}


RygelVisualItem* rygel_visual_item_new (void) {
	return rygel_visual_item_construct (RYGEL_TYPE_VISUAL_ITEM);
}


static void rygel_visual_item_class_init (RygelVisualItemClass * klass) {
	rygel_visual_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_visual_item_finalize;
}


static void rygel_visual_item_instance_init (RygelVisualItem * self) {
	GeeArrayList* _tmp0_ = NULL;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL, NULL, NULL);
	self->thumbnails = _tmp0_;
}


static void rygel_visual_item_finalize (GObject* obj) {
	RygelVisualItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem);
	_g_object_unref0 (self->thumbnails);
	G_OBJECT_CLASS (rygel_visual_item_parent_class)->finalize (obj);
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_visual_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVisualItem), 0, (GInstanceInitFunc) rygel_visual_item_instance_init, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelVisualItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
	return self;
}


RygelSubtitle* rygel_subtitle_new (void) {
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
	_g_free0 (self->caption_type);
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem * self = NULL;
	self = (RygelVideoItem*) rygel_visual_item_construct (object_type);
	return self;
}


RygelVideoItem* rygel_video_item_new (void) {
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	GeeArrayList* _tmp0_ = NULL;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->subtitles = _tmp0_;
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	_g_object_unref0 (self->subtitles);
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_VISUAL_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem * self = NULL;
	self = (RygelMusicItem*) rygel_media_item_construct (object_type);
	return self;
}


RygelMusicItem* rygel_music_item_new (void) {
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	_rygel_thumbnail_unref0 (self->album_art);
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


gint rygel_http_item_uri_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPItemURITest* test = NULL;
		RygelHTTPItemURITest* _tmp0_ = NULL;
		RygelHTTPItemURITest* _tmp1_ = NULL;
		_tmp0_ = rygel_http_item_uri_test_new (&_inner_error_);
		test = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
		_tmp1_ = test;
		rygel_http_item_uri_test_run (_tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally1;
	__catch1_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		result = 77;
		_g_error_free0 (_error_);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_critical ("rygel-http-item-uri-test.vala:120: %s", _tmp3_);
		result = -1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return rygel_http_item_uri_test_main (argv, argc);
}


void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error) {
	RygelThumbnail* thumb = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelVisualItem* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	RygelThumbnail* _tmp5_ = NULL;
	RygelVisualItem* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	RygelVisualItem* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	RygelVisualItem* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	RygelHTTPItemURI** uris = NULL;
	RygelHTTPItemURI* _tmp12_ = NULL;
	RygelHTTPItemURI* _tmp13_ = NULL;
	RygelHTTPItemURI* _tmp14_ = NULL;
	RygelHTTPItemURI* _tmp15_ = NULL;
	RygelHTTPItemURI** _tmp16_ = NULL;
	gint uris_length1 = 0;
	gint _uris_size_ = 0;
	RygelHTTPItemURI** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_thumbnail_new ();
	thumb = _tmp0_;
	_tmp1_ = thumb;
	_tmp2_ = g_strdup ("png");
	_g_free0 (_tmp1_->file_extension);
	_tmp1_->file_extension = _tmp2_;
	_tmp3_ = self->priv->item;
	_tmp4_ = _tmp3_->thumbnails;
	_tmp5_ = thumb;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
	_tmp6_ = self->priv->item;
	_tmp7_ = g_strdup ("HELLO");
	_g_free0 (((RygelMediaObject*) _tmp6_)->id);
	((RygelMediaObject*) _tmp6_)->id = _tmp7_;
	_tmp8_ = self->priv->item;
	_tmp9_ = ((RygelMediaItem*) _tmp8_)->uris;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "foo.mp3");
	_tmp10_ = self->priv->item;
	_tmp11_ = g_strdup ("audio/mp3");
	_g_free0 (((RygelMediaItem*) _tmp10_)->mime_type);
	((RygelMediaItem*) _tmp10_)->mime_type = _tmp11_;
	_tmp12_ = rygel_http_item_uri_test_test_construction (self);
	_tmp13_ = rygel_http_item_uri_test_test_construction_with_thumbnail (self);
	_tmp14_ = rygel_http_item_uri_test_test_construction_with_subtitle (self);
	_tmp15_ = rygel_http_item_uri_test_test_construction_with_transcoder (self);
	_tmp16_ = g_new0 (RygelHTTPItemURI*, 4 + 1);
	_tmp16_[0] = _tmp12_;
	_tmp16_[1] = _tmp13_;
	_tmp16_[2] = _tmp14_;
	_tmp16_[3] = _tmp15_;
	uris = _tmp16_;
	uris_length1 = 4;
	_uris_size_ = uris_length1;
	_tmp17_ = uris;
	_tmp17__length1 = uris_length1;
	{
		RygelHTTPItemURI** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp17_;
		uri_collection_length1 = _tmp17__length1;
		for (uri_it = 0; uri_it < _tmp17__length1; uri_it = uri_it + 1) {
			RygelHTTPItemURI* _tmp18_ = NULL;
			RygelHTTPItemURI* uri = NULL;
			_tmp18_ = _g_object_ref0 (uri_collection[uri_it]);
			uri = _tmp18_;
			{
				gchar* str = NULL;
				RygelHTTPItemURI* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				RygelHTTPItemURI* _tmp22_ = NULL;
				RygelHTTPItemURI* _tmp23_ = NULL;
				_tmp19_ = uri;
				_tmp20_ = rygel_http_item_uri_test_test_to_string (self, _tmp19_);
				str = _tmp20_;
				_tmp21_ = str;
				_tmp22_ = rygel_http_item_uri_test_test_construction_from_string (self, _tmp21_, &_inner_error_);
				_tmp23_ = _tmp22_;
				_g_object_unref0 (_tmp23_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (str);
					_g_object_unref0 (uri);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
					_rygel_thumbnail_unref0 (thumb);
					return;
				}
				_g_free0 (str);
				_g_object_unref0 (uri);
			}
		}
	}
	rygel_http_item_uri_test_test_error_construction (self, "/Ttt", SOUP_STATUS_BAD_REQUEST);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
	_rygel_thumbnail_unref0 (thumb);
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error) {
	RygelHTTPItemURITest * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPItemURITest*) g_object_new (object_type, NULL);
	_tmp1_ = rygel_http_server_new (&_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->server);
	self->priv->server = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return self;
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error) {
	return rygel_http_item_uri_test_construct (RYGEL_TYPE_HTTP_ITEM_URI_TEST, error);
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->item;
	_tmp1_ = self->priv->server;
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, -1, -1, NULL, NULL);
	uri = _tmp2_;
	_vala_assert (uri != NULL, "uri != null");
	result = uri;
	return result;
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->item;
	_tmp1_ = self->priv->server;
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, -1, RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX, NULL, NULL);
	uri = _tmp2_;
	_vala_assert (uri != NULL, "uri != null");
	result = uri;
	return result;
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->item;
	_tmp1_ = self->priv->server;
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, NULL, NULL);
	uri = _tmp2_;
	_vala_assert (uri != NULL, "uri != null");
	result = uri;
	return result;
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->item;
	_tmp1_ = self->priv->server;
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET, NULL);
	uri = _tmp2_;
	_vala_assert (uri != NULL, "uri != null");
	result = uri;
	return result;
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	const gchar* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = self->priv->server;
	_tmp2_ = rygel_http_item_uri_new_from_string (_tmp0_, _tmp1_, &_inner_error_);
	uri = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_vala_assert (uri != NULL, "uri != null");
	_tmp3_ = rygel_http_item_uri_to_string (uri);
	_tmp4_ = _tmp3_;
	_tmp5_ = str;
	_vala_assert (g_strcmp0 (_tmp4_, _tmp5_) == 0, "uri.to_string () == str");
	_g_free0 (_tmp4_);
	result = uri;
	return result;
}


static void rygel_http_item_uri_test_test_error_construction (RygelHTTPItemURITest* self, const gchar* str, SoupStatus error_code) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	{
		RygelHTTPItemURI* uri = NULL;
		const gchar* _tmp0_ = NULL;
		RygelHTTPServer* _tmp1_ = NULL;
		RygelHTTPItemURI* _tmp2_ = NULL;
		_tmp0_ = str;
		_tmp1_ = self->priv->server;
		_tmp2_ = rygel_http_item_uri_new_from_string (_tmp0_, _tmp1_, &_inner_error_);
		uri = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
				goto __catch2_rygel_http_request_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_vala_assert (uri == NULL, "uri == null");
		_g_object_unref0 (uri);
	}
	goto __finally2;
	__catch2_rygel_http_request_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		SoupStatus _tmp5_ = 0;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->code;
		_tmp5_ = error_code;
		_vala_assert (_tmp4_ == ((gint) _tmp5_), "error.code == error_code");
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri) {
	gchar* result = NULL;
	gchar* str = NULL;
	RygelHTTPItemURI* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = rygel_http_item_uri_to_string (_tmp0_);
	str = _tmp1_;
	_vala_assert (str != NULL, "str != null");
	result = str;
	return result;
}


static void rygel_http_item_uri_test_class_init (RygelHTTPItemURITestClass * klass) {
	rygel_http_item_uri_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURITestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_test_finalize;
}


static void rygel_http_item_uri_test_instance_init (RygelHTTPItemURITest * self) {
	RygelVisualItem* _tmp0_ = NULL;
	self->priv = RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE (self);
	_tmp0_ = rygel_visual_item_new ();
	self->priv->item = _tmp0_;
}


static void rygel_http_item_uri_test_finalize (GObject* obj) {
	RygelHTTPItemURITest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITest);
	_g_object_unref0 (self->priv->item);
	_g_object_unref0 (self->priv->server);
	G_OBJECT_CLASS (rygel_http_item_uri_test_parent_class)->finalize (obj);
}


GType rygel_http_item_uri_test_get_type (void) {
	static volatile gsize rygel_http_item_uri_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURITestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURITest), 0, (GInstanceInitFunc) rygel_http_item_uri_test_instance_init, NULL };
		GType rygel_http_item_uri_test_type_id;
		rygel_http_item_uri_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURITest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_test_type_id__volatile, rygel_http_item_uri_test_type_id);
	}
	return rygel_http_item_uri_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



