/* rygel-media-export-item-factory.c generated by valac 0.24.0.112-bbf5, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>
#include <libsoup/soup.h>


#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
static void _vala_SoupDate_free (SoupDate* self);
static gint _vala_array_length (gpointer array);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaItem* result = NULL;
	gchar* title = NULL;
	GFileInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelMediaItem* item = NULL;
	gchar* mime = NULL;
	GFileInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	RygelMediaItem* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	RygelMediaItem* _tmp40_ = NULL;
	GFileInfo* _tmp41_ = NULL;
	gint64 _tmp42_ = 0LL;
	RygelMediaItem* _tmp43_ = NULL;
	GFileInfo* _tmp44_ = NULL;
	guint64 _tmp45_ = 0ULL;
	RygelMediaItem* _tmp46_ = NULL;
	GFile* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
	mime = _tmp5_;
	_tmp6_ = mime;
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
	if (_tmp7_) {
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportVideoItem* _tmp13_ = NULL;
		_tmp8_ = file;
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = parent;
		_tmp12_ = title;
		_tmp13_ = rygel_media_export_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp13_;
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = mime;
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
		if (_tmp15_) {
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			RygelMediaExportPhotoItem* _tmp21_ = NULL;
			_tmp16_ = file;
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = parent;
			_tmp20_ = title;
			_tmp21_ = rygel_media_export_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp21_;
			_g_free0 (_tmp18_);
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp23_ = mime;
			_tmp24_ = g_str_has_prefix (_tmp23_, "audio/");
			if (_tmp24_) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp25_ = NULL;
				_tmp25_ = mime;
				_tmp22_ = g_strcmp0 (_tmp25_, "application/ogg") == 0;
			}
			if (_tmp22_) {
				GFile* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				RygelMediaContainer* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				RygelMediaExportMusicItem* _tmp31_ = NULL;
				_tmp26_ = file;
				_tmp27_ = rygel_media_export_media_cache_get_id (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = parent;
				_tmp30_ = title;
				_tmp31_ = rygel_media_export_music_item_new (_tmp28_, _tmp29_, _tmp30_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp31_;
				_g_free0 (_tmp28_);
			} else {
				GFile* _tmp32_ = NULL;
				RygelMediaContainer* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				RygelMediaItem* _tmp35_ = NULL;
				RygelMediaItem* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				_tmp32_ = file;
				_tmp33_ = parent;
				_tmp34_ = title;
				_tmp35_ = rygel_media_export_item_factory_create_playlist_item (_tmp32_, _tmp33_, _tmp34_);
				_g_object_unref0 (item);
				item = _tmp35_;
				_tmp36_ = item;
				if (_tmp36_ == NULL) {
					result = NULL;
					_g_free0 (mime);
					_g_object_unref0 (item);
					_g_free0 (title);
					return result;
				}
				_tmp37_ = g_strdup ("text/xml");
				_g_free0 (mime);
				mime = _tmp37_;
			}
		}
	}
	_tmp38_ = item;
	_tmp39_ = mime;
	rygel_media_item_set_mime_type (_tmp38_, _tmp39_);
	_tmp40_ = item;
	_tmp41_ = info;
	_tmp42_ = g_file_info_get_size (_tmp41_);
	rygel_media_item_set_size (_tmp40_, (gint64) _tmp42_);
	_tmp43_ = item;
	_tmp44_ = info;
	_tmp45_ = g_file_info_get_attribute_uint64 (_tmp44_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp43_, _tmp45_);
	_tmp46_ = item;
	_tmp47_ = file;
	_tmp48_ = g_file_get_uri (_tmp47_);
	_tmp49_ = _tmp48_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp46_, _tmp49_);
	_g_free0 (_tmp49_);
	result = item;
	_g_free0 (mime);
	_g_free0 (title);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaItem* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (fallback_title != NULL, NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gboolean _tmp4_ = FALSE;
		gint i = 0;
		guint8* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		gint _tmp14_ = 0;
		guint8 _tmp15_ = 0U;
		GUPnPMediaCollection* didl_s = NULL;
		guint8* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		GUPnPMediaCollection* _tmp17_ = NULL;
		gchar* author = NULL;
		GUPnPMediaCollection* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* title = NULL;
		GUPnPMediaCollection* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp33_ = NULL;
		RygelMediaExportPlaylistItem* item = NULL;
		GFile* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		RygelMediaContainer* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		RygelMediaExportPlaylistItem* _tmp41_ = NULL;
		RygelMediaExportPlaylistItem* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		RygelMediaExportPlaylistItem* _tmp46_ = NULL;
		_tmp1_ = file;
		_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp2_;
		contents_length1 = _tmp3_;
		_contents_size_ = contents_length1;
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			contents = (g_free (contents), NULL);
			goto __catch68_g_error;
		}
		if (!_tmp0_) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		i = 0;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp7_ = 0;
			guint8 _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
			gint _tmp12_ = 0;
			_tmp6_ = contents;
			_tmp6__length1 = contents_length1;
			_tmp7_ = i;
			_tmp8_ = _tmp6_[_tmp7_];
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
			if (_tmp9_) {
				gint _tmp10_ = 0;
				guint8* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				_tmp10_ = i;
				_tmp11_ = contents;
				_tmp11__length1 = contents_length1;
				_tmp5_ = _tmp10_ < _tmp11__length1;
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
		}
		_tmp13_ = contents;
		_tmp13__length1 = contents_length1;
		_tmp14_ = i;
		_tmp15_ = _tmp13_[_tmp14_];
		if (_tmp15_ != ((guint8) '<')) {
			result = NULL;
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp16_ = contents;
		_tmp16__length1 = contents_length1;
		_tmp17_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp16_);
		didl_s = _tmp17_;
		_tmp18_ = didl_s;
		_tmp19_ = gupnp_media_collection_get_author (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		author = _tmp21_;
		_tmp22_ = didl_s;
		_tmp23_ = gupnp_media_collection_get_title (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup (_tmp24_);
		title = _tmp25_;
		_tmp28_ = author;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_ = NULL;
			_tmp29_ = title;
			_tmp27_ = _tmp29_ == NULL;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GUPnPMediaCollection* _tmp30_ = NULL;
			GList* _tmp31_ = NULL;
			GList* _tmp32_ = NULL;
			_tmp30_ = didl_s;
			_tmp31_ = gupnp_media_collection_get_items (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp26_ = _tmp32_ == NULL;
			__g_list_free__g_object_unref0_0 (_tmp32_);
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			result = NULL;
			_g_free0 (title);
			_g_free0 (author);
			_g_object_unref0 (didl_s);
			contents = (g_free (contents), NULL);
			return result;
		}
		_tmp33_ = title;
		if (_tmp33_ == NULL) {
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp34_ = fallback_title;
			_tmp35_ = g_strdup (_tmp34_);
			_g_free0 (title);
			title = _tmp35_;
		}
		_tmp36_ = file;
		_tmp37_ = rygel_media_export_media_cache_get_id (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = parent;
		_tmp40_ = title;
		_tmp41_ = rygel_media_export_playlist_item_new (_tmp38_, _tmp39_, _tmp40_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp38_);
		item = _tmp42_;
		_tmp43_ = author;
		if (_tmp43_ != NULL) {
			RygelMediaExportPlaylistItem* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			_tmp44_ = item;
			_tmp45_ = author;
			rygel_media_object_set_creator ((RygelMediaObject*) _tmp44_, _tmp45_);
		}
		_tmp46_ = item;
		rygel_media_item_set_dlna_profile ((RygelMediaItem*) _tmp46_, "DIDL_S");
		result = (RygelMediaItem*) item;
		_g_free0 (title);
		_g_free0 (author);
		_g_object_unref0 (didl_s);
		contents = (g_free (contents), NULL);
		return result;
	}
	goto __finally68;
	__catch68_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally68:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	gchar* id = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GstDiscovererInfo* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GList* _tmp7_ = NULL;
	gboolean _tmp12_ = FALSE;
	GList* _tmp13_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = gst_discoverer_info_get_audio_streams (_tmp2_);
	__g_list_free__g_object_unref0_0 (audio_streams);
	audio_streams = (GList*) _tmp3_;
	_tmp4_ = info;
	_tmp5_ = gst_discoverer_info_get_video_streams (_tmp4_);
	__g_list_free__g_object_unref0_0 (video_streams);
	video_streams = (GList*) _tmp5_;
	_tmp7_ = audio_streams;
	if (_tmp7_ == NULL) {
		GList* _tmp8_ = NULL;
		_tmp8_ = video_streams;
		_tmp6_ = _tmp8_ == NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = file;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp11_);
		_g_free0 (_tmp11_);
		result = NULL;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	}
	_tmp13_ = audio_streams;
	if (_tmp13_ == NULL) {
		GList* _tmp14_ = NULL;
		gconstpointer _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp14_ = video_streams;
		_tmp15_ = _tmp14_->data;
		_tmp16_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp15_);
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp17_ = NULL;
		RygelMediaContainer* _tmp18_ = NULL;
		RygelMediaExportPhotoItem* _tmp19_ = NULL;
		RygelMediaItem* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GstDiscovererInfo* _tmp22_ = NULL;
		GUPnPDLNAProfile* _tmp23_ = NULL;
		GList* _tmp24_ = NULL;
		gconstpointer _tmp25_ = NULL;
		GFileInfo* _tmp26_ = NULL;
		RygelMediaItem* _tmp27_ = NULL;
		_tmp17_ = id;
		_tmp18_ = parent;
		_tmp19_ = rygel_media_export_photo_item_new (_tmp17_, _tmp18_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp19_;
		_tmp20_ = item;
		_tmp21_ = file;
		_tmp22_ = info;
		_tmp23_ = profile;
		_tmp24_ = video_streams;
		_tmp25_ = _tmp24_->data;
		_tmp26_ = file_info;
		_tmp27_ = rygel_media_export_item_factory_fill_photo_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM) ? ((RygelMediaExportPhotoItem*) _tmp20_) : NULL, _tmp21_, _tmp22_, _tmp23_, (GstDiscovererVideoInfo*) _tmp25_, _tmp26_);
		result = _tmp27_;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		GList* _tmp28_ = NULL;
		_tmp28_ = video_streams;
		if (_tmp28_ != NULL) {
			const gchar* _tmp29_ = NULL;
			RygelMediaContainer* _tmp30_ = NULL;
			RygelMediaExportVideoItem* _tmp31_ = NULL;
			GstDiscovererAudioInfo* audio_info = NULL;
			gpointer _tmp32_ = NULL;
			GstDiscovererAudioInfo* _tmp33_ = NULL;
			GList* _tmp34_ = NULL;
			RygelMediaItem* _tmp38_ = NULL;
			GFile* _tmp39_ = NULL;
			GstDiscovererInfo* _tmp40_ = NULL;
			GUPnPDLNAProfile* _tmp41_ = NULL;
			GList* _tmp42_ = NULL;
			gconstpointer _tmp43_ = NULL;
			GstDiscovererAudioInfo* _tmp44_ = NULL;
			GFileInfo* _tmp45_ = NULL;
			RygelMediaItem* _tmp46_ = NULL;
			_tmp29_ = id;
			_tmp30_ = parent;
			_tmp31_ = rygel_media_export_video_item_new (_tmp29_, _tmp30_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp31_;
			_tmp32_ = NULL;
			_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, gst_discoverer_audio_info_get_type ()) ? ((GstDiscovererAudioInfo*) _tmp32_) : NULL);
			audio_info = _tmp33_;
			_tmp34_ = audio_streams;
			if (_tmp34_ != NULL) {
				GList* _tmp35_ = NULL;
				gconstpointer _tmp36_ = NULL;
				GstDiscovererAudioInfo* _tmp37_ = NULL;
				_tmp35_ = audio_streams;
				_tmp36_ = _tmp35_->data;
				_tmp37_ = _g_object_ref0 ((GstDiscovererAudioInfo*) _tmp36_);
				_g_object_unref0 (audio_info);
				audio_info = _tmp37_;
			}
			_tmp38_ = item;
			_tmp39_ = file;
			_tmp40_ = info;
			_tmp41_ = profile;
			_tmp42_ = video_streams;
			_tmp43_ = _tmp42_->data;
			_tmp44_ = audio_info;
			_tmp45_ = file_info;
			_tmp46_ = rygel_media_export_item_factory_fill_video_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp38_) : NULL, _tmp39_, _tmp40_, _tmp41_, (GstDiscovererVideoInfo*) _tmp43_, _tmp44_, _tmp45_);
			result = _tmp46_;
			_g_object_unref0 (audio_info);
			__g_list_free__g_object_unref0_0 (video_streams);
			__g_list_free__g_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			GList* _tmp47_ = NULL;
			_tmp47_ = audio_streams;
			if (_tmp47_ != NULL) {
				const gchar* _tmp48_ = NULL;
				RygelMediaContainer* _tmp49_ = NULL;
				RygelMediaExportMusicItem* _tmp50_ = NULL;
				RygelMediaItem* _tmp51_ = NULL;
				GFile* _tmp52_ = NULL;
				GstDiscovererInfo* _tmp53_ = NULL;
				GUPnPDLNAProfile* _tmp54_ = NULL;
				GList* _tmp55_ = NULL;
				gconstpointer _tmp56_ = NULL;
				GFileInfo* _tmp57_ = NULL;
				RygelMediaItem* _tmp58_ = NULL;
				_tmp48_ = id;
				_tmp49_ = parent;
				_tmp50_ = rygel_media_export_music_item_new (_tmp48_, _tmp49_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp50_;
				_tmp51_ = item;
				_tmp52_ = file;
				_tmp53_ = info;
				_tmp54_ = profile;
				_tmp55_ = audio_streams;
				_tmp56_ = _tmp55_->data;
				_tmp57_ = file_info;
				_tmp58_ = rygel_media_export_item_factory_fill_music_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp51_) : NULL, _tmp52_, _tmp53_, _tmp54_, (GstDiscovererAudioInfo*) _tmp56_, _tmp57_);
				result = _tmp58_;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__g_object_unref0_0 (video_streams);
				__g_list_free__g_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__g_object_unref0_0 (video_streams);
	__g_list_free__g_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


static gpointer _gst_tag_list_ref0 (gpointer self) {
	return self ? gst_tag_list_ref (self) : NULL;
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info) {
	GstDiscovererInfo* _tmp0_ = NULL;
	GstClockTime _tmp1_ = 0ULL;
	GstDiscovererAudioInfo* _tmp6_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp7_ = NULL;
	GstTagList* _tmp8_ = NULL;
	GstTagList* _tmp9_ = NULL;
	GstTagList* _tmp10_ = NULL;
	RygelAudioItem* _tmp15_ = NULL;
	GstDiscovererAudioInfo* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	RygelAudioItem* _tmp18_ = NULL;
	GstDiscovererAudioInfo* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	g_return_if_fail (item != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
	if (_tmp1_ > ((GstClockTime) 0)) {
		RygelAudioItem* _tmp2_ = NULL;
		GstDiscovererInfo* _tmp3_ = NULL;
		GstClockTime _tmp4_ = 0ULL;
		_tmp2_ = item;
		_tmp3_ = info;
		_tmp4_ = gst_discoverer_info_get_duration (_tmp3_);
		rygel_audio_item_set_duration (_tmp2_, (glong) (_tmp4_ / GST_SECOND));
	} else {
		RygelAudioItem* _tmp5_ = NULL;
		_tmp5_ = item;
		rygel_audio_item_set_duration (_tmp5_, (glong) (-1));
	}
	_tmp6_ = audio_info;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = audio_info;
	_tmp8_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp7_);
	_tmp9_ = _gst_tag_list_ref0 (_tmp8_);
	tags = _tmp9_;
	_tmp10_ = tags;
	if (_tmp10_ != NULL) {
		guint tmp = 0U;
		GstTagList* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		RygelAudioItem* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		_tmp11_ = tags;
		gst_tag_list_get_uint (_tmp11_, GST_TAG_BITRATE, &_tmp12_);
		tmp = _tmp12_;
		_tmp13_ = item;
		_tmp14_ = tmp;
		rygel_audio_item_set_bitrate (_tmp13_, ((gint) _tmp14_) / 8);
	}
	_tmp15_ = item;
	_tmp16_ = audio_info;
	_tmp17_ = gst_discoverer_audio_info_get_channels (_tmp16_);
	rygel_audio_item_set_channels (_tmp15_, (gint) _tmp17_);
	_tmp18_ = item;
	_tmp19_ = audio_info;
	_tmp20_ = gst_discoverer_audio_info_get_sample_rate (_tmp19_);
	rygel_audio_item_set_sample_freq (_tmp18_, (gint) _tmp20_);
	_gst_tag_list_unref0 (tags);
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportVideoItem* _tmp0_ = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GstDiscovererAudioInfo* _tmp2_ = NULL;
	RygelMediaExportVideoItem* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GstDiscovererInfo* _tmp5_ = NULL;
	GUPnPDLNAProfile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	RygelMediaExportVideoItem* _tmp8_ = NULL;
	GstDiscovererVideoInfo* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	RygelMediaExportVideoItem* _tmp11_ = NULL;
	GstDiscovererVideoInfo* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gint color_depth = 0;
	GstDiscovererVideoInfo* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	RygelMediaExportVideoItem* _tmp19_ = NULL;
	RygelMediaExportVideoItem* _tmp20_ = NULL;
	RygelMediaItem* _tmp21_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_width (_tmp9_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = item;
	_tmp12_ = video_info;
	_tmp13_ = gst_discoverer_video_info_get_height (_tmp12_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp11_, (gint) _tmp13_);
	_tmp14_ = video_info;
	_tmp15_ = gst_discoverer_video_info_get_depth (_tmp14_);
	color_depth = (gint) _tmp15_;
	_tmp17_ = color_depth;
	if (_tmp17_ == 0) {
		_tmp16_ = -1;
	} else {
		gint _tmp18_ = 0;
		_tmp18_ = color_depth;
		_tmp16_ = _tmp18_;
	}
	_tmp19_ = item;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp19_, _tmp16_);
	_tmp20_ = item;
	_tmp21_ = _g_object_ref0 ((RygelMediaItem*) _tmp20_);
	result = _tmp21_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportPhotoItem* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GUPnPDLNAProfile* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	RygelMediaExportPhotoItem* _tmp5_ = NULL;
	GstDiscovererVideoInfo* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	RygelMediaExportPhotoItem* _tmp8_ = NULL;
	GstDiscovererVideoInfo* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gint color_depth = 0;
	GstDiscovererVideoInfo* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	RygelMediaExportPhotoItem* _tmp16_ = NULL;
	RygelMediaExportPhotoItem* _tmp17_ = NULL;
	RygelMediaItem* _tmp18_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = file;
	_tmp2_ = info;
	_tmp3_ = profile;
	_tmp4_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = item;
	_tmp6_ = video_info;
	_tmp7_ = gst_discoverer_video_info_get_width (_tmp6_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp5_, (gint) _tmp7_);
	_tmp8_ = item;
	_tmp9_ = video_info;
	_tmp10_ = gst_discoverer_video_info_get_height (_tmp9_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
	_tmp11_ = video_info;
	_tmp12_ = gst_discoverer_video_info_get_depth (_tmp11_);
	color_depth = (gint) _tmp12_;
	_tmp14_ = color_depth;
	if (_tmp14_ == 0) {
		_tmp13_ = -1;
	} else {
		gint _tmp15_ = 0;
		_tmp15_ = color_depth;
		_tmp13_ = _tmp15_;
	}
	_tmp16_ = item;
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp16_, _tmp13_);
	_tmp17_ = item;
	_tmp18_ = _g_object_ref0 ((RygelMediaItem*) _tmp17_);
	result = _tmp18_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportMusicItem* _tmp0_ = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GstDiscovererAudioInfo* _tmp2_ = NULL;
	RygelMediaExportMusicItem* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GstDiscovererInfo* _tmp5_ = NULL;
	GUPnPDLNAProfile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	GstDiscovererAudioInfo* _tmp8_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp11_ = NULL;
	GstTagList* _tmp12_ = NULL;
	GstTagList* _tmp13_ = NULL;
	GstTagList* _tmp14_ = NULL;
	gchar* artist = NULL;
	GstTagList* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	RygelMediaExportMusicItem* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* album = NULL;
	GstTagList* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	RygelMediaExportMusicItem* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* genre = NULL;
	GstTagList* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	RygelMediaExportMusicItem* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	guint tmp = 0U;
	GstTagList* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	RygelMediaExportMusicItem* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	GstTagList* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	RygelMediaExportMusicItem* _tmp35_ = NULL;
	guint _tmp36_ = 0U;
	RygelMediaArtStore* store = NULL;
	RygelMediaArtStore* _tmp37_ = NULL;
	GstSample* sample = NULL;
	GstTagList* _tmp38_ = NULL;
	GstSample* _tmp39_ = NULL;
	GstSample* _tmp40_ = NULL;
	GstSample* _tmp43_ = NULL;
	GstStructure* structure = NULL;
	GstSample* _tmp49_ = NULL;
	GstCaps* _tmp50_ = NULL;
	GstStructure* _tmp51_ = NULL;
	gint image_type = 0;
	GstStructure* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	RygelMediaExportMusicItem* _tmp66_ = NULL;
	RygelMediaItem* _tmp67_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = info;
	_tmp6_ = profile;
	_tmp7_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = audio_info;
	if (_tmp8_ == NULL) {
		RygelMediaExportMusicItem* _tmp9_ = NULL;
		RygelMediaItem* _tmp10_ = NULL;
		_tmp9_ = item;
		_tmp10_ = _g_object_ref0 ((RygelMediaItem*) _tmp9_);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = audio_info;
	_tmp12_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp11_);
	_tmp13_ = _gst_tag_list_ref0 (_tmp12_);
	tags = _tmp13_;
	_tmp14_ = tags;
	if (_tmp14_ == NULL) {
		RygelMediaExportMusicItem* _tmp15_ = NULL;
		RygelMediaItem* _tmp16_ = NULL;
		_tmp15_ = item;
		_tmp16_ = _g_object_ref0 ((RygelMediaItem*) _tmp15_);
		result = _tmp16_;
		_gst_tag_list_unref0 (tags);
		return result;
	}
	_tmp17_ = tags;
	gst_tag_list_get_string (_tmp17_, GST_TAG_ARTIST, &_tmp18_);
	_g_free0 (artist);
	artist = _tmp18_;
	_tmp19_ = item;
	_tmp20_ = artist;
	rygel_media_object_set_artist ((RygelMediaObject*) _tmp19_, _tmp20_);
	_tmp21_ = tags;
	gst_tag_list_get_string (_tmp21_, GST_TAG_ALBUM, &_tmp22_);
	_g_free0 (album);
	album = _tmp22_;
	_tmp23_ = item;
	_tmp24_ = album;
	rygel_audio_item_set_album ((RygelAudioItem*) _tmp23_, _tmp24_);
	_tmp25_ = tags;
	gst_tag_list_get_string (_tmp25_, GST_TAG_GENRE, &_tmp26_);
	_g_free0 (genre);
	genre = _tmp26_;
	_tmp27_ = item;
	_tmp28_ = genre;
	rygel_media_object_set_genre ((RygelMediaObject*) _tmp27_, _tmp28_);
	_tmp29_ = tags;
	gst_tag_list_get_uint (_tmp29_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp30_);
	tmp = _tmp30_;
	_tmp31_ = item;
	_tmp32_ = tmp;
	_tmp31_->disc = (gint) _tmp32_;
	_tmp33_ = tags;
	gst_tag_list_get_uint (_tmp33_, GST_TAG_TRACK_NUMBER, &_tmp34_);
	tmp = _tmp34_;
	_tmp35_ = item;
	_tmp36_ = tmp;
	rygel_music_item_set_track_number ((RygelMusicItem*) _tmp35_, (gint) _tmp36_);
	_tmp37_ = rygel_media_art_store_get_default ();
	store = _tmp37_;
	_tmp38_ = tags;
	gst_tag_list_get_sample (_tmp38_, GST_TAG_IMAGE, &_tmp39_);
	_gst_sample_unref0 (sample);
	sample = _tmp39_;
	_tmp40_ = sample;
	if (_tmp40_ == NULL) {
		GstTagList* _tmp41_ = NULL;
		GstSample* _tmp42_ = NULL;
		_tmp41_ = tags;
		gst_tag_list_get_sample (_tmp41_, GST_TAG_PREVIEW_IMAGE, &_tmp42_);
		_gst_sample_unref0 (sample);
		sample = _tmp42_;
	}
	_tmp43_ = sample;
	if (_tmp43_ == NULL) {
		RygelMediaArtStore* _tmp44_ = NULL;
		RygelMediaExportMusicItem* _tmp45_ = NULL;
		GFile* _tmp46_ = NULL;
		RygelMediaExportMusicItem* _tmp47_ = NULL;
		RygelMediaItem* _tmp48_ = NULL;
		_tmp44_ = store;
		_tmp45_ = item;
		_tmp46_ = file;
		rygel_media_art_store_add (_tmp44_, (RygelMusicItem*) _tmp45_, _tmp46_, NULL, 0);
		_tmp47_ = item;
		_tmp48_ = _g_object_ref0 ((RygelMediaItem*) _tmp47_);
		result = _tmp48_;
		_gst_sample_unref0 (sample);
		_g_object_unref0 (store);
		_g_free0 (genre);
		_g_free0 (album);
		_g_free0 (artist);
		_gst_tag_list_unref0 (tags);
		return result;
	}
	_tmp49_ = sample;
	_tmp50_ = gst_sample_get_caps (_tmp49_);
	_tmp51_ = gst_caps_get_structure (_tmp50_, (guint) 0);
	structure = _tmp51_;
	_tmp52_ = structure;
	gst_structure_get_enum (_tmp52_, "image-type", gst_tag_image_type_get_type (), &_tmp53_);
	image_type = _tmp53_;
	_tmp54_ = image_type;
	switch (_tmp54_) {
		case GST_TAG_IMAGE_TYPE_UNDEFINED:
		case GST_TAG_IMAGE_TYPE_FRONT_COVER:
		{
			GstMapInfo map_info = {0};
			GstSample* _tmp55_ = NULL;
			GstBuffer* _tmp56_ = NULL;
			GstMapInfo _tmp57_ = {0};
			RygelMediaArtStore* _tmp58_ = NULL;
			RygelMediaExportMusicItem* _tmp59_ = NULL;
			GFile* _tmp60_ = NULL;
			GstMapInfo _tmp61_ = {0};
			guint8* _tmp62_ = NULL;
			gint _tmp62__length1 = 0;
			GstSample* _tmp63_ = NULL;
			GstBuffer* _tmp64_ = NULL;
			GstMapInfo _tmp65_ = {0};
			_tmp55_ = sample;
			_tmp56_ = gst_sample_get_buffer (_tmp55_);
			gst_buffer_map (_tmp56_, &_tmp57_, GST_MAP_READ);
			map_info = _tmp57_;
			_tmp58_ = store;
			_tmp59_ = item;
			_tmp60_ = file;
			_tmp61_ = map_info;
			_tmp62_ = _tmp61_.data;
			_tmp62__length1 = _vala_array_length (_tmp61_.data);
			rygel_media_art_store_add (_tmp58_, (RygelMusicItem*) _tmp59_, _tmp60_, _tmp62_, _tmp62__length1);
			_tmp63_ = sample;
			_tmp64_ = gst_sample_get_buffer (_tmp63_);
			_tmp65_ = map_info;
			gst_buffer_unmap (_tmp64_, &_tmp65_);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp66_ = item;
	_tmp67_ = _g_object_ref0 ((RygelMediaItem*) _tmp66_);
	result = _tmp67_;
	_gst_sample_unref0 (sample);
	_g_object_unref0 (store);
	_g_free0 (genre);
	_g_free0 (album);
	_g_free0 (artist);
	_gst_tag_list_unref0 (tags);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	gchar* title = NULL;
	GstTagList* tags = NULL;
	GstDiscovererInfo* _tmp0_ = NULL;
	GstTagList* _tmp1_ = NULL;
	GstTagList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GstTagList* _tmp4_ = NULL;
	GstDateTime* dt = NULL;
	gboolean _tmp11_ = FALSE;
	GstTagList* _tmp12_ = NULL;
	RygelMediaItem* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	guint64 mtime = 0ULL;
	GFileInfo* _tmp42_ = NULL;
	guint64 _tmp43_ = 0ULL;
	RygelMediaItem* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	RygelMediaItem* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	RygelMediaItem* _tmp64_ = NULL;
	GFileInfo* _tmp65_ = NULL;
	gint64 _tmp66_ = 0LL;
	RygelMediaItem* _tmp67_ = NULL;
	guint64 _tmp68_ = 0ULL;
	gboolean _tmp69_ = FALSE;
	GUPnPDLNAProfile* _tmp70_ = NULL;
	RygelMediaItem* _tmp87_ = NULL;
	GFile* _tmp88_ = NULL;
	gchar* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (file_info != NULL);
	title = NULL;
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_tags (_tmp0_);
	_tmp2_ = _gst_tag_list_ref0 (_tmp1_);
	tags = _tmp2_;
	_tmp4_ = tags;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GstTagList* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = tags;
		_tmp7_ = gst_tag_list_get_string (_tmp5_, GST_TAG_TITLE, &_tmp6_);
		_g_free0 (title);
		title = _tmp6_;
		_tmp3_ = !_tmp7_;
	}
	if (_tmp3_) {
		GFileInfo* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = file_info;
		_tmp9_ = g_file_info_get_display_name (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (title);
		title = _tmp10_;
	}
	dt = NULL;
	_tmp12_ = tags;
	if (_tmp12_ != NULL) {
		GstTagList* _tmp13_ = NULL;
		GstDateTime* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = tags;
		_tmp15_ = gst_tag_list_get_date_time (_tmp13_, GST_TAG_DATE_TIME, &_tmp14_);
		_gst_date_time_unref0 (dt);
		dt = _tmp14_;
		_tmp11_ = _tmp15_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp16_ = FALSE;
		GstDateTime* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = dt;
		_tmp18_ = gst_date_time_has_day (_tmp17_);
		if (!_tmp18_) {
			_tmp16_ = TRUE;
		} else {
			GstDateTime* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp19_ = dt;
			_tmp20_ = gst_date_time_has_month (_tmp19_);
			_tmp16_ = !_tmp20_;
		}
		if (_tmp16_) {
			gint _tmp21_ = 0;
			GstDateTime* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			gint _tmp26_ = 0;
			GstDateTime* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			RygelMediaItem* _tmp31_ = NULL;
			GstDateTime* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp22_ = dt;
			_tmp23_ = gst_date_time_has_month (_tmp22_);
			if (_tmp23_) {
				GstDateTime* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				_tmp24_ = dt;
				_tmp25_ = gst_date_time_get_month (_tmp24_);
				_tmp21_ = _tmp25_;
			} else {
				_tmp21_ = 1;
			}
			_tmp27_ = dt;
			_tmp28_ = gst_date_time_has_day (_tmp27_);
			if (_tmp28_) {
				GstDateTime* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				_tmp29_ = dt;
				_tmp30_ = gst_date_time_get_day (_tmp29_);
				_tmp26_ = _tmp30_;
			} else {
				_tmp26_ = 1;
			}
			_tmp31_ = item;
			_tmp32_ = dt;
			_tmp33_ = gst_date_time_get_year (_tmp32_);
			_tmp34_ = g_strdup_printf ("%d-%02d-%02d", _tmp33_, _tmp21_, _tmp26_);
			_tmp35_ = _tmp34_;
			rygel_media_object_set_date ((RygelMediaObject*) _tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
		} else {
			RygelMediaItem* _tmp36_ = NULL;
			GstDateTime* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			_tmp36_ = item;
			_tmp37_ = dt;
			_tmp38_ = gst_date_time_to_iso8601_string (_tmp37_);
			_tmp39_ = _tmp38_;
			rygel_media_object_set_date ((RygelMediaObject*) _tmp36_, _tmp39_);
			_g_free0 (_tmp39_);
		}
	}
	_tmp40_ = item;
	_tmp41_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp40_, _tmp41_);
	_tmp42_ = file_info;
	_tmp43_ = g_file_info_get_attribute_uint64 (_tmp42_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mtime = _tmp43_;
	_tmp44_ = item;
	_tmp45_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp44_);
	_tmp46_ = _tmp45_;
	if (_tmp46_ == NULL) {
		GTimeVal tv = {0};
		guint64 _tmp47_ = 0ULL;
		GTimeVal _tmp48_ = {0};
		RygelMediaItem* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		_tmp47_ = mtime;
		_tmp48_.tv_sec = (glong) _tmp47_;
		_tmp48_.tv_usec = (glong) 0;
		tv = _tmp48_;
		_tmp49_ = item;
		_tmp50_ = g_time_val_to_iso8601 (&tv);
		_tmp51_ = _tmp50_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp49_, _tmp51_);
		_g_free0 (_tmp51_);
	}
	_tmp52_ = item;
	_tmp53_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = string_contains (_tmp54_, "T");
	if (_tmp55_) {
		SoupDate* date = NULL;
		RygelMediaItem* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		SoupDate* _tmp59_ = NULL;
		RygelMediaItem* _tmp60_ = NULL;
		SoupDate* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		_tmp56_ = item;
		_tmp57_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = soup_date_new_from_string (_tmp58_);
		date = _tmp59_;
		_tmp60_ = item;
		_tmp61_ = date;
		_tmp62_ = soup_date_to_string (_tmp61_, SOUP_DATE_ISO8601_FULL);
		_tmp63_ = _tmp62_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp60_, _tmp63_);
		_g_free0 (_tmp63_);
		__vala_SoupDate_free0 (date);
	}
	_tmp64_ = item;
	_tmp65_ = file_info;
	_tmp66_ = g_file_info_get_size (_tmp65_);
	rygel_media_item_set_size (_tmp64_, (gint64) _tmp66_);
	_tmp67_ = item;
	_tmp68_ = mtime;
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp67_, (guint64) ((gint64) _tmp68_));
	_tmp70_ = profile;
	if (_tmp70_ != NULL) {
		GUPnPDLNAProfile* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		_tmp71_ = profile;
		_tmp72_ = gupnp_dlna_profile_get_name (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp69_ = _tmp73_ != NULL;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		RygelMediaItem* _tmp74_ = NULL;
		GUPnPDLNAProfile* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		const gchar* _tmp77_ = NULL;
		RygelMediaItem* _tmp78_ = NULL;
		GUPnPDLNAProfile* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		const gchar* _tmp81_ = NULL;
		_tmp74_ = item;
		_tmp75_ = profile;
		_tmp76_ = gupnp_dlna_profile_get_name (_tmp75_);
		_tmp77_ = _tmp76_;
		rygel_media_item_set_dlna_profile (_tmp74_, _tmp77_);
		_tmp78_ = item;
		_tmp79_ = profile;
		_tmp80_ = gupnp_dlna_profile_get_mime (_tmp79_);
		_tmp81_ = _tmp80_;
		rygel_media_item_set_mime_type (_tmp78_, _tmp81_);
	} else {
		RygelMediaItem* _tmp82_ = NULL;
		GFileInfo* _tmp83_ = NULL;
		const gchar* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		gchar* _tmp86_ = NULL;
		_tmp82_ = item;
		_tmp83_ = file_info;
		_tmp84_ = g_file_info_get_content_type (_tmp83_);
		_tmp85_ = g_content_type_get_mime_type (_tmp84_);
		_tmp86_ = _tmp85_;
		rygel_media_item_set_mime_type (_tmp82_, _tmp86_);
		_g_free0 (_tmp86_);
	}
	_tmp87_ = item;
	_tmp88_ = file;
	_tmp89_ = g_file_get_uri (_tmp88_);
	_tmp90_ = _tmp89_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp87_, _tmp90_);
	_g_free0 (_tmp90_);
	_gst_date_time_unref0 (dt);
	_gst_tag_list_unref0 (tags);
	_g_free0 (title);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



