/* rygel-http-identity-handler.c generated by valac 0.24.0.112-bbf5, the Vala compiler
 * generated from rygel-http-identity-handler.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gboolean (*knows_size) (RygelHTTPGetHandler* self, RygelHTTPGet* request);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelHTTPGetHandler* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_http_identity_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
static void rygel_http_identity_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
static gint64 rygel_http_identity_handler_get_size (RygelHTTPIdentityHandler* self, RygelHTTPGet* request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_identity_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_identity_handler_render_body_real (RygelHTTPIdentityHandler* self, RygelHTTPGet* request, GError** error);
static gboolean rygel_http_identity_handler_real_knows_size (RygelHTTPGetHandler* base, RygelHTTPGet* request);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_http_identity_handler_real_add_resource (RygelHTTPGetHandler* base, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
GUPnPDIDLLiteResource* rygel_thumbnail_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source (RygelMediaEngine* self, const gchar* uri);
RygelDataSource* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
gint64 rygel_media_item_get_size (RygelMediaItem* self);


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPIdentityHandler * self = NULL;
	GCancellable* _tmp0_ = NULL;
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = cancellable;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, _tmp0_);
	return self;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
}


static void rygel_http_identity_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPIdentityHandler * self;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	RygelHTTPGet* _tmp23_ = NULL;
	RygelHTTPSeek* _tmp24_ = NULL;
	RygelHTTPGet* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPIdentityHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = request;
	_tmp1_ = _tmp0_->subtitle;
	if (_tmp1_ != NULL) {
		RygelHTTPGet* _tmp2_ = NULL;
		SoupMessage* _tmp3_ = NULL;
		SoupMessageHeaders* _tmp4_ = NULL;
		RygelHTTPGet* _tmp5_ = NULL;
		RygelSubtitle* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp2_ = request;
		_tmp3_ = ((RygelHTTPRequest*) _tmp2_)->msg;
		_tmp4_ = _tmp3_->response_headers;
		_tmp5_ = request;
		_tmp6_ = _tmp5_->subtitle;
		_tmp7_ = _tmp6_->mime_type;
		soup_message_headers_append (_tmp4_, "Content-Type", _tmp7_);
	} else {
		RygelHTTPGet* _tmp8_ = NULL;
		RygelThumbnail* _tmp9_ = NULL;
		_tmp8_ = request;
		_tmp9_ = _tmp8_->thumbnail;
		if (_tmp9_ != NULL) {
			RygelHTTPGet* _tmp10_ = NULL;
			SoupMessage* _tmp11_ = NULL;
			SoupMessageHeaders* _tmp12_ = NULL;
			RygelHTTPGet* _tmp13_ = NULL;
			RygelThumbnail* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp10_ = request;
			_tmp11_ = ((RygelHTTPRequest*) _tmp10_)->msg;
			_tmp12_ = _tmp11_->response_headers;
			_tmp13_ = request;
			_tmp14_ = _tmp13_->thumbnail;
			_tmp15_ = ((RygelIconInfo*) _tmp14_)->mime_type;
			soup_message_headers_append (_tmp12_, "Content-Type", _tmp15_);
		} else {
			RygelHTTPGet* _tmp16_ = NULL;
			SoupMessage* _tmp17_ = NULL;
			SoupMessageHeaders* _tmp18_ = NULL;
			RygelHTTPGet* _tmp19_ = NULL;
			RygelMediaObject* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			_tmp16_ = request;
			_tmp17_ = ((RygelHTTPRequest*) _tmp16_)->msg;
			_tmp18_ = _tmp17_->response_headers;
			_tmp19_ = request;
			_tmp20_ = ((RygelHTTPRequest*) _tmp19_)->object;
			_tmp21_ = rygel_media_item_get_mime_type (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp20_) : NULL);
			_tmp22_ = _tmp21_;
			soup_message_headers_append (_tmp18_, "Content-Type", _tmp22_);
		}
	}
	_tmp23_ = request;
	_tmp24_ = _tmp23_->seek;
	if (_tmp24_ != NULL) {
		RygelHTTPGet* _tmp25_ = NULL;
		RygelHTTPSeek* _tmp26_ = NULL;
		_tmp25_ = request;
		_tmp26_ = _tmp25_->seek;
		rygel_http_seek_add_response_headers (_tmp26_);
	} else {
		gint64 size = 0LL;
		RygelHTTPGet* _tmp27_ = NULL;
		gint64 _tmp28_ = 0LL;
		gint64 _tmp29_ = 0LL;
		_tmp27_ = request;
		_tmp28_ = rygel_http_identity_handler_get_size (self, _tmp27_);
		size = _tmp28_;
		_tmp29_ = size;
		if (_tmp29_ > ((gint64) 0)) {
			RygelHTTPGet* _tmp30_ = NULL;
			SoupMessage* _tmp31_ = NULL;
			SoupMessageHeaders* _tmp32_ = NULL;
			gint64 _tmp33_ = 0LL;
			_tmp30_ = request;
			_tmp31_ = ((RygelHTTPRequest*) _tmp30_)->msg;
			_tmp32_ = _tmp31_->response_headers;
			_tmp33_ = size;
			soup_message_headers_set_content_length (_tmp32_, _tmp33_);
		}
	}
	_tmp34_ = request;
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_identity_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), _tmp34_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static RygelHTTPResponse* rygel_http_identity_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPIdentityHandler * self;
	RygelHTTPResponse* result = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPIdentityHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelHTTPResponse* _tmp0_ = NULL;
		RygelHTTPGet* _tmp1_ = NULL;
		RygelHTTPResponse* _tmp2_ = NULL;
		RygelHTTPResponse* _tmp3_ = NULL;
		_tmp1_ = request;
		_tmp2_ = rygel_http_identity_handler_render_body_real (self, _tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp5_);
		_inner_error_ = _tmp6_;
		_g_error_free0 (err);
		goto __finally30;
	}
	__finally30:
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean rygel_http_identity_handler_real_knows_size (RygelHTTPGetHandler* base, RygelHTTPGet* request) {
	RygelHTTPIdentityHandler * self;
	gboolean result = FALSE;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	RygelHTTPGet* _tmp4_ = NULL;
	RygelHTTPSeek* _tmp5_ = NULL;
	self = (RygelHTTPIdentityHandler*) base;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = rygel_http_identity_handler_get_size (self, _tmp0_);
	size = _tmp1_;
	_tmp4_ = request;
	_tmp5_ = _tmp4_->seek;
	if (_tmp5_ != NULL) {
		RygelHTTPGet* _tmp6_ = NULL;
		RygelHTTPSeek* _tmp7_ = NULL;
		_tmp6_ = request;
		_tmp7_ = _tmp6_->seek;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_HTTP_BYTE_SEEK);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gint64 _tmp8_ = 0LL;
		_tmp8_ = size;
		_tmp2_ = _tmp8_ > ((gint64) 0);
	}
	result = _tmp2_;
	return result;
}


static GUPnPDIDLLiteResource* rygel_http_identity_handler_real_add_resource (RygelHTTPGetHandler* base, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error) {
	RygelHTTPIdentityHandler * self;
	GUPnPDIDLLiteResource* result = NULL;
	gchar* protocol = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelHTTPGet* _tmp3_ = NULL;
	RygelThumbnail* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPIdentityHandler*) base;
	g_return_val_if_fail (didl_object != NULL, NULL);
	g_return_val_if_fail (request != NULL, NULL);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->http_server;
	_tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) _tmp1_);
	protocol = _tmp2_;
	_tmp3_ = request;
	_tmp4_ = _tmp3_->thumbnail;
	if (_tmp4_ != NULL) {
		RygelHTTPGet* _tmp5_ = NULL;
		RygelThumbnail* _tmp6_ = NULL;
		GUPnPDIDLLiteObject* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GUPnPDIDLLiteResource* _tmp9_ = NULL;
		_tmp5_ = request;
		_tmp6_ = _tmp5_->thumbnail;
		_tmp7_ = didl_object;
		_tmp8_ = protocol;
		_tmp9_ = rygel_thumbnail_add_resource (_tmp6_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp7_) : NULL, _tmp8_);
		result = _tmp9_;
		_g_free0 (protocol);
		return result;
	} else {
		GUPnPDIDLLiteResource* _tmp10_ = NULL;
		RygelHTTPGet* _tmp11_ = NULL;
		RygelMediaObject* _tmp12_ = NULL;
		GUPnPDIDLLiteObject* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GUPnPDIDLLiteResource* _tmp15_ = NULL;
		GUPnPDIDLLiteResource* _tmp16_ = NULL;
		_tmp11_ = request;
		_tmp12_ = ((RygelHTTPRequest*) _tmp11_)->object;
		_tmp13_ = didl_object;
		_tmp14_ = protocol;
		_tmp15_ = rygel_media_object_add_resource (_tmp12_, _tmp13_, NULL, _tmp14_, NULL, &_inner_error_);
		_tmp10_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (protocol);
			return NULL;
		}
		_tmp16_ = _tmp10_;
		_tmp10_ = NULL;
		result = _tmp16_;
		_g_object_unref0 (_tmp10_);
		_g_free0 (protocol);
		return result;
	}
	_g_free0 (protocol);
}


static RygelHTTPResponse* rygel_http_identity_handler_render_body_real (RygelHTTPIdentityHandler* self, RygelHTTPGet* request, GError** error) {
	RygelHTTPResponse* result = NULL;
	RygelDataSource* src = NULL;
	RygelMediaEngine* engine = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelHTTPGet* _tmp1_ = NULL;
	RygelSubtitle* _tmp2_ = NULL;
	RygelDataSource* _tmp23_ = NULL;
	RygelHTTPResponse* _tmp26_ = NULL;
	RygelHTTPGet* _tmp27_ = NULL;
	RygelDataSource* _tmp28_ = NULL;
	RygelHTTPResponse* _tmp29_ = NULL;
	RygelHTTPResponse* _tmp30_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (request != NULL, NULL);
	_tmp0_ = rygel_media_engine_get_default ();
	engine = _tmp0_;
	_tmp1_ = request;
	_tmp2_ = _tmp1_->subtitle;
	if (_tmp2_ != NULL) {
		RygelMediaEngine* _tmp3_ = NULL;
		RygelHTTPGet* _tmp4_ = NULL;
		RygelSubtitle* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelDataSource* _tmp7_ = NULL;
		_tmp3_ = engine;
		_tmp4_ = request;
		_tmp5_ = _tmp4_->subtitle;
		_tmp6_ = _tmp5_->uri;
		_tmp7_ = rygel_media_engine_create_data_source (_tmp3_, _tmp6_);
		_g_object_unref0 (src);
		src = _tmp7_;
	} else {
		RygelHTTPGet* _tmp8_ = NULL;
		RygelThumbnail* _tmp9_ = NULL;
		_tmp8_ = request;
		_tmp9_ = _tmp8_->thumbnail;
		if (_tmp9_ != NULL) {
			RygelMediaEngine* _tmp10_ = NULL;
			RygelHTTPGet* _tmp11_ = NULL;
			RygelThumbnail* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			RygelDataSource* _tmp14_ = NULL;
			_tmp10_ = engine;
			_tmp11_ = request;
			_tmp12_ = _tmp11_->thumbnail;
			_tmp13_ = ((RygelIconInfo*) _tmp12_)->uri;
			_tmp14_ = rygel_media_engine_create_data_source (_tmp10_, _tmp13_);
			_g_object_unref0 (src);
			src = _tmp14_;
		} else {
			RygelHTTPGet* _tmp15_ = NULL;
			RygelMediaObject* _tmp16_ = NULL;
			RygelHTTPGet* _tmp17_ = NULL;
			RygelHTTPServer* _tmp18_ = NULL;
			GUPnPContext* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			RygelDataSource* _tmp22_ = NULL;
			_tmp15_ = request;
			_tmp16_ = ((RygelHTTPRequest*) _tmp15_)->object;
			_tmp17_ = request;
			_tmp18_ = ((RygelHTTPRequest*) _tmp17_)->http_server;
			_tmp19_ = _tmp18_->context;
			_tmp20_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = rygel_media_item_create_stream_source (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp16_) : NULL, _tmp21_);
			_g_object_unref0 (src);
			src = _tmp22_;
		}
	}
	_tmp23_ = src;
	if (_tmp23_ == NULL) {
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
		_tmp24_ = _ ("Not found");
		_tmp25_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp24_);
		_inner_error_ = _tmp25_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (engine);
		_g_object_unref0 (src);
		return NULL;
	}
	_tmp27_ = request;
	_tmp28_ = src;
	_tmp29_ = rygel_http_response_new (_tmp27_, (RygelHTTPGetHandler*) self, _tmp28_, &_inner_error_);
	_tmp26_ = _tmp29_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (engine);
		_g_object_unref0 (src);
		return NULL;
	}
	_tmp30_ = _tmp26_;
	_tmp26_ = NULL;
	result = _tmp30_;
	_g_object_unref0 (_tmp26_);
	_g_object_unref0 (engine);
	_g_object_unref0 (src);
	return result;
}


static gint64 rygel_http_identity_handler_get_size (RygelHTTPIdentityHandler* self, RygelHTTPGet* request) {
	gint64 result = 0LL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	RygelHTTPGet* _tmp5_ = NULL;
	RygelThumbnail* _tmp6_ = NULL;
	RygelHTTPGet* _tmp10_ = NULL;
	RygelMediaObject* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	gint64 _tmp13_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (request != NULL, 0LL);
	_tmp0_ = request;
	_tmp1_ = _tmp0_->subtitle;
	if (_tmp1_ != NULL) {
		RygelHTTPGet* _tmp2_ = NULL;
		RygelSubtitle* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		_tmp2_ = request;
		_tmp3_ = _tmp2_->subtitle;
		_tmp4_ = _tmp3_->size;
		result = _tmp4_;
		return result;
	}
	_tmp5_ = request;
	_tmp6_ = _tmp5_->thumbnail;
	if (_tmp6_ != NULL) {
		RygelHTTPGet* _tmp7_ = NULL;
		RygelThumbnail* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		_tmp7_ = request;
		_tmp8_ = _tmp7_->thumbnail;
		_tmp9_ = ((RygelIconInfo*) _tmp8_)->size;
		result = _tmp9_;
		return result;
	}
	_tmp10_ = request;
	_tmp11_ = ((RygelHTTPRequest*) _tmp10_)->object;
	_tmp12_ = rygel_media_item_get_size (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp11_) : NULL);
	_tmp13_ = _tmp12_;
	result = _tmp13_;
	return result;
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->add_response_headers = rygel_http_identity_handler_real_add_response_headers;
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->render_body = rygel_http_identity_handler_real_render_body;
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->knows_size = rygel_http_identity_handler_real_knows_size;
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->add_resource = rygel_http_identity_handler_real_add_resource;
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}



