/* sudoku-board.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
#define _sudoku_board_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_board_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
typedef struct _ParamSpecSudokuBoard ParamSpecSudokuBoard;

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuBoard *self);
};

struct _SudokuBoardPrivate {
	gboolean* possible_in_row;
	gint possible_in_row_length1;
	gint possible_in_row_length2;
	gboolean* possible_in_col;
	gint possible_in_col_length1;
	gint possible_in_col_length2;
	gboolean* possible_in_block;
	gint possible_in_block_length1;
	gint possible_in_block_length2;
	gint possible_in_block_length3;
	gdouble _previous_played_time;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gdouble _difficulty_rating;
};

typedef enum  {
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _ParamSpecSudokuBoard {
	GParamSpec parent_instance;
};

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};


static gpointer sudoku_board_parent_class = NULL;

gpointer sudoku_board_ref (gpointer instance);
void sudoku_board_unref (gpointer instance);
GParamSpec* param_spec_sudoku_board (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_board (GValue* value, gpointer v_object);
void value_take_sudoku_board (GValue* value, gpointer v_object);
gpointer value_get_sudoku_board (const GValue* value);
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
#define SUDOKU_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_BOARD, SudokuBoardPrivate))
enum  {
	SUDOKU_BOARD_DUMMY_PROPERTY
};
static gboolean sudoku_board_in_range (SudokuBoard* self, gfloat* range, int range_length1);
gdouble sudoku_board_get_difficulty_rating (SudokuBoard* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_max_val (SudokuBoard* self);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a, Coord* b);
void coord_init (Coord *self, gint row, gint col);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
static gint* _vala_array_dup1 (gint* self, int length);
static gboolean* _vala_array_dup2 (gboolean* self, int length);
static gboolean* _vala_array_dup3 (gboolean* self, int length);
static gboolean* _vala_array_dup4 (gboolean* self, int length);
static gboolean* _vala_array_dup5 (gboolean* self, int length);
void sudoku_board_set_from_string (SudokuBoard* self, const gchar* s, const gchar* delimiter, const gchar* empty_value, const gchar* rating_delimiter);
static void sudoku_board_set_difficulty_rating (SudokuBoard* self, gdouble value);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
static gint* _vala_array_dup6 (gint* self, int length);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_get_complete (SudokuBoard* self);
void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self, gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
static gint* _vala_array_dup7 (gint* self, int length);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
const gchar* sudoku_saver_get_finishgame_dir (void);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
static void sudoku_board_finalize (SudokuBoard* obj);
GType house_get_type (void) G_GNUC_CONST;
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self, Coord* coord, gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gfloat DIFFICULTY_RATING_EASY_RANGE[2];
extern const gfloat DIFFICULTY_RATING_MEDIUM_RANGE[2];
extern const gfloat DIFFICULTY_RATING_HARD_RANGE[2];
extern const gfloat DIFFICULTY_RATING_VERY_HARD_RANGE[2];

static gboolean sudoku_board_in_range (SudokuBoard* self, gfloat* range, int range_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gfloat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gfloat _tmp3_ = 0.0F;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_difficulty_rating;
	_tmp2_ = range;
	_tmp2__length1 = range_length1;
	_tmp3_ = _tmp2_[0];
	if (_tmp1_ >= ((gdouble) _tmp3_)) {
		gdouble _tmp4_ = 0.0;
		gfloat* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gfloat _tmp6_ = 0.0F;
		_tmp4_ = self->priv->_difficulty_rating;
		_tmp5_ = range;
		_tmp5__length1 = range_length1;
		_tmp6_ = _tmp5_[1];
		_tmp0_ = _tmp4_ < ((gdouble) _tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self) {
	DifficultyCategory result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sudoku_board_in_range (self, DIFFICULTY_RATING_EASY_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_EASY_RANGE));
	if (_tmp0_) {
		result = DIFFICULTY_CATEGORY_EASY;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = sudoku_board_in_range (self, DIFFICULTY_RATING_MEDIUM_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_MEDIUM_RANGE));
		if (_tmp1_) {
			result = DIFFICULTY_CATEGORY_MEDIUM;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = sudoku_board_in_range (self, DIFFICULTY_RATING_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_HARD_RANGE));
			if (_tmp2_) {
				result = DIFFICULTY_CATEGORY_HARD;
				return result;
			} else {
				gboolean _tmp3_ = FALSE;
				_tmp3_ = sudoku_board_in_range (self, DIFFICULTY_RATING_VERY_HARD_RANGE, G_N_ELEMENTS (DIFFICULTY_RATING_VERY_HARD_RANGE));
				if (_tmp3_) {
					result = DIFFICULTY_CATEGORY_VERY_HARD;
					return result;
				} else {
					result = DIFFICULTY_CATEGORY_EASY;
					return result;
				}
			}
		}
	}
}


SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols) {
	SudokuBoard* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gboolean* _tmp26_ = NULL;
	GeeHashSet* _tmp69_ = NULL;
	GeeArrayList* _tmp70_ = NULL;
	GeeList* _tmp98_ = NULL;
	GeeList* _tmp99_ = NULL;
	GeeList* _tmp100_ = NULL;
	GeeArrayList* _tmp101_ = NULL;
	GeeList* _tmp129_ = NULL;
	GeeList* _tmp130_ = NULL;
	GeeList* _tmp131_ = NULL;
	GeeHashMap* _tmp132_ = NULL;
	GeeMap* _tmp187_ = NULL;
	GeeMap* _tmp188_ = NULL;
	GeeMap* _tmp189_ = NULL;
	self = (SudokuBoard*) g_type_create_instance (object_type);
	_tmp0_ = block_rows;
	_tmp1_ = block_cols;
	self->priv->_cols = _tmp0_ * _tmp1_;
	_tmp2_ = self->priv->_cols;
	self->priv->_rows = _tmp2_;
	_tmp3_ = block_rows;
	self->priv->_block_rows = _tmp3_;
	_tmp4_ = block_cols;
	self->priv->_block_cols = _tmp4_;
	_tmp5_ = self->priv->_rows;
	_tmp6_ = self->priv->_cols;
	_tmp7_ = g_new0 (gint, _tmp5_ * _tmp6_);
	self->cells = (g_free (self->cells), NULL);
	self->cells = _tmp7_;
	self->cells_length1 = _tmp5_;
	self->cells_length2 = _tmp6_;
	_tmp8_ = self->priv->_rows;
	_tmp9_ = self->priv->_cols;
	_tmp10_ = g_new0 (gboolean, _tmp8_ * _tmp9_);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->is_fixed = _tmp10_;
	self->is_fixed_length1 = _tmp8_;
	self->is_fixed_length2 = _tmp9_;
	_tmp11_ = self->priv->_rows;
	_tmp12_ = self->priv->_cols;
	_tmp13_ = g_new0 (gboolean, _tmp11_ * _tmp12_);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_row = _tmp13_;
	self->priv->possible_in_row_length1 = _tmp11_;
	self->priv->possible_in_row_length2 = _tmp12_;
	_tmp14_ = self->priv->_cols;
	_tmp15_ = self->priv->_rows;
	_tmp16_ = g_new0 (gboolean, _tmp14_ * _tmp15_);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_col = _tmp16_;
	self->priv->possible_in_col_length1 = _tmp14_;
	self->priv->possible_in_col_length2 = _tmp15_;
	_tmp17_ = self->priv->_block_rows;
	_tmp18_ = self->priv->_block_cols;
	_tmp19_ = self->priv->_block_rows;
	_tmp20_ = self->priv->_block_cols;
	_tmp21_ = g_new0 (gboolean, (_tmp17_ * _tmp18_) * (_tmp19_ * _tmp20_));
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->priv->possible_in_block = _tmp21_;
	self->priv->possible_in_block_length1 = _tmp17_;
	self->priv->possible_in_block_length2 = _tmp18_;
	self->priv->possible_in_block_length3 = _tmp19_ * _tmp20_;
	_tmp22_ = self->priv->_rows;
	_tmp23_ = self->priv->_cols;
	_tmp24_ = sudoku_board_get_max_val (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_new0 (gboolean, (_tmp22_ * _tmp23_) * _tmp25_);
	self->earmarks = (g_free (self->earmarks), NULL);
	self->earmarks = _tmp26_;
	self->earmarks_length1 = _tmp22_;
	self->earmarks_length2 = _tmp23_;
	self->earmarks_length3 = _tmp25_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				if (!_tmp27_) {
					gint _tmp28_ = 0;
					_tmp28_ = l1;
					l1 = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp29_ = l1;
				_tmp30_ = self->priv->_rows;
				if (!(_tmp29_ < _tmp30_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp31_ = FALSE;
						_tmp31_ = TRUE;
						while (TRUE) {
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint* _tmp35_ = NULL;
							gint _tmp35__length1 = 0;
							gint _tmp35__length2 = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							gboolean* _tmp39_ = NULL;
							gint _tmp39__length1 = 0;
							gint _tmp39__length2 = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gboolean _tmp42_ = FALSE;
							gboolean* _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							gint _tmp43__length2 = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gboolean _tmp46_ = FALSE;
							gboolean* _tmp47_ = NULL;
							gint _tmp47__length1 = 0;
							gint _tmp47__length2 = 0;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gboolean _tmp50_ = FALSE;
							if (!_tmp31_) {
								gint _tmp32_ = 0;
								_tmp32_ = l2;
								l2 = _tmp32_ + 1;
							}
							_tmp31_ = FALSE;
							_tmp33_ = l2;
							_tmp34_ = self->priv->_cols;
							if (!(_tmp33_ < _tmp34_)) {
								break;
							}
							_tmp35_ = self->cells;
							_tmp35__length1 = self->cells_length1;
							_tmp35__length2 = self->cells_length2;
							_tmp36_ = l1;
							_tmp37_ = l2;
							_tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_] = 0;
							_tmp38_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_];
							_tmp39_ = self->is_fixed;
							_tmp39__length1 = self->is_fixed_length1;
							_tmp39__length2 = self->is_fixed_length2;
							_tmp40_ = l1;
							_tmp41_ = l2;
							_tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_] = FALSE;
							_tmp42_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
							_tmp43_ = self->priv->possible_in_row;
							_tmp43__length1 = self->priv->possible_in_row_length1;
							_tmp43__length2 = self->priv->possible_in_row_length2;
							_tmp44_ = l1;
							_tmp45_ = l2;
							_tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_] = TRUE;
							_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
							_tmp47_ = self->priv->possible_in_col;
							_tmp47__length1 = self->priv->possible_in_col_length1;
							_tmp47__length2 = self->priv->possible_in_col_length2;
							_tmp48_ = l2;
							_tmp49_ = l1;
							_tmp47_[(_tmp48_ * _tmp47__length2) + _tmp49_] = TRUE;
							_tmp50_ = _tmp47_[(_tmp48_ * _tmp47__length2) + _tmp49_];
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				if (!_tmp51_) {
					gint _tmp52_ = 0;
					_tmp52_ = l1;
					l1 = _tmp52_ + 1;
				}
				_tmp51_ = FALSE;
				_tmp53_ = l1;
				_tmp54_ = self->priv->_block_rows;
				if (!(_tmp53_ < _tmp54_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp55_ = FALSE;
						_tmp55_ = TRUE;
						while (TRUE) {
							gint _tmp57_ = 0;
							gint _tmp58_ = 0;
							if (!_tmp55_) {
								gint _tmp56_ = 0;
								_tmp56_ = l2;
								l2 = _tmp56_ + 1;
							}
							_tmp55_ = FALSE;
							_tmp57_ = l2;
							_tmp58_ = self->priv->_block_cols;
							if (!(_tmp57_ < _tmp58_)) {
								break;
							}
							{
								gint l3 = 0;
								l3 = 0;
								{
									gboolean _tmp59_ = FALSE;
									_tmp59_ = TRUE;
									while (TRUE) {
										gint _tmp61_ = 0;
										gint _tmp62_ = 0;
										gint _tmp63_ = 0;
										gboolean* _tmp64_ = NULL;
										gint _tmp64__length1 = 0;
										gint _tmp64__length2 = 0;
										gint _tmp64__length3 = 0;
										gint _tmp65_ = 0;
										gint _tmp66_ = 0;
										gint _tmp67_ = 0;
										gboolean _tmp68_ = FALSE;
										if (!_tmp59_) {
											gint _tmp60_ = 0;
											_tmp60_ = l3;
											l3 = _tmp60_ + 1;
										}
										_tmp59_ = FALSE;
										_tmp61_ = l3;
										_tmp62_ = sudoku_board_get_max_val (self);
										_tmp63_ = _tmp62_;
										if (!(_tmp61_ < _tmp63_)) {
											break;
										}
										_tmp64_ = self->priv->possible_in_block;
										_tmp64__length1 = self->priv->possible_in_block_length1;
										_tmp64__length2 = self->priv->possible_in_block_length2;
										_tmp64__length3 = self->priv->possible_in_block_length3;
										_tmp65_ = l1;
										_tmp66_ = l2;
										_tmp67_ = l3;
										_tmp64_[(((_tmp65_ * _tmp64__length2) + _tmp66_) * _tmp64__length3) + _tmp67_] = TRUE;
										_tmp68_ = _tmp64_[(((_tmp65_ * _tmp64__length2) + _tmp66_) * _tmp64__length3) + _tmp67_];
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp69_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	_g_object_unref0 (self->broken_coords);
	self->broken_coords = (GeeSet*) _tmp69_;
	_tmp70_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = (GeeList*) _tmp70_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp71_ = FALSE;
			_tmp71_ = TRUE;
			while (TRUE) {
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				GeeList* _tmp75_ = NULL;
				GeeArrayList* _tmp76_ = NULL;
				GeeArrayList* _tmp77_ = NULL;
				GeeList* _tmp89_ = NULL;
				gint _tmp90_ = 0;
				GeeList* _tmp91_ = NULL;
				gint _tmp92_ = 0;
				gpointer _tmp93_ = NULL;
				GeeList* _tmp94_ = NULL;
				GeeList* _tmp95_ = NULL;
				GeeList* _tmp96_ = NULL;
				GeeList* _tmp97_ = NULL;
				if (!_tmp71_) {
					gint _tmp72_ = 0;
					_tmp72_ = col;
					col = _tmp72_ + 1;
				}
				_tmp71_ = FALSE;
				_tmp73_ = col;
				_tmp74_ = self->priv->_cols;
				if (!(_tmp73_ < _tmp74_)) {
					break;
				}
				_tmp75_ = self->coords_for_col;
				_tmp76_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp77_ = _tmp76_;
				gee_collection_add ((GeeCollection*) _tmp75_, (GeeList*) _tmp77_);
				_g_object_unref0 (_tmp77_);
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp78_ = FALSE;
						_tmp78_ = TRUE;
						while (TRUE) {
							gint _tmp80_ = 0;
							gint _tmp81_ = 0;
							GeeList* _tmp82_ = NULL;
							gint _tmp83_ = 0;
							gpointer _tmp84_ = NULL;
							GeeList* _tmp85_ = NULL;
							gint _tmp86_ = 0;
							gint _tmp87_ = 0;
							Coord _tmp88_ = {0};
							if (!_tmp78_) {
								gint _tmp79_ = 0;
								_tmp79_ = row;
								row = _tmp79_ + 1;
							}
							_tmp78_ = FALSE;
							_tmp80_ = row;
							_tmp81_ = self->priv->_rows;
							if (!(_tmp80_ < _tmp81_)) {
								break;
							}
							_tmp82_ = self->coords_for_col;
							_tmp83_ = col;
							_tmp84_ = gee_list_get (_tmp82_, _tmp83_);
							_tmp85_ = (GeeList*) _tmp84_;
							_tmp86_ = row;
							_tmp87_ = col;
							coord_init (&_tmp88_, _tmp86_, _tmp87_);
							gee_collection_add ((GeeCollection*) _tmp85_, &_tmp88_);
							_g_object_unref0 (_tmp85_);
						}
					}
				}
				_tmp89_ = self->coords_for_col;
				_tmp90_ = col;
				_tmp91_ = self->coords_for_col;
				_tmp92_ = col;
				_tmp93_ = gee_list_get (_tmp91_, _tmp92_);
				_tmp94_ = (GeeList*) _tmp93_;
				_tmp95_ = gee_list_get_read_only_view (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = _tmp96_;
				gee_list_set (_tmp89_, _tmp90_, _tmp97_);
				_g_object_unref0 (_tmp97_);
				_g_object_unref0 (_tmp94_);
			}
		}
	}
	_tmp98_ = self->coords_for_col;
	_tmp99_ = gee_list_get_read_only_view (_tmp98_);
	_tmp100_ = _tmp99_;
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = _tmp100_;
	_tmp101_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = (GeeList*) _tmp101_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp102_ = FALSE;
			_tmp102_ = TRUE;
			while (TRUE) {
				gint _tmp104_ = 0;
				gint _tmp105_ = 0;
				GeeList* _tmp106_ = NULL;
				GeeArrayList* _tmp107_ = NULL;
				GeeArrayList* _tmp108_ = NULL;
				GeeList* _tmp120_ = NULL;
				gint _tmp121_ = 0;
				GeeList* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gpointer _tmp124_ = NULL;
				GeeList* _tmp125_ = NULL;
				GeeList* _tmp126_ = NULL;
				GeeList* _tmp127_ = NULL;
				GeeList* _tmp128_ = NULL;
				if (!_tmp102_) {
					gint _tmp103_ = 0;
					_tmp103_ = row;
					row = _tmp103_ + 1;
				}
				_tmp102_ = FALSE;
				_tmp104_ = row;
				_tmp105_ = self->priv->_rows;
				if (!(_tmp104_ < _tmp105_)) {
					break;
				}
				_tmp106_ = self->coords_for_row;
				_tmp107_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp108_ = _tmp107_;
				gee_collection_add ((GeeCollection*) _tmp106_, (GeeList*) _tmp108_);
				_g_object_unref0 (_tmp108_);
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp109_ = FALSE;
						_tmp109_ = TRUE;
						while (TRUE) {
							gint _tmp111_ = 0;
							gint _tmp112_ = 0;
							GeeList* _tmp113_ = NULL;
							gint _tmp114_ = 0;
							gpointer _tmp115_ = NULL;
							GeeList* _tmp116_ = NULL;
							gint _tmp117_ = 0;
							gint _tmp118_ = 0;
							Coord _tmp119_ = {0};
							if (!_tmp109_) {
								gint _tmp110_ = 0;
								_tmp110_ = col;
								col = _tmp110_ + 1;
							}
							_tmp109_ = FALSE;
							_tmp111_ = col;
							_tmp112_ = self->priv->_cols;
							if (!(_tmp111_ < _tmp112_)) {
								break;
							}
							_tmp113_ = self->coords_for_row;
							_tmp114_ = row;
							_tmp115_ = gee_list_get (_tmp113_, _tmp114_);
							_tmp116_ = (GeeList*) _tmp115_;
							_tmp117_ = row;
							_tmp118_ = col;
							coord_init (&_tmp119_, _tmp117_, _tmp118_);
							gee_collection_add ((GeeCollection*) _tmp116_, &_tmp119_);
							_g_object_unref0 (_tmp116_);
						}
					}
				}
				_tmp120_ = self->coords_for_row;
				_tmp121_ = row;
				_tmp122_ = self->coords_for_row;
				_tmp123_ = row;
				_tmp124_ = gee_list_get (_tmp122_, _tmp123_);
				_tmp125_ = (GeeList*) _tmp124_;
				_tmp126_ = gee_list_get_read_only_view (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = _tmp127_;
				gee_list_set (_tmp120_, _tmp121_, _tmp128_);
				_g_object_unref0 (_tmp128_);
				_g_object_unref0 (_tmp125_);
			}
		}
	}
	_tmp129_ = self->coords_for_row;
	_tmp130_ = gee_list_get_read_only_view (_tmp129_);
	_tmp131_ = _tmp130_;
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = _tmp131_;
	_tmp132_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = (GeeMap*) _tmp132_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp133_ = FALSE;
			_tmp133_ = TRUE;
			while (TRUE) {
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				if (!_tmp133_) {
					gint _tmp134_ = 0;
					_tmp134_ = col;
					col = _tmp134_ + 1;
				}
				_tmp133_ = FALSE;
				_tmp135_ = col;
				_tmp136_ = self->priv->_block_cols;
				if (!(_tmp135_ < _tmp136_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp137_ = FALSE;
						_tmp137_ = TRUE;
						while (TRUE) {
							gint _tmp139_ = 0;
							gint _tmp140_ = 0;
							GeeMap* _tmp141_ = NULL;
							gint _tmp142_ = 0;
							gint _tmp143_ = 0;
							Coord _tmp144_ = {0};
							GeeArrayList* _tmp145_ = NULL;
							GeeArrayList* _tmp146_ = NULL;
							if (!_tmp137_) {
								gint _tmp138_ = 0;
								_tmp138_ = row;
								row = _tmp138_ + 1;
							}
							_tmp137_ = FALSE;
							_tmp139_ = row;
							_tmp140_ = self->priv->_block_rows;
							if (!(_tmp139_ < _tmp140_)) {
								break;
							}
							_tmp141_ = self->coords_for_block;
							_tmp142_ = row;
							_tmp143_ = col;
							coord_init (&_tmp144_, _tmp142_, _tmp143_);
							_tmp145_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
							_tmp146_ = _tmp145_;
							gee_map_set (_tmp141_, &_tmp144_, (GeeList*) _tmp146_);
							_g_object_unref0 (_tmp146_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp147_ = FALSE;
			_tmp147_ = TRUE;
			while (TRUE) {
				gint _tmp149_ = 0;
				gint _tmp150_ = 0;
				if (!_tmp147_) {
					gint _tmp148_ = 0;
					_tmp148_ = col;
					col = _tmp148_ + 1;
				}
				_tmp147_ = FALSE;
				_tmp149_ = col;
				_tmp150_ = self->priv->_cols;
				if (!(_tmp149_ < _tmp150_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp151_ = FALSE;
						_tmp151_ = TRUE;
						while (TRUE) {
							gint _tmp153_ = 0;
							gint _tmp154_ = 0;
							GeeMap* _tmp155_ = NULL;
							gint _tmp156_ = 0;
							gint _tmp157_ = 0;
							gint _tmp158_ = 0;
							gint _tmp159_ = 0;
							Coord _tmp160_ = {0};
							gpointer _tmp161_ = NULL;
							GeeList* _tmp162_ = NULL;
							gint _tmp163_ = 0;
							gint _tmp164_ = 0;
							Coord _tmp165_ = {0};
							if (!_tmp151_) {
								gint _tmp152_ = 0;
								_tmp152_ = row;
								row = _tmp152_ + 1;
							}
							_tmp151_ = FALSE;
							_tmp153_ = row;
							_tmp154_ = self->priv->_rows;
							if (!(_tmp153_ < _tmp154_)) {
								break;
							}
							_tmp155_ = self->coords_for_block;
							_tmp156_ = row;
							_tmp157_ = self->priv->_block_rows;
							_tmp158_ = col;
							_tmp159_ = self->priv->_block_cols;
							coord_init (&_tmp160_, _tmp156_ / _tmp157_, _tmp158_ / _tmp159_);
							_tmp161_ = gee_map_get (_tmp155_, &_tmp160_);
							_tmp162_ = (GeeList*) _tmp161_;
							_tmp163_ = row;
							_tmp164_ = col;
							coord_init (&_tmp165_, _tmp163_, _tmp164_);
							gee_collection_add ((GeeCollection*) _tmp162_, &_tmp165_);
							_g_object_unref0 (_tmp162_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp166_ = FALSE;
			_tmp166_ = TRUE;
			while (TRUE) {
				gint _tmp168_ = 0;
				gint _tmp169_ = 0;
				if (!_tmp166_) {
					gint _tmp167_ = 0;
					_tmp167_ = col;
					col = _tmp167_ + 1;
				}
				_tmp166_ = FALSE;
				_tmp168_ = col;
				_tmp169_ = self->priv->_block_cols;
				if (!(_tmp168_ < _tmp169_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp170_ = FALSE;
						_tmp170_ = TRUE;
						while (TRUE) {
							gint _tmp172_ = 0;
							gint _tmp173_ = 0;
							GeeMap* _tmp174_ = NULL;
							gint _tmp175_ = 0;
							gint _tmp176_ = 0;
							Coord _tmp177_ = {0};
							GeeMap* _tmp178_ = NULL;
							gint _tmp179_ = 0;
							gint _tmp180_ = 0;
							Coord _tmp181_ = {0};
							gpointer _tmp182_ = NULL;
							GeeList* _tmp183_ = NULL;
							GeeList* _tmp184_ = NULL;
							GeeList* _tmp185_ = NULL;
							GeeList* _tmp186_ = NULL;
							if (!_tmp170_) {
								gint _tmp171_ = 0;
								_tmp171_ = row;
								row = _tmp171_ + 1;
							}
							_tmp170_ = FALSE;
							_tmp172_ = row;
							_tmp173_ = self->priv->_block_rows;
							if (!(_tmp172_ < _tmp173_)) {
								break;
							}
							_tmp174_ = self->coords_for_block;
							_tmp175_ = row;
							_tmp176_ = col;
							coord_init (&_tmp177_, _tmp175_, _tmp176_);
							_tmp178_ = self->coords_for_block;
							_tmp179_ = row;
							_tmp180_ = col;
							coord_init (&_tmp181_, _tmp179_, _tmp180_);
							_tmp182_ = gee_map_get (_tmp178_, &_tmp181_);
							_tmp183_ = (GeeList*) _tmp182_;
							_tmp184_ = gee_list_get_read_only_view (_tmp183_);
							_tmp185_ = _tmp184_;
							_tmp186_ = _tmp185_;
							gee_map_set (_tmp174_, &_tmp177_, _tmp186_);
							_g_object_unref0 (_tmp186_);
							_g_object_unref0 (_tmp183_);
						}
					}
				}
			}
		}
	}
	_tmp187_ = self->coords_for_block;
	_tmp188_ = gee_map_get_read_only_view (_tmp187_);
	_tmp189_ = _tmp188_;
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = _tmp189_;
	return self;
}


SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols) {
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gboolean* _vala_array_dup2 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean* _vala_array_dup3 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean* _vala_array_dup4 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


static gboolean* _vala_array_dup5 (gboolean* self, int length) {
	return g_memdup (self, length * sizeof (gboolean));
}


SudokuBoard* sudoku_board_clone (SudokuBoard* self) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuBoard* _tmp2_ = NULL;
	gint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gboolean* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gboolean* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gboolean* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	gboolean* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gboolean* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gboolean* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	gint _tmp11__length3 = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp12__length2 = 0;
	gint _tmp12__length3 = 0;
	gint _tmp13_ = 0;
	GeeSet* _tmp14_ = NULL;
	GeeSet* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
	board = _tmp2_;
	_tmp3_ = self->cells;
	_tmp3__length1 = self->cells_length1;
	_tmp3__length2 = self->cells_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	board->cells = (g_free (board->cells), NULL);
	board->cells = _tmp4_;
	board->cells_length1 = _tmp4__length1;
	board->cells_length2 = _tmp4__length2;
	_tmp5_ = self->is_fixed;
	_tmp5__length1 = self->is_fixed_length1;
	_tmp5__length2 = self->is_fixed_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	board->is_fixed = (g_free (board->is_fixed), NULL);
	board->is_fixed = _tmp6_;
	board->is_fixed_length1 = _tmp6__length1;
	board->is_fixed_length2 = _tmp6__length2;
	_tmp7_ = self->priv->possible_in_row;
	_tmp7__length1 = self->priv->possible_in_row_length1;
	_tmp7__length2 = self->priv->possible_in_row_length2;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	_tmp8__length2 = _tmp7__length2;
	board->priv->possible_in_row = (g_free (board->priv->possible_in_row), NULL);
	board->priv->possible_in_row = _tmp8_;
	board->priv->possible_in_row_length1 = _tmp8__length1;
	board->priv->possible_in_row_length2 = _tmp8__length2;
	_tmp9_ = self->priv->possible_in_col;
	_tmp9__length1 = self->priv->possible_in_col_length1;
	_tmp9__length2 = self->priv->possible_in_col_length2;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	_tmp10__length2 = _tmp9__length2;
	board->priv->possible_in_col = (g_free (board->priv->possible_in_col), NULL);
	board->priv->possible_in_col = _tmp10_;
	board->priv->possible_in_col_length1 = _tmp10__length1;
	board->priv->possible_in_col_length2 = _tmp10__length2;
	_tmp11_ = self->priv->possible_in_block;
	_tmp11__length1 = self->priv->possible_in_block_length1;
	_tmp11__length2 = self->priv->possible_in_block_length2;
	_tmp11__length3 = self->priv->possible_in_block_length3;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, (_tmp11__length1 * _tmp11__length2) * _tmp11__length3) : ((gpointer) _tmp11_);
	_tmp12__length1 = _tmp11__length1;
	_tmp12__length2 = _tmp11__length2;
	_tmp12__length3 = _tmp11__length3;
	board->priv->possible_in_block = (g_free (board->priv->possible_in_block), NULL);
	board->priv->possible_in_block = _tmp12_;
	board->priv->possible_in_block_length1 = _tmp12__length1;
	board->priv->possible_in_block_length2 = _tmp12__length2;
	board->priv->possible_in_block_length3 = _tmp12__length3;
	_tmp13_ = self->priv->_filled;
	board->priv->_filled = _tmp13_;
	_tmp14_ = board->broken_coords;
	_tmp15_ = self->broken_coords;
	gee_collection_add_all ((GeeCollection*) _tmp14_, (GeeCollection*) _tmp15_);
	result = board;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


void sudoku_board_set_from_string (SudokuBoard* self, const gchar* s, const gchar* delimiter, const gchar* empty_value, const gchar* rating_delimiter) {
	gint number_of_cells = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar** cells = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint cells_length1 = 0;
	gint _cells_size_ = 0;
	gchar** rating = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint rating_length1 = 0;
	gint _rating_size_ = 0;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	const gchar* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (delimiter != NULL);
	g_return_if_fail (empty_value != NULL);
	g_return_if_fail (rating_delimiter != NULL);
	_tmp0_ = self->priv->_cols;
	_tmp1_ = self->priv->_rows;
	number_of_cells = _tmp0_ * _tmp1_;
	_tmp2_ = s;
	_tmp3_ = delimiter;
	_tmp4_ = number_of_cells;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp2_, _tmp3_, _tmp4_);
	cells = _tmp6_;
	cells_length1 = _vala_array_length (_tmp5_);
	_cells_size_ = cells_length1;
	_tmp7_ = cells;
	_tmp7__length1 = cells_length1;
	_tmp8_ = cells;
	_tmp8__length1 = cells_length1;
	_tmp9_ = _tmp7_[_tmp8__length1 - 1];
	_tmp10_ = rating_delimiter;
	_tmp12_ = _tmp11_ = g_strsplit (_tmp9_, _tmp10_, 2);
	rating = _tmp12_;
	rating_length1 = _vala_array_length (_tmp11_);
	_rating_size_ = rating_length1;
	_tmp13_ = cells;
	_tmp13__length1 = cells_length1;
	_tmp14_ = cells;
	_tmp14__length1 = cells_length1;
	_tmp15_ = rating;
	_tmp15__length1 = rating_length1;
	_tmp16_ = _tmp15_[0];
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (_tmp13_[_tmp14__length1 - 1]);
	_tmp13_[_tmp14__length1 - 1] = _tmp17_;
	_tmp18_ = _tmp13_[_tmp14__length1 - 1];
	_tmp19_ = rating;
	_tmp19__length1 = rating_length1;
	_tmp20_ = _tmp19_[1];
	_tmp21_ = double_parse (_tmp20_);
	sudoku_board_set_difficulty_rating (self, _tmp21_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gchar* cell = NULL;
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = number_of_cells;
				if (!(_tmp24_ < _tmp25_)) {
					break;
				}
				_tmp26_ = cells;
				_tmp26__length1 = cells_length1;
				_tmp27_ = i;
				_tmp28_ = _tmp26_[_tmp27_];
				_tmp29_ = g_strdup (_tmp28_);
				cell = _tmp29_;
				_tmp30_ = cell;
				_tmp31_ = empty_value;
				if (g_strcmp0 (_tmp30_, _tmp31_) != 0) {
					gint val = 0;
					const gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					gboolean _tmp34_ = FALSE;
					gint _tmp35_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					_tmp32_ = cell;
					_tmp33_ = atoi (_tmp32_);
					val = _tmp33_;
					_tmp35_ = val;
					if (_tmp35_ >= 1) {
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						_tmp36_ = val;
						_tmp37_ = sudoku_board_get_max_val (self);
						_tmp38_ = _tmp37_;
						_tmp34_ = _tmp36_ <= _tmp38_;
					} else {
						_tmp34_ = FALSE;
					}
					_vala_assert (_tmp34_, "val >= 1 && val <= max_val");
					_tmp39_ = i;
					_tmp40_ = self->priv->_cols;
					_tmp41_ = i;
					_tmp42_ = self->priv->_cols;
					_tmp43_ = val;
					sudoku_board_insert (self, _tmp39_ / _tmp40_, _tmp41_ % _tmp42_, _tmp43_, TRUE);
				}
				_g_free0 (cell);
			}
		}
	}
	rating = (_vala_array_free (rating, rating_length1, (GDestroyNotify) g_free), NULL);
	cells = (_vala_array_free (cells, cells_length1, (GDestroyNotify) g_free), NULL);
}


gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = val;
	val = _tmp0_ - 1;
	_tmp3_ = self->priv->possible_in_row;
	_tmp3__length1 = self->priv->possible_in_row_length1;
	_tmp3__length2 = self->priv->possible_in_row_length2;
	_tmp4_ = row;
	_tmp5_ = val;
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
	if (_tmp6_) {
		gboolean* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = self->priv->possible_in_col;
		_tmp7__length1 = self->priv->possible_in_col_length1;
		_tmp7__length2 = self->priv->possible_in_col_length2;
		_tmp8_ = col;
		_tmp9_ = val;
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
		_tmp2_ = _tmp10_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp11__length3 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
		_tmp11_ = self->priv->possible_in_block;
		_tmp11__length1 = self->priv->possible_in_block_length1;
		_tmp11__length2 = self->priv->possible_in_block_length2;
		_tmp11__length3 = self->priv->possible_in_block_length3;
		_tmp12_ = row;
		_tmp13_ = self->priv->_block_cols;
		_tmp14_ = col;
		_tmp15_ = self->priv->_block_rows;
		_tmp16_ = val;
		_tmp17_ = _tmp11_[((((_tmp12_ / _tmp13_) * _tmp11__length2) + (_tmp14_ / _tmp15_)) * _tmp11__length3) + _tmp16_];
		_tmp1_ = _tmp17_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}


gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = row;
	_tmp1_ = col;
	_tmp3_ = sudoku_board_get_possibilities (self, _tmp0_, _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = _tmp2_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	result = _tmp5_;
	return result;
}


static gint* _vala_array_dup6 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint* possibilities = NULL;
	gint* _tmp6_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gint count = 0;
	gint* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	if (_tmp3_ != 0) {
		gint* _tmp4_ = NULL;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp4_ = g_new0 (gint, 0);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_new0 (gint, 9);
	possibilities = _tmp6_;
	possibilities_length1 = 9;
	_possibilities_size_ = possibilities_length1;
	count = 0;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = l;
					l = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = l;
				_tmp10_ = sudoku_board_get_max_val (self);
				_tmp11_ = _tmp10_;
				if (!(_tmp9_ <= _tmp11_)) {
					break;
				}
				_tmp12_ = row;
				_tmp13_ = col;
				_tmp14_ = l;
				_tmp15_ = sudoku_board_is_possible (self, _tmp12_, _tmp13_, _tmp14_);
				if (_tmp15_) {
					gint* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					_tmp16_ = possibilities;
					_tmp16__length1 = possibilities_length1;
					_tmp17_ = count;
					_tmp18_ = l;
					_tmp16_[_tmp17_] = _tmp18_;
					_tmp19_ = _tmp16_[_tmp17_];
					_tmp20_ = count;
					count = _tmp20_ + 1;
				}
			}
		}
	}
	_tmp21_ = possibilities;
	_tmp21__length1 = possibilities_length1;
	_tmp22_ = count;
	_tmp23_ = ((_tmp21_ + 0) != NULL) ? _vala_array_dup6 (_tmp21_ + 0, _tmp22_ - 0) : ((gpointer) (_tmp21_ + 0));
	_tmp23__length1 = _tmp22_ - 0;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = _tmp23__length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	possibilities = (g_free (possibilities), NULL);
	return result;
}


gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gboolean* result = NULL;
	gboolean* possibilities = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean* _tmp2_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	possibilities = _tmp2_;
	possibilities_length1 = _tmp1_;
	_possibilities_size_ = possibilities_length1;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gboolean* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = l;
					l = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = l;
				_tmp6_ = sudoku_board_get_max_val (self);
				_tmp7_ = _tmp6_;
				if (!(_tmp5_ <= _tmp7_)) {
					break;
				}
				_tmp8_ = possibilities;
				_tmp8__length1 = possibilities_length1;
				_tmp9_ = l;
				_tmp10_ = row;
				_tmp11_ = col;
				_tmp12_ = l;
				_tmp13_ = sudoku_board_is_possible (self, _tmp10_, _tmp11_, _tmp12_);
				_tmp8_[_tmp9_ - 1] = _tmp13_;
				_tmp14_ = _tmp8_[_tmp9_ - 1];
			}
		}
	}
	_tmp15_ = possibilities;
	_tmp15__length1 = possibilities_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}


void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Coord _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = row;
	_tmp1_ = self->priv->_block_rows;
	_tmp2_ = col;
	_tmp3_ = self->priv->_block_cols;
	coord_init (&_tmp4_, _tmp0_ / _tmp1_, _tmp2_ / _tmp3_);
	*result = _tmp4_;
	return;
}


void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gboolean* _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	gint _tmp27__length2 = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	gboolean* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gint _tmp36__length2 = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean* _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gint _tmp45__length2 = 0;
	gint _tmp45__length3 = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gboolean _tmp51_ = FALSE;
	gint _tmp61_ = 0;
	gboolean* _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	gint _tmp62__length2 = 0;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gboolean _tmp65_ = FALSE;
	gboolean* _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	gint _tmp66__length2 = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gboolean _tmp69_ = FALSE;
	gboolean* _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gint _tmp70__length2 = 0;
	gint _tmp70__length3 = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = val;
	_vala_assert (_tmp0_ > 0, "val > 0");
	_tmp1_ = val;
	_tmp2_ = sudoku_board_get_max_val (self);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp1_ <= _tmp3_, "val <= max_val");
	_tmp4_ = is_fixed;
	if (!_tmp4_) {
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->is_fixed;
		_tmp5__length1 = self->is_fixed_length1;
		_tmp5__length2 = self->is_fixed_length2;
		_tmp6_ = row;
		_tmp7_ = col;
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
	}
	_tmp9_ = self->cells;
	_tmp9__length1 = self->cells_length1;
	_tmp9__length2 = self->cells_length2;
	_tmp10_ = row;
	_tmp11_ = col;
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
	if (_tmp12_ != 0) {
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = row;
		_tmp14_ = col;
		_tmp15_ = is_fixed;
		sudoku_board_remove (self, _tmp13_, _tmp14_, _tmp15_);
	}
	_tmp16_ = self->cells;
	_tmp16__length1 = self->cells_length1;
	_tmp16__length2 = self->cells_length2;
	_tmp17_ = row;
	_tmp18_ = col;
	_tmp19_ = val;
	_tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_] = _tmp19_;
	_tmp20_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
	_tmp21_ = self->is_fixed;
	_tmp21__length1 = self->is_fixed_length1;
	_tmp21__length2 = self->is_fixed_length2;
	_tmp22_ = row;
	_tmp23_ = col;
	_tmp24_ = is_fixed;
	_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_;
	_tmp25_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
	_tmp26_ = self->priv->_filled;
	self->priv->_filled = _tmp26_ + 1;
	_tmp27_ = self->priv->possible_in_row;
	_tmp27__length1 = self->priv->possible_in_row_length1;
	_tmp27__length2 = self->priv->possible_in_row_length2;
	_tmp28_ = row;
	_tmp29_ = val;
	_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + (_tmp29_ - 1)];
	if (!_tmp30_) {
		GeeList* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gpointer _tmp33_ = NULL;
		GeeList* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		_tmp31_ = self->coords_for_row;
		_tmp32_ = row;
		_tmp33_ = gee_list_get (_tmp31_, _tmp32_);
		_tmp34_ = (GeeList*) _tmp33_;
		_tmp35_ = val;
		sudoku_board_mark_breakages_for (self, _tmp34_, _tmp35_);
		_g_object_unref0 (_tmp34_);
	}
	_tmp36_ = self->priv->possible_in_col;
	_tmp36__length1 = self->priv->possible_in_col_length1;
	_tmp36__length2 = self->priv->possible_in_col_length2;
	_tmp37_ = col;
	_tmp38_ = val;
	_tmp39_ = _tmp36_[(_tmp37_ * _tmp36__length2) + (_tmp38_ - 1)];
	if (!_tmp39_) {
		GeeList* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gpointer _tmp42_ = NULL;
		GeeList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		_tmp40_ = self->coords_for_col;
		_tmp41_ = col;
		_tmp42_ = gee_list_get (_tmp40_, _tmp41_);
		_tmp43_ = (GeeList*) _tmp42_;
		_tmp44_ = val;
		sudoku_board_mark_breakages_for (self, _tmp43_, _tmp44_);
		_g_object_unref0 (_tmp43_);
	}
	_tmp45_ = self->priv->possible_in_block;
	_tmp45__length1 = self->priv->possible_in_block_length1;
	_tmp45__length2 = self->priv->possible_in_block_length2;
	_tmp45__length3 = self->priv->possible_in_block_length3;
	_tmp46_ = row;
	_tmp47_ = self->priv->_block_cols;
	_tmp48_ = col;
	_tmp49_ = self->priv->_block_rows;
	_tmp50_ = val;
	_tmp51_ = _tmp45_[((((_tmp46_ / _tmp47_) * _tmp45__length2) + (_tmp48_ / _tmp49_)) * _tmp45__length3) + (_tmp50_ - 1)];
	if (!_tmp51_) {
		GeeMap* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		Coord _tmp57_ = {0};
		gpointer _tmp58_ = NULL;
		GeeList* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		_tmp52_ = self->coords_for_block;
		_tmp53_ = row;
		_tmp54_ = self->priv->_block_cols;
		_tmp55_ = col;
		_tmp56_ = self->priv->_block_rows;
		coord_init (&_tmp57_, _tmp53_ / _tmp54_, _tmp55_ / _tmp56_);
		_tmp58_ = gee_map_get (_tmp52_, &_tmp57_);
		_tmp59_ = (GeeList*) _tmp58_;
		_tmp60_ = val;
		sudoku_board_mark_breakages_for (self, _tmp59_, _tmp60_);
		_g_object_unref0 (_tmp59_);
	}
	_tmp61_ = val;
	val = _tmp61_ - 1;
	_tmp62_ = self->priv->possible_in_row;
	_tmp62__length1 = self->priv->possible_in_row_length1;
	_tmp62__length2 = self->priv->possible_in_row_length2;
	_tmp63_ = row;
	_tmp64_ = val;
	_tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_] = FALSE;
	_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_];
	_tmp66_ = self->priv->possible_in_col;
	_tmp66__length1 = self->priv->possible_in_col_length1;
	_tmp66__length2 = self->priv->possible_in_col_length2;
	_tmp67_ = col;
	_tmp68_ = val;
	_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_] = FALSE;
	_tmp69_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
	_tmp70_ = self->priv->possible_in_block;
	_tmp70__length1 = self->priv->possible_in_block_length1;
	_tmp70__length2 = self->priv->possible_in_block_length2;
	_tmp70__length3 = self->priv->possible_in_block_length3;
	_tmp71_ = row;
	_tmp72_ = self->priv->_block_cols;
	_tmp73_ = col;
	_tmp74_ = self->priv->_block_rows;
	_tmp75_ = val;
	_tmp70_[((((_tmp71_ / _tmp72_) * _tmp70__length2) + (_tmp73_ / _tmp74_)) * _tmp70__length3) + _tmp75_] = FALSE;
	_tmp76_ = _tmp70_[((((_tmp71_ / _tmp72_) * _tmp70__length2) + (_tmp73_ / _tmp74_)) * _tmp70__length3) + _tmp75_];
	_tmp77_ = sudoku_board_get_complete (self);
	_tmp78_ = _tmp77_;
	if (_tmp78_) {
		g_signal_emit_by_name (self, "completed");
	}
}


void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = val;
	if (_tmp0_ == 0) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = row;
		_tmp2_ = col;
		sudoku_board_remove (self, _tmp1_, _tmp2_, FALSE);
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		_tmp4_ = val;
		if (_tmp4_ > 0) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp5_ = val;
			_tmp6_ = sudoku_board_get_max_val (self);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp5_ <= _tmp7_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			_tmp8_ = row;
			_tmp9_ = col;
			_tmp10_ = val;
			sudoku_board_insert (self, _tmp8_, _tmp9_, _tmp10_, FALSE);
		} else {
			g_assert_not_reached ();
		}
	}
}


gint sudoku_board_get (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	result = _tmp3_;
	return result;
}


void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint previous_val = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GeeSet* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Coord _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	gint _tmp126_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	if (_tmp3_ == 0) {
		return;
	}
	_tmp4_ = is_fixed;
	if (!_tmp4_) {
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->is_fixed;
		_tmp5__length1 = self->is_fixed_length1;
		_tmp5__length2 = self->is_fixed_length2;
		_tmp6_ = row;
		_tmp7_ = col;
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
	}
	_tmp9_ = self->cells;
	_tmp9__length1 = self->cells_length1;
	_tmp9__length2 = self->cells_length2;
	_tmp10_ = row;
	_tmp11_ = col;
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
	previous_val = _tmp12_;
	_tmp13_ = self->cells;
	_tmp13__length1 = self->cells_length1;
	_tmp13__length2 = self->cells_length2;
	_tmp14_ = row;
	_tmp15_ = col;
	_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = 0;
	_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
	_tmp17_ = self->broken_coords;
	_tmp18_ = row;
	_tmp19_ = col;
	coord_init (&_tmp20_, _tmp18_, _tmp19_);
	_tmp21_ = gee_collection_contains ((GeeCollection*) _tmp17_, &_tmp20_);
	if (_tmp21_) {
		GeeList* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gpointer _tmp24_ = NULL;
		GeeList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gpointer _tmp29_ = NULL;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		GeeMap* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Coord _tmp37_ = {0};
		gpointer _tmp38_ = NULL;
		GeeList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		GeeSet* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Coord _tmp44_ = {0};
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gpointer _tmp47_ = NULL;
		GeeList* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		GeeList* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gpointer _tmp52_ = NULL;
		GeeList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		GeeMap* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		Coord _tmp60_ = {0};
		gpointer _tmp61_ = NULL;
		GeeList* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gboolean* _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		gint _tmp64__length2 = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GeeList* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gpointer _tmp69_ = NULL;
		GeeList* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		GeeSet* _tmp72_ = NULL;
		GeeSet* _tmp73_ = NULL;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gboolean _tmp76_ = FALSE;
		gboolean* _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		gint _tmp77__length2 = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		GeeList* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		gpointer _tmp82_ = NULL;
		GeeList* _tmp83_ = NULL;
		gint _tmp84_ = 0;
		GeeSet* _tmp85_ = NULL;
		GeeSet* _tmp86_ = NULL;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		gboolean _tmp89_ = FALSE;
		gboolean* _tmp90_ = NULL;
		gint _tmp90__length1 = 0;
		gint _tmp90__length2 = 0;
		gint _tmp90__length3 = 0;
		gint _tmp91_ = 0;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		gint _tmp95_ = 0;
		GeeMap* _tmp96_ = NULL;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		gint _tmp100_ = 0;
		Coord _tmp101_ = {0};
		gpointer _tmp102_ = NULL;
		GeeList* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		GeeSet* _tmp105_ = NULL;
		GeeSet* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		gboolean _tmp109_ = FALSE;
		_tmp22_ = self->coords_for_row;
		_tmp23_ = row;
		_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
		_tmp25_ = (GeeList*) _tmp24_;
		_tmp26_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp25_, _tmp26_);
		_g_object_unref0 (_tmp25_);
		_tmp27_ = self->coords_for_col;
		_tmp28_ = col;
		_tmp29_ = gee_list_get (_tmp27_, _tmp28_);
		_tmp30_ = (GeeList*) _tmp29_;
		_tmp31_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp30_, _tmp31_);
		_g_object_unref0 (_tmp30_);
		_tmp32_ = self->coords_for_block;
		_tmp33_ = row;
		_tmp34_ = self->priv->_block_rows;
		_tmp35_ = col;
		_tmp36_ = self->priv->_block_cols;
		coord_init (&_tmp37_, _tmp33_ / _tmp34_, _tmp35_ / _tmp36_);
		_tmp38_ = gee_map_get (_tmp32_, &_tmp37_);
		_tmp39_ = (GeeList*) _tmp38_;
		_tmp40_ = previous_val;
		sudoku_board_remove_breakages_for (self, _tmp39_, _tmp40_);
		_g_object_unref0 (_tmp39_);
		_tmp41_ = self->broken_coords;
		_tmp42_ = row;
		_tmp43_ = col;
		coord_init (&_tmp44_, _tmp42_, _tmp43_);
		gee_collection_remove ((GeeCollection*) _tmp41_, &_tmp44_);
		_tmp45_ = self->coords_for_row;
		_tmp46_ = row;
		_tmp47_ = gee_list_get (_tmp45_, _tmp46_);
		_tmp48_ = (GeeList*) _tmp47_;
		_tmp49_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp48_, _tmp49_);
		_g_object_unref0 (_tmp48_);
		_tmp50_ = self->coords_for_col;
		_tmp51_ = col;
		_tmp52_ = gee_list_get (_tmp50_, _tmp51_);
		_tmp53_ = (GeeList*) _tmp52_;
		_tmp54_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp53_, _tmp54_);
		_g_object_unref0 (_tmp53_);
		_tmp55_ = self->coords_for_block;
		_tmp56_ = row;
		_tmp57_ = self->priv->_block_rows;
		_tmp58_ = col;
		_tmp59_ = self->priv->_block_cols;
		coord_init (&_tmp60_, _tmp56_ / _tmp57_, _tmp58_ / _tmp59_);
		_tmp61_ = gee_map_get (_tmp55_, &_tmp60_);
		_tmp62_ = (GeeList*) _tmp61_;
		_tmp63_ = previous_val;
		sudoku_board_mark_breakages_for (self, _tmp62_, _tmp63_);
		_g_object_unref0 (_tmp62_);
		_tmp64_ = self->priv->possible_in_row;
		_tmp64__length1 = self->priv->possible_in_row_length1;
		_tmp64__length2 = self->priv->possible_in_row_length2;
		_tmp65_ = row;
		_tmp66_ = previous_val;
		_tmp67_ = self->coords_for_row;
		_tmp68_ = row;
		_tmp69_ = gee_list_get (_tmp67_, _tmp68_);
		_tmp70_ = (GeeList*) _tmp69_;
		_tmp71_ = previous_val;
		_tmp72_ = sudoku_board_get_occurances (self, _tmp70_, _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = gee_collection_get_size ((GeeCollection*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)] = _tmp75_ == 0;
		_tmp76_ = _tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)];
		_g_object_unref0 (_tmp73_);
		_g_object_unref0 (_tmp70_);
		_tmp77_ = self->priv->possible_in_col;
		_tmp77__length1 = self->priv->possible_in_col_length1;
		_tmp77__length2 = self->priv->possible_in_col_length2;
		_tmp78_ = col;
		_tmp79_ = previous_val;
		_tmp80_ = self->coords_for_col;
		_tmp81_ = col;
		_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
		_tmp83_ = (GeeList*) _tmp82_;
		_tmp84_ = previous_val;
		_tmp85_ = sudoku_board_get_occurances (self, _tmp83_, _tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = gee_collection_get_size ((GeeCollection*) _tmp86_);
		_tmp88_ = _tmp87_;
		_tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)] = _tmp88_ == 0;
		_tmp89_ = _tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)];
		_g_object_unref0 (_tmp86_);
		_g_object_unref0 (_tmp83_);
		_tmp90_ = self->priv->possible_in_block;
		_tmp90__length1 = self->priv->possible_in_block_length1;
		_tmp90__length2 = self->priv->possible_in_block_length2;
		_tmp90__length3 = self->priv->possible_in_block_length3;
		_tmp91_ = row;
		_tmp92_ = self->priv->_block_cols;
		_tmp93_ = col;
		_tmp94_ = self->priv->_block_rows;
		_tmp95_ = previous_val;
		_tmp96_ = self->coords_for_block;
		_tmp97_ = row;
		_tmp98_ = self->priv->_block_rows;
		_tmp99_ = col;
		_tmp100_ = self->priv->_block_cols;
		coord_init (&_tmp101_, _tmp97_ / _tmp98_, _tmp99_ / _tmp100_);
		_tmp102_ = gee_map_get (_tmp96_, &_tmp101_);
		_tmp103_ = (GeeList*) _tmp102_;
		_tmp104_ = previous_val;
		_tmp105_ = sudoku_board_get_occurances (self, _tmp103_, _tmp104_);
		_tmp106_ = _tmp105_;
		_tmp107_ = gee_collection_get_size ((GeeCollection*) _tmp106_);
		_tmp108_ = _tmp107_;
		_tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)] = _tmp108_ == 0;
		_tmp109_ = _tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)];
		_g_object_unref0 (_tmp106_);
		_g_object_unref0 (_tmp103_);
	} else {
		gint _tmp110_ = 0;
		gboolean* _tmp111_ = NULL;
		gint _tmp111__length1 = 0;
		gint _tmp111__length2 = 0;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean* _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		gint _tmp115__length2 = 0;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		gboolean _tmp118_ = FALSE;
		gboolean* _tmp119_ = NULL;
		gint _tmp119__length1 = 0;
		gint _tmp119__length2 = 0;
		gint _tmp119__length3 = 0;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		gboolean _tmp125_ = FALSE;
		_tmp110_ = previous_val;
		previous_val = _tmp110_ - 1;
		_tmp111_ = self->priv->possible_in_row;
		_tmp111__length1 = self->priv->possible_in_row_length1;
		_tmp111__length2 = self->priv->possible_in_row_length2;
		_tmp112_ = row;
		_tmp113_ = previous_val;
		_tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_] = TRUE;
		_tmp114_ = _tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_];
		_tmp115_ = self->priv->possible_in_col;
		_tmp115__length1 = self->priv->possible_in_col_length1;
		_tmp115__length2 = self->priv->possible_in_col_length2;
		_tmp116_ = col;
		_tmp117_ = previous_val;
		_tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_] = TRUE;
		_tmp118_ = _tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_];
		_tmp119_ = self->priv->possible_in_block;
		_tmp119__length1 = self->priv->possible_in_block_length1;
		_tmp119__length2 = self->priv->possible_in_block_length2;
		_tmp119__length3 = self->priv->possible_in_block_length3;
		_tmp120_ = row;
		_tmp121_ = self->priv->_block_cols;
		_tmp122_ = col;
		_tmp123_ = self->priv->_block_rows;
		_tmp124_ = previous_val;
		_tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_] = TRUE;
		_tmp125_ = _tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_];
	}
	_tmp126_ = self->priv->_filled;
	self->priv->_filled = _tmp126_ - 1;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* result = NULL;
	GeeSet* occurances = NULL;
	GeeHashSet* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (coords != NULL, NULL);
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	occurances = (GeeSet*) _tmp0_;
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp1_ = NULL;
		GeeList* _tmp2_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _coord_index = 0;
		_tmp1_ = coords;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_coord_list = _tmp2_;
		_tmp3_ = _coord_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_coord_size = _tmp5_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Coord coord = {0};
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Coord* _tmp12_ = NULL;
			Coord _tmp13_ = {0};
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp6_ = _coord_index;
			_coord_index = _tmp6_ + 1;
			_tmp7_ = _coord_index;
			_tmp8_ = _coord_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _coord_list;
			_tmp10_ = _coord_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			_tmp12_ = (Coord*) _tmp11_;
			_tmp13_ = *_tmp12_;
			_coord_free0 (_tmp12_);
			coord = _tmp13_;
			_tmp14_ = self->cells;
			_tmp14__length1 = self->cells_length1;
			_tmp14__length2 = self->cells_length2;
			_tmp15_ = coord;
			_tmp16_ = _tmp15_.row;
			_tmp17_ = coord;
			_tmp18_ = _tmp17_.col;
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
			_tmp20_ = val;
			if (_tmp19_ == _tmp20_) {
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				_tmp21_ = occurances;
				_tmp22_ = coord;
				gee_collection_add ((GeeCollection*) _tmp21_, &_tmp22_);
			}
		}
		_g_object_unref0 (_coord_list);
	}
	result = occurances;
	return result;
}


gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_row;
	_tmp1_ = row;
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = val;
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != 0;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}


gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_col;
	_tmp1_ = col;
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = val;
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != 0;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}


gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val) {
	gboolean result = FALSE;
	GeeMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (block != NULL, FALSE);
	_tmp0_ = self->coords_for_block;
	_tmp1_ = *block;
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = val;
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != 0;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _coord_index = 0;
		_tmp0_ = coords;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_coord_list = _tmp1_;
		_tmp2_ = _coord_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_coord_size = _tmp4_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Coord coord = {0};
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			gboolean _tmp13_ = FALSE;
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp5_ = _coord_index;
			_coord_index = _tmp5_ + 1;
			_tmp6_ = _coord_index;
			_tmp7_ = _coord_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _coord_list;
			_tmp9_ = _coord_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			_tmp11_ = (Coord*) _tmp10_;
			_tmp12_ = *_tmp11_;
			_coord_free0 (_tmp11_);
			coord = _tmp12_;
			_tmp14_ = self->cells;
			_tmp14__length1 = self->cells_length1;
			_tmp14__length2 = self->cells_length2;
			_tmp15_ = coord;
			_tmp16_ = _tmp15_.row;
			_tmp17_ = coord;
			_tmp18_ = _tmp17_.col;
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
			_tmp20_ = val;
			if (_tmp19_ == _tmp20_) {
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
				_tmp21_ = self->broken_coords;
				_tmp22_ = coord;
				_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp21_, &_tmp22_);
				_tmp13_ = _tmp23_;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GeeSet* _tmp24_ = NULL;
				Coord _tmp25_ = {0};
				_tmp24_ = self->broken_coords;
				_tmp25_ = coord;
				gee_collection_remove ((GeeCollection*) _tmp24_, &_tmp25_);
			}
		}
		_g_object_unref0 (_coord_list);
	}
}


static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* occurances = NULL;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	_tmp0_ = coords;
	_tmp1_ = val;
	_tmp2_ = sudoku_board_get_occurances (self, _tmp0_, _tmp1_);
	occurances = _tmp2_;
	_tmp3_ = occurances;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != 1) {
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		_tmp6_ = self->broken_coords;
		_tmp7_ = occurances;
		gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp7_);
	}
	_g_object_unref0 (occurances);
}


void sudoku_board_to_initial_state (SudokuBoard* self) {
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = l1;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gboolean* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gboolean _tmp11_ = FALSE;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = l2;
								l2 = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = l2;
							_tmp7_ = self->priv->_cols;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = self->is_fixed;
							_tmp8__length1 = self->is_fixed_length1;
							_tmp8__length2 = self->is_fixed_length2;
							_tmp9_ = l1;
							_tmp10_ = l2;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							if (!_tmp11_) {
								gint _tmp12_ = 0;
								gint _tmp13_ = 0;
								_tmp12_ = l1;
								_tmp13_ = l2;
								sudoku_board_remove (self, _tmp12_, _tmp13_, FALSE);
							}
						}
					}
				}
			}
		}
	}
}


void sudoku_board_print (SudokuBoard* self, gint indent) {
	FILE* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				FILE* _tmp21_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = l1;
				if (!(_tmp2_ < 9)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							FILE* _tmp7_ = NULL;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = i;
							_tmp6_ = indent;
							if (!(_tmp5_ < _tmp6_)) {
								break;
							}
							_tmp7_ = stdout;
							fprintf (_tmp7_, " ");
						}
					}
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_ = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = l2;
								l2 = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = l2;
							if (!(_tmp10_ < 9)) {
								break;
							}
							_tmp11_ = self->cells;
							_tmp11__length1 = self->cells_length1;
							_tmp11__length2 = self->cells_length2;
							_tmp12_ = l1;
							_tmp13_ = l2;
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
							if (_tmp14_ != 0) {
								FILE* _tmp15_ = NULL;
								gint* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								gint _tmp16__length2 = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								_tmp15_ = stdout;
								_tmp16_ = self->cells;
								_tmp16__length1 = self->cells_length1;
								_tmp16__length2 = self->cells_length2;
								_tmp17_ = l1;
								_tmp18_ = l2;
								_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
								fprintf (_tmp15_, "%d ", _tmp19_);
							} else {
								FILE* _tmp20_ = NULL;
								_tmp20_ = stdout;
								fprintf (_tmp20_, "  ");
							}
						}
					}
				}
				_tmp21_ = stdout;
				fprintf (_tmp21_, "\n");
			}
		}
	}
	_tmp22_ = stdout;
	fflush (_tmp22_);
}


void sudoku_board_get_string (SudokuBoard* self) {
	FILE* _tmp0_ = NULL;
	FILE* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "[ ");
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				FILE* _tmp4_ = NULL;
				FILE* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = l1;
				if (!(_tmp3_ < 9)) {
					break;
				}
				_tmp4_ = stdout;
				fprintf (_tmp4_, "[ ");
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							FILE* _tmp8_ = NULL;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = l2;
							if (!(_tmp7_ < 9)) {
								break;
							}
							_tmp8_ = stdout;
							_tmp9_ = self->cells;
							_tmp9__length1 = self->cells_length1;
							_tmp9__length2 = self->cells_length2;
							_tmp10_ = l1;
							_tmp11_ = l2;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							fprintf (_tmp8_, "%d", _tmp12_);
							_tmp13_ = l2;
							if (_tmp13_ != 8) {
								FILE* _tmp14_ = NULL;
								_tmp14_ = stdout;
								fprintf (_tmp14_, ",");
							}
						}
					}
				}
				_tmp15_ = stdout;
				fprintf (_tmp15_, " ]");
				_tmp16_ = l1;
				if (_tmp16_ != 8) {
					FILE* _tmp17_ = NULL;
					_tmp17_ = stdout;
					fprintf (_tmp17_, ",");
				}
			}
		}
	}
	_tmp18_ = stdout;
	fprintf (_tmp18_, " ]");
}


gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state) {
	gchar* result = NULL;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	board_string = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gboolean* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = j;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = self->is_fixed;
							_tmp9__length1 = self->is_fixed_length1;
							_tmp9__length2 = self->is_fixed_length2;
							_tmp10_ = i;
							_tmp11_ = j;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							if (_tmp12_) {
								const gchar* _tmp13_ = NULL;
								gint* _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								gint _tmp14__length2 = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
								_tmp13_ = board_string;
								_tmp14_ = self->cells;
								_tmp14__length1 = self->cells_length1;
								_tmp14__length2 = self->cells_length2;
								_tmp15_ = i;
								_tmp16_ = j;
								_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
								_tmp18_ = g_strdup_printf ("%i", _tmp17_);
								_tmp19_ = _tmp18_;
								_tmp20_ = g_strconcat (_tmp13_, _tmp19_, NULL);
								_g_free0 (board_string);
								board_string = _tmp20_;
								_g_free0 (_tmp19_);
							} else {
								gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp29_ = NULL;
								gchar* _tmp30_ = NULL;
								_tmp22_ = get_original_state;
								if (_tmp22_) {
									gchar* _tmp23_ = NULL;
									_tmp23_ = g_strdup ("0");
									_g_free0 (_tmp21_);
									_tmp21_ = _tmp23_;
								} else {
									gint* _tmp24_ = NULL;
									gint _tmp24__length1 = 0;
									gint _tmp24__length2 = 0;
									gint _tmp25_ = 0;
									gint _tmp26_ = 0;
									gint _tmp27_ = 0;
									gchar* _tmp28_ = NULL;
									_tmp24_ = self->cells;
									_tmp24__length1 = self->cells_length1;
									_tmp24__length2 = self->cells_length2;
									_tmp25_ = i;
									_tmp26_ = j;
									_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
									_tmp28_ = g_strdup_printf ("%i", _tmp27_);
									_g_free0 (_tmp21_);
									_tmp21_ = _tmp28_;
								}
								_tmp29_ = board_string;
								_tmp30_ = g_strconcat (_tmp29_, _tmp21_, NULL);
								_g_free0 (board_string);
								board_string = _tmp30_;
								_g_free0 (_tmp21_);
							}
						}
					}
				}
			}
		}
	}
	result = board_string;
	return result;
}


static gint* _vala_array_dup7 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp2__length2;
	}
	result = _tmp2_;
	return result;
}


GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self) {
	GeeHashMap* result = NULL;
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	possibilities = _tmp0_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = l1;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = l2;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = self->cells;
							_tmp9__length1 = self->cells_length1;
							_tmp9__length2 = self->cells_length2;
							_tmp10_ = l1;
							_tmp11_ = l2;
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
							if (_tmp12_ == 0) {
								GeeArrayList* possArrayList = NULL;
								GeeArrayList* _tmp13_ = NULL;
								gint* possArray = NULL;
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint* _tmp17_ = NULL;
								gint possArray_length1 = 0;
								gint _possArray_size_ = 0;
								gint* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								GeeHashMap* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								Coord _tmp24_ = {0};
								GeeArrayList* _tmp25_ = NULL;
								_tmp13_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
								possArrayList = _tmp13_;
								_tmp14_ = l1;
								_tmp15_ = l2;
								_tmp17_ = sudoku_board_get_possibilities (self, _tmp14_, _tmp15_, &_tmp16_);
								possArray = _tmp17_;
								possArray_length1 = _tmp16_;
								_possArray_size_ = possArray_length1;
								_tmp18_ = possArray;
								_tmp18__length1 = possArray_length1;
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
									i_collection = _tmp18_;
									i_collection_length1 = _tmp18__length1;
									for (i_it = 0; i_it < _tmp18__length1; i_it = i_it + 1) {
										gint i = 0;
										i = i_collection[i_it];
										{
											GeeArrayList* _tmp19_ = NULL;
											gint _tmp20_ = 0;
											_tmp19_ = possArrayList;
											_tmp20_ = i;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((gintptr) _tmp20_));
										}
									}
								}
								_tmp21_ = possibilities;
								_tmp22_ = l1;
								_tmp23_ = l2;
								coord_init (&_tmp24_, _tmp22_, _tmp23_);
								_tmp25_ = possArrayList;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, &_tmp24_, _tmp25_);
								possArray = (g_free (possArray), NULL);
								_g_object_unref0 (possArrayList);
							}
						}
					}
				}
			}
		}
	}
	result = possibilities;
	return result;
}


gboolean sudoku_board_is_finished (SudokuBoard* self) {
	gboolean result = FALSE;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	GFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sudoku_board_to_string (self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	board_string = _tmp3_;
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
	finishgame_file = _tmp6_;
	_tmp7_ = g_file_new_for_path (finishgame_file);
	file = _tmp7_;
	_tmp8_ = g_file_query_exists (file, NULL);
	result = _tmp8_;
	_g_object_unref0 (file);
	_g_free0 (finishgame_file);
	_g_free0 (board_string);
	return result;
}


gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint _tmp6__length3 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = sudoku_board_get_max_val (self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ <= _tmp5_)) {
					break;
				}
				_tmp6_ = self->earmarks;
				_tmp6__length1 = self->earmarks_length1;
				_tmp6__length2 = self->earmarks_length2;
				_tmp6__length3 = self->earmarks_length3;
				_tmp7_ = row;
				_tmp8_ = col;
				_tmp9_ = i;
				_tmp10_ = _tmp6_[(((_tmp7_ * _tmp6__length2) + _tmp8_) * _tmp6__length3) + (_tmp9_ - 1)];
				if (_tmp10_) {
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					_tmp11_ = s;
					_tmp12_ = i;
					_tmp13_ = g_strdup_printf ("%i", _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
					_g_free0 (s);
					s = _tmp15_;
					_g_free0 (_tmp14_);
				}
			}
		}
	}
	result = s;
	return result;
}


gdouble sudoku_board_get_previous_played_time (SudokuBoard* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_previous_played_time;
	result = _tmp0_;
	return result;
}


void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_previous_played_time = _tmp0_;
}


gint sudoku_board_get_block_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	result = _tmp0_;
	return result;
}


gint sudoku_board_get_block_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_cols;
	result = _tmp0_;
	return result;
}


gint sudoku_board_get_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	result = _tmp0_;
	return result;
}


gint sudoku_board_get_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cols;
	result = _tmp0_;
	return result;
}


gint sudoku_board_get_max_val (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sudoku_board_get_block_rows (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sudoku_board_get_block_cols (self);
	_tmp3_ = _tmp2_;
	result = _tmp1_ * _tmp3_;
	return result;
}


gboolean sudoku_board_get_broken (SudokuBoard* self) {
	gboolean result;
	GeeSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->broken_coords;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != 0;
	return result;
}


gint sudoku_board_get_filled (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_filled;
	result = _tmp0_;
	return result;
}


gboolean sudoku_board_get_complete (SudokuBoard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_cols;
	_tmp3_ = self->priv->_rows;
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = sudoku_board_get_broken (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gdouble sudoku_board_get_difficulty_rating (SudokuBoard* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_difficulty_rating;
	result = _tmp0_;
	return result;
}


static void sudoku_board_set_difficulty_rating (SudokuBoard* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_difficulty_rating = _tmp0_;
}


static void value_sudoku_board_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_sudoku_board_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sudoku_board_unref (value->data[0].v_pointer);
	}
}


static void value_sudoku_board_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sudoku_board_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_sudoku_board_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_sudoku_board_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SudokuBoard* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sudoku_board_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_sudoku_board_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SudokuBoard** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sudoku_board_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_sudoku_board (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSudokuBoard* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SUDOKU_BOARD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_sudoku_board (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_BOARD), NULL);
	return value->data[0].v_pointer;
}


void value_set_sudoku_board (GValue* value, gpointer v_object) {
	SudokuBoard* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_BOARD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_BOARD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sudoku_board_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_board_unref (old);
	}
}


void value_take_sudoku_board (GValue* value, gpointer v_object) {
	SudokuBoard* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SUDOKU_BOARD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SUDOKU_BOARD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sudoku_board_unref (old);
	}
}


static void sudoku_board_class_init (SudokuBoardClass * klass) {
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
	SUDOKU_BOARD_CLASS (klass)->finalize = sudoku_board_finalize;
	g_type_class_add_private (klass, sizeof (SudokuBoardPrivate));
	g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sudoku_board_instance_init (SudokuBoard * self) {
	self->priv = SUDOKU_BOARD_GET_PRIVATE (self);
	self->priv->_previous_played_time = (gdouble) 0;
	self->ref_count = 1;
}


static void sudoku_board_finalize (SudokuBoard* obj) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
	self->cells = (g_free (self->cells), NULL);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->earmarks = (g_free (self->earmarks), NULL);
	_g_object_unref0 (self->broken_coords);
	_g_object_unref0 (self->coords_for_col);
	_g_object_unref0 (self->coords_for_row);
	_g_object_unref0 (self->coords_for_block);
}


GType sudoku_board_get_type (void) {
	static volatile gsize sudoku_board_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_board_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_sudoku_board_init, value_sudoku_board_free_value, value_sudoku_board_copy_value, value_sudoku_board_peek_pointer, "p", value_sudoku_board_collect_value, "p", value_sudoku_board_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sudoku_board_type_id;
		sudoku_board_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SudokuBoard", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sudoku_board_type_id__volatile, sudoku_board_type_id);
	}
	return sudoku_board_type_id__volatile;
}


gpointer sudoku_board_ref (gpointer instance) {
	SudokuBoard* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sudoku_board_unref (gpointer instance) {
	SudokuBoard* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUDOKU_BOARD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType house_get_type (void) {
	static volatile gsize house_type_id__volatile = 0;
	if (g_once_init_enter (&house_type_id__volatile)) {
		static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
		GType house_type_id;
		house_type_id = g_enum_register_static ("House", values);
		g_once_init_leave (&house_type_id__volatile, house_type_id);
	}
	return house_type_id__volatile;
}


void coord_init (Coord *self, gint row, gint col) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	memset (self, 0, sizeof (Coord));
	_tmp0_ = row;
	(*self).row = _tmp0_;
	_tmp1_ = col;
	(*self).col = _tmp1_;
}


gint coord_hash (Coord* coord) {
	gint result = 0;
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
	Coord _tmp2_ = {0};
	gint _tmp3_ = 0;
	g_return_val_if_fail (coord != NULL, 0);
	_tmp0_ = *coord;
	_tmp1_ = _tmp0_.row;
	_tmp2_ = *coord;
	_tmp3_ = _tmp2_.col;
	result = (_tmp1_ * 33) ^ _tmp3_;
	return result;
}


gboolean coord_equal (Coord* a, Coord* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Coord _tmp3_ = {0};
	gint _tmp4_ = 0;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.row;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.row;
	if (_tmp2_ == _tmp4_) {
		Coord _tmp5_ = {0};
		gint _tmp6_ = 0;
		Coord _tmp7_ = {0};
		gint _tmp8_ = 0;
		_tmp5_ = *a;
		_tmp6_ = _tmp5_.col;
		_tmp7_ = *b;
		_tmp8_ = _tmp7_.col;
		_tmp0_ = _tmp6_ == _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


Coord* coord_dup (const Coord* self) {
	Coord* dup;
	dup = g_new0 (Coord, 1);
	memcpy (dup, self, sizeof (Coord));
	return dup;
}


void coord_free (Coord* self) {
	g_free (self);
}


GType coord_get_type (void) {
	static volatile gsize coord_type_id__volatile = 0;
	if (g_once_init_enter (&coord_type_id__volatile)) {
		GType coord_type_id;
		coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
		g_once_init_leave (&coord_type_id__volatile, coord_type_id);
	}
	return coord_type_id__volatile;
}


void cell_init (Cell *self, Coord* coord, gint val) {
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
	g_return_if_fail (coord != NULL);
	memset (self, 0, sizeof (Cell));
	_tmp0_ = *coord;
	(*self).coord = _tmp0_;
	_tmp1_ = val;
	(*self).val = _tmp1_;
}


gint cell_hash (Cell* cell) {
	gint result = 0;
	Cell _tmp0_ = {0};
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Cell _tmp3_ = {0};
	gint _tmp4_ = 0;
	g_return_val_if_fail (cell != NULL, 0);
	_tmp0_ = *cell;
	_tmp1_ = _tmp0_.coord;
	_tmp2_ = coord_hash (&_tmp1_);
	_tmp3_ = *cell;
	_tmp4_ = _tmp3_.val;
	result = (_tmp2_ * 33) ^ _tmp4_;
	return result;
}


gboolean cell_equal (Cell* a, Cell* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_ = {0};
	Coord _tmp2_ = {0};
	Cell _tmp3_ = {0};
	Coord _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.coord;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.coord;
	_tmp5_ = coord_equal (&_tmp2_, &_tmp4_);
	if (_tmp5_) {
		Cell _tmp6_ = {0};
		gint _tmp7_ = 0;
		Cell _tmp8_ = {0};
		gint _tmp9_ = 0;
		_tmp6_ = *a;
		_tmp7_ = _tmp6_.val;
		_tmp8_ = *b;
		_tmp9_ = _tmp8_.val;
		_tmp0_ = _tmp7_ == _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


Cell* cell_dup (const Cell* self) {
	Cell* dup;
	dup = g_new0 (Cell, 1);
	memcpy (dup, self, sizeof (Cell));
	return dup;
}


void cell_free (Cell* self) {
	g_free (self);
}


GType cell_get_type (void) {
	static volatile gsize cell_type_id__volatile = 0;
	if (g_once_init_enter (&cell_type_id__volatile)) {
		GType cell_type_id;
		cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
		g_once_init_leave (&cell_type_id__volatile, cell_type_id);
	}
	return cell_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



