/* history.c generated by valac 0.24.0, the Vala compiler
 * generated from history.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__history_entry_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__history_entry_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _history_entry_unref0(var) ((var == NULL) ? NULL : (var = (history_entry_unref (var), NULL)))
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
typedef struct _ParamSpecHistory ParamSpecHistory;
typedef struct _ParamSpecHistoryEntry ParamSpecHistoryEntry;

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
	gchar* filename;
	GList* entries;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	guint width;
	guint height;
	guint n_mines;
	guint duration;
};

struct _HistoryEntryClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryEntry *self);
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};

struct _ParamSpecHistoryEntry {
	GParamSpec parent_instance;
};


static gpointer history_parent_class = NULL;
static gpointer history_entry_parent_class = NULL;

gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
gpointer history_entry_ref (gpointer instance);
void history_entry_unref (gpointer instance);
GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_entry (GValue* value, gpointer v_object);
void value_take_history_entry (GValue* value, gpointer v_object);
gpointer value_get_history_entry (const GValue* value);
GType history_entry_get_type (void) G_GNUC_CONST;
enum  {
	HISTORY_DUMMY_PROPERTY
};
static void _history_entry_unref0_ (gpointer var);
static void _g_list_free__history_entry_unref0_ (GList* self);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_add (History* self, HistoryEntry* entry);
void history_load (History* self);
static GDateTime* history_parse_date (History* self, const gchar* date);
HistoryEntry* history_entry_new (GDateTime* date, guint width, guint height, guint n_mines, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint width, guint height, guint n_mines, guint duration);
void history_save (History* self);
static void g_cclosure_user_marshal_VOID__HISTORY_ENTRY (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void history_finalize (History* obj);
enum  {
	HISTORY_ENTRY_DUMMY_PROPERTY
};
static void history_entry_finalize (HistoryEntry* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _history_entry_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (history_entry_unref (var), NULL));
}


static void _g_list_free__history_entry_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _history_entry_unref0_, NULL);
	g_list_free (self);
}


History* history_construct (GType object_type, const gchar* filename) {
	History* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (History*) g_type_create_instance (object_type);
	_tmp0_ = filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->filename);
	self->filename = _tmp1_;
	__g_list_free__history_entry_unref0_0 (self->entries);
	self->entries = NULL;
	return self;
}


History* history_new (const gchar* filename) {
	return history_construct (TYPE_HISTORY, filename);
}


static gpointer _history_entry_ref0 (gpointer self) {
	return self ? history_entry_ref (self) : NULL;
}


void history_add (History* self, HistoryEntry* entry) {
	HistoryEntry* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	HistoryEntry* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	_tmp1_ = _history_entry_ref0 (_tmp0_);
	self->entries = g_list_append (self->entries, _tmp1_);
	_tmp2_ = entry;
	g_signal_emit_by_name (self, "entry-added", _tmp2_);
}


void history_load (History* self) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__history_entry_unref0_0 (self->entries);
	self->entries = NULL;
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	{
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->filename;
		g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		if (!g_error_matches (_tmp3_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("history.vala:42: Failed to load history: %s", _tmp5_);
		}
		_g_error_free0 (e);
		_g_free0 (contents);
		return;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = contents;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp8_;
		line_collection_length1 = _vala_array_length (_tmp7_);
		for (line_it = 0; line_it < _vala_array_length (_tmp7_); line_it = line_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* line = NULL;
			_tmp9_ = g_strdup (line_collection[line_it]);
			line = _tmp9_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				GDateTime* date = NULL;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				const gchar* _tmp15_ = NULL;
				GDateTime* _tmp16_ = NULL;
				GDateTime* _tmp17_ = NULL;
				gint width = 0;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				const gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint height = 0;
				gchar** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				const gchar* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint n_mines = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				const gchar* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint duration = 0;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				const gchar* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				GDateTime* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				HistoryEntry* _tmp35_ = NULL;
				HistoryEntry* _tmp36_ = NULL;
				_tmp10_ = line;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
				tokens = _tmp12_;
				tokens_length1 = _vala_array_length (_tmp11_);
				_tokens_size_ = tokens_length1;
				_tmp13_ = tokens;
				_tmp13__length1 = tokens_length1;
				if (_tmp13__length1 != 5) {
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp14_ = tokens;
				_tmp14__length1 = tokens_length1;
				_tmp15_ = _tmp14_[0];
				_tmp16_ = history_parse_date (self, _tmp15_);
				date = _tmp16_;
				_tmp17_ = date;
				if (_tmp17_ == NULL) {
					_g_date_time_unref0 (date);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp18_ = tokens;
				_tmp18__length1 = tokens_length1;
				_tmp19_ = _tmp18_[1];
				_tmp20_ = atoi (_tmp19_);
				width = _tmp20_;
				_tmp21_ = tokens;
				_tmp21__length1 = tokens_length1;
				_tmp22_ = _tmp21_[2];
				_tmp23_ = atoi (_tmp22_);
				height = _tmp23_;
				_tmp24_ = tokens;
				_tmp24__length1 = tokens_length1;
				_tmp25_ = _tmp24_[3];
				_tmp26_ = atoi (_tmp25_);
				n_mines = _tmp26_;
				_tmp27_ = tokens;
				_tmp27__length1 = tokens_length1;
				_tmp28_ = _tmp27_[4];
				_tmp29_ = atoi (_tmp28_);
				duration = _tmp29_;
				_tmp30_ = date;
				_tmp31_ = width;
				_tmp32_ = height;
				_tmp33_ = n_mines;
				_tmp34_ = duration;
				_tmp35_ = history_entry_new (_tmp30_, (guint) _tmp31_, (guint) _tmp32_, (guint) _tmp33_, (guint) _tmp34_);
				_tmp36_ = _tmp35_;
				history_add (self, _tmp36_);
				_history_entry_unref0 (_tmp36_);
				_g_date_time_unref0 (date);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (contents);
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


void history_save (History* self) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = self->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp1_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp2_ = NULL;
			HistoryEntry* entry = NULL;
			_tmp2_ = _history_entry_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp2_;
			{
				gchar* line = NULL;
				HistoryEntry* _tmp3_ = NULL;
				GDateTime* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				HistoryEntry* _tmp7_ = NULL;
				guint _tmp8_ = 0U;
				HistoryEntry* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
				HistoryEntry* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				HistoryEntry* _tmp13_ = NULL;
				guint _tmp14_ = 0U;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				_tmp3_ = entry;
				_tmp4_ = _tmp3_->date;
				_tmp5_ = g_date_time_to_string (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = entry;
				_tmp8_ = _tmp7_->width;
				_tmp9_ = entry;
				_tmp10_ = _tmp9_->height;
				_tmp11_ = entry;
				_tmp12_ = _tmp11_->n_mines;
				_tmp13_ = entry;
				_tmp14_ = _tmp13_->duration;
				_tmp15_ = g_strdup_printf ("%s %u %u %u %u\n", _tmp6_, _tmp8_, _tmp10_, _tmp12_, _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp6_);
				line = _tmp16_;
				_tmp17_ = contents;
				_tmp18_ = line;
				_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
				_g_free0 (contents);
				contents = _tmp19_;
				_g_free0 (line);
				_history_entry_unref0 (entry);
			}
		}
	}
	{
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp20_ = self->filename;
		_tmp21_ = g_path_get_dirname (_tmp20_);
		_tmp22_ = _tmp21_;
		g_mkdir_with_parents (_tmp22_, 0775);
		_g_free0 (_tmp22_);
		_tmp23_ = self->filename;
		_tmp24_ = contents;
		g_file_set_contents (_tmp23_, _tmp24_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("history.vala:81: Failed to save history: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (contents);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static GDateTime* history_parse_date (History* self, const gchar* date) {
	GDateTime* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint year = 0;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint month = 0;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint day = 0;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint hour = 0;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint minute = 0;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint seconds = 0;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gchar* timezone = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GTimeZone* _tmp51_ = NULL;
	GTimeZone* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	GDateTime* _tmp59_ = NULL;
	GDateTime* _tmp60_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	_tmp5_ = date;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ < 19) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp8_ = NULL;
		gchar _tmp9_ = '\0';
		_tmp8_ = date;
		_tmp9_ = string_get (_tmp8_, (glong) 4);
		_tmp4_ = _tmp9_ != '-';
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp10_ = NULL;
		gchar _tmp11_ = '\0';
		_tmp10_ = date;
		_tmp11_ = string_get (_tmp10_, (glong) 7);
		_tmp3_ = _tmp11_ != '-';
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp12_ = NULL;
		gchar _tmp13_ = '\0';
		_tmp12_ = date;
		_tmp13_ = string_get (_tmp12_, (glong) 10);
		_tmp2_ = _tmp13_ != 'T';
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp14_ = NULL;
		gchar _tmp15_ = '\0';
		_tmp14_ = date;
		_tmp15_ = string_get (_tmp14_, (glong) 13);
		_tmp1_ = _tmp15_ != ':';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp16_ = NULL;
		gchar _tmp17_ = '\0';
		_tmp16_ = date;
		_tmp17_ = string_get (_tmp16_, (glong) 16);
		_tmp0_ = _tmp17_ != ':';
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp18_ = date;
	_tmp19_ = string_substring (_tmp18_, (glong) 0, (glong) 4);
	_tmp20_ = _tmp19_;
	_tmp21_ = atoi (_tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	year = _tmp22_;
	_tmp23_ = date;
	_tmp24_ = string_substring (_tmp23_, (glong) 5, (glong) 2);
	_tmp25_ = _tmp24_;
	_tmp26_ = atoi (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	month = _tmp27_;
	_tmp28_ = date;
	_tmp29_ = string_substring (_tmp28_, (glong) 8, (glong) 2);
	_tmp30_ = _tmp29_;
	_tmp31_ = atoi (_tmp30_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp30_);
	day = _tmp32_;
	_tmp33_ = date;
	_tmp34_ = string_substring (_tmp33_, (glong) 11, (glong) 2);
	_tmp35_ = _tmp34_;
	_tmp36_ = atoi (_tmp35_);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	hour = _tmp37_;
	_tmp38_ = date;
	_tmp39_ = string_substring (_tmp38_, (glong) 14, (glong) 2);
	_tmp40_ = _tmp39_;
	_tmp41_ = atoi (_tmp40_);
	_tmp42_ = _tmp41_;
	_g_free0 (_tmp40_);
	minute = _tmp42_;
	_tmp43_ = date;
	_tmp44_ = string_substring (_tmp43_, (glong) 17, (glong) 2);
	_tmp45_ = _tmp44_;
	_tmp46_ = atoi (_tmp45_);
	_tmp47_ = _tmp46_;
	_g_free0 (_tmp45_);
	seconds = _tmp47_;
	_tmp48_ = date;
	_tmp49_ = string_substring (_tmp48_, (glong) 19, (glong) (-1));
	timezone = _tmp49_;
	_tmp50_ = timezone;
	_tmp51_ = g_time_zone_new (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = year;
	_tmp54_ = month;
	_tmp55_ = day;
	_tmp56_ = hour;
	_tmp57_ = minute;
	_tmp58_ = seconds;
	_tmp59_ = g_date_time_new (_tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_, _tmp57_, (gdouble) _tmp58_);
	_tmp60_ = _tmp59_;
	_g_time_zone_unref0 (_tmp52_);
	result = _tmp60_;
	_g_free0 (timezone);
	return result;
}


static void g_cclosure_user_marshal_VOID__HISTORY_ENTRY (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__HISTORY_ENTRY) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__HISTORY_ENTRY callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__HISTORY_ENTRY) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_history_entry (param_values + 1), data2);
}


static void value_history_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_unref (value->data[0].v_pointer);
	}
}


static void value_history_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		History* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	History** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
	return value->data[0].v_pointer;
}


void value_set_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


void value_take_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


static void history_class_init (HistoryClass * klass) {
	history_parent_class = g_type_class_peek_parent (klass);
	HISTORY_CLASS (klass)->finalize = history_finalize;
	g_signal_new ("entry_added", TYPE_HISTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__HISTORY_ENTRY, G_TYPE_NONE, 1, TYPE_HISTORY_ENTRY);
}


static void history_instance_init (History * self) {
	self->ref_count = 1;
}


static void history_finalize (History* obj) {
	History * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY, History);
	_g_free0 (self->filename);
	__g_list_free__history_entry_unref0_0 (self->entries);
}


GType history_get_type (void) {
	static volatile gsize history_type_id__volatile = 0;
	if (g_once_init_enter (&history_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_type_id;
		history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_type_id__volatile, history_type_id);
	}
	return history_type_id__volatile;
}


gpointer history_ref (gpointer instance) {
	History* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_unref (gpointer instance) {
	History* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint width, guint height, guint n_mines, guint duration) {
	HistoryEntry* self = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_val_if_fail (date != NULL, NULL);
	self = (HistoryEntry*) g_type_create_instance (object_type);
	_tmp0_ = date;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	_g_date_time_unref0 (self->date);
	self->date = _tmp1_;
	_tmp2_ = width;
	self->width = _tmp2_;
	_tmp3_ = height;
	self->height = _tmp3_;
	_tmp4_ = n_mines;
	self->n_mines = _tmp4_;
	_tmp5_ = duration;
	self->duration = _tmp5_;
	return self;
}


HistoryEntry* history_entry_new (GDateTime* date, guint width, guint height, guint n_mines, guint duration) {
	return history_entry_construct (TYPE_HISTORY_ENTRY, date, width, height, n_mines, duration);
}


static void value_history_entry_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_entry_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_entry_unref (value->data[0].v_pointer);
	}
}


static void value_history_entry_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_entry_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_entry_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		HistoryEntry* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_entry_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HistoryEntry** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistoryEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history_entry (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ENTRY), NULL);
	return value->data[0].v_pointer;
}


void value_set_history_entry (GValue* value, gpointer v_object) {
	HistoryEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_entry_unref (old);
	}
}


void value_take_history_entry (GValue* value, gpointer v_object) {
	HistoryEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_entry_unref (old);
	}
}


static void history_entry_class_init (HistoryEntryClass * klass) {
	history_entry_parent_class = g_type_class_peek_parent (klass);
	HISTORY_ENTRY_CLASS (klass)->finalize = history_entry_finalize;
}


static void history_entry_instance_init (HistoryEntry * self) {
	self->ref_count = 1;
}


static void history_entry_finalize (HistoryEntry* obj) {
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_ENTRY, HistoryEntry);
	_g_date_time_unref0 (self->date);
}


GType history_entry_get_type (void) {
	static volatile gsize history_entry_type_id__volatile = 0;
	if (g_once_init_enter (&history_entry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_entry_init, value_history_entry_free_value, value_history_entry_copy_value, value_history_entry_peek_pointer, "p", value_history_entry_collect_value, "p", value_history_entry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryEntry), 0, (GInstanceInitFunc) history_entry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_entry_type_id;
		history_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HistoryEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_entry_type_id__volatile, history_entry_type_id);
	}
	return history_entry_type_id__volatile;
}


gpointer history_entry_ref (gpointer instance) {
	HistoryEntry* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_entry_unref (gpointer instance) {
	HistoryEntry* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



