/* rygel-root-device-factory.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <config.h>
#include <uuid/uuid.h>
#include <libgssdp/gssdp.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GObject parent_instance;
	RygelRootDeviceFactoryPrivate * priv;
};

struct _RygelRootDeviceFactoryClass {
	GObjectClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	GUPnPContext* _context;
	RygelConfiguration* config;
	gchar* desc_dir;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4,
	RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS = 1 << 5
} RygelPluginCapabilities;

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


extern gchar* rygel_pretty_host_name;
gchar* rygel_pretty_host_name = NULL;
static gpointer rygel_root_device_factory_parent_class = NULL;
static GInitableIface* rygel_root_device_factory_g_initable_parent_iface = NULL;

GQuark root_device_factory_error_quark (void);
gchar* rygel_get_pretty_host_name (void);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY,
	RYGEL_ROOT_DEVICE_FACTORY_CONTEXT
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
const gchar* rygel_plugin_get_desc_path (RygelPlugin* self);
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error);
GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error);
GType rygel_description_file_get_type (void) G_GNUC_CONST;
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name);
static gchar* rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self, RygelPlugin* plugin);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self);
const gchar* rygel_plugin_get_description (RygelPlugin* self);
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
const gchar* rygel_plugin_get_title (RygelPlugin* self);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self);
GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
static gchar* rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self, RygelIconInfo* icon_info, RygelPlugin* plugin);
void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url);
static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value);
static void rygel_root_device_factory_finalize (GObject* obj);
static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


gchar* rygel_get_pretty_host_name (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_pretty_host_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		{
			gchar* machine_info = NULL;
			gchar* _tmp1_ = NULL;
			gchar** lines = NULL;
			const gchar* _tmp2_ = NULL;
			gchar** _tmp3_ = NULL;
			gchar** _tmp4_ = NULL;
			gint lines_length1 = 0;
			gint _lines_size_ = 0;
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			g_file_get_contents ("/etc/machine-info", &_tmp1_, NULL, &_inner_error_);
			_g_free0 (machine_info);
			machine_info = _tmp1_;
			if (_inner_error_ != NULL) {
				_g_free0 (machine_info);
				goto __catch7_g_error;
			}
			_tmp2_ = machine_info;
			_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
			lines = _tmp4_;
			lines_length1 = _vala_array_length (_tmp3_);
			_lines_size_ = lines_length1;
			_tmp5_ = lines;
			_tmp5__length1 = lines_length1;
			{
				gchar** line_collection = NULL;
				gint line_collection_length1 = 0;
				gint _line_collection_size_ = 0;
				gint line_it = 0;
				line_collection = _tmp5_;
				line_collection_length1 = _tmp5__length1;
				for (line_it = 0; line_it < _tmp5__length1; line_it = line_it + 1) {
					gchar* _tmp6_ = NULL;
					gchar* line = NULL;
					_tmp6_ = g_strdup (line_collection[line_it]);
					line = _tmp6_;
					{
						gchar** parts = NULL;
						const gchar* _tmp7_ = NULL;
						gchar** _tmp8_ = NULL;
						gchar** _tmp9_ = NULL;
						gint parts_length1 = 0;
						gint _parts_size_ = 0;
						gchar** _tmp10_ = NULL;
						gint _tmp10__length1 = 0;
						const gchar* _tmp11_ = NULL;
						_tmp7_ = line;
						_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "=", 0);
						parts = _tmp9_;
						parts_length1 = _vala_array_length (_tmp8_);
						_parts_size_ = parts_length1;
						_tmp10_ = parts;
						_tmp10__length1 = parts_length1;
						_tmp11_ = _tmp10_[0];
						if (g_strcmp0 (_tmp11_, "PRETTY_HOSTNAME") == 0) {
							gchar** _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gchar** _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gchar* _tmp14_ = NULL;
							_tmp12_ = parts;
							_tmp12__length1 = parts_length1;
							_tmp13_ = parts;
							_tmp13__length1 = parts_length1;
							_tmp14_ = g_strjoinv ("=", _tmp12_ + 1);
							_g_free0 (rygel_pretty_host_name);
							rygel_pretty_host_name = _tmp14_;
						}
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
					}
				}
			}
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (machine_info);
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_debug ("rygel-root-device-factory.vala:56: Failed to parse /etc/machine-info: " \
"%s", _tmp16_);
			_g_error_free0 (e);
		}
		__finally7:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp17_ = g_get_host_name ();
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (rygel_pretty_host_name);
		rygel_pretty_host_name = _tmp18_;
	}
	_tmp19_ = rygel_pretty_host_name;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	return result;
}


RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
	RygelRootDeviceFactory * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = context;
	self = (RygelRootDeviceFactory*) g_object_new (object_type, "context", _tmp0_, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
}


static gboolean rygel_root_device_factory_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	RygelRootDeviceFactory * self;
	gboolean result = FALSE;
	RygelConfiguration* _tmp0_ = NULL;
	RygelMetaConfig* _tmp1_ = NULL;
	gchar* config_dir = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelRootDeviceFactory*) base;
	_tmp0_ = self->priv->config;
	if (_tmp0_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp1_;
	_tmp2_ = g_get_user_config_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	config_dir = _tmp3_;
	_tmp4_ = config_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp4_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		return FALSE;
	}
	_tmp5_ = config_dir;
	_tmp6_ = g_get_application_name ();
	_tmp7_ = g_build_filename (_tmp5_, _tmp6_, NULL);
	_g_free0 (self->priv->desc_dir);
	self->priv->desc_dir = _tmp7_;
	_tmp8_ = self->priv->desc_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp8_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (config_dir);
	return result;
}


RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
	RygelRootDevice* result = NULL;
	gchar* desc_path = NULL;
	const gchar* _tmp0_ = NULL;
	RygelPlugin* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* template_path = NULL;
	RygelPlugin* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GUPnPXMLDoc* doc = NULL;
	RygelPlugin* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPXMLDoc* _tmp15_ = NULL;
	RygelRootDevice* device = NULL;
	GUPnPContext* _tmp16_ = NULL;
	RygelPlugin* _tmp17_ = NULL;
	GUPnPXMLDoc* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	RygelRootDevice* _tmp20_ = NULL;
	RygelPlugin* _tmp21_ = NULL;
	RygelRootDevice* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = self->priv->desc_dir;
	_tmp1_ = plugin;
	_tmp2_ = rygel_plugin_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".xml", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp0_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	desc_path = _tmp7_;
	_tmp8_ = plugin;
	_tmp9_ = rygel_plugin_get_desc_path (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	template_path = _tmp11_;
	_tmp12_ = plugin;
	_tmp13_ = desc_path;
	_tmp14_ = template_path;
	_tmp15_ = rygel_root_device_factory_create_desc (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
	doc = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	_tmp16_ = self->priv->_context;
	_tmp17_ = plugin;
	_tmp18_ = doc;
	_tmp19_ = desc_path;
	_tmp20_ = rygel_root_device_new (_tmp16_, _tmp17_, _tmp18_, _tmp19_, DATA_DIR);
	device = _tmp20_;
	_tmp21_ = plugin;
	_tmp22_ = device;
	_tmp23_ = desc_path;
	rygel_plugin_apply_hacks (_tmp21_, _tmp22_, _tmp23_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (device);
		_g_object_unref0 (doc);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	result = device;
	_g_object_unref0 (doc);
	_g_free0 (template_path);
	_g_free0 (desc_path);
	return result;
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
	_tmp0_ = g_new0 (guchar, 16);
	id = _tmp0_;
	id_length1 = 16;
	_id_size_ = id_length1;
	_tmp1_ = g_new0 (guchar, 51);
	unparsed = _tmp1_;
	unparsed_length1 = 51;
	_unparsed_size_ = unparsed_length1;
	_tmp2_ = id;
	_tmp2__length1 = id_length1;
	uuid_generate (_tmp2_);
	_tmp3_ = id;
	_tmp3__length1 = id_length1;
	_tmp4_ = unparsed;
	_tmp4__length1 = unparsed_length1;
	uuid_unparse (_tmp3_, _tmp4_);
	_tmp5_ = unparsed;
	_tmp5__length1 = unparsed_length1;
	_tmp5_[50] = (guchar) '\0';
	_tmp6_ = _tmp5_[50];
	_tmp7_ = unparsed;
	_tmp7__length1 = unparsed_length1;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	result = _tmp8_;
	unparsed = (g_free (unparsed), NULL);
	id = (g_free (id), NULL);
	return result;
}


static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error) {
	GUPnPXMLDoc* result = NULL;
	GUPnPXMLDoc* doc = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPXMLDoc* _tmp2_ = NULL;
	RygelDescriptionFile* file = NULL;
	GUPnPXMLDoc* _tmp3_ = NULL;
	RygelDescriptionFile* _tmp4_ = NULL;
	RygelDescriptionFile* _tmp5_ = NULL;
	RygelPlugin* _tmp6_ = NULL;
	RygelDescriptionFile* _tmp7_ = NULL;
	RygelPlugin* _tmp8_ = NULL;
	RygelDescriptionFile* _tmp9_ = NULL;
	RygelPlugin* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	RygelDescriptionFile* _tmp13_ = NULL;
	RygelPlugin* _tmp14_ = NULL;
	RygelPluginCapabilities _tmp15_ = 0;
	RygelPluginCapabilities _tmp16_ = 0;
	RygelPlugin* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* udn = NULL;
	RygelDescriptionFile* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp29_ = FALSE;
	RygelDescriptionFile* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (template_path != NULL, NULL);
	_tmp0_ = desc_path;
	_tmp1_ = template_path;
	_tmp2_ = rygel_root_device_factory_get_latest_doc (self, _tmp0_, _tmp1_, &_inner_error_);
	doc = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = doc;
	_tmp4_ = rygel_description_file_new_from_xml_document (_tmp3_);
	file = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = plugin;
	rygel_root_device_factory_add_services_to_desc (self, _tmp5_, _tmp6_);
	_tmp7_ = file;
	_tmp8_ = plugin;
	rygel_root_device_factory_add_icons_to_desc (self, _tmp7_, _tmp8_);
	_tmp9_ = file;
	_tmp10_ = plugin;
	_tmp11_ = rygel_root_device_factory_get_friendly_name (self, _tmp10_);
	_tmp12_ = _tmp11_;
	rygel_description_file_set_friendly_name (_tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = file;
	_tmp14_ = plugin;
	_tmp15_ = rygel_plugin_get_capabilities (_tmp14_);
	_tmp16_ = _tmp15_;
	rygel_description_file_set_dlna_caps (_tmp13_, _tmp16_);
	_tmp17_ = plugin;
	_tmp18_ = rygel_plugin_get_description (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		RygelDescriptionFile* _tmp20_ = NULL;
		RygelPlugin* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		_tmp20_ = file;
		_tmp21_ = plugin;
		_tmp22_ = rygel_plugin_get_description (_tmp21_);
		_tmp23_ = _tmp22_;
		rygel_description_file_set_model_description (_tmp20_, _tmp23_);
	}
	_tmp24_ = file;
	_tmp25_ = rygel_description_file_get_udn (_tmp24_);
	udn = _tmp25_;
	_tmp27_ = udn;
	if (_tmp27_ == NULL) {
		_tmp26_ = TRUE;
	} else {
		const gchar* _tmp28_ = NULL;
		_tmp28_ = udn;
		_tmp26_ = g_strcmp0 (_tmp28_, "") == 0;
	}
	_tmp29_ = _tmp26_;
	if (_tmp29_) {
		RygelDescriptionFile* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		_tmp30_ = file;
		_tmp31_ = uuid_get ();
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat ("uuid:", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		rygel_description_file_set_udn (_tmp30_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	_tmp35_ = file;
	_tmp36_ = desc_path;
	rygel_description_file_save (_tmp35_, _tmp36_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (udn);
		_g_object_unref0 (file);
		_g_object_unref0 (doc);
		return NULL;
	}
	result = doc;
	_g_free0 (udn);
	_g_object_unref0 (file);
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* rygel_root_device_factory_get_friendly_name (RygelRootDeviceFactory* self, RygelPlugin* plugin) {
	gchar* result = NULL;
	gchar* title = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		RygelConfiguration* _tmp1_ = NULL;
		RygelPlugin* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = self->priv->config;
		_tmp2_ = plugin;
		_tmp3_ = rygel_plugin_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = rygel_configuration_get_title (_tmp1_, _tmp4_, &_inner_error_);
		_tmp0_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_g_free0 (title);
		title = _tmp0_;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		RygelPlugin* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = plugin;
		_tmp7_ = rygel_plugin_get_title (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (title);
		title = _tmp9_;
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_free0 (title);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp10_ = title;
	_tmp11_ = g_get_real_name ();
	_tmp12_ = string_replace (_tmp10_, "@REALNAME@", _tmp11_);
	_g_free0 (title);
	title = _tmp12_;
	_tmp13_ = title;
	_tmp14_ = g_get_user_name ();
	_tmp15_ = string_replace (_tmp13_, "@USERNAME@", _tmp14_);
	_g_free0 (title);
	title = _tmp15_;
	_tmp16_ = title;
	_tmp17_ = g_get_host_name ();
	_tmp18_ = string_replace (_tmp16_, "@HOSTNAME@", _tmp17_);
	_g_free0 (title);
	title = _tmp18_;
	_tmp19_ = title;
	_tmp20_ = rygel_get_pretty_host_name ();
	_tmp21_ = _tmp20_;
	_tmp22_ = string_replace (_tmp19_, "@PRETTY_HOSTNAME@", _tmp21_);
	_g_free0 (title);
	title = _tmp22_;
	_g_free0 (_tmp21_);
	result = title;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin) {
	RygelDescriptionFile* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = file;
	rygel_description_file_clear_service_list (_tmp0_);
	{
		GeeArrayList* _resource_info_list = NULL;
		RygelPlugin* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		gint _resource_info_size = 0;
		GeeArrayList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _resource_info_index = 0;
		_tmp1_ = plugin;
		_tmp2_ = rygel_plugin_get_resource_infos (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_resource_info_list = _tmp4_;
		_tmp5_ = _resource_info_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_resource_info_size = _tmp7_;
		_resource_info_index = -1;
		while (TRUE) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			RygelResourceInfo* resource_info = NULL;
			GeeArrayList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			RygelResourceInfo* _tmp14_ = NULL;
			GType _tmp15_ = 0UL;
			gboolean _tmp16_ = FALSE;
			_tmp8_ = _resource_info_index;
			_resource_info_index = _tmp8_ + 1;
			_tmp9_ = _resource_info_index;
			_tmp10_ = _resource_info_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _resource_info_list;
			_tmp12_ = _resource_info_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			resource_info = (RygelResourceInfo*) _tmp13_;
			_tmp14_ = resource_info;
			_tmp15_ = _tmp14_->type;
			_tmp16_ = g_type_is_a (_tmp15_, gupnp_service_get_type ());
			if (_tmp16_) {
				RygelDescriptionFile* _tmp17_ = NULL;
				RygelPlugin* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				RygelResourceInfo* _tmp21_ = NULL;
				_tmp17_ = file;
				_tmp18_ = plugin;
				_tmp19_ = rygel_plugin_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = resource_info;
				rygel_description_file_add_service (_tmp17_, _tmp20_, _tmp21_);
			}
			_rygel_resource_info_unref0 (resource_info);
		}
		_g_object_unref0 (_resource_info_list);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, RygelDescriptionFile* file, RygelPlugin* plugin) {
	GeeArrayList* icons = NULL;
	RygelPlugin* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeArrayList* _tmp5_ = NULL;
	gboolean _tmp9_ = FALSE;
	RygelDescriptionFile* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	_tmp1_ = rygel_plugin_get_icon_infos (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	icons = _tmp3_;
	_tmp5_ = icons;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp6_ = icons;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		RygelPlugin* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelPlugin* _tmp13_ = NULL;
		GeeArrayList* _tmp14_ = NULL;
		GeeArrayList* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
		_tmp10_ = plugin;
		_tmp11_ = rygel_plugin_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		g_debug ("rygel-root-device-factory.vala:180: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", _tmp12_);
		_tmp13_ = plugin;
		_tmp14_ = rygel_plugin_get_default_icons (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_g_object_unref0 (icons);
		icons = _tmp16_;
	}
	_tmp17_ = file;
	rygel_description_file_clear_icon_list (_tmp17_);
	{
		GeeArrayList* _icon_list = NULL;
		GeeArrayList* _tmp18_ = NULL;
		GeeArrayList* _tmp19_ = NULL;
		gint _icon_size = 0;
		GeeArrayList* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _icon_index = 0;
		_tmp18_ = icons;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_icon_list = _tmp19_;
		_tmp20_ = _icon_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_icon_size = _tmp22_;
		_icon_index = -1;
		while (TRUE) {
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			RygelIconInfo* icon = NULL;
			GeeArrayList* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gpointer _tmp28_ = NULL;
			gchar* remote_path = NULL;
			RygelIconInfo* _tmp29_ = NULL;
			RygelPlugin* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			RygelIconInfo* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gboolean _tmp34_ = FALSE;
			RygelDescriptionFile* _tmp41_ = NULL;
			RygelPlugin* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			RygelIconInfo* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			_tmp23_ = _icon_index;
			_icon_index = _tmp23_ + 1;
			_tmp24_ = _icon_index;
			_tmp25_ = _icon_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _icon_list;
			_tmp27_ = _icon_index;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp27_);
			icon = (RygelIconInfo*) _tmp28_;
			_tmp29_ = icon;
			_tmp30_ = plugin;
			_tmp31_ = rygel_root_device_factory_get_icon_remote_path (self, _tmp29_, _tmp30_);
			remote_path = _tmp31_;
			_tmp32_ = icon;
			_tmp33_ = _tmp32_->uri;
			_tmp34_ = g_str_has_prefix (_tmp33_, "file://");
			if (_tmp34_) {
				gchar* local_path = NULL;
				RygelIconInfo* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				GUPnPContext* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				_tmp35_ = icon;
				_tmp36_ = _tmp35_->uri;
				_tmp37_ = string_substring (_tmp36_, (glong) 7, (glong) (-1));
				local_path = _tmp37_;
				_tmp38_ = self->priv->_context;
				_tmp39_ = local_path;
				_tmp40_ = remote_path;
				gupnp_context_host_path (_tmp38_, _tmp39_, _tmp40_);
				_g_free0 (local_path);
			}
			_tmp41_ = file;
			_tmp42_ = plugin;
			_tmp43_ = rygel_plugin_get_name (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = icon;
			_tmp46_ = remote_path;
			rygel_description_file_add_icon (_tmp41_, _tmp44_, _tmp45_, _tmp46_);
			_g_free0 (remote_path);
			_rygel_icon_info_unref0 (icon);
		}
		_g_object_unref0 (_icon_list);
	}
	_g_object_unref0 (icons);
}


static gchar* rygel_root_device_factory_get_icon_remote_path (RygelRootDeviceFactory* self, RygelIconInfo* icon_info, RygelPlugin* plugin) {
	gchar* result = NULL;
	RygelIconInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_info != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = icon_info;
	_tmp1_ = _tmp0_->uri;
	_tmp2_ = g_str_has_prefix (_tmp1_, "file://");
	if (_tmp2_) {
		RygelPlugin* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		RygelIconInfo* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		RygelIconInfo* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		RygelIconInfo* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		RygelIconInfo* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		_tmp3_ = plugin;
		_tmp4_ = rygel_plugin_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("/", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "-", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = icon_info;
		_tmp11_ = _tmp10_->width;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, "x", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = icon_info;
		_tmp19_ = _tmp18_->height;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp17_, _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "x", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = icon_info;
		_tmp27_ = _tmp26_->depth;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp25_, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, ".", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = icon_info;
		_tmp35_ = _tmp34_->file_extension;
		_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		result = _tmp37_;
		return result;
	} else {
		gchar* uri = NULL;
		RygelIconInfo* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		GUPnPContext* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		_tmp38_ = icon_info;
		_tmp39_ = _tmp38_->uri;
		_tmp40_ = g_strdup (_tmp39_);
		uri = _tmp40_;
		_tmp41_ = uri;
		_tmp42_ = self->priv->_context;
		_tmp43_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = string_replace (_tmp41_, "@ADDRESS@", _tmp44_);
		_tmp46_ = _tmp45_;
		_g_free0 (_tmp46_);
		result = uri;
		return result;
	}
}


static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error) {
	GUPnPXMLDoc* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFileInfo* info = NULL;
	GFile* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
	guint64 mod1 = 0ULL;
	GFileInfo* _tmp9_ = NULL;
	guint64 _tmp10_ = 0ULL;
	const gchar* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFileInfo* _tmp13_ = NULL;
	GFile* _tmp14_ = NULL;
	GFileInfo* _tmp15_ = NULL;
	guint64 mod2 = 0ULL;
	GFileInfo* _tmp16_ = NULL;
	guint64 _tmp17_ = 0ULL;
	guint64 _tmp18_ = 0ULL;
	guint64 _tmp19_ = 0ULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path1 != NULL, NULL);
	g_return_val_if_fail (path2 != NULL, NULL);
	_tmp0_ = path1;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		GUPnPXMLDoc* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GUPnPXMLDoc* _tmp6_ = NULL;
		_tmp5_ = path2;
		_tmp6_ = gupnp_xml_doc_new_from_path (_tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return NULL;
		}
		result = _tmp4_;
		_g_object_unref0 (file);
		return result;
	}
	_tmp7_ = file;
	_tmp8_ = g_file_query_info (_tmp7_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp9_ = info;
	_tmp10_ = g_file_info_get_attribute_uint64 (_tmp9_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mod1 = _tmp10_;
	_tmp11_ = path2;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_g_object_unref0 (file);
	file = _tmp12_;
	_tmp14_ = file;
	_tmp15_ = g_file_query_info (_tmp14_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp13_ = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_g_object_unref0 (info);
	info = _tmp13_;
	_tmp16_ = info;
	_tmp17_ = g_file_info_get_attribute_uint64 (_tmp16_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mod2 = _tmp17_;
	_tmp18_ = mod1;
	_tmp19_ = mod2;
	if (_tmp18_ > _tmp19_) {
		{
			GUPnPXMLDoc* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			GUPnPXMLDoc* _tmp22_ = NULL;
			_tmp21_ = path1;
			_tmp22_ = gupnp_xml_doc_new_from_path (_tmp21_, &_inner_error_);
			_tmp20_ = _tmp22_;
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			result = _tmp20_;
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* _error_ = NULL;
			GUPnPXMLDoc* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			GUPnPXMLDoc* _tmp25_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = path2;
			_tmp25_ = gupnp_xml_doc_new_from_path (_tmp24_, &_inner_error_);
			_tmp23_ = _tmp25_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally10;
			}
			result = _tmp23_;
			_g_error_free0 (_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		__finally10:
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	} else {
		GUPnPXMLDoc* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GUPnPXMLDoc* _tmp28_ = NULL;
		_tmp27_ = path2;
		_tmp28_ = gupnp_xml_doc_new_from_path (_tmp27_, &_inner_error_);
		_tmp26_ = _tmp28_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return NULL;
		}
		result = _tmp26_;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_g_object_unref0 (info);
	_g_object_unref0 (file);
}


static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error) {
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	_tmp0_ = dir_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		GFile* _tmp4_ = NULL;
		_tmp4_ = file;
		g_file_make_directory (_tmp4_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return;
		}
	}
	_g_object_unref0 (file);
}


GUPnPContext* rygel_root_device_factory_get_context (RygelRootDeviceFactory* self) {
	GUPnPContext* result;
	GUPnPContext* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}


static void rygel_root_device_factory_set_context (RygelRootDeviceFactory* self, GUPnPContext* value) {
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_context);
	self->priv->_context = _tmp1_;
	g_object_notify ((GObject *) self, "context");
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_root_device_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_root_device_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ROOT_DEVICE_FACTORY_CONTEXT, g_param_spec_object ("context", "context", "context", gupnp_context_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rygel_root_device_factory_g_initable_interface_init (GInitableIface * iface) {
	rygel_root_device_factory_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) rygel_root_device_factory_real_init;
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
}


static void rygel_root_device_factory_finalize (GObject* obj) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	_g_object_unref0 (self->priv->_context);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->desc_dir);
	G_OBJECT_CLASS (rygel_root_device_factory_parent_class)->finalize (obj);
}


/**
 * This is a factory to create #RygelRootDevice objects for
 * a given UPnP context.
 *
 * Call rygel_root_device_factory_create() with a plugin
 * to create a root device for the plugin.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) rygel_root_device_factory_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRootDeviceFactory", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_root_device_factory_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


static void _vala_rygel_root_device_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
		g_value_set_object (value, rygel_root_device_factory_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_root_device_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	switch (property_id) {
		case RYGEL_ROOT_DEVICE_FACTORY_CONTEXT:
		rygel_root_device_factory_set_context (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



