/* test-chess-game.c generated by valac 0.24.0.37-24e0c, the Vala compiler
 * generated from test-chess-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GL_CHESS (gl_chess_get_type ())
#define GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GL_CHESS, GlChess))
#define GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GL_CHESS, GlChessClass))
#define IS_GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GL_CHESS))
#define IS_GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GL_CHESS))
#define GL_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GL_CHESS, GlChessClass))

typedef struct _GlChess GlChess;
typedef struct _GlChessClass GlChessClass;
typedef struct _GlChessPrivate GlChessPrivate;

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ParamSpecGlChess ParamSpecGlChess;

struct _GlChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GlChessPrivate * priv;
};

struct _GlChessClass {
	GTypeClass parent_class;
	void (*finalize) (GlChess *self);
};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _ParamSpecGlChess {
	GParamSpec parent_instance;
};


static gpointer gl_chess_parent_class = NULL;
static gint gl_chess_test_count;
static gint gl_chess_test_count = 0;
static gint gl_chess_failure_count;
static gint gl_chess_failure_count = 0;

gpointer gl_chess_ref (gpointer instance);
void gl_chess_unref (gpointer instance);
GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gl_chess (GValue* value, gpointer v_object);
void value_take_gl_chess (GValue* value, gpointer v_object);
gpointer value_get_gl_chess (const GValue* value);
GType gl_chess_get_type (void) G_GNUC_CONST;
enum  {
	GL_CHESS_DUMMY_PROPERTY
};
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
static void gl_chess_test_good_move (const gchar* fen, const gchar* move, const gchar* result_fen, ChessResult _result_, ChessRule rule, gboolean verify_san);
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
gchar* chess_state_get_fen (ChessState* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_san (ChessMove* self);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
const gchar* chess_result_to_string (ChessResult self);
static void gl_chess_test_bad_move (const gchar* fen, const gchar* move);
gint gl_chess_main (gchar** args, int args_length1);
GlChess* gl_chess_new (void);
GlChess* gl_chess_construct (GType object_type);
static void gl_chess_finalize (GlChess* obj);


static void gl_chess_test_good_move (const gchar* fen, const gchar* move, const gchar* result_fen, ChessResult _result_, ChessRule rule, gboolean verify_san) {
	ChessState* state = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ChessState* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ChessState* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	ChessRule move_rule = 0;
	ChessResult move_result = 0;
	ChessState* _tmp41_ = NULL;
	ChessRule _tmp42_ = 0;
	ChessResult _tmp43_ = 0;
	gboolean _tmp44_ = FALSE;
	ChessResult _tmp45_ = 0;
	ChessResult _tmp46_ = 0;
	FILE* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	g_return_if_fail (fen != NULL);
	g_return_if_fail (move != NULL);
	g_return_if_fail (result_fen != NULL);
	_tmp0_ = fen;
	_tmp1_ = chess_state_new (_tmp0_);
	state = _tmp1_;
	_tmp2_ = gl_chess_test_count;
	gl_chess_test_count = _tmp2_ + 1;
	_tmp3_ = state;
	_tmp4_ = move;
	_tmp5_ = chess_state_move (_tmp3_, _tmp4_, TRUE);
	if (!_tmp5_) {
		FILE* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp6_ = stderr;
		_tmp7_ = gl_chess_test_count;
		_tmp8_ = fen;
		_tmp9_ = move;
		fprintf (_tmp6_, "%d. FAIL %s + %s is an invalid move\n", _tmp7_, _tmp8_, _tmp9_);
		_tmp10_ = gl_chess_failure_count;
		gl_chess_failure_count = _tmp10_ + 1;
		_chess_state_unref0 (state);
		return;
	}
	_tmp11_ = state;
	_tmp12_ = chess_state_get_fen (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = result_fen;
	_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
	_g_free0 (_tmp13_);
	if (_tmp15_) {
		FILE* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		ChessState* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		_tmp16_ = stderr;
		_tmp17_ = gl_chess_test_count;
		_tmp18_ = fen;
		_tmp19_ = move;
		_tmp20_ = state;
		_tmp21_ = chess_state_get_fen (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = result_fen;
		fprintf (_tmp16_, "%d. FAIL %s + %s has state %s not %s\n", _tmp17_, _tmp18_, _tmp19_, _tmp22_, _tmp23_);
		_g_free0 (_tmp22_);
		_tmp24_ = gl_chess_failure_count;
		gl_chess_failure_count = _tmp24_ + 1;
		_chess_state_unref0 (state);
		return;
	}
	_tmp26_ = verify_san;
	if (_tmp26_) {
		ChessState* _tmp27_ = NULL;
		ChessMove* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		_tmp27_ = state;
		_tmp28_ = _tmp27_->last_move;
		_tmp29_ = chess_move_get_san (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = move;
		_tmp25_ = g_strcmp0 (_tmp30_, _tmp31_) != 0;
		_g_free0 (_tmp30_);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		FILE* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		ChessState* _tmp36_ = NULL;
		ChessMove* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		_tmp32_ = stderr;
		_tmp33_ = gl_chess_test_count;
		_tmp34_ = fen;
		_tmp35_ = move;
		_tmp36_ = state;
		_tmp37_ = _tmp36_->last_move;
		_tmp38_ = chess_move_get_san (_tmp37_);
		_tmp39_ = _tmp38_;
		fprintf (_tmp32_, "%d. FAIL %s + %s has SAN move %s\n", _tmp33_, _tmp34_, _tmp35_, _tmp39_);
		_g_free0 (_tmp39_);
		_tmp40_ = gl_chess_failure_count;
		gl_chess_failure_count = _tmp40_ + 1;
		_chess_state_unref0 (state);
		return;
	}
	_tmp41_ = state;
	_tmp43_ = chess_state_get_result (_tmp41_, &_tmp42_);
	move_rule = _tmp42_;
	move_result = _tmp43_;
	_tmp45_ = move_result;
	_tmp46_ = _result_;
	if (_tmp45_ != _tmp46_) {
		_tmp44_ = TRUE;
	} else {
		ChessRule _tmp47_ = 0;
		ChessRule _tmp48_ = 0;
		_tmp47_ = move_rule;
		_tmp48_ = rule;
		_tmp44_ = _tmp47_ != _tmp48_;
	}
	if (_tmp44_) {
		FILE* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		const gchar* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		ChessResult _tmp53_ = 0;
		GEnumValue* _tmp54_;
		ChessResult _tmp55_ = 0;
		GEnumValue* _tmp56_;
		gint _tmp57_ = 0;
		_tmp49_ = stderr;
		_tmp50_ = gl_chess_test_count;
		_tmp51_ = fen;
		_tmp52_ = move;
		_tmp53_ = move_result;
		_tmp54_ = g_enum_get_value (g_type_class_ref (TYPE_CHESS_RESULT), _tmp53_);
		_tmp55_ = _result_;
		_tmp56_ = g_enum_get_value (g_type_class_ref (TYPE_CHESS_RESULT), _tmp55_);
		fprintf (_tmp49_, "%d. FAIL %s + %s has result %s not %s\n", _tmp50_, _tmp51_, _tmp52_, (_tmp54_ != NULL) ? _tmp54_->value_name : NULL, (_tmp56_ != NULL) ? _tmp56_->value_name : NULL);
		_tmp57_ = gl_chess_failure_count;
		gl_chess_failure_count = _tmp57_ + 1;
		_chess_state_unref0 (state);
		return;
	}
	_tmp58_ = stderr;
	_tmp59_ = gl_chess_test_count;
	_tmp60_ = fen;
	_tmp61_ = move;
	fprintf (_tmp58_, "%d. PASS %s + %s is valid\n", _tmp59_, _tmp60_, _tmp61_);
	_chess_state_unref0 (state);
}


static void gl_chess_test_bad_move (const gchar* fen, const gchar* move) {
	ChessState* state = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ChessState* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	FILE* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	g_return_if_fail (fen != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = fen;
	_tmp1_ = chess_state_new (_tmp0_);
	state = _tmp1_;
	_tmp2_ = gl_chess_test_count;
	gl_chess_test_count = _tmp2_ + 1;
	_tmp3_ = state;
	_tmp4_ = move;
	_tmp5_ = chess_state_move (_tmp3_, _tmp4_, FALSE);
	if (_tmp5_) {
		FILE* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp6_ = stderr;
		_tmp7_ = gl_chess_test_count;
		_tmp8_ = fen;
		_tmp9_ = move;
		fprintf (_tmp6_, "%d. FAIL %s + %s is valid\n", _tmp7_, _tmp8_, _tmp9_);
		_tmp10_ = gl_chess_failure_count;
		gl_chess_failure_count = _tmp10_ + 1;
		_chess_state_unref0 (state);
		return;
	}
	_tmp11_ = stderr;
	_tmp12_ = gl_chess_test_count;
	_tmp13_ = fen;
	_tmp14_ = move;
	fprintf (_tmp11_, "%d. PASS %s + %s is invalid\n", _tmp12_, _tmp13_, _tmp14_);
	_chess_state_unref0 (state);
}


gint gl_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gl_chess_test_good_move ("8/8/8/8/8/8/P7/8 w - - 0 1", "a3", "8/8/8/8/8/P7/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("8/8/8/8/8/8/P7/8 w - - 0 1", "a4", "8/8/8/8/P7/8/8/8 b - a3 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_bad_move ("8/8/8/8/8/P7/8/8 w - - 0 1", "a2a5");
	gl_chess_test_good_move ("8/P7/8/8/8/8/8/8 w - - 0 1", "a8=Q", "Q7/8/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("8/P7/8/8/8/8/8/8 w - - 0 1", "a7a8q", "Q7/8/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("8/P7/8/8/8/8/8/8 w - - 0 1", "a7a8N", "N7/8/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("8/8/8/pP6/8/8/8/8 w - a6 0 1", "bxa6", "8/8/P7/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_bad_move ("8/8/8/pP6/8/8/8/8 w - - 0 1", "b5a6");
	gl_chess_test_good_move ("8/8/8/pQ6/8/8/8/8 w - a6 0 1", "Qa6", "8/8/Q7/p7/8/8/8/8 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_bad_move ("8/8/8/pQ6/8/8/8/8 w - a6 0 1", "bxa6");
	gl_chess_test_good_move ("8/8/8/8/8/8/8/4K2R w K - 0 1", "O-O", "8/8/8/8/8/8/8/5RK1 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("8/8/8/8/8/8/8/R3K3 w Q - 0 1", "O-O-O", "8/8/8/8/8/8/8/2KR4 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/4K2R w - - 0 1", "O-O");
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/4K3 w K - 0 1", "O-O");
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/5K2 w K - 0 1", "O-O");
	gl_chess_test_bad_move ("4r3/8/8/8/8/8/8/4K2R w K - 0 1", "O-O");
	gl_chess_test_bad_move ("5r2/8/8/8/8/8/8/4K2R w K - 0 1", "O-O");
	gl_chess_test_bad_move ("8/8/8/8/8/8/6p1/4K2R w K - 0 1", "O-O");
	gl_chess_test_bad_move ("8/8/8/8/8/8/4p3/R3K3 w Q - 0 1", "O-O-O");
	gl_chess_test_bad_move ("4r3/8/8/8/8/8/4R3/4K3 w - - 0 1", "e2f2");
	gl_chess_test_good_move ("k7/8/8/8/8/8/8/1R6 w - - 0 1", "Ra1+", "k7/8/8/8/8/8/8/R7 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("k7/8/8/8/8/8/1R6/1R6 w - - 0 1", "Ra1#", "k7/8/8/8/8/8/1R6/R7 b - - 1 1", CHESS_RESULT_WHITE_WON, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("k7/7r/8/8/8/8/1R6/1R6 w - - 0 1", "Ra1+", "k7/7r/8/8/8/8/1R6/R7 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("k7/8/7R/8/8/8/8/1R6 w - - 0 1", "Rh7", "k7/7R/8/8/8/8/8/1R6 b - - 1 1", CHESS_RESULT_DRAW, CHESS_RULE_STALEMATE, FALSE);
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/8 w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_DRAW, CHESS_RULE_INSUFFICIENT_MATERIAL, FALSE);
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/7N w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/7N b - - 0 1", CHESS_RESULT_DRAW, CHESS_RULE_INSUFFICIENT_MATERIAL, FALSE);
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/6Nn w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/6Nn b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/6Nb w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/6Nb b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("k2b1b1b/6bp/7K/4B1B1/8/8/8/8 w - - 0 1", "Kxh7", "k2b1b1b/6bK/8/4B1B1/8/8/8/8 b - - 0 1", CHESS_RESULT_DRAW, CHESS_RULE_INSUFFICIENT_MATERIAL, FALSE);
	gl_chess_test_good_move ("k2b1b1b/6bp/7K/5B1B/8/8/8/8 w - - 0 1", "Kxh7", "k2b1b1b/6bK/8/5B1B/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("k6b/6bp/7K/7B/8/8/8/8 w - - 0 1", "Kxh7", "k6b/6bK/8/7B/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	gl_chess_test_good_move ("k2b1b1b/6bp/7K/6BB/8/8/8/8 w - - 0 1", "Kxh7", "k2b1b1b/6bK/8/6BB/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
	_tmp0_ = stdout;
	_tmp1_ = gl_chess_test_count;
	_tmp2_ = gl_chess_failure_count;
	_tmp3_ = gl_chess_test_count;
	fprintf (_tmp0_, "%d/%d tests successful\n", _tmp1_ - _tmp2_, _tmp3_);
	_tmp4_ = gl_chess_failure_count;
	result = _tmp4_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return gl_chess_main (argv, argc);
}


GlChess* gl_chess_construct (GType object_type) {
	GlChess* self = NULL;
	self = (GlChess*) g_type_create_instance (object_type);
	return self;
}


GlChess* gl_chess_new (void) {
	return gl_chess_construct (TYPE_GL_CHESS);
}


static void value_gl_chess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_gl_chess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gl_chess_unref (value->data[0].v_pointer);
	}
}


static void value_gl_chess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gl_chess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_gl_chess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_gl_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GlChess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gl_chess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_gl_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GlChess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gl_chess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGlChess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GL_CHESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_gl_chess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gl_chess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


void value_take_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


static void gl_chess_class_init (GlChessClass * klass) {
	gl_chess_parent_class = g_type_class_peek_parent (klass);
	GL_CHESS_CLASS (klass)->finalize = gl_chess_finalize;
}


static void gl_chess_instance_init (GlChess * self) {
	self->ref_count = 1;
}


static void gl_chess_finalize (GlChess* obj) {
	GlChess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GL_CHESS, GlChess);
}


GType gl_chess_get_type (void) {
	static volatile gsize gl_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gl_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gl_chess_init, value_gl_chess_free_value, value_gl_chess_copy_value, value_gl_chess_peek_pointer, "p", value_gl_chess_collect_value, "p", value_gl_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GlChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gl_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlChess), 0, (GInstanceInitFunc) gl_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gl_chess_type_id;
		gl_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GlChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gl_chess_type_id__volatile, gl_chess_type_id);
	}
	return gl_chess_type_id__volatile;
}


gpointer gl_chess_ref (gpointer instance) {
	GlChess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gl_chess_unref (gpointer instance) {
	GlChess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GL_CHESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



