/* computer-player.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from computer-player.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define COMPUTER_PLAYER_TYPE_STRATEGY (computer_player_strategy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PLAYER (player_get_type ())

#define COMPUTER_PLAYER_TYPE_POSSIBLE_MOVE (computer_player_possible_move_get_type ())
typedef struct _ComputerPlayerPossibleMove ComputerPlayerPossibleMove;
#define __g_list_free__computer_player_possible_move_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__computer_player_possible_move_free0_ (var), NULL)))
#define _computer_player_possible_move_free0(var) ((var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
};

struct _ComputerPlayerPrivate {
	Game* game;
	gint _level;
};

typedef enum  {
	COMPUTER_PLAYER_STRATEGY_PERFECT,
	COMPUTER_PLAYER_STRATEGY_VICTORY,
	COMPUTER_PLAYER_STRATEGY_BEST
} ComputerPlayerStrategy;

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _ComputerPlayerPossibleMove {
	gint x;
	gint y;
	gint n_tiles;
};


static gpointer computer_player_parent_class = NULL;

GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define COMPUTER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPUTER_PLAYER, ComputerPlayerPrivate))
enum  {
	COMPUTER_PLAYER_DUMMY_PROPERTY,
	COMPUTER_PLAYER_LEVEL
};
static GType computer_player_strategy_get_type (void) G_GNUC_UNUSED;
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void computer_player_set_level (ComputerPlayer* self, gint value);
void computer_player_move (ComputerPlayer* self);
GType player_get_type (void) G_GNUC_CONST;
gboolean game_can_move (Game* self, Player color);
Player game_get_current_color (Game* self);
gint game_get_n_tiles (Game* self);
static void computer_player_random_select (Game* g, gint* move_x, gint* move_y);
gint game_place_tile (Game* self, gint x, gint y);
gint computer_player_get_level (ComputerPlayer* self);
static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint p, gint* move_x, gint* move_y);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gboolean game_is_complete (Game* self);
static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy);
static GType computer_player_possible_move_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self);
gint game_count_tiles (Game* self, Player color);
Player player_flip_color (Player p);
void game_undo (Game* self, gint count);
static void _computer_player_possible_move_free0_ (gpointer var);
static void _g_list_free__computer_player_possible_move_free0_ (GList* self);
static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles);
static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b);
static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b);
void game_pass (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static gint computer_player_around (Game* g);
static gint computer_player_eval_heuristic (Game* g);
Player game_get_owner (Game* self, gint x, gint y);
static gint computer_player_is_empty (Game* g, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static void computer_player_finalize (GObject* obj);
static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gint COMPUTER_PLAYER_heuristic[64] = {65, -3, 6, 4, 4, 6, -3, 65, -3, -29, 3, 1, 1, 3, -29, -3, 6, 3, 5, 3, 3, 5, 3, 6, 4, 1, 3, 1, 1, 3, 1, 4, 4, 1, 3, 1, 1, 3, 1, 4, 6, 3, 5, 3, 3, 5, 3, 6, -3, -29, 3, 1, 1, 3, -29, -3, 65, -3, 6, 4, 4, 6, -3, 65};

static GType computer_player_strategy_get_type (void) {
	static volatile gsize computer_player_strategy_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_strategy_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPUTER_PLAYER_STRATEGY_PERFECT, "COMPUTER_PLAYER_STRATEGY_PERFECT", "perfect"}, {COMPUTER_PLAYER_STRATEGY_VICTORY, "COMPUTER_PLAYER_STRATEGY_VICTORY", "victory"}, {COMPUTER_PLAYER_STRATEGY_BEST, "COMPUTER_PLAYER_STRATEGY_BEST", "best"}, {0, NULL, NULL}};
		GType computer_player_strategy_type_id;
		computer_player_strategy_type_id = g_enum_register_static ("ComputerPlayerStrategy", values);
		g_once_init_leave (&computer_player_strategy_type_id__volatile, computer_player_strategy_type_id);
	}
	return computer_player_strategy_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 55 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 151 "computer-player.c"
}


ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level) {
	ComputerPlayer * self = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 53 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 53 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
#line 55 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = game;
#line 55 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 55 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 55 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	self->priv->game = _tmp1_;
#line 56 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp2_ = level;
#line 56 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	computer_player_set_level (self, _tmp2_);
#line 53 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return self;
#line 178 "computer-player.c"
}


ComputerPlayer* computer_player_new (Game* game, gint level) {
#line 53 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return computer_player_construct (TYPE_COMPUTER_PLAYER, game, level);
#line 185 "computer-player.c"
}


void computer_player_move (ComputerPlayer* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint depth = 0;
	gint _tmp14_ = 0;
	gint tiles_remaining = 0;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ComputerPlayerStrategy _tmp18_ = 0;
	gint _tmp19_ = 0;
	ComputerPlayerStrategy strategy = 0;
	ComputerPlayerStrategy _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint x = 0;
	gint y = 0;
	Game* _tmp25_ = NULL;
	Game* _tmp26_ = NULL;
	Game* _tmp27_ = NULL;
	ComputerPlayerStrategy _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	Game* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
#line 59 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->game;
#line 59 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp1_ = self->priv->game;
#line 59 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 59 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp3_ = _tmp2_;
#line 59 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp4_ = game_can_move (_tmp0_, _tmp3_);
#line 59 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_if_fail (_tmp4_);
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp5_ = self->priv->game;
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp6_ = game_get_n_tiles (_tmp5_);
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp7_ = _tmp6_;
#line 63 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp7_ < 8) {
#line 245 "computer-player.c"
		gint x = 0;
		gint y = 0;
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 66 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp8_ = self->priv->game;
#line 66 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		computer_player_random_select (_tmp8_, &_tmp9_, &_tmp10_);
#line 66 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		x = _tmp9_;
#line 66 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		y = _tmp10_;
#line 67 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp11_ = self->priv->game;
#line 67 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp12_ = x;
#line 67 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp13_ = y;
#line 67 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		game_place_tile (_tmp11_, _tmp12_, _tmp13_);
#line 68 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		return;
#line 272 "computer-player.c"
	}
#line 71 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp14_ = self->priv->_level;
#line 71 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	depth = 7 - ((3 - _tmp14_) * 2);
#line 72 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp15_ = self->priv->game;
#line 72 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp16_ = game_get_n_tiles (_tmp15_);
#line 72 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp17_ = _tmp16_;
#line 72 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	tiles_remaining = 64 - _tmp17_;
#line 81 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp19_ = self->priv->_level;
#line 81 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp19_ == 1) {
#line 81 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_PERFECT;
#line 292 "computer-player.c"
	} else {
#line 81 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_BEST;
#line 296 "computer-player.c"
	}
#line 81 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp20_ = _tmp18_;
#line 81 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	strategy = _tmp20_;
#line 82 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp21_ = tiles_remaining;
#line 82 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp22_ = depth;
#line 82 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp21_ <= (_tmp22_ + 10)) {
#line 83 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		strategy = COMPUTER_PLAYER_STRATEGY_PERFECT;
#line 310 "computer-player.c"
	} else {
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
#line 84 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp23_ = tiles_remaining;
#line 84 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp24_ = depth;
#line 84 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		if (_tmp23_ <= (_tmp24_ + 12)) {
#line 85 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			strategy = COMPUTER_PLAYER_STRATEGY_VICTORY;
#line 322 "computer-player.c"
		}
	}
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	x = 0;
#line 90 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	y = 0;
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp25_ = self->priv->game;
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp26_ = game_new_copy (_tmp25_);
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp27_ = _tmp26_;
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp28_ = strategy;
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp29_ = depth;
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp30_ = G_MININT;
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp31_ = G_MAXINT;
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	computer_player_search (_tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, 1, &x, &y);
#line 91 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_g_object_unref0 (_tmp27_);
#line 92 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp32_ = self->priv->game;
#line 92 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp33_ = x;
#line 92 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp34_ = y;
#line 92 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp35_ = game_place_tile (_tmp32_, _tmp33_, _tmp34_);
#line 92 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp35_ == 0) {
#line 357 "computer-player.c"
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
#line 93 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp36_ = x;
#line 93 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp37_ = y;
#line 93 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		g_critical ("computer-player.vala:93: Computer chose an invalid move: %d,%d", _tmp36_, _tmp37_);
#line 366 "computer-player.c"
	}
}


static void _computer_player_possible_move_free0_ (gpointer var) {
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	(var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL));
#line 374 "computer-player.c"
}


static void _g_list_free__computer_player_possible_move_free0_ (GList* self) {
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_list_foreach (self, (GFunc) _computer_player_possible_move_free0_, NULL);
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_list_free (self);
#line 383 "computer-player.c"
}


static gpointer _computer_player_possible_move_dup0 (gpointer self) {
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return self ? computer_player_possible_move_dup (self) : NULL;
#line 390 "computer-player.c"
}


static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = computer_player_compare_move (a, b);
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return result;
#line 399 "computer-player.c"
}


static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint p, gint* move_x, gint* move_y) {
	gint result = 0;
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GList* moves = NULL;
	GList* _tmp56_ = NULL;
	GList* _tmp59_ = NULL;
	gint _tmp109_ = 0;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp1_ = game_is_complete (_tmp0_);
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (!_tmp1_, 0);
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp2_ = p;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp3_ = p;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail ((_tmp2_ == 1) || (_tmp3_ == (-1)), 0);
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp4_ = a;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp5_ = b;
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (_tmp4_ < _tmp5_, 0);
#line 102 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp6_ = depth;
#line 102 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp6_ == 0) {
#line 440 "computer-player.c"
		Game* _tmp7_ = NULL;
		ComputerPlayerStrategy _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp7_ = g;
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp8_ = strategy;
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp9_ = computer_player_calculate_heuristic (_tmp7_, _tmp8_);
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		result = _tmp9_;
#line 103 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		return result;
#line 454 "computer-player.c"
	}
#line 106 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	moves = NULL;
#line 458 "computer-player.c"
	{
		gint x = 0;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		x = 0;
#line 463 "computer-player.c"
		{
			gboolean _tmp10_ = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp10_ = TRUE;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			while (TRUE) {
#line 470 "computer-player.c"
				gboolean _tmp11_ = FALSE;
				gint _tmp13_ = 0;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp11_ = _tmp10_;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!_tmp11_) {
#line 477 "computer-player.c"
					gint _tmp12_ = 0;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp12_ = x;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					x = _tmp12_ + 1;
#line 483 "computer-player.c"
				}
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp10_ = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp13_ = x;
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!(_tmp13_ < 8)) {
#line 107 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					break;
#line 493 "computer-player.c"
				}
				{
					gint y = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					y = 0;
#line 499 "computer-player.c"
					{
						gboolean _tmp14_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp14_ = TRUE;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						while (TRUE) {
#line 506 "computer-player.c"
							gboolean _tmp15_ = FALSE;
							gint _tmp17_ = 0;
							gint n_tiles = 0;
							Game* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Game* _tmp22_ = NULL;
							gboolean _tmp23_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp15_ = _tmp14_;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!_tmp15_) {
#line 520 "computer-player.c"
								gint _tmp16_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp16_ = y;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								y = _tmp16_ + 1;
#line 526 "computer-player.c"
							}
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp14_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp17_ = y;
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!(_tmp17_ < 8)) {
#line 109 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								break;
#line 536 "computer-player.c"
							}
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp18_ = g;
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp19_ = x;
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp20_ = y;
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp21_ = game_place_tile (_tmp18_, _tmp19_, _tmp20_);
#line 111 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							n_tiles = _tmp21_;
#line 113 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp22_ = g;
#line 113 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp23_ = game_is_complete (_tmp22_);
#line 113 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (_tmp23_) {
#line 554 "computer-player.c"
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								Game* _tmp26_ = NULL;
								Game* _tmp27_ = NULL;
								Player _tmp28_ = 0;
								Player _tmp29_ = 0;
								gint _tmp30_ = 0;
								Game* _tmp31_ = NULL;
								Game* _tmp32_ = NULL;
								Player _tmp33_ = 0;
								Player _tmp34_ = 0;
								Player _tmp35_ = 0;
								gint _tmp36_ = 0;
#line 115 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp24_ = x;
#line 115 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								*move_x = _tmp24_;
#line 116 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp25_ = y;
#line 116 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								*move_y = _tmp25_;
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp26_ = g;
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp27_ = g;
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp28_ = game_get_current_color (_tmp27_);
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp29_ = _tmp28_;
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp30_ = game_count_tiles (_tmp26_, _tmp29_);
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp31_ = g;
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp32_ = g;
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp33_ = game_get_current_color (_tmp32_);
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp34_ = _tmp33_;
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp35_ = player_flip_color (_tmp34_);
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp36_ = game_count_tiles (_tmp31_, _tmp35_);
#line 118 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								if (_tmp30_ > _tmp36_) {
#line 600 "computer-player.c"
									Game* _tmp37_ = NULL;
									gint _tmp38_ = 0;
									gint _tmp39_ = 0;
									gint _tmp42_ = 0;
#line 120 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp37_ = g;
#line 120 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									game_undo (_tmp37_, 1);
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp39_ = p;
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									if (_tmp39_ > 0) {
#line 613 "computer-player.c"
										gint _tmp40_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp40_ = G_MAXINT;
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp38_ = _tmp40_;
#line 619 "computer-player.c"
									} else {
										gint _tmp41_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp41_ = G_MININT;
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp38_ = _tmp41_;
#line 626 "computer-player.c"
									}
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp42_ = _tmp38_;
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									result = _tmp42_;
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 121 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									return result;
#line 636 "computer-player.c"
								} else {
									Game* _tmp43_ = NULL;
									gint _tmp44_ = 0;
									gint _tmp45_ = 0;
									gint _tmp48_ = 0;
#line 125 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp43_ = g;
#line 125 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									game_undo (_tmp43_, 1);
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp45_ = p;
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									if (_tmp45_ > 0) {
#line 650 "computer-player.c"
										gint _tmp46_ = 0;
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp46_ = G_MININT;
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp44_ = _tmp46_;
#line 656 "computer-player.c"
									} else {
										gint _tmp47_ = 0;
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp47_ = G_MAXINT;
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
										_tmp44_ = _tmp47_;
#line 663 "computer-player.c"
									}
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp48_ = _tmp44_;
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									result = _tmp48_;
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 126 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									return result;
#line 673 "computer-player.c"
								}
							} else {
								gint _tmp49_ = 0;
#line 129 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp49_ = n_tiles;
#line 129 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								if (_tmp49_ > 0) {
#line 681 "computer-player.c"
									ComputerPlayerPossibleMove move = {0};
									gint _tmp50_ = 0;
									gint _tmp51_ = 0;
									gint _tmp52_ = 0;
									ComputerPlayerPossibleMove _tmp53_ = {0};
									ComputerPlayerPossibleMove* _tmp54_ = NULL;
									Game* _tmp55_ = NULL;
#line 131 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp50_ = x;
#line 131 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp51_ = y;
#line 131 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp52_ = n_tiles;
#line 131 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									computer_player_possible_move_init (&move, _tmp50_, _tmp51_, _tmp52_);
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp53_ = move;
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp54_ = _computer_player_possible_move_dup0 (&_tmp53_);
#line 132 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									moves = g_list_insert_sorted (moves, _tmp54_, _computer_player_compare_move_gcompare_func);
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									_tmp55_ = g;
#line 133 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
									game_undo (_tmp55_, 1);
#line 707 "computer-player.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 140 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp56_ = moves;
#line 140 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp56_ == NULL) {
#line 720 "computer-player.c"
		ComputerPlayerPossibleMove move = {0};
		ComputerPlayerPossibleMove _tmp57_ = {0};
		ComputerPlayerPossibleMove* _tmp58_ = NULL;
#line 142 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		computer_player_possible_move_init (&move, 0, 0, 0);
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp57_ = move;
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp58_ = _computer_player_possible_move_dup0 (&_tmp57_);
#line 143 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		moves = g_list_append (moves, _tmp58_);
#line 732 "computer-player.c"
	}
#line 147 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp59_ = moves;
#line 736 "computer-player.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 147 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		move_collection = _tmp59_;
#line 147 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 744 "computer-player.c"
			ComputerPlayerPossibleMove* _tmp60_ = NULL;
			ComputerPlayerPossibleMove* move = NULL;
#line 147 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp60_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
#line 147 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			move = _tmp60_;
#line 751 "computer-player.c"
			{
				ComputerPlayerPossibleMove* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gint _tmp77_ = 0;
				Game* _tmp106_ = NULL;
				gint _tmp107_ = 0;
				gint _tmp108_ = 0;
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp61_ = move;
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp62_ = (*_tmp61_).n_tiles;
#line 149 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (_tmp62_ == 0) {
#line 765 "computer-player.c"
					Game* _tmp63_ = NULL;
#line 151 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp63_ = g;
#line 151 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					game_pass (_tmp63_);
#line 771 "computer-player.c"
				} else {
					Game* _tmp64_ = NULL;
					ComputerPlayerPossibleMove* _tmp65_ = NULL;
					gint _tmp66_ = 0;
					ComputerPlayerPossibleMove* _tmp67_ = NULL;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp64_ = g;
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp65_ = move;
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp66_ = (*_tmp65_).x;
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp67_ = move;
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp68_ = (*_tmp67_).y;
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp69_ = game_place_tile (_tmp64_, _tmp66_, _tmp68_);
#line 153 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					if (_tmp69_ == 0) {
#line 793 "computer-player.c"
						gint _tmp70_ = 0;
						ComputerPlayerPossibleMove* _tmp71_ = NULL;
						gint _tmp72_ = 0;
						ComputerPlayerPossibleMove* _tmp73_ = NULL;
						gint _tmp74_ = 0;
						ComputerPlayerPossibleMove* _tmp75_ = NULL;
						gint _tmp76_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp70_ = depth;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp71_ = move;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp72_ = (*_tmp71_).x;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp73_ = move;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp74_ = (*_tmp73_).y;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp75_ = move;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp76_ = (*_tmp75_).n_tiles;
#line 155 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						g_warning ("computer-player.vala:155: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking", _tmp70_, _tmp72_, _tmp74_, _tmp76_);
#line 156 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_computer_player_possible_move_free0 (move);
#line 156 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						continue;
#line 821 "computer-player.c"
					}
				}
#line 167 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp77_ = p;
#line 167 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (_tmp77_ > 0) {
#line 828 "computer-player.c"
					gint next_x_move = 0;
					gint next_y_move = 0;
					gint a_new = 0;
					Game* _tmp78_ = NULL;
					ComputerPlayerStrategy _tmp79_ = 0;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gint _tmp82_ = 0;
					gint _tmp83_ = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
#line 169 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					next_x_move = 0;
#line 169 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					next_y_move = 0;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp78_ = g;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp79_ = strategy;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp80_ = depth;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp81_ = a;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp82_ = b;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp83_ = p;
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp84_ = computer_player_search (_tmp78_, _tmp79_, _tmp80_ - 1, _tmp81_, _tmp82_, -_tmp83_, &next_x_move, &next_y_move);
#line 170 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					a_new = _tmp84_;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp85_ = a_new;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp86_ = a;
#line 171 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					if (_tmp85_ >= _tmp86_) {
#line 867 "computer-player.c"
						gint _tmp87_ = 0;
						ComputerPlayerPossibleMove* _tmp88_ = NULL;
						gint _tmp89_ = 0;
						ComputerPlayerPossibleMove* _tmp90_ = NULL;
						gint _tmp91_ = 0;
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp87_ = a_new;
#line 173 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						a = _tmp87_;
#line 174 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp88_ = move;
#line 174 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp89_ = (*_tmp88_).x;
#line 174 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						*move_x = _tmp89_;
#line 175 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp90_ = move;
#line 175 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp91_ = (*_tmp90_).y;
#line 175 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						*move_y = _tmp91_;
#line 889 "computer-player.c"
					}
				} else {
					gint next_x_move = 0;
					gint next_y_move = 0;
					gint b_new = 0;
					Game* _tmp92_ = NULL;
					ComputerPlayerStrategy _tmp93_ = 0;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
					gint _tmp96_ = 0;
					gint _tmp97_ = 0;
					gint _tmp98_ = 0;
					gint _tmp99_ = 0;
					gint _tmp100_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					next_x_move = 0;
#line 181 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					next_y_move = 0;
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp92_ = g;
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp93_ = strategy;
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp94_ = depth;
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp95_ = a;
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp96_ = b;
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp97_ = p;
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp98_ = computer_player_search (_tmp92_, _tmp93_, _tmp94_ - 1, _tmp95_, _tmp96_, -_tmp97_, &next_x_move, &next_y_move);
#line 182 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					b_new = _tmp98_;
#line 183 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp99_ = b_new;
#line 183 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp100_ = b;
#line 183 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					if (_tmp99_ <= _tmp100_) {
#line 930 "computer-player.c"
						gint _tmp101_ = 0;
						ComputerPlayerPossibleMove* _tmp102_ = NULL;
						gint _tmp103_ = 0;
						ComputerPlayerPossibleMove* _tmp104_ = NULL;
						gint _tmp105_ = 0;
#line 185 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp101_ = b_new;
#line 185 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						b = _tmp101_;
#line 186 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp102_ = move;
#line 186 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp103_ = (*_tmp102_).x;
#line 186 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						*move_x = _tmp103_;
#line 187 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp104_ = move;
#line 187 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp105_ = (*_tmp104_).y;
#line 187 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						*move_y = _tmp105_;
#line 952 "computer-player.c"
					}
				}
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp106_ = g;
#line 191 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				game_undo (_tmp106_, 1);
#line 194 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp107_ = b;
#line 194 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp108_ = a;
#line 194 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (_tmp107_ <= _tmp108_) {
#line 195 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_computer_player_possible_move_free0 (move);
#line 195 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					break;
#line 969 "computer-player.c"
				}
#line 147 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_computer_player_possible_move_free0 (move);
#line 973 "computer-player.c"
			}
		}
	}
#line 198 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp109_ = p;
#line 198 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp109_ > 0) {
#line 981 "computer-player.c"
		gint _tmp110_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp110_ = a;
#line 199 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		result = _tmp110_;
#line 199 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 199 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		return result;
#line 991 "computer-player.c"
	} else {
		gint _tmp111_ = 0;
#line 201 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp111_ = b;
#line 201 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		result = _tmp111_;
#line 201 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 201 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		return result;
#line 1002 "computer-player.c"
	}
#line 96 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	__g_list_free__computer_player_possible_move_free0_0 (moves);
#line 1006 "computer-player.c"
}


static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b) {
	gint result = 0;
	ComputerPlayerPossibleMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ComputerPlayerPossibleMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 206 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = b;
#line 206 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp1_ = (*_tmp0_).n_tiles;
#line 206 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp2_ = a;
#line 206 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp3_ = (*_tmp2_).n_tiles;
#line 206 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	result = _tmp1_ - _tmp3_;
#line 206 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return result;
#line 1028 "computer-player.c"
}


static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy) {
	gint result = 0;
	gint tile_difference = 0;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Player _tmp7_ = 0;
	Player _tmp8_ = 0;
	ComputerPlayerStrategy _tmp10_ = 0;
#line 213 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = g;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp1_ = game_get_n_dark_tiles (_tmp0_);
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp2_ = _tmp1_;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp3_ = g;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp4_ = game_get_n_light_tiles (_tmp3_);
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp5_ = _tmp4_;
#line 215 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	tile_difference = _tmp2_ - _tmp5_;
#line 216 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp6_ = g;
#line 216 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp7_ = game_get_current_color (_tmp6_);
#line 216 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp8_ = _tmp7_;
#line 216 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp8_ == PLAYER_DARK) {
#line 1069 "computer-player.c"
		gint _tmp9_ = 0;
#line 217 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp9_ = tile_difference;
#line 217 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		tile_difference = -_tmp9_;
#line 1075 "computer-player.c"
	}
#line 219 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp10_ = strategy;
#line 219 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	switch (_tmp10_) {
#line 219 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_STRATEGY_PERFECT:
#line 1083 "computer-player.c"
		{
#line 223 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			result = tile_difference;
#line 223 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			return result;
#line 1089 "computer-player.c"
		}
#line 219 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_STRATEGY_VICTORY:
#line 1093 "computer-player.c"
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp11_ = tile_difference;
#line 227 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp12_ = CLAMP (_tmp11_, -1, 1);
#line 227 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			result = _tmp12_;
#line 227 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			return result;
#line 1105 "computer-player.c"
		}
		default:
		{
			gint _tmp13_ = 0;
			Game* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			Game* _tmp16_ = NULL;
			gint _tmp17_ = 0;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp13_ = tile_difference;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp14_ = g;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp15_ = computer_player_around (_tmp14_);
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp16_ = g;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp17_ = computer_player_eval_heuristic (_tmp16_);
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			result = (_tmp13_ - _tmp15_) - _tmp17_;
#line 231 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			return result;
#line 1128 "computer-player.c"
		}
	}
}


static gint computer_player_eval_heuristic (Game* g) {
	gint result = 0;
	gint count = 0;
#line 235 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 237 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	count = 0;
#line 1141 "computer-player.c"
	{
		gint x = 0;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		x = 0;
#line 1146 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1153 "computer-player.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp1_ = _tmp0_;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!_tmp1_) {
#line 1160 "computer-player.c"
					gint _tmp2_ = 0;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp2_ = x;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					x = _tmp2_ + 1;
#line 1166 "computer-player.c"
				}
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp3_ = x;
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!(_tmp3_ < 8)) {
#line 238 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					break;
#line 1176 "computer-player.c"
				}
				{
					gint y = 0;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					y = 0;
#line 1182 "computer-player.c"
					{
						gboolean _tmp4_ = FALSE;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp4_ = TRUE;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1189 "computer-player.c"
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint h = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Game* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Player _tmp14_ = 0;
							Game* _tmp15_ = NULL;
							Player _tmp16_ = 0;
							Player _tmp17_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp5_ = _tmp4_;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!_tmp5_) {
#line 1209 "computer-player.c"
								gint _tmp6_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp6_ = y;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								y = _tmp6_ + 1;
#line 1215 "computer-player.c"
							}
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp4_ = FALSE;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp7_ = y;
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!(_tmp7_ < 8)) {
#line 240 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								break;
#line 1225 "computer-player.c"
							}
#line 242 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp8_ = y;
#line 242 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp9_ = x;
#line 242 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp10_ = COMPUTER_PLAYER_heuristic[(_tmp8_ * 8) + _tmp9_];
#line 242 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							h = _tmp10_;
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp11_ = g;
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp12_ = x;
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp13_ = y;
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp14_ = game_get_owner (_tmp11_, _tmp12_, _tmp13_);
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp15_ = g;
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp16_ = game_get_current_color (_tmp15_);
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp17_ = _tmp16_;
#line 243 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (_tmp14_ != _tmp17_) {
#line 1251 "computer-player.c"
								gint _tmp18_ = 0;
#line 244 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp18_ = h;
#line 244 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								h = -_tmp18_;
#line 1257 "computer-player.c"
							}
#line 245 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp19_ = count;
#line 245 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp20_ = h;
#line 245 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							count = _tmp19_ + _tmp20_;
#line 1265 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 249 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	result = count;
#line 249 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return result;
#line 1276 "computer-player.c"
}


static gint computer_player_around (Game* g) {
	gint result = 0;
	gint count = 0;
#line 252 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 254 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	count = 0;
#line 1287 "computer-player.c"
	{
		gint x = 0;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		x = 0;
#line 1292 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1299 "computer-player.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp1_ = _tmp0_;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!_tmp1_) {
#line 1306 "computer-player.c"
					gint _tmp2_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp2_ = x;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					x = _tmp2_ + 1;
#line 1312 "computer-player.c"
				}
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp3_ = x;
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!(_tmp3_ < 8)) {
#line 255 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					break;
#line 1322 "computer-player.c"
				}
				{
					gint y = 0;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					y = 0;
#line 1328 "computer-player.c"
					{
						gboolean _tmp4_ = FALSE;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp4_ = TRUE;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1335 "computer-player.c"
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint a = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Game* _tmp14_ = NULL;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							Game* _tmp19_ = NULL;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							Game* _tmp24_ = NULL;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							Game* _tmp29_ = NULL;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							Game* _tmp34_ = NULL;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							Game* _tmp39_ = NULL;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							Game* _tmp44_ = NULL;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							Game* _tmp49_ = NULL;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							Player _tmp52_ = 0;
							Game* _tmp53_ = NULL;
							Player _tmp54_ = 0;
							Player _tmp55_ = 0;
							gint _tmp57_ = 0;
							gint _tmp58_ = 0;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp5_ = _tmp4_;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!_tmp5_) {
#line 1393 "computer-player.c"
								gint _tmp6_ = 0;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp6_ = y;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								y = _tmp6_ + 1;
#line 1399 "computer-player.c"
							}
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp4_ = FALSE;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp7_ = y;
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!(_tmp7_ < 8)) {
#line 257 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								break;
#line 1409 "computer-player.c"
							}
#line 259 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = 0;
#line 260 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp8_ = a;
#line 260 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp9_ = g;
#line 260 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp10_ = x;
#line 260 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp11_ = y;
#line 260 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp12_ = computer_player_is_empty (_tmp9_, _tmp10_ + 1, _tmp11_);
#line 260 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp8_ + _tmp12_;
#line 261 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp13_ = a;
#line 261 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp14_ = g;
#line 261 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp15_ = x;
#line 261 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp16_ = y;
#line 261 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp17_ = computer_player_is_empty (_tmp14_, _tmp15_ + 1, _tmp16_ + 1);
#line 261 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp13_ + _tmp17_;
#line 262 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp18_ = a;
#line 262 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp19_ = g;
#line 262 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp20_ = x;
#line 262 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp21_ = y;
#line 262 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp22_ = computer_player_is_empty (_tmp19_, _tmp20_, _tmp21_ + 1);
#line 262 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp18_ + _tmp22_;
#line 263 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp23_ = a;
#line 263 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp24_ = g;
#line 263 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp25_ = x;
#line 263 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp26_ = y;
#line 263 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp27_ = computer_player_is_empty (_tmp24_, _tmp25_ - 1, _tmp26_ + 1);
#line 263 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp23_ + _tmp27_;
#line 264 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp28_ = a;
#line 264 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp29_ = g;
#line 264 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp30_ = x;
#line 264 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp31_ = y;
#line 264 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp32_ = computer_player_is_empty (_tmp29_, _tmp30_ - 1, _tmp31_);
#line 264 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp28_ + _tmp32_;
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp33_ = a;
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp34_ = g;
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp35_ = x;
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp36_ = y;
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp37_ = computer_player_is_empty (_tmp34_, _tmp35_ - 1, _tmp36_ - 1);
#line 265 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp33_ + _tmp37_;
#line 266 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp38_ = a;
#line 266 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp39_ = g;
#line 266 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp40_ = x;
#line 266 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp41_ = y;
#line 266 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp42_ = computer_player_is_empty (_tmp39_, _tmp40_, _tmp41_ - 1);
#line 266 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp38_ + _tmp42_;
#line 267 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp43_ = a;
#line 267 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp44_ = g;
#line 267 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp45_ = x;
#line 267 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp46_ = y;
#line 267 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp47_ = computer_player_is_empty (_tmp44_, _tmp45_ + 1, _tmp46_ - 1);
#line 267 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							a = _tmp43_ + _tmp47_;
#line 270 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp48_ = a;
#line 270 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (_tmp48_ == 0) {
#line 271 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								a = 2;
#line 1515 "computer-player.c"
							}
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp49_ = g;
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp50_ = x;
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp51_ = y;
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp52_ = game_get_owner (_tmp49_, _tmp50_, _tmp51_);
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp53_ = g;
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp54_ = game_get_current_color (_tmp53_);
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp55_ = _tmp54_;
#line 273 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (_tmp52_ != _tmp55_) {
#line 1533 "computer-player.c"
								gint _tmp56_ = 0;
#line 274 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp56_ = a;
#line 274 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								a = -_tmp56_;
#line 1539 "computer-player.c"
							}
#line 275 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp57_ = count;
#line 275 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp58_ = a;
#line 275 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							count = _tmp57_ + _tmp58_;
#line 1547 "computer-player.c"
						}
					}
				}
			}
		}
	}
#line 279 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	result = count;
#line 279 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return result;
#line 1558 "computer-player.c"
}


static gint computer_player_is_empty (Game* g, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp15_ = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (g != NULL, 0);
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp4_ = x;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp4_ < 0) {
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp3_ = TRUE;
#line 1581 "computer-player.c"
	} else {
		gint _tmp5_ = 0;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp5_ = x;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp3_ = _tmp5_ >= 8;
#line 1588 "computer-player.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp6_ = _tmp3_;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp6_) {
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp2_ = TRUE;
#line 1596 "computer-player.c"
	} else {
		gint _tmp7_ = 0;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp7_ = y;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp2_ = _tmp7_ < 0;
#line 1603 "computer-player.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp8_ = _tmp2_;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp8_) {
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp1_ = TRUE;
#line 1611 "computer-player.c"
	} else {
		gint _tmp9_ = 0;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp9_ = y;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp1_ = _tmp9_ >= 8;
#line 1618 "computer-player.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp10_ = _tmp1_;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp10_) {
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp0_ = TRUE;
#line 1626 "computer-player.c"
	} else {
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		Player _tmp14_ = 0;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp11_ = g;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp12_ = x;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp13_ = y;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp14_ = game_get_owner (_tmp11_, _tmp12_, _tmp13_);
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp0_ = _tmp14_ != PLAYER_NONE;
#line 1642 "computer-player.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp15_ = _tmp0_;
#line 284 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp15_) {
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		result = 0;
#line 285 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		return result;
#line 1652 "computer-player.c"
	}
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	result = 1;
#line 287 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return result;
#line 1658 "computer-player.c"
}


static void computer_player_random_select (Game* g, gint* move_x, gint* move_y) {
	gint _vala_move_x = 0;
	gint _vala_move_y = 0;
	GList* moves = NULL;
	GList* _tmp17_ = NULL;
#line 290 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_if_fail (g != NULL);
#line 292 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	moves = NULL;
#line 1671 "computer-player.c"
	{
		gint x = 0;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		x = 0;
#line 1676 "computer-player.c"
		{
			gboolean _tmp0_ = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			_tmp0_ = TRUE;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
			while (TRUE) {
#line 1683 "computer-player.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp1_ = _tmp0_;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!_tmp1_) {
#line 1690 "computer-player.c"
					gint _tmp2_ = 0;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					_tmp2_ = x;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					x = _tmp2_ + 1;
#line 1696 "computer-player.c"
				}
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp0_ = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				_tmp3_ = x;
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
				if (!(_tmp3_ < 8)) {
#line 293 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					break;
#line 1706 "computer-player.c"
				}
				{
					gint y = 0;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
					y = 0;
#line 1712 "computer-player.c"
					{
						gboolean _tmp4_ = FALSE;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						_tmp4_ = TRUE;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
						while (TRUE) {
#line 1719 "computer-player.c"
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Game* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Game* _tmp11_ = NULL;
							Player _tmp12_ = 0;
							Player _tmp13_ = 0;
							gboolean _tmp14_ = FALSE;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp5_ = _tmp4_;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!_tmp5_) {
#line 1733 "computer-player.c"
								gint _tmp6_ = 0;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp6_ = y;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								y = _tmp6_ + 1;
#line 1739 "computer-player.c"
							}
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp4_ = FALSE;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp7_ = y;
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (!(_tmp7_ < 8)) {
#line 295 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								break;
#line 1749 "computer-player.c"
							}
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp8_ = g;
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp9_ = x;
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp10_ = y;
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp11_ = g;
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp12_ = game_get_current_color (_tmp11_);
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp13_ = _tmp12_;
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							_tmp14_ = game_can_place (_tmp8_, _tmp9_, _tmp10_, _tmp13_);
#line 297 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
							if (_tmp14_) {
#line 1767 "computer-player.c"
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp15_ = x;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								_tmp16_ = y;
#line 298 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
								moves = g_list_append (moves, (gpointer) ((gintptr) ((_tmp15_ * 8) + _tmp16_)));
#line 1776 "computer-player.c"
							}
						}
					}
				}
			}
		}
	}
#line 301 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp17_ = moves;
#line 301 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (_tmp17_ != NULL) {
#line 1788 "computer-player.c"
		gint32 i = 0;
		GList* _tmp18_ = NULL;
		guint _tmp19_ = 0U;
		gint32 _tmp20_ = 0;
		gint xy = 0;
		GList* _tmp21_ = NULL;
		gint32 _tmp22_ = 0;
		gconstpointer _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
#line 303 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp18_ = moves;
#line 303 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp19_ = g_list_length (_tmp18_);
#line 303 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp20_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp19_));
#line 303 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		i = _tmp20_;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp21_ = moves;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp22_ = i;
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp23_ = g_list_nth_data (_tmp21_, (guint) _tmp22_);
#line 304 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		xy = (gint) ((gintptr) _tmp23_);
#line 305 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp24_ = xy;
#line 305 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_vala_move_x = _tmp24_ / 8;
#line 306 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp25_ = xy;
#line 306 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_vala_move_y = _tmp25_ % 8;
#line 1823 "computer-player.c"
	} else {
		gint _tmp26_ = 0;
#line 309 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_vala_move_y = 0;
#line 309 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_tmp26_ = _vala_move_y;
#line 309 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		_vala_move_x = _tmp26_;
#line 1832 "computer-player.c"
	}
#line 290 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_g_list_free0 (moves);
#line 290 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (move_x) {
#line 290 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		*move_x = _vala_move_x;
#line 1840 "computer-player.c"
	}
#line 290 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	if (move_y) {
#line 290 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		*move_y = _vala_move_y;
#line 1846 "computer-player.c"
	}
}


gint computer_player_get_level (ComputerPlayer* self) {
	gint result;
	gint _tmp0_ = 0;
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = self->priv->_level;
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	result = _tmp0_;
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return result;
#line 1862 "computer-player.c"
}


static void computer_player_set_level (ComputerPlayer* self, gint value) {
	gint _tmp0_ = 0;
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = value;
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	self->priv->_level = _tmp0_;
#line 38 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_object_notify ((GObject *) self, "level");
#line 1876 "computer-player.c"
}


static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 26 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	memset (self, 0, sizeof (ComputerPlayerPossibleMove));
#line 28 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp0_ = x;
#line 28 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	(*self).x = _tmp0_;
#line 29 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp1_ = y;
#line 29 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	(*self).y = _tmp1_;
#line 30 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_tmp2_ = n_tiles;
#line 30 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	(*self).n_tiles = _tmp2_;
#line 1898 "computer-player.c"
}


static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self) {
	ComputerPlayerPossibleMove* dup;
#line 20 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	dup = g_new0 (ComputerPlayerPossibleMove, 1);
#line 20 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	memcpy (dup, self, sizeof (ComputerPlayerPossibleMove));
#line 20 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	return dup;
#line 1910 "computer-player.c"
}


static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self) {
#line 20 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_free (self);
#line 1917 "computer-player.c"
}


static GType computer_player_possible_move_get_type (void) {
	static volatile gsize computer_player_possible_move_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_possible_move_type_id__volatile)) {
		GType computer_player_possible_move_type_id;
		computer_player_possible_move_type_id = g_boxed_type_register_static ("ComputerPlayerPossibleMove", (GBoxedCopyFunc) computer_player_possible_move_dup, (GBoxedFreeFunc) computer_player_possible_move_free);
		g_once_init_leave (&computer_player_possible_move_type_id__volatile, computer_player_possible_move_type_id);
	}
	return computer_player_possible_move_type_id__volatile;
}


static void computer_player_class_init (ComputerPlayerClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	computer_player_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_type_class_add_private (klass, sizeof (ComputerPlayerPrivate));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPUTER_PLAYER_LEVEL, g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1945 "computer-player.c"
}


static void computer_player_instance_init (ComputerPlayer * self) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	self->priv = COMPUTER_PLAYER_GET_PRIVATE (self);
#line 1952 "computer-player.c"
}


static void computer_player_finalize (GObject* obj) {
	ComputerPlayer * self;
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 35 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	_g_object_unref0 (self->priv->game);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
#line 1964 "computer-player.c"
}


GType computer_player_get_type (void) {
	static volatile gsize computer_player_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
		GType computer_player_type_id;
		computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, 0);
		g_once_init_leave (&computer_player_type_id__volatile, computer_player_type_id);
	}
	return computer_player_type_id__volatile;
}


static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_LEVEL:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		g_value_set_int (value, computer_player_get_level (self));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		break;
#line 1991 "computer-player.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		break;
#line 1997 "computer-player.c"
	}
}


static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		case COMPUTER_PLAYER_LEVEL:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		computer_player_set_level (self, g_value_get_int (value));
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		break;
#line 2013 "computer-player.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/src/iagno/src/computer-player.vala"
		break;
#line 2019 "computer-player.c"
	}
}



