/* puzzle-view.c generated by valac 0.22.0.48-bdf57, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	gint render_size;
	gint piece_x;
	gint piece_y;
	gboolean piece_unmoved;
	gchar _piece_id;
	gchar last_piece_id;
	gdouble kx;
	gdouble ky;
	RsvgHandle* tiles_handle;
	gchar* image_filepath;
	cairo_surface_t* surface;
	Puzzle* _puzzle;
};

struct _Puzzle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GTypeClass parent_class;
	void (*finalize) (Puzzle *self);
};


static gpointer puzzle_view_parent_class = NULL;

GType puzzle_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE
};
#define PUZZLE_VIEW_SPACE_OFFSET 4
#define PUZZLE_VIEW_SPACE_PADDING 5
#define PUZZLE_VIEW_THEME_OVERLAY_SIZE 8
#define PUZZLE_VIEW_THEME_TILE_SEGMENTS 27
#define PUZZLE_VIEW_THEME_TILE_CENTER 14
#define PUZZLE_VIEW_THEME_TILE_SIZE 34
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void puzzle_view_load_image (PuzzleView* self);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr);
static gint puzzle_view_get_tile_size (PuzzleView* self);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky);
static gchar puzzle_view_get_piece_id (PuzzleView* self);
gchar puzzle_get_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y);
gint puzzle_get_piece_nr (Puzzle* self, gint x, gint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_game_over (Puzzle* self);
static void puzzle_view_set_piece_id (PuzzleView* self, gchar value);
static gchar* _vala_array_dup7 (gchar* self, int length);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_movable (Puzzle* self, gint id);
gboolean puzzle_mapcmp (Puzzle* self, gchar* m1, int m1_length1, gchar* m2, int m2_length1);
static gchar* _vala_array_dup8 (gchar* self, int length);
static gchar* _vala_array_dup9 (gchar* self, int length);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
gboolean puzzle_move_piece (Puzzle* self, gchar id, gint x1, gint y1, gint x2, gint y2);
static void puzzle_view_puzzle_changed_cb (PuzzleView* self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self);
static void puzzle_view_finalize (GObject* obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
	self = (PuzzleView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
	puzzle_view_load_image (self);
	return self;
}


PuzzleView* puzzle_view_new (void) {
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
}


static void puzzle_view_load_image (PuzzleView* self) {
	gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "gnome-klotski.svg", NULL, NULL);
	_g_free0 (self->priv->image_filepath);
	self->priv->image_filepath = _tmp0_;
	{
		RsvgHandle* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		RsvgHandle* _tmp3_ = NULL;
		_tmp2_ = self->priv->image_filepath;
		_tmp3_ = rsvg_handle_new_from_file (_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_g_object_unref0 (self->priv->tiles_handle);
		self->priv->tiles_handle = _tmp1_;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		FILE* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s %s\n", "Error in puzzle-view.vala load image:", _tmp6_);
		_tmp7_ = stderr;
		_tmp8_ = self->priv->image_filepath;
		fprintf (_tmp7_, "%s %s\n", "image path:", _tmp8_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GtkStyleContext* _tmp25_ = NULL;
	GdkRGBA fg = {0};
	GtkStyleContext* _tmp26_ = NULL;
	GdkRGBA _tmp27_ = {0};
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp28_ = NULL;
	GdkRGBA _tmp29_ = {0};
	cairo_t* _tmp30_ = NULL;
	GdkRGBA _tmp31_ = {0};
	cairo_t* _tmp32_ = NULL;
	gint width = 0;
	gint _tmp33_ = 0;
	gint height = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	GdkRGBA _tmp36_ = {0};
	cairo_t* _tmp37_ = NULL;
	gdouble kwidth = 0.0;
	Puzzle* _tmp38_ = NULL;
	Puzzle* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gdouble kheight = 0.0;
	Puzzle* _tmp43_ = NULL;
	Puzzle* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gdouble _tmp49_ = 0.0;
	gint _tmp50_ = 0;
	gdouble _tmp51_ = 0.0;
	cairo_t* _tmp52_ = NULL;
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	cairo_t* _tmp57_ = NULL;
	self = (PuzzleView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = puzzle_view_get_tile_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->render_size;
	if (_tmp1_ != _tmp2_) {
		RsvgHandle* _tmp3_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp3_ = self->priv->tiles_handle;
		if (_tmp3_ != NULL) {
			gint height = 0;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint width = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			cairo_t* _tmp8_ = NULL;
			cairo_surface_t* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			cairo_surface_t* _tmp12_ = NULL;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp13_ = NULL;
			cairo_t* _tmp14_ = NULL;
			gdouble sfw = 0.0;
			gint _tmp15_ = 0;
			gdouble sfh = 0.0;
			gint _tmp16_ = 0;
			cairo_t* _tmp17_ = NULL;
			gdouble _tmp18_ = 0.0;
			gdouble _tmp19_ = 0.0;
			RsvgHandle* _tmp20_ = NULL;
			cairo_t* _tmp21_ = NULL;
			_tmp4_ = puzzle_view_get_tile_size (self);
			_tmp5_ = _tmp4_;
			height = _tmp5_ * 2;
			_tmp6_ = puzzle_view_get_tile_size (self);
			_tmp7_ = _tmp6_;
			width = _tmp7_ * PUZZLE_VIEW_THEME_TILE_SEGMENTS;
			_tmp8_ = cr;
			_tmp9_ = cairo_get_target (_tmp8_);
			_tmp10_ = width;
			_tmp11_ = height;
			_tmp12_ = cairo_surface_create_similar (_tmp9_, CAIRO_CONTENT_COLOR_ALPHA, _tmp10_, _tmp11_);
			_cairo_surface_destroy0 (self->priv->surface);
			self->priv->surface = _tmp12_;
			_tmp13_ = self->priv->surface;
			_tmp14_ = cairo_create (_tmp13_);
			c = _tmp14_;
			_tmp15_ = width;
			sfw = ((gdouble) _tmp15_) / 918;
			_tmp16_ = height;
			sfh = ((gdouble) _tmp16_) / 68;
			_tmp17_ = c;
			_tmp18_ = sfw;
			_tmp19_ = sfh;
			cairo_scale (_tmp17_, _tmp18_, _tmp19_);
			_tmp20_ = self->priv->tiles_handle;
			_tmp21_ = c;
			rsvg_handle_render_cairo (_tmp20_, _tmp21_);
			_cairo_destroy0 (c);
		}
		_tmp22_ = puzzle_view_get_tile_size (self);
		_tmp23_ = _tmp22_;
		self->priv->render_size = _tmp23_;
	}
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	style = _tmp25_;
	_tmp26_ = style;
	gtk_style_context_get_color (_tmp26_, GTK_STATE_FLAG_NORMAL, &_tmp27_);
	fg = _tmp27_;
	_tmp28_ = style;
	gtk_style_context_get_background_color (_tmp28_, GTK_STATE_FLAG_NORMAL, &_tmp29_);
	bg = _tmp29_;
	_tmp30_ = cr;
	_tmp31_ = bg;
	gdk_cairo_set_source_rgba (_tmp30_, &_tmp31_);
	_tmp32_ = cr;
	cairo_paint (_tmp32_);
	_tmp33_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	width = _tmp33_;
	_tmp34_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	height = _tmp34_;
	_tmp35_ = cr;
	_tmp36_ = fg;
	gdk_cairo_set_source_rgba (_tmp35_, &_tmp36_);
	_tmp37_ = cr;
	cairo_set_line_width (_tmp37_, 1.0);
	_tmp38_ = puzzle_view_get_puzzle (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_->width;
	_tmp41_ = puzzle_view_get_tile_size (self);
	_tmp42_ = _tmp41_;
	kwidth = ((_tmp40_ * _tmp42_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
	_tmp43_ = puzzle_view_get_puzzle (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = _tmp44_->height;
	_tmp46_ = puzzle_view_get_tile_size (self);
	_tmp47_ = _tmp46_;
	kheight = ((_tmp45_ * _tmp47_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
	_tmp48_ = width;
	_tmp49_ = kwidth;
	self->priv->kx = (_tmp48_ - _tmp49_) / 2.0;
	_tmp50_ = height;
	_tmp51_ = kheight;
	self->priv->ky = (_tmp50_ - _tmp51_) / 2.0;
	_tmp52_ = cr;
	_tmp53_ = self->priv->kx;
	_tmp54_ = self->priv->ky;
	_tmp55_ = kwidth;
	_tmp56_ = kheight;
	cairo_rectangle (_tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
	_tmp57_ = cr;
	cairo_stroke (_tmp57_);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				gboolean _tmp59_ = FALSE;
				gint _tmp61_ = 0;
				Puzzle* _tmp62_ = NULL;
				Puzzle* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				_tmp59_ = _tmp58_;
				if (!_tmp59_) {
					gint _tmp60_ = 0;
					_tmp60_ = y;
					y = _tmp60_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp61_ = y;
				_tmp62_ = puzzle_view_get_puzzle (self);
				_tmp63_ = _tmp62_;
				_tmp64_ = _tmp63_->height;
				if (!(_tmp61_ < _tmp64_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp65_ = FALSE;
						_tmp65_ = TRUE;
						while (TRUE) {
							gboolean _tmp66_ = FALSE;
							gint _tmp68_ = 0;
							Puzzle* _tmp69_ = NULL;
							Puzzle* _tmp70_ = NULL;
							gint _tmp71_ = 0;
							cairo_t* _tmp72_ = NULL;
							gint _tmp73_ = 0;
							gint _tmp74_ = 0;
							gdouble _tmp75_ = 0.0;
							gdouble _tmp76_ = 0.0;
							gchar _tmp77_ = '\0';
							gchar _tmp78_ = '\0';
							Puzzle* _tmp79_ = NULL;
							Puzzle* _tmp80_ = NULL;
							Puzzle* _tmp81_ = NULL;
							Puzzle* _tmp82_ = NULL;
							gchar* _tmp83_ = NULL;
							gint _tmp83__length1 = 0;
							gint _tmp84_ = 0;
							gint _tmp85_ = 0;
							gchar _tmp86_ = '\0';
							_tmp66_ = _tmp65_;
							if (!_tmp66_) {
								gint _tmp67_ = 0;
								_tmp67_ = x;
								x = _tmp67_ + 1;
							}
							_tmp65_ = FALSE;
							_tmp68_ = x;
							_tmp69_ = puzzle_view_get_puzzle (self);
							_tmp70_ = _tmp69_;
							_tmp71_ = _tmp70_->width;
							if (!(_tmp68_ < _tmp71_)) {
								break;
							}
							_tmp72_ = cr;
							_tmp73_ = x;
							_tmp74_ = y;
							_tmp75_ = self->priv->kx;
							_tmp76_ = self->priv->ky;
							puzzle_view_draw_square (self, _tmp72_, _tmp73_, _tmp74_, _tmp75_, _tmp76_);
							_tmp77_ = puzzle_view_get_piece_id (self);
							_tmp78_ = _tmp77_;
							_tmp79_ = puzzle_view_get_puzzle (self);
							_tmp80_ = _tmp79_;
							_tmp81_ = puzzle_view_get_puzzle (self);
							_tmp82_ = _tmp81_;
							_tmp83_ = _tmp82_->map;
							_tmp83__length1 = _tmp82_->map_length1;
							_tmp84_ = x;
							_tmp85_ = y;
							_tmp86_ = puzzle_get_piece_id (_tmp80_, _tmp83_, _tmp83__length1, _tmp84_, _tmp85_);
							if (_tmp78_ == _tmp86_) {
								cairo_t* _tmp87_ = NULL;
								GdkRGBA _tmp88_ = {0};
								cairo_t* _tmp89_ = NULL;
								gint _tmp90_ = 0;
								gint _tmp91_ = 0;
								gint _tmp92_ = 0;
								gdouble _tmp93_ = 0.0;
								gint _tmp94_ = 0;
								gint _tmp95_ = 0;
								gint _tmp96_ = 0;
								gdouble _tmp97_ = 0.0;
								gint _tmp98_ = 0;
								gint _tmp99_ = 0;
								gint _tmp100_ = 0;
								gint _tmp101_ = 0;
								cairo_t* _tmp102_ = NULL;
								_tmp87_ = cr;
								_tmp88_.red = 1.0;
								_tmp88_.green = 1.0;
								_tmp88_.blue = 1.0;
								_tmp88_.alpha = 0.2;
								gdk_cairo_set_source_rgba (_tmp87_, &_tmp88_);
								_tmp89_ = cr;
								_tmp90_ = x;
								_tmp91_ = puzzle_view_get_tile_size (self);
								_tmp92_ = _tmp91_;
								_tmp93_ = self->priv->kx;
								_tmp94_ = y;
								_tmp95_ = puzzle_view_get_tile_size (self);
								_tmp96_ = _tmp95_;
								_tmp97_ = self->priv->ky;
								_tmp98_ = puzzle_view_get_tile_size (self);
								_tmp99_ = _tmp98_;
								_tmp100_ = puzzle_view_get_tile_size (self);
								_tmp101_ = _tmp100_;
								cairo_rectangle (_tmp89_, (_tmp90_ * _tmp92_) + _tmp93_, (_tmp94_ * _tmp96_) + _tmp97_, (gdouble) _tmp99_, (gdouble) _tmp101_);
								_tmp102_ = cr;
								cairo_fill (_tmp102_);
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (style);
	return result;
}


static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky) {
	GdkRectangle rect = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp14_ = NULL;
	GdkRGBA _tmp15_ = {0};
	cairo_t* _tmp16_ = NULL;
	GdkRectangle _tmp17_ = {0};
	cairo_t* _tmp18_ = NULL;
	GdkRGBA _tmp19_ = {0};
	cairo_t* _tmp20_ = NULL;
	Puzzle* _tmp21_ = NULL;
	Puzzle* _tmp22_ = NULL;
	Puzzle* _tmp23_ = NULL;
	Puzzle* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gchar _tmp28_ = '\0';
	Puzzle* _tmp47_ = NULL;
	Puzzle* _tmp48_ = NULL;
	Puzzle* _tmp49_ = NULL;
	Puzzle* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gchar _tmp54_ = '\0';
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	memset (&rect, 0, sizeof (GdkRectangle));
	_tmp0_ = x;
	_tmp1_ = puzzle_view_get_tile_size (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = kx;
	rect.x = (((_tmp0_ * _tmp2_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp3_)) - 1;
	_tmp4_ = y;
	_tmp5_ = puzzle_view_get_tile_size (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = ky;
	rect.y = (((_tmp4_ * _tmp6_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp7_)) - 1;
	_tmp8_ = puzzle_view_get_tile_size (self);
	_tmp9_ = _tmp8_;
	rect.width = _tmp9_;
	_tmp10_ = puzzle_view_get_tile_size (self);
	_tmp11_ = _tmp10_;
	rect.height = _tmp11_;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	style = _tmp13_;
	_tmp14_ = style;
	gtk_style_context_get_background_color (_tmp14_, GTK_STATE_FLAG_NORMAL, &_tmp15_);
	bg = _tmp15_;
	_tmp16_ = cr;
	_tmp17_ = rect;
	gdk_cairo_rectangle (_tmp16_, &_tmp17_);
	_tmp18_ = cr;
	_tmp19_ = bg;
	gdk_cairo_set_source_rgba (_tmp18_, &_tmp19_);
	_tmp20_ = cr;
	cairo_fill (_tmp20_);
	_tmp21_ = puzzle_view_get_puzzle (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = puzzle_view_get_puzzle (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->map;
	_tmp25__length1 = _tmp24_->map_length1;
	_tmp26_ = x;
	_tmp27_ = y;
	_tmp28_ = puzzle_get_piece_id (_tmp22_, _tmp25_, _tmp25__length1, _tmp26_, _tmp27_);
	if (_tmp28_ != ' ') {
		cairo_t* _tmp29_ = NULL;
		GdkRectangle _tmp30_ = {0};
		cairo_t* _tmp31_ = NULL;
		cairo_surface_t* _tmp32_ = NULL;
		GdkRectangle _tmp33_ = {0};
		gint _tmp34_ = 0;
		Puzzle* _tmp35_ = NULL;
		Puzzle* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		GdkRectangle _tmp42_ = {0};
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		cairo_t* _tmp46_ = NULL;
		_tmp29_ = cr;
		_tmp30_ = rect;
		gdk_cairo_rectangle (_tmp29_, &_tmp30_);
		_tmp31_ = cr;
		_tmp32_ = self->priv->surface;
		_tmp33_ = rect;
		_tmp34_ = _tmp33_.x;
		_tmp35_ = puzzle_view_get_puzzle (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = x;
		_tmp38_ = y;
		_tmp39_ = puzzle_get_piece_nr (_tmp36_, _tmp37_, _tmp38_);
		_tmp40_ = puzzle_view_get_tile_size (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = rect;
		_tmp43_ = _tmp42_.y;
		_tmp44_ = puzzle_view_get_tile_size (self);
		_tmp45_ = _tmp44_;
		cairo_set_source_surface (_tmp31_, _tmp32_, (gdouble) (_tmp34_ - (_tmp39_ * _tmp41_)), (gdouble) (_tmp43_ - (_tmp45_ / 2)));
		_tmp46_ = cr;
		cairo_fill (_tmp46_);
	}
	_tmp47_ = puzzle_view_get_puzzle (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = puzzle_view_get_puzzle (self);
	_tmp50_ = _tmp49_;
	_tmp51_ = _tmp50_->map;
	_tmp51__length1 = _tmp50_->map_length1;
	_tmp52_ = x;
	_tmp53_ = y;
	_tmp54_ = puzzle_get_piece_id (_tmp48_, _tmp51_, _tmp51__length1, _tmp52_, _tmp53_);
	if (_tmp54_ == '*') {
		gint value = 0;
		Puzzle* _tmp55_ = NULL;
		Puzzle* _tmp56_ = NULL;
		Puzzle* _tmp57_ = NULL;
		Puzzle* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gchar _tmp62_ = '\0';
		gint overlay_size = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint overlay_offset = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		cairo_t* _tmp68_ = NULL;
		GdkRectangle _tmp69_ = {0};
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		GdkRectangle _tmp72_ = {0};
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		cairo_t* _tmp77_ = NULL;
		cairo_surface_t* _tmp78_ = NULL;
		GdkRectangle _tmp79_ = {0};
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		GdkRectangle _tmp84_ = {0};
		gint _tmp85_ = 0;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		cairo_t* _tmp88_ = NULL;
		value = 22;
		_tmp55_ = puzzle_view_get_puzzle (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = puzzle_view_get_puzzle (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_->orig_map;
		_tmp59__length1 = _tmp58_->orig_map_length1;
		_tmp60_ = x;
		_tmp61_ = y;
		_tmp62_ = puzzle_get_piece_id (_tmp56_, _tmp59_, _tmp59__length1, _tmp60_, _tmp61_);
		if (_tmp62_ == '.') {
			value = 20;
		}
		_tmp63_ = puzzle_view_get_tile_size (self);
		_tmp64_ = _tmp63_;
		overlay_size = (PUZZLE_VIEW_THEME_OVERLAY_SIZE * _tmp64_) / PUZZLE_VIEW_THEME_TILE_SIZE;
		_tmp65_ = puzzle_view_get_tile_size (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = overlay_size;
		overlay_offset = ((PUZZLE_VIEW_THEME_TILE_CENTER * _tmp66_) / PUZZLE_VIEW_THEME_TILE_SIZE) - (_tmp67_ / 2);
		_tmp68_ = cr;
		_tmp69_ = rect;
		_tmp70_ = _tmp69_.x;
		_tmp71_ = overlay_offset;
		_tmp72_ = rect;
		_tmp73_ = _tmp72_.y;
		_tmp74_ = overlay_offset;
		_tmp75_ = overlay_size;
		_tmp76_ = overlay_size;
		cairo_rectangle (_tmp68_, (gdouble) (_tmp70_ + _tmp71_), (gdouble) (_tmp73_ + _tmp74_), (gdouble) _tmp75_, (gdouble) _tmp76_);
		_tmp77_ = cr;
		_tmp78_ = self->priv->surface;
		_tmp79_ = rect;
		_tmp80_ = _tmp79_.x;
		_tmp81_ = value;
		_tmp82_ = puzzle_view_get_tile_size (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = rect;
		_tmp85_ = _tmp84_.y;
		_tmp86_ = puzzle_view_get_tile_size (self);
		_tmp87_ = _tmp86_;
		cairo_set_source_surface (_tmp77_, _tmp78_, (gdouble) (_tmp80_ - (_tmp81_ * _tmp83_)), (gdouble) (_tmp85_ - (_tmp87_ / 2)));
		_tmp88_ = cr;
		cairo_fill (_tmp88_);
	}
	_g_object_unref0 (style);
}


static gchar* _vala_array_dup7 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	guint _tmp1_ = 0U;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint) 1)) {
		Puzzle* _tmp2_ = NULL;
		Puzzle* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GdkEventButton _tmp5_ = {0};
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GdkEventButton _tmp10_ = {0};
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar new_piece_id = '\0';
		Puzzle* _tmp15_ = NULL;
		Puzzle* _tmp16_ = NULL;
		Puzzle* _tmp17_ = NULL;
		Puzzle* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gchar _tmp22_ = '\0';
		gboolean _tmp23_ = FALSE;
		gchar _tmp24_ = '\0';
		gchar _tmp25_ = '\0';
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gchar _tmp32_ = '\0';
		gboolean _tmp34_ = FALSE;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp42_ = FALSE;
		gchar _tmp43_ = '\0';
		Puzzle* _tmp44_ = NULL;
		Puzzle* _tmp45_ = NULL;
		Puzzle* _tmp46_ = NULL;
		Puzzle* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		gchar* _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		_tmp2_ = puzzle_view_get_puzzle (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = puzzle_game_over (_tmp3_);
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.x;
		_tmp7_ = self->priv->kx;
		_tmp8_ = puzzle_view_get_tile_size (self);
		_tmp9_ = _tmp8_;
		self->priv->piece_x = ((gint) (_tmp6_ - _tmp7_)) / _tmp9_;
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.y;
		_tmp12_ = self->priv->ky;
		_tmp13_ = puzzle_view_get_tile_size (self);
		_tmp14_ = _tmp13_;
		self->priv->piece_y = ((gint) (_tmp11_ - _tmp12_)) / _tmp14_;
		_tmp15_ = puzzle_view_get_puzzle (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = puzzle_view_get_puzzle (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_->map;
		_tmp19__length1 = _tmp18_->map_length1;
		_tmp20_ = self->priv->piece_x;
		_tmp21_ = self->priv->piece_y;
		_tmp22_ = puzzle_get_piece_id (_tmp16_, _tmp19_, _tmp19__length1, _tmp20_, _tmp21_);
		new_piece_id = _tmp22_;
		_tmp24_ = puzzle_view_get_piece_id (self);
		_tmp25_ = _tmp24_;
		if (_tmp25_ != '\0') {
			gboolean _tmp26_ = FALSE;
			_tmp26_ = self->priv->piece_unmoved;
			_tmp23_ = _tmp26_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp27_ = _tmp23_;
		if (_tmp27_) {
			puzzle_view_set_piece_id (self, '\0');
			result = FALSE;
			return result;
		}
		_tmp32_ = new_piece_id;
		if (_tmp32_ == ' ') {
			_tmp31_ = TRUE;
		} else {
			gchar _tmp33_ = '\0';
			_tmp33_ = new_piece_id;
			_tmp31_ = _tmp33_ == '.';
		}
		_tmp34_ = _tmp31_;
		if (_tmp34_) {
			_tmp30_ = TRUE;
		} else {
			gchar _tmp35_ = '\0';
			_tmp35_ = new_piece_id;
			_tmp30_ = _tmp35_ == '-';
		}
		_tmp36_ = _tmp30_;
		if (_tmp36_) {
			_tmp29_ = TRUE;
		} else {
			gchar _tmp37_ = '\0';
			_tmp37_ = new_piece_id;
			_tmp29_ = _tmp37_ == '#';
		}
		_tmp38_ = _tmp29_;
		if (_tmp38_) {
			_tmp28_ = TRUE;
		} else {
			gchar _tmp39_ = '\0';
			gchar _tmp40_ = '\0';
			gchar _tmp41_ = '\0';
			_tmp39_ = new_piece_id;
			_tmp40_ = puzzle_view_get_piece_id (self);
			_tmp41_ = _tmp40_;
			_tmp28_ = _tmp39_ == _tmp41_;
		}
		_tmp42_ = _tmp28_;
		if (_tmp42_) {
			result = FALSE;
			return result;
		}
		self->priv->piece_unmoved = TRUE;
		_tmp43_ = new_piece_id;
		puzzle_view_set_piece_id (self, _tmp43_);
		_tmp44_ = puzzle_view_get_puzzle (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = puzzle_view_get_puzzle (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_->map;
		_tmp48__length1 = _tmp47_->map_length1;
		_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup7 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
		_tmp49__length1 = _tmp48__length1;
		_tmp45_->move_map = (g_free (_tmp45_->move_map), NULL);
		_tmp45_->move_map = _tmp49_;
		_tmp45_->move_map_length1 = _tmp49__length1;
	}
	result = FALSE;
	return result;
}


static gchar* _vala_array_dup8 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gchar* _vala_array_dup9 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_ = {0};
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.button;
	if (_tmp2_ == ((guint) 1)) {
		gchar _tmp3_ = '\0';
		gchar _tmp4_ = '\0';
		_tmp3_ = puzzle_view_get_piece_id (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != '\0';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		Puzzle* _tmp8_ = NULL;
		Puzzle* _tmp9_ = NULL;
		gchar _tmp10_ = '\0';
		gchar _tmp11_ = '\0';
		gboolean _tmp12_ = FALSE;
		gboolean _tmp22_ = FALSE;
		_tmp6_ = self->priv->piece_unmoved;
		if (_tmp6_) {
			result = FALSE;
			return result;
		}
		_tmp8_ = puzzle_view_get_puzzle (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = puzzle_view_get_piece_id (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = puzzle_movable (_tmp9_, (gint) _tmp11_);
		if (_tmp12_) {
			Puzzle* _tmp13_ = NULL;
			Puzzle* _tmp14_ = NULL;
			Puzzle* _tmp15_ = NULL;
			Puzzle* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			Puzzle* _tmp18_ = NULL;
			Puzzle* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gboolean _tmp21_ = FALSE;
			_tmp13_ = puzzle_view_get_puzzle (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = puzzle_view_get_puzzle (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->move_map;
			_tmp17__length1 = _tmp16_->move_map_length1;
			_tmp18_ = puzzle_view_get_puzzle (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_->map;
			_tmp20__length1 = _tmp19_->map_length1;
			_tmp21_ = puzzle_mapcmp (_tmp14_, _tmp17_, _tmp17__length1, _tmp20_, _tmp20__length1);
			_tmp7_ = _tmp21_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp22_ = _tmp7_;
		if (_tmp22_) {
			gboolean _tmp23_ = FALSE;
			gchar _tmp24_ = '\0';
			gboolean _tmp28_ = FALSE;
			gboolean _tmp41_ = FALSE;
			Puzzle* _tmp42_ = NULL;
			Puzzle* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			gboolean _tmp54_ = FALSE;
			Puzzle* _tmp60_ = NULL;
			Puzzle* _tmp61_ = NULL;
			Puzzle* _tmp62_ = NULL;
			Puzzle* _tmp63_ = NULL;
			gchar* _tmp64_ = NULL;
			gint _tmp64__length1 = 0;
			gchar* _tmp65_ = NULL;
			gint _tmp65__length1 = 0;
			Puzzle* _tmp66_ = NULL;
			Puzzle* _tmp67_ = NULL;
			_tmp24_ = self->priv->last_piece_id;
			if (_tmp24_ == '\0') {
				_tmp23_ = TRUE;
			} else {
				gchar _tmp25_ = '\0';
				gchar _tmp26_ = '\0';
				gchar _tmp27_ = '\0';
				_tmp25_ = self->priv->last_piece_id;
				_tmp26_ = puzzle_view_get_piece_id (self);
				_tmp27_ = _tmp26_;
				_tmp23_ = _tmp25_ != _tmp27_;
			}
			_tmp28_ = _tmp23_;
			if (_tmp28_) {
				Puzzle* _tmp29_ = NULL;
				Puzzle* _tmp30_ = NULL;
				Puzzle* _tmp31_ = NULL;
				Puzzle* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				gchar* _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
				Puzzle* _tmp35_ = NULL;
				Puzzle* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				_tmp29_ = puzzle_view_get_puzzle (self);
				_tmp30_ = _tmp29_;
				_tmp31_ = puzzle_view_get_puzzle (self);
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp32_->lastmove_map;
				_tmp33__length1 = _tmp32_->lastmove_map_length1;
				_tmp34_ = (_tmp33_ != NULL) ? _vala_array_dup8 (_tmp33_, _tmp33__length1) : ((gpointer) _tmp33_);
				_tmp34__length1 = _tmp33__length1;
				_tmp30_->undomove_map = (g_free (_tmp30_->undomove_map), NULL);
				_tmp30_->undomove_map = _tmp34_;
				_tmp30_->undomove_map_length1 = _tmp34__length1;
				_tmp35_ = puzzle_view_get_puzzle (self);
				_tmp36_ = _tmp35_;
				_tmp37_ = _tmp36_->moves;
				if (_tmp37_ < 999) {
					Puzzle* _tmp38_ = NULL;
					Puzzle* _tmp39_ = NULL;
					gint _tmp40_ = 0;
					_tmp38_ = puzzle_view_get_puzzle (self);
					_tmp39_ = _tmp38_;
					_tmp40_ = _tmp39_->moves;
					_tmp39_->moves = _tmp40_ + 1;
				}
			}
			_tmp42_ = puzzle_view_get_puzzle (self);
			_tmp43_ = _tmp42_;
			_tmp44_ = _tmp43_->moves;
			if (_tmp44_ > 0) {
				Puzzle* _tmp45_ = NULL;
				Puzzle* _tmp46_ = NULL;
				Puzzle* _tmp47_ = NULL;
				Puzzle* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				Puzzle* _tmp50_ = NULL;
				Puzzle* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				gboolean _tmp53_ = FALSE;
				_tmp45_ = puzzle_view_get_puzzle (self);
				_tmp46_ = _tmp45_;
				_tmp47_ = puzzle_view_get_puzzle (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = _tmp48_->undomove_map;
				_tmp49__length1 = _tmp48_->undomove_map_length1;
				_tmp50_ = puzzle_view_get_puzzle (self);
				_tmp51_ = _tmp50_;
				_tmp52_ = _tmp51_->map;
				_tmp52__length1 = _tmp51_->map_length1;
				_tmp53_ = puzzle_mapcmp (_tmp46_, _tmp49_, _tmp49__length1, _tmp52_, _tmp52__length1);
				_tmp41_ = !_tmp53_;
			} else {
				_tmp41_ = FALSE;
			}
			_tmp54_ = _tmp41_;
			if (_tmp54_) {
				Puzzle* _tmp55_ = NULL;
				Puzzle* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				_tmp55_ = puzzle_view_get_puzzle (self);
				_tmp56_ = _tmp55_;
				_tmp57_ = _tmp56_->moves;
				_tmp56_->moves = _tmp57_ - 1;
				self->priv->last_piece_id = '\0';
			} else {
				gchar _tmp58_ = '\0';
				gchar _tmp59_ = '\0';
				_tmp58_ = puzzle_view_get_piece_id (self);
				_tmp59_ = _tmp58_;
				self->priv->last_piece_id = _tmp59_;
			}
			_tmp60_ = puzzle_view_get_puzzle (self);
			_tmp61_ = _tmp60_;
			_tmp62_ = puzzle_view_get_puzzle (self);
			_tmp63_ = _tmp62_;
			_tmp64_ = _tmp63_->map;
			_tmp64__length1 = _tmp63_->map_length1;
			_tmp65_ = (_tmp64_ != NULL) ? _vala_array_dup9 (_tmp64_, _tmp64__length1) : ((gpointer) _tmp64_);
			_tmp65__length1 = _tmp64__length1;
			_tmp61_->lastmove_map = (g_free (_tmp61_->lastmove_map), NULL);
			_tmp61_->lastmove_map = _tmp65_;
			_tmp61_->lastmove_map_length1 = _tmp65__length1;
			_tmp66_ = puzzle_view_get_puzzle (self);
			_tmp67_ = _tmp66_;
			g_signal_emit_by_name (_tmp67_, "moved");
		}
		puzzle_view_set_piece_id (self, '\0');
	}
	result = FALSE;
	return result;
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint new_piece_x = 0;
	gint new_piece_y = 0;
	gchar _tmp0_ = '\0';
	gchar _tmp1_ = '\0';
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = puzzle_view_get_piece_id (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != '\0') {
		GdkEventMotion _tmp2_ = {0};
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkEventMotion _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_ = 0;
		Puzzle* _tmp16_ = NULL;
		Puzzle* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp29_ = FALSE;
		Puzzle* _tmp30_ = NULL;
		Puzzle* _tmp31_ = NULL;
		gchar _tmp32_ = '\0';
		gchar _tmp33_ = '\0';
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		gboolean _tmp38_ = FALSE;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.x;
		_tmp4_ = self->priv->kx;
		_tmp5_ = puzzle_view_get_tile_size (self);
		_tmp6_ = _tmp5_;
		new_piece_x = ((gint) (_tmp3_ - _tmp4_)) / _tmp6_;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.y;
		_tmp9_ = self->priv->ky;
		_tmp10_ = puzzle_view_get_tile_size (self);
		_tmp11_ = _tmp10_;
		new_piece_y = ((gint) (_tmp8_ - _tmp9_)) / _tmp11_;
		_tmp15_ = new_piece_x;
		_tmp16_ = puzzle_view_get_puzzle (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_->width;
		if (_tmp15_ >= _tmp18_) {
			_tmp14_ = TRUE;
		} else {
			GdkEventMotion _tmp19_ = {0};
			gdouble _tmp20_ = 0.0;
			_tmp19_ = *event;
			_tmp20_ = _tmp19_.x;
			_tmp14_ = _tmp20_ < ((gdouble) 0);
		}
		_tmp21_ = _tmp14_;
		if (_tmp21_) {
			_tmp13_ = TRUE;
		} else {
			gint _tmp22_ = 0;
			Puzzle* _tmp23_ = NULL;
			Puzzle* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			_tmp22_ = new_piece_y;
			_tmp23_ = puzzle_view_get_puzzle (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = _tmp24_->height;
			_tmp13_ = _tmp22_ >= _tmp25_;
		}
		_tmp26_ = _tmp13_;
		if (_tmp26_) {
			_tmp12_ = TRUE;
		} else {
			GdkEventMotion _tmp27_ = {0};
			gdouble _tmp28_ = 0.0;
			_tmp27_ = *event;
			_tmp28_ = _tmp27_.y;
			_tmp12_ = _tmp28_ < ((gdouble) 0);
		}
		_tmp29_ = _tmp12_;
		if (_tmp29_) {
			result = FALSE;
			return result;
		}
		_tmp30_ = puzzle_view_get_puzzle (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = puzzle_view_get_piece_id (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->priv->piece_x;
		_tmp35_ = self->priv->piece_y;
		_tmp36_ = new_piece_x;
		_tmp37_ = new_piece_y;
		_tmp38_ = puzzle_move_piece (_tmp31_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
		if (_tmp38_) {
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			self->priv->piece_unmoved = FALSE;
			_tmp39_ = new_piece_x;
			self->priv->piece_x = _tmp39_;
			_tmp40_ = new_piece_y;
			self->priv->piece_y = _tmp40_;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void puzzle_view_puzzle_changed_cb (PuzzleView* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gchar puzzle_view_get_piece_id (PuzzleView* self) {
	gchar result;
	gchar _tmp0_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = self->priv->_piece_id;
	result = _tmp0_;
	return result;
}


static void puzzle_view_set_piece_id (PuzzleView* self, gchar value) {
	gchar _tmp0_ = '\0';
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_piece_id = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_puzzle;
	result = _tmp0_;
	return result;
}


static gpointer _puzzle_ref0 (gpointer self) {
	return self ? puzzle_ref (self) : NULL;
}


static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self) {
	puzzle_view_puzzle_changed_cb (self);
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp2_ = NULL;
	Puzzle* _tmp3_ = NULL;
	Puzzle* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_puzzle;
	if (_tmp0_ != NULL) {
		Puzzle* _tmp1_ = NULL;
		_tmp1_ = self->priv->_puzzle;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _puzzle_ref0 (_tmp2_);
	_puzzle_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp3_;
	_tmp4_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _puzzle_view_puzzle_changed_cb_puzzle_changed, self, 0);
	self->priv->piece_x = 0;
	self->priv->piece_y = 0;
	puzzle_view_set_piece_id (self, '\0');
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "puzzle");
}


static gint puzzle_view_get_tile_size (PuzzleView* self) {
	gint result;
	gint s = 0;
	gint _tmp0_ = 0;
	Puzzle* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Puzzle* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp11_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = puzzle_view_get_puzzle (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN ((_tmp0_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp3_, (_tmp4_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if ((_tmp9_ % 2) != 0) {
		gint _tmp10_ = 0;
		_tmp10_ = s;
		s = _tmp10_ - 1;
	}
	_tmp11_ = s;
	result = _tmp11_;
	return result;
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
	GTK_WIDGET_CLASS (klass)->draw = puzzle_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = puzzle_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = puzzle_view_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = puzzle_view_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE, param_spec_puzzle ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void puzzle_view_instance_init (PuzzleView * self) {
	gchar* _tmp0_ = NULL;
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
	self->priv->render_size = 0;
	self->priv->piece_x = 0;
	self->priv->piece_y = 0;
	self->priv->piece_unmoved = FALSE;
	self->priv->_piece_id = '\0';
	self->priv->last_piece_id = '\0';
	self->priv->kx = (gdouble) 0;
	self->priv->ky = (gdouble) 0;
	self->priv->tiles_handle = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->image_filepath = _tmp0_;
	self->priv->surface = NULL;
	self->priv->_puzzle = NULL;
}


static void puzzle_view_finalize (GObject* obj) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
	_g_object_unref0 (self->priv->tiles_handle);
	_g_free0 (self->priv->image_filepath);
	_cairo_surface_destroy0 (self->priv->surface);
	_puzzle_unref0 (self->priv->_puzzle);
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		value_set_puzzle (value, puzzle_view_get_puzzle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE:
		puzzle_view_set_puzzle (self, value_get_puzzle (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



