/* rygel-user-config.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Krzesimir Nowak <krnowak@openismus.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_ENTRY_TYPE (rygel_entry_type_get_type ())

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;

#define RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR (rygel_user_config_config_pair_get_type ())
#define RYGEL_USER_CONFIG_CONFIG_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPair))
#define RYGEL_USER_CONFIG_CONFIG_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPairClass))
#define RYGEL_USER_CONFIG_IS_CONFIG_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR))
#define RYGEL_USER_CONFIG_IS_CONFIG_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR))
#define RYGEL_USER_CONFIG_CONFIG_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPairClass))

typedef struct _RygelUserConfigConfigPair RygelUserConfigConfigPair;
typedef struct _RygelUserConfigConfigPairClass RygelUserConfigConfigPairClass;

#define RYGEL_USER_CONFIG_TYPE_SECTION_PAIR (rygel_user_config_section_pair_get_type ())
#define RYGEL_USER_CONFIG_SECTION_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPair))
#define RYGEL_USER_CONFIG_SECTION_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPairClass))
#define RYGEL_USER_CONFIG_IS_SECTION_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR))
#define RYGEL_USER_CONFIG_IS_SECTION_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR))
#define RYGEL_USER_CONFIG_SECTION_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPairClass))

typedef struct _RygelUserConfigSectionPair RygelUserConfigSectionPair;
typedef struct _RygelUserConfigSectionPairClass RygelUserConfigSectionPairClass;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelUserConfigSectionPairPrivate RygelUserConfigSectionPairPrivate;

#define RYGEL_TYPE_SECTION_ENTRY (rygel_section_entry_get_type ())
#define _rygel_user_config_section_pair_unref0(var) ((var == NULL) ? NULL : (var = (rygel_user_config_section_pair_unref (var), NULL)))
typedef struct _RygelUserConfigConfigPairPrivate RygelUserConfigConfigPairPrivate;

#define RYGEL_TYPE_CONFIGURATION_ENTRY (rygel_configuration_entry_get_type ())
#define _rygel_user_config_config_pair_unref0(var) ((var == NULL) ? NULL : (var = (rygel_user_config_config_pair_unref (var), NULL)))
typedef struct _RygelUserConfigParamSpecConfigPair RygelUserConfigParamSpecConfigPair;
typedef struct _RygelUserConfigParamSpecSectionPair RygelUserConfigParamSpecSectionPair;

typedef enum  {
	RYGEL_ENTRY_TYPE_STRING,
	RYGEL_ENTRY_TYPE_BOOL,
	RYGEL_ENTRY_TYPE_INT
} RygelEntryType;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
	GKeyFile* sys_key_file;
	GFileMonitor* key_file_monitor;
	GFileMonitor* sys_key_file_monitor;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()
typedef enum  {
	RYGEL_SECTION_ENTRY_TITLE,
	RYGEL_SECTION_ENTRY_ENABLED
} RygelSectionEntry;

struct _RygelUserConfigSectionPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelUserConfigSectionPairPrivate * priv;
	RygelSectionEntry entry;
	RygelEntryType type;
};

struct _RygelUserConfigSectionPairClass {
	GTypeClass parent_class;
	void (*finalize) (RygelUserConfigSectionPair *self);
};

typedef enum  {
	RYGEL_CONFIGURATION_ENTRY_UPNP_ENABLED,
	RYGEL_CONFIGURATION_ENTRY_INTERFACE,
	RYGEL_CONFIGURATION_ENTRY_PORT,
	RYGEL_CONFIGURATION_ENTRY_TRANSCODING,
	RYGEL_CONFIGURATION_ENTRY_ALLOW_UPLOAD,
	RYGEL_CONFIGURATION_ENTRY_ALLOW_DELETION,
	RYGEL_CONFIGURATION_ENTRY_LOG_LEVELS,
	RYGEL_CONFIGURATION_ENTRY_PLUGIN_PATH,
	RYGEL_CONFIGURATION_ENTRY_VIDEO_UPLOAD_FOLDER,
	RYGEL_CONFIGURATION_ENTRY_MUSIC_UPLOAD_FOLDER,
	RYGEL_CONFIGURATION_ENTRY_PICTURE_UPLOAD_FOLDER
} RygelConfigurationEntry;

struct _RygelUserConfigConfigPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelUserConfigConfigPairPrivate * priv;
	RygelConfigurationEntry entry;
	RygelEntryType type;
};

struct _RygelUserConfigConfigPairClass {
	GTypeClass parent_class;
	void (*finalize) (RygelUserConfigConfigPair *self);
};

struct _RygelUserConfigParamSpecConfigPair {
	GParamSpec parent_instance;
};

struct _RygelUserConfigParamSpecSectionPair {
	GParamSpec parent_instance;
};


static gpointer rygel_user_config_parent_class = NULL;
static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static GeeHashMap* rygel_user_config_config_keys;
static GeeHashMap* rygel_user_config_config_keys = NULL;
static GeeHashMap* rygel_user_config_section_keys;
static GeeHashMap* rygel_user_config_section_keys = NULL;
static gpointer rygel_user_config_config_pair_parent_class = NULL;
static gpointer rygel_user_config_section_pair_parent_class = NULL;
static RygelConfigurationIface* rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_entry_type_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_user_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_USER_CONFIG_DUMMY_PROPERTY
};
static gpointer rygel_user_config_config_pair_ref (gpointer instance);
static void rygel_user_config_config_pair_unref (gpointer instance);
static GParamSpec* rygel_user_config_param_spec_config_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void rygel_user_config_value_set_config_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void rygel_user_config_value_take_config_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer rygel_user_config_value_get_config_pair (const GValue* value) G_GNUC_UNUSED;
static GType rygel_user_config_config_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer rygel_user_config_section_pair_ref (gpointer instance);
static void rygel_user_config_section_pair_unref (gpointer instance);
static GParamSpec* rygel_user_config_param_spec_section_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void rygel_user_config_value_set_section_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void rygel_user_config_value_take_section_pair (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer rygel_user_config_value_get_section_pair (const GValue* value) G_GNUC_UNUSED;
static GType rygel_user_config_section_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_USER_CONFIG_GENERAL_SECTION "general"
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_UPNP_ENABLED_KEY "upnp-" RYGEL_USER_CONFIG_ENABLED_KEY
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY "allow-upload"
#define RYGEL_USER_CONFIG_ALLOW_DELETION_KEY "allow-deletion"
#define RYGEL_USER_CONFIG_LOG_LEVELS_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
#define RYGEL_USER_CONFIG_ENGINE_PATH_KEY "engine-path"
#define RYGEL_USER_CONFIG_MEDIA_ENGINE_KEY "media-engine"
#define RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY "upload-folder"
#define RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY "video-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY "music-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY "picture-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gchar** rygel_user_config_real_get_interfaces (RygelConfiguration* base, GError** error);
GeeArrayList* rygel_configuration_get_string_list (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_log_levels (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_engine_path (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_media_engine (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
RygelUserConfig* rygel_user_config_new (const gchar* local_path, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* local_path, GError** error);
static void rygel_user_config_initialize (RygelUserConfig* self, const gchar* local_path, const gchar* system_path, GError** error);
static void rygel_user_config_on_system_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _rygel_user_config_on_system_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_user_config_on_local_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _rygel_user_config_on_local_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
RygelUserConfig* rygel_user_config_new_with_paths (const gchar* local_path, const gchar* system_path, GError** error);
RygelUserConfig* rygel_user_config_construct_with_paths (GType object_type, const gchar* local_path, const gchar* system_path, GError** error);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_user_config_get_string_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
GQuark rygel_configuration_error_quark (void);
static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static GeeArrayList* rygel_user_config_get_string_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_user_config_get_int_from_keyfiles (const gchar* section, const gchar* key, gint min, gint max, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_user_config_get_int_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_user_config_get_bool_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_user_config_get_value_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error);
static GeeHashSet* rygel_user_config_get_sections (GKeyFile* key_file, GKeyFile* sys_key_file);
static GeeHashSet* rygel_user_config_get_keys (const gchar* section, GKeyFile* key_file, GKeyFile* sys_key_file);
static gboolean rygel_user_config_are_values_different (const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* new_key_file, GKeyFile* new_sys_key_file, RygelEntryType type);
static void rygel_user_config_emit_conditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* key_file, GKeyFile* sys_key_file, GeeHashMap* config_keys);
GType rygel_section_entry_get_type (void) G_GNUC_CONST;
GType rygel_configuration_entry_get_type (void) G_GNUC_CONST;
static void rygel_user_config_emit_unconditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GeeHashMap* config_keys);
static void rygel_user_config_compare_and_notify (RygelUserConfig* self, GKeyFile* key_file, GKeyFile* sys_key_file);
static void rygel_user_config_reload_compare_and_notify_system (RygelUserConfig* self, GFile* system);
static void rygel_user_config_reload_compare_and_notify_local (RygelUserConfig* self, GFile* local);
static RygelUserConfigConfigPair* rygel_user_config_config_pair_new (RygelConfigurationEntry entry, RygelEntryType type);
static RygelUserConfigConfigPair* rygel_user_config_config_pair_construct (GType object_type, RygelConfigurationEntry entry, RygelEntryType type);
static RygelUserConfigSectionPair* rygel_user_config_section_pair_new (RygelSectionEntry entry, RygelEntryType type);
static RygelUserConfigSectionPair* rygel_user_config_section_pair_construct (GType object_type, RygelSectionEntry entry, RygelEntryType type);
enum  {
	RYGEL_USER_CONFIG_CONFIG_PAIR_DUMMY_PROPERTY
};
static void rygel_user_config_config_pair_finalize (RygelUserConfigConfigPair* obj);
enum  {
	RYGEL_USER_CONFIG_SECTION_PAIR_DUMMY_PROPERTY
};
static void rygel_user_config_section_pair_finalize (RygelUserConfigSectionPair* obj);
static void rygel_user_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType rygel_entry_type_get_type (void) {
	static volatile gsize rygel_entry_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_entry_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_ENTRY_TYPE_STRING, "RYGEL_ENTRY_TYPE_STRING", "string"}, {RYGEL_ENTRY_TYPE_BOOL, "RYGEL_ENTRY_TYPE_BOOL", "bool"}, {RYGEL_ENTRY_TYPE_INT, "RYGEL_ENTRY_TYPE_INT", "int"}, {0, NULL, NULL}};
		GType rygel_entry_type_type_id;
		rygel_entry_type_type_id = g_enum_register_static ("RygelEntryType", values);
		g_once_init_leave (&rygel_entry_type_type_id__volatile, rygel_entry_type_type_id);
	}
	return rygel_entry_type_type_id__volatile;
}


static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_UPNP_ENABLED_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** rygel_user_config_real_get_interfaces (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar** result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	gchar** interfaces = NULL;
	GeeArrayList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gpointer* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint interfaces_length1 = 0;
	gint _interfaces_size_ = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string_list ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp4_ = gee_collection_to_array ((GeeCollection*) _tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_g_object_unref0 (_tmp2_);
	interfaces = _tmp5_;
	interfaces_length1 = _tmp5__length1;
	_interfaces_size_ = interfaces_length1;
	_tmp6_ = interfaces;
	_tmp6__length1 = interfaces_length1;
	if (_tmp6_ != NULL) {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		_tmp7_ = interfaces;
		_tmp7__length1 = interfaces_length1;
		_vala_array_add1 (&interfaces, &interfaces_length1, &_interfaces_size_, NULL);
	}
	result = interfaces;
	return result;
}


static gchar* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	guint16 _tmp1_ = 0U;
	guint16 _tmp2_ = 0U;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = 0U;
	_tmp2_ = G_MAXUINT16;
	_tmp3_ = rygel_configuration_get_int ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PORT_KEY, (gint) _tmp1_, (gint) _tmp2_, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_user_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_user_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_bool ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_log_levels (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_LOG_LEVELS_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_engine_path (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_ENGINE_PATH_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_media_engine (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_MEDIA_ENGINE_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, RYGEL_USER_CONFIG_GENERAL_SECTION, RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelUserConfig* rygel_user_config_get_default (GError** error) {
	RygelUserConfig* result = NULL;
	RygelUserConfig* _tmp0_ = NULL;
	RygelUserConfig* _tmp6_ = NULL;
	RygelUserConfig* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_user_config_config;
	if (_tmp0_ == NULL) {
		gchar* path = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		RygelUserConfig* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelUserConfig* _tmp5_ = NULL;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_build_filename (_tmp1_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
		path = _tmp2_;
		_tmp4_ = path;
		_tmp5_ = rygel_user_config_new (_tmp4_, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			return NULL;
		}
		_g_object_unref0 (rygel_user_config_config);
		rygel_user_config_config = _tmp3_;
		_g_free0 (path);
	}
	_tmp6_ = rygel_user_config_config;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static void _rygel_user_config_on_system_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_user_config_on_system_config_changed (self, _sender, file, other_file, event_type);
}


static void _rygel_user_config_on_local_config_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_user_config_on_local_config_changed (self, _sender, file, other_file, event_type);
}


static void rygel_user_config_initialize (RygelUserConfig* self, const gchar* local_path, const gchar* system_path, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	GKeyFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* sys_key_g_file = NULL;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFileMonitor* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFileMonitor* _tmp9_ = NULL;
	GFileMonitor* _tmp10_ = NULL;
	GFile* key_g_file = NULL;
	const gchar* _tmp19_ = NULL;
	GFile* _tmp20_ = NULL;
	GFileMonitor* _tmp21_ = NULL;
	GFile* _tmp22_ = NULL;
	GFileMonitor* _tmp23_ = NULL;
	GFileMonitor* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local_path != NULL);
	g_return_if_fail (system_path != NULL);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->key_file);
	self->key_file = _tmp0_;
	_tmp1_ = g_key_file_new ();
	_g_key_file_unref0 (self->sys_key_file);
	self->sys_key_file = _tmp1_;
	_tmp2_ = self->sys_key_file;
	_tmp3_ = system_path;
	g_key_file_load_from_file (_tmp2_, _tmp3_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = system_path;
	g_debug ("rygel-user-config.vala:234: Loaded system configuration from file '%s'", _tmp4_);
	_tmp5_ = system_path;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	sys_key_g_file = _tmp6_;
	_tmp8_ = sys_key_g_file;
	_tmp9_ = g_file_monitor_file (_tmp8_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
	_tmp7_ = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sys_key_g_file);
		return;
	}
	_g_object_unref0 (self->sys_key_file_monitor);
	self->sys_key_file_monitor = _tmp7_;
	_tmp10_ = self->sys_key_file_monitor;
	g_signal_connect_object (_tmp10_, "changed", (GCallback) _rygel_user_config_on_system_config_changed_g_file_monitor_changed, self, 0);
	{
		GKeyFile* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp11_ = self->key_file;
		_tmp12_ = local_path;
		g_key_file_load_from_file (_tmp11_, _tmp12_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp13_ = local_path;
		g_debug ("rygel-user-config.vala:249: Loaded user configuration from file '%s'", _tmp13_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GKeyFile* _tmp18_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = _ ("Failed to load user configuration from file '%s': %s");
		_tmp15_ = local_path;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_warning (_tmp14_, _tmp15_, _tmp17_);
		_tmp18_ = g_key_file_new ();
		_g_key_file_unref0 (self->key_file);
		self->key_file = _tmp18_;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (sys_key_g_file);
		return;
	}
	_tmp19_ = local_path;
	_tmp20_ = g_file_new_for_path (_tmp19_);
	key_g_file = _tmp20_;
	_tmp22_ = key_g_file;
	_tmp23_ = g_file_monitor_file (_tmp22_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
	_tmp21_ = _tmp23_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (key_g_file);
		_g_object_unref0 (sys_key_g_file);
		return;
	}
	_g_object_unref0 (self->key_file_monitor);
	self->key_file_monitor = _tmp21_;
	_tmp24_ = self->key_file_monitor;
	g_signal_connect_object (_tmp24_, "changed", (GCallback) _rygel_user_config_on_local_config_changed_g_file_monitor_changed, self, 0);
	_g_object_unref0 (key_g_file);
	_g_object_unref0 (sys_key_g_file);
}


RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* local_path, GError** error) {
	RygelUserConfig * self = NULL;
	gchar* system_path = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (local_path != NULL, NULL);
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
	_tmp0_ = g_build_filename (SYS_CONFIG_DIR, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
	system_path = _tmp0_;
	_tmp1_ = local_path;
	rygel_user_config_initialize (self, _tmp1_, system_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (system_path);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_free0 (system_path);
	return self;
}


RygelUserConfig* rygel_user_config_new (const gchar* local_path, GError** error) {
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, local_path, error);
}


RygelUserConfig* rygel_user_config_construct_with_paths (GType object_type, const gchar* local_path, const gchar* system_path, GError** error) {
	RygelUserConfig * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (local_path != NULL, NULL);
	g_return_val_if_fail (system_path != NULL, NULL);
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
	_tmp0_ = local_path;
	_tmp1_ = system_path;
	rygel_user_config_initialize (self, _tmp0_, _tmp1_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelUserConfig* rygel_user_config_new_with_paths (const gchar* local_path, const gchar* system_path, GError** error) {
	return rygel_user_config_construct_with_paths (RYGEL_TYPE_USER_CONFIG, local_path, system_path, error);
}


static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp1_ = section;
	_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) self, _tmp1_, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	_tmp1_ = section;
	_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) self, _tmp1_, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gchar* rygel_user_config_get_string_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gchar* result = NULL;
	gchar* val = NULL;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp1_ = key_file;
		_tmp2_ = section;
		_tmp3_ = key;
		_tmp4_ = g_key_file_get_string (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (val);
		val = _tmp0_;
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_ = NULL;
		gboolean _tmp8_ = FALSE;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _error_;
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp5_ = TRUE;
		} else {
			GError* _tmp7_ = NULL;
			_tmp7_ = _error_;
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			gchar* _tmp9_ = NULL;
			GKeyFile* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp10_ = sys_key_file;
			_tmp11_ = section;
			_tmp12_ = key;
			_tmp13_ = g_key_file_get_string (_tmp10_, _tmp11_, _tmp12_, &_inner_error_);
			_tmp9_ = _tmp13_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally1;
			}
			_g_free0 (val);
			val = _tmp9_;
		} else {
			GError* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			_tmp14_ = _error_;
			_tmp15_ = _g_error_copy0 (_tmp14_);
			_inner_error_ = _tmp15_;
			_g_error_free0 (_error_);
			goto __finally1;
		}
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	_tmp17_ = val;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = val;
		_tmp16_ = g_strcmp0 (_tmp18_, "") == 0;
	}
	_tmp19_ = _tmp16_;
	if (_tmp19_) {
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		_tmp20_ = _ ("No value available for '%s'");
		_tmp21_ = key;
		_tmp22_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp20_, _tmp21_);
		_inner_error_ = _tmp22_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static gchar* rygel_user_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = section;
	_tmp2_ = key;
	_tmp3_ = self->key_file;
	_tmp4_ = self->sys_key_file;
	_tmp5_ = rygel_user_config_get_string_from_keyfiles (_tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static GeeArrayList* rygel_user_config_get_string_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* str_list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gchar** strings = NULL;
	gint strings_length1 = 0;
	gint _strings_size_ = 0;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	str_list = _tmp0_;
	{
		gchar** _tmp1_ = NULL;
		GKeyFile* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gsize _tmp5_;
		gchar** _tmp6_ = NULL;
		gint _tmp1__length1 = 0;
		gint __tmp1__size_ = 0;
		_tmp2_ = key_file;
		_tmp3_ = section;
		_tmp4_ = key;
		_tmp6_ = g_key_file_get_string_list (_tmp2_, _tmp3_, _tmp4_, &_tmp5_, &_inner_error_);
		_tmp1_ = _tmp6_;
		_tmp1__length1 = _tmp5_;
		__tmp1__size_ = _tmp1__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (str_list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		strings = _tmp1_;
		strings_length1 = _tmp1__length1;
		_strings_size_ = strings_length1;
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp7_ = FALSE;
		GError* _tmp8_ = NULL;
		gboolean _tmp10_ = FALSE;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _error_;
		if (g_error_matches (_tmp8_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp7_ = TRUE;
		} else {
			GError* _tmp9_ = NULL;
			_tmp9_ = _error_;
			_tmp7_ = g_error_matches (_tmp9_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			gchar** _tmp11_ = NULL;
			GKeyFile* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gsize _tmp15_;
			gchar** _tmp16_ = NULL;
			gint _tmp11__length1 = 0;
			gint __tmp11__size_ = 0;
			_tmp12_ = sys_key_file;
			_tmp13_ = section;
			_tmp14_ = key;
			_tmp16_ = g_key_file_get_string_list (_tmp12_, _tmp13_, _tmp14_, &_tmp15_, &_inner_error_);
			_tmp11_ = _tmp16_;
			_tmp11__length1 = _tmp15_;
			__tmp11__size_ = _tmp11__length1;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally2;
			}
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			strings = _tmp11_;
			strings_length1 = _tmp11__length1;
			_strings_size_ = strings_length1;
		} else {
			GError* _tmp17_ = NULL;
			GError* _tmp18_ = NULL;
			_tmp17_ = _error_;
			_tmp18_ = _g_error_copy0 (_tmp17_);
			_inner_error_ = _tmp18_;
			_g_error_free0 (_error_);
			goto __finally2;
		}
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (str_list);
		return NULL;
	}
	_tmp19_ = strings;
	_tmp19__length1 = strings_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp19_;
		str_collection_length1 = _tmp19__length1;
		for (str_it = 0; str_it < _tmp19__length1; str_it = str_it + 1) {
			gchar* _tmp20_ = NULL;
			gchar* str = NULL;
			_tmp20_ = g_strdup (str_collection[str_it]);
			str = _tmp20_;
			{
				GeeArrayList* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				_tmp21_ = str_list;
				_tmp22_ = str;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
				_g_free0 (str);
			}
		}
	}
	result = str_list;
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = section;
	_tmp2_ = key;
	_tmp3_ = self->key_file;
	_tmp4_ = self->sys_key_file;
	_tmp5_ = rygel_user_config_get_string_list_from_keyfiles (_tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gint rygel_user_config_get_int_from_keyfiles (const gchar* section, const gchar* key, gint min, gint max, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gint result = 0;
	gint val = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gboolean _tmp21_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	g_return_val_if_fail (key_file != NULL, 0);
	g_return_val_if_fail (sys_key_file != NULL, 0);
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp1_ = key_file;
		_tmp2_ = section;
		_tmp3_ = key;
		_tmp4_ = g_key_file_get_integer (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		val = _tmp0_;
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_ = NULL;
		gboolean _tmp8_ = FALSE;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _error_;
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp5_ = TRUE;
		} else {
			GError* _tmp7_ = NULL;
			_tmp7_ = _error_;
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			gint _tmp9_ = 0;
			GKeyFile* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			_tmp10_ = sys_key_file;
			_tmp11_ = section;
			_tmp12_ = key;
			_tmp13_ = g_key_file_get_integer (_tmp10_, _tmp11_, _tmp12_, &_inner_error_);
			_tmp9_ = _tmp13_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally3;
			}
			val = _tmp9_;
		} else {
			GError* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			_tmp14_ = _error_;
			_tmp15_ = _g_error_copy0 (_tmp14_);
			_inner_error_ = _tmp15_;
			_g_error_free0 (_error_);
			goto __finally3;
		}
		_g_error_free0 (_error_);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp17_ = val;
	_tmp18_ = min;
	if (_tmp17_ < _tmp18_) {
		_tmp16_ = TRUE;
	} else {
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		_tmp19_ = val;
		_tmp20_ = max;
		_tmp16_ = _tmp19_ > _tmp20_;
	}
	_tmp21_ = _tmp16_;
	if (_tmp21_) {
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		_tmp22_ = _ ("Value of '%s' out of range");
		_tmp23_ = key;
		_tmp24_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _tmp22_, _tmp23_);
		_inner_error_ = _tmp24_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = val;
	return result;
}


static gint rygel_user_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelUserConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GKeyFile* _tmp5_ = NULL;
	GKeyFile* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp1_ = section;
	_tmp2_ = key;
	_tmp3_ = min;
	_tmp4_ = max;
	_tmp5_ = self->key_file;
	_tmp6_ = self->sys_key_file;
	_tmp7_ = rygel_user_config_get_int_from_keyfiles (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
	_tmp0_ = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp0_;
	return result;
}


static GeeArrayList* rygel_user_config_get_int_list_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* int_list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint* ints = NULL;
	gint ints_length1 = 0;
	gint _ints_size_ = 0;
	gint* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	int_list = _tmp0_;
	{
		gint* _tmp1_ = NULL;
		GKeyFile* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gsize _tmp5_;
		gint* _tmp6_ = NULL;
		gint _tmp1__length1 = 0;
		gint __tmp1__size_ = 0;
		_tmp2_ = key_file;
		_tmp3_ = section;
		_tmp4_ = key;
		_tmp6_ = g_key_file_get_integer_list (_tmp2_, _tmp3_, _tmp4_, &_tmp5_, &_inner_error_);
		_tmp1_ = _tmp6_;
		_tmp1__length1 = _tmp5_;
		__tmp1__size_ = _tmp1__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch4_g_key_file_error;
			}
			ints = (g_free (ints), NULL);
			_g_object_unref0 (int_list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		ints = (g_free (ints), NULL);
		ints = _tmp1_;
		ints_length1 = _tmp1__length1;
		_ints_size_ = ints_length1;
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp7_ = FALSE;
		GError* _tmp8_ = NULL;
		gboolean _tmp10_ = FALSE;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _error_;
		if (g_error_matches (_tmp8_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp7_ = TRUE;
		} else {
			GError* _tmp9_ = NULL;
			_tmp9_ = _error_;
			_tmp7_ = g_error_matches (_tmp9_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			gint* _tmp11_ = NULL;
			GKeyFile* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gsize _tmp15_;
			gint* _tmp16_ = NULL;
			gint _tmp11__length1 = 0;
			gint __tmp11__size_ = 0;
			_tmp12_ = sys_key_file;
			_tmp13_ = section;
			_tmp14_ = key;
			_tmp16_ = g_key_file_get_integer_list (_tmp12_, _tmp13_, _tmp14_, &_tmp15_, &_inner_error_);
			_tmp11_ = _tmp16_;
			_tmp11__length1 = _tmp15_;
			__tmp11__size_ = _tmp11__length1;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally4;
			}
			ints = (g_free (ints), NULL);
			ints = _tmp11_;
			ints_length1 = _tmp11__length1;
			_ints_size_ = ints_length1;
		} else {
			GError* _tmp17_ = NULL;
			GError* _tmp18_ = NULL;
			_tmp17_ = _error_;
			_tmp18_ = _g_error_copy0 (_tmp17_);
			_inner_error_ = _tmp18_;
			_g_error_free0 (_error_);
			goto __finally4;
		}
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		ints = (g_free (ints), NULL);
		_g_object_unref0 (int_list);
		return NULL;
	}
	_tmp19_ = ints;
	_tmp19__length1 = ints_length1;
	{
		gint* num_collection = NULL;
		gint num_collection_length1 = 0;
		gint _num_collection_size_ = 0;
		gint num_it = 0;
		num_collection = _tmp19_;
		num_collection_length1 = _tmp19__length1;
		for (num_it = 0; num_it < _tmp19__length1; num_it = num_it + 1) {
			gint num = 0;
			num = num_collection[num_it];
			{
				GeeArrayList* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				_tmp20_ = int_list;
				_tmp21_ = num;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (gpointer) ((gintptr) _tmp21_));
			}
		}
	}
	result = int_list;
	ints = (g_free (ints), NULL);
	return result;
}


static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = section;
	_tmp2_ = key;
	_tmp3_ = self->key_file;
	_tmp4_ = self->sys_key_file;
	_tmp5_ = rygel_user_config_get_int_list_from_keyfiles (_tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_user_config_get_bool_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (key_file != NULL, FALSE);
	g_return_val_if_fail (sys_key_file != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp1_ = key_file;
		_tmp2_ = section;
		_tmp3_ = key;
		_tmp4_ = g_key_file_get_boolean (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch5_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		val = _tmp0_;
	}
	goto __finally5;
	__catch5_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_ = NULL;
		gboolean _tmp8_ = FALSE;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _error_;
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp5_ = TRUE;
		} else {
			GError* _tmp7_ = NULL;
			_tmp7_ = _error_;
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			gboolean _tmp9_ = FALSE;
			GKeyFile* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp10_ = sys_key_file;
			_tmp11_ = section;
			_tmp12_ = key;
			_tmp13_ = g_key_file_get_boolean (_tmp10_, _tmp11_, _tmp12_, &_inner_error_);
			_tmp9_ = _tmp13_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally5;
			}
			val = _tmp9_;
		} else {
			GError* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			_tmp14_ = _error_;
			_tmp15_ = _g_error_copy0 (_tmp14_);
			_inner_error_ = _tmp15_;
			_g_error_free0 (_error_);
			goto __finally5;
		}
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelUserConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelUserConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = section;
	_tmp2_ = key;
	_tmp3_ = self->key_file;
	_tmp4_ = self->sys_key_file;
	_tmp5_ = rygel_user_config_get_bool_from_keyfiles (_tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
	_tmp0_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar* rygel_user_config_get_value_from_keyfiles (const gchar* section, const gchar* key, GKeyFile* key_file, GKeyFile* sys_key_file, GError** error) {
	gchar* result = NULL;
	gchar* val = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp1_ = key_file;
		_tmp2_ = section;
		_tmp3_ = key;
		_tmp4_ = g_key_file_get_value (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch6_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (val);
		val = _tmp0_;
	}
	goto __finally6;
	__catch6_g_key_file_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_ = NULL;
		gboolean _tmp8_ = FALSE;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _error_;
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp5_ = TRUE;
		} else {
			GError* _tmp7_ = NULL;
			_tmp7_ = _error_;
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			gchar* _tmp9_ = NULL;
			GKeyFile* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp10_ = sys_key_file;
			_tmp11_ = section;
			_tmp12_ = key;
			_tmp13_ = g_key_file_get_value (_tmp10_, _tmp11_, _tmp12_, &_inner_error_);
			_tmp9_ = _tmp13_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally6;
			}
			_g_free0 (val);
			val = _tmp9_;
		} else {
			GError* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			_tmp14_ = _error_;
			_tmp15_ = _g_error_copy0 (_tmp14_);
			_inner_error_ = _tmp15_;
			_g_error_free0 (_error_);
			goto __finally6;
		}
		_g_error_free0 (_error_);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static GeeHashSet* rygel_user_config_get_sections (GKeyFile* key_file, GKeyFile* sys_key_file) {
	GeeHashSet* result = NULL;
	GeeHashSet* sections = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	gsize _tmp2_;
	gchar** _tmp3_ = NULL;
	GKeyFile* _tmp7_ = NULL;
	gsize _tmp8_;
	gchar** _tmp9_ = NULL;
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	sections = _tmp0_;
	_tmp1_ = key_file;
	_tmp3_ = g_key_file_get_groups (_tmp1_, &_tmp2_);
	{
		gchar** section_collection = NULL;
		gint section_collection_length1 = 0;
		gint _section_collection_size_ = 0;
		gint section_it = 0;
		section_collection = _tmp3_;
		section_collection_length1 = _tmp2_;
		for (section_it = 0; section_it < _tmp2_; section_it = section_it + 1) {
			gchar* _tmp4_ = NULL;
			gchar* section = NULL;
			_tmp4_ = g_strdup (section_collection[section_it]);
			section = _tmp4_;
			{
				GeeHashSet* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				_tmp5_ = sections;
				_tmp6_ = section;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
				_g_free0 (section);
			}
		}
		section_collection = (_vala_array_free (section_collection, section_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = sys_key_file;
	_tmp9_ = g_key_file_get_groups (_tmp7_, &_tmp8_);
	{
		gchar** section_collection = NULL;
		gint section_collection_length1 = 0;
		gint _section_collection_size_ = 0;
		gint section_it = 0;
		section_collection = _tmp9_;
		section_collection_length1 = _tmp8_;
		for (section_it = 0; section_it < _tmp8_; section_it = section_it + 1) {
			gchar* _tmp10_ = NULL;
			gchar* section = NULL;
			_tmp10_ = g_strdup (section_collection[section_it]);
			section = _tmp10_;
			{
				GeeHashSet* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				_tmp11_ = sections;
				_tmp12_ = section;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
				_g_free0 (section);
			}
		}
		section_collection = (_vala_array_free (section_collection, section_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = sections;
	return result;
}


static GeeHashSet* rygel_user_config_get_keys (const gchar* section, GKeyFile* key_file, GKeyFile* sys_key_file) {
	GeeHashSet* result = NULL;
	GeeHashSet* keys = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (sys_key_file != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	keys = _tmp0_;
	{
		gchar** _tmp1_ = NULL;
		GKeyFile* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gsize _tmp4_;
		gchar** _tmp5_ = NULL;
		gint _tmp1__length1 = 0;
		gint __tmp1__size_ = 0;
		_tmp2_ = key_file;
		_tmp3_ = section;
		_tmp5_ = g_key_file_get_keys (_tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
		_tmp1_ = _tmp5_;
		_tmp1__length1 = _tmp4_;
		__tmp1__size_ = _tmp1__length1;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp1_;
			key_collection_length1 = _tmp1__length1;
			for (key_it = 0; key_it < _tmp1__length1; key_it = key_it + 1) {
				gchar* _tmp6_ = NULL;
				gchar* key = NULL;
				_tmp6_ = g_strdup (key_collection[key_it]);
				key = _tmp6_;
				{
					const gchar* _tmp7_ = NULL;
					_tmp7_ = key;
					gee_abstract_collection_add ((GeeAbstractCollection*) keys, _tmp7_);
					_g_free0 (key);
				}
			}
			key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (keys);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar** _tmp8_ = NULL;
		GKeyFile* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gsize _tmp11_;
		gchar** _tmp12_ = NULL;
		gint _tmp8__length1 = 0;
		gint __tmp8__size_ = 0;
		_tmp9_ = sys_key_file;
		_tmp10_ = section;
		_tmp12_ = g_key_file_get_keys (_tmp9_, _tmp10_, &_tmp11_, &_inner_error_);
		_tmp8_ = _tmp12_;
		_tmp8__length1 = _tmp11_;
		__tmp8__size_ = _tmp8__length1;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp8_;
			key_collection_length1 = _tmp8__length1;
			for (key_it = 0; key_it < _tmp8__length1; key_it = key_it + 1) {
				gchar* _tmp13_ = NULL;
				gchar* key = NULL;
				_tmp13_ = g_strdup (key_collection[key_it]);
				key = _tmp13_;
				{
					const gchar* _tmp14_ = NULL;
					_tmp14_ = key;
					gee_abstract_collection_add ((GeeAbstractCollection*) keys, _tmp14_);
					_g_free0 (key);
				}
			}
			key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (keys);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = keys;
	return result;
}


static gboolean rygel_user_config_are_values_different (const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* new_key_file, GKeyFile* new_sys_key_file, RygelEntryType type) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (old_key_file != NULL, FALSE);
	g_return_val_if_fail (old_sys_key_file != NULL, FALSE);
	g_return_val_if_fail (new_key_file != NULL, FALSE);
	g_return_val_if_fail (new_sys_key_file != NULL, FALSE);
	{
		RygelEntryType _tmp0_ = 0;
		_tmp0_ = type;
		switch (_tmp0_) {
			case RYGEL_ENTRY_TYPE_STRING:
			{
				gchar* old_value = NULL;
				const gchar* _tmp1_ = NULL;
				const gchar* _tmp2_ = NULL;
				GKeyFile* _tmp3_ = NULL;
				GKeyFile* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* new_value = NULL;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				GKeyFile* _tmp8_ = NULL;
				GKeyFile* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				_tmp1_ = section;
				_tmp2_ = key;
				_tmp3_ = old_key_file;
				_tmp4_ = old_sys_key_file;
				_tmp5_ = rygel_user_config_get_string_from_keyfiles (_tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
				old_value = _tmp5_;
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				_tmp6_ = section;
				_tmp7_ = key;
				_tmp8_ = new_key_file;
				_tmp9_ = new_sys_key_file;
				_tmp10_ = rygel_user_config_get_string_from_keyfiles (_tmp6_, _tmp7_, _tmp8_, _tmp9_, &_inner_error_);
				new_value = _tmp10_;
				if (_inner_error_ != NULL) {
					_g_free0 (old_value);
					goto __catch9_g_error;
				}
				_tmp11_ = old_value;
				_tmp12_ = new_value;
				result = g_strcmp0 (_tmp11_, _tmp12_) != 0;
				_g_free0 (new_value);
				_g_free0 (old_value);
				return result;
			}
			case RYGEL_ENTRY_TYPE_BOOL:
			{
				gboolean old_value = FALSE;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GKeyFile* _tmp15_ = NULL;
				GKeyFile* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				gboolean new_value = FALSE;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				GKeyFile* _tmp20_ = NULL;
				GKeyFile* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				_tmp13_ = section;
				_tmp14_ = key;
				_tmp15_ = old_key_file;
				_tmp16_ = old_sys_key_file;
				_tmp17_ = rygel_user_config_get_bool_from_keyfiles (_tmp13_, _tmp14_, _tmp15_, _tmp16_, &_inner_error_);
				old_value = _tmp17_;
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				_tmp18_ = section;
				_tmp19_ = key;
				_tmp20_ = new_key_file;
				_tmp21_ = new_sys_key_file;
				_tmp22_ = rygel_user_config_get_bool_from_keyfiles (_tmp18_, _tmp19_, _tmp20_, _tmp21_, &_inner_error_);
				new_value = _tmp22_;
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				_tmp23_ = old_value;
				_tmp24_ = new_value;
				result = _tmp23_ != _tmp24_;
				return result;
			}
			case RYGEL_ENTRY_TYPE_INT:
			{
				gint old_value = 0;
				const gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				GKeyFile* _tmp29_ = NULL;
				GKeyFile* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint new_value = 0;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				GKeyFile* _tmp36_ = NULL;
				GKeyFile* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				_tmp25_ = section;
				_tmp26_ = key;
				_tmp27_ = G_MININT;
				_tmp28_ = G_MAXINT;
				_tmp29_ = old_key_file;
				_tmp30_ = old_sys_key_file;
				_tmp31_ = rygel_user_config_get_int_from_keyfiles (_tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, &_inner_error_);
				old_value = _tmp31_;
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				_tmp32_ = section;
				_tmp33_ = key;
				_tmp34_ = G_MININT;
				_tmp35_ = G_MAXINT;
				_tmp36_ = new_key_file;
				_tmp37_ = new_sys_key_file;
				_tmp38_ = rygel_user_config_get_int_from_keyfiles (_tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_, &_inner_error_);
				new_value = _tmp38_;
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
				_tmp39_ = old_value;
				_tmp40_ = new_value;
				result = _tmp39_ != _tmp40_;
				return result;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = TRUE;
		_g_error_free0 (e);
		return result;
	}
	__finally9:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static void rygel_user_config_emit_conditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GKeyFile* old_key_file, GKeyFile* old_sys_key_file, GKeyFile* key_file, GKeyFile* sys_key_file, GeeHashMap* config_keys) {
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (old_key_file != NULL);
	g_return_if_fail (old_sys_key_file != NULL);
	g_return_if_fail (key_file != NULL);
	g_return_if_fail (sys_key_file != NULL);
	g_return_if_fail (config_keys != NULL);
	_tmp0_ = rygel_user_config_section_keys;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		RygelUserConfigSectionPair* pair = NULL;
		GeeHashMap* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gboolean emit = FALSE;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GKeyFile* _tmp8_ = NULL;
		GKeyFile* _tmp9_ = NULL;
		GKeyFile* _tmp10_ = NULL;
		GKeyFile* _tmp11_ = NULL;
		RygelUserConfigSectionPair* _tmp12_ = NULL;
		RygelEntryType _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp3_ = rygel_user_config_section_keys;
		_tmp4_ = key;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		pair = (RygelUserConfigSectionPair*) _tmp5_;
		_tmp6_ = section;
		_tmp7_ = key;
		_tmp8_ = old_key_file;
		_tmp9_ = old_sys_key_file;
		_tmp10_ = key_file;
		_tmp11_ = sys_key_file;
		_tmp12_ = pair;
		_tmp13_ = _tmp12_->type;
		_tmp14_ = rygel_user_config_are_values_different (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp13_);
		emit = _tmp14_;
		_tmp15_ = emit;
		if (_tmp15_) {
			const gchar* _tmp16_ = NULL;
			RygelUserConfigSectionPair* _tmp17_ = NULL;
			RygelSectionEntry _tmp18_ = 0;
			_tmp16_ = section;
			_tmp17_ = pair;
			_tmp18_ = _tmp17_->entry;
			g_signal_emit_by_name ((RygelConfiguration*) self, "section-changed", _tmp16_, _tmp18_);
		}
		_rygel_user_config_section_pair_unref0 (pair);
	} else {
		GeeHashMap* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = config_keys;
		_tmp20_ = key;
		_tmp21_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp19_, _tmp20_);
		if (_tmp21_) {
			RygelUserConfigConfigPair* pair = NULL;
			GeeHashMap* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gpointer _tmp24_ = NULL;
			gboolean emit = FALSE;
			const gchar* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			GKeyFile* _tmp27_ = NULL;
			GKeyFile* _tmp28_ = NULL;
			GKeyFile* _tmp29_ = NULL;
			GKeyFile* _tmp30_ = NULL;
			RygelUserConfigConfigPair* _tmp31_ = NULL;
			RygelEntryType _tmp32_ = 0;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_ = FALSE;
			_tmp22_ = config_keys;
			_tmp23_ = key;
			_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
			pair = (RygelUserConfigConfigPair*) _tmp24_;
			_tmp25_ = section;
			_tmp26_ = key;
			_tmp27_ = old_key_file;
			_tmp28_ = old_sys_key_file;
			_tmp29_ = key_file;
			_tmp30_ = sys_key_file;
			_tmp31_ = pair;
			_tmp32_ = _tmp31_->type;
			_tmp33_ = rygel_user_config_are_values_different (_tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp32_);
			emit = _tmp33_;
			_tmp34_ = emit;
			if (_tmp34_) {
				RygelUserConfigConfigPair* _tmp35_ = NULL;
				RygelConfigurationEntry _tmp36_ = 0;
				_tmp35_ = pair;
				_tmp36_ = _tmp35_->entry;
				g_signal_emit_by_name ((RygelConfiguration*) self, "configuration-changed", _tmp36_);
			}
			_rygel_user_config_config_pair_unref0 (pair);
		} else {
			gboolean emit = FALSE;
			gboolean _tmp49_ = FALSE;
			emit = FALSE;
			{
				gchar* old_value = NULL;
				const gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				GKeyFile* _tmp39_ = NULL;
				GKeyFile* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* new_value = NULL;
				const gchar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				GKeyFile* _tmp44_ = NULL;
				GKeyFile* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				_tmp37_ = section;
				_tmp38_ = key;
				_tmp39_ = old_key_file;
				_tmp40_ = old_sys_key_file;
				_tmp41_ = rygel_user_config_get_value_from_keyfiles (_tmp37_, _tmp38_, _tmp39_, _tmp40_, &_inner_error_);
				old_value = _tmp41_;
				if (_inner_error_ != NULL) {
					goto __catch10_g_error;
				}
				_tmp42_ = section;
				_tmp43_ = key;
				_tmp44_ = key_file;
				_tmp45_ = sys_key_file;
				_tmp46_ = rygel_user_config_get_value_from_keyfiles (_tmp42_, _tmp43_, _tmp44_, _tmp45_, &_inner_error_);
				new_value = _tmp46_;
				if (_inner_error_ != NULL) {
					_g_free0 (old_value);
					goto __catch10_g_error;
				}
				_tmp47_ = old_value;
				_tmp48_ = new_value;
				emit = g_strcmp0 (_tmp47_, _tmp48_) != 0;
				_g_free0 (new_value);
				_g_free0 (old_value);
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				emit = TRUE;
				_g_error_free0 (e);
			}
			__finally10:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp49_ = emit;
			if (_tmp49_) {
				const gchar* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				_tmp50_ = section;
				_tmp51_ = key;
				g_signal_emit_by_name ((RygelConfiguration*) self, "setting-changed", _tmp50_, _tmp51_);
			}
		}
	}
}


static void rygel_user_config_emit_unconditionally (RygelUserConfig* self, const gchar* section, const gchar* key, GeeHashMap* config_keys) {
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (config_keys != NULL);
	_tmp0_ = rygel_user_config_section_keys;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		RygelUserConfigSectionPair* pair = NULL;
		GeeHashMap* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelUserConfigSectionPair* _tmp7_ = NULL;
		RygelSectionEntry _tmp8_ = 0;
		_tmp3_ = rygel_user_config_section_keys;
		_tmp4_ = key;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		pair = (RygelUserConfigSectionPair*) _tmp5_;
		_tmp6_ = section;
		_tmp7_ = pair;
		_tmp8_ = _tmp7_->entry;
		g_signal_emit_by_name ((RygelConfiguration*) self, "section-changed", _tmp6_, _tmp8_);
		_rygel_user_config_section_pair_unref0 (pair);
	} else {
		GeeHashMap* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = config_keys;
		_tmp10_ = key;
		_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp10_);
		if (_tmp11_) {
			RygelUserConfigConfigPair* pair = NULL;
			GeeHashMap* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			RygelUserConfigConfigPair* _tmp15_ = NULL;
			RygelConfigurationEntry _tmp16_ = 0;
			_tmp12_ = config_keys;
			_tmp13_ = key;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
			pair = (RygelUserConfigConfigPair*) _tmp14_;
			_tmp15_ = pair;
			_tmp16_ = _tmp15_->entry;
			g_signal_emit_by_name ((RygelConfiguration*) self, "configuration-changed", _tmp16_);
			_rygel_user_config_config_pair_unref0 (pair);
		} else {
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			_tmp17_ = section;
			_tmp18_ = key;
			g_signal_emit_by_name ((RygelConfiguration*) self, "setting-changed", _tmp17_, _tmp18_);
		}
	}
}


static gpointer _g_key_file_ref0 (gpointer self) {
	return self ? g_key_file_ref (self) : NULL;
}


static void rygel_user_config_compare_and_notify (RygelUserConfig* self, GKeyFile* key_file, GKeyFile* sys_key_file) {
	GKeyFile* old_key_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	GKeyFile* old_sys_key_file = NULL;
	GKeyFile* _tmp2_ = NULL;
	GKeyFile* _tmp3_ = NULL;
	GeeHashSet* old_sections = NULL;
	GKeyFile* _tmp4_ = NULL;
	GKeyFile* _tmp5_ = NULL;
	GeeHashSet* _tmp6_ = NULL;
	GeeHashSet* new_sections = NULL;
	GKeyFile* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	GeeHashSet* _tmp9_ = NULL;
	GKeyFile* _tmp10_ = NULL;
	GKeyFile* _tmp11_ = NULL;
	GKeyFile* _tmp12_ = NULL;
	GKeyFile* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_file != NULL);
	g_return_if_fail (sys_key_file != NULL);
	_tmp0_ = self->key_file;
	_tmp1_ = _g_key_file_ref0 (_tmp0_);
	old_key_file = _tmp1_;
	_tmp2_ = self->sys_key_file;
	_tmp3_ = _g_key_file_ref0 (_tmp2_);
	old_sys_key_file = _tmp3_;
	_tmp4_ = old_key_file;
	_tmp5_ = old_sys_key_file;
	_tmp6_ = rygel_user_config_get_sections (_tmp4_, _tmp5_);
	old_sections = _tmp6_;
	_tmp7_ = key_file;
	_tmp8_ = sys_key_file;
	_tmp9_ = rygel_user_config_get_sections (_tmp7_, _tmp8_);
	new_sections = _tmp9_;
	_tmp10_ = key_file;
	_tmp11_ = _g_key_file_ref0 (_tmp10_);
	_g_key_file_unref0 (self->key_file);
	self->key_file = _tmp11_;
	_tmp12_ = sys_key_file;
	_tmp13_ = _g_key_file_ref0 (_tmp12_);
	_g_key_file_unref0 (self->sys_key_file);
	self->sys_key_file = _tmp13_;
	{
		GeeIterator* _section_it = NULL;
		GeeHashSet* _tmp14_ = NULL;
		GeeIterator* _tmp15_ = NULL;
		_tmp14_ = old_sections;
		_tmp15_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp14_);
		_section_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			gchar* section = NULL;
			GeeIterator* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			GeeHashSet* old_keys = NULL;
			const gchar* _tmp20_ = NULL;
			GKeyFile* _tmp21_ = NULL;
			GKeyFile* _tmp22_ = NULL;
			GeeHashSet* _tmp23_ = NULL;
			GeeHashMap* _tmp24_ = NULL;
			GeeHashMap* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			GeeHashMap* config_keys = NULL;
			GeeHashMap* _tmp32_ = NULL;
			GeeHashMap* _tmp33_ = NULL;
			GeeHashSet* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
			_tmp16_ = _section_it;
			_tmp17_ = gee_iterator_next (_tmp16_);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = _section_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			section = (gchar*) _tmp19_;
			_tmp20_ = section;
			_tmp21_ = old_key_file;
			_tmp22_ = old_sys_key_file;
			_tmp23_ = rygel_user_config_get_keys (_tmp20_, _tmp21_, _tmp22_);
			old_keys = _tmp23_;
			_tmp25_ = rygel_user_config_config_keys;
			_tmp26_ = section;
			_tmp27_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp25_, _tmp26_);
			if (_tmp27_) {
				GeeHashMap* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gpointer _tmp30_ = NULL;
				_tmp28_ = rygel_user_config_config_keys;
				_tmp29_ = section;
				_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp28_, _tmp29_);
				_g_object_unref0 (_tmp24_);
				_tmp24_ = (GeeHashMap*) _tmp30_;
			} else {
				GeeHashMap* _tmp31_ = NULL;
				_tmp31_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, rygel_user_config_config_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp24_);
				_tmp24_ = _tmp31_;
			}
			_tmp32_ = _tmp24_;
			_tmp33_ = _g_object_ref0 (_tmp32_);
			config_keys = _tmp33_;
			_tmp34_ = new_sections;
			_tmp35_ = section;
			_tmp36_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp34_, _tmp35_);
			if (_tmp36_) {
				GeeHashSet* new_keys = NULL;
				const gchar* _tmp37_ = NULL;
				GKeyFile* _tmp38_ = NULL;
				GKeyFile* _tmp39_ = NULL;
				GeeHashSet* _tmp40_ = NULL;
				_tmp37_ = section;
				_tmp38_ = key_file;
				_tmp39_ = sys_key_file;
				_tmp40_ = rygel_user_config_get_keys (_tmp37_, _tmp38_, _tmp39_);
				new_keys = _tmp40_;
				{
					GeeIterator* _key_it = NULL;
					GeeHashSet* _tmp41_ = NULL;
					GeeIterator* _tmp42_ = NULL;
					_tmp41_ = old_keys;
					_tmp42_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp41_);
					_key_it = _tmp42_;
					while (TRUE) {
						GeeIterator* _tmp43_ = NULL;
						gboolean _tmp44_ = FALSE;
						gchar* key = NULL;
						GeeIterator* _tmp45_ = NULL;
						gpointer _tmp46_ = NULL;
						GeeHashSet* _tmp47_ = NULL;
						const gchar* _tmp48_ = NULL;
						gboolean _tmp49_ = FALSE;
						_tmp43_ = _key_it;
						_tmp44_ = gee_iterator_next (_tmp43_);
						if (!_tmp44_) {
							break;
						}
						_tmp45_ = _key_it;
						_tmp46_ = gee_iterator_get (_tmp45_);
						key = (gchar*) _tmp46_;
						_tmp47_ = new_keys;
						_tmp48_ = key;
						_tmp49_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp47_, _tmp48_);
						if (_tmp49_) {
							const gchar* _tmp50_ = NULL;
							const gchar* _tmp51_ = NULL;
							GKeyFile* _tmp52_ = NULL;
							GKeyFile* _tmp53_ = NULL;
							GKeyFile* _tmp54_ = NULL;
							GKeyFile* _tmp55_ = NULL;
							GeeHashMap* _tmp56_ = NULL;
							_tmp50_ = section;
							_tmp51_ = key;
							_tmp52_ = old_key_file;
							_tmp53_ = old_sys_key_file;
							_tmp54_ = key_file;
							_tmp55_ = sys_key_file;
							_tmp56_ = config_keys;
							rygel_user_config_emit_conditionally (self, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
						} else {
							const gchar* _tmp57_ = NULL;
							const gchar* _tmp58_ = NULL;
							GeeHashMap* _tmp59_ = NULL;
							_tmp57_ = section;
							_tmp58_ = key;
							_tmp59_ = config_keys;
							rygel_user_config_emit_unconditionally (self, _tmp57_, _tmp58_, _tmp59_);
						}
						_g_free0 (key);
					}
					_g_object_unref0 (_key_it);
				}
				{
					GeeIterator* _key_it = NULL;
					GeeHashSet* _tmp60_ = NULL;
					GeeIterator* _tmp61_ = NULL;
					_tmp60_ = new_keys;
					_tmp61_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp60_);
					_key_it = _tmp61_;
					while (TRUE) {
						GeeIterator* _tmp62_ = NULL;
						gboolean _tmp63_ = FALSE;
						gchar* key = NULL;
						GeeIterator* _tmp64_ = NULL;
						gpointer _tmp65_ = NULL;
						const gchar* _tmp66_ = NULL;
						const gchar* _tmp67_ = NULL;
						GeeHashMap* _tmp68_ = NULL;
						_tmp62_ = _key_it;
						_tmp63_ = gee_iterator_next (_tmp62_);
						if (!_tmp63_) {
							break;
						}
						_tmp64_ = _key_it;
						_tmp65_ = gee_iterator_get (_tmp64_);
						key = (gchar*) _tmp65_;
						_tmp66_ = section;
						_tmp67_ = key;
						_tmp68_ = config_keys;
						rygel_user_config_emit_unconditionally (self, _tmp66_, _tmp67_, _tmp68_);
						_g_free0 (key);
					}
					_g_object_unref0 (_key_it);
				}
				_g_object_unref0 (new_keys);
			} else {
				{
					GeeIterator* _key_it = NULL;
					GeeHashSet* _tmp69_ = NULL;
					GeeIterator* _tmp70_ = NULL;
					_tmp69_ = old_keys;
					_tmp70_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp69_);
					_key_it = _tmp70_;
					while (TRUE) {
						GeeIterator* _tmp71_ = NULL;
						gboolean _tmp72_ = FALSE;
						gchar* key = NULL;
						GeeIterator* _tmp73_ = NULL;
						gpointer _tmp74_ = NULL;
						const gchar* _tmp75_ = NULL;
						const gchar* _tmp76_ = NULL;
						GeeHashMap* _tmp77_ = NULL;
						_tmp71_ = _key_it;
						_tmp72_ = gee_iterator_next (_tmp71_);
						if (!_tmp72_) {
							break;
						}
						_tmp73_ = _key_it;
						_tmp74_ = gee_iterator_get (_tmp73_);
						key = (gchar*) _tmp74_;
						_tmp75_ = section;
						_tmp76_ = key;
						_tmp77_ = config_keys;
						rygel_user_config_emit_unconditionally (self, _tmp75_, _tmp76_, _tmp77_);
						_g_free0 (key);
					}
					_g_object_unref0 (_key_it);
				}
			}
			_g_object_unref0 (config_keys);
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (old_keys);
			_g_free0 (section);
		}
		_g_object_unref0 (_section_it);
	}
	{
		GeeIterator* _section_it = NULL;
		GeeHashSet* _tmp78_ = NULL;
		GeeIterator* _tmp79_ = NULL;
		_tmp78_ = new_sections;
		_tmp79_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp78_);
		_section_it = _tmp79_;
		while (TRUE) {
			GeeIterator* _tmp80_ = NULL;
			gboolean _tmp81_ = FALSE;
			gchar* section = NULL;
			GeeIterator* _tmp82_ = NULL;
			gpointer _tmp83_ = NULL;
			GeeHashSet* keys = NULL;
			const gchar* _tmp84_ = NULL;
			GKeyFile* _tmp85_ = NULL;
			GKeyFile* _tmp86_ = NULL;
			GeeHashSet* _tmp87_ = NULL;
			GeeHashMap* _tmp88_ = NULL;
			GeeHashMap* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			gboolean _tmp91_ = FALSE;
			GeeHashMap* config_keys = NULL;
			GeeHashMap* _tmp96_ = NULL;
			GeeHashMap* _tmp97_ = NULL;
			_tmp80_ = _section_it;
			_tmp81_ = gee_iterator_next (_tmp80_);
			if (!_tmp81_) {
				break;
			}
			_tmp82_ = _section_it;
			_tmp83_ = gee_iterator_get (_tmp82_);
			section = (gchar*) _tmp83_;
			_tmp84_ = section;
			_tmp85_ = sys_key_file;
			_tmp86_ = key_file;
			_tmp87_ = rygel_user_config_get_keys (_tmp84_, _tmp85_, _tmp86_);
			keys = _tmp87_;
			_tmp89_ = rygel_user_config_config_keys;
			_tmp90_ = section;
			_tmp91_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp89_, _tmp90_);
			if (_tmp91_) {
				GeeHashMap* _tmp92_ = NULL;
				const gchar* _tmp93_ = NULL;
				gpointer _tmp94_ = NULL;
				_tmp92_ = rygel_user_config_config_keys;
				_tmp93_ = section;
				_tmp94_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp92_, _tmp93_);
				_g_object_unref0 (_tmp88_);
				_tmp88_ = (GeeHashMap*) _tmp94_;
			} else {
				GeeHashMap* _tmp95_ = NULL;
				_tmp95_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, rygel_user_config_config_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp88_);
				_tmp88_ = _tmp95_;
			}
			_tmp96_ = _tmp88_;
			_tmp97_ = _g_object_ref0 (_tmp96_);
			config_keys = _tmp97_;
			{
				GeeIterator* _key_it = NULL;
				GeeHashSet* _tmp98_ = NULL;
				GeeIterator* _tmp99_ = NULL;
				_tmp98_ = keys;
				_tmp99_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp98_);
				_key_it = _tmp99_;
				while (TRUE) {
					GeeIterator* _tmp100_ = NULL;
					gboolean _tmp101_ = FALSE;
					gchar* key = NULL;
					GeeIterator* _tmp102_ = NULL;
					gpointer _tmp103_ = NULL;
					const gchar* _tmp104_ = NULL;
					const gchar* _tmp105_ = NULL;
					GeeHashMap* _tmp106_ = NULL;
					_tmp100_ = _key_it;
					_tmp101_ = gee_iterator_next (_tmp100_);
					if (!_tmp101_) {
						break;
					}
					_tmp102_ = _key_it;
					_tmp103_ = gee_iterator_get (_tmp102_);
					key = (gchar*) _tmp103_;
					_tmp104_ = section;
					_tmp105_ = key;
					_tmp106_ = config_keys;
					rygel_user_config_emit_unconditionally (self, _tmp104_, _tmp105_, _tmp106_);
					_g_free0 (key);
				}
				_g_object_unref0 (_key_it);
			}
			_g_object_unref0 (config_keys);
			_g_object_unref0 (_tmp88_);
			_g_object_unref0 (keys);
			_g_free0 (section);
		}
		_g_object_unref0 (_section_it);
	}
	_g_object_unref0 (new_sections);
	_g_object_unref0 (old_sections);
	_g_key_file_unref0 (old_sys_key_file);
	_g_key_file_unref0 (old_key_file);
}


static void rygel_user_config_reload_compare_and_notify_system (RygelUserConfig* self, GFile* system) {
	GKeyFile* sys_key_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (system != NULL);
	_tmp0_ = g_key_file_new ();
	sys_key_file = _tmp0_;
	{
		GFile* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = system;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_file (sys_key_file, _tmp3_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_key_file_unref0 (sys_key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->key_file;
	rygel_user_config_compare_and_notify (self, _tmp4_, sys_key_file);
	_g_key_file_unref0 (sys_key_file);
}


static void rygel_user_config_reload_compare_and_notify_local (RygelUserConfig* self, GFile* local) {
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = g_key_file_new ();
	key_file = _tmp0_;
	{
		GFile* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = local;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_file (key_file, _tmp3_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->sys_key_file;
	rygel_user_config_compare_and_notify (self, key_file, _tmp4_);
	_g_key_file_unref0 (key_file);
}


static void rygel_user_config_on_system_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	GFile* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	rygel_user_config_reload_compare_and_notify_system (self, _tmp0_);
}


static void rygel_user_config_on_local_config_changed (RygelUserConfig* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	GFile* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	rygel_user_config_reload_compare_and_notify_local (self, _tmp0_);
}


static RygelUserConfigConfigPair* rygel_user_config_config_pair_construct (GType object_type, RygelConfigurationEntry entry, RygelEntryType type) {
	RygelUserConfigConfigPair* self = NULL;
	RygelConfigurationEntry _tmp0_ = 0;
	RygelEntryType _tmp1_ = 0;
	self = (RygelUserConfigConfigPair*) g_type_create_instance (object_type);
	_tmp0_ = entry;
	self->entry = _tmp0_;
	_tmp1_ = type;
	self->type = _tmp1_;
	return self;
}


static RygelUserConfigConfigPair* rygel_user_config_config_pair_new (RygelConfigurationEntry entry, RygelEntryType type) {
	return rygel_user_config_config_pair_construct (RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, entry, type);
}


static void rygel_user_config_value_config_pair_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_user_config_value_config_pair_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_user_config_config_pair_unref (value->data[0].v_pointer);
	}
}


static void rygel_user_config_value_config_pair_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_user_config_config_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_user_config_value_config_pair_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_user_config_value_config_pair_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelUserConfigConfigPair* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_user_config_config_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_user_config_value_config_pair_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelUserConfigConfigPair** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_user_config_config_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* rygel_user_config_param_spec_config_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelUserConfigParamSpecConfigPair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer rygel_user_config_value_get_config_pair (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR), NULL);
	return value->data[0].v_pointer;
}


static void rygel_user_config_value_set_config_pair (GValue* value, gpointer v_object) {
	RygelUserConfigConfigPair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_user_config_config_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_config_pair_unref (old);
	}
}


static void rygel_user_config_value_take_config_pair (GValue* value, gpointer v_object) {
	RygelUserConfigConfigPair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_config_pair_unref (old);
	}
}


static void rygel_user_config_config_pair_class_init (RygelUserConfigConfigPairClass * klass) {
	rygel_user_config_config_pair_parent_class = g_type_class_peek_parent (klass);
	RYGEL_USER_CONFIG_CONFIG_PAIR_CLASS (klass)->finalize = rygel_user_config_config_pair_finalize;
}


static void rygel_user_config_config_pair_instance_init (RygelUserConfigConfigPair * self) {
	self->ref_count = 1;
}


static void rygel_user_config_config_pair_finalize (RygelUserConfigConfigPair* obj) {
	RygelUserConfigConfigPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, RygelUserConfigConfigPair);
}


static GType rygel_user_config_config_pair_get_type (void) {
	static volatile gsize rygel_user_config_config_pair_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_config_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_user_config_value_config_pair_init, rygel_user_config_value_config_pair_free_value, rygel_user_config_value_config_pair_copy_value, rygel_user_config_value_config_pair_peek_pointer, "p", rygel_user_config_value_config_pair_collect_value, "p", rygel_user_config_value_config_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigConfigPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_config_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfigConfigPair), 0, (GInstanceInitFunc) rygel_user_config_config_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_user_config_config_pair_type_id;
		rygel_user_config_config_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelUserConfigConfigPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_user_config_config_pair_type_id__volatile, rygel_user_config_config_pair_type_id);
	}
	return rygel_user_config_config_pair_type_id__volatile;
}


static gpointer rygel_user_config_config_pair_ref (gpointer instance) {
	RygelUserConfigConfigPair* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void rygel_user_config_config_pair_unref (gpointer instance) {
	RygelUserConfigConfigPair* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_USER_CONFIG_CONFIG_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static RygelUserConfigSectionPair* rygel_user_config_section_pair_construct (GType object_type, RygelSectionEntry entry, RygelEntryType type) {
	RygelUserConfigSectionPair* self = NULL;
	RygelSectionEntry _tmp0_ = 0;
	RygelEntryType _tmp1_ = 0;
	self = (RygelUserConfigSectionPair*) g_type_create_instance (object_type);
	_tmp0_ = entry;
	self->entry = _tmp0_;
	_tmp1_ = type;
	self->type = _tmp1_;
	return self;
}


static RygelUserConfigSectionPair* rygel_user_config_section_pair_new (RygelSectionEntry entry, RygelEntryType type) {
	return rygel_user_config_section_pair_construct (RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, entry, type);
}


static void rygel_user_config_value_section_pair_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_user_config_value_section_pair_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_user_config_section_pair_unref (value->data[0].v_pointer);
	}
}


static void rygel_user_config_value_section_pair_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_user_config_section_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_user_config_value_section_pair_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_user_config_value_section_pair_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelUserConfigSectionPair* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_user_config_section_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_user_config_value_section_pair_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelUserConfigSectionPair** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_user_config_section_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* rygel_user_config_param_spec_section_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelUserConfigParamSpecSectionPair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer rygel_user_config_value_get_section_pair (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR), NULL);
	return value->data[0].v_pointer;
}


static void rygel_user_config_value_set_section_pair (GValue* value, gpointer v_object) {
	RygelUserConfigSectionPair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_user_config_section_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_section_pair_unref (old);
	}
}


static void rygel_user_config_value_take_section_pair (GValue* value, gpointer v_object) {
	RygelUserConfigSectionPair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_user_config_section_pair_unref (old);
	}
}


static void rygel_user_config_section_pair_class_init (RygelUserConfigSectionPairClass * klass) {
	rygel_user_config_section_pair_parent_class = g_type_class_peek_parent (klass);
	RYGEL_USER_CONFIG_SECTION_PAIR_CLASS (klass)->finalize = rygel_user_config_section_pair_finalize;
}


static void rygel_user_config_section_pair_instance_init (RygelUserConfigSectionPair * self) {
	self->ref_count = 1;
}


static void rygel_user_config_section_pair_finalize (RygelUserConfigSectionPair* obj) {
	RygelUserConfigSectionPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, RygelUserConfigSectionPair);
}


static GType rygel_user_config_section_pair_get_type (void) {
	static volatile gsize rygel_user_config_section_pair_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_section_pair_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_user_config_value_section_pair_init, rygel_user_config_value_section_pair_free_value, rygel_user_config_value_section_pair_copy_value, rygel_user_config_value_section_pair_peek_pointer, "p", rygel_user_config_value_section_pair_collect_value, "p", rygel_user_config_value_section_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigSectionPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_section_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfigSectionPair), 0, (GInstanceInitFunc) rygel_user_config_section_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_user_config_section_pair_type_id;
		rygel_user_config_section_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelUserConfigSectionPair", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_user_config_section_pair_type_id__volatile, rygel_user_config_section_pair_type_id);
	}
	return rygel_user_config_section_pair_type_id__volatile;
}


static gpointer rygel_user_config_section_pair_ref (gpointer instance) {
	RygelUserConfigSectionPair* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void rygel_user_config_section_pair_unref (gpointer instance) {
	RygelUserConfigSectionPair* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_USER_CONFIG_SECTION_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void rygel_user_config_class_init (RygelUserConfigClass * klass) {
	GeeHashMap* general_config_keys = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	RygelUserConfigConfigPair* _tmp4_ = NULL;
	RygelUserConfigConfigPair* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	RygelUserConfigConfigPair* _tmp7_ = NULL;
	RygelUserConfigConfigPair* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	RygelUserConfigConfigPair* _tmp10_ = NULL;
	RygelUserConfigConfigPair* _tmp11_ = NULL;
	GeeHashMap* _tmp12_ = NULL;
	RygelUserConfigConfigPair* _tmp13_ = NULL;
	RygelUserConfigConfigPair* _tmp14_ = NULL;
	GeeHashMap* _tmp15_ = NULL;
	RygelUserConfigConfigPair* _tmp16_ = NULL;
	RygelUserConfigConfigPair* _tmp17_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	RygelUserConfigConfigPair* _tmp19_ = NULL;
	RygelUserConfigConfigPair* _tmp20_ = NULL;
	GeeHashMap* _tmp21_ = NULL;
	RygelUserConfigConfigPair* _tmp22_ = NULL;
	RygelUserConfigConfigPair* _tmp23_ = NULL;
	GeeHashMap* _tmp24_ = NULL;
	RygelUserConfigConfigPair* _tmp25_ = NULL;
	RygelUserConfigConfigPair* _tmp26_ = NULL;
	GeeHashMap* _tmp27_ = NULL;
	RygelUserConfigConfigPair* _tmp28_ = NULL;
	RygelUserConfigConfigPair* _tmp29_ = NULL;
	GeeHashMap* _tmp30_ = NULL;
	RygelUserConfigConfigPair* _tmp31_ = NULL;
	RygelUserConfigConfigPair* _tmp32_ = NULL;
	GeeHashMap* _tmp33_ = NULL;
	RygelUserConfigConfigPair* _tmp34_ = NULL;
	RygelUserConfigConfigPair* _tmp35_ = NULL;
	GeeHashMap* _tmp36_ = NULL;
	GeeHashMap* _tmp37_ = NULL;
	GeeHashMap* _tmp38_ = NULL;
	RygelUserConfigSectionPair* _tmp39_ = NULL;
	RygelUserConfigSectionPair* _tmp40_ = NULL;
	GeeHashMap* _tmp41_ = NULL;
	RygelUserConfigSectionPair* _tmp42_ = NULL;
	RygelUserConfigSectionPair* _tmp43_ = NULL;
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_CONFIG_PAIR, (GBoxedCopyFunc) rygel_user_config_config_pair_ref, rygel_user_config_config_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	general_config_keys = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (rygel_user_config_config_keys);
	rygel_user_config_config_keys = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_USER_CONFIG_TYPE_SECTION_PAIR, (GBoxedCopyFunc) rygel_user_config_section_pair_ref, rygel_user_config_section_pair_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (rygel_user_config_section_keys);
	rygel_user_config_section_keys = _tmp2_;
	_tmp3_ = general_config_keys;
	_tmp4_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_INTERFACE, RYGEL_ENTRY_TYPE_STRING);
	_tmp5_ = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, RYGEL_USER_CONFIG_IFACE_KEY, _tmp5_);
	_rygel_user_config_config_pair_unref0 (_tmp5_);
	_tmp6_ = general_config_keys;
	_tmp7_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PORT, RYGEL_ENTRY_TYPE_INT);
	_tmp8_ = _tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, RYGEL_USER_CONFIG_PORT_KEY, _tmp8_);
	_rygel_user_config_config_pair_unref0 (_tmp8_);
	_tmp9_ = general_config_keys;
	_tmp10_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_UPNP_ENABLED, RYGEL_ENTRY_TYPE_BOOL);
	_tmp11_ = _tmp10_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, RYGEL_USER_CONFIG_UPNP_ENABLED_KEY, _tmp11_);
	_rygel_user_config_config_pair_unref0 (_tmp11_);
	_tmp12_ = general_config_keys;
	_tmp13_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_TRANSCODING, RYGEL_ENTRY_TYPE_BOOL);
	_tmp14_ = _tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, RYGEL_USER_CONFIG_TRANSCODING_KEY, _tmp14_);
	_rygel_user_config_config_pair_unref0 (_tmp14_);
	_tmp15_ = general_config_keys;
	_tmp16_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_ALLOW_UPLOAD, RYGEL_ENTRY_TYPE_BOOL);
	_tmp17_ = _tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, _tmp17_);
	_rygel_user_config_config_pair_unref0 (_tmp17_);
	_tmp18_ = general_config_keys;
	_tmp19_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_ALLOW_DELETION, RYGEL_ENTRY_TYPE_BOOL);
	_tmp20_ = _tmp19_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, _tmp20_);
	_rygel_user_config_config_pair_unref0 (_tmp20_);
	_tmp21_ = general_config_keys;
	_tmp22_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_LOG_LEVELS, RYGEL_ENTRY_TYPE_STRING);
	_tmp23_ = _tmp22_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, RYGEL_USER_CONFIG_LOG_LEVELS_KEY, _tmp23_);
	_rygel_user_config_config_pair_unref0 (_tmp23_);
	_tmp24_ = general_config_keys;
	_tmp25_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PLUGIN_PATH, RYGEL_ENTRY_TYPE_STRING);
	_tmp26_ = _tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, RYGEL_USER_CONFIG_PLUGIN_PATH_KEY, _tmp26_);
	_rygel_user_config_config_pair_unref0 (_tmp26_);
	_tmp27_ = general_config_keys;
	_tmp28_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_VIDEO_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
	_tmp29_ = _tmp28_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY, _tmp29_);
	_rygel_user_config_config_pair_unref0 (_tmp29_);
	_tmp30_ = general_config_keys;
	_tmp31_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_MUSIC_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
	_tmp32_ = _tmp31_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY, _tmp32_);
	_rygel_user_config_config_pair_unref0 (_tmp32_);
	_tmp33_ = general_config_keys;
	_tmp34_ = rygel_user_config_config_pair_new (RYGEL_CONFIGURATION_ENTRY_PICTURE_UPLOAD_FOLDER, RYGEL_ENTRY_TYPE_STRING);
	_tmp35_ = _tmp34_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY, _tmp35_);
	_rygel_user_config_config_pair_unref0 (_tmp35_);
	_tmp36_ = rygel_user_config_config_keys;
	_tmp37_ = general_config_keys;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, RYGEL_USER_CONFIG_GENERAL_SECTION, _tmp37_);
	_tmp38_ = rygel_user_config_section_keys;
	_tmp39_ = rygel_user_config_section_pair_new (RYGEL_SECTION_ENTRY_ENABLED, RYGEL_ENTRY_TYPE_BOOL);
	_tmp40_ = _tmp39_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp38_, RYGEL_USER_CONFIG_ENABLED_KEY, _tmp40_);
	_rygel_user_config_section_pair_unref0 (_tmp40_);
	_tmp41_ = rygel_user_config_section_keys;
	_tmp42_ = rygel_user_config_section_pair_new (RYGEL_SECTION_ENTRY_TITLE, RYGEL_ENTRY_TYPE_STRING);
	_tmp43_ = _tmp42_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, RYGEL_USER_CONFIG_TITLE_KEY, _tmp43_);
	_rygel_user_config_section_pair_unref0 (_tmp43_);
	_g_object_unref0 (general_config_keys);
}


static void rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_upnp_enabled;
	iface->get_interfaces = (gchar** (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_interfaces;
	iface->get_interface = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_interface;
	iface->get_port = (gint (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_port;
	iface->get_transcoding = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_transcoding;
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_allow_deletion;
	iface->get_log_levels = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_log_levels;
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_plugin_path;
	iface->get_engine_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_engine_path;
	iface->get_media_engine = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_media_engine;
	iface->get_video_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_video_upload_folder;
	iface->get_music_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_music_upload_folder;
	iface->get_picture_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_user_config_real_get_picture_upload_folder;
	iface->get_enabled = (gboolean (*)(RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_enabled;
	iface->get_title = (gchar* (*)(RygelConfiguration*, const gchar*, GError**)) rygel_user_config_real_get_title;
	iface->get_string = (gchar* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_string_list;
	iface->get_int = (gint (*)(RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_user_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_int_list;
	iface->get_bool = (gboolean (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_user_config_real_get_bool;
}


static void rygel_user_config_instance_init (RygelUserConfig * self) {
}


static void rygel_user_config_finalize (GObject* obj) {
	RygelUserConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_USER_CONFIG, RygelUserConfig);
	_g_key_file_unref0 (self->key_file);
	_g_key_file_unref0 (self->sys_key_file);
	_g_object_unref0 (self->key_file_monitor);
	_g_object_unref0 (self->sys_key_file_monitor);
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
}


/**
 * Manages the user configuration for Rygel.
 */
GType rygel_user_config_get_type (void) {
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



