/* rygel-media-export-harvester.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _Block4Data Block4Data;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GCancellable* cancellable;
	GeeArrayList* _locations;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _Block4Data {
	int _ref_count_;
	RygelMediaExportHarvester * self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
gboolean rygel_media_export_harvester_is_eligible (GFileInfo* info);
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda3_ (Block4Data* _data4_);
static gboolean ___lambda3__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_media_export_harvester_on_file_changed (self, file, other_file, event_type);
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GCancellable* _tmp19_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp20_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp21_ = NULL;
	GeeHashMap* _tmp22_ = NULL;
	GeeHashMap* _tmp23_ = NULL;
	g_return_val_if_fail (cancellable != NULL, NULL);
	g_return_val_if_fail (locations != NULL, NULL);
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_media_export_harvester_set_locations (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _file_index = 0;
		_tmp4_ = locations;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_file_list = _tmp5_;
		_tmp6_ = _file_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_file_size = _tmp8_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			GFile* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			_tmp9_ = _file_index;
			_file_index = _tmp9_ + 1;
			_tmp10_ = _file_index;
			_tmp11_ = _file_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _file_list;
			_tmp13_ = _file_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			file = (GFile*) _tmp14_;
			_tmp15_ = file;
			_tmp16_ = g_file_query_exists (_tmp15_, NULL);
			if (_tmp16_) {
				GeeArrayList* _tmp17_ = NULL;
				GFile* _tmp18_ = NULL;
				_tmp17_ = self->priv->_locations;
				_tmp18_ = file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp19_ = cancellable;
	_tmp20_ = rygel_media_export_recursive_file_monitor_new (_tmp19_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp20_;
	_tmp21_ = self->priv->monitor;
	g_signal_connect_object (_tmp21_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
	_tmp22_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tasks);
	self->priv->tasks = _tmp22_;
	_tmp23_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	self->priv->extraction_grace_timers = _tmp23_;
	return self;
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations) {
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable, locations);
}


/**
     * Check if a FileInfo is considered for extraction
     *
     * @param info a FileInfo
     * @return true if file should be extracted, false otherwise
     */
gboolean rygel_media_export_harvester_is_eligible (GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GFileInfo* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp28_ = FALSE;
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp6_ = info;
	_tmp7_ = g_file_info_get_content_type (_tmp6_);
	_tmp8_ = g_str_has_prefix (_tmp7_, "image/");
	if (_tmp8_) {
		_tmp5_ = TRUE;
	} else {
		GFileInfo* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = info;
		_tmp10_ = g_file_info_get_content_type (_tmp9_);
		_tmp11_ = g_str_has_prefix (_tmp10_, "video/");
		_tmp5_ = _tmp11_;
	}
	_tmp12_ = _tmp5_;
	if (_tmp12_) {
		_tmp4_ = TRUE;
	} else {
		GFileInfo* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = info;
		_tmp14_ = g_file_info_get_content_type (_tmp13_);
		_tmp15_ = g_str_has_prefix (_tmp14_, "audio/");
		_tmp4_ = _tmp15_;
	}
	_tmp16_ = _tmp4_;
	if (_tmp16_) {
		_tmp3_ = TRUE;
	} else {
		GFileInfo* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = info;
		_tmp18_ = g_file_info_get_content_type (_tmp17_);
		_tmp3_ = g_strcmp0 (_tmp18_, "application/ogg") == 0;
	}
	_tmp19_ = _tmp3_;
	if (_tmp19_) {
		_tmp2_ = TRUE;
	} else {
		GFileInfo* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp20_ = info;
		_tmp21_ = g_file_info_get_content_type (_tmp20_);
		_tmp2_ = g_strcmp0 (_tmp21_, "application/xml") == 0;
	}
	_tmp22_ = _tmp2_;
	if (_tmp22_) {
		_tmp1_ = TRUE;
	} else {
		GFileInfo* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = info;
		_tmp24_ = g_file_info_get_content_type (_tmp23_);
		_tmp1_ = g_strcmp0 (_tmp24_, "text/xml") == 0;
	}
	_tmp25_ = _tmp1_;
	if (_tmp25_) {
		_tmp0_ = TRUE;
	} else {
		GFileInfo* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		_tmp26_ = info;
		_tmp27_ = g_file_info_get_content_type (_tmp26_);
		_tmp0_ = g_strcmp0 (_tmp27_, "text/plain") == 0;
	}
	_tmp28_ = _tmp0_;
	result = _tmp28_;
	return result;
}


/**
     * Schedule rescan of all top-level locations known to the harvester.
     *
     * @param parent top-level container of the files
     */
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _file_index = 0;
		_tmp0_ = self->priv->_locations;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_file_list = _tmp1_;
		_tmp2_ = _file_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_file_size = _tmp4_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			RygelMediaContainer* _tmp12_ = NULL;
			_tmp5_ = _file_index;
			_file_index = _tmp5_ + 1;
			_tmp6_ = _file_index;
			_tmp7_ = _file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _file_list;
			_tmp9_ = _file_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			file = (GFile*) _tmp10_;
			_tmp11_ = file;
			_tmp12_ = parent;
			rygel_media_export_harvester_schedule (self, _tmp11_, _tmp12_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_media_export_harvester_on_file_harvested (self, _sender);
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent) {
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	RygelMediaExportHarvestingTask* task = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	RygelMediaContainer* _tmp5_ = NULL;
	RygelMediaExportHarvestingTask* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = self->priv->extraction_grace_timers;
	_tmp1_ = file;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
	_tmp2_ = file;
	rygel_media_export_harvester_cancel (self, _tmp2_);
	_tmp3_ = self->priv->monitor;
	_tmp4_ = file;
	_tmp5_ = parent;
	_tmp6_ = rygel_media_export_harvesting_task_new (_tmp3_, _tmp4_, _tmp5_);
	task = _tmp6_;
	_tmp7_ = self->priv->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) task, _tmp7_);
	g_signal_connect_object ((RygelStateMachine*) task, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
	_tmp8_ = self->priv->tasks;
	_tmp9_ = file;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, task);
	rygel_state_machine_run ((RygelStateMachine*) task, NULL, NULL);
	_g_object_unref0 (task);
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->tasks;
	_tmp1_ = file;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		RygelMediaExportHarvestingTask* task = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		RygelMediaExportHarvestingTask* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		GeeHashMap* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		RygelMediaExportHarvestingTask* _tmp10_ = NULL;
		_tmp3_ = self->priv->tasks;
		_tmp4_ = file;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		task = (RygelMediaExportHarvestingTask*) _tmp5_;
		_tmp6_ = task;
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
		_tmp8_ = self->priv->tasks;
		_tmp9_ = file;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
		_tmp10_ = task;
		rygel_media_export_harvesting_task_cancel (_tmp10_);
		_g_object_unref0 (task);
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelMediaExportHarvestingTask* task = NULL;
	RygelStateMachine* _tmp0_ = NULL;
	RygelMediaExportHarvestingTask* _tmp1_ = NULL;
	GFile* file = NULL;
	RygelMediaExportHarvestingTask* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state_machine != NULL);
	_tmp0_ = state_machine;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
	task = _tmp1_;
	_tmp2_ = task;
	_tmp3_ = _tmp2_->origin;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	file = _tmp4_;
	_tmp5_ = _ ("'%s' harvested");
	_tmp6_ = file;
	_tmp7_ = g_file_get_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	g_message (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->tasks;
	_tmp10_ = file;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
	_tmp11_ = self->priv->tasks;
	_tmp12_ = gee_map_get_is_empty ((GeeMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		g_signal_emit_by_name (self, "done");
	}
	_g_object_unref0 (file);
	_g_object_unref0 (task);
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GFileMonitorEvent _tmp0_ = 0;
		_tmp0_ = event;
		switch (_tmp0_) {
			case G_FILE_MONITOR_EVENT_CREATED:
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
			{
				GFile* _tmp1_ = NULL;
				_tmp1_ = file;
				rygel_media_export_harvester_on_changes_done (self, _tmp1_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch59_g_error;
				}
				break;
			}
			case G_FILE_MONITOR_EVENT_DELETED:
			{
				GFile* _tmp2_ = NULL;
				_tmp2_ = file;
				rygel_media_export_harvester_on_file_removed (self, _tmp2_);
				break;
			}
			default:
			{
				break;
			}
		}
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally59:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("rygel-media-export-harvester.vala:162: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp2_);
	_g_free0 (_tmp2_);
	{
		RygelMediaExportMediaCache* cache = NULL;
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		GFileInfo* info = NULL;
		GFile* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GFileType _tmp8_ = 0;
		gboolean _tmp10_ = FALSE;
		_tmp3_ = rygel_media_export_media_cache_get_default ();
		cache = _tmp3_;
		_tmp4_ = file;
		_tmp5_ = self->priv->cancellable;
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, _tmp5_, &_inner_error_);
		info = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cache);
			goto __catch60_g_error;
		}
		_tmp8_ = g_file_info_get_file_type (info);
		if (_tmp8_ == G_FILE_TYPE_DIRECTORY) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp9_ = FALSE;
			_tmp9_ = rygel_media_export_harvester_is_eligible (info);
			_tmp7_ = _tmp9_;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			gchar* id = NULL;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_ = NULL;
			GFile* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp11_ = file;
			_tmp12_ = g_file_get_parent (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = rygel_media_export_media_cache_get_id (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp13_);
			id = _tmp15_;
			{
				RygelMediaObject* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				RygelMediaObject* _tmp18_ = NULL;
				RygelMediaContainer* parent_container = NULL;
				RygelMediaContainer* _tmp19_ = NULL;
				GFile* _tmp20_ = NULL;
				RygelMediaContainer* _tmp21_ = NULL;
				_tmp17_ = id;
				_tmp18_ = rygel_media_export_media_cache_get_object (cache, _tmp17_, &_inner_error_);
				_tmp16_ = _tmp18_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch61_rygel_media_export_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (info);
					_g_object_unref0 (cache);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp19_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp16_) : NULL;
				if (_tmp19_ == NULL) {
					_g_object_unref0 (_tmp16_);
				}
				parent_container = _tmp19_;
				_tmp20_ = file;
				_tmp21_ = parent_container;
				rygel_media_export_harvester_schedule (self, _tmp20_, _tmp21_);
				_g_object_unref0 (parent_container);
			}
			goto __finally61;
			__catch61_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				GError* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = _ ("Error fetching object '%s' from database: %s");
				_tmp23_ = id;
				_tmp24_ = _error_;
				_tmp25_ = _tmp24_->message;
				g_warning (_tmp22_, _tmp23_, _tmp25_);
				_g_error_free0 (_error_);
			}
			__finally61:
			if (_inner_error_ != NULL) {
				_g_free0 (id);
				_g_object_unref0 (info);
				_g_object_unref0 (cache);
				goto __catch60_g_error;
			}
			_g_free0 (id);
		} else {
			GFile* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp26_ = file;
			_tmp27_ = g_file_get_uri (_tmp26_);
			_tmp28_ = _tmp27_;
			g_debug ("rygel-media-export-harvester.vala:183: %s is not eligible for extracti" \
"on", _tmp28_);
			_g_free0 (_tmp28_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (cache);
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp29_ = NULL;
		GFile* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = _ ("Failed to query info of a file %s: %s");
		_tmp30_ = file;
		_tmp31_ = g_file_get_uri (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _error_;
		_tmp34_ = _tmp33_->message;
		g_warning (_tmp29_, _tmp32_, _tmp34_);
		_g_free0 (_tmp32_);
		_g_error_free0 (_error_);
	}
	__finally60:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file) {
	RygelMediaExportMediaCache* cache = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = rygel_media_export_media_cache_get_default ();
	cache = _tmp0_;
	_tmp1_ = self->priv->extraction_grace_timers;
	_tmp2_ = file;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	if (_tmp3_) {
		GeeHashMap* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		GeeHashMap* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		_tmp4_ = self->priv->extraction_grace_timers;
		_tmp5_ = file;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		g_source_remove ((guint) ((guintptr) _tmp6_));
		_tmp7_ = self->priv->extraction_grace_timers;
		_tmp8_ = file;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
	}
	_tmp9_ = file;
	rygel_media_export_harvester_cancel (self, _tmp9_);
	{
		gchar* id = NULL;
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		RygelMediaObject* object = NULL;
		RygelMediaExportMediaCache* _tmp12_ = NULL;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaContainer* parent = NULL;
		gpointer _tmp14_ = NULL;
		RygelMediaContainer* _tmp15_ = NULL;
		_tmp10_ = file;
		_tmp11_ = rygel_media_export_media_cache_get_id (_tmp10_);
		id = _tmp11_;
		_tmp12_ = cache;
		_tmp13_ = rygel_media_export_media_cache_get_object (_tmp12_, id, &_inner_error_);
		object = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_free0 (id);
			goto __catch62_g_error;
		}
		_tmp14_ = NULL;
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp14_) : NULL);
		parent = _tmp15_;
		if (object != NULL) {
			RygelMediaContainer* _tmp16_ = NULL;
			RygelMediaContainer* _tmp17_ = NULL;
			RygelMediaContainer* _tmp18_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
			_tmp16_ = rygel_media_object_get_parent (object);
			_tmp17_ = _tmp16_;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (parent);
			parent = _tmp18_;
			_tmp19_ = parent;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
				RygelTrackableContainer* container = NULL;
				RygelMediaContainer* _tmp20_ = NULL;
				RygelTrackableContainer* _tmp21_ = NULL;
				RygelTrackableContainer* _tmp22_ = NULL;
				_tmp20_ = parent;
				_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp20_) : NULL);
				container = _tmp21_;
				_tmp22_ = container;
				rygel_trackable_container_remove_child_tracked (_tmp22_, object, NULL, NULL);
				_g_object_unref0 (container);
			}
		}
		_g_object_unref0 (parent);
		_g_object_unref0 (object);
		_g_free0 (id);
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = _ ("Error removing object from database: %s");
		_tmp24_ = _error_;
		_tmp25_ = _tmp24_->message;
		g_warning (_tmp23_, _tmp25_);
		_g_error_free0 (_error_);
	}
	__finally62:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (cache);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (cache);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		RygelMediaExportHarvester * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->file);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda3_ (Block4Data* _data4_) {
	RygelMediaExportHarvester * self;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->file;
	rygel_media_export_harvester_on_file_added (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
	return result;
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block4Data* _data4_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GeeHashMap* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GSourceFunc callback = NULL;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	guint timeout = 0U;
	GSourceFunc _tmp16_ = NULL;
	void* _tmp16__target = NULL;
	GDestroyNotify _tmp16__target_destroy_notify = NULL;
	guint _tmp17_ = 0U;
	GeeHashMap* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->file);
	_data4_->file = _tmp1_;
	_tmp2_ = _data4_->file;
	_tmp3_ = g_file_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_str_has_prefix (_tmp4_, ".");
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp7_ = self->priv->extraction_grace_timers;
	_tmp8_ = _data4_->file;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_);
	if (_tmp9_) {
		GeeHashMap* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		gpointer _tmp12_ = NULL;
		_tmp10_ = self->priv->extraction_grace_timers;
		_tmp11_ = _data4_->file;
		_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
		g_source_remove ((guint) ((guintptr) _tmp12_));
	} else {
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp13_ = _data4_->file;
		_tmp14_ = g_file_get_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		g_debug ("rygel-media-export-harvester.vala:229: Starting grace timer for harves" \
"ting %s…", _tmp15_);
		_g_free0 (_tmp15_);
	}
	callback = ___lambda3__gsource_func;
	callback_target = block4_data_ref (_data4_);
	callback_target_destroy_notify = block4_data_unref;
	_tmp16_ = callback;
	_tmp16__target = callback_target;
	_tmp16__target_destroy_notify = callback_target_destroy_notify;
	callback_target_destroy_notify = NULL;
	_tmp17_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp16_, _tmp16__target, _tmp16__target_destroy_notify);
	timeout = _tmp17_;
	_tmp18_ = self->priv->extraction_grace_timers;
	_tmp19_ = _data4_->file;
	_tmp20_ = timeout;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp19_, (gpointer) ((guintptr) _tmp20_));
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locations;
	result = _tmp0_;
	return result;
}


static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_locations);
	self->priv->_locations = _tmp1_;
	g_object_notify ((GObject *) self, "locations");
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvester_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvester_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS, g_param_spec_object ("locations", "locations", "locations", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	_g_object_unref0 (self->priv->tasks);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->_locations);
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
		g_value_set_object (value, rygel_media_export_harvester_get_locations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
		rygel_media_export_harvester_set_locations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



