/* chess-engine-uci.c generated by valac 0.22.1.2-49127, the Vala compiler
 * generated from chess-engine-uci.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessEngineUCIPrivate ChessEngineUCIPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEngineUCI {
	ChessEngine parent_instance;
	ChessEngineUCIPrivate * priv;
};

struct _ChessEngineUCIClass {
	ChessEngineClass parent_class;
};

struct _ChessEngineUCIPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* moves;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	gchar* go_options;
	gboolean waiting_for_move;
};


static gpointer chess_engine_uci_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_UCI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIPrivate))
enum  {
	CHESS_ENGINE_UCI_DUMMY_PROPERTY
};
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1);
static gchar** _vala_array_dup23 (gchar** self, int length);
static void chess_engine_uci_start_cb (ChessEngineUCI* self);
static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
static void chess_engine_uci_real_start_game (ChessEngine* base);
static void chess_engine_uci_real_request_move (ChessEngine* base);
static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move);
gchar* chess_move_get_engine (ChessMove* self);
static void chess_engine_uci_real_undo (ChessEngine* base);
static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1);
static void chess_engine_uci_configure (ChessEngineUCI* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static gchar* _vala_array_dup24 (gchar* self, int length);
static gchar** _vala_array_dup25 (gchar** self, int length);
static void chess_engine_uci_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar** _vala_array_dup23 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self) {
	chess_engine_uci_start_cb (self);
}


ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1) {
	ChessEngineUCI * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (binary != NULL, NULL);
	_tmp0_ = binary;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	self = (ChessEngineUCI*) chess_engine_construct (object_type, _tmp0_, _tmp1_, _tmp1__length1);
	_tmp2_ = options;
	_tmp2__length1 = options_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup23 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->options = _tmp3_;
	self->priv->options_length1 = _tmp3__length1;
	self->priv->_options_size_ = self->priv->options_length1;
	_tmp4_ = go_options;
	_tmp4__length1 = go_options_length1;
	_tmp5_ = g_strjoinv (" ", _tmp4_);
	_g_free0 (self->priv->go_options);
	self->priv->go_options = _tmp5_;
	_tmp6_ = g_new0 (gchar, 0);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp6_;
	self->priv->buffer_length1 = 0;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	_tmp7_ = g_strdup ("");
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp7_;
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_uci_start_cb_chess_engine_starting, self, 0);
	return self;
}


ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1) {
	return chess_engine_uci_construct (TYPE_CHESS_ENGINE_UCI, binary, args, args_length1, options, options_length1, go_options, go_options_length1);
}


static void chess_engine_uci_start_cb (ChessEngineUCI* self) {
	g_return_if_fail (self != NULL);
	chess_engine_write_line ((ChessEngine*) self, "uci");
}


static void chess_engine_uci_real_start_game (ChessEngine* base) {
	ChessEngineUCI * self;
	self = (ChessEngineUCI*) base;
	chess_engine_write_line ((ChessEngine*) self, "ucinewgame");
}


static void chess_engine_uci_real_request_move (ChessEngine* base) {
	ChessEngineUCI * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->moves;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = self->priv->moves;
		_tmp2_ = g_strconcat ("position startpos moves", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		chess_engine_write_line ((ChessEngine*) self, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		chess_engine_write_line ((ChessEngine*) self, "position startpos");
	}
	self->priv->waiting_for_move = TRUE;
	_tmp4_ = self->priv->go_options;
	_tmp5_ = g_strdup_printf ("go wtime 30000 btime 30000 %s", _tmp4_);
	_tmp6_ = _tmp5_;
	chess_engine_write_line ((ChessEngine*) self, _tmp6_);
	_g_free0 (_tmp6_);
}


static void chess_engine_uci_real_report_move (ChessEngine* base, ChessMove* move) {
	ChessEngineUCI * self;
	const gchar* _tmp0_ = NULL;
	ChessMove* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	self = (ChessEngineUCI*) base;
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->moves;
	_tmp1_ = move;
	_tmp2_ = chess_move_get_engine (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp0_, _tmp5_, NULL);
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void chess_engine_uci_real_undo (ChessEngine* base) {
	ChessEngineUCI * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->waiting_for_move;
	if (_tmp0_) {
		chess_engine_write_line ((ChessEngine*) self, "stop");
	}
	self->priv->waiting_for_move = FALSE;
	_tmp1_ = self->priv->moves;
	_tmp2_ = self->priv->moves;
	_tmp3_ = string_last_index_of (_tmp2_, " ", 0);
	_tmp4_ = string_slice (_tmp1_, (glong) 0, (glong) _tmp3_);
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp4_;
}


static gchar* _vala_array_dup24 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static void chess_engine_uci_real_process_input (ChessEngine* base, gchar* data, int data_length1) {
	ChessEngineUCI * self;
	gint current = 0;
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->buffer;
	_tmp0__length1 = self->priv->buffer_length1;
	current = _tmp0__length1;
	_tmp1_ = self->priv->buffer;
	_tmp1__length1 = self->priv->buffer_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	_tmp3_ = (gint) (_tmp1__length1 + _tmp2__length1);
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (_tmp1__length1 + _tmp2__length1));
	(_tmp3_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp3_ - self->priv->buffer_length1)) : NULL;
	self->priv->buffer_length1 = _tmp3_;
	self->priv->_buffer_size_ = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				gint _tmp7_ = 0;
				gchar* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gchar* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gchar* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				gchar _tmp15_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = data;
				_tmp8__length1 = data_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->priv->buffer;
				_tmp9__length1 = self->priv->buffer_length1;
				_tmp10_ = current;
				_tmp11_ = i;
				_tmp12_ = data;
				_tmp12__length1 = data_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp9_[_tmp10_ + _tmp11_] = _tmp14_;
				_tmp15_ = _tmp9_[_tmp10_ + _tmp11_];
			}
		}
	}
	while (TRUE) {
		gint offset = 0;
		gint _tmp26_ = 0;
		gchar* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gchar _tmp30_ = '\0';
		gchar* line = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gchar** tokens = NULL;
		const gchar* _tmp34_ = NULL;
		gchar** _tmp35_ = NULL;
		gchar** _tmp36_ = NULL;
		gint tokens_length1 = 0;
		gint _tokens_size_ = 0;
		gchar** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		gchar* _tmp54_ = NULL;
		gint _tmp54__length1 = 0;
		gint _tmp55_ = 0;
		gchar* _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		gchar* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		{
			gboolean _tmp16_ = FALSE;
			offset = 0;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gint _tmp20_ = 0;
				gchar* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gboolean _tmp25_ = FALSE;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					_tmp18_ = offset;
					offset = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp20_ = offset;
				_tmp21_ = self->priv->buffer;
				_tmp21__length1 = self->priv->buffer_length1;
				if (_tmp20_ < _tmp21__length1) {
					gchar* _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					gchar _tmp24_ = '\0';
					_tmp22_ = self->priv->buffer;
					_tmp22__length1 = self->priv->buffer_length1;
					_tmp23_ = offset;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp19_ = _tmp24_ != '\n';
				} else {
					_tmp19_ = FALSE;
				}
				_tmp25_ = _tmp19_;
				if (!_tmp25_) {
					break;
				}
			}
		}
		_tmp26_ = offset;
		_tmp27_ = self->priv->buffer;
		_tmp27__length1 = self->priv->buffer_length1;
		if (_tmp26_ >= _tmp27__length1) {
			return;
		}
		_tmp28_ = self->priv->buffer;
		_tmp28__length1 = self->priv->buffer_length1;
		_tmp29_ = offset;
		_tmp28_[_tmp29_] = '\0';
		_tmp30_ = _tmp28_[_tmp29_];
		_tmp31_ = self->priv->buffer;
		_tmp31__length1 = self->priv->buffer_length1;
		_tmp32_ = g_strdup ((const gchar*) _tmp31_);
		line = _tmp32_;
		_tmp33_ = line;
		g_debug ("chess-engine-uci.vala:82: Read from engine: '%s'", _tmp33_);
		_tmp34_ = line;
		_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, " ", 0);
		tokens = _tmp36_;
		tokens_length1 = _vala_array_length (_tmp35_);
		_tokens_size_ = tokens_length1;
		_tmp37_ = tokens;
		_tmp37__length1 = tokens_length1;
		if (_tmp37__length1 > 0) {
			gchar** _tmp38_ = NULL;
			gint _tmp38__length1 = 0;
			const gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			GQuark _tmp42_ = 0U;
			static GQuark _tmp41_label0 = 0;
			static GQuark _tmp41_label1 = 0;
			static GQuark _tmp41_label2 = 0;
			static GQuark _tmp41_label3 = 0;
			static GQuark _tmp41_label4 = 0;
			static GQuark _tmp41_label5 = 0;
			_tmp38_ = tokens;
			_tmp38__length1 = tokens_length1;
			_tmp39_ = _tmp38_[0];
			_tmp40_ = _tmp39_;
			_tmp42_ = (NULL == _tmp40_) ? 0 : g_quark_from_string (_tmp40_);
			if (_tmp42_ == ((0 != _tmp41_label0) ? _tmp41_label0 : (_tmp41_label0 = g_quark_from_static_string ("id")))) {
				switch (0) {
					default:
					{
						break;
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label1) ? _tmp41_label1 : (_tmp41_label1 = g_quark_from_static_string ("uciok")))) {
				switch (0) {
					default:
					{
						gchar** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
						_tmp43_ = tokens;
						_tmp43__length1 = tokens_length1;
						if (_tmp43__length1 != 1) {
							const gchar* _tmp44_ = NULL;
							_tmp44_ = line;
							g_warning ("chess-engine-uci.vala:94: Unexpected arguments on uciok: %s", _tmp44_);
						}
						chess_engine_uci_configure (self);
						break;
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label2) ? _tmp41_label2 : (_tmp41_label2 = g_quark_from_static_string ("readyok")))) {
				switch (0) {
					default:
					{
						gchar** _tmp45_ = NULL;
						gint _tmp45__length1 = 0;
						_tmp45_ = tokens;
						_tmp45__length1 = tokens_length1;
						if (_tmp45__length1 != 1) {
							const gchar* _tmp46_ = NULL;
							_tmp46_ = line;
							g_warning ("chess-engine-uci.vala:101: Unexpected arguments on readyok: %s", _tmp46_);
						}
						chess_engine_set_ready ((ChessEngine*) self, TRUE);
						break;
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label3) ? _tmp41_label3 : (_tmp41_label3 = g_quark_from_static_string ("bestmove")))) {
				switch (0) {
					default:
					{
						gchar** _tmp47_ = NULL;
						gint _tmp47__length1 = 0;
						gchar** _tmp49_ = NULL;
						gint _tmp49__length1 = 0;
						const gchar* _tmp50_ = NULL;
						gchar** _tmp51_ = NULL;
						gint _tmp51__length1 = 0;
						const gchar* _tmp52_ = NULL;
						_tmp47_ = tokens;
						_tmp47__length1 = tokens_length1;
						if (_tmp47__length1 < 2) {
							const gchar* _tmp48_ = NULL;
							_tmp48_ = line;
							g_warning ("chess-engine-uci.vala:108: No move with bestmove: %s", _tmp48_);
						}
						_tmp49_ = tokens;
						_tmp49__length1 = tokens_length1;
						_tmp50_ = _tmp49_[1];
						g_debug ("chess-engine-uci.vala:109: Engine moves %s", _tmp50_);
						self->priv->waiting_for_move = FALSE;
						_tmp51_ = tokens;
						_tmp51__length1 = tokens_length1;
						_tmp52_ = _tmp51_[1];
						g_signal_emit_by_name ((ChessEngine*) self, "moved", _tmp52_);
						break;
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label4) ? _tmp41_label4 : (_tmp41_label4 = g_quark_from_static_string ("info")))) {
				switch (0) {
					default:
					{
						break;
					}
				}
			} else if (_tmp42_ == ((0 != _tmp41_label5) ? _tmp41_label5 : (_tmp41_label5 = g_quark_from_static_string ("option")))) {
				switch (0) {
					default:
					{
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						const gchar* _tmp53_ = NULL;
						_tmp53_ = line;
						g_debug ("chess-engine-uci.vala:121: Unknown command: '%s'", _tmp53_);
						break;
					}
				}
			}
		}
		_tmp54_ = self->priv->buffer;
		_tmp54__length1 = self->priv->buffer_length1;
		_tmp55_ = offset;
		_tmp56_ = self->priv->buffer;
		_tmp56__length1 = self->priv->buffer_length1;
		_tmp57_ = ((_tmp54_ + (_tmp55_ + 1)) != NULL) ? _vala_array_dup24 (_tmp54_ + (_tmp55_ + 1), _tmp56__length1 - (_tmp55_ + 1)) : ((gpointer) (_tmp54_ + (_tmp55_ + 1)));
		_tmp57__length1 = _tmp56__length1 - (_tmp55_ + 1);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp57_;
		self->priv->buffer_length1 = _tmp57__length1;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
}


static gchar** _vala_array_dup25 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void chess_engine_uci_configure (ChessEngineUCI* self) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->options;
	_tmp0__length1 = self->priv->options_length1;
	{
		gchar** o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < _tmp0__length1; o_it = o_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* o = NULL;
			_tmp1_ = g_strdup (o_collection[o_it]);
			o = _tmp1_;
			{
				gchar** line = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint line_length1 = 0;
				gint _line_size_ = 0;
				gchar* option_value = NULL;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar* option_name = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				_tmp2_ = o;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
				line = _tmp4_;
				line_length1 = _vala_array_length (_tmp3_);
				_line_size_ = line_length1;
				_tmp5_ = line;
				_tmp5__length1 = line_length1;
				_tmp6_ = line;
				_tmp6__length1 = line_length1;
				_tmp7_ = _tmp5_[_tmp6__length1 - 1];
				_tmp8_ = g_strdup (_tmp7_);
				option_value = _tmp8_;
				_tmp9_ = line;
				_tmp9__length1 = line_length1;
				_tmp10_ = line;
				_tmp10__length1 = line_length1;
				_tmp11_ = ((_tmp9_ + 0) != NULL) ? _vala_array_dup25 (_tmp9_ + 0, (_tmp10__length1 - 1) - 0) : ((gpointer) (_tmp9_ + 0));
				_tmp11__length1 = (_tmp10__length1 - 1) - 0;
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
				line = _tmp11_;
				line_length1 = _tmp11__length1;
				_line_size_ = line_length1;
				_tmp12_ = line;
				_tmp12__length1 = line_length1;
				_tmp13_ = g_strjoinv (" ", _tmp12_);
				option_name = _tmp13_;
				_tmp14_ = option_name;
				_tmp15_ = option_value;
				_tmp16_ = g_strdup_printf ("setoption name %s value %s", _tmp14_, _tmp15_);
				_tmp17_ = _tmp16_;
				chess_engine_write_line ((ChessEngine*) self, _tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (option_name);
				_g_free0 (option_value);
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (o);
			}
		}
	}
	chess_engine_write_line ((ChessEngine*) self, "isready");
}


static void chess_engine_uci_class_init (ChessEngineUCIClass * klass) {
	chess_engine_uci_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEngineUCIPrivate));
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_uci_real_start_game;
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_uci_real_request_move;
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_uci_real_report_move;
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_uci_real_undo;
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_uci_real_process_input;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_uci_finalize;
}


static void chess_engine_uci_instance_init (ChessEngineUCI * self) {
	self->priv = CHESS_ENGINE_UCI_GET_PRIVATE (self);
}


static void chess_engine_uci_finalize (GObject* obj) {
	ChessEngineUCI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE_UCI, ChessEngineUCI);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	_g_free0 (self->priv->moves);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->go_options);
	G_OBJECT_CLASS (chess_engine_uci_parent_class)->finalize (obj);
}


GType chess_engine_uci_get_type (void) {
	static volatile gsize chess_engine_uci_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_uci_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineUCIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_uci_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineUCI), 0, (GInstanceInitFunc) chess_engine_uci_instance_init, NULL };
		GType chess_engine_uci_type_id;
		chess_engine_uci_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineUCI", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_uci_type_id__volatile, chess_engine_uci_type_id);
	}
	return chess_engine_uci_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



