/* chess-view-2d.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from chess-view-2d.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <stdio.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessView2DPrivate ChessView2DPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_COLOR (color_get_type ())

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView2D {
	ChessView parent_instance;
	ChessView2DPrivate * priv;
};

struct _ChessView2DClass {
	ChessViewClass parent_class;
};

struct _ChessView2DPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;


static gpointer chess_view2_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view2_d_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW2_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW2_D, ChessView2DPrivate))
enum  {
	CHESS_VIEW2_D_DUMMY_PROPERTY
};
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view2_d_load_theme (ChessView2D* self, cairo_t* c);
static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view2_d_get_border_size (ChessView2D* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
gboolean chess_game_get_is_superpaused (ChessGame* self);
void chess_view_draw_paused_overlay (ChessView* self, cairo_t* c);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view2_d_finalize (GObject* obj);
static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView2D* chess_view2_d_construct (GType object_type) {
	ChessView2D * self = NULL;
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self = (ChessView2D*) chess_view_construct (object_type);
#line 27 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	return self;
#line 270 "chess-view-2d.c"
}


ChessView2D* chess_view2_d_new (void) {
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	return chess_view2_d_construct (TYPE_CHESS_VIEW2_D);
#line 277 "chess-view-2d.c"
}


static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gint short_edge = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gdouble extra = 0.0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self = (ChessView2D*) base;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	short_edge = _tmp2_;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp3_ = short_edge;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp4_ = self->priv->border;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv->square_size = (gint) _tmp5_;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp6_ = self->priv->square_size;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	extra = _tmp6_ * 0.1;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp7_ = extra;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp7_ < ((gdouble) 3)) {
#line 37 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		extra = (gdouble) 3;
#line 326 "chess-view-2d.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp8_ = self->priv->square_size;
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp9_ = extra;
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv->selected_square_size = _tmp8_ + (2 * ((gint) (_tmp9_ + 0.5)));
#line 40 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	result = TRUE;
#line 40 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	return result;
#line 338 "chess-view-2d.c"
}


static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	RsvgHandle* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	RsvgHandle* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	RsvgHandle* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	RsvgHandle* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	RsvgHandle* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	RsvgHandle* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	cairo_t* _tmp46_ = NULL;
	GError * _inner_error_ = NULL;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (c1 != NULL);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (c2 != NULL);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (name != NULL);
#line 385 "chess-view-2d.c"
	{
		RsvgHandle* _tmp0_ = NULL;
		ChessScene* _tmp1_ = NULL;
		ChessScene* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		RsvgHandle* _tmp10_ = NULL;
		RsvgHandle* _tmp11_ = NULL;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp1_ = chess_view_get_scene ((ChessView*) self);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp2_ = _tmp1_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp3_ = chess_scene_get_theme_name (_tmp2_);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp4_ = _tmp3_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp5_ = name;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp6_ = g_strconcat (_tmp5_, ".svg", NULL);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp7_ = _tmp6_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp8_ = g_build_filename (PKGDATADIR, "pieces", _tmp4_, _tmp7_, NULL, NULL);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp9_ = _tmp8_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp10_ = rsvg_handle_new_from_file (_tmp9_, &_inner_error_);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp11_ = _tmp10_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_g_free0 (_tmp9_);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_g_free0 (_tmp7_);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp0_ = _tmp11_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		if (_inner_error_ != NULL) {
#line 429 "chess-view-2d.c"
			goto __catch17_g_error;
		}
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_g_object_unref0 (handle);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		handle = _tmp0_;
#line 436 "chess-view-2d.c"
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		e = _inner_error_;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_inner_error_ = NULL;
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp12_ = stderr;
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp13_ = e;
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp14_ = _tmp13_->message;
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		fprintf (_tmp12_, "Failed to load piece svg: %s", _tmp14_);
#line 53 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_g_error_free0 (e);
#line 53 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_g_object_unref0 (handle);
#line 53 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		return;
#line 463 "chess-view-2d.c"
	}
	__finally17:
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_inner_error_ != NULL) {
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_g_object_unref0 (handle);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		g_clear_error (&_inner_error_);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		return;
#line 476 "chess-view-2d.c"
	}
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp15_ = c1;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_save (_tmp15_);
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp16_ = c1;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp17_ = self->priv->square_size;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp18_ = offset;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_translate (_tmp16_, (gdouble) (_tmp17_ * _tmp18_), (gdouble) 0);
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp19_ = c1;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp20_ = self->priv->square_size;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp21_ = handle;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_object_get (_tmp21_, "width", &_tmp22_, NULL);
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp23_ = _tmp22_;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp24_ = self->priv->square_size;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp25_ = handle;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_object_get (_tmp25_, "height", &_tmp26_, NULL);
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp27_ = _tmp26_;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_scale (_tmp19_, ((gdouble) _tmp20_) / _tmp23_, ((gdouble) _tmp24_) / _tmp27_);
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp28_ = handle;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp29_ = c1;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	rsvg_handle_render_cairo (_tmp28_, _tmp29_);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp30_ = c1;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_restore (_tmp30_);
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp31_ = c2;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_save (_tmp31_);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp32_ = c2;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp33_ = self->priv->selected_square_size;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp34_ = offset;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_translate (_tmp32_, (gdouble) (_tmp33_ * _tmp34_), (gdouble) 0);
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp35_ = c2;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp36_ = self->priv->selected_square_size;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp37_ = handle;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_object_get (_tmp37_, "width", &_tmp38_, NULL);
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp39_ = _tmp38_;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp40_ = self->priv->selected_square_size;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp41_ = handle;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_object_get (_tmp41_, "height", &_tmp42_, NULL);
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp43_ = _tmp42_;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_scale (_tmp35_, ((gdouble) _tmp36_) / _tmp39_, ((gdouble) _tmp40_) / _tmp43_);
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp44_ = handle;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp45_ = c2;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	rsvg_handle_render_cairo (_tmp44_, _tmp45_);
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp46_ = c2;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_restore (_tmp46_);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_g_object_unref0 (handle);
#line 564 "chess-view-2d.c"
}


static void chess_view2_d_load_theme (ChessView2D* self, cairo_t* c) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_ = NULL;
	ChessScene* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	cairo_surface_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	cairo_surface_t* _tmp20_ = NULL;
	cairo_t* c1 = NULL;
	cairo_surface_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* c2 = NULL;
	cairo_surface_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	cairo_t* _tmp39_ = NULL;
	cairo_t* _tmp40_ = NULL;
	cairo_t* _tmp41_ = NULL;
	cairo_t* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	cairo_t* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	cairo_t* _tmp46_ = NULL;
	cairo_t* _tmp47_ = NULL;
	cairo_t* _tmp48_ = NULL;
	ChessScene* _tmp49_ = NULL;
	ChessScene* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (c != NULL);
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp3_ = _tmp2_;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp5_ = _tmp4_;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp6_ = self->priv->loaded_theme_name;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
#line 637 "chess-view-2d.c"
		cairo_surface_t* _tmp7_ = NULL;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp7_ = self->priv->model_surface;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp1_ = _tmp7_ != NULL;
#line 643 "chess-view-2d.c"
	} else {
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp1_ = FALSE;
#line 647 "chess-view-2d.c"
	}
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp8_ = _tmp1_;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp8_) {
#line 653 "chess-view-2d.c"
		gint _tmp9_ = 0;
		cairo_surface_t* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp9_ = self->priv->square_size;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp10_ = self->priv->model_surface;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp11_ = cairo_image_surface_get_height (_tmp10_);
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp0_ = _tmp9_ == _tmp11_;
#line 665 "chess-view-2d.c"
	} else {
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp0_ = FALSE;
#line 669 "chess-view-2d.c"
	}
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp12_ = _tmp0_;
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp12_) {
#line 73 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		return;
#line 677 "chess-view-2d.c"
	}
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp13_ = self->priv->square_size;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp14_ = self->priv->square_size;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp13_, _tmp14_);
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_cairo_surface_destroy0 (self->priv->model_surface);
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv->model_surface = _tmp15_;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp16_ = c;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp17_ = cairo_get_target (_tmp16_);
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp18_ = self->priv->selected_square_size;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp19_ = self->priv->selected_square_size;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp20_ = cairo_surface_create_similar (_tmp17_, CAIRO_CONTENT_COLOR_ALPHA, 12 * _tmp18_, _tmp19_);
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv->selected_model_surface = _tmp20_;
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp21_ = self->priv->model_surface;
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp22_ = cairo_create (_tmp21_);
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	c1 = _tmp22_;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp23_ = self->priv->selected_model_surface;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp24_ = cairo_create (_tmp23_);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	c2 = _tmp24_;
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp25_ = c1;
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp26_ = c2;
#line 80 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp25_, _tmp26_, "whitePawn", 0);
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp27_ = c1;
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp28_ = c2;
#line 81 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp27_, _tmp28_, "whiteRook", 1);
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp29_ = c1;
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp30_ = c2;
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp29_, _tmp30_, "whiteKnight", 2);
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp31_ = c1;
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp32_ = c2;
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp31_, _tmp32_, "whiteBishop", 3);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp33_ = c1;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp34_ = c2;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp33_, _tmp34_, "whiteQueen", 4);
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp35_ = c1;
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp36_ = c2;
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp35_, _tmp36_, "whiteKing", 5);
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp37_ = c1;
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp38_ = c2;
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp37_, _tmp38_, "blackPawn", 6);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp39_ = c1;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp40_ = c2;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp39_, _tmp40_, "blackRook", 7);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp41_ = c1;
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp42_ = c2;
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp41_, _tmp42_, "blackKnight", 8);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp43_ = c1;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp44_ = c2;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp43_, _tmp44_, "blackBishop", 9);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp45_ = c1;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp46_ = c2;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp45_, _tmp46_, "blackQueen", 10);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp47_ = c1;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp48_ = c2;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_render_piece (self, _tmp47_, _tmp48_, "blackKing", 11);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp49_ = chess_view_get_scene ((ChessView*) self);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp50_ = _tmp49_;
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp51_ = chess_scene_get_theme_name (_tmp50_);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp52_ = _tmp51_;
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp53_ = g_strdup (_tmp52_);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_g_free0 (self->priv->loaded_theme_name);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv->loaded_theme_name = _tmp53_;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_cairo_destroy0 (c2);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_cairo_destroy0 (c1);
#line 805 "chess-view-2d.c"
}


static gpointer _chess_model_ref0 (gpointer self) {
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	return self ? chess_model_ref (self) : NULL;
#line 812 "chess-view-2d.c"
}


static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView2D * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	ChessScene* _tmp5_ = NULL;
	ChessScene* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gint board_size = 0;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	ChessScene* _tmp42_ = NULL;
	ChessScene* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	ChessScene* _tmp188_ = NULL;
	ChessScene* _tmp189_ = NULL;
	ChessGame* _tmp190_ = NULL;
	ChessGame* _tmp191_ = NULL;
	gboolean _tmp192_ = FALSE;
	gboolean _tmp193_ = FALSE;
	ChessScene* _tmp200_ = NULL;
	ChessScene* _tmp201_ = NULL;
	GList* _tmp202_ = NULL;
#line 96 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self = (ChessView2D*) base;
#line 96 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp0_ = c;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_load_theme (self, _tmp0_);
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp1_ = c;
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_translate (_tmp1_, (gdouble) (_tmp2_ / 2), (gdouble) (_tmp3_ / 2));
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp4_ = c;
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp5_ = chess_view_get_scene ((ChessView*) self);
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp6_ = _tmp5_;
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp7_ = chess_scene_get_board_angle (_tmp6_);
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp8_ = _tmp7_;
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_rotate (_tmp4_, (G_PI * _tmp8_) / 180.0);
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp9_ = self->priv->square_size;
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp10_ = chess_view2_d_get_border_size (self);
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp11_ = _tmp10_;
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp12_ = ceil ((_tmp9_ * 4) + _tmp11_);
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	board_size = (gint) _tmp12_;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp13_ = c;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_set_source_rgb (_tmp13_, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp14_ = c;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp15_ = board_size;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp16_ = board_size;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp17_ = board_size;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp18_ = board_size;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_rectangle (_tmp14_, (gdouble) (-_tmp15_), (gdouble) (-_tmp16_), (gdouble) (_tmp17_ * 2), (gdouble) (_tmp18_ * 2));
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp19_ = c;
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_fill (_tmp19_);
#line 911 "chess-view-2d.c"
	{
		gint file = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		file = 0;
#line 916 "chess-view-2d.c"
		{
			gboolean _tmp20_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp20_ = TRUE;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			while (TRUE) {
#line 923 "chess-view-2d.c"
				gboolean _tmp21_ = FALSE;
				gint _tmp23_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp21_ = _tmp20_;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (!_tmp21_) {
#line 930 "chess-view-2d.c"
					gint _tmp22_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp22_ = file;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					file = _tmp22_ + 1;
#line 936 "chess-view-2d.c"
				}
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp20_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp23_ = file;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (!(_tmp23_ < 8)) {
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					break;
#line 946 "chess-view-2d.c"
				}
				{
					gint rank = 0;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					rank = 0;
#line 952 "chess-view-2d.c"
					{
						gboolean _tmp24_ = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
						_tmp24_ = TRUE;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
						while (TRUE) {
#line 959 "chess-view-2d.c"
							gboolean _tmp25_ = FALSE;
							gint _tmp27_ = 0;
							gint x = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint y = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							cairo_t* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							cairo_t* _tmp41_ = NULL;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp25_ = _tmp24_;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							if (!_tmp25_) {
#line 980 "chess-view-2d.c"
								gint _tmp26_ = 0;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp26_ = rank;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								rank = _tmp26_ + 1;
#line 986 "chess-view-2d.c"
							}
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp24_ = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp27_ = rank;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							if (!(_tmp27_ < 8)) {
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								break;
#line 996 "chess-view-2d.c"
							}
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp28_ = file;
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp29_ = self->priv->square_size;
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							x = (gint) ((_tmp28_ - 4) * _tmp29_);
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp30_ = rank;
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp31_ = self->priv->square_size;
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							y = (gint) ((3 - _tmp30_) * _tmp31_);
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp32_ = c;
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp33_ = x;
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp34_ = y;
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp35_ = self->priv->square_size;
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp36_ = self->priv->square_size;
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							cairo_rectangle (_tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_, (gdouble) _tmp35_, (gdouble) _tmp36_);
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp37_ = file;
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp38_ = rank;
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							if (((_tmp37_ + _tmp38_) % 2) == 0) {
#line 1028 "chess-view-2d.c"
								cairo_t* _tmp39_ = NULL;
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp39_ = c;
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								cairo_set_source_rgb (_tmp39_, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
#line 1034 "chess-view-2d.c"
							} else {
								cairo_t* _tmp40_ = NULL;
#line 120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp40_ = c;
#line 120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								cairo_set_source_rgb (_tmp40_, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
#line 1041 "chess-view-2d.c"
							}
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp41_ = c;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							cairo_fill (_tmp41_);
#line 1047 "chess-view-2d.c"
						}
					}
				}
			}
		}
	}
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp42_ = chess_view_get_scene ((ChessView*) self);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp43_ = _tmp42_;
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp44_ = chess_scene_get_show_numbering (_tmp43_);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp45_ = _tmp44_;
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp45_) {
#line 1064 "chess-view-2d.c"
		cairo_t* _tmp46_ = NULL;
		cairo_t* _tmp47_ = NULL;
		gdouble _tmp48_ = 0.0;
		gdouble _tmp49_ = 0.0;
		cairo_t* _tmp50_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp51_ = NULL;
		cairo_text_extents_t _tmp52_ = {0};
		gdouble y_offset = 0.0;
		gint _tmp53_ = 0;
		cairo_text_extents_t _tmp54_ = {0};
		gdouble _tmp55_ = 0.0;
		cairo_text_extents_t _tmp56_ = {0};
		gdouble _tmp57_ = 0.0;
		cairo_text_extents_t _tmp58_ = {0};
		gdouble _tmp59_ = 0.0;
		gdouble top = 0.0;
		gint _tmp60_ = 0;
		gdouble _tmp61_ = 0.0;
		gdouble bottom = 0.0;
		gint _tmp62_ = 0;
		gdouble _tmp63_ = 0.0;
		gdouble _tmp64_ = 0.0;
		gdouble _tmp65_ = 0.0;
		gdouble file_offset = 0.0;
		gint _tmp66_ = 0;
		gdouble rank_offset = 0.0;
		gint _tmp67_ = 0;
		gchar** files = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gchar** ranks = NULL;
		gint ranks_length1 = 0;
		gint _ranks_size_ = 0;
		cairo_matrix_t matrix = {0};
		cairo_t* _tmp68_ = NULL;
		cairo_matrix_t _tmp69_ = {0};
		ChessScene* _tmp70_ = NULL;
		ChessScene* _tmp71_ = NULL;
		gdouble _tmp72_ = 0.0;
		gdouble _tmp73_ = 0.0;
		cairo_t* _tmp110_ = NULL;
		cairo_t* _tmp111_ = NULL;
		cairo_matrix_t _tmp112_ = {0};
		cairo_t* _tmp187_ = NULL;
#line 130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp46_ = c;
#line 130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_set_source_rgb (_tmp46_, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp47_ = c;
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp48_ = chess_view2_d_get_border_size (self);
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp49_ = _tmp48_;
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_set_font_size (_tmp47_, _tmp49_ * 0.6);
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp50_ = c;
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_select_font_face (_tmp50_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp51_ = c;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_text_extents (_tmp51_, "abcdefgh", &_tmp52_);
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		extents = _tmp52_;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp53_ = self->priv->square_size;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp54_ = extents;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp55_ = _tmp54_.height;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp56_ = extents;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp57_ = _tmp56_.height;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp58_ = extents;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp59_ = _tmp58_.y_bearing;
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		y_offset = ((((_tmp53_ / 2) - _tmp55_) / 2) + _tmp57_) + _tmp59_;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp60_ = self->priv->square_size;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp61_ = y_offset;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		top = -((_tmp60_ * 4) + _tmp61_);
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp62_ = self->priv->square_size;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp63_ = chess_view2_d_get_border_size (self);
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp64_ = _tmp63_;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp65_ = y_offset;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		bottom = ((_tmp62_ * 4) + _tmp64_) - _tmp65_;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp66_ = self->priv->square_size;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		file_offset = -(_tmp66_ * 3.5);
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp67_ = self->priv->square_size;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		rank_offset = -(_tmp67_ * 3.5);
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp68_ = c;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_get_matrix (_tmp68_, &_tmp69_);
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		matrix = _tmp69_;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp70_ = chess_view_get_scene ((ChessView*) self);
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp71_ = _tmp70_;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp72_ = chess_scene_get_board_angle (_tmp71_);
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp73_ = _tmp72_;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		if (_tmp73_ == 180.0) {
#line 1188 "chess-view-2d.c"
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_ = NULL;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			gchar** _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
			gchar** _tmp91_ = NULL;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp74_ = g_strdup ("h");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp75_ = g_strdup ("g");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp76_ = g_strdup ("f");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp77_ = g_strdup ("e");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp78_ = g_strdup ("d");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp79_ = g_strdup ("c");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp80_ = g_strdup ("b");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp81_ = g_strdup ("a");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_ = g_new0 (gchar*, 8 + 1);
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[0] = _tmp74_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[1] = _tmp75_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[2] = _tmp76_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[3] = _tmp77_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[4] = _tmp78_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[5] = _tmp79_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[6] = _tmp80_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp82_[7] = _tmp81_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			files = _tmp82_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			files_length1 = 8;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_files_size_ = files_length1;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp83_ = g_strdup ("1");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp84_ = g_strdup ("2");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp85_ = g_strdup ("3");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp86_ = g_strdup ("4");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp87_ = g_strdup ("5");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp88_ = g_strdup ("6");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp89_ = g_strdup ("7");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp90_ = g_strdup ("8");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_ = g_new0 (gchar*, 8 + 1);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[0] = _tmp83_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[1] = _tmp84_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[2] = _tmp85_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[3] = _tmp86_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[4] = _tmp87_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[5] = _tmp88_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[6] = _tmp89_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp91_[7] = _tmp90_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			ranks = _tmp91_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			ranks_length1 = 8;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_ranks_size_ = ranks_length1;
#line 153 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			cairo_matrix_scale (&matrix, (gdouble) (-1), (gdouble) (-1));
#line 1293 "chess-view-2d.c"
		} else {
			gchar* _tmp92_ = NULL;
			gchar* _tmp93_ = NULL;
			gchar* _tmp94_ = NULL;
			gchar* _tmp95_ = NULL;
			gchar* _tmp96_ = NULL;
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar** _tmp100_ = NULL;
			gchar* _tmp101_ = NULL;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_ = NULL;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gchar** _tmp109_ = NULL;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp92_ = g_strdup ("a");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp93_ = g_strdup ("b");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp94_ = g_strdup ("c");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp95_ = g_strdup ("d");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp96_ = g_strdup ("e");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp97_ = g_strdup ("f");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp98_ = g_strdup ("g");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp99_ = g_strdup ("h");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_ = g_new0 (gchar*, 8 + 1);
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[0] = _tmp92_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[1] = _tmp93_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[2] = _tmp94_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[3] = _tmp95_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[4] = _tmp96_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[5] = _tmp97_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[6] = _tmp98_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp100_[7] = _tmp99_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			files = _tmp100_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			files_length1 = 8;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_files_size_ = files_length1;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp101_ = g_strdup ("8");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp102_ = g_strdup ("7");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp103_ = g_strdup ("6");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp104_ = g_strdup ("5");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp105_ = g_strdup ("4");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp106_ = g_strdup ("3");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp107_ = g_strdup ("2");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp108_ = g_strdup ("1");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_ = g_new0 (gchar*, 8 + 1);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[0] = _tmp101_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[1] = _tmp102_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[2] = _tmp103_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[3] = _tmp104_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[4] = _tmp105_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[5] = _tmp106_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[6] = _tmp107_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp109_[7] = _tmp108_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			ranks = _tmp109_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			ranks_length1 = 8;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_ranks_size_ = ranks_length1;
#line 1397 "chess-view-2d.c"
		}
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp110_ = c;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_save (_tmp110_);
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp111_ = c;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp112_ = matrix;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_set_matrix (_tmp111_, &_tmp112_);
#line 1409 "chess-view-2d.c"
		{
			gint i = 0;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			i = 0;
#line 1414 "chess-view-2d.c"
			{
				gboolean _tmp113_ = FALSE;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp113_ = TRUE;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				while (TRUE) {
#line 1421 "chess-view-2d.c"
					gboolean _tmp114_ = FALSE;
					gint _tmp116_ = 0;
					cairo_t* _tmp117_ = NULL;
					gchar** _tmp118_ = NULL;
					gint _tmp118__length1 = 0;
					gint _tmp119_ = 0;
					const gchar* _tmp120_ = NULL;
					cairo_text_extents_t _tmp121_ = {0};
					cairo_t* _tmp122_ = NULL;
					cairo_t* _tmp123_ = NULL;
					gdouble _tmp124_ = 0.0;
					cairo_text_extents_t _tmp125_ = {0};
					gdouble _tmp126_ = 0.0;
					gdouble _tmp127_ = 0.0;
					cairo_t* _tmp128_ = NULL;
					gchar** _tmp129_ = NULL;
					gint _tmp129__length1 = 0;
					gint _tmp130_ = 0;
					const gchar* _tmp131_ = NULL;
					cairo_t* _tmp132_ = NULL;
					cairo_t* _tmp133_ = NULL;
					cairo_t* _tmp134_ = NULL;
					gdouble _tmp135_ = 0.0;
					cairo_text_extents_t _tmp136_ = {0};
					gdouble _tmp137_ = 0.0;
					gdouble _tmp138_ = 0.0;
					cairo_t* _tmp139_ = NULL;
					gchar** _tmp140_ = NULL;
					gint _tmp140__length1 = 0;
					gint _tmp141_ = 0;
					const gchar* _tmp142_ = NULL;
					cairo_t* _tmp143_ = NULL;
					cairo_t* _tmp144_ = NULL;
					gchar** _tmp145_ = NULL;
					gint _tmp145__length1 = 0;
					gint _tmp146_ = 0;
					const gchar* _tmp147_ = NULL;
					cairo_text_extents_t _tmp148_ = {0};
					cairo_text_extents_t _tmp149_ = {0};
					gdouble _tmp150_ = 0.0;
					cairo_text_extents_t _tmp151_ = {0};
					gdouble _tmp152_ = 0.0;
					cairo_t* _tmp153_ = NULL;
					cairo_t* _tmp154_ = NULL;
					gint _tmp155_ = 0;
					gdouble _tmp156_ = 0.0;
					gdouble _tmp157_ = 0.0;
					gdouble _tmp158_ = 0.0;
					gdouble _tmp159_ = 0.0;
					cairo_text_extents_t _tmp160_ = {0};
					gdouble _tmp161_ = 0.0;
					gdouble _tmp162_ = 0.0;
					gdouble _tmp163_ = 0.0;
					cairo_t* _tmp164_ = NULL;
					gchar** _tmp165_ = NULL;
					gint _tmp165__length1 = 0;
					gint _tmp166_ = 0;
					const gchar* _tmp167_ = NULL;
					cairo_t* _tmp168_ = NULL;
					cairo_t* _tmp169_ = NULL;
					cairo_t* _tmp170_ = NULL;
					gint _tmp171_ = 0;
					gdouble _tmp172_ = 0.0;
					gdouble _tmp173_ = 0.0;
					cairo_text_extents_t _tmp174_ = {0};
					gdouble _tmp175_ = 0.0;
					gdouble _tmp176_ = 0.0;
					gdouble _tmp177_ = 0.0;
					cairo_t* _tmp178_ = NULL;
					gchar** _tmp179_ = NULL;
					gint _tmp179__length1 = 0;
					gint _tmp180_ = 0;
					const gchar* _tmp181_ = NULL;
					cairo_t* _tmp182_ = NULL;
					gdouble _tmp183_ = 0.0;
					gint _tmp184_ = 0;
					gdouble _tmp185_ = 0.0;
					gint _tmp186_ = 0;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp114_ = _tmp113_;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					if (!_tmp114_) {
#line 1504 "chess-view-2d.c"
						gint _tmp115_ = 0;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
						_tmp115_ = i;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
						i = _tmp115_ + 1;
#line 1510 "chess-view-2d.c"
					}
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp113_ = FALSE;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp116_ = i;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					if (!(_tmp116_ < 8)) {
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
						break;
#line 1520 "chess-view-2d.c"
					}
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp117_ = c;
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp118_ = ranks;
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp118__length1 = ranks_length1;
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp119_ = i;
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp120_ = _tmp118_[_tmp119_];
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_text_extents (_tmp117_, _tmp120_, &_tmp121_);
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					extents = _tmp121_;
#line 169 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp122_ = c;
#line 169 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_save (_tmp122_);
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp123_ = c;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp124_ = file_offset;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp125_ = extents;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp126_ = _tmp125_.width;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp127_ = top;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_move_to (_tmp123_, _tmp124_ - (_tmp126_ / 2), _tmp127_);
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp128_ = c;
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp129_ = files;
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp129__length1 = files_length1;
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp130_ = i;
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp131_ = _tmp129_[_tmp130_];
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_show_text (_tmp128_, _tmp131_);
#line 172 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp132_ = c;
#line 172 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_restore (_tmp132_);
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp133_ = c;
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_save (_tmp133_);
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp134_ = c;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp135_ = file_offset;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp136_ = extents;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp137_ = _tmp136_.width;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp138_ = bottom;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_move_to (_tmp134_, _tmp135_ - (_tmp137_ / 2), _tmp138_);
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp139_ = c;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp140_ = files;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp140__length1 = files_length1;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp141_ = i;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp142_ = _tmp140_[_tmp141_];
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_show_text (_tmp139_, _tmp142_);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp143_ = c;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_restore (_tmp143_);
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp144_ = c;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp145_ = ranks;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp145__length1 = ranks_length1;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp146_ = i;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp147_ = _tmp145_[_tmp146_];
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_text_extents (_tmp144_, _tmp147_, &_tmp148_);
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					extents = _tmp148_;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp149_ = extents;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp150_ = _tmp149_.y_bearing;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp151_ = extents;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp152_ = _tmp151_.height;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					y_offset = -(_tmp150_ + (_tmp152_ / 2));
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp153_ = c;
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_save (_tmp153_);
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp154_ = c;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp155_ = self->priv->square_size;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp156_ = chess_view2_d_get_border_size (self);
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp157_ = _tmp156_;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp158_ = chess_view2_d_get_border_size (self);
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp159_ = _tmp158_;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp160_ = extents;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp161_ = _tmp160_.width;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp162_ = rank_offset;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp163_ = y_offset;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_move_to (_tmp154_, -(((((gdouble) _tmp155_) * 4) + _tmp157_) - ((_tmp159_ - _tmp161_) / 2)), _tmp162_ + _tmp163_);
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp164_ = c;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp165_ = ranks;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp165__length1 = ranks_length1;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp166_ = i;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp167_ = _tmp165_[_tmp166_];
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_show_text (_tmp164_, _tmp167_);
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp168_ = c;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_restore (_tmp168_);
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp169_ = c;
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_save (_tmp169_);
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp170_ = c;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp171_ = self->priv->square_size;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp172_ = chess_view2_d_get_border_size (self);
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp173_ = _tmp172_;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp174_ = extents;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp175_ = _tmp174_.width;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp176_ = rank_offset;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp177_ = y_offset;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_move_to (_tmp170_, (((gdouble) _tmp171_) * 4) + ((_tmp173_ - _tmp175_) / 2), _tmp176_ + _tmp177_);
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp178_ = c;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp179_ = ranks;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp179__length1 = ranks_length1;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp180_ = i;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp181_ = _tmp179_[_tmp180_];
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_show_text (_tmp178_, _tmp181_);
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp182_ = c;
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					cairo_restore (_tmp182_);
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp183_ = file_offset;
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp184_ = self->priv->square_size;
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					file_offset = _tmp183_ + _tmp184_;
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp185_ = rank_offset;
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp186_ = self->priv->square_size;
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					rank_offset = _tmp185_ + _tmp186_;
#line 1716 "chess-view-2d.c"
				}
			}
		}
#line 199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp187_ = c;
#line 199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_restore (_tmp187_);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 1728 "chess-view-2d.c"
	}
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp188_ = chess_view_get_scene ((ChessView*) self);
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp189_ = _tmp188_;
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp190_ = chess_scene_get_game (_tmp189_);
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp191_ = _tmp190_;
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp192_ = chess_game_get_is_superpaused (_tmp191_);
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp193_ = _tmp192_;
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp193_) {
#line 1744 "chess-view-2d.c"
		cairo_t* _tmp194_ = NULL;
		ChessScene* _tmp195_ = NULL;
		ChessScene* _tmp196_ = NULL;
		gdouble _tmp197_ = 0.0;
		gdouble _tmp198_ = 0.0;
		cairo_t* _tmp199_ = NULL;
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp194_ = c;
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp195_ = chess_view_get_scene ((ChessView*) self);
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp196_ = _tmp195_;
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp197_ = chess_scene_get_board_angle (_tmp196_);
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp198_ = _tmp197_;
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		cairo_rotate (_tmp194_, (G_PI * _tmp198_) / 180.0);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp199_ = c;
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		chess_view_draw_paused_overlay ((ChessView*) self, _tmp199_);
#line 207 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		result = TRUE;
#line 207 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		return result;
#line 1771 "chess-view-2d.c"
	}
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp200_ = chess_view_get_scene ((ChessView*) self);
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp201_ = _tmp200_;
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp202_ = _tmp201_->pieces;
#line 1779 "chess-view-2d.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		model_collection = _tmp202_;
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1787 "chess-view-2d.c"
			ChessModel* _tmp203_ = NULL;
			ChessModel* model = NULL;
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp203_ = _chess_model_ref0 ((ChessModel*) model_it->data);
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			model = _tmp203_;
#line 1794 "chess-view-2d.c"
			{
				cairo_t* _tmp204_ = NULL;
				cairo_t* _tmp205_ = NULL;
				ChessModel* _tmp206_ = NULL;
				gdouble _tmp207_ = 0.0;
				gint _tmp208_ = 0;
				ChessModel* _tmp209_ = NULL;
				gdouble _tmp210_ = 0.0;
				gint _tmp211_ = 0;
				cairo_t* _tmp212_ = NULL;
				gint _tmp213_ = 0;
				gint _tmp214_ = 0;
				cairo_t* _tmp215_ = NULL;
				ChessScene* _tmp216_ = NULL;
				ChessScene* _tmp217_ = NULL;
				gdouble _tmp218_ = 0.0;
				gdouble _tmp219_ = 0.0;
				cairo_surface_t* _tmp220_ = NULL;
				ChessModel* _tmp221_ = NULL;
				gboolean _tmp222_ = FALSE;
				gint _tmp225_ = 0;
				ChessModel* _tmp226_ = NULL;
				gboolean _tmp227_ = FALSE;
				gdouble _tmp230_ = 0.0;
				gboolean _tmp231_ = FALSE;
				ChessModel* _tmp232_ = NULL;
				gboolean _tmp233_ = FALSE;
				gboolean _tmp238_ = FALSE;
				cairo_t* _tmp239_ = NULL;
				cairo_surface_t* _tmp240_ = NULL;
				gint _tmp241_ = 0;
				ChessModel* _tmp242_ = NULL;
				ChessPiece* _tmp243_ = NULL;
				gdouble _tmp244_ = 0.0;
				cairo_t* _tmp245_ = NULL;
#line 213 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp204_ = c;
#line 213 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				cairo_save (_tmp204_);
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp205_ = c;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp206_ = model;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp207_ = _tmp206_->x;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp208_ = self->priv->square_size;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp209_ = model;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp210_ = _tmp209_->y;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp211_ = self->priv->square_size;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				cairo_translate (_tmp205_, (_tmp207_ - 4) * _tmp208_, (3 - _tmp210_) * _tmp211_);
#line 215 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp212_ = c;
#line 215 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp213_ = self->priv->square_size;
#line 215 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp214_ = self->priv->square_size;
#line 215 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				cairo_translate (_tmp212_, (gdouble) (_tmp213_ / 2), (gdouble) (_tmp214_ / 2));
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp215_ = c;
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp216_ = chess_view_get_scene ((ChessView*) self);
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp217_ = _tmp216_;
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp218_ = chess_scene_get_board_angle (_tmp217_);
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp219_ = _tmp218_;
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				cairo_rotate (_tmp215_, ((-G_PI) * _tmp219_) / 180.0);
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp221_ = model;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp222_ = _tmp221_->is_selected;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (_tmp222_) {
#line 1876 "chess-view-2d.c"
					cairo_surface_t* _tmp223_ = NULL;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp223_ = self->priv->selected_model_surface;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp220_ = _tmp223_;
#line 1882 "chess-view-2d.c"
				} else {
					cairo_surface_t* _tmp224_ = NULL;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp224_ = self->priv->model_surface;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp220_ = _tmp224_;
#line 1889 "chess-view-2d.c"
				}
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp226_ = model;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp227_ = _tmp226_->is_selected;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (_tmp227_) {
#line 1897 "chess-view-2d.c"
					gint _tmp228_ = 0;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp228_ = self->priv->selected_square_size;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp225_ = _tmp228_;
#line 1903 "chess-view-2d.c"
				} else {
					gint _tmp229_ = 0;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp229_ = self->priv->square_size;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp225_ = _tmp229_;
#line 1910 "chess-view-2d.c"
				}
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp232_ = model;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp233_ = _tmp232_->under_threat;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (_tmp233_) {
#line 1918 "chess-view-2d.c"
					ChessScene* _tmp234_ = NULL;
					ChessScene* _tmp235_ = NULL;
					gboolean _tmp236_ = FALSE;
					gboolean _tmp237_ = FALSE;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp234_ = chess_view_get_scene ((ChessView*) self);
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp235_ = _tmp234_;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp236_ = chess_scene_get_show_move_hints (_tmp235_);
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp237_ = _tmp236_;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp231_ = _tmp237_;
#line 1933 "chess-view-2d.c"
				} else {
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp231_ = FALSE;
#line 1937 "chess-view-2d.c"
				}
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp238_ = _tmp231_;
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (_tmp238_) {
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp230_ = 0.8;
#line 1945 "chess-view-2d.c"
				} else {
#line 221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp230_ = 1.0;
#line 1949 "chess-view-2d.c"
				}
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp239_ = c;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp240_ = _tmp220_;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp241_ = _tmp225_;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp242_ = model;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp243_ = _tmp242_->piece;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp244_ = _tmp230_;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				chess_view2_d_draw_piece (self, _tmp239_, _tmp240_, _tmp241_, _tmp243_, _tmp244_);
#line 223 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp245_ = c;
#line 223 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				cairo_restore (_tmp245_);
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_chess_model_unref0 (model);
#line 1971 "chess-view-2d.c"
			}
		}
	}
	{
		gint rank = 0;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		rank = 0;
#line 1979 "chess-view-2d.c"
		{
			gboolean _tmp246_ = FALSE;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			_tmp246_ = TRUE;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
			while (TRUE) {
#line 1986 "chess-view-2d.c"
				gboolean _tmp247_ = FALSE;
				gint _tmp249_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp247_ = _tmp246_;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (!_tmp247_) {
#line 1993 "chess-view-2d.c"
					gint _tmp248_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					_tmp248_ = rank;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					rank = _tmp248_ + 1;
#line 1999 "chess-view-2d.c"
				}
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp246_ = FALSE;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				_tmp249_ = rank;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
				if (!(_tmp249_ < 8)) {
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					break;
#line 2009 "chess-view-2d.c"
				}
				{
					gint file = 0;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
					file = 0;
#line 2015 "chess-view-2d.c"
					{
						gboolean _tmp250_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
						_tmp250_ = TRUE;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
						while (TRUE) {
#line 2022 "chess-view-2d.c"
							gboolean _tmp251_ = FALSE;
							gint _tmp253_ = 0;
							gboolean _tmp254_ = FALSE;
							ChessScene* _tmp255_ = NULL;
							ChessScene* _tmp256_ = NULL;
							gboolean _tmp257_ = FALSE;
							gboolean _tmp258_ = FALSE;
							gboolean _tmp264_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp251_ = _tmp250_;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							if (!_tmp251_) {
#line 2035 "chess-view-2d.c"
								gint _tmp252_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp252_ = file;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								file = _tmp252_ + 1;
#line 2041 "chess-view-2d.c"
							}
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp250_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp253_ = file;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							if (!(_tmp253_ < 8)) {
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								break;
#line 2051 "chess-view-2d.c"
							}
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp255_ = chess_view_get_scene ((ChessView*) self);
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp256_ = _tmp255_;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp257_ = chess_scene_get_show_move_hints (_tmp256_);
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp258_ = _tmp257_;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							if (_tmp258_) {
#line 2063 "chess-view-2d.c"
								ChessScene* _tmp259_ = NULL;
								ChessScene* _tmp260_ = NULL;
								gint _tmp261_ = 0;
								gint _tmp262_ = 0;
								gboolean _tmp263_ = FALSE;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp259_ = chess_view_get_scene ((ChessView*) self);
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp260_ = _tmp259_;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp261_ = rank;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp262_ = file;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp263_ = chess_scene_can_move (_tmp260_, _tmp261_, _tmp262_);
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp254_ = _tmp263_;
#line 2081 "chess-view-2d.c"
							} else {
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp254_ = FALSE;
#line 2085 "chess-view-2d.c"
							}
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							_tmp264_ = _tmp254_;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
							if (_tmp264_) {
#line 2091 "chess-view-2d.c"
								cairo_t* _tmp265_ = NULL;
								cairo_t* _tmp266_ = NULL;
								gint _tmp267_ = 0;
								gint _tmp268_ = 0;
								gint _tmp269_ = 0;
								gint _tmp270_ = 0;
								cairo_t* _tmp271_ = NULL;
								gint _tmp272_ = 0;
								gint _tmp273_ = 0;
								cairo_t* _tmp274_ = NULL;
								ChessScene* _tmp275_ = NULL;
								ChessScene* _tmp276_ = NULL;
								gdouble _tmp277_ = 0.0;
								gdouble _tmp278_ = 0.0;
								cairo_t* _tmp279_ = NULL;
								cairo_surface_t* _tmp280_ = NULL;
								gint _tmp281_ = 0;
								ChessScene* _tmp282_ = NULL;
								ChessScene* _tmp283_ = NULL;
								ChessPiece* _tmp284_ = NULL;
								ChessPiece* _tmp285_ = NULL;
								cairo_t* _tmp286_ = NULL;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp265_ = c;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								cairo_save (_tmp265_);
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp266_ = c;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp267_ = file;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp268_ = self->priv->square_size;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp269_ = rank;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp270_ = self->priv->square_size;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								cairo_translate (_tmp266_, (gdouble) ((_tmp267_ - 4) * _tmp268_), (gdouble) ((3 - _tmp269_) * _tmp270_));
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp271_ = c;
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp272_ = self->priv->square_size;
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp273_ = self->priv->square_size;
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								cairo_translate (_tmp271_, (gdouble) (_tmp272_ / 2), (gdouble) (_tmp273_ / 2));
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp274_ = c;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp275_ = chess_view_get_scene ((ChessView*) self);
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp276_ = _tmp275_;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp277_ = chess_scene_get_board_angle (_tmp276_);
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp278_ = _tmp277_;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								cairo_rotate (_tmp274_, ((-G_PI) * _tmp278_) / 180.0);
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp279_ = c;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp280_ = self->priv->model_surface;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp281_ = self->priv->square_size;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp282_ = chess_view_get_scene ((ChessView*) self);
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp283_ = _tmp282_;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp284_ = chess_scene_get_selected_piece (_tmp283_);
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp285_ = _tmp284_;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								chess_view2_d_draw_piece (self, _tmp279_, _tmp280_, _tmp281_, _tmp285_, 0.1);
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_chess_piece_unref0 (_tmp285_);
#line 240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								_tmp286_ = c;
#line 240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
								cairo_restore (_tmp286_);
#line 2172 "chess-view-2d.c"
							}
						}
					}
				}
			}
		}
	}
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	result = TRUE;
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	return result;
#line 2184 "chess-view-2d.c"
}


static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha) {
	cairo_t* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint offset = 0;
	ChessPiece* _tmp3_ = NULL;
	PieceType _tmp4_ = 0;
	ChessPiece* _tmp5_ = NULL;
	Color _tmp6_ = 0;
	Color _tmp7_ = 0;
	cairo_t* _tmp9_ = NULL;
	cairo_surface_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	cairo_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (self != NULL);
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (c != NULL);
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (surface != NULL);
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_if_fail (piece != NULL);
#line 250 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp0_ = c;
#line 250 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp1_ = size;
#line 250 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp2_ = size;
#line 250 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_translate (_tmp0_, (gdouble) ((-_tmp1_) / 2), (gdouble) ((-_tmp2_) / 2));
#line 252 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp3_ = piece;
#line 252 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp4_ = _tmp3_->type;
#line 252 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	offset = (gint) _tmp4_;
#line 253 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp5_ = piece;
#line 253 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp6_ = chess_piece_get_color (_tmp5_);
#line 253 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp7_ = _tmp6_;
#line 253 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp7_ == COLOR_BLACK) {
#line 2238 "chess-view-2d.c"
		gint _tmp8_ = 0;
#line 254 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp8_ = offset;
#line 254 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		offset = _tmp8_ + 6;
#line 2244 "chess-view-2d.c"
	}
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp9_ = c;
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp10_ = surface;
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp11_ = offset;
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp12_ = size;
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_set_source_surface (_tmp9_, _tmp10_, (gdouble) ((-_tmp11_) * _tmp12_), (gdouble) 0);
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp13_ = c;
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp14_ = size;
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp15_ = size;
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_rectangle (_tmp13_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp14_, (gdouble) _tmp15_);
#line 257 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp16_ = c;
#line 257 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_clip (_tmp16_);
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp17_ = c;
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp18_ = alpha;
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	cairo_paint_with_alpha (_tmp17_, _tmp18_);
#line 2274 "chess-view-2d.c"
}


static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_ = NULL;
	ChessScene* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gint file = 0;
	GdkEventButton _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gdouble _tmp21_ = 0.0;
	gint rank = 0;
	GdkEventButton _tmp22_ = {0};
	gdouble _tmp23_ = 0.0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gdouble _tmp27_ = 0.0;
	ChessScene* _tmp28_ = NULL;
	ChessScene* _tmp29_ = NULL;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gint _tmp37_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp43_ = FALSE;
	ChessScene* _tmp44_ = NULL;
	ChessScene* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
#line 261 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self = (ChessView2D*) base;
#line 261 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp3_ = _tmp2_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp4_ = chess_scene_get_game (_tmp3_);
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp5_ = _tmp4_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp5_ == NULL) {
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp1_ = TRUE;
#line 2334 "chess-view-2d.c"
	} else {
		GdkEventButton _tmp6_ = {0};
		guint _tmp7_ = 0U;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp6_ = *event;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp7_ = _tmp6_.button;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp1_ = _tmp7_ != ((guint) 1);
#line 2344 "chess-view-2d.c"
	}
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp8_ = _tmp1_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp8_) {
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp0_ = TRUE;
#line 2352 "chess-view-2d.c"
	} else {
		ChessScene* _tmp9_ = NULL;
		ChessScene* _tmp10_ = NULL;
		ChessGame* _tmp11_ = NULL;
		ChessGame* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp9_ = chess_view_get_scene ((ChessView*) self);
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp10_ = _tmp9_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp11_ = chess_scene_get_game (_tmp10_);
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp12_ = _tmp11_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp13_ = chess_game_get_is_paused (_tmp12_);
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp14_ = _tmp13_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp0_ = _tmp14_;
#line 2374 "chess-view-2d.c"
	}
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp15_ = _tmp0_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp15_) {
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		result = FALSE;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		return result;
#line 2384 "chess-view-2d.c"
	}
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp16_ = *event;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp17_ = _tmp16_.x;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp18_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp19_ = self->priv->square_size;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp20_ = self->priv->square_size;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp21_ = floor (((_tmp17_ - (0.5 * _tmp18_)) + (_tmp19_ * 4)) / _tmp20_);
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	file = (gint) _tmp21_;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp22_ = *event;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp23_ = _tmp22_.y;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp24_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp25_ = self->priv->square_size;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp26_ = self->priv->square_size;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp27_ = floor (((_tmp23_ - (0.5 * _tmp24_)) + (_tmp25_ * 4)) / _tmp26_);
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	rank = 7 - ((gint) _tmp27_);
#line 270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp28_ = chess_view_get_scene ((ChessView*) self);
#line 270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp29_ = _tmp28_;
#line 270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp30_ = chess_scene_get_board_angle (_tmp29_);
#line 270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp31_ = _tmp30_;
#line 270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp31_ == 180.0) {
#line 2424 "chess-view-2d.c"
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
#line 272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp32_ = rank;
#line 272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		rank = 7 - _tmp32_;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp33_ = file;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		file = 7 - _tmp33_;
#line 2435 "chess-view-2d.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp37_ = file;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp37_ < 0) {
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp36_ = TRUE;
#line 2443 "chess-view-2d.c"
	} else {
		gint _tmp38_ = 0;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp38_ = file;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp36_ = _tmp38_ >= 8;
#line 2450 "chess-view-2d.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp39_ = _tmp36_;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp39_) {
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp35_ = TRUE;
#line 2458 "chess-view-2d.c"
	} else {
		gint _tmp40_ = 0;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp40_ = rank;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp35_ = _tmp40_ < 0;
#line 2465 "chess-view-2d.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp41_ = _tmp35_;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp41_) {
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp34_ = TRUE;
#line 2473 "chess-view-2d.c"
	} else {
		gint _tmp42_ = 0;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp42_ = rank;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		_tmp34_ = _tmp42_ >= 8;
#line 2480 "chess-view-2d.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp43_ = _tmp34_;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	if (_tmp43_) {
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		result = FALSE;
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		return result;
#line 2490 "chess-view-2d.c"
	}
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp44_ = chess_view_get_scene ((ChessView*) self);
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp45_ = _tmp44_;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp46_ = file;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp47_ = rank;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_scene_select_square (_tmp45_, _tmp46_, _tmp47_);
#line 281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	result = TRUE;
#line 281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	return result;
#line 2506 "chess-view-2d.c"
}


static gdouble chess_view2_d_get_border_size (ChessView2D* self) {
	gdouble result;
	gint _tmp0_ = 0;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp0_ = self->priv->square_size;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	result = (gdouble) (_tmp0_ / 2);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	return result;
#line 2521 "chess-view-2d.c"
}


static void chess_view2_d_class_init (ChessView2DClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	chess_view2_d_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	g_type_class_add_private (klass, sizeof (ChessView2DPrivate));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view2_d_real_configure_event;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	GTK_WIDGET_CLASS (klass)->draw = chess_view2_d_real_draw;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view2_d_real_button_press_event;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view2_d_get_property;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_view2_d_finalize;
#line 2540 "chess-view-2d.c"
}


static void chess_view2_d_instance_init (ChessView2D * self) {
	gchar* _tmp0_ = NULL;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv = CHESS_VIEW2_D_GET_PRIVATE (self);
#line 13 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv->border = 6;
#line 18 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_tmp0_ = g_strdup ("");
#line 18 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self->priv->loaded_theme_name = _tmp0_;
#line 2554 "chess-view-2d.c"
}


static void chess_view2_d_finalize (GObject* obj) {
	ChessView2D * self;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW2_D, ChessView2D);
#line 16 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_cairo_surface_destroy0 (self->priv->model_surface);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
#line 18 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	_g_free0 (self->priv->loaded_theme_name);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	G_OBJECT_CLASS (chess_view2_d_parent_class)->finalize (obj);
#line 2570 "chess-view-2d.c"
}


GType chess_view2_d_get_type (void) {
	static volatile gsize chess_view2_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view2_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView2DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view2_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView2D), 0, (GInstanceInitFunc) chess_view2_d_instance_init, NULL };
		GType chess_view2_d_type_id;
		chess_view2_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView2D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view2_d_type_id__volatile, chess_view2_d_type_id);
	}
	return chess_view2_d_type_id__volatile;
}


static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView2D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW2_D, ChessView2D);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
	switch (property_id) {
#line 2591 "chess-view-2d.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-view-2d.vala"
		break;
#line 2597 "chess-view-2d.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



