/* chess-scene.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from chess-scene.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ParamSpecChessModel ParamSpecChessModel;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
#define __g_list_free__chess_model_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__chess_model_unref0_ (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _chess_game_unref0(var) ((var == NULL) ? NULL : (var = (chess_game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

struct _ParamSpecChessModel {
	GParamSpec parent_instance;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessScenePrivate {
	gboolean _can_move[64];
	GTimer* animation_timer;
	gdouble animation_time;
	guint animate_timeout_id;
	ChessGame* _game;
	gint _move_number;
	gboolean _show_numbering;
	gboolean _show_move_hints;
	gchar* _theme_name;
	gboolean _show_3d_smooth;
	gchar* _board_side;
	gchar* _move_format;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_model_parent_class = NULL;
static gpointer chess_scene_parent_class = NULL;

gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MODEL_DUMMY_PROPERTY
};
ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y);
ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y);
gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y);
gboolean chess_model_animate (ChessModel* self, gdouble timestep);
gboolean chess_model_get_moving (ChessModel* self);
static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target);
static void chess_model_finalize (ChessModel* obj);
GType chess_scene_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
#define CHESS_SCENE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_SCENE, ChessScenePrivate))
enum  {
	CHESS_SCENE_DUMMY_PROPERTY,
	CHESS_SCENE_GAME,
	CHESS_SCENE_MOVE_NUMBER,
	CHESS_SCENE_SHOW_NUMBERING,
	CHESS_SCENE_SHOW_MOVE_HINTS,
	CHESS_SCENE_THEME_NAME,
	CHESS_SCENE_SHOW_3D_SMOOTH,
	CHESS_SCENE_BOARD_SIDE,
	CHESS_SCENE_BOARD_ANGLE,
	CHESS_SCENE_MOVE_FORMAT
};
static void _chess_model_unref0_ (gpointer var);
static void _g_list_free__chess_model_unref0_ (GList* self);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
ChessGame* chess_scene_get_game (ChessScene* self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
gint chess_scene_get_move_number (ChessScene* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
GType chess_player_get_type (void) G_GNUC_CONST;
ChessPlayer* chess_game_get_current_player (ChessGame* self);
gboolean chess_player_get_local_human (ChessPlayer* self);
GType piece_type_get_type (void) G_GNUC_CONST;
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type);
static void chess_scene_update_board (ChessScene* self);
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move);
static void chess_scene_paused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game);
static void chess_scene_undo_cb (ChessScene* self, ChessGame* game);
static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece);
void chess_game_add_hold (ChessGame* self);
static gboolean chess_scene_animate_cb (ChessScene* self);
static gboolean _chess_scene_animate_cb_gsource_func (gpointer self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
void chess_game_remove_hold (ChessGame* self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void _chess_scene_paused_cb_chess_game_superpaused (ChessGame* _sender, gpointer self);
static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self);
static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
void chess_scene_set_move_number (ChessScene* self, gint value);
gboolean chess_scene_get_show_numbering (ChessScene* self);
void chess_scene_set_show_numbering (ChessScene* self, gboolean value);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
void chess_scene_set_show_move_hints (ChessScene* self, gboolean value);
const gchar* chess_scene_get_theme_name (ChessScene* self);
void chess_scene_set_theme_name (ChessScene* self, const gchar* value);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value);
const gchar* chess_scene_get_board_side (ChessScene* self);
void chess_scene_set_board_side (ChessScene* self, const gchar* value);
gdouble chess_scene_get_board_angle (ChessScene* self);
ChessPlayer* chess_game_get_black (ChessGame* self);
GType color_get_type (void) G_GNUC_CONST;
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_format (ChessScene* self, const gchar* value);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_scene_finalize (GObject* obj);
static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _chess_piece_ref0 (gpointer self) {
#line 28 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return self ? chess_piece_ref (self) : NULL;
#line 298 "chess-scene.c"
}


ChessModel* chess_model_construct (GType object_type, ChessPiece* piece, gdouble x, gdouble y) {
	ChessModel* self = NULL;
	ChessPiece* _tmp0_ = NULL;
	ChessPiece* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (piece != NULL, NULL);
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self = (ChessModel*) g_type_create_instance (object_type);
#line 28 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = piece;
#line 28 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _chess_piece_ref0 (_tmp0_);
#line 28 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_chess_piece_unref0 (self->piece);
#line 28 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->piece = _tmp1_;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = x;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->target_x = _tmp2_;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp3_ = self->target_x;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->x = _tmp3_;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp4_ = y;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->target_y = _tmp4_;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = self->target_y;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->y = _tmp5_;
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return self;
#line 340 "chess-scene.c"
}


ChessModel* chess_model_new (ChessPiece* piece, gdouble x, gdouble y) {
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return chess_model_construct (TYPE_CHESS_MODEL, piece, x, y);
#line 347 "chess-scene.c"
}


gboolean chess_model_move_to (ChessModel* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp5_ = FALSE;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = self->target_x;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = x;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp1_ == _tmp2_) {
#line 367 "chess-scene.c"
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp3_ = self->target_y;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp4_ = y;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 376 "chess-scene.c"
	} else {
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = FALSE;
#line 380 "chess-scene.c"
	}
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = _tmp0_;
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp5_) {
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		result = FALSE;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return result;
#line 390 "chess-scene.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp6_ = x;
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->target_x = _tmp6_;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp7_ = y;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->target_y = _tmp7_;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = TRUE;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 404 "chess-scene.c"
}


gboolean chess_model_animate (ChessModel* self, gdouble timestep) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
#line 44 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = chess_model_get_moving (self);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _tmp0_;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (!_tmp1_) {
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		result = FALSE;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return result;
#line 432 "chess-scene.c"
	}
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = timestep;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp3_ = self->x;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp4_ = self->target_x;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = chess_model_update_position (self, _tmp2_, _tmp3_, _tmp4_);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->x = _tmp5_;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp6_ = timestep;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp7_ = self->y;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp8_ = self->target_y;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp9_ = chess_model_update_position (self, _tmp6_, _tmp7_, _tmp8_);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->y = _tmp9_;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = TRUE;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 458 "chess-scene.c"
}


static gdouble chess_model_update_position (ChessModel* self, gdouble timestep, gdouble value, gdouble target) {
	gdouble result = 0.0;
	gdouble distance = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble step = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
#line 54 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = target;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = value;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = fabs (_tmp0_ - _tmp1_);
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	distance = _tmp2_;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp3_ = timestep;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	step = _tmp3_ * 4.0;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp4_ = step;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = distance;
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp4_ > _tmp5_) {
#line 494 "chess-scene.c"
		gdouble _tmp6_ = 0.0;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp6_ = distance;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		step = _tmp6_;
#line 500 "chess-scene.c"
	}
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp7_ = target;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp8_ = value;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp7_ > _tmp8_) {
#line 508 "chess-scene.c"
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp9_ = value;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp10_ = step;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		result = _tmp9_ + _tmp10_;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return result;
#line 519 "chess-scene.c"
	} else {
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp11_ = value;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp12_ = step;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		result = _tmp11_ - _tmp12_;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return result;
#line 531 "chess-scene.c"
	}
}


gboolean chess_model_get_moving (ChessModel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp5_ = FALSE;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = self->x;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = self->target_x;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp1_ != _tmp2_) {
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = TRUE;
#line 552 "chess-scene.c"
	} else {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp3_ = self->y;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp4_ = self->target_y;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = _tmp3_ != _tmp4_;
#line 562 "chess-scene.c"
	}
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = _tmp0_;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp5_;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 570 "chess-scene.c"
}


static void value_chess_model_init (GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	value->data[0].v_pointer = NULL;
#line 577 "chess-scene.c"
}


static void value_chess_model_free_value (GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (value->data[0].v_pointer) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_model_unref (value->data[0].v_pointer);
#line 586 "chess-scene.c"
	}
}


static void value_chess_model_copy_value (const GValue* src_value, GValue* dest_value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (src_value->data[0].v_pointer) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		dest_value->data[0].v_pointer = chess_model_ref (src_value->data[0].v_pointer);
#line 596 "chess-scene.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		dest_value->data[0].v_pointer = NULL;
#line 600 "chess-scene.c"
	}
}


static gpointer value_chess_model_peek_pointer (const GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return value->data[0].v_pointer;
#line 608 "chess-scene.c"
}


static gchar* value_chess_model_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (collect_values[0].v_pointer) {
#line 615 "chess-scene.c"
		ChessModel* object;
		object = collect_values[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		if (object->parent_instance.g_class == NULL) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 622 "chess-scene.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 626 "chess-scene.c"
		}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		value->data[0].v_pointer = chess_model_ref (object);
#line 630 "chess-scene.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		value->data[0].v_pointer = NULL;
#line 634 "chess-scene.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return NULL;
#line 638 "chess-scene.c"
}


static gchar* value_chess_model_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessModel** object_p;
	object_p = collect_values[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (!object_p) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 649 "chess-scene.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (!value->data[0].v_pointer) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		*object_p = NULL;
#line 655 "chess-scene.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		*object_p = value->data[0].v_pointer;
#line 659 "chess-scene.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		*object_p = chess_model_ref (value->data[0].v_pointer);
#line 663 "chess-scene.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return NULL;
#line 667 "chess-scene.c"
}


GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessModel* spec;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_MODEL), NULL);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return G_PARAM_SPEC (spec);
#line 681 "chess-scene.c"
}


gpointer value_get_chess_model (const GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL), NULL);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return value->data[0].v_pointer;
#line 690 "chess-scene.c"
}


void value_set_chess_model (GValue* value, gpointer v_object) {
	ChessModel* old;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	old = value->data[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (v_object) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MODEL));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		value->data[0].v_pointer = v_object;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_model_ref (value->data[0].v_pointer);
#line 710 "chess-scene.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		value->data[0].v_pointer = NULL;
#line 714 "chess-scene.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (old) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_model_unref (old);
#line 720 "chess-scene.c"
	}
}


void value_take_chess_model (GValue* value, gpointer v_object) {
	ChessModel* old;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MODEL));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	old = value->data[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (v_object) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MODEL));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		value->data[0].v_pointer = v_object;
#line 739 "chess-scene.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		value->data[0].v_pointer = NULL;
#line 743 "chess-scene.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (old) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_model_unref (old);
#line 749 "chess-scene.c"
	}
}


static void chess_model_class_init (ChessModelClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_model_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	CHESS_MODEL_CLASS (klass)->finalize = chess_model_finalize;
#line 759 "chess-scene.c"
}


static void chess_model_instance_init (ChessModel * self) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->ref_count = 1;
#line 766 "chess-scene.c"
}


static void chess_model_finalize (ChessModel* obj) {
	ChessModel * self;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MODEL, ChessModel);
#line 13 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_chess_piece_unref0 (self->piece);
#line 776 "chess-scene.c"
}


GType chess_model_get_type (void) {
	static volatile gsize chess_model_type_id__volatile = 0;
	if (g_once_init_enter (&chess_model_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_model_init, value_chess_model_free_value, value_chess_model_copy_value, value_chess_model_peek_pointer, "p", value_chess_model_collect_value, "p", value_chess_model_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessModel), 0, (GInstanceInitFunc) chess_model_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_model_type_id;
		chess_model_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessModel", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_model_type_id__volatile, chess_model_type_id);
	}
	return chess_model_type_id__volatile;
}


gpointer chess_model_ref (gpointer instance) {
	ChessModel* self;
	self = instance;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_atomic_int_inc (&self->ref_count);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return instance;
#line 801 "chess-scene.c"
}


void chess_model_unref (gpointer instance) {
	ChessModel* self;
	self = instance;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		CHESS_MODEL_GET_CLASS (self)->finalize (self);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 814 "chess-scene.c"
	}
}


static void _chess_model_unref0_ (gpointer var) {
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	(var == NULL) ? NULL : (var = (chess_model_unref (var), NULL));
#line 822 "chess-scene.c"
}


static void _g_list_free__chess_model_unref0_ (GList* self) {
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_list_foreach (self, (GFunc) _chess_model_unref0_, NULL);
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_list_free (self);
#line 831 "chess-scene.c"
}


ChessPiece* chess_scene_get_selected_piece (ChessScene* self) {
	ChessPiece* result = NULL;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	ChessGame* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	ChessPiece* _tmp11_ = NULL;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = chess_scene_get_game (self);
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = _tmp1_;
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp2_ == NULL) {
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = TRUE;
#line 858 "chess-scene.c"
	} else {
		gint _tmp3_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp3_ = self->selected_rank;
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = _tmp3_ < 0;
#line 865 "chess-scene.c"
	}
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp4_ = _tmp0_;
#line 113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp4_) {
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		result = NULL;
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return result;
#line 875 "chess-scene.c"
	}
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = chess_scene_get_game (self);
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp6_ = _tmp5_;
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp7_ = self->selected_rank;
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp8_ = self->selected_file;
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp9_ = chess_scene_get_move_number (self);
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp10_ = _tmp9_;
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp11_ = chess_game_get_piece (_tmp6_, _tmp7_, _tmp8_, _tmp10_);
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp11_;
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 895 "chess-scene.c"
}


ChessScene* chess_scene_construct (GType object_type) {
	ChessScene * self = NULL;
	GTimer* _tmp0_ = NULL;
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self = (ChessScene*) g_object_new (object_type, NULL);
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = g_timer_new ();
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_timer_destroy0 (self->priv->animation_timer);
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->animation_timer = _tmp0_;
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return self;
#line 912 "chess-scene.c"
}


ChessScene* chess_scene_new (void) {
#line 195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return chess_scene_construct (TYPE_CHESS_SCENE);
#line 919 "chess-scene.c"
}


void chess_scene_select_square (ChessScene* self, gint file, gint rank) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	ChessPiece* piece = NULL;
	ChessGame* _tmp12_ = NULL;
	ChessGame* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ChessPiece* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gboolean _tmp24_ = FALSE;
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = chess_scene_get_game (self);
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = _tmp1_;
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp2_ == NULL) {
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = TRUE;
#line 952 "chess-scene.c"
	} else {
		ChessGame* _tmp3_ = NULL;
		ChessGame* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp3_ = chess_scene_get_game (self);
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp4_ = _tmp3_;
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp5_ = chess_game_get_current_player (_tmp4_);
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp6_ = _tmp5_;
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp7_ = chess_player_get_local_human (_tmp6_);
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp8_ = _tmp7_;
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp0_ = !_tmp8_;
#line 974 "chess-scene.c"
	}
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp9_ = _tmp0_;
#line 202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp9_) {
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return;
#line 982 "chess-scene.c"
	}
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp10_ = chess_scene_get_move_number (self);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp11_ = _tmp10_;
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp11_ != (-1)) {
#line 207 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return;
#line 992 "chess-scene.c"
	}
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp12_ = chess_scene_get_game (self);
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp13_ = _tmp12_;
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp14_ = rank;
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp15_ = file;
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp16_ = chess_scene_get_move_number (self);
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp17_ = _tmp16_;
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp18_ = chess_game_get_piece (_tmp13_, _tmp14_, _tmp15_, _tmp17_);
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	piece = _tmp18_;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp20_ = file;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp21_ = self->selected_file;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp20_ == _tmp21_) {
#line 1016 "chess-scene.c"
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp22_ = rank;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp23_ = self->selected_rank;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp19_ = _tmp22_ == _tmp23_;
#line 1025 "chess-scene.c"
	} else {
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp19_ = FALSE;
#line 1029 "chess-scene.c"
	}
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp24_ = _tmp19_;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp24_) {
#line 1035 "chess-scene.c"
		gint _tmp25_ = 0;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		self->selected_file = -1;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp25_ = self->selected_file;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		self->selected_rank = _tmp25_;
#line 1043 "chess-scene.c"
	} else {
		gboolean _tmp26_ = FALSE;
		ChessPiece* _tmp27_ = NULL;
		gboolean _tmp34_ = FALSE;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp27_ = piece;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		if (_tmp27_ != NULL) {
#line 1052 "chess-scene.c"
			ChessPiece* _tmp28_ = NULL;
			ChessPlayer* _tmp29_ = NULL;
			ChessGame* _tmp30_ = NULL;
			ChessGame* _tmp31_ = NULL;
			ChessPlayer* _tmp32_ = NULL;
			ChessPlayer* _tmp33_ = NULL;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp28_ = piece;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp29_ = _tmp28_->player;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp30_ = chess_scene_get_game (self);
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp31_ = _tmp30_;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp32_ = chess_game_get_current_player (_tmp31_);
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp33_ = _tmp32_;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp26_ = _tmp29_ == _tmp33_;
#line 1073 "chess-scene.c"
		} else {
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp26_ = FALSE;
#line 1077 "chess-scene.c"
		}
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp34_ = _tmp26_;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		if (_tmp34_) {
#line 1083 "chess-scene.c"
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp35_ = rank;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			self->selected_rank = _tmp35_;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp36_ = file;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			self->selected_file = _tmp36_;
#line 1094 "chess-scene.c"
		} else {
			gint _tmp37_ = 0;
#line 223 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp37_ = self->selected_file;
#line 223 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			if (_tmp37_ != (-1)) {
#line 1101 "chess-scene.c"
				gboolean can_move = FALSE;
				ChessGame* _tmp38_ = NULL;
				ChessGame* _tmp39_ = NULL;
				ChessPlayer* _tmp40_ = NULL;
				ChessPlayer* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp58_ = FALSE;
				ChessGame* _tmp70_ = NULL;
				ChessGame* _tmp71_ = NULL;
				ChessPlayer* _tmp72_ = NULL;
				ChessPlayer* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gboolean _tmp78_ = FALSE;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp38_ = chess_scene_get_game (self);
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp39_ = _tmp38_;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp40_ = chess_game_get_current_player (_tmp39_);
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp41_ = _tmp40_;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp42_ = self->selected_rank;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp43_ = self->selected_file;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp44_ = rank;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp45_ = file;
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp46_ = chess_player_move_with_coords (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, FALSE, PIECE_TYPE_QUEEN);
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				can_move = _tmp46_;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp49_ = can_move;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp49_) {
#line 1150 "chess-scene.c"
					ChessPiece* _tmp50_ = NULL;
					ChessPiece* _tmp51_ = NULL;
					PieceType _tmp52_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp50_ = chess_scene_get_selected_piece (self);
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp51_ = _tmp50_;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp52_ = _tmp51_->type;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp48_ = _tmp52_ == PIECE_TYPE_PAWN;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_chess_piece_unref0 (_tmp51_);
#line 1164 "chess-scene.c"
				} else {
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp48_ = FALSE;
#line 1168 "chess-scene.c"
				}
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp53_ = _tmp48_;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp53_) {
#line 1174 "chess-scene.c"
					gboolean _tmp54_ = FALSE;
					gint _tmp55_ = 0;
					gboolean _tmp57_ = FALSE;
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp55_ = rank;
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					if (_tmp55_ == 0) {
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
						_tmp54_ = TRUE;
#line 1184 "chess-scene.c"
					} else {
						gint _tmp56_ = 0;
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
						_tmp56_ = rank;
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
						_tmp54_ = _tmp56_ == 7;
#line 1191 "chess-scene.c"
					}
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp57_ = _tmp54_;
#line 228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp47_ = _tmp57_;
#line 1197 "chess-scene.c"
				} else {
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp47_ = FALSE;
#line 1201 "chess-scene.c"
				}
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp58_ = _tmp47_;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp58_) {
#line 1207 "chess-scene.c"
					PieceType promotion_selection = 0;
					PieceType _tmp59_ = 0;
					ChessGame* _tmp60_ = NULL;
					ChessGame* _tmp61_ = NULL;
					ChessPlayer* _tmp62_ = NULL;
					ChessPlayer* _tmp63_ = NULL;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					gint _tmp66_ = 0;
					gint _tmp67_ = 0;
					PieceType _tmp68_ = 0;
					gint _tmp69_ = 0;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					g_signal_emit_by_name (self, "choose-promotion-type", &_tmp59_);
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					promotion_selection = _tmp59_;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp60_ = chess_scene_get_game (self);
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp61_ = _tmp60_;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp62_ = chess_game_get_current_player (_tmp61_);
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp63_ = _tmp62_;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp64_ = self->selected_rank;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp65_ = self->selected_file;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp66_ = rank;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp67_ = file;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp68_ = promotion_selection;
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					chess_player_move_with_coords (_tmp63_, _tmp64_, _tmp65_, _tmp66_, _tmp67_, TRUE, _tmp68_);
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					self->selected_file = -1;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp69_ = self->selected_file;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					self->selected_rank = _tmp69_;
#line 1250 "chess-scene.c"
				}
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp70_ = chess_scene_get_game (self);
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp71_ = _tmp70_;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp72_ = chess_game_get_current_player (_tmp71_);
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp73_ = _tmp72_;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp74_ = self->selected_rank;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp75_ = self->selected_file;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp76_ = rank;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp77_ = file;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp78_ = chess_player_move_with_coords (_tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp77_, TRUE, PIECE_TYPE_QUEEN);
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp78_) {
#line 1272 "chess-scene.c"
					gint _tmp79_ = 0;
#line 237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					self->selected_file = -1;
#line 237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp79_ = self->selected_file;
#line 237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					self->selected_rank = _tmp79_;
#line 1280 "chess-scene.c"
				}
			}
		}
	}
#line 240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 241 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_chess_piece_unref0 (piece);
#line 1291 "chess-scene.c"
}


static void chess_scene_moved_cb (ChessScene* self, ChessGame* game, ChessMove* move) {
#line 244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (move != NULL);
#line 246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 1304 "chess-scene.c"
}


static void chess_scene_paused_cb (ChessScene* self, ChessGame* game) {
#line 249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 1315 "chess-scene.c"
}


static void chess_scene_unpaused_cb (ChessScene* self, ChessGame* game) {
#line 254 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 1326 "chess-scene.c"
}


static void chess_scene_undo_cb (ChessScene* self, ChessGame* game) {
#line 259 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 259 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (game != NULL);
#line 261 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 1337 "chess-scene.c"
}


static gpointer _chess_model_ref0 (gpointer self) {
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return self ? chess_model_ref (self) : NULL;
#line 1344 "chess-scene.c"
}


static ChessModel* chess_scene_find_model (ChessScene* self, ChessPiece* piece) {
	ChessModel* result = NULL;
	GList* _tmp0_ = NULL;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (piece != NULL, NULL);
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->pieces;
#line 1357 "chess-scene.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		model_collection = _tmp0_;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1365 "chess-scene.c"
			ChessModel* _tmp1_ = NULL;
			ChessModel* model = NULL;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp1_ = _chess_model_ref0 ((ChessModel*) model_it->data);
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			model = _tmp1_;
#line 1372 "chess-scene.c"
			{
				ChessModel* _tmp2_ = NULL;
				ChessPiece* _tmp3_ = NULL;
				ChessPiece* _tmp4_ = NULL;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp2_ = model;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp3_ = _tmp2_->piece;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp4_ = piece;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp3_ == _tmp4_) {
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					result = model;
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					return result;
#line 1389 "chess-scene.c"
				}
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_chess_model_unref0 (model);
#line 1393 "chess-scene.c"
			}
		}
	}
#line 269 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = NULL;
#line 269 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 1401 "chess-scene.c"
}


static gboolean _chess_scene_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_scene_animate_cb (self);
#line 336 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 1410 "chess-scene.c"
}


static void chess_scene_update_board (ChessScene* self) {
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
	gboolean board_changed = FALSE;
	gboolean need_animation = FALSE;
	GList* new_pieces = NULL;
	GList* _tmp65_ = NULL;
	guint _tmp66_ = 0U;
	GList* _tmp67_ = NULL;
	guint _tmp68_ = 0U;
	gboolean _tmp69_ = FALSE;
	GList* _tmp70_ = NULL;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp77_ = FALSE;
#line 272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = chess_scene_get_game (self);
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _tmp0_;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp1_ == NULL) {
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return;
#line 1439 "chess-scene.c"
	}
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	board_changed = FALSE;
#line 278 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	need_animation = FALSE;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	new_pieces = NULL;
#line 1447 "chess-scene.c"
	{
		gint rank = 0;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		rank = 0;
#line 1452 "chess-scene.c"
		{
			gboolean _tmp2_ = FALSE;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp2_ = TRUE;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			while (TRUE) {
#line 1459 "chess-scene.c"
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp3_ = _tmp2_;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (!_tmp3_) {
#line 1466 "chess-scene.c"
					gint _tmp4_ = 0;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp4_ = rank;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					rank = _tmp4_ + 1;
#line 1472 "chess-scene.c"
				}
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp2_ = FALSE;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp5_ = rank;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (!(_tmp5_ < 8)) {
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					break;
#line 1482 "chess-scene.c"
				}
				{
					gint file = 0;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					file = 0;
#line 1488 "chess-scene.c"
					{
						gboolean _tmp6_ = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
						_tmp6_ = TRUE;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
						while (TRUE) {
#line 1495 "chess-scene.c"
							gboolean _tmp7_ = FALSE;
							gint _tmp9_ = 0;
							gboolean can_move = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							gint _tmp12_ = 0;
							gboolean _tmp15_ = FALSE;
							gboolean _tmp25_ = FALSE;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							ChessPiece* piece = NULL;
							ChessGame* _tmp30_ = NULL;
							ChessGame* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							ChessPiece* _tmp36_ = NULL;
							ChessPiece* _tmp37_ = NULL;
							ChessModel* model = NULL;
							ChessPiece* _tmp38_ = NULL;
							ChessModel* _tmp39_ = NULL;
							ChessModel* _tmp40_ = NULL;
							ChessModel* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							ChessModel* _tmp47_ = NULL;
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gboolean _tmp50_ = FALSE;
							gboolean _tmp51_ = FALSE;
							gboolean _tmp52_ = FALSE;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							gboolean _tmp57_ = FALSE;
							gboolean _tmp60_ = FALSE;
							ChessModel* _tmp63_ = NULL;
							ChessModel* _tmp64_ = NULL;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp7_ = _tmp6_;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (!_tmp7_) {
#line 1539 "chess-scene.c"
								gint _tmp8_ = 0;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp8_ = file;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								file = _tmp8_ + 1;
#line 1545 "chess-scene.c"
							}
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp6_ = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp9_ = file;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (!(_tmp9_ < 8)) {
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								break;
#line 1555 "chess-scene.c"
							}
#line 284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							can_move = FALSE;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp12_ = self->selected_rank;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp12_ >= 0) {
#line 1563 "chess-scene.c"
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp13_ = chess_scene_get_move_number (self);
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp14_ = _tmp13_;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp11_ = _tmp14_ == (-1);
#line 1572 "chess-scene.c"
							} else {
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp11_ = FALSE;
#line 1576 "chess-scene.c"
							}
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp15_ = _tmp11_;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp15_) {
#line 1582 "chess-scene.c"
								ChessGame* _tmp16_ = NULL;
								ChessGame* _tmp17_ = NULL;
								ChessPlayer* _tmp18_ = NULL;
								ChessPlayer* _tmp19_ = NULL;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gboolean _tmp24_ = FALSE;
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp16_ = chess_scene_get_game (self);
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp17_ = _tmp16_;
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp18_ = chess_game_get_current_player (_tmp17_);
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp19_ = _tmp18_;
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp20_ = self->selected_rank;
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp21_ = self->selected_file;
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp22_ = rank;
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp23_ = file;
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp24_ = chess_player_move_with_coords (_tmp19_, _tmp20_, _tmp21_, _tmp22_, _tmp23_, FALSE, PIECE_TYPE_QUEEN);
#line 286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp10_ = _tmp24_;
#line 1612 "chess-scene.c"
							} else {
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp10_ = FALSE;
#line 1616 "chess-scene.c"
							}
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp25_ = _tmp10_;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp25_) {
#line 287 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								can_move = TRUE;
#line 1624 "chess-scene.c"
							}
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp26_ = rank;
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp27_ = file;
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp28_ = can_move;
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							self->priv->_can_move[(_tmp26_ * 8) + _tmp27_] = _tmp28_;
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp29_ = self->priv->_can_move[(_tmp26_ * 8) + _tmp27_];
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp30_ = chess_scene_get_game (self);
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp31_ = _tmp30_;
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp32_ = rank;
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp33_ = file;
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp34_ = chess_scene_get_move_number (self);
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp35_ = _tmp34_;
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp36_ = chess_game_get_piece (_tmp31_, _tmp32_, _tmp33_, _tmp35_);
#line 290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							piece = _tmp36_;
#line 291 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp37_ = piece;
#line 291 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp37_ == NULL) {
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_chess_piece_unref0 (piece);
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								continue;
#line 1660 "chess-scene.c"
							}
#line 293 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp38_ = piece;
#line 293 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp39_ = chess_scene_find_model (self, _tmp38_);
#line 293 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							model = _tmp39_;
#line 294 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp40_ = model;
#line 294 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp40_ == NULL) {
#line 1672 "chess-scene.c"
								ChessPiece* _tmp41_ = NULL;
								gint _tmp42_ = 0;
								gint _tmp43_ = 0;
								ChessModel* _tmp44_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp41_ = piece;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp42_ = file;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp43_ = rank;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp44_ = chess_model_new (_tmp41_, (gdouble) _tmp42_, (gdouble) _tmp43_);
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_chess_model_unref0 (model);
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								model = _tmp44_;
#line 297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								board_changed = TRUE;
#line 1691 "chess-scene.c"
							}
#line 299 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp45_ = model;
#line 299 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp46_ = can_move;
#line 299 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp45_->under_threat = _tmp46_;
#line 301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp47_ = model;
#line 301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp48_ = file;
#line 301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp49_ = rank;
#line 301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp50_ = chess_model_move_to (_tmp47_, (gdouble) _tmp48_, (gdouble) _tmp49_);
#line 301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp50_) {
#line 303 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								board_changed = TRUE;
#line 304 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								need_animation = TRUE;
#line 1713 "chess-scene.c"
							}
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp53_ = chess_scene_get_move_number (self);
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp54_ = _tmp53_;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp54_ == (-1)) {
#line 1721 "chess-scene.c"
								gint _tmp55_ = 0;
								gint _tmp56_ = 0;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp55_ = rank;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp56_ = self->selected_rank;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp52_ = _tmp55_ == _tmp56_;
#line 1730 "chess-scene.c"
							} else {
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp52_ = FALSE;
#line 1734 "chess-scene.c"
							}
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp57_ = _tmp52_;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp57_) {
#line 1740 "chess-scene.c"
								gint _tmp58_ = 0;
								gint _tmp59_ = 0;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp58_ = file;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp59_ = self->selected_file;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp51_ = _tmp58_ == _tmp59_;
#line 1749 "chess-scene.c"
							} else {
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp51_ = FALSE;
#line 1753 "chess-scene.c"
							}
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp60_ = _tmp51_;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							if (_tmp60_) {
#line 1759 "chess-scene.c"
								ChessModel* _tmp61_ = NULL;
#line 308 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp61_ = model;
#line 308 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp61_->is_selected = TRUE;
#line 1765 "chess-scene.c"
							} else {
								ChessModel* _tmp62_ = NULL;
#line 310 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp62_ = model;
#line 310 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
								_tmp62_->is_selected = FALSE;
#line 1772 "chess-scene.c"
							}
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp63_ = model;
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_tmp64_ = _chess_model_ref0 (_tmp63_);
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							new_pieces = g_list_append (new_pieces, _tmp64_);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_chess_model_unref0 (model);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
							_chess_piece_unref0 (piece);
#line 1784 "chess-scene.c"
						}
					}
				}
			}
		}
	}
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp65_ = new_pieces;
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp66_ = g_list_length (_tmp65_);
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp67_ = self->pieces;
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp68_ = g_list_length (_tmp67_);
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp66_ != _tmp68_) {
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		board_changed = TRUE;
#line 1803 "chess-scene.c"
	}
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp69_ = board_changed;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (!_tmp69_) {
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		__g_list_free__chess_model_unref0_0 (new_pieces);
#line 320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return;
#line 1813 "chess-scene.c"
	}
#line 323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	__g_list_free__chess_model_unref0_0 (self->pieces);
#line 323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->pieces = NULL;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp70_ = new_pieces;
#line 1821 "chess-scene.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		model_collection = _tmp70_;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1829 "chess-scene.c"
			ChessModel* _tmp71_ = NULL;
			ChessModel* model = NULL;
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp71_ = _chess_model_ref0 ((ChessModel*) model_it->data);
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			model = _tmp71_;
#line 1836 "chess-scene.c"
			{
				ChessModel* _tmp72_ = NULL;
				ChessModel* _tmp73_ = NULL;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp72_ = model;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp73_ = _chess_model_ref0 (_tmp72_);
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				self->pieces = g_list_append (self->pieces, _tmp73_);
#line 324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_chess_model_unref0 (model);
#line 1848 "chess-scene.c"
			}
		}
	}
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp75_ = need_animation;
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp75_) {
#line 1858 "chess-scene.c"
		gboolean _tmp76_ = FALSE;
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp76_ = self->animating;
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp74_ = !_tmp76_;
#line 1864 "chess-scene.c"
	} else {
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp74_ = FALSE;
#line 1868 "chess-scene.c"
	}
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp77_ = _tmp74_;
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp77_) {
#line 1874 "chess-scene.c"
		GTimer* _tmp78_ = NULL;
		ChessGame* _tmp79_ = NULL;
		ChessGame* _tmp80_ = NULL;
		guint _tmp81_ = 0U;
#line 330 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		self->animating = TRUE;
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp78_ = self->priv->animation_timer;
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_timer_start (_tmp78_);
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		self->priv->animation_time = (gdouble) 0;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp79_ = chess_scene_get_game (self);
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp80_ = _tmp79_;
#line 333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_game_add_hold (_tmp80_);
#line 336 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp81_ = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) 10, _chess_scene_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 336 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		self->priv->animate_timeout_id = _tmp81_;
#line 1897 "chess-scene.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	__g_list_free__chess_model_unref0_0 (new_pieces);
#line 1901 "chess-scene.c"
}


gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = rank;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = file;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = self->priv->_can_move[(_tmp0_ * 8) + _tmp1_];
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp2_;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 1922 "chess-scene.c"
}


static gboolean chess_scene_animate_cb (ChessScene* self) {
	gboolean result = FALSE;
	gdouble old_time = 0.0;
	gdouble _tmp0_ = 0.0;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble timestep = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gint animate_count = 0;
	GList* _tmp5_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	ChessGame* _tmp13_ = NULL;
	ChessGame* _tmp14_ = NULL;
#line 345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->animation_time;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	old_time = _tmp0_;
#line 349 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = self->priv->animation_timer;
#line 349 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
#line 349 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->animation_time = _tmp2_;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp3_ = self->priv->animation_time;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp4_ = old_time;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	timestep = _tmp3_ - _tmp4_;
#line 352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	animate_count = 0;
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = self->pieces;
#line 1963 "chess-scene.c"
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		model_collection = _tmp5_;
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
#line 1971 "chess-scene.c"
			ChessModel* _tmp6_ = NULL;
			ChessModel* model = NULL;
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			_tmp6_ = _chess_model_ref0 ((ChessModel*) model_it->data);
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
			model = _tmp6_;
#line 1978 "chess-scene.c"
			{
				ChessModel* _tmp7_ = NULL;
				gdouble _tmp8_ = 0.0;
				gboolean _tmp9_ = FALSE;
#line 355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp7_ = model;
#line 355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp8_ = timestep;
#line 355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp9_ = chess_model_animate (_tmp7_, _tmp8_);
#line 355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp9_) {
#line 1991 "chess-scene.c"
					gint _tmp10_ = 0;
#line 356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp10_ = animate_count;
#line 356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					animate_count = _tmp10_ + 1;
#line 1997 "chess-scene.c"
				}
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_chess_model_unref0 (model);
#line 2001 "chess-scene.c"
			}
		}
	}
#line 358 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp11_ = animate_count;
#line 358 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->animating = _tmp11_ > 0;
#line 360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp12_ = self->animating;
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp12_) {
#line 363 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		result = TRUE;
#line 363 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return result;
#line 2019 "chess-scene.c"
	}
#line 365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->animating = FALSE;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp13_ = chess_scene_get_game (self);
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp14_ = _tmp13_;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_game_remove_hold (_tmp14_);
#line 367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = FALSE;
#line 367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2033 "chess-scene.c"
}


ChessGame* chess_scene_get_game (ChessScene* self) {
	ChessGame* result;
	ChessGame* _tmp0_ = NULL;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_game;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2048 "chess-scene.c"
}


static gpointer _chess_game_ref0 (gpointer self) {
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return self ? chess_game_ref (self) : NULL;
#line 2055 "chess-scene.c"
}


static void _chess_scene_moved_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_moved_cb (self, _sender, move);
#line 2062 "chess-scene.c"
}


static void _chess_scene_paused_cb_chess_game_superpaused (ChessGame* _sender, gpointer self) {
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_paused_cb (self, _sender);
#line 2069 "chess-scene.c"
}


static void _chess_scene_unpaused_cb_chess_game_unpaused (ChessGame* _sender, gpointer self) {
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_unpaused_cb (self, _sender);
#line 2076 "chess-scene.c"
}


static void _chess_scene_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_undo_cb (self, _sender);
#line 2083 "chess-scene.c"
}


void chess_scene_set_game (ChessScene* self, ChessGame* value) {
	guint _tmp0_ = 0U;
	ChessGame* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessGame* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	ChessGame* _tmp7_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->animate_timeout_id;
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2101 "chess-scene.c"
		guint _tmp1_ = 0U;
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		_tmp1_ = self->priv->animate_timeout_id;
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_source_remove (_tmp1_);
#line 96 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		self->priv->animate_timeout_id = (guint) 0;
#line 97 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		self->animating = FALSE;
#line 2111 "chess-scene.c"
	}
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = value;
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp3_ = _chess_game_ref0 (_tmp2_);
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_chess_game_unref0 (self->priv->_game);
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_game = _tmp3_;
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_move_number = -1;
#line 101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->selected_rank = -1;
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->selected_file = -1;
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp4_ = self->priv->_game;
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp4_, "moved", (GCallback) _chess_scene_moved_cb_chess_game_moved, self, 0);
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp5_ = self->priv->_game;
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp5_, "superpaused", (GCallback) _chess_scene_paused_cb_chess_game_superpaused, self, 0);
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp6_ = self->priv->_game;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp6_, "unpaused", (GCallback) _chess_scene_unpaused_cb_chess_game_unpaused, self, 0);
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp7_ = self->priv->_game;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_connect_object (_tmp7_, "undo", (GCallback) _chess_scene_undo_cb_chess_game_undo, self, 0);
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 91 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "game");
#line 2147 "chess-scene.c"
}


gint chess_scene_get_move_number (ChessScene* self) {
	gint result;
	gint _tmp0_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_move_number;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2162 "chess-scene.c"
}


void chess_scene_set_move_number (ChessScene* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_move_number;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = value;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp0_ == _tmp1_) {
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		return;
#line 2180 "chess-scene.c"
	}
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = value;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_move_number = _tmp2_;
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_update_board (self);
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "move-number");
#line 2190 "chess-scene.c"
}


gboolean chess_scene_get_show_numbering (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_show_numbering;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2205 "chess-scene.c"
}


void chess_scene_set_show_numbering (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_show_numbering = _tmp0_;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "show-numbering");
#line 2221 "chess-scene.c"
}


gboolean chess_scene_get_show_move_hints (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_show_move_hints;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2236 "chess-scene.c"
}


void chess_scene_set_show_move_hints (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_show_move_hints = _tmp0_;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "show-move-hints");
#line 2252 "chess-scene.c"
}


const gchar* chess_scene_get_theme_name (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_theme_name;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2267 "chess-scene.c"
}


void chess_scene_set_theme_name (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_theme_name);
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_theme_name = _tmp1_;
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "theme-name");
#line 2288 "chess-scene.c"
}


gboolean chess_scene_get_show_3d_smooth (ChessScene* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_show_3d_smooth;
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2303 "chess-scene.c"
}


void chess_scene_set_show_3d_smooth (ChessScene* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_show_3d_smooth = _tmp0_;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "show-3d-smooth");
#line 2319 "chess-scene.c"
}


const gchar* chess_scene_get_board_side (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_board_side;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2334 "chess-scene.c"
}


void chess_scene_set_board_side (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_board_side);
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_board_side = _tmp1_;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "board-side");
#line 2355 "chess-scene.c"
}


gdouble chess_scene_get_board_angle (ChessScene* self) {
	gdouble result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	static GQuark _tmp3_label0 = 0;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	static GQuark _tmp3_label1 = 0;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	static GQuark _tmp3_label2 = 0;
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = chess_scene_get_board_side (self);
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = _tmp0_;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = _tmp1_;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("black")))) {
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2385 "chess-scene.c"
			default:
			{
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				result = 180.0;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				return result;
#line 2392 "chess-scene.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("human")))) {
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2398 "chess-scene.c"
			default:
			{
				ChessGame* _tmp5_ = NULL;
				ChessGame* _tmp6_ = NULL;
				ChessPlayer* _tmp7_ = NULL;
				ChessPlayer* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp5_ = chess_scene_get_game (self);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp6_ = _tmp5_;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp7_ = chess_game_get_black (_tmp6_);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp8_ = _tmp7_;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				g_signal_emit_by_name (self, "is-human", _tmp8_, &_tmp9_);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp9_) {
#line 179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					result = 180.0;
#line 179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					return result;
#line 2422 "chess-scene.c"
				} else {
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					result = 0.0;
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					return result;
#line 2428 "chess-scene.c"
				}
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("current")))) {
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2435 "chess-scene.c"
			default:
			{
				gdouble _tmp10_ = 0.0;
				ChessGame* _tmp11_ = NULL;
				ChessGame* _tmp12_ = NULL;
				ChessPlayer* _tmp13_ = NULL;
				ChessPlayer* _tmp14_ = NULL;
				Color _tmp15_ = 0;
				gdouble _tmp16_ = 0.0;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp11_ = chess_scene_get_game (self);
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp12_ = _tmp11_;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp13_ = chess_game_get_current_player (_tmp12_);
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp14_ = _tmp13_;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp15_ = _tmp14_->color;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				if (_tmp15_ == COLOR_WHITE) {
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp10_ = 0.0;
#line 2459 "chess-scene.c"
				} else {
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
					_tmp10_ = 180.0;
#line 2463 "chess-scene.c"
				}
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				_tmp16_ = _tmp10_;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				result = _tmp16_;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				return result;
#line 2471 "chess-scene.c"
			}
		}
	} else {
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		switch (0) {
#line 2477 "chess-scene.c"
			default:
			{
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				result = 0.0;
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
				return result;
#line 2484 "chess-scene.c"
			}
		}
	}
}


const gchar* chess_scene_get_move_format (ChessScene* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = self->priv->_move_format;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	result = _tmp0_;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	return result;
#line 2502 "chess-scene.c"
}


void chess_scene_set_move_format (ChessScene* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = value;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_move_format);
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_move_format = _tmp1_;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_emit_by_name (self, "changed");
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_notify ((GObject *) self, "move-format");
#line 2523 "chess-scene.c"
}


static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (return_value != NULL);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (n_param_values == 2);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data1 = closure->data;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data2 = param_values->data[0].v_pointer;
#line 2545 "chess-scene.c"
	} else {
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data1 = param_values->data[0].v_pointer;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data2 = closure->data;
#line 2551 "chess-scene.c"
	}
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_value_set_boolean (return_value, v_return);
#line 2559 "chess-scene.c"
}


static void g_cclosure_user_marshal_ENUM__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_ENUM__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_ENUM__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (return_value != NULL);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_return_if_fail (n_param_values == 1);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data1 = closure->data;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data2 = param_values->data[0].v_pointer;
#line 2581 "chess-scene.c"
	} else {
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data1 = param_values->data[0].v_pointer;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		data2 = closure->data;
#line 2587 "chess-scene.c"
	}
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	callback = (GMarshalFunc_ENUM__VOID) (marshal_data ? marshal_data : cc->callback);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	v_return = callback (data1, data2);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_value_set_enum (return_value, v_return);
#line 2595 "chess-scene.c"
}


static void chess_scene_class_init (ChessSceneClass * klass) {
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	chess_scene_parent_class = g_type_class_peek_parent (klass);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_type_class_add_private (klass, sizeof (ChessScenePrivate));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_scene_get_property;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_scene_set_property;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_scene_finalize;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_GAME, param_spec_chess_game ("game", "game", "game", TYPE_CHESS_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_NUMBER, g_param_spec_int ("move-number", "move-number", "move-number", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_NUMBERING, g_param_spec_boolean ("show-numbering", "show-numbering", "show-numbering", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_MOVE_HINTS, g_param_spec_boolean ("show-move-hints", "show-move-hints", "show-move-hints", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_SHOW_3D_SMOOTH, g_param_spec_boolean ("show-3d-smooth", "show-3d-smooth", "show-3d-smooth", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_SIDE, g_param_spec_string ("board-side", "board-side", "board-side", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_BOARD_ANGLE, g_param_spec_double ("board-angle", "board-angle", "board-angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_SCENE_MOVE_FORMAT, g_param_spec_string ("move-format", "move-format", "move-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_new ("is_human", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, TYPE_CHESS_PLAYER);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_new ("choose_promotion_type", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_ENUM__VOID, TYPE_PIECE_TYPE, 0);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	g_signal_new ("changed", TYPE_CHESS_SCENE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2634 "chess-scene.c"
}


static void chess_scene_instance_init (ChessScene * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv = CHESS_SCENE_GET_PRIVATE (self);
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->pieces = NULL;
#line 74 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->animating = FALSE;
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->selected_rank = -1;
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->selected_file = -1;
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->animate_timeout_id = (guint) 0;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_game = NULL;
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_move_number = -1;
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_show_numbering = TRUE;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_show_move_hints = TRUE;
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp0_ = g_strdup ("simple");
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_theme_name = _tmp0_;
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_show_3d_smooth = FALSE;
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp1_ = g_strdup ("human");
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_board_side = _tmp1_;
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_tmp2_ = g_strdup ("human");
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self->priv->_move_format = _tmp2_;
#line 2676 "chess-scene.c"
}


static void chess_scene_finalize (GObject* obj) {
	ChessScene * self;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_SCENE, ChessScene);
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	__g_list_free__chess_model_unref0_0 (self->pieces);
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_timer_destroy0 (self->priv->animation_timer);
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_chess_game_unref0 (self->priv->_game);
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_theme_name);
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_board_side);
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	_g_free0 (self->priv->_move_format);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	G_OBJECT_CLASS (chess_scene_parent_class)->finalize (obj);
#line 2698 "chess-scene.c"
}


GType chess_scene_get_type (void) {
	static volatile gsize chess_scene_type_id__volatile = 0;
	if (g_once_init_enter (&chess_scene_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessSceneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_scene_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessScene), 0, (GInstanceInitFunc) chess_scene_instance_init, NULL };
		GType chess_scene_type_id;
		chess_scene_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessScene", &g_define_type_info, 0);
		g_once_init_leave (&chess_scene_type_id__volatile, chess_scene_type_id);
	}
	return chess_scene_type_id__volatile;
}


static void _vala_chess_scene_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	switch (property_id) {
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_GAME:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		value_set_chess_game (value, chess_scene_get_game (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_NUMBER:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_int (value, chess_scene_get_move_number (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_NUMBERING:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_boolean (value, chess_scene_get_show_numbering (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_MOVE_HINTS:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_boolean (value, chess_scene_get_show_move_hints (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_THEME_NAME:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_string (value, chess_scene_get_theme_name (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_3D_SMOOTH:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_boolean (value, chess_scene_get_show_3d_smooth (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_BOARD_SIDE:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_string (value, chess_scene_get_board_side (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_BOARD_ANGLE:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_double (value, chess_scene_get_board_angle (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_FORMAT:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		g_value_set_string (value, chess_scene_get_move_format (self));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 2773 "chess-scene.c"
		default:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 2779 "chess-scene.c"
	}
}


static void _vala_chess_scene_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessScene * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_SCENE, ChessScene);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
	switch (property_id) {
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_GAME:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_game (self, value_get_chess_game (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_NUMBER:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_move_number (self, g_value_get_int (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_NUMBERING:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_show_numbering (self, g_value_get_boolean (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_MOVE_HINTS:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_show_move_hints (self, g_value_get_boolean (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_THEME_NAME:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_theme_name (self, g_value_get_string (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_SHOW_3D_SMOOTH:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_show_3d_smooth (self, g_value_get_boolean (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_BOARD_SIDE:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_board_side (self, g_value_get_string (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		case CHESS_SCENE_MOVE_FORMAT:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		chess_scene_set_move_format (self, g_value_get_string (value));
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 2837 "chess-scene.c"
		default:
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-scene.vala"
		break;
#line 2843 "chess-scene.c"
	}
}



