/* chess-engine.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from chess-engine.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <signal.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	gchar* binary;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	guint stdout_watch_id;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY
};
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1);
static gchar** _vala_array_dup20 (gchar** self, int length);
gboolean chess_engine_start (ChessEngine* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status);
static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
static void chess_engine_real_undo (ChessEngine* self);
void chess_engine_stop (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject* obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
#line 132 "chess-engine.c"
}


static gchar** _vala_array_dup20 (gchar** self, int length) {
	gchar** result;
	int i;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	result = g_new0 (gchar*, length + 1);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	for (i = 0; i < length; i++) {
#line 143 "chess-engine.c"
		gchar* _tmp0_ = NULL;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp0_ = g_strdup (self[i]);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		result[i] = _tmp0_;
#line 149 "chess-engine.c"
	}
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return result;
#line 153 "chess-engine.c"
}


ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1) {
	ChessEngine * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (binary != NULL, NULL);
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self = (ChessEngine*) g_object_new (object_type, NULL);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = binary;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_g_free0 (self->priv->binary);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->binary = _tmp1_;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp2_ = args;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp2__length1 = args_length1;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup20 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp3__length1 = _tmp2__length1;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->args = _tmp3_;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->args_length1 = _tmp3__length1;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->_args_size_ = self->priv->args_length1;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return self;
#line 195 "chess-engine.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if ((*length) == (*size)) {
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 206 "chess-engine.c"
	}
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	(*array)[(*length)++] = value;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	(*array)[*length] = NULL;
#line 212 "chess-engine.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if ((*length) == (*size)) {
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 223 "chess-engine.c"
	}
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	(*array)[(*length)++] = value;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	(*array)[*length] = NULL;
#line 229 "chess-engine.c"
}


static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
#line 74 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	chess_engine_engine_stopped_cb (self, pid, status);
#line 236 "chess-engine.c"
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb (self, source, condition);
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return result;
#line 245 "chess-engine.c"
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	gchar** argv = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint stdout_fd = 0;
	GPid _tmp16_ = 0;
	gint _tmp17_ = 0;
	GIOChannel* _tmp18_ = NULL;
	GIOChannel* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	GError * _inner_error_ = NULL;
#line 53 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->binary;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp2_ = g_new0 (gchar*, 1 + 1);
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp2_[0] = _tmp1_;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	argv = _tmp2_;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	argv_length1 = 1;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_argv_size_ = argv_length1;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp3_ = self->priv->args;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp3__length1 = self->priv->args_length1;
#line 288 "chess-engine.c"
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		arg_collection = _tmp3_;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		arg_collection_length1 = _tmp3__length1;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		for (arg_it = 0; arg_it < _tmp3__length1; arg_it = arg_it + 1) {
#line 300 "chess-engine.c"
			gchar* _tmp4_ = NULL;
			gchar* arg = NULL;
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			_tmp4_ = g_strdup (arg_collection[arg_it]);
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			arg = _tmp4_;
#line 307 "chess-engine.c"
			{
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				_tmp5_ = argv;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				_tmp5__length1 = argv_length1;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				_tmp6_ = arg;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				_tmp7_ = g_strdup (_tmp6_);
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				_vala_array_add1 (&argv, &argv_length1, &_argv_size_, _tmp7_);
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				_g_free0 (arg);
#line 325 "chess-engine.c"
			}
		}
	}
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp8_ = argv;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp8__length1 = argv_length1;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, NULL);
#line 335 "chess-engine.c"
	{
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		GPid _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp9_ = argv;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp9__length1 = argv_length1;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_spawn_async_with_pipes (NULL, _tmp9_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_inner_error_);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		self->priv->pid = _tmp10_;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		self->priv->stdin_fd = _tmp11_;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		stdout_fd = _tmp12_;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		self->priv->stderr_fd = _tmp13_;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		if (_inner_error_ != NULL) {
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 361 "chess-engine.c"
				goto __catch13_g_spawn_error;
			}
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 372 "chess-engine.c"
		}
	}
	goto __finally13;
	__catch13_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 70 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp14_ = e;
#line 70 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp15_ = _tmp14_->message;
#line 70 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:70: Failed to execute chess engine: %s\n", _tmp15_);
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		return result;
#line 399 "chess-engine.c"
	}
	__finally13:
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_inner_error_ != NULL) {
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 412 "chess-engine.c"
	}
#line 74 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp16_ = self->priv->pid;
#line 74 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp16_, _chess_engine_engine_stopped_cb_gchild_watch_func, g_object_ref (self), g_object_unref);
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp17_ = stdout_fd;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp18_ = g_io_channel_unix_new (_tmp17_);
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_g_io_channel_unref0 (self->priv->stdout_channel);
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_channel = _tmp18_;
#line 426 "chess-engine.c"
	{
		GIOChannel* _tmp19_ = NULL;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp19_ = self->priv->stdout_channel;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_io_channel_set_flags (_tmp19_, G_IO_FLAG_NONBLOCK, &_inner_error_);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		if (_inner_error_ != NULL) {
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 437 "chess-engine.c"
				goto __catch14_g_io_channel_error;
			}
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 448 "chess-engine.c"
		}
	}
	goto __finally14;
	__catch14_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp20_ = e;
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp21_ = _tmp20_->message;
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:83: Failed to set input from chess engine to non-blo" \
"cking: %s", _tmp21_);
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 469 "chess-engine.c"
	}
	__finally14:
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_inner_error_ != NULL) {
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 482 "chess-engine.c"
	}
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp22_ = self->priv->stdout_channel;
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp23_ = g_io_add_watch (_tmp22_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
#line 85 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->stdout_watch_id = _tmp23_;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "starting");
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	result = TRUE;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return result;
#line 498 "chess-engine.c"
}


static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status) {
	GPid _tmp0_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = pid;
#line 94 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_spawn_close_pid (_tmp0_);
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "stopped");
#line 512 "chess-engine.c"
}


static void chess_engine_real_start_game (ChessEngine* self) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_start_game'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return;
#line 521 "chess-engine.c"
}


void chess_engine_start_game (ChessEngine* self) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
#line 530 "chess-engine.c"
}


static void chess_engine_real_request_move (ChessEngine* self) {
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_request_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return;
#line 539 "chess-engine.c"
}


void chess_engine_request_move (ChessEngine* self) {
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
#line 548 "chess-engine.c"
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_report_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return;
#line 557 "chess-engine.c"
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
#line 566 "chess-engine.c"
}


static void chess_engine_real_undo (ChessEngine* self) {
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_critical ("Type `%s' does not implement abstract method `chess_engine_undo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return;
#line 575 "chess-engine.c"
}


void chess_engine_undo (ChessEngine* self) {
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_GET_CLASS (self)->undo (self);
#line 584 "chess-engine.c"
}


void chess_engine_stop (ChessEngine* self) {
	guint _tmp0_ = 0U;
	GPid _tmp2_ = 0;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->stdout_watch_id;
#line 108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 597 "chess-engine.c"
		guint _tmp1_ = 0U;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp1_ = self->priv->stdout_watch_id;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_source_remove (_tmp1_);
#line 603 "chess-engine.c"
	}
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp2_ = self->priv->pid;
#line 111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_tmp2_ != ((GPid) 0)) {
#line 609 "chess-engine.c"
		GPid _tmp3_ = 0;
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp3_ = self->priv->pid;
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		kill ((pid_t) _tmp3_, SIGTERM);
#line 615 "chess-engine.c"
	}
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp0_ = NULL;
	GIOStatus _tmp10_ = 0;
	GIOStatus _tmp12_ = 0;
	GError * _inner_error_ = NULL;
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (source != NULL, FALSE);
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = g_new0 (gchar, 1024);
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	buf = (g_free (buf), NULL);
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	buf = _tmp0_;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	buf_length1 = 1024;
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_buf_size_ = buf_length1;
#line 645 "chess-engine.c"
	{
		GIOStatus _tmp1_ = 0;
		GIOChannel* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gsize _tmp4_ = 0UL;
		GIOStatus _tmp5_ = 0;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp2_ = source;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp3_ = buf;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp3__length1 = buf_length1;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp5_ = g_io_channel_read_chars (_tmp2_, _tmp3_, _tmp3__length1, &_tmp4_, &_inner_error_);
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		n_read = _tmp4_;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp1_ = _tmp5_;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		if (_inner_error_ != NULL) {
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_CONVERT_ERROR) {
#line 669 "chess-engine.c"
				goto __catch15_g_convert_error;
			}
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
#line 674 "chess-engine.c"
				goto __catch15_g_io_channel_error;
			}
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			buf = (g_free (buf), NULL);
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			g_clear_error (&_inner_error_);
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			return FALSE;
#line 685 "chess-engine.c"
		}
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		status = _tmp1_;
#line 689 "chess-engine.c"
	}
	goto __finally15;
	__catch15_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp6_ = e;
#line 128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp7_ = _tmp6_->message;
#line 128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:128: Failed to read from engine: %s", _tmp7_);
#line 129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		return result;
#line 715 "chess-engine.c"
	}
	goto __finally15;
	__catch15_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		e = _inner_error_;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_inner_error_ = NULL;
#line 133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp8_ = e;
#line 133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp9_ = _tmp8_->message;
#line 133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_warning ("chess-engine.vala:133: Failed to read from engine: %s", _tmp9_);
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_g_error_free0 (e);
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		return result;
#line 741 "chess-engine.c"
	}
	__finally15:
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_inner_error_ != NULL) {
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_clear_error (&_inner_error_);
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		return FALSE;
#line 754 "chess-engine.c"
	}
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp10_ = status;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_tmp10_ == G_IO_STATUS_EOF) {
#line 760 "chess-engine.c"
		FILE* _tmp11_ = NULL;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp11_ = stdout;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		fprintf (_tmp11_, "EOF\n");
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		result = FALSE;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		buf = (g_free (buf), NULL);
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		return result;
#line 772 "chess-engine.c"
	}
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp12_ = status;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_tmp12_ == G_IO_STATUS_NORMAL) {
#line 778 "chess-engine.c"
		gsize _tmp13_ = 0UL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp13_ = n_read;
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp14_ = (gint) _tmp13_;
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		buf = g_renew (gchar, buf, (gint) _tmp13_);
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		(_tmp14_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp14_ - buf_length1)) : NULL;
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		buf_length1 = _tmp14_;
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_buf_size_ = _tmp14_;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp15_ = buf;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp15__length1 = buf_length1;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		chess_engine_process_input (self, _tmp15_, _tmp15__length1);
#line 801 "chess-engine.c"
	}
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	result = TRUE;
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	buf = (g_free (buf), NULL);
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return result;
#line 809 "chess-engine.c"
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset = 0UL;
	gsize n_written = 0UL;
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	offset = (gsize) 0;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	while (TRUE) {
#line 822 "chess-engine.c"
		gsize _tmp0_ = 0UL;
		gchar* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		gchar* d = NULL;
		gchar* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gsize _tmp3_ = 0UL;
		gchar* _tmp4_ = NULL;
		gint d_length1 = 0;
		gint _d_size_ = 0;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gchar* _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gssize _tmp21_ = 0L;
		gsize _tmp22_ = 0UL;
		gsize _tmp23_ = 0UL;
		gsize _tmp24_ = 0UL;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp0_ = offset;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp1_ = data;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp1__length1 = data_length1;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		if (!(_tmp0_ < ((gsize) _tmp1__length1))) {
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			break;
#line 852 "chess-engine.c"
		}
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp2_ = data;
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp2__length1 = data_length1;
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp3_ = offset;
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp4_ = g_new0 (gchar, _tmp2__length1 - _tmp3_);
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		d = _tmp4_;
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		d_length1 = _tmp2__length1 - _tmp3_;
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_d_size_ = d_length1;
#line 868 "chess-engine.c"
		{
			gint i = 0;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			i = 0;
#line 873 "chess-engine.c"
			{
				gboolean _tmp5_ = FALSE;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				_tmp5_ = TRUE;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
				while (TRUE) {
#line 880 "chess-engine.c"
					gboolean _tmp6_ = FALSE;
					gint _tmp8_ = 0;
					gchar* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gsize _tmp10_ = 0UL;
					gchar* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gsize _tmp14_ = 0UL;
					gint _tmp15_ = 0;
					gchar _tmp16_ = '\0';
					gchar _tmp17_ = '\0';
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp6_ = _tmp5_;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					if (!_tmp6_) {
#line 899 "chess-engine.c"
						gint _tmp7_ = 0;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
						_tmp7_ = i;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
						i = _tmp7_ + 1;
#line 905 "chess-engine.c"
					}
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp5_ = FALSE;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp8_ = i;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp9_ = data;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp9__length1 = data_length1;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp10_ = offset;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					if (!(((gsize) _tmp8_) < (_tmp9__length1 - _tmp10_))) {
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
						break;
#line 921 "chess-engine.c"
					}
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp11_ = d;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp11__length1 = d_length1;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp12_ = i;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp13_ = data;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp13__length1 = data_length1;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp14_ = offset;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp15_ = i;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp16_ = _tmp13_[_tmp14_ + _tmp15_];
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp11_[_tmp12_] = _tmp16_;
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
					_tmp17_ = _tmp11_[_tmp12_];
#line 943 "chess-engine.c"
				}
			}
		}
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp18_ = self->priv->stdin_fd;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp19_ = d;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp19__length1 = d_length1;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp20_ = d;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp20__length1 = d_length1;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp21_ = write (_tmp18_, _tmp19_, (gsize) _tmp20__length1);
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		n_written = (gsize) _tmp21_;
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp22_ = n_written;
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		if (_tmp22_ < ((gsize) 0)) {
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			d = (g_free (d), NULL);
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
			return;
#line 969 "chess-engine.c"
		}
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp23_ = offset;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp24_ = n_written;
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		offset = _tmp23_ + _tmp24_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		d = (g_free (d), NULL);
#line 979 "chess-engine.c"
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1266 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1268 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1268 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1269 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1269 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1269 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1269 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1269 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1035 "chess-engine.c"
	}
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 1041 "chess-engine.c"
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	gchar* l = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* d = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gint d_length1 = 0;
	gint _d_size_ = 0;
	gchar* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (line != NULL);
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = line;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp1_ = g_strconcat (_tmp0_, "\n", NULL);
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	l = _tmp1_;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp2_ = line;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_debug ("chess-engine.vala:177: Writing line to engine: '%s'", _tmp2_);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp3_ = l;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	d = _tmp5_;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	d_length1 = _tmp4_;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_d_size_ = d_length1;
#line 179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp6_ = d;
#line 179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp6__length1 = d_length1;
#line 179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	if (_tmp6_ != NULL) {
#line 1088 "chess-engine.c"
		gchar* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp7_ = d;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		_tmp7__length1 = d_length1;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		chess_engine_write (self, _tmp7_, _tmp7__length1);
#line 1097 "chess-engine.c"
	}
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	d = (g_free (d), NULL);
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_g_free0 (l);
#line 1103 "chess-engine.c"
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = self->priv->_ready;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	result = _tmp0_;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	return result;
#line 1118 "chess-engine.c"
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_tmp0_ = value;
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->_ready = _tmp0_;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_emit_by_name (self, "ready-changed");
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_object_notify ((GObject *) self, "ready");
#line 1134 "chess-engine.c"
}


static void chess_engine_class_init (ChessEngineClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	chess_engine_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_real_process_input;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_real_start_game;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_real_request_move;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_real_report_move;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_real_undo;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("ready_changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("stopped", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("error", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("claim_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	g_signal_new ("offer_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1177 "chess-engine.c"
}


static void chess_engine_instance_init (ChessEngine * self) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->_ready = FALSE;
#line 1186 "chess-engine.c"
}


static void chess_engine_finalize (GObject* obj) {
	ChessEngine * self;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE, ChessEngine);
#line 13 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_g_free0 (self->priv->binary);
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
#line 19 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	_g_io_channel_unref0 (self->priv->stdout_channel);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
#line 1202 "chess-engine.c"
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		case CHESS_ENGINE_READY:
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		g_value_set_boolean (value, chess_engine_get_ready (self));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		break;
#line 1229 "chess-engine.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		break;
#line 1235 "chess-engine.c"
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		case CHESS_ENGINE_READY:
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		chess_engine_set_ready (self, g_value_get_boolean (value));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		break;
#line 1251 "chess-engine.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-engine.vala"
		break;
#line 1257 "chess-engine.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



