/* gnome-klotski.c generated by valac 0.22.0, the Vala compiler
 * generated from gnome-klotski.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Puzzle Info */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <locale.h>
#include <pango/pango.h>


#define TYPE_LEVEL_INFO (level_info_get_type ())
typedef struct _LevelInfo LevelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KLOTSKI (klotski_get_type ())
#define KLOTSKI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KLOTSKI, Klotski))
#define KLOTSKI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KLOTSKI, KlotskiClass))
#define IS_KLOTSKI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KLOTSKI))
#define IS_KLOTSKI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KLOTSKI))
#define KLOTSKI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KLOTSKI, KlotskiClass))

typedef struct _Klotski Klotski;
typedef struct _KlotskiClass KlotskiClass;
typedef struct _KlotskiPrivate KlotskiPrivate;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _puzzle_unref0(var) ((var == NULL) ? NULL : (var = (puzzle_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;
#define _history_entry_unref0(var) ((var == NULL) ? NULL : (var = (history_entry_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ScoreDialogPrivate ScoreDialogPrivate;
typedef struct _HistoryPrivate HistoryPrivate;
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _LevelInfo {
	gchar* name;
	gint group;
	gint width;
	gint height;
	gchar* data;
};

struct _Klotski {
	GtkApplication parent_instance;
	KlotskiPrivate * priv;
};

struct _KlotskiClass {
	GtkApplicationClass parent_class;
};

struct _KlotskiPrivate {
	GSettings* settings;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkMenuItem* next_menu_item;
	GtkMenuItem* prev_menu_item;
	PuzzleView* view;
	GtkToolButton* fullscreen_button;
	GtkLabel* messagewidget;
	GtkLabel* moves_label;
	Puzzle* puzzle;
	gint current_level;
	History* history;
	GtkSizeGroup* groups[3];
	GtkImage** level_images;
	gint level_images_length1;
	gint _level_images_size_;
	GtkRadioMenuItem** level_items;
	gint level_items_length1;
	gint _level_items_size_;
};

struct _Puzzle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GTypeClass parent_class;
	void (*finalize) (Puzzle *self);
};

struct _ScoreDialog {
	GtkDialog parent_instance;
	ScoreDialogPrivate * priv;
};

struct _ScoreDialogClass {
	GtkDialogClass parent_class;
};

struct _ScoreDialogPrivate {
	History* history;
	HistoryEntry* selected_entry;
	GtkListStore* level_model;
	GtkListStore* score_model;
	GtkComboBox* level_combo;
};

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
	gchar* filename;
	GList* entries;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	guint level;
	guint moves;
};

struct _HistoryEntryClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryEntry *self);
};


static gpointer klotski_parent_class = NULL;
static gpointer score_dialog_parent_class = NULL;

GType level_info_get_type (void) G_GNUC_CONST;
LevelInfo* level_info_dup (const LevelInfo* self);
void level_info_free (LevelInfo* self);
void level_info_copy (const LevelInfo* self, LevelInfo* dest);
void level_info_destroy (LevelInfo* self);
GType klotski_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define KLOTSKI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KLOTSKI, KlotskiPrivate))
enum  {
	KLOTSKI_DUMMY_PROPERTY
};
#define KLOTSKI_MINWIDTH 250
#define KLOTSKI_MINHEIGHT 250
#define KLOTSKI_SPACE_PADDING 5
#define KLOTSKI_KEY_LEVEL "level"
static void klotski_restart_level_cb (Klotski* self);
static void _klotski_restart_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_fullscreen_cb (Klotski* self);
static void _klotski_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_scores_cb (Klotski* self);
static void _klotski_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_help_cb (Klotski* self);
static void _klotski_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_about_cb (Klotski* self);
static void _klotski_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void klotski_quit_cb (Klotski* self);
static void _klotski_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Klotski* klotski_new (void);
Klotski* klotski_construct (GType object_type);
static void klotski_real_startup (GApplication* base);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static gboolean klotski_window_configure_event_cb (Klotski* self, GdkEventConfigure* event);
static gboolean _klotski_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean klotski_window_state_event_cb (Klotski* self, GdkEventWindowState* event);
static gboolean _klotski_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void _klotski_restart_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void klotski_next_level_cb (Klotski* self);
static void _klotski_next_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void klotski_prev_level_cb (Klotski* self);
static void _klotski_prev_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void klotski_level_cb (Klotski* self, GtkMenuItem* item);
static void _klotski_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void klotski_load_solved_state (Klotski* self);
static void klotski_new_game (Klotski* self, gint requested_level);
gpointer history_entry_ref (gpointer instance);
void history_entry_unref (gpointer instance);
GParamSpec* param_spec_history_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_entry (GValue* value, gpointer v_object);
void value_take_history_entry (GValue* value, gpointer v_object);
gpointer value_get_history_entry (const GValue* value);
GType history_entry_get_type (void) G_GNUC_CONST;
static gint klotski_show_scores (Klotski* self, HistoryEntry* selected_entry, gboolean show_quit);
static void klotski_game_score (Klotski* self);
static gchar* klotski_get_level_key (Klotski* self, gint level_number);
HistoryEntry* history_entry_new (GDateTime* date, guint level, guint moves);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint level, guint moves);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_quit);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_quit);
static void klotski_update_menu_state (Klotski* self);
static void klotski_update_moves_label (Klotski* self);
Puzzle* puzzle_new (gint width, gint height, const gchar* data);
Puzzle* puzzle_construct (GType object_type, gint width, gint height, const gchar* data);
static void klotski_puzzle_moved_cb (Klotski* self);
static void _klotski_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
gboolean puzzle_game_over (Puzzle* self);
static void klotski_real_shutdown (GApplication* base);
static void klotski_real_activate (GApplication* base);
gint klotski_main (gchar** args, int args_length1);
static void klotski_finalize (GObject* obj);
#define SCORE_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCORE_DIALOG, ScoreDialogPrivate))
enum  {
	SCORE_DIALOG_DUMMY_PROPERTY
};
static void score_dialog_entry_added_cb (ScoreDialog* self, HistoryEntry* entry);
static void _score_dialog_entry_added_cb_history_entry_added (History* _sender, HistoryEntry* entry, gpointer self);
static void score_dialog_level_changed_cb (ScoreDialog* self, GtkComboBox* combo);
static void _score_dialog_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void score_dialog_set_level (ScoreDialog* self, guint level);
static gint score_dialog_compare_entries (HistoryEntry* a, HistoryEntry* b);
static gint _score_dialog_compare_entries_gcompare_func (gconstpointer a, gconstpointer b);
static void score_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const LevelInfo KLOTSKI_level[28] = {{"Only 18 Steps", 0, 6, 9, "######" "#a**b#" "#m**n#" "#cdef#" "#ghij#" "#k  l#" "##--##" "    .." "    .."}, {"Daisy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#zghi#" "#j  k#" "##--##" "    .." "    .."}, {"Violet", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghi#" "#j  k#" "##--##" "    .." "    .."}, {"Poppy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#fghi#" "#j  k#" "##--##" "    .." "    .."}, {"Pansy", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghf#" "#i  j#" "##--##" "    .." "    .."}, {"Snowdrop", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfgh#" "#i  j#" "##--##" "    .." "    .."}, {"Red Donkey", 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfge#" "#h  i#" "##--##" "    .." "    .."}, {"Trail", 0, 6, 9, "######" "#a**c#" "#a**c#" "#eddg#" "#hffj#" "# ii #" "##--##" "    .." "    .."}, {"Ambush", 0, 6, 9, "######" "#a**c#" "#d**e#" "#dffe#" "#ghhi#" "# jj #" "##--##" "    .." "    .."}, {"Agatka", 1, 7, 7, "..     " ".      " "#####--" "#**aab-" "#*ccde#" "#fgh  #" "#######"}, {"Success", 1, 9, 6, "#######  " "#**bbc#  " "#defgh#  " "#ijkgh-  " "#llk  #  " "#######.."}, {"Bone", 1, 6, 9, "######" "#abc*#" "# dd*#" "# ee*#" "# fgh#" "##-###" "     ." "     ." "     ."}, {"Fortune", 1, 7, 10, "     .." "     . " "####-. " "#ab  - " "#ccd # " "#ccd # " "#**ee# " "#*fgh# " "#*iih# " "###### "}, {"Fool", 1, 10, 6, "  ########" "  -aabc  #" "  #aabdef#" "  #ijggef#" "  #klhh**#" "..########"}, {"Solomon", 1, 7, 9, " .     " "..     " "#--####" "#  aab#" "# cdfb#" "#hcefg#" "#hijk*#" "#hll**#" "#######"}, {"Cleopatra", 1, 6, 8, "######" "#abcd#" "#**ee#" "#f*g #" "#fh i-" "####--" "    .." "     ."}, {"Shark", 1, 11, 8, "########   " "#nrr s #   " "#n*op q#   " "#***jml#   " "#hhijkl#   " "#ffcddg-   " "#abcdde- . " "########..."}, {"Rome", 1, 8, 8, "########" "#abcc**#" "#ddeef*#" "#ddghfi#" "#   jki#" "#--#####" " ..     " "  .     "}, {"Pennant Puzzle", 1, 6, 9, "######" "#**aa#" "#**bb#" "#de  #" "#fghh#" "#fgii#" "#--###" "    .." "    .."}, {"Ithaca", 2, 19, 19, ".aaaaaaaaaaaaaaaaab" "..  cddeffffffffffb" " .. cddeffffffffffb" "  . cddeffffffffffb" "ggg-############hhb" "ggg-  ABCDEFFGH#hhb" "ggg-       FFIJ#hhb" "ggg#       KLMJ#hhb" "ggg#NNNNOOOPQMJ#hhb" "ggg#NNNNOOOP*RS#hhb" "ggg#TTTTTUVW**X#hhb" "ggg#YZ12222W3**#hhb" "ggg#YZ12222W34*#iib" "jjj#YZ155555367#klb" "jjj#############mmb" "jjjnooooooooooppppb" "jjjqooooooooooppppb" "       rrrssssppppb" "ttttttuvvvvvvvwwwwx"}, {"Pelopones", 2, 9, 8, "#########" "#abbb***#" "#abbb*c*#" "#adeefgg#" "#  eefhh#" "#... ihh#" "#. . ihh#" "#########"}, {"Transeuropa", 2, 15, 8, "    ###########" "    -AAAAABBCC#" "    -   DEFGHI#" "    #   DEFGJI#" "    #   KEFGLI#" "    #   KEFG*I#" "  . #   MM****#" "....###########"}, {"Lodzianka", 2, 9, 7, "#########" "#**abbcc#" "#**abbdd#" "#eefgh  #" "#iiijk..#" "#iiijk..#" "#########"}, {"Polonaise", 2, 7, 7, "#######" "#aab**#" "#aabc*#" "#defgg#" "#..fhh#" "# .ihh#" "#######"}, {"Baltic Sea", 2, 6, 8, "######" "#.abc#" "#.dec#" "#fggc#" "#fhhi#" "#fjk*#" "#flk*#" "######"}, {"American Pie", 2, 10, 12, "##########" "#a*bcdefg#" "#**bhhhhg#" "#*iijjkkg#" "#liimnoop#" "#qiirrr  #" "#qstuvv  #" "#qwwxvv  #" "######--##" "         ." "        .." "        . "}, {"Traffic Jam", 2, 10, 7, "########  " "#** ffi#  " "#** fgh#  " "#aacehh#  " "#bbdjlm-  " "#bddklm-.." "########.."}, {"Sunshine", 2, 17, 22, "       ...       " "      .. ..      " "      .   .      " "      .. ..      " "       ...       " "######-----######" "#hh0iilltmmpp;qq#" "#hh,iill mmpp:qq#" "#2y{45v s w89x/z#" "#jj6kkaa nnoo<rr#" "#jj7kkaaunnoo>rr#" "#33333TTJWW11111#" "#33333TTJWW11111#" "#33333GG HH11111#" "#33333YYIgg11111#" "#33333YYIgg11111#" "#ddFeeA***BffOZZ#" "#ddFee** **ffOZZ#" "#MMKQQ*   *PPS^^#" "#VVLXX** **bbRcc#" "#VVLXXD***EbbRcc#" "#################"}};
static const GActionEntry KLOTSKI_action_entries[6] = {{"new-game", _klotski_restart_level_cb_gsimple_action_activate_callback}, {"fullscreen", _klotski_fullscreen_cb_gsimple_action_activate_callback}, {"scores", _klotski_scores_cb_gsimple_action_activate_callback}, {"help", _klotski_help_cb_gsimple_action_activate_callback}, {"about", _klotski_about_cb_gsimple_action_activate_callback}, {"quit", _klotski_quit_cb_gsimple_action_activate_callback}};

void level_info_copy (const LevelInfo* self, LevelInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).group;
	(*dest).group = _tmp2_;
	_tmp3_ = (*self).width;
	(*dest).width = _tmp3_;
	_tmp4_ = (*self).height;
	(*dest).height = _tmp4_;
	_tmp5_ = (*self).data;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp6_;
}


void level_info_destroy (LevelInfo* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).data);
}


LevelInfo* level_info_dup (const LevelInfo* self) {
	LevelInfo* dup;
	dup = g_new0 (LevelInfo, 1);
	level_info_copy (self, dup);
	return dup;
}


void level_info_free (LevelInfo* self) {
	level_info_destroy (self);
	g_free (self);
}


GType level_info_get_type (void) {
	static volatile gsize level_info_type_id__volatile = 0;
	if (g_once_init_enter (&level_info_type_id__volatile)) {
		GType level_info_type_id;
		level_info_type_id = g_boxed_type_register_static ("LevelInfo", (GBoxedCopyFunc) level_info_dup, (GBoxedFreeFunc) level_info_free);
		g_once_init_leave (&level_info_type_id__volatile, level_info_type_id);
	}
	return level_info_type_id__volatile;
}


static void _klotski_restart_level_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_restart_level_cb (self);
}


static void _klotski_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_fullscreen_cb (self);
}


static void _klotski_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_scores_cb (self);
}


static void _klotski_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_help_cb (self);
}


static void _klotski_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_about_cb (self);
}


static void _klotski_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	klotski_quit_cb (self);
}


Klotski* klotski_construct (GType object_type) {
	Klotski * self = NULL;
	self = (Klotski*) g_object_new (object_type, "application-id", "org.gnome.klotski", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Klotski* klotski_new (void) {
	return klotski_construct (TYPE_KLOTSKI);
}


static gboolean _klotski_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = klotski_window_configure_event_cb (self, event);
	return result;
}


static gboolean _klotski_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = klotski_window_state_event_cb (self, event);
	return result;
}


static void _klotski_restart_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	klotski_restart_level_cb (self);
}


static void _klotski_next_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	klotski_next_level_cb (self);
}


static void _klotski_prev_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	klotski_prev_level_cb (self);
}


static void _klotski_level_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	klotski_level_cb (self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void klotski_real_startup (GApplication* base) {
	Klotski * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GtkRadioMenuItem** _tmp2_ = NULL;
	GtkImage** _tmp3_ = NULL;
	gchar* histfile = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	History* _tmp7_ = NULL;
	History* _tmp8_ = NULL;
	GtkApplicationWindow* _tmp9_ = NULL;
	GtkWindow* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkWindow* _tmp12_ = NULL;
	GtkWindow* _tmp13_ = NULL;
	gint ww = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint wh = 0;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GtkWindow* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GSettings* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GtkBox* vbox = NULL;
	GtkBox* _tmp29_ = NULL;
	GtkWindow* _tmp30_ = NULL;
	gchar* builder_str = NULL;
	gchar* _tmp31_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkMenuBar* menubar = NULL;
	GtkMenuBar* _tmp36_ = NULL;
	GtkMenuBar* _tmp37_ = NULL;
	GtkMenuBar* _tmp38_ = NULL;
	GtkMenuItem* game_item = NULL;
	GtkMenuItem* _tmp39_ = NULL;
	GtkMenuItem* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	GtkMenuItem* _tmp42_ = NULL;
	GtkMenuItem* _tmp43_ = NULL;
	GtkMenuBar* _tmp44_ = NULL;
	GtkMenuItem* _tmp45_ = NULL;
	GtkMenuItem* _tmp46_ = NULL;
	GtkMenu* _tmp47_ = NULL;
	GtkMenu* _tmp48_ = NULL;
	GtkAccelGroup* accel_group = NULL;
	GtkAccelGroup* _tmp49_ = NULL;
	GtkWindow* _tmp50_ = NULL;
	GtkAccelGroup* _tmp51_ = NULL;
	GtkMenuItem* item = NULL;
	GtkMenuItem* _tmp52_ = NULL;
	GtkMenuItem* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	GtkMenuItem* _tmp55_ = NULL;
	GtkMenuItem* _tmp56_ = NULL;
	GtkMenuItem* _tmp57_ = NULL;
	GtkAccelGroup* _tmp58_ = NULL;
	GtkMenuItem* _tmp59_ = NULL;
	GtkMenuItem* _tmp60_ = NULL;
	GtkMenu* _tmp61_ = NULL;
	GtkMenu* _tmp62_ = NULL;
	GtkMenuItem* _tmp63_ = NULL;
	GtkMenuItem* _tmp64_ = NULL;
	GtkMenuItem* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	GtkMenuItem* _tmp67_ = NULL;
	GtkMenuItem* _tmp68_ = NULL;
	GtkAccelGroup* _tmp69_ = NULL;
	GtkMenuItem* _tmp70_ = NULL;
	GtkMenuItem* _tmp71_ = NULL;
	GtkMenu* _tmp72_ = NULL;
	GtkMenu* _tmp73_ = NULL;
	GtkMenuItem* _tmp74_ = NULL;
	GtkMenuItem* _tmp75_ = NULL;
	GtkMenuItem* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	GtkMenuItem* _tmp78_ = NULL;
	GtkMenuItem* _tmp79_ = NULL;
	GtkAccelGroup* _tmp80_ = NULL;
	GtkMenuItem* _tmp81_ = NULL;
	GtkMenuItem* _tmp82_ = NULL;
	GtkMenu* _tmp83_ = NULL;
	GtkMenu* _tmp84_ = NULL;
	GtkMenuItem* _tmp85_ = NULL;
	GtkSeparatorMenuItem* _tmp86_ = NULL;
	GtkMenuItem* _tmp87_ = NULL;
	GtkMenuItem* _tmp88_ = NULL;
	GtkMenu* _tmp89_ = NULL;
	GtkMenu* _tmp90_ = NULL;
	GtkMenuItem* _tmp91_ = NULL;
	GtkMenuItem* huarong_item = NULL;
	GtkMenuItem* _tmp92_ = NULL;
	GtkMenuItem* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	GtkMenuItem* _tmp95_ = NULL;
	GtkMenuItem* _tmp96_ = NULL;
	GtkMenu* _tmp97_ = NULL;
	GtkMenu* _tmp98_ = NULL;
	GtkMenuItem* _tmp99_ = NULL;
	GtkMenu* _tmp100_ = NULL;
	GtkMenu* _tmp101_ = NULL;
	GtkMenuItem* _tmp102_ = NULL;
	GtkMenuItem* challenge_item = NULL;
	GtkMenuItem* _tmp103_ = NULL;
	GtkMenuItem* _tmp104_ = NULL;
	const gchar* _tmp105_ = NULL;
	GtkMenuItem* _tmp106_ = NULL;
	GtkMenuItem* _tmp107_ = NULL;
	GtkMenu* _tmp108_ = NULL;
	GtkMenu* _tmp109_ = NULL;
	GtkMenuItem* _tmp110_ = NULL;
	GtkMenu* _tmp111_ = NULL;
	GtkMenu* _tmp112_ = NULL;
	GtkMenuItem* _tmp113_ = NULL;
	GtkMenuItem* skill_item = NULL;
	GtkMenuItem* _tmp114_ = NULL;
	GtkMenuItem* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	GtkMenuItem* _tmp117_ = NULL;
	GtkMenuItem* _tmp118_ = NULL;
	GtkMenu* _tmp119_ = NULL;
	GtkMenu* _tmp120_ = NULL;
	GtkMenuItem* _tmp121_ = NULL;
	GtkMenu* _tmp122_ = NULL;
	GtkMenu* _tmp123_ = NULL;
	GtkMenuItem* _tmp124_ = NULL;
	GSList* group = NULL;
	GtkBox* status_box = NULL;
	GtkBox* _tmp207_ = NULL;
	GtkLabel* _tmp208_ = NULL;
	GtkLabel* _tmp209_ = NULL;
	GtkLabel* _tmp210_ = NULL;
	GtkLabel* _tmp211_ = NULL;
	GtkLabel* _tmp212_ = NULL;
	GtkLabel* _tmp213_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp214_ = NULL;
	GtkStyleContext* _tmp215_ = NULL;
	GtkToolButton* new_game_button = NULL;
	const gchar* _tmp216_ = NULL;
	GtkToolButton* _tmp217_ = NULL;
	const gchar* _tmp218_ = NULL;
	GtkToolButton* _tmp219_ = NULL;
	GtkToolButton* _tmp220_ = NULL;
	GtkToolButton* _tmp221_ = NULL;
	GtkToolButton* _tmp222_ = NULL;
	GtkToolButton* _tmp223_ = NULL;
	GtkToolButton* _tmp224_ = NULL;
	GtkAlignment* status_alignment = NULL;
	GtkAlignment* _tmp225_ = NULL;
	GtkToolItem* status_item = NULL;
	GtkToolItem* _tmp226_ = NULL;
	PuzzleView* _tmp227_ = NULL;
	PuzzleView* _tmp228_ = NULL;
	PuzzleView* _tmp229_ = NULL;
	PuzzleView* _tmp230_ = NULL;
	GtkSeparator* _tmp231_ = NULL;
	GtkSeparator* _tmp232_ = NULL;
	gint startup_level = 0;
	GSettings* _tmp233_ = NULL;
	gint _tmp234_ = 0;
	GError * _inner_error_ = NULL;
	self = (Klotski*) base;
	G_APPLICATION_CLASS (klotski_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _ ("Klotski");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_settings_new ("org.gnome.klotski");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	gtk_window_set_default_icon_name ("gnome-klotski");
	gtk_application_add_accelerator ((GtkApplication*) self, "F11", "app.fullscreen", NULL);
	_tmp2_ = g_new0 (GtkRadioMenuItem*, G_N_ELEMENTS (KLOTSKI_level) + 1);
	self->priv->level_items = (_vala_array_free (self->priv->level_items, self->priv->level_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->level_items = _tmp2_;
	self->priv->level_items_length1 = G_N_ELEMENTS (KLOTSKI_level);
	self->priv->_level_items_size_ = self->priv->level_items_length1;
	_tmp3_ = g_new0 (GtkImage*, G_N_ELEMENTS (KLOTSKI_level) + 1);
	self->priv->level_images = (_vala_array_free (self->priv->level_images, self->priv->level_images_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->level_images = _tmp3_;
	self->priv->level_images_length1 = G_N_ELEMENTS (KLOTSKI_level);
	self->priv->_level_images_size_ = self->priv->level_images_length1;
	_tmp4_ = g_get_user_data_dir ();
	_tmp5_ = g_build_filename (_tmp4_, "gnome-klotski", "history", NULL);
	histfile = _tmp5_;
	_tmp6_ = histfile;
	_tmp7_ = history_new (_tmp6_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp7_;
	_tmp8_ = self->priv->history;
	history_load (_tmp8_);
	_tmp9_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = (GtkWindow*) _tmp9_;
	_tmp10_ = self->priv->window;
	_tmp11_ = _ ("Klotski");
	gtk_window_set_title (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "configure-event", (GCallback) _klotski_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp13_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "window-state-event", (GCallback) _klotski_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_settings_get_int (_tmp14_, "window-width");
	ww = _tmp15_;
	_tmp16_ = self->priv->settings;
	_tmp17_ = g_settings_get_int (_tmp16_, "window-height");
	wh = _tmp17_;
	_tmp18_ = ww;
	if (_tmp18_ < KLOTSKI_MINWIDTH) {
		ww = KLOTSKI_MINWIDTH;
	}
	_tmp19_ = wh;
	if (_tmp19_ < KLOTSKI_MINHEIGHT) {
		wh = KLOTSKI_MINHEIGHT;
	}
	_tmp20_ = self->priv->window;
	_tmp21_ = ww;
	_tmp22_ = wh;
	gtk_window_set_default_size (_tmp20_, _tmp21_, _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_boolean (_tmp23_, "window-is-fullscreen");
	if (_tmp24_) {
		GtkWindow* _tmp25_ = NULL;
		_tmp25_ = self->priv->window;
		gtk_window_fullscreen (_tmp25_);
	} else {
		GSettings* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		_tmp26_ = self->priv->settings;
		_tmp27_ = g_settings_get_boolean (_tmp26_, "window-is-maximized");
		if (_tmp27_) {
			GtkWindow* _tmp28_ = NULL;
			_tmp28_ = self->priv->window;
			gtk_window_maximize (_tmp28_);
		}
	}
	_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp29_);
	vbox = _tmp29_;
	_tmp30_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) vbox);
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp31_ = g_strdup ("<interface>" "\n" \
"               <menu id='app-menu'>\n" \
"                  <section>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_New " \
"Game</attribute>\n" \
"                      <attribute name='action'>app.new-game</attribute" \
">\n" \
"                      <attribute name='accel'>&lt;Primary&gt;n</attrib" \
"ute>\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Scor" \
"es</attribute>\n" \
"                      <attribute name='action'>app.scores</attribute>\n" \
"                   </item>\n" \
"                  </section>\n" \
"                  <section>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Help" \
"</attribute>\n" \
"                      <attribute name='action'>app.help</attribute>\n" \
"                      <attribute name='accel'>F1</attribute>\n" \
"                   </item>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Abou" \
"t</attribute>\n" \
"                      <attribute name='action'>app.about</attribute>\n" \
"                   </item>\n" \
"                  </section>\n" \
"                  <section>\n" \
"                   <item>\n" \
"                      <attribute name='label' translatable='yes'>_Quit" \
"</attribute>\n" \
"                      <attribute name='action'>app.quit</attribute>\n" \
"                      <attribute name='accel'>&lt;Primary&gt;q</attrib" \
"ute>\n" \
"                   </item>\n" \
"                  </section>\n" \
"                </menu>\n" \
"               </interface>\n" \
"               ");
	builder_str = _tmp31_;
	_tmp32_ = gtk_builder_new ();
	builder = _tmp32_;
	{
		gtk_builder_add_from_string (builder, builder_str, (gsize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "%s\n", "Error in gnome-klotski.vala function startup() - builder.add_from_stri" \
"ng failed");
		_tmp34_ = e->message;
		g_error ("gnome-klotski.vala:536: %s", _tmp34_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_free0 (builder_str);
		_g_object_unref0 (vbox);
		_g_free0 (histfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp35_ = gtk_builder_get_object (builder, "app-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp35_) : NULL);
	_tmp36_ = (GtkMenuBar*) gtk_menu_bar_new ();
	g_object_ref_sink (_tmp36_);
	menubar = _tmp36_;
	_tmp37_ = menubar;
	gtk_widget_set_visible ((GtkWidget*) _tmp37_, TRUE);
	_tmp38_ = menubar;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp38_, FALSE, FALSE, (guint) 0);
	_tmp39_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp39_);
	game_item = _tmp39_;
	_tmp40_ = game_item;
	_tmp41_ = _ ("_Game");
	gtk_menu_item_set_label (_tmp40_, _tmp41_);
	_tmp42_ = game_item;
	gtk_menu_item_set_use_underline (_tmp42_, TRUE);
	_tmp43_ = game_item;
	gtk_widget_set_visible ((GtkWidget*) _tmp43_, TRUE);
	_tmp44_ = menubar;
	_tmp45_ = game_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = game_item;
	_tmp47_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp47_);
	_tmp48_ = _tmp47_;
	gtk_menu_item_set_submenu (_tmp46_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = gtk_accel_group_new ();
	accel_group = _tmp49_;
	_tmp50_ = self->priv->window;
	_tmp51_ = accel_group;
	gtk_window_add_accel_group (_tmp50_, _tmp51_);
	_tmp52_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp52_);
	item = _tmp52_;
	_tmp53_ = item;
	_tmp54_ = _ ("_Restart Puzzle");
	gtk_menu_item_set_label (_tmp53_, _tmp54_);
	_tmp55_ = item;
	gtk_menu_item_set_use_underline (_tmp55_, TRUE);
	_tmp56_ = item;
	g_signal_connect_object (_tmp56_, "activate", (GCallback) _klotski_restart_level_cb_gtk_menu_item_activate, self, 0);
	_tmp57_ = item;
	_tmp58_ = accel_group;
	gtk_widget_add_accelerator ((GtkWidget*) _tmp57_, "activate", _tmp58_, (guint) GDK_KEY_R, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	_tmp59_ = item;
	gtk_widget_set_visible ((GtkWidget*) _tmp59_, TRUE);
	_tmp60_ = game_item;
	_tmp61_ = gtk_menu_item_get_submenu (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->next_menu_item);
	self->priv->next_menu_item = _tmp64_;
	_tmp65_ = self->priv->next_menu_item;
	_tmp66_ = _ ("Next Puzzle");
	gtk_menu_item_set_label (_tmp65_, _tmp66_);
	_tmp67_ = self->priv->next_menu_item;
	g_signal_connect_object (_tmp67_, "activate", (GCallback) _klotski_next_level_cb_gtk_menu_item_activate, self, 0);
	_tmp68_ = self->priv->next_menu_item;
	_tmp69_ = accel_group;
	gtk_widget_add_accelerator ((GtkWidget*) _tmp68_, "activate", _tmp69_, (guint) GDK_KEY_Page_Down, 0, GTK_ACCEL_VISIBLE);
	_tmp70_ = self->priv->next_menu_item;
	gtk_widget_set_visible ((GtkWidget*) _tmp70_, TRUE);
	_tmp71_ = game_item;
	_tmp72_ = gtk_menu_item_get_submenu (_tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = self->priv->next_menu_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->prev_menu_item);
	self->priv->prev_menu_item = _tmp75_;
	_tmp76_ = self->priv->prev_menu_item;
	_tmp77_ = _ ("Previous Puzzle");
	gtk_menu_item_set_label (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->prev_menu_item;
	g_signal_connect_object (_tmp78_, "activate", (GCallback) _klotski_prev_level_cb_gtk_menu_item_activate, self, 0);
	_tmp79_ = self->priv->prev_menu_item;
	_tmp80_ = accel_group;
	gtk_widget_add_accelerator ((GtkWidget*) _tmp79_, "activate", _tmp80_, (guint) GDK_KEY_Page_Up, 0, GTK_ACCEL_VISIBLE);
	_tmp81_ = self->priv->prev_menu_item;
	gtk_widget_set_visible ((GtkWidget*) _tmp81_, TRUE);
	_tmp82_ = game_item;
	_tmp83_ = gtk_menu_item_get_submenu (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = self->priv->prev_menu_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp84_, (GtkWidget*) _tmp85_);
	_tmp86_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp86_);
	_g_object_unref0 (item);
	item = (GtkMenuItem*) _tmp86_;
	_tmp87_ = item;
	gtk_widget_set_visible ((GtkWidget*) _tmp87_, TRUE);
	_tmp88_ = game_item;
	_tmp89_ = gtk_menu_item_get_submenu (_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp90_, (GtkWidget*) _tmp91_);
	_tmp92_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp92_);
	huarong_item = _tmp92_;
	_tmp93_ = huarong_item;
	_tmp94_ = _ ("HuaRong Trail");
	gtk_menu_item_set_label (_tmp93_, _tmp94_);
	_tmp95_ = huarong_item;
	gtk_widget_set_visible ((GtkWidget*) _tmp95_, TRUE);
	_tmp96_ = huarong_item;
	_tmp97_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp97_);
	_tmp98_ = _tmp97_;
	gtk_menu_item_set_submenu (_tmp96_, _tmp98_);
	_g_object_unref0 (_tmp98_);
	_tmp99_ = game_item;
	_tmp100_ = gtk_menu_item_get_submenu (_tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = huarong_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp101_, (GtkWidget*) _tmp102_);
	_tmp103_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp103_);
	challenge_item = _tmp103_;
	_tmp104_ = challenge_item;
	_tmp105_ = _ ("Challenge Pack");
	gtk_menu_item_set_label (_tmp104_, _tmp105_);
	_tmp106_ = challenge_item;
	gtk_widget_set_visible ((GtkWidget*) _tmp106_, TRUE);
	_tmp107_ = challenge_item;
	_tmp108_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp108_);
	_tmp109_ = _tmp108_;
	gtk_menu_item_set_submenu (_tmp107_, _tmp109_);
	_g_object_unref0 (_tmp109_);
	_tmp110_ = game_item;
	_tmp111_ = gtk_menu_item_get_submenu (_tmp110_);
	_tmp112_ = _tmp111_;
	_tmp113_ = challenge_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp112_, (GtkWidget*) _tmp113_);
	_tmp114_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp114_);
	skill_item = _tmp114_;
	_tmp115_ = skill_item;
	_tmp116_ = _ ("Skill Pack");
	gtk_menu_item_set_label (_tmp115_, _tmp116_);
	_tmp117_ = skill_item;
	gtk_widget_set_visible ((GtkWidget*) _tmp117_, TRUE);
	_tmp118_ = skill_item;
	_tmp119_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp119_);
	_tmp120_ = _tmp119_;
	gtk_menu_item_set_submenu (_tmp118_, _tmp120_);
	_g_object_unref0 (_tmp120_);
	_tmp121_ = game_item;
	_tmp122_ = gtk_menu_item_get_submenu (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = skill_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp123_, (GtkWidget*) _tmp124_);
	group = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp125_ = FALSE;
			_tmp125_ = TRUE;
			while (TRUE) {
				gboolean _tmp126_ = FALSE;
				gint _tmp128_ = 0;
				gchar* label = NULL;
				gint _tmp129_ = 0;
				LevelInfo _tmp130_ = {0};
				const gchar* _tmp131_ = NULL;
				const gchar* _tmp132_ = NULL;
				gchar* _tmp133_ = NULL;
				GtkRadioMenuItem** _tmp134_ = NULL;
				gint _tmp134__length1 = 0;
				gint _tmp135_ = 0;
				GSList* _tmp136_ = NULL;
				GtkRadioMenuItem* _tmp137_ = NULL;
				GtkRadioMenuItem* _tmp138_ = NULL;
				GtkRadioMenuItem** _tmp139_ = NULL;
				gint _tmp139__length1 = 0;
				gint _tmp140_ = 0;
				GtkRadioMenuItem* _tmp141_ = NULL;
				GSList* _tmp142_ = NULL;
				GtkRadioMenuItem** _tmp143_ = NULL;
				gint _tmp143__length1 = 0;
				gint _tmp144_ = 0;
				GtkRadioMenuItem* _tmp145_ = NULL;
				GtkRadioMenuItem** _tmp146_ = NULL;
				gint _tmp146__length1 = 0;
				gint _tmp147_ = 0;
				GtkRadioMenuItem* _tmp148_ = NULL;
				GtkRadioMenuItem** _tmp149_ = NULL;
				gint _tmp149__length1 = 0;
				gint _tmp150_ = 0;
				GtkRadioMenuItem* _tmp151_ = NULL;
				gint _tmp152_ = 0;
				gint _tmp153_ = 0;
				LevelInfo _tmp154_ = {0};
				gint _tmp155_ = 0;
				GtkBox* box = NULL;
				GtkBox* _tmp174_ = NULL;
				GtkLabel* labelw = NULL;
				const gchar* _tmp175_ = NULL;
				GtkLabel* _tmp176_ = NULL;
				GtkLabel* _tmp177_ = NULL;
				GtkImage* image = NULL;
				GtkImage* _tmp178_ = NULL;
				GtkBox* _tmp179_ = NULL;
				GtkLabel* _tmp180_ = NULL;
				GtkBox* _tmp181_ = NULL;
				GtkImage* _tmp182_ = NULL;
				gint _tmp183_ = 0;
				LevelInfo _tmp184_ = {0};
				gint _tmp185_ = 0;
				GtkSizeGroup* _tmp186_ = NULL;
				gint _tmp192_ = 0;
				LevelInfo _tmp193_ = {0};
				gint _tmp194_ = 0;
				GtkSizeGroup* _tmp195_ = NULL;
				GtkBox* _tmp196_ = NULL;
				GtkRadioMenuItem** _tmp197_ = NULL;
				gint _tmp197__length1 = 0;
				gint _tmp198_ = 0;
				GtkRadioMenuItem* _tmp199_ = NULL;
				GtkBox* _tmp200_ = NULL;
				GtkBox* _tmp201_ = NULL;
				GtkImage** _tmp202_ = NULL;
				gint _tmp202__length1 = 0;
				gint _tmp203_ = 0;
				GtkImage* _tmp204_ = NULL;
				GtkImage* _tmp205_ = NULL;
				GtkImage* _tmp206_ = NULL;
				_tmp126_ = _tmp125_;
				if (!_tmp126_) {
					gint _tmp127_ = 0;
					_tmp127_ = i;
					i = _tmp127_ + 1;
				}
				_tmp125_ = FALSE;
				_tmp128_ = i;
				if (!(_tmp128_ < G_N_ELEMENTS (KLOTSKI_level))) {
					break;
				}
				_tmp129_ = i;
				_tmp130_ = KLOTSKI_level[_tmp129_];
				_tmp131_ = _tmp130_.name;
				_tmp132_ = _ (_tmp131_);
				_tmp133_ = g_strdup (_tmp132_);
				label = _tmp133_;
				_tmp134_ = self->priv->level_items;
				_tmp134__length1 = self->priv->level_items_length1;
				_tmp135_ = i;
				_tmp136_ = group;
				_tmp137_ = (GtkRadioMenuItem*) gtk_radio_menu_item_new (_tmp136_);
				g_object_ref_sink (_tmp137_);
				_g_object_unref0 (_tmp134_[_tmp135_]);
				_tmp134_[_tmp135_] = _tmp137_;
				_tmp138_ = _tmp134_[_tmp135_];
				_tmp139_ = self->priv->level_items;
				_tmp139__length1 = self->priv->level_items_length1;
				_tmp140_ = i;
				_tmp141_ = _tmp139_[_tmp140_];
				_tmp142_ = gtk_radio_menu_item_get_group (_tmp141_);
				group = _tmp142_;
				_tmp143_ = self->priv->level_items;
				_tmp143__length1 = self->priv->level_items_length1;
				_tmp144_ = i;
				_tmp145_ = _tmp143_[_tmp144_];
				gtk_widget_set_visible ((GtkWidget*) _tmp145_, TRUE);
				_tmp146_ = self->priv->level_items;
				_tmp146__length1 = self->priv->level_items_length1;
				_tmp147_ = i;
				_tmp148_ = _tmp146_[_tmp147_];
				g_signal_connect_object ((GtkMenuItem*) _tmp148_, "activate", (GCallback) _klotski_level_cb_gtk_menu_item_activate, self, 0);
				_tmp149_ = self->priv->level_items;
				_tmp149__length1 = self->priv->level_items_length1;
				_tmp150_ = i;
				_tmp151_ = _tmp149_[_tmp150_];
				_tmp152_ = i;
				g_object_set_data_full ((GObject*) _tmp151_, "level-id", (gpointer) ((gintptr) _tmp152_), NULL);
				_tmp153_ = i;
				_tmp154_ = KLOTSKI_level[_tmp153_];
				_tmp155_ = _tmp154_.group;
				switch (_tmp155_) {
					case 0:
					{
						GtkMenuItem* _tmp156_ = NULL;
						GtkMenu* _tmp157_ = NULL;
						GtkMenu* _tmp158_ = NULL;
						GtkRadioMenuItem** _tmp159_ = NULL;
						gint _tmp159__length1 = 0;
						gint _tmp160_ = 0;
						GtkRadioMenuItem* _tmp161_ = NULL;
						_tmp156_ = huarong_item;
						_tmp157_ = gtk_menu_item_get_submenu (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = self->priv->level_items;
						_tmp159__length1 = self->priv->level_items_length1;
						_tmp160_ = i;
						_tmp161_ = _tmp159_[_tmp160_];
						gtk_menu_shell_append ((GtkMenuShell*) _tmp158_, (GtkWidget*) ((GtkMenuItem*) _tmp161_));
						break;
					}
					case 1:
					{
						GtkMenuItem* _tmp162_ = NULL;
						GtkMenu* _tmp163_ = NULL;
						GtkMenu* _tmp164_ = NULL;
						GtkRadioMenuItem** _tmp165_ = NULL;
						gint _tmp165__length1 = 0;
						gint _tmp166_ = 0;
						GtkRadioMenuItem* _tmp167_ = NULL;
						_tmp162_ = challenge_item;
						_tmp163_ = gtk_menu_item_get_submenu (_tmp162_);
						_tmp164_ = _tmp163_;
						_tmp165_ = self->priv->level_items;
						_tmp165__length1 = self->priv->level_items_length1;
						_tmp166_ = i;
						_tmp167_ = _tmp165_[_tmp166_];
						gtk_menu_shell_append ((GtkMenuShell*) _tmp164_, (GtkWidget*) ((GtkMenuItem*) _tmp167_));
						break;
					}
					case 2:
					{
						GtkMenuItem* _tmp168_ = NULL;
						GtkMenu* _tmp169_ = NULL;
						GtkMenu* _tmp170_ = NULL;
						GtkRadioMenuItem** _tmp171_ = NULL;
						gint _tmp171__length1 = 0;
						gint _tmp172_ = 0;
						GtkRadioMenuItem* _tmp173_ = NULL;
						_tmp168_ = skill_item;
						_tmp169_ = gtk_menu_item_get_submenu (_tmp168_);
						_tmp170_ = _tmp169_;
						_tmp171_ = self->priv->level_items;
						_tmp171__length1 = self->priv->level_items_length1;
						_tmp172_ = i;
						_tmp173_ = _tmp171_[_tmp172_];
						gtk_menu_shell_append ((GtkMenuShell*) _tmp170_, (GtkWidget*) ((GtkMenuItem*) _tmp173_));
						break;
					}
					default:
					break;
				}
				_tmp174_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
				g_object_ref_sink (_tmp174_);
				box = _tmp174_;
				_tmp175_ = label;
				_tmp176_ = (GtkLabel*) gtk_label_new (_tmp175_);
				g_object_ref_sink (_tmp176_);
				labelw = _tmp176_;
				_tmp177_ = labelw;
				gtk_misc_set_alignment ((GtkMisc*) _tmp177_, 0.0f, 0.5f);
				_tmp178_ = (GtkImage*) gtk_image_new ();
				g_object_ref_sink (_tmp178_);
				image = _tmp178_;
				_tmp179_ = box;
				_tmp180_ = labelw;
				gtk_box_pack_start (_tmp179_, (GtkWidget*) _tmp180_, TRUE, TRUE, (guint) 0);
				_tmp181_ = box;
				_tmp182_ = image;
				gtk_box_pack_start (_tmp181_, (GtkWidget*) _tmp182_, FALSE, TRUE, (guint) 0);
				_tmp183_ = i;
				_tmp184_ = KLOTSKI_level[_tmp183_];
				_tmp185_ = _tmp184_.group;
				_tmp186_ = self->priv->groups[_tmp185_];
				if (_tmp186_ == NULL) {
					gint _tmp187_ = 0;
					LevelInfo _tmp188_ = {0};
					gint _tmp189_ = 0;
					GtkSizeGroup* _tmp190_ = NULL;
					GtkSizeGroup* _tmp191_ = NULL;
					_tmp187_ = i;
					_tmp188_ = KLOTSKI_level[_tmp187_];
					_tmp189_ = _tmp188_.group;
					_tmp190_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
					_g_object_unref0 (self->priv->groups[_tmp189_]);
					self->priv->groups[_tmp189_] = _tmp190_;
					_tmp191_ = self->priv->groups[_tmp189_];
				}
				_tmp192_ = i;
				_tmp193_ = KLOTSKI_level[_tmp192_];
				_tmp194_ = _tmp193_.group;
				_tmp195_ = self->priv->groups[_tmp194_];
				_tmp196_ = box;
				gtk_size_group_add_widget (_tmp195_, (GtkWidget*) _tmp196_);
				_tmp197_ = self->priv->level_items;
				_tmp197__length1 = self->priv->level_items_length1;
				_tmp198_ = i;
				_tmp199_ = _tmp197_[_tmp198_];
				_tmp200_ = box;
				gtk_container_add ((GtkContainer*) _tmp199_, (GtkWidget*) _tmp200_);
				_tmp201_ = box;
				gtk_widget_show_all ((GtkWidget*) _tmp201_);
				_tmp202_ = self->priv->level_images;
				_tmp202__length1 = self->priv->level_images_length1;
				_tmp203_ = i;
				_tmp204_ = image;
				_tmp205_ = _g_object_ref0 (_tmp204_);
				_g_object_unref0 (_tmp202_[_tmp203_]);
				_tmp202_[_tmp203_] = _tmp205_;
				_tmp206_ = _tmp202_[_tmp203_];
				_g_object_unref0 (image);
				_g_object_unref0 (labelw);
				_g_object_unref0 (box);
				_g_free0 (label);
			}
		}
	}
	_tmp207_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp207_);
	status_box = _tmp207_;
	gtk_widget_show ((GtkWidget*) status_box);
	_tmp208_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp208_);
	_g_object_unref0 (self->priv->messagewidget);
	self->priv->messagewidget = _tmp208_;
	_tmp209_ = self->priv->messagewidget;
	gtk_widget_show ((GtkWidget*) _tmp209_);
	_tmp210_ = self->priv->messagewidget;
	gtk_box_pack_start (status_box, (GtkWidget*) _tmp210_, FALSE, FALSE, (guint) 0);
	_tmp211_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp211_);
	_g_object_unref0 (self->priv->moves_label);
	self->priv->moves_label = _tmp211_;
	_tmp212_ = self->priv->moves_label;
	gtk_widget_show ((GtkWidget*) _tmp212_);
	_tmp213_ = self->priv->moves_label;
	gtk_box_pack_start (status_box, (GtkWidget*) _tmp213_, FALSE, FALSE, (guint) 0);
	_tmp214_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp214_);
	toolbar = _tmp214_;
	gtk_widget_show ((GtkWidget*) toolbar);
	gtk_toolbar_set_show_arrow (toolbar, FALSE);
	_tmp215_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	gtk_style_context_add_class (_tmp215_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp216_ = _ ("_New");
	_tmp217_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp216_);
	g_object_ref_sink (_tmp217_);
	new_game_button = _tmp217_;
	gtk_tool_button_set_icon_name (new_game_button, "document-new");
	gtk_tool_button_set_use_underline (new_game_button, TRUE);
	gtk_actionable_set_action_name ((GtkActionable*) new_game_button, "app.new-game");
	gtk_tool_item_set_is_important ((GtkToolItem*) new_game_button, TRUE);
	gtk_widget_show ((GtkWidget*) new_game_button);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) new_game_button, -1);
	_tmp218_ = _ ("_Fullscreen");
	_tmp219_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp218_);
	g_object_ref_sink (_tmp219_);
	_g_object_unref0 (self->priv->fullscreen_button);
	self->priv->fullscreen_button = _tmp219_;
	_tmp220_ = self->priv->fullscreen_button;
	gtk_tool_button_set_icon_name (_tmp220_, "view-fullscreen");
	_tmp221_ = self->priv->fullscreen_button;
	gtk_tool_button_set_use_underline (_tmp221_, TRUE);
	_tmp222_ = self->priv->fullscreen_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp222_, "app.fullscreen");
	_tmp223_ = self->priv->fullscreen_button;
	gtk_widget_show ((GtkWidget*) _tmp223_);
	_tmp224_ = self->priv->fullscreen_button;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp224_, -1);
	_tmp225_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp225_);
	status_alignment = _tmp225_;
	gtk_container_add ((GtkContainer*) status_alignment, (GtkWidget*) status_box);
	gtk_widget_show ((GtkWidget*) status_alignment);
	_tmp226_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp226_);
	status_item = _tmp226_;
	gtk_tool_item_set_expand (status_item, TRUE);
	gtk_container_add ((GtkContainer*) status_item, (GtkWidget*) status_alignment);
	gtk_widget_show ((GtkWidget*) status_item);
	gtk_toolbar_insert (toolbar, status_item, -1);
	gtk_box_pack_start (vbox, (GtkWidget*) toolbar, FALSE, FALSE, (guint) 0);
	_tmp227_ = puzzle_view_new ();
	g_object_ref_sink (_tmp227_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp227_;
	_tmp228_ = self->priv->view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp228_, KLOTSKI_MINWIDTH, KLOTSKI_MINHEIGHT);
	_tmp229_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp229_);
	_tmp230_ = self->priv->view;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp230_, TRUE, TRUE, (guint) 0);
	_tmp231_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp231_);
	_tmp232_ = _tmp231_;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp232_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp232_);
	klotski_load_solved_state (self);
	_tmp233_ = self->priv->settings;
	_tmp234_ = g_settings_get_int (_tmp233_, KLOTSKI_KEY_LEVEL);
	startup_level = _tmp234_;
	klotski_new_game (self, startup_level);
	_g_object_unref0 (status_item);
	_g_object_unref0 (status_alignment);
	_g_object_unref0 (new_game_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (status_box);
	_g_object_unref0 (skill_item);
	_g_object_unref0 (challenge_item);
	_g_object_unref0 (huarong_item);
	_g_object_unref0 (item);
	_g_object_unref0 (accel_group);
	_g_object_unref0 (game_item);
	_g_object_unref0 (menubar);
	_g_object_unref0 (builder);
	_g_free0 (builder_str);
	_g_object_unref0 (vbox);
	_g_free0 (histfile);
}


static gboolean klotski_window_configure_event_cb (Klotski* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_fullscreen;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GdkEventConfigure _tmp4_ = {0};
		gint _tmp5_ = 0;
		GdkEventConfigure _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.width;
		self->priv->window_width = _tmp5_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.height;
		self->priv->window_height = _tmp7_;
	}
	result = FALSE;
	return result;
}


static gboolean klotski_window_state_event_cb (Klotski* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState _tmp4_ = {0};
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState _tmp6_ = {0};
		GdkWindowState _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.new_window_state;
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
		_tmp8_ = self->priv->is_fullscreen;
		if (_tmp8_) {
			GtkToolButton* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GtkToolButton* _tmp11_ = NULL;
			_tmp9_ = self->priv->fullscreen_button;
			_tmp10_ = _ ("_Leave Fullscreen");
			gtk_tool_button_set_label (_tmp9_, _tmp10_);
			_tmp11_ = self->priv->fullscreen_button;
			gtk_tool_button_set_icon_name (_tmp11_, "view-restore");
		} else {
			GtkToolButton* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GtkToolButton* _tmp14_ = NULL;
			_tmp12_ = self->priv->fullscreen_button;
			_tmp13_ = _ ("_Fullscreen");
			gtk_tool_button_set_label (_tmp12_, _tmp13_);
			_tmp14_ = self->priv->fullscreen_button;
			gtk_tool_button_set_icon_name (_tmp14_, "view-fullscreen");
		}
	}
	result = FALSE;
	return result;
}


static void klotski_scores_cb (Klotski* self) {
	g_return_if_fail (self != NULL);
	klotski_show_scores (self, NULL, FALSE);
}


static void klotski_game_score (Klotski* self) {
	gchar* key = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp2_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkImage** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp8_ = 0;
	GtkImage* _tmp9_ = NULL;
	GDateTime* date = NULL;
	GDateTime* _tmp10_ = NULL;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	Puzzle* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	HistoryEntry* _tmp15_ = NULL;
	History* _tmp16_ = NULL;
	HistoryEntry* _tmp17_ = NULL;
	History* _tmp18_ = NULL;
	HistoryEntry* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	_tmp1_ = klotski_get_level_key (self, _tmp0_);
	key = _tmp1_;
	_tmp2_ = g_key_file_new ();
	keyfile = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-klotski", "levels", NULL);
	filename = _tmp4_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_key_file_set_boolean (keyfile, key, "solved", TRUE);
	{
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = g_key_file_to_data (keyfile, NULL, NULL);
		_tmp6_ = _tmp5_;
		g_file_set_contents (filename, _tmp6_, (gssize) (-1), &_inner_error_);
		_g_free0 (_tmp6_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->level_images;
	_tmp7__length1 = self->priv->level_images_length1;
	_tmp8_ = self->priv->current_level;
	_tmp9_ = _tmp7_[_tmp8_];
	gtk_image_set_from_icon_name (_tmp9_, "gtk-yes", GTK_ICON_SIZE_MENU);
	_tmp10_ = g_date_time_new_now_local ();
	date = _tmp10_;
	_tmp11_ = date;
	_tmp12_ = self->priv->current_level;
	_tmp13_ = self->priv->puzzle;
	_tmp14_ = _tmp13_->moves;
	_tmp15_ = history_entry_new (_tmp11_, (guint) _tmp12_, (guint) _tmp14_);
	entry = _tmp15_;
	_tmp16_ = self->priv->history;
	_tmp17_ = entry;
	history_add (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->history;
	history_save (_tmp18_);
	_tmp19_ = entry;
	_tmp20_ = klotski_show_scores (self, _tmp19_, TRUE);
	if (_tmp20_ == ((gint) GTK_RESPONSE_CLOSE)) {
		GtkWindow* _tmp21_ = NULL;
		_tmp21_ = self->priv->window;
		gtk_widget_destroy ((GtkWidget*) _tmp21_);
	} else {
		gint _tmp22_ = 0;
		_tmp22_ = self->priv->current_level;
		klotski_new_game (self, _tmp22_);
	}
	_history_entry_unref0 (entry);
	_g_date_time_unref0 (date);
	_g_free0 (filename);
	_g_key_file_free0 (keyfile);
	_g_free0 (key);
}


static gint klotski_show_scores (Klotski* self, HistoryEntry* selected_entry, gboolean show_quit) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_quit;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* klotski_get_level_key (Klotski* self, gint level_number) {
	gchar* result = NULL;
	guint32 _result_ = 0U;
	gchar* data = NULL;
	gint _tmp0_ = 0;
	LevelInfo _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint32 _tmp23_ = 0U;
	gchar* _tmp24_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = (guint32) 0xFFFFFFFFU;
	_tmp0_ = level_number;
	_tmp1_ = KLOTSKI_level[_tmp0_];
	_tmp2_ = _tmp1_.data;
	_tmp3_ = g_strdup (_tmp2_);
	data = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gchar _tmp9_ = '\0';
				gchar octet = '\0';
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gchar _tmp12_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = data;
				_tmp8_ = i;
				_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
				if (!(_tmp9_ != '\0')) {
					break;
				}
				_tmp10_ = data;
				_tmp11_ = i;
				_tmp12_ = string_get (_tmp10_, (glong) _tmp11_);
				octet = _tmp12_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_ = FALSE;
							gint _tmp16_ = 0;
							gchar _tmp17_ = '\0';
							guint32 _tmp18_ = 0U;
							guint32 _tmp21_ = 0U;
							gchar _tmp22_ = '\0';
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_ = 0;
								_tmp15_ = j;
								j = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = j;
							if (!(_tmp16_ < 8)) {
								break;
							}
							_tmp17_ = octet;
							_tmp18_ = _result_;
							if (((_tmp17_ >> 7) ^ (_tmp18_ >> 31)) != ((guint32) 0)) {
								guint32 _tmp19_ = 0U;
								_tmp19_ = _result_;
								_result_ = (_tmp19_ << 1) ^ 0x04c11db7;
							} else {
								guint32 _tmp20_ = 0U;
								_tmp20_ = _result_;
								_result_ = _tmp20_ << 1;
							}
							_tmp21_ = _result_;
							_result_ = _tmp21_ & 0xFFFFFFFFLL;
							_tmp22_ = octet;
							octet = (gchar) (_tmp22_ << 1);
						}
					}
				}
			}
		}
	}
	_tmp23_ = _result_;
	_tmp24_ = g_strdup_printf ("%08X", (guint) (~_tmp23_));
	result = _tmp24_;
	_g_free0 (data);
	return result;
}


static void klotski_load_solved_state (Klotski* self) {
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-klotski", "levels", NULL);
	filename = _tmp2_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_key_file_free0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				gchar* key = NULL;
				gint _tmp7_ = 0;
				gchar* _tmp8_ = NULL;
				gboolean value = FALSE;
				gboolean _tmp12_ = FALSE;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < G_N_ELEMENTS (KLOTSKI_level))) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = klotski_get_level_key (self, _tmp7_);
				key = _tmp8_;
				value = FALSE;
				{
					gboolean _tmp9_ = FALSE;
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp10_ = key;
					_tmp11_ = g_key_file_get_boolean (keyfile, _tmp10_, "solved", &_inner_error_);
					_tmp9_ = _tmp11_;
					if (_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
					value = _tmp9_;
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					_g_free0 (key);
					_g_free0 (filename);
					_g_key_file_free0 (keyfile);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp12_ = value;
				if (_tmp12_) {
					GtkImage** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gint _tmp14_ = 0;
					GtkImage* _tmp15_ = NULL;
					_tmp13_ = self->priv->level_images;
					_tmp13__length1 = self->priv->level_images_length1;
					_tmp14_ = i;
					_tmp15_ = _tmp13_[_tmp14_];
					gtk_image_set_from_icon_name (_tmp15_, "gtk-yes", GTK_ICON_SIZE_MENU);
				}
				_g_free0 (key);
			}
		}
	}
	_g_free0 (filename);
	_g_key_file_free0 (keyfile);
}


static void klotski_update_menu_state (Klotski* self) {
	GtkRadioMenuItem** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	GtkRadioMenuItem* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkMenuItem* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->level_items;
	_tmp0__length1 = self->priv->level_items_length1;
	_tmp1_ = self->priv->current_level;
	_tmp2_ = _tmp0_[_tmp1_];
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp2_, TRUE);
	_tmp3_ = self->priv->next_menu_item;
	_tmp4_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_ < (G_N_ELEMENTS (KLOTSKI_level) - 1));
	_tmp5_ = self->priv->prev_menu_item;
	_tmp6_ = self->priv->current_level;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_ > 0);
	klotski_update_moves_label (self);
}


static void _klotski_puzzle_moved_cb_puzzle_moved (Puzzle* _sender, gpointer self) {
	klotski_puzzle_moved_cb (self);
}


static void klotski_new_game (Klotski* self, gint requested_level) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkLabel* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	LevelInfo _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	LevelInfo _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	LevelInfo _tmp16_ = {0};
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	LevelInfo _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	Puzzle* _tmp21_ = NULL;
	Puzzle* _tmp22_ = NULL;
	PuzzleView* _tmp23_ = NULL;
	Puzzle* _tmp24_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = requested_level;
	_tmp1_ = CLAMP (_tmp0_, 0, G_N_ELEMENTS (KLOTSKI_level) - 1);
	self->priv->current_level = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->current_level;
	g_settings_set_int (_tmp2_, KLOTSKI_KEY_LEVEL, _tmp3_);
	_tmp4_ = self->priv->messagewidget;
	_tmp5_ = _ ("Puzzle: ");
	_tmp6_ = self->priv->current_level;
	_tmp7_ = KLOTSKI_level[_tmp6_];
	_tmp8_ = _tmp7_.name;
	_tmp9_ = _ (_tmp8_);
	_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_text (_tmp4_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->current_level;
	_tmp13_ = KLOTSKI_level[_tmp12_];
	_tmp14_ = _tmp13_.width;
	_tmp15_ = self->priv->current_level;
	_tmp16_ = KLOTSKI_level[_tmp15_];
	_tmp17_ = _tmp16_.height;
	_tmp18_ = self->priv->current_level;
	_tmp19_ = KLOTSKI_level[_tmp18_];
	_tmp20_ = _tmp19_.data;
	_tmp21_ = puzzle_new (_tmp14_, _tmp17_, _tmp20_);
	_puzzle_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp21_;
	_tmp22_ = self->priv->puzzle;
	g_signal_connect_object (_tmp22_, "moved", (GCallback) _klotski_puzzle_moved_cb_puzzle_moved, self, 0);
	_tmp23_ = self->priv->view;
	_tmp24_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp23_, _tmp24_);
	klotski_update_menu_state (self);
}


static void klotski_puzzle_moved_cb (Klotski* self) {
	g_return_if_fail (self != NULL);
	klotski_update_moves_label (self);
}


static void klotski_update_moves_label (Klotski* self) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->moves_label;
	_tmp1_ = _ ("Moves: %d");
	_tmp2_ = self->priv->puzzle;
	_tmp3_ = _tmp2_->moves;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_text (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->puzzle;
	_tmp7_ = puzzle_game_over (_tmp6_);
	if (_tmp7_) {
		GtkLabel* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = self->priv->messagewidget;
		_tmp9_ = _ ("Level completed.");
		gtk_label_set_text (_tmp8_, _tmp9_);
		klotski_game_score (self);
	}
}


static void klotski_quit_cb (Klotski* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void klotski_level_cb (Klotski* self, GtkMenuItem* item) {
	GtkMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint requested_level = 0;
	GtkMenuItem* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_RADIO_MENU_ITEM) ? ((GtkRadioMenuItem*) _tmp0_) : NULL));
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = item;
	_tmp4_ = g_object_get_data ((GObject*) _tmp3_, "level-id");
	requested_level = (gint) ((gintptr) _tmp4_);
	_tmp5_ = self->priv->current_level;
	_tmp6_ = requested_level;
	if (_tmp5_ != _tmp6_) {
		gint _tmp7_ = 0;
		_tmp7_ = requested_level;
		klotski_new_game (self, _tmp7_);
	}
}


static void klotski_restart_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_);
}


static void klotski_next_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_ + 1);
}


static void klotski_prev_level_cb (Klotski* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	klotski_new_game (self, _tmp0_ - 1);
}


static void klotski_help_cb (Klotski* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-klotski", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-klotski.vala:914: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void klotski_real_shutdown (GApplication* base) {
	Klotski * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	self = (Klotski*) base;
	G_APPLICATION_CLASS (klotski_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->is_fullscreen;
	g_settings_set_boolean (_tmp6_, "window-is-fullscreen", _tmp7_);
}


static void klotski_real_activate (GApplication* base) {
	Klotski * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Klotski*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present (_tmp0_);
}


static void klotski_fullscreen_cb (Klotski* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_fullscreen;
	if (_tmp0_) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->window;
		gtk_window_unfullscreen (_tmp1_);
	} else {
		GtkWindow* _tmp2_ = NULL;
		_tmp2_ = self->priv->window;
		gtk_window_fullscreen (_tmp2_);
	}
}


static void klotski_about_cb (Klotski* self) {
	static const gchar* authors[] = {"Lars Rydlinge (original author)", "Robert Ancell (port to vala)", "John Cheetham (port to vala)", NULL};
	static const gchar* documenters[] = {"Andrew Sobala", NULL};
	gchar* license = NULL;
	gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Klotski is free software; you can redistribute it and/or modify it und" \
"er the terms of the GNU General Public License as published by the Fre" \
"e Software Foundation; either version 2 of the License, or (at your op" \
"tion) any later version.\n" \
"\n" \
"Klotski is distributed in the hope that it will be useful, but WITHOUT" \
" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or" \
" FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License " \
"for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License alon" \
"g with Klotski; if not, write to the Free Software Foundation, Inc., 5" \
"1 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA");
	license = _tmp0_;
	_tmp1_ = self->priv->window;
	_tmp2_ = _ ("Klotski");
	_tmp3_ = _ ("Sliding Block Puzzles\n\nKlotski is a part of GNOME Games.");
	_tmp4_ = _ ("translator-credits");
	_tmp5_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp1_, "program-name", _tmp2_, "version", VERSION, "comments", _tmp3_, "copyright", "Copyright \xc2\xa9 1999-2008 Lars Rydlinge", "license", license, "wrap-license", TRUE, "authors", authors, "documenters", documenters, "translator-credits", _tmp4_, "logo-icon-name", "gnome-klotski", "website", "http://www.gnome.org/projects/gnome-games", "website-label", _tmp5_, NULL, NULL);
	_g_free0 (license);
}


gint klotski_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionGroup* _tmp1_ = NULL;
	Klotski* app = NULL;
	Klotski* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_prgname ("gnotski");
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	g_option_context_set_translation_domain (context, GETTEXT_PACKAGE);
	_tmp1_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp1_);
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		fprintf (_tmp2_, "%s\n", _tmp4_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = klotski_new ();
	app = _tmp5_;
	_tmp6_ = args;
	_tmp6__length1 = args_length1;
	_tmp7_ = g_application_run ((GApplication*) app, _tmp6__length1, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return klotski_main (argv, argc);
}


static void klotski_class_init (KlotskiClass * klass) {
	klotski_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KlotskiPrivate));
	G_APPLICATION_CLASS (klass)->startup = klotski_real_startup;
	G_APPLICATION_CLASS (klass)->shutdown = klotski_real_shutdown;
	G_APPLICATION_CLASS (klass)->activate = klotski_real_activate;
	G_OBJECT_CLASS (klass)->finalize = klotski_finalize;
}


static void klotski_instance_init (Klotski * self) {
	self->priv = KLOTSKI_GET_PRIVATE (self);
	self->priv->current_level = -1;
}


static void klotski_finalize (GObject* obj) {
	Klotski * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI, Klotski);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->next_menu_item);
	_g_object_unref0 (self->priv->prev_menu_item);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->fullscreen_button);
	_g_object_unref0 (self->priv->messagewidget);
	_g_object_unref0 (self->priv->moves_label);
	_puzzle_unref0 (self->priv->puzzle);
	_history_unref0 (self->priv->history);
	_vala_array_destroy (self->priv->groups, 3, (GDestroyNotify) g_object_unref);
	self->priv->level_images = (_vala_array_free (self->priv->level_images, self->priv->level_images_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->level_items = (_vala_array_free (self->priv->level_items, self->priv->level_items_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (klotski_parent_class)->finalize (obj);
}


GType klotski_get_type (void) {
	static volatile gsize klotski_type_id__volatile = 0;
	if (g_once_init_enter (&klotski_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KlotskiClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) klotski_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Klotski), 0, (GInstanceInitFunc) klotski_instance_init, NULL };
		GType klotski_type_id;
		klotski_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Klotski", &g_define_type_info, 0);
		g_once_init_leave (&klotski_type_id__volatile, klotski_type_id);
	}
	return klotski_type_id__volatile;
}


static gpointer _history_ref0 (gpointer self) {
	return self ? history_ref (self) : NULL;
}


static void _score_dialog_entry_added_cb_history_entry_added (History* _sender, HistoryEntry* entry, gpointer self) {
	score_dialog_entry_added_cb (self, entry);
}


static gpointer _history_entry_ref0 (gpointer self) {
	return self ? history_entry_ref (self) : NULL;
}


static void _score_dialog_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	score_dialog_level_changed_cb (self, _sender);
}


ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_quit) {
	ScoreDialog * self = NULL;
	History* _tmp0_ = NULL;
	History* _tmp1_ = NULL;
	History* _tmp2_ = NULL;
	HistoryEntry* _tmp3_ = NULL;
	HistoryEntry* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkBox* vbox = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkBox* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkListStore* _tmp23_ = NULL;
	GtkComboBox* _tmp24_ = NULL;
	GtkComboBox* _tmp25_ = NULL;
	GtkComboBox* _tmp26_ = NULL;
	GtkListStore* _tmp27_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkComboBox* _tmp31_ = NULL;
	GtkCellRendererText* _tmp32_ = NULL;
	GtkComboBox* _tmp33_ = NULL;
	GtkBox* _tmp34_ = NULL;
	GtkComboBox* _tmp35_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp36_ = NULL;
	GtkScrolledWindow* _tmp37_ = NULL;
	GtkScrolledWindow* _tmp38_ = NULL;
	GtkScrolledWindow* _tmp39_ = NULL;
	GtkBox* _tmp40_ = NULL;
	GtkScrolledWindow* _tmp41_ = NULL;
	GtkListStore* _tmp42_ = NULL;
	GtkTreeView* scores = NULL;
	GtkTreeView* _tmp43_ = NULL;
	GtkCellRendererText* _tmp44_ = NULL;
	GtkTreeView* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	GtkCellRendererText* _tmp47_ = NULL;
	GtkCellRendererText* _tmp48_ = NULL;
	GtkCellRendererText* _tmp49_ = NULL;
	GtkTreeView* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	GtkCellRendererText* _tmp52_ = NULL;
	GtkTreeView* _tmp53_ = NULL;
	GtkListStore* _tmp54_ = NULL;
	GtkTreeView* _tmp55_ = NULL;
	GtkScrolledWindow* _tmp56_ = NULL;
	GtkTreeView* _tmp57_ = NULL;
	History* _tmp58_ = NULL;
	GList* _tmp59_ = NULL;
	g_return_val_if_fail (history != NULL, NULL);
	self = (ScoreDialog*) g_object_new (object_type, NULL);
	_tmp0_ = history;
	_tmp1_ = _history_ref0 (_tmp0_);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp1_;
	_tmp2_ = history;
	g_signal_connect_object (_tmp2_, "entry-added", (GCallback) _score_dialog_entry_added_cb_history_entry_added, self, 0);
	_tmp3_ = selected_entry;
	_tmp4_ = _history_entry_ref0 (_tmp3_);
	_history_entry_unref0 (self->priv->selected_entry);
	self->priv->selected_entry = _tmp4_;
	_tmp5_ = show_quit;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = _ ("_Quit");
		gtk_dialog_add_button ((GtkDialog*) self, _tmp6_, (gint) GTK_RESPONSE_CLOSE);
		_tmp7_ = _ ("New Game");
		gtk_dialog_add_button ((GtkDialog*) self, _tmp7_, (gint) GTK_RESPONSE_OK);
	} else {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = _ ("_OK");
		gtk_dialog_add_button ((GtkDialog*) self, _tmp8_, (gint) GTK_RESPONSE_DELETE_EVENT);
	}
	gtk_widget_set_size_request ((GtkWidget*) self, 200, 300);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp9_);
	vbox = _tmp9_;
	_tmp10_ = vbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 6);
	_tmp11_ = vbox;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp13_ = vbox;
	gtk_box_pack_start (_tmp12_, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp14_);
	hbox = _tmp14_;
	_tmp15_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp15_);
	_tmp16_ = vbox;
	_tmp17_ = hbox;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 0);
	_tmp18_ = _ ("Puzzle:");
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	label = _tmp19_;
	_tmp20_ = label;
	gtk_widget_show ((GtkWidget*) _tmp20_);
	_tmp21_ = hbox;
	_tmp22_ = label;
	gtk_box_pack_start (_tmp21_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	_tmp23_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (self->priv->level_model);
	self->priv->level_model = _tmp23_;
	_tmp24_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->level_combo);
	self->priv->level_combo = _tmp24_;
	_tmp25_ = self->priv->level_combo;
	g_signal_connect_object (_tmp25_, "changed", (GCallback) _score_dialog_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp26_ = self->priv->level_combo;
	_tmp27_ = self->priv->level_model;
	gtk_combo_box_set_model (_tmp26_, (GtkTreeModel*) _tmp27_);
	_tmp28_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp28_);
	renderer = _tmp28_;
	_tmp29_ = self->priv->level_combo;
	_tmp30_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, TRUE);
	_tmp31_ = self->priv->level_combo;
	_tmp32_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp31_, (GtkCellRenderer*) _tmp32_, "text", 0);
	_tmp33_ = self->priv->level_combo;
	gtk_widget_show ((GtkWidget*) _tmp33_);
	_tmp34_ = hbox;
	_tmp35_ = self->priv->level_combo;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, TRUE, TRUE, (guint) 0);
	_tmp36_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp36_);
	scroll = _tmp36_;
	_tmp37_ = scroll;
	gtk_scrolled_window_set_shadow_type (_tmp37_, GTK_SHADOW_ETCHED_IN);
	_tmp38_ = scroll;
	gtk_scrolled_window_set_policy (_tmp38_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp39_ = scroll;
	gtk_widget_show ((GtkWidget*) _tmp39_);
	_tmp40_ = vbox;
	_tmp41_ = scroll;
	gtk_box_pack_start (_tmp40_, (GtkWidget*) _tmp41_, TRUE, TRUE, (guint) 0);
	_tmp42_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp42_;
	_tmp43_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp43_);
	scores = _tmp43_;
	_tmp44_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (renderer);
	renderer = _tmp44_;
	_tmp45_ = scores;
	_tmp46_ = _ ("Date");
	_tmp47_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp45_, -1, _tmp46_, (GtkCellRenderer*) _tmp47_, "text", 0, "weight", 2, NULL);
	_tmp48_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (renderer);
	renderer = _tmp48_;
	_tmp49_ = renderer;
	g_object_set ((GtkCellRenderer*) _tmp49_, "xalign", 1.0f, NULL);
	_tmp50_ = scores;
	_tmp51_ = _ ("Moves");
	_tmp52_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp50_, -1, _tmp51_, (GtkCellRenderer*) _tmp52_, "text", 1, "weight", 2, NULL);
	_tmp53_ = scores;
	_tmp54_ = self->priv->score_model;
	gtk_tree_view_set_model (_tmp53_, (GtkTreeModel*) _tmp54_);
	_tmp55_ = scores;
	gtk_widget_show ((GtkWidget*) _tmp55_);
	_tmp56_ = scroll;
	_tmp57_ = scores;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = history;
	_tmp59_ = _tmp58_->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp59_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp60_ = NULL;
			HistoryEntry* entry = NULL;
			_tmp60_ = _history_entry_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp60_;
			{
				HistoryEntry* _tmp61_ = NULL;
				_tmp61_ = entry;
				score_dialog_entry_added_cb (self, _tmp61_);
				_history_entry_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (scores);
	_g_object_unref0 (scroll);
	_g_object_unref0 (renderer);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	return self;
}


ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_quit) {
	return score_dialog_construct (TYPE_SCORE_DIALOG, history, selected_entry, show_quit);
}


static gint _score_dialog_compare_entries_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = score_dialog_compare_entries (a, b);
	return result;
}


void score_dialog_set_level (ScoreDialog* self, guint level) {
	GtkListStore* _tmp0_ = NULL;
	GList* entries = NULL;
	History* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->score_model;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->history;
	_tmp2_ = _tmp1_->entries;
	_tmp3_ = g_list_copy (_tmp2_);
	entries = _tmp3_;
	entries = g_list_sort (entries, _score_dialog_compare_entries_gcompare_func);
	_tmp4_ = entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp4_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* entry = NULL;
			entry = (HistoryEntry*) entry_it->data;
			{
				HistoryEntry* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				guint _tmp7_ = 0U;
				gchar* date_label = NULL;
				HistoryEntry* _tmp8_ = NULL;
				GDateTime* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* moves_label = NULL;
				HistoryEntry* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				gchar* _tmp13_ = NULL;
				gint weight = 0;
				HistoryEntry* _tmp14_ = NULL;
				HistoryEntry* _tmp15_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp16_ = NULL;
				GtkTreeIter _tmp17_ = {0};
				GtkListStore* _tmp18_ = NULL;
				GtkTreeIter _tmp19_ = {0};
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				_tmp5_ = entry;
				_tmp6_ = _tmp5_->level;
				_tmp7_ = level;
				if (_tmp6_ != _tmp7_) {
					continue;
				}
				_tmp8_ = entry;
				_tmp9_ = _tmp8_->date;
				_tmp10_ = g_date_time_format (_tmp9_, "%d/%m/%Y");
				date_label = _tmp10_;
				_tmp11_ = entry;
				_tmp12_ = _tmp11_->moves;
				_tmp13_ = g_strdup_printf ("%u", _tmp12_);
				moves_label = _tmp13_;
				weight = (gint) PANGO_WEIGHT_NORMAL;
				_tmp14_ = entry;
				_tmp15_ = self->priv->selected_entry;
				if (_tmp14_ == _tmp15_) {
					weight = (gint) PANGO_WEIGHT_BOLD;
				}
				_tmp16_ = self->priv->score_model;
				gtk_list_store_append (_tmp16_, &_tmp17_);
				iter = _tmp17_;
				_tmp18_ = self->priv->score_model;
				_tmp19_ = iter;
				_tmp20_ = date_label;
				_tmp21_ = moves_label;
				_tmp22_ = weight;
				gtk_list_store_set (_tmp18_, &_tmp19_, 0, _tmp20_, 1, _tmp21_, 2, _tmp22_, -1);
				_g_free0 (moves_label);
				_g_free0 (date_label);
			}
		}
	}
	_g_list_free0 (entries);
}


static gint score_dialog_compare_entries (HistoryEntry* a, HistoryEntry* b) {
	gint result = 0;
	HistoryEntry* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	HistoryEntry* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	HistoryEntry* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	HistoryEntry* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	HistoryEntry* _tmp16_ = NULL;
	GDateTime* _tmp17_ = NULL;
	HistoryEntry* _tmp18_ = NULL;
	GDateTime* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->level;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->level;
	if (_tmp1_ != _tmp3_) {
		HistoryEntry* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		HistoryEntry* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->level;
		_tmp6_ = b;
		_tmp7_ = _tmp6_->level;
		result = ((gint) _tmp5_) - ((gint) _tmp7_);
		return result;
	}
	_tmp8_ = a;
	_tmp9_ = _tmp8_->moves;
	_tmp10_ = b;
	_tmp11_ = _tmp10_->moves;
	if (_tmp9_ != _tmp11_) {
		HistoryEntry* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		HistoryEntry* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		_tmp12_ = a;
		_tmp13_ = _tmp12_->moves;
		_tmp14_ = b;
		_tmp15_ = _tmp14_->moves;
		result = ((gint) _tmp13_) - ((gint) _tmp15_);
		return result;
	}
	_tmp16_ = a;
	_tmp17_ = _tmp16_->date;
	_tmp18_ = b;
	_tmp19_ = _tmp18_->date;
	_tmp20_ = g_date_time_compare (_tmp17_, _tmp19_);
	result = _tmp20_;
	return result;
}


static void score_dialog_level_changed_cb (ScoreDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint level = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &level, -1);
	_tmp7_ = level;
	score_dialog_set_level (self, (guint) _tmp7_);
}


static void score_dialog_entry_added_cb (ScoreDialog* self, HistoryEntry* entry) {
	GtkTreeIter iter = {0};
	gboolean have_level_entry = FALSE;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	have_level_entry = FALSE;
	_tmp0_ = self->priv->level_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				guint level = 0U;
				GtkListStore* _tmp7_ = NULL;
				GtkTreeIter _tmp8_ = {0};
				guint _tmp9_ = 0U;
				HistoryEntry* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					GtkListStore* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = self->priv->level_model;
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
					if (!_tmp6_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp7_ = self->priv->level_model;
				_tmp8_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 1, &level, -1);
				_tmp9_ = level;
				_tmp10_ = entry;
				_tmp11_ = _tmp10_->level;
				if (_tmp9_ == _tmp11_) {
					have_level_entry = TRUE;
					break;
				}
			}
		}
	}
	_tmp12_ = have_level_entry;
	if (!_tmp12_) {
		gchar* label = NULL;
		HistoryEntry* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		LevelInfo _tmp15_ = {0};
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GtkListStore* _tmp19_ = NULL;
		GtkTreeIter _tmp20_ = {0};
		GtkListStore* _tmp21_ = NULL;
		GtkTreeIter _tmp22_ = {0};
		const gchar* _tmp23_ = NULL;
		HistoryEntry* _tmp24_ = NULL;
		guint _tmp25_ = 0U;
		GtkComboBox* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gboolean _tmp30_ = FALSE;
		HistoryEntry* _tmp31_ = NULL;
		gboolean _tmp36_ = FALSE;
		_tmp13_ = entry;
		_tmp14_ = _tmp13_->level;
		_tmp15_ = KLOTSKI_level[_tmp14_];
		_tmp16_ = _tmp15_.name;
		_tmp17_ = _ (_tmp16_);
		_tmp18_ = g_strdup (_tmp17_);
		label = _tmp18_;
		_tmp19_ = self->priv->level_model;
		gtk_list_store_append (_tmp19_, &_tmp20_);
		iter = _tmp20_;
		_tmp21_ = self->priv->level_model;
		_tmp22_ = iter;
		_tmp23_ = label;
		_tmp24_ = entry;
		_tmp25_ = _tmp24_->level;
		gtk_list_store_set (_tmp21_, &_tmp22_, 0, _tmp23_, 1, _tmp25_, -1, -1);
		_tmp26_ = self->priv->level_combo;
		_tmp27_ = gtk_combo_box_get_active (_tmp26_);
		if (_tmp27_ == (-1)) {
			GtkComboBox* _tmp28_ = NULL;
			GtkTreeIter _tmp29_ = {0};
			_tmp28_ = self->priv->level_combo;
			_tmp29_ = iter;
			gtk_combo_box_set_active_iter (_tmp28_, &_tmp29_);
		}
		_tmp31_ = self->priv->selected_entry;
		if (_tmp31_ != NULL) {
			HistoryEntry* _tmp32_ = NULL;
			guint _tmp33_ = 0U;
			HistoryEntry* _tmp34_ = NULL;
			guint _tmp35_ = 0U;
			_tmp32_ = entry;
			_tmp33_ = _tmp32_->level;
			_tmp34_ = self->priv->selected_entry;
			_tmp35_ = _tmp34_->level;
			_tmp30_ = _tmp33_ == _tmp35_;
		} else {
			_tmp30_ = FALSE;
		}
		_tmp36_ = _tmp30_;
		if (_tmp36_) {
			GtkComboBox* _tmp37_ = NULL;
			GtkTreeIter _tmp38_ = {0};
			_tmp37_ = self->priv->level_combo;
			_tmp38_ = iter;
			gtk_combo_box_set_active_iter (_tmp37_, &_tmp38_);
		}
		_g_free0 (label);
	}
}


static void score_dialog_class_init (ScoreDialogClass * klass) {
	score_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScoreDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = score_dialog_finalize;
}


static void score_dialog_instance_init (ScoreDialog * self) {
	self->priv = SCORE_DIALOG_GET_PRIVATE (self);
	self->priv->selected_entry = NULL;
}


static void score_dialog_finalize (GObject* obj) {
	ScoreDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_DIALOG, ScoreDialog);
	_history_unref0 (self->priv->history);
	_history_entry_unref0 (self->priv->selected_entry);
	_g_object_unref0 (self->priv->level_model);
	_g_object_unref0 (self->priv->score_model);
	_g_object_unref0 (self->priv->level_combo);
	G_OBJECT_CLASS (score_dialog_parent_class)->finalize (obj);
}


GType score_dialog_get_type (void) {
	static volatile gsize score_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&score_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreDialog), 0, (GInstanceInitFunc) score_dialog_instance_init, NULL };
		GType score_dialog_type_id;
		score_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ScoreDialog", &g_define_type_info, 0);
		g_once_init_leave (&score_dialog_type_id__volatile, score_dialog_type_id);
	}
	return score_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



