/* rygel-searchable-container-test.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-searchable-container-test.vala, do not modify */

/*
 * Copyright (C) 2012 Jens Georg.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _RelationalExpressionPrivate RelationalExpressionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;
typedef struct _MediaObjectPrivate MediaObjectPrivate;

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
typedef struct _Block1Data Block1Data;
typedef struct _MediaContainerGetChildrenData MediaContainerGetChildrenData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_TEST_CONTAINER (test_container_get_type ())
#define TEST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_CONTAINER, TestContainer))
#define TEST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_CONTAINER, TestContainerClass))
#define IS_TEST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_CONTAINER))
#define IS_TEST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_CONTAINER))
#define TEST_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_CONTAINER, TestContainerClass))

typedef struct _TestContainer TestContainer;
typedef struct _TestContainerClass TestContainerClass;
typedef struct _TestContainerPrivate TestContainerPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TestContainerTestSearchNoLimitData TestContainerTestSearchNoLimitData;
typedef struct _TestContainerTestSearchWithLimitData TestContainerTestSearchWithLimitData;
typedef struct _TestContainerSearchData TestContainerSearchData;
typedef struct _MediaObjectsPrivate MediaObjectsPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RelationalExpression {
	SearchExpression parent_instance;
	RelationalExpressionPrivate * priv;
};

struct _RelationalExpressionClass {
	SearchExpressionClass parent_class;
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	gchar* sort_criteria;
	gint child_count;
	gboolean create_mode_enabled;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	MediaContainer * self;
	gpointer _async_data_;
};

struct _MediaContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MediaContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	Block1Data* _data1_;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	MediaObjects* _tmp5_;
	MediaObject* _tmp6_;
	MediaObject* _tmp7_;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _TestContainer {
	MediaContainer parent_instance;
	TestContainerPrivate * priv;
	GMainLoop* loop;
};

struct _TestContainerClass {
	MediaContainerClass parent_class;
};

struct _TestContainerPrivate {
	GeeArrayList* _search_classes;
};

struct _TestContainerTestSearchNoLimitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestContainer* self;
	guint total_matches;
	MediaObjects* _result_;
	guint _tmp0_;
	MediaObjects* _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GError* _error_;
	MediaObjects* _vala1__result_;
	guint _tmp5_;
	MediaObjects* _tmp6_;
	guint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GError* _vala1__error_;
	gint i;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	MediaObjects* _vala2__result_;
	gint _tmp14_;
	guint _tmp15_;
	MediaObjects* _tmp16_;
	guint _tmp17_;
	MediaObjects* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GError* _vala2__error_;
	GMainLoop* _tmp22_;
	GError * _inner_error_;
};

struct _TestContainerTestSearchWithLimitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestContainer* self;
	guint total_matches;
	MediaObjects* _result_;
	guint _tmp0_;
	MediaObjects* _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GError* _error_;
	MediaObjects* _vala1__result_;
	guint _tmp5_;
	MediaObjects* _tmp6_;
	guint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GError* _vala1__error_;
	gint i;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	MediaObjects* _vala2__result_;
	gint _tmp14_;
	guint _tmp15_;
	MediaObjects* _tmp16_;
	guint _tmp17_;
	MediaObjects* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GError* _vala2__error_;
	GMainLoop* _tmp23_;
	GError * _inner_error_;
};

struct _TestContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	MediaObjects* _tmp6_;
	SearchExpression* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	const gchar* _tmp10_;
	GCancellable* _tmp11_;
	guint _tmp12_;
	MediaObjects* _tmp13_;
	GError * _inner_error_;
};

struct _MediaObjects {
	GeeArrayList parent_instance;
	MediaObjectsPrivate * priv;
};

struct _MediaObjectsClass {
	GeeArrayListClass parent_class;
};


static gpointer relational_expression_parent_class = NULL;
static gpointer search_expression_parent_class = NULL;
static gpointer media_object_parent_class = NULL;
static gpointer media_container_parent_class = NULL;
static gpointer test_container_parent_class = NULL;
static RygelSearchableContainerIface* test_container_rygel_searchable_container_parent_iface = NULL;
static gpointer media_objects_parent_class = NULL;

GType search_expression_get_type (void) G_GNUC_CONST;
GType relational_expression_get_type (void) G_GNUC_CONST;
enum  {
	RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
SearchExpression* search_expression_new (void);
SearchExpression* search_expression_construct (GType object_type);
#define SEARCH_CRITERIA_OP_EQ "="
enum  {
	SEARCH_EXPRESSION_DUMMY_PROPERTY
};
GType media_object_get_type (void) G_GNUC_CONST;
gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object);
static void search_expression_finalize (GObject* obj);
enum  {
	MEDIA_OBJECT_DUMMY_PROPERTY
};
MediaObject* media_object_new (void);
MediaObject* media_object_construct (GType object_type);
GType media_container_get_type (void) G_GNUC_CONST;
enum  {
	MEDIA_CONTAINER_DUMMY_PROPERTY,
	MEDIA_CONTAINER_ALL_CHILD_COUNT
};
static void media_container_get_children_data_free (gpointer _data);
GType media_objects_get_type (void) G_GNUC_CONST;
void media_container_get_children (MediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean media_container_get_children_co (MediaContainerGetChildrenData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda2_ (Block1Data* _data1_);
static gboolean ___lambda2__gsource_func (gpointer self);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
void media_container_check_search_expression (MediaContainer* self, SearchExpression* expression);
MediaContainer* media_container_new (void);
MediaContainer* media_container_construct (GType object_type);
gint media_container_get_all_child_count (MediaContainer* self);
static void media_container_finalize (GObject* obj);
static void _vala_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType test_container_get_type (void) G_GNUC_CONST;
#define TEST_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_CONTAINER, TestContainerPrivate))
enum  {
	TEST_CONTAINER_DUMMY_PROPERTY,
	TEST_CONTAINER_SEARCH_CLASSES
};
static void test_container_test_search_no_limit_data_free (gpointer _data);
void test_container_test_search_no_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void test_container_test_search_no_limit_finish (TestContainer* self, GAsyncResult* _res_);
static gboolean test_container_test_search_no_limit_co (TestContainerTestSearchNoLimitData* _data_);
void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void test_container_test_search_no_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_container_test_search_with_limit_data_free (gpointer _data);
void test_container_test_search_with_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void test_container_test_search_with_limit_finish (TestContainer* self, GAsyncResult* _res_);
static gboolean test_container_test_search_with_limit_co (TestContainerTestSearchWithLimitData* _data_);
static void test_container_test_search_with_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void test_container_test_serialization (TestContainer* self);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
static void test_container_real_search_data_free (gpointer _data);
static void test_container_real_search (RygelSearchableContainer* base, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean test_container_real_search_co (TestContainerSearchData* _data_);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void test_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TestContainer* test_container_new (void);
TestContainer* test_container_construct (GType object_type);
static void test_container_finalize (GObject* obj);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
static void _vala_test_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);
static void _vala_test_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	MEDIA_OBJECTS_DUMMY_PROPERTY
};
static GeeList* media_objects_real_slice (GeeAbstractList* base, gint start, gint stop);
gint _vala_main (void);


RelationalExpression* relational_expression_construct (GType object_type) {
	RelationalExpression * self = NULL;
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (RelationalExpression*) search_expression_construct (object_type);
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 433 "rygel-searchable-container-test.c"
}


RelationalExpression* relational_expression_new (void) {
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return relational_expression_construct (TYPE_RELATIONAL_EXPRESSION);
#line 440 "rygel-searchable-container-test.c"
}


static void relational_expression_class_init (RelationalExpressionClass * klass) {
#line 23 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	relational_expression_parent_class = g_type_class_peek_parent (klass);
#line 447 "rygel-searchable-container-test.c"
}


static void relational_expression_instance_init (RelationalExpression * self) {
}


GType relational_expression_get_type (void) {
	static volatile gsize relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RelationalExpression), 0, (GInstanceInitFunc) relational_expression_instance_init, NULL };
		GType relational_expression_type_id;
		relational_expression_type_id = g_type_register_static (TYPE_SEARCH_EXPRESSION, "RelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&relational_expression_type_id__volatile, relational_expression_type_id);
	}
	return relational_expression_type_id__volatile;
}


gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object) {
	gboolean result = FALSE;
#line 35 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 35 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 36 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = TRUE;
#line 36 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 477 "rygel-searchable-container-test.c"
}


SearchExpression* search_expression_construct (GType object_type) {
	SearchExpression * self = NULL;
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (SearchExpression*) g_object_new (object_type, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 487 "rygel-searchable-container-test.c"
}


SearchExpression* search_expression_new (void) {
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return search_expression_construct (TYPE_SEARCH_EXPRESSION);
#line 494 "rygel-searchable-container-test.c"
}


static void search_expression_class_init (SearchExpressionClass * klass) {
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	search_expression_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->finalize = search_expression_finalize;
#line 503 "rygel-searchable-container-test.c"
}


static void search_expression_instance_init (SearchExpression * self) {
}


static void search_expression_finalize (GObject* obj) {
	SearchExpression * self;
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_EXPRESSION, SearchExpression);
#line 31 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (self->operand1);
#line 32 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (self->operand2);
#line 33 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (self->op);
#line 30 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (search_expression_parent_class)->finalize (obj);
#line 523 "rygel-searchable-container-test.c"
}


GType search_expression_get_type (void) {
	static volatile gsize search_expression_type_id__volatile = 0;
	if (g_once_init_enter (&search_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchExpression), 0, (GInstanceInitFunc) search_expression_instance_init, NULL };
		GType search_expression_type_id;
		search_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchExpression", &g_define_type_info, 0);
		g_once_init_leave (&search_expression_type_id__volatile, search_expression_type_id);
	}
	return search_expression_type_id__volatile;
}


MediaObject* media_object_construct (GType object_type) {
	MediaObject * self = NULL;
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaObject*) g_object_new (object_type, NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 545 "rygel-searchable-container-test.c"
}


MediaObject* media_object_new (void) {
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return media_object_construct (TYPE_MEDIA_OBJECT);
#line 552 "rygel-searchable-container-test.c"
}


static void media_object_class_init (MediaObjectClass * klass) {
#line 40 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_object_parent_class = g_type_class_peek_parent (klass);
#line 559 "rygel-searchable-container-test.c"
}


static void media_object_instance_init (MediaObject * self) {
}


GType media_object_get_type (void) {
	static volatile gsize media_object_type_id__volatile = 0;
	if (g_once_init_enter (&media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaObject), 0, (GInstanceInitFunc) media_object_instance_init, NULL };
		GType media_object_type_id;
		media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaObject", &g_define_type_info, 0);
		g_once_init_leave (&media_object_type_id__volatile, media_object_type_id);
	}
	return media_object_type_id__volatile;
}


static void media_container_get_children_data_free (gpointer _data) {
	MediaContainerGetChildrenData* _data_;
	_data_ = _data;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (_data_->sort_criteria);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->result);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (MediaContainerGetChildrenData, _data_);
#line 592 "rygel-searchable-container-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 599 "rygel-searchable-container-test.c"
}


void media_container_get_children (MediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MediaContainerGetChildrenData* _data_;
	MediaContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (MediaContainerGetChildrenData);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, media_container_get_children);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, media_container_get_children_data_free);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = offset;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->offset = _tmp1_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = max_count;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->max_count = _tmp2_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = sort_criteria;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (_data_->sort_criteria);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->sort_criteria = _tmp4_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp5_ = cancellable;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->cancellable = _tmp6_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_container_get_children_co (_data_);
#line 648 "rygel-searchable-container-test.c"
}


MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObjects* result;
	MediaContainerGetChildrenData* _data_;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return NULL;
#line 659 "rygel-searchable-container-test.c"
	}
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = _data_->result;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = NULL;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 669 "rygel-searchable-container-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return _data1_;
#line 678 "rygel-searchable-container-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 687 "rygel-searchable-container-test.c"
		MediaContainer * self;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		self = _data1_->self;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (self);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 695 "rygel-searchable-container-test.c"
	}
}


static gboolean __lambda2_ (Block1Data* _data1_) {
	MediaContainer * self;
	gboolean result = FALSE;
#line 56 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = _data1_->self;
#line 56 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_container_get_children_co (_data1_->_async_data_);
#line 56 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = FALSE;
#line 56 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 711 "rygel-searchable-container-test.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 56 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 720 "rygel-searchable-container-test.c"
}


static gboolean media_container_get_children_co (MediaContainerGetChildrenData* _data_) {
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 729 "rygel-searchable-container-test.c"
		goto _state_0;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 733 "rygel-searchable-container-test.c"
		goto _state_1;
		default:
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 738 "rygel-searchable-container-test.c"
	}
	_state_0:
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 56 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 1;
#line 57 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 755 "rygel-searchable-container-test.c"
	_state_1:
	;
#line 59 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp0_ = NULL;
#line 59 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 59 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 764 "rygel-searchable-container-test.c"
	{
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->i = 0;
#line 768 "rygel-searchable-container-test.c"
		{
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			_data_->_tmp1_ = TRUE;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			while (TRUE) {
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp2_ = FALSE;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp2_ = _data_->_tmp1_;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!_data_->_tmp2_) {
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp3_ = 0;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp3_ = _data_->i;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->i = _data_->_tmp3_ + 1;
#line 786 "rygel-searchable-container-test.c"
				}
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp1_ = FALSE;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp4_ = 0;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp4_ = _data_->i;
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!(_data_->_tmp4_ < 10)) {
#line 60 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					break;
#line 798 "rygel-searchable-container-test.c"
				}
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp5_ = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp5_ = _data_->_result_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp6_ = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp6_ = media_object_new ();
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp7_ = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp7_ = _data_->_tmp6_;
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, _data_->_tmp7_);
#line 61 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_g_object_unref0 (_data_->_tmp7_);
#line 816 "rygel-searchable-container-test.c"
			}
		}
	}
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = _data_->_result_;
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	block1_data_unref (_data_->_data1_);
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 830 "rygel-searchable-container-test.c"
	} else {
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 834 "rygel-searchable-container-test.c"
	}
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 64 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->_result_);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	block1_data_unref (_data_->_data1_);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_data1_ = NULL;
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 850 "rygel-searchable-container-test.c"
	} else {
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 854 "rygel-searchable-container-test.c"
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 50 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 860 "rygel-searchable-container-test.c"
}


void media_container_check_search_expression (MediaContainer* self, SearchExpression* expression) {
#line 67 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_return_if_fail (self != NULL);
#line 867 "rygel-searchable-container-test.c"
}


MediaContainer* media_container_construct (GType object_type) {
	MediaContainer * self = NULL;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaContainer*) media_object_construct (object_type);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 877 "rygel-searchable-container-test.c"
}


MediaContainer* media_container_new (void) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return media_container_construct (TYPE_MEDIA_CONTAINER);
#line 884 "rygel-searchable-container-test.c"
}


gint media_container_get_all_child_count (MediaContainer* self) {
	gint result;
	gint _tmp0_ = 0;
#line 48 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = self->child_count;
#line 48 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 899 "rygel-searchable-container-test.c"
}


static void media_container_class_init (MediaContainerClass * klass) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_container_parent_class = g_type_class_peek_parent (klass);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_media_container_get_property;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->finalize = media_container_finalize;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER_ALL_CHILD_COUNT, g_param_spec_int ("all-child-count", "all-child-count", "all-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 912 "rygel-searchable-container-test.c"
}


static void media_container_instance_init (MediaContainer * self) {
	gchar* _tmp0_ = NULL;
#line 44 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = g_strdup ("+dc:title");
#line 44 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->sort_criteria = _tmp0_;
#line 45 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->child_count = 10;
#line 46 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->create_mode_enabled = FALSE;
#line 926 "rygel-searchable-container-test.c"
}


static void media_container_finalize (GObject* obj) {
	MediaContainer * self;
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_CONTAINER, MediaContainer);
#line 44 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (self->sort_criteria);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (media_container_parent_class)->finalize (obj);
#line 938 "rygel-searchable-container-test.c"
}


GType media_container_get_type (void) {
	static volatile gsize media_container_type_id__volatile = 0;
	if (g_once_init_enter (&media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaContainer), 0, (GInstanceInitFunc) media_container_instance_init, NULL };
		GType media_container_type_id;
		media_container_type_id = g_type_register_static (TYPE_MEDIA_OBJECT, "MediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&media_container_type_id__volatile, media_container_type_id);
	}
	return media_container_type_id__volatile;
}


static void _vala_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_CONTAINER, MediaContainer);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (property_id) {
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case MEDIA_CONTAINER_ALL_CHILD_COUNT:
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_value_set_int (value, media_container_get_all_child_count (self));
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 965 "rygel-searchable-container-test.c"
		default:
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 43 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 971 "rygel-searchable-container-test.c"
	}
}


static void test_container_test_search_no_limit_data_free (gpointer _data) {
	TestContainerTestSearchNoLimitData* _data_;
	_data_ = _data;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (TestContainerTestSearchNoLimitData, _data_);
#line 983 "rygel-searchable-container-test.c"
}


void test_container_test_search_no_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestContainerTestSearchNoLimitData* _data_;
	TestContainer* _tmp0_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (TestContainerTestSearchNoLimitData);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, test_container_test_search_no_limit);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_container_test_search_no_limit_data_free);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_no_limit_co (_data_);
#line 1002 "rygel-searchable-container-test.c"
}


void test_container_test_search_no_limit_finish (TestContainer* self, GAsyncResult* _res_) {
	TestContainerTestSearchNoLimitData* _data_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1010 "rygel-searchable-container-test.c"
}


static void test_container_test_search_no_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestContainerTestSearchNoLimitData* _data_;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = _user_data_;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_source_object_ = source_object;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_res_ = _res_;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_no_limit_co (_data_);
#line 1024 "rygel-searchable-container-test.c"
}


static gboolean test_container_test_search_no_limit_co (TestContainerTestSearchNoLimitData* _data_) {
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 1033 "rygel-searchable-container-test.c"
		goto _state_0;
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 1037 "rygel-searchable-container-test.c"
		goto _state_1;
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 2:
#line 1041 "rygel-searchable-container-test.c"
		goto _state_2;
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 3:
#line 1045 "rygel-searchable-container-test.c"
		goto _state_3;
		default:
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 1050 "rygel-searchable-container-test.c"
	}
	_state_0:
#line 76 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->total_matches = (guint) 0;
#line 1055 "rygel-searchable-container-test.c"
	{
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp0_ = 0U;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_state_ = 1;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 0, (guint) 0, "", NULL, test_container_test_search_no_limit_ready, _data_);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1065 "rygel-searchable-container-test.c"
		_state_1:
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp1_ = NULL;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp1_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_inner_error_);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->total_matches = _data_->_tmp0_;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_result_ = _data_->_tmp1_;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1077 "rygel-searchable-container-test.c"
			goto __catch0_g_error;
		}
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp2_ = 0U;
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp2_ = _data_->total_matches;
#line 81 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp2_ == ((guint) 10), "total_matches == 10");
#line 82 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp3_ = 0;
#line 82 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_result_);
#line 82 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp4_ = 0;
#line 82 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 82 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp4_ == 10, "result.size == 10");
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (_data_->_result_);
#line 1098 "rygel-searchable-container-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_inner_error_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_error_free0 (_data_->_error_);
#line 1111 "rygel-searchable-container-test.c"
	}
	__finally0:
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1122 "rygel-searchable-container-test.c"
	}
	{
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp5_ = 0U;
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_state_ = 2;
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 10, (guint) 0, "", NULL, test_container_test_search_no_limit_ready, _data_);
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1133 "rygel-searchable-container-test.c"
		_state_2:
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp6_ = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp6_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->total_matches = _data_->_tmp5_;
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_vala1__result_ = _data_->_tmp6_;
#line 88 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1145 "rygel-searchable-container-test.c"
			goto __catch1_g_error;
		}
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp7_ = 0U;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp7_ = _data_->total_matches;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp7_ == ((guint) 10), "total_matches == 10");
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp8_ = 0;
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_vala1__result_);
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp9_ = 0;
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 90 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp9_ == 0, "result.size == 0");
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (_data_->_vala1__result_);
#line 1166 "rygel-searchable-container-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_vala1__error_ = _data_->_inner_error_;
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_inner_error_ = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_error_free0 (_data_->_vala1__error_);
#line 1179 "rygel-searchable-container-test.c"
	}
	__finally1:
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1190 "rygel-searchable-container-test.c"
	}
	{
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->i = 1;
#line 1195 "rygel-searchable-container-test.c"
		{
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			_data_->_tmp10_ = TRUE;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			while (TRUE) {
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp11_ = FALSE;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp11_ = _data_->_tmp10_;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!_data_->_tmp11_) {
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp12_ = 0;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp12_ = _data_->i;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->i = _data_->_tmp12_ + 1;
#line 1213 "rygel-searchable-container-test.c"
				}
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp10_ = FALSE;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp13_ = 0;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp13_ = _data_->i;
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!(_data_->_tmp13_ < 10)) {
#line 95 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					break;
#line 1225 "rygel-searchable-container-test.c"
				}
				{
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp14_ = 0;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp14_ = _data_->i;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp15_ = 0U;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_state_ = 3;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) _data_->_tmp14_, (guint) 0, "", NULL, test_container_test_search_no_limit_ready, _data_);
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					return FALSE;
#line 1240 "rygel-searchable-container-test.c"
					_state_3:
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp16_ = NULL;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp16_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp15_, &_data_->_inner_error_);
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->total_matches = _data_->_tmp15_;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_vala2__result_ = _data_->_tmp16_;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					if (_data_->_inner_error_ != NULL) {
#line 1252 "rygel-searchable-container-test.c"
						goto __catch2_g_error;
					}
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp17_ = 0U;
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp17_ = _data_->total_matches;
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_vala_assert (_data_->_tmp17_ == ((guint) 10), "total_matches == 10");
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp18_ = NULL;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp18_ = _data_->_vala2__result_;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp19_ = 0;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp18_);
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp20_ = 0;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp20_ = _data_->_tmp19_;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp21_ = 0;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp21_ = _data_->i;
#line 99 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_vala_assert (_data_->_tmp20_ == (10 - _data_->_tmp21_), "result.size == 10 - i");
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_g_object_unref0 (_data_->_vala2__result_);
#line 1281 "rygel-searchable-container-test.c"
				}
				goto __finally2;
				__catch2_g_error:
				{
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_vala2__error_ = _data_->_inner_error_;
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_inner_error_ = NULL;
#line 101 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_assert_not_reached ();
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_g_error_free0 (_data_->_vala2__error_);
#line 1294 "rygel-searchable-container-test.c"
				}
				__finally2:
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (_data_->_inner_error_ != NULL) {
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_clear_error (&_data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					return FALSE;
#line 1305 "rygel-searchable-container-test.c"
				}
			}
		}
	}
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp22_ = NULL;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp22_ = _data_->self->loop;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_quit (_data_->_tmp22_);
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1320 "rygel-searchable-container-test.c"
	} else {
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1324 "rygel-searchable-container-test.c"
	}
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 75 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1330 "rygel-searchable-container-test.c"
}


static void test_container_test_search_with_limit_data_free (gpointer _data) {
	TestContainerTestSearchWithLimitData* _data_;
	_data_ = _data;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (TestContainerTestSearchWithLimitData, _data_);
#line 1341 "rygel-searchable-container-test.c"
}


void test_container_test_search_with_limit (TestContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestContainerTestSearchWithLimitData* _data_;
	TestContainer* _tmp0_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (TestContainerTestSearchWithLimitData);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, test_container_test_search_with_limit);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_container_test_search_with_limit_data_free);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_with_limit_co (_data_);
#line 1360 "rygel-searchable-container-test.c"
}


void test_container_test_search_with_limit_finish (TestContainer* self, GAsyncResult* _res_) {
	TestContainerTestSearchWithLimitData* _data_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1368 "rygel-searchable-container-test.c"
}


static void test_container_test_search_with_limit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestContainerTestSearchWithLimitData* _data_;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = _user_data_;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_source_object_ = source_object;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_res_ = _res_;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_with_limit_co (_data_);
#line 1382 "rygel-searchable-container-test.c"
}


static gboolean test_container_test_search_with_limit_co (TestContainerTestSearchWithLimitData* _data_) {
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 1391 "rygel-searchable-container-test.c"
		goto _state_0;
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 1395 "rygel-searchable-container-test.c"
		goto _state_1;
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 2:
#line 1399 "rygel-searchable-container-test.c"
		goto _state_2;
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 3:
#line 1403 "rygel-searchable-container-test.c"
		goto _state_3;
		default:
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 1408 "rygel-searchable-container-test.c"
	}
	_state_0:
	{
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp0_ = 0U;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_state_ = 1;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 0, (guint) 4, "", NULL, test_container_test_search_with_limit_ready, _data_);
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1420 "rygel-searchable-container-test.c"
		_state_1:
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp1_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp1_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_inner_error_);
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->total_matches = _data_->_tmp0_;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_result_ = _data_->_tmp1_;
#line 113 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1432 "rygel-searchable-container-test.c"
			goto __catch3_g_error;
		}
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp2_ = 0U;
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp2_ = _data_->total_matches;
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp2_ == ((guint) 0), "total_matches == 0");
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp3_ = 0;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_result_);
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp4_ = 0;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 115 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp4_ == 4, "result.size == 4");
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (_data_->_result_);
#line 1453 "rygel-searchable-container-test.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_inner_error_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_error_free0 (_data_->_error_);
#line 1466 "rygel-searchable-container-test.c"
	}
	__finally3:
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 112 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1477 "rygel-searchable-container-test.c"
	}
	{
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp5_ = 0U;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_state_ = 2;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 10, (guint) 4, "", NULL, test_container_test_search_with_limit_ready, _data_);
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1488 "rygel-searchable-container-test.c"
		_state_2:
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp6_ = NULL;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp6_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->total_matches = _data_->_tmp5_;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_vala1__result_ = _data_->_tmp6_;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1500 "rygel-searchable-container-test.c"
			goto __catch4_g_error;
		}
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp7_ = 0U;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp7_ = _data_->total_matches;
#line 123 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp7_ == ((guint) 0), "total_matches == 0");
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp8_ = 0;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_vala1__result_);
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp9_ = 0;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 124 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_vala_assert (_data_->_tmp9_ == 0, "result.size == 0");
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_object_unref0 (_data_->_vala1__result_);
#line 1521 "rygel-searchable-container-test.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_vala1__error_ = _data_->_inner_error_;
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_inner_error_ = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_error_free0 (_data_->_vala1__error_);
#line 1534 "rygel-searchable-container-test.c"
	}
	__finally4:
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 120 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1545 "rygel-searchable-container-test.c"
	}
	{
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->i = 1;
#line 1550 "rygel-searchable-container-test.c"
		{
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			_data_->_tmp10_ = TRUE;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			while (TRUE) {
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp11_ = FALSE;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp11_ = _data_->_tmp10_;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!_data_->_tmp11_) {
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp12_ = 0;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp12_ = _data_->i;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->i = _data_->_tmp12_ + 1;
#line 1568 "rygel-searchable-container-test.c"
				}
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp10_ = FALSE;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp13_ = 0;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				_data_->_tmp13_ = _data_->i;
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (!(_data_->_tmp13_ < 10)) {
#line 129 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					break;
#line 1580 "rygel-searchable-container-test.c"
				}
				{
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp14_ = 0;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp14_ = _data_->i;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp15_ = 0U;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_state_ = 3;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) _data_->_tmp14_, (guint) 3, "", NULL, test_container_test_search_with_limit_ready, _data_);
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					return FALSE;
#line 1595 "rygel-searchable-container-test.c"
					_state_3:
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp16_ = NULL;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp16_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp15_, &_data_->_inner_error_);
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->total_matches = _data_->_tmp15_;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_vala2__result_ = _data_->_tmp16_;
#line 131 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					if (_data_->_inner_error_ != NULL) {
#line 1607 "rygel-searchable-container-test.c"
						goto __catch5_g_error;
					}
#line 132 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp17_ = 0U;
#line 132 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp17_ = _data_->total_matches;
#line 132 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_vala_assert (_data_->_tmp17_ == ((guint) 0), "total_matches == 0");
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp18_ = NULL;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp18_ = _data_->_vala2__result_;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp19_ = 0;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp18_);
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp20_ = 0;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp20_ = _data_->_tmp19_;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp21_ = 0;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp21_ = _data_->i;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp22_ = 0;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_tmp22_ = MIN (10 - _data_->_tmp21_, 3);
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_vala_assert (_data_->_tmp20_ == _data_->_tmp22_, "result.size == int.min (10 - i, 3)");
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_g_object_unref0 (_data_->_vala2__result_);
#line 1640 "rygel-searchable-container-test.c"
				}
				goto __finally5;
				__catch5_g_error:
				{
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_vala2__error_ = _data_->_inner_error_;
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_data_->_inner_error_ = NULL;
#line 135 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_assert_not_reached ();
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					_g_error_free0 (_data_->_vala2__error_);
#line 1653 "rygel-searchable-container-test.c"
				}
				__finally5:
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
				if (_data_->_inner_error_ != NULL) {
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					g_clear_error (&_data_->_inner_error_);
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
					return FALSE;
#line 1664 "rygel-searchable-container-test.c"
				}
			}
		}
	}
#line 139 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp23_ = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp23_ = _data_->self->loop;
#line 139 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_quit (_data_->_tmp23_);
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1679 "rygel-searchable-container-test.c"
	} else {
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1683 "rygel-searchable-container-test.c"
	}
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 108 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1689 "rygel-searchable-container-test.c"
}


void test_container_test_serialization (TestContainer* self) {
	GUPnPDIDLLiteWriter* writer = NULL;
	GUPnPDIDLLiteWriter* _tmp0_ = NULL;
	GUPnPDIDLLiteContainer* didl_container = NULL;
	GUPnPDIDLLiteContainer* _tmp1_ = NULL;
#line 146 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	writer = _tmp0_;
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = gupnp_didl_lite_writer_add_container (writer);
#line 148 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	didl_container = _tmp1_;
#line 149 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	rygel_searchable_container_serialize_search_parameters ((RygelSearchableContainer*) self, didl_container);
#line 146 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (didl_container);
#line 146 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (writer);
#line 1714 "rygel-searchable-container-test.c"
}


static void test_container_real_search_data_free (gpointer _data) {
	TestContainerSearchData* _data_;
	_data_ = _data;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->expression);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (_data_->sort_criteria);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->result);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->self);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_slice_free (TestContainerSearchData, _data_);
#line 1733 "rygel-searchable-container-test.c"
}


static void test_container_real_search (RygelSearchableContainer* base, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestContainer * self;
	TestContainerSearchData* _data_;
	TestContainer* _tmp0_ = NULL;
	SearchExpression* _tmp1_ = NULL;
	SearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) base;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_slice_new0 (TestContainerSearchData);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, test_container_real_search);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_container_real_search_data_free);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->self = _tmp0_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = expression;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->expression);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->expression = _tmp2_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = offset;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->offset = _tmp3_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp4_ = max_count;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->max_count = _tmp4_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp5_ = sort_criteria;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (_data_->sort_criteria);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->sort_criteria = _tmp6_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp7_ = cancellable;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->cancellable = _tmp8_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_real_search_co (_data_);
#line 1795 "rygel-searchable-container-test.c"
}


static MediaObjects* test_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	MediaObjects* result;
	TestContainerSearchData* _data_;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return NULL;
#line 1806 "rygel-searchable-container-test.c"
	}
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (total_matches) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		*total_matches = _data_->total_matches;
#line 1814 "rygel-searchable-container-test.c"
	}
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = _data_->result;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 1822 "rygel-searchable-container-test.c"
}


static void test_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestContainerSearchData* _data_;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_ = _user_data_;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_source_object_ = source_object;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_res_ = _res_;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_real_search_co (_data_);
#line 1836 "rygel-searchable-container-test.c"
}


static gboolean test_container_real_search_co (TestContainerSearchData* _data_) {
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (_data_->_state_) {
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 0:
#line 1845 "rygel-searchable-container-test.c"
		goto _state_0;
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case 1:
#line 1849 "rygel-searchable-container-test.c"
		goto _state_1;
		default:
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_assert_not_reached ();
#line 1854 "rygel-searchable-container-test.c"
	}
	_state_0:
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp1_ = NULL;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp1_ = _data_->sort_criteria;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp2_ = NULL;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp0_ = _data_->_tmp2_;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp3_ = NULL;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_tmp3_ == NULL) {
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp4_ = NULL;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp4_ = ((MediaContainer*) _data_->self)->sort_criteria;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp5_ = NULL;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_free0 (_data_->_tmp0_);
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_data_->_tmp0_ = _data_->_tmp5_;
#line 1885 "rygel-searchable-container-test.c"
	}
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp7_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp7_ = _data_->expression;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp8_ = 0U;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp8_ = _data_->offset;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp9_ = 0U;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp9_ = _data_->max_count;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp10_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp10_ = _data_->_tmp0_;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp11_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp11_ = _data_->cancellable;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp12_ = 0U;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_state_ = 1;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, test_container_search_ready, _data_);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1915 "rygel-searchable-container-test.c"
	_state_1:
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp13_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp13_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp12_, &_data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->total_matches = _data_->_tmp12_;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->_tmp6_ = _data_->_tmp13_;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_error_free (_data_->_inner_error_);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		_g_free0 (_data_->_tmp0_);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		if (_data_->_state_ == 0) {
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1937 "rygel-searchable-container-test.c"
		} else {
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1941 "rygel-searchable-container-test.c"
		}
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_object_unref (_data_->_async_result);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		return FALSE;
#line 1947 "rygel-searchable-container-test.c"
	}
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_data_->result = _data_->_tmp6_;
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (_data_->_tmp0_);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1957 "rygel-searchable-container-test.c"
	} else {
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1961 "rygel-searchable-container-test.c"
	}
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 159 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_free0 (_data_->_tmp0_);
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	if (_data_->_state_ == 0) {
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1973 "rygel-searchable-container-test.c"
	} else {
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1977 "rygel-searchable-container-test.c"
	}
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_unref (_data_->_async_result);
#line 152 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return FALSE;
#line 1983 "rygel-searchable-container-test.c"
}


TestContainer* test_container_construct (GType object_type) {
	TestContainer * self = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) media_container_construct (object_type);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 1993 "rygel-searchable-container-test.c"
}


TestContainer* test_container_new (void) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return test_container_construct (TYPE_TEST_CONTAINER);
#line 2000 "rygel-searchable-container-test.c"
}


static GeeArrayList* test_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	TestContainer* self;
	GeeArrayList* _tmp0_ = NULL;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) base;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = self->priv->_search_classes;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = _tmp0_;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 2016 "rygel-searchable-container-test.c"
}


static void test_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	TestContainer* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (TestContainer*) base;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = value;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->priv->_search_classes = _tmp1_;
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 2036 "rygel-searchable-container-test.c"
}


static void test_container_class_init (TestContainerClass * klass) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_parent_class = g_type_class_peek_parent (klass);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_type_class_add_private (klass, sizeof (TestContainerPrivate));
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_test_container_get_property;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_test_container_set_property;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (klass)->finalize = test_container_finalize;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_CONTAINER_SEARCH_CLASSES, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2053 "rygel-searchable-container-test.c"
}


static void test_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->search = (MediaObjects* (*)(RygelSearchableContainer*, SearchExpression*, guint, guint, guint*, const gchar*, GCancellable*, GError**)) test_container_real_search;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->search_finish = test_container_real_search_finish;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->get_search_classes = test_container_real_get_search_classes;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	iface->set_search_classes = test_container_real_set_search_classes;
#line 2068 "rygel-searchable-container-test.c"
}


static void test_container_instance_init (TestContainer * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->priv = TEST_CONTAINER_GET_PRIVATE (self);
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self->priv->_search_classes = _tmp0_;
#line 2080 "rygel-searchable-container-test.c"
}


static void test_container_finalize (GObject* obj) {
	TestContainer * self;
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEST_CONTAINER, TestContainer);
#line 71 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_main_loop_unref0 (self->loop);
#line 72 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	G_OBJECT_CLASS (test_container_parent_class)->finalize (obj);
#line 2094 "rygel-searchable-container-test.c"
}


GType test_container_get_type (void) {
	static volatile gsize test_container_type_id__volatile = 0;
	if (g_once_init_enter (&test_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestContainer), 0, (GInstanceInitFunc) test_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) test_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType test_container_type_id;
		test_container_type_id = g_type_register_static (TYPE_MEDIA_CONTAINER, "TestContainer", &g_define_type_info, 0);
		g_type_add_interface_static (test_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&test_container_type_id__volatile, test_container_type_id);
	}
	return test_container_type_id__volatile;
}


static void _vala_test_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TestContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEST_CONTAINER, TestContainer);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (property_id) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case TEST_CONTAINER_SEARCH_CLASSES:
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 2123 "rygel-searchable-container-test.c"
		default:
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 2129 "rygel-searchable-container-test.c"
	}
}


static void _vala_test_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TestContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEST_CONTAINER, TestContainer);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	switch (property_id) {
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		case TEST_CONTAINER_SEARCH_CLASSES:
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 2145 "rygel-searchable-container-test.c"
		default:
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
		break;
#line 2151 "rygel-searchable-container-test.c"
	}
}


static GeeList* media_objects_real_slice (GeeAbstractList* base, gint start, gint stop) {
	MediaObjects * self;
	GeeList* result = NULL;
	GeeList* slice = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GeeList* _tmp2_ = NULL;
	MediaObjects* ret = NULL;
	MediaObjects* _tmp3_ = NULL;
#line 170 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaObjects*) base;
#line 171 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = start;
#line 171 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = stop;
#line 171 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = GEE_ABSTRACT_LIST_CLASS (media_objects_parent_class)->slice ((GeeAbstractList*) G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ARRAY_LIST, GeeArrayList), _tmp0_, _tmp1_);
#line 171 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	slice = _tmp2_;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = media_objects_new ();
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	ret = _tmp3_;
#line 174 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	gee_array_list_add_all ((GeeArrayList*) ret, (GeeCollection*) slice);
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = (GeeList*) ret;
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (slice);
#line 176 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 2187 "rygel-searchable-container-test.c"
}


MediaObjects* media_objects_construct (GType object_type) {
	MediaObjects * self = NULL;
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	self = (MediaObjects*) gee_array_list_construct (object_type, TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return self;
#line 2197 "rygel-searchable-container-test.c"
}


MediaObjects* media_objects_new (void) {
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return media_objects_construct (TYPE_MEDIA_OBJECTS);
#line 2204 "rygel-searchable-container-test.c"
}


static void media_objects_class_init (MediaObjectsClass * klass) {
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	media_objects_parent_class = g_type_class_peek_parent (klass);
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = media_objects_real_slice;
#line 2213 "rygel-searchable-container-test.c"
}


static void media_objects_instance_init (MediaObjects * self) {
}


GType media_objects_get_type (void) {
	static volatile gsize media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaObjects), 0, (GInstanceInitFunc) media_objects_instance_init, NULL };
		GType media_objects_type_id;
		media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "MediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&media_objects_type_id__volatile, media_objects_type_id);
	}
	return media_objects_type_id__volatile;
}


gint _vala_main (void) {
	gint result = 0;
	TestContainer* c = NULL;
	TestContainer* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 182 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp0_ = test_container_new ();
#line 182 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	c = _tmp0_;
#line 183 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp1_ = g_main_loop_new (NULL, FALSE);
#line 183 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_main_loop_unref0 (c->loop);
#line 183 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	c->loop = _tmp1_;
#line 184 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_no_limit (c, NULL, NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp2_ = c->loop;
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_run (_tmp2_);
#line 186 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	test_container_test_search_with_limit (c, NULL, NULL);
#line 187 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_tmp3_ = c->loop;
#line 187 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_main_loop_run (_tmp3_);
#line 189 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	result = 0;
#line 189 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	_g_object_unref0 (c);
#line 189 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return result;
#line 2268 "rygel-searchable-container-test.c"
}


int main (int argc, char ** argv) {
#line 180 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	g_type_init ();
#line 180 "/home/jens/Source/rygel/tests/rygel-searchable-container-test.vala"
	return _vala_main ();
#line 2277 "rygel-searchable-container-test.c"
}



