/* rygel-http-post.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-post.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPPostPrivate RygelHTTPPostPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpPostHandleData RygelHttpPostHandleData;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHttpPostHandleRealData RygelHttpPostHandleRealData;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _RygelHttpPostWaitForItemData RygelHttpPostWaitForItemData;
typedef struct _RygelHttpPostFinalizePostData RygelHttpPostFinalizePostData;
typedef struct _RygelHttpPostRemoveItemData RygelHttpPostRemoveItemData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPPost {
	RygelHTTPRequest parent_instance;
	RygelHTTPPostPrivate * priv;
};

struct _RygelHTTPPostClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPPostPrivate {
	GSourceFunc handle_continue;
	gpointer handle_continue_target;
	GDestroyNotify handle_continue_target_destroy_notify;
	GFile* file;
	GFile* dotfile;
	GOutputStream* stream;
};

struct _RygelHttpPostHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp0_;
	RygelObjectRemovalQueue* _tmp1_;
	RygelMediaObject* _tmp2_;
	GError* _error_;
	RygelObjectRemovalQueue* _tmp3_;
	RygelMediaObject* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	RygelMediaContainer* parent;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	glong duration;
	GeeArrayList* uris;
	gboolean place_holder;
	GFile* file;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpPostHandleRealData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelMediaObject* _tmp0_;
	gboolean _tmp1_;
	gchar* msg;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelMediaObject* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	GFile* _tmp8_;
	RygelMediaObject* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	const gchar* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GFile* _tmp26_;
	GFileOutputStream* _tmp27_;
	GFile* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GFileOutputStream* _tmp31_;
	SoupMessage* _tmp32_;
	SoupMessage* _tmp33_;
	SoupServer* _tmp34_;
	SoupMessage* _tmp35_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	RygelHTTPPost * self;
	RygelMediaContainer* container;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	guint source_id;
};

struct _RygelHttpPostWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelMediaContainer* container;
	gchar* id;
	guint timeout;
	Block5Data* _data5_;
	RygelMediaContainer* _tmp0_;
	RygelMediaItem* item;
	gboolean _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMediaItem* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaContainer* _tmp7_;
	const gchar* _tmp8_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaItem* _tmp12_;
	GError* _error_;
	RygelMediaItem* _tmp13_;
	const gchar* _tmp14_;
	RygelMediaItem* _tmp15_;
	gboolean _tmp16_;
	Block6Data* _data6_;
	guint _tmp17_;
	guint _tmp18_;
	gulong update_id;
	RygelMediaContainer* _tmp19_;
	gulong _tmp20_;
	RygelMediaContainer* _tmp21_;
	gulong _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	GError * _inner_error_;
};

struct _RygelHttpPostFinalizePostData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	GOutputStream* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GError* _error_;
	GSourceFunc _tmp3_;
	void* _tmp3__target;
	SoupServer* _tmp4_;
	SoupMessage* _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaContainer* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaObject* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	GError* move_error;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	SoupServer* _tmp21_;
	SoupMessage* _tmp22_;
	GSourceFunc _tmp23_;
	void* _tmp23__target;
	RygelMediaObject* _tmp24_;
	RygelMediaContainer* _tmp25_;
	RygelMediaObject* _tmp26_;
	const gchar* _tmp27_;
	SoupServer* _tmp28_;
	SoupMessage* _tmp29_;
	GSourceFunc _tmp30_;
	void* _tmp30__target;
	GError * _inner_error_;
};

struct _RygelHttpPostRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp0_;
	RygelMediaObject* _tmp1_;
};


static gpointer rygel_http_post_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_post_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST, RygelHTTPPostPrivate))
enum  {
	RYGEL_HTTP_POST_DUMMY_PROPERTY
};
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self);
static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self);
static void rygel_http_post_real_handle_data_free (gpointer _data);
static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
gboolean rygel_object_removal_queue_dequeue (RygelObjectRemovalQueue* self, RygelMediaObject* item);
static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_object_removal_queue_remove_now (RygelObjectRemovalQueue* self, RygelMediaObject* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_object_removal_queue_remove_now_finish (RygelObjectRemovalQueue* self, GAsyncResult* _res_);
static void rygel_http_post_handle_real_data_free (gpointer _data);
static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GQuark rygel_content_directory_error_quark (void);
void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark rygel_http_request_error_quark (void);
static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk);
static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg);
static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self);
static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self);
static void rygel_http_post_finalize_post (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_finalize_post_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_wait_for_item_data_free (gpointer _data);
static void rygel_http_post_wait_for_item (RygelHTTPPost* self, RygelMediaContainer* container, const gchar* id, guint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_wait_for_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static gboolean rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block6Data* _data6_);
static gboolean _____lambda4__gsource_func (gpointer self);
static void ____lambda5_ (Block6Data* _data6_);
static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static void rygel_http_post_finalize_post_data_free (gpointer _data);
static gboolean rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_post_finalize_post_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_disconnect_message_signals (RygelHTTPPost* self);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_remove_item_data_free (gpointer _data);
static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_);
static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_finalize (GObject* obj);


static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self) {
#line 43 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_on_request_cancelled (self);
#line 496 "rygel-http-post.c"
}


RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPPost * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessageBody* _tmp6_ = NULL;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = http_server;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp1_ = server;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp2_ = msg;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self = (RygelHTTPPost*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp4_ = _tmp3_;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_cancellable_connect (_tmp4_, (GCallback) _rygel_http_post_on_request_cancelled_gfunc, g_object_ref (self), g_object_unref);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp5_ = msg;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp6_ = _tmp5_->request_body;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	soup_message_body_set_accumulate (_tmp6_, FALSE);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return self;
#line 537 "rygel-http-post.c"
}


RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return rygel_http_post_construct (RYGEL_TYPE_HTTP_POST, http_server, server, msg);
#line 544 "rygel-http-post.c"
}


static void rygel_http_post_real_handle_data_free (gpointer _data) {
	RygelHttpPostHandleData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_slice_free (RygelHttpPostHandleData, _data_);
#line 555 "rygel-http-post.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return self ? g_object_ref (self) : NULL;
#line 562 "rygel-http-post.c"
}


static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPPost * self;
	RygelHttpPostHandleData* _data_;
	RygelHTTPPost* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self = (RygelHTTPPost*) base;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostHandleData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_real_handle);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_real_handle_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_real_handle_co (_data_);
#line 584 "rygel-http-post.c"
}


static void rygel_http_post_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return;
#line 594 "rygel-http-post.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 598 "rygel-http-post.c"
}


static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleData* _data_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = _user_data_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_real_handle_co (_data_);
#line 612 "rygel-http-post.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return self ? g_error_copy (self) : NULL;
#line 619 "rygel-http-post.c"
}


static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 0:
#line 628 "rygel-http-post.c"
		goto _state_0;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 1:
#line 632 "rygel-http-post.c"
		goto _state_1;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 2:
#line 636 "rygel-http-post.c"
		goto _state_2;
		default:
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_assert_not_reached ();
#line 641 "rygel-http-post.c"
	}
	_state_0:
#line 48 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = rygel_object_removal_queue_get_default ();
#line 48 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->queue = _data_->_tmp0_;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp1_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp1_ = _data_->queue;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp2_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_object_removal_queue_dequeue (_data_->_tmp1_, _data_->_tmp2_);
#line 660 "rygel-http-post.c"
	{
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_state_ = 1;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_http_post_handle_real (_data_->self, rygel_http_post_handle_ready, _data_);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 668 "rygel-http-post.c"
		_state_1:
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_http_post_handle_real_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 674 "rygel-http-post.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_inner_error_ = NULL;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3_ = NULL;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3_ = _data_->queue;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp4_ = NULL;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp5_ = NULL;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp6_ = NULL;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_state_ = 2;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_object_removal_queue_remove_now (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp6_, rygel_http_post_handle_ready, _data_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 707 "rygel-http-post.c"
		_state_2:
#line 54 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_object_removal_queue_remove_now_finish (_data_->_tmp3_, _data_->_res_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp7_ = NULL;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp7_ = _data_->_error_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp8_ = NULL;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_error_free0 (_data_->_error_);
#line 723 "rygel-http-post.c"
		goto __finally6;
	}
	__finally6:
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_object_unref0 (_data_->queue);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 739 "rygel-http-post.c"
		} else {
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 743 "rygel-http-post.c"
		}
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 749 "rygel-http-post.c"
	}
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->queue);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 757 "rygel-http-post.c"
	} else {
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 761 "rygel-http-post.c"
	}
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 767 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_data_free (gpointer _data) {
	RygelHttpPostHandleRealData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_slice_free (RygelHttpPostHandleRealData, _data_);
#line 778 "rygel-http-post.c"
}


static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
	RygelHTTPPost* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostHandleRealData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_handle_real);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_handle_real_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_handle_real_co (_data_);
#line 797 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleRealData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return;
#line 807 "rygel-http-post.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 811 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = _user_data_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_handle_real_co (_data_);
#line 825 "rygel-http-post.c"
}


static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_on_got_chunk (self, _sender, chunk);
#line 832 "rygel-http-post.c"
}


static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_on_got_body (self, _sender);
#line 839 "rygel-http-post.c"
}


static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_post_handle_real_co (self);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return result;
#line 848 "rygel-http-post.c"
}


static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 0:
#line 857 "rygel-http-post.c"
		goto _state_0;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 1:
#line 861 "rygel-http-post.c"
		goto _state_1;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 2:
#line 865 "rygel-http-post.c"
		goto _state_2;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 3:
#line 869 "rygel-http-post.c"
		goto _state_3;
		default:
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_assert_not_reached ();
#line 874 "rygel-http-post.c"
	}
	_state_0:
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp1_ = FALSE;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp1_ = (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp0_) : NULL)->place_holder;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (!_data_->_tmp1_) {
#line 62 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp2_ = NULL;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp2_ = _ ("Pushing data to non-empty item '%s' not allowed");
#line 62 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3_ = NULL;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->msg = _data_->_tmp3_;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp4_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp4_ = _data_->msg;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp5_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp6_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp6_ = _data_->_tmp5_->id;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp7_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp7_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp4_, _data_->_tmp6_);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp7_;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_free0 (_data_->msg);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 925 "rygel-http-post.c"
		} else {
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 929 "rygel-http-post.c"
		}
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 935 "rygel-http-post.c"
	}
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp9_ = NULL;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp10_ = NULL;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp11_ = NULL;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_media_item_get_writable (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp9_) : NULL, _data_->_tmp11_, rygel_http_post_handle_real_ready, _data_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 955 "rygel-http-post.c"
	_state_1:
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp12_ = NULL;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp12_ = rygel_media_item_get_writable_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp9_) : NULL, _data_->_res_, &_data_->_inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp8_ = _data_->_tmp12_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 973 "rygel-http-post.c"
		} else {
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 977 "rygel-http-post.c"
		}
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 983 "rygel-http-post.c"
	}
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->file);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->file = _data_->_tmp8_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp13_ = NULL;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp13_ = _data_->self->priv->file;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_tmp13_ == NULL) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp14_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp14_ = _ ("No writable URI for %s available");
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp15_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp15_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp16_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp16_ = _data_->_tmp15_->id;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp17_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp17_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp14_, _data_->_tmp16_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp17_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1021 "rygel-http-post.c"
		} else {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1025 "rygel-http-post.c"
		}
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 1031 "rygel-http-post.c"
	}
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp18_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp18_ = _data_->self->priv->file;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp19_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp19_ = g_file_get_parent (_data_->_tmp18_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp20_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp20_ = _data_->_tmp19_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp21_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp21_ = _data_->self->priv->file;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp22_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp22_ = g_file_get_basename (_data_->_tmp21_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp23_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp24_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp24_ = g_strconcat (".", _data_->_tmp23_, NULL);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp25_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp25_ = _data_->_tmp24_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp26_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp26_ = g_file_get_child (_data_->_tmp20_, _data_->_tmp25_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->dotfile);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->dotfile = _data_->_tmp26_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_free0 (_data_->_tmp25_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_free0 (_data_->_tmp23_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->_tmp20_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp28_ = NULL;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp28_ = _data_->self->priv->dotfile;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp29_ = NULL;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp29_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp30_ = NULL;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp30_ = _data_->_tmp29_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_state_ = 2;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_file_replace_async (_data_->_tmp28_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_LOW, _data_->_tmp30_, rygel_http_post_handle_real_ready, _data_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 1097 "rygel-http-post.c"
	_state_2:
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp31_ = NULL;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp31_ = g_file_replace_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp27_ = _data_->_tmp31_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1115 "rygel-http-post.c"
		} else {
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1119 "rygel-http-post.c"
		}
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 1125 "rygel-http-post.c"
	}
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->stream);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->stream = (GOutputStream*) _data_->_tmp27_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp32_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp32_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_signal_connect_object (_data_->_tmp32_, "got-chunk", (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, _data_->self, 0);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp33_ = NULL;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp33_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_signal_connect_object (_data_->_tmp33_, "got-body", (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, _data_->self, 0);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp34_ = NULL;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp34_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp35_ = NULL;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp35_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	soup_server_unpause_message (_data_->_tmp34_, _data_->_tmp35_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	(_data_->self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->handle_continue_target_destroy_notify (_data_->self->priv->handle_continue_target), NULL);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->handle_continue = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->handle_continue = _rygel_http_post_handle_real_co_gsource_func;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target = _data_;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_state_ = 3;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 1171 "rygel-http-post.c"
	_state_3:
	;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1178 "rygel-http-post.c"
	} else {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1182 "rygel-http-post.c"
	}
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 1188 "rygel-http-post.c"
}


static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg) {
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_if_fail (msg != NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp1_ = msg;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_tmp0_ != _tmp1_) {
#line 95 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return;
#line 1207 "rygel-http-post.c"
	}
#line 98 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_finalize_post (self, NULL, NULL);
#line 1211 "rygel-http-post.c"
}


static void rygel_http_post_wait_for_item_data_free (gpointer _data) {
	RygelHttpPostWaitForItemData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_free0 (_data_->id);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_slice_free (RygelHttpPostWaitForItemData, _data_);
#line 1224 "rygel-http-post.c"
}


static void rygel_http_post_wait_for_item (RygelHTTPPost* self, RygelMediaContainer* container, const gchar* id, guint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostWaitForItemData* _data_;
	RygelHTTPPost* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostWaitForItemData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_wait_for_item);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_wait_for_item_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp1_ = container;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->container);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->container = _tmp2_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp3_ = id;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_free0 (_data_->id);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->id = _tmp4_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp5_ = timeout;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->timeout = _tmp5_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data_);
#line 1268 "rygel-http-post.c"
}


static void rygel_http_post_wait_for_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostWaitForItemData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1276 "rygel-http-post.c"
}


/**
     * Waits for an item with @id to change its state to non-placeholder under
     * @container, but at most @timeout seconds.
     *
     * @param container The container to watch for changes
     * @param id The child id to look for
     * @param timeout Seconds to wait befor cancelling
     */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return _data5_;
#line 1293 "rygel-http-post.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 1302 "rygel-http-post.c"
		RygelHTTPPost * self;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		self = _data5_->self;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_object_unref0 (_data5_->container);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_object_unref0 (self);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_slice_free (Block5Data, _data5_);
#line 1312 "rygel-http-post.c"
	}
}


static void rygel_http_post_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostWaitForItemData* _data_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = _user_data_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data_);
#line 1327 "rygel-http-post.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return _data6_;
#line 1336 "rygel-http-post.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1345 "rygel-http-post.c"
		RygelHTTPPost * self;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		self = _data6_->_data5_->self;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		block5_data_unref (_data6_->_data5_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data6_->_data5_ = NULL;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_slice_free (Block6Data, _data6_);
#line 1355 "rygel-http-post.c"
	}
}


static gboolean ____lambda4_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelHTTPPost * self;
	gboolean result = FALSE;
	RygelMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data5_ = _data6_->_data5_;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self = _data5_->self;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = _data5_->container;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_debug ("rygel-http-post.vala:135: Timeout on waiting for 'updated' signal on '" \
"%s'.", _tmp1_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data6_->source_id = (guint) 0;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data5_->_async_data_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	result = FALSE;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return result;
#line 1384 "rygel-http-post.c"
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return result;
#line 1393 "rygel-http-post.c"
}


static void ____lambda5_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelHTTPPost * self;
	RygelMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data5_ = _data6_->_data5_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self = _data5_->self;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = _data5_->container;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_debug ("rygel-http-post.vala:144: Finished waiting for update signal from cont" \
"ainer '%s'", _tmp1_);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_wait_for_item_co (_data5_->_async_data_);
#line 1414 "rygel-http-post.c"
}


static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	____lambda5_ (self);
#line 1421 "rygel-http-post.c"
}


static gboolean rygel_http_post_wait_for_item_co (RygelHttpPostWaitForItemData* _data_) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 0:
#line 1430 "rygel-http-post.c"
		goto _state_0;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 1:
#line 1434 "rygel-http-post.c"
		goto _state_1;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 2:
#line 1438 "rygel-http-post.c"
		goto _state_2;
		default:
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_assert_not_reached ();
#line 1443 "rygel-http-post.c"
	}
	_state_0:
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_data5_ = g_slice_new0 (Block5Data);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_data5_->_ref_count_ = 1;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_data5_->self = g_object_ref (_data_->self);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = _data_->container;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->_data5_->container);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_data5_->container = _data_->_tmp0_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_data5_->_async_data_ = _data_;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->item = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	while (TRUE) {
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp2_ = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp2_ = _data_->item;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_tmp2_ == NULL) {
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp1_ = TRUE;
#line 1474 "rygel-http-post.c"
		} else {
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp3_ = NULL;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp3_ = _data_->item;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp4_ = FALSE;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp4_ = _data_->_tmp3_->place_holder;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp1_ = _data_->_tmp4_;
#line 1486 "rygel-http-post.c"
		}
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp5_ = FALSE;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp5_ = _data_->_tmp1_;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (!_data_->_tmp5_) {
#line 114 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			break;
#line 1496 "rygel-http-post.c"
		}
		{
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp7_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp7_ = _data_->_data5_->container;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp8_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp8_ = _data_->id;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp9_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp10_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_state_ = 1;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			rygel_media_container_find_object (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp10_, rygel_http_post_wait_for_item_ready, _data_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			return FALSE;
#line 1521 "rygel-http-post.c"
			_state_1:
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp11_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp11_ = rygel_media_container_find_object_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp6_ = _data_->_tmp11_;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1531 "rygel-http-post.c"
				goto __catch7_g_error;
			}
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp12_ = NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp6_) : NULL;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			if (_data_->_tmp12_ == NULL) {
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
				_g_object_unref0 (_data_->_tmp6_);
#line 1542 "rygel-http-post.c"
			}
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_g_object_unref0 (_data_->item);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->item = _data_->_tmp12_;
#line 1548 "rygel-http-post.c"
		}
		goto __finally7;
		__catch7_g_error:
		{
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_error_ = _data_->_inner_error_;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_inner_error_ = NULL;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_g_error_free0 (_data_->_error_);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			break;
#line 1561 "rygel-http-post.c"
		}
		__finally7:
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_g_object_unref0 (_data_->item);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			block5_data_unref (_data_->_data5_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_data5_ = NULL;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_clear_error (&_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			return FALSE;
#line 1578 "rygel-http-post.c"
		}
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp13_ = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp13_ = _data_->item;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_tmp13_ == NULL) {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp14_ = NULL;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp14_ = _data_->id;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_warning ("rygel-http-post.vala:127: Item %s disappeared, stop waiting for it", _data_->_tmp14_);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			break;
#line 1594 "rygel-http-post.c"
		}
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp15_ = NULL;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp15_ = _data_->item;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp16_ = FALSE;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp16_ = _data_->_tmp15_->place_holder;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_tmp16_) {
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_data6_ = g_slice_new0 (Block6Data);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_data6_->_ref_count_ = 1;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_data6_->_data5_ = block5_data_ref (_data_->_data5_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_data6_->source_id = (guint) 0;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp17_ = 0U;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp17_ = _data_->timeout;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp18_ = 0U;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp18_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->_tmp17_, _____lambda4__gsource_func, block6_data_ref (_data_->_data6_), block6_data_unref);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_data6_->source_id = _data_->_tmp18_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp19_ = NULL;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp19_ = _data_->_data5_->container;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp20_ = 0UL;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp20_ = g_signal_connect_data (_data_->_tmp19_, "container-updated", (GCallback) _____lambda5__rygel_media_container_container_updated, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->update_id = _data_->_tmp20_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_state_ = 2;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			return FALSE;
#line 1638 "rygel-http-post.c"
			_state_2:
			;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp21_ = NULL;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp21_ = _data_->_data5_->container;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp22_ = 0UL;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp22_ = _data_->update_id;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_signal_handler_disconnect ((GObject*) _data_->_tmp21_, _data_->_tmp22_);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp23_ = 0U;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_tmp23_ = _data_->_data6_->source_id;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			if (_data_->_tmp23_ != ((guint) 0)) {
#line 155 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
				_data_->_tmp24_ = 0U;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
				_data_->_tmp24_ = _data_->_data6_->source_id;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
				g_source_remove (_data_->_tmp24_);
#line 1663 "rygel-http-post.c"
			} else {
#line 157 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
				block6_data_unref (_data_->_data6_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
				_data_->_data6_ = NULL;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
				break;
#line 1671 "rygel-http-post.c"
			}
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			block6_data_unref (_data_->_data6_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			_data_->_data6_ = NULL;
#line 1677 "rygel-http-post.c"
		}
	}
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->item);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	block5_data_unref (_data_->_data5_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_data5_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1690 "rygel-http-post.c"
	} else {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1694 "rygel-http-post.c"
	}
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 1700 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post_data_free (gpointer _data) {
	RygelHttpPostFinalizePostData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_slice_free (RygelHttpPostFinalizePostData, _data_);
#line 1711 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostFinalizePostData* _data_;
	RygelHTTPPost* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostFinalizePostData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_finalize_post);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_finalize_post_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_finalize_post_co (_data_);
#line 1730 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostFinalizePostData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1738 "rygel-http-post.c"
}


static void rygel_http_post_finalize_post_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostFinalizePostData* _data_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = _user_data_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_finalize_post_co (_data_);
#line 1752 "rygel-http-post.c"
}


static gboolean rygel_http_post_finalize_post_co (RygelHttpPostFinalizePostData* _data_) {
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 0:
#line 1761 "rygel-http-post.c"
		goto _state_0;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 1:
#line 1765 "rygel-http-post.c"
		goto _state_1;
		default:
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_assert_not_reached ();
#line 1770 "rygel-http-post.c"
	}
	_state_0:
	{
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp0_ = NULL;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp0_ = _data_->self->priv->stream;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp1_ = NULL;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp2_ = NULL;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_output_stream_close (_data_->_tmp0_, _data_->_tmp2_, &_data_->_inner_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1790 "rygel-http-post.c"
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
#line 164 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_inner_error_ = NULL;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3_ = NULL;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3__target = NULL;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3_ = _data_->self->priv->handle_continue;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3__target = _data_->self->priv->handle_continue_target;
#line 168 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp3_ (_data_->_tmp3__target);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_error_free0 (_data_->_error_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1819 "rygel-http-post.c"
		} else {
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1823 "rygel-http-post.c"
		}
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 1829 "rygel-http-post.c"
	}
	__finally8:
#line 164 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 164 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_clear_error (&_data_->_inner_error_);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 1840 "rygel-http-post.c"
	}
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp4_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp5_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp5_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	soup_server_pause_message (_data_->_tmp4_, _data_->_tmp5_);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp6_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp7_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp7_ = _data_->_tmp6_->parent;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp8_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp8_ = ((RygelMediaObject*) _data_->_tmp7_)->id;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp9_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp10_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp10_ = _data_->_tmp9_->id;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_debug ("Waiting for update signal from container '%s' after pushing" " content to its child item '%s'…", _data_->_tmp8_, _data_->_tmp10_);
#line 1874 "rygel-http-post.c"
	{
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp11_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp11_ = _data_->self->priv->dotfile;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp12_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp12_ = _data_->self->priv->file;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp13_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp14_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_file_move (_data_->_tmp11_, _data_->_tmp12_, G_FILE_COPY_NONE, _data_->_tmp14_, NULL, NULL, &_data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1896 "rygel-http-post.c"
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->move_error = _data_->_inner_error_;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_inner_error_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp15_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp15_ = _ ("Failed to move dotfile %s: %s");
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp16_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp16_ = _data_->self->priv->dotfile;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp17_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp17_ = g_file_get_uri (_data_->_tmp16_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp18_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp19_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp19_ = _data_->move_error;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp20_ = NULL;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp20_ = _data_->_tmp19_->message;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_free0 (_data_->_tmp18_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp21_ = NULL;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp21_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp22_ = NULL;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp22_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		soup_server_unpause_message (_data_->_tmp21_, _data_->_tmp22_);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp23_ = NULL;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp23__target = NULL;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp23_ = _data_->self->priv->handle_continue;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp23__target = _data_->self->priv->handle_continue_target;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_data_->_tmp23_ (_data_->_tmp23__target);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_error_free0 (_data_->move_error);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1963 "rygel-http-post.c"
		} else {
#line 194 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1967 "rygel-http-post.c"
		}
#line 194 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 1973 "rygel-http-post.c"
	}
	__finally9:
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_clear_error (&_data_->_inner_error_);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return FALSE;
#line 1984 "rygel-http-post.c"
	}
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp24_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp24_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp25_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp25_ = _data_->_tmp24_->parent;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp26_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp27_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp27_ = _data_->_tmp26_->id;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_wait_for_item (_data_->self, _data_->_tmp25_, _data_->_tmp27_, (guint) 5, rygel_http_post_finalize_post_ready, _data_);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 2008 "rygel-http-post.c"
	_state_1:
#line 197 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_wait_for_item_finish (_data_->self, _data_->_res_);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp28_ = NULL;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp28_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp29_ = NULL;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp29_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	soup_server_unpause_message (_data_->_tmp28_, _data_->_tmp29_);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_OK);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp30_ = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp30__target = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp30_ = _data_->self->priv->handle_continue;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp30__target = _data_->self->priv->handle_continue_target;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp30_ (_data_->_tmp30__target);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2038 "rygel-http-post.c"
	} else {
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2042 "rygel-http-post.c"
	}
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 2048 "rygel-http-post.c"
}


static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk) {
	GError * _inner_error_ = NULL;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_if_fail (msg != NULL);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_if_fail (chunk != NULL);
#line 2060 "rygel-http-post.c"
	{
		GOutputStream* _tmp0_ = NULL;
		SoupBuffer* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		GCancellable* _tmp3_ = NULL;
		GCancellable* _tmp4_ = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp0_ = self->priv->stream;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp1_ = chunk;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp2_ = _tmp1_->data;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp2__length1 = (gint) _tmp1_->length;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp4_ = _tmp3_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_output_stream_write_all (_tmp0_, _tmp2_, (gsize) _tmp2__length1, NULL, _tmp4_, &_inner_error_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		if (_inner_error_ != NULL) {
#line 2084 "rygel-http-post.c"
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		GSourceFunc _tmp9_ = NULL;
		void* _tmp9__target = NULL;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_error_ = _inner_error_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_inner_error_ = NULL;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_http_post_disconnect_message_signals (self);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp5_ = _error_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp6_ = _tmp5_->message;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp7_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR, _tmp6_);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp8_ = _tmp7_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		rygel_http_request_handle_error ((RygelHTTPRequest*) self, _tmp8_);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_error_free0 (_tmp8_);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp9_ = self->priv->handle_continue;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp9__target = self->priv->handle_continue_target;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_tmp9_ (_tmp9__target);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		_g_error_free0 (_error_);
#line 2124 "rygel-http-post.c"
	}
	__finally10:
#line 205 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_inner_error_ != NULL) {
#line 205 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_clear_error (&_inner_error_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		return;
#line 2135 "rygel-http-post.c"
	}
}


static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self) {
#line 215 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_remove_item (self, NULL, NULL);
#line 2145 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_data_free (gpointer _data) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_slice_free (RygelHttpPostRemoveItemData, _data_);
#line 2156 "rygel-http-post.c"
}


static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
	RygelHTTPPost* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostRemoveItemData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_remove_item);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_remove_item_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_remove_item_co (_data_);
#line 2175 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostRemoveItemData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2183 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_ = _user_data_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_remove_item_co (_data_);
#line 2197 "rygel-http-post.c"
}


static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_) {
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 0:
#line 2206 "rygel-http-post.c"
		goto _state_0;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		case 1:
#line 2210 "rygel-http-post.c"
		goto _state_1;
		default:
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_assert_not_reached ();
#line 2215 "rygel-http-post.c"
	}
	_state_0:
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp0_ = rygel_object_removal_queue_get_default ();
#line 220 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->queue = _data_->_tmp0_;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp1_ = NULL;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_object_removal_queue_remove_now (_data_->queue, (RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp1_) : NULL), NULL, rygel_http_post_remove_item_ready, _data_);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 2234 "rygel-http-post.c"
	_state_1:
#line 221 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_object_removal_queue_remove_now_finish (_data_->queue, _data_->_res_);
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (_data_->queue);
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2244 "rygel-http-post.c"
	} else {
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2248 "rygel-http-post.c"
	}
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 219 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	return FALSE;
#line 2254 "rygel-http-post.c"
}


static void rygel_http_post_disconnect_message_signals (RygelHTTPPost* self) {
	SoupMessage* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	SoupMessage* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_signal_parse_name ("got-body", soup_message_get_type (), &_tmp1_, NULL, FALSE);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, self);
#line 226 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_tmp2_ = ((RygelHTTPRequest*) self)->msg;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_signal_parse_name ("got-chunk", soup_message_get_type (), &_tmp3_, NULL, FALSE);
#line 226 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, self);
#line 2277 "rygel-http-post.c"
}


static void rygel_http_post_class_init (RygelHTTPPostClass * klass) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	rygel_http_post_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPPostPrivate));
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_post_real_handle;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_post_real_handle_finish;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_finalize;
#line 2292 "rygel-http-post.c"
}


static void rygel_http_post_instance_init (RygelHTTPPost * self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self->priv = RYGEL_HTTP_POST_GET_PRIVATE (self);
#line 2299 "rygel-http-post.c"
}


static void rygel_http_post_finalize (GObject* obj) {
	RygelHTTPPost * self;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_POST, RygelHTTPPost);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	(self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (self->priv->handle_continue_target_destroy_notify (self->priv->handle_continue_target), NULL);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self->priv->handle_continue = NULL;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self->priv->handle_continue_target = NULL;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	self->priv->handle_continue_target_destroy_notify = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (self->priv->file);
#line 35 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (self->priv->dotfile);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	_g_object_unref0 (self->priv->stream);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-post.vala"
	G_OBJECT_CLASS (rygel_http_post_parent_class)->finalize (obj);
#line 2323 "rygel-http-post.c"
}


/**
 * Responsible for handling HTTP POST client requests.
 */
GType rygel_http_post_get_type (void) {
	static volatile gsize rygel_http_post_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPost), 0, (GInstanceInitFunc) rygel_http_post_instance_init, NULL };
		GType rygel_http_post_type_id;
		rygel_http_post_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPPost", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_type_id__volatile, rygel_http_post_type_id);
	}
	return rygel_http_post_type_id__volatile;
}



