/* rygel-http-item-uri-test.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-item-uri-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_IS_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemClass RygelVisualItemClass;
typedef struct _RygelVisualItemPrivate RygelVisualItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_ITEM_URI_TEST (rygel_http_item_uri_test_get_type ())
#define RYGEL_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITest))
#define RYGEL_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))
#define RYGEL_IS_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_IS_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_HTTP_ITEM_URI_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))

typedef struct _RygelHTTPItemURITest RygelHTTPItemURITest;
typedef struct _RygelHTTPItemURITestClass RygelHTTPItemURITestClass;
typedef struct _RygelHTTPItemURITestPrivate RygelHTTPItemURITestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
};

struct _RygelTranscoderPrivate {
	gchar* _extension;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	GeeArrayList* uris;
	gchar* mime_type;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelVisualItem {
	RygelMediaItem parent_instance;
	RygelVisualItemPrivate * priv;
	GeeArrayList* thumbnails;
};

struct _RygelVisualItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelVideoItem {
	RygelVisualItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelVisualItemClass parent_class;
};

struct _RygelMusicItem {
	RygelMediaItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelHTTPItemURITest {
	GObject parent_instance;
	RygelHTTPItemURITestPrivate * priv;
};

struct _RygelHTTPItemURITestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURITestPrivate {
	RygelVisualItem* item;
	RygelHTTPServer* server;
};


static gpointer rygel_transcoder_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_visual_item_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_http_item_uri_test_parent_class = NULL;

GQuark rygel_http_request_error_quark (void);
GQuark rygel_test_error_quark (void);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_EXTENSION
};
RygelTranscoder* rygel_transcoder_new (const gchar* extension);
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension);
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/Test"
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value);
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_object_finalize (GObject* obj);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VISUAL_ITEM_DUMMY_PROPERTY
};
RygelVisualItem* rygel_visual_item_new (void);
RygelVisualItem* rygel_visual_item_construct (GType object_type);
static void rygel_visual_item_finalize (GObject* obj);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
static void rygel_video_item_finalize (GObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (GObject* obj);
GType rygel_http_item_uri_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET "MP3"
gint rygel_http_item_uri_test_main (gchar** args, int args_length1);
static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error);
static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error);
void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self);
static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error);
static void rygel_http_item_uri_test_test_error_construction (RygelHTTPItemURITest* self, const gchar* str, SoupKnownStatusCode error_code);
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_item_uri_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = extension;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_transcoder_set_extension (self, _tmp0_);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 443 "rygel-http-item-uri-test.c"
}


RygelTranscoder* rygel_transcoder_new (const gchar* extension) {
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER, extension);
#line 450 "rygel-http-item-uri-test.c"
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->_extension;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 465 "rygel-http-item-uri-test.c"
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = value;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_extension);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->_extension = _tmp1_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_notify ((GObject *) self, "extension");
#line 484 "rygel-http-item-uri-test.c"
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 501 "rygel-http-item-uri-test.c"
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
#line 508 "rygel-http-item-uri-test.c"
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_extension);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
#line 520 "rygel-http-item-uri-test.c"
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_value_set_string (value, rygel_transcoder_get_extension (self));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 547 "rygel-http-item-uri-test.c"
		default:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 553 "rygel-http-item-uri-test.c"
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_transcoder_set_extension (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 569 "rygel-http-item-uri-test.c"
		default:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 575 "rygel-http-item-uri-test.c"
	}
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GUPnPContext* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	GError * _inner_error_ = NULL;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_server_set_path_root (self, RYGEL_HTTP_SERVER_SERVER_PATH);
#line 594 "rygel-http-item-uri-test.c"
	{
		GUPnPContext* _tmp0_ = NULL;
		GUPnPContext* _tmp1_ = NULL;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = _tmp1_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 604 "rygel-http-item-uri-test.c"
			goto __catch0_g_error;
		}
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (self->context);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		self->context = _tmp0_;
#line 611 "rygel-http-item-uri-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = _tmp2_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 628 "rygel-http-item-uri-test.c"
		goto __finally0;
	}
	__finally0:
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_propagate_error (error, _inner_error_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (self);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 642 "rygel-http-item-uri-test.c"
		} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 650 "rygel-http-item-uri-test.c"
		}
	}
#line 60 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = self->context;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (_tmp3_ != NULL, "this.context != null");
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = self->context;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp6_ = _tmp5_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (_tmp6_ != NULL, "this.context.host_ip != null");
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp7_ = self->context;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp9_ = _tmp8_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (_tmp9_ > ((guint) 0), "this.context.port > 0");
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 675 "rygel-http-item-uri-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 682 "rygel-http-item-uri-test.c"
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = target;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (g_strcmp0 (_tmp0_, "MP3") == 0) {
#line 700 "rygel-http-item-uri-test.c"
		RygelTranscoder* _tmp1_ = NULL;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = rygel_transcoder_new ("mp3");
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = _tmp1_;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 708 "rygel-http-item-uri-test.c"
	}
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = target;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No transcoder available for target format '%s'", _tmp2_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_inner_error_ = _tmp3_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_propagate_error (error, _inner_error_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return NULL;
#line 720 "rygel-http-item-uri-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->_path_root;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 735 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_path_root);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->_path_root = _tmp1_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_notify ((GObject *) self, "path-root");
#line 754 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 771 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
#line 778 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_path_root);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->context);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 792 "rygel-http-item-uri-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 819 "rygel-http-item-uri-test.c"
		default:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 825 "rygel-http-item-uri-test.c"
	}
}


static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_http_server_set_path_root (self, g_value_get_string (value));
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 841 "rygel-http-item-uri-test.c"
		default:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 847 "rygel-http-item-uri-test.c"
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 858 "rygel-http-item-uri-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 865 "rygel-http-item-uri-test.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 874 "rygel-http-item-uri-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->id);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
#line 890 "rygel-http-item-uri-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 912 "rygel-http-item-uri-test.c"
}


RygelMediaItem* rygel_media_item_new (void) {
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 919 "rygel-http-item-uri-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 928 "rygel-http-item-uri-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->uris = _tmp0_;
#line 938 "rygel-http-item-uri-test.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->uris);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->mime_type);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 952 "rygel-http-item-uri-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelThumbnail*) g_type_create_instance (object_type);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 974 "rygel-http-item-uri-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 981 "rygel-http-item-uri-test.c"
}


static void rygel_value_thumbnail_init (GValue* value) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	value->data[0].v_pointer = NULL;
#line 988 "rygel-http-item-uri-test.c"
}


static void rygel_value_thumbnail_free_value (GValue* value) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (value->data[0].v_pointer) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_unref (value->data[0].v_pointer);
#line 997 "rygel-http-item-uri-test.c"
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (src_value->data[0].v_pointer) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
#line 1007 "rygel-http-item-uri-test.c"
	} else {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1011 "rygel-http-item-uri-test.c"
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return value->data[0].v_pointer;
#line 1019 "rygel-http-item-uri-test.c"
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (collect_values[0].v_pointer) {
#line 1026 "rygel-http-item-uri-test.c"
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1033 "rygel-http-item-uri-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1037 "rygel-http-item-uri-test.c"
		}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
#line 1041 "rygel-http-item-uri-test.c"
	} else {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = NULL;
#line 1045 "rygel-http-item-uri-test.c"
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return NULL;
#line 1049 "rygel-http-item-uri-test.c"
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (!object_p) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1060 "rygel-http-item-uri-test.c"
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (!value->data[0].v_pointer) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		*object_p = NULL;
#line 1066 "rygel-http-item-uri-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1070 "rygel-http-item-uri-test.c"
	} else {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
#line 1074 "rygel-http-item-uri-test.c"
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return NULL;
#line 1078 "rygel-http-item-uri-test.c"
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return G_PARAM_SPEC (spec);
#line 1092 "rygel-http-item-uri-test.c"
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return value->data[0].v_pointer;
#line 1101 "rygel-http-item-uri-test.c"
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	old = value->data[0].v_pointer;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (v_object) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = v_object;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_ref (value->data[0].v_pointer);
#line 1121 "rygel-http-item-uri-test.c"
	} else {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = NULL;
#line 1125 "rygel-http-item-uri-test.c"
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (old) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_unref (old);
#line 1131 "rygel-http-item-uri-test.c"
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	old = value->data[0].v_pointer;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (v_object) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = v_object;
#line 1150 "rygel-http-item-uri-test.c"
	} else {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		value->data[0].v_pointer = NULL;
#line 1154 "rygel-http-item-uri-test.c"
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (old) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_thumbnail_unref (old);
#line 1160 "rygel-http-item-uri-test.c"
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 1170 "rygel-http-item-uri-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->ref_count = 1;
#line 1177 "rygel-http-item-uri-test.c"
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->file_extension);
#line 1187 "rygel-http-item-uri-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return instance;
#line 1212 "rygel-http-item-uri-test.c"
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1225 "rygel-http-item-uri-test.c"
	}
}


RygelVisualItem* rygel_visual_item_construct (GType object_type) {
	RygelVisualItem * self = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelVisualItem*) rygel_media_item_construct (object_type);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1236 "rygel-http-item-uri-test.c"
}


RygelVisualItem* rygel_visual_item_new (void) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_visual_item_construct (RYGEL_TYPE_VISUAL_ITEM);
#line 1243 "rygel-http-item-uri-test.c"
}


static void rygel_visual_item_class_init (RygelVisualItemClass * klass) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_visual_item_parent_class = g_type_class_peek_parent (klass);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_visual_item_finalize;
#line 1252 "rygel-http-item-uri-test.c"
}


static void rygel_visual_item_instance_init (RygelVisualItem * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL, NULL, NULL);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->thumbnails = _tmp0_;
#line 1262 "rygel-http-item-uri-test.c"
}


static void rygel_visual_item_finalize (GObject* obj) {
	RygelVisualItem * self;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->thumbnails);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_visual_item_parent_class)->finalize (obj);
#line 1274 "rygel-http-item-uri-test.c"
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_visual_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVisualItem), 0, (GInstanceInitFunc) rygel_visual_item_instance_init, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelVisualItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1296 "rygel-http-item-uri-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 1303 "rygel-http-item-uri-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 1312 "rygel-http-item-uri-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->caption_type);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
#line 1328 "rygel-http-item-uri-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem * self = NULL;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelVideoItem*) rygel_visual_item_construct (object_type);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1350 "rygel-http-item-uri-test.c"
}


RygelVideoItem* rygel_video_item_new (void) {
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
#line 1357 "rygel-http-item-uri-test.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 1366 "rygel-http-item-uri-test.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->subtitles = _tmp0_;
#line 1376 "rygel-http-item-uri-test.c"
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->subtitles);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 1388 "rygel-http-item-uri-test.c"
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_VISUAL_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem * self = NULL;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelMusicItem*) rygel_media_item_construct (object_type);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1410 "rygel-http-item-uri-test.c"
}


RygelMusicItem* rygel_music_item_new (void) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
#line 1417 "rygel-http-item-uri-test.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 1426 "rygel-http-item-uri-test.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_rygel_thumbnail_unref0 (self->album_art);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 1442 "rygel-http-item-uri-test.c"
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


gint rygel_http_item_uri_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPItemURITest* test = NULL;
		RygelHTTPItemURITest* _tmp0_ = NULL;
		RygelHTTPItemURITest* _tmp1_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = rygel_http_item_uri_test_new (&_inner_error_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		test = _tmp0_;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1473 "rygel-http-item-uri-test.c"
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = test;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_http_item_uri_test_run (_tmp1_, &_inner_error_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (test);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1488 "rygel-http-item-uri-test.c"
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (test);
#line 1495 "rygel-http-item-uri-test.c"
	}
	goto __finally1;
	__catch1_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = 77;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 1511 "rygel-http-item-uri-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = _error_;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp3_ = _tmp2_->message;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("rygel-http-item-uri-test.vala:119: %s", _tmp3_);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = -1;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 1535 "rygel-http-item-uri-test.c"
	}
	__finally1:
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_clear_error (&_inner_error_);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return 0;
#line 1546 "rygel-http-item-uri-test.c"
	}
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = 0;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1552 "rygel-http-item-uri-test.c"
}


int main (int argc, char ** argv) {
#line 111 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_init ();
#line 111 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_main (argv, argc);
#line 1561 "rygel-http-item-uri-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1568 "rygel-http-item-uri-test.c"
}


void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error) {
	RygelThumbnail* thumb = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelVisualItem* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	RygelThumbnail* _tmp5_ = NULL;
	RygelVisualItem* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	RygelVisualItem* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	RygelVisualItem* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	RygelHTTPItemURI** uris = NULL;
	RygelHTTPItemURI* _tmp12_ = NULL;
	RygelHTTPItemURI* _tmp13_ = NULL;
	RygelHTTPItemURI* _tmp14_ = NULL;
	RygelHTTPItemURI* _tmp15_ = NULL;
	RygelHTTPItemURI** _tmp16_ = NULL;
	gint uris_length1 = 0;
	gint _uris_size_ = 0;
	RygelHTTPItemURI** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GError * _inner_error_ = NULL;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_thumbnail_new ();
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	thumb = _tmp0_;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = thumb;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = g_strdup ("png");
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (_tmp1_->file_extension);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_->file_extension = _tmp2_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = self->priv->item;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = _tmp3_->thumbnails;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = thumb;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp6_ = self->priv->item;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp7_ = g_strdup ("HELLO");
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (((RygelMediaObject*) _tmp6_)->id);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	((RygelMediaObject*) _tmp6_)->id = _tmp7_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp8_ = self->priv->item;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp9_ = ((RygelMediaItem*) _tmp8_)->uris;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "foo.mp3");
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp10_ = self->priv->item;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp11_ = g_strdup ("audio/mp3");
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (((RygelMediaItem*) _tmp10_)->mime_type);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	((RygelMediaItem*) _tmp10_)->mime_type = _tmp11_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp12_ = rygel_http_item_uri_test_test_construction (self);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp13_ = rygel_http_item_uri_test_test_construction_with_thumbnail (self);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp14_ = rygel_http_item_uri_test_test_construction_with_subtitle (self);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp15_ = rygel_http_item_uri_test_test_construction_with_transcoder (self);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_ = g_new0 (RygelHTTPItemURI*, 4 + 1);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[0] = _tmp12_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[1] = _tmp13_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[2] = _tmp14_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp16_[3] = _tmp15_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris = _tmp16_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris_length1 = 4;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_uris_size_ = uris_length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp17_ = uris;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp17__length1 = uris_length1;
#line 1669 "rygel-http-item-uri-test.c"
	{
		RygelHTTPItemURI** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri_collection = _tmp17_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri_collection_length1 = _tmp17__length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		for (uri_it = 0; uri_it < _tmp17__length1; uri_it = uri_it + 1) {
#line 1681 "rygel-http-item-uri-test.c"
			RygelHTTPItemURI* _tmp18_ = NULL;
			RygelHTTPItemURI* uri = NULL;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_tmp18_ = _g_object_ref0 (uri_collection[uri_it]);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			uri = _tmp18_;
#line 1688 "rygel-http-item-uri-test.c"
			{
				gchar* str = NULL;
				RygelHTTPItemURI* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				RygelHTTPItemURI* _tmp22_ = NULL;
				RygelHTTPItemURI* _tmp23_ = NULL;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp19_ = uri;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp20_ = rygel_http_item_uri_test_test_to_string (self, _tmp19_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				str = _tmp20_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp21_ = str;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp22_ = rygel_http_item_uri_test_test_construction_from_string (self, _tmp21_, &_inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp23_ = _tmp22_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_object_unref0 (_tmp23_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				if (_inner_error_ != NULL) {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					g_propagate_error (error, _inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_g_free0 (str);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_g_object_unref0 (uri);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_rygel_thumbnail_unref0 (thumb);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					return;
#line 1724 "rygel-http-item-uri-test.c"
				}
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_free0 (str);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_object_unref0 (uri);
#line 1730 "rygel-http-item-uri-test.c"
			}
		}
	}
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_item_uri_test_test_error_construction (self, "/Ttt", SOUP_STATUS_BAD_REQUEST);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_rygel_thumbnail_unref0 (thumb);
#line 1740 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error) {
	RygelHTTPItemURITest * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelHTTPItemURITest*) g_object_new (object_type, NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_server_new (&_inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = _tmp1_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_propagate_error (error, _inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (self);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 1765 "rygel-http-item-uri-test.c"
		} else {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 1773 "rygel-http-item-uri-test.c"
		}
	}
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->server);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->server = _tmp0_;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 1782 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_construct (RYGEL_TYPE_HTTP_ITEM_URI_TEST, error);
#line 1789 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, -1, -1, NULL, NULL);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (uri != NULL, "uri != null");
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1815 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
#line 160 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, -1, RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX, NULL, NULL);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (uri != NULL, "uri != null");
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1841 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, NULL, NULL);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (uri != NULL, "uri != null");
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1867 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	RygelVisualItem* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->item;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new ((RygelMediaObject*) _tmp0_, _tmp1_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET, NULL);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (uri != NULL, "uri != null");
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1893 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPItemURI* uri = NULL;
	const gchar* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = str;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new_from_string (_tmp0_, _tmp1_, &_inner_error_);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return NULL;
#line 1925 "rygel-http-item-uri-test.c"
	}
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (uri != NULL, "uri != null");
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = rygel_http_item_uri_to_string (uri);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = _tmp3_;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = str;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (g_strcmp0 (_tmp4_, _tmp5_) == 0, "uri.to_string () == str");
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (_tmp4_);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 1943 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_test_error_construction (RygelHTTPItemURITest* self, const gchar* str, SoupKnownStatusCode error_code) {
	GError * _inner_error_ = NULL;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (str != NULL);
#line 1953 "rygel-http-item-uri-test.c"
	{
		RygelHTTPItemURI* uri = NULL;
		const gchar* _tmp0_ = NULL;
		RygelHTTPServer* _tmp1_ = NULL;
		RygelHTTPItemURI* _tmp2_ = NULL;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = str;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = self->priv->server;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = rygel_http_item_uri_new_from_string (_tmp0_, _tmp1_, &_inner_error_);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri = _tmp2_;
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 1971 "rygel-http-item-uri-test.c"
				goto __catch2_rygel_http_request_error;
			}
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 202 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return;
#line 1980 "rygel-http-item-uri-test.c"
		}
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_vala_assert (uri == NULL, "uri == null");
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (uri);
#line 1986 "rygel-http-item-uri-test.c"
	}
	goto __finally2;
	__catch2_rygel_http_request_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		SoupKnownStatusCode _tmp5_ = 0;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp3_ = _error_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp4_ = _tmp3_->code;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp5_ = error_code;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_vala_assert (_tmp4_ == ((gint) _tmp5_), "error.code == error_code");
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 2009 "rygel-http-item-uri-test.c"
	}
	__finally2:
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return;
#line 2020 "rygel-http-item-uri-test.c"
	}
}


static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri) {
	gchar* result = NULL;
	gchar* str = NULL;
	RygelHTTPItemURI* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = uri;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_to_string (_tmp0_);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	str = _tmp1_;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_vala_assert (str != NULL, "str != null");
#line 213 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = str;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 2046 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_class_init (RygelHTTPItemURITestClass * klass) {
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_item_uri_test_parent_class = g_type_class_peek_parent (klass);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURITestPrivate));
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_test_finalize;
#line 2057 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_instance_init (RygelHTTPItemURITest * self) {
	RygelVisualItem* _tmp0_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE (self);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_visual_item_new ();
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->item = _tmp0_;
#line 2069 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_finalize (GObject* obj) {
	RygelHTTPItemURITest * self;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITest);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->item);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->server);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_test_parent_class)->finalize (obj);
#line 2083 "rygel-http-item-uri-test.c"
}


GType rygel_http_item_uri_test_get_type (void) {
	static volatile gsize rygel_http_item_uri_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURITestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURITest), 0, (GInstanceInitFunc) rygel_http_item_uri_test_instance_init, NULL };
		GType rygel_http_item_uri_test_type_id;
		rygel_http_item_uri_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURITest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_test_type_id__volatile, rygel_http_item_uri_test_type_id);
	}
	return rygel_http_item_uri_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



