/* rygel-http-get-test.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-get-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelParamSpecClientHacks RygelParamSpecClientHacks;

#define RYGEL_TYPE_TEST_REQUEST_FACTORY (rygel_test_request_factory_get_type ())
#define RYGEL_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactory))
#define RYGEL_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))
#define RYGEL_IS_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_IS_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_TEST_REQUEST_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))

typedef struct _RygelTestRequestFactory RygelTestRequestFactory;
typedef struct _RygelTestRequestFactoryClass RygelTestRequestFactoryClass;
typedef struct _RygelTestRequestFactoryPrivate RygelTestRequestFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_http_get_handler_unref0(var) ((var == NULL) ? NULL : (var = (rygel_http_get_handler_unref (var), NULL)))
typedef struct _RygelParamSpecTestRequestFactory RygelParamSpecTestRequestFactory;

#define RYGEL_TYPE_HTTP_GET_TEST (rygel_http_get_test_get_type ())
#define RYGEL_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest))
#define RYGEL_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))
#define RYGEL_IS_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_IS_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_HTTP_GET_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))

typedef struct _RygelHTTPGetTest RygelHTTPGetTest;
typedef struct _RygelHTTPGetTestClass RygelHTTPGetTestClass;
typedef struct _RygelHTTPGetTestPrivate RygelHTTPGetTestPrivate;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_test_request_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_test_request_factory_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _RygelHttpGetTestHandleClientMessageData RygelHttpGetTestHandleClientMessageData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelParamSpecHTTPGetHandler RygelParamSpecHTTPGetHandler;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;

#define RYGEL_TYPE_HTTP_PLAYLIST_HANDLER (rygel_http_playlist_handler_get_type ())
#define RYGEL_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler))
#define RYGEL_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))

typedef struct _RygelHTTPPlaylistHandler RygelHTTPPlaylistHandler;
typedef struct _RygelHTTPPlaylistHandlerClass RygelHTTPPlaylistHandlerClass;
typedef struct _RygelHTTPPlaylistHandlerPrivate RygelHTTPPlaylistHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelClientHacks {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GTypeClass parent_class;
	void (*finalize) (RygelClientHacks *self);
};

struct _RygelParamSpecClientHacks {
	GParamSpec parent_instance;
};

struct _RygelTestRequestFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTestRequestFactoryPrivate * priv;
	SoupMessage* msg;
	SoupKnownStatusCode expected_code;
};

struct _RygelTestRequestFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTestRequestFactory *self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelParamSpecTestRequestFactory {
	GParamSpec parent_instance;
};

struct _RygelHTTPGetTest {
	GObject parent_instance;
	RygelHTTPGetTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPGetTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPGetTest* self, GError** error);
};

struct _RygelHTTPGetTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
	GeeArrayList* requests;
	RygelTestRequestFactory* current_request;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHttpGetTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGetTest* self;
	SoupMessage* msg;
	RygelHTTPGet* request;
	SoupMessage* _tmp0_;
	RygelHTTPGet* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* _tmp3_;
	RygelMediaObject* _tmp4_;
	SoupMessage* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	SoupMessage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	RygelTestRequestFactory* _tmp11_;
	SoupKnownStatusCode _tmp12_;
	gboolean _tmp13_;
	GMainLoop* _tmp14_;
	GError* _error_;
	GError* _tmp15_;
	GError* _tmp16_;
	GMainLoop* _tmp17_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	GUPnPContext* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelVideoItem* _tmp2_;
	const gchar* _tmp3_;
	RygelAudioItem* _tmp4_;
};

struct _RygelHTTPGetHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelHTTPGetHandler *self);
};

struct _RygelParamSpecHTTPGetHandler {
	GParamSpec parent_instance;
};

struct _RygelHTTPTranscodeHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPPlaylistHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPPlaylistHandlerPrivate * priv;
};

struct _RygelHTTPPlaylistHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* ts;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block3Data* _data3_;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
};

struct _RygelTranscoderPrivate {
	gchar* _extension;
};


static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_test_request_factory_parent_class = NULL;
static gpointer rygel_http_get_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_http_playlist_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_transcoder_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_client_hacks_error_quark (void);
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaObject* item);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
static void rygel_client_hacks_finalize (RygelClientHacks* obj);
gpointer rygel_test_request_factory_ref (gpointer instance);
void rygel_test_request_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_test_request_factory (GValue* value, gpointer v_object);
void rygel_value_take_test_request_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_test_request_factory (const GValue* value);
GType rygel_test_request_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TEST_REQUEST_FACTORY_DUMMY_PROPERTY
};
RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupKnownStatusCode expected_code);
RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupKnownStatusCode expected_code);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj);
GType rygel_http_get_test_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestPrivate))
enum  {
	RYGEL_HTTP_GET_TEST_DUMMY_PROPERTY
};
gint rygel_http_get_test_main (gchar** args, int args_length1);
RygelHTTPGetTest* rygel_http_get_test_new (GError** error);
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error);
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self);
gboolean rygel_visual_item_streamable (RygelVisualItem* self);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context);
static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self);
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error);
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self);
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client);
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self);
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id);
static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_);
static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
RygelTranscoder* rygel_transcoder_new (const gchar* extension);
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda5_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean __lambda2_ (Block2Data* _data2_);
static gboolean ___lambda2__gsource_func (gpointer self);
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_playlist_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_PLAYLIST_HANDLER_DUMMY_PROPERTY
};
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* arg, GCancellable* cancellable);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* arg, GCancellable* cancellable);
gboolean rygel_http_playlist_handler_is_supported (const gchar* arg);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
static void rygel_audio_item_finalize (RygelMediaObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_video_item_finalize (RygelMediaObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (RygelSubtitle* obj);
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean __lambda3_ (Block3Data* _data3_);
static gboolean ___lambda3__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_EXTENSION
};
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_client_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_client_hacks_error-quark");
}


static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return g_boxed_copy (soup_message_headers_get_type (), self);
#line 1066 "rygel-http-get-test.c"
}


static gpointer __vala_SoupMessageHeaders_copy0 (gpointer self) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
#line 1073 "rygel-http-get-test.c"
}


static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self) {
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_boxed_free (soup_message_headers_get_type (), self);
#line 1080 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error) {
	RygelClientHacks* result = NULL;
	SoupMessageHeaders* headers = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	SoupMessageHeaders* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = message;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = __vala_SoupMessageHeaders_copy0 (_tmp1_);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	headers = _tmp2_;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = headers;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = soup_message_headers_get_one (_tmp3_, "clienthacks.test.rygel");
#line 39 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp4_ != NULL) {
#line 1107 "rygel-http-get-test.c"
		RygelClientHacks* _tmp5_ = NULL;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = rygel_client_hacks_new ();
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp5_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1117 "rygel-http-get-test.c"
	} else {
		GError* _tmp6_ = NULL;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp6_ = g_error_new_literal (RYGEL_CLIENT_HACKS_ERROR, RYGEL_CLIENT_HACKS_ERROR_NA, "");
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp6_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 1130 "rygel-http-get-test.c"
	}
#line 37 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	__vala_SoupMessageHeaders_free0 (headers);
#line 1134 "rygel-http-get-test.c"
}


void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaObject* item) {
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 1141 "rygel-http-get-test.c"
}


gboolean rygel_client_hacks_force_seek (RygelClientHacks* self) {
	gboolean result = FALSE;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1153 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks* self = NULL;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelClientHacks*) g_type_create_instance (object_type);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1163 "rygel-http-get-test.c"
}


RygelClientHacks* rygel_client_hacks_new (void) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
#line 1170 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_init (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 1177 "rygel-http-get-test.c"
}


static void rygel_value_client_hacks_free_value (GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (value->data[0].v_pointer);
#line 1186 "rygel-http-get-test.c"
	}
}


static void rygel_value_client_hacks_copy_value (const GValue* src_value, GValue* dest_value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_client_hacks_ref (src_value->data[0].v_pointer);
#line 1196 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1200 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_client_hacks_peek_pointer (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1208 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 1215 "rygel-http-get-test.c"
		RygelClientHacks* object;
		object = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1222 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1226 "rygel-http-get-test.c"
		}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_client_hacks_ref (object);
#line 1230 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1234 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1238 "rygel-http-get-test.c"
}


static gchar* rygel_value_client_hacks_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelClientHacks** object_p;
	object_p = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1249 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 1255 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1259 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1263 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1267 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecClientHacks* spec;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 1281 "rygel-http-get-test.c"
}


gpointer rygel_value_get_client_hacks (const GValue* value) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS), NULL);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1290 "rygel-http-get-test.c"
}


void rygel_value_set_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_ref (value->data[0].v_pointer);
#line 1310 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1314 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1320 "rygel-http-get-test.c"
	}
}


void rygel_value_take_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 1339 "rygel-http-get-test.c"
	} else {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1343 "rygel-http-get-test.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_client_hacks_unref (old);
#line 1349 "rygel-http-get-test.c"
	}
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_CLIENT_HACKS_CLASS (klass)->finalize = rygel_client_hacks_finalize;
#line 1359 "rygel-http-get-test.c"
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 1366 "rygel-http-get-test.c"
}


static void rygel_client_hacks_finalize (RygelClientHacks* obj) {
	RygelClientHacks * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks);
#line 1374 "rygel-http-get-test.c"
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_client_hacks_init, rygel_value_client_hacks_free_value, rygel_value_client_hacks_copy_value, rygel_value_client_hacks_peek_pointer, "p", rygel_value_client_hacks_collect_value, "p", rygel_value_client_hacks_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelClientHacks", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


gpointer rygel_client_hacks_ref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 1399 "rygel-http-get-test.c"
}


void rygel_client_hacks_unref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_CLIENT_HACKS_GET_CLASS (self)->finalize (self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1412 "rygel-http-get-test.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1420 "rygel-http-get-test.c"
}


RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupKnownStatusCode expected_code) {
	RygelTestRequestFactory* self = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupKnownStatusCode _tmp2_ = 0;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelTestRequestFactory*) g_type_create_instance (object_type);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = msg;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->msg = _tmp1_;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = expected_code;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->expected_code = _tmp2_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1447 "rygel-http-get-test.c"
}


RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupKnownStatusCode expected_code) {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_test_request_factory_construct (RYGEL_TYPE_TEST_REQUEST_FACTORY, msg, expected_code);
#line 1454 "rygel-http-get-test.c"
}


RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet* result = NULL;
	RygelHTTPGet* request = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	RygelHTTPGet* _tmp3_ = NULL;
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = http_server;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = server;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = msg;
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = rygel_http_get_new (_tmp0_, _tmp1_, _tmp2_);
#line 67 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp3_;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_http_get_handler_unref0 (request->handler);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request->handler = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = request;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1491 "rygel-http-get-test.c"
}


static void rygel_value_test_request_factory_init (GValue* value) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 1498 "rygel-http-get-test.c"
}


static void rygel_value_test_request_factory_free_value (GValue* value) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (value->data[0].v_pointer);
#line 1507 "rygel-http-get-test.c"
	}
}


static void rygel_value_test_request_factory_copy_value (const GValue* src_value, GValue* dest_value) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_test_request_factory_ref (src_value->data[0].v_pointer);
#line 1517 "rygel-http-get-test.c"
	} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1521 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_test_request_factory_peek_pointer (const GValue* value) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1529 "rygel-http-get-test.c"
}


static gchar* rygel_value_test_request_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 1536 "rygel-http-get-test.c"
		RygelTestRequestFactory* object;
		object = collect_values[0].v_pointer;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1543 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1547 "rygel-http-get-test.c"
		}
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_test_request_factory_ref (object);
#line 1551 "rygel-http-get-test.c"
	} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1555 "rygel-http-get-test.c"
	}
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1559 "rygel-http-get-test.c"
}


static gchar* rygel_value_test_request_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTestRequestFactory** object_p;
	object_p = collect_values[0].v_pointer;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1570 "rygel-http-get-test.c"
	}
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 1576 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 1580 "rygel-http-get-test.c"
	} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_test_request_factory_ref (value->data[0].v_pointer);
#line 1584 "rygel-http-get-test.c"
	}
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 1588 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTestRequestFactory* spec;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 1602 "rygel-http-get-test.c"
}


gpointer rygel_value_get_test_request_factory (const GValue* value) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 1611 "rygel-http-get-test.c"
}


void rygel_value_set_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_ref (value->data[0].v_pointer);
#line 1631 "rygel-http-get-test.c"
	} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1635 "rygel-http-get-test.c"
	}
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (old);
#line 1641 "rygel-http-get-test.c"
	}
}


void rygel_value_take_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 1660 "rygel-http-get-test.c"
	} else {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 1664 "rygel-http-get-test.c"
	}
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_test_request_factory_unref (old);
#line 1670 "rygel-http-get-test.c"
	}
}


static void rygel_test_request_factory_class_init (RygelTestRequestFactoryClass * klass) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_test_request_factory_parent_class = g_type_class_peek_parent (klass);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_TEST_REQUEST_FACTORY_CLASS (klass)->finalize = rygel_test_request_factory_finalize;
#line 1680 "rygel-http-get-test.c"
}


static void rygel_test_request_factory_instance_init (RygelTestRequestFactory * self) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 1687 "rygel-http-get-test.c"
}


static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj) {
	RygelTestRequestFactory * self;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactory);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 1697 "rygel-http-get-test.c"
}


GType rygel_test_request_factory_get_type (void) {
	static volatile gsize rygel_test_request_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_test_request_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_test_request_factory_init, rygel_value_test_request_factory_free_value, rygel_value_test_request_factory_copy_value, rygel_value_test_request_factory_peek_pointer, "p", rygel_value_test_request_factory_collect_value, "p", rygel_value_test_request_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestRequestFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_request_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestRequestFactory), 0, (GInstanceInitFunc) rygel_test_request_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_test_request_factory_type_id;
		rygel_test_request_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTestRequestFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_test_request_factory_type_id__volatile, rygel_test_request_factory_type_id);
	}
	return rygel_test_request_factory_type_id__volatile;
}


gpointer rygel_test_request_factory_ref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 1722 "rygel-http-get-test.c"
}


void rygel_test_request_factory_unref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_TEST_REQUEST_FACTORY_GET_CLASS (self)->finalize (self);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1735 "rygel-http-get-test.c"
	}
}


gint rygel_http_get_test_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp6_ = NULL;
	RygelVideoItem* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	RygelVideoItem* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPGetTest* test = NULL;
		RygelHTTPGetTest* _tmp0_ = NULL;
		RygelHTTPGetTest* _tmp1_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = rygel_http_get_test_new (&_inner_error_);
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		test = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 90 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1761 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = test;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_test_run (_tmp1_, &_inner_error_);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (test);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 1776 "rygel-http-get-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (test);
#line 1783 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = _error_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp3_ = _tmp2_->code;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp3_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1805 "rygel-http-get-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = _error_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = _tmp4_->message;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("rygel-http-get-test.vala:96: %s", _tmp5_);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = -1;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 1829 "rygel-http-get-test.c"
	}
	__finally0:
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return 0;
#line 1840 "rygel-http-get-test.c"
	}
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = rygel_video_item_new ();
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item = _tmp6_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = item;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = rygel_visual_item_is_live_stream ((RygelVisualItem*) _tmp7_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (!_tmp8_, "!item.is_live_stream()");
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = item;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = rygel_visual_item_streamable ((RygelVisualItem*) _tmp9_);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (!_tmp10_, "!item.streamable()");
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = 0;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (item);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1864 "rygel-http-get-test.c"
}


int main (int argc, char ** argv) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_init ();
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_main (argv, argc);
#line 1873 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error) {
	RygelHTTPGetTest * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	RygelHTTPClient* _tmp4_ = NULL;
	GMainLoop* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetTest*) g_object_new (object_type, NULL);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = rygel_http_server_new (&_inner_error_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _tmp1_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 1900 "rygel-http-get-test.c"
	}
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->server = _tmp0_;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->server;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_->context;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = rygel_http_client_new (_tmp3_);
#line 111 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 111 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->client = _tmp4_;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = g_main_loop_new (NULL, FALSE);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->main_loop = _tmp5_;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_create_test_messages (self);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 1926 "rygel-http-get-test.c"
}


RygelHTTPGetTest* rygel_http_get_test_new (GError** error) {
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_get_test_construct (RYGEL_TYPE_HTTP_GET_TEST, error);
#line 1933 "rygel-http-get-test.c"
}


static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_get_test_on_timeout (self);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 1942 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 118 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_message_received (self, _sender, message);
#line 1949 "rygel-http-get-test.c"
}


static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 119 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_on_client_completed (self, _sender);
#line 1956 "rygel-http-get-test.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? g_error_copy (self) : NULL;
#line 1963 "rygel-http-get-test.c"
}


static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error) {
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPClient* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_get_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 118 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->server;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object (_tmp0_, "message-received", (GCallback) _rygel_http_get_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->client;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp1_, "completed", (GCallback) _rygel_http_get_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_start_next_test_request (self);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->priv->main_loop;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_run (_tmp2_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->error;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp3_ != NULL) {
#line 1993 "rygel-http-get-test.c"
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp4_ = self->priv->error;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp5_;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_propagate_error (error, _inner_error_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return;
#line 2006 "rygel-http-get-test.c"
	}
}


void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error) {
#line 116 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_GET_CLASS (self)->run (self, error);
#line 2016 "rygel-http-get-test.c"
}


static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_ = NULL;
	SoupMessage* request = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessage* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	SoupMessage* _tmp8_ = NULL;
	RygelTestRequestFactory* _tmp9_ = NULL;
	RygelTestRequestFactory* _tmp10_ = NULL;
	RygelHTTPServer* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	SoupMessage* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	SoupMessage* _tmp17_ = NULL;
	RygelTestRequestFactory* _tmp18_ = NULL;
	RygelTestRequestFactory* _tmp19_ = NULL;
	RygelHTTPServer* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	SoupMessage* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	SoupMessage* _tmp26_ = NULL;
	RygelTestRequestFactory* _tmp27_ = NULL;
	RygelTestRequestFactory* _tmp28_ = NULL;
	gchar* uri = NULL;
	RygelHTTPServer* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	SoupMessage* _tmp34_ = NULL;
	GeeArrayList* _tmp35_ = NULL;
	SoupMessage* _tmp36_ = NULL;
	RygelTestRequestFactory* _tmp37_ = NULL;
	RygelTestRequestFactory* _tmp38_ = NULL;
	RygelHTTPServer* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	SoupMessage* _tmp43_ = NULL;
	SoupMessage* _tmp44_ = NULL;
	SoupMessageHeaders* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	SoupMessage* _tmp47_ = NULL;
	RygelTestRequestFactory* _tmp48_ = NULL;
	RygelTestRequestFactory* _tmp49_ = NULL;
	RygelHTTPServer* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	SoupMessage* _tmp54_ = NULL;
	SoupMessage* _tmp55_ = NULL;
	SoupMessageHeaders* _tmp56_ = NULL;
	GeeArrayList* _tmp57_ = NULL;
	SoupMessage* _tmp58_ = NULL;
	RygelTestRequestFactory* _tmp59_ = NULL;
	RygelTestRequestFactory* _tmp60_ = NULL;
	RygelHTTPServer* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	SoupMessage* _tmp65_ = NULL;
	SoupMessage* _tmp66_ = NULL;
	SoupMessageHeaders* _tmp67_ = NULL;
	GeeArrayList* _tmp68_ = NULL;
	SoupMessage* _tmp69_ = NULL;
	RygelTestRequestFactory* _tmp70_ = NULL;
	RygelTestRequestFactory* _tmp71_ = NULL;
	RygelHTTPServer* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	SoupMessage* _tmp77_ = NULL;
	GeeArrayList* _tmp78_ = NULL;
	SoupMessage* _tmp79_ = NULL;
	RygelTestRequestFactory* _tmp80_ = NULL;
	RygelTestRequestFactory* _tmp81_ = NULL;
	RygelHTTPServer* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	SoupMessage* _tmp86_ = NULL;
	SoupMessage* _tmp87_ = NULL;
	SoupMessageHeaders* _tmp88_ = NULL;
	GeeArrayList* _tmp89_ = NULL;
	SoupMessage* _tmp90_ = NULL;
	RygelTestRequestFactory* _tmp91_ = NULL;
	RygelTestRequestFactory* _tmp92_ = NULL;
	RygelHTTPServer* _tmp93_ = NULL;
	gchar* _tmp94_ = NULL;
	const gchar* _tmp95_ = NULL;
	SoupMessage* _tmp96_ = NULL;
	SoupMessage* _tmp97_ = NULL;
	SoupMessageHeaders* _tmp98_ = NULL;
	GeeArrayList* _tmp99_ = NULL;
	SoupMessage* _tmp100_ = NULL;
	RygelTestRequestFactory* _tmp101_ = NULL;
	RygelTestRequestFactory* _tmp102_ = NULL;
	RygelHTTPServer* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	const gchar* _tmp105_ = NULL;
	SoupMessage* _tmp106_ = NULL;
	SoupMessage* _tmp107_ = NULL;
	SoupMessageHeaders* _tmp108_ = NULL;
	GeeArrayList* _tmp109_ = NULL;
	SoupMessage* _tmp110_ = NULL;
	RygelTestRequestFactory* _tmp111_ = NULL;
	RygelTestRequestFactory* _tmp112_ = NULL;
	RygelHTTPServer* _tmp113_ = NULL;
	gchar* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	gchar* _tmp116_ = NULL;
	SoupMessage* _tmp117_ = NULL;
	SoupMessage* _tmp118_ = NULL;
	SoupMessageHeaders* _tmp119_ = NULL;
	GeeArrayList* _tmp120_ = NULL;
	SoupMessage* _tmp121_ = NULL;
	RygelTestRequestFactory* _tmp122_ = NULL;
	RygelTestRequestFactory* _tmp123_ = NULL;
	RygelHTTPServer* _tmp124_ = NULL;
	gchar* _tmp125_ = NULL;
	gchar* _tmp126_ = NULL;
	gchar* _tmp127_ = NULL;
	SoupMessage* _tmp128_ = NULL;
	SoupMessage* _tmp129_ = NULL;
	SoupMessageHeaders* _tmp130_ = NULL;
	GeeArrayList* _tmp131_ = NULL;
	SoupMessage* _tmp132_ = NULL;
	RygelTestRequestFactory* _tmp133_ = NULL;
	RygelTestRequestFactory* _tmp134_ = NULL;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TEST_REQUEST_FACTORY, (GBoxedCopyFunc) rygel_test_request_factory_ref, rygel_test_request_factory_unref, NULL, NULL, NULL);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->requests);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->requests = _tmp0_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->server;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = rygel_http_server_get_uri (_tmp1_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = soup_message_new ("POST", _tmp4_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp4_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp6_;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = self->priv->requests;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = request;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = rygel_test_request_factory_new (_tmp8_, SOUP_STATUS_BAD_REQUEST);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = _tmp9_;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp10_);
#line 134 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp10_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp11_ = self->server;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp12_ = rygel_http_server_get_uri (_tmp11_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp13_ = _tmp12_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp14_ = _tmp13_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp15_ = soup_message_new ("HEAD", _tmp14_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp15_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp14_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp16_ = self->priv->requests;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp17_ = request;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp18_ = rygel_test_request_factory_new (_tmp17_, SOUP_STATUS_OK);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp19_ = _tmp18_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp19_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp20_ = self->server;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp21_ = rygel_http_server_get_uri (_tmp20_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp22_ = _tmp21_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp23_ = _tmp22_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp24_ = soup_message_new ("GET", _tmp23_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp24_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp23_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp25_ = self->priv->requests;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp26_ = request;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp27_ = rygel_test_request_factory_new (_tmp26_, SOUP_STATUS_OK);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp28_ = _tmp27_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp28_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp29_ = self->server;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp30_ = rygel_http_server_create_uri (_tmp29_, "VideoItem");
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp30_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp31_ = uri;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp32_ = g_strconcat (_tmp31_, "/tr/MP3", NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp32_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp33_ = uri;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp34_ = soup_message_new ("HEAD", _tmp33_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp34_;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp35_ = self->priv->requests;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp36_ = request;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp37_ = rygel_test_request_factory_new (_tmp36_, SOUP_STATUS_OK);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp38_ = _tmp37_;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp38_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp38_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp39_ = self->server;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp40_ = rygel_http_server_get_uri (_tmp39_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp41_ = _tmp40_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp42_ = _tmp41_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp43_ = soup_message_new ("GET", _tmp42_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp43_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp42_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp44_ = request;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp45_ = _tmp44_->request_headers;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp45_, "transferMode.dlna.org", "Streaming");
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp46_ = self->priv->requests;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp47_ = request;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp48_ = rygel_test_request_factory_new (_tmp47_, SOUP_STATUS_OK);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp49_ = _tmp48_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp49_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp49_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp50_ = self->server;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp51_ = rygel_http_server_get_uri (_tmp50_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp52_ = _tmp51_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp53_ = _tmp52_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp54_ = soup_message_new ("GET", _tmp53_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp54_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp53_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp55_ = request;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp56_ = _tmp55_->request_headers;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp56_, "transferMode.dlna.org", "Interactive");
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp57_ = self->priv->requests;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp58_ = request;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp59_ = rygel_test_request_factory_new (_tmp58_, SOUP_STATUS_NOT_ACCEPTABLE);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp60_ = _tmp59_;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp60_);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp60_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp61_ = self->server;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp62_ = rygel_http_server_get_uri (_tmp61_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp63_ = _tmp62_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp64_ = _tmp63_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp65_ = soup_message_new ("GET", _tmp64_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp65_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp64_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp66_ = request;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp67_ = _tmp66_->request_headers;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp67_, "Range", "bytes=1-2");
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp68_ = self->priv->requests;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp69_ = request;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp70_ = rygel_test_request_factory_new (_tmp69_, SOUP_STATUS_OK);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp71_ = _tmp70_;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp71_);
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp71_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp72_ = self->server;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp73_ = rygel_http_server_create_uri (_tmp72_, "AudioItem");
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp73_;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp74_ = uri;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp75_ = g_strconcat (_tmp74_, "/th/0", NULL);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp75_;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp76_ = uri;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp77_ = soup_message_new ("GET", _tmp76_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp77_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp78_ = self->priv->requests;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp79_ = request;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp80_ = rygel_test_request_factory_new (_tmp79_, SOUP_STATUS_NOT_FOUND);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp81_ = _tmp80_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp78_, _tmp81_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp81_);
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp82_ = self->server;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp83_ = rygel_http_server_get_uri (_tmp82_);
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp84_ = _tmp83_;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp85_ = _tmp84_;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp86_ = soup_message_new ("GET", _tmp85_);
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp86_;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp85_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp87_ = request;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp88_ = _tmp87_->request_headers;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp88_, "TimeSeekRange.dlna.org", "0");
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp89_ = self->priv->requests;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp90_ = request;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp91_ = rygel_test_request_factory_new (_tmp90_, SOUP_STATUS_NOT_ACCEPTABLE);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp92_ = _tmp91_;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp89_, _tmp92_);
#line 171 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp92_);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp93_ = self->server;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp94_ = rygel_http_server_create_uri (_tmp93_, "AudioItem");
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp94_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp95_ = uri;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp96_ = soup_message_new ("GET", _tmp95_);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp96_;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp97_ = request;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp98_ = _tmp97_->request_headers;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp98_, "TimeSeekRange.dlna.org", "0");
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp99_ = self->priv->requests;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp100_ = request;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp101_ = rygel_test_request_factory_new (_tmp100_, SOUP_STATUS_BAD_REQUEST);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp102_ = _tmp101_;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp99_, _tmp102_);
#line 177 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp102_);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp103_ = self->server;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp104_ = rygel_http_server_create_uri (_tmp103_, "AudioItem");
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 180 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	uri = _tmp104_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp105_ = uri;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp106_ = soup_message_new ("GET", _tmp105_);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp106_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp107_ = request;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp108_ = _tmp107_->request_headers;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp108_, "TimeSeekRange.dlna.org", "npt=1-2049");
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp109_ = self->priv->requests;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp110_ = request;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp111_ = rygel_test_request_factory_new (_tmp110_, SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp112_ = _tmp111_;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp112_);
#line 183 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp112_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp113_ = self->server;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp114_ = rygel_http_server_get_uri (_tmp113_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp115_ = _tmp114_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp116_ = _tmp115_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp117_ = soup_message_new ("GET", _tmp116_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp117_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp116_);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp118_ = request;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp119_ = _tmp118_->request_headers;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp119_, "clienthacks.test.rygel", "f");
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp120_ = self->priv->requests;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp121_ = request;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp122_ = rygel_test_request_factory_new (_tmp121_, SOUP_STATUS_OK);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp123_ = _tmp122_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, _tmp123_);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp123_);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp124_ = self->server;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp125_ = rygel_http_server_get_uri (_tmp124_);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp126_ = _tmp125_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp127_ = _tmp126_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp128_ = soup_message_new ("GET", _tmp127_);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp128_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_tmp127_);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp129_ = request;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp130_ = _tmp129_->request_headers;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_append (_tmp130_, "clienthacks.test.rygel", "t");
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp131_ = self->priv->requests;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp132_ = request;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp133_ = rygel_test_request_factory_new (_tmp132_, SOUP_STATUS_OK);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp134_ = _tmp133_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp131_, _tmp134_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (_tmp134_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (uri);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (request);
#line 2596 "rygel-http-get-test.c"
}


static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPGet* result = NULL;
	RygelHTTPGet* request = NULL;
	RygelTestRequestFactory* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	SoupServer* _tmp4_ = NULL;
	SoupServer* _tmp5_ = NULL;
	SoupMessage* _tmp6_ = NULL;
	RygelHTTPGet* _tmp7_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->current_request;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->server;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->server;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_->context;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = gupnp_context_get_server (_tmp3_);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = _tmp4_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = msg;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = rygel_test_request_factory_create_get (_tmp0_, _tmp1_, _tmp5_, _tmp6_);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	request = _tmp7_;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = request;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2637 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client) {
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->requests;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_tmp2_ > 0) {
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_test_start_next_test_request (self);
#line 2659 "rygel-http-get-test.c"
	} else {
		GMainLoop* _tmp3_ = NULL;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp3_ = self->priv->main_loop;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_tmp3_);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self->priv->client_done = TRUE;
#line 2668 "rygel-http-get-test.c"
	}
}


static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	RygelHTTPClient* _tmp2_ = NULL;
	RygelTestRequestFactory* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	RygelHTTPClient* _tmp6_ = NULL;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->requests;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp0_, 0);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (self->priv->current_request);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->current_request = (RygelTestRequestFactory*) _tmp1_;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = self->client;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->current_request;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_->msg;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_tmp2_->msg);
#line 214 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_->msg = _tmp5_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = self->client;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp6_, NULL, NULL);
#line 2707 "rygel-http-get-test.c"
}


static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	SoupMessage* _tmp0_ = NULL;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = msg;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message (self, _tmp0_, NULL, NULL);
#line 2723 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = _data;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->msg);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpGetTestHandleClientMessageData, _data_);
#line 2736 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	RygelHTTPGetTest* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpGetTestHandleClientMessageData);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_test_handle_client_message);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_test_handle_client_message_data_free);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = msg;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->msg);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->msg = _tmp2_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 2765 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2773 "rygel-http-get-test.c"
}


static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = _user_data_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_source_object_ = source_object;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_res_ = _res_;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_handle_client_message_co (_data_);
#line 2787 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_) {
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 2796 "rygel-http-get-test.c"
		goto _state_0;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 2800 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 2805 "rygel-http-get-test.c"
	}
	_state_0:
	{
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp0_ = NULL;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp0_ = _data_->msg;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = NULL;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp1_ = rygel_http_get_test_create_request (_data_->self, _data_->_tmp0_, &_data_->_inner_error_);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->request = _data_->_tmp1_;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_inner_error_ != NULL) {
#line 2821 "rygel-http-get-test.c"
			goto __catch1_g_error;
		}
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = NULL;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = _data_->request;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_state_ = 1;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp2_, rygel_http_get_test_handle_client_message_ready, _data_);
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2834 "rygel-http-get-test.c"
		_state_1:
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp2_, _data_->_res_);
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = NULL;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = _data_->request;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp4_ = NULL;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_HTTP_GET) ? ((RygelHTTPGet*) _data_->_tmp3_) : NULL))->object;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_vala_assert (_data_->_tmp4_ != NULL, "(request as HTTPGet).object != null");
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp5_ = NULL;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp5_ = _data_->msg;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp6_ = 0U;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_get (_data_->_tmp5_, "status-code", &_data_->_tmp6_, NULL);
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp7_ = 0U;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 231 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_debug ("rygel-http-get-test.vala:231: status.code: %d", (gint) _data_->_tmp7_);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp8_ = NULL;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp8_ = _data_->msg;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp9_ = 0U;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_get (_data_->_tmp8_, "status-code", &_data_->_tmp9_, NULL);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp10_ = 0U;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp11_ = NULL;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp11_ = _data_->self->priv->current_request;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp12_ = 0;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp12_ = _data_->_tmp11_->expected_code;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_vala_assert (_data_->_tmp10_ == ((guint) _data_->_tmp12_), "msg.status_code == this.current_request.expected_code");
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp13_ = FALSE;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp13_ = _data_->self->priv->client_done;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_tmp13_) {
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp14_ = NULL;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp14_ = _data_->self->priv->main_loop;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_main_loop_quit (_data_->_tmp14_);
#line 2896 "rygel-http-get-test.c"
		}
#line 238 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->server_done = TRUE;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (_data_->request);
#line 2902 "rygel-http-get-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_inner_error_ = NULL;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp15_ = NULL;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp15_ = _data_->_error_;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp16_ = NULL;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->self->priv->error);
#line 240 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->self->priv->error = _data_->_tmp16_;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp17_ = NULL;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp17_ = _data_->self->priv->main_loop;
#line 241 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_main_loop_quit (_data_->_tmp17_);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_data_->_error_);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2935 "rygel-http-get-test.c"
		} else {
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2939 "rygel-http-get-test.c"
		}
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 243 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2945 "rygel-http-get-test.c"
	}
	__finally1:
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_inner_error_ != NULL) {
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_clear_error (&_data_->_inner_error_);
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 2956 "rygel-http-get-test.c"
	}
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2962 "rygel-http-get-test.c"
	} else {
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2966 "rygel-http-get-test.c"
	}
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 2972 "rygel-http-get-test.c"
}


static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 248 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
#line 248 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 248 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->error = _tmp0_;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->priv->main_loop;
#line 249 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_main_loop_quit (_tmp1_);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 2996 "rygel-http-get-test.c"
}


static void rygel_http_get_test_class_init (RygelHTTPGetTestClass * klass) {
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_test_parent_class = g_type_class_peek_parent (klass);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPGetTestPrivate));
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_TEST_CLASS (klass)->run = rygel_http_get_test_real_run;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_test_finalize;
#line 3009 "rygel-http-get-test.c"
}


static void rygel_http_get_test_instance_init (RygelHTTPGetTest * self) {
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_GET_TEST_GET_PRIVATE (self);
#line 3016 "rygel-http-get-test.c"
}


static void rygel_http_get_test_finalize (GObject* obj) {
	RygelHTTPGetTest * self;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->server);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->client);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 83 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_error_free0 (self->priv->error);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->requests);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_test_request_factory_unref0 (self->priv->current_request);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_get_test_parent_class)->finalize (obj);
#line 3038 "rygel-http-get-test.c"
}


GType rygel_http_get_test_get_type (void) {
	static volatile gsize rygel_http_get_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetTest), 0, (GInstanceInitFunc) rygel_http_get_test_instance_init, NULL };
		GType rygel_http_get_test_type_id;
		rygel_http_get_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_test_type_id__volatile, rygel_http_get_test_type_id);
	}
	return rygel_http_get_test_type_id__volatile;
}


gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id) {
	gchar* result = NULL;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelHTTPItemURI* item_uri = NULL;
	RygelHTTPItemURI* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 272 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 272 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 273 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_video_item_new ();
#line 273 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item = _tmp0_;
#line 274 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = item_id;
#line 274 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 274 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) item)->id);
#line 274 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) item)->id = _tmp2_;
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = rygel_http_item_uri_new ((RygelMediaObject*) item, self, -1, -1, NULL, NULL);
#line 276 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	item_uri = _tmp3_;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = rygel_http_item_uri_to_string (item_uri);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp4_;
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (item_uri);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (item);
#line 278 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3093 "rygel-http-get-test.c"
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
#line 3100 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GUPnPContext* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	GUPnPContext* _tmp10_ = NULL;
	SoupServer* _tmp11_ = NULL;
	SoupServer* _tmp12_ = NULL;
	RygelMediaContainer* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 3120 "rygel-http-get-test.c"
	{
		GUPnPContext* _tmp0_ = NULL;
		GUPnPContext* _tmp1_ = NULL;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp0_ = _tmp1_;
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_ != NULL) {
#line 3130 "rygel-http-get-test.c"
			goto __catch2_g_error;
		}
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self->context);
#line 285 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self->context = _tmp0_;
#line 3137 "rygel-http-get-test.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_error_ = _inner_error_;
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = NULL;
#line 287 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 287 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_inner_error_ = _tmp2_;
#line 287 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_error_free0 (_error_);
#line 3154 "rygel-http-get-test.c"
		goto __finally2;
	}
	__finally2:
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_inner_error_ != NULL) {
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_propagate_error (error, _inner_error_);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_g_object_unref0 (self);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 3168 "rygel-http-get-test.c"
		} else {
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_clear_error (&_inner_error_);
#line 284 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return NULL;
#line 3176 "rygel-http-get-test.c"
		}
	}
#line 290 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->context;
#line 290 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (_tmp3_ != NULL, "this.context != null");
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->context;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = _tmp5_;
#line 291 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (_tmp6_ != NULL, "this.context.host_ip != null");
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = self->context;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp9_ = _tmp8_;
#line 292 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_vala_assert (_tmp9_ > ((guint) 0), "this.context.port > 0");
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp10_ = self->context;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp11_ = gupnp_context_get_server (_tmp10_);
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp12_ = _tmp11_;
#line 294 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_add_handler (_tmp12_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp13_ = rygel_media_container_new ();
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 296 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->root_container = _tmp13_;
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3215 "rygel-http-get-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 283 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 3222 "rygel-http-get-test.c"
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	GUPnPContext* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupServer* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (server != NULL);
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (path != NULL);
#line 299 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (client != NULL);
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->context;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = gupnp_context_get_server (_tmp0_);
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _tmp1_;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = msg;
#line 304 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_pause_message (_tmp2_, _tmp3_);
#line 305 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = msg;
#line 305 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name (self, "message-received", _tmp4_);
#line 3256 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 308 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 308 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = target;
#line 309 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_tmp0_, "MP3") == 0) {
#line 3274 "rygel-http-get-test.c"
		RygelTranscoder* _tmp1_ = NULL;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_tmp1_ = rygel_transcoder_new ("mp3");
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = _tmp1_;
#line 310 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 3282 "rygel-http-get-test.c"
	}
#line 312 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = target;
#line 312 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No transcoder available for target format '%s'", _tmp2_);
#line 312 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_inner_error_ = _tmp3_;
#line 312 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_propagate_error (error, _inner_error_);
#line 312 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 3294 "rygel-http-get-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
#line 258 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 259 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3306 "rygel-http-get-test.c"
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
#line 267 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 268 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = rygel_http_server_create_uri (self, "VideoItem");
#line 268 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 268 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3321 "rygel-http-get-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
#line 3338 "rygel-http-get-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 263 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (self->root_container);
#line 264 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 3356 "rygel-http-get-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_SERVER_URI:
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_take_string (value, rygel_http_server_get_uri (self));
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3389 "rygel-http-get-test.c"
		default:
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 255 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3395 "rygel-http-get-test.c"
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 324 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = context;
#line 325 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 325 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->context = _tmp1_;
#line 324 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 3418 "rygel-http-get-test.c"
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context) {
#line 324 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context);
#line 3425 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpClientRunData, _data_);
#line 3436 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_ = NULL;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpClientRunData);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_real_run_co (_data_);
#line 3458 "rygel-http-get-test.c"
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3466 "rygel-http-get-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data1_;
#line 3475 "rygel-http-get-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 3484 "rygel-http-get-test.c"
		RygelHTTPClient * self;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data1_->self;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue = NULL;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target = NULL;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data1_->run_continue_target_destroy_notify = NULL;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 3500 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3510 "rygel-http-get-test.c"
}


static void __lambda5_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient * self;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data1_->self;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (session != NULL);
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (msg != NULL);
#line 332 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 3524 "rygel-http-get-test.c"
}


static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	__lambda5_ (self, session, msg);
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block1_data_unref (self);
#line 3533 "rygel-http-get-test.c"
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 3542 "rygel-http-get-test.c"
		goto _state_0;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 3546 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 3551 "rygel-http-get-test.c"
	}
	_state_0:
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target = _data_;
#line 329 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = NULL;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->context;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = NULL;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = gupnp_context_get_session (_data_->_tmp0_);
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = NULL;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp3_ = NULL;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp3_ = _data_->self->msg;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp4_ = NULL;
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 331 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda5__soup_session_callback, block1_data_ref (_data_->_data1_));
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 335 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3594 "rygel-http-get-test.c"
	_state_1:
	;
#line 337 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block1_data_unref (_data_->_data1_);
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data1_ = NULL;
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3607 "rygel-http-get-test.c"
	} else {
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3611 "rygel-http-get-test.c"
	}
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 328 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3617 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_ = NULL;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3633 "rygel-http-get-test.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPClient*) base;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 3653 "rygel-http-get-test.c"
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3670 "rygel-http-get-test.c"
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_client_real_run_finish;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
#line 3685 "rygel-http-get-test.c"
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
#line 3692 "rygel-http-get-test.c"
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 319 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->context);
#line 320 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->msg);
#line 322 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
#line 3708 "rygel-http-get-test.c"
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3737 "rygel-http-get-test.c"
		default:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3743 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3759 "rygel-http-get-test.c"
		default:
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 318 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 3765 "rygel-http-get-test.c"
	}
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_data_->item_id);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->result);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_media_object_unref0 (_data_->self);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelMediaContainerFindObjectData, _data_);
#line 3783 "rygel-http-get-test.c"
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self ? rygel_media_object_ref (self) : NULL;
#line 3790 "rygel-http-get-test.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	RygelMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_media_container_find_object);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _rygel_media_object_ref0 (self);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = item_id;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (_data_->item_id);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->item_id = _tmp2_;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = cancellable;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->cancellable = _tmp4_;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_find_object_co (_data_);
#line 3829 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return NULL;
#line 3840 "rygel-http-get-test.c"
	}
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _data_->result;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->result = NULL;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3850 "rygel-http-get-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data2_;
#line 3859 "rygel-http-get-test.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 3868 "rygel-http-get-test.c"
		RygelMediaContainer * self;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data2_->self;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue = NULL;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target = NULL;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data2_->find_object_continue_target_destroy_notify = NULL;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_rygel_media_object_unref0 (self);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 3884 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
#line 346 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3894 "rygel-http-get-test.c"
}


static gboolean __lambda2_ (Block2Data* _data2_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data2_->self;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _data2_->find_object_continue;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0__target = _data2_->find_object_continue_target;
#line 348 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ (_tmp0__target);
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 350 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3915 "rygel-http-get-test.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 347 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 3924 "rygel-http-get-test.c"
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_) {
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 3933 "rygel-http-get-test.c"
		goto _state_0;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 3937 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 3942 "rygel-http-get-test.c"
	}
	_state_0:
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->self = rygel_media_object_ref (_data_->self);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target = _data_;
#line 346 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_->find_object_continue_target_destroy_notify = NULL;
#line 347 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 353 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 3965 "rygel-http-get-test.c"
	_state_1:
	;
#line 355 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = NULL;
#line 355 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->item_id;
#line 355 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_debug ("rygel-http-get-test.vala:355: item id: %s", _data_->_tmp0_);
#line 356 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = NULL;
#line 356 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = _data_->item_id;
#line 356 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_data_->_tmp1_, "VideoItem") == 0) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = NULL;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp2_ = rygel_video_item_new ();
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp2_;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		block2_data_unref (_data_->_data2_);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_data2_ = NULL;
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (_data_->_state_ == 0) {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3994 "rygel-http-get-test.c"
		} else {
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3998 "rygel-http-get-test.c"
		}
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_object_unref (_data_->_async_result);
#line 357 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return FALSE;
#line 4004 "rygel-http-get-test.c"
	} else {
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = NULL;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data_->_tmp3_ = _data_->item_id;
#line 358 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (g_strcmp0 (_data_->_tmp3_, "AudioItem") == 0) {
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp4_ = NULL;
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_tmp4_ = rygel_audio_item_new ();
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->result = (RygelMediaObject*) _data_->_tmp4_;
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			block2_data_unref (_data_->_data2_);
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_data2_ = NULL;
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (_data_->_state_ == 0) {
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4026 "rygel-http-get-test.c"
			} else {
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4030 "rygel-http-get-test.c"
			}
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_object_unref (_data_->_async_result);
#line 359 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return FALSE;
#line 4036 "rygel-http-get-test.c"
		} else {
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->result = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			block2_data_unref (_data_->_data2_);
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			_data_->_data2_ = NULL;
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			if (_data_->_state_ == 0) {
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4048 "rygel-http-get-test.c"
			} else {
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4052 "rygel-http-get-test.c"
			}
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			g_object_unref (_data_->_async_result);
#line 361 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return FALSE;
#line 4058 "rygel-http-get-test.c"
		}
	}
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block2_data_unref (_data_->_data2_);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data2_ = NULL;
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4069 "rygel-http-get-test.c"
	} else {
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4073 "rygel-http-get-test.c"
	}
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 343 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 4079 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer* self = NULL;
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4089 "rygel-http-get-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 4096 "rygel-http-get-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 341 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 4103 "rygel-http-get-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPResponse* _tmp1_ = NULL;
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 367 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = rygel_http_response_new (_tmp0_);
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp1_;
#line 368 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4139 "rygel-http-get-test.c"
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
#line 371 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 371 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (get_request != NULL);
#line 4148 "rygel-http-get-test.c"
}


gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request) {
	gboolean result = FALSE;
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 373 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4162 "rygel-http-get-test.c"
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler* self = NULL;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPGetHandler*) g_type_create_instance (object_type);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4172 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_init (GValue* value) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 4179 "rygel-http-get-test.c"
}


static void rygel_value_http_get_handler_free_value (GValue* value) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (value->data[0].v_pointer);
#line 4188 "rygel-http-get-test.c"
	}
}


static void rygel_value_http_get_handler_copy_value (const GValue* src_value, GValue* dest_value) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_http_get_handler_ref (src_value->data[0].v_pointer);
#line 4198 "rygel-http-get-test.c"
	} else {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4202 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_http_get_handler_peek_pointer (const GValue* value) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4210 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 4217 "rygel-http-get-test.c"
		RygelHTTPGetHandler* object;
		object = collect_values[0].v_pointer;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4224 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4228 "rygel-http-get-test.c"
		}
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_http_get_handler_ref (object);
#line 4232 "rygel-http-get-test.c"
	} else {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4236 "rygel-http-get-test.c"
	}
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4240 "rygel-http-get-test.c"
}


static gchar* rygel_value_http_get_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelHTTPGetHandler** object_p;
	object_p = collect_values[0].v_pointer;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4251 "rygel-http-get-test.c"
	}
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 4257 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 4261 "rygel-http-get-test.c"
	} else {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 4265 "rygel-http-get-test.c"
	}
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 4269 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecHTTPGetHandler* spec;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 4283 "rygel-http-get-test.c"
}


gpointer rygel_value_get_http_get_handler (const GValue* value) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 4292 "rygel-http-get-test.c"
}


void rygel_value_set_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_ref (value->data[0].v_pointer);
#line 4312 "rygel-http-get-test.c"
	} else {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4316 "rygel-http-get-test.c"
	}
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 4322 "rygel-http-get-test.c"
	}
}


void rygel_value_take_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 4341 "rygel-http-get-test.c"
	} else {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 4345 "rygel-http-get-test.c"
	}
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_http_get_handler_unref (old);
#line 4351 "rygel-http-get-test.c"
	}
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
#line 4361 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 4368 "rygel-http-get-test.c"
}


static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj) {
	RygelHTTPGetHandler * self;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
#line 4376 "rygel-http-get-test.c"
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_http_get_handler_init, rygel_value_http_get_handler_free_value, rygel_value_http_get_handler_copy_value, rygel_value_http_get_handler_peek_pointer, "p", rygel_value_http_get_handler_collect_value, "p", rygel_value_http_get_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelHTTPGetHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


gpointer rygel_http_get_handler_ref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 4401 "rygel-http-get-test.c"
}


void rygel_http_get_handler_unref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->finalize (self);
#line 366 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4414 "rygel-http-get-test.c"
	}
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable) {
	RygelHTTPTranscodeHandler* self = NULL;
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (transcoder != NULL, NULL);
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPTranscodeHandler*) rygel_http_get_handler_construct (object_type);
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4429 "rygel-http-get-test.c"
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable) {
#line 377 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, transcoder, cancellable);
#line 4436 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
#line 376 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
#line 4443 "rygel-http-get-test.c"
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPIdentityHandler* self = NULL;
#line 382 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 382 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
#line 382 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4471 "rygel-http-get-test.c"
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
#line 382 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
#line 4478 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
#line 381 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
#line 4485 "rygel-http-get-test.c"
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* arg, GCancellable* cancellable) {
	RygelHTTPPlaylistHandler* self = NULL;
#line 386 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 386 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPPlaylistHandler*) rygel_http_get_handler_construct (object_type);
#line 386 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4513 "rygel-http-get-test.c"
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* arg, GCancellable* cancellable) {
#line 386 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_playlist_handler_construct (RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, arg, cancellable);
#line 4520 "rygel-http-get-test.c"
}


gboolean rygel_http_playlist_handler_is_supported (const gchar* arg) {
	gboolean result = FALSE;
#line 388 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = TRUE;
#line 388 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4530 "rygel-http-get-test.c"
}


static void rygel_http_playlist_handler_class_init (RygelHTTPPlaylistHandlerClass * klass) {
#line 385 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_playlist_handler_parent_class = g_type_class_peek_parent (klass);
#line 4537 "rygel-http-get-test.c"
}


static void rygel_http_playlist_handler_instance_init (RygelHTTPPlaylistHandler * self) {
}


GType rygel_http_playlist_handler_get_type (void) {
	static volatile gsize rygel_http_playlist_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_playlist_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPlaylistHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_playlist_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPlaylistHandler), 0, (GInstanceInitFunc) rygel_http_playlist_handler_instance_init, NULL };
		GType rygel_http_playlist_handler_type_id;
		rygel_http_playlist_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPPlaylistHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_playlist_handler_type_id__volatile, rygel_http_playlist_handler_type_id);
	}
	return rygel_http_playlist_handler_type_id__volatile;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
#line 397 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 398 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = ((RygelMediaObject*) self)->id;
#line 398 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_strcmp0 (_tmp0_, "VideoItem") == 0) {
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = FALSE;
#line 399 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 4570 "rygel-http-get-test.c"
	} else {
#line 401 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		result = TRUE;
#line 401 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return result;
#line 4576 "rygel-http-get-test.c"
	}
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	gboolean result = FALSE;
#line 404 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = TRUE;
#line 405 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4589 "rygel-http-get-test.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4599 "rygel-http-get-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 4608 "rygel-http-get-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 392 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 393 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->uris = _tmp0_;
#line 395 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->place_holder = FALSE;
#line 4622 "rygel-http-get-test.c"
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 393 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->uris);
#line 391 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 4634 "rygel-http-get-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem* self = NULL;
	gchar* _tmp0_ = NULL;
#line 412 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
#line 413 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("AudioItem");
#line 413 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 413 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) self)->id = _tmp0_;
#line 412 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4663 "rygel-http-get-test.c"
}


RygelAudioItem* rygel_audio_item_new (void) {
#line 412 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
#line 4670 "rygel-http-get-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 4679 "rygel-http-get-test.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
#line 410 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->duration = (gint64) 2048;
#line 4686 "rygel-http-get-test.c"
}


static void rygel_audio_item_finalize (RygelMediaObject* obj) {
	RygelAudioItem * self;
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
#line 409 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 4696 "rygel-http-get-test.c"
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self) {
	gboolean result = FALSE;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 425 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4718 "rygel-http-get-test.c"
}


gboolean rygel_visual_item_streamable (RygelVisualItem* self) {
	gboolean result = FALSE;
#line 429 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 429 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4728 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
#line 418 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 418 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
#line 4737 "rygel-http-get-test.c"
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
#line 418 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
#line 4746 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
#line 419 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 419 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
#line 4755 "rygel-http-get-test.c"
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
#line 419 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 419 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
#line 4764 "rygel-http-get-test.c"
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
#line 420 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 420 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
#line 4773 "rygel-http-get-test.c"
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
#line 420 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 420 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
#line 4782 "rygel-http-get-test.c"
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
#line 4791 "rygel-http-get-test.c"
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 422 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
#line 4800 "rygel-http-get-test.c"
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
#line 417 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	static gboolean initialized = FALSE;
#line 417 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!initialized) {
#line 417 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		initialized = TRUE;
#line 4811 "rygel-http-get-test.c"
	}
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem* self = NULL;
	gchar* _tmp0_ = NULL;
#line 440 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type);
#line 441 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("VideoItem");
#line 441 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 441 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	((RygelMediaObject*) self)->id = _tmp0_;
#line 440 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 4842 "rygel-http-get-test.c"
}


RygelVideoItem* rygel_video_item_new (void) {
#line 440 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
#line 4849 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_width;
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4865 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = _tmp0_;
#line 4878 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_height;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4894 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = _tmp0_;
#line 4907 "rygel-http-get-test.c"
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_color_depth;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4923 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = _tmp0_;
#line 4936 "rygel-http-get-test.c"
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	RygelThumbnail* _tmp2_ = NULL;
	RygelThumbnail* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 445 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 446 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL, NULL, NULL);
#line 446 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->ts);
#line 446 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->ts = _tmp0_;
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = self->priv->ts;
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = rygel_thumbnail_new ();
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = _tmp2_;
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
#line 447 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_thumbnail_unref0 (_tmp3_);
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = self->priv->ts;
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp4_;
#line 448 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 4972 "rygel-http-get-test.c"
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
#line 451 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelVideoItem*) base;
#line 4980 "rygel-http-get-test.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
#line 4991 "rygel-http-get-test.c"
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_width = rygel_video_item_real_get_width;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_width = rygel_video_item_real_set_width;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_height = rygel_video_item_real_get_height;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_height = rygel_video_item_real_set_height;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
#line 5014 "rygel-http-get-test.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
#line 434 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_width = -1;
#line 435 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_height = -1;
#line 436 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_color_depth = -1;
#line 454 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL, NULL, NULL);
#line 454 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->subtitles = _tmp0_;
#line 5032 "rygel-http-get-test.c"
}


static void rygel_video_item_finalize (RygelMediaObject* obj) {
	RygelVideoItem * self;
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
#line 438 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->ts);
#line 454 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->subtitles);
#line 433 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
#line 5046 "rygel-http-get-test.c"
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem* self = NULL;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5070 "rygel-http-get-test.c"
}


RygelMusicItem* rygel_music_item_new (void) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
#line 5077 "rygel-http-get-test.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 5086 "rygel-http-get-test.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (RygelMediaObject* obj) {
	RygelMusicItem * self;
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 458 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_rygel_thumbnail_unref0 (self->album_art);
#line 457 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 5102 "rygel-http-get-test.c"
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelThumbnail*) g_type_create_instance (object_type);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5124 "rygel-http-get-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 5131 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_init (GValue* value) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 5138 "rygel-http-get-test.c"
}


static void rygel_value_thumbnail_free_value (GValue* value) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (value->data[0].v_pointer);
#line 5147 "rygel-http-get-test.c"
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
#line 5157 "rygel-http-get-test.c"
	} else {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5161 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5169 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 5176 "rygel-http-get-test.c"
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5183 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5187 "rygel-http-get-test.c"
		}
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
#line 5191 "rygel-http-get-test.c"
	} else {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5195 "rygel-http-get-test.c"
	}
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5199 "rygel-http-get-test.c"
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5210 "rygel-http-get-test.c"
	}
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 5216 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 5220 "rygel-http-get-test.c"
	} else {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
#line 5224 "rygel-http-get-test.c"
	}
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5228 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 5242 "rygel-http-get-test.c"
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5251 "rygel-http-get-test.c"
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_ref (value->data[0].v_pointer);
#line 5271 "rygel-http-get-test.c"
	} else {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5275 "rygel-http-get-test.c"
	}
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 5281 "rygel-http-get-test.c"
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 5300 "rygel-http-get-test.c"
	} else {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5304 "rygel-http-get-test.c"
	}
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_thumbnail_unref (old);
#line 5310 "rygel-http-get-test.c"
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 5320 "rygel-http-get-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 462 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 5329 "rygel-http-get-test.c"
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
#line 463 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->file_extension);
#line 5339 "rygel-http-get-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 5364 "rygel-http-get-test.c"
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
#line 461 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5377 "rygel-http-get-test.c"
	}
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle* self = NULL;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelSubtitle*) g_type_create_instance (object_type);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5388 "rygel-http-get-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 5395 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_init (GValue* value) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 5402 "rygel-http-get-test.c"
}


static void rygel_value_subtitle_free_value (GValue* value) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (value->data[0].v_pointer);
#line 5411 "rygel-http-get-test.c"
	}
}


static void rygel_value_subtitle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
#line 5421 "rygel-http-get-test.c"
	} else {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5425 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_subtitle_peek_pointer (const GValue* value) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5433 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 5440 "rygel-http-get-test.c"
		RygelSubtitle* object;
		object = collect_values[0].v_pointer;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5447 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5451 "rygel-http-get-test.c"
		}
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_subtitle_ref (object);
#line 5455 "rygel-http-get-test.c"
	} else {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5459 "rygel-http-get-test.c"
	}
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5463 "rygel-http-get-test.c"
}


static gchar* rygel_value_subtitle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelSubtitle** object_p;
	object_p = collect_values[0].v_pointer;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5474 "rygel-http-get-test.c"
	}
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 5480 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 5484 "rygel-http-get-test.c"
	} else {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
#line 5488 "rygel-http-get-test.c"
	}
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 5492 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecSubtitle* spec;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 5506 "rygel-http-get-test.c"
}


gpointer rygel_value_get_subtitle (const GValue* value) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 5515 "rygel-http-get-test.c"
}


void rygel_value_set_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_ref (value->data[0].v_pointer);
#line 5535 "rygel-http-get-test.c"
	} else {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5539 "rygel-http-get-test.c"
	}
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 5545 "rygel-http-get-test.c"
	}
}


void rygel_value_take_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 5564 "rygel-http-get-test.c"
	} else {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 5568 "rygel-http-get-test.c"
	}
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_subtitle_unref (old);
#line 5574 "rygel-http-get-test.c"
	}
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_SUBTITLE_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 5584 "rygel-http-get-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
#line 467 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->size = (glong) 1024;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 5593 "rygel-http-get-test.c"
}


static void rygel_subtitle_finalize (RygelSubtitle* obj) {
	RygelSubtitle * self;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
#line 468 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->caption_type);
#line 5603 "rygel-http-get-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


gpointer rygel_subtitle_ref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 5628 "rygel-http-get-test.c"
}


void rygel_subtitle_unref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
#line 466 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5641 "rygel-http-get-test.c"
	}
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	SoupMessageHeaders* _tmp4_ = NULL;
	RygelHTTPGet* _tmp5_ = NULL;
	SoupServer* _tmp6_ = NULL;
	SoupServer* _tmp7_ = NULL;
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (get_request != NULL, NULL);
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
#line 478 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = get_request;
#line 478 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 478 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 478 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 478 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->msg = _tmp2_;
#line 479 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp3_ = self->priv->msg;
#line 479 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp4_ = _tmp3_->response_headers;
#line 479 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_headers_set_encoding (_tmp4_, SOUP_ENCODING_CONTENT_LENGTH);
#line 480 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp5_ = get_request;
#line 480 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->server;
#line 480 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 480 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 480 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->server = _tmp7_;
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 5688 "rygel-http-get-test.c"
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request) {
#line 477 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
#line 5695 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (_data_->self);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_slice_free (RygelHttpResponseRunData, _data_);
#line 5706 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_ = NULL;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->self = _tmp0_;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_real_run_co (_data_);
#line 5728 "rygel-http-get-test.c"
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 5736 "rygel-http-get-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return _data3_;
#line 5745 "rygel-http-get-test.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5754 "rygel-http-get-test.c"
		RygelHTTPResponse * self;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		self = _data3_->self;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : (_data3_->run_continue_target_destroy_notify (_data3_->run_continue_target), NULL);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue = NULL;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target = NULL;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_data3_->run_continue_target_destroy_notify = NULL;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		_g_object_unref0 (self);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 5770 "rygel-http-get-test.c"
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
#line 484 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5780 "rygel-http-get-test.c"
}


static gboolean __lambda3_ (Block3Data* _data3_) {
	RygelHTTPResponse * self;
	gboolean result = FALSE;
#line 486 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = _data3_->self;
#line 487 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data3_->run_continue (_data3_->run_continue_target);
#line 489 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = FALSE;
#line 489 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5795 "rygel-http-get-test.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 486 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5804 "rygel-http-get-test.c"
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (_data_->_state_) {
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 0:
#line 5813 "rygel-http-get-test.c"
		goto _state_0;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case 1:
#line 5817 "rygel-http-get-test.c"
		goto _state_1;
		default:
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_assert_not_reached ();
#line 5822 "rygel-http-get-test.c"
	}
	_state_0:
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = g_slice_new0 (Block3Data);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_ref_count_ = 1;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->self = g_object_ref (_data_->self);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->_async_data_ = _data_;
#line 484 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue = _rygel_http_response_real_run_co_gsource_func;
#line 484 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target = _data_;
#line 484 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_->run_continue_target_destroy_notify = NULL;
#line 486 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda3__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_state_ = 1;
#line 492 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 5845 "rygel-http-get-test.c"
	_state_1:
	;
#line 494 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = NULL;
#line 494 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp0_ = _data_->self->priv->msg;
#line 494 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_message_set_status (_data_->_tmp0_, (guint) SOUP_STATUS_OK);
#line 495 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = NULL;
#line 495 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp1_ = _data_->self->priv->server;
#line 495 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = NULL;
#line 495 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_tmp2_ = _data_->self->priv->msg;
#line 495 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	soup_server_unpause_message (_data_->_tmp1_, _data_->_tmp2_);
#line 497 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	block3_data_unref (_data_->_data3_);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_data_->_data3_ = NULL;
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (_data_->_state_ == 0) {
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 5874 "rygel-http-get-test.c"
	} else {
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 5878 "rygel-http-get-test.c"
	}
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_unref (_data_->_async_result);
#line 483 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return FALSE;
#line 5884 "rygel-http-get-test.c"
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_ = NULL;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_cancellable;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 5900 "rygel-http-get-test.c"
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelHTTPResponse*) base;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_cancellable = _tmp1_;
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 5920 "rygel-http-get-test.c"
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5937 "rygel-http-get-test.c"
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->run_finish = rygel_http_response_real_run_finish;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
#line 5952 "rygel-http-get-test.c"
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
#line 5959 "rygel-http-get-test.c"
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 472 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 474 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->msg);
#line 475 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_object_unref0 (self->priv->server);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
#line 5975 "rygel-http-get-test.c"
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6004 "rygel-http-get-test.c"
		default:
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6010 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6026 "rygel-http-get-test.c"
		default:
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 471 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6032 "rygel-http-get-test.c"
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject* self = NULL;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelMediaObject*) g_type_create_instance (object_type);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 6043 "rygel-http-get-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 6050 "rygel-http-get-test.c"
}


static void rygel_value_media_object_init (GValue* value) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	value->data[0].v_pointer = NULL;
#line 6057 "rygel-http-get-test.c"
}


static void rygel_value_media_object_free_value (GValue* value) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (value->data[0].v_pointer) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (value->data[0].v_pointer);
#line 6066 "rygel-http-get-test.c"
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (src_value->data[0].v_pointer) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
#line 6076 "rygel-http-get-test.c"
	} else {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6080 "rygel-http-get-test.c"
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 6088 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (collect_values[0].v_pointer) {
#line 6095 "rygel-http-get-test.c"
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		if (object->parent_instance.g_class == NULL) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6102 "rygel-http-get-test.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6106 "rygel-http-get-test.c"
		}
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = rygel_media_object_ref (object);
#line 6110 "rygel-http-get-test.c"
	} else {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6114 "rygel-http-get-test.c"
	}
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 6118 "rygel-http-get-test.c"
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!object_p) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6129 "rygel-http-get-test.c"
	}
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (!value->data[0].v_pointer) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = NULL;
#line 6135 "rygel-http-get-test.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = value->data[0].v_pointer;
#line 6139 "rygel-http-get-test.c"
	} else {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
#line 6143 "rygel-http-get-test.c"
	}
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return NULL;
#line 6147 "rygel-http-get-test.c"
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return G_PARAM_SPEC (spec);
#line 6161 "rygel-http-get-test.c"
}


gpointer rygel_value_get_media_object (const GValue* value) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return value->data[0].v_pointer;
#line 6170 "rygel-http-get-test.c"
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_ref (value->data[0].v_pointer);
#line 6190 "rygel-http-get-test.c"
	} else {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6194 "rygel-http-get-test.c"
	}
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 6200 "rygel-http-get-test.c"
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	old = value->data[0].v_pointer;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (v_object) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = v_object;
#line 6219 "rygel-http-get-test.c"
	} else {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		value->data[0].v_pointer = NULL;
#line 6223 "rygel-http-get-test.c"
	}
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (old) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_media_object_unref (old);
#line 6229 "rygel-http-get-test.c"
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 6239 "rygel-http-get-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	gchar* _tmp0_ = NULL;
#line 503 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = g_strdup ("");
#line 503 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->mime_type = _tmp0_;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->ref_count = 1;
#line 6251 "rygel-http-get-test.c"
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 502 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->id);
#line 503 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->mime_type);
#line 6263 "rygel-http-get-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_atomic_int_inc (&self->ref_count);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return instance;
#line 6288 "rygel-http-get-test.c"
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
#line 501 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6301 "rygel-http-get-test.c"
	}
}


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 509 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 509 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
#line 510 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = extension;
#line 510 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_transcoder_set_extension (self, _tmp0_);
#line 509 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return self;
#line 6319 "rygel-http-get-test.c"
}


RygelTranscoder* rygel_transcoder_new (const gchar* extension) {
#line 509 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER, extension);
#line 6326 "rygel-http-get-test.c"
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = self->priv->_extension;
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	result = _tmp0_;
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	return result;
#line 6341 "rygel-http-get-test.c"
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp0_ = value;
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->priv->_extension);
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv->_extension = _tmp1_;
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_notify ((GObject *) self, "extension");
#line 6360 "rygel-http-get-test.c"
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 6377 "rygel-http-get-test.c"
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
#line 6384 "rygel-http-get-test.c"
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 507 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	_g_free0 (self->priv->_extension);
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
#line 6396 "rygel-http-get-test.c"
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		g_value_set_string (value, rygel_transcoder_get_extension (self));
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6423 "rygel-http-get-test.c"
		default:
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6429 "rygel-http-get-test.c"
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
	switch (property_id) {
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		case RYGEL_TRANSCODER_EXTENSION:
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		rygel_transcoder_set_extension (self, g_value_get_string (value));
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6445 "rygel-http-get-test.c"
		default:
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 506 "/home/jens/Source/rygel/tests/rygel-http-get-test.vala"
		break;
#line 6451 "rygel-http-get-test.c"
	}
}



